% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/discrete.gamma.R
\name{discrete.gamma}
\alias{discrete.gamma}
\alias{plot_gamma_plus_inv}
\title{Discrete Gamma function}
\usage{
discrete.gamma(alpha, k)

plot_gamma_plus_inv(shape = 1, inv = 0, k = 4, discrete = TRUE,
  cdf = TRUE, append = FALSE, xlab = "x", ylab = ifelse(cdf,
  "F(x)", "f(x)"), xlim = NULL, verticals = FALSE, ...)
}
\arguments{
\item{alpha}{Shape parameter of the gamma distribution.}

\item{k}{Number of intervals of the discrete gamma distribution.}

\item{shape}{Shape parameter of the gamma distribution.}

\item{inv}{Proportion of invariable sites.}

\item{discrete}{logical wether to plot discrete (default) or continous pdf or
cdf.}

\item{cdf}{logical wether to plot the cummulative distribution function
or density / probability function.}

\item{append}{logical; if TRUE only add to an existing plot.}

\item{xlab}{a label for the x axis, defaults to a description of x.}

\item{ylab}{a label for the y axis, defaults to a description of y.}

\item{xlim}{the x limits of the plot.}

\item{verticals}{ogical; if TRUE, draw vertical lines at steps.}

\item{\dots}{Further arguments passed to or from other methods.}
}
\value{
\code{discrete.gamma} returns a matrix.
}
\description{
\code{discrete.gamma} internally used for the likelihood computations in
\code{pml} or \code{optim.pml}. It is useful to understand how it works
for simulation studies or in cases where .
}
\details{
These functions are exported to be used in different packages so far only in
the package coalescentMCMC, but are not intended for end user. Most of the
functions call C code and are far less forgiving if the import is not what
they expect than \code{pml}.
}
\examples{
discrete.gamma(1, 4)

par(mfrow = c(2,1))

plot_gamma_plus_inv(shape=2, discrete = FALSE, cdf=FALSE)
plot_gamma_plus_inv(shape=2, append = TRUE, cdf=FALSE)

plot_gamma_plus_inv(shape=2, discrete = FALSE)
plot_gamma_plus_inv(shape=2, append = TRUE)

par(mfrow = c(1,1))

}
\seealso{
\code{\link{pml.fit}, \link{stepfun}}
}
\author{
Klaus Schliep \email{klaus.schliep@gmail.com}
}
\keyword{cluster}
