% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/itis_facet.R
\name{itis_facet}
\alias{itis_facet}
\title{ITIS Solr facet}
\usage{
itis_facet(..., proxy = NULL, callopts = list())
}
\arguments{
\item{...}{Arguments passed on to the \code{params} parameter of
the \code{\link[solrium:solr_facet]{solrium::solr_facet()}} function}

\item{proxy}{List of arguments for a proxy connection,
including one or more of: url, port, username, password,
and auth. See \code{\link[crul:proxy]{crul::proxy()}} for  help, which is used to
construct the proxy connection.}

\item{callopts}{Curl options passed on to \link[crul:HttpClient]{crul::HttpClient}}
}
\description{
ITIS Solr facet
}
\examples{
\dontrun{
itis_facet(q = "rank:Species", rows = 0, facet.field = "kingdom")$facet_fields

x <- itis_facet(q = "hierarchySoFar:*$Aves$* AND rank:Species AND usage:valid",
   facet.pivot = "nameWInd,vernacular", facet.limit = -1, facet.mincount = 1,
   rows = 0)
head(x$facet_pivot$`nameWInd,vernacular`)
}
}
