% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/package-info.R
\name{package_info}
\alias{package_info}
\title{Information about the currently loaded packages, or about a chosen set}
\usage{
package_info(
  pkgs = c("loaded", "attached", "installed")[1],
  include_base = FALSE,
  dependencies = NA
)
}
\arguments{
\item{pkgs}{Which packages to show. It may be:
\itemize{
\item \code{NULL} or \code{"loaded"}: show all loaded packages,
\item \code{"attached"}: show all attached packages,
\item \code{"installed"}: show all installed packages,
\item a character vector of package names. Their (hard) dependencies are
also shown by default, see the \code{dependencies} argument.
}}

\item{include_base}{Include base packages in summary? By default this is
false since base packages should always match the R version.}

\item{dependencies}{Whether to include the (recursive) dependencies
as well. See the \code{dependencies} argument of \code{\link[utils:install.packages]{utils::install.packages()}}.}
}
\value{
A data frame with columns:
\itemize{
\item \code{package}: package name.
\item \code{ondiskversion}: package version (on the disk, which is sometimes
not the same as the loaded version).
\item \code{loadedversion}: package version. This is the version of the loaded
namespace if \code{pkgs} is \code{NULL}, and it is the version of the package
on disk otherwise. The two of them are almost always the same,
though.
\item \code{path}: path to the package on disk.
\item \code{loadedpath}: the path the package was originally loaded from.
\item \code{attached}: logical, whether the package is attached to the search
path.
\item \code{is_base}: logical, whether the package is a base package.
\item \code{date}: the date the package was installed or built, in UTC.
\item \code{source}: where the package was installed from. E.g.
\code{CRAN}, \code{GitHub}, \code{local} (from the local machine), etc.
\item \code{md5ok}: Whether MD5 hashes for package DLL files match, on Windows.
\code{NA} on other platforms.
\item \code{library}: factor, which package library the package was loaded from.
For loaded packages, this is (the factor representation of)
\code{loadedpath}, for others \code{path}.
}

See \code{\link[=session_info]{session_info()}} for the description of the \emph{printed} columns
by \code{package_info} (as opposed to the \emph{returned} columns).
}
\description{
Information about the currently loaded packages, or about a chosen set
}
\examples{
\dontshow{if (FALSE) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
package_info()
package_info("sessioninfo")
\dontshow{\}) # examplesIf}
}
