% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/join.R
\name{st_join}
\alias{st_join}
\alias{st_join.sftime}
\alias{st_filter.sftime}
\title{Spatial join, spatial filter for \code{sftime} objects}
\usage{
\method{st_join}{sftime}(
  x,
  y,
  join = st_intersects,
  ...,
  suffix = c(".x", ".y"),
  left = TRUE,
  largest = FALSE
)

\method{st_filter}{sftime}(x, y, ..., .predicate = st_intersects)
}
\arguments{
\item{x}{An object of class \code{sftime} or \code{sf}.}

\item{y}{An object of class \code{sftime} or \code{sf}.}

\item{join}{A geometry predicate function with the same profile as 
\code{\link[sf:geos_binary_pred]{st_intersects}}; see details.}

\item{...}{for \code{st_join}: arguments passed on to the \code{join} function or to \code{st_intersection} when \code{largest} is \code{TRUE}; for \code{st_filter} arguments passed on to the \code{.predicate} function, e.g. \code{prepared}, or a pattern for \link[sf]{st_relate}}

\item{suffix}{length 2 character vector; see \link[base]{merge}}

\item{left}{logical; if \code{TRUE} return the left join, otherwise an inner join; see details.
see also \link[dplyr:mutate-joins]{left_join}}

\item{largest}{logical; if \code{TRUE}, return \code{x} features augmented with the fields of \code{y} that have the largest overlap with each of the features of \code{x}; see https://github.com/r-spatial/sf/issues/578}

\item{.predicate}{A geometry predicate function with the same profile as 
\code{\link[sf:geos_binary_pred]{st_intersects}}; see details.}
}
\value{
An object of class \code{sftime}, joined based on geometry.
}
\description{
Spatial join, spatial filter for \code{sftime} objects
}
\details{
Alternative values for argument \code{join} are:
\itemize{
  \item \link[sf:geos_binary_pred]{st_contains_properly}
  \item \link[sf:geos_binary_pred]{st_contains}
  \item \link[sf:geos_binary_pred]{st_covered_by}
  \item \link[sf:geos_binary_pred]{st_covers}
  \item \link[sf:geos_binary_pred]{st_crosses}
  \item \link[sf:geos_binary_pred]{st_disjoint}
  \item \link[sf:geos_binary_pred]{st_equals_exact}
  \item \link[sf:geos_binary_pred]{st_equals}
  \item \link[sf:geos_binary_pred]{st_is_within_distance}
  \item \link[sf:geos_binary_pred]{st_nearest_feature}
  \item \link[sf:geos_binary_pred]{st_overlaps}
  \item \link[sf:geos_binary_pred]{st_touches}
  \item \link[sf:geos_binary_pred]{st_within}
  \item any user-defined function of the same profile as the above
}
A left join returns all records of the \code{x} object with \code{y} fields 
for non-matched records filled with \code{NA} values; an inner join returns 
only records that spatially match.
}
\examples{
g1 <- st_sfc(st_point(c(1,1)), st_point(c(2,2)), st_point(c(3,3)))
x1 <- st_sftime(a = 1:3, geometry = g1, time = Sys.time())

g2 <- st_sfc(st_point(c(10,10)), st_point(c(2,2)), st_point(c(2,2)), st_point(c(3,3)))
x2 <- st_sftime(a = 11:14, geometry = g2, time = Sys.time())

## st_join

# left spatial join with st_intersects
st_join(x1, x2)

# inner spatial join with st_intersects
st_join(x1, x2, left = FALSE)

## st_filter

st_filter(x1, x2)
st_filter(x2, x1)

}
