% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/core_reload.R
\name{core_reload}
\alias{core_reload}
\title{Reload a core}
\usage{
core_reload(conn, name, raw = FALSE, callopts = list())
}
\arguments{
\item{conn}{A solrium connection object, see \link{SolrClient}}

\item{name}{(character) The name of the core to be created. Required}

\item{raw}{(logical) If \code{TRUE}, returns raw data}

\item{callopts}{curl options passed on to \link[crul:HttpClient]{crul::HttpClient}}
}
\description{
Reload a core
}
\examples{
\dontrun{
# start Solr with Schemaless mode via the schemaless eg:
#  bin/solr start -e schemaless
# you can create a new core like: bin/solr create -c corename
# where <corename> is the name for your core - or creaate as below

# connect
(conn <- SolrClient$new())

# Status of particular cores
conn$core_reload("gettingstarted")
conn$core_status("gettingstarted")
}
}
