// Code generated by ./internal/gen/main.go. DO NOT EDIT.

//go:generate go run ./internal/gen/main.go

package encoder

var testCasesSingle = []testCase{
	{ // 0
		mask: EncodeZero,
		in:   "；2π\x15ｊ８␆aｗ␑k`\x04β\x00σ`τ７＜;R\x05␀τ？β7７␌",
		out:  "；2π\x15ｊ８␆aｗ␑k`\x04β␀σ`τ７＜;R\x05‛␀τ？β7７␌",
	}, { // 1
		mask: EncodeSlash,
		in:   "：＜VＪｇ｜Ｋ;/+\x10／φ␄/π\f:ρRα\x1fζ␃＜VLν＜ｑ",
		out:  "：＜VＪｇ｜Ｋ;／+\x10‛／φ␄／π\f:ρRα\x1fζ␃＜VLν＜ｑ",
	}, { // 2
		mask: EncodeSingleQuote,
		in:   "γ␗＇Ｐｎ\aχ%ε＼[υ\x1d␅］ζM2ω＇␆$\x12ＡＮ｜^'\r\x10",
		out:  "γ␗‛＇Ｐｎ\aχ%ε＼[υ\x1d␅］ζM2ω‛＇␆$\x12ＡＮ｜^＇\r\x10",
	}, { // 3
		mask: EncodeBackQuote,
		in:   "#␜θWfｃＲ␟(␍｀\x18Ｖ６τη\x10／*mυ\x15␂\x13␚βw｛`ρ",
		out:  "#␜θWfｃＲ␟(␍‛｀\x18Ｖ６τη\x10／*mυ\x15␂\x13␚βw｛｀ρ",
	}, { // 4
		mask: EncodeLtGt,
		in:   "４␕>ｏ*\aＰι,␚Pυ\v＜\x0f␙！９tπ＞<␐\x1e(ης␀oε",
		out:  "４␕＞ｏ*\aＰι,␚Pυ\v‛＜\x0f␙！９tπ‛＞＜␐\x1e(ης‛␀oε",
	}, { // 5
		mask: EncodeSquareBracket,
		in:   "／␘\vενm%ρ[M+τ:\x05`νw＾］␗␘ｑ．ψＩ0Ｘ␁［]",
		out:  "／␘\vενm%ρ［M+τ:\x05`νw＾‛］␗␘ｑ．ψＩ0Ｘ␁‛［］",
	}, { // 6
		mask: EncodeSemicolon,
		in:   "Rφ\x05'\x01/ςY／ψ＞ｌ%；ｙｓｏ:;;ς｜ξ␓＊\x06\r［ι／",
		out:  "Rφ\x05'\x01/ςY／ψ＞ｌ%‛；ｙｓｏ:；；ς｜ξ␓＊\x06\r［ι／",
	}, { // 7
		mask: EncodeDollar,
		in:   "%$;Ｘτ\x01］^εE＄π\x01＆＃␖␔＆ψ␆ι～／\x03~]\x04θ？R",
		out:  "%＄;Ｘτ\x01］^εE‛＄π\x01＆＃␖␔＆ψ␆ι～／\x03~]\x04θ？R",
	}, { // 8
		mask: EncodeDoubleQuote,
		in:   "ωQ＝λ：γ＂＂␈ε／#Ｒ\"!\\␇*:Ｙ\t８\x1b?π␎ν\x17␋=",
		out:  "ωQ＝λ：γ‛＂‛＂␈ε／#Ｒ＂!\\␇*:Ｙ\t８\x1b?π␎ν\x17␋=",
	}, { // 9
		mask: EncodeColon,
		in:   "χ］ρ%\x12Ｅ\r\x17Ｃ␉\"３sος␈７␋νk!π：＇o␘:MＷ\x02",
		out:  "χ］ρ%\x12Ｅ\r\x17Ｃ␉\"３sος␈７␋νk!π‛：＇o␘：MＷ\x02",
	}, { // 10
		mask: EncodeQuestion,
		in:   "\x17\x02\x11～?␕\x12Ｑ＋δω％R␃？OζＩs␈\x0f／`?＜μτC：φ",
		out:  "\x17\x02\x11～？␕\x12Ｑ＋δω％R␃‛？OζＩs␈\x0f／`？＜μτC：φ",
	}, { // 11
		mask: EncodeAsterisk,
		in:   "Q＂Ｊａｌ＊Vz/␞␐\n$*␗χκ\u007f[␚ι\x1b＜／ν%#βλＵ",
		out:  "Q＂Ｊａｌ‛＊Vz/␞␐\n$＊␗χκ\u007f[␚ι\x1b＜／ν%#βλＵ",
	}, { // 12
		mask: EncodePipe,
		in:   "W=\rｘξβ␈\x15mａε␇|／\x04｜␐］f\x0e[＼Yｈｚτ\x03δτｋ",
		out:  "W=\rｘξβ␈\x15mａε␇｜／\x04‛｜␐］f\x0e[＼Yｈｚτ\x03δτｋ",
	}, { // 13
		mask: EncodeHash,
		in:   ">\x05＃␙Ｘ*␉ｋp＊λ\x1a:`θｔg\x10＃ｋρ;#υο＂Oξ＃␅",
		out:  ">\x05‛＃␙Ｘ*␉ｋp＊λ\x1a:`θｔg\x10‛＃ｋρ;＃υο＂Oξ‛＃␅",
	}, { // 14
		mask: EncodePercent,
		in:   "\x05␋␙␚μ$φ%\x1c␂ｉδ\n\r␊ο␇χ|xI）\x05yＧ％！ςt９",
		out:  "\x05␋␙␚μ$φ％\x1c␂ｉδ\n\r␊ο␇χ|xI）\x05yＧ‛％！ςt９",
	}, { // 15
		mask: EncodeBackSlash,
		in:   "DδＭ＊ξ␄\x14ρ＂ζ␝␕Ｔ\x17｀φ!\x14Ｏ\x19'd\\/γＷＪ\b＼:",
		out:  "DδＭ＊ξ␄\x14ρ＂ζ␝␕Ｔ\x17｀φ!\x14Ｏ\x19'd＼/γＷＪ\b‛＼:",
	}, { // 16
		mask: EncodeCrLf,
		in:   "θ？＞␏μ7π*＼\n2␍x\rο:ｚ\\ο\x19␋ｗ␊／ξa>OＸ␇",
		out:  "θ？＞␏μ7π*＼␊2‛␍x␍ο:ｚ\\ο\x19␋ｗ‛␊／ξa>OＸ␇",
	}, { // 17
		mask: EncodeDel,
		in:   "Fｇ！％＞π\x1d\rY␡μ*＊0｜ν\x1eVχI３`␘\x1d␓？δ\u007f␉ω",
		out:  "Fｇ！％＞π\x1d\rY‛␡μ*＊0｜ν\x1eVχI３`␘\x1d␓？δ␡␉ω",
	}, { // 18
		mask: EncodeCtl,
		in:   "␖d\x14\v␟\x00␇\x03␜␈␊\f␑\x1c␂␕␘␓␃＊\x1d／\n*␔\"\a␉\x05␞␁\x0e\x19\u007f␙v\x1eP␆␋\x17ｎ\x12\x04␛\r\x1b␚\x1a\x17␛\x18\x1f\x0fδ\x13␍␚\x10\a␕:\x11\x16ς␏␅λ\bπ\x06：␒δ>\x02ｏ␖␌＆６␎Ｖ\x15␄␝\x1e␐␗\x01\tοZ",
		out:  "‛␖d␔␋‛␟␀‛␇␃‛␜‛␈‛␊␌‛␑␜‛␂‛␕‛␘‛␓‛␃＊␝／␊*‛␔\"␇‛␉␅‛␞‛␁␎␙\u007f‛␙v␞P‛␆‛␋␗ｎ␒␄‛␛␍␛‛␚␚␗‛␛␘␟␏δ␓‛␍‛␚␐␇‛␕:␑␖ς‛␏‛␅λ␈π␆：‛␒δ>␂ｏ‛␖‛␌＆６‛␎Ｖ␕‛␄‛␝␞‛␐‛␗␁␉οZ",
	},
}

var testCasesSingleEdge = []testCase{
	{ // 0
		mask: EncodeLeftSpace,
		in:   " ",
		out:  "␠",
	}, { // 1
		mask: EncodeZero | EncodeLeftSpace,
		in:   "␟π，；θSc\x16｝＃ ａ｀\x06３\x1b\x10j\x06<␂：φζA５*␆ιv",
		out:  "␟π，；θSc\x16｝＃ ａ｀\x06３\x1b\x10j\x06<␂：φζA５*␆ιv",
	}, { // 2
		mask: EncodeZero | EncodeLeftSpace,
		in:   " ␠，；θSc\x16｝＃ ａ｀\x06３\x1b\x10j\x06<␂：φζA５*␆ιv",
		out:  "␠␠，；θSc\x16｝＃ ａ｀\x06３\x1b\x10j\x06<␂：φζA５*␆ιv",
	}, { // 3
		mask: EncodeZero | EncodeLeftSpace,
		in:   "␠␠，；θSc\x16｝＃ ａ｀\x06３\x1b\x10j\x06<␂：φζA５*␆ιv",
		out:  "‛␠␠，；θSc\x16｝＃ ａ｀\x06３\x1b\x10j\x06<␂：φζA５*␆ιv",
	}, { // 4
		mask: EncodeZero | EncodeLeftSpace,
		in:   " π，；θSc\x16｝＃ ａ｀\x06３\x1b\x10j\x06<␂：φζA５*␆␠v",
		out:  "␠π，；θSc\x16｝＃ ａ｀\x06３\x1b\x10j\x06<␂：φζA５*␆␠v",
	}, { // 5
		mask: EncodeZero | EncodeLeftSpace,
		in:   "␠π，；θSc\x16｝＃ ａ｀\x06３\x1b\x10j\x06<␂：φζA５*␆␠v",
		out:  "‛␠π，；θSc\x16｝＃ ａ｀\x06３\x1b\x10j\x06<␂：φζA５*␆␠v",
	}, { // 6
		mask: EncodeZero | EncodeLeftSpace,
		in:   " π，；θSc\x16｝＃ ａ｀\x06３\x1b\x10j\x06<␂：φζA５*␆ι␠",
		out:  "␠π，；θSc\x16｝＃ ａ｀\x06３\x1b\x10j\x06<␂：φζA５*␆ι␠",
	}, { // 7
		mask: EncodeZero | EncodeLeftSpace,
		in:   "␠π，；θSc\x16｝＃ ａ｀\x06３\x1b\x10j\x06<␂：φζA５*␆ι␠",
		out:  "‛␠π，；θSc\x16｝＃ ａ｀\x06３\x1b\x10j\x06<␂：φζA５*␆ι␠",
	}, { // 8
		mask: EncodeZero | EncodeLeftSpace,
		in:   "␟ ，；θSc\x16｝＃ ａ｀\x06３\x1b\x10j\x06<␂：φζA５*␆ιv",
		out:  "␟ ，；θSc\x16｝＃ ａ｀\x06３\x1b\x10j\x06<␂：φζA５*␆ιv",
	}, { // 9
		mask: EncodeZero | EncodeLeftSpace,
		in:   "␟␠，；θSc\x16｝＃ ａ｀\x06３\x1b\x10j\x06<␂：φζA５*␆ιv",
		out:  "␟␠，；θSc\x16｝＃ ａ｀\x06３\x1b\x10j\x06<␂：φζA５*␆ιv",
	}, { // 10
		mask: EncodeZero | EncodeLeftSpace,
		in:   "␟ ，；θSc\x16｝＃ ａ｀\x06３\x1b\x10j\x06<␂：φζA５*␆␠v",
		out:  "␟ ，；θSc\x16｝＃ ａ｀\x06３\x1b\x10j\x06<␂：φζA５*␆␠v",
	}, { // 11
		mask: EncodeZero | EncodeLeftSpace,
		in:   "␟␠，；θSc\x16｝＃ ａ｀\x06３\x1b\x10j\x06<␂：φζA５*␆␠v",
		out:  "␟␠，；θSc\x16｝＃ ａ｀\x06３\x1b\x10j\x06<␂：φζA５*␆␠v",
	}, { // 12
		mask: EncodeZero | EncodeLeftSpace,
		in:   "␟ ，；θSc\x16｝＃ ａ｀\x06３\x1b\x10j\x06<␂：φζA５*␆ι␠",
		out:  "␟ ，；θSc\x16｝＃ ａ｀\x06３\x1b\x10j\x06<␂：φζA５*␆ι␠",
	}, { // 13
		mask: EncodeZero | EncodeLeftSpace,
		in:   "␟␠，；θSc\x16｝＃ ａ｀\x06３\x1b\x10j\x06<␂：φζA５*␆ι␠",
		out:  "␟␠，；θSc\x16｝＃ ａ｀\x06３\x1b\x10j\x06<␂：φζA５*␆ι␠",
	}, { // 14
		mask: EncodeZero | EncodeLeftSpace,
		in:   "␟π，；θSc\x16｝＃ ａ｀\x06３\x1b\x10j\x06<␂：φζA５*␆ v",
		out:  "␟π，；θSc\x16｝＃ ａ｀\x06３\x1b\x10j\x06<␂：φζA５*␆ v",
	}, { // 15
		mask: EncodeZero | EncodeLeftSpace,
		in:   "␟π，；θSc\x16｝＃ ａ｀\x06３\x1b\x10j\x06<␂：φζA５*␆␠v",
		out:  "␟π，；θSc\x16｝＃ ａ｀\x06３\x1b\x10j\x06<␂：φζA５*␆␠v",
	}, { // 16
		mask: EncodeZero | EncodeLeftSpace,
		in:   "␟π，；θSc\x16｝＃ ａ｀\x06３\x1b\x10j\x06<␂：φζA５*␆ ␠",
		out:  "␟π，；θSc\x16｝＃ ａ｀\x06３\x1b\x10j\x06<␂：φζA５*␆ ␠",
	}, { // 17
		mask: EncodeZero | EncodeLeftSpace,
		in:   "␟π，；θSc\x16｝＃ ａ｀\x06３\x1b\x10j\x06<␂：φζA５*␆␠␠",
		out:  "␟π，；θSc\x16｝＃ ａ｀\x06３\x1b\x10j\x06<␂：φζA５*␆␠␠",
	}, { // 18
		mask: EncodeZero | EncodeLeftSpace,
		in:   "␟π，；θSc\x16｝＃ ａ｀\x06３\x1b\x10j\x06<␂：φζA５*␆ι ",
		out:  "␟π，；θSc\x16｝＃ ａ｀\x06３\x1b\x10j\x06<␂：φζA５*␆ι ",
	}, { // 19
		mask: EncodeZero | EncodeLeftSpace,
		in:   "␟π，；θSc\x16｝＃ ａ｀\x06３\x1b\x10j\x06<␂：φζA５*␆ι␠",
		out:  "␟π，；θSc\x16｝＃ ａ｀\x06３\x1b\x10j\x06<␂：φζA５*␆ι␠",
	}, { // 20
		mask: EncodeSlash | EncodeLeftSpace,
		in:   "＊８,\f/ςyμｕ␃ \x1d`\x18％)ｌＧη\n␚Xα＄\x13χｑ%χ␌",
		out:  "＊８,\f／ςyμｕ␃ \x1d`\x18％)ｌＧη\n␚Xα＄\x13χｑ%χ␌",
	}, { // 21
		mask: EncodeSlash | EncodeLeftSpace,
		in:   " ␠,\f/ςyμｕ␃ \x1d`\x18％)ｌＧη\n␚Xα＄\x13χｑ%χ␌",
		out:  "␠␠,\f／ςyμｕ␃ \x1d`\x18％)ｌＧη\n␚Xα＄\x13χｑ%χ␌",
	}, { // 22
		mask: EncodeSlash | EncodeLeftSpace,
		in:   "␠␠,\f/ςyμｕ␃ \x1d`\x18％)ｌＧη\n␚Xα＄\x13χｑ%χ␌",
		out:  "‛␠␠,\f／ςyμｕ␃ \x1d`\x18％)ｌＧη\n␚Xα＄\x13χｑ%χ␌",
	}, { // 23
		mask: EncodeSlash | EncodeLeftSpace,
		in:   " ８,\f/ςyμｕ␃ \x1d`\x18％)ｌＧη\n␚Xα＄\x13χｑ%␠␌",
		out:  "␠８,\f／ςyμｕ␃ \x1d`\x18％)ｌＧη\n␚Xα＄\x13χｑ%␠␌",
	}, { // 24
		mask: EncodeSlash | EncodeLeftSpace,
		in:   "␠８,\f/ςyμｕ␃ \x1d`\x18％)ｌＧη\n␚Xα＄\x13χｑ%␠␌",
		out:  "‛␠８,\f／ςyμｕ␃ \x1d`\x18％)ｌＧη\n␚Xα＄\x13χｑ%␠␌",
	}, { // 25
		mask: EncodeSlash | EncodeLeftSpace,
		in:   " ８,\f/ςyμｕ␃ \x1d`\x18％)ｌＧη\n␚Xα＄\x13χｑ%χ␠",
		out:  "␠８,\f／ςyμｕ␃ \x1d`\x18％)ｌＧη\n␚Xα＄\x13χｑ%χ␠",
	}, { // 26
		mask: EncodeSlash | EncodeLeftSpace,
		in:   "␠８,\f/ςyμｕ␃ \x1d`\x18％)ｌＧη\n␚Xα＄\x13χｑ%χ␠",
		out:  "‛␠８,\f／ςyμｕ␃ \x1d`\x18％)ｌＧη\n␚Xα＄\x13χｑ%χ␠",
	}, { // 27
		mask: EncodeSlash | EncodeLeftSpace,
		in:   "＊ ,\f/ςyμｕ␃ \x1d`\x18％)ｌＧη\n␚Xα＄\x13χｑ%χ␌",
		out:  "＊ ,\f／ςyμｕ␃ \x1d`\x18％)ｌＧη\n␚Xα＄\x13χｑ%χ␌",
	}, { // 28
		mask: EncodeSlash | EncodeLeftSpace,
		in:   "＊␠,\f/ςyμｕ␃ \x1d`\x18％)ｌＧη\n␚Xα＄\x13χｑ%χ␌",
		out:  "＊␠,\f／ςyμｕ␃ \x1d`\x18％)ｌＧη\n␚Xα＄\x13χｑ%χ␌",
	}, { // 29
		mask: EncodeSlash | EncodeLeftSpace,
		in:   "＊ ,\f/ςyμｕ␃ \x1d`\x18％)ｌＧη\n␚Xα＄\x13χｑ%␠␌",
		out:  "＊ ,\f／ςyμｕ␃ \x1d`\x18％)ｌＧη\n␚Xα＄\x13χｑ%␠␌",
	}, { // 30
		mask: EncodeSlash | EncodeLeftSpace,
		in:   "＊␠,\f/ςyμｕ␃ \x1d`\x18％)ｌＧη\n␚Xα＄\x13χｑ%␠␌",
		out:  "＊␠,\f／ςyμｕ␃ \x1d`\x18％)ｌＧη\n␚Xα＄\x13χｑ%␠␌",
	}, { // 31
		mask: EncodeSlash | EncodeLeftSpace,
		in:   "＊ ,\f/ςyμｕ␃ \x1d`\x18％)ｌＧη\n␚Xα＄\x13χｑ%χ␠",
		out:  "＊ ,\f／ςyμｕ␃ \x1d`\x18％)ｌＧη\n␚Xα＄\x13χｑ%χ␠",
	}, { // 32
		mask: EncodeSlash | EncodeLeftSpace,
		in:   "＊␠,\f/ςyμｕ␃ \x1d`\x18％)ｌＧη\n␚Xα＄\x13χｑ%χ␠",
		out:  "＊␠,\f／ςyμｕ␃ \x1d`\x18％)ｌＧη\n␚Xα＄\x13χｑ%χ␠",
	}, { // 33
		mask: EncodeSlash | EncodeLeftSpace,
		in:   "＊８,\f/ςyμｕ␃ \x1d`\x18％)ｌＧη\n␚Xα＄\x13χｑ% ␌",
		out:  "＊８,\f／ςyμｕ␃ \x1d`\x18％)ｌＧη\n␚Xα＄\x13χｑ% ␌",
	}, { // 34
		mask: EncodeSlash | EncodeLeftSpace,
		in:   "＊８,\f/ςyμｕ␃ \x1d`\x18％)ｌＧη\n␚Xα＄\x13χｑ%␠␌",
		out:  "＊８,\f／ςyμｕ␃ \x1d`\x18％)ｌＧη\n␚Xα＄\x13χｑ%␠␌",
	}, { // 35
		mask: EncodeSlash | EncodeLeftSpace,
		in:   "＊８,\f/ςyμｕ␃ \x1d`\x18％)ｌＧη\n␚Xα＄\x13χｑ% ␠",
		out:  "＊８,\f／ςyμｕ␃ \x1d`\x18％)ｌＧη\n␚Xα＄\x13χｑ% ␠",
	}, { // 36
		mask: EncodeSlash | EncodeLeftSpace,
		in:   "＊８,\f/ςyμｕ␃ \x1d`\x18％)ｌＧη\n␚Xα＄\x13χｑ%␠␠",
		out:  "＊８,\f／ςyμｕ␃ \x1d`\x18％)ｌＧη\n␚Xα＄\x13χｑ%␠␠",
	}, { // 37
		mask: EncodeSlash | EncodeLeftSpace,
		in:   "＊８,\f/ςyμｕ␃ \x1d`\x18％)ｌＧη\n␚Xα＄\x13χｑ%χ ",
		out:  "＊８,\f／ςyμｕ␃ \x1d`\x18％)ｌＧη\n␚Xα＄\x13χｑ%χ ",
	}, { // 38
		mask: EncodeSlash | EncodeLeftSpace,
		in:   "＊８,\f/ςyμｕ␃ \x1d`\x18％)ｌＧη\n␚Xα＄\x13χｑ%χ␠",
		out:  "＊８,\f／ςyμｕ␃ \x1d`\x18％)ｌＧη\n␚Xα＄\x13χｑ%χ␠",
	}, { // 39
		mask: EncodeSingleQuote | EncodeLeftSpace,
		in:   "ｏ\t4␕＆χσJ␝Ｂ γ␈$9G\x05\v］９＝Q\x0e␆␇γ\x0eκBσ",
		out:  "ｏ\t4␕＆χσJ␝Ｂ γ␈$9G\x05\v］９＝Q\x0e␆␇γ\x0eκBσ",
	}, { // 40
		mask: EncodeSingleQuote | EncodeLeftSpace,
		in:   " ␠4␕＆χσJ␝Ｂ γ␈$9G\x05\v］９＝Q\x0e␆␇γ\x0eκBσ",
		out:  "␠␠4␕＆χσJ␝Ｂ γ␈$9G\x05\v］９＝Q\x0e␆␇γ\x0eκBσ",
	}, { // 41
		mask: EncodeSingleQuote | EncodeLeftSpace,
		in:   "␠␠4␕＆χσJ␝Ｂ γ␈$9G\x05\v］９＝Q\x0e␆␇γ\x0eκBσ",
		out:  "‛␠␠4␕＆χσJ␝Ｂ γ␈$9G\x05\v］９＝Q\x0e␆␇γ\x0eκBσ",
	}, { // 42
		mask: EncodeSingleQuote | EncodeLeftSpace,
		in:   " \t4␕＆χσJ␝Ｂ γ␈$9G\x05\v］９＝Q\x0e␆␇γ\x0eκ␠σ",
		out:  "␠\t4␕＆χσJ␝Ｂ γ␈$9G\x05\v］９＝Q\x0e␆␇γ\x0eκ␠σ",
	}, { // 43
		mask: EncodeSingleQuote | EncodeLeftSpace,
		in:   "␠\t4␕＆χσJ␝Ｂ γ␈$9G\x05\v］９＝Q\x0e␆␇γ\x0eκ␠σ",
		out:  "‛␠\t4␕＆χσJ␝Ｂ γ␈$9G\x05\v］９＝Q\x0e␆␇γ\x0eκ␠σ",
	}, { // 44
		mask: EncodeSingleQuote | EncodeLeftSpace,
		in:   " \t4␕＆χσJ␝Ｂ γ␈$9G\x05\v］９＝Q\x0e␆␇γ\x0eκB␠",
		out:  "␠\t4␕＆χσJ␝Ｂ γ␈$9G\x05\v］９＝Q\x0e␆␇γ\x0eκB␠",
	}, { // 45
		mask: EncodeSingleQuote | EncodeLeftSpace,
		in:   "␠\t4␕＆χσJ␝Ｂ γ␈$9G\x05\v］９＝Q\x0e␆␇γ\x0eκB␠",
		out:  "‛␠\t4␕＆χσJ␝Ｂ γ␈$9G\x05\v］９＝Q\x0e␆␇γ\x0eκB␠",
	}, { // 46
		mask: EncodeSingleQuote | EncodeLeftSpace,
		in:   "ｏ 4␕＆χσJ␝Ｂ γ␈$9G\x05\v］９＝Q\x0e␆␇γ\x0eκBσ",
		out:  "ｏ 4␕＆χσJ␝Ｂ γ␈$9G\x05\v］９＝Q\x0e␆␇γ\x0eκBσ",
	}, { // 47
		mask: EncodeSingleQuote | EncodeLeftSpace,
		in:   "ｏ␠4␕＆χσJ␝Ｂ γ␈$9G\x05\v］９＝Q\x0e␆␇γ\x0eκBσ",
		out:  "ｏ␠4␕＆χσJ␝Ｂ γ␈$9G\x05\v］９＝Q\x0e␆␇γ\x0eκBσ",
	}, { // 48
		mask: EncodeSingleQuote | EncodeLeftSpace,
		in:   "ｏ 4␕＆χσJ␝Ｂ γ␈$9G\x05\v］９＝Q\x0e␆␇γ\x0eκ␠σ",
		out:  "ｏ 4␕＆χσJ␝Ｂ γ␈$9G\x05\v］９＝Q\x0e␆␇γ\x0eκ␠σ",
	}, { // 49
		mask: EncodeSingleQuote | EncodeLeftSpace,
		in:   "ｏ␠4␕＆χσJ␝Ｂ γ␈$9G\x05\v］９＝Q\x0e␆␇γ\x0eκ␠σ",
		out:  "ｏ␠4␕＆χσJ␝Ｂ γ␈$9G\x05\v］９＝Q\x0e␆␇γ\x0eκ␠σ",
	}, { // 50
		mask: EncodeSingleQuote | EncodeLeftSpace,
		in:   "ｏ 4␕＆χσJ␝Ｂ γ␈$9G\x05\v］９＝Q\x0e␆␇γ\x0eκB␠",
		out:  "ｏ 4␕＆χσJ␝Ｂ γ␈$9G\x05\v］９＝Q\x0e␆␇γ\x0eκB␠",
	}, { // 51
		mask: EncodeSingleQuote | EncodeLeftSpace,
		in:   "ｏ␠4␕＆χσJ␝Ｂ γ␈$9G\x05\v］９＝Q\x0e␆␇γ\x0eκB␠",
		out:  "ｏ␠4␕＆χσJ␝Ｂ γ␈$9G\x05\v］９＝Q\x0e␆␇γ\x0eκB␠",
	}, { // 52
		mask: EncodeSingleQuote | EncodeLeftSpace,
		in:   "ｏ\t4␕＆χσJ␝Ｂ γ␈$9G\x05\v］９＝Q\x0e␆␇γ\x0eκ σ",
		out:  "ｏ\t4␕＆χσJ␝Ｂ γ␈$9G\x05\v］９＝Q\x0e␆␇γ\x0eκ σ",
	}, { // 53
		mask: EncodeSingleQuote | EncodeLeftSpace,
		in:   "ｏ\t4␕＆χσJ␝Ｂ γ␈$9G\x05\v］９＝Q\x0e␆␇γ\x0eκ␠σ",
		out:  "ｏ\t4␕＆χσJ␝Ｂ γ␈$9G\x05\v］９＝Q\x0e␆␇γ\x0eκ␠σ",
	}, { // 54
		mask: EncodeSingleQuote | EncodeLeftSpace,
		in:   "ｏ\t4␕＆χσJ␝Ｂ γ␈$9G\x05\v］９＝Q\x0e␆␇γ\x0eκ ␠",
		out:  "ｏ\t4␕＆χσJ␝Ｂ γ␈$9G\x05\v］９＝Q\x0e␆␇γ\x0eκ ␠",
	}, { // 55
		mask: EncodeSingleQuote | EncodeLeftSpace,
		in:   "ｏ\t4␕＆χσJ␝Ｂ γ␈$9G\x05\v］９＝Q\x0e␆␇γ\x0eκ␠␠",
		out:  "ｏ\t4␕＆χσJ␝Ｂ γ␈$9G\x05\v］９＝Q\x0e␆␇γ\x0eκ␠␠",
	}, { // 56
		mask: EncodeSingleQuote | EncodeLeftSpace,
		in:   "ｏ\t4␕＆χσJ␝Ｂ γ␈$9G\x05\v］９＝Q\x0e␆␇γ\x0eκB ",
		out:  "ｏ\t4␕＆χσJ␝Ｂ γ␈$9G\x05\v］９＝Q\x0e␆␇γ\x0eκB ",
	}, { // 57
		mask: EncodeSingleQuote | EncodeLeftSpace,
		in:   "ｏ\t4␕＆χσJ␝Ｂ γ␈$9G\x05\v］９＝Q\x0e␆␇γ\x0eκB␠",
		out:  "ｏ\t4␕＆χσJ␝Ｂ γ␈$9G\x05\v］９＝Q\x0e␆␇γ\x0eκB␠",
	}, { // 58
		mask: EncodeBackQuote | EncodeLeftSpace,
		in:   "wοπＨ\x10f\x04␚␖[ ␍␈+α␎|S$\x01βLｃＪＬθＫｓ^｜",
		out:  "wοπＨ\x10f\x04␚␖[ ␍␈+α␎|S$\x01βLｃＪＬθＫｓ^｜",
	}, { // 59
		mask: EncodeBackQuote | EncodeLeftSpace,
		in:   " ␠πＨ\x10f\x04␚␖[ ␍␈+α␎|S$\x01βLｃＪＬθＫｓ^｜",
		out:  "␠␠πＨ\x10f\x04␚␖[ ␍␈+α␎|S$\x01βLｃＪＬθＫｓ^｜",
	}, { // 60
		mask: EncodeBackQuote | EncodeLeftSpace,
		in:   "␠␠πＨ\x10f\x04␚␖[ ␍␈+α␎|S$\x01βLｃＪＬθＫｓ^｜",
		out:  "‛␠␠πＨ\x10f\x04␚␖[ ␍␈+α␎|S$\x01βLｃＪＬθＫｓ^｜",
	}, { // 61
		mask: EncodeBackQuote | EncodeLeftSpace,
		in:   " οπＨ\x10f\x04␚␖[ ␍␈+α␎|S$\x01βLｃＪＬθＫｓ␠｜",
		out:  "␠οπＨ\x10f\x04␚␖[ ␍␈+α␎|S$\x01βLｃＪＬθＫｓ␠｜",
	}, { // 62
		mask: EncodeBackQuote | EncodeLeftSpace,
		in:   "␠οπＨ\x10f\x04␚␖[ ␍␈+α␎|S$\x01βLｃＪＬθＫｓ␠｜",
		out:  "‛␠οπＨ\x10f\x04␚␖[ ␍␈+α␎|S$\x01βLｃＪＬθＫｓ␠｜",
	}, { // 63
		mask: EncodeBackQuote | EncodeLeftSpace,
		in:   " οπＨ\x10f\x04␚␖[ ␍␈+α␎|S$\x01βLｃＪＬθＫｓ^␠",
		out:  "␠οπＨ\x10f\x04␚␖[ ␍␈+α␎|S$\x01βLｃＪＬθＫｓ^␠",
	}, { // 64
		mask: EncodeBackQuote | EncodeLeftSpace,
		in:   "␠οπＨ\x10f\x04␚␖[ ␍␈+α␎|S$\x01βLｃＪＬθＫｓ^␠",
		out:  "‛␠οπＨ\x10f\x04␚␖[ ␍␈+α␎|S$\x01βLｃＪＬθＫｓ^␠",
	}, { // 65
		mask: EncodeBackQuote | EncodeLeftSpace,
		in:   "w πＨ\x10f\x04␚␖[ ␍␈+α␎|S$\x01βLｃＪＬθＫｓ^｜",
		out:  "w πＨ\x10f\x04␚␖[ ␍␈+α␎|S$\x01βLｃＪＬθＫｓ^｜",
	}, { // 66
		mask: EncodeBackQuote | EncodeLeftSpace,
		in:   "w␠πＨ\x10f\x04␚␖[ ␍␈+α␎|S$\x01βLｃＪＬθＫｓ^｜",
		out:  "w␠πＨ\x10f\x04␚␖[ ␍␈+α␎|S$\x01βLｃＪＬθＫｓ^｜",
	}, { // 67
		mask: EncodeBackQuote | EncodeLeftSpace,
		in:   "w πＨ\x10f\x04␚␖[ ␍␈+α␎|S$\x01βLｃＪＬθＫｓ␠｜",
		out:  "w πＨ\x10f\x04␚␖[ ␍␈+α␎|S$\x01βLｃＪＬθＫｓ␠｜",
	}, { // 68
		mask: EncodeBackQuote | EncodeLeftSpace,
		in:   "w␠πＨ\x10f\x04␚␖[ ␍␈+α␎|S$\x01βLｃＪＬθＫｓ␠｜",
		out:  "w␠πＨ\x10f\x04␚␖[ ␍␈+α␎|S$\x01βLｃＪＬθＫｓ␠｜",
	}, { // 69
		mask: EncodeBackQuote | EncodeLeftSpace,
		in:   "w πＨ\x10f\x04␚␖[ ␍␈+α␎|S$\x01βLｃＪＬθＫｓ^␠",
		out:  "w πＨ\x10f\x04␚␖[ ␍␈+α␎|S$\x01βLｃＪＬθＫｓ^␠",
	}, { // 70
		mask: EncodeBackQuote | EncodeLeftSpace,
		in:   "w␠πＨ\x10f\x04␚␖[ ␍␈+α␎|S$\x01βLｃＪＬθＫｓ^␠",
		out:  "w␠πＨ\x10f\x04␚␖[ ␍␈+α␎|S$\x01βLｃＪＬθＫｓ^␠",
	}, { // 71
		mask: EncodeBackQuote | EncodeLeftSpace,
		in:   "wοπＨ\x10f\x04␚␖[ ␍␈+α␎|S$\x01βLｃＪＬθＫｓ ｜",
		out:  "wοπＨ\x10f\x04␚␖[ ␍␈+α␎|S$\x01βLｃＪＬθＫｓ ｜",
	}, { // 72
		mask: EncodeBackQuote | EncodeLeftSpace,
		in:   "wοπＨ\x10f\x04␚␖[ ␍␈+α␎|S$\x01βLｃＪＬθＫｓ␠｜",
		out:  "wοπＨ\x10f\x04␚␖[ ␍␈+α␎|S$\x01βLｃＪＬθＫｓ␠｜",
	}, { // 73
		mask: EncodeBackQuote | EncodeLeftSpace,
		in:   "wοπＨ\x10f\x04␚␖[ ␍␈+α␎|S$\x01βLｃＪＬθＫｓ ␠",
		out:  "wοπＨ\x10f\x04␚␖[ ␍␈+α␎|S$\x01βLｃＪＬθＫｓ ␠",
	}, { // 74
		mask: EncodeBackQuote | EncodeLeftSpace,
		in:   "wοπＨ\x10f\x04␚␖[ ␍␈+α␎|S$\x01βLｃＪＬθＫｓ␠␠",
		out:  "wοπＨ\x10f\x04␚␖[ ␍␈+α␎|S$\x01βLｃＪＬθＫｓ␠␠",
	}, { // 75
		mask: EncodeBackQuote | EncodeLeftSpace,
		in:   "wοπＨ\x10f\x04␚␖[ ␍␈+α␎|S$\x01βLｃＪＬθＫｓ^ ",
		out:  "wοπＨ\x10f\x04␚␖[ ␍␈+α␎|S$\x01βLｃＪＬθＫｓ^ ",
	}, { // 76
		mask: EncodeBackQuote | EncodeLeftSpace,
		in:   "wοπＨ\x10f\x04␚␖[ ␍␈+α␎|S$\x01βLｃＪＬθＫｓ^␠",
		out:  "wοπＨ\x10f\x04␚␖[ ␍␈+α␎|S$\x01βLｃＪＬθＫｓ^␠",
	}, { // 77
		mask: EncodeLtGt | EncodeLeftSpace,
		in:   "＇\r␕σ␑｝/９｛｛ ＦSετ<β`\fγς;a5ｔ␙g␑\u007f␔",
		out:  "＇\r␕σ␑｝/９｛｛ ＦSετ＜β`\fγς;a5ｔ␙g␑\u007f␔",
	}, { // 78
		mask: EncodeLtGt | EncodeLeftSpace,
		in:   " ␠␕σ␑｝/９｛｛ ＦSετ<β`\fγς;a5ｔ␙g␑\u007f␔",
		out:  "␠␠␕σ␑｝/９｛｛ ＦSετ＜β`\fγς;a5ｔ␙g␑\u007f␔",
	}, { // 79
		mask: EncodeLtGt | EncodeLeftSpace,
		in:   "␠␠␕σ␑｝/９｛｛ ＦSετ<β`\fγς;a5ｔ␙g␑\u007f␔",
		out:  "‛␠␠␕σ␑｝/９｛｛ ＦSετ＜β`\fγς;a5ｔ␙g␑\u007f␔",
	}, { // 80
		mask: EncodeLtGt | EncodeLeftSpace,
		in:   " \r␕σ␑｝/９｛｛ ＦSετ<β`\fγς;a5ｔ␙g␑␠␔",
		out:  "␠\r␕σ␑｝/９｛｛ ＦSετ＜β`\fγς;a5ｔ␙g␑␠␔",
	}, { // 81
		mask: EncodeLtGt | EncodeLeftSpace,
		in:   "␠\r␕σ␑｝/９｛｛ ＦSετ<β`\fγς;a5ｔ␙g␑␠␔",
		out:  "‛␠\r␕σ␑｝/９｛｛ ＦSετ＜β`\fγς;a5ｔ␙g␑␠␔",
	}, { // 82
		mask: EncodeLtGt | EncodeLeftSpace,
		in:   " \r␕σ␑｝/９｛｛ ＦSετ<β`\fγς;a5ｔ␙g␑\u007f␠",
		out:  "␠\r␕σ␑｝/９｛｛ ＦSετ＜β`\fγς;a5ｔ␙g␑\u007f␠",
	}, { // 83
		mask: EncodeLtGt | EncodeLeftSpace,
		in:   "␠\r␕σ␑｝/９｛｛ ＦSετ<β`\fγς;a5ｔ␙g␑\u007f␠",
		out:  "‛␠\r␕σ␑｝/９｛｛ ＦSετ＜β`\fγς;a5ｔ␙g␑\u007f␠",
	}, { // 84
		mask: EncodeLtGt | EncodeLeftSpace,
		in:   "＇ ␕σ␑｝/９｛｛ ＦSετ<β`\fγς;a5ｔ␙g␑\u007f␔",
		out:  "＇ ␕σ␑｝/９｛｛ ＦSετ＜β`\fγς;a5ｔ␙g␑\u007f␔",
	}, { // 85
		mask: EncodeLtGt | EncodeLeftSpace,
		in:   "＇␠␕σ␑｝/９｛｛ ＦSετ<β`\fγς;a5ｔ␙g␑\u007f␔",
		out:  "＇␠␕σ␑｝/９｛｛ ＦSετ＜β`\fγς;a5ｔ␙g␑\u007f␔",
	}, { // 86
		mask: EncodeLtGt | EncodeLeftSpace,
		in:   "＇ ␕σ␑｝/９｛｛ ＦSετ<β`\fγς;a5ｔ␙g␑␠␔",
		out:  "＇ ␕σ␑｝/９｛｛ ＦSετ＜β`\fγς;a5ｔ␙g␑␠␔",
	}, { // 87
		mask: EncodeLtGt | EncodeLeftSpace,
		in:   "＇␠␕σ␑｝/９｛｛ ＦSετ<β`\fγς;a5ｔ␙g␑␠␔",
		out:  "＇␠␕σ␑｝/９｛｛ ＦSετ＜β`\fγς;a5ｔ␙g␑␠␔",
	}, { // 88
		mask: EncodeLtGt | EncodeLeftSpace,
		in:   "＇ ␕σ␑｝/９｛｛ ＦSετ<β`\fγς;a5ｔ␙g␑\u007f␠",
		out:  "＇ ␕σ␑｝/９｛｛ ＦSετ＜β`\fγς;a5ｔ␙g␑\u007f␠",
	}, { // 89
		mask: EncodeLtGt | EncodeLeftSpace,
		in:   "＇␠␕σ␑｝/９｛｛ ＦSετ<β`\fγς;a5ｔ␙g␑\u007f␠",
		out:  "＇␠␕σ␑｝/９｛｛ ＦSετ＜β`\fγς;a5ｔ␙g␑\u007f␠",
	}, { // 90
		mask: EncodeLtGt | EncodeLeftSpace,
		in:   "＇\r␕σ␑｝/９｛｛ ＦSετ<β`\fγς;a5ｔ␙g␑ ␔",
		out:  "＇\r␕σ␑｝/９｛｛ ＦSετ＜β`\fγς;a5ｔ␙g␑ ␔",
	}, { // 91
		mask: EncodeLtGt | EncodeLeftSpace,
		in:   "＇\r␕σ␑｝/９｛｛ ＦSετ<β`\fγς;a5ｔ␙g␑␠␔",
		out:  "＇\r␕σ␑｝/９｛｛ ＦSετ＜β`\fγς;a5ｔ␙g␑␠␔",
	}, { // 92
		mask: EncodeLtGt | EncodeLeftSpace,
		in:   "＇\r␕σ␑｝/９｛｛ ＦSετ<β`\fγς;a5ｔ␙g␑ ␠",
		out:  "＇\r␕σ␑｝/９｛｛ ＦSετ＜β`\fγς;a5ｔ␙g␑ ␠",
	}, { // 93
		mask: EncodeLtGt | EncodeLeftSpace,
		in:   "＇\r␕σ␑｝/９｛｛ ＦSετ<β`\fγς;a5ｔ␙g␑␠␠",
		out:  "＇\r␕σ␑｝/９｛｛ ＦSετ＜β`\fγς;a5ｔ␙g␑␠␠",
	}, { // 94
		mask: EncodeLtGt | EncodeLeftSpace,
		in:   "＇\r␕σ␑｝/９｛｛ ＦSετ<β`\fγς;a5ｔ␙g␑\u007f ",
		out:  "＇\r␕σ␑｝/９｛｛ ＦSετ＜β`\fγς;a5ｔ␙g␑\u007f ",
	}, { // 95
		mask: EncodeLtGt | EncodeLeftSpace,
		in:   "＇\r␕σ␑｝/９｛｛ ＦSετ<β`\fγς;a5ｔ␙g␑\u007f␠",
		out:  "＇\r␕σ␑｝/９｛｛ ＦSετ＜β`\fγς;a5ｔ␙g␑\u007f␠",
	}, { // 96
		mask: EncodeSquareBracket | EncodeLeftSpace,
		in:   "␈;ρ␁；␞ξ\x0e%\x19 δl␙ＷP␏３\u007fιδ／Lu８/\x00:ｄ＼",
		out:  "␈;ρ␁；␞ξ\x0e%\x19 δl␙ＷP␏３\u007fιδ／Lu８/␀:ｄ＼",
	}, { // 97
		mask: EncodeSquareBracket | EncodeLeftSpace,
		in:   " ␠ρ␁；␞ξ\x0e%\x19 δl␙ＷP␏３\u007fιδ／Lu８/\x00:ｄ＼",
		out:  "␠␠ρ␁；␞ξ\x0e%\x19 δl␙ＷP␏３\u007fιδ／Lu８/␀:ｄ＼",
	}, { // 98
		mask: EncodeSquareBracket | EncodeLeftSpace,
		in:   "␠␠ρ␁；␞ξ\x0e%\x19 δl␙ＷP␏３\u007fιδ／Lu８/\x00:ｄ＼",
		out:  "‛␠␠ρ␁；␞ξ\x0e%\x19 δl␙ＷP␏３\u007fιδ／Lu８/␀:ｄ＼",
	}, { // 99
		mask: EncodeSquareBracket | EncodeLeftSpace,
		in:   " ;ρ␁；␞ξ\x0e%\x19 δl␙ＷP␏３\u007fιδ／Lu８/\x00:␠＼",
		out:  "␠;ρ␁；␞ξ\x0e%\x19 δl␙ＷP␏３\u007fιδ／Lu８/␀:␠＼",
	}, { // 100
		mask: EncodeSquareBracket | EncodeLeftSpace,
		in:   "␠;ρ␁；␞ξ\x0e%\x19 δl␙ＷP␏３\u007fιδ／Lu８/\x00:␠＼",
		out:  "‛␠;ρ␁；␞ξ\x0e%\x19 δl␙ＷP␏３\u007fιδ／Lu８/␀:␠＼",
	}, { // 101
		mask: EncodeSquareBracket | EncodeLeftSpace,
		in:   " ;ρ␁；␞ξ\x0e%\x19 δl␙ＷP␏３\u007fιδ／Lu８/\x00:ｄ␠",
		out:  "␠;ρ␁；␞ξ\x0e%\x19 δl␙ＷP␏３\u007fιδ／Lu８/␀:ｄ␠",
	}, { // 102
		mask: EncodeSquareBracket | EncodeLeftSpace,
		in:   "␠;ρ␁；␞ξ\x0e%\x19 δl␙ＷP␏３\u007fιδ／Lu８/\x00:ｄ␠",
		out:  "‛␠;ρ␁；␞ξ\x0e%\x19 δl␙ＷP␏３\u007fιδ／Lu８/␀:ｄ␠",
	}, { // 103
		mask: EncodeSquareBracket | EncodeLeftSpace,
		in:   "␈ ρ␁；␞ξ\x0e%\x19 δl␙ＷP␏３\u007fιδ／Lu８/\x00:ｄ＼",
		out:  "␈ ρ␁；␞ξ\x0e%\x19 δl␙ＷP␏３\u007fιδ／Lu８/␀:ｄ＼",
	}, { // 104
		mask: EncodeSquareBracket | EncodeLeftSpace,
		in:   "␈␠ρ␁；␞ξ\x0e%\x19 δl␙ＷP␏３\u007fιδ／Lu８/\x00:ｄ＼",
		out:  "␈␠ρ␁；␞ξ\x0e%\x19 δl␙ＷP␏３\u007fιδ／Lu８/␀:ｄ＼",
	}, { // 105
		mask: EncodeSquareBracket | EncodeLeftSpace,
		in:   "␈ ρ␁；␞ξ\x0e%\x19 δl␙ＷP␏３\u007fιδ／Lu８/\x00:␠＼",
		out:  "␈ ρ␁；␞ξ\x0e%\x19 δl␙ＷP␏３\u007fιδ／Lu８/␀:␠＼",
	}, { // 106
		mask: EncodeSquareBracket | EncodeLeftSpace,
		in:   "␈␠ρ␁；␞ξ\x0e%\x19 δl␙ＷP␏３\u007fιδ／Lu８/\x00:␠＼",
		out:  "␈␠ρ␁；␞ξ\x0e%\x19 δl␙ＷP␏３\u007fιδ／Lu８/␀:␠＼",
	}, { // 107
		mask: EncodeSquareBracket | EncodeLeftSpace,
		in:   "␈ ρ␁；␞ξ\x0e%\x19 δl␙ＷP␏３\u007fιδ／Lu８/\x00:ｄ␠",
		out:  "␈ ρ␁；␞ξ\x0e%\x19 δl␙ＷP␏３\u007fιδ／Lu８/␀:ｄ␠",
	}, { // 108
		mask: EncodeSquareBracket | EncodeLeftSpace,
		in:   "␈␠ρ␁；␞ξ\x0e%\x19 δl␙ＷP␏３\u007fιδ／Lu８/\x00:ｄ␠",
		out:  "␈␠ρ␁；␞ξ\x0e%\x19 δl␙ＷP␏３\u007fιδ／Lu８/␀:ｄ␠",
	}, { // 109
		mask: EncodeSquareBracket | EncodeLeftSpace,
		in:   "␈;ρ␁；␞ξ\x0e%\x19 δl␙ＷP␏３\u007fιδ／Lu８/\x00: ＼",
		out:  "␈;ρ␁；␞ξ\x0e%\x19 δl␙ＷP␏３\u007fιδ／Lu８/␀: ＼",
	}, { // 110
		mask: EncodeSquareBracket | EncodeLeftSpace,
		in:   "␈;ρ␁；␞ξ\x0e%\x19 δl␙ＷP␏３\u007fιδ／Lu８/\x00:␠＼",
		out:  "␈;ρ␁；␞ξ\x0e%\x19 δl␙ＷP␏３\u007fιδ／Lu８/␀:␠＼",
	}, { // 111
		mask: EncodeSquareBracket | EncodeLeftSpace,
		in:   "␈;ρ␁；␞ξ\x0e%\x19 δl␙ＷP␏３\u007fιδ／Lu８/\x00: ␠",
		out:  "␈;ρ␁；␞ξ\x0e%\x19 δl␙ＷP␏３\u007fιδ／Lu８/␀: ␠",
	}, { // 112
		mask: EncodeSquareBracket | EncodeLeftSpace,
		in:   "␈;ρ␁；␞ξ\x0e%\x19 δl␙ＷP␏３\u007fιδ／Lu８/\x00:␠␠",
		out:  "␈;ρ␁；␞ξ\x0e%\x19 δl␙ＷP␏３\u007fιδ／Lu８/␀:␠␠",
	}, { // 113
		mask: EncodeSquareBracket | EncodeLeftSpace,
		in:   "␈;ρ␁；␞ξ\x0e%\x19 δl␙ＷP␏３\u007fιδ／Lu８/\x00:ｄ ",
		out:  "␈;ρ␁；␞ξ\x0e%\x19 δl␙ＷP␏３\u007fιδ／Lu８/␀:ｄ ",
	}, { // 114
		mask: EncodeSquareBracket | EncodeLeftSpace,
		in:   "␈;ρ␁；␞ξ\x0e%\x19 δl␙ＷP␏３\u007fιδ／Lu８/\x00:ｄ␠",
		out:  "␈;ρ␁；␞ξ\x0e%\x19 δl␙ＷP␏３\u007fιδ／Lu８/␀:ｄ␠",
	}, { // 115
		mask: EncodeSemicolon | EncodeLeftSpace,
		in:   "［\r␗`l[＼ｃｑμ ?［ｖＴζＴ#|υ＜>XKωμ\x1b␙␉η",
		out:  "［\r␗`l[＼ｃｑμ ?［ｖＴζＴ#|υ＜>XKωμ\x1b␙␉η",
	}, { // 116
		mask: EncodeSemicolon | EncodeLeftSpace,
		in:   " ␠␗`l[＼ｃｑμ ?［ｖＴζＴ#|υ＜>XKωμ\x1b␙␉η",
		out:  "␠␠␗`l[＼ｃｑμ ?［ｖＴζＴ#|υ＜>XKωμ\x1b␙␉η",
	}, { // 117
		mask: EncodeSemicolon | EncodeLeftSpace,
		in:   "␠␠␗`l[＼ｃｑμ ?［ｖＴζＴ#|υ＜>XKωμ\x1b␙␉η",
		out:  "‛␠␠␗`l[＼ｃｑμ ?［ｖＴζＴ#|υ＜>XKωμ\x1b␙␉η",
	}, { // 118
		mask: EncodeSemicolon | EncodeLeftSpace,
		in:   " \r␗`l[＼ｃｑμ ?［ｖＴζＴ#|υ＜>XKωμ\x1b␙␠η",
		out:  "␠\r␗`l[＼ｃｑμ ?［ｖＴζＴ#|υ＜>XKωμ\x1b␙␠η",
	}, { // 119
		mask: EncodeSemicolon | EncodeLeftSpace,
		in:   "␠\r␗`l[＼ｃｑμ ?［ｖＴζＴ#|υ＜>XKωμ\x1b␙␠η",
		out:  "‛␠\r␗`l[＼ｃｑμ ?［ｖＴζＴ#|υ＜>XKωμ\x1b␙␠η",
	}, { // 120
		mask: EncodeSemicolon | EncodeLeftSpace,
		in:   " \r␗`l[＼ｃｑμ ?［ｖＴζＴ#|υ＜>XKωμ\x1b␙␉␠",
		out:  "␠\r␗`l[＼ｃｑμ ?［ｖＴζＴ#|υ＜>XKωμ\x1b␙␉␠",
	}, { // 121
		mask: EncodeSemicolon | EncodeLeftSpace,
		in:   "␠\r␗`l[＼ｃｑμ ?［ｖＴζＴ#|υ＜>XKωμ\x1b␙␉␠",
		out:  "‛␠\r␗`l[＼ｃｑμ ?［ｖＴζＴ#|υ＜>XKωμ\x1b␙␉␠",
	}, { // 122
		mask: EncodeSemicolon | EncodeLeftSpace,
		in:   "［ ␗`l[＼ｃｑμ ?［ｖＴζＴ#|υ＜>XKωμ\x1b␙␉η",
		out:  "［ ␗`l[＼ｃｑμ ?［ｖＴζＴ#|υ＜>XKωμ\x1b␙␉η",
	}, { // 123
		mask: EncodeSemicolon | EncodeLeftSpace,
		in:   "［␠␗`l[＼ｃｑμ ?［ｖＴζＴ#|υ＜>XKωμ\x1b␙␉η",
		out:  "［␠␗`l[＼ｃｑμ ?［ｖＴζＴ#|υ＜>XKωμ\x1b␙␉η",
	}, { // 124
		mask: EncodeSemicolon | EncodeLeftSpace,
		in:   "［ ␗`l[＼ｃｑμ ?［ｖＴζＴ#|υ＜>XKωμ\x1b␙␠η",
		out:  "［ ␗`l[＼ｃｑμ ?［ｖＴζＴ#|υ＜>XKωμ\x1b␙␠η",
	}, { // 125
		mask: EncodeSemicolon | EncodeLeftSpace,
		in:   "［␠␗`l[＼ｃｑμ ?［ｖＴζＴ#|υ＜>XKωμ\x1b␙␠η",
		out:  "［␠␗`l[＼ｃｑμ ?［ｖＴζＴ#|υ＜>XKωμ\x1b␙␠η",
	}, { // 126
		mask: EncodeSemicolon | EncodeLeftSpace,
		in:   "［ ␗`l[＼ｃｑμ ?［ｖＴζＴ#|υ＜>XKωμ\x1b␙␉␠",
		out:  "［ ␗`l[＼ｃｑμ ?［ｖＴζＴ#|υ＜>XKωμ\x1b␙␉␠",
	}, { // 127
		mask: EncodeSemicolon | EncodeLeftSpace,
		in:   "［␠␗`l[＼ｃｑμ ?［ｖＴζＴ#|υ＜>XKωμ\x1b␙␉␠",
		out:  "［␠␗`l[＼ｃｑμ ?［ｖＴζＴ#|υ＜>XKωμ\x1b␙␉␠",
	}, { // 128
		mask: EncodeSemicolon | EncodeLeftSpace,
		in:   "［\r␗`l[＼ｃｑμ ?［ｖＴζＴ#|υ＜>XKωμ\x1b␙ η",
		out:  "［\r␗`l[＼ｃｑμ ?［ｖＴζＴ#|υ＜>XKωμ\x1b␙ η",
	}, { // 129
		mask: EncodeSemicolon | EncodeLeftSpace,
		in:   "［\r␗`l[＼ｃｑμ ?［ｖＴζＴ#|υ＜>XKωμ\x1b␙␠η",
		out:  "［\r␗`l[＼ｃｑμ ?［ｖＴζＴ#|υ＜>XKωμ\x1b␙␠η",
	}, { // 130
		mask: EncodeSemicolon | EncodeLeftSpace,
		in:   "［\r␗`l[＼ｃｑμ ?［ｖＴζＴ#|υ＜>XKωμ\x1b␙ ␠",
		out:  "［\r␗`l[＼ｃｑμ ?［ｖＴζＴ#|υ＜>XKωμ\x1b␙ ␠",
	}, { // 131
		mask: EncodeSemicolon | EncodeLeftSpace,
		in:   "［\r␗`l[＼ｃｑμ ?［ｖＴζＴ#|υ＜>XKωμ\x1b␙␠␠",
		out:  "［\r␗`l[＼ｃｑμ ?［ｖＴζＴ#|υ＜>XKωμ\x1b␙␠␠",
	}, { // 132
		mask: EncodeSemicolon | EncodeLeftSpace,
		in:   "［\r␗`l[＼ｃｑμ ?［ｖＴζＴ#|υ＜>XKωμ\x1b␙␉ ",
		out:  "［\r␗`l[＼ｃｑμ ?［ｖＴζＴ#|υ＜>XKωμ\x1b␙␉ ",
	}, { // 133
		mask: EncodeSemicolon | EncodeLeftSpace,
		in:   "［\r␗`l[＼ｃｑμ ?［ｖＴζＴ#|υ＜>XKωμ\x1b␙␉␠",
		out:  "［\r␗`l[＼ｃｑμ ?［ｖＴζＴ#|υ＜>XKωμ\x1b␙␉␠",
	}, { // 134
		mask: EncodeDollar | EncodeLeftSpace,
		in:   "ｊ\x1d␚x0␊ｃ␛z; O␞\x03ω␔＼η１？\x16φ_π*Ｘωｈ|κ",
		out:  "ｊ\x1d␚x0␊ｃ␛z; O␞\x03ω␔＼η１？\x16φ_π*Ｘωｈ|κ",
	}, { // 135
		mask: EncodeDollar | EncodeLeftSpace,
		in:   " ␠␚x0␊ｃ␛z; O␞\x03ω␔＼η１？\x16φ_π*Ｘωｈ|κ",
		out:  "␠␠␚x0␊ｃ␛z; O␞\x03ω␔＼η１？\x16φ_π*Ｘωｈ|κ",
	}, { // 136
		mask: EncodeDollar | EncodeLeftSpace,
		in:   "␠␠␚x0␊ｃ␛z; O␞\x03ω␔＼η１？\x16φ_π*Ｘωｈ|κ",
		out:  "‛␠␠␚x0␊ｃ␛z; O␞\x03ω␔＼η１？\x16φ_π*Ｘωｈ|κ",
	}, { // 137
		mask: EncodeDollar | EncodeLeftSpace,
		in:   " \x1d␚x0␊ｃ␛z; O␞\x03ω␔＼η１？\x16φ_π*Ｘωｈ␠κ",
		out:  "␠\x1d␚x0␊ｃ␛z; O␞\x03ω␔＼η１？\x16φ_π*Ｘωｈ␠κ",
	}, { // 138
		mask: EncodeDollar | EncodeLeftSpace,
		in:   "␠\x1d␚x0␊ｃ␛z; O␞\x03ω␔＼η１？\x16φ_π*Ｘωｈ␠κ",
		out:  "‛␠\x1d␚x0␊ｃ␛z; O␞\x03ω␔＼η１？\x16φ_π*Ｘωｈ␠κ",
	}, { // 139
		mask: EncodeDollar | EncodeLeftSpace,
		in:   " \x1d␚x0␊ｃ␛z; O␞\x03ω␔＼η１？\x16φ_π*Ｘωｈ|␠",
		out:  "␠\x1d␚x0␊ｃ␛z; O␞\x03ω␔＼η１？\x16φ_π*Ｘωｈ|␠",
	}, { // 140
		mask: EncodeDollar | EncodeLeftSpace,
		in:   "␠\x1d␚x0␊ｃ␛z; O␞\x03ω␔＼η１？\x16φ_π*Ｘωｈ|␠",
		out:  "‛␠\x1d␚x0␊ｃ␛z; O␞\x03ω␔＼η１？\x16φ_π*Ｘωｈ|␠",
	}, { // 141
		mask: EncodeDollar | EncodeLeftSpace,
		in:   "ｊ ␚x0␊ｃ␛z; O␞\x03ω␔＼η１？\x16φ_π*Ｘωｈ|κ",
		out:  "ｊ ␚x0␊ｃ␛z; O␞\x03ω␔＼η１？\x16φ_π*Ｘωｈ|κ",
	}, { // 142
		mask: EncodeDollar | EncodeLeftSpace,
		in:   "ｊ␠␚x0␊ｃ␛z; O␞\x03ω␔＼η１？\x16φ_π*Ｘωｈ|κ",
		out:  "ｊ␠␚x0␊ｃ␛z; O␞\x03ω␔＼η１？\x16φ_π*Ｘωｈ|κ",
	}, { // 143
		mask: EncodeDollar | EncodeLeftSpace,
		in:   "ｊ ␚x0␊ｃ␛z; O␞\x03ω␔＼η１？\x16φ_π*Ｘωｈ␠κ",
		out:  "ｊ ␚x0␊ｃ␛z; O␞\x03ω␔＼η１？\x16φ_π*Ｘωｈ␠κ",
	}, { // 144
		mask: EncodeDollar | EncodeLeftSpace,
		in:   "ｊ␠␚x0␊ｃ␛z; O␞\x03ω␔＼η１？\x16φ_π*Ｘωｈ␠κ",
		out:  "ｊ␠␚x0␊ｃ␛z; O␞\x03ω␔＼η１？\x16φ_π*Ｘωｈ␠κ",
	}, { // 145
		mask: EncodeDollar | EncodeLeftSpace,
		in:   "ｊ ␚x0␊ｃ␛z; O␞\x03ω␔＼η１？\x16φ_π*Ｘωｈ|␠",
		out:  "ｊ ␚x0␊ｃ␛z; O␞\x03ω␔＼η１？\x16φ_π*Ｘωｈ|␠",
	}, { // 146
		mask: EncodeDollar | EncodeLeftSpace,
		in:   "ｊ␠␚x0␊ｃ␛z; O␞\x03ω␔＼η１？\x16φ_π*Ｘωｈ|␠",
		out:  "ｊ␠␚x0␊ｃ␛z; O␞\x03ω␔＼η１？\x16φ_π*Ｘωｈ|␠",
	}, { // 147
		mask: EncodeDollar | EncodeLeftSpace,
		in:   "ｊ\x1d␚x0␊ｃ␛z; O␞\x03ω␔＼η１？\x16φ_π*Ｘωｈ κ",
		out:  "ｊ\x1d␚x0␊ｃ␛z; O␞\x03ω␔＼η１？\x16φ_π*Ｘωｈ κ",
	}, { // 148
		mask: EncodeDollar | EncodeLeftSpace,
		in:   "ｊ\x1d␚x0␊ｃ␛z; O␞\x03ω␔＼η１？\x16φ_π*Ｘωｈ␠κ",
		out:  "ｊ\x1d␚x0␊ｃ␛z; O␞\x03ω␔＼η１？\x16φ_π*Ｘωｈ␠κ",
	}, { // 149
		mask: EncodeDollar | EncodeLeftSpace,
		in:   "ｊ\x1d␚x0␊ｃ␛z; O␞\x03ω␔＼η１？\x16φ_π*Ｘωｈ ␠",
		out:  "ｊ\x1d␚x0␊ｃ␛z; O␞\x03ω␔＼η１？\x16φ_π*Ｘωｈ ␠",
	}, { // 150
		mask: EncodeDollar | EncodeLeftSpace,
		in:   "ｊ\x1d␚x0␊ｃ␛z; O␞\x03ω␔＼η１？\x16φ_π*Ｘωｈ␠␠",
		out:  "ｊ\x1d␚x0␊ｃ␛z; O␞\x03ω␔＼η１？\x16φ_π*Ｘωｈ␠␠",
	}, { // 151
		mask: EncodeDollar | EncodeLeftSpace,
		in:   "ｊ\x1d␚x0␊ｃ␛z; O␞\x03ω␔＼η１？\x16φ_π*Ｘωｈ| ",
		out:  "ｊ\x1d␚x0␊ｃ␛z; O␞\x03ω␔＼η１？\x16φ_π*Ｘωｈ| ",
	}, { // 152
		mask: EncodeDollar | EncodeLeftSpace,
		in:   "ｊ\x1d␚x0␊ｃ␛z; O␞\x03ω␔＼η１？\x16φ_π*Ｘωｈ|␠",
		out:  "ｊ\x1d␚x0␊ｃ␛z; O␞\x03ω␔＼η１？\x16φ_π*Ｘωｈ|␠",
	}, { // 153
		mask: EncodeDoubleQuote | EncodeLeftSpace,
		in:   "#［&Yρ\x15μ'␍γ ［ζ␃Ｕ,\x11␌！NＴχ␈-$\x18～\x04Ｆ］",
		out:  "#［&Yρ\x15μ'␍γ ［ζ␃Ｕ,\x11␌！NＴχ␈-$\x18～\x04Ｆ］",
	}, { // 154
		mask: EncodeDoubleQuote | EncodeLeftSpace,
		in:   " ␠&Yρ\x15μ'␍γ ［ζ␃Ｕ,\x11␌！NＴχ␈-$\x18～\x04Ｆ］",
		out:  "␠␠&Yρ\x15μ'␍γ ［ζ␃Ｕ,\x11␌！NＴχ␈-$\x18～\x04Ｆ］",
	}, { // 155
		mask: EncodeDoubleQuote | EncodeLeftSpace,
		in:   "␠␠&Yρ\x15μ'␍γ ［ζ␃Ｕ,\x11␌！NＴχ␈-$\x18～\x04Ｆ］",
		out:  "‛␠␠&Yρ\x15μ'␍γ ［ζ␃Ｕ,\x11␌！NＴχ␈-$\x18～\x04Ｆ］",
	}, { // 156
		mask: EncodeDoubleQuote | EncodeLeftSpace,
		in:   " ［&Yρ\x15μ'␍γ ［ζ␃Ｕ,\x11␌！NＴχ␈-$\x18～\x04␠］",
		out:  "␠［&Yρ\x15μ'␍γ ［ζ␃Ｕ,\x11␌！NＴχ␈-$\x18～\x04␠］",
	}, { // 157
		mask: EncodeDoubleQuote | EncodeLeftSpace,
		in:   "␠［&Yρ\x15μ'␍γ ［ζ␃Ｕ,\x11␌！NＴχ␈-$\x18～\x04␠］",
		out:  "‛␠［&Yρ\x15μ'␍γ ［ζ␃Ｕ,\x11␌！NＴχ␈-$\x18～\x04␠］",
	}, { // 158
		mask: EncodeDoubleQuote | EncodeLeftSpace,
		in:   " ［&Yρ\x15μ'␍γ ［ζ␃Ｕ,\x11␌！NＴχ␈-$\x18～\x04Ｆ␠",
		out:  "␠［&Yρ\x15μ'␍γ ［ζ␃Ｕ,\x11␌！NＴχ␈-$\x18～\x04Ｆ␠",
	}, { // 159
		mask: EncodeDoubleQuote | EncodeLeftSpace,
		in:   "␠［&Yρ\x15μ'␍γ ［ζ␃Ｕ,\x11␌！NＴχ␈-$\x18～\x04Ｆ␠",
		out:  "‛␠［&Yρ\x15μ'␍γ ［ζ␃Ｕ,\x11␌！NＴχ␈-$\x18～\x04Ｆ␠",
	}, { // 160
		mask: EncodeDoubleQuote | EncodeLeftSpace,
		in:   "# &Yρ\x15μ'␍γ ［ζ␃Ｕ,\x11␌！NＴχ␈-$\x18～\x04Ｆ］",
		out:  "# &Yρ\x15μ'␍γ ［ζ␃Ｕ,\x11␌！NＴχ␈-$\x18～\x04Ｆ］",
	}, { // 161
		mask: EncodeDoubleQuote | EncodeLeftSpace,
		in:   "#␠&Yρ\x15μ'␍γ ［ζ␃Ｕ,\x11␌！NＴχ␈-$\x18～\x04Ｆ］",
		out:  "#␠&Yρ\x15μ'␍γ ［ζ␃Ｕ,\x11␌！NＴχ␈-$\x18～\x04Ｆ］",
	}, { // 162
		mask: EncodeDoubleQuote | EncodeLeftSpace,
		in:   "# &Yρ\x15μ'␍γ ［ζ␃Ｕ,\x11␌！NＴχ␈-$\x18～\x04␠］",
		out:  "# &Yρ\x15μ'␍γ ［ζ␃Ｕ,\x11␌！NＴχ␈-$\x18～\x04␠］",
	}, { // 163
		mask: EncodeDoubleQuote | EncodeLeftSpace,
		in:   "#␠&Yρ\x15μ'␍γ ［ζ␃Ｕ,\x11␌！NＴχ␈-$\x18～\x04␠］",
		out:  "#␠&Yρ\x15μ'␍γ ［ζ␃Ｕ,\x11␌！NＴχ␈-$\x18～\x04␠］",
	}, { // 164
		mask: EncodeDoubleQuote | EncodeLeftSpace,
		in:   "# &Yρ\x15μ'␍γ ［ζ␃Ｕ,\x11␌！NＴχ␈-$\x18～\x04Ｆ␠",
		out:  "# &Yρ\x15μ'␍γ ［ζ␃Ｕ,\x11␌！NＴχ␈-$\x18～\x04Ｆ␠",
	}, { // 165
		mask: EncodeDoubleQuote | EncodeLeftSpace,
		in:   "#␠&Yρ\x15μ'␍γ ［ζ␃Ｕ,\x11␌！NＴχ␈-$\x18～\x04Ｆ␠",
		out:  "#␠&Yρ\x15μ'␍γ ［ζ␃Ｕ,\x11␌！NＴχ␈-$\x18～\x04Ｆ␠",
	}, { // 166
		mask: EncodeDoubleQuote | EncodeLeftSpace,
		in:   "#［&Yρ\x15μ'␍γ ［ζ␃Ｕ,\x11␌！NＴχ␈-$\x18～\x04 ］",
		out:  "#［&Yρ\x15μ'␍γ ［ζ␃Ｕ,\x11␌！NＴχ␈-$\x18～\x04 ］",
	}, { // 167
		mask: EncodeDoubleQuote | EncodeLeftSpace,
		in:   "#［&Yρ\x15μ'␍γ ［ζ␃Ｕ,\x11␌！NＴχ␈-$\x18～\x04␠］",
		out:  "#［&Yρ\x15μ'␍γ ［ζ␃Ｕ,\x11␌！NＴχ␈-$\x18～\x04␠］",
	}, { // 168
		mask: EncodeDoubleQuote | EncodeLeftSpace,
		in:   "#［&Yρ\x15μ'␍γ ［ζ␃Ｕ,\x11␌！NＴχ␈-$\x18～\x04 ␠",
		out:  "#［&Yρ\x15μ'␍γ ［ζ␃Ｕ,\x11␌！NＴχ␈-$\x18～\x04 ␠",
	}, { // 169
		mask: EncodeDoubleQuote | EncodeLeftSpace,
		in:   "#［&Yρ\x15μ'␍γ ［ζ␃Ｕ,\x11␌！NＴχ␈-$\x18～\x04␠␠",
		out:  "#［&Yρ\x15μ'␍γ ［ζ␃Ｕ,\x11␌！NＴχ␈-$\x18～\x04␠␠",
	}, { // 170
		mask: EncodeDoubleQuote | EncodeLeftSpace,
		in:   "#［&Yρ\x15μ'␍γ ［ζ␃Ｕ,\x11␌！NＴχ␈-$\x18～\x04Ｆ ",
		out:  "#［&Yρ\x15μ'␍γ ［ζ␃Ｕ,\x11␌！NＴχ␈-$\x18～\x04Ｆ ",
	}, { // 171
		mask: EncodeDoubleQuote | EncodeLeftSpace,
		in:   "#［&Yρ\x15μ'␍γ ［ζ␃Ｕ,\x11␌！NＴχ␈-$\x18～\x04Ｆ␠",
		out:  "#［&Yρ\x15μ'␍γ ［ζ␃Ｕ,\x11␌！NＴχ␈-$\x18～\x04Ｆ␠",
	}, { // 172
		mask: EncodeColon | EncodeLeftSpace,
		in:   "J？Ｑ3DＴ=＞\x12\x13 εB/σωγ｝＞\n＄␕ｊ|αω<␐␌＜",
		out:  "J？Ｑ3DＴ=＞\x12\x13 εB/σωγ｝＞\n＄␕ｊ|αω<␐␌＜",
	}, { // 173
		mask: EncodeColon | EncodeLeftSpace,
		in:   " ␠Ｑ3DＴ=＞\x12\x13 εB/σωγ｝＞\n＄␕ｊ|αω<␐␌＜",
		out:  "␠␠Ｑ3DＴ=＞\x12\x13 εB/σωγ｝＞\n＄␕ｊ|αω<␐␌＜",
	}, { // 174
		mask: EncodeColon | EncodeLeftSpace,
		in:   "␠␠Ｑ3DＴ=＞\x12\x13 εB/σωγ｝＞\n＄␕ｊ|αω<␐␌＜",
		out:  "‛␠␠Ｑ3DＴ=＞\x12\x13 εB/σωγ｝＞\n＄␕ｊ|αω<␐␌＜",
	}, { // 175
		mask: EncodeColon | EncodeLeftSpace,
		in:   " ？Ｑ3DＴ=＞\x12\x13 εB/σωγ｝＞\n＄␕ｊ|αω<␐␠＜",
		out:  "␠？Ｑ3DＴ=＞\x12\x13 εB/σωγ｝＞\n＄␕ｊ|αω<␐␠＜",
	}, { // 176
		mask: EncodeColon | EncodeLeftSpace,
		in:   "␠？Ｑ3DＴ=＞\x12\x13 εB/σωγ｝＞\n＄␕ｊ|αω<␐␠＜",
		out:  "‛␠？Ｑ3DＴ=＞\x12\x13 εB/σωγ｝＞\n＄␕ｊ|αω<␐␠＜",
	}, { // 177
		mask: EncodeColon | EncodeLeftSpace,
		in:   " ？Ｑ3DＴ=＞\x12\x13 εB/σωγ｝＞\n＄␕ｊ|αω<␐␌␠",
		out:  "␠？Ｑ3DＴ=＞\x12\x13 εB/σωγ｝＞\n＄␕ｊ|αω<␐␌␠",
	}, { // 178
		mask: EncodeColon | EncodeLeftSpace,
		in:   "␠？Ｑ3DＴ=＞\x12\x13 εB/σωγ｝＞\n＄␕ｊ|αω<␐␌␠",
		out:  "‛␠？Ｑ3DＴ=＞\x12\x13 εB/σωγ｝＞\n＄␕ｊ|αω<␐␌␠",
	}, { // 179
		mask: EncodeColon | EncodeLeftSpace,
		in:   "J Ｑ3DＴ=＞\x12\x13 εB/σωγ｝＞\n＄␕ｊ|αω<␐␌＜",
		out:  "J Ｑ3DＴ=＞\x12\x13 εB/σωγ｝＞\n＄␕ｊ|αω<␐␌＜",
	}, { // 180
		mask: EncodeColon | EncodeLeftSpace,
		in:   "J␠Ｑ3DＴ=＞\x12\x13 εB/σωγ｝＞\n＄␕ｊ|αω<␐␌＜",
		out:  "J␠Ｑ3DＴ=＞\x12\x13 εB/σωγ｝＞\n＄␕ｊ|αω<␐␌＜",
	}, { // 181
		mask: EncodeColon | EncodeLeftSpace,
		in:   "J Ｑ3DＴ=＞\x12\x13 εB/σωγ｝＞\n＄␕ｊ|αω<␐␠＜",
		out:  "J Ｑ3DＴ=＞\x12\x13 εB/σωγ｝＞\n＄␕ｊ|αω<␐␠＜",
	}, { // 182
		mask: EncodeColon | EncodeLeftSpace,
		in:   "J␠Ｑ3DＴ=＞\x12\x13 εB/σωγ｝＞\n＄␕ｊ|αω<␐␠＜",
		out:  "J␠Ｑ3DＴ=＞\x12\x13 εB/σωγ｝＞\n＄␕ｊ|αω<␐␠＜",
	}, { // 183
		mask: EncodeColon | EncodeLeftSpace,
		in:   "J Ｑ3DＴ=＞\x12\x13 εB/σωγ｝＞\n＄␕ｊ|αω<␐␌␠",
		out:  "J Ｑ3DＴ=＞\x12\x13 εB/σωγ｝＞\n＄␕ｊ|αω<␐␌␠",
	}, { // 184
		mask: EncodeColon | EncodeLeftSpace,
		in:   "J␠Ｑ3DＴ=＞\x12\x13 εB/σωγ｝＞\n＄␕ｊ|αω<␐␌␠",
		out:  "J␠Ｑ3DＴ=＞\x12\x13 εB/σωγ｝＞\n＄␕ｊ|αω<␐␌␠",
	}, { // 185
		mask: EncodeColon | EncodeLeftSpace,
		in:   "J？Ｑ3DＴ=＞\x12\x13 εB/σωγ｝＞\n＄␕ｊ|αω<␐ ＜",
		out:  "J？Ｑ3DＴ=＞\x12\x13 εB/σωγ｝＞\n＄␕ｊ|αω<␐ ＜",
	}, { // 186
		mask: EncodeColon | EncodeLeftSpace,
		in:   "J？Ｑ3DＴ=＞\x12\x13 εB/σωγ｝＞\n＄␕ｊ|αω<␐␠＜",
		out:  "J？Ｑ3DＴ=＞\x12\x13 εB/σωγ｝＞\n＄␕ｊ|αω<␐␠＜",
	}, { // 187
		mask: EncodeColon | EncodeLeftSpace,
		in:   "J？Ｑ3DＴ=＞\x12\x13 εB/σωγ｝＞\n＄␕ｊ|αω<␐ ␠",
		out:  "J？Ｑ3DＴ=＞\x12\x13 εB/σωγ｝＞\n＄␕ｊ|αω<␐ ␠",
	}, { // 188
		mask: EncodeColon | EncodeLeftSpace,
		in:   "J？Ｑ3DＴ=＞\x12\x13 εB/σωγ｝＞\n＄␕ｊ|αω<␐␠␠",
		out:  "J？Ｑ3DＴ=＞\x12\x13 εB/σωγ｝＞\n＄␕ｊ|αω<␐␠␠",
	}, { // 189
		mask: EncodeColon | EncodeLeftSpace,
		in:   "J？Ｑ3DＴ=＞\x12\x13 εB/σωγ｝＞\n＄␕ｊ|αω<␐␌ ",
		out:  "J？Ｑ3DＴ=＞\x12\x13 εB/σωγ｝＞\n＄␕ｊ|αω<␐␌ ",
	}, { // 190
		mask: EncodeColon | EncodeLeftSpace,
		in:   "J？Ｑ3DＴ=＞\x12\x13 εB/σωγ｝＞\n＄␕ｊ|αω<␐␌␠",
		out:  "J？Ｑ3DＴ=＞\x12\x13 εB/σωγ｝＞\n＄␕ｊ|αω<␐␌␠",
	}, { // 191
		mask: EncodeQuestion | EncodeLeftSpace,
		in:   "γu４hχ{x␀｜ε \x1e\nｒ＼＞＋?α\x18␔xＮ␍C＄δπ\x1a\x11",
		out:  "γu４hχ{x‛␀｜ε \x1e\nｒ＼＞＋？α\x18␔xＮ␍C＄δπ\x1a\x11",
	}, { // 192
		mask: EncodeQuestion | EncodeLeftSpace,
		in:   " ␠４hχ{x␀｜ε \x1e\nｒ＼＞＋?α\x18␔xＮ␍C＄δπ\x1a\x11",
		out:  "␠␠４hχ{x‛␀｜ε \x1e\nｒ＼＞＋？α\x18␔xＮ␍C＄δπ\x1a\x11",
	}, { // 193
		mask: EncodeQuestion | EncodeLeftSpace,
		in:   "␠␠４hχ{x␀｜ε \x1e\nｒ＼＞＋?α\x18␔xＮ␍C＄δπ\x1a\x11",
		out:  "‛␠␠４hχ{x‛␀｜ε \x1e\nｒ＼＞＋？α\x18␔xＮ␍C＄δπ\x1a\x11",
	}, { // 194
		mask: EncodeQuestion | EncodeLeftSpace,
		in:   " u４hχ{x␀｜ε \x1e\nｒ＼＞＋?α\x18␔xＮ␍C＄δπ␠\x11",
		out:  "␠u４hχ{x‛␀｜ε \x1e\nｒ＼＞＋？α\x18␔xＮ␍C＄δπ␠\x11",
	}, { // 195
		mask: EncodeQuestion | EncodeLeftSpace,
		in:   "␠u４hχ{x␀｜ε \x1e\nｒ＼＞＋?α\x18␔xＮ␍C＄δπ␠\x11",
		out:  "‛␠u４hχ{x‛␀｜ε \x1e\nｒ＼＞＋？α\x18␔xＮ␍C＄δπ␠\x11",
	}, { // 196
		mask: EncodeQuestion | EncodeLeftSpace,
		in:   " u４hχ{x␀｜ε \x1e\nｒ＼＞＋?α\x18␔xＮ␍C＄δπ\x1a␠",
		out:  "␠u４hχ{x‛␀｜ε \x1e\nｒ＼＞＋？α\x18␔xＮ␍C＄δπ\x1a␠",
	}, { // 197
		mask: EncodeQuestion | EncodeLeftSpace,
		in:   "␠u４hχ{x␀｜ε \x1e\nｒ＼＞＋?α\x18␔xＮ␍C＄δπ\x1a␠",
		out:  "‛␠u４hχ{x‛␀｜ε \x1e\nｒ＼＞＋？α\x18␔xＮ␍C＄δπ\x1a␠",
	}, { // 198
		mask: EncodeQuestion | EncodeLeftSpace,
		in:   "γ ４hχ{x␀｜ε \x1e\nｒ＼＞＋?α\x18␔xＮ␍C＄δπ\x1a\x11",
		out:  "γ ４hχ{x‛␀｜ε \x1e\nｒ＼＞＋？α\x18␔xＮ␍C＄δπ\x1a\x11",
	}, { // 199
		mask: EncodeQuestion | EncodeLeftSpace,
		in:   "γ␠４hχ{x␀｜ε \x1e\nｒ＼＞＋?α\x18␔xＮ␍C＄δπ\x1a\x11",
		out:  "γ␠４hχ{x‛␀｜ε \x1e\nｒ＼＞＋？α\x18␔xＮ␍C＄δπ\x1a\x11",
	}, { // 200
		mask: EncodeQuestion | EncodeLeftSpace,
		in:   "γ ４hχ{x␀｜ε \x1e\nｒ＼＞＋?α\x18␔xＮ␍C＄δπ␠\x11",
		out:  "γ ４hχ{x‛␀｜ε \x1e\nｒ＼＞＋？α\x18␔xＮ␍C＄δπ␠\x11",
	}, { // 201
		mask: EncodeQuestion | EncodeLeftSpace,
		in:   "γ␠４hχ{x␀｜ε \x1e\nｒ＼＞＋?α\x18␔xＮ␍C＄δπ␠\x11",
		out:  "γ␠４hχ{x‛␀｜ε \x1e\nｒ＼＞＋？α\x18␔xＮ␍C＄δπ␠\x11",
	}, { // 202
		mask: EncodeQuestion | EncodeLeftSpace,
		in:   "γ ４hχ{x␀｜ε \x1e\nｒ＼＞＋?α\x18␔xＮ␍C＄δπ\x1a␠",
		out:  "γ ４hχ{x‛␀｜ε \x1e\nｒ＼＞＋？α\x18␔xＮ␍C＄δπ\x1a␠",
	}, { // 203
		mask: EncodeQuestion | EncodeLeftSpace,
		in:   "γ␠４hχ{x␀｜ε \x1e\nｒ＼＞＋?α\x18␔xＮ␍C＄δπ\x1a␠",
		out:  "γ␠４hχ{x‛␀｜ε \x1e\nｒ＼＞＋？α\x18␔xＮ␍C＄δπ\x1a␠",
	}, { // 204
		mask: EncodeQuestion | EncodeLeftSpace,
		in:   "γu４hχ{x␀｜ε \x1e\nｒ＼＞＋?α\x18␔xＮ␍C＄δπ \x11",
		out:  "γu４hχ{x‛␀｜ε \x1e\nｒ＼＞＋？α\x18␔xＮ␍C＄δπ \x11",
	}, { // 205
		mask: EncodeQuestion | EncodeLeftSpace,
		in:   "γu４hχ{x␀｜ε \x1e\nｒ＼＞＋?α\x18␔xＮ␍C＄δπ␠\x11",
		out:  "γu４hχ{x‛␀｜ε \x1e\nｒ＼＞＋？α\x18␔xＮ␍C＄δπ␠\x11",
	}, { // 206
		mask: EncodeQuestion | EncodeLeftSpace,
		in:   "γu４hχ{x␀｜ε \x1e\nｒ＼＞＋?α\x18␔xＮ␍C＄δπ ␠",
		out:  "γu４hχ{x‛␀｜ε \x1e\nｒ＼＞＋？α\x18␔xＮ␍C＄δπ ␠",
	}, { // 207
		mask: EncodeQuestion | EncodeLeftSpace,
		in:   "γu４hχ{x␀｜ε \x1e\nｒ＼＞＋?α\x18␔xＮ␍C＄δπ␠␠",
		out:  "γu４hχ{x‛␀｜ε \x1e\nｒ＼＞＋？α\x18␔xＮ␍C＄δπ␠␠",
	}, { // 208
		mask: EncodeQuestion | EncodeLeftSpace,
		in:   "γu４hχ{x␀｜ε \x1e\nｒ＼＞＋?α\x18␔xＮ␍C＄δπ\x1a ",
		out:  "γu４hχ{x‛␀｜ε \x1e\nｒ＼＞＋？α\x18␔xＮ␍C＄δπ\x1a ",
	}, { // 209
		mask: EncodeQuestion | EncodeLeftSpace,
		in:   "γu４hχ{x␀｜ε \x1e\nｒ＼＞＋?α\x18␔xＮ␍C＄δπ\x1a␠",
		out:  "γu４hχ{x‛␀｜ε \x1e\nｒ＼＞＋？α\x18␔xＮ␍C＄δπ\x1a␠",
	}, { // 210
		mask: EncodeAsterisk | EncodeLeftSpace,
		in:   "\t＇Ｄ␘ｖ[μｖψ\x00 ;6ｇο\x1c＊／␌`ρX&Ｄwζ\uff00β}|",
		out:  "\t＇Ｄ␘ｖ[μｖψ␀ ;6ｇο\x1c‛＊／␌`ρX&Ｄwζ\uff00β}|",
	}, { // 211
		mask: EncodeAsterisk | EncodeLeftSpace,
		in:   " ␠Ｄ␘ｖ[μｖψ\x00 ;6ｇο\x1c＊／␌`ρX&Ｄwζ\uff00β}|",
		out:  "␠␠Ｄ␘ｖ[μｖψ␀ ;6ｇο\x1c‛＊／␌`ρX&Ｄwζ\uff00β}|",
	}, { // 212
		mask: EncodeAsterisk | EncodeLeftSpace,
		in:   "␠␠Ｄ␘ｖ[μｖψ\x00 ;6ｇο\x1c＊／␌`ρX&Ｄwζ\uff00β}|",
		out:  "‛␠␠Ｄ␘ｖ[μｖψ␀ ;6ｇο\x1c‛＊／␌`ρX&Ｄwζ\uff00β}|",
	}, { // 213
		mask: EncodeAsterisk | EncodeLeftSpace,
		in:   " ＇Ｄ␘ｖ[μｖψ\x00 ;6ｇο\x1c＊／␌`ρX&Ｄwζ\uff00β␠|",
		out:  "␠＇Ｄ␘ｖ[μｖψ␀ ;6ｇο\x1c‛＊／␌`ρX&Ｄwζ\uff00β␠|",
	}, { // 214
		mask: EncodeAsterisk | EncodeLeftSpace,
		in:   "␠＇Ｄ␘ｖ[μｖψ\x00 ;6ｇο\x1c＊／␌`ρX&Ｄwζ\uff00β␠|",
		out:  "‛␠＇Ｄ␘ｖ[μｖψ␀ ;6ｇο\x1c‛＊／␌`ρX&Ｄwζ\uff00β␠|",
	}, { // 215
		mask: EncodeAsterisk | EncodeLeftSpace,
		in:   " ＇Ｄ␘ｖ[μｖψ\x00 ;6ｇο\x1c＊／␌`ρX&Ｄwζ\uff00β}␠",
		out:  "␠＇Ｄ␘ｖ[μｖψ␀ ;6ｇο\x1c‛＊／␌`ρX&Ｄwζ\uff00β}␠",
	}, { // 216
		mask: EncodeAsterisk | EncodeLeftSpace,
		in:   "␠＇Ｄ␘ｖ[μｖψ\x00 ;6ｇο\x1c＊／␌`ρX&Ｄwζ\uff00β}␠",
		out:  "‛␠＇Ｄ␘ｖ[μｖψ␀ ;6ｇο\x1c‛＊／␌`ρX&Ｄwζ\uff00β}␠",
	}, { // 217
		mask: EncodeAsterisk | EncodeLeftSpace,
		in:   "\t Ｄ␘ｖ[μｖψ\x00 ;6ｇο\x1c＊／␌`ρX&Ｄwζ\uff00β}|",
		out:  "\t Ｄ␘ｖ[μｖψ␀ ;6ｇο\x1c‛＊／␌`ρX&Ｄwζ\uff00β}|",
	}, { // 218
		mask: EncodeAsterisk | EncodeLeftSpace,
		in:   "\t␠Ｄ␘ｖ[μｖψ\x00 ;6ｇο\x1c＊／␌`ρX&Ｄwζ\uff00β}|",
		out:  "\t␠Ｄ␘ｖ[μｖψ␀ ;6ｇο\x1c‛＊／␌`ρX&Ｄwζ\uff00β}|",
	}, { // 219
		mask: EncodeAsterisk | EncodeLeftSpace,
		in:   "\t Ｄ␘ｖ[μｖψ\x00 ;6ｇο\x1c＊／␌`ρX&Ｄwζ\uff00β␠|",
		out:  "\t Ｄ␘ｖ[μｖψ␀ ;6ｇο\x1c‛＊／␌`ρX&Ｄwζ\uff00β␠|",
	}, { // 220
		mask: EncodeAsterisk | EncodeLeftSpace,
		in:   "\t␠Ｄ␘ｖ[μｖψ\x00 ;6ｇο\x1c＊／␌`ρX&Ｄwζ\uff00β␠|",
		out:  "\t␠Ｄ␘ｖ[μｖψ␀ ;6ｇο\x1c‛＊／␌`ρX&Ｄwζ\uff00β␠|",
	}, { // 221
		mask: EncodeAsterisk | EncodeLeftSpace,
		in:   "\t Ｄ␘ｖ[μｖψ\x00 ;6ｇο\x1c＊／␌`ρX&Ｄwζ\uff00β}␠",
		out:  "\t Ｄ␘ｖ[μｖψ␀ ;6ｇο\x1c‛＊／␌`ρX&Ｄwζ\uff00β}␠",
	}, { // 222
		mask: EncodeAsterisk | EncodeLeftSpace,
		in:   "\t␠Ｄ␘ｖ[μｖψ\x00 ;6ｇο\x1c＊／␌`ρX&Ｄwζ\uff00β}␠",
		out:  "\t␠Ｄ␘ｖ[μｖψ␀ ;6ｇο\x1c‛＊／␌`ρX&Ｄwζ\uff00β}␠",
	}, { // 223
		mask: EncodeAsterisk | EncodeLeftSpace,
		in:   "\t＇Ｄ␘ｖ[μｖψ\x00 ;6ｇο\x1c＊／␌`ρX&Ｄwζ\uff00β |",
		out:  "\t＇Ｄ␘ｖ[μｖψ␀ ;6ｇο\x1c‛＊／␌`ρX&Ｄwζ\uff00β |",
	}, { // 224
		mask: EncodeAsterisk | EncodeLeftSpace,
		in:   "\t＇Ｄ␘ｖ[μｖψ\x00 ;6ｇο\x1c＊／␌`ρX&Ｄwζ\uff00β␠|",
		out:  "\t＇Ｄ␘ｖ[μｖψ␀ ;6ｇο\x1c‛＊／␌`ρX&Ｄwζ\uff00β␠|",
	}, { // 225
		mask: EncodeAsterisk | EncodeLeftSpace,
		in:   "\t＇Ｄ␘ｖ[μｖψ\x00 ;6ｇο\x1c＊／␌`ρX&Ｄwζ\uff00β ␠",
		out:  "\t＇Ｄ␘ｖ[μｖψ␀ ;6ｇο\x1c‛＊／␌`ρX&Ｄwζ\uff00β ␠",
	}, { // 226
		mask: EncodeAsterisk | EncodeLeftSpace,
		in:   "\t＇Ｄ␘ｖ[μｖψ\x00 ;6ｇο\x1c＊／␌`ρX&Ｄwζ\uff00β␠␠",
		out:  "\t＇Ｄ␘ｖ[μｖψ␀ ;6ｇο\x1c‛＊／␌`ρX&Ｄwζ\uff00β␠␠",
	}, { // 227
		mask: EncodeAsterisk | EncodeLeftSpace,
		in:   "\t＇Ｄ␘ｖ[μｖψ\x00 ;6ｇο\x1c＊／␌`ρX&Ｄwζ\uff00β} ",
		out:  "\t＇Ｄ␘ｖ[μｖψ␀ ;6ｇο\x1c‛＊／␌`ρX&Ｄwζ\uff00β} ",
	}, { // 228
		mask: EncodeAsterisk | EncodeLeftSpace,
		in:   "\t＇Ｄ␘ｖ[μｖψ\x00 ;6ｇο\x1c＊／␌`ρX&Ｄwζ\uff00β}␠",
		out:  "\t＇Ｄ␘ｖ[μｖψ␀ ;6ｇο\x1c‛＊／␌`ρX&Ｄwζ\uff00β}␠",
	}, { // 229
		mask: EncodePipe | EncodeLeftSpace,
		in:   "３w\x1e␏uＰοτμ= Ｘ＄␒<$(␊>\x11\r\x17/／ｄο！］φ␆",
		out:  "３w\x1e␏uＰοτμ= Ｘ＄␒<$(␊>\x11\r\x17/／ｄο！］φ␆",
	}, { // 230
		mask: EncodePipe | EncodeLeftSpace,
		in:   " ␠\x1e␏uＰοτμ= Ｘ＄␒<$(␊>\x11\r\x17/／ｄο！］φ␆",
		out:  "␠␠\x1e␏uＰοτμ= Ｘ＄␒<$(␊>\x11\r\x17/／ｄο！］φ␆",
	}, { // 231
		mask: EncodePipe | EncodeLeftSpace,
		in:   "␠␠\x1e␏uＰοτμ= Ｘ＄␒<$(␊>\x11\r\x17/／ｄο！］φ␆",
		out:  "‛␠␠\x1e␏uＰοτμ= Ｘ＄␒<$(␊>\x11\r\x17/／ｄο！］φ␆",
	}, { // 232
		mask: EncodePipe | EncodeLeftSpace,
		in:   " w\x1e␏uＰοτμ= Ｘ＄␒<$(␊>\x11\r\x17/／ｄο！］␠␆",
		out:  "␠w\x1e␏uＰοτμ= Ｘ＄␒<$(␊>\x11\r\x17/／ｄο！］␠␆",
	}, { // 233
		mask: EncodePipe | EncodeLeftSpace,
		in:   "␠w\x1e␏uＰοτμ= Ｘ＄␒<$(␊>\x11\r\x17/／ｄο！］␠␆",
		out:  "‛␠w\x1e␏uＰοτμ= Ｘ＄␒<$(␊>\x11\r\x17/／ｄο！］␠␆",
	}, { // 234
		mask: EncodePipe | EncodeLeftSpace,
		in:   " w\x1e␏uＰοτμ= Ｘ＄␒<$(␊>\x11\r\x17/／ｄο！］φ␠",
		out:  "␠w\x1e␏uＰοτμ= Ｘ＄␒<$(␊>\x11\r\x17/／ｄο！］φ␠",
	}, { // 235
		mask: EncodePipe | EncodeLeftSpace,
		in:   "␠w\x1e␏uＰοτμ= Ｘ＄␒<$(␊>\x11\r\x17/／ｄο！］φ␠",
		out:  "‛␠w\x1e␏uＰοτμ= Ｘ＄␒<$(␊>\x11\r\x17/／ｄο！］φ␠",
	}, { // 236
		mask: EncodePipe | EncodeLeftSpace,
		in:   "３ \x1e␏uＰοτμ= Ｘ＄␒<$(␊>\x11\r\x17/／ｄο！］φ␆",
		out:  "３ \x1e␏uＰοτμ= Ｘ＄␒<$(␊>\x11\r\x17/／ｄο！］φ␆",
	}, { // 237
		mask: EncodePipe | EncodeLeftSpace,
		in:   "３␠\x1e␏uＰοτμ= Ｘ＄␒<$(␊>\x11\r\x17/／ｄο！］φ␆",
		out:  "３␠\x1e␏uＰοτμ= Ｘ＄␒<$(␊>\x11\r\x17/／ｄο！］φ␆",
	}, { // 238
		mask: EncodePipe | EncodeLeftSpace,
		in:   "３ \x1e␏uＰοτμ= Ｘ＄␒<$(␊>\x11\r\x17/／ｄο！］␠␆",
		out:  "３ \x1e␏uＰοτμ= Ｘ＄␒<$(␊>\x11\r\x17/／ｄο！］␠␆",
	}, { // 239
		mask: EncodePipe | EncodeLeftSpace,
		in:   "３␠\x1e␏uＰοτμ= Ｘ＄␒<$(␊>\x11\r\x17/／ｄο！］␠␆",
		out:  "３␠\x1e␏uＰοτμ= Ｘ＄␒<$(␊>\x11\r\x17/／ｄο！］␠␆",
	}, { // 240
		mask: EncodePipe | EncodeLeftSpace,
		in:   "３ \x1e␏uＰοτμ= Ｘ＄␒<$(␊>\x11\r\x17/／ｄο！］φ␠",
		out:  "３ \x1e␏uＰοτμ= Ｘ＄␒<$(␊>\x11\r\x17/／ｄο！］φ␠",
	}, { // 241
		mask: EncodePipe | EncodeLeftSpace,
		in:   "３␠\x1e␏uＰοτμ= Ｘ＄␒<$(␊>\x11\r\x17/／ｄο！］φ␠",
		out:  "３␠\x1e␏uＰοτμ= Ｘ＄␒<$(␊>\x11\r\x17/／ｄο！］φ␠",
	}, { // 242
		mask: EncodePipe | EncodeLeftSpace,
		in:   "３w\x1e␏uＰοτμ= Ｘ＄␒<$(␊>\x11\r\x17/／ｄο！］ ␆",
		out:  "３w\x1e␏uＰοτμ= Ｘ＄␒<$(␊>\x11\r\x17/／ｄο！］ ␆",
	}, { // 243
		mask: EncodePipe | EncodeLeftSpace,
		in:   "３w\x1e␏uＰοτμ= Ｘ＄␒<$(␊>\x11\r\x17/／ｄο！］␠␆",
		out:  "３w\x1e␏uＰοτμ= Ｘ＄␒<$(␊>\x11\r\x17/／ｄο！］␠␆",
	}, { // 244
		mask: EncodePipe | EncodeLeftSpace,
		in:   "３w\x1e␏uＰοτμ= Ｘ＄␒<$(␊>\x11\r\x17/／ｄο！］ ␠",
		out:  "３w\x1e␏uＰοτμ= Ｘ＄␒<$(␊>\x11\r\x17/／ｄο！］ ␠",
	}, { // 245
		mask: EncodePipe | EncodeLeftSpace,
		in:   "３w\x1e␏uＰοτμ= Ｘ＄␒<$(␊>\x11\r\x17/／ｄο！］␠␠",
		out:  "３w\x1e␏uＰοτμ= Ｘ＄␒<$(␊>\x11\r\x17/／ｄο！］␠␠",
	}, { // 246
		mask: EncodePipe | EncodeLeftSpace,
		in:   "３w\x1e␏uＰοτμ= Ｘ＄␒<$(␊>\x11\r\x17/／ｄο！］φ ",
		out:  "３w\x1e␏uＰοτμ= Ｘ＄␒<$(␊>\x11\r\x17/／ｄο！］φ ",
	}, { // 247
		mask: EncodePipe | EncodeLeftSpace,
		in:   "３w\x1e␏uＰοτμ= Ｘ＄␒<$(␊>\x11\r\x17/／ｄο！］φ␠",
		out:  "３w\x1e␏uＰοτμ= Ｘ＄␒<$(␊>\x11\r\x17/／ｄο！］φ␠",
	}, { // 248
		mask: EncodeHash | EncodeLeftSpace,
		in:   "S?\x06γＤψ：V＜y &.μn\x0f;␆ς\f＠ｈ［｝ι（␊～\nλ",
		out:  "S?\x06γＤψ：V＜y &.μn\x0f;␆ς\f＠ｈ［｝ι（␊～\nλ",
	}, { // 249
		mask: EncodeHash | EncodeLeftSpace,
		in:   " ␠\x06γＤψ：V＜y &.μn\x0f;␆ς\f＠ｈ［｝ι（␊～\nλ",
		out:  "␠␠\x06γＤψ：V＜y &.μn\x0f;␆ς\f＠ｈ［｝ι（␊～\nλ",
	}, { // 250
		mask: EncodeHash | EncodeLeftSpace,
		in:   "␠␠\x06γＤψ：V＜y &.μn\x0f;␆ς\f＠ｈ［｝ι（␊～\nλ",
		out:  "‛␠␠\x06γＤψ：V＜y &.μn\x0f;␆ς\f＠ｈ［｝ι（␊～\nλ",
	}, { // 251
		mask: EncodeHash | EncodeLeftSpace,
		in:   " ?\x06γＤψ：V＜y &.μn\x0f;␆ς\f＠ｈ［｝ι（␊～␠λ",
		out:  "␠?\x06γＤψ：V＜y &.μn\x0f;␆ς\f＠ｈ［｝ι（␊～␠λ",
	}, { // 252
		mask: EncodeHash | EncodeLeftSpace,
		in:   "␠?\x06γＤψ：V＜y &.μn\x0f;␆ς\f＠ｈ［｝ι（␊～␠λ",
		out:  "‛␠?\x06γＤψ：V＜y &.μn\x0f;␆ς\f＠ｈ［｝ι（␊～␠λ",
	}, { // 253
		mask: EncodeHash | EncodeLeftSpace,
		in:   " ?\x06γＤψ：V＜y &.μn\x0f;␆ς\f＠ｈ［｝ι（␊～\n␠",
		out:  "␠?\x06γＤψ：V＜y &.μn\x0f;␆ς\f＠ｈ［｝ι（␊～\n␠",
	}, { // 254
		mask: EncodeHash | EncodeLeftSpace,
		in:   "␠?\x06γＤψ：V＜y &.μn\x0f;␆ς\f＠ｈ［｝ι（␊～\n␠",
		out:  "‛␠?\x06γＤψ：V＜y &.μn\x0f;␆ς\f＠ｈ［｝ι（␊～\n␠",
	}, { // 255
		mask: EncodeHash | EncodeLeftSpace,
		in:   "S \x06γＤψ：V＜y &.μn\x0f;␆ς\f＠ｈ［｝ι（␊～\nλ",
		out:  "S \x06γＤψ：V＜y &.μn\x0f;␆ς\f＠ｈ［｝ι（␊～\nλ",
	}, { // 256
		mask: EncodeHash | EncodeLeftSpace,
		in:   "S␠\x06γＤψ：V＜y &.μn\x0f;␆ς\f＠ｈ［｝ι（␊～\nλ",
		out:  "S␠\x06γＤψ：V＜y &.μn\x0f;␆ς\f＠ｈ［｝ι（␊～\nλ",
	}, { // 257
		mask: EncodeHash | EncodeLeftSpace,
		in:   "S \x06γＤψ：V＜y &.μn\x0f;␆ς\f＠ｈ［｝ι（␊～␠λ",
		out:  "S \x06γＤψ：V＜y &.μn\x0f;␆ς\f＠ｈ［｝ι（␊～␠λ",
	}, { // 258
		mask: EncodeHash | EncodeLeftSpace,
		in:   "S␠\x06γＤψ：V＜y &.μn\x0f;␆ς\f＠ｈ［｝ι（␊～␠λ",
		out:  "S␠\x06γＤψ：V＜y &.μn\x0f;␆ς\f＠ｈ［｝ι（␊～␠λ",
	}, { // 259
		mask: EncodeHash | EncodeLeftSpace,
		in:   "S \x06γＤψ：V＜y &.μn\x0f;␆ς\f＠ｈ［｝ι（␊～\n␠",
		out:  "S \x06γＤψ：V＜y &.μn\x0f;␆ς\f＠ｈ［｝ι（␊～\n␠",
	}, { // 260
		mask: EncodeHash | EncodeLeftSpace,
		in:   "S␠\x06γＤψ：V＜y &.μn\x0f;␆ς\f＠ｈ［｝ι（␊～\n␠",
		out:  "S␠\x06γＤψ：V＜y &.μn\x0f;␆ς\f＠ｈ［｝ι（␊～\n␠",
	}, { // 261
		mask: EncodeHash | EncodeLeftSpace,
		in:   "S?\x06γＤψ：V＜y &.μn\x0f;␆ς\f＠ｈ［｝ι（␊～ λ",
		out:  "S?\x06γＤψ：V＜y &.μn\x0f;␆ς\f＠ｈ［｝ι（␊～ λ",
	}, { // 262
		mask: EncodeHash | EncodeLeftSpace,
		in:   "S?\x06γＤψ：V＜y &.μn\x0f;␆ς\f＠ｈ［｝ι（␊～␠λ",
		out:  "S?\x06γＤψ：V＜y &.μn\x0f;␆ς\f＠ｈ［｝ι（␊～␠λ",
	}, { // 263
		mask: EncodeHash | EncodeLeftSpace,
		in:   "S?\x06γＤψ：V＜y &.μn\x0f;␆ς\f＠ｈ［｝ι（␊～ ␠",
		out:  "S?\x06γＤψ：V＜y &.μn\x0f;␆ς\f＠ｈ［｝ι（␊～ ␠",
	}, { // 264
		mask: EncodeHash | EncodeLeftSpace,
		in:   "S?\x06γＤψ：V＜y &.μn\x0f;␆ς\f＠ｈ［｝ι（␊～␠␠",
		out:  "S?\x06γＤψ：V＜y &.μn\x0f;␆ς\f＠ｈ［｝ι（␊～␠␠",
	}, { // 265
		mask: EncodeHash | EncodeLeftSpace,
		in:   "S?\x06γＤψ：V＜y &.μn\x0f;␆ς\f＠ｈ［｝ι（␊～\n ",
		out:  "S?\x06γＤψ：V＜y &.μn\x0f;␆ς\f＠ｈ［｝ι（␊～\n ",
	}, { // 266
		mask: EncodeHash | EncodeLeftSpace,
		in:   "S?\x06γＤψ：V＜y &.μn\x0f;␆ς\f＠ｈ［｝ι（␊～\n␠",
		out:  "S?\x06γＤψ：V＜y &.μn\x0f;␆ς\f＠ｈ［｝ι（␊～\n␠",
	}, { // 267
		mask: EncodePercent | EncodeLeftSpace,
		in:   "␄>\x17：＇\x1aςgＲ\x14 ␘ςDρf␜>\x14τEＥκ\x19＼xρ␃＊␛",
		out:  "␄>\x17：＇\x1aςgＲ\x14 ␘ςDρf␜>\x14τEＥκ\x19＼xρ␃＊␛",
	}, { // 268
		mask: EncodePercent | EncodeLeftSpace,
		in:   " ␠\x17：＇\x1aςgＲ\x14 ␘ςDρf␜>\x14τEＥκ\x19＼xρ␃＊␛",
		out:  "␠␠\x17：＇\x1aςgＲ\x14 ␘ςDρf␜>\x14τEＥκ\x19＼xρ␃＊␛",
	}, { // 269
		mask: EncodePercent | EncodeLeftSpace,
		in:   "␠␠\x17：＇\x1aςgＲ\x14 ␘ςDρf␜>\x14τEＥκ\x19＼xρ␃＊␛",
		out:  "‛␠␠\x17：＇\x1aςgＲ\x14 ␘ςDρf␜>\x14τEＥκ\x19＼xρ␃＊␛",
	}, { // 270
		mask: EncodePercent | EncodeLeftSpace,
		in:   " >\x17：＇\x1aςgＲ\x14 ␘ςDρf␜>\x14τEＥκ\x19＼xρ␃␠␛",
		out:  "␠>\x17：＇\x1aςgＲ\x14 ␘ςDρf␜>\x14τEＥκ\x19＼xρ␃␠␛",
	}, { // 271
		mask: EncodePercent | EncodeLeftSpace,
		in:   "␠>\x17：＇\x1aςgＲ\x14 ␘ςDρf␜>\x14τEＥκ\x19＼xρ␃␠␛",
		out:  "‛␠>\x17：＇\x1aςgＲ\x14 ␘ςDρf␜>\x14τEＥκ\x19＼xρ␃␠␛",
	}, { // 272
		mask: EncodePercent | EncodeLeftSpace,
		in:   " >\x17：＇\x1aςgＲ\x14 ␘ςDρf␜>\x14τEＥκ\x19＼xρ␃＊␠",
		out:  "␠>\x17：＇\x1aςgＲ\x14 ␘ςDρf␜>\x14τEＥκ\x19＼xρ␃＊␠",
	}, { // 273
		mask: EncodePercent | EncodeLeftSpace,
		in:   "␠>\x17：＇\x1aςgＲ\x14 ␘ςDρf␜>\x14τEＥκ\x19＼xρ␃＊␠",
		out:  "‛␠>\x17：＇\x1aςgＲ\x14 ␘ςDρf␜>\x14τEＥκ\x19＼xρ␃＊␠",
	}, { // 274
		mask: EncodePercent | EncodeLeftSpace,
		in:   "␄ \x17：＇\x1aςgＲ\x14 ␘ςDρf␜>\x14τEＥκ\x19＼xρ␃＊␛",
		out:  "␄ \x17：＇\x1aςgＲ\x14 ␘ςDρf␜>\x14τEＥκ\x19＼xρ␃＊␛",
	}, { // 275
		mask: EncodePercent | EncodeLeftSpace,
		in:   "␄␠\x17：＇\x1aςgＲ\x14 ␘ςDρf␜>\x14τEＥκ\x19＼xρ␃＊␛",
		out:  "␄␠\x17：＇\x1aςgＲ\x14 ␘ςDρf␜>\x14τEＥκ\x19＼xρ␃＊␛",
	}, { // 276
		mask: EncodePercent | EncodeLeftSpace,
		in:   "␄ \x17：＇\x1aςgＲ\x14 ␘ςDρf␜>\x14τEＥκ\x19＼xρ␃␠␛",
		out:  "␄ \x17：＇\x1aςgＲ\x14 ␘ςDρf␜>\x14τEＥκ\x19＼xρ␃␠␛",
	}, { // 277
		mask: EncodePercent | EncodeLeftSpace,
		in:   "␄␠\x17：＇\x1aςgＲ\x14 ␘ςDρf␜>\x14τEＥκ\x19＼xρ␃␠␛",
		out:  "␄␠\x17：＇\x1aςgＲ\x14 ␘ςDρf␜>\x14τEＥκ\x19＼xρ␃␠␛",
	}, { // 278
		mask: EncodePercent | EncodeLeftSpace,
		in:   "␄ \x17：＇\x1aςgＲ\x14 ␘ςDρf␜>\x14τEＥκ\x19＼xρ␃＊␠",
		out:  "␄ \x17：＇\x1aςgＲ\x14 ␘ςDρf␜>\x14τEＥκ\x19＼xρ␃＊␠",
	}, { // 279
		mask: EncodePercent | EncodeLeftSpace,
		in:   "␄␠\x17：＇\x1aςgＲ\x14 ␘ςDρf␜>\x14τEＥκ\x19＼xρ␃＊␠",
		out:  "␄␠\x17：＇\x1aςgＲ\x14 ␘ςDρf␜>\x14τEＥκ\x19＼xρ␃＊␠",
	}, { // 280
		mask: EncodePercent | EncodeLeftSpace,
		in:   "␄>\x17：＇\x1aςgＲ\x14 ␘ςDρf␜>\x14τEＥκ\x19＼xρ␃ ␛",
		out:  "␄>\x17：＇\x1aςgＲ\x14 ␘ςDρf␜>\x14τEＥκ\x19＼xρ␃ ␛",
	}, { // 281
		mask: EncodePercent | EncodeLeftSpace,
		in:   "␄>\x17：＇\x1aςgＲ\x14 ␘ςDρf␜>\x14τEＥκ\x19＼xρ␃␠␛",
		out:  "␄>\x17：＇\x1aςgＲ\x14 ␘ςDρf␜>\x14τEＥκ\x19＼xρ␃␠␛",
	}, { // 282
		mask: EncodePercent | EncodeLeftSpace,
		in:   "␄>\x17：＇\x1aςgＲ\x14 ␘ςDρf␜>\x14τEＥκ\x19＼xρ␃ ␠",
		out:  "␄>\x17：＇\x1aςgＲ\x14 ␘ςDρf␜>\x14τEＥκ\x19＼xρ␃ ␠",
	}, { // 283
		mask: EncodePercent | EncodeLeftSpace,
		in:   "␄>\x17：＇\x1aςgＲ\x14 ␘ςDρf␜>\x14τEＥκ\x19＼xρ␃␠␠",
		out:  "␄>\x17：＇\x1aςgＲ\x14 ␘ςDρf␜>\x14τEＥκ\x19＼xρ␃␠␠",
	}, { // 284
		mask: EncodePercent | EncodeLeftSpace,
		in:   "␄>\x17：＇\x1aςgＲ\x14 ␘ςDρf␜>\x14τEＥκ\x19＼xρ␃＊ ",
		out:  "␄>\x17：＇\x1aςgＲ\x14 ␘ςDρf␜>\x14τEＥκ\x19＼xρ␃＊ ",
	}, { // 285
		mask: EncodePercent | EncodeLeftSpace,
		in:   "␄>\x17：＇\x1aςgＲ\x14 ␘ςDρf␜>\x14τEＥκ\x19＼xρ␃＊␠",
		out:  "␄>\x17：＇\x1aςgＲ\x14 ␘ςDρf␜>\x14τEＥκ\x19＼xρ␃＊␠",
	}, { // 286
		mask: EncodeBackSlash | EncodeLeftSpace,
		in:   "␖πＷσp\\μ<＇8 ξ\x0e4\x1f␐ｓ｛[&η］Ｌ\rχ␓␕\x0fI␉",
		out:  "␖πＷσp＼μ<＇8 ξ\x0e4\x1f␐ｓ｛[&η］Ｌ\rχ␓␕\x0fI␉",
	}, { // 287
		mask: EncodeBackSlash | EncodeLeftSpace,
		in:   " ␠Ｗσp\\μ<＇8 ξ\x0e4\x1f␐ｓ｛[&η］Ｌ\rχ␓␕\x0fI␉",
		out:  "␠␠Ｗσp＼μ<＇8 ξ\x0e4\x1f␐ｓ｛[&η］Ｌ\rχ␓␕\x0fI␉",
	}, { // 288
		mask: EncodeBackSlash | EncodeLeftSpace,
		in:   "␠␠Ｗσp\\μ<＇8 ξ\x0e4\x1f␐ｓ｛[&η］Ｌ\rχ␓␕\x0fI␉",
		out:  "‛␠␠Ｗσp＼μ<＇8 ξ\x0e4\x1f␐ｓ｛[&η］Ｌ\rχ␓␕\x0fI␉",
	}, { // 289
		mask: EncodeBackSlash | EncodeLeftSpace,
		in:   " πＷσp\\μ<＇8 ξ\x0e4\x1f␐ｓ｛[&η］Ｌ\rχ␓␕\x0f␠␉",
		out:  "␠πＷσp＼μ<＇8 ξ\x0e4\x1f␐ｓ｛[&η］Ｌ\rχ␓␕\x0f␠␉",
	}, { // 290
		mask: EncodeBackSlash | EncodeLeftSpace,
		in:   "␠πＷσp\\μ<＇8 ξ\x0e4\x1f␐ｓ｛[&η］Ｌ\rχ␓␕\x0f␠␉",
		out:  "‛␠πＷσp＼μ<＇8 ξ\x0e4\x1f␐ｓ｛[&η］Ｌ\rχ␓␕\x0f␠␉",
	}, { // 291
		mask: EncodeBackSlash | EncodeLeftSpace,
		in:   " πＷσp\\μ<＇8 ξ\x0e4\x1f␐ｓ｛[&η］Ｌ\rχ␓␕\x0fI␠",
		out:  "␠πＷσp＼μ<＇8 ξ\x0e4\x1f␐ｓ｛[&η］Ｌ\rχ␓␕\x0fI␠",
	}, { // 292
		mask: EncodeBackSlash | EncodeLeftSpace,
		in:   "␠πＷσp\\μ<＇8 ξ\x0e4\x1f␐ｓ｛[&η］Ｌ\rχ␓␕\x0fI␠",
		out:  "‛␠πＷσp＼μ<＇8 ξ\x0e4\x1f␐ｓ｛[&η］Ｌ\rχ␓␕\x0fI␠",
	}, { // 293
		mask: EncodeBackSlash | EncodeLeftSpace,
		in:   "␖ Ｗσp\\μ<＇8 ξ\x0e4\x1f␐ｓ｛[&η］Ｌ\rχ␓␕\x0fI␉",
		out:  "␖ Ｗσp＼μ<＇8 ξ\x0e4\x1f␐ｓ｛[&η］Ｌ\rχ␓␕\x0fI␉",
	}, { // 294
		mask: EncodeBackSlash | EncodeLeftSpace,
		in:   "␖␠Ｗσp\\μ<＇8 ξ\x0e4\x1f␐ｓ｛[&η］Ｌ\rχ␓␕\x0fI␉",
		out:  "␖␠Ｗσp＼μ<＇8 ξ\x0e4\x1f␐ｓ｛[&η］Ｌ\rχ␓␕\x0fI␉",
	}, { // 295
		mask: EncodeBackSlash | EncodeLeftSpace,
		in:   "␖ Ｗσp\\μ<＇8 ξ\x0e4\x1f␐ｓ｛[&η］Ｌ\rχ␓␕\x0f␠␉",
		out:  "␖ Ｗσp＼μ<＇8 ξ\x0e4\x1f␐ｓ｛[&η］Ｌ\rχ␓␕\x0f␠␉",
	}, { // 296
		mask: EncodeBackSlash | EncodeLeftSpace,
		in:   "␖␠Ｗσp\\μ<＇8 ξ\x0e4\x1f␐ｓ｛[&η］Ｌ\rχ␓␕\x0f␠␉",
		out:  "␖␠Ｗσp＼μ<＇8 ξ\x0e4\x1f␐ｓ｛[&η］Ｌ\rχ␓␕\x0f␠␉",
	}, { // 297
		mask: EncodeBackSlash | EncodeLeftSpace,
		in:   "␖ Ｗσp\\μ<＇8 ξ\x0e4\x1f␐ｓ｛[&η］Ｌ\rχ␓␕\x0fI␠",
		out:  "␖ Ｗσp＼μ<＇8 ξ\x0e4\x1f␐ｓ｛[&η］Ｌ\rχ␓␕\x0fI␠",
	}, { // 298
		mask: EncodeBackSlash | EncodeLeftSpace,
		in:   "␖␠Ｗσp\\μ<＇8 ξ\x0e4\x1f␐ｓ｛[&η］Ｌ\rχ␓␕\x0fI␠",
		out:  "␖␠Ｗσp＼μ<＇8 ξ\x0e4\x1f␐ｓ｛[&η］Ｌ\rχ␓␕\x0fI␠",
	}, { // 299
		mask: EncodeBackSlash | EncodeLeftSpace,
		in:   "␖πＷσp\\μ<＇8 ξ\x0e4\x1f␐ｓ｛[&η］Ｌ\rχ␓␕\x0f ␉",
		out:  "␖πＷσp＼μ<＇8 ξ\x0e4\x1f␐ｓ｛[&η］Ｌ\rχ␓␕\x0f ␉",
	}, { // 300
		mask: EncodeBackSlash | EncodeLeftSpace,
		in:   "␖πＷσp\\μ<＇8 ξ\x0e4\x1f␐ｓ｛[&η］Ｌ\rχ␓␕\x0f␠␉",
		out:  "␖πＷσp＼μ<＇8 ξ\x0e4\x1f␐ｓ｛[&η］Ｌ\rχ␓␕\x0f␠␉",
	}, { // 301
		mask: EncodeBackSlash | EncodeLeftSpace,
		in:   "␖πＷσp\\μ<＇8 ξ\x0e4\x1f␐ｓ｛[&η］Ｌ\rχ␓␕\x0f ␠",
		out:  "␖πＷσp＼μ<＇8 ξ\x0e4\x1f␐ｓ｛[&η］Ｌ\rχ␓␕\x0f ␠",
	}, { // 302
		mask: EncodeBackSlash | EncodeLeftSpace,
		in:   "␖πＷσp\\μ<＇8 ξ\x0e4\x1f␐ｓ｛[&η］Ｌ\rχ␓␕\x0f␠␠",
		out:  "␖πＷσp＼μ<＇8 ξ\x0e4\x1f␐ｓ｛[&η］Ｌ\rχ␓␕\x0f␠␠",
	}, { // 303
		mask: EncodeBackSlash | EncodeLeftSpace,
		in:   "␖πＷσp\\μ<＇8 ξ\x0e4\x1f␐ｓ｛[&η］Ｌ\rχ␓␕\x0fI ",
		out:  "␖πＷσp＼μ<＇8 ξ\x0e4\x1f␐ｓ｛[&η］Ｌ\rχ␓␕\x0fI ",
	}, { // 304
		mask: EncodeBackSlash | EncodeLeftSpace,
		in:   "␖πＷσp\\μ<＇8 ξ\x0e4\x1f␐ｓ｛[&η］Ｌ\rχ␓␕\x0fI␠",
		out:  "␖πＷσp＼μ<＇8 ξ\x0e4\x1f␐ｓ｛[&η］Ｌ\rχ␓␕\x0fI␠",
	}, { // 305
		mask: EncodeCrLf | EncodeLeftSpace,
		in:   "ω\x1d，３␉␐?｛/χ ?-^'␇δCο\x10ＡξＣηｂ／␓X␡M",
		out:  "ω\x1d，３␉␐?｛/χ ?-^'␇δCο\x10ＡξＣηｂ／␓X␡M",
	}, { // 306
		mask: EncodeCrLf | EncodeLeftSpace,
		in:   " ␠，３␉␐?｛/χ ?-^'␇δCο\x10ＡξＣηｂ／␓X␡M",
		out:  "␠␠，３␉␐?｛/χ ?-^'␇δCο\x10ＡξＣηｂ／␓X␡M",
	}, { // 307
		mask: EncodeCrLf | EncodeLeftSpace,
		in:   "␠␠，３␉␐?｛/χ ?-^'␇δCο\x10ＡξＣηｂ／␓X␡M",
		out:  "‛␠␠，３␉␐?｛/χ ?-^'␇δCο\x10ＡξＣηｂ／␓X␡M",
	}, { // 308
		mask: EncodeCrLf | EncodeLeftSpace,
		in:   " \x1d，３␉␐?｛/χ ?-^'␇δCο\x10ＡξＣηｂ／␓X␠M",
		out:  "␠\x1d，３␉␐?｛/χ ?-^'␇δCο\x10ＡξＣηｂ／␓X␠M",
	}, { // 309
		mask: EncodeCrLf | EncodeLeftSpace,
		in:   "␠\x1d，３␉␐?｛/χ ?-^'␇δCο\x10ＡξＣηｂ／␓X␠M",
		out:  "‛␠\x1d，３␉␐?｛/χ ?-^'␇δCο\x10ＡξＣηｂ／␓X␠M",
	}, { // 310
		mask: EncodeCrLf | EncodeLeftSpace,
		in:   " \x1d，３␉␐?｛/χ ?-^'␇δCο\x10ＡξＣηｂ／␓X␡␠",
		out:  "␠\x1d，３␉␐?｛/χ ?-^'␇δCο\x10ＡξＣηｂ／␓X␡␠",
	}, { // 311
		mask: EncodeCrLf | EncodeLeftSpace,
		in:   "␠\x1d，３␉␐?｛/χ ?-^'␇δCο\x10ＡξＣηｂ／␓X␡␠",
		out:  "‛␠\x1d，３␉␐?｛/χ ?-^'␇δCο\x10ＡξＣηｂ／␓X␡␠",
	}, { // 312
		mask: EncodeCrLf | EncodeLeftSpace,
		in:   "ω ，３␉␐?｛/χ ?-^'␇δCο\x10ＡξＣηｂ／␓X␡M",
		out:  "ω ，３␉␐?｛/χ ?-^'␇δCο\x10ＡξＣηｂ／␓X␡M",
	}, { // 313
		mask: EncodeCrLf | EncodeLeftSpace,
		in:   "ω␠，３␉␐?｛/χ ?-^'␇δCο\x10ＡξＣηｂ／␓X␡M",
		out:  "ω␠，３␉␐?｛/χ ?-^'␇δCο\x10ＡξＣηｂ／␓X␡M",
	}, { // 314
		mask: EncodeCrLf | EncodeLeftSpace,
		in:   "ω ，３␉␐?｛/χ ?-^'␇δCο\x10ＡξＣηｂ／␓X␠M",
		out:  "ω ，３␉␐?｛/χ ?-^'␇δCο\x10ＡξＣηｂ／␓X␠M",
	}, { // 315
		mask: EncodeCrLf | EncodeLeftSpace,
		in:   "ω␠，３␉␐?｛/χ ?-^'␇δCο\x10ＡξＣηｂ／␓X␠M",
		out:  "ω␠，３␉␐?｛/χ ?-^'␇δCο\x10ＡξＣηｂ／␓X␠M",
	}, { // 316
		mask: EncodeCrLf | EncodeLeftSpace,
		in:   "ω ，３␉␐?｛/χ ?-^'␇δCο\x10ＡξＣηｂ／␓X␡␠",
		out:  "ω ，３␉␐?｛/χ ?-^'␇δCο\x10ＡξＣηｂ／␓X␡␠",
	}, { // 317
		mask: EncodeCrLf | EncodeLeftSpace,
		in:   "ω␠，３␉␐?｛/χ ?-^'␇δCο\x10ＡξＣηｂ／␓X␡␠",
		out:  "ω␠，３␉␐?｛/χ ?-^'␇δCο\x10ＡξＣηｂ／␓X␡␠",
	}, { // 318
		mask: EncodeCrLf | EncodeLeftSpace,
		in:   "ω\x1d，３␉␐?｛/χ ?-^'␇δCο\x10ＡξＣηｂ／␓X M",
		out:  "ω\x1d，３␉␐?｛/χ ?-^'␇δCο\x10ＡξＣηｂ／␓X M",
	}, { // 319
		mask: EncodeCrLf | EncodeLeftSpace,
		in:   "ω\x1d，３␉␐?｛/χ ?-^'␇δCο\x10ＡξＣηｂ／␓X␠M",
		out:  "ω\x1d，３␉␐?｛/χ ?-^'␇δCο\x10ＡξＣηｂ／␓X␠M",
	}, { // 320
		mask: EncodeCrLf | EncodeLeftSpace,
		in:   "ω\x1d，３␉␐?｛/χ ?-^'␇δCο\x10ＡξＣηｂ／␓X ␠",
		out:  "ω\x1d，３␉␐?｛/χ ?-^'␇δCο\x10ＡξＣηｂ／␓X ␠",
	}, { // 321
		mask: EncodeCrLf | EncodeLeftSpace,
		in:   "ω\x1d，３␉␐?｛/χ ?-^'␇δCο\x10ＡξＣηｂ／␓X␠␠",
		out:  "ω\x1d，３␉␐?｛/χ ?-^'␇δCο\x10ＡξＣηｂ／␓X␠␠",
	}, { // 322
		mask: EncodeCrLf | EncodeLeftSpace,
		in:   "ω\x1d，３␉␐?｛/χ ?-^'␇δCο\x10ＡξＣηｂ／␓X␡ ",
		out:  "ω\x1d，３␉␐?｛/χ ?-^'␇δCο\x10ＡξＣηｂ／␓X␡ ",
	}, { // 323
		mask: EncodeCrLf | EncodeLeftSpace,
		in:   "ω\x1d，３␉␐?｛/χ ?-^'␇δCο\x10ＡξＣηｂ／␓X␡␠",
		out:  "ω\x1d，３␉␐?｛/χ ?-^'␇δCο\x10ＡξＣηｂ／␓X␡␠",
	}, { // 324
		mask: EncodeDel | EncodeLeftSpace,
		in:   "␀␗λBＩ\x12\nＥ]\x00 \x1c\x18␍)␜ψ３ντ␋^？,；\x11ν.Ｘ＊",
		out:  "‛␀␗λBＩ\x12\nＥ]␀ \x1c\x18␍)␜ψ３ντ␋^？,；\x11ν.Ｘ＊",
	}, { // 325
		mask: EncodeDel | EncodeLeftSpace,
		in:   " ␠λBＩ\x12\nＥ]\x00 \x1c\x18␍)␜ψ３ντ␋^？,；\x11ν.Ｘ＊",
		out:  "␠␠λBＩ\x12\nＥ]␀ \x1c\x18␍)␜ψ３ντ␋^？,；\x11ν.Ｘ＊",
	}, { // 326
		mask: EncodeDel | EncodeLeftSpace,
		in:   "␠␠λBＩ\x12\nＥ]\x00 \x1c\x18␍)␜ψ３ντ␋^？,；\x11ν.Ｘ＊",
		out:  "‛␠␠λBＩ\x12\nＥ]␀ \x1c\x18␍)␜ψ３ντ␋^？,；\x11ν.Ｘ＊",
	}, { // 327
		mask: EncodeDel | EncodeLeftSpace,
		in:   " ␗λBＩ\x12\nＥ]\x00 \x1c\x18␍)␜ψ３ντ␋^？,；\x11ν.␠＊",
		out:  "␠␗λBＩ\x12\nＥ]␀ \x1c\x18␍)␜ψ３ντ␋^？,；\x11ν.␠＊",
	}, { // 328
		mask: EncodeDel | EncodeLeftSpace,
		in:   "␠␗λBＩ\x12\nＥ]\x00 \x1c\x18␍)␜ψ３ντ␋^？,；\x11ν.␠＊",
		out:  "‛␠␗λBＩ\x12\nＥ]␀ \x1c\x18␍)␜ψ３ντ␋^？,；\x11ν.␠＊",
	}, { // 329
		mask: EncodeDel | EncodeLeftSpace,
		in:   " ␗λBＩ\x12\nＥ]\x00 \x1c\x18␍)␜ψ３ντ␋^？,；\x11ν.Ｘ␠",
		out:  "␠␗λBＩ\x12\nＥ]␀ \x1c\x18␍)␜ψ３ντ␋^？,；\x11ν.Ｘ␠",
	}, { // 330
		mask: EncodeDel | EncodeLeftSpace,
		in:   "␠␗λBＩ\x12\nＥ]\x00 \x1c\x18␍)␜ψ３ντ␋^？,；\x11ν.Ｘ␠",
		out:  "‛␠␗λBＩ\x12\nＥ]␀ \x1c\x18␍)␜ψ３ντ␋^？,；\x11ν.Ｘ␠",
	}, { // 331
		mask: EncodeDel | EncodeLeftSpace,
		in:   "␀ λBＩ\x12\nＥ]\x00 \x1c\x18␍)␜ψ３ντ␋^？,；\x11ν.Ｘ＊",
		out:  "‛␀ λBＩ\x12\nＥ]␀ \x1c\x18␍)␜ψ３ντ␋^？,；\x11ν.Ｘ＊",
	}, { // 332
		mask: EncodeDel | EncodeLeftSpace,
		in:   "␀␠λBＩ\x12\nＥ]\x00 \x1c\x18␍)␜ψ３ντ␋^？,；\x11ν.Ｘ＊",
		out:  "‛␀␠λBＩ\x12\nＥ]␀ \x1c\x18␍)␜ψ３ντ␋^？,；\x11ν.Ｘ＊",
	}, { // 333
		mask: EncodeDel | EncodeLeftSpace,
		in:   "␀ λBＩ\x12\nＥ]\x00 \x1c\x18␍)␜ψ３ντ␋^？,；\x11ν.␠＊",
		out:  "‛␀ λBＩ\x12\nＥ]␀ \x1c\x18␍)␜ψ３ντ␋^？,；\x11ν.␠＊",
	}, { // 334
		mask: EncodeDel | EncodeLeftSpace,
		in:   "␀␠λBＩ\x12\nＥ]\x00 \x1c\x18␍)␜ψ３ντ␋^？,；\x11ν.␠＊",
		out:  "‛␀␠λBＩ\x12\nＥ]␀ \x1c\x18␍)␜ψ３ντ␋^？,；\x11ν.␠＊",
	}, { // 335
		mask: EncodeDel | EncodeLeftSpace,
		in:   "␀ λBＩ\x12\nＥ]\x00 \x1c\x18␍)␜ψ３ντ␋^？,；\x11ν.Ｘ␠",
		out:  "‛␀ λBＩ\x12\nＥ]␀ \x1c\x18␍)␜ψ３ντ␋^？,；\x11ν.Ｘ␠",
	}, { // 336
		mask: EncodeDel | EncodeLeftSpace,
		in:   "␀␠λBＩ\x12\nＥ]\x00 \x1c\x18␍)␜ψ３ντ␋^？,；\x11ν.Ｘ␠",
		out:  "‛␀␠λBＩ\x12\nＥ]␀ \x1c\x18␍)␜ψ３ντ␋^？,；\x11ν.Ｘ␠",
	}, { // 337
		mask: EncodeDel | EncodeLeftSpace,
		in:   "␀␗λBＩ\x12\nＥ]\x00 \x1c\x18␍)␜ψ３ντ␋^？,；\x11ν. ＊",
		out:  "‛␀␗λBＩ\x12\nＥ]␀ \x1c\x18␍)␜ψ３ντ␋^？,；\x11ν. ＊",
	}, { // 338
		mask: EncodeDel | EncodeLeftSpace,
		in:   "␀␗λBＩ\x12\nＥ]\x00 \x1c\x18␍)␜ψ３ντ␋^？,；\x11ν.␠＊",
		out:  "‛␀␗λBＩ\x12\nＥ]␀ \x1c\x18␍)␜ψ３ντ␋^？,；\x11ν.␠＊",
	}, { // 339
		mask: EncodeDel | EncodeLeftSpace,
		in:   "␀␗λBＩ\x12\nＥ]\x00 \x1c\x18␍)␜ψ３ντ␋^？,；\x11ν. ␠",
		out:  "‛␀␗λBＩ\x12\nＥ]␀ \x1c\x18␍)␜ψ３ντ␋^？,；\x11ν. ␠",
	}, { // 340
		mask: EncodeDel | EncodeLeftSpace,
		in:   "␀␗λBＩ\x12\nＥ]\x00 \x1c\x18␍)␜ψ３ντ␋^？,；\x11ν.␠␠",
		out:  "‛␀␗λBＩ\x12\nＥ]␀ \x1c\x18␍)␜ψ３ντ␋^？,；\x11ν.␠␠",
	}, { // 341
		mask: EncodeDel | EncodeLeftSpace,
		in:   "␀␗λBＩ\x12\nＥ]\x00 \x1c\x18␍)␜ψ３ντ␋^？,；\x11ν.Ｘ ",
		out:  "‛␀␗λBＩ\x12\nＥ]␀ \x1c\x18␍)␜ψ３ντ␋^？,；\x11ν.Ｘ ",
	}, { // 342
		mask: EncodeDel | EncodeLeftSpace,
		in:   "␀␗λBＩ\x12\nＥ]\x00 \x1c\x18␍)␜ψ３ντ␋^？,；\x11ν.Ｘ␠",
		out:  "‛␀␗λBＩ\x12\nＥ]␀ \x1c\x18␍)␜ψ３ντ␋^？,；\x11ν.Ｘ␠",
	}, { // 343
		mask: EncodeCtl | EncodeLeftSpace,
		in:   "β\x0f$ψε\x1c)/／ｋ χｙ$\x12｜＼ο/ｉC7８？８\\␒␞ς／",
		out:  "β␏$ψε␜)/／ｋ χｙ$␒｜＼ο/ｉC7８？８\\‛␒‛␞ς／",
	}, { // 344
		mask: EncodeCtl | EncodeLeftSpace,
		in:   " ␠$ψε\x1c)/／ｋ χｙ$\x12｜＼ο/ｉC7８？８\\␒␞ς／",
		out:  "␠␠$ψε␜)/／ｋ χｙ$␒｜＼ο/ｉC7８？８\\‛␒‛␞ς／",
	}, { // 345
		mask: EncodeCtl | EncodeLeftSpace,
		in:   "␠␠$ψε\x1c)/／ｋ χｙ$\x12｜＼ο/ｉC7８？８\\␒␞ς／",
		out:  "‛␠␠$ψε␜)/／ｋ χｙ$␒｜＼ο/ｉC7８？８\\‛␒‛␞ς／",
	}, { // 346
		mask: EncodeCtl | EncodeLeftSpace,
		in:   " \x0f$ψε\x1c)/／ｋ χｙ$\x12｜＼ο/ｉC7８？８\\␒␞␠／",
		out:  "␠␏$ψε␜)/／ｋ χｙ$␒｜＼ο/ｉC7８？８\\‛␒‛␞␠／",
	}, { // 347
		mask: EncodeCtl | EncodeLeftSpace,
		in:   "␠\x0f$ψε\x1c)/／ｋ χｙ$\x12｜＼ο/ｉC7８？８\\␒␞␠／",
		out:  "‛␠␏$ψε␜)/／ｋ χｙ$␒｜＼ο/ｉC7８？８\\‛␒‛␞␠／",
	}, { // 348
		mask: EncodeCtl | EncodeLeftSpace,
		in:   " \x0f$ψε\x1c)/／ｋ χｙ$\x12｜＼ο/ｉC7８？８\\␒␞ς␠",
		out:  "␠␏$ψε␜)/／ｋ χｙ$␒｜＼ο/ｉC7８？８\\‛␒‛␞ς␠",
	}, { // 349
		mask: EncodeCtl | EncodeLeftSpace,
		in:   "␠\x0f$ψε\x1c)/／ｋ χｙ$\x12｜＼ο/ｉC7８？８\\␒␞ς␠",
		out:  "‛␠␏$ψε␜)/／ｋ χｙ$␒｜＼ο/ｉC7８？８\\‛␒‛␞ς␠",
	}, { // 350
		mask: EncodeCtl | EncodeLeftSpace,
		in:   "β $ψε\x1c)/／ｋ χｙ$\x12｜＼ο/ｉC7８？８\\␒␞ς／",
		out:  "β $ψε␜)/／ｋ χｙ$␒｜＼ο/ｉC7８？８\\‛␒‛␞ς／",
	}, { // 351
		mask: EncodeCtl | EncodeLeftSpace,
		in:   "β␠$ψε\x1c)/／ｋ χｙ$\x12｜＼ο/ｉC7８？８\\␒␞ς／",
		out:  "β␠$ψε␜)/／ｋ χｙ$␒｜＼ο/ｉC7８？８\\‛␒‛␞ς／",
	}, { // 352
		mask: EncodeCtl | EncodeLeftSpace,
		in:   "β $ψε\x1c)/／ｋ χｙ$\x12｜＼ο/ｉC7８？８\\␒␞␠／",
		out:  "β $ψε␜)/／ｋ χｙ$␒｜＼ο/ｉC7８？８\\‛␒‛␞␠／",
	}, { // 353
		mask: EncodeCtl | EncodeLeftSpace,
		in:   "β␠$ψε\x1c)/／ｋ χｙ$\x12｜＼ο/ｉC7８？８\\␒␞␠／",
		out:  "β␠$ψε␜)/／ｋ χｙ$␒｜＼ο/ｉC7８？８\\‛␒‛␞␠／",
	}, { // 354
		mask: EncodeCtl | EncodeLeftSpace,
		in:   "β $ψε\x1c)/／ｋ χｙ$\x12｜＼ο/ｉC7８？８\\␒␞ς␠",
		out:  "β $ψε␜)/／ｋ χｙ$␒｜＼ο/ｉC7８？８\\‛␒‛␞ς␠",
	}, { // 355
		mask: EncodeCtl | EncodeLeftSpace,
		in:   "β␠$ψε\x1c)/／ｋ χｙ$\x12｜＼ο/ｉC7８？８\\␒␞ς␠",
		out:  "β␠$ψε␜)/／ｋ χｙ$␒｜＼ο/ｉC7８？８\\‛␒‛␞ς␠",
	}, { // 356
		mask: EncodeCtl | EncodeLeftSpace,
		in:   "β\x0f$ψε\x1c)/／ｋ χｙ$\x12｜＼ο/ｉC7８？８\\␒␞ ／",
		out:  "β␏$ψε␜)/／ｋ χｙ$␒｜＼ο/ｉC7８？８\\‛␒‛␞ ／",
	}, { // 357
		mask: EncodeCtl | EncodeLeftSpace,
		in:   "β\x0f$ψε\x1c)/／ｋ χｙ$\x12｜＼ο/ｉC7８？８\\␒␞␠／",
		out:  "β␏$ψε␜)/／ｋ χｙ$␒｜＼ο/ｉC7８？８\\‛␒‛␞␠／",
	}, { // 358
		mask: EncodeCtl | EncodeLeftSpace,
		in:   "β\x0f$ψε\x1c)/／ｋ χｙ$\x12｜＼ο/ｉC7８？８\\␒␞ ␠",
		out:  "β␏$ψε␜)/／ｋ χｙ$␒｜＼ο/ｉC7８？８\\‛␒‛␞ ␠",
	}, { // 359
		mask: EncodeCtl | EncodeLeftSpace,
		in:   "β\x0f$ψε\x1c)/／ｋ χｙ$\x12｜＼ο/ｉC7８？８\\␒␞␠␠",
		out:  "β␏$ψε␜)/／ｋ χｙ$␒｜＼ο/ｉC7８？８\\‛␒‛␞␠␠",
	}, { // 360
		mask: EncodeCtl | EncodeLeftSpace,
		in:   "β\x0f$ψε\x1c)/／ｋ χｙ$\x12｜＼ο/ｉC7８？８\\␒␞ς ",
		out:  "β␏$ψε␜)/／ｋ χｙ$␒｜＼ο/ｉC7８？８\\‛␒‛␞ς ",
	}, { // 361
		mask: EncodeCtl | EncodeLeftSpace,
		in:   "β\x0f$ψε\x1c)/／ｋ χｙ$\x12｜＼ο/ｉC7８？８\\␒␞ς␠",
		out:  "β␏$ψε␜)/／ｋ χｙ$␒｜＼ο/ｉC7８？８\\‛␒‛␞ς␠",
	}, { // 362
		mask: EncodeLeftPeriod,
		in:   ".",
		out:  "．",
	}, { // 363
		mask: EncodeZero | EncodeLeftPeriod,
		in:   "␉␓h␊␉\x1a＿w\x19ζ.␀Ｋｍδ$t␂*θFＩμζο/\x06ｖｔo",
		out:  "␉␓h␊␉\x1a＿w\x19ζ.‛␀Ｋｍδ$t␂*θFＩμζο/\x06ｖｔo",
	}, { // 364
		mask: EncodeZero | EncodeLeftPeriod,
		in:   ".．h␊␉\x1a＿w\x19ζ.␀Ｋｍδ$t␂*θFＩμζο/\x06ｖｔo",
		out:  "．．h␊␉\x1a＿w\x19ζ.‛␀Ｋｍδ$t␂*θFＩμζο/\x06ｖｔo",
	}, { // 365
		mask: EncodeZero | EncodeLeftPeriod,
		in:   "．．h␊␉\x1a＿w\x19ζ.␀Ｋｍδ$t␂*θFＩμζο/\x06ｖｔo",
		out:  "‛．．h␊␉\x1a＿w\x19ζ.‛␀Ｋｍδ$t␂*θFＩμζο/\x06ｖｔo",
	}, { // 366
		mask: EncodeZero | EncodeLeftPeriod,
		in:   ".␓h␊␉\x1a＿w\x19ζ.␀Ｋｍδ$t␂*θFＩμζο/\x06ｖ．o",
		out:  "．␓h␊␉\x1a＿w\x19ζ.‛␀Ｋｍδ$t␂*θFＩμζο/\x06ｖ．o",
	}, { // 367
		mask: EncodeZero | EncodeLeftPeriod,
		in:   "．␓h␊␉\x1a＿w\x19ζ.␀Ｋｍδ$t␂*θFＩμζο/\x06ｖ．o",
		out:  "‛．␓h␊␉\x1a＿w\x19ζ.‛␀Ｋｍδ$t␂*θFＩμζο/\x06ｖ．o",
	}, { // 368
		mask: EncodeZero | EncodeLeftPeriod,
		in:   ".␓h␊␉\x1a＿w\x19ζ.␀Ｋｍδ$t␂*θFＩμζο/\x06ｖｔ．",
		out:  "．␓h␊␉\x1a＿w\x19ζ.‛␀Ｋｍδ$t␂*θFＩμζο/\x06ｖｔ．",
	}, { // 369
		mask: EncodeZero | EncodeLeftPeriod,
		in:   "．␓h␊␉\x1a＿w\x19ζ.␀Ｋｍδ$t␂*θFＩμζο/\x06ｖｔ．",
		out:  "‛．␓h␊␉\x1a＿w\x19ζ.‛␀Ｋｍδ$t␂*θFＩμζο/\x06ｖｔ．",
	}, { // 370
		mask: EncodeZero | EncodeLeftPeriod,
		in:   "␉.h␊␉\x1a＿w\x19ζ.␀Ｋｍδ$t␂*θFＩμζο/\x06ｖｔo",
		out:  "␉.h␊␉\x1a＿w\x19ζ.‛␀Ｋｍδ$t␂*θFＩμζο/\x06ｖｔo",
	}, { // 371
		mask: EncodeZero | EncodeLeftPeriod,
		in:   "␉．h␊␉\x1a＿w\x19ζ.␀Ｋｍδ$t␂*θFＩμζο/\x06ｖｔo",
		out:  "␉．h␊␉\x1a＿w\x19ζ.‛␀Ｋｍδ$t␂*θFＩμζο/\x06ｖｔo",
	}, { // 372
		mask: EncodeZero | EncodeLeftPeriod,
		in:   "␉.h␊␉\x1a＿w\x19ζ.␀Ｋｍδ$t␂*θFＩμζο/\x06ｖ．o",
		out:  "␉.h␊␉\x1a＿w\x19ζ.‛␀Ｋｍδ$t␂*θFＩμζο/\x06ｖ．o",
	}, { // 373
		mask: EncodeZero | EncodeLeftPeriod,
		in:   "␉．h␊␉\x1a＿w\x19ζ.␀Ｋｍδ$t␂*θFＩμζο/\x06ｖ．o",
		out:  "␉．h␊␉\x1a＿w\x19ζ.‛␀Ｋｍδ$t␂*θFＩμζο/\x06ｖ．o",
	}, { // 374
		mask: EncodeZero | EncodeLeftPeriod,
		in:   "␉.h␊␉\x1a＿w\x19ζ.␀Ｋｍδ$t␂*θFＩμζο/\x06ｖｔ．",
		out:  "␉.h␊␉\x1a＿w\x19ζ.‛␀Ｋｍδ$t␂*θFＩμζο/\x06ｖｔ．",
	}, { // 375
		mask: EncodeZero | EncodeLeftPeriod,
		in:   "␉．h␊␉\x1a＿w\x19ζ.␀Ｋｍδ$t␂*θFＩμζο/\x06ｖｔ．",
		out:  "␉．h␊␉\x1a＿w\x19ζ.‛␀Ｋｍδ$t␂*θFＩμζο/\x06ｖｔ．",
	}, { // 376
		mask: EncodeZero | EncodeLeftPeriod,
		in:   "␉␓h␊␉\x1a＿w\x19ζ.␀Ｋｍδ$t␂*θFＩμζο/\x06ｖ.o",
		out:  "␉␓h␊␉\x1a＿w\x19ζ.‛␀Ｋｍδ$t␂*θFＩμζο/\x06ｖ.o",
	}, { // 377
		mask: EncodeZero | EncodeLeftPeriod,
		in:   "␉␓h␊␉\x1a＿w\x19ζ.␀Ｋｍδ$t␂*θFＩμζο/\x06ｖ．o",
		out:  "␉␓h␊␉\x1a＿w\x19ζ.‛␀Ｋｍδ$t␂*θFＩμζο/\x06ｖ．o",
	}, { // 378
		mask: EncodeZero | EncodeLeftPeriod,
		in:   "␉␓h␊␉\x1a＿w\x19ζ.␀Ｋｍδ$t␂*θFＩμζο/\x06ｖ.．",
		out:  "␉␓h␊␉\x1a＿w\x19ζ.‛␀Ｋｍδ$t␂*θFＩμζο/\x06ｖ.．",
	}, { // 379
		mask: EncodeZero | EncodeLeftPeriod,
		in:   "␉␓h␊␉\x1a＿w\x19ζ.␀Ｋｍδ$t␂*θFＩμζο/\x06ｖ．．",
		out:  "␉␓h␊␉\x1a＿w\x19ζ.‛␀Ｋｍδ$t␂*θFＩμζο/\x06ｖ．．",
	}, { // 380
		mask: EncodeZero | EncodeLeftPeriod,
		in:   "␉␓h␊␉\x1a＿w\x19ζ.␀Ｋｍδ$t␂*θFＩμζο/\x06ｖｔ.",
		out:  "␉␓h␊␉\x1a＿w\x19ζ.‛␀Ｋｍδ$t␂*θFＩμζο/\x06ｖｔ.",
	}, { // 381
		mask: EncodeZero | EncodeLeftPeriod,
		in:   "␉␓h␊␉\x1a＿w\x19ζ.␀Ｋｍδ$t␂*θFＩμζο/\x06ｖｔ．",
		out:  "␉␓h␊␉\x1a＿w\x19ζ.‛␀Ｋｍδ$t␂*θFＩμζο/\x06ｖｔ．",
	}, { // 382
		mask: EncodeSlash | EncodeLeftPeriod,
		in:   ":ρ\x02OＸF␡\a２＄.ｃ2;υσ\v␍Ｂ＄+ψwσ＼Ｉ：\x03π9",
		out:  ":ρ\x02OＸF␡\a２＄.ｃ2;υσ\v␍Ｂ＄+ψwσ＼Ｉ：\x03π9",
	}, { // 383
		mask: EncodeSlash | EncodeLeftPeriod,
		in:   ".．\x02OＸF␡\a２＄.ｃ2;υσ\v␍Ｂ＄+ψwσ＼Ｉ：\x03π9",
		out:  "．．\x02OＸF␡\a２＄.ｃ2;υσ\v␍Ｂ＄+ψwσ＼Ｉ：\x03π9",
	}, { // 384
		mask: EncodeSlash | EncodeLeftPeriod,
		in:   "．．\x02OＸF␡\a２＄.ｃ2;υσ\v␍Ｂ＄+ψwσ＼Ｉ：\x03π9",
		out:  "‛．．\x02OＸF␡\a２＄.ｃ2;υσ\v␍Ｂ＄+ψwσ＼Ｉ：\x03π9",
	}, { // 385
		mask: EncodeSlash | EncodeLeftPeriod,
		in:   ".ρ\x02OＸF␡\a２＄.ｃ2;υσ\v␍Ｂ＄+ψwσ＼Ｉ：\x03．9",
		out:  "．ρ\x02OＸF␡\a２＄.ｃ2;υσ\v␍Ｂ＄+ψwσ＼Ｉ：\x03．9",
	}, { // 386
		mask: EncodeSlash | EncodeLeftPeriod,
		in:   "．ρ\x02OＸF␡\a２＄.ｃ2;υσ\v␍Ｂ＄+ψwσ＼Ｉ：\x03．9",
		out:  "‛．ρ\x02OＸF␡\a２＄.ｃ2;υσ\v␍Ｂ＄+ψwσ＼Ｉ：\x03．9",
	}, { // 387
		mask: EncodeSlash | EncodeLeftPeriod,
		in:   ".ρ\x02OＸF␡\a２＄.ｃ2;υσ\v␍Ｂ＄+ψwσ＼Ｉ：\x03π．",
		out:  "．ρ\x02OＸF␡\a２＄.ｃ2;υσ\v␍Ｂ＄+ψwσ＼Ｉ：\x03π．",
	}, { // 388
		mask: EncodeSlash | EncodeLeftPeriod,
		in:   "．ρ\x02OＸF␡\a２＄.ｃ2;υσ\v␍Ｂ＄+ψwσ＼Ｉ：\x03π．",
		out:  "‛．ρ\x02OＸF␡\a２＄.ｃ2;υσ\v␍Ｂ＄+ψwσ＼Ｉ：\x03π．",
	}, { // 389
		mask: EncodeSlash | EncodeLeftPeriod,
		in:   ":.\x02OＸF␡\a２＄.ｃ2;υσ\v␍Ｂ＄+ψwσ＼Ｉ：\x03π9",
		out:  ":.\x02OＸF␡\a２＄.ｃ2;υσ\v␍Ｂ＄+ψwσ＼Ｉ：\x03π9",
	}, { // 390
		mask: EncodeSlash | EncodeLeftPeriod,
		in:   ":．\x02OＸF␡\a２＄.ｃ2;υσ\v␍Ｂ＄+ψwσ＼Ｉ：\x03π9",
		out:  ":．\x02OＸF␡\a２＄.ｃ2;υσ\v␍Ｂ＄+ψwσ＼Ｉ：\x03π9",
	}, { // 391
		mask: EncodeSlash | EncodeLeftPeriod,
		in:   ":.\x02OＸF␡\a２＄.ｃ2;υσ\v␍Ｂ＄+ψwσ＼Ｉ：\x03．9",
		out:  ":.\x02OＸF␡\a２＄.ｃ2;υσ\v␍Ｂ＄+ψwσ＼Ｉ：\x03．9",
	}, { // 392
		mask: EncodeSlash | EncodeLeftPeriod,
		in:   ":．\x02OＸF␡\a２＄.ｃ2;υσ\v␍Ｂ＄+ψwσ＼Ｉ：\x03．9",
		out:  ":．\x02OＸF␡\a２＄.ｃ2;υσ\v␍Ｂ＄+ψwσ＼Ｉ：\x03．9",
	}, { // 393
		mask: EncodeSlash | EncodeLeftPeriod,
		in:   ":.\x02OＸF␡\a２＄.ｃ2;υσ\v␍Ｂ＄+ψwσ＼Ｉ：\x03π．",
		out:  ":.\x02OＸF␡\a２＄.ｃ2;υσ\v␍Ｂ＄+ψwσ＼Ｉ：\x03π．",
	}, { // 394
		mask: EncodeSlash | EncodeLeftPeriod,
		in:   ":．\x02OＸF␡\a２＄.ｃ2;υσ\v␍Ｂ＄+ψwσ＼Ｉ：\x03π．",
		out:  ":．\x02OＸF␡\a２＄.ｃ2;υσ\v␍Ｂ＄+ψwσ＼Ｉ：\x03π．",
	}, { // 395
		mask: EncodeSlash | EncodeLeftPeriod,
		in:   ":ρ\x02OＸF␡\a２＄.ｃ2;υσ\v␍Ｂ＄+ψwσ＼Ｉ：\x03.9",
		out:  ":ρ\x02OＸF␡\a２＄.ｃ2;υσ\v␍Ｂ＄+ψwσ＼Ｉ：\x03.9",
	}, { // 396
		mask: EncodeSlash | EncodeLeftPeriod,
		in:   ":ρ\x02OＸF␡\a２＄.ｃ2;υσ\v␍Ｂ＄+ψwσ＼Ｉ：\x03．9",
		out:  ":ρ\x02OＸF␡\a２＄.ｃ2;υσ\v␍Ｂ＄+ψwσ＼Ｉ：\x03．9",
	}, { // 397
		mask: EncodeSlash | EncodeLeftPeriod,
		in:   ":ρ\x02OＸF␡\a２＄.ｃ2;υσ\v␍Ｂ＄+ψwσ＼Ｉ：\x03.．",
		out:  ":ρ\x02OＸF␡\a２＄.ｃ2;υσ\v␍Ｂ＄+ψwσ＼Ｉ：\x03.．",
	}, { // 398
		mask: EncodeSlash | EncodeLeftPeriod,
		in:   ":ρ\x02OＸF␡\a２＄.ｃ2;υσ\v␍Ｂ＄+ψwσ＼Ｉ：\x03．．",
		out:  ":ρ\x02OＸF␡\a２＄.ｃ2;υσ\v␍Ｂ＄+ψwσ＼Ｉ：\x03．．",
	}, { // 399
		mask: EncodeSlash | EncodeLeftPeriod,
		in:   ":ρ\x02OＸF␡\a２＄.ｃ2;υσ\v␍Ｂ＄+ψwσ＼Ｉ：\x03π.",
		out:  ":ρ\x02OＸF␡\a２＄.ｃ2;υσ\v␍Ｂ＄+ψwσ＼Ｉ：\x03π.",
	}, { // 400
		mask: EncodeSlash | EncodeLeftPeriod,
		in:   ":ρ\x02OＸF␡\a２＄.ｃ2;υσ\v␍Ｂ＄+ψwσ＼Ｉ：\x03π．",
		out:  ":ρ\x02OＸF␡\a２＄.ｃ2;υσ\v␍Ｂ＄+ψwσ＼Ｉ：\x03π．",
	}, { // 401
		mask: EncodeSingleQuote | EncodeLeftPeriod,
		in:   "ｎηξa]␝｜ｃ\x1e␒.｀ρX～］ｑLfισ＋t\t\x035:␝␌|",
		out:  "ｎηξa]␝｜ｃ\x1e␒.｀ρX～］ｑLfισ＋t\t\x035:␝␌|",
	}, { // 402
		mask: EncodeSingleQuote | EncodeLeftPeriod,
		in:   ".．ξa]␝｜ｃ\x1e␒.｀ρX～］ｑLfισ＋t\t\x035:␝␌|",
		out:  "．．ξa]␝｜ｃ\x1e␒.｀ρX～］ｑLfισ＋t\t\x035:␝␌|",
	}, { // 403
		mask: EncodeSingleQuote | EncodeLeftPeriod,
		in:   "．．ξa]␝｜ｃ\x1e␒.｀ρX～］ｑLfισ＋t\t\x035:␝␌|",
		out:  "‛．．ξa]␝｜ｃ\x1e␒.｀ρX～］ｑLfισ＋t\t\x035:␝␌|",
	}, { // 404
		mask: EncodeSingleQuote | EncodeLeftPeriod,
		in:   ".ηξa]␝｜ｃ\x1e␒.｀ρX～］ｑLfισ＋t\t\x035:␝．|",
		out:  "．ηξa]␝｜ｃ\x1e␒.｀ρX～］ｑLfισ＋t\t\x035:␝．|",
	}, { // 405
		mask: EncodeSingleQuote | EncodeLeftPeriod,
		in:   "．ηξa]␝｜ｃ\x1e␒.｀ρX～］ｑLfισ＋t\t\x035:␝．|",
		out:  "‛．ηξa]␝｜ｃ\x1e␒.｀ρX～］ｑLfισ＋t\t\x035:␝．|",
	}, { // 406
		mask: EncodeSingleQuote | EncodeLeftPeriod,
		in:   ".ηξa]␝｜ｃ\x1e␒.｀ρX～］ｑLfισ＋t\t\x035:␝␌．",
		out:  "．ηξa]␝｜ｃ\x1e␒.｀ρX～］ｑLfισ＋t\t\x035:␝␌．",
	}, { // 407
		mask: EncodeSingleQuote | EncodeLeftPeriod,
		in:   "．ηξa]␝｜ｃ\x1e␒.｀ρX～］ｑLfισ＋t\t\x035:␝␌．",
		out:  "‛．ηξa]␝｜ｃ\x1e␒.｀ρX～］ｑLfισ＋t\t\x035:␝␌．",
	}, { // 408
		mask: EncodeSingleQuote | EncodeLeftPeriod,
		in:   "ｎ.ξa]␝｜ｃ\x1e␒.｀ρX～］ｑLfισ＋t\t\x035:␝␌|",
		out:  "ｎ.ξa]␝｜ｃ\x1e␒.｀ρX～］ｑLfισ＋t\t\x035:␝␌|",
	}, { // 409
		mask: EncodeSingleQuote | EncodeLeftPeriod,
		in:   "ｎ．ξa]␝｜ｃ\x1e␒.｀ρX～］ｑLfισ＋t\t\x035:␝␌|",
		out:  "ｎ．ξa]␝｜ｃ\x1e␒.｀ρX～］ｑLfισ＋t\t\x035:␝␌|",
	}, { // 410
		mask: EncodeSingleQuote | EncodeLeftPeriod,
		in:   "ｎ.ξa]␝｜ｃ\x1e␒.｀ρX～］ｑLfισ＋t\t\x035:␝．|",
		out:  "ｎ.ξa]␝｜ｃ\x1e␒.｀ρX～］ｑLfισ＋t\t\x035:␝．|",
	}, { // 411
		mask: EncodeSingleQuote | EncodeLeftPeriod,
		in:   "ｎ．ξa]␝｜ｃ\x1e␒.｀ρX～］ｑLfισ＋t\t\x035:␝．|",
		out:  "ｎ．ξa]␝｜ｃ\x1e␒.｀ρX～］ｑLfισ＋t\t\x035:␝．|",
	}, { // 412
		mask: EncodeSingleQuote | EncodeLeftPeriod,
		in:   "ｎ.ξa]␝｜ｃ\x1e␒.｀ρX～］ｑLfισ＋t\t\x035:␝␌．",
		out:  "ｎ.ξa]␝｜ｃ\x1e␒.｀ρX～］ｑLfισ＋t\t\x035:␝␌．",
	}, { // 413
		mask: EncodeSingleQuote | EncodeLeftPeriod,
		in:   "ｎ．ξa]␝｜ｃ\x1e␒.｀ρX～］ｑLfισ＋t\t\x035:␝␌．",
		out:  "ｎ．ξa]␝｜ｃ\x1e␒.｀ρX～］ｑLfισ＋t\t\x035:␝␌．",
	}, { // 414
		mask: EncodeSingleQuote | EncodeLeftPeriod,
		in:   "ｎηξa]␝｜ｃ\x1e␒.｀ρX～］ｑLfισ＋t\t\x035:␝.|",
		out:  "ｎηξa]␝｜ｃ\x1e␒.｀ρX～］ｑLfισ＋t\t\x035:␝.|",
	}, { // 415
		mask: EncodeSingleQuote | EncodeLeftPeriod,
		in:   "ｎηξa]␝｜ｃ\x1e␒.｀ρX～］ｑLfισ＋t\t\x035:␝．|",
		out:  "ｎηξa]␝｜ｃ\x1e␒.｀ρX～］ｑLfισ＋t\t\x035:␝．|",
	}, { // 416
		mask: EncodeSingleQuote | EncodeLeftPeriod,
		in:   "ｎηξa]␝｜ｃ\x1e␒.｀ρX～］ｑLfισ＋t\t\x035:␝.．",
		out:  "ｎηξa]␝｜ｃ\x1e␒.｀ρX～］ｑLfισ＋t\t\x035:␝.．",
	}, { // 417
		mask: EncodeSingleQuote | EncodeLeftPeriod,
		in:   "ｎηξa]␝｜ｃ\x1e␒.｀ρX～］ｑLfισ＋t\t\x035:␝．．",
		out:  "ｎηξa]␝｜ｃ\x1e␒.｀ρX～］ｑLfισ＋t\t\x035:␝．．",
	}, { // 418
		mask: EncodeSingleQuote | EncodeLeftPeriod,
		in:   "ｎηξa]␝｜ｃ\x1e␒.｀ρX～］ｑLfισ＋t\t\x035:␝␌.",
		out:  "ｎηξa]␝｜ｃ\x1e␒.｀ρX～］ｑLfισ＋t\t\x035:␝␌.",
	}, { // 419
		mask: EncodeSingleQuote | EncodeLeftPeriod,
		in:   "ｎηξa]␝｜ｃ\x1e␒.｀ρX～］ｑLfισ＋t\t\x035:␝␌．",
		out:  "ｎηξa]␝｜ｃ\x1e␒.｀ρX～］ｑLfισ＋t\t\x035:␝␌．",
	}, { // 420
		mask: EncodeBackQuote | EncodeLeftPeriod,
		in:   "５:\x14｀\x06`ＶＰ］κ.]\nｒ＊ψｇ!␐Nβ␍ω?cM\x1b５␆δ",
		out:  "５:\x14‛｀\x06｀ＶＰ］κ.]\nｒ＊ψｇ!␐Nβ␍ω?cM\x1b５␆δ",
	}, { // 421
		mask: EncodeBackQuote | EncodeLeftPeriod,
		in:   ".．\x14｀\x06`ＶＰ］κ.]\nｒ＊ψｇ!␐Nβ␍ω?cM\x1b５␆δ",
		out:  "．．\x14‛｀\x06｀ＶＰ］κ.]\nｒ＊ψｇ!␐Nβ␍ω?cM\x1b５␆δ",
	}, { // 422
		mask: EncodeBackQuote | EncodeLeftPeriod,
		in:   "．．\x14｀\x06`ＶＰ］κ.]\nｒ＊ψｇ!␐Nβ␍ω?cM\x1b５␆δ",
		out:  "‛．．\x14‛｀\x06｀ＶＰ］κ.]\nｒ＊ψｇ!␐Nβ␍ω?cM\x1b５␆δ",
	}, { // 423
		mask: EncodeBackQuote | EncodeLeftPeriod,
		in:   ".:\x14｀\x06`ＶＰ］κ.]\nｒ＊ψｇ!␐Nβ␍ω?cM\x1b５．δ",
		out:  "．:\x14‛｀\x06｀ＶＰ］κ.]\nｒ＊ψｇ!␐Nβ␍ω?cM\x1b５．δ",
	}, { // 424
		mask: EncodeBackQuote | EncodeLeftPeriod,
		in:   "．:\x14｀\x06`ＶＰ］κ.]\nｒ＊ψｇ!␐Nβ␍ω?cM\x1b５．δ",
		out:  "‛．:\x14‛｀\x06｀ＶＰ］κ.]\nｒ＊ψｇ!␐Nβ␍ω?cM\x1b５．δ",
	}, { // 425
		mask: EncodeBackQuote | EncodeLeftPeriod,
		in:   ".:\x14｀\x06`ＶＰ］κ.]\nｒ＊ψｇ!␐Nβ␍ω?cM\x1b５␆．",
		out:  "．:\x14‛｀\x06｀ＶＰ］κ.]\nｒ＊ψｇ!␐Nβ␍ω?cM\x1b５␆．",
	}, { // 426
		mask: EncodeBackQuote | EncodeLeftPeriod,
		in:   "．:\x14｀\x06`ＶＰ］κ.]\nｒ＊ψｇ!␐Nβ␍ω?cM\x1b５␆．",
		out:  "‛．:\x14‛｀\x06｀ＶＰ］κ.]\nｒ＊ψｇ!␐Nβ␍ω?cM\x1b５␆．",
	}, { // 427
		mask: EncodeBackQuote | EncodeLeftPeriod,
		in:   "５.\x14｀\x06`ＶＰ］κ.]\nｒ＊ψｇ!␐Nβ␍ω?cM\x1b５␆δ",
		out:  "５.\x14‛｀\x06｀ＶＰ］κ.]\nｒ＊ψｇ!␐Nβ␍ω?cM\x1b５␆δ",
	}, { // 428
		mask: EncodeBackQuote | EncodeLeftPeriod,
		in:   "５．\x14｀\x06`ＶＰ］κ.]\nｒ＊ψｇ!␐Nβ␍ω?cM\x1b５␆δ",
		out:  "５．\x14‛｀\x06｀ＶＰ］κ.]\nｒ＊ψｇ!␐Nβ␍ω?cM\x1b５␆δ",
	}, { // 429
		mask: EncodeBackQuote | EncodeLeftPeriod,
		in:   "５.\x14｀\x06`ＶＰ］κ.]\nｒ＊ψｇ!␐Nβ␍ω?cM\x1b５．δ",
		out:  "５.\x14‛｀\x06｀ＶＰ］κ.]\nｒ＊ψｇ!␐Nβ␍ω?cM\x1b５．δ",
	}, { // 430
		mask: EncodeBackQuote | EncodeLeftPeriod,
		in:   "５．\x14｀\x06`ＶＰ］κ.]\nｒ＊ψｇ!␐Nβ␍ω?cM\x1b５．δ",
		out:  "５．\x14‛｀\x06｀ＶＰ］κ.]\nｒ＊ψｇ!␐Nβ␍ω?cM\x1b５．δ",
	}, { // 431
		mask: EncodeBackQuote | EncodeLeftPeriod,
		in:   "５.\x14｀\x06`ＶＰ］κ.]\nｒ＊ψｇ!␐Nβ␍ω?cM\x1b５␆．",
		out:  "５.\x14‛｀\x06｀ＶＰ］κ.]\nｒ＊ψｇ!␐Nβ␍ω?cM\x1b５␆．",
	}, { // 432
		mask: EncodeBackQuote | EncodeLeftPeriod,
		in:   "５．\x14｀\x06`ＶＰ］κ.]\nｒ＊ψｇ!␐Nβ␍ω?cM\x1b５␆．",
		out:  "５．\x14‛｀\x06｀ＶＰ］κ.]\nｒ＊ψｇ!␐Nβ␍ω?cM\x1b５␆．",
	}, { // 433
		mask: EncodeBackQuote | EncodeLeftPeriod,
		in:   "５:\x14｀\x06`ＶＰ］κ.]\nｒ＊ψｇ!␐Nβ␍ω?cM\x1b５.δ",
		out:  "５:\x14‛｀\x06｀ＶＰ］κ.]\nｒ＊ψｇ!␐Nβ␍ω?cM\x1b５.δ",
	}, { // 434
		mask: EncodeBackQuote | EncodeLeftPeriod,
		in:   "５:\x14｀\x06`ＶＰ］κ.]\nｒ＊ψｇ!␐Nβ␍ω?cM\x1b５．δ",
		out:  "５:\x14‛｀\x06｀ＶＰ］κ.]\nｒ＊ψｇ!␐Nβ␍ω?cM\x1b５．δ",
	}, { // 435
		mask: EncodeBackQuote | EncodeLeftPeriod,
		in:   "５:\x14｀\x06`ＶＰ］κ.]\nｒ＊ψｇ!␐Nβ␍ω?cM\x1b５.．",
		out:  "５:\x14‛｀\x06｀ＶＰ］κ.]\nｒ＊ψｇ!␐Nβ␍ω?cM\x1b５.．",
	}, { // 436
		mask: EncodeBackQuote | EncodeLeftPeriod,
		in:   "５:\x14｀\x06`ＶＰ］κ.]\nｒ＊ψｇ!␐Nβ␍ω?cM\x1b５．．",
		out:  "５:\x14‛｀\x06｀ＶＰ］κ.]\nｒ＊ψｇ!␐Nβ␍ω?cM\x1b５．．",
	}, { // 437
		mask: EncodeBackQuote | EncodeLeftPeriod,
		in:   "５:\x14｀\x06`ＶＰ］κ.]\nｒ＊ψｇ!␐Nβ␍ω?cM\x1b５␆.",
		out:  "５:\x14‛｀\x06｀ＶＰ］κ.]\nｒ＊ψｇ!␐Nβ␍ω?cM\x1b５␆.",
	}, { // 438
		mask: EncodeBackQuote | EncodeLeftPeriod,
		in:   "５:\x14｀\x06`ＶＰ］κ.]\nｒ＊ψｇ!␐Nβ␍ω?cM\x1b５␆．",
		out:  "５:\x14‛｀\x06｀ＶＰ］κ.]\nｒ＊ψｇ!␐Nβ␍ω?cM\x1b５␆．",
	}, { // 439
		mask: EncodeLtGt | EncodeLeftPeriod,
		in:   "&>␛\r␌＄υ␛u０.<w]ι\x04f４／␛．\x11＂π\x013＄λυθ",
		out:  "&＞␛\r␌＄υ␛u０.＜w]ι\x04f４／␛．\x11＂π\x013＄λυθ",
	}, { // 440
		mask: EncodeLtGt | EncodeLeftPeriod,
		in:   ".．␛\r␌＄υ␛u０.<w]ι\x04f４／␛．\x11＂π\x013＄λυθ",
		out:  "．．␛\r␌＄υ␛u０.＜w]ι\x04f４／␛．\x11＂π\x013＄λυθ",
	}, { // 441
		mask: EncodeLtGt | EncodeLeftPeriod,
		in:   "．．␛\r␌＄υ␛u０.<w]ι\x04f４／␛．\x11＂π\x013＄λυθ",
		out:  "‛．．␛\r␌＄υ␛u０.＜w]ι\x04f４／␛．\x11＂π\x013＄λυθ",
	}, { // 442
		mask: EncodeLtGt | EncodeLeftPeriod,
		in:   ".>␛\r␌＄υ␛u０.<w]ι\x04f４／␛．\x11＂π\x013＄λ．θ",
		out:  "．＞␛\r␌＄υ␛u０.＜w]ι\x04f４／␛．\x11＂π\x013＄λ．θ",
	}, { // 443
		mask: EncodeLtGt | EncodeLeftPeriod,
		in:   "．>␛\r␌＄υ␛u０.<w]ι\x04f４／␛．\x11＂π\x013＄λ．θ",
		out:  "‛．＞␛\r␌＄υ␛u０.＜w]ι\x04f４／␛．\x11＂π\x013＄λ．θ",
	}, { // 444
		mask: EncodeLtGt | EncodeLeftPeriod,
		in:   ".>␛\r␌＄υ␛u０.<w]ι\x04f４／␛．\x11＂π\x013＄λυ．",
		out:  "．＞␛\r␌＄υ␛u０.＜w]ι\x04f４／␛．\x11＂π\x013＄λυ．",
	}, { // 445
		mask: EncodeLtGt | EncodeLeftPeriod,
		in:   "．>␛\r␌＄υ␛u０.<w]ι\x04f４／␛．\x11＂π\x013＄λυ．",
		out:  "‛．＞␛\r␌＄υ␛u０.＜w]ι\x04f４／␛．\x11＂π\x013＄λυ．",
	}, { // 446
		mask: EncodeLtGt | EncodeLeftPeriod,
		in:   "&.␛\r␌＄υ␛u０.<w]ι\x04f４／␛．\x11＂π\x013＄λυθ",
		out:  "&.␛\r␌＄υ␛u０.＜w]ι\x04f４／␛．\x11＂π\x013＄λυθ",
	}, { // 447
		mask: EncodeLtGt | EncodeLeftPeriod,
		in:   "&．␛\r␌＄υ␛u０.<w]ι\x04f４／␛．\x11＂π\x013＄λυθ",
		out:  "&．␛\r␌＄υ␛u０.＜w]ι\x04f４／␛．\x11＂π\x013＄λυθ",
	}, { // 448
		mask: EncodeLtGt | EncodeLeftPeriod,
		in:   "&.␛\r␌＄υ␛u０.<w]ι\x04f４／␛．\x11＂π\x013＄λ．θ",
		out:  "&.␛\r␌＄υ␛u０.＜w]ι\x04f４／␛．\x11＂π\x013＄λ．θ",
	}, { // 449
		mask: EncodeLtGt | EncodeLeftPeriod,
		in:   "&．␛\r␌＄υ␛u０.<w]ι\x04f４／␛．\x11＂π\x013＄λ．θ",
		out:  "&．␛\r␌＄υ␛u０.＜w]ι\x04f４／␛．\x11＂π\x013＄λ．θ",
	}, { // 450
		mask: EncodeLtGt | EncodeLeftPeriod,
		in:   "&.␛\r␌＄υ␛u０.<w]ι\x04f４／␛．\x11＂π\x013＄λυ．",
		out:  "&.␛\r␌＄υ␛u０.＜w]ι\x04f４／␛．\x11＂π\x013＄λυ．",
	}, { // 451
		mask: EncodeLtGt | EncodeLeftPeriod,
		in:   "&．␛\r␌＄υ␛u０.<w]ι\x04f４／␛．\x11＂π\x013＄λυ．",
		out:  "&．␛\r␌＄υ␛u０.＜w]ι\x04f４／␛．\x11＂π\x013＄λυ．",
	}, { // 452
		mask: EncodeLtGt | EncodeLeftPeriod,
		in:   "&>␛\r␌＄υ␛u０.<w]ι\x04f４／␛．\x11＂π\x013＄λ.θ",
		out:  "&＞␛\r␌＄υ␛u０.＜w]ι\x04f４／␛．\x11＂π\x013＄λ.θ",
	}, { // 453
		mask: EncodeLtGt | EncodeLeftPeriod,
		in:   "&>␛\r␌＄υ␛u０.<w]ι\x04f４／␛．\x11＂π\x013＄λ．θ",
		out:  "&＞␛\r␌＄υ␛u０.＜w]ι\x04f４／␛．\x11＂π\x013＄λ．θ",
	}, { // 454
		mask: EncodeLtGt | EncodeLeftPeriod,
		in:   "&>␛\r␌＄υ␛u０.<w]ι\x04f４／␛．\x11＂π\x013＄λ.．",
		out:  "&＞␛\r␌＄υ␛u０.＜w]ι\x04f４／␛．\x11＂π\x013＄λ.．",
	}, { // 455
		mask: EncodeLtGt | EncodeLeftPeriod,
		in:   "&>␛\r␌＄υ␛u０.<w]ι\x04f４／␛．\x11＂π\x013＄λ．．",
		out:  "&＞␛\r␌＄υ␛u０.＜w]ι\x04f４／␛．\x11＂π\x013＄λ．．",
	}, { // 456
		mask: EncodeLtGt | EncodeLeftPeriod,
		in:   "&>␛\r␌＄υ␛u０.<w]ι\x04f４／␛．\x11＂π\x013＄λυ.",
		out:  "&＞␛\r␌＄υ␛u０.＜w]ι\x04f４／␛．\x11＂π\x013＄λυ.",
	}, { // 457
		mask: EncodeLtGt | EncodeLeftPeriod,
		in:   "&>␛\r␌＄υ␛u０.<w]ι\x04f４／␛．\x11＂π\x013＄λυ．",
		out:  "&＞␛\r␌＄υ␛u０.＜w]ι\x04f４／␛．\x11＂π\x013＄λυ．",
	}, { // 458
		mask: EncodeSquareBracket | EncodeLeftPeriod,
		in:   "P|ο５ｖ\nm` ;.ａ＇dαbξ␈␞␀;μ␏／;␁ＸＨη\u007f",
		out:  "P|ο５ｖ\nm` ;.ａ＇dαbξ␈␞‛␀;μ␏／;␁ＸＨη\u007f",
	}, { // 459
		mask: EncodeSquareBracket | EncodeLeftPeriod,
		in:   ".．ο５ｖ\nm` ;.ａ＇dαbξ␈␞␀;μ␏／;␁ＸＨη\u007f",
		out:  "．．ο５ｖ\nm` ;.ａ＇dαbξ␈␞‛␀;μ␏／;␁ＸＨη\u007f",
	}, { // 460
		mask: EncodeSquareBracket | EncodeLeftPeriod,
		in:   "．．ο５ｖ\nm` ;.ａ＇dαbξ␈␞␀;μ␏／;␁ＸＨη\u007f",
		out:  "‛．．ο５ｖ\nm` ;.ａ＇dαbξ␈␞‛␀;μ␏／;␁ＸＨη\u007f",
	}, { // 461
		mask: EncodeSquareBracket | EncodeLeftPeriod,
		in:   ".|ο５ｖ\nm` ;.ａ＇dαbξ␈␞␀;μ␏／;␁ＸＨ．\u007f",
		out:  "．|ο５ｖ\nm` ;.ａ＇dαbξ␈␞‛␀;μ␏／;␁ＸＨ．\u007f",
	}, { // 462
		mask: EncodeSquareBracket | EncodeLeftPeriod,
		in:   "．|ο５ｖ\nm` ;.ａ＇dαbξ␈␞␀;μ␏／;␁ＸＨ．\u007f",
		out:  "‛．|ο５ｖ\nm` ;.ａ＇dαbξ␈␞‛␀;μ␏／;␁ＸＨ．\u007f",
	}, { // 463
		mask: EncodeSquareBracket | EncodeLeftPeriod,
		in:   ".|ο５ｖ\nm` ;.ａ＇dαbξ␈␞␀;μ␏／;␁ＸＨη．",
		out:  "．|ο５ｖ\nm` ;.ａ＇dαbξ␈␞‛␀;μ␏／;␁ＸＨη．",
	}, { // 464
		mask: EncodeSquareBracket | EncodeLeftPeriod,
		in:   "．|ο５ｖ\nm` ;.ａ＇dαbξ␈␞␀;μ␏／;␁ＸＨη．",
		out:  "‛．|ο５ｖ\nm` ;.ａ＇dαbξ␈␞‛␀;μ␏／;␁ＸＨη．",
	}, { // 465
		mask: EncodeSquareBracket | EncodeLeftPeriod,
		in:   "P.ο５ｖ\nm` ;.ａ＇dαbξ␈␞␀;μ␏／;␁ＸＨη\u007f",
		out:  "P.ο５ｖ\nm` ;.ａ＇dαbξ␈␞‛␀;μ␏／;␁ＸＨη\u007f",
	}, { // 466
		mask: EncodeSquareBracket | EncodeLeftPeriod,
		in:   "P．ο５ｖ\nm` ;.ａ＇dαbξ␈␞␀;μ␏／;␁ＸＨη\u007f",
		out:  "P．ο５ｖ\nm` ;.ａ＇dαbξ␈␞‛␀;μ␏／;␁ＸＨη\u007f",
	}, { // 467
		mask: EncodeSquareBracket | EncodeLeftPeriod,
		in:   "P.ο５ｖ\nm` ;.ａ＇dαbξ␈␞␀;μ␏／;␁ＸＨ．\u007f",
		out:  "P.ο５ｖ\nm` ;.ａ＇dαbξ␈␞‛␀;μ␏／;␁ＸＨ．\u007f",
	}, { // 468
		mask: EncodeSquareBracket | EncodeLeftPeriod,
		in:   "P．ο５ｖ\nm` ;.ａ＇dαbξ␈␞␀;μ␏／;␁ＸＨ．\u007f",
		out:  "P．ο５ｖ\nm` ;.ａ＇dαbξ␈␞‛␀;μ␏／;␁ＸＨ．\u007f",
	}, { // 469
		mask: EncodeSquareBracket | EncodeLeftPeriod,
		in:   "P.ο５ｖ\nm` ;.ａ＇dαbξ␈␞␀;μ␏／;␁ＸＨη．",
		out:  "P.ο５ｖ\nm` ;.ａ＇dαbξ␈␞‛␀;μ␏／;␁ＸＨη．",
	}, { // 470
		mask: EncodeSquareBracket | EncodeLeftPeriod,
		in:   "P．ο５ｖ\nm` ;.ａ＇dαbξ␈␞␀;μ␏／;␁ＸＨη．",
		out:  "P．ο５ｖ\nm` ;.ａ＇dαbξ␈␞‛␀;μ␏／;␁ＸＨη．",
	}, { // 471
		mask: EncodeSquareBracket | EncodeLeftPeriod,
		in:   "P|ο５ｖ\nm` ;.ａ＇dαbξ␈␞␀;μ␏／;␁ＸＨ.\u007f",
		out:  "P|ο５ｖ\nm` ;.ａ＇dαbξ␈␞‛␀;μ␏／;␁ＸＨ.\u007f",
	}, { // 472
		mask: EncodeSquareBracket | EncodeLeftPeriod,
		in:   "P|ο５ｖ\nm` ;.ａ＇dαbξ␈␞␀;μ␏／;␁ＸＨ．\u007f",
		out:  "P|ο５ｖ\nm` ;.ａ＇dαbξ␈␞‛␀;μ␏／;␁ＸＨ．\u007f",
	}, { // 473
		mask: EncodeSquareBracket | EncodeLeftPeriod,
		in:   "P|ο５ｖ\nm` ;.ａ＇dαbξ␈␞␀;μ␏／;␁ＸＨ.．",
		out:  "P|ο５ｖ\nm` ;.ａ＇dαbξ␈␞‛␀;μ␏／;␁ＸＨ.．",
	}, { // 474
		mask: EncodeSquareBracket | EncodeLeftPeriod,
		in:   "P|ο５ｖ\nm` ;.ａ＇dαbξ␈␞␀;μ␏／;␁ＸＨ．．",
		out:  "P|ο５ｖ\nm` ;.ａ＇dαbξ␈␞‛␀;μ␏／;␁ＸＨ．．",
	}, { // 475
		mask: EncodeSquareBracket | EncodeLeftPeriod,
		in:   "P|ο５ｖ\nm` ;.ａ＇dαbξ␈␞␀;μ␏／;␁ＸＨη.",
		out:  "P|ο５ｖ\nm` ;.ａ＇dαbξ␈␞‛␀;μ␏／;␁ＸＨη.",
	}, { // 476
		mask: EncodeSquareBracket | EncodeLeftPeriod,
		in:   "P|ο５ｖ\nm` ;.ａ＇dαbξ␈␞␀;μ␏／;␁ＸＨη．",
		out:  "P|ο５ｖ\nm` ;.ａ＇dαbξ␈␞‛␀;μ␏／;␁ＸＨη．",
	}, { // 477
		mask: EncodeSemicolon | EncodeLeftPeriod,
		in:   "*#θ[␍η|xｒ`.ｊ␋ξs＝␜␚＂0）／\\A\x05␈με\fσ",
		out:  "*#θ[␍η|xｒ`.ｊ␋ξs＝␜␚＂0）／\\A\x05␈με\fσ",
	}, { // 478
		mask: EncodeSemicolon | EncodeLeftPeriod,
		in:   ".．θ[␍η|xｒ`.ｊ␋ξs＝␜␚＂0）／\\A\x05␈με\fσ",
		out:  "．．θ[␍η|xｒ`.ｊ␋ξs＝␜␚＂0）／\\A\x05␈με\fσ",
	}, { // 479
		mask: EncodeSemicolon | EncodeLeftPeriod,
		in:   "．．θ[␍η|xｒ`.ｊ␋ξs＝␜␚＂0）／\\A\x05␈με\fσ",
		out:  "‛．．θ[␍η|xｒ`.ｊ␋ξs＝␜␚＂0）／\\A\x05␈με\fσ",
	}, { // 480
		mask: EncodeSemicolon | EncodeLeftPeriod,
		in:   ".#θ[␍η|xｒ`.ｊ␋ξs＝␜␚＂0）／\\A\x05␈με．σ",
		out:  "．#θ[␍η|xｒ`.ｊ␋ξs＝␜␚＂0）／\\A\x05␈με．σ",
	}, { // 481
		mask: EncodeSemicolon | EncodeLeftPeriod,
		in:   "．#θ[␍η|xｒ`.ｊ␋ξs＝␜␚＂0）／\\A\x05␈με．σ",
		out:  "‛．#θ[␍η|xｒ`.ｊ␋ξs＝␜␚＂0）／\\A\x05␈με．σ",
	}, { // 482
		mask: EncodeSemicolon | EncodeLeftPeriod,
		in:   ".#θ[␍η|xｒ`.ｊ␋ξs＝␜␚＂0）／\\A\x05␈με\f．",
		out:  "．#θ[␍η|xｒ`.ｊ␋ξs＝␜␚＂0）／\\A\x05␈με\f．",
	}, { // 483
		mask: EncodeSemicolon | EncodeLeftPeriod,
		in:   "．#θ[␍η|xｒ`.ｊ␋ξs＝␜␚＂0）／\\A\x05␈με\f．",
		out:  "‛．#θ[␍η|xｒ`.ｊ␋ξs＝␜␚＂0）／\\A\x05␈με\f．",
	}, { // 484
		mask: EncodeSemicolon | EncodeLeftPeriod,
		in:   "*.θ[␍η|xｒ`.ｊ␋ξs＝␜␚＂0）／\\A\x05␈με\fσ",
		out:  "*.θ[␍η|xｒ`.ｊ␋ξs＝␜␚＂0）／\\A\x05␈με\fσ",
	}, { // 485
		mask: EncodeSemicolon | EncodeLeftPeriod,
		in:   "*．θ[␍η|xｒ`.ｊ␋ξs＝␜␚＂0）／\\A\x05␈με\fσ",
		out:  "*．θ[␍η|xｒ`.ｊ␋ξs＝␜␚＂0）／\\A\x05␈με\fσ",
	}, { // 486
		mask: EncodeSemicolon | EncodeLeftPeriod,
		in:   "*.θ[␍η|xｒ`.ｊ␋ξs＝␜␚＂0）／\\A\x05␈με．σ",
		out:  "*.θ[␍η|xｒ`.ｊ␋ξs＝␜␚＂0）／\\A\x05␈με．σ",
	}, { // 487
		mask: EncodeSemicolon | EncodeLeftPeriod,
		in:   "*．θ[␍η|xｒ`.ｊ␋ξs＝␜␚＂0）／\\A\x05␈με．σ",
		out:  "*．θ[␍η|xｒ`.ｊ␋ξs＝␜␚＂0）／\\A\x05␈με．σ",
	}, { // 488
		mask: EncodeSemicolon | EncodeLeftPeriod,
		in:   "*.θ[␍η|xｒ`.ｊ␋ξs＝␜␚＂0）／\\A\x05␈με\f．",
		out:  "*.θ[␍η|xｒ`.ｊ␋ξs＝␜␚＂0）／\\A\x05␈με\f．",
	}, { // 489
		mask: EncodeSemicolon | EncodeLeftPeriod,
		in:   "*．θ[␍η|xｒ`.ｊ␋ξs＝␜␚＂0）／\\A\x05␈με\f．",
		out:  "*．θ[␍η|xｒ`.ｊ␋ξs＝␜␚＂0）／\\A\x05␈με\f．",
	}, { // 490
		mask: EncodeSemicolon | EncodeLeftPeriod,
		in:   "*#θ[␍η|xｒ`.ｊ␋ξs＝␜␚＂0）／\\A\x05␈με.σ",
		out:  "*#θ[␍η|xｒ`.ｊ␋ξs＝␜␚＂0）／\\A\x05␈με.σ",
	}, { // 491
		mask: EncodeSemicolon | EncodeLeftPeriod,
		in:   "*#θ[␍η|xｒ`.ｊ␋ξs＝␜␚＂0）／\\A\x05␈με．σ",
		out:  "*#θ[␍η|xｒ`.ｊ␋ξs＝␜␚＂0）／\\A\x05␈με．σ",
	}, { // 492
		mask: EncodeSemicolon | EncodeLeftPeriod,
		in:   "*#θ[␍η|xｒ`.ｊ␋ξs＝␜␚＂0）／\\A\x05␈με.．",
		out:  "*#θ[␍η|xｒ`.ｊ␋ξs＝␜␚＂0）／\\A\x05␈με.．",
	}, { // 493
		mask: EncodeSemicolon | EncodeLeftPeriod,
		in:   "*#θ[␍η|xｒ`.ｊ␋ξs＝␜␚＂0）／\\A\x05␈με．．",
		out:  "*#θ[␍η|xｒ`.ｊ␋ξs＝␜␚＂0）／\\A\x05␈με．．",
	}, { // 494
		mask: EncodeSemicolon | EncodeLeftPeriod,
		in:   "*#θ[␍η|xｒ`.ｊ␋ξs＝␜␚＂0）／\\A\x05␈με\f.",
		out:  "*#θ[␍η|xｒ`.ｊ␋ξs＝␜␚＂0）／\\A\x05␈με\f.",
	}, { // 495
		mask: EncodeSemicolon | EncodeLeftPeriod,
		in:   "*#θ[␍η|xｒ`.ｊ␋ξs＝␜␚＂0）／\\A\x05␈με\f．",
		out:  "*#θ[␍η|xｒ`.ｊ␋ξs＝␜␚＂0）／\\A\x05␈με\f．",
	}, { // 496
		mask: EncodeDollar | EncodeLeftPeriod,
		in:   "\x1eχη>\x127/：Ａβ.\x17Ｘ1␆＞|υ\uff00#０＜ψLψ<␃｜M␉",
		out:  "\x1eχη>\x127/：Ａβ.\x17Ｘ1␆＞|υ\uff00#０＜ψLψ<␃｜M␉",
	}, { // 497
		mask: EncodeDollar | EncodeLeftPeriod,
		in:   ".．η>\x127/：Ａβ.\x17Ｘ1␆＞|υ\uff00#０＜ψLψ<␃｜M␉",
		out:  "．．η>\x127/：Ａβ.\x17Ｘ1␆＞|υ\uff00#０＜ψLψ<␃｜M␉",
	}, { // 498
		mask: EncodeDollar | EncodeLeftPeriod,
		in:   "．．η>\x127/：Ａβ.\x17Ｘ1␆＞|υ\uff00#０＜ψLψ<␃｜M␉",
		out:  "‛．．η>\x127/：Ａβ.\x17Ｘ1␆＞|υ\uff00#０＜ψLψ<␃｜M␉",
	}, { // 499
		mask: EncodeDollar | EncodeLeftPeriod,
		in:   ".χη>\x127/：Ａβ.\x17Ｘ1␆＞|υ\uff00#０＜ψLψ<␃｜．␉",
		out:  "．χη>\x127/：Ａβ.\x17Ｘ1␆＞|υ\uff00#０＜ψLψ<␃｜．␉",
	}, { // 500
		mask: EncodeDollar | EncodeLeftPeriod,
		in:   "．χη>\x127/：Ａβ.\x17Ｘ1␆＞|υ\uff00#０＜ψLψ<␃｜．␉",
		out:  "‛．χη>\x127/：Ａβ.\x17Ｘ1␆＞|υ\uff00#０＜ψLψ<␃｜．␉",
	}, { // 501
		mask: EncodeDollar | EncodeLeftPeriod,
		in:   ".χη>\x127/：Ａβ.\x17Ｘ1␆＞|υ\uff00#０＜ψLψ<␃｜M．",
		out:  "．χη>\x127/：Ａβ.\x17Ｘ1␆＞|υ\uff00#０＜ψLψ<␃｜M．",
	}, { // 502
		mask: EncodeDollar | EncodeLeftPeriod,
		in:   "．χη>\x127/：Ａβ.\x17Ｘ1␆＞|υ\uff00#０＜ψLψ<␃｜M．",
		out:  "‛．χη>\x127/：Ａβ.\x17Ｘ1␆＞|υ\uff00#０＜ψLψ<␃｜M．",
	}, { // 503
		mask: EncodeDollar | EncodeLeftPeriod,
		in:   "\x1e.η>\x127/：Ａβ.\x17Ｘ1␆＞|υ\uff00#０＜ψLψ<␃｜M␉",
		out:  "\x1e.η>\x127/：Ａβ.\x17Ｘ1␆＞|υ\uff00#０＜ψLψ<␃｜M␉",
	}, { // 504
		mask: EncodeDollar | EncodeLeftPeriod,
		in:   "\x1e．η>\x127/：Ａβ.\x17Ｘ1␆＞|υ\uff00#０＜ψLψ<␃｜M␉",
		out:  "\x1e．η>\x127/：Ａβ.\x17Ｘ1␆＞|υ\uff00#０＜ψLψ<␃｜M␉",
	}, { // 505
		mask: EncodeDollar | EncodeLeftPeriod,
		in:   "\x1e.η>\x127/：Ａβ.\x17Ｘ1␆＞|υ\uff00#０＜ψLψ<␃｜．␉",
		out:  "\x1e.η>\x127/：Ａβ.\x17Ｘ1␆＞|υ\uff00#０＜ψLψ<␃｜．␉",
	}, { // 506
		mask: EncodeDollar | EncodeLeftPeriod,
		in:   "\x1e．η>\x127/：Ａβ.\x17Ｘ1␆＞|υ\uff00#０＜ψLψ<␃｜．␉",
		out:  "\x1e．η>\x127/：Ａβ.\x17Ｘ1␆＞|υ\uff00#０＜ψLψ<␃｜．␉",
	}, { // 507
		mask: EncodeDollar | EncodeLeftPeriod,
		in:   "\x1e.η>\x127/：Ａβ.\x17Ｘ1␆＞|υ\uff00#０＜ψLψ<␃｜M．",
		out:  "\x1e.η>\x127/：Ａβ.\x17Ｘ1␆＞|υ\uff00#０＜ψLψ<␃｜M．",
	}, { // 508
		mask: EncodeDollar | EncodeLeftPeriod,
		in:   "\x1e．η>\x127/：Ａβ.\x17Ｘ1␆＞|υ\uff00#０＜ψLψ<␃｜M．",
		out:  "\x1e．η>\x127/：Ａβ.\x17Ｘ1␆＞|υ\uff00#０＜ψLψ<␃｜M．",
	}, { // 509
		mask: EncodeDollar | EncodeLeftPeriod,
		in:   "\x1eχη>\x127/：Ａβ.\x17Ｘ1␆＞|υ\uff00#０＜ψLψ<␃｜.␉",
		out:  "\x1eχη>\x127/：Ａβ.\x17Ｘ1␆＞|υ\uff00#０＜ψLψ<␃｜.␉",
	}, { // 510
		mask: EncodeDollar | EncodeLeftPeriod,
		in:   "\x1eχη>\x127/：Ａβ.\x17Ｘ1␆＞|υ\uff00#０＜ψLψ<␃｜．␉",
		out:  "\x1eχη>\x127/：Ａβ.\x17Ｘ1␆＞|υ\uff00#０＜ψLψ<␃｜．␉",
	}, { // 511
		mask: EncodeDollar | EncodeLeftPeriod,
		in:   "\x1eχη>\x127/：Ａβ.\x17Ｘ1␆＞|υ\uff00#０＜ψLψ<␃｜.．",
		out:  "\x1eχη>\x127/：Ａβ.\x17Ｘ1␆＞|υ\uff00#０＜ψLψ<␃｜.．",
	}, { // 512
		mask: EncodeDollar | EncodeLeftPeriod,
		in:   "\x1eχη>\x127/：Ａβ.\x17Ｘ1␆＞|υ\uff00#０＜ψLψ<␃｜．．",
		out:  "\x1eχη>\x127/：Ａβ.\x17Ｘ1␆＞|υ\uff00#０＜ψLψ<␃｜．．",
	}, { // 513
		mask: EncodeDollar | EncodeLeftPeriod,
		in:   "\x1eχη>\x127/：Ａβ.\x17Ｘ1␆＞|υ\uff00#０＜ψLψ<␃｜M.",
		out:  "\x1eχη>\x127/：Ａβ.\x17Ｘ1␆＞|υ\uff00#０＜ψLψ<␃｜M.",
	}, { // 514
		mask: EncodeDollar | EncodeLeftPeriod,
		in:   "\x1eχη>\x127/：Ａβ.\x17Ｘ1␆＞|υ\uff00#０＜ψLψ<␃｜M．",
		out:  "\x1eχη>\x127/：Ａβ.\x17Ｘ1␆＞|υ\uff00#０＜ψLψ<␃｜M．",
	}, { // 515
		mask: EncodeDoubleQuote | EncodeLeftPeriod,
		in:   "πｍ$４\u007fθ`?ｗ－.χ~βX\x01␇]]ｓ＄)＇␉vλ␒|／␑",
		out:  "πｍ$４\u007fθ`?ｗ－.χ~βX\x01␇]]ｓ＄)＇␉vλ␒|／␑",
	}, { // 516
		mask: EncodeDoubleQuote | EncodeLeftPeriod,
		in:   ".．$４\u007fθ`?ｗ－.χ~βX\x01␇]]ｓ＄)＇␉vλ␒|／␑",
		out:  "．．$４\u007fθ`?ｗ－.χ~βX\x01␇]]ｓ＄)＇␉vλ␒|／␑",
	}, { // 517
		mask: EncodeDoubleQuote | EncodeLeftPeriod,
		in:   "．．$４\u007fθ`?ｗ－.χ~βX\x01␇]]ｓ＄)＇␉vλ␒|／␑",
		out:  "‛．．$４\u007fθ`?ｗ－.χ~βX\x01␇]]ｓ＄)＇␉vλ␒|／␑",
	}, { // 518
		mask: EncodeDoubleQuote | EncodeLeftPeriod,
		in:   ".ｍ$４\u007fθ`?ｗ－.χ~βX\x01␇]]ｓ＄)＇␉vλ␒|．␑",
		out:  "．ｍ$４\u007fθ`?ｗ－.χ~βX\x01␇]]ｓ＄)＇␉vλ␒|．␑",
	}, { // 519
		mask: EncodeDoubleQuote | EncodeLeftPeriod,
		in:   "．ｍ$４\u007fθ`?ｗ－.χ~βX\x01␇]]ｓ＄)＇␉vλ␒|．␑",
		out:  "‛．ｍ$４\u007fθ`?ｗ－.χ~βX\x01␇]]ｓ＄)＇␉vλ␒|．␑",
	}, { // 520
		mask: EncodeDoubleQuote | EncodeLeftPeriod,
		in:   ".ｍ$４\u007fθ`?ｗ－.χ~βX\x01␇]]ｓ＄)＇␉vλ␒|／．",
		out:  "．ｍ$４\u007fθ`?ｗ－.χ~βX\x01␇]]ｓ＄)＇␉vλ␒|／．",
	}, { // 521
		mask: EncodeDoubleQuote | EncodeLeftPeriod,
		in:   "．ｍ$４\u007fθ`?ｗ－.χ~βX\x01␇]]ｓ＄)＇␉vλ␒|／．",
		out:  "‛．ｍ$４\u007fθ`?ｗ－.χ~βX\x01␇]]ｓ＄)＇␉vλ␒|／．",
	}, { // 522
		mask: EncodeDoubleQuote | EncodeLeftPeriod,
		in:   "π.$４\u007fθ`?ｗ－.χ~βX\x01␇]]ｓ＄)＇␉vλ␒|／␑",
		out:  "π.$４\u007fθ`?ｗ－.χ~βX\x01␇]]ｓ＄)＇␉vλ␒|／␑",
	}, { // 523
		mask: EncodeDoubleQuote | EncodeLeftPeriod,
		in:   "π．$４\u007fθ`?ｗ－.χ~βX\x01␇]]ｓ＄)＇␉vλ␒|／␑",
		out:  "π．$４\u007fθ`?ｗ－.χ~βX\x01␇]]ｓ＄)＇␉vλ␒|／␑",
	}, { // 524
		mask: EncodeDoubleQuote | EncodeLeftPeriod,
		in:   "π.$４\u007fθ`?ｗ－.χ~βX\x01␇]]ｓ＄)＇␉vλ␒|．␑",
		out:  "π.$４\u007fθ`?ｗ－.χ~βX\x01␇]]ｓ＄)＇␉vλ␒|．␑",
	}, { // 525
		mask: EncodeDoubleQuote | EncodeLeftPeriod,
		in:   "π．$４\u007fθ`?ｗ－.χ~βX\x01␇]]ｓ＄)＇␉vλ␒|．␑",
		out:  "π．$４\u007fθ`?ｗ－.χ~βX\x01␇]]ｓ＄)＇␉vλ␒|．␑",
	}, { // 526
		mask: EncodeDoubleQuote | EncodeLeftPeriod,
		in:   "π.$４\u007fθ`?ｗ－.χ~βX\x01␇]]ｓ＄)＇␉vλ␒|／．",
		out:  "π.$４\u007fθ`?ｗ－.χ~βX\x01␇]]ｓ＄)＇␉vλ␒|／．",
	}, { // 527
		mask: EncodeDoubleQuote | EncodeLeftPeriod,
		in:   "π．$４\u007fθ`?ｗ－.χ~βX\x01␇]]ｓ＄)＇␉vλ␒|／．",
		out:  "π．$４\u007fθ`?ｗ－.χ~βX\x01␇]]ｓ＄)＇␉vλ␒|／．",
	}, { // 528
		mask: EncodeDoubleQuote | EncodeLeftPeriod,
		in:   "πｍ$４\u007fθ`?ｗ－.χ~βX\x01␇]]ｓ＄)＇␉vλ␒|.␑",
		out:  "πｍ$４\u007fθ`?ｗ－.χ~βX\x01␇]]ｓ＄)＇␉vλ␒|.␑",
	}, { // 529
		mask: EncodeDoubleQuote | EncodeLeftPeriod,
		in:   "πｍ$４\u007fθ`?ｗ－.χ~βX\x01␇]]ｓ＄)＇␉vλ␒|．␑",
		out:  "πｍ$４\u007fθ`?ｗ－.χ~βX\x01␇]]ｓ＄)＇␉vλ␒|．␑",
	}, { // 530
		mask: EncodeDoubleQuote | EncodeLeftPeriod,
		in:   "πｍ$４\u007fθ`?ｗ－.χ~βX\x01␇]]ｓ＄)＇␉vλ␒|.．",
		out:  "πｍ$４\u007fθ`?ｗ－.χ~βX\x01␇]]ｓ＄)＇␉vλ␒|.．",
	}, { // 531
		mask: EncodeDoubleQuote | EncodeLeftPeriod,
		in:   "πｍ$４\u007fθ`?ｗ－.χ~βX\x01␇]]ｓ＄)＇␉vλ␒|．．",
		out:  "πｍ$４\u007fθ`?ｗ－.χ~βX\x01␇]]ｓ＄)＇␉vλ␒|．．",
	}, { // 532
		mask: EncodeDoubleQuote | EncodeLeftPeriod,
		in:   "πｍ$４\u007fθ`?ｗ－.χ~βX\x01␇]]ｓ＄)＇␉vλ␒|／.",
		out:  "πｍ$４\u007fθ`?ｗ－.χ~βX\x01␇]]ｓ＄)＇␉vλ␒|／.",
	}, { // 533
		mask: EncodeDoubleQuote | EncodeLeftPeriod,
		in:   "πｍ$４\u007fθ`?ｗ－.χ~βX\x01␇]]ｓ＄)＇␉vλ␒|／．",
		out:  "πｍ$４\u007fθ`?ｗ－.χ~βX\x01␇]]ｓ＄)＇␉vλ␒|／．",
	}, { // 534
		mask: EncodeColon | EncodeLeftPeriod,
		in:   "φπ.k？␟μｆ\x13ｚ.：;［｜␆0␄Ｓνρ%６｜13\r.\x02\x01",
		out:  "φπ.k？␟μｆ\x13ｚ.‛：;［｜␆0␄Ｓνρ%６｜13\r.\x02\x01",
	}, { // 535
		mask: EncodeColon | EncodeLeftPeriod,
		in:   ".．.k？␟μｆ\x13ｚ.：;［｜␆0␄Ｓνρ%６｜13\r.\x02\x01",
		out:  "．．.k？␟μｆ\x13ｚ.‛：;［｜␆0␄Ｓνρ%６｜13\r.\x02\x01",
	}, { // 536
		mask: EncodeColon | EncodeLeftPeriod,
		in:   "．．.k？␟μｆ\x13ｚ.：;［｜␆0␄Ｓνρ%６｜13\r.\x02\x01",
		out:  "‛．．.k？␟μｆ\x13ｚ.‛：;［｜␆0␄Ｓνρ%６｜13\r.\x02\x01",
	}, { // 537
		mask: EncodeColon | EncodeLeftPeriod,
		in:   ".π.k？␟μｆ\x13ｚ.：;［｜␆0␄Ｓνρ%６｜13\r.．\x01",
		out:  "．π.k？␟μｆ\x13ｚ.‛：;［｜␆0␄Ｓνρ%６｜13\r.．\x01",
	}, { // 538
		mask: EncodeColon | EncodeLeftPeriod,
		in:   "．π.k？␟μｆ\x13ｚ.：;［｜␆0␄Ｓνρ%６｜13\r.．\x01",
		out:  "‛．π.k？␟μｆ\x13ｚ.‛：;［｜␆0␄Ｓνρ%６｜13\r.．\x01",
	}, { // 539
		mask: EncodeColon | EncodeLeftPeriod,
		in:   ".π.k？␟μｆ\x13ｚ.：;［｜␆0␄Ｓνρ%６｜13\r.\x02．",
		out:  "．π.k？␟μｆ\x13ｚ.‛：;［｜␆0␄Ｓνρ%６｜13\r.\x02．",
	}, { // 540
		mask: EncodeColon | EncodeLeftPeriod,
		in:   "．π.k？␟μｆ\x13ｚ.：;［｜␆0␄Ｓνρ%６｜13\r.\x02．",
		out:  "‛．π.k？␟μｆ\x13ｚ.‛：;［｜␆0␄Ｓνρ%６｜13\r.\x02．",
	}, { // 541
		mask: EncodeColon | EncodeLeftPeriod,
		in:   "φ..k？␟μｆ\x13ｚ.：;［｜␆0␄Ｓνρ%６｜13\r.\x02\x01",
		out:  "φ..k？␟μｆ\x13ｚ.‛：;［｜␆0␄Ｓνρ%６｜13\r.\x02\x01",
	}, { // 542
		mask: EncodeColon | EncodeLeftPeriod,
		in:   "φ．.k？␟μｆ\x13ｚ.：;［｜␆0␄Ｓνρ%６｜13\r.\x02\x01",
		out:  "φ．.k？␟μｆ\x13ｚ.‛：;［｜␆0␄Ｓνρ%６｜13\r.\x02\x01",
	}, { // 543
		mask: EncodeColon | EncodeLeftPeriod,
		in:   "φ..k？␟μｆ\x13ｚ.：;［｜␆0␄Ｓνρ%６｜13\r.．\x01",
		out:  "φ..k？␟μｆ\x13ｚ.‛：;［｜␆0␄Ｓνρ%６｜13\r.．\x01",
	}, { // 544
		mask: EncodeColon | EncodeLeftPeriod,
		in:   "φ．.k？␟μｆ\x13ｚ.：;［｜␆0␄Ｓνρ%６｜13\r.．\x01",
		out:  "φ．.k？␟μｆ\x13ｚ.‛：;［｜␆0␄Ｓνρ%６｜13\r.．\x01",
	}, { // 545
		mask: EncodeColon | EncodeLeftPeriod,
		in:   "φ..k？␟μｆ\x13ｚ.：;［｜␆0␄Ｓνρ%６｜13\r.\x02．",
		out:  "φ..k？␟μｆ\x13ｚ.‛：;［｜␆0␄Ｓνρ%６｜13\r.\x02．",
	}, { // 546
		mask: EncodeColon | EncodeLeftPeriod,
		in:   "φ．.k？␟μｆ\x13ｚ.：;［｜␆0␄Ｓνρ%６｜13\r.\x02．",
		out:  "φ．.k？␟μｆ\x13ｚ.‛：;［｜␆0␄Ｓνρ%６｜13\r.\x02．",
	}, { // 547
		mask: EncodeColon | EncodeLeftPeriod,
		in:   "φπ.k？␟μｆ\x13ｚ.：;［｜␆0␄Ｓνρ%６｜13\r..\x01",
		out:  "φπ.k？␟μｆ\x13ｚ.‛：;［｜␆0␄Ｓνρ%６｜13\r..\x01",
	}, { // 548
		mask: EncodeColon | EncodeLeftPeriod,
		in:   "φπ.k？␟μｆ\x13ｚ.：;［｜␆0␄Ｓνρ%６｜13\r.．\x01",
		out:  "φπ.k？␟μｆ\x13ｚ.‛：;［｜␆0␄Ｓνρ%６｜13\r.．\x01",
	}, { // 549
		mask: EncodeColon | EncodeLeftPeriod,
		in:   "φπ.k？␟μｆ\x13ｚ.：;［｜␆0␄Ｓνρ%６｜13\r..．",
		out:  "φπ.k？␟μｆ\x13ｚ.‛：;［｜␆0␄Ｓνρ%６｜13\r..．",
	}, { // 550
		mask: EncodeColon | EncodeLeftPeriod,
		in:   "φπ.k？␟μｆ\x13ｚ.：;［｜␆0␄Ｓνρ%６｜13\r.．．",
		out:  "φπ.k？␟μｆ\x13ｚ.‛：;［｜␆0␄Ｓνρ%６｜13\r.．．",
	}, { // 551
		mask: EncodeColon | EncodeLeftPeriod,
		in:   "φπ.k？␟μｆ\x13ｚ.：;［｜␆0␄Ｓνρ%６｜13\r.\x02.",
		out:  "φπ.k？␟μｆ\x13ｚ.‛：;［｜␆0␄Ｓνρ%６｜13\r.\x02.",
	}, { // 552
		mask: EncodeColon | EncodeLeftPeriod,
		in:   "φπ.k？␟μｆ\x13ｚ.：;［｜␆0␄Ｓνρ%６｜13\r.\x02．",
		out:  "φπ.k？␟μｆ\x13ｚ.‛：;［｜␆0␄Ｓνρ%６｜13\r.\x02．",
	}, { // 553
		mask: EncodeQuestion | EncodeLeftPeriod,
		in:   "\x04δ!\x17υＳ＃␉ς［.\\>␟Ｖχς！\x13;ξ\x17\x10８Fg␄8Ｕｉ",
		out:  "\x04δ!\x17υＳ＃␉ς［.\\>␟Ｖχς！\x13;ξ\x17\x10８Fg␄8Ｕｉ",
	}, { // 554
		mask: EncodeQuestion | EncodeLeftPeriod,
		in:   ".．!\x17υＳ＃␉ς［.\\>␟Ｖχς！\x13;ξ\x17\x10８Fg␄8Ｕｉ",
		out:  "．．!\x17υＳ＃␉ς［.\\>␟Ｖχς！\x13;ξ\x17\x10８Fg␄8Ｕｉ",
	}, { // 555
		mask: EncodeQuestion | EncodeLeftPeriod,
		in:   "．．!\x17υＳ＃␉ς［.\\>␟Ｖχς！\x13;ξ\x17\x10８Fg␄8Ｕｉ",
		out:  "‛．．!\x17υＳ＃␉ς［.\\>␟Ｖχς！\x13;ξ\x17\x10８Fg␄8Ｕｉ",
	}, { // 556
		mask: EncodeQuestion | EncodeLeftPeriod,
		in:   ".δ!\x17υＳ＃␉ς［.\\>␟Ｖχς！\x13;ξ\x17\x10８Fg␄8．ｉ",
		out:  "．δ!\x17υＳ＃␉ς［.\\>␟Ｖχς！\x13;ξ\x17\x10８Fg␄8．ｉ",
	}, { // 557
		mask: EncodeQuestion | EncodeLeftPeriod,
		in:   "．δ!\x17υＳ＃␉ς［.\\>␟Ｖχς！\x13;ξ\x17\x10８Fg␄8．ｉ",
		out:  "‛．δ!\x17υＳ＃␉ς［.\\>␟Ｖχς！\x13;ξ\x17\x10８Fg␄8．ｉ",
	}, { // 558
		mask: EncodeQuestion | EncodeLeftPeriod,
		in:   ".δ!\x17υＳ＃␉ς［.\\>␟Ｖχς！\x13;ξ\x17\x10８Fg␄8Ｕ．",
		out:  "．δ!\x17υＳ＃␉ς［.\\>␟Ｖχς！\x13;ξ\x17\x10８Fg␄8Ｕ．",
	}, { // 559
		mask: EncodeQuestion | EncodeLeftPeriod,
		in:   "．δ!\x17υＳ＃␉ς［.\\>␟Ｖχς！\x13;ξ\x17\x10８Fg␄8Ｕ．",
		out:  "‛．δ!\x17υＳ＃␉ς［.\\>␟Ｖχς！\x13;ξ\x17\x10８Fg␄8Ｕ．",
	}, { // 560
		mask: EncodeQuestion | EncodeLeftPeriod,
		in:   "\x04.!\x17υＳ＃␉ς［.\\>␟Ｖχς！\x13;ξ\x17\x10８Fg␄8Ｕｉ",
		out:  "\x04.!\x17υＳ＃␉ς［.\\>␟Ｖχς！\x13;ξ\x17\x10８Fg␄8Ｕｉ",
	}, { // 561
		mask: EncodeQuestion | EncodeLeftPeriod,
		in:   "\x04．!\x17υＳ＃␉ς［.\\>␟Ｖχς！\x13;ξ\x17\x10８Fg␄8Ｕｉ",
		out:  "\x04．!\x17υＳ＃␉ς［.\\>␟Ｖχς！\x13;ξ\x17\x10８Fg␄8Ｕｉ",
	}, { // 562
		mask: EncodeQuestion | EncodeLeftPeriod,
		in:   "\x04.!\x17υＳ＃␉ς［.\\>␟Ｖχς！\x13;ξ\x17\x10８Fg␄8．ｉ",
		out:  "\x04.!\x17υＳ＃␉ς［.\\>␟Ｖχς！\x13;ξ\x17\x10８Fg␄8．ｉ",
	}, { // 563
		mask: EncodeQuestion | EncodeLeftPeriod,
		in:   "\x04．!\x17υＳ＃␉ς［.\\>␟Ｖχς！\x13;ξ\x17\x10８Fg␄8．ｉ",
		out:  "\x04．!\x17υＳ＃␉ς［.\\>␟Ｖχς！\x13;ξ\x17\x10８Fg␄8．ｉ",
	}, { // 564
		mask: EncodeQuestion | EncodeLeftPeriod,
		in:   "\x04.!\x17υＳ＃␉ς［.\\>␟Ｖχς！\x13;ξ\x17\x10８Fg␄8Ｕ．",
		out:  "\x04.!\x17υＳ＃␉ς［.\\>␟Ｖχς！\x13;ξ\x17\x10８Fg␄8Ｕ．",
	}, { // 565
		mask: EncodeQuestion | EncodeLeftPeriod,
		in:   "\x04．!\x17υＳ＃␉ς［.\\>␟Ｖχς！\x13;ξ\x17\x10８Fg␄8Ｕ．",
		out:  "\x04．!\x17υＳ＃␉ς［.\\>␟Ｖχς！\x13;ξ\x17\x10８Fg␄8Ｕ．",
	}, { // 566
		mask: EncodeQuestion | EncodeLeftPeriod,
		in:   "\x04δ!\x17υＳ＃␉ς［.\\>␟Ｖχς！\x13;ξ\x17\x10８Fg␄8.ｉ",
		out:  "\x04δ!\x17υＳ＃␉ς［.\\>␟Ｖχς！\x13;ξ\x17\x10８Fg␄8.ｉ",
	}, { // 567
		mask: EncodeQuestion | EncodeLeftPeriod,
		in:   "\x04δ!\x17υＳ＃␉ς［.\\>␟Ｖχς！\x13;ξ\x17\x10８Fg␄8．ｉ",
		out:  "\x04δ!\x17υＳ＃␉ς［.\\>␟Ｖχς！\x13;ξ\x17\x10８Fg␄8．ｉ",
	}, { // 568
		mask: EncodeQuestion | EncodeLeftPeriod,
		in:   "\x04δ!\x17υＳ＃␉ς［.\\>␟Ｖχς！\x13;ξ\x17\x10８Fg␄8.．",
		out:  "\x04δ!\x17υＳ＃␉ς［.\\>␟Ｖχς！\x13;ξ\x17\x10８Fg␄8.．",
	}, { // 569
		mask: EncodeQuestion | EncodeLeftPeriod,
		in:   "\x04δ!\x17υＳ＃␉ς［.\\>␟Ｖχς！\x13;ξ\x17\x10８Fg␄8．．",
		out:  "\x04δ!\x17υＳ＃␉ς［.\\>␟Ｖχς！\x13;ξ\x17\x10８Fg␄8．．",
	}, { // 570
		mask: EncodeQuestion | EncodeLeftPeriod,
		in:   "\x04δ!\x17υＳ＃␉ς［.\\>␟Ｖχς！\x13;ξ\x17\x10８Fg␄8Ｕ.",
		out:  "\x04δ!\x17υＳ＃␉ς［.\\>␟Ｖχς！\x13;ξ\x17\x10８Fg␄8Ｕ.",
	}, { // 571
		mask: EncodeQuestion | EncodeLeftPeriod,
		in:   "\x04δ!\x17υＳ＃␉ς［.\\>␟Ｖχς！\x13;ξ\x17\x10８Fg␄8Ｕ．",
		out:  "\x04δ!\x17υＳ＃␉ς［.\\>␟Ｖχς！\x13;ξ\x17\x10８Fg␄8Ｕ．",
	}, { // 572
		mask: EncodeAsterisk | EncodeLeftPeriod,
		in:   "|Ｓ\bθ-α｜Ｋ␂␟.\x06η␎&\x13＄␊7（θ｛ωf␓／e|τ<",
		out:  "|Ｓ\bθ-α｜Ｋ␂␟.\x06η␎&\x13＄␊7（θ｛ωf␓／e|τ<",
	}, { // 573
		mask: EncodeAsterisk | EncodeLeftPeriod,
		in:   ".．\bθ-α｜Ｋ␂␟.\x06η␎&\x13＄␊7（θ｛ωf␓／e|τ<",
		out:  "．．\bθ-α｜Ｋ␂␟.\x06η␎&\x13＄␊7（θ｛ωf␓／e|τ<",
	}, { // 574
		mask: EncodeAsterisk | EncodeLeftPeriod,
		in:   "．．\bθ-α｜Ｋ␂␟.\x06η␎&\x13＄␊7（θ｛ωf␓／e|τ<",
		out:  "‛．．\bθ-α｜Ｋ␂␟.\x06η␎&\x13＄␊7（θ｛ωf␓／e|τ<",
	}, { // 575
		mask: EncodeAsterisk | EncodeLeftPeriod,
		in:   ".Ｓ\bθ-α｜Ｋ␂␟.\x06η␎&\x13＄␊7（θ｛ωf␓／e|．<",
		out:  "．Ｓ\bθ-α｜Ｋ␂␟.\x06η␎&\x13＄␊7（θ｛ωf␓／e|．<",
	}, { // 576
		mask: EncodeAsterisk | EncodeLeftPeriod,
		in:   "．Ｓ\bθ-α｜Ｋ␂␟.\x06η␎&\x13＄␊7（θ｛ωf␓／e|．<",
		out:  "‛．Ｓ\bθ-α｜Ｋ␂␟.\x06η␎&\x13＄␊7（θ｛ωf␓／e|．<",
	}, { // 577
		mask: EncodeAsterisk | EncodeLeftPeriod,
		in:   ".Ｓ\bθ-α｜Ｋ␂␟.\x06η␎&\x13＄␊7（θ｛ωf␓／e|τ．",
		out:  "．Ｓ\bθ-α｜Ｋ␂␟.\x06η␎&\x13＄␊7（θ｛ωf␓／e|τ．",
	}, { // 578
		mask: EncodeAsterisk | EncodeLeftPeriod,
		in:   "．Ｓ\bθ-α｜Ｋ␂␟.\x06η␎&\x13＄␊7（θ｛ωf␓／e|τ．",
		out:  "‛．Ｓ\bθ-α｜Ｋ␂␟.\x06η␎&\x13＄␊7（θ｛ωf␓／e|τ．",
	}, { // 579
		mask: EncodeAsterisk | EncodeLeftPeriod,
		in:   "|.\bθ-α｜Ｋ␂␟.\x06η␎&\x13＄␊7（θ｛ωf␓／e|τ<",
		out:  "|.\bθ-α｜Ｋ␂␟.\x06η␎&\x13＄␊7（θ｛ωf␓／e|τ<",
	}, { // 580
		mask: EncodeAsterisk | EncodeLeftPeriod,
		in:   "|．\bθ-α｜Ｋ␂␟.\x06η␎&\x13＄␊7（θ｛ωf␓／e|τ<",
		out:  "|．\bθ-α｜Ｋ␂␟.\x06η␎&\x13＄␊7（θ｛ωf␓／e|τ<",
	}, { // 581
		mask: EncodeAsterisk | EncodeLeftPeriod,
		in:   "|.\bθ-α｜Ｋ␂␟.\x06η␎&\x13＄␊7（θ｛ωf␓／e|．<",
		out:  "|.\bθ-α｜Ｋ␂␟.\x06η␎&\x13＄␊7（θ｛ωf␓／e|．<",
	}, { // 582
		mask: EncodeAsterisk | EncodeLeftPeriod,
		in:   "|．\bθ-α｜Ｋ␂␟.\x06η␎&\x13＄␊7（θ｛ωf␓／e|．<",
		out:  "|．\bθ-α｜Ｋ␂␟.\x06η␎&\x13＄␊7（θ｛ωf␓／e|．<",
	}, { // 583
		mask: EncodeAsterisk | EncodeLeftPeriod,
		in:   "|.\bθ-α｜Ｋ␂␟.\x06η␎&\x13＄␊7（θ｛ωf␓／e|τ．",
		out:  "|.\bθ-α｜Ｋ␂␟.\x06η␎&\x13＄␊7（θ｛ωf␓／e|τ．",
	}, { // 584
		mask: EncodeAsterisk | EncodeLeftPeriod,
		in:   "|．\bθ-α｜Ｋ␂␟.\x06η␎&\x13＄␊7（θ｛ωf␓／e|τ．",
		out:  "|．\bθ-α｜Ｋ␂␟.\x06η␎&\x13＄␊7（θ｛ωf␓／e|τ．",
	}, { // 585
		mask: EncodeAsterisk | EncodeLeftPeriod,
		in:   "|Ｓ\bθ-α｜Ｋ␂␟.\x06η␎&\x13＄␊7（θ｛ωf␓／e|.<",
		out:  "|Ｓ\bθ-α｜Ｋ␂␟.\x06η␎&\x13＄␊7（θ｛ωf␓／e|.<",
	}, { // 586
		mask: EncodeAsterisk | EncodeLeftPeriod,
		in:   "|Ｓ\bθ-α｜Ｋ␂␟.\x06η␎&\x13＄␊7（θ｛ωf␓／e|．<",
		out:  "|Ｓ\bθ-α｜Ｋ␂␟.\x06η␎&\x13＄␊7（θ｛ωf␓／e|．<",
	}, { // 587
		mask: EncodeAsterisk | EncodeLeftPeriod,
		in:   "|Ｓ\bθ-α｜Ｋ␂␟.\x06η␎&\x13＄␊7（θ｛ωf␓／e|.．",
		out:  "|Ｓ\bθ-α｜Ｋ␂␟.\x06η␎&\x13＄␊7（θ｛ωf␓／e|.．",
	}, { // 588
		mask: EncodeAsterisk | EncodeLeftPeriod,
		in:   "|Ｓ\bθ-α｜Ｋ␂␟.\x06η␎&\x13＄␊7（θ｛ωf␓／e|．．",
		out:  "|Ｓ\bθ-α｜Ｋ␂␟.\x06η␎&\x13＄␊7（θ｛ωf␓／e|．．",
	}, { // 589
		mask: EncodeAsterisk | EncodeLeftPeriod,
		in:   "|Ｓ\bθ-α｜Ｋ␂␟.\x06η␎&\x13＄␊7（θ｛ωf␓／e|τ.",
		out:  "|Ｓ\bθ-α｜Ｋ␂␟.\x06η␎&\x13＄␊7（θ｛ωf␓／e|τ.",
	}, { // 590
		mask: EncodeAsterisk | EncodeLeftPeriod,
		in:   "|Ｓ\bθ-α｜Ｋ␂␟.\x06η␎&\x13＄␊7（θ｛ωf␓／e|τ．",
		out:  "|Ｓ\bθ-α｜Ｋ␂␟.\x06η␎&\x13＄␊7（θ｛ωf␓／e|τ．",
	}, { // 591
		mask: EncodePipe | EncodeLeftPeriod,
		in:   "␊\x164␁$）＼Ｌ：[.{φ｀＜tκ\\εＬ４␍μσλ\x12 6\x1b＾",
		out:  "␊\x164␁$）＼Ｌ：[.{φ｀＜tκ\\εＬ４␍μσλ\x12 6\x1b＾",
	}, { // 592
		mask: EncodePipe | EncodeLeftPeriod,
		in:   ".．4␁$）＼Ｌ：[.{φ｀＜tκ\\εＬ４␍μσλ\x12 6\x1b＾",
		out:  "．．4␁$）＼Ｌ：[.{φ｀＜tκ\\εＬ４␍μσλ\x12 6\x1b＾",
	}, { // 593
		mask: EncodePipe | EncodeLeftPeriod,
		in:   "．．4␁$）＼Ｌ：[.{φ｀＜tκ\\εＬ４␍μσλ\x12 6\x1b＾",
		out:  "‛．．4␁$）＼Ｌ：[.{φ｀＜tκ\\εＬ４␍μσλ\x12 6\x1b＾",
	}, { // 594
		mask: EncodePipe | EncodeLeftPeriod,
		in:   ".\x164␁$）＼Ｌ：[.{φ｀＜tκ\\εＬ４␍μσλ\x12 6．＾",
		out:  "．\x164␁$）＼Ｌ：[.{φ｀＜tκ\\εＬ４␍μσλ\x12 6．＾",
	}, { // 595
		mask: EncodePipe | EncodeLeftPeriod,
		in:   "．\x164␁$）＼Ｌ：[.{φ｀＜tκ\\εＬ４␍μσλ\x12 6．＾",
		out:  "‛．\x164␁$）＼Ｌ：[.{φ｀＜tκ\\εＬ４␍μσλ\x12 6．＾",
	}, { // 596
		mask: EncodePipe | EncodeLeftPeriod,
		in:   ".\x164␁$）＼Ｌ：[.{φ｀＜tκ\\εＬ４␍μσλ\x12 6\x1b．",
		out:  "．\x164␁$）＼Ｌ：[.{φ｀＜tκ\\εＬ４␍μσλ\x12 6\x1b．",
	}, { // 597
		mask: EncodePipe | EncodeLeftPeriod,
		in:   "．\x164␁$）＼Ｌ：[.{φ｀＜tκ\\εＬ４␍μσλ\x12 6\x1b．",
		out:  "‛．\x164␁$）＼Ｌ：[.{φ｀＜tκ\\εＬ４␍μσλ\x12 6\x1b．",
	}, { // 598
		mask: EncodePipe | EncodeLeftPeriod,
		in:   "␊.4␁$）＼Ｌ：[.{φ｀＜tκ\\εＬ４␍μσλ\x12 6\x1b＾",
		out:  "␊.4␁$）＼Ｌ：[.{φ｀＜tκ\\εＬ４␍μσλ\x12 6\x1b＾",
	}, { // 599
		mask: EncodePipe | EncodeLeftPeriod,
		in:   "␊．4␁$）＼Ｌ：[.{φ｀＜tκ\\εＬ４␍μσλ\x12 6\x1b＾",
		out:  "␊．4␁$）＼Ｌ：[.{φ｀＜tκ\\εＬ４␍μσλ\x12 6\x1b＾",
	}, { // 600
		mask: EncodePipe | EncodeLeftPeriod,
		in:   "␊.4␁$）＼Ｌ：[.{φ｀＜tκ\\εＬ４␍μσλ\x12 6．＾",
		out:  "␊.4␁$）＼Ｌ：[.{φ｀＜tκ\\εＬ４␍μσλ\x12 6．＾",
	}, { // 601
		mask: EncodePipe | EncodeLeftPeriod,
		in:   "␊．4␁$）＼Ｌ：[.{φ｀＜tκ\\εＬ４␍μσλ\x12 6．＾",
		out:  "␊．4␁$）＼Ｌ：[.{φ｀＜tκ\\εＬ４␍μσλ\x12 6．＾",
	}, { // 602
		mask: EncodePipe | EncodeLeftPeriod,
		in:   "␊.4␁$）＼Ｌ：[.{φ｀＜tκ\\εＬ４␍μσλ\x12 6\x1b．",
		out:  "␊.4␁$）＼Ｌ：[.{φ｀＜tκ\\εＬ４␍μσλ\x12 6\x1b．",
	}, { // 603
		mask: EncodePipe | EncodeLeftPeriod,
		in:   "␊．4␁$）＼Ｌ：[.{φ｀＜tκ\\εＬ４␍μσλ\x12 6\x1b．",
		out:  "␊．4␁$）＼Ｌ：[.{φ｀＜tκ\\εＬ４␍μσλ\x12 6\x1b．",
	}, { // 604
		mask: EncodePipe | EncodeLeftPeriod,
		in:   "␊\x164␁$）＼Ｌ：[.{φ｀＜tκ\\εＬ４␍μσλ\x12 6.＾",
		out:  "␊\x164␁$）＼Ｌ：[.{φ｀＜tκ\\εＬ４␍μσλ\x12 6.＾",
	}, { // 605
		mask: EncodePipe | EncodeLeftPeriod,
		in:   "␊\x164␁$）＼Ｌ：[.{φ｀＜tκ\\εＬ４␍μσλ\x12 6．＾",
		out:  "␊\x164␁$）＼Ｌ：[.{φ｀＜tκ\\εＬ４␍μσλ\x12 6．＾",
	}, { // 606
		mask: EncodePipe | EncodeLeftPeriod,
		in:   "␊\x164␁$）＼Ｌ：[.{φ｀＜tκ\\εＬ４␍μσλ\x12 6.．",
		out:  "␊\x164␁$）＼Ｌ：[.{φ｀＜tκ\\εＬ４␍μσλ\x12 6.．",
	}, { // 607
		mask: EncodePipe | EncodeLeftPeriod,
		in:   "␊\x164␁$）＼Ｌ：[.{φ｀＜tκ\\εＬ４␍μσλ\x12 6．．",
		out:  "␊\x164␁$）＼Ｌ：[.{φ｀＜tκ\\εＬ４␍μσλ\x12 6．．",
	}, { // 608
		mask: EncodePipe | EncodeLeftPeriod,
		in:   "␊\x164␁$）＼Ｌ：[.{φ｀＜tκ\\εＬ４␍μσλ\x12 6\x1b.",
		out:  "␊\x164␁$）＼Ｌ：[.{φ｀＜tκ\\εＬ４␍μσλ\x12 6\x1b.",
	}, { // 609
		mask: EncodePipe | EncodeLeftPeriod,
		in:   "␊\x164␁$）＼Ｌ：[.{φ｀＜tκ\\εＬ４␍μσλ\x12 6\x1b．",
		out:  "␊\x164␁$）＼Ｌ：[.{φ｀＜tκ\\εＬ４␍μσλ\x12 6\x1b．",
	}, { // 610
		mask: EncodeHash | EncodeLeftPeriod,
		in:   "η␊ｗＷ␑␎ｂ\x1f［S.\bQTδση{␋］\r＜\vθ\x1e␃)ＩBι",
		out:  "η␊ｗＷ␑␎ｂ\x1f［S.\bQTδση{␋］\r＜\vθ\x1e␃)ＩBι",
	}, { // 611
		mask: EncodeHash | EncodeLeftPeriod,
		in:   ".．ｗＷ␑␎ｂ\x1f［S.\bQTδση{␋］\r＜\vθ\x1e␃)ＩBι",
		out:  "．．ｗＷ␑␎ｂ\x1f［S.\bQTδση{␋］\r＜\vθ\x1e␃)ＩBι",
	}, { // 612
		mask: EncodeHash | EncodeLeftPeriod,
		in:   "．．ｗＷ␑␎ｂ\x1f［S.\bQTδση{␋］\r＜\vθ\x1e␃)ＩBι",
		out:  "‛．．ｗＷ␑␎ｂ\x1f［S.\bQTδση{␋］\r＜\vθ\x1e␃)ＩBι",
	}, { // 613
		mask: EncodeHash | EncodeLeftPeriod,
		in:   ".␊ｗＷ␑␎ｂ\x1f［S.\bQTδση{␋］\r＜\vθ\x1e␃)Ｉ．ι",
		out:  "．␊ｗＷ␑␎ｂ\x1f［S.\bQTδση{␋］\r＜\vθ\x1e␃)Ｉ．ι",
	}, { // 614
		mask: EncodeHash | EncodeLeftPeriod,
		in:   "．␊ｗＷ␑␎ｂ\x1f［S.\bQTδση{␋］\r＜\vθ\x1e␃)Ｉ．ι",
		out:  "‛．␊ｗＷ␑␎ｂ\x1f［S.\bQTδση{␋］\r＜\vθ\x1e␃)Ｉ．ι",
	}, { // 615
		mask: EncodeHash | EncodeLeftPeriod,
		in:   ".␊ｗＷ␑␎ｂ\x1f［S.\bQTδση{␋］\r＜\vθ\x1e␃)ＩB．",
		out:  "．␊ｗＷ␑␎ｂ\x1f［S.\bQTδση{␋］\r＜\vθ\x1e␃)ＩB．",
	}, { // 616
		mask: EncodeHash | EncodeLeftPeriod,
		in:   "．␊ｗＷ␑␎ｂ\x1f［S.\bQTδση{␋］\r＜\vθ\x1e␃)ＩB．",
		out:  "‛．␊ｗＷ␑␎ｂ\x1f［S.\bQTδση{␋］\r＜\vθ\x1e␃)ＩB．",
	}, { // 617
		mask: EncodeHash | EncodeLeftPeriod,
		in:   "η.ｗＷ␑␎ｂ\x1f［S.\bQTδση{␋］\r＜\vθ\x1e␃)ＩBι",
		out:  "η.ｗＷ␑␎ｂ\x1f［S.\bQTδση{␋］\r＜\vθ\x1e␃)ＩBι",
	}, { // 618
		mask: EncodeHash | EncodeLeftPeriod,
		in:   "η．ｗＷ␑␎ｂ\x1f［S.\bQTδση{␋］\r＜\vθ\x1e␃)ＩBι",
		out:  "η．ｗＷ␑␎ｂ\x1f［S.\bQTδση{␋］\r＜\vθ\x1e␃)ＩBι",
	}, { // 619
		mask: EncodeHash | EncodeLeftPeriod,
		in:   "η.ｗＷ␑␎ｂ\x1f［S.\bQTδση{␋］\r＜\vθ\x1e␃)Ｉ．ι",
		out:  "η.ｗＷ␑␎ｂ\x1f［S.\bQTδση{␋］\r＜\vθ\x1e␃)Ｉ．ι",
	}, { // 620
		mask: EncodeHash | EncodeLeftPeriod,
		in:   "η．ｗＷ␑␎ｂ\x1f［S.\bQTδση{␋］\r＜\vθ\x1e␃)Ｉ．ι",
		out:  "η．ｗＷ␑␎ｂ\x1f［S.\bQTδση{␋］\r＜\vθ\x1e␃)Ｉ．ι",
	}, { // 621
		mask: EncodeHash | EncodeLeftPeriod,
		in:   "η.ｗＷ␑␎ｂ\x1f［S.\bQTδση{␋］\r＜\vθ\x1e␃)ＩB．",
		out:  "η.ｗＷ␑␎ｂ\x1f［S.\bQTδση{␋］\r＜\vθ\x1e␃)ＩB．",
	}, { // 622
		mask: EncodeHash | EncodeLeftPeriod,
		in:   "η．ｗＷ␑␎ｂ\x1f［S.\bQTδση{␋］\r＜\vθ\x1e␃)ＩB．",
		out:  "η．ｗＷ␑␎ｂ\x1f［S.\bQTδση{␋］\r＜\vθ\x1e␃)ＩB．",
	}, { // 623
		mask: EncodeHash | EncodeLeftPeriod,
		in:   "η␊ｗＷ␑␎ｂ\x1f［S.\bQTδση{␋］\r＜\vθ\x1e␃)Ｉ.ι",
		out:  "η␊ｗＷ␑␎ｂ\x1f［S.\bQTδση{␋］\r＜\vθ\x1e␃)Ｉ.ι",
	}, { // 624
		mask: EncodeHash | EncodeLeftPeriod,
		in:   "η␊ｗＷ␑␎ｂ\x1f［S.\bQTδση{␋］\r＜\vθ\x1e␃)Ｉ．ι",
		out:  "η␊ｗＷ␑␎ｂ\x1f［S.\bQTδση{␋］\r＜\vθ\x1e␃)Ｉ．ι",
	}, { // 625
		mask: EncodeHash | EncodeLeftPeriod,
		in:   "η␊ｗＷ␑␎ｂ\x1f［S.\bQTδση{␋］\r＜\vθ\x1e␃)Ｉ.．",
		out:  "η␊ｗＷ␑␎ｂ\x1f［S.\bQTδση{␋］\r＜\vθ\x1e␃)Ｉ.．",
	}, { // 626
		mask: EncodeHash | EncodeLeftPeriod,
		in:   "η␊ｗＷ␑␎ｂ\x1f［S.\bQTδση{␋］\r＜\vθ\x1e␃)Ｉ．．",
		out:  "η␊ｗＷ␑␎ｂ\x1f［S.\bQTδση{␋］\r＜\vθ\x1e␃)Ｉ．．",
	}, { // 627
		mask: EncodeHash | EncodeLeftPeriod,
		in:   "η␊ｗＷ␑␎ｂ\x1f［S.\bQTδση{␋］\r＜\vθ\x1e␃)ＩB.",
		out:  "η␊ｗＷ␑␎ｂ\x1f［S.\bQTδση{␋］\r＜\vθ\x1e␃)ＩB.",
	}, { // 628
		mask: EncodeHash | EncodeLeftPeriod,
		in:   "η␊ｗＷ␑␎ｂ\x1f［S.\bQTδση{␋］\r＜\vθ\x1e␃)ＩB．",
		out:  "η␊ｗＷ␑␎ｂ\x1f［S.\bQTδση{␋］\r＜\vθ\x1e␃)ＩB．",
	}, { // 629
		mask: EncodePercent | EncodeLeftPeriod,
		in:   "q＄ｃ＄Mλ0␊ｊ#.\x1cδyηＶ␄ψ／λ＋＄$\ah\tο\u007f␛Ｘ",
		out:  "q＄ｃ＄Mλ0␊ｊ#.\x1cδyηＶ␄ψ／λ＋＄$\ah\tο\u007f␛Ｘ",
	}, { // 630
		mask: EncodePercent | EncodeLeftPeriod,
		in:   ".．ｃ＄Mλ0␊ｊ#.\x1cδyηＶ␄ψ／λ＋＄$\ah\tο\u007f␛Ｘ",
		out:  "．．ｃ＄Mλ0␊ｊ#.\x1cδyηＶ␄ψ／λ＋＄$\ah\tο\u007f␛Ｘ",
	}, { // 631
		mask: EncodePercent | EncodeLeftPeriod,
		in:   "．．ｃ＄Mλ0␊ｊ#.\x1cδyηＶ␄ψ／λ＋＄$\ah\tο\u007f␛Ｘ",
		out:  "‛．．ｃ＄Mλ0␊ｊ#.\x1cδyηＶ␄ψ／λ＋＄$\ah\tο\u007f␛Ｘ",
	}, { // 632
		mask: EncodePercent | EncodeLeftPeriod,
		in:   ".＄ｃ＄Mλ0␊ｊ#.\x1cδyηＶ␄ψ／λ＋＄$\ah\tο\u007f．Ｘ",
		out:  "．＄ｃ＄Mλ0␊ｊ#.\x1cδyηＶ␄ψ／λ＋＄$\ah\tο\u007f．Ｘ",
	}, { // 633
		mask: EncodePercent | EncodeLeftPeriod,
		in:   "．＄ｃ＄Mλ0␊ｊ#.\x1cδyηＶ␄ψ／λ＋＄$\ah\tο\u007f．Ｘ",
		out:  "‛．＄ｃ＄Mλ0␊ｊ#.\x1cδyηＶ␄ψ／λ＋＄$\ah\tο\u007f．Ｘ",
	}, { // 634
		mask: EncodePercent | EncodeLeftPeriod,
		in:   ".＄ｃ＄Mλ0␊ｊ#.\x1cδyηＶ␄ψ／λ＋＄$\ah\tο\u007f␛．",
		out:  "．＄ｃ＄Mλ0␊ｊ#.\x1cδyηＶ␄ψ／λ＋＄$\ah\tο\u007f␛．",
	}, { // 635
		mask: EncodePercent | EncodeLeftPeriod,
		in:   "．＄ｃ＄Mλ0␊ｊ#.\x1cδyηＶ␄ψ／λ＋＄$\ah\tο\u007f␛．",
		out:  "‛．＄ｃ＄Mλ0␊ｊ#.\x1cδyηＶ␄ψ／λ＋＄$\ah\tο\u007f␛．",
	}, { // 636
		mask: EncodePercent | EncodeLeftPeriod,
		in:   "q.ｃ＄Mλ0␊ｊ#.\x1cδyηＶ␄ψ／λ＋＄$\ah\tο\u007f␛Ｘ",
		out:  "q.ｃ＄Mλ0␊ｊ#.\x1cδyηＶ␄ψ／λ＋＄$\ah\tο\u007f␛Ｘ",
	}, { // 637
		mask: EncodePercent | EncodeLeftPeriod,
		in:   "q．ｃ＄Mλ0␊ｊ#.\x1cδyηＶ␄ψ／λ＋＄$\ah\tο\u007f␛Ｘ",
		out:  "q．ｃ＄Mλ0␊ｊ#.\x1cδyηＶ␄ψ／λ＋＄$\ah\tο\u007f␛Ｘ",
	}, { // 638
		mask: EncodePercent | EncodeLeftPeriod,
		in:   "q.ｃ＄Mλ0␊ｊ#.\x1cδyηＶ␄ψ／λ＋＄$\ah\tο\u007f．Ｘ",
		out:  "q.ｃ＄Mλ0␊ｊ#.\x1cδyηＶ␄ψ／λ＋＄$\ah\tο\u007f．Ｘ",
	}, { // 639
		mask: EncodePercent | EncodeLeftPeriod,
		in:   "q．ｃ＄Mλ0␊ｊ#.\x1cδyηＶ␄ψ／λ＋＄$\ah\tο\u007f．Ｘ",
		out:  "q．ｃ＄Mλ0␊ｊ#.\x1cδyηＶ␄ψ／λ＋＄$\ah\tο\u007f．Ｘ",
	}, { // 640
		mask: EncodePercent | EncodeLeftPeriod,
		in:   "q.ｃ＄Mλ0␊ｊ#.\x1cδyηＶ␄ψ／λ＋＄$\ah\tο\u007f␛．",
		out:  "q.ｃ＄Mλ0␊ｊ#.\x1cδyηＶ␄ψ／λ＋＄$\ah\tο\u007f␛．",
	}, { // 641
		mask: EncodePercent | EncodeLeftPeriod,
		in:   "q．ｃ＄Mλ0␊ｊ#.\x1cδyηＶ␄ψ／λ＋＄$\ah\tο\u007f␛．",
		out:  "q．ｃ＄Mλ0␊ｊ#.\x1cδyηＶ␄ψ／λ＋＄$\ah\tο\u007f␛．",
	}, { // 642
		mask: EncodePercent | EncodeLeftPeriod,
		in:   "q＄ｃ＄Mλ0␊ｊ#.\x1cδyηＶ␄ψ／λ＋＄$\ah\tο\u007f.Ｘ",
		out:  "q＄ｃ＄Mλ0␊ｊ#.\x1cδyηＶ␄ψ／λ＋＄$\ah\tο\u007f.Ｘ",
	}, { // 643
		mask: EncodePercent | EncodeLeftPeriod,
		in:   "q＄ｃ＄Mλ0␊ｊ#.\x1cδyηＶ␄ψ／λ＋＄$\ah\tο\u007f．Ｘ",
		out:  "q＄ｃ＄Mλ0␊ｊ#.\x1cδyηＶ␄ψ／λ＋＄$\ah\tο\u007f．Ｘ",
	}, { // 644
		mask: EncodePercent | EncodeLeftPeriod,
		in:   "q＄ｃ＄Mλ0␊ｊ#.\x1cδyηＶ␄ψ／λ＋＄$\ah\tο\u007f.．",
		out:  "q＄ｃ＄Mλ0␊ｊ#.\x1cδyηＶ␄ψ／λ＋＄$\ah\tο\u007f.．",
	}, { // 645
		mask: EncodePercent | EncodeLeftPeriod,
		in:   "q＄ｃ＄Mλ0␊ｊ#.\x1cδyηＶ␄ψ／λ＋＄$\ah\tο\u007f．．",
		out:  "q＄ｃ＄Mλ0␊ｊ#.\x1cδyηＶ␄ψ／λ＋＄$\ah\tο\u007f．．",
	}, { // 646
		mask: EncodePercent | EncodeLeftPeriod,
		in:   "q＄ｃ＄Mλ0␊ｊ#.\x1cδyηＶ␄ψ／λ＋＄$\ah\tο\u007f␛.",
		out:  "q＄ｃ＄Mλ0␊ｊ#.\x1cδyηＶ␄ψ／λ＋＄$\ah\tο\u007f␛.",
	}, { // 647
		mask: EncodePercent | EncodeLeftPeriod,
		in:   "q＄ｃ＄Mλ0␊ｊ#.\x1cδyηＶ␄ψ／λ＋＄$\ah\tο\u007f␛．",
		out:  "q＄ｃ＄Mλ0␊ｊ#.\x1cδyηＶ␄ψ／λ＋＄$\ah\tο\u007f␛．",
	}, { // 648
		mask: EncodeBackSlash | EncodeLeftPeriod,
		in:   "ρｚ␜␡！␓Gb；3.␇ζχ\x16ｌ８α\x16HＲγλk␈/`\r／\x12",
		out:  "ρｚ␜␡！␓Gb；3.␇ζχ\x16ｌ８α\x16HＲγλk␈/`\r／\x12",
	}, { // 649
		mask: EncodeBackSlash | EncodeLeftPeriod,
		in:   ".．␜␡！␓Gb；3.␇ζχ\x16ｌ８α\x16HＲγλk␈/`\r／\x12",
		out:  "．．␜␡！␓Gb；3.␇ζχ\x16ｌ８α\x16HＲγλk␈/`\r／\x12",
	}, { // 650
		mask: EncodeBackSlash | EncodeLeftPeriod,
		in:   "．．␜␡！␓Gb；3.␇ζχ\x16ｌ８α\x16HＲγλk␈/`\r／\x12",
		out:  "‛．．␜␡！␓Gb；3.␇ζχ\x16ｌ８α\x16HＲγλk␈/`\r／\x12",
	}, { // 651
		mask: EncodeBackSlash | EncodeLeftPeriod,
		in:   ".ｚ␜␡！␓Gb；3.␇ζχ\x16ｌ８α\x16HＲγλk␈/`\r．\x12",
		out:  "．ｚ␜␡！␓Gb；3.␇ζχ\x16ｌ８α\x16HＲγλk␈/`\r．\x12",
	}, { // 652
		mask: EncodeBackSlash | EncodeLeftPeriod,
		in:   "．ｚ␜␡！␓Gb；3.␇ζχ\x16ｌ８α\x16HＲγλk␈/`\r．\x12",
		out:  "‛．ｚ␜␡！␓Gb；3.␇ζχ\x16ｌ８α\x16HＲγλk␈/`\r．\x12",
	}, { // 653
		mask: EncodeBackSlash | EncodeLeftPeriod,
		in:   ".ｚ␜␡！␓Gb；3.␇ζχ\x16ｌ８α\x16HＲγλk␈/`\r／．",
		out:  "．ｚ␜␡！␓Gb；3.␇ζχ\x16ｌ８α\x16HＲγλk␈/`\r／．",
	}, { // 654
		mask: EncodeBackSlash | EncodeLeftPeriod,
		in:   "．ｚ␜␡！␓Gb；3.␇ζχ\x16ｌ８α\x16HＲγλk␈/`\r／．",
		out:  "‛．ｚ␜␡！␓Gb；3.␇ζχ\x16ｌ８α\x16HＲγλk␈/`\r／．",
	}, { // 655
		mask: EncodeBackSlash | EncodeLeftPeriod,
		in:   "ρ.␜␡！␓Gb；3.␇ζχ\x16ｌ８α\x16HＲγλk␈/`\r／\x12",
		out:  "ρ.␜␡！␓Gb；3.␇ζχ\x16ｌ８α\x16HＲγλk␈/`\r／\x12",
	}, { // 656
		mask: EncodeBackSlash | EncodeLeftPeriod,
		in:   "ρ．␜␡！␓Gb；3.␇ζχ\x16ｌ８α\x16HＲγλk␈/`\r／\x12",
		out:  "ρ．␜␡！␓Gb；3.␇ζχ\x16ｌ８α\x16HＲγλk␈/`\r／\x12",
	}, { // 657
		mask: EncodeBackSlash | EncodeLeftPeriod,
		in:   "ρ.␜␡！␓Gb；3.␇ζχ\x16ｌ８α\x16HＲγλk␈/`\r．\x12",
		out:  "ρ.␜␡！␓Gb；3.␇ζχ\x16ｌ８α\x16HＲγλk␈/`\r．\x12",
	}, { // 658
		mask: EncodeBackSlash | EncodeLeftPeriod,
		in:   "ρ．␜␡！␓Gb；3.␇ζχ\x16ｌ８α\x16HＲγλk␈/`\r．\x12",
		out:  "ρ．␜␡！␓Gb；3.␇ζχ\x16ｌ８α\x16HＲγλk␈/`\r．\x12",
	}, { // 659
		mask: EncodeBackSlash | EncodeLeftPeriod,
		in:   "ρ.␜␡！␓Gb；3.␇ζχ\x16ｌ８α\x16HＲγλk␈/`\r／．",
		out:  "ρ.␜␡！␓Gb；3.␇ζχ\x16ｌ８α\x16HＲγλk␈/`\r／．",
	}, { // 660
		mask: EncodeBackSlash | EncodeLeftPeriod,
		in:   "ρ．␜␡！␓Gb；3.␇ζχ\x16ｌ８α\x16HＲγλk␈/`\r／．",
		out:  "ρ．␜␡！␓Gb；3.␇ζχ\x16ｌ８α\x16HＲγλk␈/`\r／．",
	}, { // 661
		mask: EncodeBackSlash | EncodeLeftPeriod,
		in:   "ρｚ␜␡！␓Gb；3.␇ζχ\x16ｌ８α\x16HＲγλk␈/`\r.\x12",
		out:  "ρｚ␜␡！␓Gb；3.␇ζχ\x16ｌ８α\x16HＲγλk␈/`\r.\x12",
	}, { // 662
		mask: EncodeBackSlash | EncodeLeftPeriod,
		in:   "ρｚ␜␡！␓Gb；3.␇ζχ\x16ｌ８α\x16HＲγλk␈/`\r．\x12",
		out:  "ρｚ␜␡！␓Gb；3.␇ζχ\x16ｌ８α\x16HＲγλk␈/`\r．\x12",
	}, { // 663
		mask: EncodeBackSlash | EncodeLeftPeriod,
		in:   "ρｚ␜␡！␓Gb；3.␇ζχ\x16ｌ８α\x16HＲγλk␈/`\r.．",
		out:  "ρｚ␜␡！␓Gb；3.␇ζχ\x16ｌ８α\x16HＲγλk␈/`\r.．",
	}, { // 664
		mask: EncodeBackSlash | EncodeLeftPeriod,
		in:   "ρｚ␜␡！␓Gb；3.␇ζχ\x16ｌ８α\x16HＲγλk␈/`\r．．",
		out:  "ρｚ␜␡！␓Gb；3.␇ζχ\x16ｌ８α\x16HＲγλk␈/`\r．．",
	}, { // 665
		mask: EncodeBackSlash | EncodeLeftPeriod,
		in:   "ρｚ␜␡！␓Gb；3.␇ζχ\x16ｌ８α\x16HＲγλk␈/`\r／.",
		out:  "ρｚ␜␡！␓Gb；3.␇ζχ\x16ｌ８α\x16HＲγλk␈/`\r／.",
	}, { // 666
		mask: EncodeBackSlash | EncodeLeftPeriod,
		in:   "ρｚ␜␡！␓Gb；3.␇ζχ\x16ｌ８α\x16HＲγλk␈/`\r／．",
		out:  "ρｚ␜␡！␓Gb；3.␇ζχ\x16ｌ８α\x16HＲγλk␈/`\r／．",
	}, { // 667
		mask: EncodeCrLf | EncodeLeftPeriod,
		in:   "\\zＲ＇π．\uff00/'ｎ.φ \x13␎＞ｆ\x15％|σd]ξＴαρ␡=␛",
		out:  "\\zＲ＇π．\uff00/'ｎ.φ \x13␎＞ｆ\x15％|σd]ξＴαρ␡=␛",
	}, { // 668
		mask: EncodeCrLf | EncodeLeftPeriod,
		in:   ".．Ｒ＇π．\uff00/'ｎ.φ \x13␎＞ｆ\x15％|σd]ξＴαρ␡=␛",
		out:  "．．Ｒ＇π．\uff00/'ｎ.φ \x13␎＞ｆ\x15％|σd]ξＴαρ␡=␛",
	}, { // 669
		mask: EncodeCrLf | EncodeLeftPeriod,
		in:   "．．Ｒ＇π．\uff00/'ｎ.φ \x13␎＞ｆ\x15％|σd]ξＴαρ␡=␛",
		out:  "‛．．Ｒ＇π．\uff00/'ｎ.φ \x13␎＞ｆ\x15％|σd]ξＴαρ␡=␛",
	}, { // 670
		mask: EncodeCrLf | EncodeLeftPeriod,
		in:   ".zＲ＇π．\uff00/'ｎ.φ \x13␎＞ｆ\x15％|σd]ξＴαρ␡．␛",
		out:  "．zＲ＇π．\uff00/'ｎ.φ \x13␎＞ｆ\x15％|σd]ξＴαρ␡．␛",
	}, { // 671
		mask: EncodeCrLf | EncodeLeftPeriod,
		in:   "．zＲ＇π．\uff00/'ｎ.φ \x13␎＞ｆ\x15％|σd]ξＴαρ␡．␛",
		out:  "‛．zＲ＇π．\uff00/'ｎ.φ \x13␎＞ｆ\x15％|σd]ξＴαρ␡．␛",
	}, { // 672
		mask: EncodeCrLf | EncodeLeftPeriod,
		in:   ".zＲ＇π．\uff00/'ｎ.φ \x13␎＞ｆ\x15％|σd]ξＴαρ␡=．",
		out:  "．zＲ＇π．\uff00/'ｎ.φ \x13␎＞ｆ\x15％|σd]ξＴαρ␡=．",
	}, { // 673
		mask: EncodeCrLf | EncodeLeftPeriod,
		in:   "．zＲ＇π．\uff00/'ｎ.φ \x13␎＞ｆ\x15％|σd]ξＴαρ␡=．",
		out:  "‛．zＲ＇π．\uff00/'ｎ.φ \x13␎＞ｆ\x15％|σd]ξＴαρ␡=．",
	}, { // 674
		mask: EncodeCrLf | EncodeLeftPeriod,
		in:   "\\.Ｒ＇π．\uff00/'ｎ.φ \x13␎＞ｆ\x15％|σd]ξＴαρ␡=␛",
		out:  "\\.Ｒ＇π．\uff00/'ｎ.φ \x13␎＞ｆ\x15％|σd]ξＴαρ␡=␛",
	}, { // 675
		mask: EncodeCrLf | EncodeLeftPeriod,
		in:   "\\．Ｒ＇π．\uff00/'ｎ.φ \x13␎＞ｆ\x15％|σd]ξＴαρ␡=␛",
		out:  "\\．Ｒ＇π．\uff00/'ｎ.φ \x13␎＞ｆ\x15％|σd]ξＴαρ␡=␛",
	}, { // 676
		mask: EncodeCrLf | EncodeLeftPeriod,
		in:   "\\.Ｒ＇π．\uff00/'ｎ.φ \x13␎＞ｆ\x15％|σd]ξＴαρ␡．␛",
		out:  "\\.Ｒ＇π．\uff00/'ｎ.φ \x13␎＞ｆ\x15％|σd]ξＴαρ␡．␛",
	}, { // 677
		mask: EncodeCrLf | EncodeLeftPeriod,
		in:   "\\．Ｒ＇π．\uff00/'ｎ.φ \x13␎＞ｆ\x15％|σd]ξＴαρ␡．␛",
		out:  "\\．Ｒ＇π．\uff00/'ｎ.φ \x13␎＞ｆ\x15％|σd]ξＴαρ␡．␛",
	}, { // 678
		mask: EncodeCrLf | EncodeLeftPeriod,
		in:   "\\.Ｒ＇π．\uff00/'ｎ.φ \x13␎＞ｆ\x15％|σd]ξＴαρ␡=．",
		out:  "\\.Ｒ＇π．\uff00/'ｎ.φ \x13␎＞ｆ\x15％|σd]ξＴαρ␡=．",
	}, { // 679
		mask: EncodeCrLf | EncodeLeftPeriod,
		in:   "\\．Ｒ＇π．\uff00/'ｎ.φ \x13␎＞ｆ\x15％|σd]ξＴαρ␡=．",
		out:  "\\．Ｒ＇π．\uff00/'ｎ.φ \x13␎＞ｆ\x15％|σd]ξＴαρ␡=．",
	}, { // 680
		mask: EncodeCrLf | EncodeLeftPeriod,
		in:   "\\zＲ＇π．\uff00/'ｎ.φ \x13␎＞ｆ\x15％|σd]ξＴαρ␡.␛",
		out:  "\\zＲ＇π．\uff00/'ｎ.φ \x13␎＞ｆ\x15％|σd]ξＴαρ␡.␛",
	}, { // 681
		mask: EncodeCrLf | EncodeLeftPeriod,
		in:   "\\zＲ＇π．\uff00/'ｎ.φ \x13␎＞ｆ\x15％|σd]ξＴαρ␡．␛",
		out:  "\\zＲ＇π．\uff00/'ｎ.φ \x13␎＞ｆ\x15％|σd]ξＴαρ␡．␛",
	}, { // 682
		mask: EncodeCrLf | EncodeLeftPeriod,
		in:   "\\zＲ＇π．\uff00/'ｎ.φ \x13␎＞ｆ\x15％|σd]ξＴαρ␡.．",
		out:  "\\zＲ＇π．\uff00/'ｎ.φ \x13␎＞ｆ\x15％|σd]ξＴαρ␡.．",
	}, { // 683
		mask: EncodeCrLf | EncodeLeftPeriod,
		in:   "\\zＲ＇π．\uff00/'ｎ.φ \x13␎＞ｆ\x15％|σd]ξＴαρ␡．．",
		out:  "\\zＲ＇π．\uff00/'ｎ.φ \x13␎＞ｆ\x15％|σd]ξＴαρ␡．．",
	}, { // 684
		mask: EncodeCrLf | EncodeLeftPeriod,
		in:   "\\zＲ＇π．\uff00/'ｎ.φ \x13␎＞ｆ\x15％|σd]ξＴαρ␡=.",
		out:  "\\zＲ＇π．\uff00/'ｎ.φ \x13␎＞ｆ\x15％|σd]ξＴαρ␡=.",
	}, { // 685
		mask: EncodeCrLf | EncodeLeftPeriod,
		in:   "\\zＲ＇π．\uff00/'ｎ.φ \x13␎＞ｆ\x15％|σd]ξＴαρ␡=．",
		out:  "\\zＲ＇π．\uff00/'ｎ.φ \x13␎＞ｆ\x15％|σd]ξＴαρ␡=．",
	}, { // 686
		mask: EncodeDel | EncodeLeftPeriod,
		in:   "Ｃ5n>ｎＵ\rι\x15␔.λ\x1dμω\"ＳＩ\r*ｔ］％\x1eμ}␝r＞␉",
		out:  "Ｃ5n>ｎＵ\rι\x15␔.λ\x1dμω\"ＳＩ\r*ｔ］％\x1eμ}␝r＞␉",
	}, { // 687
		mask: EncodeDel | EncodeLeftPeriod,
		in:   ".．n>ｎＵ\rι\x15␔.λ\x1dμω\"ＳＩ\r*ｔ］％\x1eμ}␝r＞␉",
		out:  "．．n>ｎＵ\rι\x15␔.λ\x1dμω\"ＳＩ\r*ｔ］％\x1eμ}␝r＞␉",
	}, { // 688
		mask: EncodeDel | EncodeLeftPeriod,
		in:   "．．n>ｎＵ\rι\x15␔.λ\x1dμω\"ＳＩ\r*ｔ］％\x1eμ}␝r＞␉",
		out:  "‛．．n>ｎＵ\rι\x15␔.λ\x1dμω\"ＳＩ\r*ｔ］％\x1eμ}␝r＞␉",
	}, { // 689
		mask: EncodeDel | EncodeLeftPeriod,
		in:   ".5n>ｎＵ\rι\x15␔.λ\x1dμω\"ＳＩ\r*ｔ］％\x1eμ}␝r．␉",
		out:  "．5n>ｎＵ\rι\x15␔.λ\x1dμω\"ＳＩ\r*ｔ］％\x1eμ}␝r．␉",
	}, { // 690
		mask: EncodeDel | EncodeLeftPeriod,
		in:   "．5n>ｎＵ\rι\x15␔.λ\x1dμω\"ＳＩ\r*ｔ］％\x1eμ}␝r．␉",
		out:  "‛．5n>ｎＵ\rι\x15␔.λ\x1dμω\"ＳＩ\r*ｔ］％\x1eμ}␝r．␉",
	}, { // 691
		mask: EncodeDel | EncodeLeftPeriod,
		in:   ".5n>ｎＵ\rι\x15␔.λ\x1dμω\"ＳＩ\r*ｔ］％\x1eμ}␝r＞．",
		out:  "．5n>ｎＵ\rι\x15␔.λ\x1dμω\"ＳＩ\r*ｔ］％\x1eμ}␝r＞．",
	}, { // 692
		mask: EncodeDel | EncodeLeftPeriod,
		in:   "．5n>ｎＵ\rι\x15␔.λ\x1dμω\"ＳＩ\r*ｔ］％\x1eμ}␝r＞．",
		out:  "‛．5n>ｎＵ\rι\x15␔.λ\x1dμω\"ＳＩ\r*ｔ］％\x1eμ}␝r＞．",
	}, { // 693
		mask: EncodeDel | EncodeLeftPeriod,
		in:   "Ｃ.n>ｎＵ\rι\x15␔.λ\x1dμω\"ＳＩ\r*ｔ］％\x1eμ}␝r＞␉",
		out:  "Ｃ.n>ｎＵ\rι\x15␔.λ\x1dμω\"ＳＩ\r*ｔ］％\x1eμ}␝r＞␉",
	}, { // 694
		mask: EncodeDel | EncodeLeftPeriod,
		in:   "Ｃ．n>ｎＵ\rι\x15␔.λ\x1dμω\"ＳＩ\r*ｔ］％\x1eμ}␝r＞␉",
		out:  "Ｃ．n>ｎＵ\rι\x15␔.λ\x1dμω\"ＳＩ\r*ｔ］％\x1eμ}␝r＞␉",
	}, { // 695
		mask: EncodeDel | EncodeLeftPeriod,
		in:   "Ｃ.n>ｎＵ\rι\x15␔.λ\x1dμω\"ＳＩ\r*ｔ］％\x1eμ}␝r．␉",
		out:  "Ｃ.n>ｎＵ\rι\x15␔.λ\x1dμω\"ＳＩ\r*ｔ］％\x1eμ}␝r．␉",
	}, { // 696
		mask: EncodeDel | EncodeLeftPeriod,
		in:   "Ｃ．n>ｎＵ\rι\x15␔.λ\x1dμω\"ＳＩ\r*ｔ］％\x1eμ}␝r．␉",
		out:  "Ｃ．n>ｎＵ\rι\x15␔.λ\x1dμω\"ＳＩ\r*ｔ］％\x1eμ}␝r．␉",
	}, { // 697
		mask: EncodeDel | EncodeLeftPeriod,
		in:   "Ｃ.n>ｎＵ\rι\x15␔.λ\x1dμω\"ＳＩ\r*ｔ］％\x1eμ}␝r＞．",
		out:  "Ｃ.n>ｎＵ\rι\x15␔.λ\x1dμω\"ＳＩ\r*ｔ］％\x1eμ}␝r＞．",
	}, { // 698
		mask: EncodeDel | EncodeLeftPeriod,
		in:   "Ｃ．n>ｎＵ\rι\x15␔.λ\x1dμω\"ＳＩ\r*ｔ］％\x1eμ}␝r＞．",
		out:  "Ｃ．n>ｎＵ\rι\x15␔.λ\x1dμω\"ＳＩ\r*ｔ］％\x1eμ}␝r＞．",
	}, { // 699
		mask: EncodeDel | EncodeLeftPeriod,
		in:   "Ｃ5n>ｎＵ\rι\x15␔.λ\x1dμω\"ＳＩ\r*ｔ］％\x1eμ}␝r.␉",
		out:  "Ｃ5n>ｎＵ\rι\x15␔.λ\x1dμω\"ＳＩ\r*ｔ］％\x1eμ}␝r.␉",
	}, { // 700
		mask: EncodeDel | EncodeLeftPeriod,
		in:   "Ｃ5n>ｎＵ\rι\x15␔.λ\x1dμω\"ＳＩ\r*ｔ］％\x1eμ}␝r．␉",
		out:  "Ｃ5n>ｎＵ\rι\x15␔.λ\x1dμω\"ＳＩ\r*ｔ］％\x1eμ}␝r．␉",
	}, { // 701
		mask: EncodeDel | EncodeLeftPeriod,
		in:   "Ｃ5n>ｎＵ\rι\x15␔.λ\x1dμω\"ＳＩ\r*ｔ］％\x1eμ}␝r.．",
		out:  "Ｃ5n>ｎＵ\rι\x15␔.λ\x1dμω\"ＳＩ\r*ｔ］％\x1eμ}␝r.．",
	}, { // 702
		mask: EncodeDel | EncodeLeftPeriod,
		in:   "Ｃ5n>ｎＵ\rι\x15␔.λ\x1dμω\"ＳＩ\r*ｔ］％\x1eμ}␝r．．",
		out:  "Ｃ5n>ｎＵ\rι\x15␔.λ\x1dμω\"ＳＩ\r*ｔ］％\x1eμ}␝r．．",
	}, { // 703
		mask: EncodeDel | EncodeLeftPeriod,
		in:   "Ｃ5n>ｎＵ\rι\x15␔.λ\x1dμω\"ＳＩ\r*ｔ］％\x1eμ}␝r＞.",
		out:  "Ｃ5n>ｎＵ\rι\x15␔.λ\x1dμω\"ＳＩ\r*ｔ］％\x1eμ}␝r＞.",
	}, { // 704
		mask: EncodeDel | EncodeLeftPeriod,
		in:   "Ｃ5n>ｎＵ\rι\x15␔.λ\x1dμω\"ＳＩ\r*ｔ］％\x1eμ}␝r＞．",
		out:  "Ｃ5n>ｎＵ\rι\x15␔.λ\x1dμω\"ＳＩ\r*ｔ］％\x1eμ}␝r＞．",
	}, { // 705
		mask: EncodeCtl | EncodeLeftPeriod,
		in:   "|␍ｊψ␗\rλ␀φ\x14.␃Ｐ{％[ｔ｜／$ζ{θ@o␝ｐμ\x150",
		out:  "|‛␍ｊψ‛␗␍λ‛␀φ␔.‛␃Ｐ{％[ｔ｜／$ζ{θ@o‛␝ｐμ␕0",
	}, { // 706
		mask: EncodeCtl | EncodeLeftPeriod,
		in:   ".．ｊψ␗\rλ␀φ\x14.␃Ｐ{％[ｔ｜／$ζ{θ@o␝ｐμ\x150",
		out:  "．．ｊψ‛␗␍λ‛␀φ␔.‛␃Ｐ{％[ｔ｜／$ζ{θ@o‛␝ｐμ␕0",
	}, { // 707
		mask: EncodeCtl | EncodeLeftPeriod,
		in:   "．．ｊψ␗\rλ␀φ\x14.␃Ｐ{％[ｔ｜／$ζ{θ@o␝ｐμ\x150",
		out:  "‛．．ｊψ‛␗␍λ‛␀φ␔.‛␃Ｐ{％[ｔ｜／$ζ{θ@o‛␝ｐμ␕0",
	}, { // 708
		mask: EncodeCtl | EncodeLeftPeriod,
		in:   ".␍ｊψ␗\rλ␀φ\x14.␃Ｐ{％[ｔ｜／$ζ{θ@o␝ｐμ．0",
		out:  "．‛␍ｊψ‛␗␍λ‛␀φ␔.‛␃Ｐ{％[ｔ｜／$ζ{θ@o‛␝ｐμ．0",
	}, { // 709
		mask: EncodeCtl | EncodeLeftPeriod,
		in:   "．␍ｊψ␗\rλ␀φ\x14.␃Ｐ{％[ｔ｜／$ζ{θ@o␝ｐμ．0",
		out:  "‛．‛␍ｊψ‛␗␍λ‛␀φ␔.‛␃Ｐ{％[ｔ｜／$ζ{θ@o‛␝ｐμ．0",
	}, { // 710
		mask: EncodeCtl | EncodeLeftPeriod,
		in:   ".␍ｊψ␗\rλ␀φ\x14.␃Ｐ{％[ｔ｜／$ζ{θ@o␝ｐμ\x15．",
		out:  "．‛␍ｊψ‛␗␍λ‛␀φ␔.‛␃Ｐ{％[ｔ｜／$ζ{θ@o‛␝ｐμ␕．",
	}, { // 711
		mask: EncodeCtl | EncodeLeftPeriod,
		in:   "．␍ｊψ␗\rλ␀φ\x14.␃Ｐ{％[ｔ｜／$ζ{θ@o␝ｐμ\x15．",
		out:  "‛．‛␍ｊψ‛␗␍λ‛␀φ␔.‛␃Ｐ{％[ｔ｜／$ζ{θ@o‛␝ｐμ␕．",
	}, { // 712
		mask: EncodeCtl | EncodeLeftPeriod,
		in:   "|.ｊψ␗\rλ␀φ\x14.␃Ｐ{％[ｔ｜／$ζ{θ@o␝ｐμ\x150",
		out:  "|.ｊψ‛␗␍λ‛␀φ␔.‛␃Ｐ{％[ｔ｜／$ζ{θ@o‛␝ｐμ␕0",
	}, { // 713
		mask: EncodeCtl | EncodeLeftPeriod,
		in:   "|．ｊψ␗\rλ␀φ\x14.␃Ｐ{％[ｔ｜／$ζ{θ@o␝ｐμ\x150",
		out:  "|．ｊψ‛␗␍λ‛␀φ␔.‛␃Ｐ{％[ｔ｜／$ζ{θ@o‛␝ｐμ␕0",
	}, { // 714
		mask: EncodeCtl | EncodeLeftPeriod,
		in:   "|.ｊψ␗\rλ␀φ\x14.␃Ｐ{％[ｔ｜／$ζ{θ@o␝ｐμ．0",
		out:  "|.ｊψ‛␗␍λ‛␀φ␔.‛␃Ｐ{％[ｔ｜／$ζ{θ@o‛␝ｐμ．0",
	}, { // 715
		mask: EncodeCtl | EncodeLeftPeriod,
		in:   "|．ｊψ␗\rλ␀φ\x14.␃Ｐ{％[ｔ｜／$ζ{θ@o␝ｐμ．0",
		out:  "|．ｊψ‛␗␍λ‛␀φ␔.‛␃Ｐ{％[ｔ｜／$ζ{θ@o‛␝ｐμ．0",
	}, { // 716
		mask: EncodeCtl | EncodeLeftPeriod,
		in:   "|.ｊψ␗\rλ␀φ\x14.␃Ｐ{％[ｔ｜／$ζ{θ@o␝ｐμ\x15．",
		out:  "|.ｊψ‛␗␍λ‛␀φ␔.‛␃Ｐ{％[ｔ｜／$ζ{θ@o‛␝ｐμ␕．",
	}, { // 717
		mask: EncodeCtl | EncodeLeftPeriod,
		in:   "|．ｊψ␗\rλ␀φ\x14.␃Ｐ{％[ｔ｜／$ζ{θ@o␝ｐμ\x15．",
		out:  "|．ｊψ‛␗␍λ‛␀φ␔.‛␃Ｐ{％[ｔ｜／$ζ{θ@o‛␝ｐμ␕．",
	}, { // 718
		mask: EncodeCtl | EncodeLeftPeriod,
		in:   "|␍ｊψ␗\rλ␀φ\x14.␃Ｐ{％[ｔ｜／$ζ{θ@o␝ｐμ.0",
		out:  "|‛␍ｊψ‛␗␍λ‛␀φ␔.‛␃Ｐ{％[ｔ｜／$ζ{θ@o‛␝ｐμ.0",
	}, { // 719
		mask: EncodeCtl | EncodeLeftPeriod,
		in:   "|␍ｊψ␗\rλ␀φ\x14.␃Ｐ{％[ｔ｜／$ζ{θ@o␝ｐμ．0",
		out:  "|‛␍ｊψ‛␗␍λ‛␀φ␔.‛␃Ｐ{％[ｔ｜／$ζ{θ@o‛␝ｐμ．0",
	}, { // 720
		mask: EncodeCtl | EncodeLeftPeriod,
		in:   "|␍ｊψ␗\rλ␀φ\x14.␃Ｐ{％[ｔ｜／$ζ{θ@o␝ｐμ.．",
		out:  "|‛␍ｊψ‛␗␍λ‛␀φ␔.‛␃Ｐ{％[ｔ｜／$ζ{θ@o‛␝ｐμ.．",
	}, { // 721
		mask: EncodeCtl | EncodeLeftPeriod,
		in:   "|␍ｊψ␗\rλ␀φ\x14.␃Ｐ{％[ｔ｜／$ζ{θ@o␝ｐμ．．",
		out:  "|‛␍ｊψ‛␗␍λ‛␀φ␔.‛␃Ｐ{％[ｔ｜／$ζ{θ@o‛␝ｐμ．．",
	}, { // 722
		mask: EncodeCtl | EncodeLeftPeriod,
		in:   "|␍ｊψ␗\rλ␀φ\x14.␃Ｐ{％[ｔ｜／$ζ{θ@o␝ｐμ\x15.",
		out:  "|‛␍ｊψ‛␗␍λ‛␀φ␔.‛␃Ｐ{％[ｔ｜／$ζ{θ@o‛␝ｐμ␕.",
	}, { // 723
		mask: EncodeCtl | EncodeLeftPeriod,
		in:   "|␍ｊψ␗\rλ␀φ\x14.␃Ｐ{％[ｔ｜／$ζ{θ@o␝ｐμ\x15．",
		out:  "|‛␍ｊψ‛␗␍λ‛␀φ␔.‛␃Ｐ{％[ｔ｜／$ζ{θ@o‛␝ｐμ␕．",
	}, { // 724
		mask: EncodeLeftTilde,
		in:   "~",
		out:  "～",
	}, { // 725
		mask: EncodeZero | EncodeLeftTilde,
		in:   "vη／?Ｃ＂＂＃␅\x17~\x1dＺ２［]mθλ\x00μ\x19␐#１Oι␃|ω",
		out:  "vη／?Ｃ＂＂＃␅\x17~\x1dＺ２［]mθλ␀μ\x19␐#１Oι␃|ω",
	}, { // 726
		mask: EncodeZero | EncodeLeftTilde,
		in:   "~～／?Ｃ＂＂＃␅\x17~\x1dＺ２［]mθλ\x00μ\x19␐#１Oι␃|ω",
		out:  "～～／?Ｃ＂＂＃␅\x17~\x1dＺ２［]mθλ␀μ\x19␐#１Oι␃|ω",
	}, { // 727
		mask: EncodeZero | EncodeLeftTilde,
		in:   "～～／?Ｃ＂＂＃␅\x17~\x1dＺ２［]mθλ\x00μ\x19␐#１Oι␃|ω",
		out:  "‛～～／?Ｃ＂＂＃␅\x17~\x1dＺ２［]mθλ␀μ\x19␐#１Oι␃|ω",
	}, { // 728
		mask: EncodeZero | EncodeLeftTilde,
		in:   "~η／?Ｃ＂＂＃␅\x17~\x1dＺ２［]mθλ\x00μ\x19␐#１Oι␃～ω",
		out:  "～η／?Ｃ＂＂＃␅\x17~\x1dＺ２［]mθλ␀μ\x19␐#１Oι␃～ω",
	}, { // 729
		mask: EncodeZero | EncodeLeftTilde,
		in:   "～η／?Ｃ＂＂＃␅\x17~\x1dＺ２［]mθλ\x00μ\x19␐#１Oι␃～ω",
		out:  "‛～η／?Ｃ＂＂＃␅\x17~\x1dＺ２［]mθλ␀μ\x19␐#１Oι␃～ω",
	}, { // 730
		mask: EncodeZero | EncodeLeftTilde,
		in:   "~η／?Ｃ＂＂＃␅\x17~\x1dＺ２［]mθλ\x00μ\x19␐#１Oι␃|～",
		out:  "～η／?Ｃ＂＂＃␅\x17~\x1dＺ２［]mθλ␀μ\x19␐#１Oι␃|～",
	}, { // 731
		mask: EncodeZero | EncodeLeftTilde,
		in:   "～η／?Ｃ＂＂＃␅\x17~\x1dＺ２［]mθλ\x00μ\x19␐#１Oι␃|～",
		out:  "‛～η／?Ｃ＂＂＃␅\x17~\x1dＺ２［]mθλ␀μ\x19␐#１Oι␃|～",
	}, { // 732
		mask: EncodeZero | EncodeLeftTilde,
		in:   "v~／?Ｃ＂＂＃␅\x17~\x1dＺ２［]mθλ\x00μ\x19␐#１Oι␃|ω",
		out:  "v~／?Ｃ＂＂＃␅\x17~\x1dＺ２［]mθλ␀μ\x19␐#１Oι␃|ω",
	}, { // 733
		mask: EncodeZero | EncodeLeftTilde,
		in:   "v～／?Ｃ＂＂＃␅\x17~\x1dＺ２［]mθλ\x00μ\x19␐#１Oι␃|ω",
		out:  "v～／?Ｃ＂＂＃␅\x17~\x1dＺ２［]mθλ␀μ\x19␐#１Oι␃|ω",
	}, { // 734
		mask: EncodeZero | EncodeLeftTilde,
		in:   "v~／?Ｃ＂＂＃␅\x17~\x1dＺ２［]mθλ\x00μ\x19␐#１Oι␃～ω",
		out:  "v~／?Ｃ＂＂＃␅\x17~\x1dＺ２［]mθλ␀μ\x19␐#１Oι␃～ω",
	}, { // 735
		mask: EncodeZero | EncodeLeftTilde,
		in:   "v～／?Ｃ＂＂＃␅\x17~\x1dＺ２［]mθλ\x00μ\x19␐#１Oι␃～ω",
		out:  "v～／?Ｃ＂＂＃␅\x17~\x1dＺ２［]mθλ␀μ\x19␐#１Oι␃～ω",
	}, { // 736
		mask: EncodeZero | EncodeLeftTilde,
		in:   "v~／?Ｃ＂＂＃␅\x17~\x1dＺ２［]mθλ\x00μ\x19␐#１Oι␃|～",
		out:  "v~／?Ｃ＂＂＃␅\x17~\x1dＺ２［]mθλ␀μ\x19␐#１Oι␃|～",
	}, { // 737
		mask: EncodeZero | EncodeLeftTilde,
		in:   "v～／?Ｃ＂＂＃␅\x17~\x1dＺ２［]mθλ\x00μ\x19␐#１Oι␃|～",
		out:  "v～／?Ｃ＂＂＃␅\x17~\x1dＺ２［]mθλ␀μ\x19␐#１Oι␃|～",
	}, { // 738
		mask: EncodeZero | EncodeLeftTilde,
		in:   "vη／?Ｃ＂＂＃␅\x17~\x1dＺ２［]mθλ\x00μ\x19␐#１Oι␃~ω",
		out:  "vη／?Ｃ＂＂＃␅\x17~\x1dＺ２［]mθλ␀μ\x19␐#１Oι␃~ω",
	}, { // 739
		mask: EncodeZero | EncodeLeftTilde,
		in:   "vη／?Ｃ＂＂＃␅\x17~\x1dＺ２［]mθλ\x00μ\x19␐#１Oι␃～ω",
		out:  "vη／?Ｃ＂＂＃␅\x17~\x1dＺ２［]mθλ␀μ\x19␐#１Oι␃～ω",
	}, { // 740
		mask: EncodeZero | EncodeLeftTilde,
		in:   "vη／?Ｃ＂＂＃␅\x17~\x1dＺ２［]mθλ\x00μ\x19␐#１Oι␃~～",
		out:  "vη／?Ｃ＂＂＃␅\x17~\x1dＺ２［]mθλ␀μ\x19␐#１Oι␃~～",
	}, { // 741
		mask: EncodeZero | EncodeLeftTilde,
		in:   "vη／?Ｃ＂＂＃␅\x17~\x1dＺ２［]mθλ\x00μ\x19␐#１Oι␃～～",
		out:  "vη／?Ｃ＂＂＃␅\x17~\x1dＺ２［]mθλ␀μ\x19␐#１Oι␃～～",
	}, { // 742
		mask: EncodeZero | EncodeLeftTilde,
		in:   "vη／?Ｃ＂＂＃␅\x17~\x1dＺ２［]mθλ\x00μ\x19␐#１Oι␃|~",
		out:  "vη／?Ｃ＂＂＃␅\x17~\x1dＺ２［]mθλ␀μ\x19␐#１Oι␃|~",
	}, { // 743
		mask: EncodeZero | EncodeLeftTilde,
		in:   "vη／?Ｃ＂＂＃␅\x17~\x1dＺ２［]mθλ\x00μ\x19␐#１Oι␃|～",
		out:  "vη／?Ｃ＂＂＃␅\x17~\x1dＺ２［]mθλ␀μ\x19␐#１Oι␃|～",
	}, { // 744
		mask: EncodeSlash | EncodeLeftTilde,
		in:   "MWｇ＇％␙␀αA＠~\x18\v＆δ*Uｐ[λδ␋x\x16ιι/＠－？",
		out:  "MWｇ＇％␙‛␀αA＠~\x18\v＆δ*Uｐ[λδ␋x\x16ιι／＠－？",
	}, { // 745
		mask: EncodeSlash | EncodeLeftTilde,
		in:   "~～ｇ＇％␙␀αA＠~\x18\v＆δ*Uｐ[λδ␋x\x16ιι/＠－？",
		out:  "～～ｇ＇％␙‛␀αA＠~\x18\v＆δ*Uｐ[λδ␋x\x16ιι／＠－？",
	}, { // 746
		mask: EncodeSlash | EncodeLeftTilde,
		in:   "～～ｇ＇％␙␀αA＠~\x18\v＆δ*Uｐ[λδ␋x\x16ιι/＠－？",
		out:  "‛～～ｇ＇％␙‛␀αA＠~\x18\v＆δ*Uｐ[λδ␋x\x16ιι／＠－？",
	}, { // 747
		mask: EncodeSlash | EncodeLeftTilde,
		in:   "~Wｇ＇％␙␀αA＠~\x18\v＆δ*Uｐ[λδ␋x\x16ιι/＠～？",
		out:  "～Wｇ＇％␙‛␀αA＠~\x18\v＆δ*Uｐ[λδ␋x\x16ιι／＠～？",
	}, { // 748
		mask: EncodeSlash | EncodeLeftTilde,
		in:   "～Wｇ＇％␙␀αA＠~\x18\v＆δ*Uｐ[λδ␋x\x16ιι/＠～？",
		out:  "‛～Wｇ＇％␙‛␀αA＠~\x18\v＆δ*Uｐ[λδ␋x\x16ιι／＠～？",
	}, { // 749
		mask: EncodeSlash | EncodeLeftTilde,
		in:   "~Wｇ＇％␙␀αA＠~\x18\v＆δ*Uｐ[λδ␋x\x16ιι/＠－～",
		out:  "～Wｇ＇％␙‛␀αA＠~\x18\v＆δ*Uｐ[λδ␋x\x16ιι／＠－～",
	}, { // 750
		mask: EncodeSlash | EncodeLeftTilde,
		in:   "～Wｇ＇％␙␀αA＠~\x18\v＆δ*Uｐ[λδ␋x\x16ιι/＠－～",
		out:  "‛～Wｇ＇％␙‛␀αA＠~\x18\v＆δ*Uｐ[λδ␋x\x16ιι／＠－～",
	}, { // 751
		mask: EncodeSlash | EncodeLeftTilde,
		in:   "M~ｇ＇％␙␀αA＠~\x18\v＆δ*Uｐ[λδ␋x\x16ιι/＠－？",
		out:  "M~ｇ＇％␙‛␀αA＠~\x18\v＆δ*Uｐ[λδ␋x\x16ιι／＠－？",
	}, { // 752
		mask: EncodeSlash | EncodeLeftTilde,
		in:   "M～ｇ＇％␙␀αA＠~\x18\v＆δ*Uｐ[λδ␋x\x16ιι/＠－？",
		out:  "M～ｇ＇％␙‛␀αA＠~\x18\v＆δ*Uｐ[λδ␋x\x16ιι／＠－？",
	}, { // 753
		mask: EncodeSlash | EncodeLeftTilde,
		in:   "M~ｇ＇％␙␀αA＠~\x18\v＆δ*Uｐ[λδ␋x\x16ιι/＠～？",
		out:  "M~ｇ＇％␙‛␀αA＠~\x18\v＆δ*Uｐ[λδ␋x\x16ιι／＠～？",
	}, { // 754
		mask: EncodeSlash | EncodeLeftTilde,
		in:   "M～ｇ＇％␙␀αA＠~\x18\v＆δ*Uｐ[λδ␋x\x16ιι/＠～？",
		out:  "M～ｇ＇％␙‛␀αA＠~\x18\v＆δ*Uｐ[λδ␋x\x16ιι／＠～？",
	}, { // 755
		mask: EncodeSlash | EncodeLeftTilde,
		in:   "M~ｇ＇％␙␀αA＠~\x18\v＆δ*Uｐ[λδ␋x\x16ιι/＠－～",
		out:  "M~ｇ＇％␙‛␀αA＠~\x18\v＆δ*Uｐ[λδ␋x\x16ιι／＠－～",
	}, { // 756
		mask: EncodeSlash | EncodeLeftTilde,
		in:   "M～ｇ＇％␙␀αA＠~\x18\v＆δ*Uｐ[λδ␋x\x16ιι/＠－～",
		out:  "M～ｇ＇％␙‛␀αA＠~\x18\v＆δ*Uｐ[λδ␋x\x16ιι／＠－～",
	}, { // 757
		mask: EncodeSlash | EncodeLeftTilde,
		in:   "MWｇ＇％␙␀αA＠~\x18\v＆δ*Uｐ[λδ␋x\x16ιι/＠~？",
		out:  "MWｇ＇％␙‛␀αA＠~\x18\v＆δ*Uｐ[λδ␋x\x16ιι／＠~？",
	}, { // 758
		mask: EncodeSlash | EncodeLeftTilde,
		in:   "MWｇ＇％␙␀αA＠~\x18\v＆δ*Uｐ[λδ␋x\x16ιι/＠～？",
		out:  "MWｇ＇％␙‛␀αA＠~\x18\v＆δ*Uｐ[λδ␋x\x16ιι／＠～？",
	}, { // 759
		mask: EncodeSlash | EncodeLeftTilde,
		in:   "MWｇ＇％␙␀αA＠~\x18\v＆δ*Uｐ[λδ␋x\x16ιι/＠~～",
		out:  "MWｇ＇％␙‛␀αA＠~\x18\v＆δ*Uｐ[λδ␋x\x16ιι／＠~～",
	}, { // 760
		mask: EncodeSlash | EncodeLeftTilde,
		in:   "MWｇ＇％␙␀αA＠~\x18\v＆δ*Uｐ[λδ␋x\x16ιι/＠～～",
		out:  "MWｇ＇％␙‛␀αA＠~\x18\v＆δ*Uｐ[λδ␋x\x16ιι／＠～～",
	}, { // 761
		mask: EncodeSlash | EncodeLeftTilde,
		in:   "MWｇ＇％␙␀αA＠~\x18\v＆δ*Uｐ[λδ␋x\x16ιι/＠－~",
		out:  "MWｇ＇％␙‛␀αA＠~\x18\v＆δ*Uｐ[λδ␋x\x16ιι／＠－~",
	}, { // 762
		mask: EncodeSlash | EncodeLeftTilde,
		in:   "MWｇ＇％␙␀αA＠~\x18\v＆δ*Uｐ[λδ␋x\x16ιι/＠－～",
		out:  "MWｇ＇％␙‛␀αA＠~\x18\v＆δ*Uｐ[λδ␋x\x16ιι／＠－～",
	}, { // 763
		mask: EncodeSingleQuote | EncodeLeftTilde,
		in:   "＞ωI#ςh5\v］\x0e~｝␍␝\uff00\x15ｐσ␑uFμ␁Ｌ\x10cω␇\nν",
		out:  "＞ωI#ςh5\v］\x0e~｝␍␝\uff00\x15ｐσ␑uFμ␁Ｌ\x10cω␇\nν",
	}, { // 764
		mask: EncodeSingleQuote | EncodeLeftTilde,
		in:   "~～I#ςh5\v］\x0e~｝␍␝\uff00\x15ｐσ␑uFμ␁Ｌ\x10cω␇\nν",
		out:  "～～I#ςh5\v］\x0e~｝␍␝\uff00\x15ｐσ␑uFμ␁Ｌ\x10cω␇\nν",
	}, { // 765
		mask: EncodeSingleQuote | EncodeLeftTilde,
		in:   "～～I#ςh5\v］\x0e~｝␍␝\uff00\x15ｐσ␑uFμ␁Ｌ\x10cω␇\nν",
		out:  "‛～～I#ςh5\v］\x0e~｝␍␝\uff00\x15ｐσ␑uFμ␁Ｌ\x10cω␇\nν",
	}, { // 766
		mask: EncodeSingleQuote | EncodeLeftTilde,
		in:   "~ωI#ςh5\v］\x0e~｝␍␝\uff00\x15ｐσ␑uFμ␁Ｌ\x10cω␇～ν",
		out:  "～ωI#ςh5\v］\x0e~｝␍␝\uff00\x15ｐσ␑uFμ␁Ｌ\x10cω␇～ν",
	}, { // 767
		mask: EncodeSingleQuote | EncodeLeftTilde,
		in:   "～ωI#ςh5\v］\x0e~｝␍␝\uff00\x15ｐσ␑uFμ␁Ｌ\x10cω␇～ν",
		out:  "‛～ωI#ςh5\v］\x0e~｝␍␝\uff00\x15ｐσ␑uFμ␁Ｌ\x10cω␇～ν",
	}, { // 768
		mask: EncodeSingleQuote | EncodeLeftTilde,
		in:   "~ωI#ςh5\v］\x0e~｝␍␝\uff00\x15ｐσ␑uFμ␁Ｌ\x10cω␇\n～",
		out:  "～ωI#ςh5\v］\x0e~｝␍␝\uff00\x15ｐσ␑uFμ␁Ｌ\x10cω␇\n～",
	}, { // 769
		mask: EncodeSingleQuote | EncodeLeftTilde,
		in:   "～ωI#ςh5\v］\x0e~｝␍␝\uff00\x15ｐσ␑uFμ␁Ｌ\x10cω␇\n～",
		out:  "‛～ωI#ςh5\v］\x0e~｝␍␝\uff00\x15ｐσ␑uFμ␁Ｌ\x10cω␇\n～",
	}, { // 770
		mask: EncodeSingleQuote | EncodeLeftTilde,
		in:   "＞~I#ςh5\v］\x0e~｝␍␝\uff00\x15ｐσ␑uFμ␁Ｌ\x10cω␇\nν",
		out:  "＞~I#ςh5\v］\x0e~｝␍␝\uff00\x15ｐσ␑uFμ␁Ｌ\x10cω␇\nν",
	}, { // 771
		mask: EncodeSingleQuote | EncodeLeftTilde,
		in:   "＞～I#ςh5\v］\x0e~｝␍␝\uff00\x15ｐσ␑uFμ␁Ｌ\x10cω␇\nν",
		out:  "＞～I#ςh5\v］\x0e~｝␍␝\uff00\x15ｐσ␑uFμ␁Ｌ\x10cω␇\nν",
	}, { // 772
		mask: EncodeSingleQuote | EncodeLeftTilde,
		in:   "＞~I#ςh5\v］\x0e~｝␍␝\uff00\x15ｐσ␑uFμ␁Ｌ\x10cω␇～ν",
		out:  "＞~I#ςh5\v］\x0e~｝␍␝\uff00\x15ｐσ␑uFμ␁Ｌ\x10cω␇～ν",
	}, { // 773
		mask: EncodeSingleQuote | EncodeLeftTilde,
		in:   "＞～I#ςh5\v］\x0e~｝␍␝\uff00\x15ｐσ␑uFμ␁Ｌ\x10cω␇～ν",
		out:  "＞～I#ςh5\v］\x0e~｝␍␝\uff00\x15ｐσ␑uFμ␁Ｌ\x10cω␇～ν",
	}, { // 774
		mask: EncodeSingleQuote | EncodeLeftTilde,
		in:   "＞~I#ςh5\v］\x0e~｝␍␝\uff00\x15ｐσ␑uFμ␁Ｌ\x10cω␇\n～",
		out:  "＞~I#ςh5\v］\x0e~｝␍␝\uff00\x15ｐσ␑uFμ␁Ｌ\x10cω␇\n～",
	}, { // 775
		mask: EncodeSingleQuote | EncodeLeftTilde,
		in:   "＞～I#ςh5\v］\x0e~｝␍␝\uff00\x15ｐσ␑uFμ␁Ｌ\x10cω␇\n～",
		out:  "＞～I#ςh5\v］\x0e~｝␍␝\uff00\x15ｐσ␑uFμ␁Ｌ\x10cω␇\n～",
	}, { // 776
		mask: EncodeSingleQuote | EncodeLeftTilde,
		in:   "＞ωI#ςh5\v］\x0e~｝␍␝\uff00\x15ｐσ␑uFμ␁Ｌ\x10cω␇~ν",
		out:  "＞ωI#ςh5\v］\x0e~｝␍␝\uff00\x15ｐσ␑uFμ␁Ｌ\x10cω␇~ν",
	}, { // 777
		mask: EncodeSingleQuote | EncodeLeftTilde,
		in:   "＞ωI#ςh5\v］\x0e~｝␍␝\uff00\x15ｐσ␑uFμ␁Ｌ\x10cω␇～ν",
		out:  "＞ωI#ςh5\v］\x0e~｝␍␝\uff00\x15ｐσ␑uFμ␁Ｌ\x10cω␇～ν",
	}, { // 778
		mask: EncodeSingleQuote | EncodeLeftTilde,
		in:   "＞ωI#ςh5\v］\x0e~｝␍␝\uff00\x15ｐσ␑uFμ␁Ｌ\x10cω␇~～",
		out:  "＞ωI#ςh5\v］\x0e~｝␍␝\uff00\x15ｐσ␑uFμ␁Ｌ\x10cω␇~～",
	}, { // 779
		mask: EncodeSingleQuote | EncodeLeftTilde,
		in:   "＞ωI#ςh5\v］\x0e~｝␍␝\uff00\x15ｐσ␑uFμ␁Ｌ\x10cω␇～～",
		out:  "＞ωI#ςh5\v］\x0e~｝␍␝\uff00\x15ｐσ␑uFμ␁Ｌ\x10cω␇～～",
	}, { // 780
		mask: EncodeSingleQuote | EncodeLeftTilde,
		in:   "＞ωI#ςh5\v］\x0e~｝␍␝\uff00\x15ｐσ␑uFμ␁Ｌ\x10cω␇\n~",
		out:  "＞ωI#ςh5\v］\x0e~｝␍␝\uff00\x15ｐσ␑uFμ␁Ｌ\x10cω␇\n~",
	}, { // 781
		mask: EncodeSingleQuote | EncodeLeftTilde,
		in:   "＞ωI#ςh5\v］\x0e~｝␍␝\uff00\x15ｐσ␑uFμ␁Ｌ\x10cω␇\n～",
		out:  "＞ωI#ςh5\v］\x0e~｝␍␝\uff00\x15ｐσ␑uFμ␁Ｌ\x10cω␇\n～",
	}, { // 782
		mask: EncodeBackQuote | EncodeLeftTilde,
		in:   "ｙ\x18１\x03κ␊ς␗<w~rCβ*␓AηＰλ[␗[hＶ\x01␁＾␂Ｐ",
		out:  "ｙ\x18１\x03κ␊ς␗<w~rCβ*␓AηＰλ[␗[hＶ\x01␁＾␂Ｐ",
	}, { // 783
		mask: EncodeBackQuote | EncodeLeftTilde,
		in:   "~～１\x03κ␊ς␗<w~rCβ*␓AηＰλ[␗[hＶ\x01␁＾␂Ｐ",
		out:  "～～１\x03κ␊ς␗<w~rCβ*␓AηＰλ[␗[hＶ\x01␁＾␂Ｐ",
	}, { // 784
		mask: EncodeBackQuote | EncodeLeftTilde,
		in:   "～～１\x03κ␊ς␗<w~rCβ*␓AηＰλ[␗[hＶ\x01␁＾␂Ｐ",
		out:  "‛～～１\x03κ␊ς␗<w~rCβ*␓AηＰλ[␗[hＶ\x01␁＾␂Ｐ",
	}, { // 785
		mask: EncodeBackQuote | EncodeLeftTilde,
		in:   "~\x18１\x03κ␊ς␗<w~rCβ*␓AηＰλ[␗[hＶ\x01␁＾～Ｐ",
		out:  "～\x18１\x03κ␊ς␗<w~rCβ*␓AηＰλ[␗[hＶ\x01␁＾～Ｐ",
	}, { // 786
		mask: EncodeBackQuote | EncodeLeftTilde,
		in:   "～\x18１\x03κ␊ς␗<w~rCβ*␓AηＰλ[␗[hＶ\x01␁＾～Ｐ",
		out:  "‛～\x18１\x03κ␊ς␗<w~rCβ*␓AηＰλ[␗[hＶ\x01␁＾～Ｐ",
	}, { // 787
		mask: EncodeBackQuote | EncodeLeftTilde,
		in:   "~\x18１\x03κ␊ς␗<w~rCβ*␓AηＰλ[␗[hＶ\x01␁＾␂～",
		out:  "～\x18１\x03κ␊ς␗<w~rCβ*␓AηＰλ[␗[hＶ\x01␁＾␂～",
	}, { // 788
		mask: EncodeBackQuote | EncodeLeftTilde,
		in:   "～\x18１\x03κ␊ς␗<w~rCβ*␓AηＰλ[␗[hＶ\x01␁＾␂～",
		out:  "‛～\x18１\x03κ␊ς␗<w~rCβ*␓AηＰλ[␗[hＶ\x01␁＾␂～",
	}, { // 789
		mask: EncodeBackQuote | EncodeLeftTilde,
		in:   "ｙ~１\x03κ␊ς␗<w~rCβ*␓AηＰλ[␗[hＶ\x01␁＾␂Ｐ",
		out:  "ｙ~１\x03κ␊ς␗<w~rCβ*␓AηＰλ[␗[hＶ\x01␁＾␂Ｐ",
	}, { // 790
		mask: EncodeBackQuote | EncodeLeftTilde,
		in:   "ｙ～１\x03κ␊ς␗<w~rCβ*␓AηＰλ[␗[hＶ\x01␁＾␂Ｐ",
		out:  "ｙ～１\x03κ␊ς␗<w~rCβ*␓AηＰλ[␗[hＶ\x01␁＾␂Ｐ",
	}, { // 791
		mask: EncodeBackQuote | EncodeLeftTilde,
		in:   "ｙ~１\x03κ␊ς␗<w~rCβ*␓AηＰλ[␗[hＶ\x01␁＾～Ｐ",
		out:  "ｙ~１\x03κ␊ς␗<w~rCβ*␓AηＰλ[␗[hＶ\x01␁＾～Ｐ",
	}, { // 792
		mask: EncodeBackQuote | EncodeLeftTilde,
		in:   "ｙ～１\x03κ␊ς␗<w~rCβ*␓AηＰλ[␗[hＶ\x01␁＾～Ｐ",
		out:  "ｙ～１\x03κ␊ς␗<w~rCβ*␓AηＰλ[␗[hＶ\x01␁＾～Ｐ",
	}, { // 793
		mask: EncodeBackQuote | EncodeLeftTilde,
		in:   "ｙ~１\x03κ␊ς␗<w~rCβ*␓AηＰλ[␗[hＶ\x01␁＾␂～",
		out:  "ｙ~１\x03κ␊ς␗<w~rCβ*␓AηＰλ[␗[hＶ\x01␁＾␂～",
	}, { // 794
		mask: EncodeBackQuote | EncodeLeftTilde,
		in:   "ｙ～１\x03κ␊ς␗<w~rCβ*␓AηＰλ[␗[hＶ\x01␁＾␂～",
		out:  "ｙ～１\x03κ␊ς␗<w~rCβ*␓AηＰλ[␗[hＶ\x01␁＾␂～",
	}, { // 795
		mask: EncodeBackQuote | EncodeLeftTilde,
		in:   "ｙ\x18１\x03κ␊ς␗<w~rCβ*␓AηＰλ[␗[hＶ\x01␁＾~Ｐ",
		out:  "ｙ\x18１\x03κ␊ς␗<w~rCβ*␓AηＰλ[␗[hＶ\x01␁＾~Ｐ",
	}, { // 796
		mask: EncodeBackQuote | EncodeLeftTilde,
		in:   "ｙ\x18１\x03κ␊ς␗<w~rCβ*␓AηＰλ[␗[hＶ\x01␁＾～Ｐ",
		out:  "ｙ\x18１\x03κ␊ς␗<w~rCβ*␓AηＰλ[␗[hＶ\x01␁＾～Ｐ",
	}, { // 797
		mask: EncodeBackQuote | EncodeLeftTilde,
		in:   "ｙ\x18１\x03κ␊ς␗<w~rCβ*␓AηＰλ[␗[hＶ\x01␁＾~～",
		out:  "ｙ\x18１\x03κ␊ς␗<w~rCβ*␓AηＰλ[␗[hＶ\x01␁＾~～",
	}, { // 798
		mask: EncodeBackQuote | EncodeLeftTilde,
		in:   "ｙ\x18１\x03κ␊ς␗<w~rCβ*␓AηＰλ[␗[hＶ\x01␁＾～～",
		out:  "ｙ\x18１\x03κ␊ς␗<w~rCβ*␓AηＰλ[␗[hＶ\x01␁＾～～",
	}, { // 799
		mask: EncodeBackQuote | EncodeLeftTilde,
		in:   "ｙ\x18１\x03κ␊ς␗<w~rCβ*␓AηＰλ[␗[hＶ\x01␁＾␂~",
		out:  "ｙ\x18１\x03κ␊ς␗<w~rCβ*␓AηＰλ[␗[hＶ\x01␁＾␂~",
	}, { // 800
		mask: EncodeBackQuote | EncodeLeftTilde,
		in:   "ｙ\x18１\x03κ␊ς␗<w~rCβ*␓AηＰλ[␗[hＶ\x01␁＾␂～",
		out:  "ｙ\x18１\x03κ␊ς␗<w~rCβ*␓AηＰλ[␗[hＶ\x01␁＾␂～",
	}, { // 801
		mask: EncodeLtGt | EncodeLeftTilde,
		in:   "α\x0fςnＷ｀ｇπ：P~C\x14[\x14％%３μ␏␙\x0eφM＂％；\x10］κ",
		out:  "α\x0fςnＷ｀ｇπ：P~C\x14[\x14％%３μ␏␙\x0eφM＂％；\x10］κ",
	}, { // 802
		mask: EncodeLtGt | EncodeLeftTilde,
		in:   "~～ςnＷ｀ｇπ：P~C\x14[\x14％%３μ␏␙\x0eφM＂％；\x10］κ",
		out:  "～～ςnＷ｀ｇπ：P~C\x14[\x14％%３μ␏␙\x0eφM＂％；\x10］κ",
	}, { // 803
		mask: EncodeLtGt | EncodeLeftTilde,
		in:   "～～ςnＷ｀ｇπ：P~C\x14[\x14％%３μ␏␙\x0eφM＂％；\x10］κ",
		out:  "‛～～ςnＷ｀ｇπ：P~C\x14[\x14％%３μ␏␙\x0eφM＂％；\x10］κ",
	}, { // 804
		mask: EncodeLtGt | EncodeLeftTilde,
		in:   "~\x0fςnＷ｀ｇπ：P~C\x14[\x14％%３μ␏␙\x0eφM＂％；\x10～κ",
		out:  "～\x0fςnＷ｀ｇπ：P~C\x14[\x14％%３μ␏␙\x0eφM＂％；\x10～κ",
	}, { // 805
		mask: EncodeLtGt | EncodeLeftTilde,
		in:   "～\x0fςnＷ｀ｇπ：P~C\x14[\x14％%３μ␏␙\x0eφM＂％；\x10～κ",
		out:  "‛～\x0fςnＷ｀ｇπ：P~C\x14[\x14％%３μ␏␙\x0eφM＂％；\x10～κ",
	}, { // 806
		mask: EncodeLtGt | EncodeLeftTilde,
		in:   "~\x0fςnＷ｀ｇπ：P~C\x14[\x14％%３μ␏␙\x0eφM＂％；\x10］～",
		out:  "～\x0fςnＷ｀ｇπ：P~C\x14[\x14％%３μ␏␙\x0eφM＂％；\x10］～",
	}, { // 807
		mask: EncodeLtGt | EncodeLeftTilde,
		in:   "～\x0fςnＷ｀ｇπ：P~C\x14[\x14％%３μ␏␙\x0eφM＂％；\x10］～",
		out:  "‛～\x0fςnＷ｀ｇπ：P~C\x14[\x14％%３μ␏␙\x0eφM＂％；\x10］～",
	}, { // 808
		mask: EncodeLtGt | EncodeLeftTilde,
		in:   "α~ςnＷ｀ｇπ：P~C\x14[\x14％%３μ␏␙\x0eφM＂％；\x10］κ",
		out:  "α~ςnＷ｀ｇπ：P~C\x14[\x14％%３μ␏␙\x0eφM＂％；\x10］κ",
	}, { // 809
		mask: EncodeLtGt | EncodeLeftTilde,
		in:   "α～ςnＷ｀ｇπ：P~C\x14[\x14％%３μ␏␙\x0eφM＂％；\x10］κ",
		out:  "α～ςnＷ｀ｇπ：P~C\x14[\x14％%３μ␏␙\x0eφM＂％；\x10］κ",
	}, { // 810
		mask: EncodeLtGt | EncodeLeftTilde,
		in:   "α~ςnＷ｀ｇπ：P~C\x14[\x14％%３μ␏␙\x0eφM＂％；\x10～κ",
		out:  "α~ςnＷ｀ｇπ：P~C\x14[\x14％%３μ␏␙\x0eφM＂％；\x10～κ",
	}, { // 811
		mask: EncodeLtGt | EncodeLeftTilde,
		in:   "α～ςnＷ｀ｇπ：P~C\x14[\x14％%３μ␏␙\x0eφM＂％；\x10～κ",
		out:  "α～ςnＷ｀ｇπ：P~C\x14[\x14％%３μ␏␙\x0eφM＂％；\x10～κ",
	}, { // 812
		mask: EncodeLtGt | EncodeLeftTilde,
		in:   "α~ςnＷ｀ｇπ：P~C\x14[\x14％%３μ␏␙\x0eφM＂％；\x10］～",
		out:  "α~ςnＷ｀ｇπ：P~C\x14[\x14％%３μ␏␙\x0eφM＂％；\x10］～",
	}, { // 813
		mask: EncodeLtGt | EncodeLeftTilde,
		in:   "α～ςnＷ｀ｇπ：P~C\x14[\x14％%３μ␏␙\x0eφM＂％；\x10］～",
		out:  "α～ςnＷ｀ｇπ：P~C\x14[\x14％%３μ␏␙\x0eφM＂％；\x10］～",
	}, { // 814
		mask: EncodeLtGt | EncodeLeftTilde,
		in:   "α\x0fςnＷ｀ｇπ：P~C\x14[\x14％%３μ␏␙\x0eφM＂％；\x10~κ",
		out:  "α\x0fςnＷ｀ｇπ：P~C\x14[\x14％%３μ␏␙\x0eφM＂％；\x10~κ",
	}, { // 815
		mask: EncodeLtGt | EncodeLeftTilde,
		in:   "α\x0fςnＷ｀ｇπ：P~C\x14[\x14％%３μ␏␙\x0eφM＂％；\x10～κ",
		out:  "α\x0fςnＷ｀ｇπ：P~C\x14[\x14％%３μ␏␙\x0eφM＂％；\x10～κ",
	}, { // 816
		mask: EncodeLtGt | EncodeLeftTilde,
		in:   "α\x0fςnＷ｀ｇπ：P~C\x14[\x14％%３μ␏␙\x0eφM＂％；\x10~～",
		out:  "α\x0fςnＷ｀ｇπ：P~C\x14[\x14％%３μ␏␙\x0eφM＂％；\x10~～",
	}, { // 817
		mask: EncodeLtGt | EncodeLeftTilde,
		in:   "α\x0fςnＷ｀ｇπ：P~C\x14[\x14％%３μ␏␙\x0eφM＂％；\x10～～",
		out:  "α\x0fςnＷ｀ｇπ：P~C\x14[\x14％%３μ␏␙\x0eφM＂％；\x10～～",
	}, { // 818
		mask: EncodeLtGt | EncodeLeftTilde,
		in:   "α\x0fςnＷ｀ｇπ：P~C\x14[\x14％%３μ␏␙\x0eφM＂％；\x10］~",
		out:  "α\x0fςnＷ｀ｇπ：P~C\x14[\x14％%３μ␏␙\x0eφM＂％；\x10］~",
	}, { // 819
		mask: EncodeLtGt | EncodeLeftTilde,
		in:   "α\x0fςnＷ｀ｇπ：P~C\x14[\x14％%３μ␏␙\x0eφM＂％；\x10］～",
		out:  "α\x0fςnＷ｀ｇπ：P~C\x14[\x14％%３μ␏␙\x0eφM＂％；\x10］～",
	}, { // 820
		mask: EncodeSquareBracket | EncodeLeftTilde,
		in:   "ＱζχB\a␟σχ␎␓~J：C>\nｆ，[8（␆η＿δ\a␍t`␜",
		out:  "ＱζχB\a␟σχ␎␓~J：C>\nｆ，［8（␆η＿δ\a␍t`␜",
	}, { // 821
		mask: EncodeSquareBracket | EncodeLeftTilde,
		in:   "~～χB\a␟σχ␎␓~J：C>\nｆ，[8（␆η＿δ\a␍t`␜",
		out:  "～～χB\a␟σχ␎␓~J：C>\nｆ，［8（␆η＿δ\a␍t`␜",
	}, { // 822
		mask: EncodeSquareBracket | EncodeLeftTilde,
		in:   "～～χB\a␟σχ␎␓~J：C>\nｆ，[8（␆η＿δ\a␍t`␜",
		out:  "‛～～χB\a␟σχ␎␓~J：C>\nｆ，［8（␆η＿δ\a␍t`␜",
	}, { // 823
		mask: EncodeSquareBracket | EncodeLeftTilde,
		in:   "~ζχB\a␟σχ␎␓~J：C>\nｆ，[8（␆η＿δ\a␍t～␜",
		out:  "～ζχB\a␟σχ␎␓~J：C>\nｆ，［8（␆η＿δ\a␍t～␜",
	}, { // 824
		mask: EncodeSquareBracket | EncodeLeftTilde,
		in:   "～ζχB\a␟σχ␎␓~J：C>\nｆ，[8（␆η＿δ\a␍t～␜",
		out:  "‛～ζχB\a␟σχ␎␓~J：C>\nｆ，［8（␆η＿δ\a␍t～␜",
	}, { // 825
		mask: EncodeSquareBracket | EncodeLeftTilde,
		in:   "~ζχB\a␟σχ␎␓~J：C>\nｆ，[8（␆η＿δ\a␍t`～",
		out:  "～ζχB\a␟σχ␎␓~J：C>\nｆ，［8（␆η＿δ\a␍t`～",
	}, { // 826
		mask: EncodeSquareBracket | EncodeLeftTilde,
		in:   "～ζχB\a␟σχ␎␓~J：C>\nｆ，[8（␆η＿δ\a␍t`～",
		out:  "‛～ζχB\a␟σχ␎␓~J：C>\nｆ，［8（␆η＿δ\a␍t`～",
	}, { // 827
		mask: EncodeSquareBracket | EncodeLeftTilde,
		in:   "Ｑ~χB\a␟σχ␎␓~J：C>\nｆ，[8（␆η＿δ\a␍t`␜",
		out:  "Ｑ~χB\a␟σχ␎␓~J：C>\nｆ，［8（␆η＿δ\a␍t`␜",
	}, { // 828
		mask: EncodeSquareBracket | EncodeLeftTilde,
		in:   "Ｑ～χB\a␟σχ␎␓~J：C>\nｆ，[8（␆η＿δ\a␍t`␜",
		out:  "Ｑ～χB\a␟σχ␎␓~J：C>\nｆ，［8（␆η＿δ\a␍t`␜",
	}, { // 829
		mask: EncodeSquareBracket | EncodeLeftTilde,
		in:   "Ｑ~χB\a␟σχ␎␓~J：C>\nｆ，[8（␆η＿δ\a␍t～␜",
		out:  "Ｑ~χB\a␟σχ␎␓~J：C>\nｆ，［8（␆η＿δ\a␍t～␜",
	}, { // 830
		mask: EncodeSquareBracket | EncodeLeftTilde,
		in:   "Ｑ～χB\a␟σχ␎␓~J：C>\nｆ，[8（␆η＿δ\a␍t～␜",
		out:  "Ｑ～χB\a␟σχ␎␓~J：C>\nｆ，［8（␆η＿δ\a␍t～␜",
	}, { // 831
		mask: EncodeSquareBracket | EncodeLeftTilde,
		in:   "Ｑ~χB\a␟σχ␎␓~J：C>\nｆ，[8（␆η＿δ\a␍t`～",
		out:  "Ｑ~χB\a␟σχ␎␓~J：C>\nｆ，［8（␆η＿δ\a␍t`～",
	}, { // 832
		mask: EncodeSquareBracket | EncodeLeftTilde,
		in:   "Ｑ～χB\a␟σχ␎␓~J：C>\nｆ，[8（␆η＿δ\a␍t`～",
		out:  "Ｑ～χB\a␟σχ␎␓~J：C>\nｆ，［8（␆η＿δ\a␍t`～",
	}, { // 833
		mask: EncodeSquareBracket | EncodeLeftTilde,
		in:   "ＱζχB\a␟σχ␎␓~J：C>\nｆ，[8（␆η＿δ\a␍t~␜",
		out:  "ＱζχB\a␟σχ␎␓~J：C>\nｆ，［8（␆η＿δ\a␍t~␜",
	}, { // 834
		mask: EncodeSquareBracket | EncodeLeftTilde,
		in:   "ＱζχB\a␟σχ␎␓~J：C>\nｆ，[8（␆η＿δ\a␍t～␜",
		out:  "ＱζχB\a␟σχ␎␓~J：C>\nｆ，［8（␆η＿δ\a␍t～␜",
	}, { // 835
		mask: EncodeSquareBracket | EncodeLeftTilde,
		in:   "ＱζχB\a␟σχ␎␓~J：C>\nｆ，[8（␆η＿δ\a␍t~～",
		out:  "ＱζχB\a␟σχ␎␓~J：C>\nｆ，［8（␆η＿δ\a␍t~～",
	}, { // 836
		mask: EncodeSquareBracket | EncodeLeftTilde,
		in:   "ＱζχB\a␟σχ␎␓~J：C>\nｆ，[8（␆η＿δ\a␍t～～",
		out:  "ＱζχB\a␟σχ␎␓~J：C>\nｆ，［8（␆η＿δ\a␍t～～",
	}, { // 837
		mask: EncodeSquareBracket | EncodeLeftTilde,
		in:   "ＱζχB\a␟σχ␎␓~J：C>\nｆ，[8（␆η＿δ\a␍t`~",
		out:  "ＱζχB\a␟σχ␎␓~J：C>\nｆ，［8（␆η＿δ\a␍t`~",
	}, { // 838
		mask: EncodeSquareBracket | EncodeLeftTilde,
		in:   "ＱζχB\a␟σχ␎␓~J：C>\nｆ，[8（␆η＿δ\a␍t`～",
		out:  "ＱζχB\a␟σχ␎␓~J：C>\nｆ，［8（␆η＿δ\a␍t`～",
	}, { // 839
		mask: EncodeSemicolon | EncodeLeftTilde,
		in:   "ν␛ξ8-\x1d［ζｌ｀~πＬ＼\x12\u007f\x1d］．@－?\x03mμσ＄*k␝",
		out:  "ν␛ξ8-\x1d［ζｌ｀~πＬ＼\x12\u007f\x1d］．@－?\x03mμσ＄*k␝",
	}, { // 840
		mask: EncodeSemicolon | EncodeLeftTilde,
		in:   "~～ξ8-\x1d［ζｌ｀~πＬ＼\x12\u007f\x1d］．@－?\x03mμσ＄*k␝",
		out:  "～～ξ8-\x1d［ζｌ｀~πＬ＼\x12\u007f\x1d］．@－?\x03mμσ＄*k␝",
	}, { // 841
		mask: EncodeSemicolon | EncodeLeftTilde,
		in:   "～～ξ8-\x1d［ζｌ｀~πＬ＼\x12\u007f\x1d］．@－?\x03mμσ＄*k␝",
		out:  "‛～～ξ8-\x1d［ζｌ｀~πＬ＼\x12\u007f\x1d］．@－?\x03mμσ＄*k␝",
	}, { // 842
		mask: EncodeSemicolon | EncodeLeftTilde,
		in:   "~␛ξ8-\x1d［ζｌ｀~πＬ＼\x12\u007f\x1d］．@－?\x03mμσ＄*～␝",
		out:  "～␛ξ8-\x1d［ζｌ｀~πＬ＼\x12\u007f\x1d］．@－?\x03mμσ＄*～␝",
	}, { // 843
		mask: EncodeSemicolon | EncodeLeftTilde,
		in:   "～␛ξ8-\x1d［ζｌ｀~πＬ＼\x12\u007f\x1d］．@－?\x03mμσ＄*～␝",
		out:  "‛～␛ξ8-\x1d［ζｌ｀~πＬ＼\x12\u007f\x1d］．@－?\x03mμσ＄*～␝",
	}, { // 844
		mask: EncodeSemicolon | EncodeLeftTilde,
		in:   "~␛ξ8-\x1d［ζｌ｀~πＬ＼\x12\u007f\x1d］．@－?\x03mμσ＄*k～",
		out:  "～␛ξ8-\x1d［ζｌ｀~πＬ＼\x12\u007f\x1d］．@－?\x03mμσ＄*k～",
	}, { // 845
		mask: EncodeSemicolon | EncodeLeftTilde,
		in:   "～␛ξ8-\x1d［ζｌ｀~πＬ＼\x12\u007f\x1d］．@－?\x03mμσ＄*k～",
		out:  "‛～␛ξ8-\x1d［ζｌ｀~πＬ＼\x12\u007f\x1d］．@－?\x03mμσ＄*k～",
	}, { // 846
		mask: EncodeSemicolon | EncodeLeftTilde,
		in:   "ν~ξ8-\x1d［ζｌ｀~πＬ＼\x12\u007f\x1d］．@－?\x03mμσ＄*k␝",
		out:  "ν~ξ8-\x1d［ζｌ｀~πＬ＼\x12\u007f\x1d］．@－?\x03mμσ＄*k␝",
	}, { // 847
		mask: EncodeSemicolon | EncodeLeftTilde,
		in:   "ν～ξ8-\x1d［ζｌ｀~πＬ＼\x12\u007f\x1d］．@－?\x03mμσ＄*k␝",
		out:  "ν～ξ8-\x1d［ζｌ｀~πＬ＼\x12\u007f\x1d］．@－?\x03mμσ＄*k␝",
	}, { // 848
		mask: EncodeSemicolon | EncodeLeftTilde,
		in:   "ν~ξ8-\x1d［ζｌ｀~πＬ＼\x12\u007f\x1d］．@－?\x03mμσ＄*～␝",
		out:  "ν~ξ8-\x1d［ζｌ｀~πＬ＼\x12\u007f\x1d］．@－?\x03mμσ＄*～␝",
	}, { // 849
		mask: EncodeSemicolon | EncodeLeftTilde,
		in:   "ν～ξ8-\x1d［ζｌ｀~πＬ＼\x12\u007f\x1d］．@－?\x03mμσ＄*～␝",
		out:  "ν～ξ8-\x1d［ζｌ｀~πＬ＼\x12\u007f\x1d］．@－?\x03mμσ＄*～␝",
	}, { // 850
		mask: EncodeSemicolon | EncodeLeftTilde,
		in:   "ν~ξ8-\x1d［ζｌ｀~πＬ＼\x12\u007f\x1d］．@－?\x03mμσ＄*k～",
		out:  "ν~ξ8-\x1d［ζｌ｀~πＬ＼\x12\u007f\x1d］．@－?\x03mμσ＄*k～",
	}, { // 851
		mask: EncodeSemicolon | EncodeLeftTilde,
		in:   "ν～ξ8-\x1d［ζｌ｀~πＬ＼\x12\u007f\x1d］．@－?\x03mμσ＄*k～",
		out:  "ν～ξ8-\x1d［ζｌ｀~πＬ＼\x12\u007f\x1d］．@－?\x03mμσ＄*k～",
	}, { // 852
		mask: EncodeSemicolon | EncodeLeftTilde,
		in:   "ν␛ξ8-\x1d［ζｌ｀~πＬ＼\x12\u007f\x1d］．@－?\x03mμσ＄*~␝",
		out:  "ν␛ξ8-\x1d［ζｌ｀~πＬ＼\x12\u007f\x1d］．@－?\x03mμσ＄*~␝",
	}, { // 853
		mask: EncodeSemicolon | EncodeLeftTilde,
		in:   "ν␛ξ8-\x1d［ζｌ｀~πＬ＼\x12\u007f\x1d］．@－?\x03mμσ＄*～␝",
		out:  "ν␛ξ8-\x1d［ζｌ｀~πＬ＼\x12\u007f\x1d］．@－?\x03mμσ＄*～␝",
	}, { // 854
		mask: EncodeSemicolon | EncodeLeftTilde,
		in:   "ν␛ξ8-\x1d［ζｌ｀~πＬ＼\x12\u007f\x1d］．@－?\x03mμσ＄*~～",
		out:  "ν␛ξ8-\x1d［ζｌ｀~πＬ＼\x12\u007f\x1d］．@－?\x03mμσ＄*~～",
	}, { // 855
		mask: EncodeSemicolon | EncodeLeftTilde,
		in:   "ν␛ξ8-\x1d［ζｌ｀~πＬ＼\x12\u007f\x1d］．@－?\x03mμσ＄*～～",
		out:  "ν␛ξ8-\x1d［ζｌ｀~πＬ＼\x12\u007f\x1d］．@－?\x03mμσ＄*～～",
	}, { // 856
		mask: EncodeSemicolon | EncodeLeftTilde,
		in:   "ν␛ξ8-\x1d［ζｌ｀~πＬ＼\x12\u007f\x1d］．@－?\x03mμσ＄*k~",
		out:  "ν␛ξ8-\x1d［ζｌ｀~πＬ＼\x12\u007f\x1d］．@－?\x03mμσ＄*k~",
	}, { // 857
		mask: EncodeSemicolon | EncodeLeftTilde,
		in:   "ν␛ξ8-\x1d［ζｌ｀~πＬ＼\x12\u007f\x1d］．@－?\x03mμσ＄*k～",
		out:  "ν␛ξ8-\x1d［ζｌ｀~πＬ＼\x12\u007f\x1d］．@－?\x03mμσ＄*k～",
	}, { // 858
		mask: EncodeDollar | EncodeLeftTilde,
		in:   ":ι／␡α#j４␎\x12~ｖ\r：\x10ｙ?εθｒ␡γ␟%ζ］X＼\x1cF",
		out:  ":ι／␡α#j４␎\x12~ｖ\r：\x10ｙ?εθｒ␡γ␟%ζ］X＼\x1cF",
	}, { // 859
		mask: EncodeDollar | EncodeLeftTilde,
		in:   "~～／␡α#j４␎\x12~ｖ\r：\x10ｙ?εθｒ␡γ␟%ζ］X＼\x1cF",
		out:  "～～／␡α#j４␎\x12~ｖ\r：\x10ｙ?εθｒ␡γ␟%ζ］X＼\x1cF",
	}, { // 860
		mask: EncodeDollar | EncodeLeftTilde,
		in:   "～～／␡α#j４␎\x12~ｖ\r：\x10ｙ?εθｒ␡γ␟%ζ］X＼\x1cF",
		out:  "‛～～／␡α#j４␎\x12~ｖ\r：\x10ｙ?εθｒ␡γ␟%ζ］X＼\x1cF",
	}, { // 861
		mask: EncodeDollar | EncodeLeftTilde,
		in:   "~ι／␡α#j４␎\x12~ｖ\r：\x10ｙ?εθｒ␡γ␟%ζ］X＼～F",
		out:  "～ι／␡α#j４␎\x12~ｖ\r：\x10ｙ?εθｒ␡γ␟%ζ］X＼～F",
	}, { // 862
		mask: EncodeDollar | EncodeLeftTilde,
		in:   "～ι／␡α#j４␎\x12~ｖ\r：\x10ｙ?εθｒ␡γ␟%ζ］X＼～F",
		out:  "‛～ι／␡α#j４␎\x12~ｖ\r：\x10ｙ?εθｒ␡γ␟%ζ］X＼～F",
	}, { // 863
		mask: EncodeDollar | EncodeLeftTilde,
		in:   "~ι／␡α#j４␎\x12~ｖ\r：\x10ｙ?εθｒ␡γ␟%ζ］X＼\x1c～",
		out:  "～ι／␡α#j４␎\x12~ｖ\r：\x10ｙ?εθｒ␡γ␟%ζ］X＼\x1c～",
	}, { // 864
		mask: EncodeDollar | EncodeLeftTilde,
		in:   "～ι／␡α#j４␎\x12~ｖ\r：\x10ｙ?εθｒ␡γ␟%ζ］X＼\x1c～",
		out:  "‛～ι／␡α#j４␎\x12~ｖ\r：\x10ｙ?εθｒ␡γ␟%ζ］X＼\x1c～",
	}, { // 865
		mask: EncodeDollar | EncodeLeftTilde,
		in:   ":~／␡α#j４␎\x12~ｖ\r：\x10ｙ?εθｒ␡γ␟%ζ］X＼\x1cF",
		out:  ":~／␡α#j４␎\x12~ｖ\r：\x10ｙ?εθｒ␡γ␟%ζ］X＼\x1cF",
	}, { // 866
		mask: EncodeDollar | EncodeLeftTilde,
		in:   ":～／␡α#j４␎\x12~ｖ\r：\x10ｙ?εθｒ␡γ␟%ζ］X＼\x1cF",
		out:  ":～／␡α#j４␎\x12~ｖ\r：\x10ｙ?εθｒ␡γ␟%ζ］X＼\x1cF",
	}, { // 867
		mask: EncodeDollar | EncodeLeftTilde,
		in:   ":~／␡α#j４␎\x12~ｖ\r：\x10ｙ?εθｒ␡γ␟%ζ］X＼～F",
		out:  ":~／␡α#j４␎\x12~ｖ\r：\x10ｙ?εθｒ␡γ␟%ζ］X＼～F",
	}, { // 868
		mask: EncodeDollar | EncodeLeftTilde,
		in:   ":～／␡α#j４␎\x12~ｖ\r：\x10ｙ?εθｒ␡γ␟%ζ］X＼～F",
		out:  ":～／␡α#j４␎\x12~ｖ\r：\x10ｙ?εθｒ␡γ␟%ζ］X＼～F",
	}, { // 869
		mask: EncodeDollar | EncodeLeftTilde,
		in:   ":~／␡α#j４␎\x12~ｖ\r：\x10ｙ?εθｒ␡γ␟%ζ］X＼\x1c～",
		out:  ":~／␡α#j４␎\x12~ｖ\r：\x10ｙ?εθｒ␡γ␟%ζ］X＼\x1c～",
	}, { // 870
		mask: EncodeDollar | EncodeLeftTilde,
		in:   ":～／␡α#j４␎\x12~ｖ\r：\x10ｙ?εθｒ␡γ␟%ζ］X＼\x1c～",
		out:  ":～／␡α#j４␎\x12~ｖ\r：\x10ｙ?εθｒ␡γ␟%ζ］X＼\x1c～",
	}, { // 871
		mask: EncodeDollar | EncodeLeftTilde,
		in:   ":ι／␡α#j４␎\x12~ｖ\r：\x10ｙ?εθｒ␡γ␟%ζ］X＼~F",
		out:  ":ι／␡α#j４␎\x12~ｖ\r：\x10ｙ?εθｒ␡γ␟%ζ］X＼~F",
	}, { // 872
		mask: EncodeDollar | EncodeLeftTilde,
		in:   ":ι／␡α#j４␎\x12~ｖ\r：\x10ｙ?εθｒ␡γ␟%ζ］X＼～F",
		out:  ":ι／␡α#j４␎\x12~ｖ\r：\x10ｙ?εθｒ␡γ␟%ζ］X＼～F",
	}, { // 873
		mask: EncodeDollar | EncodeLeftTilde,
		in:   ":ι／␡α#j４␎\x12~ｖ\r：\x10ｙ?εθｒ␡γ␟%ζ］X＼~～",
		out:  ":ι／␡α#j４␎\x12~ｖ\r：\x10ｙ?εθｒ␡γ␟%ζ］X＼~～",
	}, { // 874
		mask: EncodeDollar | EncodeLeftTilde,
		in:   ":ι／␡α#j４␎\x12~ｖ\r：\x10ｙ?εθｒ␡γ␟%ζ］X＼～～",
		out:  ":ι／␡α#j４␎\x12~ｖ\r：\x10ｙ?εθｒ␡γ␟%ζ］X＼～～",
	}, { // 875
		mask: EncodeDollar | EncodeLeftTilde,
		in:   ":ι／␡α#j４␎\x12~ｖ\r：\x10ｙ?εθｒ␡γ␟%ζ］X＼\x1c~",
		out:  ":ι／␡α#j４␎\x12~ｖ\r：\x10ｙ?εθｒ␡γ␟%ζ］X＼\x1c~",
	}, { // 876
		mask: EncodeDollar | EncodeLeftTilde,
		in:   ":ι／␡α#j４␎\x12~ｖ\r：\x10ｙ?εθｒ␡γ␟%ζ］X＼\x1c～",
		out:  ":ι／␡α#j４␎\x12~ｖ\r：\x10ｙ?εθｒ␡γ␟%ζ］X＼\x1c～",
	}, { // 877
		mask: EncodeDoubleQuote | EncodeLeftTilde,
		in:   "\x06γυＤ]γλ*_␍~␎Ｑ\x00\rｅ␆␂h＿␅ａ-δηＩ\x15=␊\\",
		out:  "\x06γυＤ]γλ*_␍~␎Ｑ␀\rｅ␆␂h＿␅ａ-δηＩ\x15=␊\\",
	}, { // 878
		mask: EncodeDoubleQuote | EncodeLeftTilde,
		in:   "~～υＤ]γλ*_␍~␎Ｑ\x00\rｅ␆␂h＿␅ａ-δηＩ\x15=␊\\",
		out:  "～～υＤ]γλ*_␍~␎Ｑ␀\rｅ␆␂h＿␅ａ-δηＩ\x15=␊\\",
	}, { // 879
		mask: EncodeDoubleQuote | EncodeLeftTilde,
		in:   "～～υＤ]γλ*_␍~␎Ｑ\x00\rｅ␆␂h＿␅ａ-δηＩ\x15=␊\\",
		out:  "‛～～υＤ]γλ*_␍~␎Ｑ␀\rｅ␆␂h＿␅ａ-δηＩ\x15=␊\\",
	}, { // 880
		mask: EncodeDoubleQuote | EncodeLeftTilde,
		in:   "~γυＤ]γλ*_␍~␎Ｑ\x00\rｅ␆␂h＿␅ａ-δηＩ\x15=～\\",
		out:  "～γυＤ]γλ*_␍~␎Ｑ␀\rｅ␆␂h＿␅ａ-δηＩ\x15=～\\",
	}, { // 881
		mask: EncodeDoubleQuote | EncodeLeftTilde,
		in:   "～γυＤ]γλ*_␍~␎Ｑ\x00\rｅ␆␂h＿␅ａ-δηＩ\x15=～\\",
		out:  "‛～γυＤ]γλ*_␍~␎Ｑ␀\rｅ␆␂h＿␅ａ-δηＩ\x15=～\\",
	}, { // 882
		mask: EncodeDoubleQuote | EncodeLeftTilde,
		in:   "~γυＤ]γλ*_␍~␎Ｑ\x00\rｅ␆␂h＿␅ａ-δηＩ\x15=␊～",
		out:  "～γυＤ]γλ*_␍~␎Ｑ␀\rｅ␆␂h＿␅ａ-δηＩ\x15=␊～",
	}, { // 883
		mask: EncodeDoubleQuote | EncodeLeftTilde,
		in:   "～γυＤ]γλ*_␍~␎Ｑ\x00\rｅ␆␂h＿␅ａ-δηＩ\x15=␊～",
		out:  "‛～γυＤ]γλ*_␍~␎Ｑ␀\rｅ␆␂h＿␅ａ-δηＩ\x15=␊～",
	}, { // 884
		mask: EncodeDoubleQuote | EncodeLeftTilde,
		in:   "\x06~υＤ]γλ*_␍~␎Ｑ\x00\rｅ␆␂h＿␅ａ-δηＩ\x15=␊\\",
		out:  "\x06~υＤ]γλ*_␍~␎Ｑ␀\rｅ␆␂h＿␅ａ-δηＩ\x15=␊\\",
	}, { // 885
		mask: EncodeDoubleQuote | EncodeLeftTilde,
		in:   "\x06～υＤ]γλ*_␍~␎Ｑ\x00\rｅ␆␂h＿␅ａ-δηＩ\x15=␊\\",
		out:  "\x06～υＤ]γλ*_␍~␎Ｑ␀\rｅ␆␂h＿␅ａ-δηＩ\x15=␊\\",
	}, { // 886
		mask: EncodeDoubleQuote | EncodeLeftTilde,
		in:   "\x06~υＤ]γλ*_␍~␎Ｑ\x00\rｅ␆␂h＿␅ａ-δηＩ\x15=～\\",
		out:  "\x06~υＤ]γλ*_␍~␎Ｑ␀\rｅ␆␂h＿␅ａ-δηＩ\x15=～\\",
	}, { // 887
		mask: EncodeDoubleQuote | EncodeLeftTilde,
		in:   "\x06～υＤ]γλ*_␍~␎Ｑ\x00\rｅ␆␂h＿␅ａ-δηＩ\x15=～\\",
		out:  "\x06～υＤ]γλ*_␍~␎Ｑ␀\rｅ␆␂h＿␅ａ-δηＩ\x15=～\\",
	}, { // 888
		mask: EncodeDoubleQuote | EncodeLeftTilde,
		in:   "\x06~υＤ]γλ*_␍~␎Ｑ\x00\rｅ␆␂h＿␅ａ-δηＩ\x15=␊～",
		out:  "\x06~υＤ]γλ*_␍~␎Ｑ␀\rｅ␆␂h＿␅ａ-δηＩ\x15=␊～",
	}, { // 889
		mask: EncodeDoubleQuote | EncodeLeftTilde,
		in:   "\x06～υＤ]γλ*_␍~␎Ｑ\x00\rｅ␆␂h＿␅ａ-δηＩ\x15=␊～",
		out:  "\x06～υＤ]γλ*_␍~␎Ｑ␀\rｅ␆␂h＿␅ａ-δηＩ\x15=␊～",
	}, { // 890
		mask: EncodeDoubleQuote | EncodeLeftTilde,
		in:   "\x06γυＤ]γλ*_␍~␎Ｑ\x00\rｅ␆␂h＿␅ａ-δηＩ\x15=~\\",
		out:  "\x06γυＤ]γλ*_␍~␎Ｑ␀\rｅ␆␂h＿␅ａ-δηＩ\x15=~\\",
	}, { // 891
		mask: EncodeDoubleQuote | EncodeLeftTilde,
		in:   "\x06γυＤ]γλ*_␍~␎Ｑ\x00\rｅ␆␂h＿␅ａ-δηＩ\x15=～\\",
		out:  "\x06γυＤ]γλ*_␍~␎Ｑ␀\rｅ␆␂h＿␅ａ-δηＩ\x15=～\\",
	}, { // 892
		mask: EncodeDoubleQuote | EncodeLeftTilde,
		in:   "\x06γυＤ]γλ*_␍~␎Ｑ\x00\rｅ␆␂h＿␅ａ-δηＩ\x15=~～",
		out:  "\x06γυＤ]γλ*_␍~␎Ｑ␀\rｅ␆␂h＿␅ａ-δηＩ\x15=~～",
	}, { // 893
		mask: EncodeDoubleQuote | EncodeLeftTilde,
		in:   "\x06γυＤ]γλ*_␍~␎Ｑ\x00\rｅ␆␂h＿␅ａ-δηＩ\x15=～～",
		out:  "\x06γυＤ]γλ*_␍~␎Ｑ␀\rｅ␆␂h＿␅ａ-δηＩ\x15=～～",
	}, { // 894
		mask: EncodeDoubleQuote | EncodeLeftTilde,
		in:   "\x06γυＤ]γλ*_␍~␎Ｑ\x00\rｅ␆␂h＿␅ａ-δηＩ\x15=␊~",
		out:  "\x06γυＤ]γλ*_␍~␎Ｑ␀\rｅ␆␂h＿␅ａ-δηＩ\x15=␊~",
	}, { // 895
		mask: EncodeDoubleQuote | EncodeLeftTilde,
		in:   "\x06γυＤ]γλ*_␍~␎Ｑ\x00\rｅ␆␂h＿␅ａ-δηＩ\x15=␊～",
		out:  "\x06γυＤ]γλ*_␍~␎Ｑ␀\rｅ␆␂h＿␅ａ-δηＩ\x15=␊～",
	}, { // 896
		mask: EncodeColon | EncodeLeftTilde,
		in:   "␆␅ZAzχ＇\x1c\x1b\x14~␍ｃ＜υ［ＬM~\x0eν␕ν\nγHμｗｑ\x1d",
		out:  "␆␅ZAzχ＇\x1c\x1b\x14~␍ｃ＜υ［ＬM~\x0eν␕ν\nγHμｗｑ\x1d",
	}, { // 897
		mask: EncodeColon | EncodeLeftTilde,
		in:   "~～ZAzχ＇\x1c\x1b\x14~␍ｃ＜υ［ＬM~\x0eν␕ν\nγHμｗｑ\x1d",
		out:  "～～ZAzχ＇\x1c\x1b\x14~␍ｃ＜υ［ＬM~\x0eν␕ν\nγHμｗｑ\x1d",
	}, { // 898
		mask: EncodeColon | EncodeLeftTilde,
		in:   "～～ZAzχ＇\x1c\x1b\x14~␍ｃ＜υ［ＬM~\x0eν␕ν\nγHμｗｑ\x1d",
		out:  "‛～～ZAzχ＇\x1c\x1b\x14~␍ｃ＜υ［ＬM~\x0eν␕ν\nγHμｗｑ\x1d",
	}, { // 899
		mask: EncodeColon | EncodeLeftTilde,
		in:   "~␅ZAzχ＇\x1c\x1b\x14~␍ｃ＜υ［ＬM~\x0eν␕ν\nγHμｗ～\x1d",
		out:  "～␅ZAzχ＇\x1c\x1b\x14~␍ｃ＜υ［ＬM~\x0eν␕ν\nγHμｗ～\x1d",
	}, { // 900
		mask: EncodeColon | EncodeLeftTilde,
		in:   "～␅ZAzχ＇\x1c\x1b\x14~␍ｃ＜υ［ＬM~\x0eν␕ν\nγHμｗ～\x1d",
		out:  "‛～␅ZAzχ＇\x1c\x1b\x14~␍ｃ＜υ［ＬM~\x0eν␕ν\nγHμｗ～\x1d",
	}, { // 901
		mask: EncodeColon | EncodeLeftTilde,
		in:   "~␅ZAzχ＇\x1c\x1b\x14~␍ｃ＜υ［ＬM~\x0eν␕ν\nγHμｗｑ～",
		out:  "～␅ZAzχ＇\x1c\x1b\x14~␍ｃ＜υ［ＬM~\x0eν␕ν\nγHμｗｑ～",
	}, { // 902
		mask: EncodeColon | EncodeLeftTilde,
		in:   "～␅ZAzχ＇\x1c\x1b\x14~␍ｃ＜υ［ＬM~\x0eν␕ν\nγHμｗｑ～",
		out:  "‛～␅ZAzχ＇\x1c\x1b\x14~␍ｃ＜υ［ＬM~\x0eν␕ν\nγHμｗｑ～",
	}, { // 903
		mask: EncodeColon | EncodeLeftTilde,
		in:   "␆~ZAzχ＇\x1c\x1b\x14~␍ｃ＜υ［ＬM~\x0eν␕ν\nγHμｗｑ\x1d",
		out:  "␆~ZAzχ＇\x1c\x1b\x14~␍ｃ＜υ［ＬM~\x0eν␕ν\nγHμｗｑ\x1d",
	}, { // 904
		mask: EncodeColon | EncodeLeftTilde,
		in:   "␆～ZAzχ＇\x1c\x1b\x14~␍ｃ＜υ［ＬM~\x0eν␕ν\nγHμｗｑ\x1d",
		out:  "␆～ZAzχ＇\x1c\x1b\x14~␍ｃ＜υ［ＬM~\x0eν␕ν\nγHμｗｑ\x1d",
	}, { // 905
		mask: EncodeColon | EncodeLeftTilde,
		in:   "␆~ZAzχ＇\x1c\x1b\x14~␍ｃ＜υ［ＬM~\x0eν␕ν\nγHμｗ～\x1d",
		out:  "␆~ZAzχ＇\x1c\x1b\x14~␍ｃ＜υ［ＬM~\x0eν␕ν\nγHμｗ～\x1d",
	}, { // 906
		mask: EncodeColon | EncodeLeftTilde,
		in:   "␆～ZAzχ＇\x1c\x1b\x14~␍ｃ＜υ［ＬM~\x0eν␕ν\nγHμｗ～\x1d",
		out:  "␆～ZAzχ＇\x1c\x1b\x14~␍ｃ＜υ［ＬM~\x0eν␕ν\nγHμｗ～\x1d",
	}, { // 907
		mask: EncodeColon | EncodeLeftTilde,
		in:   "␆~ZAzχ＇\x1c\x1b\x14~␍ｃ＜υ［ＬM~\x0eν␕ν\nγHμｗｑ～",
		out:  "␆~ZAzχ＇\x1c\x1b\x14~␍ｃ＜υ［ＬM~\x0eν␕ν\nγHμｗｑ～",
	}, { // 908
		mask: EncodeColon | EncodeLeftTilde,
		in:   "␆～ZAzχ＇\x1c\x1b\x14~␍ｃ＜υ［ＬM~\x0eν␕ν\nγHμｗｑ～",
		out:  "␆～ZAzχ＇\x1c\x1b\x14~␍ｃ＜υ［ＬM~\x0eν␕ν\nγHμｗｑ～",
	}, { // 909
		mask: EncodeColon | EncodeLeftTilde,
		in:   "␆␅ZAzχ＇\x1c\x1b\x14~␍ｃ＜υ［ＬM~\x0eν␕ν\nγHμｗ~\x1d",
		out:  "␆␅ZAzχ＇\x1c\x1b\x14~␍ｃ＜υ［ＬM~\x0eν␕ν\nγHμｗ~\x1d",
	}, { // 910
		mask: EncodeColon | EncodeLeftTilde,
		in:   "␆␅ZAzχ＇\x1c\x1b\x14~␍ｃ＜υ［ＬM~\x0eν␕ν\nγHμｗ～\x1d",
		out:  "␆␅ZAzχ＇\x1c\x1b\x14~␍ｃ＜υ［ＬM~\x0eν␕ν\nγHμｗ～\x1d",
	}, { // 911
		mask: EncodeColon | EncodeLeftTilde,
		in:   "␆␅ZAzχ＇\x1c\x1b\x14~␍ｃ＜υ［ＬM~\x0eν␕ν\nγHμｗ~～",
		out:  "␆␅ZAzχ＇\x1c\x1b\x14~␍ｃ＜υ［ＬM~\x0eν␕ν\nγHμｗ~～",
	}, { // 912
		mask: EncodeColon | EncodeLeftTilde,
		in:   "␆␅ZAzχ＇\x1c\x1b\x14~␍ｃ＜υ［ＬM~\x0eν␕ν\nγHμｗ～～",
		out:  "␆␅ZAzχ＇\x1c\x1b\x14~␍ｃ＜υ［ＬM~\x0eν␕ν\nγHμｗ～～",
	}, { // 913
		mask: EncodeColon | EncodeLeftTilde,
		in:   "␆␅ZAzχ＇\x1c\x1b\x14~␍ｃ＜υ［ＬM~\x0eν␕ν\nγHμｗｑ~",
		out:  "␆␅ZAzχ＇\x1c\x1b\x14~␍ｃ＜υ［ＬM~\x0eν␕ν\nγHμｗｑ~",
	}, { // 914
		mask: EncodeColon | EncodeLeftTilde,
		in:   "␆␅ZAzχ＇\x1c\x1b\x14~␍ｃ＜υ［ＬM~\x0eν␕ν\nγHμｗｑ～",
		out:  "␆␅ZAzχ＇\x1c\x1b\x14~␍ｃ＜υ［ＬM~\x0eν␕ν\nγHμｗｑ～",
	}, { // 915
		mask: EncodeQuestion | EncodeLeftTilde,
		in:   "［ωＬνＱｊ;␗␘κ~tMＬ<'ι*κ␄ＭyI？\x1eς␟␍\x00`",
		out:  "［ωＬνＱｊ;␗␘κ~tMＬ<'ι*κ␄ＭyI‛？\x1eς␟␍␀`",
	}, { // 916
		mask: EncodeQuestion | EncodeLeftTilde,
		in:   "~～ＬνＱｊ;␗␘κ~tMＬ<'ι*κ␄ＭyI？\x1eς␟␍\x00`",
		out:  "～～ＬνＱｊ;␗␘κ~tMＬ<'ι*κ␄ＭyI‛？\x1eς␟␍␀`",
	}, { // 917
		mask: EncodeQuestion | EncodeLeftTilde,
		in:   "～～ＬνＱｊ;␗␘κ~tMＬ<'ι*κ␄ＭyI？\x1eς␟␍\x00`",
		out:  "‛～～ＬνＱｊ;␗␘κ~tMＬ<'ι*κ␄ＭyI‛？\x1eς␟␍␀`",
	}, { // 918
		mask: EncodeQuestion | EncodeLeftTilde,
		in:   "~ωＬνＱｊ;␗␘κ~tMＬ<'ι*κ␄ＭyI？\x1eς␟␍～`",
		out:  "～ωＬνＱｊ;␗␘κ~tMＬ<'ι*κ␄ＭyI‛？\x1eς␟␍～`",
	}, { // 919
		mask: EncodeQuestion | EncodeLeftTilde,
		in:   "～ωＬνＱｊ;␗␘κ~tMＬ<'ι*κ␄ＭyI？\x1eς␟␍～`",
		out:  "‛～ωＬνＱｊ;␗␘κ~tMＬ<'ι*κ␄ＭyI‛？\x1eς␟␍～`",
	}, { // 920
		mask: EncodeQuestion | EncodeLeftTilde,
		in:   "~ωＬνＱｊ;␗␘κ~tMＬ<'ι*κ␄ＭyI？\x1eς␟␍\x00～",
		out:  "～ωＬνＱｊ;␗␘κ~tMＬ<'ι*κ␄ＭyI‛？\x1eς␟␍␀～",
	}, { // 921
		mask: EncodeQuestion | EncodeLeftTilde,
		in:   "～ωＬνＱｊ;␗␘κ~tMＬ<'ι*κ␄ＭyI？\x1eς␟␍\x00～",
		out:  "‛～ωＬνＱｊ;␗␘κ~tMＬ<'ι*κ␄ＭyI‛？\x1eς␟␍␀～",
	}, { // 922
		mask: EncodeQuestion | EncodeLeftTilde,
		in:   "［~ＬνＱｊ;␗␘κ~tMＬ<'ι*κ␄ＭyI？\x1eς␟␍\x00`",
		out:  "［~ＬνＱｊ;␗␘κ~tMＬ<'ι*κ␄ＭyI‛？\x1eς␟␍␀`",
	}, { // 923
		mask: EncodeQuestion | EncodeLeftTilde,
		in:   "［～ＬνＱｊ;␗␘κ~tMＬ<'ι*κ␄ＭyI？\x1eς␟␍\x00`",
		out:  "［～ＬνＱｊ;␗␘κ~tMＬ<'ι*κ␄ＭyI‛？\x1eς␟␍␀`",
	}, { // 924
		mask: EncodeQuestion | EncodeLeftTilde,
		in:   "［~ＬνＱｊ;␗␘κ~tMＬ<'ι*κ␄ＭyI？\x1eς␟␍～`",
		out:  "［~ＬνＱｊ;␗␘κ~tMＬ<'ι*κ␄ＭyI‛？\x1eς␟␍～`",
	}, { // 925
		mask: EncodeQuestion | EncodeLeftTilde,
		in:   "［～ＬνＱｊ;␗␘κ~tMＬ<'ι*κ␄ＭyI？\x1eς␟␍～`",
		out:  "［～ＬνＱｊ;␗␘κ~tMＬ<'ι*κ␄ＭyI‛？\x1eς␟␍～`",
	}, { // 926
		mask: EncodeQuestion | EncodeLeftTilde,
		in:   "［~ＬνＱｊ;␗␘κ~tMＬ<'ι*κ␄ＭyI？\x1eς␟␍\x00～",
		out:  "［~ＬνＱｊ;␗␘κ~tMＬ<'ι*κ␄ＭyI‛？\x1eς␟␍␀～",
	}, { // 927
		mask: EncodeQuestion | EncodeLeftTilde,
		in:   "［～ＬνＱｊ;␗␘κ~tMＬ<'ι*κ␄ＭyI？\x1eς␟␍\x00～",
		out:  "［～ＬνＱｊ;␗␘κ~tMＬ<'ι*κ␄ＭyI‛？\x1eς␟␍␀～",
	}, { // 928
		mask: EncodeQuestion | EncodeLeftTilde,
		in:   "［ωＬνＱｊ;␗␘κ~tMＬ<'ι*κ␄ＭyI？\x1eς␟␍~`",
		out:  "［ωＬνＱｊ;␗␘κ~tMＬ<'ι*κ␄ＭyI‛？\x1eς␟␍~`",
	}, { // 929
		mask: EncodeQuestion | EncodeLeftTilde,
		in:   "［ωＬνＱｊ;␗␘κ~tMＬ<'ι*κ␄ＭyI？\x1eς␟␍～`",
		out:  "［ωＬνＱｊ;␗␘κ~tMＬ<'ι*κ␄ＭyI‛？\x1eς␟␍～`",
	}, { // 930
		mask: EncodeQuestion | EncodeLeftTilde,
		in:   "［ωＬνＱｊ;␗␘κ~tMＬ<'ι*κ␄ＭyI？\x1eς␟␍~～",
		out:  "［ωＬνＱｊ;␗␘κ~tMＬ<'ι*κ␄ＭyI‛？\x1eς␟␍~～",
	}, { // 931
		mask: EncodeQuestion | EncodeLeftTilde,
		in:   "［ωＬνＱｊ;␗␘κ~tMＬ<'ι*κ␄ＭyI？\x1eς␟␍～～",
		out:  "［ωＬνＱｊ;␗␘κ~tMＬ<'ι*κ␄ＭyI‛？\x1eς␟␍～～",
	}, { // 932
		mask: EncodeQuestion | EncodeLeftTilde,
		in:   "［ωＬνＱｊ;␗␘κ~tMＬ<'ι*κ␄ＭyI？\x1eς␟␍\x00~",
		out:  "［ωＬνＱｊ;␗␘κ~tMＬ<'ι*κ␄ＭyI‛？\x1eς␟␍␀~",
	}, { // 933
		mask: EncodeQuestion | EncodeLeftTilde,
		in:   "［ωＬνＱｊ;␗␘κ~tMＬ<'ι*κ␄ＭyI？\x1eς␟␍\x00～",
		out:  "［ωＬνＱｊ;␗␘κ~tMＬ<'ι*κ␄ＭyI‛？\x1eς␟␍␀～",
	}, { // 934
		mask: EncodeAsterisk | EncodeLeftTilde,
		in:   "εｕςχ３\"\r␎␛＠~Ｍoξ\n\x14\x0f\x1dθ＋c\x171＇␍8␀{ε＊",
		out:  "εｕςχ３\"\r␎␛＠~Ｍoξ\n\x14\x0f\x1dθ＋c\x171＇␍8‛␀{ε‛＊",
	}, { // 935
		mask: EncodeAsterisk | EncodeLeftTilde,
		in:   "~～ςχ３\"\r␎␛＠~Ｍoξ\n\x14\x0f\x1dθ＋c\x171＇␍8␀{ε＊",
		out:  "～～ςχ３\"\r␎␛＠~Ｍoξ\n\x14\x0f\x1dθ＋c\x171＇␍8‛␀{ε‛＊",
	}, { // 936
		mask: EncodeAsterisk | EncodeLeftTilde,
		in:   "～～ςχ３\"\r␎␛＠~Ｍoξ\n\x14\x0f\x1dθ＋c\x171＇␍8␀{ε＊",
		out:  "‛～～ςχ３\"\r␎␛＠~Ｍoξ\n\x14\x0f\x1dθ＋c\x171＇␍8‛␀{ε‛＊",
	}, { // 937
		mask: EncodeAsterisk | EncodeLeftTilde,
		in:   "~ｕςχ３\"\r␎␛＠~Ｍoξ\n\x14\x0f\x1dθ＋c\x171＇␍8␀{～＊",
		out:  "～ｕςχ３\"\r␎␛＠~Ｍoξ\n\x14\x0f\x1dθ＋c\x171＇␍8‛␀{～‛＊",
	}, { // 938
		mask: EncodeAsterisk | EncodeLeftTilde,
		in:   "～ｕςχ３\"\r␎␛＠~Ｍoξ\n\x14\x0f\x1dθ＋c\x171＇␍8␀{～＊",
		out:  "‛～ｕςχ３\"\r␎␛＠~Ｍoξ\n\x14\x0f\x1dθ＋c\x171＇␍8‛␀{～‛＊",
	}, { // 939
		mask: EncodeAsterisk | EncodeLeftTilde,
		in:   "~ｕςχ３\"\r␎␛＠~Ｍoξ\n\x14\x0f\x1dθ＋c\x171＇␍8␀{ε～",
		out:  "～ｕςχ３\"\r␎␛＠~Ｍoξ\n\x14\x0f\x1dθ＋c\x171＇␍8‛␀{ε～",
	}, { // 940
		mask: EncodeAsterisk | EncodeLeftTilde,
		in:   "～ｕςχ３\"\r␎␛＠~Ｍoξ\n\x14\x0f\x1dθ＋c\x171＇␍8␀{ε～",
		out:  "‛～ｕςχ３\"\r␎␛＠~Ｍoξ\n\x14\x0f\x1dθ＋c\x171＇␍8‛␀{ε～",
	}, { // 941
		mask: EncodeAsterisk | EncodeLeftTilde,
		in:   "ε~ςχ３\"\r␎␛＠~Ｍoξ\n\x14\x0f\x1dθ＋c\x171＇␍8␀{ε＊",
		out:  "ε~ςχ３\"\r␎␛＠~Ｍoξ\n\x14\x0f\x1dθ＋c\x171＇␍8‛␀{ε‛＊",
	}, { // 942
		mask: EncodeAsterisk | EncodeLeftTilde,
		in:   "ε～ςχ３\"\r␎␛＠~Ｍoξ\n\x14\x0f\x1dθ＋c\x171＇␍8␀{ε＊",
		out:  "ε～ςχ３\"\r␎␛＠~Ｍoξ\n\x14\x0f\x1dθ＋c\x171＇␍8‛␀{ε‛＊",
	}, { // 943
		mask: EncodeAsterisk | EncodeLeftTilde,
		in:   "ε~ςχ３\"\r␎␛＠~Ｍoξ\n\x14\x0f\x1dθ＋c\x171＇␍8␀{～＊",
		out:  "ε~ςχ３\"\r␎␛＠~Ｍoξ\n\x14\x0f\x1dθ＋c\x171＇␍8‛␀{～‛＊",
	}, { // 944
		mask: EncodeAsterisk | EncodeLeftTilde,
		in:   "ε～ςχ３\"\r␎␛＠~Ｍoξ\n\x14\x0f\x1dθ＋c\x171＇␍8␀{～＊",
		out:  "ε～ςχ３\"\r␎␛＠~Ｍoξ\n\x14\x0f\x1dθ＋c\x171＇␍8‛␀{～‛＊",
	}, { // 945
		mask: EncodeAsterisk | EncodeLeftTilde,
		in:   "ε~ςχ３\"\r␎␛＠~Ｍoξ\n\x14\x0f\x1dθ＋c\x171＇␍8␀{ε～",
		out:  "ε~ςχ３\"\r␎␛＠~Ｍoξ\n\x14\x0f\x1dθ＋c\x171＇␍8‛␀{ε～",
	}, { // 946
		mask: EncodeAsterisk | EncodeLeftTilde,
		in:   "ε～ςχ３\"\r␎␛＠~Ｍoξ\n\x14\x0f\x1dθ＋c\x171＇␍8␀{ε～",
		out:  "ε～ςχ３\"\r␎␛＠~Ｍoξ\n\x14\x0f\x1dθ＋c\x171＇␍8‛␀{ε～",
	}, { // 947
		mask: EncodeAsterisk | EncodeLeftTilde,
		in:   "εｕςχ３\"\r␎␛＠~Ｍoξ\n\x14\x0f\x1dθ＋c\x171＇␍8␀{~＊",
		out:  "εｕςχ３\"\r␎␛＠~Ｍoξ\n\x14\x0f\x1dθ＋c\x171＇␍8‛␀{~‛＊",
	}, { // 948
		mask: EncodeAsterisk | EncodeLeftTilde,
		in:   "εｕςχ３\"\r␎␛＠~Ｍoξ\n\x14\x0f\x1dθ＋c\x171＇␍8␀{～＊",
		out:  "εｕςχ３\"\r␎␛＠~Ｍoξ\n\x14\x0f\x1dθ＋c\x171＇␍8‛␀{～‛＊",
	}, { // 949
		mask: EncodeAsterisk | EncodeLeftTilde,
		in:   "εｕςχ３\"\r␎␛＠~Ｍoξ\n\x14\x0f\x1dθ＋c\x171＇␍8␀{~～",
		out:  "εｕςχ３\"\r␎␛＠~Ｍoξ\n\x14\x0f\x1dθ＋c\x171＇␍8‛␀{~～",
	}, { // 950
		mask: EncodeAsterisk | EncodeLeftTilde,
		in:   "εｕςχ３\"\r␎␛＠~Ｍoξ\n\x14\x0f\x1dθ＋c\x171＇␍8␀{～～",
		out:  "εｕςχ３\"\r␎␛＠~Ｍoξ\n\x14\x0f\x1dθ＋c\x171＇␍8‛␀{～～",
	}, { // 951
		mask: EncodeAsterisk | EncodeLeftTilde,
		in:   "εｕςχ３\"\r␎␛＠~Ｍoξ\n\x14\x0f\x1dθ＋c\x171＇␍8␀{ε~",
		out:  "εｕςχ３\"\r␎␛＠~Ｍoξ\n\x14\x0f\x1dθ＋c\x171＇␍8‛␀{ε~",
	}, { // 952
		mask: EncodeAsterisk | EncodeLeftTilde,
		in:   "εｕςχ３\"\r␎␛＠~Ｍoξ\n\x14\x0f\x1dθ＋c\x171＇␍8␀{ε～",
		out:  "εｕςχ３\"\r␎␛＠~Ｍoξ\n\x14\x0f\x1dθ＋c\x171＇␍8‛␀{ε～",
	}, { // 953
		mask: EncodePipe | EncodeLeftTilde,
		in:   "\rχQｒd?θκ\"τ~Ｋ␂＋［３ｘ;\v␌L\x1a␏λＷ␅sη\r0",
		out:  "\rχQｒd?θκ\"τ~Ｋ␂＋［３ｘ;\v␌L\x1a␏λＷ␅sη\r0",
	}, { // 954
		mask: EncodePipe | EncodeLeftTilde,
		in:   "~～Qｒd?θκ\"τ~Ｋ␂＋［３ｘ;\v␌L\x1a␏λＷ␅sη\r0",
		out:  "～～Qｒd?θκ\"τ~Ｋ␂＋［３ｘ;\v␌L\x1a␏λＷ␅sη\r0",
	}, { // 955
		mask: EncodePipe | EncodeLeftTilde,
		in:   "～～Qｒd?θκ\"τ~Ｋ␂＋［３ｘ;\v␌L\x1a␏λＷ␅sη\r0",
		out:  "‛～～Qｒd?θκ\"τ~Ｋ␂＋［３ｘ;\v␌L\x1a␏λＷ␅sη\r0",
	}, { // 956
		mask: EncodePipe | EncodeLeftTilde,
		in:   "~χQｒd?θκ\"τ~Ｋ␂＋［３ｘ;\v␌L\x1a␏λＷ␅sη～0",
		out:  "～χQｒd?θκ\"τ~Ｋ␂＋［３ｘ;\v␌L\x1a␏λＷ␅sη～0",
	}, { // 957
		mask: EncodePipe | EncodeLeftTilde,
		in:   "～χQｒd?θκ\"τ~Ｋ␂＋［３ｘ;\v␌L\x1a␏λＷ␅sη～0",
		out:  "‛～χQｒd?θκ\"τ~Ｋ␂＋［３ｘ;\v␌L\x1a␏λＷ␅sη～0",
	}, { // 958
		mask: EncodePipe | EncodeLeftTilde,
		in:   "~χQｒd?θκ\"τ~Ｋ␂＋［３ｘ;\v␌L\x1a␏λＷ␅sη\r～",
		out:  "～χQｒd?θκ\"τ~Ｋ␂＋［３ｘ;\v␌L\x1a␏λＷ␅sη\r～",
	}, { // 959
		mask: EncodePipe | EncodeLeftTilde,
		in:   "～χQｒd?θκ\"τ~Ｋ␂＋［３ｘ;\v␌L\x1a␏λＷ␅sη\r～",
		out:  "‛～χQｒd?θκ\"τ~Ｋ␂＋［３ｘ;\v␌L\x1a␏λＷ␅sη\r～",
	}, { // 960
		mask: EncodePipe | EncodeLeftTilde,
		in:   "\r~Qｒd?θκ\"τ~Ｋ␂＋［３ｘ;\v␌L\x1a␏λＷ␅sη\r0",
		out:  "\r~Qｒd?θκ\"τ~Ｋ␂＋［３ｘ;\v␌L\x1a␏λＷ␅sη\r0",
	}, { // 961
		mask: EncodePipe | EncodeLeftTilde,
		in:   "\r～Qｒd?θκ\"τ~Ｋ␂＋［３ｘ;\v␌L\x1a␏λＷ␅sη\r0",
		out:  "\r～Qｒd?θκ\"τ~Ｋ␂＋［３ｘ;\v␌L\x1a␏λＷ␅sη\r0",
	}, { // 962
		mask: EncodePipe | EncodeLeftTilde,
		in:   "\r~Qｒd?θκ\"τ~Ｋ␂＋［３ｘ;\v␌L\x1a␏λＷ␅sη～0",
		out:  "\r~Qｒd?θκ\"τ~Ｋ␂＋［３ｘ;\v␌L\x1a␏λＷ␅sη～0",
	}, { // 963
		mask: EncodePipe | EncodeLeftTilde,
		in:   "\r～Qｒd?θκ\"τ~Ｋ␂＋［３ｘ;\v␌L\x1a␏λＷ␅sη～0",
		out:  "\r～Qｒd?θκ\"τ~Ｋ␂＋［３ｘ;\v␌L\x1a␏λＷ␅sη～0",
	}, { // 964
		mask: EncodePipe | EncodeLeftTilde,
		in:   "\r~Qｒd?θκ\"τ~Ｋ␂＋［３ｘ;\v␌L\x1a␏λＷ␅sη\r～",
		out:  "\r~Qｒd?θκ\"τ~Ｋ␂＋［３ｘ;\v␌L\x1a␏λＷ␅sη\r～",
	}, { // 965
		mask: EncodePipe | EncodeLeftTilde,
		in:   "\r～Qｒd?θκ\"τ~Ｋ␂＋［３ｘ;\v␌L\x1a␏λＷ␅sη\r～",
		out:  "\r～Qｒd?θκ\"τ~Ｋ␂＋［３ｘ;\v␌L\x1a␏λＷ␅sη\r～",
	}, { // 966
		mask: EncodePipe | EncodeLeftTilde,
		in:   "\rχQｒd?θκ\"τ~Ｋ␂＋［３ｘ;\v␌L\x1a␏λＷ␅sη~0",
		out:  "\rχQｒd?θκ\"τ~Ｋ␂＋［３ｘ;\v␌L\x1a␏λＷ␅sη~0",
	}, { // 967
		mask: EncodePipe | EncodeLeftTilde,
		in:   "\rχQｒd?θκ\"τ~Ｋ␂＋［３ｘ;\v␌L\x1a␏λＷ␅sη～0",
		out:  "\rχQｒd?θκ\"τ~Ｋ␂＋［３ｘ;\v␌L\x1a␏λＷ␅sη～0",
	}, { // 968
		mask: EncodePipe | EncodeLeftTilde,
		in:   "\rχQｒd?θκ\"τ~Ｋ␂＋［３ｘ;\v␌L\x1a␏λＷ␅sη~～",
		out:  "\rχQｒd?θκ\"τ~Ｋ␂＋［３ｘ;\v␌L\x1a␏λＷ␅sη~～",
	}, { // 969
		mask: EncodePipe | EncodeLeftTilde,
		in:   "\rχQｒd?θκ\"τ~Ｋ␂＋［３ｘ;\v␌L\x1a␏λＷ␅sη～～",
		out:  "\rχQｒd?θκ\"τ~Ｋ␂＋［３ｘ;\v␌L\x1a␏λＷ␅sη～～",
	}, { // 970
		mask: EncodePipe | EncodeLeftTilde,
		in:   "\rχQｒd?θκ\"τ~Ｋ␂＋［３ｘ;\v␌L\x1a␏λＷ␅sη\r~",
		out:  "\rχQｒd?θκ\"τ~Ｋ␂＋［３ｘ;\v␌L\x1a␏λＷ␅sη\r~",
	}, { // 971
		mask: EncodePipe | EncodeLeftTilde,
		in:   "\rχQｒd?θκ\"τ~Ｋ␂＋［３ｘ;\v␌L\x1a␏λＷ␅sη\r～",
		out:  "\rχQｒd?θκ\"τ~Ｋ␂＋［３ｘ;\v␌L\x1a␏λＷ␅sη\r～",
	}, { // 972
		mask: EncodeHash | EncodeLeftTilde,
		in:   "'kｄZγｗ/Ａγς~?mV\x15＂＞ς｜ｋχ␒\n␊γY␐ｈ\ac",
		out:  "'kｄZγｗ/Ａγς~?mV\x15＂＞ς｜ｋχ␒\n␊γY␐ｈ\ac",
	}, { // 973
		mask: EncodeHash | EncodeLeftTilde,
		in:   "~～ｄZγｗ/Ａγς~?mV\x15＂＞ς｜ｋχ␒\n␊γY␐ｈ\ac",
		out:  "～～ｄZγｗ/Ａγς~?mV\x15＂＞ς｜ｋχ␒\n␊γY␐ｈ\ac",
	}, { // 974
		mask: EncodeHash | EncodeLeftTilde,
		in:   "～～ｄZγｗ/Ａγς~?mV\x15＂＞ς｜ｋχ␒\n␊γY␐ｈ\ac",
		out:  "‛～～ｄZγｗ/Ａγς~?mV\x15＂＞ς｜ｋχ␒\n␊γY␐ｈ\ac",
	}, { // 975
		mask: EncodeHash | EncodeLeftTilde,
		in:   "~kｄZγｗ/Ａγς~?mV\x15＂＞ς｜ｋχ␒\n␊γY␐ｈ～c",
		out:  "～kｄZγｗ/Ａγς~?mV\x15＂＞ς｜ｋχ␒\n␊γY␐ｈ～c",
	}, { // 976
		mask: EncodeHash | EncodeLeftTilde,
		in:   "～kｄZγｗ/Ａγς~?mV\x15＂＞ς｜ｋχ␒\n␊γY␐ｈ～c",
		out:  "‛～kｄZγｗ/Ａγς~?mV\x15＂＞ς｜ｋχ␒\n␊γY␐ｈ～c",
	}, { // 977
		mask: EncodeHash | EncodeLeftTilde,
		in:   "~kｄZγｗ/Ａγς~?mV\x15＂＞ς｜ｋχ␒\n␊γY␐ｈ\a～",
		out:  "～kｄZγｗ/Ａγς~?mV\x15＂＞ς｜ｋχ␒\n␊γY␐ｈ\a～",
	}, { // 978
		mask: EncodeHash | EncodeLeftTilde,
		in:   "～kｄZγｗ/Ａγς~?mV\x15＂＞ς｜ｋχ␒\n␊γY␐ｈ\a～",
		out:  "‛～kｄZγｗ/Ａγς~?mV\x15＂＞ς｜ｋχ␒\n␊γY␐ｈ\a～",
	}, { // 979
		mask: EncodeHash | EncodeLeftTilde,
		in:   "'~ｄZγｗ/Ａγς~?mV\x15＂＞ς｜ｋχ␒\n␊γY␐ｈ\ac",
		out:  "'~ｄZγｗ/Ａγς~?mV\x15＂＞ς｜ｋχ␒\n␊γY␐ｈ\ac",
	}, { // 980
		mask: EncodeHash | EncodeLeftTilde,
		in:   "'～ｄZγｗ/Ａγς~?mV\x15＂＞ς｜ｋχ␒\n␊γY␐ｈ\ac",
		out:  "'～ｄZγｗ/Ａγς~?mV\x15＂＞ς｜ｋχ␒\n␊γY␐ｈ\ac",
	}, { // 981
		mask: EncodeHash | EncodeLeftTilde,
		in:   "'~ｄZγｗ/Ａγς~?mV\x15＂＞ς｜ｋχ␒\n␊γY␐ｈ～c",
		out:  "'~ｄZγｗ/Ａγς~?mV\x15＂＞ς｜ｋχ␒\n␊γY␐ｈ～c",
	}, { // 982
		mask: EncodeHash | EncodeLeftTilde,
		in:   "'～ｄZγｗ/Ａγς~?mV\x15＂＞ς｜ｋχ␒\n␊γY␐ｈ～c",
		out:  "'～ｄZγｗ/Ａγς~?mV\x15＂＞ς｜ｋχ␒\n␊γY␐ｈ～c",
	}, { // 983
		mask: EncodeHash | EncodeLeftTilde,
		in:   "'~ｄZγｗ/Ａγς~?mV\x15＂＞ς｜ｋχ␒\n␊γY␐ｈ\a～",
		out:  "'~ｄZγｗ/Ａγς~?mV\x15＂＞ς｜ｋχ␒\n␊γY␐ｈ\a～",
	}, { // 984
		mask: EncodeHash | EncodeLeftTilde,
		in:   "'～ｄZγｗ/Ａγς~?mV\x15＂＞ς｜ｋχ␒\n␊γY␐ｈ\a～",
		out:  "'～ｄZγｗ/Ａγς~?mV\x15＂＞ς｜ｋχ␒\n␊γY␐ｈ\a～",
	}, { // 985
		mask: EncodeHash | EncodeLeftTilde,
		in:   "'kｄZγｗ/Ａγς~?mV\x15＂＞ς｜ｋχ␒\n␊γY␐ｈ~c",
		out:  "'kｄZγｗ/Ａγς~?mV\x15＂＞ς｜ｋχ␒\n␊γY␐ｈ~c",
	}, { // 986
		mask: EncodeHash | EncodeLeftTilde,
		in:   "'kｄZγｗ/Ａγς~?mV\x15＂＞ς｜ｋχ␒\n␊γY␐ｈ～c",
		out:  "'kｄZγｗ/Ａγς~?mV\x15＂＞ς｜ｋχ␒\n␊γY␐ｈ～c",
	}, { // 987
		mask: EncodeHash | EncodeLeftTilde,
		in:   "'kｄZγｗ/Ａγς~?mV\x15＂＞ς｜ｋχ␒\n␊γY␐ｈ~～",
		out:  "'kｄZγｗ/Ａγς~?mV\x15＂＞ς｜ｋχ␒\n␊γY␐ｈ~～",
	}, { // 988
		mask: EncodeHash | EncodeLeftTilde,
		in:   "'kｄZγｗ/Ａγς~?mV\x15＂＞ς｜ｋχ␒\n␊γY␐ｈ～～",
		out:  "'kｄZγｗ/Ａγς~?mV\x15＂＞ς｜ｋχ␒\n␊γY␐ｈ～～",
	}, { // 989
		mask: EncodeHash | EncodeLeftTilde,
		in:   "'kｄZγｗ/Ａγς~?mV\x15＂＞ς｜ｋχ␒\n␊γY␐ｈ\a~",
		out:  "'kｄZγｗ/Ａγς~?mV\x15＂＞ς｜ｋχ␒\n␊γY␐ｈ\a~",
	}, { // 990
		mask: EncodeHash | EncodeLeftTilde,
		in:   "'kｄZγｗ/Ａγς~?mV\x15＂＞ς｜ｋχ␒\n␊γY␐ｈ\a～",
		out:  "'kｄZγｗ/Ａγς~?mV\x15＂＞ς｜ｋχ␒\n␊γY␐ｈ\a～",
	}, { // 991
		mask: EncodePercent | EncodeLeftTilde,
		in:   "ｄS＞Ｄ␍6γ␋rＮ~8ψ／fγ\vγ␜ξ\"\x11σ＆/`[ＷqＲ",
		out:  "ｄS＞Ｄ␍6γ␋rＮ~8ψ／fγ\vγ␜ξ\"\x11σ＆/`[ＷqＲ",
	}, { // 992
		mask: EncodePercent | EncodeLeftTilde,
		in:   "~～＞Ｄ␍6γ␋rＮ~8ψ／fγ\vγ␜ξ\"\x11σ＆/`[ＷqＲ",
		out:  "～～＞Ｄ␍6γ␋rＮ~8ψ／fγ\vγ␜ξ\"\x11σ＆/`[ＷqＲ",
	}, { // 993
		mask: EncodePercent | EncodeLeftTilde,
		in:   "～～＞Ｄ␍6γ␋rＮ~8ψ／fγ\vγ␜ξ\"\x11σ＆/`[ＷqＲ",
		out:  "‛～～＞Ｄ␍6γ␋rＮ~8ψ／fγ\vγ␜ξ\"\x11σ＆/`[ＷqＲ",
	}, { // 994
		mask: EncodePercent | EncodeLeftTilde,
		in:   "~S＞Ｄ␍6γ␋rＮ~8ψ／fγ\vγ␜ξ\"\x11σ＆/`[Ｗ～Ｒ",
		out:  "～S＞Ｄ␍6γ␋rＮ~8ψ／fγ\vγ␜ξ\"\x11σ＆/`[Ｗ～Ｒ",
	}, { // 995
		mask: EncodePercent | EncodeLeftTilde,
		in:   "～S＞Ｄ␍6γ␋rＮ~8ψ／fγ\vγ␜ξ\"\x11σ＆/`[Ｗ～Ｒ",
		out:  "‛～S＞Ｄ␍6γ␋rＮ~8ψ／fγ\vγ␜ξ\"\x11σ＆/`[Ｗ～Ｒ",
	}, { // 996
		mask: EncodePercent | EncodeLeftTilde,
		in:   "~S＞Ｄ␍6γ␋rＮ~8ψ／fγ\vγ␜ξ\"\x11σ＆/`[Ｗq～",
		out:  "～S＞Ｄ␍6γ␋rＮ~8ψ／fγ\vγ␜ξ\"\x11σ＆/`[Ｗq～",
	}, { // 997
		mask: EncodePercent | EncodeLeftTilde,
		in:   "～S＞Ｄ␍6γ␋rＮ~8ψ／fγ\vγ␜ξ\"\x11σ＆/`[Ｗq～",
		out:  "‛～S＞Ｄ␍6γ␋rＮ~8ψ／fγ\vγ␜ξ\"\x11σ＆/`[Ｗq～",
	}, { // 998
		mask: EncodePercent | EncodeLeftTilde,
		in:   "ｄ~＞Ｄ␍6γ␋rＮ~8ψ／fγ\vγ␜ξ\"\x11σ＆/`[ＷqＲ",
		out:  "ｄ~＞Ｄ␍6γ␋rＮ~8ψ／fγ\vγ␜ξ\"\x11σ＆/`[ＷqＲ",
	}, { // 999
		mask: EncodePercent | EncodeLeftTilde,
		in:   "ｄ～＞Ｄ␍6γ␋rＮ~8ψ／fγ\vγ␜ξ\"\x11σ＆/`[ＷqＲ",
		out:  "ｄ～＞Ｄ␍6γ␋rＮ~8ψ／fγ\vγ␜ξ\"\x11σ＆/`[ＷqＲ",
	}, { // 1000
		mask: EncodePercent | EncodeLeftTilde,
		in:   "ｄ~＞Ｄ␍6γ␋rＮ~8ψ／fγ\vγ␜ξ\"\x11σ＆/`[Ｗ～Ｒ",
		out:  "ｄ~＞Ｄ␍6γ␋rＮ~8ψ／fγ\vγ␜ξ\"\x11σ＆/`[Ｗ～Ｒ",
	}, { // 1001
		mask: EncodePercent | EncodeLeftTilde,
		in:   "ｄ～＞Ｄ␍6γ␋rＮ~8ψ／fγ\vγ␜ξ\"\x11σ＆/`[Ｗ～Ｒ",
		out:  "ｄ～＞Ｄ␍6γ␋rＮ~8ψ／fγ\vγ␜ξ\"\x11σ＆/`[Ｗ～Ｒ",
	}, { // 1002
		mask: EncodePercent | EncodeLeftTilde,
		in:   "ｄ~＞Ｄ␍6γ␋rＮ~8ψ／fγ\vγ␜ξ\"\x11σ＆/`[Ｗq～",
		out:  "ｄ~＞Ｄ␍6γ␋rＮ~8ψ／fγ\vγ␜ξ\"\x11σ＆/`[Ｗq～",
	}, { // 1003
		mask: EncodePercent | EncodeLeftTilde,
		in:   "ｄ～＞Ｄ␍6γ␋rＮ~8ψ／fγ\vγ␜ξ\"\x11σ＆/`[Ｗq～",
		out:  "ｄ～＞Ｄ␍6γ␋rＮ~8ψ／fγ\vγ␜ξ\"\x11σ＆/`[Ｗq～",
	}, { // 1004
		mask: EncodePercent | EncodeLeftTilde,
		in:   "ｄS＞Ｄ␍6γ␋rＮ~8ψ／fγ\vγ␜ξ\"\x11σ＆/`[Ｗ~Ｒ",
		out:  "ｄS＞Ｄ␍6γ␋rＮ~8ψ／fγ\vγ␜ξ\"\x11σ＆/`[Ｗ~Ｒ",
	}, { // 1005
		mask: EncodePercent | EncodeLeftTilde,
		in:   "ｄS＞Ｄ␍6γ␋rＮ~8ψ／fγ\vγ␜ξ\"\x11σ＆/`[Ｗ～Ｒ",
		out:  "ｄS＞Ｄ␍6γ␋rＮ~8ψ／fγ\vγ␜ξ\"\x11σ＆/`[Ｗ～Ｒ",
	}, { // 1006
		mask: EncodePercent | EncodeLeftTilde,
		in:   "ｄS＞Ｄ␍6γ␋rＮ~8ψ／fγ\vγ␜ξ\"\x11σ＆/`[Ｗ~～",
		out:  "ｄS＞Ｄ␍6γ␋rＮ~8ψ／fγ\vγ␜ξ\"\x11σ＆/`[Ｗ~～",
	}, { // 1007
		mask: EncodePercent | EncodeLeftTilde,
		in:   "ｄS＞Ｄ␍6γ␋rＮ~8ψ／fγ\vγ␜ξ\"\x11σ＆/`[Ｗ～～",
		out:  "ｄS＞Ｄ␍6γ␋rＮ~8ψ／fγ\vγ␜ξ\"\x11σ＆/`[Ｗ～～",
	}, { // 1008
		mask: EncodePercent | EncodeLeftTilde,
		in:   "ｄS＞Ｄ␍6γ␋rＮ~8ψ／fγ\vγ␜ξ\"\x11σ＆/`[Ｗq~",
		out:  "ｄS＞Ｄ␍6γ␋rＮ~8ψ／fγ\vγ␜ξ\"\x11σ＆/`[Ｗq~",
	}, { // 1009
		mask: EncodePercent | EncodeLeftTilde,
		in:   "ｄS＞Ｄ␍6γ␋rＮ~8ψ／fγ\vγ␜ξ\"\x11σ＆/`[Ｗq～",
		out:  "ｄS＞Ｄ␍6γ␋rＮ~8ψ／fγ\vγ␜ξ\"\x11σ＆/`[Ｗq～",
	}, { // 1010
		mask: EncodeBackSlash | EncodeLeftTilde,
		in:   "\x1bρ|ο＠\x1c\x06νηｊ~␘0＼Ａ＋υ]\x01:ψ［␒Iz␅＇ｔ?＜",
		out:  "\x1bρ|ο＠\x1c\x06νηｊ~␘0‛＼Ａ＋υ]\x01:ψ［␒Iz␅＇ｔ?＜",
	}, { // 1011
		mask: EncodeBackSlash | EncodeLeftTilde,
		in:   "~～|ο＠\x1c\x06νηｊ~␘0＼Ａ＋υ]\x01:ψ［␒Iz␅＇ｔ?＜",
		out:  "～～|ο＠\x1c\x06νηｊ~␘0‛＼Ａ＋υ]\x01:ψ［␒Iz␅＇ｔ?＜",
	}, { // 1012
		mask: EncodeBackSlash | EncodeLeftTilde,
		in:   "～～|ο＠\x1c\x06νηｊ~␘0＼Ａ＋υ]\x01:ψ［␒Iz␅＇ｔ?＜",
		out:  "‛～～|ο＠\x1c\x06νηｊ~␘0‛＼Ａ＋υ]\x01:ψ［␒Iz␅＇ｔ?＜",
	}, { // 1013
		mask: EncodeBackSlash | EncodeLeftTilde,
		in:   "~ρ|ο＠\x1c\x06νηｊ~␘0＼Ａ＋υ]\x01:ψ［␒Iz␅＇ｔ～＜",
		out:  "～ρ|ο＠\x1c\x06νηｊ~␘0‛＼Ａ＋υ]\x01:ψ［␒Iz␅＇ｔ～＜",
	}, { // 1014
		mask: EncodeBackSlash | EncodeLeftTilde,
		in:   "～ρ|ο＠\x1c\x06νηｊ~␘0＼Ａ＋υ]\x01:ψ［␒Iz␅＇ｔ～＜",
		out:  "‛～ρ|ο＠\x1c\x06νηｊ~␘0‛＼Ａ＋υ]\x01:ψ［␒Iz␅＇ｔ～＜",
	}, { // 1015
		mask: EncodeBackSlash | EncodeLeftTilde,
		in:   "~ρ|ο＠\x1c\x06νηｊ~␘0＼Ａ＋υ]\x01:ψ［␒Iz␅＇ｔ?～",
		out:  "～ρ|ο＠\x1c\x06νηｊ~␘0‛＼Ａ＋υ]\x01:ψ［␒Iz␅＇ｔ?～",
	}, { // 1016
		mask: EncodeBackSlash | EncodeLeftTilde,
		in:   "～ρ|ο＠\x1c\x06νηｊ~␘0＼Ａ＋υ]\x01:ψ［␒Iz␅＇ｔ?～",
		out:  "‛～ρ|ο＠\x1c\x06νηｊ~␘0‛＼Ａ＋υ]\x01:ψ［␒Iz␅＇ｔ?～",
	}, { // 1017
		mask: EncodeBackSlash | EncodeLeftTilde,
		in:   "\x1b~|ο＠\x1c\x06νηｊ~␘0＼Ａ＋υ]\x01:ψ［␒Iz␅＇ｔ?＜",
		out:  "\x1b~|ο＠\x1c\x06νηｊ~␘0‛＼Ａ＋υ]\x01:ψ［␒Iz␅＇ｔ?＜",
	}, { // 1018
		mask: EncodeBackSlash | EncodeLeftTilde,
		in:   "\x1b～|ο＠\x1c\x06νηｊ~␘0＼Ａ＋υ]\x01:ψ［␒Iz␅＇ｔ?＜",
		out:  "\x1b～|ο＠\x1c\x06νηｊ~␘0‛＼Ａ＋υ]\x01:ψ［␒Iz␅＇ｔ?＜",
	}, { // 1019
		mask: EncodeBackSlash | EncodeLeftTilde,
		in:   "\x1b~|ο＠\x1c\x06νηｊ~␘0＼Ａ＋υ]\x01:ψ［␒Iz␅＇ｔ～＜",
		out:  "\x1b~|ο＠\x1c\x06νηｊ~␘0‛＼Ａ＋υ]\x01:ψ［␒Iz␅＇ｔ～＜",
	}, { // 1020
		mask: EncodeBackSlash | EncodeLeftTilde,
		in:   "\x1b～|ο＠\x1c\x06νηｊ~␘0＼Ａ＋υ]\x01:ψ［␒Iz␅＇ｔ～＜",
		out:  "\x1b～|ο＠\x1c\x06νηｊ~␘0‛＼Ａ＋υ]\x01:ψ［␒Iz␅＇ｔ～＜",
	}, { // 1021
		mask: EncodeBackSlash | EncodeLeftTilde,
		in:   "\x1b~|ο＠\x1c\x06νηｊ~␘0＼Ａ＋υ]\x01:ψ［␒Iz␅＇ｔ?～",
		out:  "\x1b~|ο＠\x1c\x06νηｊ~␘0‛＼Ａ＋υ]\x01:ψ［␒Iz␅＇ｔ?～",
	}, { // 1022
		mask: EncodeBackSlash | EncodeLeftTilde,
		in:   "\x1b～|ο＠\x1c\x06νηｊ~␘0＼Ａ＋υ]\x01:ψ［␒Iz␅＇ｔ?～",
		out:  "\x1b～|ο＠\x1c\x06νηｊ~␘0‛＼Ａ＋υ]\x01:ψ［␒Iz␅＇ｔ?～",
	}, { // 1023
		mask: EncodeBackSlash | EncodeLeftTilde,
		in:   "\x1bρ|ο＠\x1c\x06νηｊ~␘0＼Ａ＋υ]\x01:ψ［␒Iz␅＇ｔ~＜",
		out:  "\x1bρ|ο＠\x1c\x06νηｊ~␘0‛＼Ａ＋υ]\x01:ψ［␒Iz␅＇ｔ~＜",
	}, { // 1024
		mask: EncodeBackSlash | EncodeLeftTilde,
		in:   "\x1bρ|ο＠\x1c\x06νηｊ~␘0＼Ａ＋υ]\x01:ψ［␒Iz␅＇ｔ～＜",
		out:  "\x1bρ|ο＠\x1c\x06νηｊ~␘0‛＼Ａ＋υ]\x01:ψ［␒Iz␅＇ｔ～＜",
	}, { // 1025
		mask: EncodeBackSlash | EncodeLeftTilde,
		in:   "\x1bρ|ο＠\x1c\x06νηｊ~␘0＼Ａ＋υ]\x01:ψ［␒Iz␅＇ｔ~～",
		out:  "\x1bρ|ο＠\x1c\x06νηｊ~␘0‛＼Ａ＋υ]\x01:ψ［␒Iz␅＇ｔ~～",
	}, { // 1026
		mask: EncodeBackSlash | EncodeLeftTilde,
		in:   "\x1bρ|ο＠\x1c\x06νηｊ~␘0＼Ａ＋υ]\x01:ψ［␒Iz␅＇ｔ～～",
		out:  "\x1bρ|ο＠\x1c\x06νηｊ~␘0‛＼Ａ＋υ]\x01:ψ［␒Iz␅＇ｔ～～",
	}, { // 1027
		mask: EncodeBackSlash | EncodeLeftTilde,
		in:   "\x1bρ|ο＠\x1c\x06νηｊ~␘0＼Ａ＋υ]\x01:ψ［␒Iz␅＇ｔ?~",
		out:  "\x1bρ|ο＠\x1c\x06νηｊ~␘0‛＼Ａ＋υ]\x01:ψ［␒Iz␅＇ｔ?~",
	}, { // 1028
		mask: EncodeBackSlash | EncodeLeftTilde,
		in:   "\x1bρ|ο＠\x1c\x06νηｊ~␘0＼Ａ＋υ]\x01:ψ［␒Iz␅＇ｔ?～",
		out:  "\x1bρ|ο＠\x1c\x06νηｊ~␘0‛＼Ａ＋υ]\x01:ψ［␒Iz␅＇ｔ?～",
	}, { // 1029
		mask: EncodeCrLf | EncodeLeftTilde,
		in:   "χ␒！␀α０τ\a＊θ~？θ\x13]h:w/；␐ο＼\uff00@]q␍;\x04",
		out:  "χ␒！‛␀α０τ\a＊θ~？θ\x13]h:w/；␐ο＼\uff00@]q‛␍;\x04",
	}, { // 1030
		mask: EncodeCrLf | EncodeLeftTilde,
		in:   "~～！␀α０τ\a＊θ~？θ\x13]h:w/；␐ο＼\uff00@]q␍;\x04",
		out:  "～～！‛␀α０τ\a＊θ~？θ\x13]h:w/；␐ο＼\uff00@]q‛␍;\x04",
	}, { // 1031
		mask: EncodeCrLf | EncodeLeftTilde,
		in:   "～～！␀α０τ\a＊θ~？θ\x13]h:w/；␐ο＼\uff00@]q␍;\x04",
		out:  "‛～～！‛␀α０τ\a＊θ~？θ\x13]h:w/；␐ο＼\uff00@]q‛␍;\x04",
	}, { // 1032
		mask: EncodeCrLf | EncodeLeftTilde,
		in:   "~␒！␀α０τ\a＊θ~？θ\x13]h:w/；␐ο＼\uff00@]q␍～\x04",
		out:  "～␒！‛␀α０τ\a＊θ~？θ\x13]h:w/；␐ο＼\uff00@]q‛␍～\x04",
	}, { // 1033
		mask: EncodeCrLf | EncodeLeftTilde,
		in:   "～␒！␀α０τ\a＊θ~？θ\x13]h:w/；␐ο＼\uff00@]q␍～\x04",
		out:  "‛～␒！‛␀α０τ\a＊θ~？θ\x13]h:w/；␐ο＼\uff00@]q‛␍～\x04",
	}, { // 1034
		mask: EncodeCrLf | EncodeLeftTilde,
		in:   "~␒！␀α０τ\a＊θ~？θ\x13]h:w/；␐ο＼\uff00@]q␍;～",
		out:  "～␒！‛␀α０τ\a＊θ~？θ\x13]h:w/；␐ο＼\uff00@]q‛␍;～",
	}, { // 1035
		mask: EncodeCrLf | EncodeLeftTilde,
		in:   "～␒！␀α０τ\a＊θ~？θ\x13]h:w/；␐ο＼\uff00@]q␍;～",
		out:  "‛～␒！‛␀α０τ\a＊θ~？θ\x13]h:w/；␐ο＼\uff00@]q‛␍;～",
	}, { // 1036
		mask: EncodeCrLf | EncodeLeftTilde,
		in:   "χ~！␀α０τ\a＊θ~？θ\x13]h:w/；␐ο＼\uff00@]q␍;\x04",
		out:  "χ~！‛␀α０τ\a＊θ~？θ\x13]h:w/；␐ο＼\uff00@]q‛␍;\x04",
	}, { // 1037
		mask: EncodeCrLf | EncodeLeftTilde,
		in:   "χ～！␀α０τ\a＊θ~？θ\x13]h:w/；␐ο＼\uff00@]q␍;\x04",
		out:  "χ～！‛␀α０τ\a＊θ~？θ\x13]h:w/；␐ο＼\uff00@]q‛␍;\x04",
	}, { // 1038
		mask: EncodeCrLf | EncodeLeftTilde,
		in:   "χ~！␀α０τ\a＊θ~？θ\x13]h:w/；␐ο＼\uff00@]q␍～\x04",
		out:  "χ~！‛␀α０τ\a＊θ~？θ\x13]h:w/；␐ο＼\uff00@]q‛␍～\x04",
	}, { // 1039
		mask: EncodeCrLf | EncodeLeftTilde,
		in:   "χ～！␀α０τ\a＊θ~？θ\x13]h:w/；␐ο＼\uff00@]q␍～\x04",
		out:  "χ～！‛␀α０τ\a＊θ~？θ\x13]h:w/；␐ο＼\uff00@]q‛␍～\x04",
	}, { // 1040
		mask: EncodeCrLf | EncodeLeftTilde,
		in:   "χ~！␀α０τ\a＊θ~？θ\x13]h:w/；␐ο＼\uff00@]q␍;～",
		out:  "χ~！‛␀α０τ\a＊θ~？θ\x13]h:w/；␐ο＼\uff00@]q‛␍;～",
	}, { // 1041
		mask: EncodeCrLf | EncodeLeftTilde,
		in:   "χ～！␀α０τ\a＊θ~？θ\x13]h:w/；␐ο＼\uff00@]q␍;～",
		out:  "χ～！‛␀α０τ\a＊θ~？θ\x13]h:w/；␐ο＼\uff00@]q‛␍;～",
	}, { // 1042
		mask: EncodeCrLf | EncodeLeftTilde,
		in:   "χ␒！␀α０τ\a＊θ~？θ\x13]h:w/；␐ο＼\uff00@]q␍~\x04",
		out:  "χ␒！‛␀α０τ\a＊θ~？θ\x13]h:w/；␐ο＼\uff00@]q‛␍~\x04",
	}, { // 1043
		mask: EncodeCrLf | EncodeLeftTilde,
		in:   "χ␒！␀α０τ\a＊θ~？θ\x13]h:w/；␐ο＼\uff00@]q␍～\x04",
		out:  "χ␒！‛␀α０τ\a＊θ~？θ\x13]h:w/；␐ο＼\uff00@]q‛␍～\x04",
	}, { // 1044
		mask: EncodeCrLf | EncodeLeftTilde,
		in:   "χ␒！␀α０τ\a＊θ~？θ\x13]h:w/；␐ο＼\uff00@]q␍~～",
		out:  "χ␒！‛␀α０τ\a＊θ~？θ\x13]h:w/；␐ο＼\uff00@]q‛␍~～",
	}, { // 1045
		mask: EncodeCrLf | EncodeLeftTilde,
		in:   "χ␒！␀α０τ\a＊θ~？θ\x13]h:w/；␐ο＼\uff00@]q␍～～",
		out:  "χ␒！‛␀α０τ\a＊θ~？θ\x13]h:w/；␐ο＼\uff00@]q‛␍～～",
	}, { // 1046
		mask: EncodeCrLf | EncodeLeftTilde,
		in:   "χ␒！␀α０τ\a＊θ~？θ\x13]h:w/；␐ο＼\uff00@]q␍;~",
		out:  "χ␒！‛␀α０τ\a＊θ~？θ\x13]h:w/；␐ο＼\uff00@]q‛␍;~",
	}, { // 1047
		mask: EncodeCrLf | EncodeLeftTilde,
		in:   "χ␒！␀α０τ\a＊θ~？θ\x13]h:w/；␐ο＼\uff00@]q␍;～",
		out:  "χ␒！‛␀α０τ\a＊θ~？θ\x13]h:w/；␐ο＼\uff00@]q‛␍;～",
	}, { // 1048
		mask: EncodeDel | EncodeLeftTilde,
		in:   "\"␆Ｈ\x02␚－\x12／␏>~␒３πφ－#＜ωNrκπ~－W|ｉχ\a",
		out:  "\"␆Ｈ\x02␚－\x12／␏>~␒３πφ－#＜ωNrκπ~－W|ｉχ\a",
	}, { // 1049
		mask: EncodeDel | EncodeLeftTilde,
		in:   "~～Ｈ\x02␚－\x12／␏>~␒３πφ－#＜ωNrκπ~－W|ｉχ\a",
		out:  "～～Ｈ\x02␚－\x12／␏>~␒３πφ－#＜ωNrκπ~－W|ｉχ\a",
	}, { // 1050
		mask: EncodeDel | EncodeLeftTilde,
		in:   "～～Ｈ\x02␚－\x12／␏>~␒３πφ－#＜ωNrκπ~－W|ｉχ\a",
		out:  "‛～～Ｈ\x02␚－\x12／␏>~␒３πφ－#＜ωNrκπ~－W|ｉχ\a",
	}, { // 1051
		mask: EncodeDel | EncodeLeftTilde,
		in:   "~␆Ｈ\x02␚－\x12／␏>~␒３πφ－#＜ωNrκπ~－W|ｉ～\a",
		out:  "～␆Ｈ\x02␚－\x12／␏>~␒３πφ－#＜ωNrκπ~－W|ｉ～\a",
	}, { // 1052
		mask: EncodeDel | EncodeLeftTilde,
		in:   "～␆Ｈ\x02␚－\x12／␏>~␒３πφ－#＜ωNrκπ~－W|ｉ～\a",
		out:  "‛～␆Ｈ\x02␚－\x12／␏>~␒３πφ－#＜ωNrκπ~－W|ｉ～\a",
	}, { // 1053
		mask: EncodeDel | EncodeLeftTilde,
		in:   "~␆Ｈ\x02␚－\x12／␏>~␒３πφ－#＜ωNrκπ~－W|ｉχ～",
		out:  "～␆Ｈ\x02␚－\x12／␏>~␒３πφ－#＜ωNrκπ~－W|ｉχ～",
	}, { // 1054
		mask: EncodeDel | EncodeLeftTilde,
		in:   "～␆Ｈ\x02␚－\x12／␏>~␒３πφ－#＜ωNrκπ~－W|ｉχ～",
		out:  "‛～␆Ｈ\x02␚－\x12／␏>~␒３πφ－#＜ωNrκπ~－W|ｉχ～",
	}, { // 1055
		mask: EncodeDel | EncodeLeftTilde,
		in:   "\"~Ｈ\x02␚－\x12／␏>~␒３πφ－#＜ωNrκπ~－W|ｉχ\a",
		out:  "\"~Ｈ\x02␚－\x12／␏>~␒３πφ－#＜ωNrκπ~－W|ｉχ\a",
	}, { // 1056
		mask: EncodeDel | EncodeLeftTilde,
		in:   "\"～Ｈ\x02␚－\x12／␏>~␒３πφ－#＜ωNrκπ~－W|ｉχ\a",
		out:  "\"～Ｈ\x02␚－\x12／␏>~␒３πφ－#＜ωNrκπ~－W|ｉχ\a",
	}, { // 1057
		mask: EncodeDel | EncodeLeftTilde,
		in:   "\"~Ｈ\x02␚－\x12／␏>~␒３πφ－#＜ωNrκπ~－W|ｉ～\a",
		out:  "\"~Ｈ\x02␚－\x12／␏>~␒３πφ－#＜ωNrκπ~－W|ｉ～\a",
	}, { // 1058
		mask: EncodeDel | EncodeLeftTilde,
		in:   "\"～Ｈ\x02␚－\x12／␏>~␒３πφ－#＜ωNrκπ~－W|ｉ～\a",
		out:  "\"～Ｈ\x02␚－\x12／␏>~␒３πφ－#＜ωNrκπ~－W|ｉ～\a",
	}, { // 1059
		mask: EncodeDel | EncodeLeftTilde,
		in:   "\"~Ｈ\x02␚－\x12／␏>~␒３πφ－#＜ωNrκπ~－W|ｉχ～",
		out:  "\"~Ｈ\x02␚－\x12／␏>~␒３πφ－#＜ωNrκπ~－W|ｉχ～",
	}, { // 1060
		mask: EncodeDel | EncodeLeftTilde,
		in:   "\"～Ｈ\x02␚－\x12／␏>~␒３πφ－#＜ωNrκπ~－W|ｉχ～",
		out:  "\"～Ｈ\x02␚－\x12／␏>~␒３πφ－#＜ωNrκπ~－W|ｉχ～",
	}, { // 1061
		mask: EncodeDel | EncodeLeftTilde,
		in:   "\"␆Ｈ\x02␚－\x12／␏>~␒３πφ－#＜ωNrκπ~－W|ｉ~\a",
		out:  "\"␆Ｈ\x02␚－\x12／␏>~␒３πφ－#＜ωNrκπ~－W|ｉ~\a",
	}, { // 1062
		mask: EncodeDel | EncodeLeftTilde,
		in:   "\"␆Ｈ\x02␚－\x12／␏>~␒３πφ－#＜ωNrκπ~－W|ｉ～\a",
		out:  "\"␆Ｈ\x02␚－\x12／␏>~␒３πφ－#＜ωNrκπ~－W|ｉ～\a",
	}, { // 1063
		mask: EncodeDel | EncodeLeftTilde,
		in:   "\"␆Ｈ\x02␚－\x12／␏>~␒３πφ－#＜ωNrκπ~－W|ｉ~～",
		out:  "\"␆Ｈ\x02␚－\x12／␏>~␒３πφ－#＜ωNrκπ~－W|ｉ~～",
	}, { // 1064
		mask: EncodeDel | EncodeLeftTilde,
		in:   "\"␆Ｈ\x02␚－\x12／␏>~␒３πφ－#＜ωNrκπ~－W|ｉ～～",
		out:  "\"␆Ｈ\x02␚－\x12／␏>~␒３πφ－#＜ωNrκπ~－W|ｉ～～",
	}, { // 1065
		mask: EncodeDel | EncodeLeftTilde,
		in:   "\"␆Ｈ\x02␚－\x12／␏>~␒３πφ－#＜ωNrκπ~－W|ｉχ~",
		out:  "\"␆Ｈ\x02␚－\x12／␏>~␒３πφ－#＜ωNrκπ~－W|ｉχ~",
	}, { // 1066
		mask: EncodeDel | EncodeLeftTilde,
		in:   "\"␆Ｈ\x02␚－\x12／␏>~␒３πφ－#＜ωNrκπ~－W|ｉχ～",
		out:  "\"␆Ｈ\x02␚－\x12／␏>~␒３πφ－#＜ωNrκπ~－W|ｉχ～",
	}, { // 1067
		mask: EncodeCtl | EncodeLeftTilde,
		in:   "5␑：．␉*ι␀Ｒγ~Z#ςξ)τ（ζ?␘n\x03ｚＢＰ\f7;\\",
		out:  "5‛␑：．‛␉*ι‛␀Ｒγ~Z#ςξ)τ（ζ?‛␘n␃ｚＢＰ␌7;\\",
	}, { // 1068
		mask: EncodeCtl | EncodeLeftTilde,
		in:   "~～：．␉*ι␀Ｒγ~Z#ςξ)τ（ζ?␘n\x03ｚＢＰ\f7;\\",
		out:  "～～：．‛␉*ι‛␀Ｒγ~Z#ςξ)τ（ζ?‛␘n␃ｚＢＰ␌7;\\",
	}, { // 1069
		mask: EncodeCtl | EncodeLeftTilde,
		in:   "～～：．␉*ι␀Ｒγ~Z#ςξ)τ（ζ?␘n\x03ｚＢＰ\f7;\\",
		out:  "‛～～：．‛␉*ι‛␀Ｒγ~Z#ςξ)τ（ζ?‛␘n␃ｚＢＰ␌7;\\",
	}, { // 1070
		mask: EncodeCtl | EncodeLeftTilde,
		in:   "~␑：．␉*ι␀Ｒγ~Z#ςξ)τ（ζ?␘n\x03ｚＢＰ\f7～\\",
		out:  "～‛␑：．‛␉*ι‛␀Ｒγ~Z#ςξ)τ（ζ?‛␘n␃ｚＢＰ␌7～\\",
	}, { // 1071
		mask: EncodeCtl | EncodeLeftTilde,
		in:   "～␑：．␉*ι␀Ｒγ~Z#ςξ)τ（ζ?␘n\x03ｚＢＰ\f7～\\",
		out:  "‛～‛␑：．‛␉*ι‛␀Ｒγ~Z#ςξ)τ（ζ?‛␘n␃ｚＢＰ␌7～\\",
	}, { // 1072
		mask: EncodeCtl | EncodeLeftTilde,
		in:   "~␑：．␉*ι␀Ｒγ~Z#ςξ)τ（ζ?␘n\x03ｚＢＰ\f7;～",
		out:  "～‛␑：．‛␉*ι‛␀Ｒγ~Z#ςξ)τ（ζ?‛␘n␃ｚＢＰ␌7;～",
	}, { // 1073
		mask: EncodeCtl | EncodeLeftTilde,
		in:   "～␑：．␉*ι␀Ｒγ~Z#ςξ)τ（ζ?␘n\x03ｚＢＰ\f7;～",
		out:  "‛～‛␑：．‛␉*ι‛␀Ｒγ~Z#ςξ)τ（ζ?‛␘n␃ｚＢＰ␌7;～",
	}, { // 1074
		mask: EncodeCtl | EncodeLeftTilde,
		in:   "5~：．␉*ι␀Ｒγ~Z#ςξ)τ（ζ?␘n\x03ｚＢＰ\f7;\\",
		out:  "5~：．‛␉*ι‛␀Ｒγ~Z#ςξ)τ（ζ?‛␘n␃ｚＢＰ␌7;\\",
	}, { // 1075
		mask: EncodeCtl | EncodeLeftTilde,
		in:   "5～：．␉*ι␀Ｒγ~Z#ςξ)τ（ζ?␘n\x03ｚＢＰ\f7;\\",
		out:  "5～：．‛␉*ι‛␀Ｒγ~Z#ςξ)τ（ζ?‛␘n␃ｚＢＰ␌7;\\",
	}, { // 1076
		mask: EncodeCtl | EncodeLeftTilde,
		in:   "5~：．␉*ι␀Ｒγ~Z#ςξ)τ（ζ?␘n\x03ｚＢＰ\f7～\\",
		out:  "5~：．‛␉*ι‛␀Ｒγ~Z#ςξ)τ（ζ?‛␘n␃ｚＢＰ␌7～\\",
	}, { // 1077
		mask: EncodeCtl | EncodeLeftTilde,
		in:   "5～：．␉*ι␀Ｒγ~Z#ςξ)τ（ζ?␘n\x03ｚＢＰ\f7～\\",
		out:  "5～：．‛␉*ι‛␀Ｒγ~Z#ςξ)τ（ζ?‛␘n␃ｚＢＰ␌7～\\",
	}, { // 1078
		mask: EncodeCtl | EncodeLeftTilde,
		in:   "5~：．␉*ι␀Ｒγ~Z#ςξ)τ（ζ?␘n\x03ｚＢＰ\f7;～",
		out:  "5~：．‛␉*ι‛␀Ｒγ~Z#ςξ)τ（ζ?‛␘n␃ｚＢＰ␌7;～",
	}, { // 1079
		mask: EncodeCtl | EncodeLeftTilde,
		in:   "5～：．␉*ι␀Ｒγ~Z#ςξ)τ（ζ?␘n\x03ｚＢＰ\f7;～",
		out:  "5～：．‛␉*ι‛␀Ｒγ~Z#ςξ)τ（ζ?‛␘n␃ｚＢＰ␌7;～",
	}, { // 1080
		mask: EncodeCtl | EncodeLeftTilde,
		in:   "5␑：．␉*ι␀Ｒγ~Z#ςξ)τ（ζ?␘n\x03ｚＢＰ\f7~\\",
		out:  "5‛␑：．‛␉*ι‛␀Ｒγ~Z#ςξ)τ（ζ?‛␘n␃ｚＢＰ␌7~\\",
	}, { // 1081
		mask: EncodeCtl | EncodeLeftTilde,
		in:   "5␑：．␉*ι␀Ｒγ~Z#ςξ)τ（ζ?␘n\x03ｚＢＰ\f7～\\",
		out:  "5‛␑：．‛␉*ι‛␀Ｒγ~Z#ςξ)τ（ζ?‛␘n␃ｚＢＰ␌7～\\",
	}, { // 1082
		mask: EncodeCtl | EncodeLeftTilde,
		in:   "5␑：．␉*ι␀Ｒγ~Z#ςξ)τ（ζ?␘n\x03ｚＢＰ\f7~～",
		out:  "5‛␑：．‛␉*ι‛␀Ｒγ~Z#ςξ)τ（ζ?‛␘n␃ｚＢＰ␌7~～",
	}, { // 1083
		mask: EncodeCtl | EncodeLeftTilde,
		in:   "5␑：．␉*ι␀Ｒγ~Z#ςξ)τ（ζ?␘n\x03ｚＢＰ\f7～～",
		out:  "5‛␑：．‛␉*ι‛␀Ｒγ~Z#ςξ)τ（ζ?‛␘n␃ｚＢＰ␌7～～",
	}, { // 1084
		mask: EncodeCtl | EncodeLeftTilde,
		in:   "5␑：．␉*ι␀Ｒγ~Z#ςξ)τ（ζ?␘n\x03ｚＢＰ\f7;~",
		out:  "5‛␑：．‛␉*ι‛␀Ｒγ~Z#ςξ)τ（ζ?‛␘n␃ｚＢＰ␌7;~",
	}, { // 1085
		mask: EncodeCtl | EncodeLeftTilde,
		in:   "5␑：．␉*ι␀Ｒγ~Z#ςξ)τ（ζ?␘n\x03ｚＢＰ\f7;～",
		out:  "5‛␑：．‛␉*ι‛␀Ｒγ~Z#ςξ)τ（ζ?‛␘n␃ｚＢＰ␌7;～",
	}, { // 1086
		mask: EncodeLeftCrLfHtVt,
		in:   "\t",
		out:  "␉",
	}, { // 1087
		mask: EncodeLeftCrLfHtVt,
		in:   "\n",
		out:  "␊",
	}, { // 1088
		mask: EncodeLeftCrLfHtVt,
		in:   "\v",
		out:  "␋",
	}, { // 1089
		mask: EncodeLeftCrLfHtVt,
		in:   "\r",
		out:  "␍",
	}, { // 1090
		mask: EncodeZero | EncodeLeftCrLfHtVt,
		in:   "\x17＃␟;\aωｇJ*ω\t:?＞βν␄␗H+υ＃（；\x18:ω｜［８",
		out:  "\x17＃␟;\aωｇJ*ω\t:?＞βν␄␗H+υ＃（；\x18:ω｜［８",
	}, { // 1091
		mask: EncodeZero | EncodeLeftCrLfHtVt,
		in:   "\t␉␟;\aωｇJ*ω\t:?＞βν␄␗H+υ＃（；\x18:ω｜［８",
		out:  "␉␉␟;\aωｇJ*ω\t:?＞βν␄␗H+υ＃（；\x18:ω｜［８",
	}, { // 1092
		mask: EncodeZero | EncodeLeftCrLfHtVt,
		in:   "␉␉␟;\aωｇJ*ω\t:?＞βν␄␗H+υ＃（；\x18:ω｜［８",
		out:  "‛␉␉␟;\aωｇJ*ω\t:?＞βν␄␗H+υ＃（；\x18:ω｜［８",
	}, { // 1093
		mask: EncodeZero | EncodeLeftCrLfHtVt,
		in:   "\t＃␟;\aωｇJ*ω\t:?＞βν␄␗H+υ＃（；\x18:ω｜␉８",
		out:  "␉＃␟;\aωｇJ*ω\t:?＞βν␄␗H+υ＃（；\x18:ω｜␉８",
	}, { // 1094
		mask: EncodeZero | EncodeLeftCrLfHtVt,
		in:   "␉＃␟;\aωｇJ*ω\t:?＞βν␄␗H+υ＃（；\x18:ω｜␉８",
		out:  "‛␉＃␟;\aωｇJ*ω\t:?＞βν␄␗H+υ＃（；\x18:ω｜␉８",
	}, { // 1095
		mask: EncodeZero | EncodeLeftCrLfHtVt,
		in:   "\t＃␟;\aωｇJ*ω\t:?＞βν␄␗H+υ＃（；\x18:ω｜［␉",
		out:  "␉＃␟;\aωｇJ*ω\t:?＞βν␄␗H+υ＃（；\x18:ω｜［␉",
	}, { // 1096
		mask: EncodeZero | EncodeLeftCrLfHtVt,
		in:   "␉＃␟;\aωｇJ*ω\t:?＞βν␄␗H+υ＃（；\x18:ω｜［␉",
		out:  "‛␉＃␟;\aωｇJ*ω\t:?＞βν␄␗H+υ＃（；\x18:ω｜［␉",
	}, { // 1097
		mask: EncodeZero | EncodeLeftCrLfHtVt,
		in:   "\x17\t␟;\aωｇJ*ω\t:?＞βν␄␗H+υ＃（；\x18:ω｜［８",
		out:  "\x17\t␟;\aωｇJ*ω\t:?＞βν␄␗H+υ＃（；\x18:ω｜［８",
	}, { // 1098
		mask: EncodeZero | EncodeLeftCrLfHtVt,
		in:   "\x17␉␟;\aωｇJ*ω\t:?＞βν␄␗H+υ＃（；\x18:ω｜［８",
		out:  "\x17␉␟;\aωｇJ*ω\t:?＞βν␄␗H+υ＃（；\x18:ω｜［８",
	}, { // 1099
		mask: EncodeZero | EncodeLeftCrLfHtVt,
		in:   "\x17\t␟;\aωｇJ*ω\t:?＞βν␄␗H+υ＃（；\x18:ω｜␉８",
		out:  "\x17\t␟;\aωｇJ*ω\t:?＞βν␄␗H+υ＃（；\x18:ω｜␉８",
	}, { // 1100
		mask: EncodeZero | EncodeLeftCrLfHtVt,
		in:   "\x17␉␟;\aωｇJ*ω\t:?＞βν␄␗H+υ＃（；\x18:ω｜␉８",
		out:  "\x17␉␟;\aωｇJ*ω\t:?＞βν␄␗H+υ＃（；\x18:ω｜␉８",
	}, { // 1101
		mask: EncodeZero | EncodeLeftCrLfHtVt,
		in:   "\x17\t␟;\aωｇJ*ω\t:?＞βν␄␗H+υ＃（；\x18:ω｜［␉",
		out:  "\x17\t␟;\aωｇJ*ω\t:?＞βν␄␗H+υ＃（；\x18:ω｜［␉",
	}, { // 1102
		mask: EncodeZero | EncodeLeftCrLfHtVt,
		in:   "\x17␉␟;\aωｇJ*ω\t:?＞βν␄␗H+υ＃（；\x18:ω｜［␉",
		out:  "\x17␉␟;\aωｇJ*ω\t:?＞βν␄␗H+υ＃（；\x18:ω｜［␉",
	}, { // 1103
		mask: EncodeZero | EncodeLeftCrLfHtVt,
		in:   "\x17＃␟;\aωｇJ*ω\t:?＞βν␄␗H+υ＃（；\x18:ω｜\t８",
		out:  "\x17＃␟;\aωｇJ*ω\t:?＞βν␄␗H+υ＃（；\x18:ω｜\t８",
	}, { // 1104
		mask: EncodeZero | EncodeLeftCrLfHtVt,
		in:   "\x17＃␟;\aωｇJ*ω\t:?＞βν␄␗H+υ＃（；\x18:ω｜␉８",
		out:  "\x17＃␟;\aωｇJ*ω\t:?＞βν␄␗H+υ＃（；\x18:ω｜␉８",
	}, { // 1105
		mask: EncodeZero | EncodeLeftCrLfHtVt,
		in:   "\x17＃␟;\aωｇJ*ω\t:?＞βν␄␗H+υ＃（；\x18:ω｜\t␉",
		out:  "\x17＃␟;\aωｇJ*ω\t:?＞βν␄␗H+υ＃（；\x18:ω｜\t␉",
	}, { // 1106
		mask: EncodeZero | EncodeLeftCrLfHtVt,
		in:   "\x17＃␟;\aωｇJ*ω\t:?＞βν␄␗H+υ＃（；\x18:ω｜␉␉",
		out:  "\x17＃␟;\aωｇJ*ω\t:?＞βν␄␗H+υ＃（；\x18:ω｜␉␉",
	}, { // 1107
		mask: EncodeZero | EncodeLeftCrLfHtVt,
		in:   "\x17＃␟;\aωｇJ*ω\t:?＞βν␄␗H+υ＃（；\x18:ω｜［\t",
		out:  "\x17＃␟;\aωｇJ*ω\t:?＞βν␄␗H+υ＃（；\x18:ω｜［\t",
	}, { // 1108
		mask: EncodeZero | EncodeLeftCrLfHtVt,
		in:   "\x17＃␟;\aωｇJ*ω\t:?＞βν␄␗H+υ＃（；\x18:ω｜［␉",
		out:  "\x17＃␟;\aωｇJ*ω\t:?＞βν␄␗H+υ＃（；\x18:ω｜［␉",
	}, { // 1109
		mask: EncodeZero | EncodeLeftCrLfHtVt,
		in:   "Ｓ\x0eπＺiε＂\n`？\nπk＞ψ␍＃\n/υ＿／␋\x16\uff00Go\r}７",
		out:  "Ｓ\x0eπＺiε＂\n`？\nπk＞ψ␍＃\n/υ＿／␋\x16\uff00Go\r}７",
	}, { // 1110
		mask: EncodeZero | EncodeLeftCrLfHtVt,
		in:   "\n␊πＺiε＂\n`？\nπk＞ψ␍＃\n/υ＿／␋\x16\uff00Go\r}７",
		out:  "␊␊πＺiε＂\n`？\nπk＞ψ␍＃\n/υ＿／␋\x16\uff00Go\r}７",
	}, { // 1111
		mask: EncodeZero | EncodeLeftCrLfHtVt,
		in:   "␊␊πＺiε＂\n`？\nπk＞ψ␍＃\n/υ＿／␋\x16\uff00Go\r}７",
		out:  "‛␊␊πＺiε＂\n`？\nπk＞ψ␍＃\n/υ＿／␋\x16\uff00Go\r}７",
	}, { // 1112
		mask: EncodeZero | EncodeLeftCrLfHtVt,
		in:   "\n\x0eπＺiε＂\n`？\nπk＞ψ␍＃\n/υ＿／␋\x16\uff00Go\r␊７",
		out:  "␊\x0eπＺiε＂\n`？\nπk＞ψ␍＃\n/υ＿／␋\x16\uff00Go\r␊７",
	}, { // 1113
		mask: EncodeZero | EncodeLeftCrLfHtVt,
		in:   "␊\x0eπＺiε＂\n`？\nπk＞ψ␍＃\n/υ＿／␋\x16\uff00Go\r␊７",
		out:  "‛␊\x0eπＺiε＂\n`？\nπk＞ψ␍＃\n/υ＿／␋\x16\uff00Go\r␊７",
	}, { // 1114
		mask: EncodeZero | EncodeLeftCrLfHtVt,
		in:   "\n\x0eπＺiε＂\n`？\nπk＞ψ␍＃\n/υ＿／␋\x16\uff00Go\r}␊",
		out:  "␊\x0eπＺiε＂\n`？\nπk＞ψ␍＃\n/υ＿／␋\x16\uff00Go\r}␊",
	}, { // 1115
		mask: EncodeZero | EncodeLeftCrLfHtVt,
		in:   "␊\x0eπＺiε＂\n`？\nπk＞ψ␍＃\n/υ＿／␋\x16\uff00Go\r}␊",
		out:  "‛␊\x0eπＺiε＂\n`？\nπk＞ψ␍＃\n/υ＿／␋\x16\uff00Go\r}␊",
	}, { // 1116
		mask: EncodeZero | EncodeLeftCrLfHtVt,
		in:   "Ｓ\nπＺiε＂\n`？\nπk＞ψ␍＃\n/υ＿／␋\x16\uff00Go\r}７",
		out:  "Ｓ\nπＺiε＂\n`？\nπk＞ψ␍＃\n/υ＿／␋\x16\uff00Go\r}７",
	}, { // 1117
		mask: EncodeZero | EncodeLeftCrLfHtVt,
		in:   "Ｓ␊πＺiε＂\n`？\nπk＞ψ␍＃\n/υ＿／␋\x16\uff00Go\r}７",
		out:  "Ｓ␊πＺiε＂\n`？\nπk＞ψ␍＃\n/υ＿／␋\x16\uff00Go\r}７",
	}, { // 1118
		mask: EncodeZero | EncodeLeftCrLfHtVt,
		in:   "Ｓ\nπＺiε＂\n`？\nπk＞ψ␍＃\n/υ＿／␋\x16\uff00Go\r␊７",
		out:  "Ｓ\nπＺiε＂\n`？\nπk＞ψ␍＃\n/υ＿／␋\x16\uff00Go\r␊７",
	}, { // 1119
		mask: EncodeZero | EncodeLeftCrLfHtVt,
		in:   "Ｓ␊πＺiε＂\n`？\nπk＞ψ␍＃\n/υ＿／␋\x16\uff00Go\r␊７",
		out:  "Ｓ␊πＺiε＂\n`？\nπk＞ψ␍＃\n/υ＿／␋\x16\uff00Go\r␊７",
	}, { // 1120
		mask: EncodeZero | EncodeLeftCrLfHtVt,
		in:   "Ｓ\nπＺiε＂\n`？\nπk＞ψ␍＃\n/υ＿／␋\x16\uff00Go\r}␊",
		out:  "Ｓ\nπＺiε＂\n`？\nπk＞ψ␍＃\n/υ＿／␋\x16\uff00Go\r}␊",
	}, { // 1121
		mask: EncodeZero | EncodeLeftCrLfHtVt,
		in:   "Ｓ␊πＺiε＂\n`？\nπk＞ψ␍＃\n/υ＿／␋\x16\uff00Go\r}␊",
		out:  "Ｓ␊πＺiε＂\n`？\nπk＞ψ␍＃\n/υ＿／␋\x16\uff00Go\r}␊",
	}, { // 1122
		mask: EncodeZero | EncodeLeftCrLfHtVt,
		in:   "Ｓ\x0eπＺiε＂\n`？\nπk＞ψ␍＃\n/υ＿／␋\x16\uff00Go\r\n７",
		out:  "Ｓ\x0eπＺiε＂\n`？\nπk＞ψ␍＃\n/υ＿／␋\x16\uff00Go\r\n７",
	}, { // 1123
		mask: EncodeZero | EncodeLeftCrLfHtVt,
		in:   "Ｓ\x0eπＺiε＂\n`？\nπk＞ψ␍＃\n/υ＿／␋\x16\uff00Go\r␊７",
		out:  "Ｓ\x0eπＺiε＂\n`？\nπk＞ψ␍＃\n/υ＿／␋\x16\uff00Go\r␊７",
	}, { // 1124
		mask: EncodeZero | EncodeLeftCrLfHtVt,
		in:   "Ｓ\x0eπＺiε＂\n`？\nπk＞ψ␍＃\n/υ＿／␋\x16\uff00Go\r\n␊",
		out:  "Ｓ\x0eπＺiε＂\n`？\nπk＞ψ␍＃\n/υ＿／␋\x16\uff00Go\r\n␊",
	}, { // 1125
		mask: EncodeZero | EncodeLeftCrLfHtVt,
		in:   "Ｓ\x0eπＺiε＂\n`？\nπk＞ψ␍＃\n/υ＿／␋\x16\uff00Go\r␊␊",
		out:  "Ｓ\x0eπＺiε＂\n`？\nπk＞ψ␍＃\n/υ＿／␋\x16\uff00Go\r␊␊",
	}, { // 1126
		mask: EncodeZero | EncodeLeftCrLfHtVt,
		in:   "Ｓ\x0eπＺiε＂\n`？\nπk＞ψ␍＃\n/υ＿／␋\x16\uff00Go\r}\n",
		out:  "Ｓ\x0eπＺiε＂\n`？\nπk＞ψ␍＃\n/υ＿／␋\x16\uff00Go\r}\n",
	}, { // 1127
		mask: EncodeZero | EncodeLeftCrLfHtVt,
		in:   "Ｓ\x0eπＺiε＂\n`？\nπk＞ψ␍＃\n/υ＿／␋\x16\uff00Go\r}␊",
		out:  "Ｓ\x0eπＺiε＂\n`？\nπk＞ψ␍＃\n/υ＿／␋\x16\uff00Go\r}␊",
	}, { // 1128
		mask: EncodeZero | EncodeLeftCrLfHtVt,
		in:   "ς␈}␜␎m\x1dＯ␞Ｖ\vＩW\x13τ<σψ?%y＼\x1a，Ａνυ}ｅ␅",
		out:  "ς␈}␜␎m\x1dＯ␞Ｖ\vＩW\x13τ<σψ?%y＼\x1a，Ａνυ}ｅ␅",
	}, { // 1129
		mask: EncodeZero | EncodeLeftCrLfHtVt,
		in:   "\v␋}␜␎m\x1dＯ␞Ｖ\vＩW\x13τ<σψ?%y＼\x1a，Ａνυ}ｅ␅",
		out:  "␋␋}␜␎m\x1dＯ␞Ｖ\vＩW\x13τ<σψ?%y＼\x1a，Ａνυ}ｅ␅",
	}, { // 1130
		mask: EncodeZero | EncodeLeftCrLfHtVt,
		in:   "␋␋}␜␎m\x1dＯ␞Ｖ\vＩW\x13τ<σψ?%y＼\x1a，Ａνυ}ｅ␅",
		out:  "‛␋␋}␜␎m\x1dＯ␞Ｖ\vＩW\x13τ<σψ?%y＼\x1a，Ａνυ}ｅ␅",
	}, { // 1131
		mask: EncodeZero | EncodeLeftCrLfHtVt,
		in:   "\v␈}␜␎m\x1dＯ␞Ｖ\vＩW\x13τ<σψ?%y＼\x1a，Ａνυ}␋␅",
		out:  "␋␈}␜␎m\x1dＯ␞Ｖ\vＩW\x13τ<σψ?%y＼\x1a，Ａνυ}␋␅",
	}, { // 1132
		mask: EncodeZero | EncodeLeftCrLfHtVt,
		in:   "␋␈}␜␎m\x1dＯ␞Ｖ\vＩW\x13τ<σψ?%y＼\x1a，Ａνυ}␋␅",
		out:  "‛␋␈}␜␎m\x1dＯ␞Ｖ\vＩW\x13τ<σψ?%y＼\x1a，Ａνυ}␋␅",
	}, { // 1133
		mask: EncodeZero | EncodeLeftCrLfHtVt,
		in:   "\v␈}␜␎m\x1dＯ␞Ｖ\vＩW\x13τ<σψ?%y＼\x1a，Ａνυ}ｅ␋",
		out:  "␋␈}␜␎m\x1dＯ␞Ｖ\vＩW\x13τ<σψ?%y＼\x1a，Ａνυ}ｅ␋",
	}, { // 1134
		mask: EncodeZero | EncodeLeftCrLfHtVt,
		in:   "␋␈}␜␎m\x1dＯ␞Ｖ\vＩW\x13τ<σψ?%y＼\x1a，Ａνυ}ｅ␋",
		out:  "‛␋␈}␜␎m\x1dＯ␞Ｖ\vＩW\x13τ<σψ?%y＼\x1a，Ａνυ}ｅ␋",
	}, { // 1135
		mask: EncodeZero | EncodeLeftCrLfHtVt,
		in:   "ς\v}␜␎m\x1dＯ␞Ｖ\vＩW\x13τ<σψ?%y＼\x1a，Ａνυ}ｅ␅",
		out:  "ς\v}␜␎m\x1dＯ␞Ｖ\vＩW\x13τ<σψ?%y＼\x1a，Ａνυ}ｅ␅",
	}, { // 1136
		mask: EncodeZero | EncodeLeftCrLfHtVt,
		in:   "ς␋}␜␎m\x1dＯ␞Ｖ\vＩW\x13τ<σψ?%y＼\x1a，Ａνυ}ｅ␅",
		out:  "ς␋}␜␎m\x1dＯ␞Ｖ\vＩW\x13τ<σψ?%y＼\x1a，Ａνυ}ｅ␅",
	}, { // 1137
		mask: EncodeZero | EncodeLeftCrLfHtVt,
		in:   "ς\v}␜␎m\x1dＯ␞Ｖ\vＩW\x13τ<σψ?%y＼\x1a，Ａνυ}␋␅",
		out:  "ς\v}␜␎m\x1dＯ␞Ｖ\vＩW\x13τ<σψ?%y＼\x1a，Ａνυ}␋␅",
	}, { // 1138
		mask: EncodeZero | EncodeLeftCrLfHtVt,
		in:   "ς␋}␜␎m\x1dＯ␞Ｖ\vＩW\x13τ<σψ?%y＼\x1a，Ａνυ}␋␅",
		out:  "ς␋}␜␎m\x1dＯ␞Ｖ\vＩW\x13τ<σψ?%y＼\x1a，Ａνυ}␋␅",
	}, { // 1139
		mask: EncodeZero | EncodeLeftCrLfHtVt,
		in:   "ς\v}␜␎m\x1dＯ␞Ｖ\vＩW\x13τ<σψ?%y＼\x1a，Ａνυ}ｅ␋",
		out:  "ς\v}␜␎m\x1dＯ␞Ｖ\vＩW\x13τ<σψ?%y＼\x1a，Ａνυ}ｅ␋",
	}, { // 1140
		mask: EncodeZero | EncodeLeftCrLfHtVt,
		in:   "ς␋}␜␎m\x1dＯ␞Ｖ\vＩW\x13τ<σψ?%y＼\x1a，Ａνυ}ｅ␋",
		out:  "ς␋}␜␎m\x1dＯ␞Ｖ\vＩW\x13τ<σψ?%y＼\x1a，Ａνυ}ｅ␋",
	}, { // 1141
		mask: EncodeZero | EncodeLeftCrLfHtVt,
		in:   "ς␈}␜␎m\x1dＯ␞Ｖ\vＩW\x13τ<σψ?%y＼\x1a，Ａνυ}\v␅",
		out:  "ς␈}␜␎m\x1dＯ␞Ｖ\vＩW\x13τ<σψ?%y＼\x1a，Ａνυ}\v␅",
	}, { // 1142
		mask: EncodeZero | EncodeLeftCrLfHtVt,
		in:   "ς␈}␜␎m\x1dＯ␞Ｖ\vＩW\x13τ<σψ?%y＼\x1a，Ａνυ}␋␅",
		out:  "ς␈}␜␎m\x1dＯ␞Ｖ\vＩW\x13τ<σψ?%y＼\x1a，Ａνυ}␋␅",
	}, { // 1143
		mask: EncodeZero | EncodeLeftCrLfHtVt,
		in:   "ς␈}␜␎m\x1dＯ␞Ｖ\vＩW\x13τ<σψ?%y＼\x1a，Ａνυ}\v␋",
		out:  "ς␈}␜␎m\x1dＯ␞Ｖ\vＩW\x13τ<σψ?%y＼\x1a，Ａνυ}\v␋",
	}, { // 1144
		mask: EncodeZero | EncodeLeftCrLfHtVt,
		in:   "ς␈}␜␎m\x1dＯ␞Ｖ\vＩW\x13τ<σψ?%y＼\x1a，Ａνυ}␋␋",
		out:  "ς␈}␜␎m\x1dＯ␞Ｖ\vＩW\x13τ<σψ?%y＼\x1a，Ａνυ}␋␋",
	}, { // 1145
		mask: EncodeZero | EncodeLeftCrLfHtVt,
		in:   "ς␈}␜␎m\x1dＯ␞Ｖ\vＩW\x13τ<σψ?%y＼\x1a，Ａνυ}ｅ\v",
		out:  "ς␈}␜␎m\x1dＯ␞Ｖ\vＩW\x13τ<σψ?%y＼\x1a，Ａνυ}ｅ\v",
	}, { // 1146
		mask: EncodeZero | EncodeLeftCrLfHtVt,
		in:   "ς␈}␜␎m\x1dＯ␞Ｖ\vＩW\x13τ<σψ?%y＼\x1a，Ａνυ}ｅ␋",
		out:  "ς␈}␜␎m\x1dＯ␞Ｖ\vＩW\x13τ<σψ?%y＼\x1a，Ａνυ}ｅ␋",
	}, { // 1147
		mask: EncodeZero | EncodeLeftCrLfHtVt,
		in:   "␑+␘ρ＃＊：\u007f␆\x06\r@ωdν:␒αOＣX\x04\uff00Ｇ\n（ψ\x18ν4",
		out:  "␑+␘ρ＃＊：\u007f␆\x06\r@ωdν:␒αOＣX\x04\uff00Ｇ\n（ψ\x18ν4",
	}, { // 1148
		mask: EncodeZero | EncodeLeftCrLfHtVt,
		in:   "\r␍␘ρ＃＊：\u007f␆\x06\r@ωdν:␒αOＣX\x04\uff00Ｇ\n（ψ\x18ν4",
		out:  "␍␍␘ρ＃＊：\u007f␆\x06\r@ωdν:␒αOＣX\x04\uff00Ｇ\n（ψ\x18ν4",
	}, { // 1149
		mask: EncodeZero | EncodeLeftCrLfHtVt,
		in:   "␍␍␘ρ＃＊：\u007f␆\x06\r@ωdν:␒αOＣX\x04\uff00Ｇ\n（ψ\x18ν4",
		out:  "‛␍␍␘ρ＃＊：\u007f␆\x06\r@ωdν:␒αOＣX\x04\uff00Ｇ\n（ψ\x18ν4",
	}, { // 1150
		mask: EncodeZero | EncodeLeftCrLfHtVt,
		in:   "\r+␘ρ＃＊：\u007f␆\x06\r@ωdν:␒αOＣX\x04\uff00Ｇ\n（ψ\x18␍4",
		out:  "␍+␘ρ＃＊：\u007f␆\x06\r@ωdν:␒αOＣX\x04\uff00Ｇ\n（ψ\x18␍4",
	}, { // 1151
		mask: EncodeZero | EncodeLeftCrLfHtVt,
		in:   "␍+␘ρ＃＊：\u007f␆\x06\r@ωdν:␒αOＣX\x04\uff00Ｇ\n（ψ\x18␍4",
		out:  "‛␍+␘ρ＃＊：\u007f␆\x06\r@ωdν:␒αOＣX\x04\uff00Ｇ\n（ψ\x18␍4",
	}, { // 1152
		mask: EncodeZero | EncodeLeftCrLfHtVt,
		in:   "\r+␘ρ＃＊：\u007f␆\x06\r@ωdν:␒αOＣX\x04\uff00Ｇ\n（ψ\x18ν␍",
		out:  "␍+␘ρ＃＊：\u007f␆\x06\r@ωdν:␒αOＣX\x04\uff00Ｇ\n（ψ\x18ν␍",
	}, { // 1153
		mask: EncodeZero | EncodeLeftCrLfHtVt,
		in:   "␍+␘ρ＃＊：\u007f␆\x06\r@ωdν:␒αOＣX\x04\uff00Ｇ\n（ψ\x18ν␍",
		out:  "‛␍+␘ρ＃＊：\u007f␆\x06\r@ωdν:␒αOＣX\x04\uff00Ｇ\n（ψ\x18ν␍",
	}, { // 1154
		mask: EncodeZero | EncodeLeftCrLfHtVt,
		in:   "␑\r␘ρ＃＊：\u007f␆\x06\r@ωdν:␒αOＣX\x04\uff00Ｇ\n（ψ\x18ν4",
		out:  "␑\r␘ρ＃＊：\u007f␆\x06\r@ωdν:␒αOＣX\x04\uff00Ｇ\n（ψ\x18ν4",
	}, { // 1155
		mask: EncodeZero | EncodeLeftCrLfHtVt,
		in:   "␑␍␘ρ＃＊：\u007f␆\x06\r@ωdν:␒αOＣX\x04\uff00Ｇ\n（ψ\x18ν4",
		out:  "␑␍␘ρ＃＊：\u007f␆\x06\r@ωdν:␒αOＣX\x04\uff00Ｇ\n（ψ\x18ν4",
	}, { // 1156
		mask: EncodeZero | EncodeLeftCrLfHtVt,
		in:   "␑\r␘ρ＃＊：\u007f␆\x06\r@ωdν:␒αOＣX\x04\uff00Ｇ\n（ψ\x18␍4",
		out:  "␑\r␘ρ＃＊：\u007f␆\x06\r@ωdν:␒αOＣX\x04\uff00Ｇ\n（ψ\x18␍4",
	}, { // 1157
		mask: EncodeZero | EncodeLeftCrLfHtVt,
		in:   "␑␍␘ρ＃＊：\u007f␆\x06\r@ωdν:␒αOＣX\x04\uff00Ｇ\n（ψ\x18␍4",
		out:  "␑␍␘ρ＃＊：\u007f␆\x06\r@ωdν:␒αOＣX\x04\uff00Ｇ\n（ψ\x18␍4",
	}, { // 1158
		mask: EncodeZero | EncodeLeftCrLfHtVt,
		in:   "␑\r␘ρ＃＊：\u007f␆\x06\r@ωdν:␒αOＣX\x04\uff00Ｇ\n（ψ\x18ν␍",
		out:  "␑\r␘ρ＃＊：\u007f␆\x06\r@ωdν:␒αOＣX\x04\uff00Ｇ\n（ψ\x18ν␍",
	}, { // 1159
		mask: EncodeZero | EncodeLeftCrLfHtVt,
		in:   "␑␍␘ρ＃＊：\u007f␆\x06\r@ωdν:␒αOＣX\x04\uff00Ｇ\n（ψ\x18ν␍",
		out:  "␑␍␘ρ＃＊：\u007f␆\x06\r@ωdν:␒αOＣX\x04\uff00Ｇ\n（ψ\x18ν␍",
	}, { // 1160
		mask: EncodeZero | EncodeLeftCrLfHtVt,
		in:   "␑+␘ρ＃＊：\u007f␆\x06\r@ωdν:␒αOＣX\x04\uff00Ｇ\n（ψ\x18\r4",
		out:  "␑+␘ρ＃＊：\u007f␆\x06\r@ωdν:␒αOＣX\x04\uff00Ｇ\n（ψ\x18\r4",
	}, { // 1161
		mask: EncodeZero | EncodeLeftCrLfHtVt,
		in:   "␑+␘ρ＃＊：\u007f␆\x06\r@ωdν:␒αOＣX\x04\uff00Ｇ\n（ψ\x18␍4",
		out:  "␑+␘ρ＃＊：\u007f␆\x06\r@ωdν:␒αOＣX\x04\uff00Ｇ\n（ψ\x18␍4",
	}, { // 1162
		mask: EncodeZero | EncodeLeftCrLfHtVt,
		in:   "␑+␘ρ＃＊：\u007f␆\x06\r@ωdν:␒αOＣX\x04\uff00Ｇ\n（ψ\x18\r␍",
		out:  "␑+␘ρ＃＊：\u007f␆\x06\r@ωdν:␒αOＣX\x04\uff00Ｇ\n（ψ\x18\r␍",
	}, { // 1163
		mask: EncodeZero | EncodeLeftCrLfHtVt,
		in:   "␑+␘ρ＃＊：\u007f␆\x06\r@ωdν:␒αOＣX\x04\uff00Ｇ\n（ψ\x18␍␍",
		out:  "␑+␘ρ＃＊：\u007f␆\x06\r@ωdν:␒αOＣX\x04\uff00Ｇ\n（ψ\x18␍␍",
	}, { // 1164
		mask: EncodeZero | EncodeLeftCrLfHtVt,
		in:   "␑+␘ρ＃＊：\u007f␆\x06\r@ωdν:␒αOＣX\x04\uff00Ｇ\n（ψ\x18ν\r",
		out:  "␑+␘ρ＃＊：\u007f␆\x06\r@ωdν:␒αOＣX\x04\uff00Ｇ\n（ψ\x18ν\r",
	}, { // 1165
		mask: EncodeZero | EncodeLeftCrLfHtVt,
		in:   "␑+␘ρ＃＊：\u007f␆\x06\r@ωdν:␒αOＣX\x04\uff00Ｇ\n（ψ\x18ν␍",
		out:  "␑+␘ρ＃＊：\u007f␆\x06\r@ωdν:␒αOＣX\x04\uff00Ｇ\n（ψ\x18ν␍",
	}, { // 1166
		mask: EncodeSlash | EncodeLeftCrLfHtVt,
		in:   "\x12ｈζZ\x06θhＷ０λ\tψ␄␚\x14β\rψ␅␗.\nqＳ＿]｜t␜Ｄ",
		out:  "\x12ｈζZ\x06θhＷ０λ\tψ␄␚\x14β\rψ␅␗.\nqＳ＿]｜t␜Ｄ",
	}, { // 1167
		mask: EncodeSlash | EncodeLeftCrLfHtVt,
		in:   "\t␉ζZ\x06θhＷ０λ\tψ␄␚\x14β\rψ␅␗.\nqＳ＿]｜t␜Ｄ",
		out:  "␉␉ζZ\x06θhＷ０λ\tψ␄␚\x14β\rψ␅␗.\nqＳ＿]｜t␜Ｄ",
	}, { // 1168
		mask: EncodeSlash | EncodeLeftCrLfHtVt,
		in:   "␉␉ζZ\x06θhＷ０λ\tψ␄␚\x14β\rψ␅␗.\nqＳ＿]｜t␜Ｄ",
		out:  "‛␉␉ζZ\x06θhＷ０λ\tψ␄␚\x14β\rψ␅␗.\nqＳ＿]｜t␜Ｄ",
	}, { // 1169
		mask: EncodeSlash | EncodeLeftCrLfHtVt,
		in:   "\tｈζZ\x06θhＷ０λ\tψ␄␚\x14β\rψ␅␗.\nqＳ＿]｜t␉Ｄ",
		out:  "␉ｈζZ\x06θhＷ０λ\tψ␄␚\x14β\rψ␅␗.\nqＳ＿]｜t␉Ｄ",
	}, { // 1170
		mask: EncodeSlash | EncodeLeftCrLfHtVt,
		in:   "␉ｈζZ\x06θhＷ０λ\tψ␄␚\x14β\rψ␅␗.\nqＳ＿]｜t␉Ｄ",
		out:  "‛␉ｈζZ\x06θhＷ０λ\tψ␄␚\x14β\rψ␅␗.\nqＳ＿]｜t␉Ｄ",
	}, { // 1171
		mask: EncodeSlash | EncodeLeftCrLfHtVt,
		in:   "\tｈζZ\x06θhＷ０λ\tψ␄␚\x14β\rψ␅␗.\nqＳ＿]｜t␜␉",
		out:  "␉ｈζZ\x06θhＷ０λ\tψ␄␚\x14β\rψ␅␗.\nqＳ＿]｜t␜␉",
	}, { // 1172
		mask: EncodeSlash | EncodeLeftCrLfHtVt,
		in:   "␉ｈζZ\x06θhＷ０λ\tψ␄␚\x14β\rψ␅␗.\nqＳ＿]｜t␜␉",
		out:  "‛␉ｈζZ\x06θhＷ０λ\tψ␄␚\x14β\rψ␅␗.\nqＳ＿]｜t␜␉",
	}, { // 1173
		mask: EncodeSlash | EncodeLeftCrLfHtVt,
		in:   "\x12\tζZ\x06θhＷ０λ\tψ␄␚\x14β\rψ␅␗.\nqＳ＿]｜t␜Ｄ",
		out:  "\x12\tζZ\x06θhＷ０λ\tψ␄␚\x14β\rψ␅␗.\nqＳ＿]｜t␜Ｄ",
	}, { // 1174
		mask: EncodeSlash | EncodeLeftCrLfHtVt,
		in:   "\x12␉ζZ\x06θhＷ０λ\tψ␄␚\x14β\rψ␅␗.\nqＳ＿]｜t␜Ｄ",
		out:  "\x12␉ζZ\x06θhＷ０λ\tψ␄␚\x14β\rψ␅␗.\nqＳ＿]｜t␜Ｄ",
	}, { // 1175
		mask: EncodeSlash | EncodeLeftCrLfHtVt,
		in:   "\x12\tζZ\x06θhＷ０λ\tψ␄␚\x14β\rψ␅␗.\nqＳ＿]｜t␉Ｄ",
		out:  "\x12\tζZ\x06θhＷ０λ\tψ␄␚\x14β\rψ␅␗.\nqＳ＿]｜t␉Ｄ",
	}, { // 1176
		mask: EncodeSlash | EncodeLeftCrLfHtVt,
		in:   "\x12␉ζZ\x06θhＷ０λ\tψ␄␚\x14β\rψ␅␗.\nqＳ＿]｜t␉Ｄ",
		out:  "\x12␉ζZ\x06θhＷ０λ\tψ␄␚\x14β\rψ␅␗.\nqＳ＿]｜t␉Ｄ",
	}, { // 1177
		mask: EncodeSlash | EncodeLeftCrLfHtVt,
		in:   "\x12\tζZ\x06θhＷ０λ\tψ␄␚\x14β\rψ␅␗.\nqＳ＿]｜t␜␉",
		out:  "\x12\tζZ\x06θhＷ０λ\tψ␄␚\x14β\rψ␅␗.\nqＳ＿]｜t␜␉",
	}, { // 1178
		mask: EncodeSlash | EncodeLeftCrLfHtVt,
		in:   "\x12␉ζZ\x06θhＷ０λ\tψ␄␚\x14β\rψ␅␗.\nqＳ＿]｜t␜␉",
		out:  "\x12␉ζZ\x06θhＷ０λ\tψ␄␚\x14β\rψ␅␗.\nqＳ＿]｜t␜␉",
	}, { // 1179
		mask: EncodeSlash | EncodeLeftCrLfHtVt,
		in:   "\x12ｈζZ\x06θhＷ０λ\tψ␄␚\x14β\rψ␅␗.\nqＳ＿]｜t\tＤ",
		out:  "\x12ｈζZ\x06θhＷ０λ\tψ␄␚\x14β\rψ␅␗.\nqＳ＿]｜t\tＤ",
	}, { // 1180
		mask: EncodeSlash | EncodeLeftCrLfHtVt,
		in:   "\x12ｈζZ\x06θhＷ０λ\tψ␄␚\x14β\rψ␅␗.\nqＳ＿]｜t␉Ｄ",
		out:  "\x12ｈζZ\x06θhＷ０λ\tψ␄␚\x14β\rψ␅␗.\nqＳ＿]｜t␉Ｄ",
	}, { // 1181
		mask: EncodeSlash | EncodeLeftCrLfHtVt,
		in:   "\x12ｈζZ\x06θhＷ０λ\tψ␄␚\x14β\rψ␅␗.\nqＳ＿]｜t\t␉",
		out:  "\x12ｈζZ\x06θhＷ０λ\tψ␄␚\x14β\rψ␅␗.\nqＳ＿]｜t\t␉",
	}, { // 1182
		mask: EncodeSlash | EncodeLeftCrLfHtVt,
		in:   "\x12ｈζZ\x06θhＷ０λ\tψ␄␚\x14β\rψ␅␗.\nqＳ＿]｜t␉␉",
		out:  "\x12ｈζZ\x06θhＷ０λ\tψ␄␚\x14β\rψ␅␗.\nqＳ＿]｜t␉␉",
	}, { // 1183
		mask: EncodeSlash | EncodeLeftCrLfHtVt,
		in:   "\x12ｈζZ\x06θhＷ０λ\tψ␄␚\x14β\rψ␅␗.\nqＳ＿]｜t␜\t",
		out:  "\x12ｈζZ\x06θhＷ０λ\tψ␄␚\x14β\rψ␅␗.\nqＳ＿]｜t␜\t",
	}, { // 1184
		mask: EncodeSlash | EncodeLeftCrLfHtVt,
		in:   "\x12ｈζZ\x06θhＷ０λ\tψ␄␚\x14β\rψ␅␗.\nqＳ＿]｜t␜␉",
		out:  "\x12ｈζZ\x06θhＷ０λ\tψ␄␚\x14β\rψ␅␗.\nqＳ＿]｜t␜␉",
	}, { // 1185
		mask: EncodeSlash | EncodeLeftCrLfHtVt,
		in:   "L\r:$ο␕５Ｚσ␑\n_υ\n１␕Ｖδ｜\x00βj|␑]\x16{ｗｋη",
		out:  "L\r:$ο␕５Ｚσ␑\n_υ\n１␕Ｖδ｜␀βj|␑]\x16{ｗｋη",
	}, { // 1186
		mask: EncodeSlash | EncodeLeftCrLfHtVt,
		in:   "\n␊:$ο␕５Ｚσ␑\n_υ\n１␕Ｖδ｜\x00βj|␑]\x16{ｗｋη",
		out:  "␊␊:$ο␕５Ｚσ␑\n_υ\n１␕Ｖδ｜␀βj|␑]\x16{ｗｋη",
	}, { // 1187
		mask: EncodeSlash | EncodeLeftCrLfHtVt,
		in:   "␊␊:$ο␕５Ｚσ␑\n_υ\n１␕Ｖδ｜\x00βj|␑]\x16{ｗｋη",
		out:  "‛␊␊:$ο␕５Ｚσ␑\n_υ\n１␕Ｖδ｜␀βj|␑]\x16{ｗｋη",
	}, { // 1188
		mask: EncodeSlash | EncodeLeftCrLfHtVt,
		in:   "\n\r:$ο␕５Ｚσ␑\n_υ\n１␕Ｖδ｜\x00βj|␑]\x16{ｗ␊η",
		out:  "␊\r:$ο␕５Ｚσ␑\n_υ\n１␕Ｖδ｜␀βj|␑]\x16{ｗ␊η",
	}, { // 1189
		mask: EncodeSlash | EncodeLeftCrLfHtVt,
		in:   "␊\r:$ο␕５Ｚσ␑\n_υ\n１␕Ｖδ｜\x00βj|␑]\x16{ｗ␊η",
		out:  "‛␊\r:$ο␕５Ｚσ␑\n_υ\n１␕Ｖδ｜␀βj|␑]\x16{ｗ␊η",
	}, { // 1190
		mask: EncodeSlash | EncodeLeftCrLfHtVt,
		in:   "\n\r:$ο␕５Ｚσ␑\n_υ\n１␕Ｖδ｜\x00βj|␑]\x16{ｗｋ␊",
		out:  "␊\r:$ο␕５Ｚσ␑\n_υ\n１␕Ｖδ｜␀βj|␑]\x16{ｗｋ␊",
	}, { // 1191
		mask: EncodeSlash | EncodeLeftCrLfHtVt,
		in:   "␊\r:$ο␕５Ｚσ␑\n_υ\n１␕Ｖδ｜\x00βj|␑]\x16{ｗｋ␊",
		out:  "‛␊\r:$ο␕５Ｚσ␑\n_υ\n１␕Ｖδ｜␀βj|␑]\x16{ｗｋ␊",
	}, { // 1192
		mask: EncodeSlash | EncodeLeftCrLfHtVt,
		in:   "L\n:$ο␕５Ｚσ␑\n_υ\n１␕Ｖδ｜\x00βj|␑]\x16{ｗｋη",
		out:  "L\n:$ο␕５Ｚσ␑\n_υ\n１␕Ｖδ｜␀βj|␑]\x16{ｗｋη",
	}, { // 1193
		mask: EncodeSlash | EncodeLeftCrLfHtVt,
		in:   "L␊:$ο␕５Ｚσ␑\n_υ\n１␕Ｖδ｜\x00βj|␑]\x16{ｗｋη",
		out:  "L␊:$ο␕５Ｚσ␑\n_υ\n１␕Ｖδ｜␀βj|␑]\x16{ｗｋη",
	}, { // 1194
		mask: EncodeSlash | EncodeLeftCrLfHtVt,
		in:   "L\n:$ο␕５Ｚσ␑\n_υ\n１␕Ｖδ｜\x00βj|␑]\x16{ｗ␊η",
		out:  "L\n:$ο␕５Ｚσ␑\n_υ\n１␕Ｖδ｜␀βj|␑]\x16{ｗ␊η",
	}, { // 1195
		mask: EncodeSlash | EncodeLeftCrLfHtVt,
		in:   "L␊:$ο␕５Ｚσ␑\n_υ\n１␕Ｖδ｜\x00βj|␑]\x16{ｗ␊η",
		out:  "L␊:$ο␕５Ｚσ␑\n_υ\n１␕Ｖδ｜␀βj|␑]\x16{ｗ␊η",
	}, { // 1196
		mask: EncodeSlash | EncodeLeftCrLfHtVt,
		in:   "L\n:$ο␕５Ｚσ␑\n_υ\n１␕Ｖδ｜\x00βj|␑]\x16{ｗｋ␊",
		out:  "L\n:$ο␕５Ｚσ␑\n_υ\n１␕Ｖδ｜␀βj|␑]\x16{ｗｋ␊",
	}, { // 1197
		mask: EncodeSlash | EncodeLeftCrLfHtVt,
		in:   "L␊:$ο␕５Ｚσ␑\n_υ\n１␕Ｖδ｜\x00βj|␑]\x16{ｗｋ␊",
		out:  "L␊:$ο␕５Ｚσ␑\n_υ\n１␕Ｖδ｜␀βj|␑]\x16{ｗｋ␊",
	}, { // 1198
		mask: EncodeSlash | EncodeLeftCrLfHtVt,
		in:   "L\r:$ο␕５Ｚσ␑\n_υ\n１␕Ｖδ｜\x00βj|␑]\x16{ｗ\nη",
		out:  "L\r:$ο␕５Ｚσ␑\n_υ\n１␕Ｖδ｜␀βj|␑]\x16{ｗ\nη",
	}, { // 1199
		mask: EncodeSlash | EncodeLeftCrLfHtVt,
		in:   "L\r:$ο␕５Ｚσ␑\n_υ\n１␕Ｖδ｜\x00βj|␑]\x16{ｗ␊η",
		out:  "L\r:$ο␕５Ｚσ␑\n_υ\n１␕Ｖδ｜␀βj|␑]\x16{ｗ␊η",
	}, { // 1200
		mask: EncodeSlash | EncodeLeftCrLfHtVt,
		in:   "L\r:$ο␕５Ｚσ␑\n_υ\n１␕Ｖδ｜\x00βj|␑]\x16{ｗ\n␊",
		out:  "L\r:$ο␕５Ｚσ␑\n_υ\n１␕Ｖδ｜␀βj|␑]\x16{ｗ\n␊",
	}, { // 1201
		mask: EncodeSlash | EncodeLeftCrLfHtVt,
		in:   "L\r:$ο␕５Ｚσ␑\n_υ\n１␕Ｖδ｜\x00βj|␑]\x16{ｗ␊␊",
		out:  "L\r:$ο␕５Ｚσ␑\n_υ\n１␕Ｖδ｜␀βj|␑]\x16{ｗ␊␊",
	}, { // 1202
		mask: EncodeSlash | EncodeLeftCrLfHtVt,
		in:   "L\r:$ο␕５Ｚσ␑\n_υ\n１␕Ｖδ｜\x00βj|␑]\x16{ｗｋ\n",
		out:  "L\r:$ο␕５Ｚσ␑\n_υ\n１␕Ｖδ｜␀βj|␑]\x16{ｗｋ\n",
	}, { // 1203
		mask: EncodeSlash | EncodeLeftCrLfHtVt,
		in:   "L\r:$ο␕５Ｚσ␑\n_υ\n１␕Ｖδ｜\x00βj|␑]\x16{ｗｋ␊",
		out:  "L\r:$ο␕５Ｚσ␑\n_υ\n１␕Ｖδ｜␀βj|␑]\x16{ｗｋ␊",
	}, { // 1204
		mask: EncodeSlash | EncodeLeftCrLfHtVt,
		in:   "3ε␂Vψ\x1fＴ＾μ␈\v；7？␋Cｎ␊ν/3\x1d５\x14\\:β｜\x13τ",
		out:  "3ε␂Vψ\x1fＴ＾μ␈\v；7？␋Cｎ␊ν／3\x1d５\x14\\:β｜\x13τ",
	}, { // 1205
		mask: EncodeSlash | EncodeLeftCrLfHtVt,
		in:   "\v␋␂Vψ\x1fＴ＾μ␈\v；7？␋Cｎ␊ν/3\x1d５\x14\\:β｜\x13τ",
		out:  "␋␋␂Vψ\x1fＴ＾μ␈\v；7？␋Cｎ␊ν／3\x1d５\x14\\:β｜\x13τ",
	}, { // 1206
		mask: EncodeSlash | EncodeLeftCrLfHtVt,
		in:   "␋␋␂Vψ\x1fＴ＾μ␈\v；7？␋Cｎ␊ν/3\x1d５\x14\\:β｜\x13τ",
		out:  "‛␋␋␂Vψ\x1fＴ＾μ␈\v；7？␋Cｎ␊ν／3\x1d５\x14\\:β｜\x13τ",
	}, { // 1207
		mask: EncodeSlash | EncodeLeftCrLfHtVt,
		in:   "\vε␂Vψ\x1fＴ＾μ␈\v；7？␋Cｎ␊ν/3\x1d５\x14\\:β｜␋τ",
		out:  "␋ε␂Vψ\x1fＴ＾μ␈\v；7？␋Cｎ␊ν／3\x1d５\x14\\:β｜␋τ",
	}, { // 1208
		mask: EncodeSlash | EncodeLeftCrLfHtVt,
		in:   "␋ε␂Vψ\x1fＴ＾μ␈\v；7？␋Cｎ␊ν/3\x1d５\x14\\:β｜␋τ",
		out:  "‛␋ε␂Vψ\x1fＴ＾μ␈\v；7？␋Cｎ␊ν／3\x1d５\x14\\:β｜␋τ",
	}, { // 1209
		mask: EncodeSlash | EncodeLeftCrLfHtVt,
		in:   "\vε␂Vψ\x1fＴ＾μ␈\v；7？␋Cｎ␊ν/3\x1d５\x14\\:β｜\x13␋",
		out:  "␋ε␂Vψ\x1fＴ＾μ␈\v；7？␋Cｎ␊ν／3\x1d５\x14\\:β｜\x13␋",
	}, { // 1210
		mask: EncodeSlash | EncodeLeftCrLfHtVt,
		in:   "␋ε␂Vψ\x1fＴ＾μ␈\v；7？␋Cｎ␊ν/3\x1d５\x14\\:β｜\x13␋",
		out:  "‛␋ε␂Vψ\x1fＴ＾μ␈\v；7？␋Cｎ␊ν／3\x1d５\x14\\:β｜\x13␋",
	}, { // 1211
		mask: EncodeSlash | EncodeLeftCrLfHtVt,
		in:   "3\v␂Vψ\x1fＴ＾μ␈\v；7？␋Cｎ␊ν/3\x1d５\x14\\:β｜\x13τ",
		out:  "3\v␂Vψ\x1fＴ＾μ␈\v；7？␋Cｎ␊ν／3\x1d５\x14\\:β｜\x13τ",
	}, { // 1212
		mask: EncodeSlash | EncodeLeftCrLfHtVt,
		in:   "3␋␂Vψ\x1fＴ＾μ␈\v；7？␋Cｎ␊ν/3\x1d５\x14\\:β｜\x13τ",
		out:  "3␋␂Vψ\x1fＴ＾μ␈\v；7？␋Cｎ␊ν／3\x1d５\x14\\:β｜\x13τ",
	}, { // 1213
		mask: EncodeSlash | EncodeLeftCrLfHtVt,
		in:   "3\v␂Vψ\x1fＴ＾μ␈\v；7？␋Cｎ␊ν/3\x1d５\x14\\:β｜␋τ",
		out:  "3\v␂Vψ\x1fＴ＾μ␈\v；7？␋Cｎ␊ν／3\x1d５\x14\\:β｜␋τ",
	}, { // 1214
		mask: EncodeSlash | EncodeLeftCrLfHtVt,
		in:   "3␋␂Vψ\x1fＴ＾μ␈\v；7？␋Cｎ␊ν/3\x1d５\x14\\:β｜␋τ",
		out:  "3␋␂Vψ\x1fＴ＾μ␈\v；7？␋Cｎ␊ν／3\x1d５\x14\\:β｜␋τ",
	}, { // 1215
		mask: EncodeSlash | EncodeLeftCrLfHtVt,
		in:   "3\v␂Vψ\x1fＴ＾μ␈\v；7？␋Cｎ␊ν/3\x1d５\x14\\:β｜\x13␋",
		out:  "3\v␂Vψ\x1fＴ＾μ␈\v；7？␋Cｎ␊ν／3\x1d５\x14\\:β｜\x13␋",
	}, { // 1216
		mask: EncodeSlash | EncodeLeftCrLfHtVt,
		in:   "3␋␂Vψ\x1fＴ＾μ␈\v；7？␋Cｎ␊ν/3\x1d５\x14\\:β｜\x13␋",
		out:  "3␋␂Vψ\x1fＴ＾μ␈\v；7？␋Cｎ␊ν／3\x1d５\x14\\:β｜\x13␋",
	}, { // 1217
		mask: EncodeSlash | EncodeLeftCrLfHtVt,
		in:   "3ε␂Vψ\x1fＴ＾μ␈\v；7？␋Cｎ␊ν/3\x1d５\x14\\:β｜\vτ",
		out:  "3ε␂Vψ\x1fＴ＾μ␈\v；7？␋Cｎ␊ν／3\x1d５\x14\\:β｜\vτ",
	}, { // 1218
		mask: EncodeSlash | EncodeLeftCrLfHtVt,
		in:   "3ε␂Vψ\x1fＴ＾μ␈\v；7？␋Cｎ␊ν/3\x1d５\x14\\:β｜␋τ",
		out:  "3ε␂Vψ\x1fＴ＾μ␈\v；7？␋Cｎ␊ν／3\x1d５\x14\\:β｜␋τ",
	}, { // 1219
		mask: EncodeSlash | EncodeLeftCrLfHtVt,
		in:   "3ε␂Vψ\x1fＴ＾μ␈\v；7？␋Cｎ␊ν/3\x1d５\x14\\:β｜\v␋",
		out:  "3ε␂Vψ\x1fＴ＾μ␈\v；7？␋Cｎ␊ν／3\x1d５\x14\\:β｜\v␋",
	}, { // 1220
		mask: EncodeSlash | EncodeLeftCrLfHtVt,
		in:   "3ε␂Vψ\x1fＴ＾μ␈\v；7？␋Cｎ␊ν/3\x1d５\x14\\:β｜␋␋",
		out:  "3ε␂Vψ\x1fＴ＾μ␈\v；7？␋Cｎ␊ν／3\x1d５\x14\\:β｜␋␋",
	}, { // 1221
		mask: EncodeSlash | EncodeLeftCrLfHtVt,
		in:   "3ε␂Vψ\x1fＴ＾μ␈\v；7？␋Cｎ␊ν/3\x1d５\x14\\:β｜\x13\v",
		out:  "3ε␂Vψ\x1fＴ＾μ␈\v；7？␋Cｎ␊ν／3\x1d５\x14\\:β｜\x13\v",
	}, { // 1222
		mask: EncodeSlash | EncodeLeftCrLfHtVt,
		in:   "3ε␂Vψ\x1fＴ＾μ␈\v；7？␋Cｎ␊ν/3\x1d５\x14\\:β｜\x13␋",
		out:  "3ε␂Vψ\x1fＴ＾μ␈\v；7？␋Cｎ␊ν／3\x1d５\x14\\:β｜\x13␋",
	}, { // 1223
		mask: EncodeSlash | EncodeLeftCrLfHtVt,
		in:   "␜χ<Ｏ\x1eε＜␔Ｐ|\rδ1bVλpF␍＿␗\x1f２ο\x19ρ：\rＷ＂",
		out:  "␜χ<Ｏ\x1eε＜␔Ｐ|\rδ1bVλpF␍＿␗\x1f２ο\x19ρ：\rＷ＂",
	}, { // 1224
		mask: EncodeSlash | EncodeLeftCrLfHtVt,
		in:   "\r␍<Ｏ\x1eε＜␔Ｐ|\rδ1bVλpF␍＿␗\x1f２ο\x19ρ：\rＷ＂",
		out:  "␍␍<Ｏ\x1eε＜␔Ｐ|\rδ1bVλpF␍＿␗\x1f２ο\x19ρ：\rＷ＂",
	}, { // 1225
		mask: EncodeSlash | EncodeLeftCrLfHtVt,
		in:   "␍␍<Ｏ\x1eε＜␔Ｐ|\rδ1bVλpF␍＿␗\x1f２ο\x19ρ：\rＷ＂",
		out:  "‛␍␍<Ｏ\x1eε＜␔Ｐ|\rδ1bVλpF␍＿␗\x1f２ο\x19ρ：\rＷ＂",
	}, { // 1226
		mask: EncodeSlash | EncodeLeftCrLfHtVt,
		in:   "\rχ<Ｏ\x1eε＜␔Ｐ|\rδ1bVλpF␍＿␗\x1f２ο\x19ρ：\r␍＂",
		out:  "␍χ<Ｏ\x1eε＜␔Ｐ|\rδ1bVλpF␍＿␗\x1f２ο\x19ρ：\r␍＂",
	}, { // 1227
		mask: EncodeSlash | EncodeLeftCrLfHtVt,
		in:   "␍χ<Ｏ\x1eε＜␔Ｐ|\rδ1bVλpF␍＿␗\x1f２ο\x19ρ：\r␍＂",
		out:  "‛␍χ<Ｏ\x1eε＜␔Ｐ|\rδ1bVλpF␍＿␗\x1f２ο\x19ρ：\r␍＂",
	}, { // 1228
		mask: EncodeSlash | EncodeLeftCrLfHtVt,
		in:   "\rχ<Ｏ\x1eε＜␔Ｐ|\rδ1bVλpF␍＿␗\x1f２ο\x19ρ：\rＷ␍",
		out:  "␍χ<Ｏ\x1eε＜␔Ｐ|\rδ1bVλpF␍＿␗\x1f２ο\x19ρ：\rＷ␍",
	}, { // 1229
		mask: EncodeSlash | EncodeLeftCrLfHtVt,
		in:   "␍χ<Ｏ\x1eε＜␔Ｐ|\rδ1bVλpF␍＿␗\x1f２ο\x19ρ：\rＷ␍",
		out:  "‛␍χ<Ｏ\x1eε＜␔Ｐ|\rδ1bVλpF␍＿␗\x1f２ο\x19ρ：\rＷ␍",
	}, { // 1230
		mask: EncodeSlash | EncodeLeftCrLfHtVt,
		in:   "␜\r<Ｏ\x1eε＜␔Ｐ|\rδ1bVλpF␍＿␗\x1f２ο\x19ρ：\rＷ＂",
		out:  "␜\r<Ｏ\x1eε＜␔Ｐ|\rδ1bVλpF␍＿␗\x1f２ο\x19ρ：\rＷ＂",
	}, { // 1231
		mask: EncodeSlash | EncodeLeftCrLfHtVt,
		in:   "␜␍<Ｏ\x1eε＜␔Ｐ|\rδ1bVλpF␍＿␗\x1f２ο\x19ρ：\rＷ＂",
		out:  "␜␍<Ｏ\x1eε＜␔Ｐ|\rδ1bVλpF␍＿␗\x1f２ο\x19ρ：\rＷ＂",
	}, { // 1232
		mask: EncodeSlash | EncodeLeftCrLfHtVt,
		in:   "␜\r<Ｏ\x1eε＜␔Ｐ|\rδ1bVλpF␍＿␗\x1f２ο\x19ρ：\r␍＂",
		out:  "␜\r<Ｏ\x1eε＜␔Ｐ|\rδ1bVλpF␍＿␗\x1f２ο\x19ρ：\r␍＂",
	}, { // 1233
		mask: EncodeSlash | EncodeLeftCrLfHtVt,
		in:   "␜␍<Ｏ\x1eε＜␔Ｐ|\rδ1bVλpF␍＿␗\x1f２ο\x19ρ：\r␍＂",
		out:  "␜␍<Ｏ\x1eε＜␔Ｐ|\rδ1bVλpF␍＿␗\x1f２ο\x19ρ：\r␍＂",
	}, { // 1234
		mask: EncodeSlash | EncodeLeftCrLfHtVt,
		in:   "␜\r<Ｏ\x1eε＜␔Ｐ|\rδ1bVλpF␍＿␗\x1f２ο\x19ρ：\rＷ␍",
		out:  "␜\r<Ｏ\x1eε＜␔Ｐ|\rδ1bVλpF␍＿␗\x1f２ο\x19ρ：\rＷ␍",
	}, { // 1235
		mask: EncodeSlash | EncodeLeftCrLfHtVt,
		in:   "␜␍<Ｏ\x1eε＜␔Ｐ|\rδ1bVλpF␍＿␗\x1f２ο\x19ρ：\rＷ␍",
		out:  "␜␍<Ｏ\x1eε＜␔Ｐ|\rδ1bVλpF␍＿␗\x1f２ο\x19ρ：\rＷ␍",
	}, { // 1236
		mask: EncodeSlash | EncodeLeftCrLfHtVt,
		in:   "␜χ<Ｏ\x1eε＜␔Ｐ|\rδ1bVλpF␍＿␗\x1f２ο\x19ρ：\r\r＂",
		out:  "␜χ<Ｏ\x1eε＜␔Ｐ|\rδ1bVλpF␍＿␗\x1f２ο\x19ρ：\r\r＂",
	}, { // 1237
		mask: EncodeSlash | EncodeLeftCrLfHtVt,
		in:   "␜χ<Ｏ\x1eε＜␔Ｐ|\rδ1bVλpF␍＿␗\x1f２ο\x19ρ：\r␍＂",
		out:  "␜χ<Ｏ\x1eε＜␔Ｐ|\rδ1bVλpF␍＿␗\x1f２ο\x19ρ：\r␍＂",
	}, { // 1238
		mask: EncodeSlash | EncodeLeftCrLfHtVt,
		in:   "␜χ<Ｏ\x1eε＜␔Ｐ|\rδ1bVλpF␍＿␗\x1f２ο\x19ρ：\r\r␍",
		out:  "␜χ<Ｏ\x1eε＜␔Ｐ|\rδ1bVλpF␍＿␗\x1f２ο\x19ρ：\r\r␍",
	}, { // 1239
		mask: EncodeSlash | EncodeLeftCrLfHtVt,
		in:   "␜χ<Ｏ\x1eε＜␔Ｐ|\rδ1bVλpF␍＿␗\x1f２ο\x19ρ：\r␍␍",
		out:  "␜χ<Ｏ\x1eε＜␔Ｐ|\rδ1bVλpF␍＿␗\x1f２ο\x19ρ：\r␍␍",
	}, { // 1240
		mask: EncodeSlash | EncodeLeftCrLfHtVt,
		in:   "␜χ<Ｏ\x1eε＜␔Ｐ|\rδ1bVλpF␍＿␗\x1f２ο\x19ρ：\rＷ\r",
		out:  "␜χ<Ｏ\x1eε＜␔Ｐ|\rδ1bVλpF␍＿␗\x1f２ο\x19ρ：\rＷ\r",
	}, { // 1241
		mask: EncodeSlash | EncodeLeftCrLfHtVt,
		in:   "␜χ<Ｏ\x1eε＜␔Ｐ|\rδ1bVλpF␍＿␗\x1f２ο\x19ρ：\rＷ␍",
		out:  "␜χ<Ｏ\x1eε＜␔Ｐ|\rδ1bVλpF␍＿␗\x1f２ο\x19ρ：\rＷ␍",
	}, { // 1242
		mask: EncodeSingleQuote | EncodeLeftCrLfHtVt,
		in:   "@＊␘χＴ/␊h\x12ｖ\tι\x1fα-ｂ␡＋\r|␊\x1c＞δNh␡x＄ο",
		out:  "@＊␘χＴ/␊h\x12ｖ\tι\x1fα-ｂ␡＋\r|␊\x1c＞δNh␡x＄ο",
	}, { // 1243
		mask: EncodeSingleQuote | EncodeLeftCrLfHtVt,
		in:   "\t␉␘χＴ/␊h\x12ｖ\tι\x1fα-ｂ␡＋\r|␊\x1c＞δNh␡x＄ο",
		out:  "␉␉␘χＴ/␊h\x12ｖ\tι\x1fα-ｂ␡＋\r|␊\x1c＞δNh␡x＄ο",
	}, { // 1244
		mask: EncodeSingleQuote | EncodeLeftCrLfHtVt,
		in:   "␉␉␘χＴ/␊h\x12ｖ\tι\x1fα-ｂ␡＋\r|␊\x1c＞δNh␡x＄ο",
		out:  "‛␉␉␘χＴ/␊h\x12ｖ\tι\x1fα-ｂ␡＋\r|␊\x1c＞δNh␡x＄ο",
	}, { // 1245
		mask: EncodeSingleQuote | EncodeLeftCrLfHtVt,
		in:   "\t＊␘χＴ/␊h\x12ｖ\tι\x1fα-ｂ␡＋\r|␊\x1c＞δNh␡x␉ο",
		out:  "␉＊␘χＴ/␊h\x12ｖ\tι\x1fα-ｂ␡＋\r|␊\x1c＞δNh␡x␉ο",
	}, { // 1246
		mask: EncodeSingleQuote | EncodeLeftCrLfHtVt,
		in:   "␉＊␘χＴ/␊h\x12ｖ\tι\x1fα-ｂ␡＋\r|␊\x1c＞δNh␡x␉ο",
		out:  "‛␉＊␘χＴ/␊h\x12ｖ\tι\x1fα-ｂ␡＋\r|␊\x1c＞δNh␡x␉ο",
	}, { // 1247
		mask: EncodeSingleQuote | EncodeLeftCrLfHtVt,
		in:   "\t＊␘χＴ/␊h\x12ｖ\tι\x1fα-ｂ␡＋\r|␊\x1c＞δNh␡x＄␉",
		out:  "␉＊␘χＴ/␊h\x12ｖ\tι\x1fα-ｂ␡＋\r|␊\x1c＞δNh␡x＄␉",
	}, { // 1248
		mask: EncodeSingleQuote | EncodeLeftCrLfHtVt,
		in:   "␉＊␘χＴ/␊h\x12ｖ\tι\x1fα-ｂ␡＋\r|␊\x1c＞δNh␡x＄␉",
		out:  "‛␉＊␘χＴ/␊h\x12ｖ\tι\x1fα-ｂ␡＋\r|␊\x1c＞δNh␡x＄␉",
	}, { // 1249
		mask: EncodeSingleQuote | EncodeLeftCrLfHtVt,
		in:   "@\t␘χＴ/␊h\x12ｖ\tι\x1fα-ｂ␡＋\r|␊\x1c＞δNh␡x＄ο",
		out:  "@\t␘χＴ/␊h\x12ｖ\tι\x1fα-ｂ␡＋\r|␊\x1c＞δNh␡x＄ο",
	}, { // 1250
		mask: EncodeSingleQuote | EncodeLeftCrLfHtVt,
		in:   "@␉␘χＴ/␊h\x12ｖ\tι\x1fα-ｂ␡＋\r|␊\x1c＞δNh␡x＄ο",
		out:  "@␉␘χＴ/␊h\x12ｖ\tι\x1fα-ｂ␡＋\r|␊\x1c＞δNh␡x＄ο",
	}, { // 1251
		mask: EncodeSingleQuote | EncodeLeftCrLfHtVt,
		in:   "@\t␘χＴ/␊h\x12ｖ\tι\x1fα-ｂ␡＋\r|␊\x1c＞δNh␡x␉ο",
		out:  "@\t␘χＴ/␊h\x12ｖ\tι\x1fα-ｂ␡＋\r|␊\x1c＞δNh␡x␉ο",
	}, { // 1252
		mask: EncodeSingleQuote | EncodeLeftCrLfHtVt,
		in:   "@␉␘χＴ/␊h\x12ｖ\tι\x1fα-ｂ␡＋\r|␊\x1c＞δNh␡x␉ο",
		out:  "@␉␘χＴ/␊h\x12ｖ\tι\x1fα-ｂ␡＋\r|␊\x1c＞δNh␡x␉ο",
	}, { // 1253
		mask: EncodeSingleQuote | EncodeLeftCrLfHtVt,
		in:   "@\t␘χＴ/␊h\x12ｖ\tι\x1fα-ｂ␡＋\r|␊\x1c＞δNh␡x＄␉",
		out:  "@\t␘χＴ/␊h\x12ｖ\tι\x1fα-ｂ␡＋\r|␊\x1c＞δNh␡x＄␉",
	}, { // 1254
		mask: EncodeSingleQuote | EncodeLeftCrLfHtVt,
		in:   "@␉␘χＴ/␊h\x12ｖ\tι\x1fα-ｂ␡＋\r|␊\x1c＞δNh␡x＄␉",
		out:  "@␉␘χＴ/␊h\x12ｖ\tι\x1fα-ｂ␡＋\r|␊\x1c＞δNh␡x＄␉",
	}, { // 1255
		mask: EncodeSingleQuote | EncodeLeftCrLfHtVt,
		in:   "@＊␘χＴ/␊h\x12ｖ\tι\x1fα-ｂ␡＋\r|␊\x1c＞δNh␡x\tο",
		out:  "@＊␘χＴ/␊h\x12ｖ\tι\x1fα-ｂ␡＋\r|␊\x1c＞δNh␡x\tο",
	}, { // 1256
		mask: EncodeSingleQuote | EncodeLeftCrLfHtVt,
		in:   "@＊␘χＴ/␊h\x12ｖ\tι\x1fα-ｂ␡＋\r|␊\x1c＞δNh␡x␉ο",
		out:  "@＊␘χＴ/␊h\x12ｖ\tι\x1fα-ｂ␡＋\r|␊\x1c＞δNh␡x␉ο",
	}, { // 1257
		mask: EncodeSingleQuote | EncodeLeftCrLfHtVt,
		in:   "@＊␘χＴ/␊h\x12ｖ\tι\x1fα-ｂ␡＋\r|␊\x1c＞δNh␡x\t␉",
		out:  "@＊␘χＴ/␊h\x12ｖ\tι\x1fα-ｂ␡＋\r|␊\x1c＞δNh␡x\t␉",
	}, { // 1258
		mask: EncodeSingleQuote | EncodeLeftCrLfHtVt,
		in:   "@＊␘χＴ/␊h\x12ｖ\tι\x1fα-ｂ␡＋\r|␊\x1c＞δNh␡x␉␉",
		out:  "@＊␘χＴ/␊h\x12ｖ\tι\x1fα-ｂ␡＋\r|␊\x1c＞δNh␡x␉␉",
	}, { // 1259
		mask: EncodeSingleQuote | EncodeLeftCrLfHtVt,
		in:   "@＊␘χＴ/␊h\x12ｖ\tι\x1fα-ｂ␡＋\r|␊\x1c＞δNh␡x＄\t",
		out:  "@＊␘χＴ/␊h\x12ｖ\tι\x1fα-ｂ␡＋\r|␊\x1c＞δNh␡x＄\t",
	}, { // 1260
		mask: EncodeSingleQuote | EncodeLeftCrLfHtVt,
		in:   "@＊␘χＴ/␊h\x12ｖ\tι\x1fα-ｂ␡＋\r|␊\x1c＞δNh␡x＄␉",
		out:  "@＊␘χＴ/␊h\x12ｖ\tι\x1fα-ｂ␡＋\r|␊\x1c＞δNh␡x＄␉",
	}, { // 1261
		mask: EncodeSingleQuote | EncodeLeftCrLfHtVt,
		in:   "^\x15\x12␊ς＊ＶζδU\nｖ｜\x1fπtν\x01By；＂\x1eδ<｜：ａ␆<",
		out:  "^\x15\x12␊ς＊ＶζδU\nｖ｜\x1fπtν\x01By；＂\x1eδ<｜：ａ␆<",
	}, { // 1262
		mask: EncodeSingleQuote | EncodeLeftCrLfHtVt,
		in:   "\n␊\x12␊ς＊ＶζδU\nｖ｜\x1fπtν\x01By；＂\x1eδ<｜：ａ␆<",
		out:  "␊␊\x12␊ς＊ＶζδU\nｖ｜\x1fπtν\x01By；＂\x1eδ<｜：ａ␆<",
	}, { // 1263
		mask: EncodeSingleQuote | EncodeLeftCrLfHtVt,
		in:   "␊␊\x12␊ς＊ＶζδU\nｖ｜\x1fπtν\x01By；＂\x1eδ<｜：ａ␆<",
		out:  "‛␊␊\x12␊ς＊ＶζδU\nｖ｜\x1fπtν\x01By；＂\x1eδ<｜：ａ␆<",
	}, { // 1264
		mask: EncodeSingleQuote | EncodeLeftCrLfHtVt,
		in:   "\n\x15\x12␊ς＊ＶζδU\nｖ｜\x1fπtν\x01By；＂\x1eδ<｜：ａ␊<",
		out:  "␊\x15\x12␊ς＊ＶζδU\nｖ｜\x1fπtν\x01By；＂\x1eδ<｜：ａ␊<",
	}, { // 1265
		mask: EncodeSingleQuote | EncodeLeftCrLfHtVt,
		in:   "␊\x15\x12␊ς＊ＶζδU\nｖ｜\x1fπtν\x01By；＂\x1eδ<｜：ａ␊<",
		out:  "‛␊\x15\x12␊ς＊ＶζδU\nｖ｜\x1fπtν\x01By；＂\x1eδ<｜：ａ␊<",
	}, { // 1266
		mask: EncodeSingleQuote | EncodeLeftCrLfHtVt,
		in:   "\n\x15\x12␊ς＊ＶζδU\nｖ｜\x1fπtν\x01By；＂\x1eδ<｜：ａ␆␊",
		out:  "␊\x15\x12␊ς＊ＶζδU\nｖ｜\x1fπtν\x01By；＂\x1eδ<｜：ａ␆␊",
	}, { // 1267
		mask: EncodeSingleQuote | EncodeLeftCrLfHtVt,
		in:   "␊\x15\x12␊ς＊ＶζδU\nｖ｜\x1fπtν\x01By；＂\x1eδ<｜：ａ␆␊",
		out:  "‛␊\x15\x12␊ς＊ＶζδU\nｖ｜\x1fπtν\x01By；＂\x1eδ<｜：ａ␆␊",
	}, { // 1268
		mask: EncodeSingleQuote | EncodeLeftCrLfHtVt,
		in:   "^\n\x12␊ς＊ＶζδU\nｖ｜\x1fπtν\x01By；＂\x1eδ<｜：ａ␆<",
		out:  "^\n\x12␊ς＊ＶζδU\nｖ｜\x1fπtν\x01By；＂\x1eδ<｜：ａ␆<",
	}, { // 1269
		mask: EncodeSingleQuote | EncodeLeftCrLfHtVt,
		in:   "^␊\x12␊ς＊ＶζδU\nｖ｜\x1fπtν\x01By；＂\x1eδ<｜：ａ␆<",
		out:  "^␊\x12␊ς＊ＶζδU\nｖ｜\x1fπtν\x01By；＂\x1eδ<｜：ａ␆<",
	}, { // 1270
		mask: EncodeSingleQuote | EncodeLeftCrLfHtVt,
		in:   "^\n\x12␊ς＊ＶζδU\nｖ｜\x1fπtν\x01By；＂\x1eδ<｜：ａ␊<",
		out:  "^\n\x12␊ς＊ＶζδU\nｖ｜\x1fπtν\x01By；＂\x1eδ<｜：ａ␊<",
	}, { // 1271
		mask: EncodeSingleQuote | EncodeLeftCrLfHtVt,
		in:   "^␊\x12␊ς＊ＶζδU\nｖ｜\x1fπtν\x01By；＂\x1eδ<｜：ａ␊<",
		out:  "^␊\x12␊ς＊ＶζδU\nｖ｜\x1fπtν\x01By；＂\x1eδ<｜：ａ␊<",
	}, { // 1272
		mask: EncodeSingleQuote | EncodeLeftCrLfHtVt,
		in:   "^\n\x12␊ς＊ＶζδU\nｖ｜\x1fπtν\x01By；＂\x1eδ<｜：ａ␆␊",
		out:  "^\n\x12␊ς＊ＶζδU\nｖ｜\x1fπtν\x01By；＂\x1eδ<｜：ａ␆␊",
	}, { // 1273
		mask: EncodeSingleQuote | EncodeLeftCrLfHtVt,
		in:   "^␊\x12␊ς＊ＶζδU\nｖ｜\x1fπtν\x01By；＂\x1eδ<｜：ａ␆␊",
		out:  "^␊\x12␊ς＊ＶζδU\nｖ｜\x1fπtν\x01By；＂\x1eδ<｜：ａ␆␊",
	}, { // 1274
		mask: EncodeSingleQuote | EncodeLeftCrLfHtVt,
		in:   "^\x15\x12␊ς＊ＶζδU\nｖ｜\x1fπtν\x01By；＂\x1eδ<｜：ａ\n<",
		out:  "^\x15\x12␊ς＊ＶζδU\nｖ｜\x1fπtν\x01By；＂\x1eδ<｜：ａ\n<",
	}, { // 1275
		mask: EncodeSingleQuote | EncodeLeftCrLfHtVt,
		in:   "^\x15\x12␊ς＊ＶζδU\nｖ｜\x1fπtν\x01By；＂\x1eδ<｜：ａ␊<",
		out:  "^\x15\x12␊ς＊ＶζδU\nｖ｜\x1fπtν\x01By；＂\x1eδ<｜：ａ␊<",
	}, { // 1276
		mask: EncodeSingleQuote | EncodeLeftCrLfHtVt,
		in:   "^\x15\x12␊ς＊ＶζδU\nｖ｜\x1fπtν\x01By；＂\x1eδ<｜：ａ\n␊",
		out:  "^\x15\x12␊ς＊ＶζδU\nｖ｜\x1fπtν\x01By；＂\x1eδ<｜：ａ\n␊",
	}, { // 1277
		mask: EncodeSingleQuote | EncodeLeftCrLfHtVt,
		in:   "^\x15\x12␊ς＊ＶζδU\nｖ｜\x1fπtν\x01By；＂\x1eδ<｜：ａ␊␊",
		out:  "^\x15\x12␊ς＊ＶζδU\nｖ｜\x1fπtν\x01By；＂\x1eδ<｜：ａ␊␊",
	}, { // 1278
		mask: EncodeSingleQuote | EncodeLeftCrLfHtVt,
		in:   "^\x15\x12␊ς＊ＶζδU\nｖ｜\x1fπtν\x01By；＂\x1eδ<｜：ａ␆\n",
		out:  "^\x15\x12␊ς＊ＶζδU\nｖ｜\x1fπtν\x01By；＂\x1eδ<｜：ａ␆\n",
	}, { // 1279
		mask: EncodeSingleQuote | EncodeLeftCrLfHtVt,
		in:   "^\x15\x12␊ς＊ＶζδU\nｖ｜\x1fπtν\x01By；＂\x1eδ<｜：ａ␆␊",
		out:  "^\x15\x12␊ς＊ＶζδU\nｖ｜\x1fπtν\x01By；＂\x1eδ<｜：ａ␆␊",
	}, { // 1280
		mask: EncodeSingleQuote | EncodeLeftCrLfHtVt,
		in:   ":；>]υζ6␝:␙\vτ\x06 ψ[ｅ␏χｃ\x1c＠.ｈIｉD；π｜",
		out:  ":；>]υζ6␝:␙\vτ\x06 ψ[ｅ␏χｃ\x1c＠.ｈIｉD；π｜",
	}, { // 1281
		mask: EncodeSingleQuote | EncodeLeftCrLfHtVt,
		in:   "\v␋>]υζ6␝:␙\vτ\x06 ψ[ｅ␏χｃ\x1c＠.ｈIｉD；π｜",
		out:  "␋␋>]υζ6␝:␙\vτ\x06 ψ[ｅ␏χｃ\x1c＠.ｈIｉD；π｜",
	}, { // 1282
		mask: EncodeSingleQuote | EncodeLeftCrLfHtVt,
		in:   "␋␋>]υζ6␝:␙\vτ\x06 ψ[ｅ␏χｃ\x1c＠.ｈIｉD；π｜",
		out:  "‛␋␋>]υζ6␝:␙\vτ\x06 ψ[ｅ␏χｃ\x1c＠.ｈIｉD；π｜",
	}, { // 1283
		mask: EncodeSingleQuote | EncodeLeftCrLfHtVt,
		in:   "\v；>]υζ6␝:␙\vτ\x06 ψ[ｅ␏χｃ\x1c＠.ｈIｉD；␋｜",
		out:  "␋；>]υζ6␝:␙\vτ\x06 ψ[ｅ␏χｃ\x1c＠.ｈIｉD；␋｜",
	}, { // 1284
		mask: EncodeSingleQuote | EncodeLeftCrLfHtVt,
		in:   "␋；>]υζ6␝:␙\vτ\x06 ψ[ｅ␏χｃ\x1c＠.ｈIｉD；␋｜",
		out:  "‛␋；>]υζ6␝:␙\vτ\x06 ψ[ｅ␏χｃ\x1c＠.ｈIｉD；␋｜",
	}, { // 1285
		mask: EncodeSingleQuote | EncodeLeftCrLfHtVt,
		in:   "\v；>]υζ6␝:␙\vτ\x06 ψ[ｅ␏χｃ\x1c＠.ｈIｉD；π␋",
		out:  "␋；>]υζ6␝:␙\vτ\x06 ψ[ｅ␏χｃ\x1c＠.ｈIｉD；π␋",
	}, { // 1286
		mask: EncodeSingleQuote | EncodeLeftCrLfHtVt,
		in:   "␋；>]υζ6␝:␙\vτ\x06 ψ[ｅ␏χｃ\x1c＠.ｈIｉD；π␋",
		out:  "‛␋；>]υζ6␝:␙\vτ\x06 ψ[ｅ␏χｃ\x1c＠.ｈIｉD；π␋",
	}, { // 1287
		mask: EncodeSingleQuote | EncodeLeftCrLfHtVt,
		in:   ":\v>]υζ6␝:␙\vτ\x06 ψ[ｅ␏χｃ\x1c＠.ｈIｉD；π｜",
		out:  ":\v>]υζ6␝:␙\vτ\x06 ψ[ｅ␏χｃ\x1c＠.ｈIｉD；π｜",
	}, { // 1288
		mask: EncodeSingleQuote | EncodeLeftCrLfHtVt,
		in:   ":␋>]υζ6␝:␙\vτ\x06 ψ[ｅ␏χｃ\x1c＠.ｈIｉD；π｜",
		out:  ":␋>]υζ6␝:␙\vτ\x06 ψ[ｅ␏χｃ\x1c＠.ｈIｉD；π｜",
	}, { // 1289
		mask: EncodeSingleQuote | EncodeLeftCrLfHtVt,
		in:   ":\v>]υζ6␝:␙\vτ\x06 ψ[ｅ␏χｃ\x1c＠.ｈIｉD；␋｜",
		out:  ":\v>]υζ6␝:␙\vτ\x06 ψ[ｅ␏χｃ\x1c＠.ｈIｉD；␋｜",
	}, { // 1290
		mask: EncodeSingleQuote | EncodeLeftCrLfHtVt,
		in:   ":␋>]υζ6␝:␙\vτ\x06 ψ[ｅ␏χｃ\x1c＠.ｈIｉD；␋｜",
		out:  ":␋>]υζ6␝:␙\vτ\x06 ψ[ｅ␏χｃ\x1c＠.ｈIｉD；␋｜",
	}, { // 1291
		mask: EncodeSingleQuote | EncodeLeftCrLfHtVt,
		in:   ":\v>]υζ6␝:␙\vτ\x06 ψ[ｅ␏χｃ\x1c＠.ｈIｉD；π␋",
		out:  ":\v>]υζ6␝:␙\vτ\x06 ψ[ｅ␏χｃ\x1c＠.ｈIｉD；π␋",
	}, { // 1292
		mask: EncodeSingleQuote | EncodeLeftCrLfHtVt,
		in:   ":␋>]υζ6␝:␙\vτ\x06 ψ[ｅ␏χｃ\x1c＠.ｈIｉD；π␋",
		out:  ":␋>]υζ6␝:␙\vτ\x06 ψ[ｅ␏χｃ\x1c＠.ｈIｉD；π␋",
	}, { // 1293
		mask: EncodeSingleQuote | EncodeLeftCrLfHtVt,
		in:   ":；>]υζ6␝:␙\vτ\x06 ψ[ｅ␏χｃ\x1c＠.ｈIｉD；\v｜",
		out:  ":；>]υζ6␝:␙\vτ\x06 ψ[ｅ␏χｃ\x1c＠.ｈIｉD；\v｜",
	}, { // 1294
		mask: EncodeSingleQuote | EncodeLeftCrLfHtVt,
		in:   ":；>]υζ6␝:␙\vτ\x06 ψ[ｅ␏χｃ\x1c＠.ｈIｉD；␋｜",
		out:  ":；>]υζ6␝:␙\vτ\x06 ψ[ｅ␏χｃ\x1c＠.ｈIｉD；␋｜",
	}, { // 1295
		mask: EncodeSingleQuote | EncodeLeftCrLfHtVt,
		in:   ":；>]υζ6␝:␙\vτ\x06 ψ[ｅ␏χｃ\x1c＠.ｈIｉD；\v␋",
		out:  ":；>]υζ6␝:␙\vτ\x06 ψ[ｅ␏χｃ\x1c＠.ｈIｉD；\v␋",
	}, { // 1296
		mask: EncodeSingleQuote | EncodeLeftCrLfHtVt,
		in:   ":；>]υζ6␝:␙\vτ\x06 ψ[ｅ␏χｃ\x1c＠.ｈIｉD；␋␋",
		out:  ":；>]υζ6␝:␙\vτ\x06 ψ[ｅ␏χｃ\x1c＠.ｈIｉD；␋␋",
	}, { // 1297
		mask: EncodeSingleQuote | EncodeLeftCrLfHtVt,
		in:   ":；>]υζ6␝:␙\vτ\x06 ψ[ｅ␏χｃ\x1c＠.ｈIｉD；π\v",
		out:  ":；>]υζ6␝:␙\vτ\x06 ψ[ｅ␏χｃ\x1c＠.ｈIｉD；π\v",
	}, { // 1298
		mask: EncodeSingleQuote | EncodeLeftCrLfHtVt,
		in:   ":；>]υζ6␝:␙\vτ\x06 ψ[ｅ␏χｃ\x1c＠.ｈIｉD；π␋",
		out:  ":；>]υζ6␝:␙\vτ\x06 ψ[ｅ␏χｃ\x1c＠.ｈIｉD；π␋",
	}, { // 1299
		mask: EncodeSingleQuote | EncodeLeftCrLfHtVt,
		in:   "\x03ε\uff00\x03βｖＳ．Ｘ／\r：␉␊\x03\x1cβ- ＊F␡λ␘\"\x19 θiκ",
		out:  "\x03ε\uff00\x03βｖＳ．Ｘ／\r：␉␊\x03\x1cβ- ＊F␡λ␘\"\x19 θiκ",
	}, { // 1300
		mask: EncodeSingleQuote | EncodeLeftCrLfHtVt,
		in:   "\r␍\uff00\x03βｖＳ．Ｘ／\r：␉␊\x03\x1cβ- ＊F␡λ␘\"\x19 θiκ",
		out:  "␍␍\uff00\x03βｖＳ．Ｘ／\r：␉␊\x03\x1cβ- ＊F␡λ␘\"\x19 θiκ",
	}, { // 1301
		mask: EncodeSingleQuote | EncodeLeftCrLfHtVt,
		in:   "␍␍\uff00\x03βｖＳ．Ｘ／\r：␉␊\x03\x1cβ- ＊F␡λ␘\"\x19 θiκ",
		out:  "‛␍␍\uff00\x03βｖＳ．Ｘ／\r：␉␊\x03\x1cβ- ＊F␡λ␘\"\x19 θiκ",
	}, { // 1302
		mask: EncodeSingleQuote | EncodeLeftCrLfHtVt,
		in:   "\rε\uff00\x03βｖＳ．Ｘ／\r：␉␊\x03\x1cβ- ＊F␡λ␘\"\x19 θ␍κ",
		out:  "␍ε\uff00\x03βｖＳ．Ｘ／\r：␉␊\x03\x1cβ- ＊F␡λ␘\"\x19 θ␍κ",
	}, { // 1303
		mask: EncodeSingleQuote | EncodeLeftCrLfHtVt,
		in:   "␍ε\uff00\x03βｖＳ．Ｘ／\r：␉␊\x03\x1cβ- ＊F␡λ␘\"\x19 θ␍κ",
		out:  "‛␍ε\uff00\x03βｖＳ．Ｘ／\r：␉␊\x03\x1cβ- ＊F␡λ␘\"\x19 θ␍κ",
	}, { // 1304
		mask: EncodeSingleQuote | EncodeLeftCrLfHtVt,
		in:   "\rε\uff00\x03βｖＳ．Ｘ／\r：␉␊\x03\x1cβ- ＊F␡λ␘\"\x19 θi␍",
		out:  "␍ε\uff00\x03βｖＳ．Ｘ／\r：␉␊\x03\x1cβ- ＊F␡λ␘\"\x19 θi␍",
	}, { // 1305
		mask: EncodeSingleQuote | EncodeLeftCrLfHtVt,
		in:   "␍ε\uff00\x03βｖＳ．Ｘ／\r：␉␊\x03\x1cβ- ＊F␡λ␘\"\x19 θi␍",
		out:  "‛␍ε\uff00\x03βｖＳ．Ｘ／\r：␉␊\x03\x1cβ- ＊F␡λ␘\"\x19 θi␍",
	}, { // 1306
		mask: EncodeSingleQuote | EncodeLeftCrLfHtVt,
		in:   "\x03\r\uff00\x03βｖＳ．Ｘ／\r：␉␊\x03\x1cβ- ＊F␡λ␘\"\x19 θiκ",
		out:  "\x03\r\uff00\x03βｖＳ．Ｘ／\r：␉␊\x03\x1cβ- ＊F␡λ␘\"\x19 θiκ",
	}, { // 1307
		mask: EncodeSingleQuote | EncodeLeftCrLfHtVt,
		in:   "\x03␍\uff00\x03βｖＳ．Ｘ／\r：␉␊\x03\x1cβ- ＊F␡λ␘\"\x19 θiκ",
		out:  "\x03␍\uff00\x03βｖＳ．Ｘ／\r：␉␊\x03\x1cβ- ＊F␡λ␘\"\x19 θiκ",
	}, { // 1308
		mask: EncodeSingleQuote | EncodeLeftCrLfHtVt,
		in:   "\x03\r\uff00\x03βｖＳ．Ｘ／\r：␉␊\x03\x1cβ- ＊F␡λ␘\"\x19 θ␍κ",
		out:  "\x03\r\uff00\x03βｖＳ．Ｘ／\r：␉␊\x03\x1cβ- ＊F␡λ␘\"\x19 θ␍κ",
	}, { // 1309
		mask: EncodeSingleQuote | EncodeLeftCrLfHtVt,
		in:   "\x03␍\uff00\x03βｖＳ．Ｘ／\r：␉␊\x03\x1cβ- ＊F␡λ␘\"\x19 θ␍κ",
		out:  "\x03␍\uff00\x03βｖＳ．Ｘ／\r：␉␊\x03\x1cβ- ＊F␡λ␘\"\x19 θ␍κ",
	}, { // 1310
		mask: EncodeSingleQuote | EncodeLeftCrLfHtVt,
		in:   "\x03\r\uff00\x03βｖＳ．Ｘ／\r：␉␊\x03\x1cβ- ＊F␡λ␘\"\x19 θi␍",
		out:  "\x03\r\uff00\x03βｖＳ．Ｘ／\r：␉␊\x03\x1cβ- ＊F␡λ␘\"\x19 θi␍",
	}, { // 1311
		mask: EncodeSingleQuote | EncodeLeftCrLfHtVt,
		in:   "\x03␍\uff00\x03βｖＳ．Ｘ／\r：␉␊\x03\x1cβ- ＊F␡λ␘\"\x19 θi␍",
		out:  "\x03␍\uff00\x03βｖＳ．Ｘ／\r：␉␊\x03\x1cβ- ＊F␡λ␘\"\x19 θi␍",
	}, { // 1312
		mask: EncodeSingleQuote | EncodeLeftCrLfHtVt,
		in:   "\x03ε\uff00\x03βｖＳ．Ｘ／\r：␉␊\x03\x1cβ- ＊F␡λ␘\"\x19 θ\rκ",
		out:  "\x03ε\uff00\x03βｖＳ．Ｘ／\r：␉␊\x03\x1cβ- ＊F␡λ␘\"\x19 θ\rκ",
	}, { // 1313
		mask: EncodeSingleQuote | EncodeLeftCrLfHtVt,
		in:   "\x03ε\uff00\x03βｖＳ．Ｘ／\r：␉␊\x03\x1cβ- ＊F␡λ␘\"\x19 θ␍κ",
		out:  "\x03ε\uff00\x03βｖＳ．Ｘ／\r：␉␊\x03\x1cβ- ＊F␡λ␘\"\x19 θ␍κ",
	}, { // 1314
		mask: EncodeSingleQuote | EncodeLeftCrLfHtVt,
		in:   "\x03ε\uff00\x03βｖＳ．Ｘ／\r：␉␊\x03\x1cβ- ＊F␡λ␘\"\x19 θ\r␍",
		out:  "\x03ε\uff00\x03βｖＳ．Ｘ／\r：␉␊\x03\x1cβ- ＊F␡λ␘\"\x19 θ\r␍",
	}, { // 1315
		mask: EncodeSingleQuote | EncodeLeftCrLfHtVt,
		in:   "\x03ε\uff00\x03βｖＳ．Ｘ／\r：␉␊\x03\x1cβ- ＊F␡λ␘\"\x19 θ␍␍",
		out:  "\x03ε\uff00\x03βｖＳ．Ｘ／\r：␉␊\x03\x1cβ- ＊F␡λ␘\"\x19 θ␍␍",
	}, { // 1316
		mask: EncodeSingleQuote | EncodeLeftCrLfHtVt,
		in:   "\x03ε\uff00\x03βｖＳ．Ｘ／\r：␉␊\x03\x1cβ- ＊F␡λ␘\"\x19 θi\r",
		out:  "\x03ε\uff00\x03βｖＳ．Ｘ／\r：␉␊\x03\x1cβ- ＊F␡λ␘\"\x19 θi\r",
	}, { // 1317
		mask: EncodeSingleQuote | EncodeLeftCrLfHtVt,
		in:   "\x03ε\uff00\x03βｖＳ．Ｘ／\r：␉␊\x03\x1cβ- ＊F␡λ␘\"\x19 θi␍",
		out:  "\x03ε\uff00\x03βｖＳ．Ｘ／\r：␉␊\x03\x1cβ- ＊F␡λ␘\"\x19 θi␍",
	}, { // 1318
		mask: EncodeBackQuote | EncodeLeftCrLfHtVt,
		in:   "ψφ\x06␙ＥｉjＳ\x13\t\tＵaδ4␟＄\x16％ξ␙γ\\δＵ\x19␏ｒ:\f",
		out:  "ψφ\x06␙ＥｉjＳ\x13\t\tＵaδ4␟＄\x16％ξ␙γ\\δＵ\x19␏ｒ:\f",
	}, { // 1319
		mask: EncodeBackQuote | EncodeLeftCrLfHtVt,
		in:   "\t␉\x06␙ＥｉjＳ\x13\t\tＵaδ4␟＄\x16％ξ␙γ\\δＵ\x19␏ｒ:\f",
		out:  "␉␉\x06␙ＥｉjＳ\x13\t\tＵaδ4␟＄\x16％ξ␙γ\\δＵ\x19␏ｒ:\f",
	}, { // 1320
		mask: EncodeBackQuote | EncodeLeftCrLfHtVt,
		in:   "␉␉\x06␙ＥｉjＳ\x13\t\tＵaδ4␟＄\x16％ξ␙γ\\δＵ\x19␏ｒ:\f",
		out:  "‛␉␉\x06␙ＥｉjＳ\x13\t\tＵaδ4␟＄\x16％ξ␙γ\\δＵ\x19␏ｒ:\f",
	}, { // 1321
		mask: EncodeBackQuote | EncodeLeftCrLfHtVt,
		in:   "\tφ\x06␙ＥｉjＳ\x13\t\tＵaδ4␟＄\x16％ξ␙γ\\δＵ\x19␏ｒ␉\f",
		out:  "␉φ\x06␙ＥｉjＳ\x13\t\tＵaδ4␟＄\x16％ξ␙γ\\δＵ\x19␏ｒ␉\f",
	}, { // 1322
		mask: EncodeBackQuote | EncodeLeftCrLfHtVt,
		in:   "␉φ\x06␙ＥｉjＳ\x13\t\tＵaδ4␟＄\x16％ξ␙γ\\δＵ\x19␏ｒ␉\f",
		out:  "‛␉φ\x06␙ＥｉjＳ\x13\t\tＵaδ4␟＄\x16％ξ␙γ\\δＵ\x19␏ｒ␉\f",
	}, { // 1323
		mask: EncodeBackQuote | EncodeLeftCrLfHtVt,
		in:   "\tφ\x06␙ＥｉjＳ\x13\t\tＵaδ4␟＄\x16％ξ␙γ\\δＵ\x19␏ｒ:␉",
		out:  "␉φ\x06␙ＥｉjＳ\x13\t\tＵaδ4␟＄\x16％ξ␙γ\\δＵ\x19␏ｒ:␉",
	}, { // 1324
		mask: EncodeBackQuote | EncodeLeftCrLfHtVt,
		in:   "␉φ\x06␙ＥｉjＳ\x13\t\tＵaδ4␟＄\x16％ξ␙γ\\δＵ\x19␏ｒ:␉",
		out:  "‛␉φ\x06␙ＥｉjＳ\x13\t\tＵaδ4␟＄\x16％ξ␙γ\\δＵ\x19␏ｒ:␉",
	}, { // 1325
		mask: EncodeBackQuote | EncodeLeftCrLfHtVt,
		in:   "ψ\t\x06␙ＥｉjＳ\x13\t\tＵaδ4␟＄\x16％ξ␙γ\\δＵ\x19␏ｒ:\f",
		out:  "ψ\t\x06␙ＥｉjＳ\x13\t\tＵaδ4␟＄\x16％ξ␙γ\\δＵ\x19␏ｒ:\f",
	}, { // 1326
		mask: EncodeBackQuote | EncodeLeftCrLfHtVt,
		in:   "ψ␉\x06␙ＥｉjＳ\x13\t\tＵaδ4␟＄\x16％ξ␙γ\\δＵ\x19␏ｒ:\f",
		out:  "ψ␉\x06␙ＥｉjＳ\x13\t\tＵaδ4␟＄\x16％ξ␙γ\\δＵ\x19␏ｒ:\f",
	}, { // 1327
		mask: EncodeBackQuote | EncodeLeftCrLfHtVt,
		in:   "ψ\t\x06␙ＥｉjＳ\x13\t\tＵaδ4␟＄\x16％ξ␙γ\\δＵ\x19␏ｒ␉\f",
		out:  "ψ\t\x06␙ＥｉjＳ\x13\t\tＵaδ4␟＄\x16％ξ␙γ\\δＵ\x19␏ｒ␉\f",
	}, { // 1328
		mask: EncodeBackQuote | EncodeLeftCrLfHtVt,
		in:   "ψ␉\x06␙ＥｉjＳ\x13\t\tＵaδ4␟＄\x16％ξ␙γ\\δＵ\x19␏ｒ␉\f",
		out:  "ψ␉\x06␙ＥｉjＳ\x13\t\tＵaδ4␟＄\x16％ξ␙γ\\δＵ\x19␏ｒ␉\f",
	}, { // 1329
		mask: EncodeBackQuote | EncodeLeftCrLfHtVt,
		in:   "ψ\t\x06␙ＥｉjＳ\x13\t\tＵaδ4␟＄\x16％ξ␙γ\\δＵ\x19␏ｒ:␉",
		out:  "ψ\t\x06␙ＥｉjＳ\x13\t\tＵaδ4␟＄\x16％ξ␙γ\\δＵ\x19␏ｒ:␉",
	}, { // 1330
		mask: EncodeBackQuote | EncodeLeftCrLfHtVt,
		in:   "ψ␉\x06␙ＥｉjＳ\x13\t\tＵaδ4␟＄\x16％ξ␙γ\\δＵ\x19␏ｒ:␉",
		out:  "ψ␉\x06␙ＥｉjＳ\x13\t\tＵaδ4␟＄\x16％ξ␙γ\\δＵ\x19␏ｒ:␉",
	}, { // 1331
		mask: EncodeBackQuote | EncodeLeftCrLfHtVt,
		in:   "ψφ\x06␙ＥｉjＳ\x13\t\tＵaδ4␟＄\x16％ξ␙γ\\δＵ\x19␏ｒ\t\f",
		out:  "ψφ\x06␙ＥｉjＳ\x13\t\tＵaδ4␟＄\x16％ξ␙γ\\δＵ\x19␏ｒ\t\f",
	}, { // 1332
		mask: EncodeBackQuote | EncodeLeftCrLfHtVt,
		in:   "ψφ\x06␙ＥｉjＳ\x13\t\tＵaδ4␟＄\x16％ξ␙γ\\δＵ\x19␏ｒ␉\f",
		out:  "ψφ\x06␙ＥｉjＳ\x13\t\tＵaδ4␟＄\x16％ξ␙γ\\δＵ\x19␏ｒ␉\f",
	}, { // 1333
		mask: EncodeBackQuote | EncodeLeftCrLfHtVt,
		in:   "ψφ\x06␙ＥｉjＳ\x13\t\tＵaδ4␟＄\x16％ξ␙γ\\δＵ\x19␏ｒ\t␉",
		out:  "ψφ\x06␙ＥｉjＳ\x13\t\tＵaδ4␟＄\x16％ξ␙γ\\δＵ\x19␏ｒ\t␉",
	}, { // 1334
		mask: EncodeBackQuote | EncodeLeftCrLfHtVt,
		in:   "ψφ\x06␙ＥｉjＳ\x13\t\tＵaδ4␟＄\x16％ξ␙γ\\δＵ\x19␏ｒ␉␉",
		out:  "ψφ\x06␙ＥｉjＳ\x13\t\tＵaδ4␟＄\x16％ξ␙γ\\δＵ\x19␏ｒ␉␉",
	}, { // 1335
		mask: EncodeBackQuote | EncodeLeftCrLfHtVt,
		in:   "ψφ\x06␙ＥｉjＳ\x13\t\tＵaδ4␟＄\x16％ξ␙γ\\δＵ\x19␏ｒ:\t",
		out:  "ψφ\x06␙ＥｉjＳ\x13\t\tＵaδ4␟＄\x16％ξ␙γ\\δＵ\x19␏ｒ:\t",
	}, { // 1336
		mask: EncodeBackQuote | EncodeLeftCrLfHtVt,
		in:   "ψφ\x06␙ＥｉjＳ\x13\t\tＵaδ4␟＄\x16％ξ␙γ\\δＵ\x19␏ｒ:␉",
		out:  "ψφ\x06␙ＥｉjＳ\x13\t\tＵaδ4␟＄\x16％ξ␙γ\\δＵ\x19␏ｒ:␉",
	}, { // 1337
		mask: EncodeBackQuote | EncodeLeftCrLfHtVt,
		in:   "␡ο＠＜O４ε\x10\x15␇\nι\x1c＂\x12ｈ&_β␑/␓PYη＼+Ｌｑ\"",
		out:  "␡ο＠＜O４ε\x10\x15␇\nι\x1c＂\x12ｈ&_β␑/␓PYη＼+Ｌｑ\"",
	}, { // 1338
		mask: EncodeBackQuote | EncodeLeftCrLfHtVt,
		in:   "\n␊＠＜O４ε\x10\x15␇\nι\x1c＂\x12ｈ&_β␑/␓PYη＼+Ｌｑ\"",
		out:  "␊␊＠＜O４ε\x10\x15␇\nι\x1c＂\x12ｈ&_β␑/␓PYη＼+Ｌｑ\"",
	}, { // 1339
		mask: EncodeBackQuote | EncodeLeftCrLfHtVt,
		in:   "␊␊＠＜O４ε\x10\x15␇\nι\x1c＂\x12ｈ&_β␑/␓PYη＼+Ｌｑ\"",
		out:  "‛␊␊＠＜O４ε\x10\x15␇\nι\x1c＂\x12ｈ&_β␑/␓PYη＼+Ｌｑ\"",
	}, { // 1340
		mask: EncodeBackQuote | EncodeLeftCrLfHtVt,
		in:   "\nο＠＜O４ε\x10\x15␇\nι\x1c＂\x12ｈ&_β␑/␓PYη＼+Ｌ␊\"",
		out:  "␊ο＠＜O４ε\x10\x15␇\nι\x1c＂\x12ｈ&_β␑/␓PYη＼+Ｌ␊\"",
	}, { // 1341
		mask: EncodeBackQuote | EncodeLeftCrLfHtVt,
		in:   "␊ο＠＜O４ε\x10\x15␇\nι\x1c＂\x12ｈ&_β␑/␓PYη＼+Ｌ␊\"",
		out:  "‛␊ο＠＜O４ε\x10\x15␇\nι\x1c＂\x12ｈ&_β␑/␓PYη＼+Ｌ␊\"",
	}, { // 1342
		mask: EncodeBackQuote | EncodeLeftCrLfHtVt,
		in:   "\nο＠＜O４ε\x10\x15␇\nι\x1c＂\x12ｈ&_β␑/␓PYη＼+Ｌｑ␊",
		out:  "␊ο＠＜O４ε\x10\x15␇\nι\x1c＂\x12ｈ&_β␑/␓PYη＼+Ｌｑ␊",
	}, { // 1343
		mask: EncodeBackQuote | EncodeLeftCrLfHtVt,
		in:   "␊ο＠＜O４ε\x10\x15␇\nι\x1c＂\x12ｈ&_β␑/␓PYη＼+Ｌｑ␊",
		out:  "‛␊ο＠＜O４ε\x10\x15␇\nι\x1c＂\x12ｈ&_β␑/␓PYη＼+Ｌｑ␊",
	}, { // 1344
		mask: EncodeBackQuote | EncodeLeftCrLfHtVt,
		in:   "␡\n＠＜O４ε\x10\x15␇\nι\x1c＂\x12ｈ&_β␑/␓PYη＼+Ｌｑ\"",
		out:  "␡\n＠＜O４ε\x10\x15␇\nι\x1c＂\x12ｈ&_β␑/␓PYη＼+Ｌｑ\"",
	}, { // 1345
		mask: EncodeBackQuote | EncodeLeftCrLfHtVt,
		in:   "␡␊＠＜O４ε\x10\x15␇\nι\x1c＂\x12ｈ&_β␑/␓PYη＼+Ｌｑ\"",
		out:  "␡␊＠＜O４ε\x10\x15␇\nι\x1c＂\x12ｈ&_β␑/␓PYη＼+Ｌｑ\"",
	}, { // 1346
		mask: EncodeBackQuote | EncodeLeftCrLfHtVt,
		in:   "␡\n＠＜O４ε\x10\x15␇\nι\x1c＂\x12ｈ&_β␑/␓PYη＼+Ｌ␊\"",
		out:  "␡\n＠＜O４ε\x10\x15␇\nι\x1c＂\x12ｈ&_β␑/␓PYη＼+Ｌ␊\"",
	}, { // 1347
		mask: EncodeBackQuote | EncodeLeftCrLfHtVt,
		in:   "␡␊＠＜O４ε\x10\x15␇\nι\x1c＂\x12ｈ&_β␑/␓PYη＼+Ｌ␊\"",
		out:  "␡␊＠＜O４ε\x10\x15␇\nι\x1c＂\x12ｈ&_β␑/␓PYη＼+Ｌ␊\"",
	}, { // 1348
		mask: EncodeBackQuote | EncodeLeftCrLfHtVt,
		in:   "␡\n＠＜O４ε\x10\x15␇\nι\x1c＂\x12ｈ&_β␑/␓PYη＼+Ｌｑ␊",
		out:  "␡\n＠＜O４ε\x10\x15␇\nι\x1c＂\x12ｈ&_β␑/␓PYη＼+Ｌｑ␊",
	}, { // 1349
		mask: EncodeBackQuote | EncodeLeftCrLfHtVt,
		in:   "␡␊＠＜O４ε\x10\x15␇\nι\x1c＂\x12ｈ&_β␑/␓PYη＼+Ｌｑ␊",
		out:  "␡␊＠＜O４ε\x10\x15␇\nι\x1c＂\x12ｈ&_β␑/␓PYη＼+Ｌｑ␊",
	}, { // 1350
		mask: EncodeBackQuote | EncodeLeftCrLfHtVt,
		in:   "␡ο＠＜O４ε\x10\x15␇\nι\x1c＂\x12ｈ&_β␑/␓PYη＼+Ｌ\n\"",
		out:  "␡ο＠＜O４ε\x10\x15␇\nι\x1c＂\x12ｈ&_β␑/␓PYη＼+Ｌ\n\"",
	}, { // 1351
		mask: EncodeBackQuote | EncodeLeftCrLfHtVt,
		in:   "␡ο＠＜O４ε\x10\x15␇\nι\x1c＂\x12ｈ&_β␑/␓PYη＼+Ｌ␊\"",
		out:  "␡ο＠＜O４ε\x10\x15␇\nι\x1c＂\x12ｈ&_β␑/␓PYη＼+Ｌ␊\"",
	}, { // 1352
		mask: EncodeBackQuote | EncodeLeftCrLfHtVt,
		in:   "␡ο＠＜O４ε\x10\x15␇\nι\x1c＂\x12ｈ&_β␑/␓PYη＼+Ｌ\n␊",
		out:  "␡ο＠＜O４ε\x10\x15␇\nι\x1c＂\x12ｈ&_β␑/␓PYη＼+Ｌ\n␊",
	}, { // 1353
		mask: EncodeBackQuote | EncodeLeftCrLfHtVt,
		in:   "␡ο＠＜O４ε\x10\x15␇\nι\x1c＂\x12ｈ&_β␑/␓PYη＼+Ｌ␊␊",
		out:  "␡ο＠＜O４ε\x10\x15␇\nι\x1c＂\x12ｈ&_β␑/␓PYη＼+Ｌ␊␊",
	}, { // 1354
		mask: EncodeBackQuote | EncodeLeftCrLfHtVt,
		in:   "␡ο＠＜O４ε\x10\x15␇\nι\x1c＂\x12ｈ&_β␑/␓PYη＼+Ｌｑ\n",
		out:  "␡ο＠＜O４ε\x10\x15␇\nι\x1c＂\x12ｈ&_β␑/␓PYη＼+Ｌｑ\n",
	}, { // 1355
		mask: EncodeBackQuote | EncodeLeftCrLfHtVt,
		in:   "␡ο＠＜O４ε\x10\x15␇\nι\x1c＂\x12ｈ&_β␑/␓PYη＼+Ｌｑ␊",
		out:  "␡ο＠＜O４ε\x10\x15␇\nι\x1c＂\x12ｈ&_β␑/␓PYη＼+Ｌｑ␊",
	}, { // 1356
		mask: EncodeBackQuote | EncodeLeftCrLfHtVt,
		in:   "_ψ\x01N８␍：␍：ｌ\v\n,\tιηｚ％\v\x1d,␡β#ｔ+ι*ο（",
		out:  "_ψ\x01N８␍：␍：ｌ\v\n,\tιηｚ％\v\x1d,␡β#ｔ+ι*ο（",
	}, { // 1357
		mask: EncodeBackQuote | EncodeLeftCrLfHtVt,
		in:   "\v␋\x01N８␍：␍：ｌ\v\n,\tιηｚ％\v\x1d,␡β#ｔ+ι*ο（",
		out:  "␋␋\x01N８␍：␍：ｌ\v\n,\tιηｚ％\v\x1d,␡β#ｔ+ι*ο（",
	}, { // 1358
		mask: EncodeBackQuote | EncodeLeftCrLfHtVt,
		in:   "␋␋\x01N８␍：␍：ｌ\v\n,\tιηｚ％\v\x1d,␡β#ｔ+ι*ο（",
		out:  "‛␋␋\x01N８␍：␍：ｌ\v\n,\tιηｚ％\v\x1d,␡β#ｔ+ι*ο（",
	}, { // 1359
		mask: EncodeBackQuote | EncodeLeftCrLfHtVt,
		in:   "\vψ\x01N８␍：␍：ｌ\v\n,\tιηｚ％\v\x1d,␡β#ｔ+ι*␋（",
		out:  "␋ψ\x01N８␍：␍：ｌ\v\n,\tιηｚ％\v\x1d,␡β#ｔ+ι*␋（",
	}, { // 1360
		mask: EncodeBackQuote | EncodeLeftCrLfHtVt,
		in:   "␋ψ\x01N８␍：␍：ｌ\v\n,\tιηｚ％\v\x1d,␡β#ｔ+ι*␋（",
		out:  "‛␋ψ\x01N８␍：␍：ｌ\v\n,\tιηｚ％\v\x1d,␡β#ｔ+ι*␋（",
	}, { // 1361
		mask: EncodeBackQuote | EncodeLeftCrLfHtVt,
		in:   "\vψ\x01N８␍：␍：ｌ\v\n,\tιηｚ％\v\x1d,␡β#ｔ+ι*ο␋",
		out:  "␋ψ\x01N８␍：␍：ｌ\v\n,\tιηｚ％\v\x1d,␡β#ｔ+ι*ο␋",
	}, { // 1362
		mask: EncodeBackQuote | EncodeLeftCrLfHtVt,
		in:   "␋ψ\x01N８␍：␍：ｌ\v\n,\tιηｚ％\v\x1d,␡β#ｔ+ι*ο␋",
		out:  "‛␋ψ\x01N８␍：␍：ｌ\v\n,\tιηｚ％\v\x1d,␡β#ｔ+ι*ο␋",
	}, { // 1363
		mask: EncodeBackQuote | EncodeLeftCrLfHtVt,
		in:   "_\v\x01N８␍：␍：ｌ\v\n,\tιηｚ％\v\x1d,␡β#ｔ+ι*ο（",
		out:  "_\v\x01N８␍：␍：ｌ\v\n,\tιηｚ％\v\x1d,␡β#ｔ+ι*ο（",
	}, { // 1364
		mask: EncodeBackQuote | EncodeLeftCrLfHtVt,
		in:   "_␋\x01N８␍：␍：ｌ\v\n,\tιηｚ％\v\x1d,␡β#ｔ+ι*ο（",
		out:  "_␋\x01N８␍：␍：ｌ\v\n,\tιηｚ％\v\x1d,␡β#ｔ+ι*ο（",
	}, { // 1365
		mask: EncodeBackQuote | EncodeLeftCrLfHtVt,
		in:   "_\v\x01N８␍：␍：ｌ\v\n,\tιηｚ％\v\x1d,␡β#ｔ+ι*␋（",
		out:  "_\v\x01N８␍：␍：ｌ\v\n,\tιηｚ％\v\x1d,␡β#ｔ+ι*␋（",
	}, { // 1366
		mask: EncodeBackQuote | EncodeLeftCrLfHtVt,
		in:   "_␋\x01N８␍：␍：ｌ\v\n,\tιηｚ％\v\x1d,␡β#ｔ+ι*␋（",
		out:  "_␋\x01N８␍：␍：ｌ\v\n,\tιηｚ％\v\x1d,␡β#ｔ+ι*␋（",
	}, { // 1367
		mask: EncodeBackQuote | EncodeLeftCrLfHtVt,
		in:   "_\v\x01N８␍：␍：ｌ\v\n,\tιηｚ％\v\x1d,␡β#ｔ+ι*ο␋",
		out:  "_\v\x01N８␍：␍：ｌ\v\n,\tιηｚ％\v\x1d,␡β#ｔ+ι*ο␋",
	}, { // 1368
		mask: EncodeBackQuote | EncodeLeftCrLfHtVt,
		in:   "_␋\x01N８␍：␍：ｌ\v\n,\tιηｚ％\v\x1d,␡β#ｔ+ι*ο␋",
		out:  "_␋\x01N８␍：␍：ｌ\v\n,\tιηｚ％\v\x1d,␡β#ｔ+ι*ο␋",
	}, { // 1369
		mask: EncodeBackQuote | EncodeLeftCrLfHtVt,
		in:   "_ψ\x01N８␍：␍：ｌ\v\n,\tιηｚ％\v\x1d,␡β#ｔ+ι*\v（",
		out:  "_ψ\x01N８␍：␍：ｌ\v\n,\tιηｚ％\v\x1d,␡β#ｔ+ι*\v（",
	}, { // 1370
		mask: EncodeBackQuote | EncodeLeftCrLfHtVt,
		in:   "_ψ\x01N８␍：␍：ｌ\v\n,\tιηｚ％\v\x1d,␡β#ｔ+ι*␋（",
		out:  "_ψ\x01N８␍：␍：ｌ\v\n,\tιηｚ％\v\x1d,␡β#ｔ+ι*␋（",
	}, { // 1371
		mask: EncodeBackQuote | EncodeLeftCrLfHtVt,
		in:   "_ψ\x01N８␍：␍：ｌ\v\n,\tιηｚ％\v\x1d,␡β#ｔ+ι*\v␋",
		out:  "_ψ\x01N８␍：␍：ｌ\v\n,\tιηｚ％\v\x1d,␡β#ｔ+ι*\v␋",
	}, { // 1372
		mask: EncodeBackQuote | EncodeLeftCrLfHtVt,
		in:   "_ψ\x01N８␍：␍：ｌ\v\n,\tιηｚ％\v\x1d,␡β#ｔ+ι*␋␋",
		out:  "_ψ\x01N８␍：␍：ｌ\v\n,\tιηｚ％\v\x1d,␡β#ｔ+ι*␋␋",
	}, { // 1373
		mask: EncodeBackQuote | EncodeLeftCrLfHtVt,
		in:   "_ψ\x01N８␍：␍：ｌ\v\n,\tιηｚ％\v\x1d,␡β#ｔ+ι*ο\v",
		out:  "_ψ\x01N８␍：␍：ｌ\v\n,\tιηｚ％\v\x1d,␡β#ｔ+ι*ο\v",
	}, { // 1374
		mask: EncodeBackQuote | EncodeLeftCrLfHtVt,
		in:   "_ψ\x01N８␍：␍：ｌ\v\n,\tιηｚ％\v\x1d,␡β#ｔ+ι*ο␋",
		out:  "_ψ\x01N８␍：␍：ｌ\v\n,\tιηｚ％\v\x1d,␡β#ｔ+ι*ο␋",
	}, { // 1375
		mask: EncodeBackQuote | EncodeLeftCrLfHtVt,
		in:   "π４;␇\x1dｘ\x1d␟θσ\rQ\x11ω<ｇ:'␐ａO\r␓πμ␊$ｙＬ^",
		out:  "π４;␇\x1dｘ\x1d␟θσ\rQ\x11ω<ｇ:'␐ａO\r␓πμ␊$ｙＬ^",
	}, { // 1376
		mask: EncodeBackQuote | EncodeLeftCrLfHtVt,
		in:   "\r␍;␇\x1dｘ\x1d␟θσ\rQ\x11ω<ｇ:'␐ａO\r␓πμ␊$ｙＬ^",
		out:  "␍␍;␇\x1dｘ\x1d␟θσ\rQ\x11ω<ｇ:'␐ａO\r␓πμ␊$ｙＬ^",
	}, { // 1377
		mask: EncodeBackQuote | EncodeLeftCrLfHtVt,
		in:   "␍␍;␇\x1dｘ\x1d␟θσ\rQ\x11ω<ｇ:'␐ａO\r␓πμ␊$ｙＬ^",
		out:  "‛␍␍;␇\x1dｘ\x1d␟θσ\rQ\x11ω<ｇ:'␐ａO\r␓πμ␊$ｙＬ^",
	}, { // 1378
		mask: EncodeBackQuote | EncodeLeftCrLfHtVt,
		in:   "\r４;␇\x1dｘ\x1d␟θσ\rQ\x11ω<ｇ:'␐ａO\r␓πμ␊$ｙ␍^",
		out:  "␍４;␇\x1dｘ\x1d␟θσ\rQ\x11ω<ｇ:'␐ａO\r␓πμ␊$ｙ␍^",
	}, { // 1379
		mask: EncodeBackQuote | EncodeLeftCrLfHtVt,
		in:   "␍４;␇\x1dｘ\x1d␟θσ\rQ\x11ω<ｇ:'␐ａO\r␓πμ␊$ｙ␍^",
		out:  "‛␍４;␇\x1dｘ\x1d␟θσ\rQ\x11ω<ｇ:'␐ａO\r␓πμ␊$ｙ␍^",
	}, { // 1380
		mask: EncodeBackQuote | EncodeLeftCrLfHtVt,
		in:   "\r４;␇\x1dｘ\x1d␟θσ\rQ\x11ω<ｇ:'␐ａO\r␓πμ␊$ｙＬ␍",
		out:  "␍４;␇\x1dｘ\x1d␟θσ\rQ\x11ω<ｇ:'␐ａO\r␓πμ␊$ｙＬ␍",
	}, { // 1381
		mask: EncodeBackQuote | EncodeLeftCrLfHtVt,
		in:   "␍４;␇\x1dｘ\x1d␟θσ\rQ\x11ω<ｇ:'␐ａO\r␓πμ␊$ｙＬ␍",
		out:  "‛␍４;␇\x1dｘ\x1d␟θσ\rQ\x11ω<ｇ:'␐ａO\r␓πμ␊$ｙＬ␍",
	}, { // 1382
		mask: EncodeBackQuote | EncodeLeftCrLfHtVt,
		in:   "π\r;␇\x1dｘ\x1d␟θσ\rQ\x11ω<ｇ:'␐ａO\r␓πμ␊$ｙＬ^",
		out:  "π\r;␇\x1dｘ\x1d␟θσ\rQ\x11ω<ｇ:'␐ａO\r␓πμ␊$ｙＬ^",
	}, { // 1383
		mask: EncodeBackQuote | EncodeLeftCrLfHtVt,
		in:   "π␍;␇\x1dｘ\x1d␟θσ\rQ\x11ω<ｇ:'␐ａO\r␓πμ␊$ｙＬ^",
		out:  "π␍;␇\x1dｘ\x1d␟θσ\rQ\x11ω<ｇ:'␐ａO\r␓πμ␊$ｙＬ^",
	}, { // 1384
		mask: EncodeBackQuote | EncodeLeftCrLfHtVt,
		in:   "π\r;␇\x1dｘ\x1d␟θσ\rQ\x11ω<ｇ:'␐ａO\r␓πμ␊$ｙ␍^",
		out:  "π\r;␇\x1dｘ\x1d␟θσ\rQ\x11ω<ｇ:'␐ａO\r␓πμ␊$ｙ␍^",
	}, { // 1385
		mask: EncodeBackQuote | EncodeLeftCrLfHtVt,
		in:   "π␍;␇\x1dｘ\x1d␟θσ\rQ\x11ω<ｇ:'␐ａO\r␓πμ␊$ｙ␍^",
		out:  "π␍;␇\x1dｘ\x1d␟θσ\rQ\x11ω<ｇ:'␐ａO\r␓πμ␊$ｙ␍^",
	}, { // 1386
		mask: EncodeBackQuote | EncodeLeftCrLfHtVt,
		in:   "π\r;␇\x1dｘ\x1d␟θσ\rQ\x11ω<ｇ:'␐ａO\r␓πμ␊$ｙＬ␍",
		out:  "π\r;␇\x1dｘ\x1d␟θσ\rQ\x11ω<ｇ:'␐ａO\r␓πμ␊$ｙＬ␍",
	}, { // 1387
		mask: EncodeBackQuote | EncodeLeftCrLfHtVt,
		in:   "π␍;␇\x1dｘ\x1d␟θσ\rQ\x11ω<ｇ:'␐ａO\r␓πμ␊$ｙＬ␍",
		out:  "π␍;␇\x1dｘ\x1d␟θσ\rQ\x11ω<ｇ:'␐ａO\r␓πμ␊$ｙＬ␍",
	}, { // 1388
		mask: EncodeBackQuote | EncodeLeftCrLfHtVt,
		in:   "π４;␇\x1dｘ\x1d␟θσ\rQ\x11ω<ｇ:'␐ａO\r␓πμ␊$ｙ\r^",
		out:  "π４;␇\x1dｘ\x1d␟θσ\rQ\x11ω<ｇ:'␐ａO\r␓πμ␊$ｙ\r^",
	}, { // 1389
		mask: EncodeBackQuote | EncodeLeftCrLfHtVt,
		in:   "π４;␇\x1dｘ\x1d␟θσ\rQ\x11ω<ｇ:'␐ａO\r␓πμ␊$ｙ␍^",
		out:  "π４;␇\x1dｘ\x1d␟θσ\rQ\x11ω<ｇ:'␐ａO\r␓πμ␊$ｙ␍^",
	}, { // 1390
		mask: EncodeBackQuote | EncodeLeftCrLfHtVt,
		in:   "π４;␇\x1dｘ\x1d␟θσ\rQ\x11ω<ｇ:'␐ａO\r␓πμ␊$ｙ\r␍",
		out:  "π４;␇\x1dｘ\x1d␟θσ\rQ\x11ω<ｇ:'␐ａO\r␓πμ␊$ｙ\r␍",
	}, { // 1391
		mask: EncodeBackQuote | EncodeLeftCrLfHtVt,
		in:   "π４;␇\x1dｘ\x1d␟θσ\rQ\x11ω<ｇ:'␐ａO\r␓πμ␊$ｙ␍␍",
		out:  "π４;␇\x1dｘ\x1d␟θσ\rQ\x11ω<ｇ:'␐ａO\r␓πμ␊$ｙ␍␍",
	}, { // 1392
		mask: EncodeBackQuote | EncodeLeftCrLfHtVt,
		in:   "π４;␇\x1dｘ\x1d␟θσ\rQ\x11ω<ｇ:'␐ａO\r␓πμ␊$ｙＬ\r",
		out:  "π４;␇\x1dｘ\x1d␟θσ\rQ\x11ω<ｇ:'␐ａO\r␓πμ␊$ｙＬ\r",
	}, { // 1393
		mask: EncodeBackQuote | EncodeLeftCrLfHtVt,
		in:   "π４;␇\x1dｘ\x1d␟θσ\rQ\x11ω<ｇ:'␐ａO\r␓πμ␊$ｙＬ␍",
		out:  "π４;␇\x1dｘ\x1d␟θσ\rQ\x11ω<ｇ:'␐ａO\r␓πμ␊$ｙＬ␍",
	}, { // 1394
		mask: EncodeLtGt | EncodeLeftCrLfHtVt,
		in:   "␚>ζ\v\x1b｝ςｍ?υ\t＂Ｊ71７;\x02?α＾␟,␚σφ：＂（@",
		out:  "␚＞ζ\v\x1b｝ςｍ?υ\t＂Ｊ71７;\x02?α＾␟,␚σφ：＂（@",
	}, { // 1395
		mask: EncodeLtGt | EncodeLeftCrLfHtVt,
		in:   "\t␉ζ\v\x1b｝ςｍ?υ\t＂Ｊ71７;\x02?α＾␟,␚σφ：＂（@",
		out:  "␉␉ζ\v\x1b｝ςｍ?υ\t＂Ｊ71７;\x02?α＾␟,␚σφ：＂（@",
	}, { // 1396
		mask: EncodeLtGt | EncodeLeftCrLfHtVt,
		in:   "␉␉ζ\v\x1b｝ςｍ?υ\t＂Ｊ71７;\x02?α＾␟,␚σφ：＂（@",
		out:  "‛␉␉ζ\v\x1b｝ςｍ?υ\t＂Ｊ71７;\x02?α＾␟,␚σφ：＂（@",
	}, { // 1397
		mask: EncodeLtGt | EncodeLeftCrLfHtVt,
		in:   "\t>ζ\v\x1b｝ςｍ?υ\t＂Ｊ71７;\x02?α＾␟,␚σφ：＂␉@",
		out:  "␉＞ζ\v\x1b｝ςｍ?υ\t＂Ｊ71７;\x02?α＾␟,␚σφ：＂␉@",
	}, { // 1398
		mask: EncodeLtGt | EncodeLeftCrLfHtVt,
		in:   "␉>ζ\v\x1b｝ςｍ?υ\t＂Ｊ71７;\x02?α＾␟,␚σφ：＂␉@",
		out:  "‛␉＞ζ\v\x1b｝ςｍ?υ\t＂Ｊ71７;\x02?α＾␟,␚σφ：＂␉@",
	}, { // 1399
		mask: EncodeLtGt | EncodeLeftCrLfHtVt,
		in:   "\t>ζ\v\x1b｝ςｍ?υ\t＂Ｊ71７;\x02?α＾␟,␚σφ：＂（␉",
		out:  "␉＞ζ\v\x1b｝ςｍ?υ\t＂Ｊ71７;\x02?α＾␟,␚σφ：＂（␉",
	}, { // 1400
		mask: EncodeLtGt | EncodeLeftCrLfHtVt,
		in:   "␉>ζ\v\x1b｝ςｍ?υ\t＂Ｊ71７;\x02?α＾␟,␚σφ：＂（␉",
		out:  "‛␉＞ζ\v\x1b｝ςｍ?υ\t＂Ｊ71７;\x02?α＾␟,␚σφ：＂（␉",
	}, { // 1401
		mask: EncodeLtGt | EncodeLeftCrLfHtVt,
		in:   "␚\tζ\v\x1b｝ςｍ?υ\t＂Ｊ71７;\x02?α＾␟,␚σφ：＂（@",
		out:  "␚\tζ\v\x1b｝ςｍ?υ\t＂Ｊ71７;\x02?α＾␟,␚σφ：＂（@",
	}, { // 1402
		mask: EncodeLtGt | EncodeLeftCrLfHtVt,
		in:   "␚␉ζ\v\x1b｝ςｍ?υ\t＂Ｊ71７;\x02?α＾␟,␚σφ：＂（@",
		out:  "␚␉ζ\v\x1b｝ςｍ?υ\t＂Ｊ71７;\x02?α＾␟,␚σφ：＂（@",
	}, { // 1403
		mask: EncodeLtGt | EncodeLeftCrLfHtVt,
		in:   "␚\tζ\v\x1b｝ςｍ?υ\t＂Ｊ71７;\x02?α＾␟,␚σφ：＂␉@",
		out:  "␚\tζ\v\x1b｝ςｍ?υ\t＂Ｊ71７;\x02?α＾␟,␚σφ：＂␉@",
	}, { // 1404
		mask: EncodeLtGt | EncodeLeftCrLfHtVt,
		in:   "␚␉ζ\v\x1b｝ςｍ?υ\t＂Ｊ71７;\x02?α＾␟,␚σφ：＂␉@",
		out:  "␚␉ζ\v\x1b｝ςｍ?υ\t＂Ｊ71７;\x02?α＾␟,␚σφ：＂␉@",
	}, { // 1405
		mask: EncodeLtGt | EncodeLeftCrLfHtVt,
		in:   "␚\tζ\v\x1b｝ςｍ?υ\t＂Ｊ71７;\x02?α＾␟,␚σφ：＂（␉",
		out:  "␚\tζ\v\x1b｝ςｍ?υ\t＂Ｊ71７;\x02?α＾␟,␚σφ：＂（␉",
	}, { // 1406
		mask: EncodeLtGt | EncodeLeftCrLfHtVt,
		in:   "␚␉ζ\v\x1b｝ςｍ?υ\t＂Ｊ71７;\x02?α＾␟,␚σφ：＂（␉",
		out:  "␚␉ζ\v\x1b｝ςｍ?υ\t＂Ｊ71７;\x02?α＾␟,␚σφ：＂（␉",
	}, { // 1407
		mask: EncodeLtGt | EncodeLeftCrLfHtVt,
		in:   "␚>ζ\v\x1b｝ςｍ?υ\t＂Ｊ71７;\x02?α＾␟,␚σφ：＂\t@",
		out:  "␚＞ζ\v\x1b｝ςｍ?υ\t＂Ｊ71７;\x02?α＾␟,␚σφ：＂\t@",
	}, { // 1408
		mask: EncodeLtGt | EncodeLeftCrLfHtVt,
		in:   "␚>ζ\v\x1b｝ςｍ?υ\t＂Ｊ71７;\x02?α＾␟,␚σφ：＂␉@",
		out:  "␚＞ζ\v\x1b｝ςｍ?υ\t＂Ｊ71７;\x02?α＾␟,␚σφ：＂␉@",
	}, { // 1409
		mask: EncodeLtGt | EncodeLeftCrLfHtVt,
		in:   "␚>ζ\v\x1b｝ςｍ?υ\t＂Ｊ71７;\x02?α＾␟,␚σφ：＂\t␉",
		out:  "␚＞ζ\v\x1b｝ςｍ?υ\t＂Ｊ71７;\x02?α＾␟,␚σφ：＂\t␉",
	}, { // 1410
		mask: EncodeLtGt | EncodeLeftCrLfHtVt,
		in:   "␚>ζ\v\x1b｝ςｍ?υ\t＂Ｊ71７;\x02?α＾␟,␚σφ：＂␉␉",
		out:  "␚＞ζ\v\x1b｝ςｍ?υ\t＂Ｊ71７;\x02?α＾␟,␚σφ：＂␉␉",
	}, { // 1411
		mask: EncodeLtGt | EncodeLeftCrLfHtVt,
		in:   "␚>ζ\v\x1b｝ςｍ?υ\t＂Ｊ71７;\x02?α＾␟,␚σφ：＂（\t",
		out:  "␚＞ζ\v\x1b｝ςｍ?υ\t＂Ｊ71７;\x02?α＾␟,␚σφ：＂（\t",
	}, { // 1412
		mask: EncodeLtGt | EncodeLeftCrLfHtVt,
		in:   "␚>ζ\v\x1b｝ςｍ?υ\t＂Ｊ71７;\x02?α＾␟,␚σφ：＂（␉",
		out:  "␚＞ζ\v\x1b｝ςｍ?υ\t＂Ｊ71７;\x02?α＾␟,␚σφ：＂（␉",
	}, { // 1413
		mask: EncodeLtGt | EncodeLeftCrLfHtVt,
		in:   "\nζ％␊＝<#；ｄz\n␃ζ\x15␄<\x04ζ_！ｓ？\tＲυ８δ/\x1cA",
		out:  "␊ζ％␊＝＜#；ｄz\n␃ζ\x15␄＜\x04ζ_！ｓ？\tＲυ８δ/\x1cA",
	}, { // 1414
		mask: EncodeLtGt | EncodeLeftCrLfHtVt,
		in:   "\n␊％␊＝<#；ｄz\n␃ζ\x15␄<\x04ζ_！ｓ？\tＲυ８δ/\x1cA",
		out:  "␊␊％␊＝＜#；ｄz\n␃ζ\x15␄＜\x04ζ_！ｓ？\tＲυ８δ/\x1cA",
	}, { // 1415
		mask: EncodeLtGt | EncodeLeftCrLfHtVt,
		in:   "␊␊％␊＝<#；ｄz\n␃ζ\x15␄<\x04ζ_！ｓ？\tＲυ８δ/\x1cA",
		out:  "‛␊␊％␊＝＜#；ｄz\n␃ζ\x15␄＜\x04ζ_！ｓ？\tＲυ８δ/\x1cA",
	}, { // 1416
		mask: EncodeLtGt | EncodeLeftCrLfHtVt,
		in:   "\nζ％␊＝<#；ｄz\n␃ζ\x15␄<\x04ζ_！ｓ？\tＲυ８δ/␊A",
		out:  "␊ζ％␊＝＜#；ｄz\n␃ζ\x15␄＜\x04ζ_！ｓ？\tＲυ８δ/␊A",
	}, { // 1417
		mask: EncodeLtGt | EncodeLeftCrLfHtVt,
		in:   "␊ζ％␊＝<#；ｄz\n␃ζ\x15␄<\x04ζ_！ｓ？\tＲυ８δ/␊A",
		out:  "‛␊ζ％␊＝＜#；ｄz\n␃ζ\x15␄＜\x04ζ_！ｓ？\tＲυ８δ/␊A",
	}, { // 1418
		mask: EncodeLtGt | EncodeLeftCrLfHtVt,
		in:   "\nζ％␊＝<#；ｄz\n␃ζ\x15␄<\x04ζ_！ｓ？\tＲυ８δ/\x1c␊",
		out:  "␊ζ％␊＝＜#；ｄz\n␃ζ\x15␄＜\x04ζ_！ｓ？\tＲυ８δ/\x1c␊",
	}, { // 1419
		mask: EncodeLtGt | EncodeLeftCrLfHtVt,
		in:   "␊ζ％␊＝<#；ｄz\n␃ζ\x15␄<\x04ζ_！ｓ？\tＲυ８δ/\x1c␊",
		out:  "‛␊ζ％␊＝＜#；ｄz\n␃ζ\x15␄＜\x04ζ_！ｓ？\tＲυ８δ/\x1c␊",
	}, { // 1420
		mask: EncodeLtGt | EncodeLeftCrLfHtVt,
		in:   "\n\n％␊＝<#；ｄz\n␃ζ\x15␄<\x04ζ_！ｓ？\tＲυ８δ/\x1cA",
		out:  "␊\n％␊＝＜#；ｄz\n␃ζ\x15␄＜\x04ζ_！ｓ？\tＲυ８δ/\x1cA",
	}, { // 1421
		mask: EncodeLtGt | EncodeLeftCrLfHtVt,
		in:   "\n␊％␊＝<#；ｄz\n␃ζ\x15␄<\x04ζ_！ｓ？\tＲυ８δ/\x1cA",
		out:  "␊␊％␊＝＜#；ｄz\n␃ζ\x15␄＜\x04ζ_！ｓ？\tＲυ８δ/\x1cA",
	}, { // 1422
		mask: EncodeLtGt | EncodeLeftCrLfHtVt,
		in:   "\n\n％␊＝<#；ｄz\n␃ζ\x15␄<\x04ζ_！ｓ？\tＲυ８δ/␊A",
		out:  "␊\n％␊＝＜#；ｄz\n␃ζ\x15␄＜\x04ζ_！ｓ？\tＲυ８δ/␊A",
	}, { // 1423
		mask: EncodeLtGt | EncodeLeftCrLfHtVt,
		in:   "\n␊％␊＝<#；ｄz\n␃ζ\x15␄<\x04ζ_！ｓ？\tＲυ８δ/␊A",
		out:  "␊␊％␊＝＜#；ｄz\n␃ζ\x15␄＜\x04ζ_！ｓ？\tＲυ８δ/␊A",
	}, { // 1424
		mask: EncodeLtGt | EncodeLeftCrLfHtVt,
		in:   "\n\n％␊＝<#；ｄz\n␃ζ\x15␄<\x04ζ_！ｓ？\tＲυ８δ/\x1c␊",
		out:  "␊\n％␊＝＜#；ｄz\n␃ζ\x15␄＜\x04ζ_！ｓ？\tＲυ８δ/\x1c␊",
	}, { // 1425
		mask: EncodeLtGt | EncodeLeftCrLfHtVt,
		in:   "\n␊％␊＝<#；ｄz\n␃ζ\x15␄<\x04ζ_！ｓ？\tＲυ８δ/\x1c␊",
		out:  "␊␊％␊＝＜#；ｄz\n␃ζ\x15␄＜\x04ζ_！ｓ？\tＲυ８δ/\x1c␊",
	}, { // 1426
		mask: EncodeLtGt | EncodeLeftCrLfHtVt,
		in:   "\nζ％␊＝<#；ｄz\n␃ζ\x15␄<\x04ζ_！ｓ？\tＲυ８δ/\nA",
		out:  "␊ζ％␊＝＜#；ｄz\n␃ζ\x15␄＜\x04ζ_！ｓ？\tＲυ８δ/\nA",
	}, { // 1427
		mask: EncodeLtGt | EncodeLeftCrLfHtVt,
		in:   "\nζ％␊＝<#；ｄz\n␃ζ\x15␄<\x04ζ_！ｓ？\tＲυ８δ/␊A",
		out:  "␊ζ％␊＝＜#；ｄz\n␃ζ\x15␄＜\x04ζ_！ｓ？\tＲυ８δ/␊A",
	}, { // 1428
		mask: EncodeLtGt | EncodeLeftCrLfHtVt,
		in:   "\nζ％␊＝<#；ｄz\n␃ζ\x15␄<\x04ζ_！ｓ？\tＲυ８δ/\n␊",
		out:  "␊ζ％␊＝＜#；ｄz\n␃ζ\x15␄＜\x04ζ_！ｓ？\tＲυ８δ/\n␊",
	}, { // 1429
		mask: EncodeLtGt | EncodeLeftCrLfHtVt,
		in:   "\nζ％␊＝<#；ｄz\n␃ζ\x15␄<\x04ζ_！ｓ？\tＲυ８δ/␊␊",
		out:  "␊ζ％␊＝＜#；ｄz\n␃ζ\x15␄＜\x04ζ_！ｓ？\tＲυ８δ/␊␊",
	}, { // 1430
		mask: EncodeLtGt | EncodeLeftCrLfHtVt,
		in:   "\nζ％␊＝<#；ｄz\n␃ζ\x15␄<\x04ζ_！ｓ？\tＲυ８δ/\x1c\n",
		out:  "␊ζ％␊＝＜#；ｄz\n␃ζ\x15␄＜\x04ζ_！ｓ？\tＲυ８δ/\x1c\n",
	}, { // 1431
		mask: EncodeLtGt | EncodeLeftCrLfHtVt,
		in:   "\nζ％␊＝<#；ｄz\n␃ζ\x15␄<\x04ζ_！ｓ？\tＲυ８δ/\x1c␊",
		out:  "␊ζ％␊＝＜#；ｄz\n␃ζ\x15␄＜\x04ζ_！ｓ？\tＲυ８δ/\x1c␊",
	}, { // 1432
		mask: EncodeLtGt | EncodeLeftCrLfHtVt,
		in:   "\u007f|8６)\x0f␊＄ｕ\v\v\x1dｖ␝␂)τθ8／;\x11␆τa＇σπ／θ",
		out:  "\u007f|8６)\x0f␊＄ｕ\v\v\x1dｖ␝␂)τθ8／;\x11␆τa＇σπ／θ",
	}, { // 1433
		mask: EncodeLtGt | EncodeLeftCrLfHtVt,
		in:   "\v␋8６)\x0f␊＄ｕ\v\v\x1dｖ␝␂)τθ8／;\x11␆τa＇σπ／θ",
		out:  "␋␋8６)\x0f␊＄ｕ\v\v\x1dｖ␝␂)τθ8／;\x11␆τa＇σπ／θ",
	}, { // 1434
		mask: EncodeLtGt | EncodeLeftCrLfHtVt,
		in:   "␋␋8６)\x0f␊＄ｕ\v\v\x1dｖ␝␂)τθ8／;\x11␆τa＇σπ／θ",
		out:  "‛␋␋8６)\x0f␊＄ｕ\v\v\x1dｖ␝␂)τθ8／;\x11␆τa＇σπ／θ",
	}, { // 1435
		mask: EncodeLtGt | EncodeLeftCrLfHtVt,
		in:   "\v|8６)\x0f␊＄ｕ\v\v\x1dｖ␝␂)τθ8／;\x11␆τa＇σπ␋θ",
		out:  "␋|8６)\x0f␊＄ｕ\v\v\x1dｖ␝␂)τθ8／;\x11␆τa＇σπ␋θ",
	}, { // 1436
		mask: EncodeLtGt | EncodeLeftCrLfHtVt,
		in:   "␋|8６)\x0f␊＄ｕ\v\v\x1dｖ␝␂)τθ8／;\x11␆τa＇σπ␋θ",
		out:  "‛␋|8６)\x0f␊＄ｕ\v\v\x1dｖ␝␂)τθ8／;\x11␆τa＇σπ␋θ",
	}, { // 1437
		mask: EncodeLtGt | EncodeLeftCrLfHtVt,
		in:   "\v|8６)\x0f␊＄ｕ\v\v\x1dｖ␝␂)τθ8／;\x11␆τa＇σπ／␋",
		out:  "␋|8６)\x0f␊＄ｕ\v\v\x1dｖ␝␂)τθ8／;\x11␆τa＇σπ／␋",
	}, { // 1438
		mask: EncodeLtGt | EncodeLeftCrLfHtVt,
		in:   "␋|8６)\x0f␊＄ｕ\v\v\x1dｖ␝␂)τθ8／;\x11␆τa＇σπ／␋",
		out:  "‛␋|8６)\x0f␊＄ｕ\v\v\x1dｖ␝␂)τθ8／;\x11␆τa＇σπ／␋",
	}, { // 1439
		mask: EncodeLtGt | EncodeLeftCrLfHtVt,
		in:   "\u007f\v8６)\x0f␊＄ｕ\v\v\x1dｖ␝␂)τθ8／;\x11␆τa＇σπ／θ",
		out:  "\u007f\v8６)\x0f␊＄ｕ\v\v\x1dｖ␝␂)τθ8／;\x11␆τa＇σπ／θ",
	}, { // 1440
		mask: EncodeLtGt | EncodeLeftCrLfHtVt,
		in:   "\u007f␋8６)\x0f␊＄ｕ\v\v\x1dｖ␝␂)τθ8／;\x11␆τa＇σπ／θ",
		out:  "\u007f␋8６)\x0f␊＄ｕ\v\v\x1dｖ␝␂)τθ8／;\x11␆τa＇σπ／θ",
	}, { // 1441
		mask: EncodeLtGt | EncodeLeftCrLfHtVt,
		in:   "\u007f\v8６)\x0f␊＄ｕ\v\v\x1dｖ␝␂)τθ8／;\x11␆τa＇σπ␋θ",
		out:  "\u007f\v8６)\x0f␊＄ｕ\v\v\x1dｖ␝␂)τθ8／;\x11␆τa＇σπ␋θ",
	}, { // 1442
		mask: EncodeLtGt | EncodeLeftCrLfHtVt,
		in:   "\u007f␋8６)\x0f␊＄ｕ\v\v\x1dｖ␝␂)τθ8／;\x11␆τa＇σπ␋θ",
		out:  "\u007f␋8６)\x0f␊＄ｕ\v\v\x1dｖ␝␂)τθ8／;\x11␆τa＇σπ␋θ",
	}, { // 1443
		mask: EncodeLtGt | EncodeLeftCrLfHtVt,
		in:   "\u007f\v8６)\x0f␊＄ｕ\v\v\x1dｖ␝␂)τθ8／;\x11␆τa＇σπ／␋",
		out:  "\u007f\v8６)\x0f␊＄ｕ\v\v\x1dｖ␝␂)τθ8／;\x11␆τa＇σπ／␋",
	}, { // 1444
		mask: EncodeLtGt | EncodeLeftCrLfHtVt,
		in:   "\u007f␋8６)\x0f␊＄ｕ\v\v\x1dｖ␝␂)τθ8／;\x11␆τa＇σπ／␋",
		out:  "\u007f␋8６)\x0f␊＄ｕ\v\v\x1dｖ␝␂)τθ8／;\x11␆τa＇σπ／␋",
	}, { // 1445
		mask: EncodeLtGt | EncodeLeftCrLfHtVt,
		in:   "\u007f|8６)\x0f␊＄ｕ\v\v\x1dｖ␝␂)τθ8／;\x11␆τa＇σπ\vθ",
		out:  "\u007f|8６)\x0f␊＄ｕ\v\v\x1dｖ␝␂)τθ8／;\x11␆τa＇σπ\vθ",
	}, { // 1446
		mask: EncodeLtGt | EncodeLeftCrLfHtVt,
		in:   "\u007f|8６)\x0f␊＄ｕ\v\v\x1dｖ␝␂)τθ8／;\x11␆τa＇σπ␋θ",
		out:  "\u007f|8６)\x0f␊＄ｕ\v\v\x1dｖ␝␂)τθ8／;\x11␆τa＇σπ␋θ",
	}, { // 1447
		mask: EncodeLtGt | EncodeLeftCrLfHtVt,
		in:   "\u007f|8６)\x0f␊＄ｕ\v\v\x1dｖ␝␂)τθ8／;\x11␆τa＇σπ\v␋",
		out:  "\u007f|8６)\x0f␊＄ｕ\v\v\x1dｖ␝␂)τθ8／;\x11␆τa＇σπ\v␋",
	}, { // 1448
		mask: EncodeLtGt | EncodeLeftCrLfHtVt,
		in:   "\u007f|8６)\x0f␊＄ｕ\v\v\x1dｖ␝␂)τθ8／;\x11␆τa＇σπ␋␋",
		out:  "\u007f|8６)\x0f␊＄ｕ\v\v\x1dｖ␝␂)τθ8／;\x11␆τa＇σπ␋␋",
	}, { // 1449
		mask: EncodeLtGt | EncodeLeftCrLfHtVt,
		in:   "\u007f|8６)\x0f␊＄ｕ\v\v\x1dｖ␝␂)τθ8／;\x11␆τa＇σπ／\v",
		out:  "\u007f|8６)\x0f␊＄ｕ\v\v\x1dｖ␝␂)τθ8／;\x11␆τa＇σπ／\v",
	}, { // 1450
		mask: EncodeLtGt | EncodeLeftCrLfHtVt,
		in:   "\u007f|8６)\x0f␊＄ｕ\v\v\x1dｖ␝␂)τθ8／;\x11␆τa＇σπ／␋",
		out:  "\u007f|8６)\x0f␊＄ｕ\v\v\x1dｖ␝␂)τθ8／;\x11␆τa＇σπ／␋",
	}, { // 1451
		mask: EncodeLtGt | EncodeLeftCrLfHtVt,
		in:   "\x1aς\x14␄λm\vξγ:\rξ＼S-␟␉：－L％(␞ｃＬk\x03\uff00/ε",
		out:  "\x1aς\x14␄λm\vξγ:\rξ＼S-␟␉：－L％(␞ｃＬk\x03\uff00/ε",
	}, { // 1452
		mask: EncodeLtGt | EncodeLeftCrLfHtVt,
		in:   "\r␍\x14␄λm\vξγ:\rξ＼S-␟␉：－L％(␞ｃＬk\x03\uff00/ε",
		out:  "␍␍\x14␄λm\vξγ:\rξ＼S-␟␉：－L％(␞ｃＬk\x03\uff00/ε",
	}, { // 1453
		mask: EncodeLtGt | EncodeLeftCrLfHtVt,
		in:   "␍␍\x14␄λm\vξγ:\rξ＼S-␟␉：－L％(␞ｃＬk\x03\uff00/ε",
		out:  "‛␍␍\x14␄λm\vξγ:\rξ＼S-␟␉：－L％(␞ｃＬk\x03\uff00/ε",
	}, { // 1454
		mask: EncodeLtGt | EncodeLeftCrLfHtVt,
		in:   "\rς\x14␄λm\vξγ:\rξ＼S-␟␉：－L％(␞ｃＬk\x03\uff00␍ε",
		out:  "␍ς\x14␄λm\vξγ:\rξ＼S-␟␉：－L％(␞ｃＬk\x03\uff00␍ε",
	}, { // 1455
		mask: EncodeLtGt | EncodeLeftCrLfHtVt,
		in:   "␍ς\x14␄λm\vξγ:\rξ＼S-␟␉：－L％(␞ｃＬk\x03\uff00␍ε",
		out:  "‛␍ς\x14␄λm\vξγ:\rξ＼S-␟␉：－L％(␞ｃＬk\x03\uff00␍ε",
	}, { // 1456
		mask: EncodeLtGt | EncodeLeftCrLfHtVt,
		in:   "\rς\x14␄λm\vξγ:\rξ＼S-␟␉：－L％(␞ｃＬk\x03\uff00/␍",
		out:  "␍ς\x14␄λm\vξγ:\rξ＼S-␟␉：－L％(␞ｃＬk\x03\uff00/␍",
	}, { // 1457
		mask: EncodeLtGt | EncodeLeftCrLfHtVt,
		in:   "␍ς\x14␄λm\vξγ:\rξ＼S-␟␉：－L％(␞ｃＬk\x03\uff00/␍",
		out:  "‛␍ς\x14␄λm\vξγ:\rξ＼S-␟␉：－L％(␞ｃＬk\x03\uff00/␍",
	}, { // 1458
		mask: EncodeLtGt | EncodeLeftCrLfHtVt,
		in:   "\x1a\r\x14␄λm\vξγ:\rξ＼S-␟␉：－L％(␞ｃＬk\x03\uff00/ε",
		out:  "\x1a\r\x14␄λm\vξγ:\rξ＼S-␟␉：－L％(␞ｃＬk\x03\uff00/ε",
	}, { // 1459
		mask: EncodeLtGt | EncodeLeftCrLfHtVt,
		in:   "\x1a␍\x14␄λm\vξγ:\rξ＼S-␟␉：－L％(␞ｃＬk\x03\uff00/ε",
		out:  "\x1a␍\x14␄λm\vξγ:\rξ＼S-␟␉：－L％(␞ｃＬk\x03\uff00/ε",
	}, { // 1460
		mask: EncodeLtGt | EncodeLeftCrLfHtVt,
		in:   "\x1a\r\x14␄λm\vξγ:\rξ＼S-␟␉：－L％(␞ｃＬk\x03\uff00␍ε",
		out:  "\x1a\r\x14␄λm\vξγ:\rξ＼S-␟␉：－L％(␞ｃＬk\x03\uff00␍ε",
	}, { // 1461
		mask: EncodeLtGt | EncodeLeftCrLfHtVt,
		in:   "\x1a␍\x14␄λm\vξγ:\rξ＼S-␟␉：－L％(␞ｃＬk\x03\uff00␍ε",
		out:  "\x1a␍\x14␄λm\vξγ:\rξ＼S-␟␉：－L％(␞ｃＬk\x03\uff00␍ε",
	}, { // 1462
		mask: EncodeLtGt | EncodeLeftCrLfHtVt,
		in:   "\x1a\r\x14␄λm\vξγ:\rξ＼S-␟␉：－L％(␞ｃＬk\x03\uff00/␍",
		out:  "\x1a\r\x14␄λm\vξγ:\rξ＼S-␟␉：－L％(␞ｃＬk\x03\uff00/␍",
	}, { // 1463
		mask: EncodeLtGt | EncodeLeftCrLfHtVt,
		in:   "\x1a␍\x14␄λm\vξγ:\rξ＼S-␟␉：－L％(␞ｃＬk\x03\uff00/␍",
		out:  "\x1a␍\x14␄λm\vξγ:\rξ＼S-␟␉：－L％(␞ｃＬk\x03\uff00/␍",
	}, { // 1464
		mask: EncodeLtGt | EncodeLeftCrLfHtVt,
		in:   "\x1aς\x14␄λm\vξγ:\rξ＼S-␟␉：－L％(␞ｃＬk\x03\uff00\rε",
		out:  "\x1aς\x14␄λm\vξγ:\rξ＼S-␟␉：－L％(␞ｃＬk\x03\uff00\rε",
	}, { // 1465
		mask: EncodeLtGt | EncodeLeftCrLfHtVt,
		in:   "\x1aς\x14␄λm\vξγ:\rξ＼S-␟␉：－L％(␞ｃＬk\x03\uff00␍ε",
		out:  "\x1aς\x14␄λm\vξγ:\rξ＼S-␟␉：－L％(␞ｃＬk\x03\uff00␍ε",
	}, { // 1466
		mask: EncodeLtGt | EncodeLeftCrLfHtVt,
		in:   "\x1aς\x14␄λm\vξγ:\rξ＼S-␟␉：－L％(␞ｃＬk\x03\uff00\r␍",
		out:  "\x1aς\x14␄λm\vξγ:\rξ＼S-␟␉：－L％(␞ｃＬk\x03\uff00\r␍",
	}, { // 1467
		mask: EncodeLtGt | EncodeLeftCrLfHtVt,
		in:   "\x1aς\x14␄λm\vξγ:\rξ＼S-␟␉：－L％(␞ｃＬk\x03\uff00␍␍",
		out:  "\x1aς\x14␄λm\vξγ:\rξ＼S-␟␉：－L％(␞ｃＬk\x03\uff00␍␍",
	}, { // 1468
		mask: EncodeLtGt | EncodeLeftCrLfHtVt,
		in:   "\x1aς\x14␄λm\vξγ:\rξ＼S-␟␉：－L％(␞ｃＬk\x03\uff00/\r",
		out:  "\x1aς\x14␄λm\vξγ:\rξ＼S-␟␉：－L％(␞ｃＬk\x03\uff00/\r",
	}, { // 1469
		mask: EncodeLtGt | EncodeLeftCrLfHtVt,
		in:   "\x1aς\x14␄λm\vξγ:\rξ＼S-␟␉：－L％(␞ｃＬk\x03\uff00/␍",
		out:  "\x1aς\x14␄λm\vξγ:\rξ＼S-␟␉：－L％(␞ｃＬk\x03\uff00/␍",
	}, { // 1470
		mask: EncodeSquareBracket | EncodeLeftCrLfHtVt,
		in:   "6ｗ␖ξJ7μ［\x05Ｐ\t*λ-m\a␚␝Ｅｆ\x0f␖φ4τ\x13\x1cｋ␍／",
		out:  "6ｗ␖ξJ7μ‛［\x05Ｐ\t*λ-m\a␚␝Ｅｆ\x0f␖φ4τ\x13\x1cｋ␍／",
	}, { // 1471
		mask: EncodeSquareBracket | EncodeLeftCrLfHtVt,
		in:   "\t␉␖ξJ7μ［\x05Ｐ\t*λ-m\a␚␝Ｅｆ\x0f␖φ4τ\x13\x1cｋ␍／",
		out:  "␉␉␖ξJ7μ‛［\x05Ｐ\t*λ-m\a␚␝Ｅｆ\x0f␖φ4τ\x13\x1cｋ␍／",
	}, { // 1472
		mask: EncodeSquareBracket | EncodeLeftCrLfHtVt,
		in:   "␉␉␖ξJ7μ［\x05Ｐ\t*λ-m\a␚␝Ｅｆ\x0f␖φ4τ\x13\x1cｋ␍／",
		out:  "‛␉␉␖ξJ7μ‛［\x05Ｐ\t*λ-m\a␚␝Ｅｆ\x0f␖φ4τ\x13\x1cｋ␍／",
	}, { // 1473
		mask: EncodeSquareBracket | EncodeLeftCrLfHtVt,
		in:   "\tｗ␖ξJ7μ［\x05Ｐ\t*λ-m\a␚␝Ｅｆ\x0f␖φ4τ\x13\x1cｋ␉／",
		out:  "␉ｗ␖ξJ7μ‛［\x05Ｐ\t*λ-m\a␚␝Ｅｆ\x0f␖φ4τ\x13\x1cｋ␉／",
	}, { // 1474
		mask: EncodeSquareBracket | EncodeLeftCrLfHtVt,
		in:   "␉ｗ␖ξJ7μ［\x05Ｐ\t*λ-m\a␚␝Ｅｆ\x0f␖φ4τ\x13\x1cｋ␉／",
		out:  "‛␉ｗ␖ξJ7μ‛［\x05Ｐ\t*λ-m\a␚␝Ｅｆ\x0f␖φ4τ\x13\x1cｋ␉／",
	}, { // 1475
		mask: EncodeSquareBracket | EncodeLeftCrLfHtVt,
		in:   "\tｗ␖ξJ7μ［\x05Ｐ\t*λ-m\a␚␝Ｅｆ\x0f␖φ4τ\x13\x1cｋ␍␉",
		out:  "␉ｗ␖ξJ7μ‛［\x05Ｐ\t*λ-m\a␚␝Ｅｆ\x0f␖φ4τ\x13\x1cｋ␍␉",
	}, { // 1476
		mask: EncodeSquareBracket | EncodeLeftCrLfHtVt,
		in:   "␉ｗ␖ξJ7μ［\x05Ｐ\t*λ-m\a␚␝Ｅｆ\x0f␖φ4τ\x13\x1cｋ␍␉",
		out:  "‛␉ｗ␖ξJ7μ‛［\x05Ｐ\t*λ-m\a␚␝Ｅｆ\x0f␖φ4τ\x13\x1cｋ␍␉",
	}, { // 1477
		mask: EncodeSquareBracket | EncodeLeftCrLfHtVt,
		in:   "6\t␖ξJ7μ［\x05Ｐ\t*λ-m\a␚␝Ｅｆ\x0f␖φ4τ\x13\x1cｋ␍／",
		out:  "6\t␖ξJ7μ‛［\x05Ｐ\t*λ-m\a␚␝Ｅｆ\x0f␖φ4τ\x13\x1cｋ␍／",
	}, { // 1478
		mask: EncodeSquareBracket | EncodeLeftCrLfHtVt,
		in:   "6␉␖ξJ7μ［\x05Ｐ\t*λ-m\a␚␝Ｅｆ\x0f␖φ4τ\x13\x1cｋ␍／",
		out:  "6␉␖ξJ7μ‛［\x05Ｐ\t*λ-m\a␚␝Ｅｆ\x0f␖φ4τ\x13\x1cｋ␍／",
	}, { // 1479
		mask: EncodeSquareBracket | EncodeLeftCrLfHtVt,
		in:   "6\t␖ξJ7μ［\x05Ｐ\t*λ-m\a␚␝Ｅｆ\x0f␖φ4τ\x13\x1cｋ␉／",
		out:  "6\t␖ξJ7μ‛［\x05Ｐ\t*λ-m\a␚␝Ｅｆ\x0f␖φ4τ\x13\x1cｋ␉／",
	}, { // 1480
		mask: EncodeSquareBracket | EncodeLeftCrLfHtVt,
		in:   "6␉␖ξJ7μ［\x05Ｐ\t*λ-m\a␚␝Ｅｆ\x0f␖φ4τ\x13\x1cｋ␉／",
		out:  "6␉␖ξJ7μ‛［\x05Ｐ\t*λ-m\a␚␝Ｅｆ\x0f␖φ4τ\x13\x1cｋ␉／",
	}, { // 1481
		mask: EncodeSquareBracket | EncodeLeftCrLfHtVt,
		in:   "6\t␖ξJ7μ［\x05Ｐ\t*λ-m\a␚␝Ｅｆ\x0f␖φ4τ\x13\x1cｋ␍␉",
		out:  "6\t␖ξJ7μ‛［\x05Ｐ\t*λ-m\a␚␝Ｅｆ\x0f␖φ4τ\x13\x1cｋ␍␉",
	}, { // 1482
		mask: EncodeSquareBracket | EncodeLeftCrLfHtVt,
		in:   "6␉␖ξJ7μ［\x05Ｐ\t*λ-m\a␚␝Ｅｆ\x0f␖φ4τ\x13\x1cｋ␍␉",
		out:  "6␉␖ξJ7μ‛［\x05Ｐ\t*λ-m\a␚␝Ｅｆ\x0f␖φ4τ\x13\x1cｋ␍␉",
	}, { // 1483
		mask: EncodeSquareBracket | EncodeLeftCrLfHtVt,
		in:   "6ｗ␖ξJ7μ［\x05Ｐ\t*λ-m\a␚␝Ｅｆ\x0f␖φ4τ\x13\x1cｋ\t／",
		out:  "6ｗ␖ξJ7μ‛［\x05Ｐ\t*λ-m\a␚␝Ｅｆ\x0f␖φ4τ\x13\x1cｋ\t／",
	}, { // 1484
		mask: EncodeSquareBracket | EncodeLeftCrLfHtVt,
		in:   "6ｗ␖ξJ7μ［\x05Ｐ\t*λ-m\a␚␝Ｅｆ\x0f␖φ4τ\x13\x1cｋ␉／",
		out:  "6ｗ␖ξJ7μ‛［\x05Ｐ\t*λ-m\a␚␝Ｅｆ\x0f␖φ4τ\x13\x1cｋ␉／",
	}, { // 1485
		mask: EncodeSquareBracket | EncodeLeftCrLfHtVt,
		in:   "6ｗ␖ξJ7μ［\x05Ｐ\t*λ-m\a␚␝Ｅｆ\x0f␖φ4τ\x13\x1cｋ\t␉",
		out:  "6ｗ␖ξJ7μ‛［\x05Ｐ\t*λ-m\a␚␝Ｅｆ\x0f␖φ4τ\x13\x1cｋ\t␉",
	}, { // 1486
		mask: EncodeSquareBracket | EncodeLeftCrLfHtVt,
		in:   "6ｗ␖ξJ7μ［\x05Ｐ\t*λ-m\a␚␝Ｅｆ\x0f␖φ4τ\x13\x1cｋ␉␉",
		out:  "6ｗ␖ξJ7μ‛［\x05Ｐ\t*λ-m\a␚␝Ｅｆ\x0f␖φ4τ\x13\x1cｋ␉␉",
	}, { // 1487
		mask: EncodeSquareBracket | EncodeLeftCrLfHtVt,
		in:   "6ｗ␖ξJ7μ［\x05Ｐ\t*λ-m\a␚␝Ｅｆ\x0f␖φ4τ\x13\x1cｋ␍\t",
		out:  "6ｗ␖ξJ7μ‛［\x05Ｐ\t*λ-m\a␚␝Ｅｆ\x0f␖φ4τ\x13\x1cｋ␍\t",
	}, { // 1488
		mask: EncodeSquareBracket | EncodeLeftCrLfHtVt,
		in:   "6ｗ␖ξJ7μ［\x05Ｐ\t*λ-m\a␚␝Ｅｆ\x0f␖φ4τ\x13\x1cｋ␍␉",
		out:  "6ｗ␖ξJ7μ‛［\x05Ｐ\t*λ-m\a␚␝Ｅｆ\x0f␖φ4τ\x13\x1cｋ␍␉",
	}, { // 1489
		mask: EncodeSquareBracket | EncodeLeftCrLfHtVt,
		in:   "␒｀ιφ6Gπ&？5\n\x1c␆，␔κ\"＇／\a\x0forψｇ４;␕\x11τ",
		out:  "␒｀ιφ6Gπ&？5\n\x1c␆，␔κ\"＇／\a\x0forψｇ４;␕\x11τ",
	}, { // 1490
		mask: EncodeSquareBracket | EncodeLeftCrLfHtVt,
		in:   "\n␊ιφ6Gπ&？5\n\x1c␆，␔κ\"＇／\a\x0forψｇ４;␕\x11τ",
		out:  "␊␊ιφ6Gπ&？5\n\x1c␆，␔κ\"＇／\a\x0forψｇ４;␕\x11τ",
	}, { // 1491
		mask: EncodeSquareBracket | EncodeLeftCrLfHtVt,
		in:   "␊␊ιφ6Gπ&？5\n\x1c␆，␔κ\"＇／\a\x0forψｇ４;␕\x11τ",
		out:  "‛␊␊ιφ6Gπ&？5\n\x1c␆，␔κ\"＇／\a\x0forψｇ４;␕\x11τ",
	}, { // 1492
		mask: EncodeSquareBracket | EncodeLeftCrLfHtVt,
		in:   "\n｀ιφ6Gπ&？5\n\x1c␆，␔κ\"＇／\a\x0forψｇ４;␕␊τ",
		out:  "␊｀ιφ6Gπ&？5\n\x1c␆，␔κ\"＇／\a\x0forψｇ４;␕␊τ",
	}, { // 1493
		mask: EncodeSquareBracket | EncodeLeftCrLfHtVt,
		in:   "␊｀ιφ6Gπ&？5\n\x1c␆，␔κ\"＇／\a\x0forψｇ４;␕␊τ",
		out:  "‛␊｀ιφ6Gπ&？5\n\x1c␆，␔κ\"＇／\a\x0forψｇ４;␕␊τ",
	}, { // 1494
		mask: EncodeSquareBracket | EncodeLeftCrLfHtVt,
		in:   "\n｀ιφ6Gπ&？5\n\x1c␆，␔κ\"＇／\a\x0forψｇ４;␕\x11␊",
		out:  "␊｀ιφ6Gπ&？5\n\x1c␆，␔κ\"＇／\a\x0forψｇ４;␕\x11␊",
	}, { // 1495
		mask: EncodeSquareBracket | EncodeLeftCrLfHtVt,
		in:   "␊｀ιφ6Gπ&？5\n\x1c␆，␔κ\"＇／\a\x0forψｇ４;␕\x11␊",
		out:  "‛␊｀ιφ6Gπ&？5\n\x1c␆，␔κ\"＇／\a\x0forψｇ４;␕\x11␊",
	}, { // 1496
		mask: EncodeSquareBracket | EncodeLeftCrLfHtVt,
		in:   "␒\nιφ6Gπ&？5\n\x1c␆，␔κ\"＇／\a\x0forψｇ４;␕\x11τ",
		out:  "␒\nιφ6Gπ&？5\n\x1c␆，␔κ\"＇／\a\x0forψｇ４;␕\x11τ",
	}, { // 1497
		mask: EncodeSquareBracket | EncodeLeftCrLfHtVt,
		in:   "␒␊ιφ6Gπ&？5\n\x1c␆，␔κ\"＇／\a\x0forψｇ４;␕\x11τ",
		out:  "␒␊ιφ6Gπ&？5\n\x1c␆，␔κ\"＇／\a\x0forψｇ４;␕\x11τ",
	}, { // 1498
		mask: EncodeSquareBracket | EncodeLeftCrLfHtVt,
		in:   "␒\nιφ6Gπ&？5\n\x1c␆，␔κ\"＇／\a\x0forψｇ４;␕␊τ",
		out:  "␒\nιφ6Gπ&？5\n\x1c␆，␔κ\"＇／\a\x0forψｇ４;␕␊τ",
	}, { // 1499
		mask: EncodeSquareBracket | EncodeLeftCrLfHtVt,
		in:   "␒␊ιφ6Gπ&？5\n\x1c␆，␔κ\"＇／\a\x0forψｇ４;␕␊τ",
		out:  "␒␊ιφ6Gπ&？5\n\x1c␆，␔κ\"＇／\a\x0forψｇ４;␕␊τ",
	}, { // 1500
		mask: EncodeSquareBracket | EncodeLeftCrLfHtVt,
		in:   "␒\nιφ6Gπ&？5\n\x1c␆，␔κ\"＇／\a\x0forψｇ４;␕\x11␊",
		out:  "␒\nιφ6Gπ&？5\n\x1c␆，␔κ\"＇／\a\x0forψｇ４;␕\x11␊",
	}, { // 1501
		mask: EncodeSquareBracket | EncodeLeftCrLfHtVt,
		in:   "␒␊ιφ6Gπ&？5\n\x1c␆，␔κ\"＇／\a\x0forψｇ４;␕\x11␊",
		out:  "␒␊ιφ6Gπ&？5\n\x1c␆，␔κ\"＇／\a\x0forψｇ４;␕\x11␊",
	}, { // 1502
		mask: EncodeSquareBracket | EncodeLeftCrLfHtVt,
		in:   "␒｀ιφ6Gπ&？5\n\x1c␆，␔κ\"＇／\a\x0forψｇ４;␕\nτ",
		out:  "␒｀ιφ6Gπ&？5\n\x1c␆，␔κ\"＇／\a\x0forψｇ４;␕\nτ",
	}, { // 1503
		mask: EncodeSquareBracket | EncodeLeftCrLfHtVt,
		in:   "␒｀ιφ6Gπ&？5\n\x1c␆，␔κ\"＇／\a\x0forψｇ４;␕␊τ",
		out:  "␒｀ιφ6Gπ&？5\n\x1c␆，␔κ\"＇／\a\x0forψｇ４;␕␊τ",
	}, { // 1504
		mask: EncodeSquareBracket | EncodeLeftCrLfHtVt,
		in:   "␒｀ιφ6Gπ&？5\n\x1c␆，␔κ\"＇／\a\x0forψｇ４;␕\n␊",
		out:  "␒｀ιφ6Gπ&？5\n\x1c␆，␔κ\"＇／\a\x0forψｇ４;␕\n␊",
	}, { // 1505
		mask: EncodeSquareBracket | EncodeLeftCrLfHtVt,
		in:   "␒｀ιφ6Gπ&？5\n\x1c␆，␔κ\"＇／\a\x0forψｇ４;␕␊␊",
		out:  "␒｀ιφ6Gπ&？5\n\x1c␆，␔κ\"＇／\a\x0forψｇ４;␕␊␊",
	}, { // 1506
		mask: EncodeSquareBracket | EncodeLeftCrLfHtVt,
		in:   "␒｀ιφ6Gπ&？5\n\x1c␆，␔κ\"＇／\a\x0forψｇ４;␕\x11\n",
		out:  "␒｀ιφ6Gπ&？5\n\x1c␆，␔κ\"＇／\a\x0forψｇ４;␕\x11\n",
	}, { // 1507
		mask: EncodeSquareBracket | EncodeLeftCrLfHtVt,
		in:   "␒｀ιφ6Gπ&？5\n\x1c␆，␔κ\"＇／\a\x0forψｇ４;␕\x11␊",
		out:  "␒｀ιφ6Gπ&？5\n\x1c␆，␔κ\"＇／\a\x0forψｇ４;␕\x11␊",
	}, { // 1508
		mask: EncodeSquareBracket | EncodeLeftCrLfHtVt,
		in:   "οＣ\r\uff00π．/［ε\x15\vXpmＥＭσ\x16\v\rτβ␑^␕＼M␌；\x1c",
		out:  "οＣ\r\uff00π．/‛［ε\x15\vXpmＥＭσ\x16\v\rτβ␑^␕＼M␌；\x1c",
	}, { // 1509
		mask: EncodeSquareBracket | EncodeLeftCrLfHtVt,
		in:   "\v␋\r\uff00π．/［ε\x15\vXpmＥＭσ\x16\v\rτβ␑^␕＼M␌；\x1c",
		out:  "␋␋\r\uff00π．/‛［ε\x15\vXpmＥＭσ\x16\v\rτβ␑^␕＼M␌；\x1c",
	}, { // 1510
		mask: EncodeSquareBracket | EncodeLeftCrLfHtVt,
		in:   "␋␋\r\uff00π．/［ε\x15\vXpmＥＭσ\x16\v\rτβ␑^␕＼M␌；\x1c",
		out:  "‛␋␋\r\uff00π．/‛［ε\x15\vXpmＥＭσ\x16\v\rτβ␑^␕＼M␌；\x1c",
	}, { // 1511
		mask: EncodeSquareBracket | EncodeLeftCrLfHtVt,
		in:   "\vＣ\r\uff00π．/［ε\x15\vXpmＥＭσ\x16\v\rτβ␑^␕＼M␌␋\x1c",
		out:  "␋Ｃ\r\uff00π．/‛［ε\x15\vXpmＥＭσ\x16\v\rτβ␑^␕＼M␌␋\x1c",
	}, { // 1512
		mask: EncodeSquareBracket | EncodeLeftCrLfHtVt,
		in:   "␋Ｃ\r\uff00π．/［ε\x15\vXpmＥＭσ\x16\v\rτβ␑^␕＼M␌␋\x1c",
		out:  "‛␋Ｃ\r\uff00π．/‛［ε\x15\vXpmＥＭσ\x16\v\rτβ␑^␕＼M␌␋\x1c",
	}, { // 1513
		mask: EncodeSquareBracket | EncodeLeftCrLfHtVt,
		in:   "\vＣ\r\uff00π．/［ε\x15\vXpmＥＭσ\x16\v\rτβ␑^␕＼M␌；␋",
		out:  "␋Ｃ\r\uff00π．/‛［ε\x15\vXpmＥＭσ\x16\v\rτβ␑^␕＼M␌；␋",
	}, { // 1514
		mask: EncodeSquareBracket | EncodeLeftCrLfHtVt,
		in:   "␋Ｃ\r\uff00π．/［ε\x15\vXpmＥＭσ\x16\v\rτβ␑^␕＼M␌；␋",
		out:  "‛␋Ｃ\r\uff00π．/‛［ε\x15\vXpmＥＭσ\x16\v\rτβ␑^␕＼M␌；␋",
	}, { // 1515
		mask: EncodeSquareBracket | EncodeLeftCrLfHtVt,
		in:   "ο\v\r\uff00π．/［ε\x15\vXpmＥＭσ\x16\v\rτβ␑^␕＼M␌；\x1c",
		out:  "ο\v\r\uff00π．/‛［ε\x15\vXpmＥＭσ\x16\v\rτβ␑^␕＼M␌；\x1c",
	}, { // 1516
		mask: EncodeSquareBracket | EncodeLeftCrLfHtVt,
		in:   "ο␋\r\uff00π．/［ε\x15\vXpmＥＭσ\x16\v\rτβ␑^␕＼M␌；\x1c",
		out:  "ο␋\r\uff00π．/‛［ε\x15\vXpmＥＭσ\x16\v\rτβ␑^␕＼M␌；\x1c",
	}, { // 1517
		mask: EncodeSquareBracket | EncodeLeftCrLfHtVt,
		in:   "ο\v\r\uff00π．/［ε\x15\vXpmＥＭσ\x16\v\rτβ␑^␕＼M␌␋\x1c",
		out:  "ο\v\r\uff00π．/‛［ε\x15\vXpmＥＭσ\x16\v\rτβ␑^␕＼M␌␋\x1c",
	}, { // 1518
		mask: EncodeSquareBracket | EncodeLeftCrLfHtVt,
		in:   "ο␋\r\uff00π．/［ε\x15\vXpmＥＭσ\x16\v\rτβ␑^␕＼M␌␋\x1c",
		out:  "ο␋\r\uff00π．/‛［ε\x15\vXpmＥＭσ\x16\v\rτβ␑^␕＼M␌␋\x1c",
	}, { // 1519
		mask: EncodeSquareBracket | EncodeLeftCrLfHtVt,
		in:   "ο\v\r\uff00π．/［ε\x15\vXpmＥＭσ\x16\v\rτβ␑^␕＼M␌；␋",
		out:  "ο\v\r\uff00π．/‛［ε\x15\vXpmＥＭσ\x16\v\rτβ␑^␕＼M␌；␋",
	}, { // 1520
		mask: EncodeSquareBracket | EncodeLeftCrLfHtVt,
		in:   "ο␋\r\uff00π．/［ε\x15\vXpmＥＭσ\x16\v\rτβ␑^␕＼M␌；␋",
		out:  "ο␋\r\uff00π．/‛［ε\x15\vXpmＥＭσ\x16\v\rτβ␑^␕＼M␌；␋",
	}, { // 1521
		mask: EncodeSquareBracket | EncodeLeftCrLfHtVt,
		in:   "οＣ\r\uff00π．/［ε\x15\vXpmＥＭσ\x16\v\rτβ␑^␕＼M␌\v\x1c",
		out:  "οＣ\r\uff00π．/‛［ε\x15\vXpmＥＭσ\x16\v\rτβ␑^␕＼M␌\v\x1c",
	}, { // 1522
		mask: EncodeSquareBracket | EncodeLeftCrLfHtVt,
		in:   "οＣ\r\uff00π．/［ε\x15\vXpmＥＭσ\x16\v\rτβ␑^␕＼M␌␋\x1c",
		out:  "οＣ\r\uff00π．/‛［ε\x15\vXpmＥＭσ\x16\v\rτβ␑^␕＼M␌␋\x1c",
	}, { // 1523
		mask: EncodeSquareBracket | EncodeLeftCrLfHtVt,
		in:   "οＣ\r\uff00π．/［ε\x15\vXpmＥＭσ\x16\v\rτβ␑^␕＼M␌\v␋",
		out:  "οＣ\r\uff00π．/‛［ε\x15\vXpmＥＭσ\x16\v\rτβ␑^␕＼M␌\v␋",
	}, { // 1524
		mask: EncodeSquareBracket | EncodeLeftCrLfHtVt,
		in:   "οＣ\r\uff00π．/［ε\x15\vXpmＥＭσ\x16\v\rτβ␑^␕＼M␌␋␋",
		out:  "οＣ\r\uff00π．/‛［ε\x15\vXpmＥＭσ\x16\v\rτβ␑^␕＼M␌␋␋",
	}, { // 1525
		mask: EncodeSquareBracket | EncodeLeftCrLfHtVt,
		in:   "οＣ\r\uff00π．/［ε\x15\vXpmＥＭσ\x16\v\rτβ␑^␕＼M␌；\v",
		out:  "οＣ\r\uff00π．/‛［ε\x15\vXpmＥＭσ\x16\v\rτβ␑^␕＼M␌；\v",
	}, { // 1526
		mask: EncodeSquareBracket | EncodeLeftCrLfHtVt,
		in:   "οＣ\r\uff00π．/［ε\x15\vXpmＥＭσ\x16\v\rτβ␑^␕＼M␌；␋",
		out:  "οＣ\r\uff00π．/‛［ε\x15\vXpmＥＭσ\x16\v\rτβ␑^␕＼M␌；␋",
	}, { // 1527
		mask: EncodeSquareBracket | EncodeLeftCrLfHtVt,
		in:   "␐+uν\x10φＣο␐ｖ\r\x14？Ｊυｚ\x12␊␝\x03ｖＫ：:\x00wπγs\x00",
		out:  "␐+uν\x10φＣο␐ｖ\r\x14？Ｊυｚ\x12␊␝\x03ｖＫ：:␀wπγs␀",
	}, { // 1528
		mask: EncodeSquareBracket | EncodeLeftCrLfHtVt,
		in:   "\r␍uν\x10φＣο␐ｖ\r\x14？Ｊυｚ\x12␊␝\x03ｖＫ：:\x00wπγs\x00",
		out:  "␍␍uν\x10φＣο␐ｖ\r\x14？Ｊυｚ\x12␊␝\x03ｖＫ：:␀wπγs␀",
	}, { // 1529
		mask: EncodeSquareBracket | EncodeLeftCrLfHtVt,
		in:   "␍␍uν\x10φＣο␐ｖ\r\x14？Ｊυｚ\x12␊␝\x03ｖＫ：:\x00wπγs\x00",
		out:  "‛␍␍uν\x10φＣο␐ｖ\r\x14？Ｊυｚ\x12␊␝\x03ｖＫ：:␀wπγs␀",
	}, { // 1530
		mask: EncodeSquareBracket | EncodeLeftCrLfHtVt,
		in:   "\r+uν\x10φＣο␐ｖ\r\x14？Ｊυｚ\x12␊␝\x03ｖＫ：:\x00wπγ␍\x00",
		out:  "␍+uν\x10φＣο␐ｖ\r\x14？Ｊυｚ\x12␊␝\x03ｖＫ：:␀wπγ␍␀",
	}, { // 1531
		mask: EncodeSquareBracket | EncodeLeftCrLfHtVt,
		in:   "␍+uν\x10φＣο␐ｖ\r\x14？Ｊυｚ\x12␊␝\x03ｖＫ：:\x00wπγ␍\x00",
		out:  "‛␍+uν\x10φＣο␐ｖ\r\x14？Ｊυｚ\x12␊␝\x03ｖＫ：:␀wπγ␍␀",
	}, { // 1532
		mask: EncodeSquareBracket | EncodeLeftCrLfHtVt,
		in:   "\r+uν\x10φＣο␐ｖ\r\x14？Ｊυｚ\x12␊␝\x03ｖＫ：:\x00wπγs␍",
		out:  "␍+uν\x10φＣο␐ｖ\r\x14？Ｊυｚ\x12␊␝\x03ｖＫ：:␀wπγs␍",
	}, { // 1533
		mask: EncodeSquareBracket | EncodeLeftCrLfHtVt,
		in:   "␍+uν\x10φＣο␐ｖ\r\x14？Ｊυｚ\x12␊␝\x03ｖＫ：:\x00wπγs␍",
		out:  "‛␍+uν\x10φＣο␐ｖ\r\x14？Ｊυｚ\x12␊␝\x03ｖＫ：:␀wπγs␍",
	}, { // 1534
		mask: EncodeSquareBracket | EncodeLeftCrLfHtVt,
		in:   "␐\ruν\x10φＣο␐ｖ\r\x14？Ｊυｚ\x12␊␝\x03ｖＫ：:\x00wπγs\x00",
		out:  "␐\ruν\x10φＣο␐ｖ\r\x14？Ｊυｚ\x12␊␝\x03ｖＫ：:␀wπγs␀",
	}, { // 1535
		mask: EncodeSquareBracket | EncodeLeftCrLfHtVt,
		in:   "␐␍uν\x10φＣο␐ｖ\r\x14？Ｊυｚ\x12␊␝\x03ｖＫ：:\x00wπγs\x00",
		out:  "␐␍uν\x10φＣο␐ｖ\r\x14？Ｊυｚ\x12␊␝\x03ｖＫ：:␀wπγs␀",
	}, { // 1536
		mask: EncodeSquareBracket | EncodeLeftCrLfHtVt,
		in:   "␐\ruν\x10φＣο␐ｖ\r\x14？Ｊυｚ\x12␊␝\x03ｖＫ：:\x00wπγ␍\x00",
		out:  "␐\ruν\x10φＣο␐ｖ\r\x14？Ｊυｚ\x12␊␝\x03ｖＫ：:␀wπγ␍␀",
	}, { // 1537
		mask: EncodeSquareBracket | EncodeLeftCrLfHtVt,
		in:   "␐␍uν\x10φＣο␐ｖ\r\x14？Ｊυｚ\x12␊␝\x03ｖＫ：:\x00wπγ␍\x00",
		out:  "␐␍uν\x10φＣο␐ｖ\r\x14？Ｊυｚ\x12␊␝\x03ｖＫ：:␀wπγ␍␀",
	}, { // 1538
		mask: EncodeSquareBracket | EncodeLeftCrLfHtVt,
		in:   "␐\ruν\x10φＣο␐ｖ\r\x14？Ｊυｚ\x12␊␝\x03ｖＫ：:\x00wπγs␍",
		out:  "␐\ruν\x10φＣο␐ｖ\r\x14？Ｊυｚ\x12␊␝\x03ｖＫ：:␀wπγs␍",
	}, { // 1539
		mask: EncodeSquareBracket | EncodeLeftCrLfHtVt,
		in:   "␐␍uν\x10φＣο␐ｖ\r\x14？Ｊυｚ\x12␊␝\x03ｖＫ：:\x00wπγs␍",
		out:  "␐␍uν\x10φＣο␐ｖ\r\x14？Ｊυｚ\x12␊␝\x03ｖＫ：:␀wπγs␍",
	}, { // 1540
		mask: EncodeSquareBracket | EncodeLeftCrLfHtVt,
		in:   "␐+uν\x10φＣο␐ｖ\r\x14？Ｊυｚ\x12␊␝\x03ｖＫ：:\x00wπγ\r\x00",
		out:  "␐+uν\x10φＣο␐ｖ\r\x14？Ｊυｚ\x12␊␝\x03ｖＫ：:␀wπγ\r␀",
	}, { // 1541
		mask: EncodeSquareBracket | EncodeLeftCrLfHtVt,
		in:   "␐+uν\x10φＣο␐ｖ\r\x14？Ｊυｚ\x12␊␝\x03ｖＫ：:\x00wπγ␍\x00",
		out:  "␐+uν\x10φＣο␐ｖ\r\x14？Ｊυｚ\x12␊␝\x03ｖＫ：:␀wπγ␍␀",
	}, { // 1542
		mask: EncodeSquareBracket | EncodeLeftCrLfHtVt,
		in:   "␐+uν\x10φＣο␐ｖ\r\x14？Ｊυｚ\x12␊␝\x03ｖＫ：:\x00wπγ\r␍",
		out:  "␐+uν\x10φＣο␐ｖ\r\x14？Ｊυｚ\x12␊␝\x03ｖＫ：:␀wπγ\r␍",
	}, { // 1543
		mask: EncodeSquareBracket | EncodeLeftCrLfHtVt,
		in:   "␐+uν\x10φＣο␐ｖ\r\x14？Ｊυｚ\x12␊␝\x03ｖＫ：:\x00wπγ␍␍",
		out:  "␐+uν\x10φＣο␐ｖ\r\x14？Ｊυｚ\x12␊␝\x03ｖＫ：:␀wπγ␍␍",
	}, { // 1544
		mask: EncodeSquareBracket | EncodeLeftCrLfHtVt,
		in:   "␐+uν\x10φＣο␐ｖ\r\x14？Ｊυｚ\x12␊␝\x03ｖＫ：:\x00wπγs\r",
		out:  "␐+uν\x10φＣο␐ｖ\r\x14？Ｊυｚ\x12␊␝\x03ｖＫ：:␀wπγs\r",
	}, { // 1545
		mask: EncodeSquareBracket | EncodeLeftCrLfHtVt,
		in:   "␐+uν\x10φＣο␐ｖ\r\x14？Ｊυｚ\x12␊␝\x03ｖＫ：:\x00wπγs␍",
		out:  "␐+uν\x10φＣο␐ｖ\r\x14？Ｊυｚ\x12␊␝\x03ｖＫ：:␀wπγs␍",
	}, { // 1546
		mask: EncodeSemicolon | EncodeLeftCrLfHtVt,
		in:   "Ｖｑ#＄␟ζｘ␉λX\tμ␔\x19τ\tσ<_＝aμ6Ｄ}\x060\r／＇",
		out:  "Ｖｑ#＄␟ζｘ␉λX\tμ␔\x19τ\tσ<_＝aμ6Ｄ}\x060\r／＇",
	}, { // 1547
		mask: EncodeSemicolon | EncodeLeftCrLfHtVt,
		in:   "\t␉#＄␟ζｘ␉λX\tμ␔\x19τ\tσ<_＝aμ6Ｄ}\x060\r／＇",
		out:  "␉␉#＄␟ζｘ␉λX\tμ␔\x19τ\tσ<_＝aμ6Ｄ}\x060\r／＇",
	}, { // 1548
		mask: EncodeSemicolon | EncodeLeftCrLfHtVt,
		in:   "␉␉#＄␟ζｘ␉λX\tμ␔\x19τ\tσ<_＝aμ6Ｄ}\x060\r／＇",
		out:  "‛␉␉#＄␟ζｘ␉λX\tμ␔\x19τ\tσ<_＝aμ6Ｄ}\x060\r／＇",
	}, { // 1549
		mask: EncodeSemicolon | EncodeLeftCrLfHtVt,
		in:   "\tｑ#＄␟ζｘ␉λX\tμ␔\x19τ\tσ<_＝aμ6Ｄ}\x060\r␉＇",
		out:  "␉ｑ#＄␟ζｘ␉λX\tμ␔\x19τ\tσ<_＝aμ6Ｄ}\x060\r␉＇",
	}, { // 1550
		mask: EncodeSemicolon | EncodeLeftCrLfHtVt,
		in:   "␉ｑ#＄␟ζｘ␉λX\tμ␔\x19τ\tσ<_＝aμ6Ｄ}\x060\r␉＇",
		out:  "‛␉ｑ#＄␟ζｘ␉λX\tμ␔\x19τ\tσ<_＝aμ6Ｄ}\x060\r␉＇",
	}, { // 1551
		mask: EncodeSemicolon | EncodeLeftCrLfHtVt,
		in:   "\tｑ#＄␟ζｘ␉λX\tμ␔\x19τ\tσ<_＝aμ6Ｄ}\x060\r／␉",
		out:  "␉ｑ#＄␟ζｘ␉λX\tμ␔\x19τ\tσ<_＝aμ6Ｄ}\x060\r／␉",
	}, { // 1552
		mask: EncodeSemicolon | EncodeLeftCrLfHtVt,
		in:   "␉ｑ#＄␟ζｘ␉λX\tμ␔\x19τ\tσ<_＝aμ6Ｄ}\x060\r／␉",
		out:  "‛␉ｑ#＄␟ζｘ␉λX\tμ␔\x19τ\tσ<_＝aμ6Ｄ}\x060\r／␉",
	}, { // 1553
		mask: EncodeSemicolon | EncodeLeftCrLfHtVt,
		in:   "Ｖ\t#＄␟ζｘ␉λX\tμ␔\x19τ\tσ<_＝aμ6Ｄ}\x060\r／＇",
		out:  "Ｖ\t#＄␟ζｘ␉λX\tμ␔\x19τ\tσ<_＝aμ6Ｄ}\x060\r／＇",
	}, { // 1554
		mask: EncodeSemicolon | EncodeLeftCrLfHtVt,
		in:   "Ｖ␉#＄␟ζｘ␉λX\tμ␔\x19τ\tσ<_＝aμ6Ｄ}\x060\r／＇",
		out:  "Ｖ␉#＄␟ζｘ␉λX\tμ␔\x19τ\tσ<_＝aμ6Ｄ}\x060\r／＇",
	}, { // 1555
		mask: EncodeSemicolon | EncodeLeftCrLfHtVt,
		in:   "Ｖ\t#＄␟ζｘ␉λX\tμ␔\x19τ\tσ<_＝aμ6Ｄ}\x060\r␉＇",
		out:  "Ｖ\t#＄␟ζｘ␉λX\tμ␔\x19τ\tσ<_＝aμ6Ｄ}\x060\r␉＇",
	}, { // 1556
		mask: EncodeSemicolon | EncodeLeftCrLfHtVt,
		in:   "Ｖ␉#＄␟ζｘ␉λX\tμ␔\x19τ\tσ<_＝aμ6Ｄ}\x060\r␉＇",
		out:  "Ｖ␉#＄␟ζｘ␉λX\tμ␔\x19τ\tσ<_＝aμ6Ｄ}\x060\r␉＇",
	}, { // 1557
		mask: EncodeSemicolon | EncodeLeftCrLfHtVt,
		in:   "Ｖ\t#＄␟ζｘ␉λX\tμ␔\x19τ\tσ<_＝aμ6Ｄ}\x060\r／␉",
		out:  "Ｖ\t#＄␟ζｘ␉λX\tμ␔\x19τ\tσ<_＝aμ6Ｄ}\x060\r／␉",
	}, { // 1558
		mask: EncodeSemicolon | EncodeLeftCrLfHtVt,
		in:   "Ｖ␉#＄␟ζｘ␉λX\tμ␔\x19τ\tσ<_＝aμ6Ｄ}\x060\r／␉",
		out:  "Ｖ␉#＄␟ζｘ␉λX\tμ␔\x19τ\tσ<_＝aμ6Ｄ}\x060\r／␉",
	}, { // 1559
		mask: EncodeSemicolon | EncodeLeftCrLfHtVt,
		in:   "Ｖｑ#＄␟ζｘ␉λX\tμ␔\x19τ\tσ<_＝aμ6Ｄ}\x060\r\t＇",
		out:  "Ｖｑ#＄␟ζｘ␉λX\tμ␔\x19τ\tσ<_＝aμ6Ｄ}\x060\r\t＇",
	}, { // 1560
		mask: EncodeSemicolon | EncodeLeftCrLfHtVt,
		in:   "Ｖｑ#＄␟ζｘ␉λX\tμ␔\x19τ\tσ<_＝aμ6Ｄ}\x060\r␉＇",
		out:  "Ｖｑ#＄␟ζｘ␉λX\tμ␔\x19τ\tσ<_＝aμ6Ｄ}\x060\r␉＇",
	}, { // 1561
		mask: EncodeSemicolon | EncodeLeftCrLfHtVt,
		in:   "Ｖｑ#＄␟ζｘ␉λX\tμ␔\x19τ\tσ<_＝aμ6Ｄ}\x060\r\t␉",
		out:  "Ｖｑ#＄␟ζｘ␉λX\tμ␔\x19τ\tσ<_＝aμ6Ｄ}\x060\r\t␉",
	}, { // 1562
		mask: EncodeSemicolon | EncodeLeftCrLfHtVt,
		in:   "Ｖｑ#＄␟ζｘ␉λX\tμ␔\x19τ\tσ<_＝aμ6Ｄ}\x060\r␉␉",
		out:  "Ｖｑ#＄␟ζｘ␉λX\tμ␔\x19τ\tσ<_＝aμ6Ｄ}\x060\r␉␉",
	}, { // 1563
		mask: EncodeSemicolon | EncodeLeftCrLfHtVt,
		in:   "Ｖｑ#＄␟ζｘ␉λX\tμ␔\x19τ\tσ<_＝aμ6Ｄ}\x060\r／\t",
		out:  "Ｖｑ#＄␟ζｘ␉λX\tμ␔\x19τ\tσ<_＝aμ6Ｄ}\x060\r／\t",
	}, { // 1564
		mask: EncodeSemicolon | EncodeLeftCrLfHtVt,
		in:   "Ｖｑ#＄␟ζｘ␉λX\tμ␔\x19τ\tσ<_＝aμ6Ｄ}\x060\r／␉",
		out:  "Ｖｑ#＄␟ζｘ␉λX\tμ␔\x19τ\tσ<_＝aμ6Ｄ}\x060\r／␉",
	}, { // 1565
		mask: EncodeSemicolon | EncodeLeftCrLfHtVt,
		in:   "｛ｋ\x1aｐ␇πδ］.>\n%CNzξε;３␒］2\nζκ\x04｀\x06（Ｆ",
		out:  "｛ｋ\x1aｐ␇πδ］.>\n%CNzξε；３␒］2\nζκ\x04｀\x06（Ｆ",
	}, { // 1566
		mask: EncodeSemicolon | EncodeLeftCrLfHtVt,
		in:   "\n␊\x1aｐ␇πδ］.>\n%CNzξε;３␒］2\nζκ\x04｀\x06（Ｆ",
		out:  "␊␊\x1aｐ␇πδ］.>\n%CNzξε；３␒］2\nζκ\x04｀\x06（Ｆ",
	}, { // 1567
		mask: EncodeSemicolon | EncodeLeftCrLfHtVt,
		in:   "␊␊\x1aｐ␇πδ］.>\n%CNzξε;３␒］2\nζκ\x04｀\x06（Ｆ",
		out:  "‛␊␊\x1aｐ␇πδ］.>\n%CNzξε；３␒］2\nζκ\x04｀\x06（Ｆ",
	}, { // 1568
		mask: EncodeSemicolon | EncodeLeftCrLfHtVt,
		in:   "\nｋ\x1aｐ␇πδ］.>\n%CNzξε;３␒］2\nζκ\x04｀\x06␊Ｆ",
		out:  "␊ｋ\x1aｐ␇πδ］.>\n%CNzξε；３␒］2\nζκ\x04｀\x06␊Ｆ",
	}, { // 1569
		mask: EncodeSemicolon | EncodeLeftCrLfHtVt,
		in:   "␊ｋ\x1aｐ␇πδ］.>\n%CNzξε;３␒］2\nζκ\x04｀\x06␊Ｆ",
		out:  "‛␊ｋ\x1aｐ␇πδ］.>\n%CNzξε；３␒］2\nζκ\x04｀\x06␊Ｆ",
	}, { // 1570
		mask: EncodeSemicolon | EncodeLeftCrLfHtVt,
		in:   "\nｋ\x1aｐ␇πδ］.>\n%CNzξε;３␒］2\nζκ\x04｀\x06（␊",
		out:  "␊ｋ\x1aｐ␇πδ］.>\n%CNzξε；３␒］2\nζκ\x04｀\x06（␊",
	}, { // 1571
		mask: EncodeSemicolon | EncodeLeftCrLfHtVt,
		in:   "␊ｋ\x1aｐ␇πδ］.>\n%CNzξε;３␒］2\nζκ\x04｀\x06（␊",
		out:  "‛␊ｋ\x1aｐ␇πδ］.>\n%CNzξε；３␒］2\nζκ\x04｀\x06（␊",
	}, { // 1572
		mask: EncodeSemicolon | EncodeLeftCrLfHtVt,
		in:   "｛\n\x1aｐ␇πδ］.>\n%CNzξε;３␒］2\nζκ\x04｀\x06（Ｆ",
		out:  "｛\n\x1aｐ␇πδ］.>\n%CNzξε；３␒］2\nζκ\x04｀\x06（Ｆ",
	}, { // 1573
		mask: EncodeSemicolon | EncodeLeftCrLfHtVt,
		in:   "｛␊\x1aｐ␇πδ］.>\n%CNzξε;３␒］2\nζκ\x04｀\x06（Ｆ",
		out:  "｛␊\x1aｐ␇πδ］.>\n%CNzξε；３␒］2\nζκ\x04｀\x06（Ｆ",
	}, { // 1574
		mask: EncodeSemicolon | EncodeLeftCrLfHtVt,
		in:   "｛\n\x1aｐ␇πδ］.>\n%CNzξε;３␒］2\nζκ\x04｀\x06␊Ｆ",
		out:  "｛\n\x1aｐ␇πδ］.>\n%CNzξε；３␒］2\nζκ\x04｀\x06␊Ｆ",
	}, { // 1575
		mask: EncodeSemicolon | EncodeLeftCrLfHtVt,
		in:   "｛␊\x1aｐ␇πδ］.>\n%CNzξε;３␒］2\nζκ\x04｀\x06␊Ｆ",
		out:  "｛␊\x1aｐ␇πδ］.>\n%CNzξε；３␒］2\nζκ\x04｀\x06␊Ｆ",
	}, { // 1576
		mask: EncodeSemicolon | EncodeLeftCrLfHtVt,
		in:   "｛\n\x1aｐ␇πδ］.>\n%CNzξε;３␒］2\nζκ\x04｀\x06（␊",
		out:  "｛\n\x1aｐ␇πδ］.>\n%CNzξε；３␒］2\nζκ\x04｀\x06（␊",
	}, { // 1577
		mask: EncodeSemicolon | EncodeLeftCrLfHtVt,
		in:   "｛␊\x1aｐ␇πδ］.>\n%CNzξε;３␒］2\nζκ\x04｀\x06（␊",
		out:  "｛␊\x1aｐ␇πδ］.>\n%CNzξε；３␒］2\nζκ\x04｀\x06（␊",
	}, { // 1578
		mask: EncodeSemicolon | EncodeLeftCrLfHtVt,
		in:   "｛ｋ\x1aｐ␇πδ］.>\n%CNzξε;３␒］2\nζκ\x04｀\x06\nＦ",
		out:  "｛ｋ\x1aｐ␇πδ］.>\n%CNzξε；３␒］2\nζκ\x04｀\x06\nＦ",
	}, { // 1579
		mask: EncodeSemicolon | EncodeLeftCrLfHtVt,
		in:   "｛ｋ\x1aｐ␇πδ］.>\n%CNzξε;３␒］2\nζκ\x04｀\x06␊Ｆ",
		out:  "｛ｋ\x1aｐ␇πδ］.>\n%CNzξε；３␒］2\nζκ\x04｀\x06␊Ｆ",
	}, { // 1580
		mask: EncodeSemicolon | EncodeLeftCrLfHtVt,
		in:   "｛ｋ\x1aｐ␇πδ］.>\n%CNzξε;３␒］2\nζκ\x04｀\x06\n␊",
		out:  "｛ｋ\x1aｐ␇πδ］.>\n%CNzξε；３␒］2\nζκ\x04｀\x06\n␊",
	}, { // 1581
		mask: EncodeSemicolon | EncodeLeftCrLfHtVt,
		in:   "｛ｋ\x1aｐ␇πδ］.>\n%CNzξε;３␒］2\nζκ\x04｀\x06␊␊",
		out:  "｛ｋ\x1aｐ␇πδ］.>\n%CNzξε；３␒］2\nζκ\x04｀\x06␊␊",
	}, { // 1582
		mask: EncodeSemicolon | EncodeLeftCrLfHtVt,
		in:   "｛ｋ\x1aｐ␇πδ］.>\n%CNzξε;３␒］2\nζκ\x04｀\x06（\n",
		out:  "｛ｋ\x1aｐ␇πδ］.>\n%CNzξε；３␒］2\nζκ\x04｀\x06（\n",
	}, { // 1583
		mask: EncodeSemicolon | EncodeLeftCrLfHtVt,
		in:   "｛ｋ\x1aｐ␇πδ］.>\n%CNzξε;３␒］2\nζκ\x04｀\x06（␊",
		out:  "｛ｋ\x1aｐ␇πδ］.>\n%CNzξε；３␒］2\nζκ\x04｀\x06（␊",
	}, { // 1584
		mask: EncodeSemicolon | EncodeLeftCrLfHtVt,
		in:   "\x198θ\x00(＄１４，␙\vαｌ␝L\x02)：］␚γ\x14／<ιN=<γβ",
		out:  "\x198θ␀(＄１４，␙\vαｌ␝L\x02)：］␚γ\x14／<ιN=<γβ",
	}, { // 1585
		mask: EncodeSemicolon | EncodeLeftCrLfHtVt,
		in:   "\v␋θ\x00(＄１４，␙\vαｌ␝L\x02)：］␚γ\x14／<ιN=<γβ",
		out:  "␋␋θ␀(＄１４，␙\vαｌ␝L\x02)：］␚γ\x14／<ιN=<γβ",
	}, { // 1586
		mask: EncodeSemicolon | EncodeLeftCrLfHtVt,
		in:   "␋␋θ\x00(＄１４，␙\vαｌ␝L\x02)：］␚γ\x14／<ιN=<γβ",
		out:  "‛␋␋θ␀(＄１４，␙\vαｌ␝L\x02)：］␚γ\x14／<ιN=<γβ",
	}, { // 1587
		mask: EncodeSemicolon | EncodeLeftCrLfHtVt,
		in:   "\v8θ\x00(＄１４，␙\vαｌ␝L\x02)：］␚γ\x14／<ιN=<␋β",
		out:  "␋8θ␀(＄１４，␙\vαｌ␝L\x02)：］␚γ\x14／<ιN=<␋β",
	}, { // 1588
		mask: EncodeSemicolon | EncodeLeftCrLfHtVt,
		in:   "␋8θ\x00(＄１４，␙\vαｌ␝L\x02)：］␚γ\x14／<ιN=<␋β",
		out:  "‛␋8θ␀(＄１４，␙\vαｌ␝L\x02)：］␚γ\x14／<ιN=<␋β",
	}, { // 1589
		mask: EncodeSemicolon | EncodeLeftCrLfHtVt,
		in:   "\v8θ\x00(＄１４，␙\vαｌ␝L\x02)：］␚γ\x14／<ιN=<γ␋",
		out:  "␋8θ␀(＄１４，␙\vαｌ␝L\x02)：］␚γ\x14／<ιN=<γ␋",
	}, { // 1590
		mask: EncodeSemicolon | EncodeLeftCrLfHtVt,
		in:   "␋8θ\x00(＄１４，␙\vαｌ␝L\x02)：］␚γ\x14／<ιN=<γ␋",
		out:  "‛␋8θ␀(＄１４，␙\vαｌ␝L\x02)：］␚γ\x14／<ιN=<γ␋",
	}, { // 1591
		mask: EncodeSemicolon | EncodeLeftCrLfHtVt,
		in:   "\x19\vθ\x00(＄１４，␙\vαｌ␝L\x02)：］␚γ\x14／<ιN=<γβ",
		out:  "\x19\vθ␀(＄１４，␙\vαｌ␝L\x02)：］␚γ\x14／<ιN=<γβ",
	}, { // 1592
		mask: EncodeSemicolon | EncodeLeftCrLfHtVt,
		in:   "\x19␋θ\x00(＄１４，␙\vαｌ␝L\x02)：］␚γ\x14／<ιN=<γβ",
		out:  "\x19␋θ␀(＄１４，␙\vαｌ␝L\x02)：］␚γ\x14／<ιN=<γβ",
	}, { // 1593
		mask: EncodeSemicolon | EncodeLeftCrLfHtVt,
		in:   "\x19\vθ\x00(＄１４，␙\vαｌ␝L\x02)：］␚γ\x14／<ιN=<␋β",
		out:  "\x19\vθ␀(＄１４，␙\vαｌ␝L\x02)：］␚γ\x14／<ιN=<␋β",
	}, { // 1594
		mask: EncodeSemicolon | EncodeLeftCrLfHtVt,
		in:   "\x19␋θ\x00(＄１４，␙\vαｌ␝L\x02)：］␚γ\x14／<ιN=<␋β",
		out:  "\x19␋θ␀(＄１４，␙\vαｌ␝L\x02)：］␚γ\x14／<ιN=<␋β",
	}, { // 1595
		mask: EncodeSemicolon | EncodeLeftCrLfHtVt,
		in:   "\x19\vθ\x00(＄１４，␙\vαｌ␝L\x02)：］␚γ\x14／<ιN=<γ␋",
		out:  "\x19\vθ␀(＄１４，␙\vαｌ␝L\x02)：］␚γ\x14／<ιN=<γ␋",
	}, { // 1596
		mask: EncodeSemicolon | EncodeLeftCrLfHtVt,
		in:   "\x19␋θ\x00(＄１４，␙\vαｌ␝L\x02)：］␚γ\x14／<ιN=<γ␋",
		out:  "\x19␋θ␀(＄１４，␙\vαｌ␝L\x02)：］␚γ\x14／<ιN=<γ␋",
	}, { // 1597
		mask: EncodeSemicolon | EncodeLeftCrLfHtVt,
		in:   "\x198θ\x00(＄１４，␙\vαｌ␝L\x02)：］␚γ\x14／<ιN=<\vβ",
		out:  "\x198θ␀(＄１４，␙\vαｌ␝L\x02)：］␚γ\x14／<ιN=<\vβ",
	}, { // 1598
		mask: EncodeSemicolon | EncodeLeftCrLfHtVt,
		in:   "\x198θ\x00(＄１４，␙\vαｌ␝L\x02)：］␚γ\x14／<ιN=<␋β",
		out:  "\x198θ␀(＄１４，␙\vαｌ␝L\x02)：］␚γ\x14／<ιN=<␋β",
	}, { // 1599
		mask: EncodeSemicolon | EncodeLeftCrLfHtVt,
		in:   "\x198θ\x00(＄１４，␙\vαｌ␝L\x02)：］␚γ\x14／<ιN=<\v␋",
		out:  "\x198θ␀(＄１４，␙\vαｌ␝L\x02)：］␚γ\x14／<ιN=<\v␋",
	}, { // 1600
		mask: EncodeSemicolon | EncodeLeftCrLfHtVt,
		in:   "\x198θ\x00(＄１４，␙\vαｌ␝L\x02)：］␚γ\x14／<ιN=<␋␋",
		out:  "\x198θ␀(＄１４，␙\vαｌ␝L\x02)：］␚γ\x14／<ιN=<␋␋",
	}, { // 1601
		mask: EncodeSemicolon | EncodeLeftCrLfHtVt,
		in:   "\x198θ\x00(＄１４，␙\vαｌ␝L\x02)：］␚γ\x14／<ιN=<γ\v",
		out:  "\x198θ␀(＄１４，␙\vαｌ␝L\x02)：］␚γ\x14／<ιN=<γ\v",
	}, { // 1602
		mask: EncodeSemicolon | EncodeLeftCrLfHtVt,
		in:   "\x198θ\x00(＄１４，␙\vαｌ␝L\x02)：］␚γ\x14／<ιN=<γ␋",
		out:  "\x198θ␀(＄１４，␙\vαｌ␝L\x02)：］␚γ\x14／<ιN=<γ␋",
	}, { // 1603
		mask: EncodeSemicolon | EncodeLeftCrLfHtVt,
		in:   "？␒V＃ι^σgjＹ\rχＣｃ｜\x12φＦω␔␅\fF␌'\x1d\x02oι\a",
		out:  "？␒V＃ι^σgjＹ\rχＣｃ｜\x12φＦω␔␅\fF␌'\x1d\x02oι\a",
	}, { // 1604
		mask: EncodeSemicolon | EncodeLeftCrLfHtVt,
		in:   "\r␍V＃ι^σgjＹ\rχＣｃ｜\x12φＦω␔␅\fF␌'\x1d\x02oι\a",
		out:  "␍␍V＃ι^σgjＹ\rχＣｃ｜\x12φＦω␔␅\fF␌'\x1d\x02oι\a",
	}, { // 1605
		mask: EncodeSemicolon | EncodeLeftCrLfHtVt,
		in:   "␍␍V＃ι^σgjＹ\rχＣｃ｜\x12φＦω␔␅\fF␌'\x1d\x02oι\a",
		out:  "‛␍␍V＃ι^σgjＹ\rχＣｃ｜\x12φＦω␔␅\fF␌'\x1d\x02oι\a",
	}, { // 1606
		mask: EncodeSemicolon | EncodeLeftCrLfHtVt,
		in:   "\r␒V＃ι^σgjＹ\rχＣｃ｜\x12φＦω␔␅\fF␌'\x1d\x02o␍\a",
		out:  "␍␒V＃ι^σgjＹ\rχＣｃ｜\x12φＦω␔␅\fF␌'\x1d\x02o␍\a",
	}, { // 1607
		mask: EncodeSemicolon | EncodeLeftCrLfHtVt,
		in:   "␍␒V＃ι^σgjＹ\rχＣｃ｜\x12φＦω␔␅\fF␌'\x1d\x02o␍\a",
		out:  "‛␍␒V＃ι^σgjＹ\rχＣｃ｜\x12φＦω␔␅\fF␌'\x1d\x02o␍\a",
	}, { // 1608
		mask: EncodeSemicolon | EncodeLeftCrLfHtVt,
		in:   "\r␒V＃ι^σgjＹ\rχＣｃ｜\x12φＦω␔␅\fF␌'\x1d\x02oι␍",
		out:  "␍␒V＃ι^σgjＹ\rχＣｃ｜\x12φＦω␔␅\fF␌'\x1d\x02oι␍",
	}, { // 1609
		mask: EncodeSemicolon | EncodeLeftCrLfHtVt,
		in:   "␍␒V＃ι^σgjＹ\rχＣｃ｜\x12φＦω␔␅\fF␌'\x1d\x02oι␍",
		out:  "‛␍␒V＃ι^σgjＹ\rχＣｃ｜\x12φＦω␔␅\fF␌'\x1d\x02oι␍",
	}, { // 1610
		mask: EncodeSemicolon | EncodeLeftCrLfHtVt,
		in:   "？\rV＃ι^σgjＹ\rχＣｃ｜\x12φＦω␔␅\fF␌'\x1d\x02oι\a",
		out:  "？\rV＃ι^σgjＹ\rχＣｃ｜\x12φＦω␔␅\fF␌'\x1d\x02oι\a",
	}, { // 1611
		mask: EncodeSemicolon | EncodeLeftCrLfHtVt,
		in:   "？␍V＃ι^σgjＹ\rχＣｃ｜\x12φＦω␔␅\fF␌'\x1d\x02oι\a",
		out:  "？␍V＃ι^σgjＹ\rχＣｃ｜\x12φＦω␔␅\fF␌'\x1d\x02oι\a",
	}, { // 1612
		mask: EncodeSemicolon | EncodeLeftCrLfHtVt,
		in:   "？\rV＃ι^σgjＹ\rχＣｃ｜\x12φＦω␔␅\fF␌'\x1d\x02o␍\a",
		out:  "？\rV＃ι^σgjＹ\rχＣｃ｜\x12φＦω␔␅\fF␌'\x1d\x02o␍\a",
	}, { // 1613
		mask: EncodeSemicolon | EncodeLeftCrLfHtVt,
		in:   "？␍V＃ι^σgjＹ\rχＣｃ｜\x12φＦω␔␅\fF␌'\x1d\x02o␍\a",
		out:  "？␍V＃ι^σgjＹ\rχＣｃ｜\x12φＦω␔␅\fF␌'\x1d\x02o␍\a",
	}, { // 1614
		mask: EncodeSemicolon | EncodeLeftCrLfHtVt,
		in:   "？\rV＃ι^σgjＹ\rχＣｃ｜\x12φＦω␔␅\fF␌'\x1d\x02oι␍",
		out:  "？\rV＃ι^σgjＹ\rχＣｃ｜\x12φＦω␔␅\fF␌'\x1d\x02oι␍",
	}, { // 1615
		mask: EncodeSemicolon | EncodeLeftCrLfHtVt,
		in:   "？␍V＃ι^σgjＹ\rχＣｃ｜\x12φＦω␔␅\fF␌'\x1d\x02oι␍",
		out:  "？␍V＃ι^σgjＹ\rχＣｃ｜\x12φＦω␔␅\fF␌'\x1d\x02oι␍",
	}, { // 1616
		mask: EncodeSemicolon | EncodeLeftCrLfHtVt,
		in:   "？␒V＃ι^σgjＹ\rχＣｃ｜\x12φＦω␔␅\fF␌'\x1d\x02o\r\a",
		out:  "？␒V＃ι^σgjＹ\rχＣｃ｜\x12φＦω␔␅\fF␌'\x1d\x02o\r\a",
	}, { // 1617
		mask: EncodeSemicolon | EncodeLeftCrLfHtVt,
		in:   "？␒V＃ι^σgjＹ\rχＣｃ｜\x12φＦω␔␅\fF␌'\x1d\x02o␍\a",
		out:  "？␒V＃ι^σgjＹ\rχＣｃ｜\x12φＦω␔␅\fF␌'\x1d\x02o␍\a",
	}, { // 1618
		mask: EncodeSemicolon | EncodeLeftCrLfHtVt,
		in:   "？␒V＃ι^σgjＹ\rχＣｃ｜\x12φＦω␔␅\fF␌'\x1d\x02o\r␍",
		out:  "？␒V＃ι^σgjＹ\rχＣｃ｜\x12φＦω␔␅\fF␌'\x1d\x02o\r␍",
	}, { // 1619
		mask: EncodeSemicolon | EncodeLeftCrLfHtVt,
		in:   "？␒V＃ι^σgjＹ\rχＣｃ｜\x12φＦω␔␅\fF␌'\x1d\x02o␍␍",
		out:  "？␒V＃ι^σgjＹ\rχＣｃ｜\x12φＦω␔␅\fF␌'\x1d\x02o␍␍",
	}, { // 1620
		mask: EncodeSemicolon | EncodeLeftCrLfHtVt,
		in:   "？␒V＃ι^σgjＹ\rχＣｃ｜\x12φＦω␔␅\fF␌'\x1d\x02oι\r",
		out:  "？␒V＃ι^σgjＹ\rχＣｃ｜\x12φＦω␔␅\fF␌'\x1d\x02oι\r",
	}, { // 1621
		mask: EncodeSemicolon | EncodeLeftCrLfHtVt,
		in:   "？␒V＃ι^σgjＹ\rχＣｃ｜\x12φＦω␔␅\fF␌'\x1d\x02oι␍",
		out:  "？␒V＃ι^σgjＹ\rχＣｃ｜\x12φＦω␔␅\fF␌'\x1d\x02oι␍",
	}, { // 1622
		mask: EncodeDollar | EncodeLeftCrLfHtVt,
		in:   "α␇ο*π＾\f＼a␚\tＲ\uff00e<>＞T␗-␅'\r\x1aｕκζυｊ|",
		out:  "α␇ο*π＾\f＼a␚\tＲ\uff00e<>＞T␗-␅'\r\x1aｕκζυｊ|",
	}, { // 1623
		mask: EncodeDollar | EncodeLeftCrLfHtVt,
		in:   "\t␉ο*π＾\f＼a␚\tＲ\uff00e<>＞T␗-␅'\r\x1aｕκζυｊ|",
		out:  "␉␉ο*π＾\f＼a␚\tＲ\uff00e<>＞T␗-␅'\r\x1aｕκζυｊ|",
	}, { // 1624
		mask: EncodeDollar | EncodeLeftCrLfHtVt,
		in:   "␉␉ο*π＾\f＼a␚\tＲ\uff00e<>＞T␗-␅'\r\x1aｕκζυｊ|",
		out:  "‛␉␉ο*π＾\f＼a␚\tＲ\uff00e<>＞T␗-␅'\r\x1aｕκζυｊ|",
	}, { // 1625
		mask: EncodeDollar | EncodeLeftCrLfHtVt,
		in:   "\t␇ο*π＾\f＼a␚\tＲ\uff00e<>＞T␗-␅'\r\x1aｕκζυ␉|",
		out:  "␉␇ο*π＾\f＼a␚\tＲ\uff00e<>＞T␗-␅'\r\x1aｕκζυ␉|",
	}, { // 1626
		mask: EncodeDollar | EncodeLeftCrLfHtVt,
		in:   "␉␇ο*π＾\f＼a␚\tＲ\uff00e<>＞T␗-␅'\r\x1aｕκζυ␉|",
		out:  "‛␉␇ο*π＾\f＼a␚\tＲ\uff00e<>＞T␗-␅'\r\x1aｕκζυ␉|",
	}, { // 1627
		mask: EncodeDollar | EncodeLeftCrLfHtVt,
		in:   "\t␇ο*π＾\f＼a␚\tＲ\uff00e<>＞T␗-␅'\r\x1aｕκζυｊ␉",
		out:  "␉␇ο*π＾\f＼a␚\tＲ\uff00e<>＞T␗-␅'\r\x1aｕκζυｊ␉",
	}, { // 1628
		mask: EncodeDollar | EncodeLeftCrLfHtVt,
		in:   "␉␇ο*π＾\f＼a␚\tＲ\uff00e<>＞T␗-␅'\r\x1aｕκζυｊ␉",
		out:  "‛␉␇ο*π＾\f＼a␚\tＲ\uff00e<>＞T␗-␅'\r\x1aｕκζυｊ␉",
	}, { // 1629
		mask: EncodeDollar | EncodeLeftCrLfHtVt,
		in:   "α\tο*π＾\f＼a␚\tＲ\uff00e<>＞T␗-␅'\r\x1aｕκζυｊ|",
		out:  "α\tο*π＾\f＼a␚\tＲ\uff00e<>＞T␗-␅'\r\x1aｕκζυｊ|",
	}, { // 1630
		mask: EncodeDollar | EncodeLeftCrLfHtVt,
		in:   "α␉ο*π＾\f＼a␚\tＲ\uff00e<>＞T␗-␅'\r\x1aｕκζυｊ|",
		out:  "α␉ο*π＾\f＼a␚\tＲ\uff00e<>＞T␗-␅'\r\x1aｕκζυｊ|",
	}, { // 1631
		mask: EncodeDollar | EncodeLeftCrLfHtVt,
		in:   "α\tο*π＾\f＼a␚\tＲ\uff00e<>＞T␗-␅'\r\x1aｕκζυ␉|",
		out:  "α\tο*π＾\f＼a␚\tＲ\uff00e<>＞T␗-␅'\r\x1aｕκζυ␉|",
	}, { // 1632
		mask: EncodeDollar | EncodeLeftCrLfHtVt,
		in:   "α␉ο*π＾\f＼a␚\tＲ\uff00e<>＞T␗-␅'\r\x1aｕκζυ␉|",
		out:  "α␉ο*π＾\f＼a␚\tＲ\uff00e<>＞T␗-␅'\r\x1aｕκζυ␉|",
	}, { // 1633
		mask: EncodeDollar | EncodeLeftCrLfHtVt,
		in:   "α\tο*π＾\f＼a␚\tＲ\uff00e<>＞T␗-␅'\r\x1aｕκζυｊ␉",
		out:  "α\tο*π＾\f＼a␚\tＲ\uff00e<>＞T␗-␅'\r\x1aｕκζυｊ␉",
	}, { // 1634
		mask: EncodeDollar | EncodeLeftCrLfHtVt,
		in:   "α␉ο*π＾\f＼a␚\tＲ\uff00e<>＞T␗-␅'\r\x1aｕκζυｊ␉",
		out:  "α␉ο*π＾\f＼a␚\tＲ\uff00e<>＞T␗-␅'\r\x1aｕκζυｊ␉",
	}, { // 1635
		mask: EncodeDollar | EncodeLeftCrLfHtVt,
		in:   "α␇ο*π＾\f＼a␚\tＲ\uff00e<>＞T␗-␅'\r\x1aｕκζυ\t|",
		out:  "α␇ο*π＾\f＼a␚\tＲ\uff00e<>＞T␗-␅'\r\x1aｕκζυ\t|",
	}, { // 1636
		mask: EncodeDollar | EncodeLeftCrLfHtVt,
		in:   "α␇ο*π＾\f＼a␚\tＲ\uff00e<>＞T␗-␅'\r\x1aｕκζυ␉|",
		out:  "α␇ο*π＾\f＼a␚\tＲ\uff00e<>＞T␗-␅'\r\x1aｕκζυ␉|",
	}, { // 1637
		mask: EncodeDollar | EncodeLeftCrLfHtVt,
		in:   "α␇ο*π＾\f＼a␚\tＲ\uff00e<>＞T␗-␅'\r\x1aｕκζυ\t␉",
		out:  "α␇ο*π＾\f＼a␚\tＲ\uff00e<>＞T␗-␅'\r\x1aｕκζυ\t␉",
	}, { // 1638
		mask: EncodeDollar | EncodeLeftCrLfHtVt,
		in:   "α␇ο*π＾\f＼a␚\tＲ\uff00e<>＞T␗-␅'\r\x1aｕκζυ␉␉",
		out:  "α␇ο*π＾\f＼a␚\tＲ\uff00e<>＞T␗-␅'\r\x1aｕκζυ␉␉",
	}, { // 1639
		mask: EncodeDollar | EncodeLeftCrLfHtVt,
		in:   "α␇ο*π＾\f＼a␚\tＲ\uff00e<>＞T␗-␅'\r\x1aｕκζυｊ\t",
		out:  "α␇ο*π＾\f＼a␚\tＲ\uff00e<>＞T␗-␅'\r\x1aｕκζυｊ\t",
	}, { // 1640
		mask: EncodeDollar | EncodeLeftCrLfHtVt,
		in:   "α␇ο*π＾\f＼a␚\tＲ\uff00e<>＞T␗-␅'\r\x1aｕκζυｊ␉",
		out:  "α␇ο*π＾\f＼a␚\tＲ\uff00e<>＞T␗-␅'\r\x1aｕκζυｊ␉",
	}, { // 1641
		mask: EncodeDollar | EncodeLeftCrLfHtVt,
		in:   "+σ\x1b␔δ\n％␈\x00ε\n／9vυ\x15ＴＡ=\x01(ν＜｀８ｄＴｑτ|",
		out:  "+σ\x1b␔δ\n％␈␀ε\n／9vυ\x15ＴＡ=\x01(ν＜｀８ｄＴｑτ|",
	}, { // 1642
		mask: EncodeDollar | EncodeLeftCrLfHtVt,
		in:   "\n␊\x1b␔δ\n％␈\x00ε\n／9vυ\x15ＴＡ=\x01(ν＜｀８ｄＴｑτ|",
		out:  "␊␊\x1b␔δ\n％␈␀ε\n／9vυ\x15ＴＡ=\x01(ν＜｀８ｄＴｑτ|",
	}, { // 1643
		mask: EncodeDollar | EncodeLeftCrLfHtVt,
		in:   "␊␊\x1b␔δ\n％␈\x00ε\n／9vυ\x15ＴＡ=\x01(ν＜｀８ｄＴｑτ|",
		out:  "‛␊␊\x1b␔δ\n％␈␀ε\n／9vυ\x15ＴＡ=\x01(ν＜｀８ｄＴｑτ|",
	}, { // 1644
		mask: EncodeDollar | EncodeLeftCrLfHtVt,
		in:   "\nσ\x1b␔δ\n％␈\x00ε\n／9vυ\x15ＴＡ=\x01(ν＜｀８ｄＴｑ␊|",
		out:  "␊σ\x1b␔δ\n％␈␀ε\n／9vυ\x15ＴＡ=\x01(ν＜｀８ｄＴｑ␊|",
	}, { // 1645
		mask: EncodeDollar | EncodeLeftCrLfHtVt,
		in:   "␊σ\x1b␔δ\n％␈\x00ε\n／9vυ\x15ＴＡ=\x01(ν＜｀８ｄＴｑ␊|",
		out:  "‛␊σ\x1b␔δ\n％␈␀ε\n／9vυ\x15ＴＡ=\x01(ν＜｀８ｄＴｑ␊|",
	}, { // 1646
		mask: EncodeDollar | EncodeLeftCrLfHtVt,
		in:   "\nσ\x1b␔δ\n％␈\x00ε\n／9vυ\x15ＴＡ=\x01(ν＜｀８ｄＴｑτ␊",
		out:  "␊σ\x1b␔δ\n％␈␀ε\n／9vυ\x15ＴＡ=\x01(ν＜｀８ｄＴｑτ␊",
	}, { // 1647
		mask: EncodeDollar | EncodeLeftCrLfHtVt,
		in:   "␊σ\x1b␔δ\n％␈\x00ε\n／9vυ\x15ＴＡ=\x01(ν＜｀８ｄＴｑτ␊",
		out:  "‛␊σ\x1b␔δ\n％␈␀ε\n／9vυ\x15ＴＡ=\x01(ν＜｀８ｄＴｑτ␊",
	}, { // 1648
		mask: EncodeDollar | EncodeLeftCrLfHtVt,
		in:   "+\n\x1b␔δ\n％␈\x00ε\n／9vυ\x15ＴＡ=\x01(ν＜｀８ｄＴｑτ|",
		out:  "+\n\x1b␔δ\n％␈␀ε\n／9vυ\x15ＴＡ=\x01(ν＜｀８ｄＴｑτ|",
	}, { // 1649
		mask: EncodeDollar | EncodeLeftCrLfHtVt,
		in:   "+␊\x1b␔δ\n％␈\x00ε\n／9vυ\x15ＴＡ=\x01(ν＜｀８ｄＴｑτ|",
		out:  "+␊\x1b␔δ\n％␈␀ε\n／9vυ\x15ＴＡ=\x01(ν＜｀８ｄＴｑτ|",
	}, { // 1650
		mask: EncodeDollar | EncodeLeftCrLfHtVt,
		in:   "+\n\x1b␔δ\n％␈\x00ε\n／9vυ\x15ＴＡ=\x01(ν＜｀８ｄＴｑ␊|",
		out:  "+\n\x1b␔δ\n％␈␀ε\n／9vυ\x15ＴＡ=\x01(ν＜｀８ｄＴｑ␊|",
	}, { // 1651
		mask: EncodeDollar | EncodeLeftCrLfHtVt,
		in:   "+␊\x1b␔δ\n％␈\x00ε\n／9vυ\x15ＴＡ=\x01(ν＜｀８ｄＴｑ␊|",
		out:  "+␊\x1b␔δ\n％␈␀ε\n／9vυ\x15ＴＡ=\x01(ν＜｀８ｄＴｑ␊|",
	}, { // 1652
		mask: EncodeDollar | EncodeLeftCrLfHtVt,
		in:   "+\n\x1b␔δ\n％␈\x00ε\n／9vυ\x15ＴＡ=\x01(ν＜｀８ｄＴｑτ␊",
		out:  "+\n\x1b␔δ\n％␈␀ε\n／9vυ\x15ＴＡ=\x01(ν＜｀８ｄＴｑτ␊",
	}, { // 1653
		mask: EncodeDollar | EncodeLeftCrLfHtVt,
		in:   "+␊\x1b␔δ\n％␈\x00ε\n／9vυ\x15ＴＡ=\x01(ν＜｀８ｄＴｑτ␊",
		out:  "+␊\x1b␔δ\n％␈␀ε\n／9vυ\x15ＴＡ=\x01(ν＜｀８ｄＴｑτ␊",
	}, { // 1654
		mask: EncodeDollar | EncodeLeftCrLfHtVt,
		in:   "+σ\x1b␔δ\n％␈\x00ε\n／9vυ\x15ＴＡ=\x01(ν＜｀８ｄＴｑ\n|",
		out:  "+σ\x1b␔δ\n％␈␀ε\n／9vυ\x15ＴＡ=\x01(ν＜｀８ｄＴｑ\n|",
	}, { // 1655
		mask: EncodeDollar | EncodeLeftCrLfHtVt,
		in:   "+σ\x1b␔δ\n％␈\x00ε\n／9vυ\x15ＴＡ=\x01(ν＜｀８ｄＴｑ␊|",
		out:  "+σ\x1b␔δ\n％␈␀ε\n／9vυ\x15ＴＡ=\x01(ν＜｀８ｄＴｑ␊|",
	}, { // 1656
		mask: EncodeDollar | EncodeLeftCrLfHtVt,
		in:   "+σ\x1b␔δ\n％␈\x00ε\n／9vυ\x15ＴＡ=\x01(ν＜｀８ｄＴｑ\n␊",
		out:  "+σ\x1b␔δ\n％␈␀ε\n／9vυ\x15ＴＡ=\x01(ν＜｀８ｄＴｑ\n␊",
	}, { // 1657
		mask: EncodeDollar | EncodeLeftCrLfHtVt,
		in:   "+σ\x1b␔δ\n％␈\x00ε\n／9vυ\x15ＴＡ=\x01(ν＜｀８ｄＴｑ␊␊",
		out:  "+σ\x1b␔δ\n％␈␀ε\n／9vυ\x15ＴＡ=\x01(ν＜｀８ｄＴｑ␊␊",
	}, { // 1658
		mask: EncodeDollar | EncodeLeftCrLfHtVt,
		in:   "+σ\x1b␔δ\n％␈\x00ε\n／9vυ\x15ＴＡ=\x01(ν＜｀８ｄＴｑτ\n",
		out:  "+σ\x1b␔δ\n％␈␀ε\n／9vυ\x15ＴＡ=\x01(ν＜｀８ｄＴｑτ\n",
	}, { // 1659
		mask: EncodeDollar | EncodeLeftCrLfHtVt,
		in:   "+σ\x1b␔δ\n％␈\x00ε\n／9vυ\x15ＴＡ=\x01(ν＜｀８ｄＴｑτ␊",
		out:  "+σ\x1b␔δ\n％␈␀ε\n／9vυ\x15ＴＡ=\x01(ν＜｀８ｄＴｑτ␊",
	}, { // 1660
		mask: EncodeDollar | EncodeLeftCrLfHtVt,
		in:   "εｄμ␇\a)P\x1d＝/\v␎ β｜nＷσ␜\x00；Ｚ␟，：@V/π\x00",
		out:  "εｄμ␇\a)P\x1d＝/\v␎ β｜nＷσ␜␀；Ｚ␟，：@V/π␀",
	}, { // 1661
		mask: EncodeDollar | EncodeLeftCrLfHtVt,
		in:   "\v␋μ␇\a)P\x1d＝/\v␎ β｜nＷσ␜\x00；Ｚ␟，：@V/π\x00",
		out:  "␋␋μ␇\a)P\x1d＝/\v␎ β｜nＷσ␜␀；Ｚ␟，：@V/π␀",
	}, { // 1662
		mask: EncodeDollar | EncodeLeftCrLfHtVt,
		in:   "␋␋μ␇\a)P\x1d＝/\v␎ β｜nＷσ␜\x00；Ｚ␟，：@V/π\x00",
		out:  "‛␋␋μ␇\a)P\x1d＝/\v␎ β｜nＷσ␜␀；Ｚ␟，：@V/π␀",
	}, { // 1663
		mask: EncodeDollar | EncodeLeftCrLfHtVt,
		in:   "\vｄμ␇\a)P\x1d＝/\v␎ β｜nＷσ␜\x00；Ｚ␟，：@V/␋\x00",
		out:  "␋ｄμ␇\a)P\x1d＝/\v␎ β｜nＷσ␜␀；Ｚ␟，：@V/␋␀",
	}, { // 1664
		mask: EncodeDollar | EncodeLeftCrLfHtVt,
		in:   "␋ｄμ␇\a)P\x1d＝/\v␎ β｜nＷσ␜\x00；Ｚ␟，：@V/␋\x00",
		out:  "‛␋ｄμ␇\a)P\x1d＝/\v␎ β｜nＷσ␜␀；Ｚ␟，：@V/␋␀",
	}, { // 1665
		mask: EncodeDollar | EncodeLeftCrLfHtVt,
		in:   "\vｄμ␇\a)P\x1d＝/\v␎ β｜nＷσ␜\x00；Ｚ␟，：@V/π␋",
		out:  "␋ｄμ␇\a)P\x1d＝/\v␎ β｜nＷσ␜␀；Ｚ␟，：@V/π␋",
	}, { // 1666
		mask: EncodeDollar | EncodeLeftCrLfHtVt,
		in:   "␋ｄμ␇\a)P\x1d＝/\v␎ β｜nＷσ␜\x00；Ｚ␟，：@V/π␋",
		out:  "‛␋ｄμ␇\a)P\x1d＝/\v␎ β｜nＷσ␜␀；Ｚ␟，：@V/π␋",
	}, { // 1667
		mask: EncodeDollar | EncodeLeftCrLfHtVt,
		in:   "ε\vμ␇\a)P\x1d＝/\v␎ β｜nＷσ␜\x00；Ｚ␟，：@V/π\x00",
		out:  "ε\vμ␇\a)P\x1d＝/\v␎ β｜nＷσ␜␀；Ｚ␟，：@V/π␀",
	}, { // 1668
		mask: EncodeDollar | EncodeLeftCrLfHtVt,
		in:   "ε␋μ␇\a)P\x1d＝/\v␎ β｜nＷσ␜\x00；Ｚ␟，：@V/π\x00",
		out:  "ε␋μ␇\a)P\x1d＝/\v␎ β｜nＷσ␜␀；Ｚ␟，：@V/π␀",
	}, { // 1669
		mask: EncodeDollar | EncodeLeftCrLfHtVt,
		in:   "ε\vμ␇\a)P\x1d＝/\v␎ β｜nＷσ␜\x00；Ｚ␟，：@V/␋\x00",
		out:  "ε\vμ␇\a)P\x1d＝/\v␎ β｜nＷσ␜␀；Ｚ␟，：@V/␋␀",
	}, { // 1670
		mask: EncodeDollar | EncodeLeftCrLfHtVt,
		in:   "ε␋μ␇\a)P\x1d＝/\v␎ β｜nＷσ␜\x00；Ｚ␟，：@V/␋\x00",
		out:  "ε␋μ␇\a)P\x1d＝/\v␎ β｜nＷσ␜␀；Ｚ␟，：@V/␋␀",
	}, { // 1671
		mask: EncodeDollar | EncodeLeftCrLfHtVt,
		in:   "ε\vμ␇\a)P\x1d＝/\v␎ β｜nＷσ␜\x00；Ｚ␟，：@V/π␋",
		out:  "ε\vμ␇\a)P\x1d＝/\v␎ β｜nＷσ␜␀；Ｚ␟，：@V/π␋",
	}, { // 1672
		mask: EncodeDollar | EncodeLeftCrLfHtVt,
		in:   "ε␋μ␇\a)P\x1d＝/\v␎ β｜nＷσ␜\x00；Ｚ␟，：@V/π␋",
		out:  "ε␋μ␇\a)P\x1d＝/\v␎ β｜nＷσ␜␀；Ｚ␟，：@V/π␋",
	}, { // 1673
		mask: EncodeDollar | EncodeLeftCrLfHtVt,
		in:   "εｄμ␇\a)P\x1d＝/\v␎ β｜nＷσ␜\x00；Ｚ␟，：@V/\v\x00",
		out:  "εｄμ␇\a)P\x1d＝/\v␎ β｜nＷσ␜␀；Ｚ␟，：@V/\v␀",
	}, { // 1674
		mask: EncodeDollar | EncodeLeftCrLfHtVt,
		in:   "εｄμ␇\a)P\x1d＝/\v␎ β｜nＷσ␜\x00；Ｚ␟，：@V/␋\x00",
		out:  "εｄμ␇\a)P\x1d＝/\v␎ β｜nＷσ␜␀；Ｚ␟，：@V/␋␀",
	}, { // 1675
		mask: EncodeDollar | EncodeLeftCrLfHtVt,
		in:   "εｄμ␇\a)P\x1d＝/\v␎ β｜nＷσ␜\x00；Ｚ␟，：@V/\v␋",
		out:  "εｄμ␇\a)P\x1d＝/\v␎ β｜nＷσ␜␀；Ｚ␟，：@V/\v␋",
	}, { // 1676
		mask: EncodeDollar | EncodeLeftCrLfHtVt,
		in:   "εｄμ␇\a)P\x1d＝/\v␎ β｜nＷσ␜\x00；Ｚ␟，：@V/␋␋",
		out:  "εｄμ␇\a)P\x1d＝/\v␎ β｜nＷσ␜␀；Ｚ␟，：@V/␋␋",
	}, { // 1677
		mask: EncodeDollar | EncodeLeftCrLfHtVt,
		in:   "εｄμ␇\a)P\x1d＝/\v␎ β｜nＷσ␜\x00；Ｚ␟，：@V/π\v",
		out:  "εｄμ␇\a)P\x1d＝/\v␎ β｜nＷσ␜␀；Ｚ␟，：@V/π\v",
	}, { // 1678
		mask: EncodeDollar | EncodeLeftCrLfHtVt,
		in:   "εｄμ␇\a)P\x1d＝/\v␎ β｜nＷσ␜\x00；Ｚ␟，：@V/π␋",
		out:  "εｄμ␇\a)P\x1d＝/\v␎ β｜nＷσ␜␀；Ｚ␟，：@V/π␋",
	}, { // 1679
		mask: EncodeDollar | EncodeLeftCrLfHtVt,
		in:   "\x1a#\tρ.Ｙ；＞\x05␍\rδςＹｖe*=：α␌ψ|\x1c␍␟Vμｒr",
		out:  "\x1a#\tρ.Ｙ；＞\x05␍\rδςＹｖe*=：α␌ψ|\x1c␍␟Vμｒr",
	}, { // 1680
		mask: EncodeDollar | EncodeLeftCrLfHtVt,
		in:   "\r␍\tρ.Ｙ；＞\x05␍\rδςＹｖe*=：α␌ψ|\x1c␍␟Vμｒr",
		out:  "␍␍\tρ.Ｙ；＞\x05␍\rδςＹｖe*=：α␌ψ|\x1c␍␟Vμｒr",
	}, { // 1681
		mask: EncodeDollar | EncodeLeftCrLfHtVt,
		in:   "␍␍\tρ.Ｙ；＞\x05␍\rδςＹｖe*=：α␌ψ|\x1c␍␟Vμｒr",
		out:  "‛␍␍\tρ.Ｙ；＞\x05␍\rδςＹｖe*=：α␌ψ|\x1c␍␟Vμｒr",
	}, { // 1682
		mask: EncodeDollar | EncodeLeftCrLfHtVt,
		in:   "\r#\tρ.Ｙ；＞\x05␍\rδςＹｖe*=：α␌ψ|\x1c␍␟Vμ␍r",
		out:  "␍#\tρ.Ｙ；＞\x05␍\rδςＹｖe*=：α␌ψ|\x1c␍␟Vμ␍r",
	}, { // 1683
		mask: EncodeDollar | EncodeLeftCrLfHtVt,
		in:   "␍#\tρ.Ｙ；＞\x05␍\rδςＹｖe*=：α␌ψ|\x1c␍␟Vμ␍r",
		out:  "‛␍#\tρ.Ｙ；＞\x05␍\rδςＹｖe*=：α␌ψ|\x1c␍␟Vμ␍r",
	}, { // 1684
		mask: EncodeDollar | EncodeLeftCrLfHtVt,
		in:   "\r#\tρ.Ｙ；＞\x05␍\rδςＹｖe*=：α␌ψ|\x1c␍␟Vμｒ␍",
		out:  "␍#\tρ.Ｙ；＞\x05␍\rδςＹｖe*=：α␌ψ|\x1c␍␟Vμｒ␍",
	}, { // 1685
		mask: EncodeDollar | EncodeLeftCrLfHtVt,
		in:   "␍#\tρ.Ｙ；＞\x05␍\rδςＹｖe*=：α␌ψ|\x1c␍␟Vμｒ␍",
		out:  "‛␍#\tρ.Ｙ；＞\x05␍\rδςＹｖe*=：α␌ψ|\x1c␍␟Vμｒ␍",
	}, { // 1686
		mask: EncodeDollar | EncodeLeftCrLfHtVt,
		in:   "\x1a\r\tρ.Ｙ；＞\x05␍\rδςＹｖe*=：α␌ψ|\x1c␍␟Vμｒr",
		out:  "\x1a\r\tρ.Ｙ；＞\x05␍\rδςＹｖe*=：α␌ψ|\x1c␍␟Vμｒr",
	}, { // 1687
		mask: EncodeDollar | EncodeLeftCrLfHtVt,
		in:   "\x1a␍\tρ.Ｙ；＞\x05␍\rδςＹｖe*=：α␌ψ|\x1c␍␟Vμｒr",
		out:  "\x1a␍\tρ.Ｙ；＞\x05␍\rδςＹｖe*=：α␌ψ|\x1c␍␟Vμｒr",
	}, { // 1688
		mask: EncodeDollar | EncodeLeftCrLfHtVt,
		in:   "\x1a\r\tρ.Ｙ；＞\x05␍\rδςＹｖe*=：α␌ψ|\x1c␍␟Vμ␍r",
		out:  "\x1a\r\tρ.Ｙ；＞\x05␍\rδςＹｖe*=：α␌ψ|\x1c␍␟Vμ␍r",
	}, { // 1689
		mask: EncodeDollar | EncodeLeftCrLfHtVt,
		in:   "\x1a␍\tρ.Ｙ；＞\x05␍\rδςＹｖe*=：α␌ψ|\x1c␍␟Vμ␍r",
		out:  "\x1a␍\tρ.Ｙ；＞\x05␍\rδςＹｖe*=：α␌ψ|\x1c␍␟Vμ␍r",
	}, { // 1690
		mask: EncodeDollar | EncodeLeftCrLfHtVt,
		in:   "\x1a\r\tρ.Ｙ；＞\x05␍\rδςＹｖe*=：α␌ψ|\x1c␍␟Vμｒ␍",
		out:  "\x1a\r\tρ.Ｙ；＞\x05␍\rδςＹｖe*=：α␌ψ|\x1c␍␟Vμｒ␍",
	}, { // 1691
		mask: EncodeDollar | EncodeLeftCrLfHtVt,
		in:   "\x1a␍\tρ.Ｙ；＞\x05␍\rδςＹｖe*=：α␌ψ|\x1c␍␟Vμｒ␍",
		out:  "\x1a␍\tρ.Ｙ；＞\x05␍\rδςＹｖe*=：α␌ψ|\x1c␍␟Vμｒ␍",
	}, { // 1692
		mask: EncodeDollar | EncodeLeftCrLfHtVt,
		in:   "\x1a#\tρ.Ｙ；＞\x05␍\rδςＹｖe*=：α␌ψ|\x1c␍␟Vμ\rr",
		out:  "\x1a#\tρ.Ｙ；＞\x05␍\rδςＹｖe*=：α␌ψ|\x1c␍␟Vμ\rr",
	}, { // 1693
		mask: EncodeDollar | EncodeLeftCrLfHtVt,
		in:   "\x1a#\tρ.Ｙ；＞\x05␍\rδςＹｖe*=：α␌ψ|\x1c␍␟Vμ␍r",
		out:  "\x1a#\tρ.Ｙ；＞\x05␍\rδςＹｖe*=：α␌ψ|\x1c␍␟Vμ␍r",
	}, { // 1694
		mask: EncodeDollar | EncodeLeftCrLfHtVt,
		in:   "\x1a#\tρ.Ｙ；＞\x05␍\rδςＹｖe*=：α␌ψ|\x1c␍␟Vμ\r␍",
		out:  "\x1a#\tρ.Ｙ；＞\x05␍\rδςＹｖe*=：α␌ψ|\x1c␍␟Vμ\r␍",
	}, { // 1695
		mask: EncodeDollar | EncodeLeftCrLfHtVt,
		in:   "\x1a#\tρ.Ｙ；＞\x05␍\rδςＹｖe*=：α␌ψ|\x1c␍␟Vμ␍␍",
		out:  "\x1a#\tρ.Ｙ；＞\x05␍\rδςＹｖe*=：α␌ψ|\x1c␍␟Vμ␍␍",
	}, { // 1696
		mask: EncodeDollar | EncodeLeftCrLfHtVt,
		in:   "\x1a#\tρ.Ｙ；＞\x05␍\rδςＹｖe*=：α␌ψ|\x1c␍␟Vμｒ\r",
		out:  "\x1a#\tρ.Ｙ；＞\x05␍\rδςＹｖe*=：α␌ψ|\x1c␍␟Vμｒ\r",
	}, { // 1697
		mask: EncodeDollar | EncodeLeftCrLfHtVt,
		in:   "\x1a#\tρ.Ｙ；＞\x05␍\rδςＹｖe*=：α␌ψ|\x1c␍␟Vμｒ␍",
		out:  "\x1a#\tρ.Ｙ；＞\x05␍\rδςＹｖe*=：α␌ψ|\x1c␍␟Vμｒ␍",
	}, { // 1698
		mask: EncodeDoubleQuote | EncodeLeftCrLfHtVt,
		in:   "\rZ␆＊vγU\"Ｕｘ\t．␋*υZ␓ｑ;\x06ε\n\x05␚｜ξχεＴ\x1c",
		out:  "␍Z␆＊vγU＂Ｕｘ\t．␋*υZ␓ｑ;\x06ε\n\x05␚｜ξχεＴ\x1c",
	}, { // 1699
		mask: EncodeDoubleQuote | EncodeLeftCrLfHtVt,
		in:   "\t␉␆＊vγU\"Ｕｘ\t．␋*υZ␓ｑ;\x06ε\n\x05␚｜ξχεＴ\x1c",
		out:  "␉␉␆＊vγU＂Ｕｘ\t．␋*υZ␓ｑ;\x06ε\n\x05␚｜ξχεＴ\x1c",
	}, { // 1700
		mask: EncodeDoubleQuote | EncodeLeftCrLfHtVt,
		in:   "␉␉␆＊vγU\"Ｕｘ\t．␋*υZ␓ｑ;\x06ε\n\x05␚｜ξχεＴ\x1c",
		out:  "‛␉␉␆＊vγU＂Ｕｘ\t．␋*υZ␓ｑ;\x06ε\n\x05␚｜ξχεＴ\x1c",
	}, { // 1701
		mask: EncodeDoubleQuote | EncodeLeftCrLfHtVt,
		in:   "\tZ␆＊vγU\"Ｕｘ\t．␋*υZ␓ｑ;\x06ε\n\x05␚｜ξχε␉\x1c",
		out:  "␉Z␆＊vγU＂Ｕｘ\t．␋*υZ␓ｑ;\x06ε\n\x05␚｜ξχε␉\x1c",
	}, { // 1702
		mask: EncodeDoubleQuote | EncodeLeftCrLfHtVt,
		in:   "␉Z␆＊vγU\"Ｕｘ\t．␋*υZ␓ｑ;\x06ε\n\x05␚｜ξχε␉\x1c",
		out:  "‛␉Z␆＊vγU＂Ｕｘ\t．␋*υZ␓ｑ;\x06ε\n\x05␚｜ξχε␉\x1c",
	}, { // 1703
		mask: EncodeDoubleQuote | EncodeLeftCrLfHtVt,
		in:   "\tZ␆＊vγU\"Ｕｘ\t．␋*υZ␓ｑ;\x06ε\n\x05␚｜ξχεＴ␉",
		out:  "␉Z␆＊vγU＂Ｕｘ\t．␋*υZ␓ｑ;\x06ε\n\x05␚｜ξχεＴ␉",
	}, { // 1704
		mask: EncodeDoubleQuote | EncodeLeftCrLfHtVt,
		in:   "␉Z␆＊vγU\"Ｕｘ\t．␋*υZ␓ｑ;\x06ε\n\x05␚｜ξχεＴ␉",
		out:  "‛␉Z␆＊vγU＂Ｕｘ\t．␋*υZ␓ｑ;\x06ε\n\x05␚｜ξχεＴ␉",
	}, { // 1705
		mask: EncodeDoubleQuote | EncodeLeftCrLfHtVt,
		in:   "\r\t␆＊vγU\"Ｕｘ\t．␋*υZ␓ｑ;\x06ε\n\x05␚｜ξχεＴ\x1c",
		out:  "␍\t␆＊vγU＂Ｕｘ\t．␋*υZ␓ｑ;\x06ε\n\x05␚｜ξχεＴ\x1c",
	}, { // 1706
		mask: EncodeDoubleQuote | EncodeLeftCrLfHtVt,
		in:   "\r␉␆＊vγU\"Ｕｘ\t．␋*υZ␓ｑ;\x06ε\n\x05␚｜ξχεＴ\x1c",
		out:  "␍␉␆＊vγU＂Ｕｘ\t．␋*υZ␓ｑ;\x06ε\n\x05␚｜ξχεＴ\x1c",
	}, { // 1707
		mask: EncodeDoubleQuote | EncodeLeftCrLfHtVt,
		in:   "\r\t␆＊vγU\"Ｕｘ\t．␋*υZ␓ｑ;\x06ε\n\x05␚｜ξχε␉\x1c",
		out:  "␍\t␆＊vγU＂Ｕｘ\t．␋*υZ␓ｑ;\x06ε\n\x05␚｜ξχε␉\x1c",
	}, { // 1708
		mask: EncodeDoubleQuote | EncodeLeftCrLfHtVt,
		in:   "\r␉␆＊vγU\"Ｕｘ\t．␋*υZ␓ｑ;\x06ε\n\x05␚｜ξχε␉\x1c",
		out:  "␍␉␆＊vγU＂Ｕｘ\t．␋*υZ␓ｑ;\x06ε\n\x05␚｜ξχε␉\x1c",
	}, { // 1709
		mask: EncodeDoubleQuote | EncodeLeftCrLfHtVt,
		in:   "\r\t␆＊vγU\"Ｕｘ\t．␋*υZ␓ｑ;\x06ε\n\x05␚｜ξχεＴ␉",
		out:  "␍\t␆＊vγU＂Ｕｘ\t．␋*υZ␓ｑ;\x06ε\n\x05␚｜ξχεＴ␉",
	}, { // 1710
		mask: EncodeDoubleQuote | EncodeLeftCrLfHtVt,
		in:   "\r␉␆＊vγU\"Ｕｘ\t．␋*υZ␓ｑ;\x06ε\n\x05␚｜ξχεＴ␉",
		out:  "␍␉␆＊vγU＂Ｕｘ\t．␋*υZ␓ｑ;\x06ε\n\x05␚｜ξχεＴ␉",
	}, { // 1711
		mask: EncodeDoubleQuote | EncodeLeftCrLfHtVt,
		in:   "\rZ␆＊vγU\"Ｕｘ\t．␋*υZ␓ｑ;\x06ε\n\x05␚｜ξχε\t\x1c",
		out:  "␍Z␆＊vγU＂Ｕｘ\t．␋*υZ␓ｑ;\x06ε\n\x05␚｜ξχε\t\x1c",
	}, { // 1712
		mask: EncodeDoubleQuote | EncodeLeftCrLfHtVt,
		in:   "\rZ␆＊vγU\"Ｕｘ\t．␋*υZ␓ｑ;\x06ε\n\x05␚｜ξχε␉\x1c",
		out:  "␍Z␆＊vγU＂Ｕｘ\t．␋*υZ␓ｑ;\x06ε\n\x05␚｜ξχε␉\x1c",
	}, { // 1713
		mask: EncodeDoubleQuote | EncodeLeftCrLfHtVt,
		in:   "\rZ␆＊vγU\"Ｕｘ\t．␋*υZ␓ｑ;\x06ε\n\x05␚｜ξχε\t␉",
		out:  "␍Z␆＊vγU＂Ｕｘ\t．␋*υZ␓ｑ;\x06ε\n\x05␚｜ξχε\t␉",
	}, { // 1714
		mask: EncodeDoubleQuote | EncodeLeftCrLfHtVt,
		in:   "\rZ␆＊vγU\"Ｕｘ\t．␋*υZ␓ｑ;\x06ε\n\x05␚｜ξχε␉␉",
		out:  "␍Z␆＊vγU＂Ｕｘ\t．␋*υZ␓ｑ;\x06ε\n\x05␚｜ξχε␉␉",
	}, { // 1715
		mask: EncodeDoubleQuote | EncodeLeftCrLfHtVt,
		in:   "\rZ␆＊vγU\"Ｕｘ\t．␋*υZ␓ｑ;\x06ε\n\x05␚｜ξχεＴ\t",
		out:  "␍Z␆＊vγU＂Ｕｘ\t．␋*υZ␓ｑ;\x06ε\n\x05␚｜ξχεＴ\t",
	}, { // 1716
		mask: EncodeDoubleQuote | EncodeLeftCrLfHtVt,
		in:   "\rZ␆＊vγU\"Ｕｘ\t．␋*υZ␓ｑ;\x06ε\n\x05␚｜ξχεＴ␉",
		out:  "␍Z␆＊vγU＂Ｕｘ\t．␋*υZ␓ｑ;\x06ε\n\x05␚｜ξχεＴ␉",
	}, { // 1717
		mask: EncodeDoubleQuote | EncodeLeftCrLfHtVt,
		in:   "␋ιｅ8Oιｗ␛{␆\nι6\aχ\rπ␉#;ｚＤςf␎～，␛`\x1c",
		out:  "‛␋ιｅ8Oιｗ␛{␆\nι6\aχ\rπ␉#;ｚＤςf␎～，␛`\x1c",
	}, { // 1718
		mask: EncodeDoubleQuote | EncodeLeftCrLfHtVt,
		in:   "\n␊ｅ8Oιｗ␛{␆\nι6\aχ\rπ␉#;ｚＤςf␎～，␛`\x1c",
		out:  "␊␊ｅ8Oιｗ␛{␆\nι6\aχ\rπ␉#;ｚＤςf␎～，␛`\x1c",
	}, { // 1719
		mask: EncodeDoubleQuote | EncodeLeftCrLfHtVt,
		in:   "␊␊ｅ8Oιｗ␛{␆\nι6\aχ\rπ␉#;ｚＤςf␎～，␛`\x1c",
		out:  "‛␊␊ｅ8Oιｗ␛{␆\nι6\aχ\rπ␉#;ｚＤςf␎～，␛`\x1c",
	}, { // 1720
		mask: EncodeDoubleQuote | EncodeLeftCrLfHtVt,
		in:   "\nιｅ8Oιｗ␛{␆\nι6\aχ\rπ␉#;ｚＤςf␎～，␛␊\x1c",
		out:  "␊ιｅ8Oιｗ␛{␆\nι6\aχ\rπ␉#;ｚＤςf␎～，␛␊\x1c",
	}, { // 1721
		mask: EncodeDoubleQuote | EncodeLeftCrLfHtVt,
		in:   "␊ιｅ8Oιｗ␛{␆\nι6\aχ\rπ␉#;ｚＤςf␎～，␛␊\x1c",
		out:  "‛␊ιｅ8Oιｗ␛{␆\nι6\aχ\rπ␉#;ｚＤςf␎～，␛␊\x1c",
	}, { // 1722
		mask: EncodeDoubleQuote | EncodeLeftCrLfHtVt,
		in:   "\nιｅ8Oιｗ␛{␆\nι6\aχ\rπ␉#;ｚＤςf␎～，␛`␊",
		out:  "␊ιｅ8Oιｗ␛{␆\nι6\aχ\rπ␉#;ｚＤςf␎～，␛`␊",
	}, { // 1723
		mask: EncodeDoubleQuote | EncodeLeftCrLfHtVt,
		in:   "␊ιｅ8Oιｗ␛{␆\nι6\aχ\rπ␉#;ｚＤςf␎～，␛`␊",
		out:  "‛␊ιｅ8Oιｗ␛{␆\nι6\aχ\rπ␉#;ｚＤςf␎～，␛`␊",
	}, { // 1724
		mask: EncodeDoubleQuote | EncodeLeftCrLfHtVt,
		in:   "␋\nｅ8Oιｗ␛{␆\nι6\aχ\rπ␉#;ｚＤςf␎～，␛`\x1c",
		out:  "‛␋\nｅ8Oιｗ␛{␆\nι6\aχ\rπ␉#;ｚＤςf␎～，␛`\x1c",
	}, { // 1725
		mask: EncodeDoubleQuote | EncodeLeftCrLfHtVt,
		in:   "␋␊ｅ8Oιｗ␛{␆\nι6\aχ\rπ␉#;ｚＤςf␎～，␛`\x1c",
		out:  "‛␋␊ｅ8Oιｗ␛{␆\nι6\aχ\rπ␉#;ｚＤςf␎～，␛`\x1c",
	}, { // 1726
		mask: EncodeDoubleQuote | EncodeLeftCrLfHtVt,
		in:   "␋\nｅ8Oιｗ␛{␆\nι6\aχ\rπ␉#;ｚＤςf␎～，␛␊\x1c",
		out:  "‛␋\nｅ8Oιｗ␛{␆\nι6\aχ\rπ␉#;ｚＤςf␎～，␛␊\x1c",
	}, { // 1727
		mask: EncodeDoubleQuote | EncodeLeftCrLfHtVt,
		in:   "␋␊ｅ8Oιｗ␛{␆\nι6\aχ\rπ␉#;ｚＤςf␎～，␛␊\x1c",
		out:  "‛␋␊ｅ8Oιｗ␛{␆\nι6\aχ\rπ␉#;ｚＤςf␎～，␛␊\x1c",
	}, { // 1728
		mask: EncodeDoubleQuote | EncodeLeftCrLfHtVt,
		in:   "␋\nｅ8Oιｗ␛{␆\nι6\aχ\rπ␉#;ｚＤςf␎～，␛`␊",
		out:  "‛␋\nｅ8Oιｗ␛{␆\nι6\aχ\rπ␉#;ｚＤςf␎～，␛`␊",
	}, { // 1729
		mask: EncodeDoubleQuote | EncodeLeftCrLfHtVt,
		in:   "␋␊ｅ8Oιｗ␛{␆\nι6\aχ\rπ␉#;ｚＤςf␎～，␛`␊",
		out:  "‛␋␊ｅ8Oιｗ␛{␆\nι6\aχ\rπ␉#;ｚＤςf␎～，␛`␊",
	}, { // 1730
		mask: EncodeDoubleQuote | EncodeLeftCrLfHtVt,
		in:   "␋ιｅ8Oιｗ␛{␆\nι6\aχ\rπ␉#;ｚＤςf␎～，␛\n\x1c",
		out:  "‛␋ιｅ8Oιｗ␛{␆\nι6\aχ\rπ␉#;ｚＤςf␎～，␛\n\x1c",
	}, { // 1731
		mask: EncodeDoubleQuote | EncodeLeftCrLfHtVt,
		in:   "␋ιｅ8Oιｗ␛{␆\nι6\aχ\rπ␉#;ｚＤςf␎～，␛␊\x1c",
		out:  "‛␋ιｅ8Oιｗ␛{␆\nι6\aχ\rπ␉#;ｚＤςf␎～，␛␊\x1c",
	}, { // 1732
		mask: EncodeDoubleQuote | EncodeLeftCrLfHtVt,
		in:   "␋ιｅ8Oιｗ␛{␆\nι6\aχ\rπ␉#;ｚＤςf␎～，␛\n␊",
		out:  "‛␋ιｅ8Oιｗ␛{␆\nι6\aχ\rπ␉#;ｚＤςf␎～，␛\n␊",
	}, { // 1733
		mask: EncodeDoubleQuote | EncodeLeftCrLfHtVt,
		in:   "␋ιｅ8Oιｗ␛{␆\nι6\aχ\rπ␉#;ｚＤςf␎～，␛␊␊",
		out:  "‛␋ιｅ8Oιｗ␛{␆\nι6\aχ\rπ␉#;ｚＤςf␎～，␛␊␊",
	}, { // 1734
		mask: EncodeDoubleQuote | EncodeLeftCrLfHtVt,
		in:   "␋ιｅ8Oιｗ␛{␆\nι6\aχ\rπ␉#;ｚＤςf␎～，␛`\n",
		out:  "‛␋ιｅ8Oιｗ␛{␆\nι6\aχ\rπ␉#;ｚＤςf␎～，␛`\n",
	}, { // 1735
		mask: EncodeDoubleQuote | EncodeLeftCrLfHtVt,
		in:   "␋ιｅ8Oιｗ␛{␆\nι6\aχ\rπ␉#;ｚＤςf␎～，␛`␊",
		out:  "‛␋ιｅ8Oιｗ␛{␆\nι6\aχ\rπ␉#;ｚＤςf␎～，␛`␊",
	}, { // 1736
		mask: EncodeDoubleQuote | EncodeLeftCrLfHtVt,
		in:   "γ＼＇ｐ␔␀␞9ψε\vZ\x00`␇０）κC３\x1daａ#υmη\x01\v｀",
		out:  "γ＼＇ｐ␔‛␀␞9ψε\vZ␀`␇０）κC３\x1daａ#υmη\x01\v｀",
	}, { // 1737
		mask: EncodeDoubleQuote | EncodeLeftCrLfHtVt,
		in:   "\v␋＇ｐ␔␀␞9ψε\vZ\x00`␇０）κC３\x1daａ#υmη\x01\v｀",
		out:  "␋␋＇ｐ␔‛␀␞9ψε\vZ␀`␇０）κC３\x1daａ#υmη\x01\v｀",
	}, { // 1738
		mask: EncodeDoubleQuote | EncodeLeftCrLfHtVt,
		in:   "␋␋＇ｐ␔␀␞9ψε\vZ\x00`␇０）κC３\x1daａ#υmη\x01\v｀",
		out:  "‛␋␋＇ｐ␔‛␀␞9ψε\vZ␀`␇０）κC３\x1daａ#υmη\x01\v｀",
	}, { // 1739
		mask: EncodeDoubleQuote | EncodeLeftCrLfHtVt,
		in:   "\v＼＇ｐ␔␀␞9ψε\vZ\x00`␇０）κC３\x1daａ#υmη\x01␋｀",
		out:  "␋＼＇ｐ␔‛␀␞9ψε\vZ␀`␇０）κC３\x1daａ#υmη\x01␋｀",
	}, { // 1740
		mask: EncodeDoubleQuote | EncodeLeftCrLfHtVt,
		in:   "␋＼＇ｐ␔␀␞9ψε\vZ\x00`␇０）κC３\x1daａ#υmη\x01␋｀",
		out:  "‛␋＼＇ｐ␔‛␀␞9ψε\vZ␀`␇０）κC３\x1daａ#υmη\x01␋｀",
	}, { // 1741
		mask: EncodeDoubleQuote | EncodeLeftCrLfHtVt,
		in:   "\v＼＇ｐ␔␀␞9ψε\vZ\x00`␇０）κC３\x1daａ#υmη\x01\v␋",
		out:  "␋＼＇ｐ␔‛␀␞9ψε\vZ␀`␇０）κC３\x1daａ#υmη\x01\v␋",
	}, { // 1742
		mask: EncodeDoubleQuote | EncodeLeftCrLfHtVt,
		in:   "␋＼＇ｐ␔␀␞9ψε\vZ\x00`␇０）κC３\x1daａ#υmη\x01\v␋",
		out:  "‛␋＼＇ｐ␔‛␀␞9ψε\vZ␀`␇０）κC３\x1daａ#υmη\x01\v␋",
	}, { // 1743
		mask: EncodeDoubleQuote | EncodeLeftCrLfHtVt,
		in:   "γ\v＇ｐ␔␀␞9ψε\vZ\x00`␇０）κC３\x1daａ#υmη\x01\v｀",
		out:  "γ\v＇ｐ␔‛␀␞9ψε\vZ␀`␇０）κC３\x1daａ#υmη\x01\v｀",
	}, { // 1744
		mask: EncodeDoubleQuote | EncodeLeftCrLfHtVt,
		in:   "γ␋＇ｐ␔␀␞9ψε\vZ\x00`␇０）κC３\x1daａ#υmη\x01\v｀",
		out:  "γ␋＇ｐ␔‛␀␞9ψε\vZ␀`␇０）κC３\x1daａ#υmη\x01\v｀",
	}, { // 1745
		mask: EncodeDoubleQuote | EncodeLeftCrLfHtVt,
		in:   "γ\v＇ｐ␔␀␞9ψε\vZ\x00`␇０）κC３\x1daａ#υmη\x01␋｀",
		out:  "γ\v＇ｐ␔‛␀␞9ψε\vZ␀`␇０）κC３\x1daａ#υmη\x01␋｀",
	}, { // 1746
		mask: EncodeDoubleQuote | EncodeLeftCrLfHtVt,
		in:   "γ␋＇ｐ␔␀␞9ψε\vZ\x00`␇０）κC３\x1daａ#υmη\x01␋｀",
		out:  "γ␋＇ｐ␔‛␀␞9ψε\vZ␀`␇０）κC３\x1daａ#υmη\x01␋｀",
	}, { // 1747
		mask: EncodeDoubleQuote | EncodeLeftCrLfHtVt,
		in:   "γ\v＇ｐ␔␀␞9ψε\vZ\x00`␇０）κC３\x1daａ#υmη\x01\v␋",
		out:  "γ\v＇ｐ␔‛␀␞9ψε\vZ␀`␇０）κC３\x1daａ#υmη\x01\v␋",
	}, { // 1748
		mask: EncodeDoubleQuote | EncodeLeftCrLfHtVt,
		in:   "γ␋＇ｐ␔␀␞9ψε\vZ\x00`␇０）κC３\x1daａ#υmη\x01\v␋",
		out:  "γ␋＇ｐ␔‛␀␞9ψε\vZ␀`␇０）κC３\x1daａ#υmη\x01\v␋",
	}, { // 1749
		mask: EncodeDoubleQuote | EncodeLeftCrLfHtVt,
		in:   "γ＼＇ｐ␔␀␞9ψε\vZ\x00`␇０）κC３\x1daａ#υmη\x01\v｀",
		out:  "γ＼＇ｐ␔‛␀␞9ψε\vZ␀`␇０）κC３\x1daａ#υmη\x01\v｀",
	}, { // 1750
		mask: EncodeDoubleQuote | EncodeLeftCrLfHtVt,
		in:   "γ＼＇ｐ␔␀␞9ψε\vZ\x00`␇０）κC３\x1daａ#υmη\x01␋｀",
		out:  "γ＼＇ｐ␔‛␀␞9ψε\vZ␀`␇０）κC３\x1daａ#υmη\x01␋｀",
	}, { // 1751
		mask: EncodeDoubleQuote | EncodeLeftCrLfHtVt,
		in:   "γ＼＇ｐ␔␀␞9ψε\vZ\x00`␇０）κC３\x1daａ#υmη\x01\v␋",
		out:  "γ＼＇ｐ␔‛␀␞9ψε\vZ␀`␇０）κC３\x1daａ#υmη\x01\v␋",
	}, { // 1752
		mask: EncodeDoubleQuote | EncodeLeftCrLfHtVt,
		in:   "γ＼＇ｐ␔␀␞9ψε\vZ\x00`␇０）κC３\x1daａ#υmη\x01␋␋",
		out:  "γ＼＇ｐ␔‛␀␞9ψε\vZ␀`␇０）κC３\x1daａ#υmη\x01␋␋",
	}, { // 1753
		mask: EncodeDoubleQuote | EncodeLeftCrLfHtVt,
		in:   "γ＼＇ｐ␔␀␞9ψε\vZ\x00`␇０）κC３\x1daａ#υmη\x01\v\v",
		out:  "γ＼＇ｐ␔‛␀␞9ψε\vZ␀`␇０）κC３\x1daａ#υmη\x01\v\v",
	}, { // 1754
		mask: EncodeDoubleQuote | EncodeLeftCrLfHtVt,
		in:   "γ＼＇ｐ␔␀␞9ψε\vZ\x00`␇０）κC３\x1daａ#υmη\x01\v␋",
		out:  "γ＼＇ｐ␔‛␀␞9ψε\vZ␀`␇０）κC３\x1daａ#υmη\x01\v␋",
	}, { // 1755
		mask: EncodeDoubleQuote | EncodeLeftCrLfHtVt,
		in:   "\x014␓ν１\uff00β[βμ\r]]␓＃χｕι\x1d＊＼0\a␁\tＩ:Ａ\x0e␌",
		out:  "\x014␓ν１\uff00β[βμ\r]]␓＃χｕι\x1d＊＼0\a␁\tＩ:Ａ\x0e␌",
	}, { // 1756
		mask: EncodeDoubleQuote | EncodeLeftCrLfHtVt,
		in:   "\r␍␓ν１\uff00β[βμ\r]]␓＃χｕι\x1d＊＼0\a␁\tＩ:Ａ\x0e␌",
		out:  "␍␍␓ν１\uff00β[βμ\r]]␓＃χｕι\x1d＊＼0\a␁\tＩ:Ａ\x0e␌",
	}, { // 1757
		mask: EncodeDoubleQuote | EncodeLeftCrLfHtVt,
		in:   "␍␍␓ν１\uff00β[βμ\r]]␓＃χｕι\x1d＊＼0\a␁\tＩ:Ａ\x0e␌",
		out:  "‛␍␍␓ν１\uff00β[βμ\r]]␓＃χｕι\x1d＊＼0\a␁\tＩ:Ａ\x0e␌",
	}, { // 1758
		mask: EncodeDoubleQuote | EncodeLeftCrLfHtVt,
		in:   "\r4␓ν１\uff00β[βμ\r]]␓＃χｕι\x1d＊＼0\a␁\tＩ:Ａ␍␌",
		out:  "␍4␓ν１\uff00β[βμ\r]]␓＃χｕι\x1d＊＼0\a␁\tＩ:Ａ␍␌",
	}, { // 1759
		mask: EncodeDoubleQuote | EncodeLeftCrLfHtVt,
		in:   "␍4␓ν１\uff00β[βμ\r]]␓＃χｕι\x1d＊＼0\a␁\tＩ:Ａ␍␌",
		out:  "‛␍4␓ν１\uff00β[βμ\r]]␓＃χｕι\x1d＊＼0\a␁\tＩ:Ａ␍␌",
	}, { // 1760
		mask: EncodeDoubleQuote | EncodeLeftCrLfHtVt,
		in:   "\r4␓ν１\uff00β[βμ\r]]␓＃χｕι\x1d＊＼0\a␁\tＩ:Ａ\x0e␍",
		out:  "␍4␓ν１\uff00β[βμ\r]]␓＃χｕι\x1d＊＼0\a␁\tＩ:Ａ\x0e␍",
	}, { // 1761
		mask: EncodeDoubleQuote | EncodeLeftCrLfHtVt,
		in:   "␍4␓ν１\uff00β[βμ\r]]␓＃χｕι\x1d＊＼0\a␁\tＩ:Ａ\x0e␍",
		out:  "‛␍4␓ν１\uff00β[βμ\r]]␓＃χｕι\x1d＊＼0\a␁\tＩ:Ａ\x0e␍",
	}, { // 1762
		mask: EncodeDoubleQuote | EncodeLeftCrLfHtVt,
		in:   "\x01\r␓ν１\uff00β[βμ\r]]␓＃χｕι\x1d＊＼0\a␁\tＩ:Ａ\x0e␌",
		out:  "\x01\r␓ν１\uff00β[βμ\r]]␓＃χｕι\x1d＊＼0\a␁\tＩ:Ａ\x0e␌",
	}, { // 1763
		mask: EncodeDoubleQuote | EncodeLeftCrLfHtVt,
		in:   "\x01␍␓ν１\uff00β[βμ\r]]␓＃χｕι\x1d＊＼0\a␁\tＩ:Ａ\x0e␌",
		out:  "\x01␍␓ν１\uff00β[βμ\r]]␓＃χｕι\x1d＊＼0\a␁\tＩ:Ａ\x0e␌",
	}, { // 1764
		mask: EncodeDoubleQuote | EncodeLeftCrLfHtVt,
		in:   "\x01\r␓ν１\uff00β[βμ\r]]␓＃χｕι\x1d＊＼0\a␁\tＩ:Ａ␍␌",
		out:  "\x01\r␓ν１\uff00β[βμ\r]]␓＃χｕι\x1d＊＼0\a␁\tＩ:Ａ␍␌",
	}, { // 1765
		mask: EncodeDoubleQuote | EncodeLeftCrLfHtVt,
		in:   "\x01␍␓ν１\uff00β[βμ\r]]␓＃χｕι\x1d＊＼0\a␁\tＩ:Ａ␍␌",
		out:  "\x01␍␓ν１\uff00β[βμ\r]]␓＃χｕι\x1d＊＼0\a␁\tＩ:Ａ␍␌",
	}, { // 1766
		mask: EncodeDoubleQuote | EncodeLeftCrLfHtVt,
		in:   "\x01\r␓ν１\uff00β[βμ\r]]␓＃χｕι\x1d＊＼0\a␁\tＩ:Ａ\x0e␍",
		out:  "\x01\r␓ν１\uff00β[βμ\r]]␓＃χｕι\x1d＊＼0\a␁\tＩ:Ａ\x0e␍",
	}, { // 1767
		mask: EncodeDoubleQuote | EncodeLeftCrLfHtVt,
		in:   "\x01␍␓ν１\uff00β[βμ\r]]␓＃χｕι\x1d＊＼0\a␁\tＩ:Ａ\x0e␍",
		out:  "\x01␍␓ν１\uff00β[βμ\r]]␓＃χｕι\x1d＊＼0\a␁\tＩ:Ａ\x0e␍",
	}, { // 1768
		mask: EncodeDoubleQuote | EncodeLeftCrLfHtVt,
		in:   "\x014␓ν１\uff00β[βμ\r]]␓＃χｕι\x1d＊＼0\a␁\tＩ:Ａ\r␌",
		out:  "\x014␓ν１\uff00β[βμ\r]]␓＃χｕι\x1d＊＼0\a␁\tＩ:Ａ\r␌",
	}, { // 1769
		mask: EncodeDoubleQuote | EncodeLeftCrLfHtVt,
		in:   "\x014␓ν１\uff00β[βμ\r]]␓＃χｕι\x1d＊＼0\a␁\tＩ:Ａ␍␌",
		out:  "\x014␓ν１\uff00β[βμ\r]]␓＃χｕι\x1d＊＼0\a␁\tＩ:Ａ␍␌",
	}, { // 1770
		mask: EncodeDoubleQuote | EncodeLeftCrLfHtVt,
		in:   "\x014␓ν１\uff00β[βμ\r]]␓＃χｕι\x1d＊＼0\a␁\tＩ:Ａ\r␍",
		out:  "\x014␓ν１\uff00β[βμ\r]]␓＃χｕι\x1d＊＼0\a␁\tＩ:Ａ\r␍",
	}, { // 1771
		mask: EncodeDoubleQuote | EncodeLeftCrLfHtVt,
		in:   "\x014␓ν１\uff00β[βμ\r]]␓＃χｕι\x1d＊＼0\a␁\tＩ:Ａ␍␍",
		out:  "\x014␓ν１\uff00β[βμ\r]]␓＃χｕι\x1d＊＼0\a␁\tＩ:Ａ␍␍",
	}, { // 1772
		mask: EncodeDoubleQuote | EncodeLeftCrLfHtVt,
		in:   "\x014␓ν１\uff00β[βμ\r]]␓＃χｕι\x1d＊＼0\a␁\tＩ:Ａ\x0e\r",
		out:  "\x014␓ν１\uff00β[βμ\r]]␓＃χｕι\x1d＊＼0\a␁\tＩ:Ａ\x0e\r",
	}, { // 1773
		mask: EncodeDoubleQuote | EncodeLeftCrLfHtVt,
		in:   "\x014␓ν１\uff00β[βμ\r]]␓＃χｕι\x1d＊＼0\a␁\tＩ:Ａ\x0e␍",
		out:  "\x014␓ν１\uff00β[βμ\r]]␓＃χｕι\x1d＊＼0\a␁\tＩ:Ａ\x0e␍",
	}, { // 1774
		mask: EncodeColon | EncodeLeftCrLfHtVt,
		in:   "｜\"C=)%Ｆ␙␍ξ\t]9ισｉＧ0ψ␍'\uff00␊'｜δＪＥβ\x11",
		out:  "｜\"C=)%Ｆ␙␍ξ\t]9ισｉＧ0ψ␍'\uff00␊'｜δＪＥβ\x11",
	}, { // 1775
		mask: EncodeColon | EncodeLeftCrLfHtVt,
		in:   "\t␉C=)%Ｆ␙␍ξ\t]9ισｉＧ0ψ␍'\uff00␊'｜δＪＥβ\x11",
		out:  "␉␉C=)%Ｆ␙␍ξ\t]9ισｉＧ0ψ␍'\uff00␊'｜δＪＥβ\x11",
	}, { // 1776
		mask: EncodeColon | EncodeLeftCrLfHtVt,
		in:   "␉␉C=)%Ｆ␙␍ξ\t]9ισｉＧ0ψ␍'\uff00␊'｜δＪＥβ\x11",
		out:  "‛␉␉C=)%Ｆ␙␍ξ\t]9ισｉＧ0ψ␍'\uff00␊'｜δＪＥβ\x11",
	}, { // 1777
		mask: EncodeColon | EncodeLeftCrLfHtVt,
		in:   "\t\"C=)%Ｆ␙␍ξ\t]9ισｉＧ0ψ␍'\uff00␊'｜δＪＥ␉\x11",
		out:  "␉\"C=)%Ｆ␙␍ξ\t]9ισｉＧ0ψ␍'\uff00␊'｜δＪＥ␉\x11",
	}, { // 1778
		mask: EncodeColon | EncodeLeftCrLfHtVt,
		in:   "␉\"C=)%Ｆ␙␍ξ\t]9ισｉＧ0ψ␍'\uff00␊'｜δＪＥ␉\x11",
		out:  "‛␉\"C=)%Ｆ␙␍ξ\t]9ισｉＧ0ψ␍'\uff00␊'｜δＪＥ␉\x11",
	}, { // 1779
		mask: EncodeColon | EncodeLeftCrLfHtVt,
		in:   "\t\"C=)%Ｆ␙␍ξ\t]9ισｉＧ0ψ␍'\uff00␊'｜δＪＥβ␉",
		out:  "␉\"C=)%Ｆ␙␍ξ\t]9ισｉＧ0ψ␍'\uff00␊'｜δＪＥβ␉",
	}, { // 1780
		mask: EncodeColon | EncodeLeftCrLfHtVt,
		in:   "␉\"C=)%Ｆ␙␍ξ\t]9ισｉＧ0ψ␍'\uff00␊'｜δＪＥβ␉",
		out:  "‛␉\"C=)%Ｆ␙␍ξ\t]9ισｉＧ0ψ␍'\uff00␊'｜δＪＥβ␉",
	}, { // 1781
		mask: EncodeColon | EncodeLeftCrLfHtVt,
		in:   "｜\tC=)%Ｆ␙␍ξ\t]9ισｉＧ0ψ␍'\uff00␊'｜δＪＥβ\x11",
		out:  "｜\tC=)%Ｆ␙␍ξ\t]9ισｉＧ0ψ␍'\uff00␊'｜δＪＥβ\x11",
	}, { // 1782
		mask: EncodeColon | EncodeLeftCrLfHtVt,
		in:   "｜␉C=)%Ｆ␙␍ξ\t]9ισｉＧ0ψ␍'\uff00␊'｜δＪＥβ\x11",
		out:  "｜␉C=)%Ｆ␙␍ξ\t]9ισｉＧ0ψ␍'\uff00␊'｜δＪＥβ\x11",
	}, { // 1783
		mask: EncodeColon | EncodeLeftCrLfHtVt,
		in:   "｜\tC=)%Ｆ␙␍ξ\t]9ισｉＧ0ψ␍'\uff00␊'｜δＪＥ␉\x11",
		out:  "｜\tC=)%Ｆ␙␍ξ\t]9ισｉＧ0ψ␍'\uff00␊'｜δＪＥ␉\x11",
	}, { // 1784
		mask: EncodeColon | EncodeLeftCrLfHtVt,
		in:   "｜␉C=)%Ｆ␙␍ξ\t]9ισｉＧ0ψ␍'\uff00␊'｜δＪＥ␉\x11",
		out:  "｜␉C=)%Ｆ␙␍ξ\t]9ισｉＧ0ψ␍'\uff00␊'｜δＪＥ␉\x11",
	}, { // 1785
		mask: EncodeColon | EncodeLeftCrLfHtVt,
		in:   "｜\tC=)%Ｆ␙␍ξ\t]9ισｉＧ0ψ␍'\uff00␊'｜δＪＥβ␉",
		out:  "｜\tC=)%Ｆ␙␍ξ\t]9ισｉＧ0ψ␍'\uff00␊'｜δＪＥβ␉",
	}, { // 1786
		mask: EncodeColon | EncodeLeftCrLfHtVt,
		in:   "｜␉C=)%Ｆ␙␍ξ\t]9ισｉＧ0ψ␍'\uff00␊'｜δＪＥβ␉",
		out:  "｜␉C=)%Ｆ␙␍ξ\t]9ισｉＧ0ψ␍'\uff00␊'｜δＪＥβ␉",
	}, { // 1787
		mask: EncodeColon | EncodeLeftCrLfHtVt,
		in:   "｜\"C=)%Ｆ␙␍ξ\t]9ισｉＧ0ψ␍'\uff00␊'｜δＪＥ\t\x11",
		out:  "｜\"C=)%Ｆ␙␍ξ\t]9ισｉＧ0ψ␍'\uff00␊'｜δＪＥ\t\x11",
	}, { // 1788
		mask: EncodeColon | EncodeLeftCrLfHtVt,
		in:   "｜\"C=)%Ｆ␙␍ξ\t]9ισｉＧ0ψ␍'\uff00␊'｜δＪＥ␉\x11",
		out:  "｜\"C=)%Ｆ␙␍ξ\t]9ισｉＧ0ψ␍'\uff00␊'｜δＪＥ␉\x11",
	}, { // 1789
		mask: EncodeColon | EncodeLeftCrLfHtVt,
		in:   "｜\"C=)%Ｆ␙␍ξ\t]9ισｉＧ0ψ␍'\uff00␊'｜δＪＥ\t␉",
		out:  "｜\"C=)%Ｆ␙␍ξ\t]9ισｉＧ0ψ␍'\uff00␊'｜δＪＥ\t␉",
	}, { // 1790
		mask: EncodeColon | EncodeLeftCrLfHtVt,
		in:   "｜\"C=)%Ｆ␙␍ξ\t]9ισｉＧ0ψ␍'\uff00␊'｜δＪＥ␉␉",
		out:  "｜\"C=)%Ｆ␙␍ξ\t]9ισｉＧ0ψ␍'\uff00␊'｜δＪＥ␉␉",
	}, { // 1791
		mask: EncodeColon | EncodeLeftCrLfHtVt,
		in:   "｜\"C=)%Ｆ␙␍ξ\t]9ισｉＧ0ψ␍'\uff00␊'｜δＪＥβ\t",
		out:  "｜\"C=)%Ｆ␙␍ξ\t]9ισｉＧ0ψ␍'\uff00␊'｜δＪＥβ\t",
	}, { // 1792
		mask: EncodeColon | EncodeLeftCrLfHtVt,
		in:   "｜\"C=)%Ｆ␙␍ξ\t]9ισｉＧ0ψ␍'\uff00␊'｜δＪＥβ␉",
		out:  "｜\"C=)%Ｆ␙␍ξ\t]9ισｉＧ0ψ␍'\uff00␊'｜δＪＥβ␉",
	}, { // 1793
		mask: EncodeColon | EncodeLeftCrLfHtVt,
		in:   "ηκ]␆＾\x13\x01J\x04␞\n/＋␡%９␖rU，␍γυ#␝;ψ[Ｆ［",
		out:  "ηκ]␆＾\x13\x01J\x04␞\n/＋␡%９␖rU，␍γυ#␝;ψ[Ｆ［",
	}, { // 1794
		mask: EncodeColon | EncodeLeftCrLfHtVt,
		in:   "\n␊]␆＾\x13\x01J\x04␞\n/＋␡%９␖rU，␍γυ#␝;ψ[Ｆ［",
		out:  "␊␊]␆＾\x13\x01J\x04␞\n/＋␡%９␖rU，␍γυ#␝;ψ[Ｆ［",
	}, { // 1795
		mask: EncodeColon | EncodeLeftCrLfHtVt,
		in:   "␊␊]␆＾\x13\x01J\x04␞\n/＋␡%９␖rU，␍γυ#␝;ψ[Ｆ［",
		out:  "‛␊␊]␆＾\x13\x01J\x04␞\n/＋␡%９␖rU，␍γυ#␝;ψ[Ｆ［",
	}, { // 1796
		mask: EncodeColon | EncodeLeftCrLfHtVt,
		in:   "\nκ]␆＾\x13\x01J\x04␞\n/＋␡%９␖rU，␍γυ#␝;ψ[␊［",
		out:  "␊κ]␆＾\x13\x01J\x04␞\n/＋␡%９␖rU，␍γυ#␝;ψ[␊［",
	}, { // 1797
		mask: EncodeColon | EncodeLeftCrLfHtVt,
		in:   "␊κ]␆＾\x13\x01J\x04␞\n/＋␡%９␖rU，␍γυ#␝;ψ[␊［",
		out:  "‛␊κ]␆＾\x13\x01J\x04␞\n/＋␡%９␖rU，␍γυ#␝;ψ[␊［",
	}, { // 1798
		mask: EncodeColon | EncodeLeftCrLfHtVt,
		in:   "\nκ]␆＾\x13\x01J\x04␞\n/＋␡%９␖rU，␍γυ#␝;ψ[Ｆ␊",
		out:  "␊κ]␆＾\x13\x01J\x04␞\n/＋␡%９␖rU，␍γυ#␝;ψ[Ｆ␊",
	}, { // 1799
		mask: EncodeColon | EncodeLeftCrLfHtVt,
		in:   "␊κ]␆＾\x13\x01J\x04␞\n/＋␡%９␖rU，␍γυ#␝;ψ[Ｆ␊",
		out:  "‛␊κ]␆＾\x13\x01J\x04␞\n/＋␡%９␖rU，␍γυ#␝;ψ[Ｆ␊",
	}, { // 1800
		mask: EncodeColon | EncodeLeftCrLfHtVt,
		in:   "η\n]␆＾\x13\x01J\x04␞\n/＋␡%９␖rU，␍γυ#␝;ψ[Ｆ［",
		out:  "η\n]␆＾\x13\x01J\x04␞\n/＋␡%９␖rU，␍γυ#␝;ψ[Ｆ［",
	}, { // 1801
		mask: EncodeColon | EncodeLeftCrLfHtVt,
		in:   "η␊]␆＾\x13\x01J\x04␞\n/＋␡%９␖rU，␍γυ#␝;ψ[Ｆ［",
		out:  "η␊]␆＾\x13\x01J\x04␞\n/＋␡%９␖rU，␍γυ#␝;ψ[Ｆ［",
	}, { // 1802
		mask: EncodeColon | EncodeLeftCrLfHtVt,
		in:   "η\n]␆＾\x13\x01J\x04␞\n/＋␡%９␖rU，␍γυ#␝;ψ[␊［",
		out:  "η\n]␆＾\x13\x01J\x04␞\n/＋␡%９␖rU，␍γυ#␝;ψ[␊［",
	}, { // 1803
		mask: EncodeColon | EncodeLeftCrLfHtVt,
		in:   "η␊]␆＾\x13\x01J\x04␞\n/＋␡%９␖rU，␍γυ#␝;ψ[␊［",
		out:  "η␊]␆＾\x13\x01J\x04␞\n/＋␡%９␖rU，␍γυ#␝;ψ[␊［",
	}, { // 1804
		mask: EncodeColon | EncodeLeftCrLfHtVt,
		in:   "η\n]␆＾\x13\x01J\x04␞\n/＋␡%９␖rU，␍γυ#␝;ψ[Ｆ␊",
		out:  "η\n]␆＾\x13\x01J\x04␞\n/＋␡%９␖rU，␍γυ#␝;ψ[Ｆ␊",
	}, { // 1805
		mask: EncodeColon | EncodeLeftCrLfHtVt,
		in:   "η␊]␆＾\x13\x01J\x04␞\n/＋␡%９␖rU，␍γυ#␝;ψ[Ｆ␊",
		out:  "η␊]␆＾\x13\x01J\x04␞\n/＋␡%９␖rU，␍γυ#␝;ψ[Ｆ␊",
	}, { // 1806
		mask: EncodeColon | EncodeLeftCrLfHtVt,
		in:   "ηκ]␆＾\x13\x01J\x04␞\n/＋␡%９␖rU，␍γυ#␝;ψ[\n［",
		out:  "ηκ]␆＾\x13\x01J\x04␞\n/＋␡%９␖rU，␍γυ#␝;ψ[\n［",
	}, { // 1807
		mask: EncodeColon | EncodeLeftCrLfHtVt,
		in:   "ηκ]␆＾\x13\x01J\x04␞\n/＋␡%９␖rU，␍γυ#␝;ψ[␊［",
		out:  "ηκ]␆＾\x13\x01J\x04␞\n/＋␡%９␖rU，␍γυ#␝;ψ[␊［",
	}, { // 1808
		mask: EncodeColon | EncodeLeftCrLfHtVt,
		in:   "ηκ]␆＾\x13\x01J\x04␞\n/＋␡%９␖rU，␍γυ#␝;ψ[\n␊",
		out:  "ηκ]␆＾\x13\x01J\x04␞\n/＋␡%９␖rU，␍γυ#␝;ψ[\n␊",
	}, { // 1809
		mask: EncodeColon | EncodeLeftCrLfHtVt,
		in:   "ηκ]␆＾\x13\x01J\x04␞\n/＋␡%９␖rU，␍γυ#␝;ψ[␊␊",
		out:  "ηκ]␆＾\x13\x01J\x04␞\n/＋␡%９␖rU，␍γυ#␝;ψ[␊␊",
	}, { // 1810
		mask: EncodeColon | EncodeLeftCrLfHtVt,
		in:   "ηκ]␆＾\x13\x01J\x04␞\n/＋␡%９␖rU，␍γυ#␝;ψ[Ｆ\n",
		out:  "ηκ]␆＾\x13\x01J\x04␞\n/＋␡%９␖rU，␍γυ#␝;ψ[Ｆ\n",
	}, { // 1811
		mask: EncodeColon | EncodeLeftCrLfHtVt,
		in:   "ηκ]␆＾\x13\x01J\x04␞\n/＋␡%９␖rU，␍γυ#␝;ψ[Ｆ␊",
		out:  "ηκ]␆＾\x13\x01J\x04␞\n/＋␡%９␖rU，␍γυ#␝;ψ[Ｆ␊",
	}, { // 1812
		mask: EncodeColon | EncodeLeftCrLfHtVt,
		in:   "\"Ｚλκ2␈3\x0fλ６\vb＇ｐ\x12\x1aＴ&\x1b␂␁θ\x18νPｄ␋δ␗Y",
		out:  "\"Ｚλκ2␈3\x0fλ６\vb＇ｐ\x12\x1aＴ&\x1b␂␁θ\x18νPｄ␋δ␗Y",
	}, { // 1813
		mask: EncodeColon | EncodeLeftCrLfHtVt,
		in:   "\v␋λκ2␈3\x0fλ６\vb＇ｐ\x12\x1aＴ&\x1b␂␁θ\x18νPｄ␋δ␗Y",
		out:  "␋␋λκ2␈3\x0fλ６\vb＇ｐ\x12\x1aＴ&\x1b␂␁θ\x18νPｄ␋δ␗Y",
	}, { // 1814
		mask: EncodeColon | EncodeLeftCrLfHtVt,
		in:   "␋␋λκ2␈3\x0fλ６\vb＇ｐ\x12\x1aＴ&\x1b␂␁θ\x18νPｄ␋δ␗Y",
		out:  "‛␋␋λκ2␈3\x0fλ６\vb＇ｐ\x12\x1aＴ&\x1b␂␁θ\x18νPｄ␋δ␗Y",
	}, { // 1815
		mask: EncodeColon | EncodeLeftCrLfHtVt,
		in:   "\vＺλκ2␈3\x0fλ６\vb＇ｐ\x12\x1aＴ&\x1b␂␁θ\x18νPｄ␋δ␋Y",
		out:  "␋Ｚλκ2␈3\x0fλ６\vb＇ｐ\x12\x1aＴ&\x1b␂␁θ\x18νPｄ␋δ␋Y",
	}, { // 1816
		mask: EncodeColon | EncodeLeftCrLfHtVt,
		in:   "␋Ｚλκ2␈3\x0fλ６\vb＇ｐ\x12\x1aＴ&\x1b␂␁θ\x18νPｄ␋δ␋Y",
		out:  "‛␋Ｚλκ2␈3\x0fλ６\vb＇ｐ\x12\x1aＴ&\x1b␂␁θ\x18νPｄ␋δ␋Y",
	}, { // 1817
		mask: EncodeColon | EncodeLeftCrLfHtVt,
		in:   "\vＺλκ2␈3\x0fλ６\vb＇ｐ\x12\x1aＴ&\x1b␂␁θ\x18νPｄ␋δ␗␋",
		out:  "␋Ｚλκ2␈3\x0fλ６\vb＇ｐ\x12\x1aＴ&\x1b␂␁θ\x18νPｄ␋δ␗␋",
	}, { // 1818
		mask: EncodeColon | EncodeLeftCrLfHtVt,
		in:   "␋Ｚλκ2␈3\x0fλ６\vb＇ｐ\x12\x1aＴ&\x1b␂␁θ\x18νPｄ␋δ␗␋",
		out:  "‛␋Ｚλκ2␈3\x0fλ６\vb＇ｐ\x12\x1aＴ&\x1b␂␁θ\x18νPｄ␋δ␗␋",
	}, { // 1819
		mask: EncodeColon | EncodeLeftCrLfHtVt,
		in:   "\"\vλκ2␈3\x0fλ６\vb＇ｐ\x12\x1aＴ&\x1b␂␁θ\x18νPｄ␋δ␗Y",
		out:  "\"\vλκ2␈3\x0fλ６\vb＇ｐ\x12\x1aＴ&\x1b␂␁θ\x18νPｄ␋δ␗Y",
	}, { // 1820
		mask: EncodeColon | EncodeLeftCrLfHtVt,
		in:   "\"␋λκ2␈3\x0fλ６\vb＇ｐ\x12\x1aＴ&\x1b␂␁θ\x18νPｄ␋δ␗Y",
		out:  "\"␋λκ2␈3\x0fλ６\vb＇ｐ\x12\x1aＴ&\x1b␂␁θ\x18νPｄ␋δ␗Y",
	}, { // 1821
		mask: EncodeColon | EncodeLeftCrLfHtVt,
		in:   "\"\vλκ2␈3\x0fλ６\vb＇ｐ\x12\x1aＴ&\x1b␂␁θ\x18νPｄ␋δ␋Y",
		out:  "\"\vλκ2␈3\x0fλ６\vb＇ｐ\x12\x1aＴ&\x1b␂␁θ\x18νPｄ␋δ␋Y",
	}, { // 1822
		mask: EncodeColon | EncodeLeftCrLfHtVt,
		in:   "\"␋λκ2␈3\x0fλ６\vb＇ｐ\x12\x1aＴ&\x1b␂␁θ\x18νPｄ␋δ␋Y",
		out:  "\"␋λκ2␈3\x0fλ６\vb＇ｐ\x12\x1aＴ&\x1b␂␁θ\x18νPｄ␋δ␋Y",
	}, { // 1823
		mask: EncodeColon | EncodeLeftCrLfHtVt,
		in:   "\"\vλκ2␈3\x0fλ６\vb＇ｐ\x12\x1aＴ&\x1b␂␁θ\x18νPｄ␋δ␗␋",
		out:  "\"\vλκ2␈3\x0fλ６\vb＇ｐ\x12\x1aＴ&\x1b␂␁θ\x18νPｄ␋δ␗␋",
	}, { // 1824
		mask: EncodeColon | EncodeLeftCrLfHtVt,
		in:   "\"␋λκ2␈3\x0fλ６\vb＇ｐ\x12\x1aＴ&\x1b␂␁θ\x18νPｄ␋δ␗␋",
		out:  "\"␋λκ2␈3\x0fλ６\vb＇ｐ\x12\x1aＴ&\x1b␂␁θ\x18νPｄ␋δ␗␋",
	}, { // 1825
		mask: EncodeColon | EncodeLeftCrLfHtVt,
		in:   "\"Ｚλκ2␈3\x0fλ６\vb＇ｐ\x12\x1aＴ&\x1b␂␁θ\x18νPｄ␋δ\vY",
		out:  "\"Ｚλκ2␈3\x0fλ６\vb＇ｐ\x12\x1aＴ&\x1b␂␁θ\x18νPｄ␋δ\vY",
	}, { // 1826
		mask: EncodeColon | EncodeLeftCrLfHtVt,
		in:   "\"Ｚλκ2␈3\x0fλ６\vb＇ｐ\x12\x1aＴ&\x1b␂␁θ\x18νPｄ␋δ␋Y",
		out:  "\"Ｚλκ2␈3\x0fλ６\vb＇ｐ\x12\x1aＴ&\x1b␂␁θ\x18νPｄ␋δ␋Y",
	}, { // 1827
		mask: EncodeColon | EncodeLeftCrLfHtVt,
		in:   "\"Ｚλκ2␈3\x0fλ６\vb＇ｐ\x12\x1aＴ&\x1b␂␁θ\x18νPｄ␋δ\v␋",
		out:  "\"Ｚλκ2␈3\x0fλ６\vb＇ｐ\x12\x1aＴ&\x1b␂␁θ\x18νPｄ␋δ\v␋",
	}, { // 1828
		mask: EncodeColon | EncodeLeftCrLfHtVt,
		in:   "\"Ｚλκ2␈3\x0fλ６\vb＇ｐ\x12\x1aＴ&\x1b␂␁θ\x18νPｄ␋δ␋␋",
		out:  "\"Ｚλκ2␈3\x0fλ６\vb＇ｐ\x12\x1aＴ&\x1b␂␁θ\x18νPｄ␋δ␋␋",
	}, { // 1829
		mask: EncodeColon | EncodeLeftCrLfHtVt,
		in:   "\"Ｚλκ2␈3\x0fλ６\vb＇ｐ\x12\x1aＴ&\x1b␂␁θ\x18νPｄ␋δ␗\v",
		out:  "\"Ｚλκ2␈3\x0fλ６\vb＇ｐ\x12\x1aＴ&\x1b␂␁θ\x18νPｄ␋δ␗\v",
	}, { // 1830
		mask: EncodeColon | EncodeLeftCrLfHtVt,
		in:   "\"Ｚλκ2␈3\x0fλ６\vb＇ｐ\x12\x1aＴ&\x1b␂␁θ\x18νPｄ␋δ␗␋",
		out:  "\"Ｚλκ2␈3\x0fλ６\vb＇ｐ\x12\x1aＴ&\x1b␂␁θ\x18νPｄ␋δ␗␋",
	}, { // 1831
		mask: EncodeColon | EncodeLeftCrLfHtVt,
		in:   "eυ[Q6Pσ？(\x03\r＄\aβ%ｌψο\n␕␍Ｗ␂～υｃｙ\u007f␔n",
		out:  "eυ[Q6Pσ？(\x03\r＄\aβ%ｌψο\n␕␍Ｗ␂～υｃｙ\u007f␔n",
	}, { // 1832
		mask: EncodeColon | EncodeLeftCrLfHtVt,
		in:   "\r␍[Q6Pσ？(\x03\r＄\aβ%ｌψο\n␕␍Ｗ␂～υｃｙ\u007f␔n",
		out:  "␍␍[Q6Pσ？(\x03\r＄\aβ%ｌψο\n␕␍Ｗ␂～υｃｙ\u007f␔n",
	}, { // 1833
		mask: EncodeColon | EncodeLeftCrLfHtVt,
		in:   "␍␍[Q6Pσ？(\x03\r＄\aβ%ｌψο\n␕␍Ｗ␂～υｃｙ\u007f␔n",
		out:  "‛␍␍[Q6Pσ？(\x03\r＄\aβ%ｌψο\n␕␍Ｗ␂～υｃｙ\u007f␔n",
	}, { // 1834
		mask: EncodeColon | EncodeLeftCrLfHtVt,
		in:   "\rυ[Q6Pσ？(\x03\r＄\aβ%ｌψο\n␕␍Ｗ␂～υｃｙ\u007f␍n",
		out:  "␍υ[Q6Pσ？(\x03\r＄\aβ%ｌψο\n␕␍Ｗ␂～υｃｙ\u007f␍n",
	}, { // 1835
		mask: EncodeColon | EncodeLeftCrLfHtVt,
		in:   "␍υ[Q6Pσ？(\x03\r＄\aβ%ｌψο\n␕␍Ｗ␂～υｃｙ\u007f␍n",
		out:  "‛␍υ[Q6Pσ？(\x03\r＄\aβ%ｌψο\n␕␍Ｗ␂～υｃｙ\u007f␍n",
	}, { // 1836
		mask: EncodeColon | EncodeLeftCrLfHtVt,
		in:   "\rυ[Q6Pσ？(\x03\r＄\aβ%ｌψο\n␕␍Ｗ␂～υｃｙ\u007f␔␍",
		out:  "␍υ[Q6Pσ？(\x03\r＄\aβ%ｌψο\n␕␍Ｗ␂～υｃｙ\u007f␔␍",
	}, { // 1837
		mask: EncodeColon | EncodeLeftCrLfHtVt,
		in:   "␍υ[Q6Pσ？(\x03\r＄\aβ%ｌψο\n␕␍Ｗ␂～υｃｙ\u007f␔␍",
		out:  "‛␍υ[Q6Pσ？(\x03\r＄\aβ%ｌψο\n␕␍Ｗ␂～υｃｙ\u007f␔␍",
	}, { // 1838
		mask: EncodeColon | EncodeLeftCrLfHtVt,
		in:   "e\r[Q6Pσ？(\x03\r＄\aβ%ｌψο\n␕␍Ｗ␂～υｃｙ\u007f␔n",
		out:  "e\r[Q6Pσ？(\x03\r＄\aβ%ｌψο\n␕␍Ｗ␂～υｃｙ\u007f␔n",
	}, { // 1839
		mask: EncodeColon | EncodeLeftCrLfHtVt,
		in:   "e␍[Q6Pσ？(\x03\r＄\aβ%ｌψο\n␕␍Ｗ␂～υｃｙ\u007f␔n",
		out:  "e␍[Q6Pσ？(\x03\r＄\aβ%ｌψο\n␕␍Ｗ␂～υｃｙ\u007f␔n",
	}, { // 1840
		mask: EncodeColon | EncodeLeftCrLfHtVt,
		in:   "e\r[Q6Pσ？(\x03\r＄\aβ%ｌψο\n␕␍Ｗ␂～υｃｙ\u007f␍n",
		out:  "e\r[Q6Pσ？(\x03\r＄\aβ%ｌψο\n␕␍Ｗ␂～υｃｙ\u007f␍n",
	}, { // 1841
		mask: EncodeColon | EncodeLeftCrLfHtVt,
		in:   "e␍[Q6Pσ？(\x03\r＄\aβ%ｌψο\n␕␍Ｗ␂～υｃｙ\u007f␍n",
		out:  "e␍[Q6Pσ？(\x03\r＄\aβ%ｌψο\n␕␍Ｗ␂～υｃｙ\u007f␍n",
	}, { // 1842
		mask: EncodeColon | EncodeLeftCrLfHtVt,
		in:   "e\r[Q6Pσ？(\x03\r＄\aβ%ｌψο\n␕␍Ｗ␂～υｃｙ\u007f␔␍",
		out:  "e\r[Q6Pσ？(\x03\r＄\aβ%ｌψο\n␕␍Ｗ␂～υｃｙ\u007f␔␍",
	}, { // 1843
		mask: EncodeColon | EncodeLeftCrLfHtVt,
		in:   "e␍[Q6Pσ？(\x03\r＄\aβ%ｌψο\n␕␍Ｗ␂～υｃｙ\u007f␔␍",
		out:  "e␍[Q6Pσ？(\x03\r＄\aβ%ｌψο\n␕␍Ｗ␂～υｃｙ\u007f␔␍",
	}, { // 1844
		mask: EncodeColon | EncodeLeftCrLfHtVt,
		in:   "eυ[Q6Pσ？(\x03\r＄\aβ%ｌψο\n␕␍Ｗ␂～υｃｙ\u007f\rn",
		out:  "eυ[Q6Pσ？(\x03\r＄\aβ%ｌψο\n␕␍Ｗ␂～υｃｙ\u007f\rn",
	}, { // 1845
		mask: EncodeColon | EncodeLeftCrLfHtVt,
		in:   "eυ[Q6Pσ？(\x03\r＄\aβ%ｌψο\n␕␍Ｗ␂～υｃｙ\u007f␍n",
		out:  "eυ[Q6Pσ？(\x03\r＄\aβ%ｌψο\n␕␍Ｗ␂～υｃｙ\u007f␍n",
	}, { // 1846
		mask: EncodeColon | EncodeLeftCrLfHtVt,
		in:   "eυ[Q6Pσ？(\x03\r＄\aβ%ｌψο\n␕␍Ｗ␂～υｃｙ\u007f\r␍",
		out:  "eυ[Q6Pσ？(\x03\r＄\aβ%ｌψο\n␕␍Ｗ␂～υｃｙ\u007f\r␍",
	}, { // 1847
		mask: EncodeColon | EncodeLeftCrLfHtVt,
		in:   "eυ[Q6Pσ？(\x03\r＄\aβ%ｌψο\n␕␍Ｗ␂～υｃｙ\u007f␍␍",
		out:  "eυ[Q6Pσ？(\x03\r＄\aβ%ｌψο\n␕␍Ｗ␂～υｃｙ\u007f␍␍",
	}, { // 1848
		mask: EncodeColon | EncodeLeftCrLfHtVt,
		in:   "eυ[Q6Pσ？(\x03\r＄\aβ%ｌψο\n␕␍Ｗ␂～υｃｙ\u007f␔\r",
		out:  "eυ[Q6Pσ？(\x03\r＄\aβ%ｌψο\n␕␍Ｗ␂～υｃｙ\u007f␔\r",
	}, { // 1849
		mask: EncodeColon | EncodeLeftCrLfHtVt,
		in:   "eυ[Q6Pσ？(\x03\r＄\aβ%ｌψο\n␕␍Ｗ␂～υｃｙ\u007f␔␍",
		out:  "eυ[Q6Pσ？(\x03\r＄\aβ%ｌψο\n␕␍Ｗ␂～υｃｙ\u007f␔␍",
	}, { // 1850
		mask: EncodeQuestion | EncodeLeftCrLfHtVt,
		in:   "ＡＡ\x1aηω##～\x12｜\t␏/R＊+/\tB␅␘ππλＭ␞#σ～\x16",
		out:  "ＡＡ\x1aηω##～\x12｜\t␏/R＊+/\tB␅␘ππλＭ␞#σ～\x16",
	}, { // 1851
		mask: EncodeQuestion | EncodeLeftCrLfHtVt,
		in:   "\t␉\x1aηω##～\x12｜\t␏/R＊+/\tB␅␘ππλＭ␞#σ～\x16",
		out:  "␉␉\x1aηω##～\x12｜\t␏/R＊+/\tB␅␘ππλＭ␞#σ～\x16",
	}, { // 1852
		mask: EncodeQuestion | EncodeLeftCrLfHtVt,
		in:   "␉␉\x1aηω##～\x12｜\t␏/R＊+/\tB␅␘ππλＭ␞#σ～\x16",
		out:  "‛␉␉\x1aηω##～\x12｜\t␏/R＊+/\tB␅␘ππλＭ␞#σ～\x16",
	}, { // 1853
		mask: EncodeQuestion | EncodeLeftCrLfHtVt,
		in:   "\tＡ\x1aηω##～\x12｜\t␏/R＊+/\tB␅␘ππλＭ␞#σ␉\x16",
		out:  "␉Ａ\x1aηω##～\x12｜\t␏/R＊+/\tB␅␘ππλＭ␞#σ␉\x16",
	}, { // 1854
		mask: EncodeQuestion | EncodeLeftCrLfHtVt,
		in:   "␉Ａ\x1aηω##～\x12｜\t␏/R＊+/\tB␅␘ππλＭ␞#σ␉\x16",
		out:  "‛␉Ａ\x1aηω##～\x12｜\t␏/R＊+/\tB␅␘ππλＭ␞#σ␉\x16",
	}, { // 1855
		mask: EncodeQuestion | EncodeLeftCrLfHtVt,
		in:   "\tＡ\x1aηω##～\x12｜\t␏/R＊+/\tB␅␘ππλＭ␞#σ～␉",
		out:  "␉Ａ\x1aηω##～\x12｜\t␏/R＊+/\tB␅␘ππλＭ␞#σ～␉",
	}, { // 1856
		mask: EncodeQuestion | EncodeLeftCrLfHtVt,
		in:   "␉Ａ\x1aηω##～\x12｜\t␏/R＊+/\tB␅␘ππλＭ␞#σ～␉",
		out:  "‛␉Ａ\x1aηω##～\x12｜\t␏/R＊+/\tB␅␘ππλＭ␞#σ～␉",
	}, { // 1857
		mask: EncodeQuestion | EncodeLeftCrLfHtVt,
		in:   "Ａ\t\x1aηω##～\x12｜\t␏/R＊+/\tB␅␘ππλＭ␞#σ～\x16",
		out:  "Ａ\t\x1aηω##～\x12｜\t␏/R＊+/\tB␅␘ππλＭ␞#σ～\x16",
	}, { // 1858
		mask: EncodeQuestion | EncodeLeftCrLfHtVt,
		in:   "Ａ␉\x1aηω##～\x12｜\t␏/R＊+/\tB␅␘ππλＭ␞#σ～\x16",
		out:  "Ａ␉\x1aηω##～\x12｜\t␏/R＊+/\tB␅␘ππλＭ␞#σ～\x16",
	}, { // 1859
		mask: EncodeQuestion | EncodeLeftCrLfHtVt,
		in:   "Ａ\t\x1aηω##～\x12｜\t␏/R＊+/\tB␅␘ππλＭ␞#σ␉\x16",
		out:  "Ａ\t\x1aηω##～\x12｜\t␏/R＊+/\tB␅␘ππλＭ␞#σ␉\x16",
	}, { // 1860
		mask: EncodeQuestion | EncodeLeftCrLfHtVt,
		in:   "Ａ␉\x1aηω##～\x12｜\t␏/R＊+/\tB␅␘ππλＭ␞#σ␉\x16",
		out:  "Ａ␉\x1aηω##～\x12｜\t␏/R＊+/\tB␅␘ππλＭ␞#σ␉\x16",
	}, { // 1861
		mask: EncodeQuestion | EncodeLeftCrLfHtVt,
		in:   "Ａ\t\x1aηω##～\x12｜\t␏/R＊+/\tB␅␘ππλＭ␞#σ～␉",
		out:  "Ａ\t\x1aηω##～\x12｜\t␏/R＊+/\tB␅␘ππλＭ␞#σ～␉",
	}, { // 1862
		mask: EncodeQuestion | EncodeLeftCrLfHtVt,
		in:   "Ａ␉\x1aηω##～\x12｜\t␏/R＊+/\tB␅␘ππλＭ␞#σ～␉",
		out:  "Ａ␉\x1aηω##～\x12｜\t␏/R＊+/\tB␅␘ππλＭ␞#σ～␉",
	}, { // 1863
		mask: EncodeQuestion | EncodeLeftCrLfHtVt,
		in:   "ＡＡ\x1aηω##～\x12｜\t␏/R＊+/\tB␅␘ππλＭ␞#σ\t\x16",
		out:  "ＡＡ\x1aηω##～\x12｜\t␏/R＊+/\tB␅␘ππλＭ␞#σ\t\x16",
	}, { // 1864
		mask: EncodeQuestion | EncodeLeftCrLfHtVt,
		in:   "ＡＡ\x1aηω##～\x12｜\t␏/R＊+/\tB␅␘ππλＭ␞#σ␉\x16",
		out:  "ＡＡ\x1aηω##～\x12｜\t␏/R＊+/\tB␅␘ππλＭ␞#σ␉\x16",
	}, { // 1865
		mask: EncodeQuestion | EncodeLeftCrLfHtVt,
		in:   "ＡＡ\x1aηω##～\x12｜\t␏/R＊+/\tB␅␘ππλＭ␞#σ\t␉",
		out:  "ＡＡ\x1aηω##～\x12｜\t␏/R＊+/\tB␅␘ππλＭ␞#σ\t␉",
	}, { // 1866
		mask: EncodeQuestion | EncodeLeftCrLfHtVt,
		in:   "ＡＡ\x1aηω##～\x12｜\t␏/R＊+/\tB␅␘ππλＭ␞#σ␉␉",
		out:  "ＡＡ\x1aηω##～\x12｜\t␏/R＊+/\tB␅␘ππλＭ␞#σ␉␉",
	}, { // 1867
		mask: EncodeQuestion | EncodeLeftCrLfHtVt,
		in:   "ＡＡ\x1aηω##～\x12｜\t␏/R＊+/\tB␅␘ππλＭ␞#σ～\t",
		out:  "ＡＡ\x1aηω##～\x12｜\t␏/R＊+/\tB␅␘ππλＭ␞#σ～\t",
	}, { // 1868
		mask: EncodeQuestion | EncodeLeftCrLfHtVt,
		in:   "ＡＡ\x1aηω##～\x12｜\t␏/R＊+/\tB␅␘ππλＭ␞#σ～␉",
		out:  "ＡＡ\x1aηω##～\x12｜\t␏/R＊+/\tB␅␘ππλＭ␞#σ～␉",
	}, { // 1869
		mask: EncodeQuestion | EncodeLeftCrLfHtVt,
		in:   "-［\x01>｛␔％ς＇r\n␋＋７Ｅ|γβB,␒:*\x1fςｒ：?ζw",
		out:  "-［\x01>｛␔％ς＇r\n␋＋７Ｅ|γβB,␒:*\x1fςｒ：？ζw",
	}, { // 1870
		mask: EncodeQuestion | EncodeLeftCrLfHtVt,
		in:   "\n␊\x01>｛␔％ς＇r\n␋＋７Ｅ|γβB,␒:*\x1fςｒ：?ζw",
		out:  "␊␊\x01>｛␔％ς＇r\n␋＋７Ｅ|γβB,␒:*\x1fςｒ：？ζw",
	}, { // 1871
		mask: EncodeQuestion | EncodeLeftCrLfHtVt,
		in:   "␊␊\x01>｛␔％ς＇r\n␋＋７Ｅ|γβB,␒:*\x1fςｒ：?ζw",
		out:  "‛␊␊\x01>｛␔％ς＇r\n␋＋７Ｅ|γβB,␒:*\x1fςｒ：？ζw",
	}, { // 1872
		mask: EncodeQuestion | EncodeLeftCrLfHtVt,
		in:   "\n［\x01>｛␔％ς＇r\n␋＋７Ｅ|γβB,␒:*\x1fςｒ：?␊w",
		out:  "␊［\x01>｛␔％ς＇r\n␋＋７Ｅ|γβB,␒:*\x1fςｒ：？␊w",
	}, { // 1873
		mask: EncodeQuestion | EncodeLeftCrLfHtVt,
		in:   "␊［\x01>｛␔％ς＇r\n␋＋７Ｅ|γβB,␒:*\x1fςｒ：?␊w",
		out:  "‛␊［\x01>｛␔％ς＇r\n␋＋７Ｅ|γβB,␒:*\x1fςｒ：？␊w",
	}, { // 1874
		mask: EncodeQuestion | EncodeLeftCrLfHtVt,
		in:   "\n［\x01>｛␔％ς＇r\n␋＋７Ｅ|γβB,␒:*\x1fςｒ：?ζ␊",
		out:  "␊［\x01>｛␔％ς＇r\n␋＋７Ｅ|γβB,␒:*\x1fςｒ：？ζ␊",
	}, { // 1875
		mask: EncodeQuestion | EncodeLeftCrLfHtVt,
		in:   "␊［\x01>｛␔％ς＇r\n␋＋７Ｅ|γβB,␒:*\x1fςｒ：?ζ␊",
		out:  "‛␊［\x01>｛␔％ς＇r\n␋＋７Ｅ|γβB,␒:*\x1fςｒ：？ζ␊",
	}, { // 1876
		mask: EncodeQuestion | EncodeLeftCrLfHtVt,
		in:   "-\n\x01>｛␔％ς＇r\n␋＋７Ｅ|γβB,␒:*\x1fςｒ：?ζw",
		out:  "-\n\x01>｛␔％ς＇r\n␋＋７Ｅ|γβB,␒:*\x1fςｒ：？ζw",
	}, { // 1877
		mask: EncodeQuestion | EncodeLeftCrLfHtVt,
		in:   "-␊\x01>｛␔％ς＇r\n␋＋７Ｅ|γβB,␒:*\x1fςｒ：?ζw",
		out:  "-␊\x01>｛␔％ς＇r\n␋＋７Ｅ|γβB,␒:*\x1fςｒ：？ζw",
	}, { // 1878
		mask: EncodeQuestion | EncodeLeftCrLfHtVt,
		in:   "-\n\x01>｛␔％ς＇r\n␋＋７Ｅ|γβB,␒:*\x1fςｒ：?␊w",
		out:  "-\n\x01>｛␔％ς＇r\n␋＋７Ｅ|γβB,␒:*\x1fςｒ：？␊w",
	}, { // 1879
		mask: EncodeQuestion | EncodeLeftCrLfHtVt,
		in:   "-␊\x01>｛␔％ς＇r\n␋＋７Ｅ|γβB,␒:*\x1fςｒ：?␊w",
		out:  "-␊\x01>｛␔％ς＇r\n␋＋７Ｅ|γβB,␒:*\x1fςｒ：？␊w",
	}, { // 1880
		mask: EncodeQuestion | EncodeLeftCrLfHtVt,
		in:   "-\n\x01>｛␔％ς＇r\n␋＋７Ｅ|γβB,␒:*\x1fςｒ：?ζ␊",
		out:  "-\n\x01>｛␔％ς＇r\n␋＋７Ｅ|γβB,␒:*\x1fςｒ：？ζ␊",
	}, { // 1881
		mask: EncodeQuestion | EncodeLeftCrLfHtVt,
		in:   "-␊\x01>｛␔％ς＇r\n␋＋７Ｅ|γβB,␒:*\x1fςｒ：?ζ␊",
		out:  "-␊\x01>｛␔％ς＇r\n␋＋７Ｅ|γβB,␒:*\x1fςｒ：？ζ␊",
	}, { // 1882
		mask: EncodeQuestion | EncodeLeftCrLfHtVt,
		in:   "-［\x01>｛␔％ς＇r\n␋＋７Ｅ|γβB,␒:*\x1fςｒ：?\nw",
		out:  "-［\x01>｛␔％ς＇r\n␋＋７Ｅ|γβB,␒:*\x1fςｒ：？\nw",
	}, { // 1883
		mask: EncodeQuestion | EncodeLeftCrLfHtVt,
		in:   "-［\x01>｛␔％ς＇r\n␋＋７Ｅ|γβB,␒:*\x1fςｒ：?␊w",
		out:  "-［\x01>｛␔％ς＇r\n␋＋７Ｅ|γβB,␒:*\x1fςｒ：？␊w",
	}, { // 1884
		mask: EncodeQuestion | EncodeLeftCrLfHtVt,
		in:   "-［\x01>｛␔％ς＇r\n␋＋７Ｅ|γβB,␒:*\x1fςｒ：?\n␊",
		out:  "-［\x01>｛␔％ς＇r\n␋＋７Ｅ|γβB,␒:*\x1fςｒ：？\n␊",
	}, { // 1885
		mask: EncodeQuestion | EncodeLeftCrLfHtVt,
		in:   "-［\x01>｛␔％ς＇r\n␋＋７Ｅ|γβB,␒:*\x1fςｒ：?␊␊",
		out:  "-［\x01>｛␔％ς＇r\n␋＋７Ｅ|γβB,␒:*\x1fςｒ：？␊␊",
	}, { // 1886
		mask: EncodeQuestion | EncodeLeftCrLfHtVt,
		in:   "-［\x01>｛␔％ς＇r\n␋＋７Ｅ|γβB,␒:*\x1fςｒ：?ζ\n",
		out:  "-［\x01>｛␔％ς＇r\n␋＋７Ｅ|γβB,␒:*\x1fςｒ：？ζ\n",
	}, { // 1887
		mask: EncodeQuestion | EncodeLeftCrLfHtVt,
		in:   "-［\x01>｛␔％ς＇r\n␋＋７Ｅ|γβB,␒:*\x1fςｒ：?ζ␊",
		out:  "-［\x01>｛␔％ς＇r\n␋＋７Ｅ|γβB,␒:*\x1fςｒ：？ζ␊",
	}, { // 1888
		mask: EncodeQuestion | EncodeLeftCrLfHtVt,
		in:   "␈\rδ＇␛'/8［μ\vτ|␡λ｜/tβfｔＨＷν｜\x14ｄJＤ\x10",
		out:  "␈\rδ＇␛'/8［μ\vτ|␡λ｜/tβfｔＨＷν｜\x14ｄJＤ\x10",
	}, { // 1889
		mask: EncodeQuestion | EncodeLeftCrLfHtVt,
		in:   "\v␋δ＇␛'/8［μ\vτ|␡λ｜/tβfｔＨＷν｜\x14ｄJＤ\x10",
		out:  "␋␋δ＇␛'/8［μ\vτ|␡λ｜/tβfｔＨＷν｜\x14ｄJＤ\x10",
	}, { // 1890
		mask: EncodeQuestion | EncodeLeftCrLfHtVt,
		in:   "␋␋δ＇␛'/8［μ\vτ|␡λ｜/tβfｔＨＷν｜\x14ｄJＤ\x10",
		out:  "‛␋␋δ＇␛'/8［μ\vτ|␡λ｜/tβfｔＨＷν｜\x14ｄJＤ\x10",
	}, { // 1891
		mask: EncodeQuestion | EncodeLeftCrLfHtVt,
		in:   "\v\rδ＇␛'/8［μ\vτ|␡λ｜/tβfｔＨＷν｜\x14ｄJ␋\x10",
		out:  "␋\rδ＇␛'/8［μ\vτ|␡λ｜/tβfｔＨＷν｜\x14ｄJ␋\x10",
	}, { // 1892
		mask: EncodeQuestion | EncodeLeftCrLfHtVt,
		in:   "␋\rδ＇␛'/8［μ\vτ|␡λ｜/tβfｔＨＷν｜\x14ｄJ␋\x10",
		out:  "‛␋\rδ＇␛'/8［μ\vτ|␡λ｜/tβfｔＨＷν｜\x14ｄJ␋\x10",
	}, { // 1893
		mask: EncodeQuestion | EncodeLeftCrLfHtVt,
		in:   "\v\rδ＇␛'/8［μ\vτ|␡λ｜/tβfｔＨＷν｜\x14ｄJＤ␋",
		out:  "␋\rδ＇␛'/8［μ\vτ|␡λ｜/tβfｔＨＷν｜\x14ｄJＤ␋",
	}, { // 1894
		mask: EncodeQuestion | EncodeLeftCrLfHtVt,
		in:   "␋\rδ＇␛'/8［μ\vτ|␡λ｜/tβfｔＨＷν｜\x14ｄJＤ␋",
		out:  "‛␋\rδ＇␛'/8［μ\vτ|␡λ｜/tβfｔＨＷν｜\x14ｄJＤ␋",
	}, { // 1895
		mask: EncodeQuestion | EncodeLeftCrLfHtVt,
		in:   "␈\vδ＇␛'/8［μ\vτ|␡λ｜/tβfｔＨＷν｜\x14ｄJＤ\x10",
		out:  "␈\vδ＇␛'/8［μ\vτ|␡λ｜/tβfｔＨＷν｜\x14ｄJＤ\x10",
	}, { // 1896
		mask: EncodeQuestion | EncodeLeftCrLfHtVt,
		in:   "␈␋δ＇␛'/8［μ\vτ|␡λ｜/tβfｔＨＷν｜\x14ｄJＤ\x10",
		out:  "␈␋δ＇␛'/8［μ\vτ|␡λ｜/tβfｔＨＷν｜\x14ｄJＤ\x10",
	}, { // 1897
		mask: EncodeQuestion | EncodeLeftCrLfHtVt,
		in:   "␈\vδ＇␛'/8［μ\vτ|␡λ｜/tβfｔＨＷν｜\x14ｄJ␋\x10",
		out:  "␈\vδ＇␛'/8［μ\vτ|␡λ｜/tβfｔＨＷν｜\x14ｄJ␋\x10",
	}, { // 1898
		mask: EncodeQuestion | EncodeLeftCrLfHtVt,
		in:   "␈␋δ＇␛'/8［μ\vτ|␡λ｜/tβfｔＨＷν｜\x14ｄJ␋\x10",
		out:  "␈␋δ＇␛'/8［μ\vτ|␡λ｜/tβfｔＨＷν｜\x14ｄJ␋\x10",
	}, { // 1899
		mask: EncodeQuestion | EncodeLeftCrLfHtVt,
		in:   "␈\vδ＇␛'/8［μ\vτ|␡λ｜/tβfｔＨＷν｜\x14ｄJＤ␋",
		out:  "␈\vδ＇␛'/8［μ\vτ|␡λ｜/tβfｔＨＷν｜\x14ｄJＤ␋",
	}, { // 1900
		mask: EncodeQuestion | EncodeLeftCrLfHtVt,
		in:   "␈␋δ＇␛'/8［μ\vτ|␡λ｜/tβfｔＨＷν｜\x14ｄJＤ␋",
		out:  "␈␋δ＇␛'/8［μ\vτ|␡λ｜/tβfｔＨＷν｜\x14ｄJＤ␋",
	}, { // 1901
		mask: EncodeQuestion | EncodeLeftCrLfHtVt,
		in:   "␈\rδ＇␛'/8［μ\vτ|␡λ｜/tβfｔＨＷν｜\x14ｄJ\v\x10",
		out:  "␈\rδ＇␛'/8［μ\vτ|␡λ｜/tβfｔＨＷν｜\x14ｄJ\v\x10",
	}, { // 1902
		mask: EncodeQuestion | EncodeLeftCrLfHtVt,
		in:   "␈\rδ＇␛'/8［μ\vτ|␡λ｜/tβfｔＨＷν｜\x14ｄJ␋\x10",
		out:  "␈\rδ＇␛'/8［μ\vτ|␡λ｜/tβfｔＨＷν｜\x14ｄJ␋\x10",
	}, { // 1903
		mask: EncodeQuestion | EncodeLeftCrLfHtVt,
		in:   "␈\rδ＇␛'/8［μ\vτ|␡λ｜/tβfｔＨＷν｜\x14ｄJ\v␋",
		out:  "␈\rδ＇␛'/8［μ\vτ|␡λ｜/tβfｔＨＷν｜\x14ｄJ\v␋",
	}, { // 1904
		mask: EncodeQuestion | EncodeLeftCrLfHtVt,
		in:   "␈\rδ＇␛'/8［μ\vτ|␡λ｜/tβfｔＨＷν｜\x14ｄJ␋␋",
		out:  "␈\rδ＇␛'/8［μ\vτ|␡λ｜/tβfｔＨＷν｜\x14ｄJ␋␋",
	}, { // 1905
		mask: EncodeQuestion | EncodeLeftCrLfHtVt,
		in:   "␈\rδ＇␛'/8［μ\vτ|␡λ｜/tβfｔＨＷν｜\x14ｄJＤ\v",
		out:  "␈\rδ＇␛'/8［μ\vτ|␡λ｜/tβfｔＨＷν｜\x14ｄJＤ\v",
	}, { // 1906
		mask: EncodeQuestion | EncodeLeftCrLfHtVt,
		in:   "␈\rδ＇␛'/8［μ\vτ|␡λ｜/tβfｔＨＷν｜\x14ｄJＤ␋",
		out:  "␈\rδ＇␛'/8［μ\vτ|␡λ｜/tβfｔＨＷν｜\x14ｄJＤ␋",
	}, { // 1907
		mask: EncodeQuestion | EncodeLeftCrLfHtVt,
		in:   "␐＄＼\r[ｎ#ς．ρ\r␚'／ｚ*υR\x1fqχ\x13|v␈ηＶｌω＄",
		out:  "␐＄＼\r[ｎ#ς．ρ\r␚'／ｚ*υR\x1fqχ\x13|v␈ηＶｌω＄",
	}, { // 1908
		mask: EncodeQuestion | EncodeLeftCrLfHtVt,
		in:   "\r␍＼\r[ｎ#ς．ρ\r␚'／ｚ*υR\x1fqχ\x13|v␈ηＶｌω＄",
		out:  "␍␍＼\r[ｎ#ς．ρ\r␚'／ｚ*υR\x1fqχ\x13|v␈ηＶｌω＄",
	}, { // 1909
		mask: EncodeQuestion | EncodeLeftCrLfHtVt,
		in:   "␍␍＼\r[ｎ#ς．ρ\r␚'／ｚ*υR\x1fqχ\x13|v␈ηＶｌω＄",
		out:  "‛␍␍＼\r[ｎ#ς．ρ\r␚'／ｚ*υR\x1fqχ\x13|v␈ηＶｌω＄",
	}, { // 1910
		mask: EncodeQuestion | EncodeLeftCrLfHtVt,
		in:   "\r＄＼\r[ｎ#ς．ρ\r␚'／ｚ*υR\x1fqχ\x13|v␈ηＶｌ␍＄",
		out:  "␍＄＼\r[ｎ#ς．ρ\r␚'／ｚ*υR\x1fqχ\x13|v␈ηＶｌ␍＄",
	}, { // 1911
		mask: EncodeQuestion | EncodeLeftCrLfHtVt,
		in:   "␍＄＼\r[ｎ#ς．ρ\r␚'／ｚ*υR\x1fqχ\x13|v␈ηＶｌ␍＄",
		out:  "‛␍＄＼\r[ｎ#ς．ρ\r␚'／ｚ*υR\x1fqχ\x13|v␈ηＶｌ␍＄",
	}, { // 1912
		mask: EncodeQuestion | EncodeLeftCrLfHtVt,
		in:   "\r＄＼\r[ｎ#ς．ρ\r␚'／ｚ*υR\x1fqχ\x13|v␈ηＶｌω␍",
		out:  "␍＄＼\r[ｎ#ς．ρ\r␚'／ｚ*υR\x1fqχ\x13|v␈ηＶｌω␍",
	}, { // 1913
		mask: EncodeQuestion | EncodeLeftCrLfHtVt,
		in:   "␍＄＼\r[ｎ#ς．ρ\r␚'／ｚ*υR\x1fqχ\x13|v␈ηＶｌω␍",
		out:  "‛␍＄＼\r[ｎ#ς．ρ\r␚'／ｚ*υR\x1fqχ\x13|v␈ηＶｌω␍",
	}, { // 1914
		mask: EncodeQuestion | EncodeLeftCrLfHtVt,
		in:   "␐\r＼\r[ｎ#ς．ρ\r␚'／ｚ*υR\x1fqχ\x13|v␈ηＶｌω＄",
		out:  "␐\r＼\r[ｎ#ς．ρ\r␚'／ｚ*υR\x1fqχ\x13|v␈ηＶｌω＄",
	}, { // 1915
		mask: EncodeQuestion | EncodeLeftCrLfHtVt,
		in:   "␐␍＼\r[ｎ#ς．ρ\r␚'／ｚ*υR\x1fqχ\x13|v␈ηＶｌω＄",
		out:  "␐␍＼\r[ｎ#ς．ρ\r␚'／ｚ*υR\x1fqχ\x13|v␈ηＶｌω＄",
	}, { // 1916
		mask: EncodeQuestion | EncodeLeftCrLfHtVt,
		in:   "␐\r＼\r[ｎ#ς．ρ\r␚'／ｚ*υR\x1fqχ\x13|v␈ηＶｌ␍＄",
		out:  "␐\r＼\r[ｎ#ς．ρ\r␚'／ｚ*υR\x1fqχ\x13|v␈ηＶｌ␍＄",
	}, { // 1917
		mask: EncodeQuestion | EncodeLeftCrLfHtVt,
		in:   "␐␍＼\r[ｎ#ς．ρ\r␚'／ｚ*υR\x1fqχ\x13|v␈ηＶｌ␍＄",
		out:  "␐␍＼\r[ｎ#ς．ρ\r␚'／ｚ*υR\x1fqχ\x13|v␈ηＶｌ␍＄",
	}, { // 1918
		mask: EncodeQuestion | EncodeLeftCrLfHtVt,
		in:   "␐\r＼\r[ｎ#ς．ρ\r␚'／ｚ*υR\x1fqχ\x13|v␈ηＶｌω␍",
		out:  "␐\r＼\r[ｎ#ς．ρ\r␚'／ｚ*υR\x1fqχ\x13|v␈ηＶｌω␍",
	}, { // 1919
		mask: EncodeQuestion | EncodeLeftCrLfHtVt,
		in:   "␐␍＼\r[ｎ#ς．ρ\r␚'／ｚ*υR\x1fqχ\x13|v␈ηＶｌω␍",
		out:  "␐␍＼\r[ｎ#ς．ρ\r␚'／ｚ*υR\x1fqχ\x13|v␈ηＶｌω␍",
	}, { // 1920
		mask: EncodeQuestion | EncodeLeftCrLfHtVt,
		in:   "␐＄＼\r[ｎ#ς．ρ\r␚'／ｚ*υR\x1fqχ\x13|v␈ηＶｌ\r＄",
		out:  "␐＄＼\r[ｎ#ς．ρ\r␚'／ｚ*υR\x1fqχ\x13|v␈ηＶｌ\r＄",
	}, { // 1921
		mask: EncodeQuestion | EncodeLeftCrLfHtVt,
		in:   "␐＄＼\r[ｎ#ς．ρ\r␚'／ｚ*υR\x1fqχ\x13|v␈ηＶｌ␍＄",
		out:  "␐＄＼\r[ｎ#ς．ρ\r␚'／ｚ*υR\x1fqχ\x13|v␈ηＶｌ␍＄",
	}, { // 1922
		mask: EncodeQuestion | EncodeLeftCrLfHtVt,
		in:   "␐＄＼\r[ｎ#ς．ρ\r␚'／ｚ*υR\x1fqχ\x13|v␈ηＶｌ\r␍",
		out:  "␐＄＼\r[ｎ#ς．ρ\r␚'／ｚ*υR\x1fqχ\x13|v␈ηＶｌ\r␍",
	}, { // 1923
		mask: EncodeQuestion | EncodeLeftCrLfHtVt,
		in:   "␐＄＼\r[ｎ#ς．ρ\r␚'／ｚ*υR\x1fqχ\x13|v␈ηＶｌ␍␍",
		out:  "␐＄＼\r[ｎ#ς．ρ\r␚'／ｚ*υR\x1fqχ\x13|v␈ηＶｌ␍␍",
	}, { // 1924
		mask: EncodeQuestion | EncodeLeftCrLfHtVt,
		in:   "␐＄＼\r[ｎ#ς．ρ\r␚'／ｚ*υR\x1fqχ\x13|v␈ηＶｌω\r",
		out:  "␐＄＼\r[ｎ#ς．ρ\r␚'／ｚ*υR\x1fqχ\x13|v␈ηＶｌω\r",
	}, { // 1925
		mask: EncodeQuestion | EncodeLeftCrLfHtVt,
		in:   "␐＄＼\r[ｎ#ς．ρ\r␚'／ｚ*υR\x1fqχ\x13|v␈ηＶｌω␍",
		out:  "␐＄＼\r[ｎ#ς．ρ\r␚'／ｚ*υR\x1fqχ\x13|v␈ηＶｌω␍",
	}, { // 1926
		mask: EncodeAsterisk | EncodeLeftCrLfHtVt,
		in:   "ey␈\nν！P␑＇\x1d\t␐␅\rhζ％ｉ\x16υ５μσＺ<\x02␀Ｂ\x0f%",
		out:  "ey␈\nν！P␑＇\x1d\t␐␅\rhζ％ｉ\x16υ５μσＺ<\x02‛␀Ｂ\x0f%",
	}, { // 1927
		mask: EncodeAsterisk | EncodeLeftCrLfHtVt,
		in:   "\t␉␈\nν！P␑＇\x1d\t␐␅\rhζ％ｉ\x16υ５μσＺ<\x02␀Ｂ\x0f%",
		out:  "␉␉␈\nν！P␑＇\x1d\t␐␅\rhζ％ｉ\x16υ５μσＺ<\x02‛␀Ｂ\x0f%",
	}, { // 1928
		mask: EncodeAsterisk | EncodeLeftCrLfHtVt,
		in:   "␉␉␈\nν！P␑＇\x1d\t␐␅\rhζ％ｉ\x16υ５μσＺ<\x02␀Ｂ\x0f%",
		out:  "‛␉␉␈\nν！P␑＇\x1d\t␐␅\rhζ％ｉ\x16υ５μσＺ<\x02‛␀Ｂ\x0f%",
	}, { // 1929
		mask: EncodeAsterisk | EncodeLeftCrLfHtVt,
		in:   "\ty␈\nν！P␑＇\x1d\t␐␅\rhζ％ｉ\x16υ５μσＺ<\x02␀Ｂ␉%",
		out:  "␉y␈\nν！P␑＇\x1d\t␐␅\rhζ％ｉ\x16υ５μσＺ<\x02‛␀Ｂ␉%",
	}, { // 1930
		mask: EncodeAsterisk | EncodeLeftCrLfHtVt,
		in:   "␉y␈\nν！P␑＇\x1d\t␐␅\rhζ％ｉ\x16υ５μσＺ<\x02␀Ｂ␉%",
		out:  "‛␉y␈\nν！P␑＇\x1d\t␐␅\rhζ％ｉ\x16υ５μσＺ<\x02‛␀Ｂ␉%",
	}, { // 1931
		mask: EncodeAsterisk | EncodeLeftCrLfHtVt,
		in:   "\ty␈\nν！P␑＇\x1d\t␐␅\rhζ％ｉ\x16υ５μσＺ<\x02␀Ｂ\x0f␉",
		out:  "␉y␈\nν！P␑＇\x1d\t␐␅\rhζ％ｉ\x16υ５μσＺ<\x02‛␀Ｂ\x0f␉",
	}, { // 1932
		mask: EncodeAsterisk | EncodeLeftCrLfHtVt,
		in:   "␉y␈\nν！P␑＇\x1d\t␐␅\rhζ％ｉ\x16υ５μσＺ<\x02␀Ｂ\x0f␉",
		out:  "‛␉y␈\nν！P␑＇\x1d\t␐␅\rhζ％ｉ\x16υ５μσＺ<\x02‛␀Ｂ\x0f␉",
	}, { // 1933
		mask: EncodeAsterisk | EncodeLeftCrLfHtVt,
		in:   "e\t␈\nν！P␑＇\x1d\t␐␅\rhζ％ｉ\x16υ５μσＺ<\x02␀Ｂ\x0f%",
		out:  "e\t␈\nν！P␑＇\x1d\t␐␅\rhζ％ｉ\x16υ５μσＺ<\x02‛␀Ｂ\x0f%",
	}, { // 1934
		mask: EncodeAsterisk | EncodeLeftCrLfHtVt,
		in:   "e␉␈\nν！P␑＇\x1d\t␐␅\rhζ％ｉ\x16υ５μσＺ<\x02␀Ｂ\x0f%",
		out:  "e␉␈\nν！P␑＇\x1d\t␐␅\rhζ％ｉ\x16υ５μσＺ<\x02‛␀Ｂ\x0f%",
	}, { // 1935
		mask: EncodeAsterisk | EncodeLeftCrLfHtVt,
		in:   "e\t␈\nν！P␑＇\x1d\t␐␅\rhζ％ｉ\x16υ５μσＺ<\x02␀Ｂ␉%",
		out:  "e\t␈\nν！P␑＇\x1d\t␐␅\rhζ％ｉ\x16υ５μσＺ<\x02‛␀Ｂ␉%",
	}, { // 1936
		mask: EncodeAsterisk | EncodeLeftCrLfHtVt,
		in:   "e␉␈\nν！P␑＇\x1d\t␐␅\rhζ％ｉ\x16υ５μσＺ<\x02␀Ｂ␉%",
		out:  "e␉␈\nν！P␑＇\x1d\t␐␅\rhζ％ｉ\x16υ５μσＺ<\x02‛␀Ｂ␉%",
	}, { // 1937
		mask: EncodeAsterisk | EncodeLeftCrLfHtVt,
		in:   "e\t␈\nν！P␑＇\x1d\t␐␅\rhζ％ｉ\x16υ５μσＺ<\x02␀Ｂ\x0f␉",
		out:  "e\t␈\nν！P␑＇\x1d\t␐␅\rhζ％ｉ\x16υ５μσＺ<\x02‛␀Ｂ\x0f␉",
	}, { // 1938
		mask: EncodeAsterisk | EncodeLeftCrLfHtVt,
		in:   "e␉␈\nν！P␑＇\x1d\t␐␅\rhζ％ｉ\x16υ５μσＺ<\x02␀Ｂ\x0f␉",
		out:  "e␉␈\nν！P␑＇\x1d\t␐␅\rhζ％ｉ\x16υ５μσＺ<\x02‛␀Ｂ\x0f␉",
	}, { // 1939
		mask: EncodeAsterisk | EncodeLeftCrLfHtVt,
		in:   "ey␈\nν！P␑＇\x1d\t␐␅\rhζ％ｉ\x16υ５μσＺ<\x02␀Ｂ\t%",
		out:  "ey␈\nν！P␑＇\x1d\t␐␅\rhζ％ｉ\x16υ５μσＺ<\x02‛␀Ｂ\t%",
	}, { // 1940
		mask: EncodeAsterisk | EncodeLeftCrLfHtVt,
		in:   "ey␈\nν！P␑＇\x1d\t␐␅\rhζ％ｉ\x16υ５μσＺ<\x02␀Ｂ␉%",
		out:  "ey␈\nν！P␑＇\x1d\t␐␅\rhζ％ｉ\x16υ５μσＺ<\x02‛␀Ｂ␉%",
	}, { // 1941
		mask: EncodeAsterisk | EncodeLeftCrLfHtVt,
		in:   "ey␈\nν！P␑＇\x1d\t␐␅\rhζ％ｉ\x16υ５μσＺ<\x02␀Ｂ\t␉",
		out:  "ey␈\nν！P␑＇\x1d\t␐␅\rhζ％ｉ\x16υ５μσＺ<\x02‛␀Ｂ\t␉",
	}, { // 1942
		mask: EncodeAsterisk | EncodeLeftCrLfHtVt,
		in:   "ey␈\nν！P␑＇\x1d\t␐␅\rhζ％ｉ\x16υ５μσＺ<\x02␀Ｂ␉␉",
		out:  "ey␈\nν！P␑＇\x1d\t␐␅\rhζ％ｉ\x16υ５μσＺ<\x02‛␀Ｂ␉␉",
	}, { // 1943
		mask: EncodeAsterisk | EncodeLeftCrLfHtVt,
		in:   "ey␈\nν！P␑＇\x1d\t␐␅\rhζ％ｉ\x16υ５μσＺ<\x02␀Ｂ\x0f\t",
		out:  "ey␈\nν！P␑＇\x1d\t␐␅\rhζ％ｉ\x16υ５μσＺ<\x02‛␀Ｂ\x0f\t",
	}, { // 1944
		mask: EncodeAsterisk | EncodeLeftCrLfHtVt,
		in:   "ey␈\nν！P␑＇\x1d\t␐␅\rhζ％ｉ\x16υ５μσＺ<\x02␀Ｂ\x0f␉",
		out:  "ey␈\nν！P␑＇\x1d\t␐␅\rhζ％ｉ\x16υ５μσＺ<\x02‛␀Ｂ\x0f␉",
	}, { // 1945
		mask: EncodeAsterisk | EncodeLeftCrLfHtVt,
		in:   "O\n␓κη␊λ'␖y\nξ＄\x14Ａ␗ο～␔ｓ１$|\nJ\b％φ4C",
		out:  "O\n␓κη␊λ'␖y\nξ＄\x14Ａ␗ο～␔ｓ１$|\nJ\b％φ4C",
	}, { // 1946
		mask: EncodeAsterisk | EncodeLeftCrLfHtVt,
		in:   "\n␊␓κη␊λ'␖y\nξ＄\x14Ａ␗ο～␔ｓ１$|\nJ\b％φ4C",
		out:  "␊␊␓κη␊λ'␖y\nξ＄\x14Ａ␗ο～␔ｓ１$|\nJ\b％φ4C",
	}, { // 1947
		mask: EncodeAsterisk | EncodeLeftCrLfHtVt,
		in:   "␊␊␓κη␊λ'␖y\nξ＄\x14Ａ␗ο～␔ｓ１$|\nJ\b％φ4C",
		out:  "‛␊␊␓κη␊λ'␖y\nξ＄\x14Ａ␗ο～␔ｓ１$|\nJ\b％φ4C",
	}, { // 1948
		mask: EncodeAsterisk | EncodeLeftCrLfHtVt,
		in:   "\n\n␓κη␊λ'␖y\nξ＄\x14Ａ␗ο～␔ｓ１$|\nJ\b％φ␊C",
		out:  "␊\n␓κη␊λ'␖y\nξ＄\x14Ａ␗ο～␔ｓ１$|\nJ\b％φ␊C",
	}, { // 1949
		mask: EncodeAsterisk | EncodeLeftCrLfHtVt,
		in:   "␊\n␓κη␊λ'␖y\nξ＄\x14Ａ␗ο～␔ｓ１$|\nJ\b％φ␊C",
		out:  "‛␊\n␓κη␊λ'␖y\nξ＄\x14Ａ␗ο～␔ｓ１$|\nJ\b％φ␊C",
	}, { // 1950
		mask: EncodeAsterisk | EncodeLeftCrLfHtVt,
		in:   "\n\n␓κη␊λ'␖y\nξ＄\x14Ａ␗ο～␔ｓ１$|\nJ\b％φ4␊",
		out:  "␊\n␓κη␊λ'␖y\nξ＄\x14Ａ␗ο～␔ｓ１$|\nJ\b％φ4␊",
	}, { // 1951
		mask: EncodeAsterisk | EncodeLeftCrLfHtVt,
		in:   "␊\n␓κη␊λ'␖y\nξ＄\x14Ａ␗ο～␔ｓ１$|\nJ\b％φ4␊",
		out:  "‛␊\n␓κη␊λ'␖y\nξ＄\x14Ａ␗ο～␔ｓ１$|\nJ\b％φ4␊",
	}, { // 1952
		mask: EncodeAsterisk | EncodeLeftCrLfHtVt,
		in:   "O\n␓κη␊λ'␖y\nξ＄\x14Ａ␗ο～␔ｓ１$|\nJ\b％φ4C",
		out:  "O\n␓κη␊λ'␖y\nξ＄\x14Ａ␗ο～␔ｓ１$|\nJ\b％φ4C",
	}, { // 1953
		mask: EncodeAsterisk | EncodeLeftCrLfHtVt,
		in:   "O␊␓κη␊λ'␖y\nξ＄\x14Ａ␗ο～␔ｓ１$|\nJ\b％φ4C",
		out:  "O␊␓κη␊λ'␖y\nξ＄\x14Ａ␗ο～␔ｓ１$|\nJ\b％φ4C",
	}, { // 1954
		mask: EncodeAsterisk | EncodeLeftCrLfHtVt,
		in:   "O\n␓κη␊λ'␖y\nξ＄\x14Ａ␗ο～␔ｓ１$|\nJ\b％φ␊C",
		out:  "O\n␓κη␊λ'␖y\nξ＄\x14Ａ␗ο～␔ｓ１$|\nJ\b％φ␊C",
	}, { // 1955
		mask: EncodeAsterisk | EncodeLeftCrLfHtVt,
		in:   "O␊␓κη␊λ'␖y\nξ＄\x14Ａ␗ο～␔ｓ１$|\nJ\b％φ␊C",
		out:  "O␊␓κη␊λ'␖y\nξ＄\x14Ａ␗ο～␔ｓ１$|\nJ\b％φ␊C",
	}, { // 1956
		mask: EncodeAsterisk | EncodeLeftCrLfHtVt,
		in:   "O\n␓κη␊λ'␖y\nξ＄\x14Ａ␗ο～␔ｓ１$|\nJ\b％φ4␊",
		out:  "O\n␓κη␊λ'␖y\nξ＄\x14Ａ␗ο～␔ｓ１$|\nJ\b％φ4␊",
	}, { // 1957
		mask: EncodeAsterisk | EncodeLeftCrLfHtVt,
		in:   "O␊␓κη␊λ'␖y\nξ＄\x14Ａ␗ο～␔ｓ１$|\nJ\b％φ4␊",
		out:  "O␊␓κη␊λ'␖y\nξ＄\x14Ａ␗ο～␔ｓ１$|\nJ\b％φ4␊",
	}, { // 1958
		mask: EncodeAsterisk | EncodeLeftCrLfHtVt,
		in:   "O\n␓κη␊λ'␖y\nξ＄\x14Ａ␗ο～␔ｓ１$|\nJ\b％φ\nC",
		out:  "O\n␓κη␊λ'␖y\nξ＄\x14Ａ␗ο～␔ｓ１$|\nJ\b％φ\nC",
	}, { // 1959
		mask: EncodeAsterisk | EncodeLeftCrLfHtVt,
		in:   "O\n␓κη␊λ'␖y\nξ＄\x14Ａ␗ο～␔ｓ１$|\nJ\b％φ␊C",
		out:  "O\n␓κη␊λ'␖y\nξ＄\x14Ａ␗ο～␔ｓ１$|\nJ\b％φ␊C",
	}, { // 1960
		mask: EncodeAsterisk | EncodeLeftCrLfHtVt,
		in:   "O\n␓κη␊λ'␖y\nξ＄\x14Ａ␗ο～␔ｓ１$|\nJ\b％φ\n␊",
		out:  "O\n␓κη␊λ'␖y\nξ＄\x14Ａ␗ο～␔ｓ１$|\nJ\b％φ\n␊",
	}, { // 1961
		mask: EncodeAsterisk | EncodeLeftCrLfHtVt,
		in:   "O\n␓κη␊λ'␖y\nξ＄\x14Ａ␗ο～␔ｓ１$|\nJ\b％φ␊␊",
		out:  "O\n␓κη␊λ'␖y\nξ＄\x14Ａ␗ο～␔ｓ１$|\nJ\b％φ␊␊",
	}, { // 1962
		mask: EncodeAsterisk | EncodeLeftCrLfHtVt,
		in:   "O\n␓κη␊λ'␖y\nξ＄\x14Ａ␗ο～␔ｓ１$|\nJ\b％φ4\n",
		out:  "O\n␓κη␊λ'␖y\nξ＄\x14Ａ␗ο～␔ｓ１$|\nJ\b％φ4\n",
	}, { // 1963
		mask: EncodeAsterisk | EncodeLeftCrLfHtVt,
		in:   "O\n␓κη␊λ'␖y\nξ＄\x14Ａ␗ο～␔ｓ１$|\nJ\b％φ4␊",
		out:  "O\n␓κη␊λ'␖y\nξ＄\x14Ａ␗ο～␔ｓ１$|\nJ\b％φ4␊",
	}, { // 1964
		mask: EncodeAsterisk | EncodeLeftCrLfHtVt,
		in:   "ψ'\x17Oφ＞␎\x1a␍␐\vWθ＜8pD\x1b#ｕνｆ｛\\ο;␆␖５ο",
		out:  "ψ'\x17Oφ＞␎\x1a␍␐\vWθ＜8pD\x1b#ｕνｆ｛\\ο;␆␖５ο",
	}, { // 1965
		mask: EncodeAsterisk | EncodeLeftCrLfHtVt,
		in:   "\v␋\x17Oφ＞␎\x1a␍␐\vWθ＜8pD\x1b#ｕνｆ｛\\ο;␆␖５ο",
		out:  "␋␋\x17Oφ＞␎\x1a␍␐\vWθ＜8pD\x1b#ｕνｆ｛\\ο;␆␖５ο",
	}, { // 1966
		mask: EncodeAsterisk | EncodeLeftCrLfHtVt,
		in:   "␋␋\x17Oφ＞␎\x1a␍␐\vWθ＜8pD\x1b#ｕνｆ｛\\ο;␆␖５ο",
		out:  "‛␋␋\x17Oφ＞␎\x1a␍␐\vWθ＜8pD\x1b#ｕνｆ｛\\ο;␆␖５ο",
	}, { // 1967
		mask: EncodeAsterisk | EncodeLeftCrLfHtVt,
		in:   "\v'\x17Oφ＞␎\x1a␍␐\vWθ＜8pD\x1b#ｕνｆ｛\\ο;␆␖␋ο",
		out:  "␋'\x17Oφ＞␎\x1a␍␐\vWθ＜8pD\x1b#ｕνｆ｛\\ο;␆␖␋ο",
	}, { // 1968
		mask: EncodeAsterisk | EncodeLeftCrLfHtVt,
		in:   "␋'\x17Oφ＞␎\x1a␍␐\vWθ＜8pD\x1b#ｕνｆ｛\\ο;␆␖␋ο",
		out:  "‛␋'\x17Oφ＞␎\x1a␍␐\vWθ＜8pD\x1b#ｕνｆ｛\\ο;␆␖␋ο",
	}, { // 1969
		mask: EncodeAsterisk | EncodeLeftCrLfHtVt,
		in:   "\v'\x17Oφ＞␎\x1a␍␐\vWθ＜8pD\x1b#ｕνｆ｛\\ο;␆␖５␋",
		out:  "␋'\x17Oφ＞␎\x1a␍␐\vWθ＜8pD\x1b#ｕνｆ｛\\ο;␆␖５␋",
	}, { // 1970
		mask: EncodeAsterisk | EncodeLeftCrLfHtVt,
		in:   "␋'\x17Oφ＞␎\x1a␍␐\vWθ＜8pD\x1b#ｕνｆ｛\\ο;␆␖５␋",
		out:  "‛␋'\x17Oφ＞␎\x1a␍␐\vWθ＜8pD\x1b#ｕνｆ｛\\ο;␆␖５␋",
	}, { // 1971
		mask: EncodeAsterisk | EncodeLeftCrLfHtVt,
		in:   "ψ\v\x17Oφ＞␎\x1a␍␐\vWθ＜8pD\x1b#ｕνｆ｛\\ο;␆␖５ο",
		out:  "ψ\v\x17Oφ＞␎\x1a␍␐\vWθ＜8pD\x1b#ｕνｆ｛\\ο;␆␖５ο",
	}, { // 1972
		mask: EncodeAsterisk | EncodeLeftCrLfHtVt,
		in:   "ψ␋\x17Oφ＞␎\x1a␍␐\vWθ＜8pD\x1b#ｕνｆ｛\\ο;␆␖５ο",
		out:  "ψ␋\x17Oφ＞␎\x1a␍␐\vWθ＜8pD\x1b#ｕνｆ｛\\ο;␆␖５ο",
	}, { // 1973
		mask: EncodeAsterisk | EncodeLeftCrLfHtVt,
		in:   "ψ\v\x17Oφ＞␎\x1a␍␐\vWθ＜8pD\x1b#ｕνｆ｛\\ο;␆␖␋ο",
		out:  "ψ\v\x17Oφ＞␎\x1a␍␐\vWθ＜8pD\x1b#ｕνｆ｛\\ο;␆␖␋ο",
	}, { // 1974
		mask: EncodeAsterisk | EncodeLeftCrLfHtVt,
		in:   "ψ␋\x17Oφ＞␎\x1a␍␐\vWθ＜8pD\x1b#ｕνｆ｛\\ο;␆␖␋ο",
		out:  "ψ␋\x17Oφ＞␎\x1a␍␐\vWθ＜8pD\x1b#ｕνｆ｛\\ο;␆␖␋ο",
	}, { // 1975
		mask: EncodeAsterisk | EncodeLeftCrLfHtVt,
		in:   "ψ\v\x17Oφ＞␎\x1a␍␐\vWθ＜8pD\x1b#ｕνｆ｛\\ο;␆␖５␋",
		out:  "ψ\v\x17Oφ＞␎\x1a␍␐\vWθ＜8pD\x1b#ｕνｆ｛\\ο;␆␖５␋",
	}, { // 1976
		mask: EncodeAsterisk | EncodeLeftCrLfHtVt,
		in:   "ψ␋\x17Oφ＞␎\x1a␍␐\vWθ＜8pD\x1b#ｕνｆ｛\\ο;␆␖５␋",
		out:  "ψ␋\x17Oφ＞␎\x1a␍␐\vWθ＜8pD\x1b#ｕνｆ｛\\ο;␆␖５␋",
	}, { // 1977
		mask: EncodeAsterisk | EncodeLeftCrLfHtVt,
		in:   "ψ'\x17Oφ＞␎\x1a␍␐\vWθ＜8pD\x1b#ｕνｆ｛\\ο;␆␖\vο",
		out:  "ψ'\x17Oφ＞␎\x1a␍␐\vWθ＜8pD\x1b#ｕνｆ｛\\ο;␆␖\vο",
	}, { // 1978
		mask: EncodeAsterisk | EncodeLeftCrLfHtVt,
		in:   "ψ'\x17Oφ＞␎\x1a␍␐\vWθ＜8pD\x1b#ｕνｆ｛\\ο;␆␖␋ο",
		out:  "ψ'\x17Oφ＞␎\x1a␍␐\vWθ＜8pD\x1b#ｕνｆ｛\\ο;␆␖␋ο",
	}, { // 1979
		mask: EncodeAsterisk | EncodeLeftCrLfHtVt,
		in:   "ψ'\x17Oφ＞␎\x1a␍␐\vWθ＜8pD\x1b#ｕνｆ｛\\ο;␆␖\v␋",
		out:  "ψ'\x17Oφ＞␎\x1a␍␐\vWθ＜8pD\x1b#ｕνｆ｛\\ο;␆␖\v␋",
	}, { // 1980
		mask: EncodeAsterisk | EncodeLeftCrLfHtVt,
		in:   "ψ'\x17Oφ＞␎\x1a␍␐\vWθ＜8pD\x1b#ｕνｆ｛\\ο;␆␖␋␋",
		out:  "ψ'\x17Oφ＞␎\x1a␍␐\vWθ＜8pD\x1b#ｕνｆ｛\\ο;␆␖␋␋",
	}, { // 1981
		mask: EncodeAsterisk | EncodeLeftCrLfHtVt,
		in:   "ψ'\x17Oφ＞␎\x1a␍␐\vWθ＜8pD\x1b#ｕνｆ｛\\ο;␆␖５\v",
		out:  "ψ'\x17Oφ＞␎\x1a␍␐\vWθ＜8pD\x1b#ｕνｆ｛\\ο;␆␖５\v",
	}, { // 1982
		mask: EncodeAsterisk | EncodeLeftCrLfHtVt,
		in:   "ψ'\x17Oφ＞␎\x1a␍␐\vWθ＜8pD\x1b#ｕνｆ｛\\ο;␆␖５␋",
		out:  "ψ'\x17Oφ＞␎\x1a␍␐\vWθ＜8pD\x1b#ｕνｆ｛\\ο;␆␖５␋",
	}, { // 1983
		mask: EncodeAsterisk | EncodeLeftCrLfHtVt,
		in:   "␀ｍ\x03δρβ／␕(\x02\rρ；ＲA／｝$R４;;2␙χλ␊\uff00/\x15",
		out:  "‛␀ｍ\x03δρβ／␕(\x02\rρ；ＲA／｝$R４;;2␙χλ␊\uff00/\x15",
	}, { // 1984
		mask: EncodeAsterisk | EncodeLeftCrLfHtVt,
		in:   "\r␍\x03δρβ／␕(\x02\rρ；ＲA／｝$R４;;2␙χλ␊\uff00/\x15",
		out:  "␍␍\x03δρβ／␕(\x02\rρ；ＲA／｝$R４;;2␙χλ␊\uff00/\x15",
	}, { // 1985
		mask: EncodeAsterisk | EncodeLeftCrLfHtVt,
		in:   "␍␍\x03δρβ／␕(\x02\rρ；ＲA／｝$R４;;2␙χλ␊\uff00/\x15",
		out:  "‛␍␍\x03δρβ／␕(\x02\rρ；ＲA／｝$R４;;2␙χλ␊\uff00/\x15",
	}, { // 1986
		mask: EncodeAsterisk | EncodeLeftCrLfHtVt,
		in:   "\rｍ\x03δρβ／␕(\x02\rρ；ＲA／｝$R４;;2␙χλ␊\uff00␍\x15",
		out:  "␍ｍ\x03δρβ／␕(\x02\rρ；ＲA／｝$R４;;2␙χλ␊\uff00␍\x15",
	}, { // 1987
		mask: EncodeAsterisk | EncodeLeftCrLfHtVt,
		in:   "␍ｍ\x03δρβ／␕(\x02\rρ；ＲA／｝$R４;;2␙χλ␊\uff00␍\x15",
		out:  "‛␍ｍ\x03δρβ／␕(\x02\rρ；ＲA／｝$R４;;2␙χλ␊\uff00␍\x15",
	}, { // 1988
		mask: EncodeAsterisk | EncodeLeftCrLfHtVt,
		in:   "\rｍ\x03δρβ／␕(\x02\rρ；ＲA／｝$R４;;2␙χλ␊\uff00/␍",
		out:  "␍ｍ\x03δρβ／␕(\x02\rρ；ＲA／｝$R４;;2␙χλ␊\uff00/␍",
	}, { // 1989
		mask: EncodeAsterisk | EncodeLeftCrLfHtVt,
		in:   "␍ｍ\x03δρβ／␕(\x02\rρ；ＲA／｝$R４;;2␙χλ␊\uff00/␍",
		out:  "‛␍ｍ\x03δρβ／␕(\x02\rρ；ＲA／｝$R４;;2␙χλ␊\uff00/␍",
	}, { // 1990
		mask: EncodeAsterisk | EncodeLeftCrLfHtVt,
		in:   "␀\r\x03δρβ／␕(\x02\rρ；ＲA／｝$R４;;2␙χλ␊\uff00/\x15",
		out:  "‛␀\r\x03δρβ／␕(\x02\rρ；ＲA／｝$R４;;2␙χλ␊\uff00/\x15",
	}, { // 1991
		mask: EncodeAsterisk | EncodeLeftCrLfHtVt,
		in:   "␀␍\x03δρβ／␕(\x02\rρ；ＲA／｝$R４;;2␙χλ␊\uff00/\x15",
		out:  "‛␀␍\x03δρβ／␕(\x02\rρ；ＲA／｝$R４;;2␙χλ␊\uff00/\x15",
	}, { // 1992
		mask: EncodeAsterisk | EncodeLeftCrLfHtVt,
		in:   "␀\r\x03δρβ／␕(\x02\rρ；ＲA／｝$R４;;2␙χλ␊\uff00␍\x15",
		out:  "‛␀\r\x03δρβ／␕(\x02\rρ；ＲA／｝$R４;;2␙χλ␊\uff00␍\x15",
	}, { // 1993
		mask: EncodeAsterisk | EncodeLeftCrLfHtVt,
		in:   "␀␍\x03δρβ／␕(\x02\rρ；ＲA／｝$R４;;2␙χλ␊\uff00␍\x15",
		out:  "‛␀␍\x03δρβ／␕(\x02\rρ；ＲA／｝$R４;;2␙χλ␊\uff00␍\x15",
	}, { // 1994
		mask: EncodeAsterisk | EncodeLeftCrLfHtVt,
		in:   "␀\r\x03δρβ／␕(\x02\rρ；ＲA／｝$R４;;2␙χλ␊\uff00/␍",
		out:  "‛␀\r\x03δρβ／␕(\x02\rρ；ＲA／｝$R４;;2␙χλ␊\uff00/␍",
	}, { // 1995
		mask: EncodeAsterisk | EncodeLeftCrLfHtVt,
		in:   "␀␍\x03δρβ／␕(\x02\rρ；ＲA／｝$R４;;2␙χλ␊\uff00/␍",
		out:  "‛␀␍\x03δρβ／␕(\x02\rρ；ＲA／｝$R４;;2␙χλ␊\uff00/␍",
	}, { // 1996
		mask: EncodeAsterisk | EncodeLeftCrLfHtVt,
		in:   "␀ｍ\x03δρβ／␕(\x02\rρ；ＲA／｝$R４;;2␙χλ␊\uff00\r\x15",
		out:  "‛␀ｍ\x03δρβ／␕(\x02\rρ；ＲA／｝$R４;;2␙χλ␊\uff00\r\x15",
	}, { // 1997
		mask: EncodeAsterisk | EncodeLeftCrLfHtVt,
		in:   "␀ｍ\x03δρβ／␕(\x02\rρ；ＲA／｝$R４;;2␙χλ␊\uff00␍\x15",
		out:  "‛␀ｍ\x03δρβ／␕(\x02\rρ；ＲA／｝$R４;;2␙χλ␊\uff00␍\x15",
	}, { // 1998
		mask: EncodeAsterisk | EncodeLeftCrLfHtVt,
		in:   "␀ｍ\x03δρβ／␕(\x02\rρ；ＲA／｝$R４;;2␙χλ␊\uff00\r␍",
		out:  "‛␀ｍ\x03δρβ／␕(\x02\rρ；ＲA／｝$R４;;2␙χλ␊\uff00\r␍",
	}, { // 1999
		mask: EncodeAsterisk | EncodeLeftCrLfHtVt,
		in:   "␀ｍ\x03δρβ／␕(\x02\rρ；ＲA／｝$R４;;2␙χλ␊\uff00␍␍",
		out:  "‛␀ｍ\x03δρβ／␕(\x02\rρ；ＲA／｝$R４;;2␙χλ␊\uff00␍␍",
	}, { // 2000
		mask: EncodeAsterisk | EncodeLeftCrLfHtVt,
		in:   "␀ｍ\x03δρβ／␕(\x02\rρ；ＲA／｝$R４;;2␙χλ␊\uff00/\r",
		out:  "‛␀ｍ\x03δρβ／␕(\x02\rρ；ＲA／｝$R４;;2␙χλ␊\uff00/\r",
	}, { // 2001
		mask: EncodeAsterisk | EncodeLeftCrLfHtVt,
		in:   "␀ｍ\x03δρβ／␕(\x02\rρ；ＲA／｝$R４;;2␙χλ␊\uff00/␍",
		out:  "‛␀ｍ\x03δρβ／␕(\x02\rρ；ＲA／｝$R４;;2␙χλ␊\uff00/␍",
	}, { // 2002
		mask: EncodePipe | EncodeLeftCrLfHtVt,
		in:   "８\aλ␒ν\x06ｊ＊n\x1a\t\x1e>σθｐｘη]：Ｔ］)␕？Wε\x177*",
		out:  "８\aλ␒ν\x06ｊ＊n\x1a\t\x1e>σθｐｘη]：Ｔ］)␕？Wε\x177*",
	}, { // 2003
		mask: EncodePipe | EncodeLeftCrLfHtVt,
		in:   "\t␉λ␒ν\x06ｊ＊n\x1a\t\x1e>σθｐｘη]：Ｔ］)␕？Wε\x177*",
		out:  "␉␉λ␒ν\x06ｊ＊n\x1a\t\x1e>σθｐｘη]：Ｔ］)␕？Wε\x177*",
	}, { // 2004
		mask: EncodePipe | EncodeLeftCrLfHtVt,
		in:   "␉␉λ␒ν\x06ｊ＊n\x1a\t\x1e>σθｐｘη]：Ｔ］)␕？Wε\x177*",
		out:  "‛␉␉λ␒ν\x06ｊ＊n\x1a\t\x1e>σθｐｘη]：Ｔ］)␕？Wε\x177*",
	}, { // 2005
		mask: EncodePipe | EncodeLeftCrLfHtVt,
		in:   "\t\aλ␒ν\x06ｊ＊n\x1a\t\x1e>σθｐｘη]：Ｔ］)␕？Wε\x17␉*",
		out:  "␉\aλ␒ν\x06ｊ＊n\x1a\t\x1e>σθｐｘη]：Ｔ］)␕？Wε\x17␉*",
	}, { // 2006
		mask: EncodePipe | EncodeLeftCrLfHtVt,
		in:   "␉\aλ␒ν\x06ｊ＊n\x1a\t\x1e>σθｐｘη]：Ｔ］)␕？Wε\x17␉*",
		out:  "‛␉\aλ␒ν\x06ｊ＊n\x1a\t\x1e>σθｐｘη]：Ｔ］)␕？Wε\x17␉*",
	}, { // 2007
		mask: EncodePipe | EncodeLeftCrLfHtVt,
		in:   "\t\aλ␒ν\x06ｊ＊n\x1a\t\x1e>σθｐｘη]：Ｔ］)␕？Wε\x177␉",
		out:  "␉\aλ␒ν\x06ｊ＊n\x1a\t\x1e>σθｐｘη]：Ｔ］)␕？Wε\x177␉",
	}, { // 2008
		mask: EncodePipe | EncodeLeftCrLfHtVt,
		in:   "␉\aλ␒ν\x06ｊ＊n\x1a\t\x1e>σθｐｘη]：Ｔ］)␕？Wε\x177␉",
		out:  "‛␉\aλ␒ν\x06ｊ＊n\x1a\t\x1e>σθｐｘη]：Ｔ］)␕？Wε\x177␉",
	}, { // 2009
		mask: EncodePipe | EncodeLeftCrLfHtVt,
		in:   "８\tλ␒ν\x06ｊ＊n\x1a\t\x1e>σθｐｘη]：Ｔ］)␕？Wε\x177*",
		out:  "８\tλ␒ν\x06ｊ＊n\x1a\t\x1e>σθｐｘη]：Ｔ］)␕？Wε\x177*",
	}, { // 2010
		mask: EncodePipe | EncodeLeftCrLfHtVt,
		in:   "８␉λ␒ν\x06ｊ＊n\x1a\t\x1e>σθｐｘη]：Ｔ］)␕？Wε\x177*",
		out:  "８␉λ␒ν\x06ｊ＊n\x1a\t\x1e>σθｐｘη]：Ｔ］)␕？Wε\x177*",
	}, { // 2011
		mask: EncodePipe | EncodeLeftCrLfHtVt,
		in:   "８\tλ␒ν\x06ｊ＊n\x1a\t\x1e>σθｐｘη]：Ｔ］)␕？Wε\x17␉*",
		out:  "８\tλ␒ν\x06ｊ＊n\x1a\t\x1e>σθｐｘη]：Ｔ］)␕？Wε\x17␉*",
	}, { // 2012
		mask: EncodePipe | EncodeLeftCrLfHtVt,
		in:   "８␉λ␒ν\x06ｊ＊n\x1a\t\x1e>σθｐｘη]：Ｔ］)␕？Wε\x17␉*",
		out:  "８␉λ␒ν\x06ｊ＊n\x1a\t\x1e>σθｐｘη]：Ｔ］)␕？Wε\x17␉*",
	}, { // 2013
		mask: EncodePipe | EncodeLeftCrLfHtVt,
		in:   "８\tλ␒ν\x06ｊ＊n\x1a\t\x1e>σθｐｘη]：Ｔ］)␕？Wε\x177␉",
		out:  "８\tλ␒ν\x06ｊ＊n\x1a\t\x1e>σθｐｘη]：Ｔ］)␕？Wε\x177␉",
	}, { // 2014
		mask: EncodePipe | EncodeLeftCrLfHtVt,
		in:   "８␉λ␒ν\x06ｊ＊n\x1a\t\x1e>σθｐｘη]：Ｔ］)␕？Wε\x177␉",
		out:  "８␉λ␒ν\x06ｊ＊n\x1a\t\x1e>σθｐｘη]：Ｔ］)␕？Wε\x177␉",
	}, { // 2015
		mask: EncodePipe | EncodeLeftCrLfHtVt,
		in:   "８\aλ␒ν\x06ｊ＊n\x1a\t\x1e>σθｐｘη]：Ｔ］)␕？Wε\x17\t*",
		out:  "８\aλ␒ν\x06ｊ＊n\x1a\t\x1e>σθｐｘη]：Ｔ］)␕？Wε\x17\t*",
	}, { // 2016
		mask: EncodePipe | EncodeLeftCrLfHtVt,
		in:   "８\aλ␒ν\x06ｊ＊n\x1a\t\x1e>σθｐｘη]：Ｔ］)␕？Wε\x17␉*",
		out:  "８\aλ␒ν\x06ｊ＊n\x1a\t\x1e>σθｐｘη]：Ｔ］)␕？Wε\x17␉*",
	}, { // 2017
		mask: EncodePipe | EncodeLeftCrLfHtVt,
		in:   "８\aλ␒ν\x06ｊ＊n\x1a\t\x1e>σθｐｘη]：Ｔ］)␕？Wε\x17\t␉",
		out:  "８\aλ␒ν\x06ｊ＊n\x1a\t\x1e>σθｐｘη]：Ｔ］)␕？Wε\x17\t␉",
	}, { // 2018
		mask: EncodePipe | EncodeLeftCrLfHtVt,
		in:   "８\aλ␒ν\x06ｊ＊n\x1a\t\x1e>σθｐｘη]：Ｔ］)␕？Wε\x17␉␉",
		out:  "８\aλ␒ν\x06ｊ＊n\x1a\t\x1e>σθｐｘη]：Ｔ］)␕？Wε\x17␉␉",
	}, { // 2019
		mask: EncodePipe | EncodeLeftCrLfHtVt,
		in:   "８\aλ␒ν\x06ｊ＊n\x1a\t\x1e>σθｐｘη]：Ｔ］)␕？Wε\x177\t",
		out:  "８\aλ␒ν\x06ｊ＊n\x1a\t\x1e>σθｐｘη]：Ｔ］)␕？Wε\x177\t",
	}, { // 2020
		mask: EncodePipe | EncodeLeftCrLfHtVt,
		in:   "８\aλ␒ν\x06ｊ＊n\x1a\t\x1e>σθｐｘη]：Ｔ］)␕？Wε\x177␉",
		out:  "８\aλ␒ν\x06ｊ＊n\x1a\t\x1e>σθｐｘη]：Ｔ］)␕？Wε\x177␉",
	}, { // 2021
		mask: EncodePipe | EncodeLeftCrLfHtVt,
		in:   "i␟x＊χο*␟Ｊλ\n＄␂|␓εＩβ？\x04ｙ０\x02\r'|GOσW",
		out:  "i␟x＊χο*␟Ｊλ\n＄␂｜␓εＩβ？\x04ｙ０\x02\r'｜GOσW",
	}, { // 2022
		mask: EncodePipe | EncodeLeftCrLfHtVt,
		in:   "\n␊x＊χο*␟Ｊλ\n＄␂|␓εＩβ？\x04ｙ０\x02\r'|GOσW",
		out:  "␊␊x＊χο*␟Ｊλ\n＄␂｜␓εＩβ？\x04ｙ０\x02\r'｜GOσW",
	}, { // 2023
		mask: EncodePipe | EncodeLeftCrLfHtVt,
		in:   "␊␊x＊χο*␟Ｊλ\n＄␂|␓εＩβ？\x04ｙ０\x02\r'|GOσW",
		out:  "‛␊␊x＊χο*␟Ｊλ\n＄␂｜␓εＩβ？\x04ｙ０\x02\r'｜GOσW",
	}, { // 2024
		mask: EncodePipe | EncodeLeftCrLfHtVt,
		in:   "\n␟x＊χο*␟Ｊλ\n＄␂|␓εＩβ？\x04ｙ０\x02\r'|GO␊W",
		out:  "␊␟x＊χο*␟Ｊλ\n＄␂｜␓εＩβ？\x04ｙ０\x02\r'｜GO␊W",
	}, { // 2025
		mask: EncodePipe | EncodeLeftCrLfHtVt,
		in:   "␊␟x＊χο*␟Ｊλ\n＄␂|␓εＩβ？\x04ｙ０\x02\r'|GO␊W",
		out:  "‛␊␟x＊χο*␟Ｊλ\n＄␂｜␓εＩβ？\x04ｙ０\x02\r'｜GO␊W",
	}, { // 2026
		mask: EncodePipe | EncodeLeftCrLfHtVt,
		in:   "\n␟x＊χο*␟Ｊλ\n＄␂|␓εＩβ？\x04ｙ０\x02\r'|GOσ␊",
		out:  "␊␟x＊χο*␟Ｊλ\n＄␂｜␓εＩβ？\x04ｙ０\x02\r'｜GOσ␊",
	}, { // 2027
		mask: EncodePipe | EncodeLeftCrLfHtVt,
		in:   "␊␟x＊χο*␟Ｊλ\n＄␂|␓εＩβ？\x04ｙ０\x02\r'|GOσ␊",
		out:  "‛␊␟x＊χο*␟Ｊλ\n＄␂｜␓εＩβ？\x04ｙ０\x02\r'｜GOσ␊",
	}, { // 2028
		mask: EncodePipe | EncodeLeftCrLfHtVt,
		in:   "i\nx＊χο*␟Ｊλ\n＄␂|␓εＩβ？\x04ｙ０\x02\r'|GOσW",
		out:  "i\nx＊χο*␟Ｊλ\n＄␂｜␓εＩβ？\x04ｙ０\x02\r'｜GOσW",
	}, { // 2029
		mask: EncodePipe | EncodeLeftCrLfHtVt,
		in:   "i␊x＊χο*␟Ｊλ\n＄␂|␓εＩβ？\x04ｙ０\x02\r'|GOσW",
		out:  "i␊x＊χο*␟Ｊλ\n＄␂｜␓εＩβ？\x04ｙ０\x02\r'｜GOσW",
	}, { // 2030
		mask: EncodePipe | EncodeLeftCrLfHtVt,
		in:   "i\nx＊χο*␟Ｊλ\n＄␂|␓εＩβ？\x04ｙ０\x02\r'|GO␊W",
		out:  "i\nx＊χο*␟Ｊλ\n＄␂｜␓εＩβ？\x04ｙ０\x02\r'｜GO␊W",
	}, { // 2031
		mask: EncodePipe | EncodeLeftCrLfHtVt,
		in:   "i␊x＊χο*␟Ｊλ\n＄␂|␓εＩβ？\x04ｙ０\x02\r'|GO␊W",
		out:  "i␊x＊χο*␟Ｊλ\n＄␂｜␓εＩβ？\x04ｙ０\x02\r'｜GO␊W",
	}, { // 2032
		mask: EncodePipe | EncodeLeftCrLfHtVt,
		in:   "i\nx＊χο*␟Ｊλ\n＄␂|␓εＩβ？\x04ｙ０\x02\r'|GOσ␊",
		out:  "i\nx＊χο*␟Ｊλ\n＄␂｜␓εＩβ？\x04ｙ０\x02\r'｜GOσ␊",
	}, { // 2033
		mask: EncodePipe | EncodeLeftCrLfHtVt,
		in:   "i␊x＊χο*␟Ｊλ\n＄␂|␓εＩβ？\x04ｙ０\x02\r'|GOσ␊",
		out:  "i␊x＊χο*␟Ｊλ\n＄␂｜␓εＩβ？\x04ｙ０\x02\r'｜GOσ␊",
	}, { // 2034
		mask: EncodePipe | EncodeLeftCrLfHtVt,
		in:   "i␟x＊χο*␟Ｊλ\n＄␂|␓εＩβ？\x04ｙ０\x02\r'|GO\nW",
		out:  "i␟x＊χο*␟Ｊλ\n＄␂｜␓εＩβ？\x04ｙ０\x02\r'｜GO\nW",
	}, { // 2035
		mask: EncodePipe | EncodeLeftCrLfHtVt,
		in:   "i␟x＊χο*␟Ｊλ\n＄␂|␓εＩβ？\x04ｙ０\x02\r'|GO␊W",
		out:  "i␟x＊χο*␟Ｊλ\n＄␂｜␓εＩβ？\x04ｙ０\x02\r'｜GO␊W",
	}, { // 2036
		mask: EncodePipe | EncodeLeftCrLfHtVt,
		in:   "i␟x＊χο*␟Ｊλ\n＄␂|␓εＩβ？\x04ｙ０\x02\r'|GO\n␊",
		out:  "i␟x＊χο*␟Ｊλ\n＄␂｜␓εＩβ？\x04ｙ０\x02\r'｜GO\n␊",
	}, { // 2037
		mask: EncodePipe | EncodeLeftCrLfHtVt,
		in:   "i␟x＊χο*␟Ｊλ\n＄␂|␓εＩβ？\x04ｙ０\x02\r'|GO␊␊",
		out:  "i␟x＊χο*␟Ｊλ\n＄␂｜␓εＩβ？\x04ｙ０\x02\r'｜GO␊␊",
	}, { // 2038
		mask: EncodePipe | EncodeLeftCrLfHtVt,
		in:   "i␟x＊χο*␟Ｊλ\n＄␂|␓εＩβ？\x04ｙ０\x02\r'|GOσ\n",
		out:  "i␟x＊χο*␟Ｊλ\n＄␂｜␓εＩβ？\x04ｙ０\x02\r'｜GOσ\n",
	}, { // 2039
		mask: EncodePipe | EncodeLeftCrLfHtVt,
		in:   "i␟x＊χο*␟Ｊλ\n＄␂|␓εＩβ？\x04ｙ０\x02\r'|GOσ␊",
		out:  "i␟x＊χο*␟Ｊλ\n＄␂｜␓εＩβ？\x04ｙ０\x02\r'｜GOσ␊",
	}, { // 2040
		mask: EncodePipe | EncodeLeftCrLfHtVt,
		in:   "4ο?\x17β％␚_\fχ\v；＠τＲ'\x00\"εθｌ＂U.␊＊d␄:␔",
		out:  "4ο?\x17β％␚_\fχ\v；＠τＲ'␀\"εθｌ＂U.␊＊d␄:␔",
	}, { // 2041
		mask: EncodePipe | EncodeLeftCrLfHtVt,
		in:   "\v␋?\x17β％␚_\fχ\v；＠τＲ'\x00\"εθｌ＂U.␊＊d␄:␔",
		out:  "␋␋?\x17β％␚_\fχ\v；＠τＲ'␀\"εθｌ＂U.␊＊d␄:␔",
	}, { // 2042
		mask: EncodePipe | EncodeLeftCrLfHtVt,
		in:   "␋␋?\x17β％␚_\fχ\v；＠τＲ'\x00\"εθｌ＂U.␊＊d␄:␔",
		out:  "‛␋␋?\x17β％␚_\fχ\v；＠τＲ'␀\"εθｌ＂U.␊＊d␄:␔",
	}, { // 2043
		mask: EncodePipe | EncodeLeftCrLfHtVt,
		in:   "\vο?\x17β％␚_\fχ\v；＠τＲ'\x00\"εθｌ＂U.␊＊d␄␋␔",
		out:  "␋ο?\x17β％␚_\fχ\v；＠τＲ'␀\"εθｌ＂U.␊＊d␄␋␔",
	}, { // 2044
		mask: EncodePipe | EncodeLeftCrLfHtVt,
		in:   "␋ο?\x17β％␚_\fχ\v；＠τＲ'\x00\"εθｌ＂U.␊＊d␄␋␔",
		out:  "‛␋ο?\x17β％␚_\fχ\v；＠τＲ'␀\"εθｌ＂U.␊＊d␄␋␔",
	}, { // 2045
		mask: EncodePipe | EncodeLeftCrLfHtVt,
		in:   "\vο?\x17β％␚_\fχ\v；＠τＲ'\x00\"εθｌ＂U.␊＊d␄:␋",
		out:  "␋ο?\x17β％␚_\fχ\v；＠τＲ'␀\"εθｌ＂U.␊＊d␄:␋",
	}, { // 2046
		mask: EncodePipe | EncodeLeftCrLfHtVt,
		in:   "␋ο?\x17β％␚_\fχ\v；＠τＲ'\x00\"εθｌ＂U.␊＊d␄:␋",
		out:  "‛␋ο?\x17β％␚_\fχ\v；＠τＲ'␀\"εθｌ＂U.␊＊d␄:␋",
	}, { // 2047
		mask: EncodePipe | EncodeLeftCrLfHtVt,
		in:   "4\v?\x17β％␚_\fχ\v；＠τＲ'\x00\"εθｌ＂U.␊＊d␄:␔",
		out:  "4\v?\x17β％␚_\fχ\v；＠τＲ'␀\"εθｌ＂U.␊＊d␄:␔",
	}, { // 2048
		mask: EncodePipe | EncodeLeftCrLfHtVt,
		in:   "4␋?\x17β％␚_\fχ\v；＠τＲ'\x00\"εθｌ＂U.␊＊d␄:␔",
		out:  "4␋?\x17β％␚_\fχ\v；＠τＲ'␀\"εθｌ＂U.␊＊d␄:␔",
	}, { // 2049
		mask: EncodePipe | EncodeLeftCrLfHtVt,
		in:   "4\v?\x17β％␚_\fχ\v；＠τＲ'\x00\"εθｌ＂U.␊＊d␄␋␔",
		out:  "4\v?\x17β％␚_\fχ\v；＠τＲ'␀\"εθｌ＂U.␊＊d␄␋␔",
	}, { // 2050
		mask: EncodePipe | EncodeLeftCrLfHtVt,
		in:   "4␋?\x17β％␚_\fχ\v；＠τＲ'\x00\"εθｌ＂U.␊＊d␄␋␔",
		out:  "4␋?\x17β％␚_\fχ\v；＠τＲ'␀\"εθｌ＂U.␊＊d␄␋␔",
	}, { // 2051
		mask: EncodePipe | EncodeLeftCrLfHtVt,
		in:   "4\v?\x17β％␚_\fχ\v；＠τＲ'\x00\"εθｌ＂U.␊＊d␄:␋",
		out:  "4\v?\x17β％␚_\fχ\v；＠τＲ'␀\"εθｌ＂U.␊＊d␄:␋",
	}, { // 2052
		mask: EncodePipe | EncodeLeftCrLfHtVt,
		in:   "4␋?\x17β％␚_\fχ\v；＠τＲ'\x00\"εθｌ＂U.␊＊d␄:␋",
		out:  "4␋?\x17β％␚_\fχ\v；＠τＲ'␀\"εθｌ＂U.␊＊d␄:␋",
	}, { // 2053
		mask: EncodePipe | EncodeLeftCrLfHtVt,
		in:   "4ο?\x17β％␚_\fχ\v；＠τＲ'\x00\"εθｌ＂U.␊＊d␄\v␔",
		out:  "4ο?\x17β％␚_\fχ\v；＠τＲ'␀\"εθｌ＂U.␊＊d␄\v␔",
	}, { // 2054
		mask: EncodePipe | EncodeLeftCrLfHtVt,
		in:   "4ο?\x17β％␚_\fχ\v；＠τＲ'\x00\"εθｌ＂U.␊＊d␄␋␔",
		out:  "4ο?\x17β％␚_\fχ\v；＠τＲ'␀\"εθｌ＂U.␊＊d␄␋␔",
	}, { // 2055
		mask: EncodePipe | EncodeLeftCrLfHtVt,
		in:   "4ο?\x17β％␚_\fχ\v；＠τＲ'\x00\"εθｌ＂U.␊＊d␄\v␋",
		out:  "4ο?\x17β％␚_\fχ\v；＠τＲ'␀\"εθｌ＂U.␊＊d␄\v␋",
	}, { // 2056
		mask: EncodePipe | EncodeLeftCrLfHtVt,
		in:   "4ο?\x17β％␚_\fχ\v；＠τＲ'\x00\"εθｌ＂U.␊＊d␄␋␋",
		out:  "4ο?\x17β％␚_\fχ\v；＠τＲ'␀\"εθｌ＂U.␊＊d␄␋␋",
	}, { // 2057
		mask: EncodePipe | EncodeLeftCrLfHtVt,
		in:   "4ο?\x17β％␚_\fχ\v；＠τＲ'\x00\"εθｌ＂U.␊＊d␄:\v",
		out:  "4ο?\x17β％␚_\fχ\v；＠τＲ'␀\"εθｌ＂U.␊＊d␄:\v",
	}, { // 2058
		mask: EncodePipe | EncodeLeftCrLfHtVt,
		in:   "4ο?\x17β％␚_\fχ\v；＠τＲ'\x00\"εθｌ＂U.␊＊d␄:␋",
		out:  "4ο?\x17β％␚_\fχ\v；＠τＲ'␀\"εθｌ＂U.␊＊d␄:␋",
	}, { // 2059
		mask: EncodePipe | EncodeLeftCrLfHtVt,
		in:   "␓ρＹ＇eＹＡｒeτ\rρ␀ｅ\n␁;Ｂtμ\x14␖ζ␚?γ4~*>",
		out:  "␓ρＹ＇eＹＡｒeτ\rρ‛␀ｅ\n␁;Ｂtμ\x14␖ζ␚?γ4~*>",
	}, { // 2060
		mask: EncodePipe | EncodeLeftCrLfHtVt,
		in:   "\r␍Ｙ＇eＹＡｒeτ\rρ␀ｅ\n␁;Ｂtμ\x14␖ζ␚?γ4~*>",
		out:  "␍␍Ｙ＇eＹＡｒeτ\rρ‛␀ｅ\n␁;Ｂtμ\x14␖ζ␚?γ4~*>",
	}, { // 2061
		mask: EncodePipe | EncodeLeftCrLfHtVt,
		in:   "␍␍Ｙ＇eＹＡｒeτ\rρ␀ｅ\n␁;Ｂtμ\x14␖ζ␚?γ4~*>",
		out:  "‛␍␍Ｙ＇eＹＡｒeτ\rρ‛␀ｅ\n␁;Ｂtμ\x14␖ζ␚?γ4~*>",
	}, { // 2062
		mask: EncodePipe | EncodeLeftCrLfHtVt,
		in:   "\rρＹ＇eＹＡｒeτ\rρ␀ｅ\n␁;Ｂtμ\x14␖ζ␚?γ4~␍>",
		out:  "␍ρＹ＇eＹＡｒeτ\rρ‛␀ｅ\n␁;Ｂtμ\x14␖ζ␚?γ4~␍>",
	}, { // 2063
		mask: EncodePipe | EncodeLeftCrLfHtVt,
		in:   "␍ρＹ＇eＹＡｒeτ\rρ␀ｅ\n␁;Ｂtμ\x14␖ζ␚?γ4~␍>",
		out:  "‛␍ρＹ＇eＹＡｒeτ\rρ‛␀ｅ\n␁;Ｂtμ\x14␖ζ␚?γ4~␍>",
	}, { // 2064
		mask: EncodePipe | EncodeLeftCrLfHtVt,
		in:   "\rρＹ＇eＹＡｒeτ\rρ␀ｅ\n␁;Ｂtμ\x14␖ζ␚?γ4~*␍",
		out:  "␍ρＹ＇eＹＡｒeτ\rρ‛␀ｅ\n␁;Ｂtμ\x14␖ζ␚?γ4~*␍",
	}, { // 2065
		mask: EncodePipe | EncodeLeftCrLfHtVt,
		in:   "␍ρＹ＇eＹＡｒeτ\rρ␀ｅ\n␁;Ｂtμ\x14␖ζ␚?γ4~*␍",
		out:  "‛␍ρＹ＇eＹＡｒeτ\rρ‛␀ｅ\n␁;Ｂtμ\x14␖ζ␚?γ4~*␍",
	}, { // 2066
		mask: EncodePipe | EncodeLeftCrLfHtVt,
		in:   "␓\rＹ＇eＹＡｒeτ\rρ␀ｅ\n␁;Ｂtμ\x14␖ζ␚?γ4~*>",
		out:  "␓\rＹ＇eＹＡｒeτ\rρ‛␀ｅ\n␁;Ｂtμ\x14␖ζ␚?γ4~*>",
	}, { // 2067
		mask: EncodePipe | EncodeLeftCrLfHtVt,
		in:   "␓␍Ｙ＇eＹＡｒeτ\rρ␀ｅ\n␁;Ｂtμ\x14␖ζ␚?γ4~*>",
		out:  "␓␍Ｙ＇eＹＡｒeτ\rρ‛␀ｅ\n␁;Ｂtμ\x14␖ζ␚?γ4~*>",
	}, { // 2068
		mask: EncodePipe | EncodeLeftCrLfHtVt,
		in:   "␓\rＹ＇eＹＡｒeτ\rρ␀ｅ\n␁;Ｂtμ\x14␖ζ␚?γ4~␍>",
		out:  "␓\rＹ＇eＹＡｒeτ\rρ‛␀ｅ\n␁;Ｂtμ\x14␖ζ␚?γ4~␍>",
	}, { // 2069
		mask: EncodePipe | EncodeLeftCrLfHtVt,
		in:   "␓␍Ｙ＇eＹＡｒeτ\rρ␀ｅ\n␁;Ｂtμ\x14␖ζ␚?γ4~␍>",
		out:  "␓␍Ｙ＇eＹＡｒeτ\rρ‛␀ｅ\n␁;Ｂtμ\x14␖ζ␚?γ4~␍>",
	}, { // 2070
		mask: EncodePipe | EncodeLeftCrLfHtVt,
		in:   "␓\rＹ＇eＹＡｒeτ\rρ␀ｅ\n␁;Ｂtμ\x14␖ζ␚?γ4~*␍",
		out:  "␓\rＹ＇eＹＡｒeτ\rρ‛␀ｅ\n␁;Ｂtμ\x14␖ζ␚?γ4~*␍",
	}, { // 2071
		mask: EncodePipe | EncodeLeftCrLfHtVt,
		in:   "␓␍Ｙ＇eＹＡｒeτ\rρ␀ｅ\n␁;Ｂtμ\x14␖ζ␚?γ4~*␍",
		out:  "␓␍Ｙ＇eＹＡｒeτ\rρ‛␀ｅ\n␁;Ｂtμ\x14␖ζ␚?γ4~*␍",
	}, { // 2072
		mask: EncodePipe | EncodeLeftCrLfHtVt,
		in:   "␓ρＹ＇eＹＡｒeτ\rρ␀ｅ\n␁;Ｂtμ\x14␖ζ␚?γ4~\r>",
		out:  "␓ρＹ＇eＹＡｒeτ\rρ‛␀ｅ\n␁;Ｂtμ\x14␖ζ␚?γ4~\r>",
	}, { // 2073
		mask: EncodePipe | EncodeLeftCrLfHtVt,
		in:   "␓ρＹ＇eＹＡｒeτ\rρ␀ｅ\n␁;Ｂtμ\x14␖ζ␚?γ4~␍>",
		out:  "␓ρＹ＇eＹＡｒeτ\rρ‛␀ｅ\n␁;Ｂtμ\x14␖ζ␚?γ4~␍>",
	}, { // 2074
		mask: EncodePipe | EncodeLeftCrLfHtVt,
		in:   "␓ρＹ＇eＹＡｒeτ\rρ␀ｅ\n␁;Ｂtμ\x14␖ζ␚?γ4~\r␍",
		out:  "␓ρＹ＇eＹＡｒeτ\rρ‛␀ｅ\n␁;Ｂtμ\x14␖ζ␚?γ4~\r␍",
	}, { // 2075
		mask: EncodePipe | EncodeLeftCrLfHtVt,
		in:   "␓ρＹ＇eＹＡｒeτ\rρ␀ｅ\n␁;Ｂtμ\x14␖ζ␚?γ4~␍␍",
		out:  "␓ρＹ＇eＹＡｒeτ\rρ‛␀ｅ\n␁;Ｂtμ\x14␖ζ␚?γ4~␍␍",
	}, { // 2076
		mask: EncodePipe | EncodeLeftCrLfHtVt,
		in:   "␓ρＹ＇eＹＡｒeτ\rρ␀ｅ\n␁;Ｂtμ\x14␖ζ␚?γ4~*\r",
		out:  "␓ρＹ＇eＹＡｒeτ\rρ‛␀ｅ\n␁;Ｂtμ\x14␖ζ␚?γ4~*\r",
	}, { // 2077
		mask: EncodePipe | EncodeLeftCrLfHtVt,
		in:   "␓ρＹ＇eＹＡｒeτ\rρ␀ｅ\n␁;Ｂtμ\x14␖ζ␚?γ4~*␍",
		out:  "␓ρＹ＇eＹＡｒeτ\rρ‛␀ｅ\n␁;Ｂtμ\x14␖ζ␚?γ4~*␍",
	}, { // 2078
		mask: EncodeHash | EncodeLeftCrLfHtVt,
		in:   "%｜；τζκ␒U９\x13\t)？Ｏ％ασ\u007f␀@ｄ｝\x06jζ<[ＬＫ|",
		out:  "%｜；τζκ␒U９\x13\t)？Ｏ％ασ\u007f‛␀@ｄ｝\x06jζ<[ＬＫ|",
	}, { // 2079
		mask: EncodeHash | EncodeLeftCrLfHtVt,
		in:   "\t␉；τζκ␒U９\x13\t)？Ｏ％ασ\u007f␀@ｄ｝\x06jζ<[ＬＫ|",
		out:  "␉␉；τζκ␒U９\x13\t)？Ｏ％ασ\u007f‛␀@ｄ｝\x06jζ<[ＬＫ|",
	}, { // 2080
		mask: EncodeHash | EncodeLeftCrLfHtVt,
		in:   "␉␉；τζκ␒U９\x13\t)？Ｏ％ασ\u007f␀@ｄ｝\x06jζ<[ＬＫ|",
		out:  "‛␉␉；τζκ␒U９\x13\t)？Ｏ％ασ\u007f‛␀@ｄ｝\x06jζ<[ＬＫ|",
	}, { // 2081
		mask: EncodeHash | EncodeLeftCrLfHtVt,
		in:   "\t｜；τζκ␒U９\x13\t)？Ｏ％ασ\u007f␀@ｄ｝\x06jζ<[Ｌ␉|",
		out:  "␉｜；τζκ␒U９\x13\t)？Ｏ％ασ\u007f‛␀@ｄ｝\x06jζ<[Ｌ␉|",
	}, { // 2082
		mask: EncodeHash | EncodeLeftCrLfHtVt,
		in:   "␉｜；τζκ␒U９\x13\t)？Ｏ％ασ\u007f␀@ｄ｝\x06jζ<[Ｌ␉|",
		out:  "‛␉｜；τζκ␒U９\x13\t)？Ｏ％ασ\u007f‛␀@ｄ｝\x06jζ<[Ｌ␉|",
	}, { // 2083
		mask: EncodeHash | EncodeLeftCrLfHtVt,
		in:   "\t｜；τζκ␒U９\x13\t)？Ｏ％ασ\u007f␀@ｄ｝\x06jζ<[ＬＫ␉",
		out:  "␉｜；τζκ␒U９\x13\t)？Ｏ％ασ\u007f‛␀@ｄ｝\x06jζ<[ＬＫ␉",
	}, { // 2084
		mask: EncodeHash | EncodeLeftCrLfHtVt,
		in:   "␉｜；τζκ␒U９\x13\t)？Ｏ％ασ\u007f␀@ｄ｝\x06jζ<[ＬＫ␉",
		out:  "‛␉｜；τζκ␒U９\x13\t)？Ｏ％ασ\u007f‛␀@ｄ｝\x06jζ<[ＬＫ␉",
	}, { // 2085
		mask: EncodeHash | EncodeLeftCrLfHtVt,
		in:   "%\t；τζκ␒U９\x13\t)？Ｏ％ασ\u007f␀@ｄ｝\x06jζ<[ＬＫ|",
		out:  "%\t；τζκ␒U９\x13\t)？Ｏ％ασ\u007f‛␀@ｄ｝\x06jζ<[ＬＫ|",
	}, { // 2086
		mask: EncodeHash | EncodeLeftCrLfHtVt,
		in:   "%␉；τζκ␒U９\x13\t)？Ｏ％ασ\u007f␀@ｄ｝\x06jζ<[ＬＫ|",
		out:  "%␉；τζκ␒U９\x13\t)？Ｏ％ασ\u007f‛␀@ｄ｝\x06jζ<[ＬＫ|",
	}, { // 2087
		mask: EncodeHash | EncodeLeftCrLfHtVt,
		in:   "%\t；τζκ␒U９\x13\t)？Ｏ％ασ\u007f␀@ｄ｝\x06jζ<[Ｌ␉|",
		out:  "%\t；τζκ␒U９\x13\t)？Ｏ％ασ\u007f‛␀@ｄ｝\x06jζ<[Ｌ␉|",
	}, { // 2088
		mask: EncodeHash | EncodeLeftCrLfHtVt,
		in:   "%␉；τζκ␒U９\x13\t)？Ｏ％ασ\u007f␀@ｄ｝\x06jζ<[Ｌ␉|",
		out:  "%␉；τζκ␒U９\x13\t)？Ｏ％ασ\u007f‛␀@ｄ｝\x06jζ<[Ｌ␉|",
	}, { // 2089
		mask: EncodeHash | EncodeLeftCrLfHtVt,
		in:   "%\t；τζκ␒U９\x13\t)？Ｏ％ασ\u007f␀@ｄ｝\x06jζ<[ＬＫ␉",
		out:  "%\t；τζκ␒U９\x13\t)？Ｏ％ασ\u007f‛␀@ｄ｝\x06jζ<[ＬＫ␉",
	}, { // 2090
		mask: EncodeHash | EncodeLeftCrLfHtVt,
		in:   "%␉；τζκ␒U９\x13\t)？Ｏ％ασ\u007f␀@ｄ｝\x06jζ<[ＬＫ␉",
		out:  "%␉；τζκ␒U９\x13\t)？Ｏ％ασ\u007f‛␀@ｄ｝\x06jζ<[ＬＫ␉",
	}, { // 2091
		mask: EncodeHash | EncodeLeftCrLfHtVt,
		in:   "%｜；τζκ␒U９\x13\t)？Ｏ％ασ\u007f␀@ｄ｝\x06jζ<[Ｌ\t|",
		out:  "%｜；τζκ␒U９\x13\t)？Ｏ％ασ\u007f‛␀@ｄ｝\x06jζ<[Ｌ\t|",
	}, { // 2092
		mask: EncodeHash | EncodeLeftCrLfHtVt,
		in:   "%｜；τζκ␒U９\x13\t)？Ｏ％ασ\u007f␀@ｄ｝\x06jζ<[Ｌ␉|",
		out:  "%｜；τζκ␒U９\x13\t)？Ｏ％ασ\u007f‛␀@ｄ｝\x06jζ<[Ｌ␉|",
	}, { // 2093
		mask: EncodeHash | EncodeLeftCrLfHtVt,
		in:   "%｜；τζκ␒U９\x13\t)？Ｏ％ασ\u007f␀@ｄ｝\x06jζ<[Ｌ\t␉",
		out:  "%｜；τζκ␒U９\x13\t)？Ｏ％ασ\u007f‛␀@ｄ｝\x06jζ<[Ｌ\t␉",
	}, { // 2094
		mask: EncodeHash | EncodeLeftCrLfHtVt,
		in:   "%｜；τζκ␒U９\x13\t)？Ｏ％ασ\u007f␀@ｄ｝\x06jζ<[Ｌ␉␉",
		out:  "%｜；τζκ␒U９\x13\t)？Ｏ％ασ\u007f‛␀@ｄ｝\x06jζ<[Ｌ␉␉",
	}, { // 2095
		mask: EncodeHash | EncodeLeftCrLfHtVt,
		in:   "%｜；τζκ␒U９\x13\t)？Ｏ％ασ\u007f␀@ｄ｝\x06jζ<[ＬＫ\t",
		out:  "%｜；τζκ␒U９\x13\t)？Ｏ％ασ\u007f‛␀@ｄ｝\x06jζ<[ＬＫ\t",
	}, { // 2096
		mask: EncodeHash | EncodeLeftCrLfHtVt,
		in:   "%｜；τζκ␒U９\x13\t)？Ｏ％ασ\u007f␀@ｄ｝\x06jζ<[ＬＫ␉",
		out:  "%｜；τζκ␒U９\x13\t)？Ｏ％ασ\u007f‛␀@ｄ｝\x06jζ<[ＬＫ␉",
	}, { // 2097
		mask: EncodeHash | EncodeLeftCrLfHtVt,
		in:   "\\%λ\x06＜ｌ(～ρ＝\nＬ␞κ␡｀w［|βοy[\x1f;\x18Ｐδ＠\\",
		out:  "\\%λ\x06＜ｌ(～ρ＝\nＬ␞κ␡｀w［|βοy[\x1f;\x18Ｐδ＠\\",
	}, { // 2098
		mask: EncodeHash | EncodeLeftCrLfHtVt,
		in:   "\n␊λ\x06＜ｌ(～ρ＝\nＬ␞κ␡｀w［|βοy[\x1f;\x18Ｐδ＠\\",
		out:  "␊␊λ\x06＜ｌ(～ρ＝\nＬ␞κ␡｀w［|βοy[\x1f;\x18Ｐδ＠\\",
	}, { // 2099
		mask: EncodeHash | EncodeLeftCrLfHtVt,
		in:   "␊␊λ\x06＜ｌ(～ρ＝\nＬ␞κ␡｀w［|βοy[\x1f;\x18Ｐδ＠\\",
		out:  "‛␊␊λ\x06＜ｌ(～ρ＝\nＬ␞κ␡｀w［|βοy[\x1f;\x18Ｐδ＠\\",
	}, { // 2100
		mask: EncodeHash | EncodeLeftCrLfHtVt,
		in:   "\n%λ\x06＜ｌ(～ρ＝\nＬ␞κ␡｀w［|βοy[\x1f;\x18Ｐδ␊\\",
		out:  "␊%λ\x06＜ｌ(～ρ＝\nＬ␞κ␡｀w［|βοy[\x1f;\x18Ｐδ␊\\",
	}, { // 2101
		mask: EncodeHash | EncodeLeftCrLfHtVt,
		in:   "␊%λ\x06＜ｌ(～ρ＝\nＬ␞κ␡｀w［|βοy[\x1f;\x18Ｐδ␊\\",
		out:  "‛␊%λ\x06＜ｌ(～ρ＝\nＬ␞κ␡｀w［|βοy[\x1f;\x18Ｐδ␊\\",
	}, { // 2102
		mask: EncodeHash | EncodeLeftCrLfHtVt,
		in:   "\n%λ\x06＜ｌ(～ρ＝\nＬ␞κ␡｀w［|βοy[\x1f;\x18Ｐδ＠␊",
		out:  "␊%λ\x06＜ｌ(～ρ＝\nＬ␞κ␡｀w［|βοy[\x1f;\x18Ｐδ＠␊",
	}, { // 2103
		mask: EncodeHash | EncodeLeftCrLfHtVt,
		in:   "␊%λ\x06＜ｌ(～ρ＝\nＬ␞κ␡｀w［|βοy[\x1f;\x18Ｐδ＠␊",
		out:  "‛␊%λ\x06＜ｌ(～ρ＝\nＬ␞κ␡｀w［|βοy[\x1f;\x18Ｐδ＠␊",
	}, { // 2104
		mask: EncodeHash | EncodeLeftCrLfHtVt,
		in:   "\\\nλ\x06＜ｌ(～ρ＝\nＬ␞κ␡｀w［|βοy[\x1f;\x18Ｐδ＠\\",
		out:  "\\\nλ\x06＜ｌ(～ρ＝\nＬ␞κ␡｀w［|βοy[\x1f;\x18Ｐδ＠\\",
	}, { // 2105
		mask: EncodeHash | EncodeLeftCrLfHtVt,
		in:   "\\␊λ\x06＜ｌ(～ρ＝\nＬ␞κ␡｀w［|βοy[\x1f;\x18Ｐδ＠\\",
		out:  "\\␊λ\x06＜ｌ(～ρ＝\nＬ␞κ␡｀w［|βοy[\x1f;\x18Ｐδ＠\\",
	}, { // 2106
		mask: EncodeHash | EncodeLeftCrLfHtVt,
		in:   "\\\nλ\x06＜ｌ(～ρ＝\nＬ␞κ␡｀w［|βοy[\x1f;\x18Ｐδ␊\\",
		out:  "\\\nλ\x06＜ｌ(～ρ＝\nＬ␞κ␡｀w［|βοy[\x1f;\x18Ｐδ␊\\",
	}, { // 2107
		mask: EncodeHash | EncodeLeftCrLfHtVt,
		in:   "\\␊λ\x06＜ｌ(～ρ＝\nＬ␞κ␡｀w［|βοy[\x1f;\x18Ｐδ␊\\",
		out:  "\\␊λ\x06＜ｌ(～ρ＝\nＬ␞κ␡｀w［|βοy[\x1f;\x18Ｐδ␊\\",
	}, { // 2108
		mask: EncodeHash | EncodeLeftCrLfHtVt,
		in:   "\\\nλ\x06＜ｌ(～ρ＝\nＬ␞κ␡｀w［|βοy[\x1f;\x18Ｐδ＠␊",
		out:  "\\\nλ\x06＜ｌ(～ρ＝\nＬ␞κ␡｀w［|βοy[\x1f;\x18Ｐδ＠␊",
	}, { // 2109
		mask: EncodeHash | EncodeLeftCrLfHtVt,
		in:   "\\␊λ\x06＜ｌ(～ρ＝\nＬ␞κ␡｀w［|βοy[\x1f;\x18Ｐδ＠␊",
		out:  "\\␊λ\x06＜ｌ(～ρ＝\nＬ␞κ␡｀w［|βοy[\x1f;\x18Ｐδ＠␊",
	}, { // 2110
		mask: EncodeHash | EncodeLeftCrLfHtVt,
		in:   "\\%λ\x06＜ｌ(～ρ＝\nＬ␞κ␡｀w［|βοy[\x1f;\x18Ｐδ\n\\",
		out:  "\\%λ\x06＜ｌ(～ρ＝\nＬ␞κ␡｀w［|βοy[\x1f;\x18Ｐδ\n\\",
	}, { // 2111
		mask: EncodeHash | EncodeLeftCrLfHtVt,
		in:   "\\%λ\x06＜ｌ(～ρ＝\nＬ␞κ␡｀w［|βοy[\x1f;\x18Ｐδ␊\\",
		out:  "\\%λ\x06＜ｌ(～ρ＝\nＬ␞κ␡｀w［|βοy[\x1f;\x18Ｐδ␊\\",
	}, { // 2112
		mask: EncodeHash | EncodeLeftCrLfHtVt,
		in:   "\\%λ\x06＜ｌ(～ρ＝\nＬ␞κ␡｀w［|βοy[\x1f;\x18Ｐδ\n␊",
		out:  "\\%λ\x06＜ｌ(～ρ＝\nＬ␞κ␡｀w［|βοy[\x1f;\x18Ｐδ\n␊",
	}, { // 2113
		mask: EncodeHash | EncodeLeftCrLfHtVt,
		in:   "\\%λ\x06＜ｌ(～ρ＝\nＬ␞κ␡｀w［|βοy[\x1f;\x18Ｐδ␊␊",
		out:  "\\%λ\x06＜ｌ(～ρ＝\nＬ␞κ␡｀w［|βοy[\x1f;\x18Ｐδ␊␊",
	}, { // 2114
		mask: EncodeHash | EncodeLeftCrLfHtVt,
		in:   "\\%λ\x06＜ｌ(～ρ＝\nＬ␞κ␡｀w［|βοy[\x1f;\x18Ｐδ＠\n",
		out:  "\\%λ\x06＜ｌ(～ρ＝\nＬ␞κ␡｀w［|βοy[\x1f;\x18Ｐδ＠\n",
	}, { // 2115
		mask: EncodeHash | EncodeLeftCrLfHtVt,
		in:   "\\%λ\x06＜ｌ(～ρ＝\nＬ␞κ␡｀w［|βοy[\x1f;\x18Ｐδ＠␊",
		out:  "\\%λ\x06＜ｌ(～ρ＝\nＬ␞κ␡｀w［|βοy[\x1f;\x18Ｐδ＠␊",
	}, { // 2116
		mask: EncodeHash | EncodeLeftCrLfHtVt,
		in:   "υ␋；\x1ca*９j\x04υ\vG\x0f)＊ξλ&\uff00Ｘ\\＋η␎\x1bＵτ＊␀］",
		out:  "υ␋；\x1ca*９j\x04υ\vG\x0f)＊ξλ&\uff00Ｘ\\＋η␎\x1bＵτ＊‛␀］",
	}, { // 2117
		mask: EncodeHash | EncodeLeftCrLfHtVt,
		in:   "\v␋；\x1ca*９j\x04υ\vG\x0f)＊ξλ&\uff00Ｘ\\＋η␎\x1bＵτ＊␀］",
		out:  "␋␋；\x1ca*９j\x04υ\vG\x0f)＊ξλ&\uff00Ｘ\\＋η␎\x1bＵτ＊‛␀］",
	}, { // 2118
		mask: EncodeHash | EncodeLeftCrLfHtVt,
		in:   "␋␋；\x1ca*９j\x04υ\vG\x0f)＊ξλ&\uff00Ｘ\\＋η␎\x1bＵτ＊␀］",
		out:  "‛␋␋；\x1ca*９j\x04υ\vG\x0f)＊ξλ&\uff00Ｘ\\＋η␎\x1bＵτ＊‛␀］",
	}, { // 2119
		mask: EncodeHash | EncodeLeftCrLfHtVt,
		in:   "\v␋；\x1ca*９j\x04υ\vG\x0f)＊ξλ&\uff00Ｘ\\＋η␎\x1bＵτ＊␋］",
		out:  "␋␋；\x1ca*９j\x04υ\vG\x0f)＊ξλ&\uff00Ｘ\\＋η␎\x1bＵτ＊␋］",
	}, { // 2120
		mask: EncodeHash | EncodeLeftCrLfHtVt,
		in:   "␋␋；\x1ca*９j\x04υ\vG\x0f)＊ξλ&\uff00Ｘ\\＋η␎\x1bＵτ＊␋］",
		out:  "‛␋␋；\x1ca*９j\x04υ\vG\x0f)＊ξλ&\uff00Ｘ\\＋η␎\x1bＵτ＊␋］",
	}, { // 2121
		mask: EncodeHash | EncodeLeftCrLfHtVt,
		in:   "\v␋；\x1ca*９j\x04υ\vG\x0f)＊ξλ&\uff00Ｘ\\＋η␎\x1bＵτ＊␀␋",
		out:  "␋␋；\x1ca*９j\x04υ\vG\x0f)＊ξλ&\uff00Ｘ\\＋η␎\x1bＵτ＊‛␀␋",
	}, { // 2122
		mask: EncodeHash | EncodeLeftCrLfHtVt,
		in:   "␋␋；\x1ca*９j\x04υ\vG\x0f)＊ξλ&\uff00Ｘ\\＋η␎\x1bＵτ＊␀␋",
		out:  "‛␋␋；\x1ca*９j\x04υ\vG\x0f)＊ξλ&\uff00Ｘ\\＋η␎\x1bＵτ＊‛␀␋",
	}, { // 2123
		mask: EncodeHash | EncodeLeftCrLfHtVt,
		in:   "υ\v；\x1ca*９j\x04υ\vG\x0f)＊ξλ&\uff00Ｘ\\＋η␎\x1bＵτ＊␀］",
		out:  "υ\v；\x1ca*９j\x04υ\vG\x0f)＊ξλ&\uff00Ｘ\\＋η␎\x1bＵτ＊‛␀］",
	}, { // 2124
		mask: EncodeHash | EncodeLeftCrLfHtVt,
		in:   "υ␋；\x1ca*９j\x04υ\vG\x0f)＊ξλ&\uff00Ｘ\\＋η␎\x1bＵτ＊␀］",
		out:  "υ␋；\x1ca*９j\x04υ\vG\x0f)＊ξλ&\uff00Ｘ\\＋η␎\x1bＵτ＊‛␀］",
	}, { // 2125
		mask: EncodeHash | EncodeLeftCrLfHtVt,
		in:   "υ\v；\x1ca*９j\x04υ\vG\x0f)＊ξλ&\uff00Ｘ\\＋η␎\x1bＵτ＊␋］",
		out:  "υ\v；\x1ca*９j\x04υ\vG\x0f)＊ξλ&\uff00Ｘ\\＋η␎\x1bＵτ＊␋］",
	}, { // 2126
		mask: EncodeHash | EncodeLeftCrLfHtVt,
		in:   "υ␋；\x1ca*９j\x04υ\vG\x0f)＊ξλ&\uff00Ｘ\\＋η␎\x1bＵτ＊␋］",
		out:  "υ␋；\x1ca*９j\x04υ\vG\x0f)＊ξλ&\uff00Ｘ\\＋η␎\x1bＵτ＊␋］",
	}, { // 2127
		mask: EncodeHash | EncodeLeftCrLfHtVt,
		in:   "υ\v；\x1ca*９j\x04υ\vG\x0f)＊ξλ&\uff00Ｘ\\＋η␎\x1bＵτ＊␀␋",
		out:  "υ\v；\x1ca*９j\x04υ\vG\x0f)＊ξλ&\uff00Ｘ\\＋η␎\x1bＵτ＊‛␀␋",
	}, { // 2128
		mask: EncodeHash | EncodeLeftCrLfHtVt,
		in:   "υ␋；\x1ca*９j\x04υ\vG\x0f)＊ξλ&\uff00Ｘ\\＋η␎\x1bＵτ＊␀␋",
		out:  "υ␋；\x1ca*９j\x04υ\vG\x0f)＊ξλ&\uff00Ｘ\\＋η␎\x1bＵτ＊‛␀␋",
	}, { // 2129
		mask: EncodeHash | EncodeLeftCrLfHtVt,
		in:   "υ␋；\x1ca*９j\x04υ\vG\x0f)＊ξλ&\uff00Ｘ\\＋η␎\x1bＵτ＊\v］",
		out:  "υ␋；\x1ca*９j\x04υ\vG\x0f)＊ξλ&\uff00Ｘ\\＋η␎\x1bＵτ＊\v］",
	}, { // 2130
		mask: EncodeHash | EncodeLeftCrLfHtVt,
		in:   "υ␋；\x1ca*９j\x04υ\vG\x0f)＊ξλ&\uff00Ｘ\\＋η␎\x1bＵτ＊␋］",
		out:  "υ␋；\x1ca*９j\x04υ\vG\x0f)＊ξλ&\uff00Ｘ\\＋η␎\x1bＵτ＊␋］",
	}, { // 2131
		mask: EncodeHash | EncodeLeftCrLfHtVt,
		in:   "υ␋；\x1ca*９j\x04υ\vG\x0f)＊ξλ&\uff00Ｘ\\＋η␎\x1bＵτ＊\v␋",
		out:  "υ␋；\x1ca*９j\x04υ\vG\x0f)＊ξλ&\uff00Ｘ\\＋η␎\x1bＵτ＊\v␋",
	}, { // 2132
		mask: EncodeHash | EncodeLeftCrLfHtVt,
		in:   "υ␋；\x1ca*９j\x04υ\vG\x0f)＊ξλ&\uff00Ｘ\\＋η␎\x1bＵτ＊␋␋",
		out:  "υ␋；\x1ca*９j\x04υ\vG\x0f)＊ξλ&\uff00Ｘ\\＋η␎\x1bＵτ＊␋␋",
	}, { // 2133
		mask: EncodeHash | EncodeLeftCrLfHtVt,
		in:   "υ␋；\x1ca*９j\x04υ\vG\x0f)＊ξλ&\uff00Ｘ\\＋η␎\x1bＵτ＊␀\v",
		out:  "υ␋；\x1ca*９j\x04υ\vG\x0f)＊ξλ&\uff00Ｘ\\＋η␎\x1bＵτ＊‛␀\v",
	}, { // 2134
		mask: EncodeHash | EncodeLeftCrLfHtVt,
		in:   "υ␋；\x1ca*９j\x04υ\vG\x0f)＊ξλ&\uff00Ｘ\\＋η␎\x1bＵτ＊␀␋",
		out:  "υ␋；\x1ca*９j\x04υ\vG\x0f)＊ξλ&\uff00Ｘ\\＋η␎\x1bＵτ＊‛␀␋",
	}, { // 2135
		mask: EncodeHash | EncodeLeftCrLfHtVt,
		in:   "υＱ\x16\r`M，3Ｓ␟\r\x0fχ／/;？（IＡ］βκb␖ρ｝\x00μI",
		out:  "υＱ\x16\r`M，3Ｓ␟\r\x0fχ／/;？（IＡ］βκb␖ρ｝␀μI",
	}, { // 2136
		mask: EncodeHash | EncodeLeftCrLfHtVt,
		in:   "\r␍\x16\r`M，3Ｓ␟\r\x0fχ／/;？（IＡ］βκb␖ρ｝\x00μI",
		out:  "␍␍\x16\r`M，3Ｓ␟\r\x0fχ／/;？（IＡ］βκb␖ρ｝␀μI",
	}, { // 2137
		mask: EncodeHash | EncodeLeftCrLfHtVt,
		in:   "␍␍\x16\r`M，3Ｓ␟\r\x0fχ／/;？（IＡ］βκb␖ρ｝\x00μI",
		out:  "‛␍␍\x16\r`M，3Ｓ␟\r\x0fχ／/;？（IＡ］βκb␖ρ｝␀μI",
	}, { // 2138
		mask: EncodeHash | EncodeLeftCrLfHtVt,
		in:   "\rＱ\x16\r`M，3Ｓ␟\r\x0fχ／/;？（IＡ］βκb␖ρ｝\x00␍I",
		out:  "␍Ｑ\x16\r`M，3Ｓ␟\r\x0fχ／/;？（IＡ］βκb␖ρ｝␀␍I",
	}, { // 2139
		mask: EncodeHash | EncodeLeftCrLfHtVt,
		in:   "␍Ｑ\x16\r`M，3Ｓ␟\r\x0fχ／/;？（IＡ］βκb␖ρ｝\x00␍I",
		out:  "‛␍Ｑ\x16\r`M，3Ｓ␟\r\x0fχ／/;？（IＡ］βκb␖ρ｝␀␍I",
	}, { // 2140
		mask: EncodeHash | EncodeLeftCrLfHtVt,
		in:   "\rＱ\x16\r`M，3Ｓ␟\r\x0fχ／/;？（IＡ］βκb␖ρ｝\x00μ␍",
		out:  "␍Ｑ\x16\r`M，3Ｓ␟\r\x0fχ／/;？（IＡ］βκb␖ρ｝␀μ␍",
	}, { // 2141
		mask: EncodeHash | EncodeLeftCrLfHtVt,
		in:   "␍Ｑ\x16\r`M，3Ｓ␟\r\x0fχ／/;？（IＡ］βκb␖ρ｝\x00μ␍",
		out:  "‛␍Ｑ\x16\r`M，3Ｓ␟\r\x0fχ／/;？（IＡ］βκb␖ρ｝␀μ␍",
	}, { // 2142
		mask: EncodeHash | EncodeLeftCrLfHtVt,
		in:   "υ\r\x16\r`M，3Ｓ␟\r\x0fχ／/;？（IＡ］βκb␖ρ｝\x00μI",
		out:  "υ\r\x16\r`M，3Ｓ␟\r\x0fχ／/;？（IＡ］βκb␖ρ｝␀μI",
	}, { // 2143
		mask: EncodeHash | EncodeLeftCrLfHtVt,
		in:   "υ␍\x16\r`M，3Ｓ␟\r\x0fχ／/;？（IＡ］βκb␖ρ｝\x00μI",
		out:  "υ␍\x16\r`M，3Ｓ␟\r\x0fχ／/;？（IＡ］βκb␖ρ｝␀μI",
	}, { // 2144
		mask: EncodeHash | EncodeLeftCrLfHtVt,
		in:   "υ\r\x16\r`M，3Ｓ␟\r\x0fχ／/;？（IＡ］βκb␖ρ｝\x00␍I",
		out:  "υ\r\x16\r`M，3Ｓ␟\r\x0fχ／/;？（IＡ］βκb␖ρ｝␀␍I",
	}, { // 2145
		mask: EncodeHash | EncodeLeftCrLfHtVt,
		in:   "υ␍\x16\r`M，3Ｓ␟\r\x0fχ／/;？（IＡ］βκb␖ρ｝\x00␍I",
		out:  "υ␍\x16\r`M，3Ｓ␟\r\x0fχ／/;？（IＡ］βκb␖ρ｝␀␍I",
	}, { // 2146
		mask: EncodeHash | EncodeLeftCrLfHtVt,
		in:   "υ\r\x16\r`M，3Ｓ␟\r\x0fχ／/;？（IＡ］βκb␖ρ｝\x00μ␍",
		out:  "υ\r\x16\r`M，3Ｓ␟\r\x0fχ／/;？（IＡ］βκb␖ρ｝␀μ␍",
	}, { // 2147
		mask: EncodeHash | EncodeLeftCrLfHtVt,
		in:   "υ␍\x16\r`M，3Ｓ␟\r\x0fχ／/;？（IＡ］βκb␖ρ｝\x00μ␍",
		out:  "υ␍\x16\r`M，3Ｓ␟\r\x0fχ／/;？（IＡ］βκb␖ρ｝␀μ␍",
	}, { // 2148
		mask: EncodeHash | EncodeLeftCrLfHtVt,
		in:   "υＱ\x16\r`M，3Ｓ␟\r\x0fχ／/;？（IＡ］βκb␖ρ｝\x00\rI",
		out:  "υＱ\x16\r`M，3Ｓ␟\r\x0fχ／/;？（IＡ］βκb␖ρ｝␀\rI",
	}, { // 2149
		mask: EncodeHash | EncodeLeftCrLfHtVt,
		in:   "υＱ\x16\r`M，3Ｓ␟\r\x0fχ／/;？（IＡ］βκb␖ρ｝\x00␍I",
		out:  "υＱ\x16\r`M，3Ｓ␟\r\x0fχ／/;？（IＡ］βκb␖ρ｝␀␍I",
	}, { // 2150
		mask: EncodeHash | EncodeLeftCrLfHtVt,
		in:   "υＱ\x16\r`M，3Ｓ␟\r\x0fχ／/;？（IＡ］βκb␖ρ｝\x00\r␍",
		out:  "υＱ\x16\r`M，3Ｓ␟\r\x0fχ／/;？（IＡ］βκb␖ρ｝␀\r␍",
	}, { // 2151
		mask: EncodeHash | EncodeLeftCrLfHtVt,
		in:   "υＱ\x16\r`M，3Ｓ␟\r\x0fχ／/;？（IＡ］βκb␖ρ｝\x00␍␍",
		out:  "υＱ\x16\r`M，3Ｓ␟\r\x0fχ／/;？（IＡ］βκb␖ρ｝␀␍␍",
	}, { // 2152
		mask: EncodeHash | EncodeLeftCrLfHtVt,
		in:   "υＱ\x16\r`M，3Ｓ␟\r\x0fχ／/;？（IＡ］βκb␖ρ｝\x00μ\r",
		out:  "υＱ\x16\r`M，3Ｓ␟\r\x0fχ／/;？（IＡ］βκb␖ρ｝␀μ\r",
	}, { // 2153
		mask: EncodeHash | EncodeLeftCrLfHtVt,
		in:   "υＱ\x16\r`M，3Ｓ␟\r\x0fχ／/;？（IＡ］βκb␖ρ｝\x00μ␍",
		out:  "υＱ\x16\r`M，3Ｓ␟\r\x0fχ／/;？（IＡ］βκb␖ρ｝␀μ␍",
	}, { // 2154
		mask: EncodePercent | EncodeLeftCrLfHtVt,
		in:   "β／：ζ\"ｍv_－β\t\x17>>␚δ\x0f␎z<ηξ＞eM<＼９／ｗ",
		out:  "β／：ζ\"ｍv_－β\t\x17>>␚δ\x0f␎z<ηξ＞eM<＼９／ｗ",
	}, { // 2155
		mask: EncodePercent | EncodeLeftCrLfHtVt,
		in:   "\t␉：ζ\"ｍv_－β\t\x17>>␚δ\x0f␎z<ηξ＞eM<＼９／ｗ",
		out:  "␉␉：ζ\"ｍv_－β\t\x17>>␚δ\x0f␎z<ηξ＞eM<＼９／ｗ",
	}, { // 2156
		mask: EncodePercent | EncodeLeftCrLfHtVt,
		in:   "␉␉：ζ\"ｍv_－β\t\x17>>␚δ\x0f␎z<ηξ＞eM<＼９／ｗ",
		out:  "‛␉␉：ζ\"ｍv_－β\t\x17>>␚δ\x0f␎z<ηξ＞eM<＼９／ｗ",
	}, { // 2157
		mask: EncodePercent | EncodeLeftCrLfHtVt,
		in:   "\t／：ζ\"ｍv_－β\t\x17>>␚δ\x0f␎z<ηξ＞eM<＼９␉ｗ",
		out:  "␉／：ζ\"ｍv_－β\t\x17>>␚δ\x0f␎z<ηξ＞eM<＼９␉ｗ",
	}, { // 2158
		mask: EncodePercent | EncodeLeftCrLfHtVt,
		in:   "␉／：ζ\"ｍv_－β\t\x17>>␚δ\x0f␎z<ηξ＞eM<＼９␉ｗ",
		out:  "‛␉／：ζ\"ｍv_－β\t\x17>>␚δ\x0f␎z<ηξ＞eM<＼９␉ｗ",
	}, { // 2159
		mask: EncodePercent | EncodeLeftCrLfHtVt,
		in:   "\t／：ζ\"ｍv_－β\t\x17>>␚δ\x0f␎z<ηξ＞eM<＼９／␉",
		out:  "␉／：ζ\"ｍv_－β\t\x17>>␚δ\x0f␎z<ηξ＞eM<＼９／␉",
	}, { // 2160
		mask: EncodePercent | EncodeLeftCrLfHtVt,
		in:   "␉／：ζ\"ｍv_－β\t\x17>>␚δ\x0f␎z<ηξ＞eM<＼９／␉",
		out:  "‛␉／：ζ\"ｍv_－β\t\x17>>␚δ\x0f␎z<ηξ＞eM<＼９／␉",
	}, { // 2161
		mask: EncodePercent | EncodeLeftCrLfHtVt,
		in:   "β\t：ζ\"ｍv_－β\t\x17>>␚δ\x0f␎z<ηξ＞eM<＼９／ｗ",
		out:  "β\t：ζ\"ｍv_－β\t\x17>>␚δ\x0f␎z<ηξ＞eM<＼９／ｗ",
	}, { // 2162
		mask: EncodePercent | EncodeLeftCrLfHtVt,
		in:   "β␉：ζ\"ｍv_－β\t\x17>>␚δ\x0f␎z<ηξ＞eM<＼９／ｗ",
		out:  "β␉：ζ\"ｍv_－β\t\x17>>␚δ\x0f␎z<ηξ＞eM<＼９／ｗ",
	}, { // 2163
		mask: EncodePercent | EncodeLeftCrLfHtVt,
		in:   "β\t：ζ\"ｍv_－β\t\x17>>␚δ\x0f␎z<ηξ＞eM<＼９␉ｗ",
		out:  "β\t：ζ\"ｍv_－β\t\x17>>␚δ\x0f␎z<ηξ＞eM<＼９␉ｗ",
	}, { // 2164
		mask: EncodePercent | EncodeLeftCrLfHtVt,
		in:   "β␉：ζ\"ｍv_－β\t\x17>>␚δ\x0f␎z<ηξ＞eM<＼９␉ｗ",
		out:  "β␉：ζ\"ｍv_－β\t\x17>>␚δ\x0f␎z<ηξ＞eM<＼９␉ｗ",
	}, { // 2165
		mask: EncodePercent | EncodeLeftCrLfHtVt,
		in:   "β\t：ζ\"ｍv_－β\t\x17>>␚δ\x0f␎z<ηξ＞eM<＼９／␉",
		out:  "β\t：ζ\"ｍv_－β\t\x17>>␚δ\x0f␎z<ηξ＞eM<＼９／␉",
	}, { // 2166
		mask: EncodePercent | EncodeLeftCrLfHtVt,
		in:   "β␉：ζ\"ｍv_－β\t\x17>>␚δ\x0f␎z<ηξ＞eM<＼９／␉",
		out:  "β␉：ζ\"ｍv_－β\t\x17>>␚δ\x0f␎z<ηξ＞eM<＼９／␉",
	}, { // 2167
		mask: EncodePercent | EncodeLeftCrLfHtVt,
		in:   "β／：ζ\"ｍv_－β\t\x17>>␚δ\x0f␎z<ηξ＞eM<＼９\tｗ",
		out:  "β／：ζ\"ｍv_－β\t\x17>>␚δ\x0f␎z<ηξ＞eM<＼９\tｗ",
	}, { // 2168
		mask: EncodePercent | EncodeLeftCrLfHtVt,
		in:   "β／：ζ\"ｍv_－β\t\x17>>␚δ\x0f␎z<ηξ＞eM<＼９␉ｗ",
		out:  "β／：ζ\"ｍv_－β\t\x17>>␚δ\x0f␎z<ηξ＞eM<＼９␉ｗ",
	}, { // 2169
		mask: EncodePercent | EncodeLeftCrLfHtVt,
		in:   "β／：ζ\"ｍv_－β\t\x17>>␚δ\x0f␎z<ηξ＞eM<＼９\t␉",
		out:  "β／：ζ\"ｍv_－β\t\x17>>␚δ\x0f␎z<ηξ＞eM<＼９\t␉",
	}, { // 2170
		mask: EncodePercent | EncodeLeftCrLfHtVt,
		in:   "β／：ζ\"ｍv_－β\t\x17>>␚δ\x0f␎z<ηξ＞eM<＼９␉␉",
		out:  "β／：ζ\"ｍv_－β\t\x17>>␚δ\x0f␎z<ηξ＞eM<＼９␉␉",
	}, { // 2171
		mask: EncodePercent | EncodeLeftCrLfHtVt,
		in:   "β／：ζ\"ｍv_－β\t\x17>>␚δ\x0f␎z<ηξ＞eM<＼９／\t",
		out:  "β／：ζ\"ｍv_－β\t\x17>>␚δ\x0f␎z<ηξ＞eM<＼９／\t",
	}, { // 2172
		mask: EncodePercent | EncodeLeftCrLfHtVt,
		in:   "β／：ζ\"ｍv_－β\t\x17>>␚δ\x0f␎z<ηξ＞eM<＼９／␉",
		out:  "β／：ζ\"ｍv_－β\t\x17>>␚δ\x0f␎z<ηξ＞eM<＼９／␉",
	}, { // 2173
		mask: EncodePercent | EncodeLeftCrLfHtVt,
		in:   "`βρq~γ\x11Ａ&␓\n6␛<＋σ\x10␏␟Ｅ␕\"\vλ␆．\x16|Ｉπ",
		out:  "`βρq~γ\x11Ａ&␓\n6␛<＋σ\x10␏␟Ｅ␕\"\vλ␆．\x16|Ｉπ",
	}, { // 2174
		mask: EncodePercent | EncodeLeftCrLfHtVt,
		in:   "\n␊ρq~γ\x11Ａ&␓\n6␛<＋σ\x10␏␟Ｅ␕\"\vλ␆．\x16|Ｉπ",
		out:  "␊␊ρq~γ\x11Ａ&␓\n6␛<＋σ\x10␏␟Ｅ␕\"\vλ␆．\x16|Ｉπ",
	}, { // 2175
		mask: EncodePercent | EncodeLeftCrLfHtVt,
		in:   "␊␊ρq~γ\x11Ａ&␓\n6␛<＋σ\x10␏␟Ｅ␕\"\vλ␆．\x16|Ｉπ",
		out:  "‛␊␊ρq~γ\x11Ａ&␓\n6␛<＋σ\x10␏␟Ｅ␕\"\vλ␆．\x16|Ｉπ",
	}, { // 2176
		mask: EncodePercent | EncodeLeftCrLfHtVt,
		in:   "\nβρq~γ\x11Ａ&␓\n6␛<＋σ\x10␏␟Ｅ␕\"\vλ␆．\x16|␊π",
		out:  "␊βρq~γ\x11Ａ&␓\n6␛<＋σ\x10␏␟Ｅ␕\"\vλ␆．\x16|␊π",
	}, { // 2177
		mask: EncodePercent | EncodeLeftCrLfHtVt,
		in:   "␊βρq~γ\x11Ａ&␓\n6␛<＋σ\x10␏␟Ｅ␕\"\vλ␆．\x16|␊π",
		out:  "‛␊βρq~γ\x11Ａ&␓\n6␛<＋σ\x10␏␟Ｅ␕\"\vλ␆．\x16|␊π",
	}, { // 2178
		mask: EncodePercent | EncodeLeftCrLfHtVt,
		in:   "\nβρq~γ\x11Ａ&␓\n6␛<＋σ\x10␏␟Ｅ␕\"\vλ␆．\x16|Ｉ␊",
		out:  "␊βρq~γ\x11Ａ&␓\n6␛<＋σ\x10␏␟Ｅ␕\"\vλ␆．\x16|Ｉ␊",
	}, { // 2179
		mask: EncodePercent | EncodeLeftCrLfHtVt,
		in:   "␊βρq~γ\x11Ａ&␓\n6␛<＋σ\x10␏␟Ｅ␕\"\vλ␆．\x16|Ｉ␊",
		out:  "‛␊βρq~γ\x11Ａ&␓\n6␛<＋σ\x10␏␟Ｅ␕\"\vλ␆．\x16|Ｉ␊",
	}, { // 2180
		mask: EncodePercent | EncodeLeftCrLfHtVt,
		in:   "`\nρq~γ\x11Ａ&␓\n6␛<＋σ\x10␏␟Ｅ␕\"\vλ␆．\x16|Ｉπ",
		out:  "`\nρq~γ\x11Ａ&␓\n6␛<＋σ\x10␏␟Ｅ␕\"\vλ␆．\x16|Ｉπ",
	}, { // 2181
		mask: EncodePercent | EncodeLeftCrLfHtVt,
		in:   "`␊ρq~γ\x11Ａ&␓\n6␛<＋σ\x10␏␟Ｅ␕\"\vλ␆．\x16|Ｉπ",
		out:  "`␊ρq~γ\x11Ａ&␓\n6␛<＋σ\x10␏␟Ｅ␕\"\vλ␆．\x16|Ｉπ",
	}, { // 2182
		mask: EncodePercent | EncodeLeftCrLfHtVt,
		in:   "`\nρq~γ\x11Ａ&␓\n6␛<＋σ\x10␏␟Ｅ␕\"\vλ␆．\x16|␊π",
		out:  "`\nρq~γ\x11Ａ&␓\n6␛<＋σ\x10␏␟Ｅ␕\"\vλ␆．\x16|␊π",
	}, { // 2183
		mask: EncodePercent | EncodeLeftCrLfHtVt,
		in:   "`␊ρq~γ\x11Ａ&␓\n6␛<＋σ\x10␏␟Ｅ␕\"\vλ␆．\x16|␊π",
		out:  "`␊ρq~γ\x11Ａ&␓\n6␛<＋σ\x10␏␟Ｅ␕\"\vλ␆．\x16|␊π",
	}, { // 2184
		mask: EncodePercent | EncodeLeftCrLfHtVt,
		in:   "`\nρq~γ\x11Ａ&␓\n6␛<＋σ\x10␏␟Ｅ␕\"\vλ␆．\x16|Ｉ␊",
		out:  "`\nρq~γ\x11Ａ&␓\n6␛<＋σ\x10␏␟Ｅ␕\"\vλ␆．\x16|Ｉ␊",
	}, { // 2185
		mask: EncodePercent | EncodeLeftCrLfHtVt,
		in:   "`␊ρq~γ\x11Ａ&␓\n6␛<＋σ\x10␏␟Ｅ␕\"\vλ␆．\x16|Ｉ␊",
		out:  "`␊ρq~γ\x11Ａ&␓\n6␛<＋σ\x10␏␟Ｅ␕\"\vλ␆．\x16|Ｉ␊",
	}, { // 2186
		mask: EncodePercent | EncodeLeftCrLfHtVt,
		in:   "`βρq~γ\x11Ａ&␓\n6␛<＋σ\x10␏␟Ｅ␕\"\vλ␆．\x16|\nπ",
		out:  "`βρq~γ\x11Ａ&␓\n6␛<＋σ\x10␏␟Ｅ␕\"\vλ␆．\x16|\nπ",
	}, { // 2187
		mask: EncodePercent | EncodeLeftCrLfHtVt,
		in:   "`βρq~γ\x11Ａ&␓\n6␛<＋σ\x10␏␟Ｅ␕\"\vλ␆．\x16|␊π",
		out:  "`βρq~γ\x11Ａ&␓\n6␛<＋σ\x10␏␟Ｅ␕\"\vλ␆．\x16|␊π",
	}, { // 2188
		mask: EncodePercent | EncodeLeftCrLfHtVt,
		in:   "`βρq~γ\x11Ａ&␓\n6␛<＋σ\x10␏␟Ｅ␕\"\vλ␆．\x16|\n␊",
		out:  "`βρq~γ\x11Ａ&␓\n6␛<＋σ\x10␏␟Ｅ␕\"\vλ␆．\x16|\n␊",
	}, { // 2189
		mask: EncodePercent | EncodeLeftCrLfHtVt,
		in:   "`βρq~γ\x11Ａ&␓\n6␛<＋σ\x10␏␟Ｅ␕\"\vλ␆．\x16|␊␊",
		out:  "`βρq~γ\x11Ａ&␓\n6␛<＋σ\x10␏␟Ｅ␕\"\vλ␆．\x16|␊␊",
	}, { // 2190
		mask: EncodePercent | EncodeLeftCrLfHtVt,
		in:   "`βρq~γ\x11Ａ&␓\n6␛<＋σ\x10␏␟Ｅ␕\"\vλ␆．\x16|Ｉ\n",
		out:  "`βρq~γ\x11Ａ&␓\n6␛<＋σ\x10␏␟Ｅ␕\"\vλ␆．\x16|Ｉ\n",
	}, { // 2191
		mask: EncodePercent | EncodeLeftCrLfHtVt,
		in:   "`βρq~γ\x11Ａ&␓\n6␛<＋σ\x10␏␟Ｅ␕\"\vλ␆．\x16|Ｉ␊",
		out:  "`βρq~γ\x11Ａ&␓\n6␛<＋σ\x10␏␟Ｅ␕\"\vλ␆．\x16|Ｉ␊",
	}, { // 2192
		mask: EncodePercent | EncodeLeftCrLfHtVt,
		in:   "\u007fcρ:'ｋＢχ＆|\vμν\x1aες␟5RＯ/␖\x18w␌ｉ＃＾␁␔",
		out:  "\u007fcρ:'ｋＢχ＆|\vμν\x1aες␟5RＯ/␖\x18w␌ｉ＃＾␁␔",
	}, { // 2193
		mask: EncodePercent | EncodeLeftCrLfHtVt,
		in:   "\v␋ρ:'ｋＢχ＆|\vμν\x1aες␟5RＯ/␖\x18w␌ｉ＃＾␁␔",
		out:  "␋␋ρ:'ｋＢχ＆|\vμν\x1aες␟5RＯ/␖\x18w␌ｉ＃＾␁␔",
	}, { // 2194
		mask: EncodePercent | EncodeLeftCrLfHtVt,
		in:   "␋␋ρ:'ｋＢχ＆|\vμν\x1aες␟5RＯ/␖\x18w␌ｉ＃＾␁␔",
		out:  "‛␋␋ρ:'ｋＢχ＆|\vμν\x1aες␟5RＯ/␖\x18w␌ｉ＃＾␁␔",
	}, { // 2195
		mask: EncodePercent | EncodeLeftCrLfHtVt,
		in:   "\vcρ:'ｋＢχ＆|\vμν\x1aες␟5RＯ/␖\x18w␌ｉ＃＾␋␔",
		out:  "␋cρ:'ｋＢχ＆|\vμν\x1aες␟5RＯ/␖\x18w␌ｉ＃＾␋␔",
	}, { // 2196
		mask: EncodePercent | EncodeLeftCrLfHtVt,
		in:   "␋cρ:'ｋＢχ＆|\vμν\x1aες␟5RＯ/␖\x18w␌ｉ＃＾␋␔",
		out:  "‛␋cρ:'ｋＢχ＆|\vμν\x1aες␟5RＯ/␖\x18w␌ｉ＃＾␋␔",
	}, { // 2197
		mask: EncodePercent | EncodeLeftCrLfHtVt,
		in:   "\vcρ:'ｋＢχ＆|\vμν\x1aες␟5RＯ/␖\x18w␌ｉ＃＾␁␋",
		out:  "␋cρ:'ｋＢχ＆|\vμν\x1aες␟5RＯ/␖\x18w␌ｉ＃＾␁␋",
	}, { // 2198
		mask: EncodePercent | EncodeLeftCrLfHtVt,
		in:   "␋cρ:'ｋＢχ＆|\vμν\x1aες␟5RＯ/␖\x18w␌ｉ＃＾␁␋",
		out:  "‛␋cρ:'ｋＢχ＆|\vμν\x1aες␟5RＯ/␖\x18w␌ｉ＃＾␁␋",
	}, { // 2199
		mask: EncodePercent | EncodeLeftCrLfHtVt,
		in:   "\u007f\vρ:'ｋＢχ＆|\vμν\x1aες␟5RＯ/␖\x18w␌ｉ＃＾␁␔",
		out:  "\u007f\vρ:'ｋＢχ＆|\vμν\x1aες␟5RＯ/␖\x18w␌ｉ＃＾␁␔",
	}, { // 2200
		mask: EncodePercent | EncodeLeftCrLfHtVt,
		in:   "\u007f␋ρ:'ｋＢχ＆|\vμν\x1aες␟5RＯ/␖\x18w␌ｉ＃＾␁␔",
		out:  "\u007f␋ρ:'ｋＢχ＆|\vμν\x1aες␟5RＯ/␖\x18w␌ｉ＃＾␁␔",
	}, { // 2201
		mask: EncodePercent | EncodeLeftCrLfHtVt,
		in:   "\u007f\vρ:'ｋＢχ＆|\vμν\x1aες␟5RＯ/␖\x18w␌ｉ＃＾␋␔",
		out:  "\u007f\vρ:'ｋＢχ＆|\vμν\x1aες␟5RＯ/␖\x18w␌ｉ＃＾␋␔",
	}, { // 2202
		mask: EncodePercent | EncodeLeftCrLfHtVt,
		in:   "\u007f␋ρ:'ｋＢχ＆|\vμν\x1aες␟5RＯ/␖\x18w␌ｉ＃＾␋␔",
		out:  "\u007f␋ρ:'ｋＢχ＆|\vμν\x1aες␟5RＯ/␖\x18w␌ｉ＃＾␋␔",
	}, { // 2203
		mask: EncodePercent | EncodeLeftCrLfHtVt,
		in:   "\u007f\vρ:'ｋＢχ＆|\vμν\x1aες␟5RＯ/␖\x18w␌ｉ＃＾␁␋",
		out:  "\u007f\vρ:'ｋＢχ＆|\vμν\x1aες␟5RＯ/␖\x18w␌ｉ＃＾␁␋",
	}, { // 2204
		mask: EncodePercent | EncodeLeftCrLfHtVt,
		in:   "\u007f␋ρ:'ｋＢχ＆|\vμν\x1aες␟5RＯ/␖\x18w␌ｉ＃＾␁␋",
		out:  "\u007f␋ρ:'ｋＢχ＆|\vμν\x1aες␟5RＯ/␖\x18w␌ｉ＃＾␁␋",
	}, { // 2205
		mask: EncodePercent | EncodeLeftCrLfHtVt,
		in:   "\u007fcρ:'ｋＢχ＆|\vμν\x1aες␟5RＯ/␖\x18w␌ｉ＃＾\v␔",
		out:  "\u007fcρ:'ｋＢχ＆|\vμν\x1aες␟5RＯ/␖\x18w␌ｉ＃＾\v␔",
	}, { // 2206
		mask: EncodePercent | EncodeLeftCrLfHtVt,
		in:   "\u007fcρ:'ｋＢχ＆|\vμν\x1aες␟5RＯ/␖\x18w␌ｉ＃＾␋␔",
		out:  "\u007fcρ:'ｋＢχ＆|\vμν\x1aες␟5RＯ/␖\x18w␌ｉ＃＾␋␔",
	}, { // 2207
		mask: EncodePercent | EncodeLeftCrLfHtVt,
		in:   "\u007fcρ:'ｋＢχ＆|\vμν\x1aες␟5RＯ/␖\x18w␌ｉ＃＾\v␋",
		out:  "\u007fcρ:'ｋＢχ＆|\vμν\x1aες␟5RＯ/␖\x18w␌ｉ＃＾\v␋",
	}, { // 2208
		mask: EncodePercent | EncodeLeftCrLfHtVt,
		in:   "\u007fcρ:'ｋＢχ＆|\vμν\x1aες␟5RＯ/␖\x18w␌ｉ＃＾␋␋",
		out:  "\u007fcρ:'ｋＢχ＆|\vμν\x1aες␟5RＯ/␖\x18w␌ｉ＃＾␋␋",
	}, { // 2209
		mask: EncodePercent | EncodeLeftCrLfHtVt,
		in:   "\u007fcρ:'ｋＢχ＆|\vμν\x1aες␟5RＯ/␖\x18w␌ｉ＃＾␁\v",
		out:  "\u007fcρ:'ｋＢχ＆|\vμν\x1aες␟5RＯ/␖\x18w␌ｉ＃＾␁\v",
	}, { // 2210
		mask: EncodePercent | EncodeLeftCrLfHtVt,
		in:   "\u007fcρ:'ｋＢχ＆|\vμν\x1aες␟5RＯ/␖\x18w␌ｉ＃＾␁␋",
		out:  "\u007fcρ:'ｋＢχ＆|\vμν\x1aες␟5RＯ/␖\x18w␌ｉ＃＾␁␋",
	}, { // 2211
		mask: EncodePercent | EncodeLeftCrLfHtVt,
		in:   "４ｌV／*O\x1c\x1aωｂ\r\x0fι\x00ｍ7␏ςμ␃＜$＞ＶR$？ｎ\x0eθ",
		out:  "４ｌV／*O\x1c\x1aωｂ\r\x0fι␀ｍ7␏ςμ␃＜$＞ＶR$？ｎ\x0eθ",
	}, { // 2212
		mask: EncodePercent | EncodeLeftCrLfHtVt,
		in:   "\r␍V／*O\x1c\x1aωｂ\r\x0fι\x00ｍ7␏ςμ␃＜$＞ＶR$？ｎ\x0eθ",
		out:  "␍␍V／*O\x1c\x1aωｂ\r\x0fι␀ｍ7␏ςμ␃＜$＞ＶR$？ｎ\x0eθ",
	}, { // 2213
		mask: EncodePercent | EncodeLeftCrLfHtVt,
		in:   "␍␍V／*O\x1c\x1aωｂ\r\x0fι\x00ｍ7␏ςμ␃＜$＞ＶR$？ｎ\x0eθ",
		out:  "‛␍␍V／*O\x1c\x1aωｂ\r\x0fι␀ｍ7␏ςμ␃＜$＞ＶR$？ｎ\x0eθ",
	}, { // 2214
		mask: EncodePercent | EncodeLeftCrLfHtVt,
		in:   "\rｌV／*O\x1c\x1aωｂ\r\x0fι\x00ｍ7␏ςμ␃＜$＞ＶR$？ｎ␍θ",
		out:  "␍ｌV／*O\x1c\x1aωｂ\r\x0fι␀ｍ7␏ςμ␃＜$＞ＶR$？ｎ␍θ",
	}, { // 2215
		mask: EncodePercent | EncodeLeftCrLfHtVt,
		in:   "␍ｌV／*O\x1c\x1aωｂ\r\x0fι\x00ｍ7␏ςμ␃＜$＞ＶR$？ｎ␍θ",
		out:  "‛␍ｌV／*O\x1c\x1aωｂ\r\x0fι␀ｍ7␏ςμ␃＜$＞ＶR$？ｎ␍θ",
	}, { // 2216
		mask: EncodePercent | EncodeLeftCrLfHtVt,
		in:   "\rｌV／*O\x1c\x1aωｂ\r\x0fι\x00ｍ7␏ςμ␃＜$＞ＶR$？ｎ\x0e␍",
		out:  "␍ｌV／*O\x1c\x1aωｂ\r\x0fι␀ｍ7␏ςμ␃＜$＞ＶR$？ｎ\x0e␍",
	}, { // 2217
		mask: EncodePercent | EncodeLeftCrLfHtVt,
		in:   "␍ｌV／*O\x1c\x1aωｂ\r\x0fι\x00ｍ7␏ςμ␃＜$＞ＶR$？ｎ\x0e␍",
		out:  "‛␍ｌV／*O\x1c\x1aωｂ\r\x0fι␀ｍ7␏ςμ␃＜$＞ＶR$？ｎ\x0e␍",
	}, { // 2218
		mask: EncodePercent | EncodeLeftCrLfHtVt,
		in:   "４\rV／*O\x1c\x1aωｂ\r\x0fι\x00ｍ7␏ςμ␃＜$＞ＶR$？ｎ\x0eθ",
		out:  "４\rV／*O\x1c\x1aωｂ\r\x0fι␀ｍ7␏ςμ␃＜$＞ＶR$？ｎ\x0eθ",
	}, { // 2219
		mask: EncodePercent | EncodeLeftCrLfHtVt,
		in:   "４␍V／*O\x1c\x1aωｂ\r\x0fι\x00ｍ7␏ςμ␃＜$＞ＶR$？ｎ\x0eθ",
		out:  "４␍V／*O\x1c\x1aωｂ\r\x0fι␀ｍ7␏ςμ␃＜$＞ＶR$？ｎ\x0eθ",
	}, { // 2220
		mask: EncodePercent | EncodeLeftCrLfHtVt,
		in:   "４\rV／*O\x1c\x1aωｂ\r\x0fι\x00ｍ7␏ςμ␃＜$＞ＶR$？ｎ␍θ",
		out:  "４\rV／*O\x1c\x1aωｂ\r\x0fι␀ｍ7␏ςμ␃＜$＞ＶR$？ｎ␍θ",
	}, { // 2221
		mask: EncodePercent | EncodeLeftCrLfHtVt,
		in:   "４␍V／*O\x1c\x1aωｂ\r\x0fι\x00ｍ7␏ςμ␃＜$＞ＶR$？ｎ␍θ",
		out:  "４␍V／*O\x1c\x1aωｂ\r\x0fι␀ｍ7␏ςμ␃＜$＞ＶR$？ｎ␍θ",
	}, { // 2222
		mask: EncodePercent | EncodeLeftCrLfHtVt,
		in:   "４\rV／*O\x1c\x1aωｂ\r\x0fι\x00ｍ7␏ςμ␃＜$＞ＶR$？ｎ\x0e␍",
		out:  "４\rV／*O\x1c\x1aωｂ\r\x0fι␀ｍ7␏ςμ␃＜$＞ＶR$？ｎ\x0e␍",
	}, { // 2223
		mask: EncodePercent | EncodeLeftCrLfHtVt,
		in:   "４␍V／*O\x1c\x1aωｂ\r\x0fι\x00ｍ7␏ςμ␃＜$＞ＶR$？ｎ\x0e␍",
		out:  "４␍V／*O\x1c\x1aωｂ\r\x0fι␀ｍ7␏ςμ␃＜$＞ＶR$？ｎ\x0e␍",
	}, { // 2224
		mask: EncodePercent | EncodeLeftCrLfHtVt,
		in:   "４ｌV／*O\x1c\x1aωｂ\r\x0fι\x00ｍ7␏ςμ␃＜$＞ＶR$？ｎ\rθ",
		out:  "４ｌV／*O\x1c\x1aωｂ\r\x0fι␀ｍ7␏ςμ␃＜$＞ＶR$？ｎ\rθ",
	}, { // 2225
		mask: EncodePercent | EncodeLeftCrLfHtVt,
		in:   "４ｌV／*O\x1c\x1aωｂ\r\x0fι\x00ｍ7␏ςμ␃＜$＞ＶR$？ｎ␍θ",
		out:  "４ｌV／*O\x1c\x1aωｂ\r\x0fι␀ｍ7␏ςμ␃＜$＞ＶR$？ｎ␍θ",
	}, { // 2226
		mask: EncodePercent | EncodeLeftCrLfHtVt,
		in:   "４ｌV／*O\x1c\x1aωｂ\r\x0fι\x00ｍ7␏ςμ␃＜$＞ＶR$？ｎ\r␍",
		out:  "４ｌV／*O\x1c\x1aωｂ\r\x0fι␀ｍ7␏ςμ␃＜$＞ＶR$？ｎ\r␍",
	}, { // 2227
		mask: EncodePercent | EncodeLeftCrLfHtVt,
		in:   "４ｌV／*O\x1c\x1aωｂ\r\x0fι\x00ｍ7␏ςμ␃＜$＞ＶR$？ｎ␍␍",
		out:  "４ｌV／*O\x1c\x1aωｂ\r\x0fι␀ｍ7␏ςμ␃＜$＞ＶR$？ｎ␍␍",
	}, { // 2228
		mask: EncodePercent | EncodeLeftCrLfHtVt,
		in:   "４ｌV／*O\x1c\x1aωｂ\r\x0fι\x00ｍ7␏ςμ␃＜$＞ＶR$？ｎ\x0e\r",
		out:  "４ｌV／*O\x1c\x1aωｂ\r\x0fι␀ｍ7␏ςμ␃＜$＞ＶR$？ｎ\x0e\r",
	}, { // 2229
		mask: EncodePercent | EncodeLeftCrLfHtVt,
		in:   "４ｌV／*O\x1c\x1aωｂ\r\x0fι\x00ｍ7␏ςμ␃＜$＞ＶR$？ｎ\x0e␍",
		out:  "４ｌV／*O\x1c\x1aωｂ\r\x0fι␀ｍ7␏ςμ␃＜$＞ＶR$？ｎ\x0e␍",
	}, { // 2230
		mask: EncodeBackSlash | EncodeLeftCrLfHtVt,
		in:   "＼F␈π␟βtιS]\tφ<ｌ（／$7\x1b|η*ｐ３␎␔？ι?g",
		out:  "‛＼F␈π␟βtιS]\tφ<ｌ（／$7\x1b|η*ｐ３␎␔？ι?g",
	}, { // 2231
		mask: EncodeBackSlash | EncodeLeftCrLfHtVt,
		in:   "\t␉␈π␟βtιS]\tφ<ｌ（／$7\x1b|η*ｐ３␎␔？ι?g",
		out:  "␉␉␈π␟βtιS]\tφ<ｌ（／$7\x1b|η*ｐ３␎␔？ι?g",
	}, { // 2232
		mask: EncodeBackSlash | EncodeLeftCrLfHtVt,
		in:   "␉␉␈π␟βtιS]\tφ<ｌ（／$7\x1b|η*ｐ３␎␔？ι?g",
		out:  "‛␉␉␈π␟βtιS]\tφ<ｌ（／$7\x1b|η*ｐ３␎␔？ι?g",
	}, { // 2233
		mask: EncodeBackSlash | EncodeLeftCrLfHtVt,
		in:   "\tF␈π␟βtιS]\tφ<ｌ（／$7\x1b|η*ｐ３␎␔？ι␉g",
		out:  "␉F␈π␟βtιS]\tφ<ｌ（／$7\x1b|η*ｐ３␎␔？ι␉g",
	}, { // 2234
		mask: EncodeBackSlash | EncodeLeftCrLfHtVt,
		in:   "␉F␈π␟βtιS]\tφ<ｌ（／$7\x1b|η*ｐ３␎␔？ι␉g",
		out:  "‛␉F␈π␟βtιS]\tφ<ｌ（／$7\x1b|η*ｐ３␎␔？ι␉g",
	}, { // 2235
		mask: EncodeBackSlash | EncodeLeftCrLfHtVt,
		in:   "\tF␈π␟βtιS]\tφ<ｌ（／$7\x1b|η*ｐ３␎␔？ι?␉",
		out:  "␉F␈π␟βtιS]\tφ<ｌ（／$7\x1b|η*ｐ３␎␔？ι?␉",
	}, { // 2236
		mask: EncodeBackSlash | EncodeLeftCrLfHtVt,
		in:   "␉F␈π␟βtιS]\tφ<ｌ（／$7\x1b|η*ｐ３␎␔？ι?␉",
		out:  "‛␉F␈π␟βtιS]\tφ<ｌ（／$7\x1b|η*ｐ３␎␔？ι?␉",
	}, { // 2237
		mask: EncodeBackSlash | EncodeLeftCrLfHtVt,
		in:   "＼\t␈π␟βtιS]\tφ<ｌ（／$7\x1b|η*ｐ３␎␔？ι?g",
		out:  "‛＼\t␈π␟βtιS]\tφ<ｌ（／$7\x1b|η*ｐ３␎␔？ι?g",
	}, { // 2238
		mask: EncodeBackSlash | EncodeLeftCrLfHtVt,
		in:   "＼␉␈π␟βtιS]\tφ<ｌ（／$7\x1b|η*ｐ３␎␔？ι?g",
		out:  "‛＼␉␈π␟βtιS]\tφ<ｌ（／$7\x1b|η*ｐ３␎␔？ι?g",
	}, { // 2239
		mask: EncodeBackSlash | EncodeLeftCrLfHtVt,
		in:   "＼\t␈π␟βtιS]\tφ<ｌ（／$7\x1b|η*ｐ３␎␔？ι␉g",
		out:  "‛＼\t␈π␟βtιS]\tφ<ｌ（／$7\x1b|η*ｐ３␎␔？ι␉g",
	}, { // 2240
		mask: EncodeBackSlash | EncodeLeftCrLfHtVt,
		in:   "＼␉␈π␟βtιS]\tφ<ｌ（／$7\x1b|η*ｐ３␎␔？ι␉g",
		out:  "‛＼␉␈π␟βtιS]\tφ<ｌ（／$7\x1b|η*ｐ３␎␔？ι␉g",
	}, { // 2241
		mask: EncodeBackSlash | EncodeLeftCrLfHtVt,
		in:   "＼\t␈π␟βtιS]\tφ<ｌ（／$7\x1b|η*ｐ３␎␔？ι?␉",
		out:  "‛＼\t␈π␟βtιS]\tφ<ｌ（／$7\x1b|η*ｐ３␎␔？ι?␉",
	}, { // 2242
		mask: EncodeBackSlash | EncodeLeftCrLfHtVt,
		in:   "＼␉␈π␟βtιS]\tφ<ｌ（／$7\x1b|η*ｐ３␎␔？ι?␉",
		out:  "‛＼␉␈π␟βtιS]\tφ<ｌ（／$7\x1b|η*ｐ３␎␔？ι?␉",
	}, { // 2243
		mask: EncodeBackSlash | EncodeLeftCrLfHtVt,
		in:   "＼F␈π␟βtιS]\tφ<ｌ（／$7\x1b|η*ｐ３␎␔？ι\tg",
		out:  "‛＼F␈π␟βtιS]\tφ<ｌ（／$7\x1b|η*ｐ３␎␔？ι\tg",
	}, { // 2244
		mask: EncodeBackSlash | EncodeLeftCrLfHtVt,
		in:   "＼F␈π␟βtιS]\tφ<ｌ（／$7\x1b|η*ｐ３␎␔？ι␉g",
		out:  "‛＼F␈π␟βtιS]\tφ<ｌ（／$7\x1b|η*ｐ３␎␔？ι␉g",
	}, { // 2245
		mask: EncodeBackSlash | EncodeLeftCrLfHtVt,
		in:   "＼F␈π␟βtιS]\tφ<ｌ（／$7\x1b|η*ｐ３␎␔？ι\t␉",
		out:  "‛＼F␈π␟βtιS]\tφ<ｌ（／$7\x1b|η*ｐ３␎␔？ι\t␉",
	}, { // 2246
		mask: EncodeBackSlash | EncodeLeftCrLfHtVt,
		in:   "＼F␈π␟βtιS]\tφ<ｌ（／$7\x1b|η*ｐ３␎␔？ι␉␉",
		out:  "‛＼F␈π␟βtιS]\tφ<ｌ（／$7\x1b|η*ｐ３␎␔？ι␉␉",
	}, { // 2247
		mask: EncodeBackSlash | EncodeLeftCrLfHtVt,
		in:   "＼F␈π␟βtιS]\tφ<ｌ（／$7\x1b|η*ｐ３␎␔？ι?\t",
		out:  "‛＼F␈π␟βtιS]\tφ<ｌ（／$7\x1b|η*ｐ３␎␔？ι?\t",
	}, { // 2248
		mask: EncodeBackSlash | EncodeLeftCrLfHtVt,
		in:   "＼F␈π␟βtιS]\tφ<ｌ（／$7\x1b|η*ｐ３␎␔？ι?␉",
		out:  "‛＼F␈π␟βtιS]\tφ<ｌ（／$7\x1b|η*ｐ３␎␔？ι?␉",
	}, { // 2249
		mask: EncodeBackSlash | EncodeLeftCrLfHtVt,
		in:   "？T＊＄να;'\x1c\f\nＴq\x1aυｏl\x12φ％,＇＞␑ＨL＜η｀\\",
		out:  "？T＊＄να;'\x1c\f\nＴq\x1aυｏl\x12φ％,＇＞␑ＨL＜η｀＼",
	}, { // 2250
		mask: EncodeBackSlash | EncodeLeftCrLfHtVt,
		in:   "\n␊＊＄να;'\x1c\f\nＴq\x1aυｏl\x12φ％,＇＞␑ＨL＜η｀\\",
		out:  "␊␊＊＄να;'\x1c\f\nＴq\x1aυｏl\x12φ％,＇＞␑ＨL＜η｀＼",
	}, { // 2251
		mask: EncodeBackSlash | EncodeLeftCrLfHtVt,
		in:   "␊␊＊＄να;'\x1c\f\nＴq\x1aυｏl\x12φ％,＇＞␑ＨL＜η｀\\",
		out:  "‛␊␊＊＄να;'\x1c\f\nＴq\x1aυｏl\x12φ％,＇＞␑ＨL＜η｀＼",
	}, { // 2252
		mask: EncodeBackSlash | EncodeLeftCrLfHtVt,
		in:   "\nT＊＄να;'\x1c\f\nＴq\x1aυｏl\x12φ％,＇＞␑ＨL＜η␊\\",
		out:  "␊T＊＄να;'\x1c\f\nＴq\x1aυｏl\x12φ％,＇＞␑ＨL＜η␊＼",
	}, { // 2253
		mask: EncodeBackSlash | EncodeLeftCrLfHtVt,
		in:   "␊T＊＄να;'\x1c\f\nＴq\x1aυｏl\x12φ％,＇＞␑ＨL＜η␊\\",
		out:  "‛␊T＊＄να;'\x1c\f\nＴq\x1aυｏl\x12φ％,＇＞␑ＨL＜η␊＼",
	}, { // 2254
		mask: EncodeBackSlash | EncodeLeftCrLfHtVt,
		in:   "\nT＊＄να;'\x1c\f\nＴq\x1aυｏl\x12φ％,＇＞␑ＨL＜η｀␊",
		out:  "␊T＊＄να;'\x1c\f\nＴq\x1aυｏl\x12φ％,＇＞␑ＨL＜η｀␊",
	}, { // 2255
		mask: EncodeBackSlash | EncodeLeftCrLfHtVt,
		in:   "␊T＊＄να;'\x1c\f\nＴq\x1aυｏl\x12φ％,＇＞␑ＨL＜η｀␊",
		out:  "‛␊T＊＄να;'\x1c\f\nＴq\x1aυｏl\x12φ％,＇＞␑ＨL＜η｀␊",
	}, { // 2256
		mask: EncodeBackSlash | EncodeLeftCrLfHtVt,
		in:   "？\n＊＄να;'\x1c\f\nＴq\x1aυｏl\x12φ％,＇＞␑ＨL＜η｀\\",
		out:  "？\n＊＄να;'\x1c\f\nＴq\x1aυｏl\x12φ％,＇＞␑ＨL＜η｀＼",
	}, { // 2257
		mask: EncodeBackSlash | EncodeLeftCrLfHtVt,
		in:   "？␊＊＄να;'\x1c\f\nＴq\x1aυｏl\x12φ％,＇＞␑ＨL＜η｀\\",
		out:  "？␊＊＄να;'\x1c\f\nＴq\x1aυｏl\x12φ％,＇＞␑ＨL＜η｀＼",
	}, { // 2258
		mask: EncodeBackSlash | EncodeLeftCrLfHtVt,
		in:   "？\n＊＄να;'\x1c\f\nＴq\x1aυｏl\x12φ％,＇＞␑ＨL＜η␊\\",
		out:  "？\n＊＄να;'\x1c\f\nＴq\x1aυｏl\x12φ％,＇＞␑ＨL＜η␊＼",
	}, { // 2259
		mask: EncodeBackSlash | EncodeLeftCrLfHtVt,
		in:   "？␊＊＄να;'\x1c\f\nＴq\x1aυｏl\x12φ％,＇＞␑ＨL＜η␊\\",
		out:  "？␊＊＄να;'\x1c\f\nＴq\x1aυｏl\x12φ％,＇＞␑ＨL＜η␊＼",
	}, { // 2260
		mask: EncodeBackSlash | EncodeLeftCrLfHtVt,
		in:   "？\n＊＄να;'\x1c\f\nＴq\x1aυｏl\x12φ％,＇＞␑ＨL＜η｀␊",
		out:  "？\n＊＄να;'\x1c\f\nＴq\x1aυｏl\x12φ％,＇＞␑ＨL＜η｀␊",
	}, { // 2261
		mask: EncodeBackSlash | EncodeLeftCrLfHtVt,
		in:   "？␊＊＄να;'\x1c\f\nＴq\x1aυｏl\x12φ％,＇＞␑ＨL＜η｀␊",
		out:  "？␊＊＄να;'\x1c\f\nＴq\x1aυｏl\x12φ％,＇＞␑ＨL＜η｀␊",
	}, { // 2262
		mask: EncodeBackSlash | EncodeLeftCrLfHtVt,
		in:   "？T＊＄να;'\x1c\f\nＴq\x1aυｏl\x12φ％,＇＞␑ＨL＜η\n\\",
		out:  "？T＊＄να;'\x1c\f\nＴq\x1aυｏl\x12φ％,＇＞␑ＨL＜η\n＼",
	}, { // 2263
		mask: EncodeBackSlash | EncodeLeftCrLfHtVt,
		in:   "？T＊＄να;'\x1c\f\nＴq\x1aυｏl\x12φ％,＇＞␑ＨL＜η␊\\",
		out:  "？T＊＄να;'\x1c\f\nＴq\x1aυｏl\x12φ％,＇＞␑ＨL＜η␊＼",
	}, { // 2264
		mask: EncodeBackSlash | EncodeLeftCrLfHtVt,
		in:   "？T＊＄να;'\x1c\f\nＴq\x1aυｏl\x12φ％,＇＞␑ＨL＜η\n␊",
		out:  "？T＊＄να;'\x1c\f\nＴq\x1aυｏl\x12φ％,＇＞␑ＨL＜η\n␊",
	}, { // 2265
		mask: EncodeBackSlash | EncodeLeftCrLfHtVt,
		in:   "？T＊＄να;'\x1c\f\nＴq\x1aυｏl\x12φ％,＇＞␑ＨL＜η␊␊",
		out:  "？T＊＄να;'\x1c\f\nＴq\x1aυｏl\x12φ％,＇＞␑ＨL＜η␊␊",
	}, { // 2266
		mask: EncodeBackSlash | EncodeLeftCrLfHtVt,
		in:   "？T＊＄να;'\x1c\f\nＴq\x1aυｏl\x12φ％,＇＞␑ＨL＜η｀\n",
		out:  "？T＊＄να;'\x1c\f\nＴq\x1aυｏl\x12φ％,＇＞␑ＨL＜η｀\n",
	}, { // 2267
		mask: EncodeBackSlash | EncodeLeftCrLfHtVt,
		in:   "？T＊＄να;'\x1c\f\nＴq\x1aυｏl\x12φ％,＇＞␑ＨL＜η｀␊",
		out:  "？T＊＄να;'\x1c\f\nＴq\x1aυｏl\x12φ％,＇＞␑ＨL＜η｀␊",
	}, { // 2268
		mask: EncodeBackSlash | EncodeLeftCrLfHtVt,
		in:   "^\x14／＼］\vεＵ｀β\vＹ）\v/．％κ9k\\fB\x1fｍτ＇kＭα",
		out:  "^\x14／‛＼］\vεＵ｀β\vＹ）\v/．％κ9k＼fB\x1fｍτ＇kＭα",
	}, { // 2269
		mask: EncodeBackSlash | EncodeLeftCrLfHtVt,
		in:   "\v␋／＼］\vεＵ｀β\vＹ）\v/．％κ9k\\fB\x1fｍτ＇kＭα",
		out:  "␋␋／‛＼］\vεＵ｀β\vＹ）\v/．％κ9k＼fB\x1fｍτ＇kＭα",
	}, { // 2270
		mask: EncodeBackSlash | EncodeLeftCrLfHtVt,
		in:   "␋␋／＼］\vεＵ｀β\vＹ）\v/．％κ9k\\fB\x1fｍτ＇kＭα",
		out:  "‛␋␋／‛＼］\vεＵ｀β\vＹ）\v/．％κ9k＼fB\x1fｍτ＇kＭα",
	}, { // 2271
		mask: EncodeBackSlash | EncodeLeftCrLfHtVt,
		in:   "\v\x14／＼］\vεＵ｀β\vＹ）\v/．％κ9k\\fB\x1fｍτ＇k␋α",
		out:  "␋\x14／‛＼］\vεＵ｀β\vＹ）\v/．％κ9k＼fB\x1fｍτ＇k␋α",
	}, { // 2272
		mask: EncodeBackSlash | EncodeLeftCrLfHtVt,
		in:   "␋\x14／＼］\vεＵ｀β\vＹ）\v/．％κ9k\\fB\x1fｍτ＇k␋α",
		out:  "‛␋\x14／‛＼］\vεＵ｀β\vＹ）\v/．％κ9k＼fB\x1fｍτ＇k␋α",
	}, { // 2273
		mask: EncodeBackSlash | EncodeLeftCrLfHtVt,
		in:   "\v\x14／＼］\vεＵ｀β\vＹ）\v/．％κ9k\\fB\x1fｍτ＇kＭ␋",
		out:  "␋\x14／‛＼］\vεＵ｀β\vＹ）\v/．％κ9k＼fB\x1fｍτ＇kＭ␋",
	}, { // 2274
		mask: EncodeBackSlash | EncodeLeftCrLfHtVt,
		in:   "␋\x14／＼］\vεＵ｀β\vＹ）\v/．％κ9k\\fB\x1fｍτ＇kＭ␋",
		out:  "‛␋\x14／‛＼］\vεＵ｀β\vＹ）\v/．％κ9k＼fB\x1fｍτ＇kＭ␋",
	}, { // 2275
		mask: EncodeBackSlash | EncodeLeftCrLfHtVt,
		in:   "^\v／＼］\vεＵ｀β\vＹ）\v/．％κ9k\\fB\x1fｍτ＇kＭα",
		out:  "^\v／‛＼］\vεＵ｀β\vＹ）\v/．％κ9k＼fB\x1fｍτ＇kＭα",
	}, { // 2276
		mask: EncodeBackSlash | EncodeLeftCrLfHtVt,
		in:   "^␋／＼］\vεＵ｀β\vＹ）\v/．％κ9k\\fB\x1fｍτ＇kＭα",
		out:  "^␋／‛＼］\vεＵ｀β\vＹ）\v/．％κ9k＼fB\x1fｍτ＇kＭα",
	}, { // 2277
		mask: EncodeBackSlash | EncodeLeftCrLfHtVt,
		in:   "^\v／＼］\vεＵ｀β\vＹ）\v/．％κ9k\\fB\x1fｍτ＇k␋α",
		out:  "^\v／‛＼］\vεＵ｀β\vＹ）\v/．％κ9k＼fB\x1fｍτ＇k␋α",
	}, { // 2278
		mask: EncodeBackSlash | EncodeLeftCrLfHtVt,
		in:   "^␋／＼］\vεＵ｀β\vＹ）\v/．％κ9k\\fB\x1fｍτ＇k␋α",
		out:  "^␋／‛＼］\vεＵ｀β\vＹ）\v/．％κ9k＼fB\x1fｍτ＇k␋α",
	}, { // 2279
		mask: EncodeBackSlash | EncodeLeftCrLfHtVt,
		in:   "^\v／＼］\vεＵ｀β\vＹ）\v/．％κ9k\\fB\x1fｍτ＇kＭ␋",
		out:  "^\v／‛＼］\vεＵ｀β\vＹ）\v/．％κ9k＼fB\x1fｍτ＇kＭ␋",
	}, { // 2280
		mask: EncodeBackSlash | EncodeLeftCrLfHtVt,
		in:   "^␋／＼］\vεＵ｀β\vＹ）\v/．％κ9k\\fB\x1fｍτ＇kＭ␋",
		out:  "^␋／‛＼］\vεＵ｀β\vＹ）\v/．％κ9k＼fB\x1fｍτ＇kＭ␋",
	}, { // 2281
		mask: EncodeBackSlash | EncodeLeftCrLfHtVt,
		in:   "^\x14／＼］\vεＵ｀β\vＹ）\v/．％κ9k\\fB\x1fｍτ＇k\vα",
		out:  "^\x14／‛＼］\vεＵ｀β\vＹ）\v/．％κ9k＼fB\x1fｍτ＇k\vα",
	}, { // 2282
		mask: EncodeBackSlash | EncodeLeftCrLfHtVt,
		in:   "^\x14／＼］\vεＵ｀β\vＹ）\v/．％κ9k\\fB\x1fｍτ＇k␋α",
		out:  "^\x14／‛＼］\vεＵ｀β\vＹ）\v/．％κ9k＼fB\x1fｍτ＇k␋α",
	}, { // 2283
		mask: EncodeBackSlash | EncodeLeftCrLfHtVt,
		in:   "^\x14／＼］\vεＵ｀β\vＹ）\v/．％κ9k\\fB\x1fｍτ＇k\v␋",
		out:  "^\x14／‛＼］\vεＵ｀β\vＹ）\v/．％κ9k＼fB\x1fｍτ＇k\v␋",
	}, { // 2284
		mask: EncodeBackSlash | EncodeLeftCrLfHtVt,
		in:   "^\x14／＼］\vεＵ｀β\vＹ）\v/．％κ9k\\fB\x1fｍτ＇k␋␋",
		out:  "^\x14／‛＼］\vεＵ｀β\vＹ）\v/．％κ9k＼fB\x1fｍτ＇k␋␋",
	}, { // 2285
		mask: EncodeBackSlash | EncodeLeftCrLfHtVt,
		in:   "^\x14／＼］\vεＵ｀β\vＹ）\v/．％κ9k\\fB\x1fｍτ＇kＭ\v",
		out:  "^\x14／‛＼］\vεＵ｀β\vＹ）\v/．％κ9k＼fB\x1fｍτ＇kＭ\v",
	}, { // 2286
		mask: EncodeBackSlash | EncodeLeftCrLfHtVt,
		in:   "^\x14／＼］\vεＵ｀β\vＹ）\v/．％κ9k\\fB\x1fｍτ＇kＭ␋",
		out:  "^\x14／‛＼］\vεＵ｀β\vＹ）\v/．％κ9k＼fB\x1fｍτ＇kＭ␋",
	}, { // 2287
		mask: EncodeBackSlash | EncodeLeftCrLfHtVt,
		in:   "ι␘）\x18ξ␅ｆ␜＊|\r]ι~bζ\x17\x14\u007fＸhωEＭｏ[ι：␝␞",
		out:  "ι␘）\x18ξ␅ｆ␜＊|\r]ι~bζ\x17\x14\u007fＸhωEＭｏ[ι：␝␞",
	}, { // 2288
		mask: EncodeBackSlash | EncodeLeftCrLfHtVt,
		in:   "\r␍）\x18ξ␅ｆ␜＊|\r]ι~bζ\x17\x14\u007fＸhωEＭｏ[ι：␝␞",
		out:  "␍␍）\x18ξ␅ｆ␜＊|\r]ι~bζ\x17\x14\u007fＸhωEＭｏ[ι：␝␞",
	}, { // 2289
		mask: EncodeBackSlash | EncodeLeftCrLfHtVt,
		in:   "␍␍）\x18ξ␅ｆ␜＊|\r]ι~bζ\x17\x14\u007fＸhωEＭｏ[ι：␝␞",
		out:  "‛␍␍）\x18ξ␅ｆ␜＊|\r]ι~bζ\x17\x14\u007fＸhωEＭｏ[ι：␝␞",
	}, { // 2290
		mask: EncodeBackSlash | EncodeLeftCrLfHtVt,
		in:   "\r␘）\x18ξ␅ｆ␜＊|\r]ι~bζ\x17\x14\u007fＸhωEＭｏ[ι：␍␞",
		out:  "␍␘）\x18ξ␅ｆ␜＊|\r]ι~bζ\x17\x14\u007fＸhωEＭｏ[ι：␍␞",
	}, { // 2291
		mask: EncodeBackSlash | EncodeLeftCrLfHtVt,
		in:   "␍␘）\x18ξ␅ｆ␜＊|\r]ι~bζ\x17\x14\u007fＸhωEＭｏ[ι：␍␞",
		out:  "‛␍␘）\x18ξ␅ｆ␜＊|\r]ι~bζ\x17\x14\u007fＸhωEＭｏ[ι：␍␞",
	}, { // 2292
		mask: EncodeBackSlash | EncodeLeftCrLfHtVt,
		in:   "\r␘）\x18ξ␅ｆ␜＊|\r]ι~bζ\x17\x14\u007fＸhωEＭｏ[ι：␝␍",
		out:  "␍␘）\x18ξ␅ｆ␜＊|\r]ι~bζ\x17\x14\u007fＸhωEＭｏ[ι：␝␍",
	}, { // 2293
		mask: EncodeBackSlash | EncodeLeftCrLfHtVt,
		in:   "␍␘）\x18ξ␅ｆ␜＊|\r]ι~bζ\x17\x14\u007fＸhωEＭｏ[ι：␝␍",
		out:  "‛␍␘）\x18ξ␅ｆ␜＊|\r]ι~bζ\x17\x14\u007fＸhωEＭｏ[ι：␝␍",
	}, { // 2294
		mask: EncodeBackSlash | EncodeLeftCrLfHtVt,
		in:   "ι\r）\x18ξ␅ｆ␜＊|\r]ι~bζ\x17\x14\u007fＸhωEＭｏ[ι：␝␞",
		out:  "ι\r）\x18ξ␅ｆ␜＊|\r]ι~bζ\x17\x14\u007fＸhωEＭｏ[ι：␝␞",
	}, { // 2295
		mask: EncodeBackSlash | EncodeLeftCrLfHtVt,
		in:   "ι␍）\x18ξ␅ｆ␜＊|\r]ι~bζ\x17\x14\u007fＸhωEＭｏ[ι：␝␞",
		out:  "ι␍）\x18ξ␅ｆ␜＊|\r]ι~bζ\x17\x14\u007fＸhωEＭｏ[ι：␝␞",
	}, { // 2296
		mask: EncodeBackSlash | EncodeLeftCrLfHtVt,
		in:   "ι\r）\x18ξ␅ｆ␜＊|\r]ι~bζ\x17\x14\u007fＸhωEＭｏ[ι：␍␞",
		out:  "ι\r）\x18ξ␅ｆ␜＊|\r]ι~bζ\x17\x14\u007fＸhωEＭｏ[ι：␍␞",
	}, { // 2297
		mask: EncodeBackSlash | EncodeLeftCrLfHtVt,
		in:   "ι␍）\x18ξ␅ｆ␜＊|\r]ι~bζ\x17\x14\u007fＸhωEＭｏ[ι：␍␞",
		out:  "ι␍）\x18ξ␅ｆ␜＊|\r]ι~bζ\x17\x14\u007fＸhωEＭｏ[ι：␍␞",
	}, { // 2298
		mask: EncodeBackSlash | EncodeLeftCrLfHtVt,
		in:   "ι\r）\x18ξ␅ｆ␜＊|\r]ι~bζ\x17\x14\u007fＸhωEＭｏ[ι：␝␍",
		out:  "ι\r）\x18ξ␅ｆ␜＊|\r]ι~bζ\x17\x14\u007fＸhωEＭｏ[ι：␝␍",
	}, { // 2299
		mask: EncodeBackSlash | EncodeLeftCrLfHtVt,
		in:   "ι␍）\x18ξ␅ｆ␜＊|\r]ι~bζ\x17\x14\u007fＸhωEＭｏ[ι：␝␍",
		out:  "ι␍）\x18ξ␅ｆ␜＊|\r]ι~bζ\x17\x14\u007fＸhωEＭｏ[ι：␝␍",
	}, { // 2300
		mask: EncodeBackSlash | EncodeLeftCrLfHtVt,
		in:   "ι␘）\x18ξ␅ｆ␜＊|\r]ι~bζ\x17\x14\u007fＸhωEＭｏ[ι：\r␞",
		out:  "ι␘）\x18ξ␅ｆ␜＊|\r]ι~bζ\x17\x14\u007fＸhωEＭｏ[ι：\r␞",
	}, { // 2301
		mask: EncodeBackSlash | EncodeLeftCrLfHtVt,
		in:   "ι␘）\x18ξ␅ｆ␜＊|\r]ι~bζ\x17\x14\u007fＸhωEＭｏ[ι：␍␞",
		out:  "ι␘）\x18ξ␅ｆ␜＊|\r]ι~bζ\x17\x14\u007fＸhωEＭｏ[ι：␍␞",
	}, { // 2302
		mask: EncodeBackSlash | EncodeLeftCrLfHtVt,
		in:   "ι␘）\x18ξ␅ｆ␜＊|\r]ι~bζ\x17\x14\u007fＸhωEＭｏ[ι：\r␍",
		out:  "ι␘）\x18ξ␅ｆ␜＊|\r]ι~bζ\x17\x14\u007fＸhωEＭｏ[ι：\r␍",
	}, { // 2303
		mask: EncodeBackSlash | EncodeLeftCrLfHtVt,
		in:   "ι␘）\x18ξ␅ｆ␜＊|\r]ι~bζ\x17\x14\u007fＸhωEＭｏ[ι：␍␍",
		out:  "ι␘）\x18ξ␅ｆ␜＊|\r]ι~bζ\x17\x14\u007fＸhωEＭｏ[ι：␍␍",
	}, { // 2304
		mask: EncodeBackSlash | EncodeLeftCrLfHtVt,
		in:   "ι␘）\x18ξ␅ｆ␜＊|\r]ι~bζ\x17\x14\u007fＸhωEＭｏ[ι：␝\r",
		out:  "ι␘）\x18ξ␅ｆ␜＊|\r]ι~bζ\x17\x14\u007fＸhωEＭｏ[ι：␝\r",
	}, { // 2305
		mask: EncodeBackSlash | EncodeLeftCrLfHtVt,
		in:   "ι␘）\x18ξ␅ｆ␜＊|\r]ι~bζ\x17\x14\u007fＸhωEＭｏ[ι：␝␍",
		out:  "ι␘）\x18ξ␅ｆ␜＊|\r]ι~bζ\x17\x14\u007fＸhωEＭｏ[ι：␝␍",
	}, { // 2306
		mask: EncodeDel | EncodeLeftCrLfHtVt,
		in:   "ζ＋␇A%σb\n;＇\tχ\\＆*\x1dψ＞ρ/＝;␂ο\x0fＴ␄␂kＧ",
		out:  "ζ＋␇A%σb\n;＇\tχ\\＆*\x1dψ＞ρ/＝;␂ο\x0fＴ␄␂kＧ",
	}, { // 2307
		mask: EncodeDel | EncodeLeftCrLfHtVt,
		in:   "\t␉␇A%σb\n;＇\tχ\\＆*\x1dψ＞ρ/＝;␂ο\x0fＴ␄␂kＧ",
		out:  "␉␉␇A%σb\n;＇\tχ\\＆*\x1dψ＞ρ/＝;␂ο\x0fＴ␄␂kＧ",
	}, { // 2308
		mask: EncodeDel | EncodeLeftCrLfHtVt,
		in:   "␉␉␇A%σb\n;＇\tχ\\＆*\x1dψ＞ρ/＝;␂ο\x0fＴ␄␂kＧ",
		out:  "‛␉␉␇A%σb\n;＇\tχ\\＆*\x1dψ＞ρ/＝;␂ο\x0fＴ␄␂kＧ",
	}, { // 2309
		mask: EncodeDel | EncodeLeftCrLfHtVt,
		in:   "\t＋␇A%σb\n;＇\tχ\\＆*\x1dψ＞ρ/＝;␂ο\x0fＴ␄␂␉Ｇ",
		out:  "␉＋␇A%σb\n;＇\tχ\\＆*\x1dψ＞ρ/＝;␂ο\x0fＴ␄␂␉Ｇ",
	}, { // 2310
		mask: EncodeDel | EncodeLeftCrLfHtVt,
		in:   "␉＋␇A%σb\n;＇\tχ\\＆*\x1dψ＞ρ/＝;␂ο\x0fＴ␄␂␉Ｇ",
		out:  "‛␉＋␇A%σb\n;＇\tχ\\＆*\x1dψ＞ρ/＝;␂ο\x0fＴ␄␂␉Ｇ",
	}, { // 2311
		mask: EncodeDel | EncodeLeftCrLfHtVt,
		in:   "\t＋␇A%σb\n;＇\tχ\\＆*\x1dψ＞ρ/＝;␂ο\x0fＴ␄␂k␉",
		out:  "␉＋␇A%σb\n;＇\tχ\\＆*\x1dψ＞ρ/＝;␂ο\x0fＴ␄␂k␉",
	}, { // 2312
		mask: EncodeDel | EncodeLeftCrLfHtVt,
		in:   "␉＋␇A%σb\n;＇\tχ\\＆*\x1dψ＞ρ/＝;␂ο\x0fＴ␄␂k␉",
		out:  "‛␉＋␇A%σb\n;＇\tχ\\＆*\x1dψ＞ρ/＝;␂ο\x0fＴ␄␂k␉",
	}, { // 2313
		mask: EncodeDel | EncodeLeftCrLfHtVt,
		in:   "ζ\t␇A%σb\n;＇\tχ\\＆*\x1dψ＞ρ/＝;␂ο\x0fＴ␄␂kＧ",
		out:  "ζ\t␇A%σb\n;＇\tχ\\＆*\x1dψ＞ρ/＝;␂ο\x0fＴ␄␂kＧ",
	}, { // 2314
		mask: EncodeDel | EncodeLeftCrLfHtVt,
		in:   "ζ␉␇A%σb\n;＇\tχ\\＆*\x1dψ＞ρ/＝;␂ο\x0fＴ␄␂kＧ",
		out:  "ζ␉␇A%σb\n;＇\tχ\\＆*\x1dψ＞ρ/＝;␂ο\x0fＴ␄␂kＧ",
	}, { // 2315
		mask: EncodeDel | EncodeLeftCrLfHtVt,
		in:   "ζ\t␇A%σb\n;＇\tχ\\＆*\x1dψ＞ρ/＝;␂ο\x0fＴ␄␂␉Ｇ",
		out:  "ζ\t␇A%σb\n;＇\tχ\\＆*\x1dψ＞ρ/＝;␂ο\x0fＴ␄␂␉Ｇ",
	}, { // 2316
		mask: EncodeDel | EncodeLeftCrLfHtVt,
		in:   "ζ␉␇A%σb\n;＇\tχ\\＆*\x1dψ＞ρ/＝;␂ο\x0fＴ␄␂␉Ｇ",
		out:  "ζ␉␇A%σb\n;＇\tχ\\＆*\x1dψ＞ρ/＝;␂ο\x0fＴ␄␂␉Ｇ",
	}, { // 2317
		mask: EncodeDel | EncodeLeftCrLfHtVt,
		in:   "ζ\t␇A%σb\n;＇\tχ\\＆*\x1dψ＞ρ/＝;␂ο\x0fＴ␄␂k␉",
		out:  "ζ\t␇A%σb\n;＇\tχ\\＆*\x1dψ＞ρ/＝;␂ο\x0fＴ␄␂k␉",
	}, { // 2318
		mask: EncodeDel | EncodeLeftCrLfHtVt,
		in:   "ζ␉␇A%σb\n;＇\tχ\\＆*\x1dψ＞ρ/＝;␂ο\x0fＴ␄␂k␉",
		out:  "ζ␉␇A%σb\n;＇\tχ\\＆*\x1dψ＞ρ/＝;␂ο\x0fＴ␄␂k␉",
	}, { // 2319
		mask: EncodeDel | EncodeLeftCrLfHtVt,
		in:   "ζ＋␇A%σb\n;＇\tχ\\＆*\x1dψ＞ρ/＝;␂ο\x0fＴ␄␂\tＧ",
		out:  "ζ＋␇A%σb\n;＇\tχ\\＆*\x1dψ＞ρ/＝;␂ο\x0fＴ␄␂\tＧ",
	}, { // 2320
		mask: EncodeDel | EncodeLeftCrLfHtVt,
		in:   "ζ＋␇A%σb\n;＇\tχ\\＆*\x1dψ＞ρ/＝;␂ο\x0fＴ␄␂␉Ｇ",
		out:  "ζ＋␇A%σb\n;＇\tχ\\＆*\x1dψ＞ρ/＝;␂ο\x0fＴ␄␂␉Ｇ",
	}, { // 2321
		mask: EncodeDel | EncodeLeftCrLfHtVt,
		in:   "ζ＋␇A%σb\n;＇\tχ\\＆*\x1dψ＞ρ/＝;␂ο\x0fＴ␄␂\t␉",
		out:  "ζ＋␇A%σb\n;＇\tχ\\＆*\x1dψ＞ρ/＝;␂ο\x0fＴ␄␂\t␉",
	}, { // 2322
		mask: EncodeDel | EncodeLeftCrLfHtVt,
		in:   "ζ＋␇A%σb\n;＇\tχ\\＆*\x1dψ＞ρ/＝;␂ο\x0fＴ␄␂␉␉",
		out:  "ζ＋␇A%σb\n;＇\tχ\\＆*\x1dψ＞ρ/＝;␂ο\x0fＴ␄␂␉␉",
	}, { // 2323
		mask: EncodeDel | EncodeLeftCrLfHtVt,
		in:   "ζ＋␇A%σb\n;＇\tχ\\＆*\x1dψ＞ρ/＝;␂ο\x0fＴ␄␂k\t",
		out:  "ζ＋␇A%σb\n;＇\tχ\\＆*\x1dψ＞ρ/＝;␂ο\x0fＴ␄␂k\t",
	}, { // 2324
		mask: EncodeDel | EncodeLeftCrLfHtVt,
		in:   "ζ＋␇A%σb\n;＇\tχ\\＆*\x1dψ＞ρ/＝;␂ο\x0fＴ␄␂k␉",
		out:  "ζ＋␇A%σb\n;＇\tχ\\＆*\x1dψ＞ρ/＝;␂ο\x0fＴ␄␂k␉",
	}, { // 2325
		mask: EncodeDel | EncodeLeftCrLfHtVt,
		in:   "／\bｆＮ␛τ␑␗μＰ\nν＆\t\x15\a：\\ＯbμH[mνεＱ?␐W",
		out:  "／\bｆＮ␛τ␑␗μＰ\nν＆\t\x15\a：\\ＯbμH[mνεＱ?␐W",
	}, { // 2326
		mask: EncodeDel | EncodeLeftCrLfHtVt,
		in:   "\n␊ｆＮ␛τ␑␗μＰ\nν＆\t\x15\a：\\ＯbμH[mνεＱ?␐W",
		out:  "␊␊ｆＮ␛τ␑␗μＰ\nν＆\t\x15\a：\\ＯbμH[mνεＱ?␐W",
	}, { // 2327
		mask: EncodeDel | EncodeLeftCrLfHtVt,
		in:   "␊␊ｆＮ␛τ␑␗μＰ\nν＆\t\x15\a：\\ＯbμH[mνεＱ?␐W",
		out:  "‛␊␊ｆＮ␛τ␑␗μＰ\nν＆\t\x15\a：\\ＯbμH[mνεＱ?␐W",
	}, { // 2328
		mask: EncodeDel | EncodeLeftCrLfHtVt,
		in:   "\n\bｆＮ␛τ␑␗μＰ\nν＆\t\x15\a：\\ＯbμH[mνεＱ?␊W",
		out:  "␊\bｆＮ␛τ␑␗μＰ\nν＆\t\x15\a：\\ＯbμH[mνεＱ?␊W",
	}, { // 2329
		mask: EncodeDel | EncodeLeftCrLfHtVt,
		in:   "␊\bｆＮ␛τ␑␗μＰ\nν＆\t\x15\a：\\ＯbμH[mνεＱ?␊W",
		out:  "‛␊\bｆＮ␛τ␑␗μＰ\nν＆\t\x15\a：\\ＯbμH[mνεＱ?␊W",
	}, { // 2330
		mask: EncodeDel | EncodeLeftCrLfHtVt,
		in:   "\n\bｆＮ␛τ␑␗μＰ\nν＆\t\x15\a：\\ＯbμH[mνεＱ?␐␊",
		out:  "␊\bｆＮ␛τ␑␗μＰ\nν＆\t\x15\a：\\ＯbμH[mνεＱ?␐␊",
	}, { // 2331
		mask: EncodeDel | EncodeLeftCrLfHtVt,
		in:   "␊\bｆＮ␛τ␑␗μＰ\nν＆\t\x15\a：\\ＯbμH[mνεＱ?␐␊",
		out:  "‛␊\bｆＮ␛τ␑␗μＰ\nν＆\t\x15\a：\\ＯbμH[mνεＱ?␐␊",
	}, { // 2332
		mask: EncodeDel | EncodeLeftCrLfHtVt,
		in:   "／\nｆＮ␛τ␑␗μＰ\nν＆\t\x15\a：\\ＯbμH[mνεＱ?␐W",
		out:  "／\nｆＮ␛τ␑␗μＰ\nν＆\t\x15\a：\\ＯbμH[mνεＱ?␐W",
	}, { // 2333
		mask: EncodeDel | EncodeLeftCrLfHtVt,
		in:   "／␊ｆＮ␛τ␑␗μＰ\nν＆\t\x15\a：\\ＯbμH[mνεＱ?␐W",
		out:  "／␊ｆＮ␛τ␑␗μＰ\nν＆\t\x15\a：\\ＯbμH[mνεＱ?␐W",
	}, { // 2334
		mask: EncodeDel | EncodeLeftCrLfHtVt,
		in:   "／\nｆＮ␛τ␑␗μＰ\nν＆\t\x15\a：\\ＯbμH[mνεＱ?␊W",
		out:  "／\nｆＮ␛τ␑␗μＰ\nν＆\t\x15\a：\\ＯbμH[mνεＱ?␊W",
	}, { // 2335
		mask: EncodeDel | EncodeLeftCrLfHtVt,
		in:   "／␊ｆＮ␛τ␑␗μＰ\nν＆\t\x15\a：\\ＯbμH[mνεＱ?␊W",
		out:  "／␊ｆＮ␛τ␑␗μＰ\nν＆\t\x15\a：\\ＯbμH[mνεＱ?␊W",
	}, { // 2336
		mask: EncodeDel | EncodeLeftCrLfHtVt,
		in:   "／\nｆＮ␛τ␑␗μＰ\nν＆\t\x15\a：\\ＯbμH[mνεＱ?␐␊",
		out:  "／\nｆＮ␛τ␑␗μＰ\nν＆\t\x15\a：\\ＯbμH[mνεＱ?␐␊",
	}, { // 2337
		mask: EncodeDel | EncodeLeftCrLfHtVt,
		in:   "／␊ｆＮ␛τ␑␗μＰ\nν＆\t\x15\a：\\ＯbμH[mνεＱ?␐␊",
		out:  "／␊ｆＮ␛τ␑␗μＰ\nν＆\t\x15\a：\\ＯbμH[mνεＱ?␐␊",
	}, { // 2338
		mask: EncodeDel | EncodeLeftCrLfHtVt,
		in:   "／\bｆＮ␛τ␑␗μＰ\nν＆\t\x15\a：\\ＯbμH[mνεＱ?\nW",
		out:  "／\bｆＮ␛τ␑␗μＰ\nν＆\t\x15\a：\\ＯbμH[mνεＱ?\nW",
	}, { // 2339
		mask: EncodeDel | EncodeLeftCrLfHtVt,
		in:   "／\bｆＮ␛τ␑␗μＰ\nν＆\t\x15\a：\\ＯbμH[mνεＱ?␊W",
		out:  "／\bｆＮ␛τ␑␗μＰ\nν＆\t\x15\a：\\ＯbμH[mνεＱ?␊W",
	}, { // 2340
		mask: EncodeDel | EncodeLeftCrLfHtVt,
		in:   "／\bｆＮ␛τ␑␗μＰ\nν＆\t\x15\a：\\ＯbμH[mνεＱ?\n␊",
		out:  "／\bｆＮ␛τ␑␗μＰ\nν＆\t\x15\a：\\ＯbμH[mνεＱ?\n␊",
	}, { // 2341
		mask: EncodeDel | EncodeLeftCrLfHtVt,
		in:   "／\bｆＮ␛τ␑␗μＰ\nν＆\t\x15\a：\\ＯbμH[mνεＱ?␊␊",
		out:  "／\bｆＮ␛τ␑␗μＰ\nν＆\t\x15\a：\\ＯbμH[mνεＱ?␊␊",
	}, { // 2342
		mask: EncodeDel | EncodeLeftCrLfHtVt,
		in:   "／\bｆＮ␛τ␑␗μＰ\nν＆\t\x15\a：\\ＯbμH[mνεＱ?␐\n",
		out:  "／\bｆＮ␛τ␑␗μＰ\nν＆\t\x15\a：\\ＯbμH[mνεＱ?␐\n",
	}, { // 2343
		mask: EncodeDel | EncodeLeftCrLfHtVt,
		in:   "／\bｆＮ␛τ␑␗μＰ\nν＆\t\x15\a：\\ＯbμH[mνεＱ?␐␊",
		out:  "／\bｆＮ␛τ␑␗μＰ\nν＆\t\x15\a：\\ＯbμH[mνεＱ?␐␊",
	}, { // 2344
		mask: EncodeDel | EncodeLeftCrLfHtVt,
		in:   "Ｙ\x1aμ6｜>\"FυＥ\v<ς_u ；␌Ｓ]＇＜␙f｜δｄε\x1eψ",
		out:  "Ｙ\x1aμ6｜>\"FυＥ\v<ς_u ；␌Ｓ]＇＜␙f｜δｄε\x1eψ",
	}, { // 2345
		mask: EncodeDel | EncodeLeftCrLfHtVt,
		in:   "\v␋μ6｜>\"FυＥ\v<ς_u ；␌Ｓ]＇＜␙f｜δｄε\x1eψ",
		out:  "␋␋μ6｜>\"FυＥ\v<ς_u ；␌Ｓ]＇＜␙f｜δｄε\x1eψ",
	}, { // 2346
		mask: EncodeDel | EncodeLeftCrLfHtVt,
		in:   "␋␋μ6｜>\"FυＥ\v<ς_u ；␌Ｓ]＇＜␙f｜δｄε\x1eψ",
		out:  "‛␋␋μ6｜>\"FυＥ\v<ς_u ；␌Ｓ]＇＜␙f｜δｄε\x1eψ",
	}, { // 2347
		mask: EncodeDel | EncodeLeftCrLfHtVt,
		in:   "\v\x1aμ6｜>\"FυＥ\v<ς_u ；␌Ｓ]＇＜␙f｜δｄε␋ψ",
		out:  "␋\x1aμ6｜>\"FυＥ\v<ς_u ；␌Ｓ]＇＜␙f｜δｄε␋ψ",
	}, { // 2348
		mask: EncodeDel | EncodeLeftCrLfHtVt,
		in:   "␋\x1aμ6｜>\"FυＥ\v<ς_u ；␌Ｓ]＇＜␙f｜δｄε␋ψ",
		out:  "‛␋\x1aμ6｜>\"FυＥ\v<ς_u ；␌Ｓ]＇＜␙f｜δｄε␋ψ",
	}, { // 2349
		mask: EncodeDel | EncodeLeftCrLfHtVt,
		in:   "\v\x1aμ6｜>\"FυＥ\v<ς_u ；␌Ｓ]＇＜␙f｜δｄε\x1e␋",
		out:  "␋\x1aμ6｜>\"FυＥ\v<ς_u ；␌Ｓ]＇＜␙f｜δｄε\x1e␋",
	}, { // 2350
		mask: EncodeDel | EncodeLeftCrLfHtVt,
		in:   "␋\x1aμ6｜>\"FυＥ\v<ς_u ；␌Ｓ]＇＜␙f｜δｄε\x1e␋",
		out:  "‛␋\x1aμ6｜>\"FυＥ\v<ς_u ；␌Ｓ]＇＜␙f｜δｄε\x1e␋",
	}, { // 2351
		mask: EncodeDel | EncodeLeftCrLfHtVt,
		in:   "Ｙ\vμ6｜>\"FυＥ\v<ς_u ；␌Ｓ]＇＜␙f｜δｄε\x1eψ",
		out:  "Ｙ\vμ6｜>\"FυＥ\v<ς_u ；␌Ｓ]＇＜␙f｜δｄε\x1eψ",
	}, { // 2352
		mask: EncodeDel | EncodeLeftCrLfHtVt,
		in:   "Ｙ␋μ6｜>\"FυＥ\v<ς_u ；␌Ｓ]＇＜␙f｜δｄε\x1eψ",
		out:  "Ｙ␋μ6｜>\"FυＥ\v<ς_u ；␌Ｓ]＇＜␙f｜δｄε\x1eψ",
	}, { // 2353
		mask: EncodeDel | EncodeLeftCrLfHtVt,
		in:   "Ｙ\vμ6｜>\"FυＥ\v<ς_u ；␌Ｓ]＇＜␙f｜δｄε␋ψ",
		out:  "Ｙ\vμ6｜>\"FυＥ\v<ς_u ；␌Ｓ]＇＜␙f｜δｄε␋ψ",
	}, { // 2354
		mask: EncodeDel | EncodeLeftCrLfHtVt,
		in:   "Ｙ␋μ6｜>\"FυＥ\v<ς_u ；␌Ｓ]＇＜␙f｜δｄε␋ψ",
		out:  "Ｙ␋μ6｜>\"FυＥ\v<ς_u ；␌Ｓ]＇＜␙f｜δｄε␋ψ",
	}, { // 2355
		mask: EncodeDel | EncodeLeftCrLfHtVt,
		in:   "Ｙ\vμ6｜>\"FυＥ\v<ς_u ；␌Ｓ]＇＜␙f｜δｄε\x1e␋",
		out:  "Ｙ\vμ6｜>\"FυＥ\v<ς_u ；␌Ｓ]＇＜␙f｜δｄε\x1e␋",
	}, { // 2356
		mask: EncodeDel | EncodeLeftCrLfHtVt,
		in:   "Ｙ␋μ6｜>\"FυＥ\v<ς_u ；␌Ｓ]＇＜␙f｜δｄε\x1e␋",
		out:  "Ｙ␋μ6｜>\"FυＥ\v<ς_u ；␌Ｓ]＇＜␙f｜δｄε\x1e␋",
	}, { // 2357
		mask: EncodeDel | EncodeLeftCrLfHtVt,
		in:   "Ｙ\x1aμ6｜>\"FυＥ\v<ς_u ；␌Ｓ]＇＜␙f｜δｄε\vψ",
		out:  "Ｙ\x1aμ6｜>\"FυＥ\v<ς_u ；␌Ｓ]＇＜␙f｜δｄε\vψ",
	}, { // 2358
		mask: EncodeDel | EncodeLeftCrLfHtVt,
		in:   "Ｙ\x1aμ6｜>\"FυＥ\v<ς_u ；␌Ｓ]＇＜␙f｜δｄε␋ψ",
		out:  "Ｙ\x1aμ6｜>\"FυＥ\v<ς_u ；␌Ｓ]＇＜␙f｜δｄε␋ψ",
	}, { // 2359
		mask: EncodeDel | EncodeLeftCrLfHtVt,
		in:   "Ｙ\x1aμ6｜>\"FυＥ\v<ς_u ；␌Ｓ]＇＜␙f｜δｄε\v␋",
		out:  "Ｙ\x1aμ6｜>\"FυＥ\v<ς_u ；␌Ｓ]＇＜␙f｜δｄε\v␋",
	}, { // 2360
		mask: EncodeDel | EncodeLeftCrLfHtVt,
		in:   "Ｙ\x1aμ6｜>\"FυＥ\v<ς_u ；␌Ｓ]＇＜␙f｜δｄε␋␋",
		out:  "Ｙ\x1aμ6｜>\"FυＥ\v<ς_u ；␌Ｓ]＇＜␙f｜δｄε␋␋",
	}, { // 2361
		mask: EncodeDel | EncodeLeftCrLfHtVt,
		in:   "Ｙ\x1aμ6｜>\"FυＥ\v<ς_u ；␌Ｓ]＇＜␙f｜δｄε\x1e\v",
		out:  "Ｙ\x1aμ6｜>\"FυＥ\v<ς_u ；␌Ｓ]＇＜␙f｜δｄε\x1e\v",
	}, { // 2362
		mask: EncodeDel | EncodeLeftCrLfHtVt,
		in:   "Ｙ\x1aμ6｜>\"FυＥ\v<ς_u ；␌Ｓ]＇＜␙f｜δｄε\x1e␋",
		out:  "Ｙ\x1aμ6｜>\"FυＥ\v<ς_u ；␌Ｓ]＇＜␙f｜δｄε\x1e␋",
	}, { // 2363
		mask: EncodeDel | EncodeLeftCrLfHtVt,
		in:   "ｘκ`␞␓\x03Ｗｓ＄c\r]｜␘8Ｃφ％κβ\x15＋\x11fGφ␆#λ\"",
		out:  "ｘκ`␞␓\x03Ｗｓ＄c\r]｜␘8Ｃφ％κβ\x15＋\x11fGφ␆#λ\"",
	}, { // 2364
		mask: EncodeDel | EncodeLeftCrLfHtVt,
		in:   "\r␍`␞␓\x03Ｗｓ＄c\r]｜␘8Ｃφ％κβ\x15＋\x11fGφ␆#λ\"",
		out:  "␍␍`␞␓\x03Ｗｓ＄c\r]｜␘8Ｃφ％κβ\x15＋\x11fGφ␆#λ\"",
	}, { // 2365
		mask: EncodeDel | EncodeLeftCrLfHtVt,
		in:   "␍␍`␞␓\x03Ｗｓ＄c\r]｜␘8Ｃφ％κβ\x15＋\x11fGφ␆#λ\"",
		out:  "‛␍␍`␞␓\x03Ｗｓ＄c\r]｜␘8Ｃφ％κβ\x15＋\x11fGφ␆#λ\"",
	}, { // 2366
		mask: EncodeDel | EncodeLeftCrLfHtVt,
		in:   "\rκ`␞␓\x03Ｗｓ＄c\r]｜␘8Ｃφ％κβ\x15＋\x11fGφ␆#␍\"",
		out:  "␍κ`␞␓\x03Ｗｓ＄c\r]｜␘8Ｃφ％κβ\x15＋\x11fGφ␆#␍\"",
	}, { // 2367
		mask: EncodeDel | EncodeLeftCrLfHtVt,
		in:   "␍κ`␞␓\x03Ｗｓ＄c\r]｜␘8Ｃφ％κβ\x15＋\x11fGφ␆#␍\"",
		out:  "‛␍κ`␞␓\x03Ｗｓ＄c\r]｜␘8Ｃφ％κβ\x15＋\x11fGφ␆#␍\"",
	}, { // 2368
		mask: EncodeDel | EncodeLeftCrLfHtVt,
		in:   "\rκ`␞␓\x03Ｗｓ＄c\r]｜␘8Ｃφ％κβ\x15＋\x11fGφ␆#λ␍",
		out:  "␍κ`␞␓\x03Ｗｓ＄c\r]｜␘8Ｃφ％κβ\x15＋\x11fGφ␆#λ␍",
	}, { // 2369
		mask: EncodeDel | EncodeLeftCrLfHtVt,
		in:   "␍κ`␞␓\x03Ｗｓ＄c\r]｜␘8Ｃφ％κβ\x15＋\x11fGφ␆#λ␍",
		out:  "‛␍κ`␞␓\x03Ｗｓ＄c\r]｜␘8Ｃφ％κβ\x15＋\x11fGφ␆#λ␍",
	}, { // 2370
		mask: EncodeDel | EncodeLeftCrLfHtVt,
		in:   "ｘ\r`␞␓\x03Ｗｓ＄c\r]｜␘8Ｃφ％κβ\x15＋\x11fGφ␆#λ\"",
		out:  "ｘ\r`␞␓\x03Ｗｓ＄c\r]｜␘8Ｃφ％κβ\x15＋\x11fGφ␆#λ\"",
	}, { // 2371
		mask: EncodeDel | EncodeLeftCrLfHtVt,
		in:   "ｘ␍`␞␓\x03Ｗｓ＄c\r]｜␘8Ｃφ％κβ\x15＋\x11fGφ␆#λ\"",
		out:  "ｘ␍`␞␓\x03Ｗｓ＄c\r]｜␘8Ｃφ％κβ\x15＋\x11fGφ␆#λ\"",
	}, { // 2372
		mask: EncodeDel | EncodeLeftCrLfHtVt,
		in:   "ｘ\r`␞␓\x03Ｗｓ＄c\r]｜␘8Ｃφ％κβ\x15＋\x11fGφ␆#␍\"",
		out:  "ｘ\r`␞␓\x03Ｗｓ＄c\r]｜␘8Ｃφ％κβ\x15＋\x11fGφ␆#␍\"",
	}, { // 2373
		mask: EncodeDel | EncodeLeftCrLfHtVt,
		in:   "ｘ␍`␞␓\x03Ｗｓ＄c\r]｜␘8Ｃφ％κβ\x15＋\x11fGφ␆#␍\"",
		out:  "ｘ␍`␞␓\x03Ｗｓ＄c\r]｜␘8Ｃφ％κβ\x15＋\x11fGφ␆#␍\"",
	}, { // 2374
		mask: EncodeDel | EncodeLeftCrLfHtVt,
		in:   "ｘ\r`␞␓\x03Ｗｓ＄c\r]｜␘8Ｃφ％κβ\x15＋\x11fGφ␆#λ␍",
		out:  "ｘ\r`␞␓\x03Ｗｓ＄c\r]｜␘8Ｃφ％κβ\x15＋\x11fGφ␆#λ␍",
	}, { // 2375
		mask: EncodeDel | EncodeLeftCrLfHtVt,
		in:   "ｘ␍`␞␓\x03Ｗｓ＄c\r]｜␘8Ｃφ％κβ\x15＋\x11fGφ␆#λ␍",
		out:  "ｘ␍`␞␓\x03Ｗｓ＄c\r]｜␘8Ｃφ％κβ\x15＋\x11fGφ␆#λ␍",
	}, { // 2376
		mask: EncodeDel | EncodeLeftCrLfHtVt,
		in:   "ｘκ`␞␓\x03Ｗｓ＄c\r]｜␘8Ｃφ％κβ\x15＋\x11fGφ␆#\r\"",
		out:  "ｘκ`␞␓\x03Ｗｓ＄c\r]｜␘8Ｃφ％κβ\x15＋\x11fGφ␆#\r\"",
	}, { // 2377
		mask: EncodeDel | EncodeLeftCrLfHtVt,
		in:   "ｘκ`␞␓\x03Ｗｓ＄c\r]｜␘8Ｃφ％κβ\x15＋\x11fGφ␆#␍\"",
		out:  "ｘκ`␞␓\x03Ｗｓ＄c\r]｜␘8Ｃφ％κβ\x15＋\x11fGφ␆#␍\"",
	}, { // 2378
		mask: EncodeDel | EncodeLeftCrLfHtVt,
		in:   "ｘκ`␞␓\x03Ｗｓ＄c\r]｜␘8Ｃφ％κβ\x15＋\x11fGφ␆#\r␍",
		out:  "ｘκ`␞␓\x03Ｗｓ＄c\r]｜␘8Ｃφ％κβ\x15＋\x11fGφ␆#\r␍",
	}, { // 2379
		mask: EncodeDel | EncodeLeftCrLfHtVt,
		in:   "ｘκ`␞␓\x03Ｗｓ＄c\r]｜␘8Ｃφ％κβ\x15＋\x11fGφ␆#␍␍",
		out:  "ｘκ`␞␓\x03Ｗｓ＄c\r]｜␘8Ｃφ％κβ\x15＋\x11fGφ␆#␍␍",
	}, { // 2380
		mask: EncodeDel | EncodeLeftCrLfHtVt,
		in:   "ｘκ`␞␓\x03Ｗｓ＄c\r]｜␘8Ｃφ％κβ\x15＋\x11fGφ␆#λ\r",
		out:  "ｘκ`␞␓\x03Ｗｓ＄c\r]｜␘8Ｃφ％κβ\x15＋\x11fGφ␆#λ\r",
	}, { // 2381
		mask: EncodeDel | EncodeLeftCrLfHtVt,
		in:   "ｘκ`␞␓\x03Ｗｓ＄c\r]｜␘8Ｃφ％κβ\x15＋\x11fGφ␆#λ␍",
		out:  "ｘκ`␞␓\x03Ｗｓ＄c\r]｜␘8Ｃφ％κβ\x15＋\x11fGφ␆#λ␍",
	}, { // 2382
		mask: EncodeRightSpace,
		in:   " ",
		out:  "␠",
	}, { // 2383
		mask: EncodeZero | EncodeRightSpace,
		in:   "，＇␏\x0fη'␟ζＶς \x05＼/＜V\x06␝/OλzＯｌ\"Ｏ\x0fν7ο",
		out:  "，＇␏\x0fη'␟ζＶς \x05＼/＜V\x06␝/OλzＯｌ\"Ｏ\x0fν7ο",
	}, { // 2384
		mask: EncodeZero | EncodeRightSpace,
		in:   " ␠␏\x0fη'␟ζＶς \x05＼/＜V\x06␝/OλzＯｌ\"Ｏ\x0fν7ο",
		out:  " ␠␏\x0fη'␟ζＶς \x05＼/＜V\x06␝/OλzＯｌ\"Ｏ\x0fν7ο",
	}, { // 2385
		mask: EncodeZero | EncodeRightSpace,
		in:   "␠␠␏\x0fη'␟ζＶς \x05＼/＜V\x06␝/OλzＯｌ\"Ｏ\x0fν7ο",
		out:  "␠␠␏\x0fη'␟ζＶς \x05＼/＜V\x06␝/OλzＯｌ\"Ｏ\x0fν7ο",
	}, { // 2386
		mask: EncodeZero | EncodeRightSpace,
		in:   " ＇␏\x0fη'␟ζＶς \x05＼/＜V\x06␝/OλzＯｌ\"Ｏ\x0fν␠ο",
		out:  " ＇␏\x0fη'␟ζＶς \x05＼/＜V\x06␝/OλzＯｌ\"Ｏ\x0fν␠ο",
	}, { // 2387
		mask: EncodeZero | EncodeRightSpace,
		in:   "␠＇␏\x0fη'␟ζＶς \x05＼/＜V\x06␝/OλzＯｌ\"Ｏ\x0fν␠ο",
		out:  "␠＇␏\x0fη'␟ζＶς \x05＼/＜V\x06␝/OλzＯｌ\"Ｏ\x0fν␠ο",
	}, { // 2388
		mask: EncodeZero | EncodeRightSpace,
		in:   " ＇␏\x0fη'␟ζＶς \x05＼/＜V\x06␝/OλzＯｌ\"Ｏ\x0fν7␠",
		out:  " ＇␏\x0fη'␟ζＶς \x05＼/＜V\x06␝/OλzＯｌ\"Ｏ\x0fν7‛␠",
	}, { // 2389
		mask: EncodeZero | EncodeRightSpace,
		in:   "␠＇␏\x0fη'␟ζＶς \x05＼/＜V\x06␝/OλzＯｌ\"Ｏ\x0fν7␠",
		out:  "␠＇␏\x0fη'␟ζＶς \x05＼/＜V\x06␝/OλzＯｌ\"Ｏ\x0fν7‛␠",
	}, { // 2390
		mask: EncodeZero | EncodeRightSpace,
		in:   "， ␏\x0fη'␟ζＶς \x05＼/＜V\x06␝/OλzＯｌ\"Ｏ\x0fν7ο",
		out:  "， ␏\x0fη'␟ζＶς \x05＼/＜V\x06␝/OλzＯｌ\"Ｏ\x0fν7ο",
	}, { // 2391
		mask: EncodeZero | EncodeRightSpace,
		in:   "，␠␏\x0fη'␟ζＶς \x05＼/＜V\x06␝/OλzＯｌ\"Ｏ\x0fν7ο",
		out:  "，␠␏\x0fη'␟ζＶς \x05＼/＜V\x06␝/OλzＯｌ\"Ｏ\x0fν7ο",
	}, { // 2392
		mask: EncodeZero | EncodeRightSpace,
		in:   "， ␏\x0fη'␟ζＶς \x05＼/＜V\x06␝/OλzＯｌ\"Ｏ\x0fν␠ο",
		out:  "， ␏\x0fη'␟ζＶς \x05＼/＜V\x06␝/OλzＯｌ\"Ｏ\x0fν␠ο",
	}, { // 2393
		mask: EncodeZero | EncodeRightSpace,
		in:   "，␠␏\x0fη'␟ζＶς \x05＼/＜V\x06␝/OλzＯｌ\"Ｏ\x0fν␠ο",
		out:  "，␠␏\x0fη'␟ζＶς \x05＼/＜V\x06␝/OλzＯｌ\"Ｏ\x0fν␠ο",
	}, { // 2394
		mask: EncodeZero | EncodeRightSpace,
		in:   "， ␏\x0fη'␟ζＶς \x05＼/＜V\x06␝/OλzＯｌ\"Ｏ\x0fν7␠",
		out:  "， ␏\x0fη'␟ζＶς \x05＼/＜V\x06␝/OλzＯｌ\"Ｏ\x0fν7‛␠",
	}, { // 2395
		mask: EncodeZero | EncodeRightSpace,
		in:   "，␠␏\x0fη'␟ζＶς \x05＼/＜V\x06␝/OλzＯｌ\"Ｏ\x0fν7␠",
		out:  "，␠␏\x0fη'␟ζＶς \x05＼/＜V\x06␝/OλzＯｌ\"Ｏ\x0fν7‛␠",
	}, { // 2396
		mask: EncodeZero | EncodeRightSpace,
		in:   "，＇␏\x0fη'␟ζＶς \x05＼/＜V\x06␝/OλzＯｌ\"Ｏ\x0fν ο",
		out:  "，＇␏\x0fη'␟ζＶς \x05＼/＜V\x06␝/OλzＯｌ\"Ｏ\x0fν ο",
	}, { // 2397
		mask: EncodeZero | EncodeRightSpace,
		in:   "，＇␏\x0fη'␟ζＶς \x05＼/＜V\x06␝/OλzＯｌ\"Ｏ\x0fν␠ο",
		out:  "，＇␏\x0fη'␟ζＶς \x05＼/＜V\x06␝/OλzＯｌ\"Ｏ\x0fν␠ο",
	}, { // 2398
		mask: EncodeZero | EncodeRightSpace,
		in:   "，＇␏\x0fη'␟ζＶς \x05＼/＜V\x06␝/OλzＯｌ\"Ｏ\x0fν ␠",
		out:  "，＇␏\x0fη'␟ζＶς \x05＼/＜V\x06␝/OλzＯｌ\"Ｏ\x0fν ‛␠",
	}, { // 2399
		mask: EncodeZero | EncodeRightSpace,
		in:   "，＇␏\x0fη'␟ζＶς \x05＼/＜V\x06␝/OλzＯｌ\"Ｏ\x0fν␠␠",
		out:  "，＇␏\x0fη'␟ζＶς \x05＼/＜V\x06␝/OλzＯｌ\"Ｏ\x0fν␠‛␠",
	}, { // 2400
		mask: EncodeZero | EncodeRightSpace,
		in:   "，＇␏\x0fη'␟ζＶς \x05＼/＜V\x06␝/OλzＯｌ\"Ｏ\x0fν7 ",
		out:  "，＇␏\x0fη'␟ζＶς \x05＼/＜V\x06␝/OλzＯｌ\"Ｏ\x0fν7␠",
	}, { // 2401
		mask: EncodeZero | EncodeRightSpace,
		in:   "，＇␏\x0fη'␟ζＶς \x05＼/＜V\x06␝/OλzＯｌ\"Ｏ\x0fν7␠",
		out:  "，＇␏\x0fη'␟ζＶς \x05＼/＜V\x06␝/OλzＯｌ\"Ｏ\x0fν7‛␠",
	}, { // 2402
		mask: EncodeSlash | EncodeRightSpace,
		in:   "Ｒ␂｛=υ␈Ｕ␡ｊβ αvyx$\x1b．\u007f␋５ζ[\x01ψ\x13\x1d!␙ψ",
		out:  "Ｒ␂｛=υ␈Ｕ␡ｊβ αvyx$\x1b．\u007f␋５ζ[\x01ψ\x13\x1d!␙ψ",
	}, { // 2403
		mask: EncodeSlash | EncodeRightSpace,
		in:   " ␠｛=υ␈Ｕ␡ｊβ αvyx$\x1b．\u007f␋５ζ[\x01ψ\x13\x1d!␙ψ",
		out:  " ␠｛=υ␈Ｕ␡ｊβ αvyx$\x1b．\u007f␋５ζ[\x01ψ\x13\x1d!␙ψ",
	}, { // 2404
		mask: EncodeSlash | EncodeRightSpace,
		in:   "␠␠｛=υ␈Ｕ␡ｊβ αvyx$\x1b．\u007f␋５ζ[\x01ψ\x13\x1d!␙ψ",
		out:  "␠␠｛=υ␈Ｕ␡ｊβ αvyx$\x1b．\u007f␋５ζ[\x01ψ\x13\x1d!␙ψ",
	}, { // 2405
		mask: EncodeSlash | EncodeRightSpace,
		in:   " ␂｛=υ␈Ｕ␡ｊβ αvyx$\x1b．\u007f␋５ζ[\x01ψ\x13\x1d!␠ψ",
		out:  " ␂｛=υ␈Ｕ␡ｊβ αvyx$\x1b．\u007f␋５ζ[\x01ψ\x13\x1d!␠ψ",
	}, { // 2406
		mask: EncodeSlash | EncodeRightSpace,
		in:   "␠␂｛=υ␈Ｕ␡ｊβ αvyx$\x1b．\u007f␋５ζ[\x01ψ\x13\x1d!␠ψ",
		out:  "␠␂｛=υ␈Ｕ␡ｊβ αvyx$\x1b．\u007f␋５ζ[\x01ψ\x13\x1d!␠ψ",
	}, { // 2407
		mask: EncodeSlash | EncodeRightSpace,
		in:   " ␂｛=υ␈Ｕ␡ｊβ αvyx$\x1b．\u007f␋５ζ[\x01ψ\x13\x1d!␙␠",
		out:  " ␂｛=υ␈Ｕ␡ｊβ αvyx$\x1b．\u007f␋５ζ[\x01ψ\x13\x1d!␙‛␠",
	}, { // 2408
		mask: EncodeSlash | EncodeRightSpace,
		in:   "␠␂｛=υ␈Ｕ␡ｊβ αvyx$\x1b．\u007f␋５ζ[\x01ψ\x13\x1d!␙␠",
		out:  "␠␂｛=υ␈Ｕ␡ｊβ αvyx$\x1b．\u007f␋５ζ[\x01ψ\x13\x1d!␙‛␠",
	}, { // 2409
		mask: EncodeSlash | EncodeRightSpace,
		in:   "Ｒ ｛=υ␈Ｕ␡ｊβ αvyx$\x1b．\u007f␋５ζ[\x01ψ\x13\x1d!␙ψ",
		out:  "Ｒ ｛=υ␈Ｕ␡ｊβ αvyx$\x1b．\u007f␋５ζ[\x01ψ\x13\x1d!␙ψ",
	}, { // 2410
		mask: EncodeSlash | EncodeRightSpace,
		in:   "Ｒ␠｛=υ␈Ｕ␡ｊβ αvyx$\x1b．\u007f␋５ζ[\x01ψ\x13\x1d!␙ψ",
		out:  "Ｒ␠｛=υ␈Ｕ␡ｊβ αvyx$\x1b．\u007f␋５ζ[\x01ψ\x13\x1d!␙ψ",
	}, { // 2411
		mask: EncodeSlash | EncodeRightSpace,
		in:   "Ｒ ｛=υ␈Ｕ␡ｊβ αvyx$\x1b．\u007f␋５ζ[\x01ψ\x13\x1d!␠ψ",
		out:  "Ｒ ｛=υ␈Ｕ␡ｊβ αvyx$\x1b．\u007f␋５ζ[\x01ψ\x13\x1d!␠ψ",
	}, { // 2412
		mask: EncodeSlash | EncodeRightSpace,
		in:   "Ｒ␠｛=υ␈Ｕ␡ｊβ αvyx$\x1b．\u007f␋５ζ[\x01ψ\x13\x1d!␠ψ",
		out:  "Ｒ␠｛=υ␈Ｕ␡ｊβ αvyx$\x1b．\u007f␋５ζ[\x01ψ\x13\x1d!␠ψ",
	}, { // 2413
		mask: EncodeSlash | EncodeRightSpace,
		in:   "Ｒ ｛=υ␈Ｕ␡ｊβ αvyx$\x1b．\u007f␋５ζ[\x01ψ\x13\x1d!␙␠",
		out:  "Ｒ ｛=υ␈Ｕ␡ｊβ αvyx$\x1b．\u007f␋５ζ[\x01ψ\x13\x1d!␙‛␠",
	}, { // 2414
		mask: EncodeSlash | EncodeRightSpace,
		in:   "Ｒ␠｛=υ␈Ｕ␡ｊβ αvyx$\x1b．\u007f␋５ζ[\x01ψ\x13\x1d!␙␠",
		out:  "Ｒ␠｛=υ␈Ｕ␡ｊβ αvyx$\x1b．\u007f␋５ζ[\x01ψ\x13\x1d!␙‛␠",
	}, { // 2415
		mask: EncodeSlash | EncodeRightSpace,
		in:   "Ｒ␂｛=υ␈Ｕ␡ｊβ αvyx$\x1b．\u007f␋５ζ[\x01ψ\x13\x1d! ψ",
		out:  "Ｒ␂｛=υ␈Ｕ␡ｊβ αvyx$\x1b．\u007f␋５ζ[\x01ψ\x13\x1d! ψ",
	}, { // 2416
		mask: EncodeSlash | EncodeRightSpace,
		in:   "Ｒ␂｛=υ␈Ｕ␡ｊβ αvyx$\x1b．\u007f␋５ζ[\x01ψ\x13\x1d!␠ψ",
		out:  "Ｒ␂｛=υ␈Ｕ␡ｊβ αvyx$\x1b．\u007f␋５ζ[\x01ψ\x13\x1d!␠ψ",
	}, { // 2417
		mask: EncodeSlash | EncodeRightSpace,
		in:   "Ｒ␂｛=υ␈Ｕ␡ｊβ αvyx$\x1b．\u007f␋５ζ[\x01ψ\x13\x1d! ␠",
		out:  "Ｒ␂｛=υ␈Ｕ␡ｊβ αvyx$\x1b．\u007f␋５ζ[\x01ψ\x13\x1d! ‛␠",
	}, { // 2418
		mask: EncodeSlash | EncodeRightSpace,
		in:   "Ｒ␂｛=υ␈Ｕ␡ｊβ αvyx$\x1b．\u007f␋５ζ[\x01ψ\x13\x1d!␠␠",
		out:  "Ｒ␂｛=υ␈Ｕ␡ｊβ αvyx$\x1b．\u007f␋５ζ[\x01ψ\x13\x1d!␠‛␠",
	}, { // 2419
		mask: EncodeSlash | EncodeRightSpace,
		in:   "Ｒ␂｛=υ␈Ｕ␡ｊβ αvyx$\x1b．\u007f␋５ζ[\x01ψ\x13\x1d!␙ ",
		out:  "Ｒ␂｛=υ␈Ｕ␡ｊβ αvyx$\x1b．\u007f␋５ζ[\x01ψ\x13\x1d!␙␠",
	}, { // 2420
		mask: EncodeSlash | EncodeRightSpace,
		in:   "Ｒ␂｛=υ␈Ｕ␡ｊβ αvyx$\x1b．\u007f␋５ζ[\x01ψ\x13\x1d!␙␠",
		out:  "Ｒ␂｛=υ␈Ｕ␡ｊβ αvyx$\x1b．\u007f␋５ζ[\x01ψ\x13\x1d!␙‛␠",
	}, { // 2421
		mask: EncodeSingleQuote | EncodeRightSpace,
		in:   "η␕8Ｊ？ｒτ\x1d// κι\x1bδＵ'␇R\u007f＇iｇ／｜\vN␎Ｌ\n",
		out:  "η␕8Ｊ？ｒτ\x1d// κι\x1bδＵ＇␇R\u007f‛＇iｇ／｜\vN␎Ｌ\n",
	}, { // 2422
		mask: EncodeSingleQuote | EncodeRightSpace,
		in:   " ␠8Ｊ？ｒτ\x1d// κι\x1bδＵ'␇R\u007f＇iｇ／｜\vN␎Ｌ\n",
		out:  " ␠8Ｊ？ｒτ\x1d// κι\x1bδＵ＇␇R\u007f‛＇iｇ／｜\vN␎Ｌ\n",
	}, { // 2423
		mask: EncodeSingleQuote | EncodeRightSpace,
		in:   "␠␠8Ｊ？ｒτ\x1d// κι\x1bδＵ'␇R\u007f＇iｇ／｜\vN␎Ｌ\n",
		out:  "␠␠8Ｊ？ｒτ\x1d// κι\x1bδＵ＇␇R\u007f‛＇iｇ／｜\vN␎Ｌ\n",
	}, { // 2424
		mask: EncodeSingleQuote | EncodeRightSpace,
		in:   " ␕8Ｊ？ｒτ\x1d// κι\x1bδＵ'␇R\u007f＇iｇ／｜\vN␎␠\n",
		out:  " ␕8Ｊ？ｒτ\x1d// κι\x1bδＵ＇␇R\u007f‛＇iｇ／｜\vN␎␠\n",
	}, { // 2425
		mask: EncodeSingleQuote | EncodeRightSpace,
		in:   "␠␕8Ｊ？ｒτ\x1d// κι\x1bδＵ'␇R\u007f＇iｇ／｜\vN␎␠\n",
		out:  "␠␕8Ｊ？ｒτ\x1d// κι\x1bδＵ＇␇R\u007f‛＇iｇ／｜\vN␎␠\n",
	}, { // 2426
		mask: EncodeSingleQuote | EncodeRightSpace,
		in:   " ␕8Ｊ？ｒτ\x1d// κι\x1bδＵ'␇R\u007f＇iｇ／｜\vN␎Ｌ␠",
		out:  " ␕8Ｊ？ｒτ\x1d// κι\x1bδＵ＇␇R\u007f‛＇iｇ／｜\vN␎Ｌ‛␠",
	}, { // 2427
		mask: EncodeSingleQuote | EncodeRightSpace,
		in:   "␠␕8Ｊ？ｒτ\x1d// κι\x1bδＵ'␇R\u007f＇iｇ／｜\vN␎Ｌ␠",
		out:  "␠␕8Ｊ？ｒτ\x1d// κι\x1bδＵ＇␇R\u007f‛＇iｇ／｜\vN␎Ｌ‛␠",
	}, { // 2428
		mask: EncodeSingleQuote | EncodeRightSpace,
		in:   "η 8Ｊ？ｒτ\x1d// κι\x1bδＵ'␇R\u007f＇iｇ／｜\vN␎Ｌ\n",
		out:  "η 8Ｊ？ｒτ\x1d// κι\x1bδＵ＇␇R\u007f‛＇iｇ／｜\vN␎Ｌ\n",
	}, { // 2429
		mask: EncodeSingleQuote | EncodeRightSpace,
		in:   "η␠8Ｊ？ｒτ\x1d// κι\x1bδＵ'␇R\u007f＇iｇ／｜\vN␎Ｌ\n",
		out:  "η␠8Ｊ？ｒτ\x1d// κι\x1bδＵ＇␇R\u007f‛＇iｇ／｜\vN␎Ｌ\n",
	}, { // 2430
		mask: EncodeSingleQuote | EncodeRightSpace,
		in:   "η 8Ｊ？ｒτ\x1d// κι\x1bδＵ'␇R\u007f＇iｇ／｜\vN␎␠\n",
		out:  "η 8Ｊ？ｒτ\x1d// κι\x1bδＵ＇␇R\u007f‛＇iｇ／｜\vN␎␠\n",
	}, { // 2431
		mask: EncodeSingleQuote | EncodeRightSpace,
		in:   "η␠8Ｊ？ｒτ\x1d// κι\x1bδＵ'␇R\u007f＇iｇ／｜\vN␎␠\n",
		out:  "η␠8Ｊ？ｒτ\x1d// κι\x1bδＵ＇␇R\u007f‛＇iｇ／｜\vN␎␠\n",
	}, { // 2432
		mask: EncodeSingleQuote | EncodeRightSpace,
		in:   "η 8Ｊ？ｒτ\x1d// κι\x1bδＵ'␇R\u007f＇iｇ／｜\vN␎Ｌ␠",
		out:  "η 8Ｊ？ｒτ\x1d// κι\x1bδＵ＇␇R\u007f‛＇iｇ／｜\vN␎Ｌ‛␠",
	}, { // 2433
		mask: EncodeSingleQuote | EncodeRightSpace,
		in:   "η␠8Ｊ？ｒτ\x1d// κι\x1bδＵ'␇R\u007f＇iｇ／｜\vN␎Ｌ␠",
		out:  "η␠8Ｊ？ｒτ\x1d// κι\x1bδＵ＇␇R\u007f‛＇iｇ／｜\vN␎Ｌ‛␠",
	}, { // 2434
		mask: EncodeSingleQuote | EncodeRightSpace,
		in:   "η␕8Ｊ？ｒτ\x1d// κι\x1bδＵ'␇R\u007f＇iｇ／｜\vN␎ \n",
		out:  "η␕8Ｊ？ｒτ\x1d// κι\x1bδＵ＇␇R\u007f‛＇iｇ／｜\vN␎ \n",
	}, { // 2435
		mask: EncodeSingleQuote | EncodeRightSpace,
		in:   "η␕8Ｊ？ｒτ\x1d// κι\x1bδＵ'␇R\u007f＇iｇ／｜\vN␎␠\n",
		out:  "η␕8Ｊ？ｒτ\x1d// κι\x1bδＵ＇␇R\u007f‛＇iｇ／｜\vN␎␠\n",
	}, { // 2436
		mask: EncodeSingleQuote | EncodeRightSpace,
		in:   "η␕8Ｊ？ｒτ\x1d// κι\x1bδＵ'␇R\u007f＇iｇ／｜\vN␎ ␠",
		out:  "η␕8Ｊ？ｒτ\x1d// κι\x1bδＵ＇␇R\u007f‛＇iｇ／｜\vN␎ ‛␠",
	}, { // 2437
		mask: EncodeSingleQuote | EncodeRightSpace,
		in:   "η␕8Ｊ？ｒτ\x1d// κι\x1bδＵ'␇R\u007f＇iｇ／｜\vN␎␠␠",
		out:  "η␕8Ｊ？ｒτ\x1d// κι\x1bδＵ＇␇R\u007f‛＇iｇ／｜\vN␎␠‛␠",
	}, { // 2438
		mask: EncodeSingleQuote | EncodeRightSpace,
		in:   "η␕8Ｊ？ｒτ\x1d// κι\x1bδＵ'␇R\u007f＇iｇ／｜\vN␎Ｌ ",
		out:  "η␕8Ｊ？ｒτ\x1d// κι\x1bδＵ＇␇R\u007f‛＇iｇ／｜\vN␎Ｌ␠",
	}, { // 2439
		mask: EncodeSingleQuote | EncodeRightSpace,
		in:   "η␕8Ｊ？ｒτ\x1d// κι\x1bδＵ'␇R\u007f＇iｇ／｜\vN␎Ｌ␠",
		out:  "η␕8Ｊ？ｒτ\x1d// κι\x1bδＵ＇␇R\u007f‛＇iｇ／｜\vN␎Ｌ‛␠",
	}, { // 2440
		mask: EncodeBackQuote | EncodeRightSpace,
		in:   "\x1a␂ρ＂\"］#ａＤｌ ？^Ｌ␞γ␙*π\x1c！8ξtρ\"U␉uω",
		out:  "\x1a␂ρ＂\"］#ａＤｌ ？^Ｌ␞γ␙*π\x1c！8ξtρ\"U␉uω",
	}, { // 2441
		mask: EncodeBackQuote | EncodeRightSpace,
		in:   " ␠ρ＂\"］#ａＤｌ ？^Ｌ␞γ␙*π\x1c！8ξtρ\"U␉uω",
		out:  " ␠ρ＂\"］#ａＤｌ ？^Ｌ␞γ␙*π\x1c！8ξtρ\"U␉uω",
	}, { // 2442
		mask: EncodeBackQuote | EncodeRightSpace,
		in:   "␠␠ρ＂\"］#ａＤｌ ？^Ｌ␞γ␙*π\x1c！8ξtρ\"U␉uω",
		out:  "␠␠ρ＂\"］#ａＤｌ ？^Ｌ␞γ␙*π\x1c！8ξtρ\"U␉uω",
	}, { // 2443
		mask: EncodeBackQuote | EncodeRightSpace,
		in:   " ␂ρ＂\"］#ａＤｌ ？^Ｌ␞γ␙*π\x1c！8ξtρ\"U␉␠ω",
		out:  " ␂ρ＂\"］#ａＤｌ ？^Ｌ␞γ␙*π\x1c！8ξtρ\"U␉␠ω",
	}, { // 2444
		mask: EncodeBackQuote | EncodeRightSpace,
		in:   "␠␂ρ＂\"］#ａＤｌ ？^Ｌ␞γ␙*π\x1c！8ξtρ\"U␉␠ω",
		out:  "␠␂ρ＂\"］#ａＤｌ ？^Ｌ␞γ␙*π\x1c！8ξtρ\"U␉␠ω",
	}, { // 2445
		mask: EncodeBackQuote | EncodeRightSpace,
		in:   " ␂ρ＂\"］#ａＤｌ ？^Ｌ␞γ␙*π\x1c！8ξtρ\"U␉u␠",
		out:  " ␂ρ＂\"］#ａＤｌ ？^Ｌ␞γ␙*π\x1c！8ξtρ\"U␉u‛␠",
	}, { // 2446
		mask: EncodeBackQuote | EncodeRightSpace,
		in:   "␠␂ρ＂\"］#ａＤｌ ？^Ｌ␞γ␙*π\x1c！8ξtρ\"U␉u␠",
		out:  "␠␂ρ＂\"］#ａＤｌ ？^Ｌ␞γ␙*π\x1c！8ξtρ\"U␉u‛␠",
	}, { // 2447
		mask: EncodeBackQuote | EncodeRightSpace,
		in:   "\x1a ρ＂\"］#ａＤｌ ？^Ｌ␞γ␙*π\x1c！8ξtρ\"U␉uω",
		out:  "\x1a ρ＂\"］#ａＤｌ ？^Ｌ␞γ␙*π\x1c！8ξtρ\"U␉uω",
	}, { // 2448
		mask: EncodeBackQuote | EncodeRightSpace,
		in:   "\x1a␠ρ＂\"］#ａＤｌ ？^Ｌ␞γ␙*π\x1c！8ξtρ\"U␉uω",
		out:  "\x1a␠ρ＂\"］#ａＤｌ ？^Ｌ␞γ␙*π\x1c！8ξtρ\"U␉uω",
	}, { // 2449
		mask: EncodeBackQuote | EncodeRightSpace,
		in:   "\x1a ρ＂\"］#ａＤｌ ？^Ｌ␞γ␙*π\x1c！8ξtρ\"U␉␠ω",
		out:  "\x1a ρ＂\"］#ａＤｌ ？^Ｌ␞γ␙*π\x1c！8ξtρ\"U␉␠ω",
	}, { // 2450
		mask: EncodeBackQuote | EncodeRightSpace,
		in:   "\x1a␠ρ＂\"］#ａＤｌ ？^Ｌ␞γ␙*π\x1c！8ξtρ\"U␉␠ω",
		out:  "\x1a␠ρ＂\"］#ａＤｌ ？^Ｌ␞γ␙*π\x1c！8ξtρ\"U␉␠ω",
	}, { // 2451
		mask: EncodeBackQuote | EncodeRightSpace,
		in:   "\x1a ρ＂\"］#ａＤｌ ？^Ｌ␞γ␙*π\x1c！8ξtρ\"U␉u␠",
		out:  "\x1a ρ＂\"］#ａＤｌ ？^Ｌ␞γ␙*π\x1c！8ξtρ\"U␉u‛␠",
	}, { // 2452
		mask: EncodeBackQuote | EncodeRightSpace,
		in:   "\x1a␠ρ＂\"］#ａＤｌ ？^Ｌ␞γ␙*π\x1c！8ξtρ\"U␉u␠",
		out:  "\x1a␠ρ＂\"］#ａＤｌ ？^Ｌ␞γ␙*π\x1c！8ξtρ\"U␉u‛␠",
	}, { // 2453
		mask: EncodeBackQuote | EncodeRightSpace,
		in:   "\x1a␂ρ＂\"］#ａＤｌ ？^Ｌ␞γ␙*π\x1c！8ξtρ\"U␉ ω",
		out:  "\x1a␂ρ＂\"］#ａＤｌ ？^Ｌ␞γ␙*π\x1c！8ξtρ\"U␉ ω",
	}, { // 2454
		mask: EncodeBackQuote | EncodeRightSpace,
		in:   "\x1a␂ρ＂\"］#ａＤｌ ？^Ｌ␞γ␙*π\x1c！8ξtρ\"U␉␠ω",
		out:  "\x1a␂ρ＂\"］#ａＤｌ ？^Ｌ␞γ␙*π\x1c！8ξtρ\"U␉␠ω",
	}, { // 2455
		mask: EncodeBackQuote | EncodeRightSpace,
		in:   "\x1a␂ρ＂\"］#ａＤｌ ？^Ｌ␞γ␙*π\x1c！8ξtρ\"U␉ ␠",
		out:  "\x1a␂ρ＂\"］#ａＤｌ ？^Ｌ␞γ␙*π\x1c！8ξtρ\"U␉ ‛␠",
	}, { // 2456
		mask: EncodeBackQuote | EncodeRightSpace,
		in:   "\x1a␂ρ＂\"］#ａＤｌ ？^Ｌ␞γ␙*π\x1c！8ξtρ\"U␉␠␠",
		out:  "\x1a␂ρ＂\"］#ａＤｌ ？^Ｌ␞γ␙*π\x1c！8ξtρ\"U␉␠‛␠",
	}, { // 2457
		mask: EncodeBackQuote | EncodeRightSpace,
		in:   "\x1a␂ρ＂\"］#ａＤｌ ？^Ｌ␞γ␙*π\x1c！8ξtρ\"U␉u ",
		out:  "\x1a␂ρ＂\"］#ａＤｌ ？^Ｌ␞γ␙*π\x1c！8ξtρ\"U␉u␠",
	}, { // 2458
		mask: EncodeBackQuote | EncodeRightSpace,
		in:   "\x1a␂ρ＂\"］#ａＤｌ ？^Ｌ␞γ␙*π\x1c！8ξtρ\"U␉u␠",
		out:  "\x1a␂ρ＂\"］#ａＤｌ ？^Ｌ␞γ␙*π\x1c！8ξtρ\"U␉u‛␠",
	}, { // 2459
		mask: EncodeLtGt | EncodeRightSpace,
		in:   "%␒；:Jα;ｉ＜κ γ␘ｆＤ\x0eｇ@Ｎμ␅␐Nε/B;e\x19β",
		out:  "%␒；:Jα;ｉ‛＜κ γ␘ｆＤ\x0eｇ@Ｎμ␅␐Nε/B;e\x19β",
	}, { // 2460
		mask: EncodeLtGt | EncodeRightSpace,
		in:   " ␠；:Jα;ｉ＜κ γ␘ｆＤ\x0eｇ@Ｎμ␅␐Nε/B;e\x19β",
		out:  " ␠；:Jα;ｉ‛＜κ γ␘ｆＤ\x0eｇ@Ｎμ␅␐Nε/B;e\x19β",
	}, { // 2461
		mask: EncodeLtGt | EncodeRightSpace,
		in:   "␠␠；:Jα;ｉ＜κ γ␘ｆＤ\x0eｇ@Ｎμ␅␐Nε/B;e\x19β",
		out:  "␠␠；:Jα;ｉ‛＜κ γ␘ｆＤ\x0eｇ@Ｎμ␅␐Nε/B;e\x19β",
	}, { // 2462
		mask: EncodeLtGt | EncodeRightSpace,
		in:   " ␒；:Jα;ｉ＜κ γ␘ｆＤ\x0eｇ@Ｎμ␅␐Nε/B;e␠β",
		out:  " ␒；:Jα;ｉ‛＜κ γ␘ｆＤ\x0eｇ@Ｎμ␅␐Nε/B;e␠β",
	}, { // 2463
		mask: EncodeLtGt | EncodeRightSpace,
		in:   "␠␒；:Jα;ｉ＜κ γ␘ｆＤ\x0eｇ@Ｎμ␅␐Nε/B;e␠β",
		out:  "␠␒；:Jα;ｉ‛＜κ γ␘ｆＤ\x0eｇ@Ｎμ␅␐Nε/B;e␠β",
	}, { // 2464
		mask: EncodeLtGt | EncodeRightSpace,
		in:   " ␒；:Jα;ｉ＜κ γ␘ｆＤ\x0eｇ@Ｎμ␅␐Nε/B;e\x19␠",
		out:  " ␒；:Jα;ｉ‛＜κ γ␘ｆＤ\x0eｇ@Ｎμ␅␐Nε/B;e\x19‛␠",
	}, { // 2465
		mask: EncodeLtGt | EncodeRightSpace,
		in:   "␠␒；:Jα;ｉ＜κ γ␘ｆＤ\x0eｇ@Ｎμ␅␐Nε/B;e\x19␠",
		out:  "␠␒；:Jα;ｉ‛＜κ γ␘ｆＤ\x0eｇ@Ｎμ␅␐Nε/B;e\x19‛␠",
	}, { // 2466
		mask: EncodeLtGt | EncodeRightSpace,
		in:   "% ；:Jα;ｉ＜κ γ␘ｆＤ\x0eｇ@Ｎμ␅␐Nε/B;e\x19β",
		out:  "% ；:Jα;ｉ‛＜κ γ␘ｆＤ\x0eｇ@Ｎμ␅␐Nε/B;e\x19β",
	}, { // 2467
		mask: EncodeLtGt | EncodeRightSpace,
		in:   "%␠；:Jα;ｉ＜κ γ␘ｆＤ\x0eｇ@Ｎμ␅␐Nε/B;e\x19β",
		out:  "%␠；:Jα;ｉ‛＜κ γ␘ｆＤ\x0eｇ@Ｎμ␅␐Nε/B;e\x19β",
	}, { // 2468
		mask: EncodeLtGt | EncodeRightSpace,
		in:   "% ；:Jα;ｉ＜κ γ␘ｆＤ\x0eｇ@Ｎμ␅␐Nε/B;e␠β",
		out:  "% ；:Jα;ｉ‛＜κ γ␘ｆＤ\x0eｇ@Ｎμ␅␐Nε/B;e␠β",
	}, { // 2469
		mask: EncodeLtGt | EncodeRightSpace,
		in:   "%␠；:Jα;ｉ＜κ γ␘ｆＤ\x0eｇ@Ｎμ␅␐Nε/B;e␠β",
		out:  "%␠；:Jα;ｉ‛＜κ γ␘ｆＤ\x0eｇ@Ｎμ␅␐Nε/B;e␠β",
	}, { // 2470
		mask: EncodeLtGt | EncodeRightSpace,
		in:   "% ；:Jα;ｉ＜κ γ␘ｆＤ\x0eｇ@Ｎμ␅␐Nε/B;e\x19␠",
		out:  "% ；:Jα;ｉ‛＜κ γ␘ｆＤ\x0eｇ@Ｎμ␅␐Nε/B;e\x19‛␠",
	}, { // 2471
		mask: EncodeLtGt | EncodeRightSpace,
		in:   "%␠；:Jα;ｉ＜κ γ␘ｆＤ\x0eｇ@Ｎμ␅␐Nε/B;e\x19␠",
		out:  "%␠；:Jα;ｉ‛＜κ γ␘ｆＤ\x0eｇ@Ｎμ␅␐Nε/B;e\x19‛␠",
	}, { // 2472
		mask: EncodeLtGt | EncodeRightSpace,
		in:   "%␒；:Jα;ｉ＜κ γ␘ｆＤ\x0eｇ@Ｎμ␅␐Nε/B;e β",
		out:  "%␒；:Jα;ｉ‛＜κ γ␘ｆＤ\x0eｇ@Ｎμ␅␐Nε/B;e β",
	}, { // 2473
		mask: EncodeLtGt | EncodeRightSpace,
		in:   "%␒；:Jα;ｉ＜κ γ␘ｆＤ\x0eｇ@Ｎμ␅␐Nε/B;e␠β",
		out:  "%␒；:Jα;ｉ‛＜κ γ␘ｆＤ\x0eｇ@Ｎμ␅␐Nε/B;e␠β",
	}, { // 2474
		mask: EncodeLtGt | EncodeRightSpace,
		in:   "%␒；:Jα;ｉ＜κ γ␘ｆＤ\x0eｇ@Ｎμ␅␐Nε/B;e ␠",
		out:  "%␒；:Jα;ｉ‛＜κ γ␘ｆＤ\x0eｇ@Ｎμ␅␐Nε/B;e ‛␠",
	}, { // 2475
		mask: EncodeLtGt | EncodeRightSpace,
		in:   "%␒；:Jα;ｉ＜κ γ␘ｆＤ\x0eｇ@Ｎμ␅␐Nε/B;e␠␠",
		out:  "%␒；:Jα;ｉ‛＜κ γ␘ｆＤ\x0eｇ@Ｎμ␅␐Nε/B;e␠‛␠",
	}, { // 2476
		mask: EncodeLtGt | EncodeRightSpace,
		in:   "%␒；:Jα;ｉ＜κ γ␘ｆＤ\x0eｇ@Ｎμ␅␐Nε/B;e\x19 ",
		out:  "%␒；:Jα;ｉ‛＜κ γ␘ｆＤ\x0eｇ@Ｎμ␅␐Nε/B;e\x19␠",
	}, { // 2477
		mask: EncodeLtGt | EncodeRightSpace,
		in:   "%␒；:Jα;ｉ＜κ γ␘ｆＤ\x0eｇ@Ｎμ␅␐Nε/B;e\x19␠",
		out:  "%␒；:Jα;ｉ‛＜κ γ␘ｆＤ\x0eｇ@Ｎμ␅␐Nε/B;e\x19‛␠",
	}, { // 2478
		mask: EncodeSquareBracket | EncodeRightSpace,
		in:   "␌υ:９*Ｏ␙0␗ρ ρ␕Ｐ)\rω]７,｜␛%＝ν2\vφ␝'",
		out:  "␌υ:９*Ｏ␙0␗ρ ρ␕Ｐ)\rω］７,｜␛%＝ν2\vφ␝'",
	}, { // 2479
		mask: EncodeSquareBracket | EncodeRightSpace,
		in:   " ␠:９*Ｏ␙0␗ρ ρ␕Ｐ)\rω]７,｜␛%＝ν2\vφ␝'",
		out:  " ␠:９*Ｏ␙0␗ρ ρ␕Ｐ)\rω］７,｜␛%＝ν2\vφ␝'",
	}, { // 2480
		mask: EncodeSquareBracket | EncodeRightSpace,
		in:   "␠␠:９*Ｏ␙0␗ρ ρ␕Ｐ)\rω]７,｜␛%＝ν2\vφ␝'",
		out:  "␠␠:９*Ｏ␙0␗ρ ρ␕Ｐ)\rω］７,｜␛%＝ν2\vφ␝'",
	}, { // 2481
		mask: EncodeSquareBracket | EncodeRightSpace,
		in:   " υ:９*Ｏ␙0␗ρ ρ␕Ｐ)\rω]７,｜␛%＝ν2\vφ␠'",
		out:  " υ:９*Ｏ␙0␗ρ ρ␕Ｐ)\rω］７,｜␛%＝ν2\vφ␠'",
	}, { // 2482
		mask: EncodeSquareBracket | EncodeRightSpace,
		in:   "␠υ:９*Ｏ␙0␗ρ ρ␕Ｐ)\rω]７,｜␛%＝ν2\vφ␠'",
		out:  "␠υ:９*Ｏ␙0␗ρ ρ␕Ｐ)\rω］７,｜␛%＝ν2\vφ␠'",
	}, { // 2483
		mask: EncodeSquareBracket | EncodeRightSpace,
		in:   " υ:９*Ｏ␙0␗ρ ρ␕Ｐ)\rω]７,｜␛%＝ν2\vφ␝␠",
		out:  " υ:９*Ｏ␙0␗ρ ρ␕Ｐ)\rω］７,｜␛%＝ν2\vφ␝‛␠",
	}, { // 2484
		mask: EncodeSquareBracket | EncodeRightSpace,
		in:   "␠υ:９*Ｏ␙0␗ρ ρ␕Ｐ)\rω]７,｜␛%＝ν2\vφ␝␠",
		out:  "␠υ:９*Ｏ␙0␗ρ ρ␕Ｐ)\rω］７,｜␛%＝ν2\vφ␝‛␠",
	}, { // 2485
		mask: EncodeSquareBracket | EncodeRightSpace,
		in:   "␌ :９*Ｏ␙0␗ρ ρ␕Ｐ)\rω]７,｜␛%＝ν2\vφ␝'",
		out:  "␌ :９*Ｏ␙0␗ρ ρ␕Ｐ)\rω］７,｜␛%＝ν2\vφ␝'",
	}, { // 2486
		mask: EncodeSquareBracket | EncodeRightSpace,
		in:   "␌␠:９*Ｏ␙0␗ρ ρ␕Ｐ)\rω]７,｜␛%＝ν2\vφ␝'",
		out:  "␌␠:９*Ｏ␙0␗ρ ρ␕Ｐ)\rω］７,｜␛%＝ν2\vφ␝'",
	}, { // 2487
		mask: EncodeSquareBracket | EncodeRightSpace,
		in:   "␌ :９*Ｏ␙0␗ρ ρ␕Ｐ)\rω]７,｜␛%＝ν2\vφ␠'",
		out:  "␌ :９*Ｏ␙0␗ρ ρ␕Ｐ)\rω］７,｜␛%＝ν2\vφ␠'",
	}, { // 2488
		mask: EncodeSquareBracket | EncodeRightSpace,
		in:   "␌␠:９*Ｏ␙0␗ρ ρ␕Ｐ)\rω]７,｜␛%＝ν2\vφ␠'",
		out:  "␌␠:９*Ｏ␙0␗ρ ρ␕Ｐ)\rω］７,｜␛%＝ν2\vφ␠'",
	}, { // 2489
		mask: EncodeSquareBracket | EncodeRightSpace,
		in:   "␌ :９*Ｏ␙0␗ρ ρ␕Ｐ)\rω]７,｜␛%＝ν2\vφ␝␠",
		out:  "␌ :９*Ｏ␙0␗ρ ρ␕Ｐ)\rω］７,｜␛%＝ν2\vφ␝‛␠",
	}, { // 2490
		mask: EncodeSquareBracket | EncodeRightSpace,
		in:   "␌␠:９*Ｏ␙0␗ρ ρ␕Ｐ)\rω]７,｜␛%＝ν2\vφ␝␠",
		out:  "␌␠:９*Ｏ␙0␗ρ ρ␕Ｐ)\rω］７,｜␛%＝ν2\vφ␝‛␠",
	}, { // 2491
		mask: EncodeSquareBracket | EncodeRightSpace,
		in:   "␌υ:９*Ｏ␙0␗ρ ρ␕Ｐ)\rω]７,｜␛%＝ν2\vφ '",
		out:  "␌υ:９*Ｏ␙0␗ρ ρ␕Ｐ)\rω］７,｜␛%＝ν2\vφ '",
	}, { // 2492
		mask: EncodeSquareBracket | EncodeRightSpace,
		in:   "␌υ:９*Ｏ␙0␗ρ ρ␕Ｐ)\rω]７,｜␛%＝ν2\vφ␠'",
		out:  "␌υ:９*Ｏ␙0␗ρ ρ␕Ｐ)\rω］７,｜␛%＝ν2\vφ␠'",
	}, { // 2493
		mask: EncodeSquareBracket | EncodeRightSpace,
		in:   "␌υ:９*Ｏ␙0␗ρ ρ␕Ｐ)\rω]７,｜␛%＝ν2\vφ ␠",
		out:  "␌υ:９*Ｏ␙0␗ρ ρ␕Ｐ)\rω］７,｜␛%＝ν2\vφ ‛␠",
	}, { // 2494
		mask: EncodeSquareBracket | EncodeRightSpace,
		in:   "␌υ:９*Ｏ␙0␗ρ ρ␕Ｐ)\rω]７,｜␛%＝ν2\vφ␠␠",
		out:  "␌υ:９*Ｏ␙0␗ρ ρ␕Ｐ)\rω］７,｜␛%＝ν2\vφ␠‛␠",
	}, { // 2495
		mask: EncodeSquareBracket | EncodeRightSpace,
		in:   "␌υ:９*Ｏ␙0␗ρ ρ␕Ｐ)\rω]７,｜␛%＝ν2\vφ␝ ",
		out:  "␌υ:９*Ｏ␙0␗ρ ρ␕Ｐ)\rω］７,｜␛%＝ν2\vφ␝␠",
	}, { // 2496
		mask: EncodeSquareBracket | EncodeRightSpace,
		in:   "␌υ:９*Ｏ␙0␗ρ ρ␕Ｐ)\rω]７,｜␛%＝ν2\vφ␝␠",
		out:  "␌υ:９*Ｏ␙0␗ρ ρ␕Ｐ)\rω］７,｜␛%＝ν2\vφ␝‛␠",
	}, { // 2497
		mask: EncodeSemicolon | EncodeRightSpace,
		in:   "７\x17ι<kTζc\x1d␉ ｅgｊτ␔｜？ｐ-␒Ｋ\x0f*β\x15ψ#␈σ",
		out:  "７\x17ι<kTζc\x1d␉ ｅgｊτ␔｜？ｐ-␒Ｋ\x0f*β\x15ψ#␈σ",
	}, { // 2498
		mask: EncodeSemicolon | EncodeRightSpace,
		in:   " ␠ι<kTζc\x1d␉ ｅgｊτ␔｜？ｐ-␒Ｋ\x0f*β\x15ψ#␈σ",
		out:  " ␠ι<kTζc\x1d␉ ｅgｊτ␔｜？ｐ-␒Ｋ\x0f*β\x15ψ#␈σ",
	}, { // 2499
		mask: EncodeSemicolon | EncodeRightSpace,
		in:   "␠␠ι<kTζc\x1d␉ ｅgｊτ␔｜？ｐ-␒Ｋ\x0f*β\x15ψ#␈σ",
		out:  "␠␠ι<kTζc\x1d␉ ｅgｊτ␔｜？ｐ-␒Ｋ\x0f*β\x15ψ#␈σ",
	}, { // 2500
		mask: EncodeSemicolon | EncodeRightSpace,
		in:   " \x17ι<kTζc\x1d␉ ｅgｊτ␔｜？ｐ-␒Ｋ\x0f*β\x15ψ#␠σ",
		out:  " \x17ι<kTζc\x1d␉ ｅgｊτ␔｜？ｐ-␒Ｋ\x0f*β\x15ψ#␠σ",
	}, { // 2501
		mask: EncodeSemicolon | EncodeRightSpace,
		in:   "␠\x17ι<kTζc\x1d␉ ｅgｊτ␔｜？ｐ-␒Ｋ\x0f*β\x15ψ#␠σ",
		out:  "␠\x17ι<kTζc\x1d␉ ｅgｊτ␔｜？ｐ-␒Ｋ\x0f*β\x15ψ#␠σ",
	}, { // 2502
		mask: EncodeSemicolon | EncodeRightSpace,
		in:   " \x17ι<kTζc\x1d␉ ｅgｊτ␔｜？ｐ-␒Ｋ\x0f*β\x15ψ#␈␠",
		out:  " \x17ι<kTζc\x1d␉ ｅgｊτ␔｜？ｐ-␒Ｋ\x0f*β\x15ψ#␈‛␠",
	}, { // 2503
		mask: EncodeSemicolon | EncodeRightSpace,
		in:   "␠\x17ι<kTζc\x1d␉ ｅgｊτ␔｜？ｐ-␒Ｋ\x0f*β\x15ψ#␈␠",
		out:  "␠\x17ι<kTζc\x1d␉ ｅgｊτ␔｜？ｐ-␒Ｋ\x0f*β\x15ψ#␈‛␠",
	}, { // 2504
		mask: EncodeSemicolon | EncodeRightSpace,
		in:   "７ ι<kTζc\x1d␉ ｅgｊτ␔｜？ｐ-␒Ｋ\x0f*β\x15ψ#␈σ",
		out:  "７ ι<kTζc\x1d␉ ｅgｊτ␔｜？ｐ-␒Ｋ\x0f*β\x15ψ#␈σ",
	}, { // 2505
		mask: EncodeSemicolon | EncodeRightSpace,
		in:   "７␠ι<kTζc\x1d␉ ｅgｊτ␔｜？ｐ-␒Ｋ\x0f*β\x15ψ#␈σ",
		out:  "７␠ι<kTζc\x1d␉ ｅgｊτ␔｜？ｐ-␒Ｋ\x0f*β\x15ψ#␈σ",
	}, { // 2506
		mask: EncodeSemicolon | EncodeRightSpace,
		in:   "７ ι<kTζc\x1d␉ ｅgｊτ␔｜？ｐ-␒Ｋ\x0f*β\x15ψ#␠σ",
		out:  "７ ι<kTζc\x1d␉ ｅgｊτ␔｜？ｐ-␒Ｋ\x0f*β\x15ψ#␠σ",
	}, { // 2507
		mask: EncodeSemicolon | EncodeRightSpace,
		in:   "７␠ι<kTζc\x1d␉ ｅgｊτ␔｜？ｐ-␒Ｋ\x0f*β\x15ψ#␠σ",
		out:  "７␠ι<kTζc\x1d␉ ｅgｊτ␔｜？ｐ-␒Ｋ\x0f*β\x15ψ#␠σ",
	}, { // 2508
		mask: EncodeSemicolon | EncodeRightSpace,
		in:   "７ ι<kTζc\x1d␉ ｅgｊτ␔｜？ｐ-␒Ｋ\x0f*β\x15ψ#␈␠",
		out:  "７ ι<kTζc\x1d␉ ｅgｊτ␔｜？ｐ-␒Ｋ\x0f*β\x15ψ#␈‛␠",
	}, { // 2509
		mask: EncodeSemicolon | EncodeRightSpace,
		in:   "７␠ι<kTζc\x1d␉ ｅgｊτ␔｜？ｐ-␒Ｋ\x0f*β\x15ψ#␈␠",
		out:  "７␠ι<kTζc\x1d␉ ｅgｊτ␔｜？ｐ-␒Ｋ\x0f*β\x15ψ#␈‛␠",
	}, { // 2510
		mask: EncodeSemicolon | EncodeRightSpace,
		in:   "７\x17ι<kTζc\x1d␉ ｅgｊτ␔｜？ｐ-␒Ｋ\x0f*β\x15ψ# σ",
		out:  "７\x17ι<kTζc\x1d␉ ｅgｊτ␔｜？ｐ-␒Ｋ\x0f*β\x15ψ# σ",
	}, { // 2511
		mask: EncodeSemicolon | EncodeRightSpace,
		in:   "７\x17ι<kTζc\x1d␉ ｅgｊτ␔｜？ｐ-␒Ｋ\x0f*β\x15ψ#␠σ",
		out:  "７\x17ι<kTζc\x1d␉ ｅgｊτ␔｜？ｐ-␒Ｋ\x0f*β\x15ψ#␠σ",
	}, { // 2512
		mask: EncodeSemicolon | EncodeRightSpace,
		in:   "７\x17ι<kTζc\x1d␉ ｅgｊτ␔｜？ｐ-␒Ｋ\x0f*β\x15ψ# ␠",
		out:  "７\x17ι<kTζc\x1d␉ ｅgｊτ␔｜？ｐ-␒Ｋ\x0f*β\x15ψ# ‛␠",
	}, { // 2513
		mask: EncodeSemicolon | EncodeRightSpace,
		in:   "７\x17ι<kTζc\x1d␉ ｅgｊτ␔｜？ｐ-␒Ｋ\x0f*β\x15ψ#␠␠",
		out:  "７\x17ι<kTζc\x1d␉ ｅgｊτ␔｜？ｐ-␒Ｋ\x0f*β\x15ψ#␠‛␠",
	}, { // 2514
		mask: EncodeSemicolon | EncodeRightSpace,
		in:   "７\x17ι<kTζc\x1d␉ ｅgｊτ␔｜？ｐ-␒Ｋ\x0f*β\x15ψ#␈ ",
		out:  "７\x17ι<kTζc\x1d␉ ｅgｊτ␔｜？ｐ-␒Ｋ\x0f*β\x15ψ#␈␠",
	}, { // 2515
		mask: EncodeSemicolon | EncodeRightSpace,
		in:   "７\x17ι<kTζc\x1d␉ ｅgｊτ␔｜？ｐ-␒Ｋ\x0f*β\x15ψ#␈␠",
		out:  "７\x17ι<kTζc\x1d␉ ｅgｊτ␔｜？ｐ-␒Ｋ\x0f*β\x15ψ#␈‛␠",
	}, { // 2516
		mask: EncodeDollar | EncodeRightSpace,
		in:   "$δ|];\x04\x12（πμ \\.ς␋␘ε\a＿ｔ？χ␏Ｖ␅＇＼i？5",
		out:  "＄δ|];\x04\x12（πμ \\.ς␋␘ε\a＿ｔ？χ␏Ｖ␅＇＼i？5",
	}, { // 2517
		mask: EncodeDollar | EncodeRightSpace,
		in:   " ␠|];\x04\x12（πμ \\.ς␋␘ε\a＿ｔ？χ␏Ｖ␅＇＼i？5",
		out:  " ␠|];\x04\x12（πμ \\.ς␋␘ε\a＿ｔ？χ␏Ｖ␅＇＼i？5",
	}, { // 2518
		mask: EncodeDollar | EncodeRightSpace,
		in:   "␠␠|];\x04\x12（πμ \\.ς␋␘ε\a＿ｔ？χ␏Ｖ␅＇＼i？5",
		out:  "␠␠|];\x04\x12（πμ \\.ς␋␘ε\a＿ｔ？χ␏Ｖ␅＇＼i？5",
	}, { // 2519
		mask: EncodeDollar | EncodeRightSpace,
		in:   " δ|];\x04\x12（πμ \\.ς␋␘ε\a＿ｔ？χ␏Ｖ␅＇＼i␠5",
		out:  " δ|];\x04\x12（πμ \\.ς␋␘ε\a＿ｔ？χ␏Ｖ␅＇＼i␠5",
	}, { // 2520
		mask: EncodeDollar | EncodeRightSpace,
		in:   "␠δ|];\x04\x12（πμ \\.ς␋␘ε\a＿ｔ？χ␏Ｖ␅＇＼i␠5",
		out:  "␠δ|];\x04\x12（πμ \\.ς␋␘ε\a＿ｔ？χ␏Ｖ␅＇＼i␠5",
	}, { // 2521
		mask: EncodeDollar | EncodeRightSpace,
		in:   " δ|];\x04\x12（πμ \\.ς␋␘ε\a＿ｔ？χ␏Ｖ␅＇＼i？␠",
		out:  " δ|];\x04\x12（πμ \\.ς␋␘ε\a＿ｔ？χ␏Ｖ␅＇＼i？‛␠",
	}, { // 2522
		mask: EncodeDollar | EncodeRightSpace,
		in:   "␠δ|];\x04\x12（πμ \\.ς␋␘ε\a＿ｔ？χ␏Ｖ␅＇＼i？␠",
		out:  "␠δ|];\x04\x12（πμ \\.ς␋␘ε\a＿ｔ？χ␏Ｖ␅＇＼i？‛␠",
	}, { // 2523
		mask: EncodeDollar | EncodeRightSpace,
		in:   "$ |];\x04\x12（πμ \\.ς␋␘ε\a＿ｔ？χ␏Ｖ␅＇＼i？5",
		out:  "＄ |];\x04\x12（πμ \\.ς␋␘ε\a＿ｔ？χ␏Ｖ␅＇＼i？5",
	}, { // 2524
		mask: EncodeDollar | EncodeRightSpace,
		in:   "$␠|];\x04\x12（πμ \\.ς␋␘ε\a＿ｔ？χ␏Ｖ␅＇＼i？5",
		out:  "＄␠|];\x04\x12（πμ \\.ς␋␘ε\a＿ｔ？χ␏Ｖ␅＇＼i？5",
	}, { // 2525
		mask: EncodeDollar | EncodeRightSpace,
		in:   "$ |];\x04\x12（πμ \\.ς␋␘ε\a＿ｔ？χ␏Ｖ␅＇＼i␠5",
		out:  "＄ |];\x04\x12（πμ \\.ς␋␘ε\a＿ｔ？χ␏Ｖ␅＇＼i␠5",
	}, { // 2526
		mask: EncodeDollar | EncodeRightSpace,
		in:   "$␠|];\x04\x12（πμ \\.ς␋␘ε\a＿ｔ？χ␏Ｖ␅＇＼i␠5",
		out:  "＄␠|];\x04\x12（πμ \\.ς␋␘ε\a＿ｔ？χ␏Ｖ␅＇＼i␠5",
	}, { // 2527
		mask: EncodeDollar | EncodeRightSpace,
		in:   "$ |];\x04\x12（πμ \\.ς␋␘ε\a＿ｔ？χ␏Ｖ␅＇＼i？␠",
		out:  "＄ |];\x04\x12（πμ \\.ς␋␘ε\a＿ｔ？χ␏Ｖ␅＇＼i？‛␠",
	}, { // 2528
		mask: EncodeDollar | EncodeRightSpace,
		in:   "$␠|];\x04\x12（πμ \\.ς␋␘ε\a＿ｔ？χ␏Ｖ␅＇＼i？␠",
		out:  "＄␠|];\x04\x12（πμ \\.ς␋␘ε\a＿ｔ？χ␏Ｖ␅＇＼i？‛␠",
	}, { // 2529
		mask: EncodeDollar | EncodeRightSpace,
		in:   "$δ|];\x04\x12（πμ \\.ς␋␘ε\a＿ｔ？χ␏Ｖ␅＇＼i 5",
		out:  "＄δ|];\x04\x12（πμ \\.ς␋␘ε\a＿ｔ？χ␏Ｖ␅＇＼i 5",
	}, { // 2530
		mask: EncodeDollar | EncodeRightSpace,
		in:   "$δ|];\x04\x12（πμ \\.ς␋␘ε\a＿ｔ？χ␏Ｖ␅＇＼i␠5",
		out:  "＄δ|];\x04\x12（πμ \\.ς␋␘ε\a＿ｔ？χ␏Ｖ␅＇＼i␠5",
	}, { // 2531
		mask: EncodeDollar | EncodeRightSpace,
		in:   "$δ|];\x04\x12（πμ \\.ς␋␘ε\a＿ｔ？χ␏Ｖ␅＇＼i ␠",
		out:  "＄δ|];\x04\x12（πμ \\.ς␋␘ε\a＿ｔ？χ␏Ｖ␅＇＼i ‛␠",
	}, { // 2532
		mask: EncodeDollar | EncodeRightSpace,
		in:   "$δ|];\x04\x12（πμ \\.ς␋␘ε\a＿ｔ？χ␏Ｖ␅＇＼i␠␠",
		out:  "＄δ|];\x04\x12（πμ \\.ς␋␘ε\a＿ｔ？χ␏Ｖ␅＇＼i␠‛␠",
	}, { // 2533
		mask: EncodeDollar | EncodeRightSpace,
		in:   "$δ|];\x04\x12（πμ \\.ς␋␘ε\a＿ｔ？χ␏Ｖ␅＇＼i？ ",
		out:  "＄δ|];\x04\x12（πμ \\.ς␋␘ε\a＿ｔ？χ␏Ｖ␅＇＼i？␠",
	}, { // 2534
		mask: EncodeDollar | EncodeRightSpace,
		in:   "$δ|];\x04\x12（πμ \\.ς␋␘ε\a＿ｔ？χ␏Ｖ␅＇＼i？␠",
		out:  "＄δ|];\x04\x12（πμ \\.ς␋␘ε\a＿ｔ？χ␏Ｖ␅＇＼i？‛␠",
	}, { // 2535
		mask: EncodeDoubleQuote | EncodeRightSpace,
		in:   "υPPｇ）\x16η`ε\x17 υ,␐π\x1a]␆］κｚQ，␛｀，7＊\x17\b",
		out:  "υPPｇ）\x16η`ε\x17 υ,␐π\x1a]␆］κｚQ，␛｀，7＊\x17\b",
	}, { // 2536
		mask: EncodeDoubleQuote | EncodeRightSpace,
		in:   " ␠Pｇ）\x16η`ε\x17 υ,␐π\x1a]␆］κｚQ，␛｀，7＊\x17\b",
		out:  " ␠Pｇ）\x16η`ε\x17 υ,␐π\x1a]␆］κｚQ，␛｀，7＊\x17\b",
	}, { // 2537
		mask: EncodeDoubleQuote | EncodeRightSpace,
		in:   "␠␠Pｇ）\x16η`ε\x17 υ,␐π\x1a]␆］κｚQ，␛｀，7＊\x17\b",
		out:  "␠␠Pｇ）\x16η`ε\x17 υ,␐π\x1a]␆］κｚQ，␛｀，7＊\x17\b",
	}, { // 2538
		mask: EncodeDoubleQuote | EncodeRightSpace,
		in:   " PPｇ）\x16η`ε\x17 υ,␐π\x1a]␆］κｚQ，␛｀，7＊␠\b",
		out:  " PPｇ）\x16η`ε\x17 υ,␐π\x1a]␆］κｚQ，␛｀，7＊␠\b",
	}, { // 2539
		mask: EncodeDoubleQuote | EncodeRightSpace,
		in:   "␠PPｇ）\x16η`ε\x17 υ,␐π\x1a]␆］κｚQ，␛｀，7＊␠\b",
		out:  "␠PPｇ）\x16η`ε\x17 υ,␐π\x1a]␆］κｚQ，␛｀，7＊␠\b",
	}, { // 2540
		mask: EncodeDoubleQuote | EncodeRightSpace,
		in:   " PPｇ）\x16η`ε\x17 υ,␐π\x1a]␆］κｚQ，␛｀，7＊\x17␠",
		out:  " PPｇ）\x16η`ε\x17 υ,␐π\x1a]␆］κｚQ，␛｀，7＊\x17‛␠",
	}, { // 2541
		mask: EncodeDoubleQuote | EncodeRightSpace,
		in:   "␠PPｇ）\x16η`ε\x17 υ,␐π\x1a]␆］κｚQ，␛｀，7＊\x17␠",
		out:  "␠PPｇ）\x16η`ε\x17 υ,␐π\x1a]␆］κｚQ，␛｀，7＊\x17‛␠",
	}, { // 2542
		mask: EncodeDoubleQuote | EncodeRightSpace,
		in:   "υ Pｇ）\x16η`ε\x17 υ,␐π\x1a]␆］κｚQ，␛｀，7＊\x17\b",
		out:  "υ Pｇ）\x16η`ε\x17 υ,␐π\x1a]␆］κｚQ，␛｀，7＊\x17\b",
	}, { // 2543
		mask: EncodeDoubleQuote | EncodeRightSpace,
		in:   "υ␠Pｇ）\x16η`ε\x17 υ,␐π\x1a]␆］κｚQ，␛｀，7＊\x17\b",
		out:  "υ␠Pｇ）\x16η`ε\x17 υ,␐π\x1a]␆］κｚQ，␛｀，7＊\x17\b",
	}, { // 2544
		mask: EncodeDoubleQuote | EncodeRightSpace,
		in:   "υ Pｇ）\x16η`ε\x17 υ,␐π\x1a]␆］κｚQ，␛｀，7＊␠\b",
		out:  "υ Pｇ）\x16η`ε\x17 υ,␐π\x1a]␆］κｚQ，␛｀，7＊␠\b",
	}, { // 2545
		mask: EncodeDoubleQuote | EncodeRightSpace,
		in:   "υ␠Pｇ）\x16η`ε\x17 υ,␐π\x1a]␆］κｚQ，␛｀，7＊␠\b",
		out:  "υ␠Pｇ）\x16η`ε\x17 υ,␐π\x1a]␆］κｚQ，␛｀，7＊␠\b",
	}, { // 2546
		mask: EncodeDoubleQuote | EncodeRightSpace,
		in:   "υ Pｇ）\x16η`ε\x17 υ,␐π\x1a]␆］κｚQ，␛｀，7＊\x17␠",
		out:  "υ Pｇ）\x16η`ε\x17 υ,␐π\x1a]␆］κｚQ，␛｀，7＊\x17‛␠",
	}, { // 2547
		mask: EncodeDoubleQuote | EncodeRightSpace,
		in:   "υ␠Pｇ）\x16η`ε\x17 υ,␐π\x1a]␆］κｚQ，␛｀，7＊\x17␠",
		out:  "υ␠Pｇ）\x16η`ε\x17 υ,␐π\x1a]␆］κｚQ，␛｀，7＊\x17‛␠",
	}, { // 2548
		mask: EncodeDoubleQuote | EncodeRightSpace,
		in:   "υPPｇ）\x16η`ε\x17 υ,␐π\x1a]␆］κｚQ，␛｀，7＊ \b",
		out:  "υPPｇ）\x16η`ε\x17 υ,␐π\x1a]␆］κｚQ，␛｀，7＊ \b",
	}, { // 2549
		mask: EncodeDoubleQuote | EncodeRightSpace,
		in:   "υPPｇ）\x16η`ε\x17 υ,␐π\x1a]␆］κｚQ，␛｀，7＊␠\b",
		out:  "υPPｇ）\x16η`ε\x17 υ,␐π\x1a]␆］κｚQ，␛｀，7＊␠\b",
	}, { // 2550
		mask: EncodeDoubleQuote | EncodeRightSpace,
		in:   "υPPｇ）\x16η`ε\x17 υ,␐π\x1a]␆］κｚQ，␛｀，7＊ ␠",
		out:  "υPPｇ）\x16η`ε\x17 υ,␐π\x1a]␆］κｚQ，␛｀，7＊ ‛␠",
	}, { // 2551
		mask: EncodeDoubleQuote | EncodeRightSpace,
		in:   "υPPｇ）\x16η`ε\x17 υ,␐π\x1a]␆］κｚQ，␛｀，7＊␠␠",
		out:  "υPPｇ）\x16η`ε\x17 υ,␐π\x1a]␆］κｚQ，␛｀，7＊␠‛␠",
	}, { // 2552
		mask: EncodeDoubleQuote | EncodeRightSpace,
		in:   "υPPｇ）\x16η`ε\x17 υ,␐π\x1a]␆］κｚQ，␛｀，7＊\x17 ",
		out:  "υPPｇ）\x16η`ε\x17 υ,␐π\x1a]␆］κｚQ，␛｀，7＊\x17␠",
	}, { // 2553
		mask: EncodeDoubleQuote | EncodeRightSpace,
		in:   "υPPｇ）\x16η`ε\x17 υ,␐π\x1a]␆］κｚQ，␛｀，7＊\x17␠",
		out:  "υPPｇ）\x16η`ε\x17 υ,␐π\x1a]␆］κｚQ，␛｀，7＊\x17‛␠",
	}, { // 2554
		mask: EncodeColon | EncodeRightSpace,
		in:   "%ν＜π!ｚ␏］Ｆ{ ；Ｓ%ο=\u007f␎ｅζa␄a%\bγ\x18＿.τ",
		out:  "%ν＜π!ｚ␏］Ｆ{ ；Ｓ%ο=\u007f␎ｅζa␄a%\bγ\x18＿.τ",
	}, { // 2555
		mask: EncodeColon | EncodeRightSpace,
		in:   " ␠＜π!ｚ␏］Ｆ{ ；Ｓ%ο=\u007f␎ｅζa␄a%\bγ\x18＿.τ",
		out:  " ␠＜π!ｚ␏］Ｆ{ ；Ｓ%ο=\u007f␎ｅζa␄a%\bγ\x18＿.τ",
	}, { // 2556
		mask: EncodeColon | EncodeRightSpace,
		in:   "␠␠＜π!ｚ␏］Ｆ{ ；Ｓ%ο=\u007f␎ｅζa␄a%\bγ\x18＿.τ",
		out:  "␠␠＜π!ｚ␏］Ｆ{ ；Ｓ%ο=\u007f␎ｅζa␄a%\bγ\x18＿.τ",
	}, { // 2557
		mask: EncodeColon | EncodeRightSpace,
		in:   " ν＜π!ｚ␏］Ｆ{ ；Ｓ%ο=\u007f␎ｅζa␄a%\bγ\x18＿␠τ",
		out:  " ν＜π!ｚ␏］Ｆ{ ；Ｓ%ο=\u007f␎ｅζa␄a%\bγ\x18＿␠τ",
	}, { // 2558
		mask: EncodeColon | EncodeRightSpace,
		in:   "␠ν＜π!ｚ␏］Ｆ{ ；Ｓ%ο=\u007f␎ｅζa␄a%\bγ\x18＿␠τ",
		out:  "␠ν＜π!ｚ␏］Ｆ{ ；Ｓ%ο=\u007f␎ｅζa␄a%\bγ\x18＿␠τ",
	}, { // 2559
		mask: EncodeColon | EncodeRightSpace,
		in:   " ν＜π!ｚ␏］Ｆ{ ；Ｓ%ο=\u007f␎ｅζa␄a%\bγ\x18＿.␠",
		out:  " ν＜π!ｚ␏］Ｆ{ ；Ｓ%ο=\u007f␎ｅζa␄a%\bγ\x18＿.‛␠",
	}, { // 2560
		mask: EncodeColon | EncodeRightSpace,
		in:   "␠ν＜π!ｚ␏］Ｆ{ ；Ｓ%ο=\u007f␎ｅζa␄a%\bγ\x18＿.␠",
		out:  "␠ν＜π!ｚ␏］Ｆ{ ；Ｓ%ο=\u007f␎ｅζa␄a%\bγ\x18＿.‛␠",
	}, { // 2561
		mask: EncodeColon | EncodeRightSpace,
		in:   "% ＜π!ｚ␏］Ｆ{ ；Ｓ%ο=\u007f␎ｅζa␄a%\bγ\x18＿.τ",
		out:  "% ＜π!ｚ␏］Ｆ{ ；Ｓ%ο=\u007f␎ｅζa␄a%\bγ\x18＿.τ",
	}, { // 2562
		mask: EncodeColon | EncodeRightSpace,
		in:   "%␠＜π!ｚ␏］Ｆ{ ；Ｓ%ο=\u007f␎ｅζa␄a%\bγ\x18＿.τ",
		out:  "%␠＜π!ｚ␏］Ｆ{ ；Ｓ%ο=\u007f␎ｅζa␄a%\bγ\x18＿.τ",
	}, { // 2563
		mask: EncodeColon | EncodeRightSpace,
		in:   "% ＜π!ｚ␏］Ｆ{ ；Ｓ%ο=\u007f␎ｅζa␄a%\bγ\x18＿␠τ",
		out:  "% ＜π!ｚ␏］Ｆ{ ；Ｓ%ο=\u007f␎ｅζa␄a%\bγ\x18＿␠τ",
	}, { // 2564
		mask: EncodeColon | EncodeRightSpace,
		in:   "%␠＜π!ｚ␏］Ｆ{ ；Ｓ%ο=\u007f␎ｅζa␄a%\bγ\x18＿␠τ",
		out:  "%␠＜π!ｚ␏］Ｆ{ ；Ｓ%ο=\u007f␎ｅζa␄a%\bγ\x18＿␠τ",
	}, { // 2565
		mask: EncodeColon | EncodeRightSpace,
		in:   "% ＜π!ｚ␏］Ｆ{ ；Ｓ%ο=\u007f␎ｅζa␄a%\bγ\x18＿.␠",
		out:  "% ＜π!ｚ␏］Ｆ{ ；Ｓ%ο=\u007f␎ｅζa␄a%\bγ\x18＿.‛␠",
	}, { // 2566
		mask: EncodeColon | EncodeRightSpace,
		in:   "%␠＜π!ｚ␏］Ｆ{ ；Ｓ%ο=\u007f␎ｅζa␄a%\bγ\x18＿.␠",
		out:  "%␠＜π!ｚ␏］Ｆ{ ；Ｓ%ο=\u007f␎ｅζa␄a%\bγ\x18＿.‛␠",
	}, { // 2567
		mask: EncodeColon | EncodeRightSpace,
		in:   "%ν＜π!ｚ␏］Ｆ{ ；Ｓ%ο=\u007f␎ｅζa␄a%\bγ\x18＿ τ",
		out:  "%ν＜π!ｚ␏］Ｆ{ ；Ｓ%ο=\u007f␎ｅζa␄a%\bγ\x18＿ τ",
	}, { // 2568
		mask: EncodeColon | EncodeRightSpace,
		in:   "%ν＜π!ｚ␏］Ｆ{ ；Ｓ%ο=\u007f␎ｅζa␄a%\bγ\x18＿␠τ",
		out:  "%ν＜π!ｚ␏］Ｆ{ ；Ｓ%ο=\u007f␎ｅζa␄a%\bγ\x18＿␠τ",
	}, { // 2569
		mask: EncodeColon | EncodeRightSpace,
		in:   "%ν＜π!ｚ␏］Ｆ{ ；Ｓ%ο=\u007f␎ｅζa␄a%\bγ\x18＿ ␠",
		out:  "%ν＜π!ｚ␏］Ｆ{ ；Ｓ%ο=\u007f␎ｅζa␄a%\bγ\x18＿ ‛␠",
	}, { // 2570
		mask: EncodeColon | EncodeRightSpace,
		in:   "%ν＜π!ｚ␏］Ｆ{ ；Ｓ%ο=\u007f␎ｅζa␄a%\bγ\x18＿␠␠",
		out:  "%ν＜π!ｚ␏］Ｆ{ ；Ｓ%ο=\u007f␎ｅζa␄a%\bγ\x18＿␠‛␠",
	}, { // 2571
		mask: EncodeColon | EncodeRightSpace,
		in:   "%ν＜π!ｚ␏］Ｆ{ ；Ｓ%ο=\u007f␎ｅζa␄a%\bγ\x18＿. ",
		out:  "%ν＜π!ｚ␏］Ｆ{ ；Ｓ%ο=\u007f␎ｅζa␄a%\bγ\x18＿.␠",
	}, { // 2572
		mask: EncodeColon | EncodeRightSpace,
		in:   "%ν＜π!ｚ␏］Ｆ{ ；Ｓ%ο=\u007f␎ｅζa␄a%\bγ\x18＿.␠",
		out:  "%ν＜π!ｚ␏］Ｆ{ ；Ｓ%ο=\u007f␎ｅζa␄a%\bγ\x18＿.‛␠",
	}, { // 2573
		mask: EncodeQuestion | EncodeRightSpace,
		in:   "ｙ␝ #\"σ␔Oω\uff00 ␖σξｕ$（４9\x15gＤ\bδτ␙~\x00␋+",
		out:  "ｙ␝ #\"σ␔Oω\uff00 ␖σξｕ$（４9\x15gＤ\bδτ␙~␀␋+",
	}, { // 2574
		mask: EncodeQuestion | EncodeRightSpace,
		in:   " ␠ #\"σ␔Oω\uff00 ␖σξｕ$（４9\x15gＤ\bδτ␙~\x00␋+",
		out:  " ␠ #\"σ␔Oω\uff00 ␖σξｕ$（４9\x15gＤ\bδτ␙~␀␋+",
	}, { // 2575
		mask: EncodeQuestion | EncodeRightSpace,
		in:   "␠␠ #\"σ␔Oω\uff00 ␖σξｕ$（４9\x15gＤ\bδτ␙~\x00␋+",
		out:  "␠␠ #\"σ␔Oω\uff00 ␖σξｕ$（４9\x15gＤ\bδτ␙~␀␋+",
	}, { // 2576
		mask: EncodeQuestion | EncodeRightSpace,
		in:   " ␝ #\"σ␔Oω\uff00 ␖σξｕ$（４9\x15gＤ\bδτ␙~\x00␠+",
		out:  " ␝ #\"σ␔Oω\uff00 ␖σξｕ$（４9\x15gＤ\bδτ␙~␀␠+",
	}, { // 2577
		mask: EncodeQuestion | EncodeRightSpace,
		in:   "␠␝ #\"σ␔Oω\uff00 ␖σξｕ$（４9\x15gＤ\bδτ␙~\x00␠+",
		out:  "␠␝ #\"σ␔Oω\uff00 ␖σξｕ$（４9\x15gＤ\bδτ␙~␀␠+",
	}, { // 2578
		mask: EncodeQuestion | EncodeRightSpace,
		in:   " ␝ #\"σ␔Oω\uff00 ␖σξｕ$（４9\x15gＤ\bδτ␙~\x00␋␠",
		out:  " ␝ #\"σ␔Oω\uff00 ␖σξｕ$（４9\x15gＤ\bδτ␙~␀␋‛␠",
	}, { // 2579
		mask: EncodeQuestion | EncodeRightSpace,
		in:   "␠␝ #\"σ␔Oω\uff00 ␖σξｕ$（４9\x15gＤ\bδτ␙~\x00␋␠",
		out:  "␠␝ #\"σ␔Oω\uff00 ␖σξｕ$（４9\x15gＤ\bδτ␙~␀␋‛␠",
	}, { // 2580
		mask: EncodeQuestion | EncodeRightSpace,
		in:   "ｙ  #\"σ␔Oω\uff00 ␖σξｕ$（４9\x15gＤ\bδτ␙~\x00␋+",
		out:  "ｙ  #\"σ␔Oω\uff00 ␖σξｕ$（４9\x15gＤ\bδτ␙~␀␋+",
	}, { // 2581
		mask: EncodeQuestion | EncodeRightSpace,
		in:   "ｙ␠ #\"σ␔Oω\uff00 ␖σξｕ$（４9\x15gＤ\bδτ␙~\x00␋+",
		out:  "ｙ␠ #\"σ␔Oω\uff00 ␖σξｕ$（４9\x15gＤ\bδτ␙~␀␋+",
	}, { // 2582
		mask: EncodeQuestion | EncodeRightSpace,
		in:   "ｙ  #\"σ␔Oω\uff00 ␖σξｕ$（４9\x15gＤ\bδτ␙~\x00␠+",
		out:  "ｙ  #\"σ␔Oω\uff00 ␖σξｕ$（４9\x15gＤ\bδτ␙~␀␠+",
	}, { // 2583
		mask: EncodeQuestion | EncodeRightSpace,
		in:   "ｙ␠ #\"σ␔Oω\uff00 ␖σξｕ$（４9\x15gＤ\bδτ␙~\x00␠+",
		out:  "ｙ␠ #\"σ␔Oω\uff00 ␖σξｕ$（４9\x15gＤ\bδτ␙~␀␠+",
	}, { // 2584
		mask: EncodeQuestion | EncodeRightSpace,
		in:   "ｙ  #\"σ␔Oω\uff00 ␖σξｕ$（４9\x15gＤ\bδτ␙~\x00␋␠",
		out:  "ｙ  #\"σ␔Oω\uff00 ␖σξｕ$（４9\x15gＤ\bδτ␙~␀␋‛␠",
	}, { // 2585
		mask: EncodeQuestion | EncodeRightSpace,
		in:   "ｙ␠ #\"σ␔Oω\uff00 ␖σξｕ$（４9\x15gＤ\bδτ␙~\x00␋␠",
		out:  "ｙ␠ #\"σ␔Oω\uff00 ␖σξｕ$（４9\x15gＤ\bδτ␙~␀␋‛␠",
	}, { // 2586
		mask: EncodeQuestion | EncodeRightSpace,
		in:   "ｙ␝ #\"σ␔Oω\uff00 ␖σξｕ$（４9\x15gＤ\bδτ␙~\x00 +",
		out:  "ｙ␝ #\"σ␔Oω\uff00 ␖σξｕ$（４9\x15gＤ\bδτ␙~␀ +",
	}, { // 2587
		mask: EncodeQuestion | EncodeRightSpace,
		in:   "ｙ␝ #\"σ␔Oω\uff00 ␖σξｕ$（４9\x15gＤ\bδτ␙~\x00␠+",
		out:  "ｙ␝ #\"σ␔Oω\uff00 ␖σξｕ$（４9\x15gＤ\bδτ␙~␀␠+",
	}, { // 2588
		mask: EncodeQuestion | EncodeRightSpace,
		in:   "ｙ␝ #\"σ␔Oω\uff00 ␖σξｕ$（４9\x15gＤ\bδτ␙~\x00 ␠",
		out:  "ｙ␝ #\"σ␔Oω\uff00 ␖σξｕ$（４9\x15gＤ\bδτ␙~␀ ‛␠",
	}, { // 2589
		mask: EncodeQuestion | EncodeRightSpace,
		in:   "ｙ␝ #\"σ␔Oω\uff00 ␖σξｕ$（４9\x15gＤ\bδτ␙~\x00␠␠",
		out:  "ｙ␝ #\"σ␔Oω\uff00 ␖σξｕ$（４9\x15gＤ\bδτ␙~␀␠‛␠",
	}, { // 2590
		mask: EncodeQuestion | EncodeRightSpace,
		in:   "ｙ␝ #\"σ␔Oω\uff00 ␖σξｕ$（４9\x15gＤ\bδτ␙~\x00␋ ",
		out:  "ｙ␝ #\"σ␔Oω\uff00 ␖σξｕ$（４9\x15gＤ\bδτ␙~␀␋␠",
	}, { // 2591
		mask: EncodeQuestion | EncodeRightSpace,
		in:   "ｙ␝ #\"σ␔Oω\uff00 ␖σξｕ$（４9\x15gＤ\bδτ␙~\x00␋␠",
		out:  "ｙ␝ #\"σ␔Oω\uff00 ␖σξｕ$（４9\x15gＤ\bδτ␙~␀␋‛␠",
	}, { // 2592
		mask: EncodeAsterisk | EncodeRightSpace,
		in:   "Ｉ>＿ςχt~ςχ␙ ␍ｋ␝␉\x159*８?κ/\x1a␇ν\ruＮYｌ",
		out:  "Ｉ>＿ςχt~ςχ␙ ␍ｋ␝␉\x159＊８?κ/\x1a␇ν\ruＮYｌ",
	}, { // 2593
		mask: EncodeAsterisk | EncodeRightSpace,
		in:   " ␠＿ςχt~ςχ␙ ␍ｋ␝␉\x159*８?κ/\x1a␇ν\ruＮYｌ",
		out:  " ␠＿ςχt~ςχ␙ ␍ｋ␝␉\x159＊８?κ/\x1a␇ν\ruＮYｌ",
	}, { // 2594
		mask: EncodeAsterisk | EncodeRightSpace,
		in:   "␠␠＿ςχt~ςχ␙ ␍ｋ␝␉\x159*８?κ/\x1a␇ν\ruＮYｌ",
		out:  "␠␠＿ςχt~ςχ␙ ␍ｋ␝␉\x159＊８?κ/\x1a␇ν\ruＮYｌ",
	}, { // 2595
		mask: EncodeAsterisk | EncodeRightSpace,
		in:   " >＿ςχt~ςχ␙ ␍ｋ␝␉\x159*８?κ/\x1a␇ν\ruＮ␠ｌ",
		out:  " >＿ςχt~ςχ␙ ␍ｋ␝␉\x159＊８?κ/\x1a␇ν\ruＮ␠ｌ",
	}, { // 2596
		mask: EncodeAsterisk | EncodeRightSpace,
		in:   "␠>＿ςχt~ςχ␙ ␍ｋ␝␉\x159*８?κ/\x1a␇ν\ruＮ␠ｌ",
		out:  "␠>＿ςχt~ςχ␙ ␍ｋ␝␉\x159＊８?κ/\x1a␇ν\ruＮ␠ｌ",
	}, { // 2597
		mask: EncodeAsterisk | EncodeRightSpace,
		in:   " >＿ςχt~ςχ␙ ␍ｋ␝␉\x159*８?κ/\x1a␇ν\ruＮY␠",
		out:  " >＿ςχt~ςχ␙ ␍ｋ␝␉\x159＊８?κ/\x1a␇ν\ruＮY‛␠",
	}, { // 2598
		mask: EncodeAsterisk | EncodeRightSpace,
		in:   "␠>＿ςχt~ςχ␙ ␍ｋ␝␉\x159*８?κ/\x1a␇ν\ruＮY␠",
		out:  "␠>＿ςχt~ςχ␙ ␍ｋ␝␉\x159＊８?κ/\x1a␇ν\ruＮY‛␠",
	}, { // 2599
		mask: EncodeAsterisk | EncodeRightSpace,
		in:   "Ｉ ＿ςχt~ςχ␙ ␍ｋ␝␉\x159*８?κ/\x1a␇ν\ruＮYｌ",
		out:  "Ｉ ＿ςχt~ςχ␙ ␍ｋ␝␉\x159＊８?κ/\x1a␇ν\ruＮYｌ",
	}, { // 2600
		mask: EncodeAsterisk | EncodeRightSpace,
		in:   "Ｉ␠＿ςχt~ςχ␙ ␍ｋ␝␉\x159*８?κ/\x1a␇ν\ruＮYｌ",
		out:  "Ｉ␠＿ςχt~ςχ␙ ␍ｋ␝␉\x159＊８?κ/\x1a␇ν\ruＮYｌ",
	}, { // 2601
		mask: EncodeAsterisk | EncodeRightSpace,
		in:   "Ｉ ＿ςχt~ςχ␙ ␍ｋ␝␉\x159*８?κ/\x1a␇ν\ruＮ␠ｌ",
		out:  "Ｉ ＿ςχt~ςχ␙ ␍ｋ␝␉\x159＊８?κ/\x1a␇ν\ruＮ␠ｌ",
	}, { // 2602
		mask: EncodeAsterisk | EncodeRightSpace,
		in:   "Ｉ␠＿ςχt~ςχ␙ ␍ｋ␝␉\x159*８?κ/\x1a␇ν\ruＮ␠ｌ",
		out:  "Ｉ␠＿ςχt~ςχ␙ ␍ｋ␝␉\x159＊８?κ/\x1a␇ν\ruＮ␠ｌ",
	}, { // 2603
		mask: EncodeAsterisk | EncodeRightSpace,
		in:   "Ｉ ＿ςχt~ςχ␙ ␍ｋ␝␉\x159*８?κ/\x1a␇ν\ruＮY␠",
		out:  "Ｉ ＿ςχt~ςχ␙ ␍ｋ␝␉\x159＊８?κ/\x1a␇ν\ruＮY‛␠",
	}, { // 2604
		mask: EncodeAsterisk | EncodeRightSpace,
		in:   "Ｉ␠＿ςχt~ςχ␙ ␍ｋ␝␉\x159*８?κ/\x1a␇ν\ruＮY␠",
		out:  "Ｉ␠＿ςχt~ςχ␙ ␍ｋ␝␉\x159＊８?κ/\x1a␇ν\ruＮY‛␠",
	}, { // 2605
		mask: EncodeAsterisk | EncodeRightSpace,
		in:   "Ｉ>＿ςχt~ςχ␙ ␍ｋ␝␉\x159*８?κ/\x1a␇ν\ruＮ ｌ",
		out:  "Ｉ>＿ςχt~ςχ␙ ␍ｋ␝␉\x159＊８?κ/\x1a␇ν\ruＮ ｌ",
	}, { // 2606
		mask: EncodeAsterisk | EncodeRightSpace,
		in:   "Ｉ>＿ςχt~ςχ␙ ␍ｋ␝␉\x159*８?κ/\x1a␇ν\ruＮ␠ｌ",
		out:  "Ｉ>＿ςχt~ςχ␙ ␍ｋ␝␉\x159＊８?κ/\x1a␇ν\ruＮ␠ｌ",
	}, { // 2607
		mask: EncodeAsterisk | EncodeRightSpace,
		in:   "Ｉ>＿ςχt~ςχ␙ ␍ｋ␝␉\x159*８?κ/\x1a␇ν\ruＮ ␠",
		out:  "Ｉ>＿ςχt~ςχ␙ ␍ｋ␝␉\x159＊８?κ/\x1a␇ν\ruＮ ‛␠",
	}, { // 2608
		mask: EncodeAsterisk | EncodeRightSpace,
		in:   "Ｉ>＿ςχt~ςχ␙ ␍ｋ␝␉\x159*８?κ/\x1a␇ν\ruＮ␠␠",
		out:  "Ｉ>＿ςχt~ςχ␙ ␍ｋ␝␉\x159＊８?κ/\x1a␇ν\ruＮ␠‛␠",
	}, { // 2609
		mask: EncodeAsterisk | EncodeRightSpace,
		in:   "Ｉ>＿ςχt~ςχ␙ ␍ｋ␝␉\x159*８?κ/\x1a␇ν\ruＮY ",
		out:  "Ｉ>＿ςχt~ςχ␙ ␍ｋ␝␉\x159＊８?κ/\x1a␇ν\ruＮY␠",
	}, { // 2610
		mask: EncodeAsterisk | EncodeRightSpace,
		in:   "Ｉ>＿ςχt~ςχ␙ ␍ｋ␝␉\x159*８?κ/\x1a␇ν\ruＮY␠",
		out:  "Ｉ>＿ςχt~ςχ␙ ␍ｋ␝␉\x159＊８?κ/\x1a␇ν\ruＮY‛␠",
	}, { // 2611
		mask: EncodePipe | EncodeRightSpace,
		in:   "␝＿ρ]E\x02\n/␄ｑ \u007f%α/β&％θ&Ｅ␚Lｄ␓␔ωF｜θ",
		out:  "␝＿ρ]E\x02\n/␄ｑ \u007f%α/β&％θ&Ｅ␚Lｄ␓␔ωF‛｜θ",
	}, { // 2612
		mask: EncodePipe | EncodeRightSpace,
		in:   " ␠ρ]E\x02\n/␄ｑ \u007f%α/β&％θ&Ｅ␚Lｄ␓␔ωF｜θ",
		out:  " ␠ρ]E\x02\n/␄ｑ \u007f%α/β&％θ&Ｅ␚Lｄ␓␔ωF‛｜θ",
	}, { // 2613
		mask: EncodePipe | EncodeRightSpace,
		in:   "␠␠ρ]E\x02\n/␄ｑ \u007f%α/β&％θ&Ｅ␚Lｄ␓␔ωF｜θ",
		out:  "␠␠ρ]E\x02\n/␄ｑ \u007f%α/β&％θ&Ｅ␚Lｄ␓␔ωF‛｜θ",
	}, { // 2614
		mask: EncodePipe | EncodeRightSpace,
		in:   " ＿ρ]E\x02\n/␄ｑ \u007f%α/β&％θ&Ｅ␚Lｄ␓␔ωF␠θ",
		out:  " ＿ρ]E\x02\n/␄ｑ \u007f%α/β&％θ&Ｅ␚Lｄ␓␔ωF␠θ",
	}, { // 2615
		mask: EncodePipe | EncodeRightSpace,
		in:   "␠＿ρ]E\x02\n/␄ｑ \u007f%α/β&％θ&Ｅ␚Lｄ␓␔ωF␠θ",
		out:  "␠＿ρ]E\x02\n/␄ｑ \u007f%α/β&％θ&Ｅ␚Lｄ␓␔ωF␠θ",
	}, { // 2616
		mask: EncodePipe | EncodeRightSpace,
		in:   " ＿ρ]E\x02\n/␄ｑ \u007f%α/β&％θ&Ｅ␚Lｄ␓␔ωF｜␠",
		out:  " ＿ρ]E\x02\n/␄ｑ \u007f%α/β&％θ&Ｅ␚Lｄ␓␔ωF‛｜‛␠",
	}, { // 2617
		mask: EncodePipe | EncodeRightSpace,
		in:   "␠＿ρ]E\x02\n/␄ｑ \u007f%α/β&％θ&Ｅ␚Lｄ␓␔ωF｜␠",
		out:  "␠＿ρ]E\x02\n/␄ｑ \u007f%α/β&％θ&Ｅ␚Lｄ␓␔ωF‛｜‛␠",
	}, { // 2618
		mask: EncodePipe | EncodeRightSpace,
		in:   "␝ ρ]E\x02\n/␄ｑ \u007f%α/β&％θ&Ｅ␚Lｄ␓␔ωF｜θ",
		out:  "␝ ρ]E\x02\n/␄ｑ \u007f%α/β&％θ&Ｅ␚Lｄ␓␔ωF‛｜θ",
	}, { // 2619
		mask: EncodePipe | EncodeRightSpace,
		in:   "␝␠ρ]E\x02\n/␄ｑ \u007f%α/β&％θ&Ｅ␚Lｄ␓␔ωF｜θ",
		out:  "␝␠ρ]E\x02\n/␄ｑ \u007f%α/β&％θ&Ｅ␚Lｄ␓␔ωF‛｜θ",
	}, { // 2620
		mask: EncodePipe | EncodeRightSpace,
		in:   "␝ ρ]E\x02\n/␄ｑ \u007f%α/β&％θ&Ｅ␚Lｄ␓␔ωF␠θ",
		out:  "␝ ρ]E\x02\n/␄ｑ \u007f%α/β&％θ&Ｅ␚Lｄ␓␔ωF␠θ",
	}, { // 2621
		mask: EncodePipe | EncodeRightSpace,
		in:   "␝␠ρ]E\x02\n/␄ｑ \u007f%α/β&％θ&Ｅ␚Lｄ␓␔ωF␠θ",
		out:  "␝␠ρ]E\x02\n/␄ｑ \u007f%α/β&％θ&Ｅ␚Lｄ␓␔ωF␠θ",
	}, { // 2622
		mask: EncodePipe | EncodeRightSpace,
		in:   "␝ ρ]E\x02\n/␄ｑ \u007f%α/β&％θ&Ｅ␚Lｄ␓␔ωF｜␠",
		out:  "␝ ρ]E\x02\n/␄ｑ \u007f%α/β&％θ&Ｅ␚Lｄ␓␔ωF‛｜‛␠",
	}, { // 2623
		mask: EncodePipe | EncodeRightSpace,
		in:   "␝␠ρ]E\x02\n/␄ｑ \u007f%α/β&％θ&Ｅ␚Lｄ␓␔ωF｜␠",
		out:  "␝␠ρ]E\x02\n/␄ｑ \u007f%α/β&％θ&Ｅ␚Lｄ␓␔ωF‛｜‛␠",
	}, { // 2624
		mask: EncodePipe | EncodeRightSpace,
		in:   "␝＿ρ]E\x02\n/␄ｑ \u007f%α/β&％θ&Ｅ␚Lｄ␓␔ωF θ",
		out:  "␝＿ρ]E\x02\n/␄ｑ \u007f%α/β&％θ&Ｅ␚Lｄ␓␔ωF θ",
	}, { // 2625
		mask: EncodePipe | EncodeRightSpace,
		in:   "␝＿ρ]E\x02\n/␄ｑ \u007f%α/β&％θ&Ｅ␚Lｄ␓␔ωF␠θ",
		out:  "␝＿ρ]E\x02\n/␄ｑ \u007f%α/β&％θ&Ｅ␚Lｄ␓␔ωF␠θ",
	}, { // 2626
		mask: EncodePipe | EncodeRightSpace,
		in:   "␝＿ρ]E\x02\n/␄ｑ \u007f%α/β&％θ&Ｅ␚Lｄ␓␔ωF ␠",
		out:  "␝＿ρ]E\x02\n/␄ｑ \u007f%α/β&％θ&Ｅ␚Lｄ␓␔ωF ‛␠",
	}, { // 2627
		mask: EncodePipe | EncodeRightSpace,
		in:   "␝＿ρ]E\x02\n/␄ｑ \u007f%α/β&％θ&Ｅ␚Lｄ␓␔ωF␠␠",
		out:  "␝＿ρ]E\x02\n/␄ｑ \u007f%α/β&％θ&Ｅ␚Lｄ␓␔ωF␠‛␠",
	}, { // 2628
		mask: EncodePipe | EncodeRightSpace,
		in:   "␝＿ρ]E\x02\n/␄ｑ \u007f%α/β&％θ&Ｅ␚Lｄ␓␔ωF｜ ",
		out:  "␝＿ρ]E\x02\n/␄ｑ \u007f%α/β&％θ&Ｅ␚Lｄ␓␔ωF‛｜␠",
	}, { // 2629
		mask: EncodePipe | EncodeRightSpace,
		in:   "␝＿ρ]E\x02\n/␄ｑ \u007f%α/β&％θ&Ｅ␚Lｄ␓␔ωF｜␠",
		out:  "␝＿ρ]E\x02\n/␄ｑ \u007f%α/β&％θ&Ｅ␚Lｄ␓␔ωF‛｜‛␠",
	}, { // 2630
		mask: EncodeHash | EncodeRightSpace,
		in:   "␛%!5ρ>uＡ\t\\ νπ␚#－1υH７␄（\x02␉φ＾ο␅␚\x12",
		out:  "␛%!5ρ>uＡ\t\\ νπ␚＃－1υH７␄（\x02␉φ＾ο␅␚\x12",
	}, { // 2631
		mask: EncodeHash | EncodeRightSpace,
		in:   " ␠!5ρ>uＡ\t\\ νπ␚#－1υH７␄（\x02␉φ＾ο␅␚\x12",
		out:  " ␠!5ρ>uＡ\t\\ νπ␚＃－1υH７␄（\x02␉φ＾ο␅␚\x12",
	}, { // 2632
		mask: EncodeHash | EncodeRightSpace,
		in:   "␠␠!5ρ>uＡ\t\\ νπ␚#－1υH７␄（\x02␉φ＾ο␅␚\x12",
		out:  "␠␠!5ρ>uＡ\t\\ νπ␚＃－1υH７␄（\x02␉φ＾ο␅␚\x12",
	}, { // 2633
		mask: EncodeHash | EncodeRightSpace,
		in:   " %!5ρ>uＡ\t\\ νπ␚#－1υH７␄（\x02␉φ＾ο␅␠\x12",
		out:  " %!5ρ>uＡ\t\\ νπ␚＃－1υH７␄（\x02␉φ＾ο␅␠\x12",
	}, { // 2634
		mask: EncodeHash | EncodeRightSpace,
		in:   "␠%!5ρ>uＡ\t\\ νπ␚#－1υH７␄（\x02␉φ＾ο␅␠\x12",
		out:  "␠%!5ρ>uＡ\t\\ νπ␚＃－1υH７␄（\x02␉φ＾ο␅␠\x12",
	}, { // 2635
		mask: EncodeHash | EncodeRightSpace,
		in:   " %!5ρ>uＡ\t\\ νπ␚#－1υH７␄（\x02␉φ＾ο␅␚␠",
		out:  " %!5ρ>uＡ\t\\ νπ␚＃－1υH７␄（\x02␉φ＾ο␅␚‛␠",
	}, { // 2636
		mask: EncodeHash | EncodeRightSpace,
		in:   "␠%!5ρ>uＡ\t\\ νπ␚#－1υH７␄（\x02␉φ＾ο␅␚␠",
		out:  "␠%!5ρ>uＡ\t\\ νπ␚＃－1υH７␄（\x02␉φ＾ο␅␚‛␠",
	}, { // 2637
		mask: EncodeHash | EncodeRightSpace,
		in:   "␛ !5ρ>uＡ\t\\ νπ␚#－1υH７␄（\x02␉φ＾ο␅␚\x12",
		out:  "␛ !5ρ>uＡ\t\\ νπ␚＃－1υH７␄（\x02␉φ＾ο␅␚\x12",
	}, { // 2638
		mask: EncodeHash | EncodeRightSpace,
		in:   "␛␠!5ρ>uＡ\t\\ νπ␚#－1υH７␄（\x02␉φ＾ο␅␚\x12",
		out:  "␛␠!5ρ>uＡ\t\\ νπ␚＃－1υH７␄（\x02␉φ＾ο␅␚\x12",
	}, { // 2639
		mask: EncodeHash | EncodeRightSpace,
		in:   "␛ !5ρ>uＡ\t\\ νπ␚#－1υH７␄（\x02␉φ＾ο␅␠\x12",
		out:  "␛ !5ρ>uＡ\t\\ νπ␚＃－1υH７␄（\x02␉φ＾ο␅␠\x12",
	}, { // 2640
		mask: EncodeHash | EncodeRightSpace,
		in:   "␛␠!5ρ>uＡ\t\\ νπ␚#－1υH７␄（\x02␉φ＾ο␅␠\x12",
		out:  "␛␠!5ρ>uＡ\t\\ νπ␚＃－1υH７␄（\x02␉φ＾ο␅␠\x12",
	}, { // 2641
		mask: EncodeHash | EncodeRightSpace,
		in:   "␛ !5ρ>uＡ\t\\ νπ␚#－1υH７␄（\x02␉φ＾ο␅␚␠",
		out:  "␛ !5ρ>uＡ\t\\ νπ␚＃－1υH７␄（\x02␉φ＾ο␅␚‛␠",
	}, { // 2642
		mask: EncodeHash | EncodeRightSpace,
		in:   "␛␠!5ρ>uＡ\t\\ νπ␚#－1υH７␄（\x02␉φ＾ο␅␚␠",
		out:  "␛␠!5ρ>uＡ\t\\ νπ␚＃－1υH７␄（\x02␉φ＾ο␅␚‛␠",
	}, { // 2643
		mask: EncodeHash | EncodeRightSpace,
		in:   "␛%!5ρ>uＡ\t\\ νπ␚#－1υH７␄（\x02␉φ＾ο␅ \x12",
		out:  "␛%!5ρ>uＡ\t\\ νπ␚＃－1υH７␄（\x02␉φ＾ο␅ \x12",
	}, { // 2644
		mask: EncodeHash | EncodeRightSpace,
		in:   "␛%!5ρ>uＡ\t\\ νπ␚#－1υH７␄（\x02␉φ＾ο␅␠\x12",
		out:  "␛%!5ρ>uＡ\t\\ νπ␚＃－1υH７␄（\x02␉φ＾ο␅␠\x12",
	}, { // 2645
		mask: EncodeHash | EncodeRightSpace,
		in:   "␛%!5ρ>uＡ\t\\ νπ␚#－1υH７␄（\x02␉φ＾ο␅ ␠",
		out:  "␛%!5ρ>uＡ\t\\ νπ␚＃－1υH７␄（\x02␉φ＾ο␅ ‛␠",
	}, { // 2646
		mask: EncodeHash | EncodeRightSpace,
		in:   "␛%!5ρ>uＡ\t\\ νπ␚#－1υH７␄（\x02␉φ＾ο␅␠␠",
		out:  "␛%!5ρ>uＡ\t\\ νπ␚＃－1υH７␄（\x02␉φ＾ο␅␠‛␠",
	}, { // 2647
		mask: EncodeHash | EncodeRightSpace,
		in:   "␛%!5ρ>uＡ\t\\ νπ␚#－1υH７␄（\x02␉φ＾ο␅␚ ",
		out:  "␛%!5ρ>uＡ\t\\ νπ␚＃－1υH７␄（\x02␉φ＾ο␅␚␠",
	}, { // 2648
		mask: EncodeHash | EncodeRightSpace,
		in:   "␛%!5ρ>uＡ\t\\ νπ␚#－1υH７␄（\x02␉φ＾ο␅␚␠",
		out:  "␛%!5ρ>uＡ\t\\ νπ␚＃－1υH７␄（\x02␉φ＾ο␅␚‛␠",
	}, { // 2649
		mask: EncodePercent | EncodeRightSpace,
		in:   "t\b\x166πγ)＞ξ/ ｀\x03＊θｘＥ＊ｅμ␆`%ag␐＼πＺ␋",
		out:  "t\b\x166πγ)＞ξ/ ｀\x03＊θｘＥ＊ｅμ␆`％ag␐＼πＺ␋",
	}, { // 2650
		mask: EncodePercent | EncodeRightSpace,
		in:   " ␠\x166πγ)＞ξ/ ｀\x03＊θｘＥ＊ｅμ␆`%ag␐＼πＺ␋",
		out:  " ␠\x166πγ)＞ξ/ ｀\x03＊θｘＥ＊ｅμ␆`％ag␐＼πＺ␋",
	}, { // 2651
		mask: EncodePercent | EncodeRightSpace,
		in:   "␠␠\x166πγ)＞ξ/ ｀\x03＊θｘＥ＊ｅμ␆`%ag␐＼πＺ␋",
		out:  "␠␠\x166πγ)＞ξ/ ｀\x03＊θｘＥ＊ｅμ␆`％ag␐＼πＺ␋",
	}, { // 2652
		mask: EncodePercent | EncodeRightSpace,
		in:   " \b\x166πγ)＞ξ/ ｀\x03＊θｘＥ＊ｅμ␆`%ag␐＼π␠␋",
		out:  " \b\x166πγ)＞ξ/ ｀\x03＊θｘＥ＊ｅμ␆`％ag␐＼π␠␋",
	}, { // 2653
		mask: EncodePercent | EncodeRightSpace,
		in:   "␠\b\x166πγ)＞ξ/ ｀\x03＊θｘＥ＊ｅμ␆`%ag␐＼π␠␋",
		out:  "␠\b\x166πγ)＞ξ/ ｀\x03＊θｘＥ＊ｅμ␆`％ag␐＼π␠␋",
	}, { // 2654
		mask: EncodePercent | EncodeRightSpace,
		in:   " \b\x166πγ)＞ξ/ ｀\x03＊θｘＥ＊ｅμ␆`%ag␐＼πＺ␠",
		out:  " \b\x166πγ)＞ξ/ ｀\x03＊θｘＥ＊ｅμ␆`％ag␐＼πＺ‛␠",
	}, { // 2655
		mask: EncodePercent | EncodeRightSpace,
		in:   "␠\b\x166πγ)＞ξ/ ｀\x03＊θｘＥ＊ｅμ␆`%ag␐＼πＺ␠",
		out:  "␠\b\x166πγ)＞ξ/ ｀\x03＊θｘＥ＊ｅμ␆`％ag␐＼πＺ‛␠",
	}, { // 2656
		mask: EncodePercent | EncodeRightSpace,
		in:   "t \x166πγ)＞ξ/ ｀\x03＊θｘＥ＊ｅμ␆`%ag␐＼πＺ␋",
		out:  "t \x166πγ)＞ξ/ ｀\x03＊θｘＥ＊ｅμ␆`％ag␐＼πＺ␋",
	}, { // 2657
		mask: EncodePercent | EncodeRightSpace,
		in:   "t␠\x166πγ)＞ξ/ ｀\x03＊θｘＥ＊ｅμ␆`%ag␐＼πＺ␋",
		out:  "t␠\x166πγ)＞ξ/ ｀\x03＊θｘＥ＊ｅμ␆`％ag␐＼πＺ␋",
	}, { // 2658
		mask: EncodePercent | EncodeRightSpace,
		in:   "t \x166πγ)＞ξ/ ｀\x03＊θｘＥ＊ｅμ␆`%ag␐＼π␠␋",
		out:  "t \x166πγ)＞ξ/ ｀\x03＊θｘＥ＊ｅμ␆`％ag␐＼π␠␋",
	}, { // 2659
		mask: EncodePercent | EncodeRightSpace,
		in:   "t␠\x166πγ)＞ξ/ ｀\x03＊θｘＥ＊ｅμ␆`%ag␐＼π␠␋",
		out:  "t␠\x166πγ)＞ξ/ ｀\x03＊θｘＥ＊ｅμ␆`％ag␐＼π␠␋",
	}, { // 2660
		mask: EncodePercent | EncodeRightSpace,
		in:   "t \x166πγ)＞ξ/ ｀\x03＊θｘＥ＊ｅμ␆`%ag␐＼πＺ␠",
		out:  "t \x166πγ)＞ξ/ ｀\x03＊θｘＥ＊ｅμ␆`％ag␐＼πＺ‛␠",
	}, { // 2661
		mask: EncodePercent | EncodeRightSpace,
		in:   "t␠\x166πγ)＞ξ/ ｀\x03＊θｘＥ＊ｅμ␆`%ag␐＼πＺ␠",
		out:  "t␠\x166πγ)＞ξ/ ｀\x03＊θｘＥ＊ｅμ␆`％ag␐＼πＺ‛␠",
	}, { // 2662
		mask: EncodePercent | EncodeRightSpace,
		in:   "t\b\x166πγ)＞ξ/ ｀\x03＊θｘＥ＊ｅμ␆`%ag␐＼π ␋",
		out:  "t\b\x166πγ)＞ξ/ ｀\x03＊θｘＥ＊ｅμ␆`％ag␐＼π ␋",
	}, { // 2663
		mask: EncodePercent | EncodeRightSpace,
		in:   "t\b\x166πγ)＞ξ/ ｀\x03＊θｘＥ＊ｅμ␆`%ag␐＼π␠␋",
		out:  "t\b\x166πγ)＞ξ/ ｀\x03＊θｘＥ＊ｅμ␆`％ag␐＼π␠␋",
	}, { // 2664
		mask: EncodePercent | EncodeRightSpace,
		in:   "t\b\x166πγ)＞ξ/ ｀\x03＊θｘＥ＊ｅμ␆`%ag␐＼π ␠",
		out:  "t\b\x166πγ)＞ξ/ ｀\x03＊θｘＥ＊ｅμ␆`％ag␐＼π ‛␠",
	}, { // 2665
		mask: EncodePercent | EncodeRightSpace,
		in:   "t\b\x166πγ)＞ξ/ ｀\x03＊θｘＥ＊ｅμ␆`%ag␐＼π␠␠",
		out:  "t\b\x166πγ)＞ξ/ ｀\x03＊θｘＥ＊ｅμ␆`％ag␐＼π␠‛␠",
	}, { // 2666
		mask: EncodePercent | EncodeRightSpace,
		in:   "t\b\x166πγ)＞ξ/ ｀\x03＊θｘＥ＊ｅμ␆`%ag␐＼πＺ ",
		out:  "t\b\x166πγ)＞ξ/ ｀\x03＊θｘＥ＊ｅμ␆`％ag␐＼πＺ␠",
	}, { // 2667
		mask: EncodePercent | EncodeRightSpace,
		in:   "t\b\x166πγ)＞ξ/ ｀\x03＊θｘＥ＊ｅμ␆`%ag␐＼πＺ␠",
		out:  "t\b\x166πγ)＞ξ/ ｀\x03＊θｘＥ＊ｅμ␆`％ag␐＼πＺ‛␠",
	}, { // 2668
		mask: EncodeBackSlash | EncodeRightSpace,
		in:   "0Ｍ␀'\x15θ␆␊␝[ \fI\x10Ｐτρh\b`γ］５ｚκ＂'␒δ\uff00",
		out:  "0Ｍ‛␀'\x15θ␆␊␝[ \fI\x10Ｐτρh\b`γ］５ｚκ＂'␒δ\uff00",
	}, { // 2669
		mask: EncodeBackSlash | EncodeRightSpace,
		in:   " ␠␀'\x15θ␆␊␝[ \fI\x10Ｐτρh\b`γ］５ｚκ＂'␒δ\uff00",
		out:  " ␠‛␀'\x15θ␆␊␝[ \fI\x10Ｐτρh\b`γ］５ｚκ＂'␒δ\uff00",
	}, { // 2670
		mask: EncodeBackSlash | EncodeRightSpace,
		in:   "␠␠␀'\x15θ␆␊␝[ \fI\x10Ｐτρh\b`γ］５ｚκ＂'␒δ\uff00",
		out:  "␠␠‛␀'\x15θ␆␊␝[ \fI\x10Ｐτρh\b`γ］５ｚκ＂'␒δ\uff00",
	}, { // 2671
		mask: EncodeBackSlash | EncodeRightSpace,
		in:   " Ｍ␀'\x15θ␆␊␝[ \fI\x10Ｐτρh\b`γ］５ｚκ＂'␒␠\uff00",
		out:  " Ｍ‛␀'\x15θ␆␊␝[ \fI\x10Ｐτρh\b`γ］５ｚκ＂'␒␠\uff00",
	}, { // 2672
		mask: EncodeBackSlash | EncodeRightSpace,
		in:   "␠Ｍ␀'\x15θ␆␊␝[ \fI\x10Ｐτρh\b`γ］５ｚκ＂'␒␠\uff00",
		out:  "␠Ｍ‛␀'\x15θ␆␊␝[ \fI\x10Ｐτρh\b`γ］５ｚκ＂'␒␠\uff00",
	}, { // 2673
		mask: EncodeBackSlash | EncodeRightSpace,
		in:   " Ｍ␀'\x15θ␆␊␝[ \fI\x10Ｐτρh\b`γ］５ｚκ＂'␒δ␠",
		out:  " Ｍ‛␀'\x15θ␆␊␝[ \fI\x10Ｐτρh\b`γ］５ｚκ＂'␒δ‛␠",
	}, { // 2674
		mask: EncodeBackSlash | EncodeRightSpace,
		in:   "␠Ｍ␀'\x15θ␆␊␝[ \fI\x10Ｐτρh\b`γ］５ｚκ＂'␒δ␠",
		out:  "␠Ｍ‛␀'\x15θ␆␊␝[ \fI\x10Ｐτρh\b`γ］５ｚκ＂'␒δ‛␠",
	}, { // 2675
		mask: EncodeBackSlash | EncodeRightSpace,
		in:   "0 ␀'\x15θ␆␊␝[ \fI\x10Ｐτρh\b`γ］５ｚκ＂'␒δ\uff00",
		out:  "0 ‛␀'\x15θ␆␊␝[ \fI\x10Ｐτρh\b`γ］５ｚκ＂'␒δ\uff00",
	}, { // 2676
		mask: EncodeBackSlash | EncodeRightSpace,
		in:   "0␠␀'\x15θ␆␊␝[ \fI\x10Ｐτρh\b`γ］５ｚκ＂'␒δ\uff00",
		out:  "0␠‛␀'\x15θ␆␊␝[ \fI\x10Ｐτρh\b`γ］５ｚκ＂'␒δ\uff00",
	}, { // 2677
		mask: EncodeBackSlash | EncodeRightSpace,
		in:   "0 ␀'\x15θ␆␊␝[ \fI\x10Ｐτρh\b`γ］５ｚκ＂'␒␠\uff00",
		out:  "0 ‛␀'\x15θ␆␊␝[ \fI\x10Ｐτρh\b`γ］５ｚκ＂'␒␠\uff00",
	}, { // 2678
		mask: EncodeBackSlash | EncodeRightSpace,
		in:   "0␠␀'\x15θ␆␊␝[ \fI\x10Ｐτρh\b`γ］５ｚκ＂'␒␠\uff00",
		out:  "0␠‛␀'\x15θ␆␊␝[ \fI\x10Ｐτρh\b`γ］５ｚκ＂'␒␠\uff00",
	}, { // 2679
		mask: EncodeBackSlash | EncodeRightSpace,
		in:   "0 ␀'\x15θ␆␊␝[ \fI\x10Ｐτρh\b`γ］５ｚκ＂'␒δ␠",
		out:  "0 ‛␀'\x15θ␆␊␝[ \fI\x10Ｐτρh\b`γ］５ｚκ＂'␒δ‛␠",
	}, { // 2680
		mask: EncodeBackSlash | EncodeRightSpace,
		in:   "0␠␀'\x15θ␆␊␝[ \fI\x10Ｐτρh\b`γ］５ｚκ＂'␒δ␠",
		out:  "0␠‛␀'\x15θ␆␊␝[ \fI\x10Ｐτρh\b`γ］５ｚκ＂'␒δ‛␠",
	}, { // 2681
		mask: EncodeBackSlash | EncodeRightSpace,
		in:   "0Ｍ␀'\x15θ␆␊␝[ \fI\x10Ｐτρh\b`γ］５ｚκ＂'␒ \uff00",
		out:  "0Ｍ‛␀'\x15θ␆␊␝[ \fI\x10Ｐτρh\b`γ］５ｚκ＂'␒ \uff00",
	}, { // 2682
		mask: EncodeBackSlash | EncodeRightSpace,
		in:   "0Ｍ␀'\x15θ␆␊␝[ \fI\x10Ｐτρh\b`γ］５ｚκ＂'␒␠\uff00",
		out:  "0Ｍ‛␀'\x15θ␆␊␝[ \fI\x10Ｐτρh\b`γ］５ｚκ＂'␒␠\uff00",
	}, { // 2683
		mask: EncodeBackSlash | EncodeRightSpace,
		in:   "0Ｍ␀'\x15θ␆␊␝[ \fI\x10Ｐτρh\b`γ］５ｚκ＂'␒ ␠",
		out:  "0Ｍ‛␀'\x15θ␆␊␝[ \fI\x10Ｐτρh\b`γ］５ｚκ＂'␒ ‛␠",
	}, { // 2684
		mask: EncodeBackSlash | EncodeRightSpace,
		in:   "0Ｍ␀'\x15θ␆␊␝[ \fI\x10Ｐτρh\b`γ］５ｚκ＂'␒␠␠",
		out:  "0Ｍ‛␀'\x15θ␆␊␝[ \fI\x10Ｐτρh\b`γ］５ｚκ＂'␒␠‛␠",
	}, { // 2685
		mask: EncodeBackSlash | EncodeRightSpace,
		in:   "0Ｍ␀'\x15θ␆␊␝[ \fI\x10Ｐτρh\b`γ］５ｚκ＂'␒δ ",
		out:  "0Ｍ‛␀'\x15θ␆␊␝[ \fI\x10Ｐτρh\b`γ］５ｚκ＂'␒δ␠",
	}, { // 2686
		mask: EncodeBackSlash | EncodeRightSpace,
		in:   "0Ｍ␀'\x15θ␆␊␝[ \fI\x10Ｐτρh\b`γ］５ｚκ＂'␒δ␠",
		out:  "0Ｍ‛␀'\x15θ␆␊␝[ \fI\x10Ｐτρh\b`γ］５ｚκ＂'␒δ‛␠",
	}, { // 2687
		mask: EncodeCrLf | EncodeRightSpace,
		in:   "ｉ\x10ｈ\x1eUeＤ］θJ \x06␈\x00ςj\x1d\x1e\"πO［ε␂＜ｅιφ␋Ｈ",
		out:  "ｉ\x10ｈ\x1eUeＤ］θJ \x06␈␀ςj\x1d\x1e\"πO［ε␂＜ｅιφ␋Ｈ",
	}, { // 2688
		mask: EncodeCrLf | EncodeRightSpace,
		in:   " ␠ｈ\x1eUeＤ］θJ \x06␈\x00ςj\x1d\x1e\"πO［ε␂＜ｅιφ␋Ｈ",
		out:  " ␠ｈ\x1eUeＤ］θJ \x06␈␀ςj\x1d\x1e\"πO［ε␂＜ｅιφ␋Ｈ",
	}, { // 2689
		mask: EncodeCrLf | EncodeRightSpace,
		in:   "␠␠ｈ\x1eUeＤ］θJ \x06␈\x00ςj\x1d\x1e\"πO［ε␂＜ｅιφ␋Ｈ",
		out:  "␠␠ｈ\x1eUeＤ］θJ \x06␈␀ςj\x1d\x1e\"πO［ε␂＜ｅιφ␋Ｈ",
	}, { // 2690
		mask: EncodeCrLf | EncodeRightSpace,
		in:   " \x10ｈ\x1eUeＤ］θJ \x06␈\x00ςj\x1d\x1e\"πO［ε␂＜ｅιφ␠Ｈ",
		out:  " \x10ｈ\x1eUeＤ］θJ \x06␈␀ςj\x1d\x1e\"πO［ε␂＜ｅιφ␠Ｈ",
	}, { // 2691
		mask: EncodeCrLf | EncodeRightSpace,
		in:   "␠\x10ｈ\x1eUeＤ］θJ \x06␈\x00ςj\x1d\x1e\"πO［ε␂＜ｅιφ␠Ｈ",
		out:  "␠\x10ｈ\x1eUeＤ］θJ \x06␈␀ςj\x1d\x1e\"πO［ε␂＜ｅιφ␠Ｈ",
	}, { // 2692
		mask: EncodeCrLf | EncodeRightSpace,
		in:   " \x10ｈ\x1eUeＤ］θJ \x06␈\x00ςj\x1d\x1e\"πO［ε␂＜ｅιφ␋␠",
		out:  " \x10ｈ\x1eUeＤ］θJ \x06␈␀ςj\x1d\x1e\"πO［ε␂＜ｅιφ␋‛␠",
	}, { // 2693
		mask: EncodeCrLf | EncodeRightSpace,
		in:   "␠\x10ｈ\x1eUeＤ］θJ \x06␈\x00ςj\x1d\x1e\"πO［ε␂＜ｅιφ␋␠",
		out:  "␠\x10ｈ\x1eUeＤ］θJ \x06␈␀ςj\x1d\x1e\"πO［ε␂＜ｅιφ␋‛␠",
	}, { // 2694
		mask: EncodeCrLf | EncodeRightSpace,
		in:   "ｉ ｈ\x1eUeＤ］θJ \x06␈\x00ςj\x1d\x1e\"πO［ε␂＜ｅιφ␋Ｈ",
		out:  "ｉ ｈ\x1eUeＤ］θJ \x06␈␀ςj\x1d\x1e\"πO［ε␂＜ｅιφ␋Ｈ",
	}, { // 2695
		mask: EncodeCrLf | EncodeRightSpace,
		in:   "ｉ␠ｈ\x1eUeＤ］θJ \x06␈\x00ςj\x1d\x1e\"πO［ε␂＜ｅιφ␋Ｈ",
		out:  "ｉ␠ｈ\x1eUeＤ］θJ \x06␈␀ςj\x1d\x1e\"πO［ε␂＜ｅιφ␋Ｈ",
	}, { // 2696
		mask: EncodeCrLf | EncodeRightSpace,
		in:   "ｉ ｈ\x1eUeＤ］θJ \x06␈\x00ςj\x1d\x1e\"πO［ε␂＜ｅιφ␠Ｈ",
		out:  "ｉ ｈ\x1eUeＤ］θJ \x06␈␀ςj\x1d\x1e\"πO［ε␂＜ｅιφ␠Ｈ",
	}, { // 2697
		mask: EncodeCrLf | EncodeRightSpace,
		in:   "ｉ␠ｈ\x1eUeＤ］θJ \x06␈\x00ςj\x1d\x1e\"πO［ε␂＜ｅιφ␠Ｈ",
		out:  "ｉ␠ｈ\x1eUeＤ］θJ \x06␈␀ςj\x1d\x1e\"πO［ε␂＜ｅιφ␠Ｈ",
	}, { // 2698
		mask: EncodeCrLf | EncodeRightSpace,
		in:   "ｉ ｈ\x1eUeＤ］θJ \x06␈\x00ςj\x1d\x1e\"πO［ε␂＜ｅιφ␋␠",
		out:  "ｉ ｈ\x1eUeＤ］θJ \x06␈␀ςj\x1d\x1e\"πO［ε␂＜ｅιφ␋‛␠",
	}, { // 2699
		mask: EncodeCrLf | EncodeRightSpace,
		in:   "ｉ␠ｈ\x1eUeＤ］θJ \x06␈\x00ςj\x1d\x1e\"πO［ε␂＜ｅιφ␋␠",
		out:  "ｉ␠ｈ\x1eUeＤ］θJ \x06␈␀ςj\x1d\x1e\"πO［ε␂＜ｅιφ␋‛␠",
	}, { // 2700
		mask: EncodeCrLf | EncodeRightSpace,
		in:   "ｉ\x10ｈ\x1eUeＤ］θJ \x06␈\x00ςj\x1d\x1e\"πO［ε␂＜ｅιφ Ｈ",
		out:  "ｉ\x10ｈ\x1eUeＤ］θJ \x06␈␀ςj\x1d\x1e\"πO［ε␂＜ｅιφ Ｈ",
	}, { // 2701
		mask: EncodeCrLf | EncodeRightSpace,
		in:   "ｉ\x10ｈ\x1eUeＤ］θJ \x06␈\x00ςj\x1d\x1e\"πO［ε␂＜ｅιφ␠Ｈ",
		out:  "ｉ\x10ｈ\x1eUeＤ］θJ \x06␈␀ςj\x1d\x1e\"πO［ε␂＜ｅιφ␠Ｈ",
	}, { // 2702
		mask: EncodeCrLf | EncodeRightSpace,
		in:   "ｉ\x10ｈ\x1eUeＤ］θJ \x06␈\x00ςj\x1d\x1e\"πO［ε␂＜ｅιφ ␠",
		out:  "ｉ\x10ｈ\x1eUeＤ］θJ \x06␈␀ςj\x1d\x1e\"πO［ε␂＜ｅιφ ‛␠",
	}, { // 2703
		mask: EncodeCrLf | EncodeRightSpace,
		in:   "ｉ\x10ｈ\x1eUeＤ］θJ \x06␈\x00ςj\x1d\x1e\"πO［ε␂＜ｅιφ␠␠",
		out:  "ｉ\x10ｈ\x1eUeＤ］θJ \x06␈␀ςj\x1d\x1e\"πO［ε␂＜ｅιφ␠‛␠",
	}, { // 2704
		mask: EncodeCrLf | EncodeRightSpace,
		in:   "ｉ\x10ｈ\x1eUeＤ］θJ \x06␈\x00ςj\x1d\x1e\"πO［ε␂＜ｅιφ␋ ",
		out:  "ｉ\x10ｈ\x1eUeＤ］θJ \x06␈␀ςj\x1d\x1e\"πO［ε␂＜ｅιφ␋␠",
	}, { // 2705
		mask: EncodeCrLf | EncodeRightSpace,
		in:   "ｉ\x10ｈ\x1eUeＤ］θJ \x06␈\x00ςj\x1d\x1e\"πO［ε␂＜ｅιφ␋␠",
		out:  "ｉ\x10ｈ\x1eUeＤ］θJ \x06␈␀ςj\x1d\x1e\"πO［ε␂＜ｅιφ␋‛␠",
	}, { // 2706
		mask: EncodeDel | EncodeRightSpace,
		in:   "\x1ch＄ｌδ|␟9］␓ \x05εγ␊ｂοｃ\bε`\x05ｚεLG４W␈m",
		out:  "\x1ch＄ｌδ|␟9］␓ \x05εγ␊ｂοｃ\bε`\x05ｚεLG４W␈m",
	}, { // 2707
		mask: EncodeDel | EncodeRightSpace,
		in:   " ␠＄ｌδ|␟9］␓ \x05εγ␊ｂοｃ\bε`\x05ｚεLG４W␈m",
		out:  " ␠＄ｌδ|␟9］␓ \x05εγ␊ｂοｃ\bε`\x05ｚεLG４W␈m",
	}, { // 2708
		mask: EncodeDel | EncodeRightSpace,
		in:   "␠␠＄ｌδ|␟9］␓ \x05εγ␊ｂοｃ\bε`\x05ｚεLG４W␈m",
		out:  "␠␠＄ｌδ|␟9］␓ \x05εγ␊ｂοｃ\bε`\x05ｚεLG４W␈m",
	}, { // 2709
		mask: EncodeDel | EncodeRightSpace,
		in:   " h＄ｌδ|␟9］␓ \x05εγ␊ｂοｃ\bε`\x05ｚεLG４W␠m",
		out:  " h＄ｌδ|␟9］␓ \x05εγ␊ｂοｃ\bε`\x05ｚεLG４W␠m",
	}, { // 2710
		mask: EncodeDel | EncodeRightSpace,
		in:   "␠h＄ｌδ|␟9］␓ \x05εγ␊ｂοｃ\bε`\x05ｚεLG４W␠m",
		out:  "␠h＄ｌδ|␟9］␓ \x05εγ␊ｂοｃ\bε`\x05ｚεLG４W␠m",
	}, { // 2711
		mask: EncodeDel | EncodeRightSpace,
		in:   " h＄ｌδ|␟9］␓ \x05εγ␊ｂοｃ\bε`\x05ｚεLG４W␈␠",
		out:  " h＄ｌδ|␟9］␓ \x05εγ␊ｂοｃ\bε`\x05ｚεLG４W␈‛␠",
	}, { // 2712
		mask: EncodeDel | EncodeRightSpace,
		in:   "␠h＄ｌδ|␟9］␓ \x05εγ␊ｂοｃ\bε`\x05ｚεLG４W␈␠",
		out:  "␠h＄ｌδ|␟9］␓ \x05εγ␊ｂοｃ\bε`\x05ｚεLG４W␈‛␠",
	}, { // 2713
		mask: EncodeDel | EncodeRightSpace,
		in:   "\x1c ＄ｌδ|␟9］␓ \x05εγ␊ｂοｃ\bε`\x05ｚεLG４W␈m",
		out:  "\x1c ＄ｌδ|␟9］␓ \x05εγ␊ｂοｃ\bε`\x05ｚεLG４W␈m",
	}, { // 2714
		mask: EncodeDel | EncodeRightSpace,
		in:   "\x1c␠＄ｌδ|␟9］␓ \x05εγ␊ｂοｃ\bε`\x05ｚεLG４W␈m",
		out:  "\x1c␠＄ｌδ|␟9］␓ \x05εγ␊ｂοｃ\bε`\x05ｚεLG４W␈m",
	}, { // 2715
		mask: EncodeDel | EncodeRightSpace,
		in:   "\x1c ＄ｌδ|␟9］␓ \x05εγ␊ｂοｃ\bε`\x05ｚεLG４W␠m",
		out:  "\x1c ＄ｌδ|␟9］␓ \x05εγ␊ｂοｃ\bε`\x05ｚεLG４W␠m",
	}, { // 2716
		mask: EncodeDel | EncodeRightSpace,
		in:   "\x1c␠＄ｌδ|␟9］␓ \x05εγ␊ｂοｃ\bε`\x05ｚεLG４W␠m",
		out:  "\x1c␠＄ｌδ|␟9］␓ \x05εγ␊ｂοｃ\bε`\x05ｚεLG４W␠m",
	}, { // 2717
		mask: EncodeDel | EncodeRightSpace,
		in:   "\x1c ＄ｌδ|␟9］␓ \x05εγ␊ｂοｃ\bε`\x05ｚεLG４W␈␠",
		out:  "\x1c ＄ｌδ|␟9］␓ \x05εγ␊ｂοｃ\bε`\x05ｚεLG４W␈‛␠",
	}, { // 2718
		mask: EncodeDel | EncodeRightSpace,
		in:   "\x1c␠＄ｌδ|␟9］␓ \x05εγ␊ｂοｃ\bε`\x05ｚεLG４W␈␠",
		out:  "\x1c␠＄ｌδ|␟9］␓ \x05εγ␊ｂοｃ\bε`\x05ｚεLG４W␈‛␠",
	}, { // 2719
		mask: EncodeDel | EncodeRightSpace,
		in:   "\x1ch＄ｌδ|␟9］␓ \x05εγ␊ｂοｃ\bε`\x05ｚεLG４W m",
		out:  "\x1ch＄ｌδ|␟9］␓ \x05εγ␊ｂοｃ\bε`\x05ｚεLG４W m",
	}, { // 2720
		mask: EncodeDel | EncodeRightSpace,
		in:   "\x1ch＄ｌδ|␟9］␓ \x05εγ␊ｂοｃ\bε`\x05ｚεLG４W␠m",
		out:  "\x1ch＄ｌδ|␟9］␓ \x05εγ␊ｂοｃ\bε`\x05ｚεLG４W␠m",
	}, { // 2721
		mask: EncodeDel | EncodeRightSpace,
		in:   "\x1ch＄ｌδ|␟9］␓ \x05εγ␊ｂοｃ\bε`\x05ｚεLG４W ␠",
		out:  "\x1ch＄ｌδ|␟9］␓ \x05εγ␊ｂοｃ\bε`\x05ｚεLG４W ‛␠",
	}, { // 2722
		mask: EncodeDel | EncodeRightSpace,
		in:   "\x1ch＄ｌδ|␟9］␓ \x05εγ␊ｂοｃ\bε`\x05ｚεLG４W␠␠",
		out:  "\x1ch＄ｌδ|␟9］␓ \x05εγ␊ｂοｃ\bε`\x05ｚεLG４W␠‛␠",
	}, { // 2723
		mask: EncodeDel | EncodeRightSpace,
		in:   "\x1ch＄ｌδ|␟9］␓ \x05εγ␊ｂοｃ\bε`\x05ｚεLG４W␈ ",
		out:  "\x1ch＄ｌδ|␟9］␓ \x05εγ␊ｂοｃ\bε`\x05ｚεLG４W␈␠",
	}, { // 2724
		mask: EncodeDel | EncodeRightSpace,
		in:   "\x1ch＄ｌδ|␟9］␓ \x05εγ␊ｂοｃ\bε`\x05ｚεLG４W␈␠",
		out:  "\x1ch＄ｌδ|␟9］␓ \x05εγ␊ｂοｃ\bε`\x05ｚεLG４W␈‛␠",
	}, { // 2725
		mask: EncodeCtl | EncodeRightSpace,
		in:   "\x16␐ｓ＼␍gcＢκ＞ )β［\x1f\x14␄γ\a␀ｒ：ψG/＄μ\x04>/",
		out:  "␖‛␐ｓ＼‛␍gcＢκ＞ )β［␟␔‛␄γ␇‛␀ｒ：ψG/＄μ␄>/",
	}, { // 2726
		mask: EncodeCtl | EncodeRightSpace,
		in:   " ␠ｓ＼␍gcＢκ＞ )β［\x1f\x14␄γ\a␀ｒ：ψG/＄μ\x04>/",
		out:  " ␠ｓ＼‛␍gcＢκ＞ )β［␟␔‛␄γ␇‛␀ｒ：ψG/＄μ␄>/",
	}, { // 2727
		mask: EncodeCtl | EncodeRightSpace,
		in:   "␠␠ｓ＼␍gcＢκ＞ )β［\x1f\x14␄γ\a␀ｒ：ψG/＄μ\x04>/",
		out:  "␠␠ｓ＼‛␍gcＢκ＞ )β［␟␔‛␄γ␇‛␀ｒ：ψG/＄μ␄>/",
	}, { // 2728
		mask: EncodeCtl | EncodeRightSpace,
		in:   " ␐ｓ＼␍gcＢκ＞ )β［\x1f\x14␄γ\a␀ｒ：ψG/＄μ\x04␠/",
		out:  " ‛␐ｓ＼‛␍gcＢκ＞ )β［␟␔‛␄γ␇‛␀ｒ：ψG/＄μ␄␠/",
	}, { // 2729
		mask: EncodeCtl | EncodeRightSpace,
		in:   "␠␐ｓ＼␍gcＢκ＞ )β［\x1f\x14␄γ\a␀ｒ：ψG/＄μ\x04␠/",
		out:  "␠‛␐ｓ＼‛␍gcＢκ＞ )β［␟␔‛␄γ␇‛␀ｒ：ψG/＄μ␄␠/",
	}, { // 2730
		mask: EncodeCtl | EncodeRightSpace,
		in:   " ␐ｓ＼␍gcＢκ＞ )β［\x1f\x14␄γ\a␀ｒ：ψG/＄μ\x04>␠",
		out:  " ‛␐ｓ＼‛␍gcＢκ＞ )β［␟␔‛␄γ␇‛␀ｒ：ψG/＄μ␄>‛␠",
	}, { // 2731
		mask: EncodeCtl | EncodeRightSpace,
		in:   "␠␐ｓ＼␍gcＢκ＞ )β［\x1f\x14␄γ\a␀ｒ：ψG/＄μ\x04>␠",
		out:  "␠‛␐ｓ＼‛␍gcＢκ＞ )β［␟␔‛␄γ␇‛␀ｒ：ψG/＄μ␄>‛␠",
	}, { // 2732
		mask: EncodeCtl | EncodeRightSpace,
		in:   "\x16 ｓ＼␍gcＢκ＞ )β［\x1f\x14␄γ\a␀ｒ：ψG/＄μ\x04>/",
		out:  "␖ ｓ＼‛␍gcＢκ＞ )β［␟␔‛␄γ␇‛␀ｒ：ψG/＄μ␄>/",
	}, { // 2733
		mask: EncodeCtl | EncodeRightSpace,
		in:   "\x16␠ｓ＼␍gcＢκ＞ )β［\x1f\x14␄γ\a␀ｒ：ψG/＄μ\x04>/",
		out:  "␖␠ｓ＼‛␍gcＢκ＞ )β［␟␔‛␄γ␇‛␀ｒ：ψG/＄μ␄>/",
	}, { // 2734
		mask: EncodeCtl | EncodeRightSpace,
		in:   "\x16 ｓ＼␍gcＢκ＞ )β［\x1f\x14␄γ\a␀ｒ：ψG/＄μ\x04␠/",
		out:  "␖ ｓ＼‛␍gcＢκ＞ )β［␟␔‛␄γ␇‛␀ｒ：ψG/＄μ␄␠/",
	}, { // 2735
		mask: EncodeCtl | EncodeRightSpace,
		in:   "\x16␠ｓ＼␍gcＢκ＞ )β［\x1f\x14␄γ\a␀ｒ：ψG/＄μ\x04␠/",
		out:  "␖␠ｓ＼‛␍gcＢκ＞ )β［␟␔‛␄γ␇‛␀ｒ：ψG/＄μ␄␠/",
	}, { // 2736
		mask: EncodeCtl | EncodeRightSpace,
		in:   "\x16 ｓ＼␍gcＢκ＞ )β［\x1f\x14␄γ\a␀ｒ：ψG/＄μ\x04>␠",
		out:  "␖ ｓ＼‛␍gcＢκ＞ )β［␟␔‛␄γ␇‛␀ｒ：ψG/＄μ␄>‛␠",
	}, { // 2737
		mask: EncodeCtl | EncodeRightSpace,
		in:   "\x16␠ｓ＼␍gcＢκ＞ )β［\x1f\x14␄γ\a␀ｒ：ψG/＄μ\x04>␠",
		out:  "␖␠ｓ＼‛␍gcＢκ＞ )β［␟␔‛␄γ␇‛␀ｒ：ψG/＄μ␄>‛␠",
	}, { // 2738
		mask: EncodeCtl | EncodeRightSpace,
		in:   "\x16␐ｓ＼␍gcＢκ＞ )β［\x1f\x14␄γ\a␀ｒ：ψG/＄μ\x04 /",
		out:  "␖‛␐ｓ＼‛␍gcＢκ＞ )β［␟␔‛␄γ␇‛␀ｒ：ψG/＄μ␄ /",
	}, { // 2739
		mask: EncodeCtl | EncodeRightSpace,
		in:   "\x16␐ｓ＼␍gcＢκ＞ )β［\x1f\x14␄γ\a␀ｒ：ψG/＄μ\x04␠/",
		out:  "␖‛␐ｓ＼‛␍gcＢκ＞ )β［␟␔‛␄γ␇‛␀ｒ：ψG/＄μ␄␠/",
	}, { // 2740
		mask: EncodeCtl | EncodeRightSpace,
		in:   "\x16␐ｓ＼␍gcＢκ＞ )β［\x1f\x14␄γ\a␀ｒ：ψG/＄μ\x04 ␠",
		out:  "␖‛␐ｓ＼‛␍gcＢκ＞ )β［␟␔‛␄γ␇‛␀ｒ：ψG/＄μ␄ ‛␠",
	}, { // 2741
		mask: EncodeCtl | EncodeRightSpace,
		in:   "\x16␐ｓ＼␍gcＢκ＞ )β［\x1f\x14␄γ\a␀ｒ：ψG/＄μ\x04␠␠",
		out:  "␖‛␐ｓ＼‛␍gcＢκ＞ )β［␟␔‛␄γ␇‛␀ｒ：ψG/＄μ␄␠‛␠",
	}, { // 2742
		mask: EncodeCtl | EncodeRightSpace,
		in:   "\x16␐ｓ＼␍gcＢκ＞ )β［\x1f\x14␄γ\a␀ｒ：ψG/＄μ\x04> ",
		out:  "␖‛␐ｓ＼‛␍gcＢκ＞ )β［␟␔‛␄γ␇‛␀ｒ：ψG/＄μ␄>␠",
	}, { // 2743
		mask: EncodeCtl | EncodeRightSpace,
		in:   "\x16␐ｓ＼␍gcＢκ＞ )β［\x1f\x14␄γ\a␀ｒ：ψG/＄μ\x04>␠",
		out:  "␖‛␐ｓ＼‛␍gcＢκ＞ )β［␟␔‛␄γ␇‛␀ｒ：ψG/＄μ␄>‛␠",
	}, { // 2744
		mask: EncodeRightPeriod,
		in:   ".",
		out:  "．",
	}, { // 2745
		mask: EncodeZero | EncodeRightPeriod,
		in:   "␔\"␕3M3Ｍηυ\x12.｜δ\f ψ\x04\f>／␟γ\uff00␉{␍φｘＣ-",
		out:  "␔\"␕3M3Ｍηυ\x12.｜δ\f ψ\x04\f>／␟γ\uff00␉{␍φｘＣ-",
	}, { // 2746
		mask: EncodeZero | EncodeRightPeriod,
		in:   ".．␕3M3Ｍηυ\x12.｜δ\f ψ\x04\f>／␟γ\uff00␉{␍φｘＣ-",
		out:  ".．␕3M3Ｍηυ\x12.｜δ\f ψ\x04\f>／␟γ\uff00␉{␍φｘＣ-",
	}, { // 2747
		mask: EncodeZero | EncodeRightPeriod,
		in:   "．．␕3M3Ｍηυ\x12.｜δ\f ψ\x04\f>／␟γ\uff00␉{␍φｘＣ-",
		out:  "．．␕3M3Ｍηυ\x12.｜δ\f ψ\x04\f>／␟γ\uff00␉{␍φｘＣ-",
	}, { // 2748
		mask: EncodeZero | EncodeRightPeriod,
		in:   ".\"␕3M3Ｍηυ\x12.｜δ\f ψ\x04\f>／␟γ\uff00␉{␍φｘ．-",
		out:  ".\"␕3M3Ｍηυ\x12.｜δ\f ψ\x04\f>／␟γ\uff00␉{␍φｘ．-",
	}, { // 2749
		mask: EncodeZero | EncodeRightPeriod,
		in:   "．\"␕3M3Ｍηυ\x12.｜δ\f ψ\x04\f>／␟γ\uff00␉{␍φｘ．-",
		out:  "．\"␕3M3Ｍηυ\x12.｜δ\f ψ\x04\f>／␟γ\uff00␉{␍φｘ．-",
	}, { // 2750
		mask: EncodeZero | EncodeRightPeriod,
		in:   ".\"␕3M3Ｍηυ\x12.｜δ\f ψ\x04\f>／␟γ\uff00␉{␍φｘＣ．",
		out:  ".\"␕3M3Ｍηυ\x12.｜δ\f ψ\x04\f>／␟γ\uff00␉{␍φｘＣ‛．",
	}, { // 2751
		mask: EncodeZero | EncodeRightPeriod,
		in:   "．\"␕3M3Ｍηυ\x12.｜δ\f ψ\x04\f>／␟γ\uff00␉{␍φｘＣ．",
		out:  "．\"␕3M3Ｍηυ\x12.｜δ\f ψ\x04\f>／␟γ\uff00␉{␍φｘＣ‛．",
	}, { // 2752
		mask: EncodeZero | EncodeRightPeriod,
		in:   "␔.␕3M3Ｍηυ\x12.｜δ\f ψ\x04\f>／␟γ\uff00␉{␍φｘＣ-",
		out:  "␔.␕3M3Ｍηυ\x12.｜δ\f ψ\x04\f>／␟γ\uff00␉{␍φｘＣ-",
	}, { // 2753
		mask: EncodeZero | EncodeRightPeriod,
		in:   "␔．␕3M3Ｍηυ\x12.｜δ\f ψ\x04\f>／␟γ\uff00␉{␍φｘＣ-",
		out:  "␔．␕3M3Ｍηυ\x12.｜δ\f ψ\x04\f>／␟γ\uff00␉{␍φｘＣ-",
	}, { // 2754
		mask: EncodeZero | EncodeRightPeriod,
		in:   "␔.␕3M3Ｍηυ\x12.｜δ\f ψ\x04\f>／␟γ\uff00␉{␍φｘ．-",
		out:  "␔.␕3M3Ｍηυ\x12.｜δ\f ψ\x04\f>／␟γ\uff00␉{␍φｘ．-",
	}, { // 2755
		mask: EncodeZero | EncodeRightPeriod,
		in:   "␔．␕3M3Ｍηυ\x12.｜δ\f ψ\x04\f>／␟γ\uff00␉{␍φｘ．-",
		out:  "␔．␕3M3Ｍηυ\x12.｜δ\f ψ\x04\f>／␟γ\uff00␉{␍φｘ．-",
	}, { // 2756
		mask: EncodeZero | EncodeRightPeriod,
		in:   "␔.␕3M3Ｍηυ\x12.｜δ\f ψ\x04\f>／␟γ\uff00␉{␍φｘＣ．",
		out:  "␔.␕3M3Ｍηυ\x12.｜δ\f ψ\x04\f>／␟γ\uff00␉{␍φｘＣ‛．",
	}, { // 2757
		mask: EncodeZero | EncodeRightPeriod,
		in:   "␔．␕3M3Ｍηυ\x12.｜δ\f ψ\x04\f>／␟γ\uff00␉{␍φｘＣ．",
		out:  "␔．␕3M3Ｍηυ\x12.｜δ\f ψ\x04\f>／␟γ\uff00␉{␍φｘＣ‛．",
	}, { // 2758
		mask: EncodeZero | EncodeRightPeriod,
		in:   "␔\"␕3M3Ｍηυ\x12.｜δ\f ψ\x04\f>／␟γ\uff00␉{␍φｘ.-",
		out:  "␔\"␕3M3Ｍηυ\x12.｜δ\f ψ\x04\f>／␟γ\uff00␉{␍φｘ.-",
	}, { // 2759
		mask: EncodeZero | EncodeRightPeriod,
		in:   "␔\"␕3M3Ｍηυ\x12.｜δ\f ψ\x04\f>／␟γ\uff00␉{␍φｘ．-",
		out:  "␔\"␕3M3Ｍηυ\x12.｜δ\f ψ\x04\f>／␟γ\uff00␉{␍φｘ．-",
	}, { // 2760
		mask: EncodeZero | EncodeRightPeriod,
		in:   "␔\"␕3M3Ｍηυ\x12.｜δ\f ψ\x04\f>／␟γ\uff00␉{␍φｘ.．",
		out:  "␔\"␕3M3Ｍηυ\x12.｜δ\f ψ\x04\f>／␟γ\uff00␉{␍φｘ.‛．",
	}, { // 2761
		mask: EncodeZero | EncodeRightPeriod,
		in:   "␔\"␕3M3Ｍηυ\x12.｜δ\f ψ\x04\f>／␟γ\uff00␉{␍φｘ．．",
		out:  "␔\"␕3M3Ｍηυ\x12.｜δ\f ψ\x04\f>／␟γ\uff00␉{␍φｘ．‛．",
	}, { // 2762
		mask: EncodeZero | EncodeRightPeriod,
		in:   "␔\"␕3M3Ｍηυ\x12.｜δ\f ψ\x04\f>／␟γ\uff00␉{␍φｘＣ.",
		out:  "␔\"␕3M3Ｍηυ\x12.｜δ\f ψ\x04\f>／␟γ\uff00␉{␍φｘＣ．",
	}, { // 2763
		mask: EncodeZero | EncodeRightPeriod,
		in:   "␔\"␕3M3Ｍηυ\x12.｜δ\f ψ\x04\f>／␟γ\uff00␉{␍φｘＣ．",
		out:  "␔\"␕3M3Ｍηυ\x12.｜δ\f ψ\x04\f>／␟γ\uff00␉{␍φｘＣ‛．",
	}, { // 2764
		mask: EncodeSlash | EncodeRightPeriod,
		in:   "␔θ&Ｇ>>χD\x04－.␔９［/o␡４／\nροP?\rｋ\x11＊８υ",
		out:  "␔θ&Ｇ>>χD\x04－.␔９［／o␡４‛／\nροP?\rｋ\x11＊８υ",
	}, { // 2765
		mask: EncodeSlash | EncodeRightPeriod,
		in:   ".．&Ｇ>>χD\x04－.␔９［/o␡４／\nροP?\rｋ\x11＊８υ",
		out:  ".．&Ｇ>>χD\x04－.␔９［／o␡４‛／\nροP?\rｋ\x11＊８υ",
	}, { // 2766
		mask: EncodeSlash | EncodeRightPeriod,
		in:   "．．&Ｇ>>χD\x04－.␔９［/o␡４／\nροP?\rｋ\x11＊８υ",
		out:  "．．&Ｇ>>χD\x04－.␔９［／o␡４‛／\nροP?\rｋ\x11＊８υ",
	}, { // 2767
		mask: EncodeSlash | EncodeRightPeriod,
		in:   ".θ&Ｇ>>χD\x04－.␔９［/o␡４／\nροP?\rｋ\x11＊．υ",
		out:  ".θ&Ｇ>>χD\x04－.␔９［／o␡４‛／\nροP?\rｋ\x11＊．υ",
	}, { // 2768
		mask: EncodeSlash | EncodeRightPeriod,
		in:   "．θ&Ｇ>>χD\x04－.␔９［/o␡４／\nροP?\rｋ\x11＊．υ",
		out:  "．θ&Ｇ>>χD\x04－.␔９［／o␡４‛／\nροP?\rｋ\x11＊．υ",
	}, { // 2769
		mask: EncodeSlash | EncodeRightPeriod,
		in:   ".θ&Ｇ>>χD\x04－.␔９［/o␡４／\nροP?\rｋ\x11＊８．",
		out:  ".θ&Ｇ>>χD\x04－.␔９［／o␡４‛／\nροP?\rｋ\x11＊８‛．",
	}, { // 2770
		mask: EncodeSlash | EncodeRightPeriod,
		in:   "．θ&Ｇ>>χD\x04－.␔９［/o␡４／\nροP?\rｋ\x11＊８．",
		out:  "．θ&Ｇ>>χD\x04－.␔９［／o␡４‛／\nροP?\rｋ\x11＊８‛．",
	}, { // 2771
		mask: EncodeSlash | EncodeRightPeriod,
		in:   "␔.&Ｇ>>χD\x04－.␔９［/o␡４／\nροP?\rｋ\x11＊８υ",
		out:  "␔.&Ｇ>>χD\x04－.␔９［／o␡４‛／\nροP?\rｋ\x11＊８υ",
	}, { // 2772
		mask: EncodeSlash | EncodeRightPeriod,
		in:   "␔．&Ｇ>>χD\x04－.␔９［/o␡４／\nροP?\rｋ\x11＊８υ",
		out:  "␔．&Ｇ>>χD\x04－.␔９［／o␡４‛／\nροP?\rｋ\x11＊８υ",
	}, { // 2773
		mask: EncodeSlash | EncodeRightPeriod,
		in:   "␔.&Ｇ>>χD\x04－.␔９［/o␡４／\nροP?\rｋ\x11＊．υ",
		out:  "␔.&Ｇ>>χD\x04－.␔９［／o␡４‛／\nροP?\rｋ\x11＊．υ",
	}, { // 2774
		mask: EncodeSlash | EncodeRightPeriod,
		in:   "␔．&Ｇ>>χD\x04－.␔９［/o␡４／\nροP?\rｋ\x11＊．υ",
		out:  "␔．&Ｇ>>χD\x04－.␔９［／o␡４‛／\nροP?\rｋ\x11＊．υ",
	}, { // 2775
		mask: EncodeSlash | EncodeRightPeriod,
		in:   "␔.&Ｇ>>χD\x04－.␔９［/o␡４／\nροP?\rｋ\x11＊８．",
		out:  "␔.&Ｇ>>χD\x04－.␔９［／o␡４‛／\nροP?\rｋ\x11＊８‛．",
	}, { // 2776
		mask: EncodeSlash | EncodeRightPeriod,
		in:   "␔．&Ｇ>>χD\x04－.␔９［/o␡４／\nροP?\rｋ\x11＊８．",
		out:  "␔．&Ｇ>>χD\x04－.␔９［／o␡４‛／\nροP?\rｋ\x11＊８‛．",
	}, { // 2777
		mask: EncodeSlash | EncodeRightPeriod,
		in:   "␔θ&Ｇ>>χD\x04－.␔９［/o␡４／\nροP?\rｋ\x11＊.υ",
		out:  "␔θ&Ｇ>>χD\x04－.␔９［／o␡４‛／\nροP?\rｋ\x11＊.υ",
	}, { // 2778
		mask: EncodeSlash | EncodeRightPeriod,
		in:   "␔θ&Ｇ>>χD\x04－.␔９［/o␡４／\nροP?\rｋ\x11＊．υ",
		out:  "␔θ&Ｇ>>χD\x04－.␔９［／o␡４‛／\nροP?\rｋ\x11＊．υ",
	}, { // 2779
		mask: EncodeSlash | EncodeRightPeriod,
		in:   "␔θ&Ｇ>>χD\x04－.␔９［/o␡４／\nροP?\rｋ\x11＊.．",
		out:  "␔θ&Ｇ>>χD\x04－.␔９［／o␡４‛／\nροP?\rｋ\x11＊.‛．",
	}, { // 2780
		mask: EncodeSlash | EncodeRightPeriod,
		in:   "␔θ&Ｇ>>χD\x04－.␔９［/o␡４／\nροP?\rｋ\x11＊．．",
		out:  "␔θ&Ｇ>>χD\x04－.␔９［／o␡４‛／\nροP?\rｋ\x11＊．‛．",
	}, { // 2781
		mask: EncodeSlash | EncodeRightPeriod,
		in:   "␔θ&Ｇ>>χD\x04－.␔９［/o␡４／\nροP?\rｋ\x11＊８.",
		out:  "␔θ&Ｇ>>χD\x04－.␔９［／o␡４‛／\nροP?\rｋ\x11＊８．",
	}, { // 2782
		mask: EncodeSlash | EncodeRightPeriod,
		in:   "␔θ&Ｇ>>χD\x04－.␔９［/o␡４／\nροP?\rｋ\x11＊８．",
		out:  "␔θ&Ｇ>>χD\x04－.␔９［／o␡４‛／\nροP?\rｋ\x11＊８‛．",
	}, { // 2783
		mask: EncodeSingleQuote | EncodeRightPeriod,
		in:   "Xn\x16υ＊␇␆|+＠.／ν１４\x1e_\x03η/\x00α＂O；/＜＄β＃",
		out:  "Xn\x16υ＊␇␆|+＠.／ν１４\x1e_\x03η/␀α＂O；/＜＄β＃",
	}, { // 2784
		mask: EncodeSingleQuote | EncodeRightPeriod,
		in:   ".．\x16υ＊␇␆|+＠.／ν１４\x1e_\x03η/\x00α＂O；/＜＄β＃",
		out:  ".．\x16υ＊␇␆|+＠.／ν１４\x1e_\x03η/␀α＂O；/＜＄β＃",
	}, { // 2785
		mask: EncodeSingleQuote | EncodeRightPeriod,
		in:   "．．\x16υ＊␇␆|+＠.／ν１４\x1e_\x03η/\x00α＂O；/＜＄β＃",
		out:  "．．\x16υ＊␇␆|+＠.／ν１４\x1e_\x03η/␀α＂O；/＜＄β＃",
	}, { // 2786
		mask: EncodeSingleQuote | EncodeRightPeriod,
		in:   ".n\x16υ＊␇␆|+＠.／ν１４\x1e_\x03η/\x00α＂O；/＜＄．＃",
		out:  ".n\x16υ＊␇␆|+＠.／ν１４\x1e_\x03η/␀α＂O；/＜＄．＃",
	}, { // 2787
		mask: EncodeSingleQuote | EncodeRightPeriod,
		in:   "．n\x16υ＊␇␆|+＠.／ν１４\x1e_\x03η/\x00α＂O；/＜＄．＃",
		out:  "．n\x16υ＊␇␆|+＠.／ν１４\x1e_\x03η/␀α＂O；/＜＄．＃",
	}, { // 2788
		mask: EncodeSingleQuote | EncodeRightPeriod,
		in:   ".n\x16υ＊␇␆|+＠.／ν１４\x1e_\x03η/\x00α＂O；/＜＄β．",
		out:  ".n\x16υ＊␇␆|+＠.／ν１４\x1e_\x03η/␀α＂O；/＜＄β‛．",
	}, { // 2789
		mask: EncodeSingleQuote | EncodeRightPeriod,
		in:   "．n\x16υ＊␇␆|+＠.／ν１４\x1e_\x03η/\x00α＂O；/＜＄β．",
		out:  "．n\x16υ＊␇␆|+＠.／ν１４\x1e_\x03η/␀α＂O；/＜＄β‛．",
	}, { // 2790
		mask: EncodeSingleQuote | EncodeRightPeriod,
		in:   "X.\x16υ＊␇␆|+＠.／ν１４\x1e_\x03η/\x00α＂O；/＜＄β＃",
		out:  "X.\x16υ＊␇␆|+＠.／ν１４\x1e_\x03η/␀α＂O；/＜＄β＃",
	}, { // 2791
		mask: EncodeSingleQuote | EncodeRightPeriod,
		in:   "X．\x16υ＊␇␆|+＠.／ν１４\x1e_\x03η/\x00α＂O；/＜＄β＃",
		out:  "X．\x16υ＊␇␆|+＠.／ν１４\x1e_\x03η/␀α＂O；/＜＄β＃",
	}, { // 2792
		mask: EncodeSingleQuote | EncodeRightPeriod,
		in:   "X.\x16υ＊␇␆|+＠.／ν１４\x1e_\x03η/\x00α＂O；/＜＄．＃",
		out:  "X.\x16υ＊␇␆|+＠.／ν１４\x1e_\x03η/␀α＂O；/＜＄．＃",
	}, { // 2793
		mask: EncodeSingleQuote | EncodeRightPeriod,
		in:   "X．\x16υ＊␇␆|+＠.／ν１４\x1e_\x03η/\x00α＂O；/＜＄．＃",
		out:  "X．\x16υ＊␇␆|+＠.／ν１４\x1e_\x03η/␀α＂O；/＜＄．＃",
	}, { // 2794
		mask: EncodeSingleQuote | EncodeRightPeriod,
		in:   "X.\x16υ＊␇␆|+＠.／ν１４\x1e_\x03η/\x00α＂O；/＜＄β．",
		out:  "X.\x16υ＊␇␆|+＠.／ν１４\x1e_\x03η/␀α＂O；/＜＄β‛．",
	}, { // 2795
		mask: EncodeSingleQuote | EncodeRightPeriod,
		in:   "X．\x16υ＊␇␆|+＠.／ν１４\x1e_\x03η/\x00α＂O；/＜＄β．",
		out:  "X．\x16υ＊␇␆|+＠.／ν１４\x1e_\x03η/␀α＂O；/＜＄β‛．",
	}, { // 2796
		mask: EncodeSingleQuote | EncodeRightPeriod,
		in:   "Xn\x16υ＊␇␆|+＠.／ν１４\x1e_\x03η/\x00α＂O；/＜＄.＃",
		out:  "Xn\x16υ＊␇␆|+＠.／ν１４\x1e_\x03η/␀α＂O；/＜＄.＃",
	}, { // 2797
		mask: EncodeSingleQuote | EncodeRightPeriod,
		in:   "Xn\x16υ＊␇␆|+＠.／ν１４\x1e_\x03η/\x00α＂O；/＜＄．＃",
		out:  "Xn\x16υ＊␇␆|+＠.／ν１４\x1e_\x03η/␀α＂O；/＜＄．＃",
	}, { // 2798
		mask: EncodeSingleQuote | EncodeRightPeriod,
		in:   "Xn\x16υ＊␇␆|+＠.／ν１４\x1e_\x03η/\x00α＂O；/＜＄.．",
		out:  "Xn\x16υ＊␇␆|+＠.／ν１４\x1e_\x03η/␀α＂O；/＜＄.‛．",
	}, { // 2799
		mask: EncodeSingleQuote | EncodeRightPeriod,
		in:   "Xn\x16υ＊␇␆|+＠.／ν１４\x1e_\x03η/\x00α＂O；/＜＄．．",
		out:  "Xn\x16υ＊␇␆|+＠.／ν１４\x1e_\x03η/␀α＂O；/＜＄．‛．",
	}, { // 2800
		mask: EncodeSingleQuote | EncodeRightPeriod,
		in:   "Xn\x16υ＊␇␆|+＠.／ν１４\x1e_\x03η/\x00α＂O；/＜＄β.",
		out:  "Xn\x16υ＊␇␆|+＠.／ν１４\x1e_\x03η/␀α＂O；/＜＄β．",
	}, { // 2801
		mask: EncodeSingleQuote | EncodeRightPeriod,
		in:   "Xn\x16υ＊␇␆|+＠.／ν１４\x1e_\x03η/\x00α＂O；/＜＄β．",
		out:  "Xn\x16υ＊␇␆|+＠.／ν１４\x1e_\x03η/␀α＂O；/＜＄β‛．",
	}, { // 2802
		mask: EncodeBackQuote | EncodeRightPeriod,
		in:   "υ␏\x15TｈZy＞9␆.\x0fωＤＥ？σ|`\x1c]εκtη＊[Ｅ␓␊",
		out:  "υ␏\x15TｈZy＞9␆.\x0fωＤＥ？σ|｀\x1c]εκtη＊[Ｅ␓␊",
	}, { // 2803
		mask: EncodeBackQuote | EncodeRightPeriod,
		in:   ".．\x15TｈZy＞9␆.\x0fωＤＥ？σ|`\x1c]εκtη＊[Ｅ␓␊",
		out:  ".．\x15TｈZy＞9␆.\x0fωＤＥ？σ|｀\x1c]εκtη＊[Ｅ␓␊",
	}, { // 2804
		mask: EncodeBackQuote | EncodeRightPeriod,
		in:   "．．\x15TｈZy＞9␆.\x0fωＤＥ？σ|`\x1c]εκtη＊[Ｅ␓␊",
		out:  "．．\x15TｈZy＞9␆.\x0fωＤＥ？σ|｀\x1c]εκtη＊[Ｅ␓␊",
	}, { // 2805
		mask: EncodeBackQuote | EncodeRightPeriod,
		in:   ".␏\x15TｈZy＞9␆.\x0fωＤＥ？σ|`\x1c]εκtη＊[Ｅ．␊",
		out:  ".␏\x15TｈZy＞9␆.\x0fωＤＥ？σ|｀\x1c]εκtη＊[Ｅ．␊",
	}, { // 2806
		mask: EncodeBackQuote | EncodeRightPeriod,
		in:   "．␏\x15TｈZy＞9␆.\x0fωＤＥ？σ|`\x1c]εκtη＊[Ｅ．␊",
		out:  "．␏\x15TｈZy＞9␆.\x0fωＤＥ？σ|｀\x1c]εκtη＊[Ｅ．␊",
	}, { // 2807
		mask: EncodeBackQuote | EncodeRightPeriod,
		in:   ".␏\x15TｈZy＞9␆.\x0fωＤＥ？σ|`\x1c]εκtη＊[Ｅ␓．",
		out:  ".␏\x15TｈZy＞9␆.\x0fωＤＥ？σ|｀\x1c]εκtη＊[Ｅ␓‛．",
	}, { // 2808
		mask: EncodeBackQuote | EncodeRightPeriod,
		in:   "．␏\x15TｈZy＞9␆.\x0fωＤＥ？σ|`\x1c]εκtη＊[Ｅ␓．",
		out:  "．␏\x15TｈZy＞9␆.\x0fωＤＥ？σ|｀\x1c]εκtη＊[Ｅ␓‛．",
	}, { // 2809
		mask: EncodeBackQuote | EncodeRightPeriod,
		in:   "υ.\x15TｈZy＞9␆.\x0fωＤＥ？σ|`\x1c]εκtη＊[Ｅ␓␊",
		out:  "υ.\x15TｈZy＞9␆.\x0fωＤＥ？σ|｀\x1c]εκtη＊[Ｅ␓␊",
	}, { // 2810
		mask: EncodeBackQuote | EncodeRightPeriod,
		in:   "υ．\x15TｈZy＞9␆.\x0fωＤＥ？σ|`\x1c]εκtη＊[Ｅ␓␊",
		out:  "υ．\x15TｈZy＞9␆.\x0fωＤＥ？σ|｀\x1c]εκtη＊[Ｅ␓␊",
	}, { // 2811
		mask: EncodeBackQuote | EncodeRightPeriod,
		in:   "υ.\x15TｈZy＞9␆.\x0fωＤＥ？σ|`\x1c]εκtη＊[Ｅ．␊",
		out:  "υ.\x15TｈZy＞9␆.\x0fωＤＥ？σ|｀\x1c]εκtη＊[Ｅ．␊",
	}, { // 2812
		mask: EncodeBackQuote | EncodeRightPeriod,
		in:   "υ．\x15TｈZy＞9␆.\x0fωＤＥ？σ|`\x1c]εκtη＊[Ｅ．␊",
		out:  "υ．\x15TｈZy＞9␆.\x0fωＤＥ？σ|｀\x1c]εκtη＊[Ｅ．␊",
	}, { // 2813
		mask: EncodeBackQuote | EncodeRightPeriod,
		in:   "υ.\x15TｈZy＞9␆.\x0fωＤＥ？σ|`\x1c]εκtη＊[Ｅ␓．",
		out:  "υ.\x15TｈZy＞9␆.\x0fωＤＥ？σ|｀\x1c]εκtη＊[Ｅ␓‛．",
	}, { // 2814
		mask: EncodeBackQuote | EncodeRightPeriod,
		in:   "υ．\x15TｈZy＞9␆.\x0fωＤＥ？σ|`\x1c]εκtη＊[Ｅ␓．",
		out:  "υ．\x15TｈZy＞9␆.\x0fωＤＥ？σ|｀\x1c]εκtη＊[Ｅ␓‛．",
	}, { // 2815
		mask: EncodeBackQuote | EncodeRightPeriod,
		in:   "υ␏\x15TｈZy＞9␆.\x0fωＤＥ？σ|`\x1c]εκtη＊[Ｅ.␊",
		out:  "υ␏\x15TｈZy＞9␆.\x0fωＤＥ？σ|｀\x1c]εκtη＊[Ｅ.␊",
	}, { // 2816
		mask: EncodeBackQuote | EncodeRightPeriod,
		in:   "υ␏\x15TｈZy＞9␆.\x0fωＤＥ？σ|`\x1c]εκtη＊[Ｅ．␊",
		out:  "υ␏\x15TｈZy＞9␆.\x0fωＤＥ？σ|｀\x1c]εκtη＊[Ｅ．␊",
	}, { // 2817
		mask: EncodeBackQuote | EncodeRightPeriod,
		in:   "υ␏\x15TｈZy＞9␆.\x0fωＤＥ？σ|`\x1c]εκtη＊[Ｅ.．",
		out:  "υ␏\x15TｈZy＞9␆.\x0fωＤＥ？σ|｀\x1c]εκtη＊[Ｅ.‛．",
	}, { // 2818
		mask: EncodeBackQuote | EncodeRightPeriod,
		in:   "υ␏\x15TｈZy＞9␆.\x0fωＤＥ？σ|`\x1c]εκtη＊[Ｅ．．",
		out:  "υ␏\x15TｈZy＞9␆.\x0fωＤＥ？σ|｀\x1c]εκtη＊[Ｅ．‛．",
	}, { // 2819
		mask: EncodeBackQuote | EncodeRightPeriod,
		in:   "υ␏\x15TｈZy＞9␆.\x0fωＤＥ？σ|`\x1c]εκtη＊[Ｅ␓.",
		out:  "υ␏\x15TｈZy＞9␆.\x0fωＤＥ？σ|｀\x1c]εκtη＊[Ｅ␓．",
	}, { // 2820
		mask: EncodeBackQuote | EncodeRightPeriod,
		in:   "υ␏\x15TｈZy＞9␆.\x0fωＤＥ？σ|`\x1c]εκtη＊[Ｅ␓．",
		out:  "υ␏\x15TｈZy＞9␆.\x0fωＤＥ？σ|｀\x1c]εκtη＊[Ｅ␓‛．",
	}, { // 2821
		mask: EncodeLtGt | EncodeRightPeriod,
		in:   "j\x1e～\x1aξσ␜␖κ<.ς＃j＄\x1f␆M（＋>3ιＹ␀<␕＠O\x14",
		out:  "j\x1e～\x1aξσ␜␖κ＜.ς＃j＄\x1f␆M（＋＞3ιＹ‛␀＜␕＠O\x14",
	}, { // 2822
		mask: EncodeLtGt | EncodeRightPeriod,
		in:   ".．～\x1aξσ␜␖κ<.ς＃j＄\x1f␆M（＋>3ιＹ␀<␕＠O\x14",
		out:  ".．～\x1aξσ␜␖κ＜.ς＃j＄\x1f␆M（＋＞3ιＹ‛␀＜␕＠O\x14",
	}, { // 2823
		mask: EncodeLtGt | EncodeRightPeriod,
		in:   "．．～\x1aξσ␜␖κ<.ς＃j＄\x1f␆M（＋>3ιＹ␀<␕＠O\x14",
		out:  "．．～\x1aξσ␜␖κ＜.ς＃j＄\x1f␆M（＋＞3ιＹ‛␀＜␕＠O\x14",
	}, { // 2824
		mask: EncodeLtGt | EncodeRightPeriod,
		in:   ".\x1e～\x1aξσ␜␖κ<.ς＃j＄\x1f␆M（＋>3ιＹ␀<␕＠．\x14",
		out:  ".\x1e～\x1aξσ␜␖κ＜.ς＃j＄\x1f␆M（＋＞3ιＹ‛␀＜␕＠．\x14",
	}, { // 2825
		mask: EncodeLtGt | EncodeRightPeriod,
		in:   "．\x1e～\x1aξσ␜␖κ<.ς＃j＄\x1f␆M（＋>3ιＹ␀<␕＠．\x14",
		out:  "．\x1e～\x1aξσ␜␖κ＜.ς＃j＄\x1f␆M（＋＞3ιＹ‛␀＜␕＠．\x14",
	}, { // 2826
		mask: EncodeLtGt | EncodeRightPeriod,
		in:   ".\x1e～\x1aξσ␜␖κ<.ς＃j＄\x1f␆M（＋>3ιＹ␀<␕＠O．",
		out:  ".\x1e～\x1aξσ␜␖κ＜.ς＃j＄\x1f␆M（＋＞3ιＹ‛␀＜␕＠O‛．",
	}, { // 2827
		mask: EncodeLtGt | EncodeRightPeriod,
		in:   "．\x1e～\x1aξσ␜␖κ<.ς＃j＄\x1f␆M（＋>3ιＹ␀<␕＠O．",
		out:  "．\x1e～\x1aξσ␜␖κ＜.ς＃j＄\x1f␆M（＋＞3ιＹ‛␀＜␕＠O‛．",
	}, { // 2828
		mask: EncodeLtGt | EncodeRightPeriod,
		in:   "j.～\x1aξσ␜␖κ<.ς＃j＄\x1f␆M（＋>3ιＹ␀<␕＠O\x14",
		out:  "j.～\x1aξσ␜␖κ＜.ς＃j＄\x1f␆M（＋＞3ιＹ‛␀＜␕＠O\x14",
	}, { // 2829
		mask: EncodeLtGt | EncodeRightPeriod,
		in:   "j．～\x1aξσ␜␖κ<.ς＃j＄\x1f␆M（＋>3ιＹ␀<␕＠O\x14",
		out:  "j．～\x1aξσ␜␖κ＜.ς＃j＄\x1f␆M（＋＞3ιＹ‛␀＜␕＠O\x14",
	}, { // 2830
		mask: EncodeLtGt | EncodeRightPeriod,
		in:   "j.～\x1aξσ␜␖κ<.ς＃j＄\x1f␆M（＋>3ιＹ␀<␕＠．\x14",
		out:  "j.～\x1aξσ␜␖κ＜.ς＃j＄\x1f␆M（＋＞3ιＹ‛␀＜␕＠．\x14",
	}, { // 2831
		mask: EncodeLtGt | EncodeRightPeriod,
		in:   "j．～\x1aξσ␜␖κ<.ς＃j＄\x1f␆M（＋>3ιＹ␀<␕＠．\x14",
		out:  "j．～\x1aξσ␜␖κ＜.ς＃j＄\x1f␆M（＋＞3ιＹ‛␀＜␕＠．\x14",
	}, { // 2832
		mask: EncodeLtGt | EncodeRightPeriod,
		in:   "j.～\x1aξσ␜␖κ<.ς＃j＄\x1f␆M（＋>3ιＹ␀<␕＠O．",
		out:  "j.～\x1aξσ␜␖κ＜.ς＃j＄\x1f␆M（＋＞3ιＹ‛␀＜␕＠O‛．",
	}, { // 2833
		mask: EncodeLtGt | EncodeRightPeriod,
		in:   "j．～\x1aξσ␜␖κ<.ς＃j＄\x1f␆M（＋>3ιＹ␀<␕＠O．",
		out:  "j．～\x1aξσ␜␖κ＜.ς＃j＄\x1f␆M（＋＞3ιＹ‛␀＜␕＠O‛．",
	}, { // 2834
		mask: EncodeLtGt | EncodeRightPeriod,
		in:   "j\x1e～\x1aξσ␜␖κ<.ς＃j＄\x1f␆M（＋>3ιＹ␀<␕＠.\x14",
		out:  "j\x1e～\x1aξσ␜␖κ＜.ς＃j＄\x1f␆M（＋＞3ιＹ‛␀＜␕＠.\x14",
	}, { // 2835
		mask: EncodeLtGt | EncodeRightPeriod,
		in:   "j\x1e～\x1aξσ␜␖κ<.ς＃j＄\x1f␆M（＋>3ιＹ␀<␕＠．\x14",
		out:  "j\x1e～\x1aξσ␜␖κ＜.ς＃j＄\x1f␆M（＋＞3ιＹ‛␀＜␕＠．\x14",
	}, { // 2836
		mask: EncodeLtGt | EncodeRightPeriod,
		in:   "j\x1e～\x1aξσ␜␖κ<.ς＃j＄\x1f␆M（＋>3ιＹ␀<␕＠.．",
		out:  "j\x1e～\x1aξσ␜␖κ＜.ς＃j＄\x1f␆M（＋＞3ιＹ‛␀＜␕＠.‛．",
	}, { // 2837
		mask: EncodeLtGt | EncodeRightPeriod,
		in:   "j\x1e～\x1aξσ␜␖κ<.ς＃j＄\x1f␆M（＋>3ιＹ␀<␕＠．．",
		out:  "j\x1e～\x1aξσ␜␖κ＜.ς＃j＄\x1f␆M（＋＞3ιＹ‛␀＜␕＠．‛．",
	}, { // 2838
		mask: EncodeLtGt | EncodeRightPeriod,
		in:   "j\x1e～\x1aξσ␜␖κ<.ς＃j＄\x1f␆M（＋>3ιＹ␀<␕＠O.",
		out:  "j\x1e～\x1aξσ␜␖κ＜.ς＃j＄\x1f␆M（＋＞3ιＹ‛␀＜␕＠O．",
	}, { // 2839
		mask: EncodeLtGt | EncodeRightPeriod,
		in:   "j\x1e～\x1aξσ␜␖κ<.ς＃j＄\x1f␆M（＋>3ιＹ␀<␕＠O．",
		out:  "j\x1e～\x1aξσ␜␖κ＜.ς＃j＄\x1f␆M（＋＞3ιＹ‛␀＜␕＠O‛．",
	}, { // 2840
		mask: EncodeSquareBracket | EncodeRightPeriod,
		in:   "<g9ｓ␇␄β\x0e␗９.{␌Ｅ\x1d/S\x0f＊ＺUυν\x0e％\x16ｆ｝ςυ",
		out:  "<g9ｓ␇␄β\x0e␗９.{␌Ｅ\x1d/S\x0f＊ＺUυν\x0e％\x16ｆ｝ςυ",
	}, { // 2841
		mask: EncodeSquareBracket | EncodeRightPeriod,
		in:   ".．9ｓ␇␄β\x0e␗９.{␌Ｅ\x1d/S\x0f＊ＺUυν\x0e％\x16ｆ｝ςυ",
		out:  ".．9ｓ␇␄β\x0e␗９.{␌Ｅ\x1d/S\x0f＊ＺUυν\x0e％\x16ｆ｝ςυ",
	}, { // 2842
		mask: EncodeSquareBracket | EncodeRightPeriod,
		in:   "．．9ｓ␇␄β\x0e␗９.{␌Ｅ\x1d/S\x0f＊ＺUυν\x0e％\x16ｆ｝ςυ",
		out:  "．．9ｓ␇␄β\x0e␗９.{␌Ｅ\x1d/S\x0f＊ＺUυν\x0e％\x16ｆ｝ςυ",
	}, { // 2843
		mask: EncodeSquareBracket | EncodeRightPeriod,
		in:   ".g9ｓ␇␄β\x0e␗９.{␌Ｅ\x1d/S\x0f＊ＺUυν\x0e％\x16ｆ｝．υ",
		out:  ".g9ｓ␇␄β\x0e␗９.{␌Ｅ\x1d/S\x0f＊ＺUυν\x0e％\x16ｆ｝．υ",
	}, { // 2844
		mask: EncodeSquareBracket | EncodeRightPeriod,
		in:   "．g9ｓ␇␄β\x0e␗９.{␌Ｅ\x1d/S\x0f＊ＺUυν\x0e％\x16ｆ｝．υ",
		out:  "．g9ｓ␇␄β\x0e␗９.{␌Ｅ\x1d/S\x0f＊ＺUυν\x0e％\x16ｆ｝．υ",
	}, { // 2845
		mask: EncodeSquareBracket | EncodeRightPeriod,
		in:   ".g9ｓ␇␄β\x0e␗９.{␌Ｅ\x1d/S\x0f＊ＺUυν\x0e％\x16ｆ｝ς．",
		out:  ".g9ｓ␇␄β\x0e␗９.{␌Ｅ\x1d/S\x0f＊ＺUυν\x0e％\x16ｆ｝ς‛．",
	}, { // 2846
		mask: EncodeSquareBracket | EncodeRightPeriod,
		in:   "．g9ｓ␇␄β\x0e␗９.{␌Ｅ\x1d/S\x0f＊ＺUυν\x0e％\x16ｆ｝ς．",
		out:  "．g9ｓ␇␄β\x0e␗９.{␌Ｅ\x1d/S\x0f＊ＺUυν\x0e％\x16ｆ｝ς‛．",
	}, { // 2847
		mask: EncodeSquareBracket | EncodeRightPeriod,
		in:   "<.9ｓ␇␄β\x0e␗９.{␌Ｅ\x1d/S\x0f＊ＺUυν\x0e％\x16ｆ｝ςυ",
		out:  "<.9ｓ␇␄β\x0e␗９.{␌Ｅ\x1d/S\x0f＊ＺUυν\x0e％\x16ｆ｝ςυ",
	}, { // 2848
		mask: EncodeSquareBracket | EncodeRightPeriod,
		in:   "<．9ｓ␇␄β\x0e␗９.{␌Ｅ\x1d/S\x0f＊ＺUυν\x0e％\x16ｆ｝ςυ",
		out:  "<．9ｓ␇␄β\x0e␗９.{␌Ｅ\x1d/S\x0f＊ＺUυν\x0e％\x16ｆ｝ςυ",
	}, { // 2849
		mask: EncodeSquareBracket | EncodeRightPeriod,
		in:   "<.9ｓ␇␄β\x0e␗９.{␌Ｅ\x1d/S\x0f＊ＺUυν\x0e％\x16ｆ｝．υ",
		out:  "<.9ｓ␇␄β\x0e␗９.{␌Ｅ\x1d/S\x0f＊ＺUυν\x0e％\x16ｆ｝．υ",
	}, { // 2850
		mask: EncodeSquareBracket | EncodeRightPeriod,
		in:   "<．9ｓ␇␄β\x0e␗９.{␌Ｅ\x1d/S\x0f＊ＺUυν\x0e％\x16ｆ｝．υ",
		out:  "<．9ｓ␇␄β\x0e␗９.{␌Ｅ\x1d/S\x0f＊ＺUυν\x0e％\x16ｆ｝．υ",
	}, { // 2851
		mask: EncodeSquareBracket | EncodeRightPeriod,
		in:   "<.9ｓ␇␄β\x0e␗９.{␌Ｅ\x1d/S\x0f＊ＺUυν\x0e％\x16ｆ｝ς．",
		out:  "<.9ｓ␇␄β\x0e␗９.{␌Ｅ\x1d/S\x0f＊ＺUυν\x0e％\x16ｆ｝ς‛．",
	}, { // 2852
		mask: EncodeSquareBracket | EncodeRightPeriod,
		in:   "<．9ｓ␇␄β\x0e␗９.{␌Ｅ\x1d/S\x0f＊ＺUυν\x0e％\x16ｆ｝ς．",
		out:  "<．9ｓ␇␄β\x0e␗９.{␌Ｅ\x1d/S\x0f＊ＺUυν\x0e％\x16ｆ｝ς‛．",
	}, { // 2853
		mask: EncodeSquareBracket | EncodeRightPeriod,
		in:   "<g9ｓ␇␄β\x0e␗９.{␌Ｅ\x1d/S\x0f＊ＺUυν\x0e％\x16ｆ｝.υ",
		out:  "<g9ｓ␇␄β\x0e␗９.{␌Ｅ\x1d/S\x0f＊ＺUυν\x0e％\x16ｆ｝.υ",
	}, { // 2854
		mask: EncodeSquareBracket | EncodeRightPeriod,
		in:   "<g9ｓ␇␄β\x0e␗９.{␌Ｅ\x1d/S\x0f＊ＺUυν\x0e％\x16ｆ｝．υ",
		out:  "<g9ｓ␇␄β\x0e␗９.{␌Ｅ\x1d/S\x0f＊ＺUυν\x0e％\x16ｆ｝．υ",
	}, { // 2855
		mask: EncodeSquareBracket | EncodeRightPeriod,
		in:   "<g9ｓ␇␄β\x0e␗９.{␌Ｅ\x1d/S\x0f＊ＺUυν\x0e％\x16ｆ｝.．",
		out:  "<g9ｓ␇␄β\x0e␗９.{␌Ｅ\x1d/S\x0f＊ＺUυν\x0e％\x16ｆ｝.‛．",
	}, { // 2856
		mask: EncodeSquareBracket | EncodeRightPeriod,
		in:   "<g9ｓ␇␄β\x0e␗９.{␌Ｅ\x1d/S\x0f＊ＺUυν\x0e％\x16ｆ｝．．",
		out:  "<g9ｓ␇␄β\x0e␗９.{␌Ｅ\x1d/S\x0f＊ＺUυν\x0e％\x16ｆ｝．‛．",
	}, { // 2857
		mask: EncodeSquareBracket | EncodeRightPeriod,
		in:   "<g9ｓ␇␄β\x0e␗９.{␌Ｅ\x1d/S\x0f＊ＺUυν\x0e％\x16ｆ｝ς.",
		out:  "<g9ｓ␇␄β\x0e␗９.{␌Ｅ\x1d/S\x0f＊ＺUυν\x0e％\x16ｆ｝ς．",
	}, { // 2858
		mask: EncodeSquareBracket | EncodeRightPeriod,
		in:   "<g9ｓ␇␄β\x0e␗９.{␌Ｅ\x1d/S\x0f＊ＺUυν\x0e％\x16ｆ｝ς．",
		out:  "<g9ｓ␇␄β\x0e␗９.{␌Ｅ\x1d/S\x0f＊ＺUυν\x0e％\x16ｆ｝ς‛．",
	}, { // 2859
		mask: EncodeSemicolon | EncodeRightPeriod,
		in:   ">Ｍ：Q＞\x00\v］␟α.τςＮ\x1c␘\"␙␈\x1ccν\nγ２hξw␅ｖ",
		out:  ">Ｍ：Q＞␀\v］␟α.τςＮ\x1c␘\"␙␈\x1ccν\nγ２hξw␅ｖ",
	}, { // 2860
		mask: EncodeSemicolon | EncodeRightPeriod,
		in:   ".．：Q＞\x00\v］␟α.τςＮ\x1c␘\"␙␈\x1ccν\nγ２hξw␅ｖ",
		out:  ".．：Q＞␀\v］␟α.τςＮ\x1c␘\"␙␈\x1ccν\nγ２hξw␅ｖ",
	}, { // 2861
		mask: EncodeSemicolon | EncodeRightPeriod,
		in:   "．．：Q＞\x00\v］␟α.τςＮ\x1c␘\"␙␈\x1ccν\nγ２hξw␅ｖ",
		out:  "．．：Q＞␀\v］␟α.τςＮ\x1c␘\"␙␈\x1ccν\nγ２hξw␅ｖ",
	}, { // 2862
		mask: EncodeSemicolon | EncodeRightPeriod,
		in:   ".Ｍ：Q＞\x00\v］␟α.τςＮ\x1c␘\"␙␈\x1ccν\nγ２hξw．ｖ",
		out:  ".Ｍ：Q＞␀\v］␟α.τςＮ\x1c␘\"␙␈\x1ccν\nγ２hξw．ｖ",
	}, { // 2863
		mask: EncodeSemicolon | EncodeRightPeriod,
		in:   "．Ｍ：Q＞\x00\v］␟α.τςＮ\x1c␘\"␙␈\x1ccν\nγ２hξw．ｖ",
		out:  "．Ｍ：Q＞␀\v］␟α.τςＮ\x1c␘\"␙␈\x1ccν\nγ２hξw．ｖ",
	}, { // 2864
		mask: EncodeSemicolon | EncodeRightPeriod,
		in:   ".Ｍ：Q＞\x00\v］␟α.τςＮ\x1c␘\"␙␈\x1ccν\nγ２hξw␅．",
		out:  ".Ｍ：Q＞␀\v］␟α.τςＮ\x1c␘\"␙␈\x1ccν\nγ２hξw␅‛．",
	}, { // 2865
		mask: EncodeSemicolon | EncodeRightPeriod,
		in:   "．Ｍ：Q＞\x00\v］␟α.τςＮ\x1c␘\"␙␈\x1ccν\nγ２hξw␅．",
		out:  "．Ｍ：Q＞␀\v］␟α.τςＮ\x1c␘\"␙␈\x1ccν\nγ２hξw␅‛．",
	}, { // 2866
		mask: EncodeSemicolon | EncodeRightPeriod,
		in:   ">.：Q＞\x00\v］␟α.τςＮ\x1c␘\"␙␈\x1ccν\nγ２hξw␅ｖ",
		out:  ">.：Q＞␀\v］␟α.τςＮ\x1c␘\"␙␈\x1ccν\nγ２hξw␅ｖ",
	}, { // 2867
		mask: EncodeSemicolon | EncodeRightPeriod,
		in:   ">．：Q＞\x00\v］␟α.τςＮ\x1c␘\"␙␈\x1ccν\nγ２hξw␅ｖ",
		out:  ">．：Q＞␀\v］␟α.τςＮ\x1c␘\"␙␈\x1ccν\nγ２hξw␅ｖ",
	}, { // 2868
		mask: EncodeSemicolon | EncodeRightPeriod,
		in:   ">.：Q＞\x00\v］␟α.τςＮ\x1c␘\"␙␈\x1ccν\nγ２hξw．ｖ",
		out:  ">.：Q＞␀\v］␟α.τςＮ\x1c␘\"␙␈\x1ccν\nγ２hξw．ｖ",
	}, { // 2869
		mask: EncodeSemicolon | EncodeRightPeriod,
		in:   ">．：Q＞\x00\v］␟α.τςＮ\x1c␘\"␙␈\x1ccν\nγ２hξw．ｖ",
		out:  ">．：Q＞␀\v］␟α.τςＮ\x1c␘\"␙␈\x1ccν\nγ２hξw．ｖ",
	}, { // 2870
		mask: EncodeSemicolon | EncodeRightPeriod,
		in:   ">.：Q＞\x00\v］␟α.τςＮ\x1c␘\"␙␈\x1ccν\nγ２hξw␅．",
		out:  ">.：Q＞␀\v］␟α.τςＮ\x1c␘\"␙␈\x1ccν\nγ２hξw␅‛．",
	}, { // 2871
		mask: EncodeSemicolon | EncodeRightPeriod,
		in:   ">．：Q＞\x00\v］␟α.τςＮ\x1c␘\"␙␈\x1ccν\nγ２hξw␅．",
		out:  ">．：Q＞␀\v］␟α.τςＮ\x1c␘\"␙␈\x1ccν\nγ２hξw␅‛．",
	}, { // 2872
		mask: EncodeSemicolon | EncodeRightPeriod,
		in:   ">Ｍ：Q＞\x00\v］␟α.τςＮ\x1c␘\"␙␈\x1ccν\nγ２hξw.ｖ",
		out:  ">Ｍ：Q＞␀\v］␟α.τςＮ\x1c␘\"␙␈\x1ccν\nγ２hξw.ｖ",
	}, { // 2873
		mask: EncodeSemicolon | EncodeRightPeriod,
		in:   ">Ｍ：Q＞\x00\v］␟α.τςＮ\x1c␘\"␙␈\x1ccν\nγ２hξw．ｖ",
		out:  ">Ｍ：Q＞␀\v］␟α.τςＮ\x1c␘\"␙␈\x1ccν\nγ２hξw．ｖ",
	}, { // 2874
		mask: EncodeSemicolon | EncodeRightPeriod,
		in:   ">Ｍ：Q＞\x00\v］␟α.τςＮ\x1c␘\"␙␈\x1ccν\nγ２hξw.．",
		out:  ">Ｍ：Q＞␀\v］␟α.τςＮ\x1c␘\"␙␈\x1ccν\nγ２hξw.‛．",
	}, { // 2875
		mask: EncodeSemicolon | EncodeRightPeriod,
		in:   ">Ｍ：Q＞\x00\v］␟α.τςＮ\x1c␘\"␙␈\x1ccν\nγ２hξw．．",
		out:  ">Ｍ：Q＞␀\v］␟α.τςＮ\x1c␘\"␙␈\x1ccν\nγ２hξw．‛．",
	}, { // 2876
		mask: EncodeSemicolon | EncodeRightPeriod,
		in:   ">Ｍ：Q＞\x00\v］␟α.τςＮ\x1c␘\"␙␈\x1ccν\nγ２hξw␅.",
		out:  ">Ｍ：Q＞␀\v］␟α.τςＮ\x1c␘\"␙␈\x1ccν\nγ２hξw␅．",
	}, { // 2877
		mask: EncodeSemicolon | EncodeRightPeriod,
		in:   ">Ｍ：Q＞\x00\v］␟α.τςＮ\x1c␘\"␙␈\x1ccν\nγ２hξw␅．",
		out:  ">Ｍ：Q＞␀\v］␟α.τςＮ\x1c␘\"␙␈\x1ccν\nγ２hξw␅‛．",
	}, { // 2878
		mask: EncodeDollar | EncodeRightPeriod,
		in:   "（ε\x18␞␂␔ｕ=Sγ.*λ\x1c０␏Q｜/λ［\rｃ［ωＴ0|\x01-",
		out:  "（ε\x18␞␂␔ｕ=Sγ.*λ\x1c０␏Q｜/λ［\rｃ［ωＴ0|\x01-",
	}, { // 2879
		mask: EncodeDollar | EncodeRightPeriod,
		in:   ".．\x18␞␂␔ｕ=Sγ.*λ\x1c０␏Q｜/λ［\rｃ［ωＴ0|\x01-",
		out:  ".．\x18␞␂␔ｕ=Sγ.*λ\x1c０␏Q｜/λ［\rｃ［ωＴ0|\x01-",
	}, { // 2880
		mask: EncodeDollar | EncodeRightPeriod,
		in:   "．．\x18␞␂␔ｕ=Sγ.*λ\x1c０␏Q｜/λ［\rｃ［ωＴ0|\x01-",
		out:  "．．\x18␞␂␔ｕ=Sγ.*λ\x1c０␏Q｜/λ［\rｃ［ωＴ0|\x01-",
	}, { // 2881
		mask: EncodeDollar | EncodeRightPeriod,
		in:   ".ε\x18␞␂␔ｕ=Sγ.*λ\x1c０␏Q｜/λ［\rｃ［ωＴ0|．-",
		out:  ".ε\x18␞␂␔ｕ=Sγ.*λ\x1c０␏Q｜/λ［\rｃ［ωＴ0|．-",
	}, { // 2882
		mask: EncodeDollar | EncodeRightPeriod,
		in:   "．ε\x18␞␂␔ｕ=Sγ.*λ\x1c０␏Q｜/λ［\rｃ［ωＴ0|．-",
		out:  "．ε\x18␞␂␔ｕ=Sγ.*λ\x1c０␏Q｜/λ［\rｃ［ωＴ0|．-",
	}, { // 2883
		mask: EncodeDollar | EncodeRightPeriod,
		in:   ".ε\x18␞␂␔ｕ=Sγ.*λ\x1c０␏Q｜/λ［\rｃ［ωＴ0|\x01．",
		out:  ".ε\x18␞␂␔ｕ=Sγ.*λ\x1c０␏Q｜/λ［\rｃ［ωＴ0|\x01‛．",
	}, { // 2884
		mask: EncodeDollar | EncodeRightPeriod,
		in:   "．ε\x18␞␂␔ｕ=Sγ.*λ\x1c０␏Q｜/λ［\rｃ［ωＴ0|\x01．",
		out:  "．ε\x18␞␂␔ｕ=Sγ.*λ\x1c０␏Q｜/λ［\rｃ［ωＴ0|\x01‛．",
	}, { // 2885
		mask: EncodeDollar | EncodeRightPeriod,
		in:   "（.\x18␞␂␔ｕ=Sγ.*λ\x1c０␏Q｜/λ［\rｃ［ωＴ0|\x01-",
		out:  "（.\x18␞␂␔ｕ=Sγ.*λ\x1c０␏Q｜/λ［\rｃ［ωＴ0|\x01-",
	}, { // 2886
		mask: EncodeDollar | EncodeRightPeriod,
		in:   "（．\x18␞␂␔ｕ=Sγ.*λ\x1c０␏Q｜/λ［\rｃ［ωＴ0|\x01-",
		out:  "（．\x18␞␂␔ｕ=Sγ.*λ\x1c０␏Q｜/λ［\rｃ［ωＴ0|\x01-",
	}, { // 2887
		mask: EncodeDollar | EncodeRightPeriod,
		in:   "（.\x18␞␂␔ｕ=Sγ.*λ\x1c０␏Q｜/λ［\rｃ［ωＴ0|．-",
		out:  "（.\x18␞␂␔ｕ=Sγ.*λ\x1c０␏Q｜/λ［\rｃ［ωＴ0|．-",
	}, { // 2888
		mask: EncodeDollar | EncodeRightPeriod,
		in:   "（．\x18␞␂␔ｕ=Sγ.*λ\x1c０␏Q｜/λ［\rｃ［ωＴ0|．-",
		out:  "（．\x18␞␂␔ｕ=Sγ.*λ\x1c０␏Q｜/λ［\rｃ［ωＴ0|．-",
	}, { // 2889
		mask: EncodeDollar | EncodeRightPeriod,
		in:   "（.\x18␞␂␔ｕ=Sγ.*λ\x1c０␏Q｜/λ［\rｃ［ωＴ0|\x01．",
		out:  "（.\x18␞␂␔ｕ=Sγ.*λ\x1c０␏Q｜/λ［\rｃ［ωＴ0|\x01‛．",
	}, { // 2890
		mask: EncodeDollar | EncodeRightPeriod,
		in:   "（．\x18␞␂␔ｕ=Sγ.*λ\x1c０␏Q｜/λ［\rｃ［ωＴ0|\x01．",
		out:  "（．\x18␞␂␔ｕ=Sγ.*λ\x1c０␏Q｜/λ［\rｃ［ωＴ0|\x01‛．",
	}, { // 2891
		mask: EncodeDollar | EncodeRightPeriod,
		in:   "（ε\x18␞␂␔ｕ=Sγ.*λ\x1c０␏Q｜/λ［\rｃ［ωＴ0|.-",
		out:  "（ε\x18␞␂␔ｕ=Sγ.*λ\x1c０␏Q｜/λ［\rｃ［ωＴ0|.-",
	}, { // 2892
		mask: EncodeDollar | EncodeRightPeriod,
		in:   "（ε\x18␞␂␔ｕ=Sγ.*λ\x1c０␏Q｜/λ［\rｃ［ωＴ0|．-",
		out:  "（ε\x18␞␂␔ｕ=Sγ.*λ\x1c０␏Q｜/λ［\rｃ［ωＴ0|．-",
	}, { // 2893
		mask: EncodeDollar | EncodeRightPeriod,
		in:   "（ε\x18␞␂␔ｕ=Sγ.*λ\x1c０␏Q｜/λ［\rｃ［ωＴ0|.．",
		out:  "（ε\x18␞␂␔ｕ=Sγ.*λ\x1c０␏Q｜/λ［\rｃ［ωＴ0|.‛．",
	}, { // 2894
		mask: EncodeDollar | EncodeRightPeriod,
		in:   "（ε\x18␞␂␔ｕ=Sγ.*λ\x1c０␏Q｜/λ［\rｃ［ωＴ0|．．",
		out:  "（ε\x18␞␂␔ｕ=Sγ.*λ\x1c０␏Q｜/λ［\rｃ［ωＴ0|．‛．",
	}, { // 2895
		mask: EncodeDollar | EncodeRightPeriod,
		in:   "（ε\x18␞␂␔ｕ=Sγ.*λ\x1c０␏Q｜/λ［\rｃ［ωＴ0|\x01.",
		out:  "（ε\x18␞␂␔ｕ=Sγ.*λ\x1c０␏Q｜/λ［\rｃ［ωＴ0|\x01．",
	}, { // 2896
		mask: EncodeDollar | EncodeRightPeriod,
		in:   "（ε\x18␞␂␔ｕ=Sγ.*λ\x1c０␏Q｜/λ［\rｃ［ωＴ0|\x01．",
		out:  "（ε\x18␞␂␔ｕ=Sγ.*λ\x1c０␏Q｜/λ［\rｃ［ωＴ0|\x01‛．",
	}, { // 2897
		mask: EncodeDoubleQuote | EncodeRightPeriod,
		in:   "ιη\v␃\bπ2＄[\x1c.␂\\.４␘ξ\x1d{（j}␍υμ␏>Ｐｊ６",
		out:  "ιη\v␃\bπ2＄[\x1c.␂\\.４␘ξ\x1d{（j}␍υμ␏>Ｐｊ６",
	}, { // 2898
		mask: EncodeDoubleQuote | EncodeRightPeriod,
		in:   ".．\v␃\bπ2＄[\x1c.␂\\.４␘ξ\x1d{（j}␍υμ␏>Ｐｊ６",
		out:  ".．\v␃\bπ2＄[\x1c.␂\\.４␘ξ\x1d{（j}␍υμ␏>Ｐｊ６",
	}, { // 2899
		mask: EncodeDoubleQuote | EncodeRightPeriod,
		in:   "．．\v␃\bπ2＄[\x1c.␂\\.４␘ξ\x1d{（j}␍υμ␏>Ｐｊ６",
		out:  "．．\v␃\bπ2＄[\x1c.␂\\.４␘ξ\x1d{（j}␍υμ␏>Ｐｊ６",
	}, { // 2900
		mask: EncodeDoubleQuote | EncodeRightPeriod,
		in:   ".η\v␃\bπ2＄[\x1c.␂\\.４␘ξ\x1d{（j}␍υμ␏>Ｐ．６",
		out:  ".η\v␃\bπ2＄[\x1c.␂\\.４␘ξ\x1d{（j}␍υμ␏>Ｐ．６",
	}, { // 2901
		mask: EncodeDoubleQuote | EncodeRightPeriod,
		in:   "．η\v␃\bπ2＄[\x1c.␂\\.４␘ξ\x1d{（j}␍υμ␏>Ｐ．６",
		out:  "．η\v␃\bπ2＄[\x1c.␂\\.４␘ξ\x1d{（j}␍υμ␏>Ｐ．６",
	}, { // 2902
		mask: EncodeDoubleQuote | EncodeRightPeriod,
		in:   ".η\v␃\bπ2＄[\x1c.␂\\.４␘ξ\x1d{（j}␍υμ␏>Ｐｊ．",
		out:  ".η\v␃\bπ2＄[\x1c.␂\\.４␘ξ\x1d{（j}␍υμ␏>Ｐｊ‛．",
	}, { // 2903
		mask: EncodeDoubleQuote | EncodeRightPeriod,
		in:   "．η\v␃\bπ2＄[\x1c.␂\\.４␘ξ\x1d{（j}␍υμ␏>Ｐｊ．",
		out:  "．η\v␃\bπ2＄[\x1c.␂\\.４␘ξ\x1d{（j}␍υμ␏>Ｐｊ‛．",
	}, { // 2904
		mask: EncodeDoubleQuote | EncodeRightPeriod,
		in:   "ι.\v␃\bπ2＄[\x1c.␂\\.４␘ξ\x1d{（j}␍υμ␏>Ｐｊ６",
		out:  "ι.\v␃\bπ2＄[\x1c.␂\\.４␘ξ\x1d{（j}␍υμ␏>Ｐｊ６",
	}, { // 2905
		mask: EncodeDoubleQuote | EncodeRightPeriod,
		in:   "ι．\v␃\bπ2＄[\x1c.␂\\.４␘ξ\x1d{（j}␍υμ␏>Ｐｊ６",
		out:  "ι．\v␃\bπ2＄[\x1c.␂\\.４␘ξ\x1d{（j}␍υμ␏>Ｐｊ６",
	}, { // 2906
		mask: EncodeDoubleQuote | EncodeRightPeriod,
		in:   "ι.\v␃\bπ2＄[\x1c.␂\\.４␘ξ\x1d{（j}␍υμ␏>Ｐ．６",
		out:  "ι.\v␃\bπ2＄[\x1c.␂\\.４␘ξ\x1d{（j}␍υμ␏>Ｐ．６",
	}, { // 2907
		mask: EncodeDoubleQuote | EncodeRightPeriod,
		in:   "ι．\v␃\bπ2＄[\x1c.␂\\.４␘ξ\x1d{（j}␍υμ␏>Ｐ．６",
		out:  "ι．\v␃\bπ2＄[\x1c.␂\\.４␘ξ\x1d{（j}␍υμ␏>Ｐ．６",
	}, { // 2908
		mask: EncodeDoubleQuote | EncodeRightPeriod,
		in:   "ι.\v␃\bπ2＄[\x1c.␂\\.４␘ξ\x1d{（j}␍υμ␏>Ｐｊ．",
		out:  "ι.\v␃\bπ2＄[\x1c.␂\\.４␘ξ\x1d{（j}␍υμ␏>Ｐｊ‛．",
	}, { // 2909
		mask: EncodeDoubleQuote | EncodeRightPeriod,
		in:   "ι．\v␃\bπ2＄[\x1c.␂\\.４␘ξ\x1d{（j}␍υμ␏>Ｐｊ．",
		out:  "ι．\v␃\bπ2＄[\x1c.␂\\.４␘ξ\x1d{（j}␍υμ␏>Ｐｊ‛．",
	}, { // 2910
		mask: EncodeDoubleQuote | EncodeRightPeriod,
		in:   "ιη\v␃\bπ2＄[\x1c.␂\\.４␘ξ\x1d{（j}␍υμ␏>Ｐ.６",
		out:  "ιη\v␃\bπ2＄[\x1c.␂\\.４␘ξ\x1d{（j}␍υμ␏>Ｐ.６",
	}, { // 2911
		mask: EncodeDoubleQuote | EncodeRightPeriod,
		in:   "ιη\v␃\bπ2＄[\x1c.␂\\.４␘ξ\x1d{（j}␍υμ␏>Ｐ．６",
		out:  "ιη\v␃\bπ2＄[\x1c.␂\\.４␘ξ\x1d{（j}␍υμ␏>Ｐ．６",
	}, { // 2912
		mask: EncodeDoubleQuote | EncodeRightPeriod,
		in:   "ιη\v␃\bπ2＄[\x1c.␂\\.４␘ξ\x1d{（j}␍υμ␏>Ｐ.．",
		out:  "ιη\v␃\bπ2＄[\x1c.␂\\.４␘ξ\x1d{（j}␍υμ␏>Ｐ.‛．",
	}, { // 2913
		mask: EncodeDoubleQuote | EncodeRightPeriod,
		in:   "ιη\v␃\bπ2＄[\x1c.␂\\.４␘ξ\x1d{（j}␍υμ␏>Ｐ．．",
		out:  "ιη\v␃\bπ2＄[\x1c.␂\\.４␘ξ\x1d{（j}␍υμ␏>Ｐ．‛．",
	}, { // 2914
		mask: EncodeDoubleQuote | EncodeRightPeriod,
		in:   "ιη\v␃\bπ2＄[\x1c.␂\\.４␘ξ\x1d{（j}␍υμ␏>Ｐｊ.",
		out:  "ιη\v␃\bπ2＄[\x1c.␂\\.４␘ξ\x1d{（j}␍υμ␏>Ｐｊ．",
	}, { // 2915
		mask: EncodeDoubleQuote | EncodeRightPeriod,
		in:   "ιη\v␃\bπ2＄[\x1c.␂\\.４␘ξ\x1d{（j}␍υμ␏>Ｐｊ．",
		out:  "ιη\v␃\bπ2＄[\x1c.␂\\.４␘ξ\x1d{（j}␍υμ␏>Ｐｊ‛．",
	}, { // 2916
		mask: EncodeColon | EncodeRightPeriod,
		in:   "υ\"␗｜ρ＼\"\x1f\x00ｒ.λg\x0ex＂␡<N␄ρλ５ｓς｀\x19h␎Ｍ",
		out:  "υ\"␗｜ρ＼\"\x1f␀ｒ.λg\x0ex＂␡<N␄ρλ５ｓς｀\x19h␎Ｍ",
	}, { // 2917
		mask: EncodeColon | EncodeRightPeriod,
		in:   ".．␗｜ρ＼\"\x1f\x00ｒ.λg\x0ex＂␡<N␄ρλ５ｓς｀\x19h␎Ｍ",
		out:  ".．␗｜ρ＼\"\x1f␀ｒ.λg\x0ex＂␡<N␄ρλ５ｓς｀\x19h␎Ｍ",
	}, { // 2918
		mask: EncodeColon | EncodeRightPeriod,
		in:   "．．␗｜ρ＼\"\x1f\x00ｒ.λg\x0ex＂␡<N␄ρλ５ｓς｀\x19h␎Ｍ",
		out:  "．．␗｜ρ＼\"\x1f␀ｒ.λg\x0ex＂␡<N␄ρλ５ｓς｀\x19h␎Ｍ",
	}, { // 2919
		mask: EncodeColon | EncodeRightPeriod,
		in:   ".\"␗｜ρ＼\"\x1f\x00ｒ.λg\x0ex＂␡<N␄ρλ５ｓς｀\x19h．Ｍ",
		out:  ".\"␗｜ρ＼\"\x1f␀ｒ.λg\x0ex＂␡<N␄ρλ５ｓς｀\x19h．Ｍ",
	}, { // 2920
		mask: EncodeColon | EncodeRightPeriod,
		in:   "．\"␗｜ρ＼\"\x1f\x00ｒ.λg\x0ex＂␡<N␄ρλ５ｓς｀\x19h．Ｍ",
		out:  "．\"␗｜ρ＼\"\x1f␀ｒ.λg\x0ex＂␡<N␄ρλ５ｓς｀\x19h．Ｍ",
	}, { // 2921
		mask: EncodeColon | EncodeRightPeriod,
		in:   ".\"␗｜ρ＼\"\x1f\x00ｒ.λg\x0ex＂␡<N␄ρλ５ｓς｀\x19h␎．",
		out:  ".\"␗｜ρ＼\"\x1f␀ｒ.λg\x0ex＂␡<N␄ρλ５ｓς｀\x19h␎‛．",
	}, { // 2922
		mask: EncodeColon | EncodeRightPeriod,
		in:   "．\"␗｜ρ＼\"\x1f\x00ｒ.λg\x0ex＂␡<N␄ρλ５ｓς｀\x19h␎．",
		out:  "．\"␗｜ρ＼\"\x1f␀ｒ.λg\x0ex＂␡<N␄ρλ５ｓς｀\x19h␎‛．",
	}, { // 2923
		mask: EncodeColon | EncodeRightPeriod,
		in:   "υ.␗｜ρ＼\"\x1f\x00ｒ.λg\x0ex＂␡<N␄ρλ５ｓς｀\x19h␎Ｍ",
		out:  "υ.␗｜ρ＼\"\x1f␀ｒ.λg\x0ex＂␡<N␄ρλ５ｓς｀\x19h␎Ｍ",
	}, { // 2924
		mask: EncodeColon | EncodeRightPeriod,
		in:   "υ．␗｜ρ＼\"\x1f\x00ｒ.λg\x0ex＂␡<N␄ρλ５ｓς｀\x19h␎Ｍ",
		out:  "υ．␗｜ρ＼\"\x1f␀ｒ.λg\x0ex＂␡<N␄ρλ５ｓς｀\x19h␎Ｍ",
	}, { // 2925
		mask: EncodeColon | EncodeRightPeriod,
		in:   "υ.␗｜ρ＼\"\x1f\x00ｒ.λg\x0ex＂␡<N␄ρλ５ｓς｀\x19h．Ｍ",
		out:  "υ.␗｜ρ＼\"\x1f␀ｒ.λg\x0ex＂␡<N␄ρλ５ｓς｀\x19h．Ｍ",
	}, { // 2926
		mask: EncodeColon | EncodeRightPeriod,
		in:   "υ．␗｜ρ＼\"\x1f\x00ｒ.λg\x0ex＂␡<N␄ρλ５ｓς｀\x19h．Ｍ",
		out:  "υ．␗｜ρ＼\"\x1f␀ｒ.λg\x0ex＂␡<N␄ρλ５ｓς｀\x19h．Ｍ",
	}, { // 2927
		mask: EncodeColon | EncodeRightPeriod,
		in:   "υ.␗｜ρ＼\"\x1f\x00ｒ.λg\x0ex＂␡<N␄ρλ５ｓς｀\x19h␎．",
		out:  "υ.␗｜ρ＼\"\x1f␀ｒ.λg\x0ex＂␡<N␄ρλ５ｓς｀\x19h␎‛．",
	}, { // 2928
		mask: EncodeColon | EncodeRightPeriod,
		in:   "υ．␗｜ρ＼\"\x1f\x00ｒ.λg\x0ex＂␡<N␄ρλ５ｓς｀\x19h␎．",
		out:  "υ．␗｜ρ＼\"\x1f␀ｒ.λg\x0ex＂␡<N␄ρλ５ｓς｀\x19h␎‛．",
	}, { // 2929
		mask: EncodeColon | EncodeRightPeriod,
		in:   "υ\"␗｜ρ＼\"\x1f\x00ｒ.λg\x0ex＂␡<N␄ρλ５ｓς｀\x19h.Ｍ",
		out:  "υ\"␗｜ρ＼\"\x1f␀ｒ.λg\x0ex＂␡<N␄ρλ５ｓς｀\x19h.Ｍ",
	}, { // 2930
		mask: EncodeColon | EncodeRightPeriod,
		in:   "υ\"␗｜ρ＼\"\x1f\x00ｒ.λg\x0ex＂␡<N␄ρλ５ｓς｀\x19h．Ｍ",
		out:  "υ\"␗｜ρ＼\"\x1f␀ｒ.λg\x0ex＂␡<N␄ρλ５ｓς｀\x19h．Ｍ",
	}, { // 2931
		mask: EncodeColon | EncodeRightPeriod,
		in:   "υ\"␗｜ρ＼\"\x1f\x00ｒ.λg\x0ex＂␡<N␄ρλ５ｓς｀\x19h.．",
		out:  "υ\"␗｜ρ＼\"\x1f␀ｒ.λg\x0ex＂␡<N␄ρλ５ｓς｀\x19h.‛．",
	}, { // 2932
		mask: EncodeColon | EncodeRightPeriod,
		in:   "υ\"␗｜ρ＼\"\x1f\x00ｒ.λg\x0ex＂␡<N␄ρλ５ｓς｀\x19h．．",
		out:  "υ\"␗｜ρ＼\"\x1f␀ｒ.λg\x0ex＂␡<N␄ρλ５ｓς｀\x19h．‛．",
	}, { // 2933
		mask: EncodeColon | EncodeRightPeriod,
		in:   "υ\"␗｜ρ＼\"\x1f\x00ｒ.λg\x0ex＂␡<N␄ρλ５ｓς｀\x19h␎.",
		out:  "υ\"␗｜ρ＼\"\x1f␀ｒ.λg\x0ex＂␡<N␄ρλ５ｓς｀\x19h␎．",
	}, { // 2934
		mask: EncodeColon | EncodeRightPeriod,
		in:   "υ\"␗｜ρ＼\"\x1f\x00ｒ.λg\x0ex＂␡<N␄ρλ５ｓς｀\x19h␎．",
		out:  "υ\"␗｜ρ＼\"\x1f␀ｒ.λg\x0ex＂␡<N␄ρλ５ｓς｀\x19h␎‛．",
	}, { // 2935
		mask: EncodeQuestion | EncodeRightPeriod,
		in:   "\t␟τ(χＴｈ｜\x17C.ｃ\\#ｃ␘B［*＂Ｅ␆yCε0ι:＇ι",
		out:  "\t␟τ(χＴｈ｜\x17C.ｃ\\#ｃ␘B［*＂Ｅ␆yCε0ι:＇ι",
	}, { // 2936
		mask: EncodeQuestion | EncodeRightPeriod,
		in:   ".．τ(χＴｈ｜\x17C.ｃ\\#ｃ␘B［*＂Ｅ␆yCε0ι:＇ι",
		out:  ".．τ(χＴｈ｜\x17C.ｃ\\#ｃ␘B［*＂Ｅ␆yCε0ι:＇ι",
	}, { // 2937
		mask: EncodeQuestion | EncodeRightPeriod,
		in:   "．．τ(χＴｈ｜\x17C.ｃ\\#ｃ␘B［*＂Ｅ␆yCε0ι:＇ι",
		out:  "．．τ(χＴｈ｜\x17C.ｃ\\#ｃ␘B［*＂Ｅ␆yCε0ι:＇ι",
	}, { // 2938
		mask: EncodeQuestion | EncodeRightPeriod,
		in:   ".␟τ(χＴｈ｜\x17C.ｃ\\#ｃ␘B［*＂Ｅ␆yCε0ι:．ι",
		out:  ".␟τ(χＴｈ｜\x17C.ｃ\\#ｃ␘B［*＂Ｅ␆yCε0ι:．ι",
	}, { // 2939
		mask: EncodeQuestion | EncodeRightPeriod,
		in:   "．␟τ(χＴｈ｜\x17C.ｃ\\#ｃ␘B［*＂Ｅ␆yCε0ι:．ι",
		out:  "．␟τ(χＴｈ｜\x17C.ｃ\\#ｃ␘B［*＂Ｅ␆yCε0ι:．ι",
	}, { // 2940
		mask: EncodeQuestion | EncodeRightPeriod,
		in:   ".␟τ(χＴｈ｜\x17C.ｃ\\#ｃ␘B［*＂Ｅ␆yCε0ι:＇．",
		out:  ".␟τ(χＴｈ｜\x17C.ｃ\\#ｃ␘B［*＂Ｅ␆yCε0ι:＇‛．",
	}, { // 2941
		mask: EncodeQuestion | EncodeRightPeriod,
		in:   "．␟τ(χＴｈ｜\x17C.ｃ\\#ｃ␘B［*＂Ｅ␆yCε0ι:＇．",
		out:  "．␟τ(χＴｈ｜\x17C.ｃ\\#ｃ␘B［*＂Ｅ␆yCε0ι:＇‛．",
	}, { // 2942
		mask: EncodeQuestion | EncodeRightPeriod,
		in:   "\t.τ(χＴｈ｜\x17C.ｃ\\#ｃ␘B［*＂Ｅ␆yCε0ι:＇ι",
		out:  "\t.τ(χＴｈ｜\x17C.ｃ\\#ｃ␘B［*＂Ｅ␆yCε0ι:＇ι",
	}, { // 2943
		mask: EncodeQuestion | EncodeRightPeriod,
		in:   "\t．τ(χＴｈ｜\x17C.ｃ\\#ｃ␘B［*＂Ｅ␆yCε0ι:＇ι",
		out:  "\t．τ(χＴｈ｜\x17C.ｃ\\#ｃ␘B［*＂Ｅ␆yCε0ι:＇ι",
	}, { // 2944
		mask: EncodeQuestion | EncodeRightPeriod,
		in:   "\t.τ(χＴｈ｜\x17C.ｃ\\#ｃ␘B［*＂Ｅ␆yCε0ι:．ι",
		out:  "\t.τ(χＴｈ｜\x17C.ｃ\\#ｃ␘B［*＂Ｅ␆yCε0ι:．ι",
	}, { // 2945
		mask: EncodeQuestion | EncodeRightPeriod,
		in:   "\t．τ(χＴｈ｜\x17C.ｃ\\#ｃ␘B［*＂Ｅ␆yCε0ι:．ι",
		out:  "\t．τ(χＴｈ｜\x17C.ｃ\\#ｃ␘B［*＂Ｅ␆yCε0ι:．ι",
	}, { // 2946
		mask: EncodeQuestion | EncodeRightPeriod,
		in:   "\t.τ(χＴｈ｜\x17C.ｃ\\#ｃ␘B［*＂Ｅ␆yCε0ι:＇．",
		out:  "\t.τ(χＴｈ｜\x17C.ｃ\\#ｃ␘B［*＂Ｅ␆yCε0ι:＇‛．",
	}, { // 2947
		mask: EncodeQuestion | EncodeRightPeriod,
		in:   "\t．τ(χＴｈ｜\x17C.ｃ\\#ｃ␘B［*＂Ｅ␆yCε0ι:＇．",
		out:  "\t．τ(χＴｈ｜\x17C.ｃ\\#ｃ␘B［*＂Ｅ␆yCε0ι:＇‛．",
	}, { // 2948
		mask: EncodeQuestion | EncodeRightPeriod,
		in:   "\t␟τ(χＴｈ｜\x17C.ｃ\\#ｃ␘B［*＂Ｅ␆yCε0ι:.ι",
		out:  "\t␟τ(χＴｈ｜\x17C.ｃ\\#ｃ␘B［*＂Ｅ␆yCε0ι:.ι",
	}, { // 2949
		mask: EncodeQuestion | EncodeRightPeriod,
		in:   "\t␟τ(χＴｈ｜\x17C.ｃ\\#ｃ␘B［*＂Ｅ␆yCε0ι:．ι",
		out:  "\t␟τ(χＴｈ｜\x17C.ｃ\\#ｃ␘B［*＂Ｅ␆yCε0ι:．ι",
	}, { // 2950
		mask: EncodeQuestion | EncodeRightPeriod,
		in:   "\t␟τ(χＴｈ｜\x17C.ｃ\\#ｃ␘B［*＂Ｅ␆yCε0ι:.．",
		out:  "\t␟τ(χＴｈ｜\x17C.ｃ\\#ｃ␘B［*＂Ｅ␆yCε0ι:.‛．",
	}, { // 2951
		mask: EncodeQuestion | EncodeRightPeriod,
		in:   "\t␟τ(χＴｈ｜\x17C.ｃ\\#ｃ␘B［*＂Ｅ␆yCε0ι:．．",
		out:  "\t␟τ(χＴｈ｜\x17C.ｃ\\#ｃ␘B［*＂Ｅ␆yCε0ι:．‛．",
	}, { // 2952
		mask: EncodeQuestion | EncodeRightPeriod,
		in:   "\t␟τ(χＴｈ｜\x17C.ｃ\\#ｃ␘B［*＂Ｅ␆yCε0ι:＇.",
		out:  "\t␟τ(χＴｈ｜\x17C.ｃ\\#ｃ␘B［*＂Ｅ␆yCε0ι:＇．",
	}, { // 2953
		mask: EncodeQuestion | EncodeRightPeriod,
		in:   "\t␟τ(χＴｈ｜\x17C.ｃ\\#ｃ␘B［*＂Ｅ␆yCε0ι:＇．",
		out:  "\t␟τ(χＴｈ｜\x17C.ｃ\\#ｃ␘B［*＂Ｅ␆yCε0ι:＇‛．",
	}, { // 2954
		mask: EncodeAsterisk | EncodeRightPeriod,
		in:   "/｀ξZ｀\x17ｚ４ζ␕.\x045␟ρ␅M\aｚ␀_␇\x00＋,Hｗτξβ",
		out:  "/｀ξZ｀\x17ｚ４ζ␕.\x045␟ρ␅M\aｚ‛␀_␇␀＋,Hｗτξβ",
	}, { // 2955
		mask: EncodeAsterisk | EncodeRightPeriod,
		in:   ".．ξZ｀\x17ｚ４ζ␕.\x045␟ρ␅M\aｚ␀_␇\x00＋,Hｗτξβ",
		out:  ".．ξZ｀\x17ｚ４ζ␕.\x045␟ρ␅M\aｚ‛␀_␇␀＋,Hｗτξβ",
	}, { // 2956
		mask: EncodeAsterisk | EncodeRightPeriod,
		in:   "．．ξZ｀\x17ｚ４ζ␕.\x045␟ρ␅M\aｚ␀_␇\x00＋,Hｗτξβ",
		out:  "．．ξZ｀\x17ｚ４ζ␕.\x045␟ρ␅M\aｚ‛␀_␇␀＋,Hｗτξβ",
	}, { // 2957
		mask: EncodeAsterisk | EncodeRightPeriod,
		in:   ".｀ξZ｀\x17ｚ４ζ␕.\x045␟ρ␅M\aｚ␀_␇\x00＋,Hｗτ．β",
		out:  ".｀ξZ｀\x17ｚ４ζ␕.\x045␟ρ␅M\aｚ‛␀_␇␀＋,Hｗτ．β",
	}, { // 2958
		mask: EncodeAsterisk | EncodeRightPeriod,
		in:   "．｀ξZ｀\x17ｚ４ζ␕.\x045␟ρ␅M\aｚ␀_␇\x00＋,Hｗτ．β",
		out:  "．｀ξZ｀\x17ｚ４ζ␕.\x045␟ρ␅M\aｚ‛␀_␇␀＋,Hｗτ．β",
	}, { // 2959
		mask: EncodeAsterisk | EncodeRightPeriod,
		in:   ".｀ξZ｀\x17ｚ４ζ␕.\x045␟ρ␅M\aｚ␀_␇\x00＋,Hｗτξ．",
		out:  ".｀ξZ｀\x17ｚ４ζ␕.\x045␟ρ␅M\aｚ‛␀_␇␀＋,Hｗτξ‛．",
	}, { // 2960
		mask: EncodeAsterisk | EncodeRightPeriod,
		in:   "．｀ξZ｀\x17ｚ４ζ␕.\x045␟ρ␅M\aｚ␀_␇\x00＋,Hｗτξ．",
		out:  "．｀ξZ｀\x17ｚ４ζ␕.\x045␟ρ␅M\aｚ‛␀_␇␀＋,Hｗτξ‛．",
	}, { // 2961
		mask: EncodeAsterisk | EncodeRightPeriod,
		in:   "/.ξZ｀\x17ｚ４ζ␕.\x045␟ρ␅M\aｚ␀_␇\x00＋,Hｗτξβ",
		out:  "/.ξZ｀\x17ｚ４ζ␕.\x045␟ρ␅M\aｚ‛␀_␇␀＋,Hｗτξβ",
	}, { // 2962
		mask: EncodeAsterisk | EncodeRightPeriod,
		in:   "/．ξZ｀\x17ｚ４ζ␕.\x045␟ρ␅M\aｚ␀_␇\x00＋,Hｗτξβ",
		out:  "/．ξZ｀\x17ｚ４ζ␕.\x045␟ρ␅M\aｚ‛␀_␇␀＋,Hｗτξβ",
	}, { // 2963
		mask: EncodeAsterisk | EncodeRightPeriod,
		in:   "/.ξZ｀\x17ｚ４ζ␕.\x045␟ρ␅M\aｚ␀_␇\x00＋,Hｗτ．β",
		out:  "/.ξZ｀\x17ｚ４ζ␕.\x045␟ρ␅M\aｚ‛␀_␇␀＋,Hｗτ．β",
	}, { // 2964
		mask: EncodeAsterisk | EncodeRightPeriod,
		in:   "/．ξZ｀\x17ｚ４ζ␕.\x045␟ρ␅M\aｚ␀_␇\x00＋,Hｗτ．β",
		out:  "/．ξZ｀\x17ｚ４ζ␕.\x045␟ρ␅M\aｚ‛␀_␇␀＋,Hｗτ．β",
	}, { // 2965
		mask: EncodeAsterisk | EncodeRightPeriod,
		in:   "/.ξZ｀\x17ｚ４ζ␕.\x045␟ρ␅M\aｚ␀_␇\x00＋,Hｗτξ．",
		out:  "/.ξZ｀\x17ｚ４ζ␕.\x045␟ρ␅M\aｚ‛␀_␇␀＋,Hｗτξ‛．",
	}, { // 2966
		mask: EncodeAsterisk | EncodeRightPeriod,
		in:   "/．ξZ｀\x17ｚ４ζ␕.\x045␟ρ␅M\aｚ␀_␇\x00＋,Hｗτξ．",
		out:  "/．ξZ｀\x17ｚ４ζ␕.\x045␟ρ␅M\aｚ‛␀_␇␀＋,Hｗτξ‛．",
	}, { // 2967
		mask: EncodeAsterisk | EncodeRightPeriod,
		in:   "/｀ξZ｀\x17ｚ４ζ␕.\x045␟ρ␅M\aｚ␀_␇\x00＋,Hｗτ.β",
		out:  "/｀ξZ｀\x17ｚ４ζ␕.\x045␟ρ␅M\aｚ‛␀_␇␀＋,Hｗτ.β",
	}, { // 2968
		mask: EncodeAsterisk | EncodeRightPeriod,
		in:   "/｀ξZ｀\x17ｚ４ζ␕.\x045␟ρ␅M\aｚ␀_␇\x00＋,Hｗτ．β",
		out:  "/｀ξZ｀\x17ｚ４ζ␕.\x045␟ρ␅M\aｚ‛␀_␇␀＋,Hｗτ．β",
	}, { // 2969
		mask: EncodeAsterisk | EncodeRightPeriod,
		in:   "/｀ξZ｀\x17ｚ４ζ␕.\x045␟ρ␅M\aｚ␀_␇\x00＋,Hｗτ.．",
		out:  "/｀ξZ｀\x17ｚ４ζ␕.\x045␟ρ␅M\aｚ‛␀_␇␀＋,Hｗτ.‛．",
	}, { // 2970
		mask: EncodeAsterisk | EncodeRightPeriod,
		in:   "/｀ξZ｀\x17ｚ４ζ␕.\x045␟ρ␅M\aｚ␀_␇\x00＋,Hｗτ．．",
		out:  "/｀ξZ｀\x17ｚ４ζ␕.\x045␟ρ␅M\aｚ‛␀_␇␀＋,Hｗτ．‛．",
	}, { // 2971
		mask: EncodeAsterisk | EncodeRightPeriod,
		in:   "/｀ξZ｀\x17ｚ４ζ␕.\x045␟ρ␅M\aｚ␀_␇\x00＋,Hｗτξ.",
		out:  "/｀ξZ｀\x17ｚ４ζ␕.\x045␟ρ␅M\aｚ‛␀_␇␀＋,Hｗτξ．",
	}, { // 2972
		mask: EncodeAsterisk | EncodeRightPeriod,
		in:   "/｀ξZ｀\x17ｚ４ζ␕.\x045␟ρ␅M\aｚ␀_␇\x00＋,Hｗτξ．",
		out:  "/｀ξZ｀\x17ｚ４ζ␕.\x045␟ρ␅M\aｚ‛␀_␇␀＋,Hｗτξ‛．",
	}, { // 2973
		mask: EncodePipe | EncodeRightPeriod,
		in:   "\x15\r+D#ｕςν＼].␊～ｗ｝P␃α␓Rδ+<\b␟／Ｉ\aκ：",
		out:  "\x15\r+D#ｕςν＼].␊～ｗ｝P␃α␓Rδ+<\b␟／Ｉ\aκ：",
	}, { // 2974
		mask: EncodePipe | EncodeRightPeriod,
		in:   ".．+D#ｕςν＼].␊～ｗ｝P␃α␓Rδ+<\b␟／Ｉ\aκ：",
		out:  ".．+D#ｕςν＼].␊～ｗ｝P␃α␓Rδ+<\b␟／Ｉ\aκ：",
	}, { // 2975
		mask: EncodePipe | EncodeRightPeriod,
		in:   "．．+D#ｕςν＼].␊～ｗ｝P␃α␓Rδ+<\b␟／Ｉ\aκ：",
		out:  "．．+D#ｕςν＼].␊～ｗ｝P␃α␓Rδ+<\b␟／Ｉ\aκ：",
	}, { // 2976
		mask: EncodePipe | EncodeRightPeriod,
		in:   ".\r+D#ｕςν＼].␊～ｗ｝P␃α␓Rδ+<\b␟／Ｉ\a．：",
		out:  ".\r+D#ｕςν＼].␊～ｗ｝P␃α␓Rδ+<\b␟／Ｉ\a．：",
	}, { // 2977
		mask: EncodePipe | EncodeRightPeriod,
		in:   "．\r+D#ｕςν＼].␊～ｗ｝P␃α␓Rδ+<\b␟／Ｉ\a．：",
		out:  "．\r+D#ｕςν＼].␊～ｗ｝P␃α␓Rδ+<\b␟／Ｉ\a．：",
	}, { // 2978
		mask: EncodePipe | EncodeRightPeriod,
		in:   ".\r+D#ｕςν＼].␊～ｗ｝P␃α␓Rδ+<\b␟／Ｉ\aκ．",
		out:  ".\r+D#ｕςν＼].␊～ｗ｝P␃α␓Rδ+<\b␟／Ｉ\aκ‛．",
	}, { // 2979
		mask: EncodePipe | EncodeRightPeriod,
		in:   "．\r+D#ｕςν＼].␊～ｗ｝P␃α␓Rδ+<\b␟／Ｉ\aκ．",
		out:  "．\r+D#ｕςν＼].␊～ｗ｝P␃α␓Rδ+<\b␟／Ｉ\aκ‛．",
	}, { // 2980
		mask: EncodePipe | EncodeRightPeriod,
		in:   "\x15.+D#ｕςν＼].␊～ｗ｝P␃α␓Rδ+<\b␟／Ｉ\aκ：",
		out:  "\x15.+D#ｕςν＼].␊～ｗ｝P␃α␓Rδ+<\b␟／Ｉ\aκ：",
	}, { // 2981
		mask: EncodePipe | EncodeRightPeriod,
		in:   "\x15．+D#ｕςν＼].␊～ｗ｝P␃α␓Rδ+<\b␟／Ｉ\aκ：",
		out:  "\x15．+D#ｕςν＼].␊～ｗ｝P␃α␓Rδ+<\b␟／Ｉ\aκ：",
	}, { // 2982
		mask: EncodePipe | EncodeRightPeriod,
		in:   "\x15.+D#ｕςν＼].␊～ｗ｝P␃α␓Rδ+<\b␟／Ｉ\a．：",
		out:  "\x15.+D#ｕςν＼].␊～ｗ｝P␃α␓Rδ+<\b␟／Ｉ\a．：",
	}, { // 2983
		mask: EncodePipe | EncodeRightPeriod,
		in:   "\x15．+D#ｕςν＼].␊～ｗ｝P␃α␓Rδ+<\b␟／Ｉ\a．：",
		out:  "\x15．+D#ｕςν＼].␊～ｗ｝P␃α␓Rδ+<\b␟／Ｉ\a．：",
	}, { // 2984
		mask: EncodePipe | EncodeRightPeriod,
		in:   "\x15.+D#ｕςν＼].␊～ｗ｝P␃α␓Rδ+<\b␟／Ｉ\aκ．",
		out:  "\x15.+D#ｕςν＼].␊～ｗ｝P␃α␓Rδ+<\b␟／Ｉ\aκ‛．",
	}, { // 2985
		mask: EncodePipe | EncodeRightPeriod,
		in:   "\x15．+D#ｕςν＼].␊～ｗ｝P␃α␓Rδ+<\b␟／Ｉ\aκ．",
		out:  "\x15．+D#ｕςν＼].␊～ｗ｝P␃α␓Rδ+<\b␟／Ｉ\aκ‛．",
	}, { // 2986
		mask: EncodePipe | EncodeRightPeriod,
		in:   "\x15\r+D#ｕςν＼].␊～ｗ｝P␃α␓Rδ+<\b␟／Ｉ\a.：",
		out:  "\x15\r+D#ｕςν＼].␊～ｗ｝P␃α␓Rδ+<\b␟／Ｉ\a.：",
	}, { // 2987
		mask: EncodePipe | EncodeRightPeriod,
		in:   "\x15\r+D#ｕςν＼].␊～ｗ｝P␃α␓Rδ+<\b␟／Ｉ\a．：",
		out:  "\x15\r+D#ｕςν＼].␊～ｗ｝P␃α␓Rδ+<\b␟／Ｉ\a．：",
	}, { // 2988
		mask: EncodePipe | EncodeRightPeriod,
		in:   "\x15\r+D#ｕςν＼].␊～ｗ｝P␃α␓Rδ+<\b␟／Ｉ\a.．",
		out:  "\x15\r+D#ｕςν＼].␊～ｗ｝P␃α␓Rδ+<\b␟／Ｉ\a.‛．",
	}, { // 2989
		mask: EncodePipe | EncodeRightPeriod,
		in:   "\x15\r+D#ｕςν＼].␊～ｗ｝P␃α␓Rδ+<\b␟／Ｉ\a．．",
		out:  "\x15\r+D#ｕςν＼].␊～ｗ｝P␃α␓Rδ+<\b␟／Ｉ\a．‛．",
	}, { // 2990
		mask: EncodePipe | EncodeRightPeriod,
		in:   "\x15\r+D#ｕςν＼].␊～ｗ｝P␃α␓Rδ+<\b␟／Ｉ\aκ.",
		out:  "\x15\r+D#ｕςν＼].␊～ｗ｝P␃α␓Rδ+<\b␟／Ｉ\aκ．",
	}, { // 2991
		mask: EncodePipe | EncodeRightPeriod,
		in:   "\x15\r+D#ｕςν＼].␊～ｗ｝P␃α␓Rδ+<\b␟／Ｉ\aκ．",
		out:  "\x15\r+D#ｕςν＼].␊～ｗ｝P␃α␓Rδ+<\b␟／Ｉ\aκ‛．",
	}, { // 2992
		mask: EncodeHash | EncodeRightPeriod,
		in:   "κυ\x00３ｋ］␍＇γ␒.３\x05\x1e\x05?M.ｒX｜βwｄＯχ>\x15／ς",
		out:  "κυ␀３ｋ］␍＇γ␒.３\x05\x1e\x05?M.ｒX｜βwｄＯχ>\x15／ς",
	}, { // 2993
		mask: EncodeHash | EncodeRightPeriod,
		in:   ".．\x00３ｋ］␍＇γ␒.３\x05\x1e\x05?M.ｒX｜βwｄＯχ>\x15／ς",
		out:  ".．␀３ｋ］␍＇γ␒.３\x05\x1e\x05?M.ｒX｜βwｄＯχ>\x15／ς",
	}, { // 2994
		mask: EncodeHash | EncodeRightPeriod,
		in:   "．．\x00３ｋ］␍＇γ␒.３\x05\x1e\x05?M.ｒX｜βwｄＯχ>\x15／ς",
		out:  "．．␀３ｋ］␍＇γ␒.３\x05\x1e\x05?M.ｒX｜βwｄＯχ>\x15／ς",
	}, { // 2995
		mask: EncodeHash | EncodeRightPeriod,
		in:   ".υ\x00３ｋ］␍＇γ␒.３\x05\x1e\x05?M.ｒX｜βwｄＯχ>\x15．ς",
		out:  ".υ␀３ｋ］␍＇γ␒.３\x05\x1e\x05?M.ｒX｜βwｄＯχ>\x15．ς",
	}, { // 2996
		mask: EncodeHash | EncodeRightPeriod,
		in:   "．υ\x00３ｋ］␍＇γ␒.３\x05\x1e\x05?M.ｒX｜βwｄＯχ>\x15．ς",
		out:  "．υ␀３ｋ］␍＇γ␒.３\x05\x1e\x05?M.ｒX｜βwｄＯχ>\x15．ς",
	}, { // 2997
		mask: EncodeHash | EncodeRightPeriod,
		in:   ".υ\x00３ｋ］␍＇γ␒.３\x05\x1e\x05?M.ｒX｜βwｄＯχ>\x15／．",
		out:  ".υ␀３ｋ］␍＇γ␒.３\x05\x1e\x05?M.ｒX｜βwｄＯχ>\x15／‛．",
	}, { // 2998
		mask: EncodeHash | EncodeRightPeriod,
		in:   "．υ\x00３ｋ］␍＇γ␒.３\x05\x1e\x05?M.ｒX｜βwｄＯχ>\x15／．",
		out:  "．υ␀３ｋ］␍＇γ␒.３\x05\x1e\x05?M.ｒX｜βwｄＯχ>\x15／‛．",
	}, { // 2999
		mask: EncodeHash | EncodeRightPeriod,
		in:   "κ.\x00３ｋ］␍＇γ␒.３\x05\x1e\x05?M.ｒX｜βwｄＯχ>\x15／ς",
		out:  "κ.␀３ｋ］␍＇γ␒.３\x05\x1e\x05?M.ｒX｜βwｄＯχ>\x15／ς",
	}, { // 3000
		mask: EncodeHash | EncodeRightPeriod,
		in:   "κ．\x00３ｋ］␍＇γ␒.３\x05\x1e\x05?M.ｒX｜βwｄＯχ>\x15／ς",
		out:  "κ．␀３ｋ］␍＇γ␒.３\x05\x1e\x05?M.ｒX｜βwｄＯχ>\x15／ς",
	}, { // 3001
		mask: EncodeHash | EncodeRightPeriod,
		in:   "κ.\x00３ｋ］␍＇γ␒.３\x05\x1e\x05?M.ｒX｜βwｄＯχ>\x15．ς",
		out:  "κ.␀３ｋ］␍＇γ␒.３\x05\x1e\x05?M.ｒX｜βwｄＯχ>\x15．ς",
	}, { // 3002
		mask: EncodeHash | EncodeRightPeriod,
		in:   "κ．\x00３ｋ］␍＇γ␒.３\x05\x1e\x05?M.ｒX｜βwｄＯχ>\x15．ς",
		out:  "κ．␀３ｋ］␍＇γ␒.３\x05\x1e\x05?M.ｒX｜βwｄＯχ>\x15．ς",
	}, { // 3003
		mask: EncodeHash | EncodeRightPeriod,
		in:   "κ.\x00３ｋ］␍＇γ␒.３\x05\x1e\x05?M.ｒX｜βwｄＯχ>\x15／．",
		out:  "κ.␀３ｋ］␍＇γ␒.３\x05\x1e\x05?M.ｒX｜βwｄＯχ>\x15／‛．",
	}, { // 3004
		mask: EncodeHash | EncodeRightPeriod,
		in:   "κ．\x00３ｋ］␍＇γ␒.３\x05\x1e\x05?M.ｒX｜βwｄＯχ>\x15／．",
		out:  "κ．␀３ｋ］␍＇γ␒.３\x05\x1e\x05?M.ｒX｜βwｄＯχ>\x15／‛．",
	}, { // 3005
		mask: EncodeHash | EncodeRightPeriod,
		in:   "κυ\x00３ｋ］␍＇γ␒.３\x05\x1e\x05?M.ｒX｜βwｄＯχ>\x15.ς",
		out:  "κυ␀３ｋ］␍＇γ␒.３\x05\x1e\x05?M.ｒX｜βwｄＯχ>\x15.ς",
	}, { // 3006
		mask: EncodeHash | EncodeRightPeriod,
		in:   "κυ\x00３ｋ］␍＇γ␒.３\x05\x1e\x05?M.ｒX｜βwｄＯχ>\x15．ς",
		out:  "κυ␀３ｋ］␍＇γ␒.３\x05\x1e\x05?M.ｒX｜βwｄＯχ>\x15．ς",
	}, { // 3007
		mask: EncodeHash | EncodeRightPeriod,
		in:   "κυ\x00３ｋ］␍＇γ␒.３\x05\x1e\x05?M.ｒX｜βwｄＯχ>\x15.．",
		out:  "κυ␀３ｋ］␍＇γ␒.３\x05\x1e\x05?M.ｒX｜βwｄＯχ>\x15.‛．",
	}, { // 3008
		mask: EncodeHash | EncodeRightPeriod,
		in:   "κυ\x00３ｋ］␍＇γ␒.３\x05\x1e\x05?M.ｒX｜βwｄＯχ>\x15．．",
		out:  "κυ␀３ｋ］␍＇γ␒.３\x05\x1e\x05?M.ｒX｜βwｄＯχ>\x15．‛．",
	}, { // 3009
		mask: EncodeHash | EncodeRightPeriod,
		in:   "κυ\x00３ｋ］␍＇γ␒.３\x05\x1e\x05?M.ｒX｜βwｄＯχ>\x15／.",
		out:  "κυ␀３ｋ］␍＇γ␒.３\x05\x1e\x05?M.ｒX｜βwｄＯχ>\x15／．",
	}, { // 3010
		mask: EncodeHash | EncodeRightPeriod,
		in:   "κυ\x00３ｋ］␍＇γ␒.３\x05\x1e\x05?M.ｒX｜βwｄＯχ>\x15／．",
		out:  "κυ␀３ｋ］␍＇γ␒.３\x05\x1e\x05?M.ｒX｜βwｄＯχ>\x15／‛．",
	}, { // 3011
		mask: EncodePercent | EncodeRightPeriod,
		in:   "εｆ␡\\％\n:Ipγ.\x11＞#␐Lχ␘`ＣＧｑ\x17ζ｛ｅuι'␛",
		out:  "εｆ␡\\‛％\n:Ipγ.\x11＞#␐Lχ␘`ＣＧｑ\x17ζ｛ｅuι'␛",
	}, { // 3012
		mask: EncodePercent | EncodeRightPeriod,
		in:   ".．␡\\％\n:Ipγ.\x11＞#␐Lχ␘`ＣＧｑ\x17ζ｛ｅuι'␛",
		out:  ".．␡\\‛％\n:Ipγ.\x11＞#␐Lχ␘`ＣＧｑ\x17ζ｛ｅuι'␛",
	}, { // 3013
		mask: EncodePercent | EncodeRightPeriod,
		in:   "．．␡\\％\n:Ipγ.\x11＞#␐Lχ␘`ＣＧｑ\x17ζ｛ｅuι'␛",
		out:  "．．␡\\‛％\n:Ipγ.\x11＞#␐Lχ␘`ＣＧｑ\x17ζ｛ｅuι'␛",
	}, { // 3014
		mask: EncodePercent | EncodeRightPeriod,
		in:   ".ｆ␡\\％\n:Ipγ.\x11＞#␐Lχ␘`ＣＧｑ\x17ζ｛ｅuι．␛",
		out:  ".ｆ␡\\‛％\n:Ipγ.\x11＞#␐Lχ␘`ＣＧｑ\x17ζ｛ｅuι．␛",
	}, { // 3015
		mask: EncodePercent | EncodeRightPeriod,
		in:   "．ｆ␡\\％\n:Ipγ.\x11＞#␐Lχ␘`ＣＧｑ\x17ζ｛ｅuι．␛",
		out:  "．ｆ␡\\‛％\n:Ipγ.\x11＞#␐Lχ␘`ＣＧｑ\x17ζ｛ｅuι．␛",
	}, { // 3016
		mask: EncodePercent | EncodeRightPeriod,
		in:   ".ｆ␡\\％\n:Ipγ.\x11＞#␐Lχ␘`ＣＧｑ\x17ζ｛ｅuι'．",
		out:  ".ｆ␡\\‛％\n:Ipγ.\x11＞#␐Lχ␘`ＣＧｑ\x17ζ｛ｅuι'‛．",
	}, { // 3017
		mask: EncodePercent | EncodeRightPeriod,
		in:   "．ｆ␡\\％\n:Ipγ.\x11＞#␐Lχ␘`ＣＧｑ\x17ζ｛ｅuι'．",
		out:  "．ｆ␡\\‛％\n:Ipγ.\x11＞#␐Lχ␘`ＣＧｑ\x17ζ｛ｅuι'‛．",
	}, { // 3018
		mask: EncodePercent | EncodeRightPeriod,
		in:   "ε.␡\\％\n:Ipγ.\x11＞#␐Lχ␘`ＣＧｑ\x17ζ｛ｅuι'␛",
		out:  "ε.␡\\‛％\n:Ipγ.\x11＞#␐Lχ␘`ＣＧｑ\x17ζ｛ｅuι'␛",
	}, { // 3019
		mask: EncodePercent | EncodeRightPeriod,
		in:   "ε．␡\\％\n:Ipγ.\x11＞#␐Lχ␘`ＣＧｑ\x17ζ｛ｅuι'␛",
		out:  "ε．␡\\‛％\n:Ipγ.\x11＞#␐Lχ␘`ＣＧｑ\x17ζ｛ｅuι'␛",
	}, { // 3020
		mask: EncodePercent | EncodeRightPeriod,
		in:   "ε.␡\\％\n:Ipγ.\x11＞#␐Lχ␘`ＣＧｑ\x17ζ｛ｅuι．␛",
		out:  "ε.␡\\‛％\n:Ipγ.\x11＞#␐Lχ␘`ＣＧｑ\x17ζ｛ｅuι．␛",
	}, { // 3021
		mask: EncodePercent | EncodeRightPeriod,
		in:   "ε．␡\\％\n:Ipγ.\x11＞#␐Lχ␘`ＣＧｑ\x17ζ｛ｅuι．␛",
		out:  "ε．␡\\‛％\n:Ipγ.\x11＞#␐Lχ␘`ＣＧｑ\x17ζ｛ｅuι．␛",
	}, { // 3022
		mask: EncodePercent | EncodeRightPeriod,
		in:   "ε.␡\\％\n:Ipγ.\x11＞#␐Lχ␘`ＣＧｑ\x17ζ｛ｅuι'．",
		out:  "ε.␡\\‛％\n:Ipγ.\x11＞#␐Lχ␘`ＣＧｑ\x17ζ｛ｅuι'‛．",
	}, { // 3023
		mask: EncodePercent | EncodeRightPeriod,
		in:   "ε．␡\\％\n:Ipγ.\x11＞#␐Lχ␘`ＣＧｑ\x17ζ｛ｅuι'．",
		out:  "ε．␡\\‛％\n:Ipγ.\x11＞#␐Lχ␘`ＣＧｑ\x17ζ｛ｅuι'‛．",
	}, { // 3024
		mask: EncodePercent | EncodeRightPeriod,
		in:   "εｆ␡\\％\n:Ipγ.\x11＞#␐Lχ␘`ＣＧｑ\x17ζ｛ｅuι.␛",
		out:  "εｆ␡\\‛％\n:Ipγ.\x11＞#␐Lχ␘`ＣＧｑ\x17ζ｛ｅuι.␛",
	}, { // 3025
		mask: EncodePercent | EncodeRightPeriod,
		in:   "εｆ␡\\％\n:Ipγ.\x11＞#␐Lχ␘`ＣＧｑ\x17ζ｛ｅuι．␛",
		out:  "εｆ␡\\‛％\n:Ipγ.\x11＞#␐Lχ␘`ＣＧｑ\x17ζ｛ｅuι．␛",
	}, { // 3026
		mask: EncodePercent | EncodeRightPeriod,
		in:   "εｆ␡\\％\n:Ipγ.\x11＞#␐Lχ␘`ＣＧｑ\x17ζ｛ｅuι.．",
		out:  "εｆ␡\\‛％\n:Ipγ.\x11＞#␐Lχ␘`ＣＧｑ\x17ζ｛ｅuι.‛．",
	}, { // 3027
		mask: EncodePercent | EncodeRightPeriod,
		in:   "εｆ␡\\％\n:Ipγ.\x11＞#␐Lχ␘`ＣＧｑ\x17ζ｛ｅuι．．",
		out:  "εｆ␡\\‛％\n:Ipγ.\x11＞#␐Lχ␘`ＣＧｑ\x17ζ｛ｅuι．‛．",
	}, { // 3028
		mask: EncodePercent | EncodeRightPeriod,
		in:   "εｆ␡\\％\n:Ipγ.\x11＞#␐Lχ␘`ＣＧｑ\x17ζ｛ｅuι'.",
		out:  "εｆ␡\\‛％\n:Ipγ.\x11＞#␐Lχ␘`ＣＧｑ\x17ζ｛ｅuι'．",
	}, { // 3029
		mask: EncodePercent | EncodeRightPeriod,
		in:   "εｆ␡\\％\n:Ipγ.\x11＞#␐Lχ␘`ＣＧｑ\x17ζ｛ｅuι'．",
		out:  "εｆ␡\\‛％\n:Ipγ.\x11＞#␐Lχ␘`ＣＧｑ\x17ζ｛ｅuι'‛．",
	}, { // 3030
		mask: EncodeBackSlash | EncodeRightPeriod,
		in:   "␃␡\nψ＂}\x18Ｖ>Ｆ.χη＄]\nｓ␏λ4β␂\x1a␊␊＊\\ρI~",
		out:  "␃␡\nψ＂}\x18Ｖ>Ｆ.χη＄]\nｓ␏λ4β␂\x1a␊␊＊＼ρI~",
	}, { // 3031
		mask: EncodeBackSlash | EncodeRightPeriod,
		in:   ".．\nψ＂}\x18Ｖ>Ｆ.χη＄]\nｓ␏λ4β␂\x1a␊␊＊\\ρI~",
		out:  ".．\nψ＂}\x18Ｖ>Ｆ.χη＄]\nｓ␏λ4β␂\x1a␊␊＊＼ρI~",
	}, { // 3032
		mask: EncodeBackSlash | EncodeRightPeriod,
		in:   "．．\nψ＂}\x18Ｖ>Ｆ.χη＄]\nｓ␏λ4β␂\x1a␊␊＊\\ρI~",
		out:  "．．\nψ＂}\x18Ｖ>Ｆ.χη＄]\nｓ␏λ4β␂\x1a␊␊＊＼ρI~",
	}, { // 3033
		mask: EncodeBackSlash | EncodeRightPeriod,
		in:   ".␡\nψ＂}\x18Ｖ>Ｆ.χη＄]\nｓ␏λ4β␂\x1a␊␊＊\\ρ．~",
		out:  ".␡\nψ＂}\x18Ｖ>Ｆ.χη＄]\nｓ␏λ4β␂\x1a␊␊＊＼ρ．~",
	}, { // 3034
		mask: EncodeBackSlash | EncodeRightPeriod,
		in:   "．␡\nψ＂}\x18Ｖ>Ｆ.χη＄]\nｓ␏λ4β␂\x1a␊␊＊\\ρ．~",
		out:  "．␡\nψ＂}\x18Ｖ>Ｆ.χη＄]\nｓ␏λ4β␂\x1a␊␊＊＼ρ．~",
	}, { // 3035
		mask: EncodeBackSlash | EncodeRightPeriod,
		in:   ".␡\nψ＂}\x18Ｖ>Ｆ.χη＄]\nｓ␏λ4β␂\x1a␊␊＊\\ρI．",
		out:  ".␡\nψ＂}\x18Ｖ>Ｆ.χη＄]\nｓ␏λ4β␂\x1a␊␊＊＼ρI‛．",
	}, { // 3036
		mask: EncodeBackSlash | EncodeRightPeriod,
		in:   "．␡\nψ＂}\x18Ｖ>Ｆ.χη＄]\nｓ␏λ4β␂\x1a␊␊＊\\ρI．",
		out:  "．␡\nψ＂}\x18Ｖ>Ｆ.χη＄]\nｓ␏λ4β␂\x1a␊␊＊＼ρI‛．",
	}, { // 3037
		mask: EncodeBackSlash | EncodeRightPeriod,
		in:   "␃.\nψ＂}\x18Ｖ>Ｆ.χη＄]\nｓ␏λ4β␂\x1a␊␊＊\\ρI~",
		out:  "␃.\nψ＂}\x18Ｖ>Ｆ.χη＄]\nｓ␏λ4β␂\x1a␊␊＊＼ρI~",
	}, { // 3038
		mask: EncodeBackSlash | EncodeRightPeriod,
		in:   "␃．\nψ＂}\x18Ｖ>Ｆ.χη＄]\nｓ␏λ4β␂\x1a␊␊＊\\ρI~",
		out:  "␃．\nψ＂}\x18Ｖ>Ｆ.χη＄]\nｓ␏λ4β␂\x1a␊␊＊＼ρI~",
	}, { // 3039
		mask: EncodeBackSlash | EncodeRightPeriod,
		in:   "␃.\nψ＂}\x18Ｖ>Ｆ.χη＄]\nｓ␏λ4β␂\x1a␊␊＊\\ρ．~",
		out:  "␃.\nψ＂}\x18Ｖ>Ｆ.χη＄]\nｓ␏λ4β␂\x1a␊␊＊＼ρ．~",
	}, { // 3040
		mask: EncodeBackSlash | EncodeRightPeriod,
		in:   "␃．\nψ＂}\x18Ｖ>Ｆ.χη＄]\nｓ␏λ4β␂\x1a␊␊＊\\ρ．~",
		out:  "␃．\nψ＂}\x18Ｖ>Ｆ.χη＄]\nｓ␏λ4β␂\x1a␊␊＊＼ρ．~",
	}, { // 3041
		mask: EncodeBackSlash | EncodeRightPeriod,
		in:   "␃.\nψ＂}\x18Ｖ>Ｆ.χη＄]\nｓ␏λ4β␂\x1a␊␊＊\\ρI．",
		out:  "␃.\nψ＂}\x18Ｖ>Ｆ.χη＄]\nｓ␏λ4β␂\x1a␊␊＊＼ρI‛．",
	}, { // 3042
		mask: EncodeBackSlash | EncodeRightPeriod,
		in:   "␃．\nψ＂}\x18Ｖ>Ｆ.χη＄]\nｓ␏λ4β␂\x1a␊␊＊\\ρI．",
		out:  "␃．\nψ＂}\x18Ｖ>Ｆ.χη＄]\nｓ␏λ4β␂\x1a␊␊＊＼ρI‛．",
	}, { // 3043
		mask: EncodeBackSlash | EncodeRightPeriod,
		in:   "␃␡\nψ＂}\x18Ｖ>Ｆ.χη＄]\nｓ␏λ4β␂\x1a␊␊＊\\ρ.~",
		out:  "␃␡\nψ＂}\x18Ｖ>Ｆ.χη＄]\nｓ␏λ4β␂\x1a␊␊＊＼ρ.~",
	}, { // 3044
		mask: EncodeBackSlash | EncodeRightPeriod,
		in:   "␃␡\nψ＂}\x18Ｖ>Ｆ.χη＄]\nｓ␏λ4β␂\x1a␊␊＊\\ρ．~",
		out:  "␃␡\nψ＂}\x18Ｖ>Ｆ.χη＄]\nｓ␏λ4β␂\x1a␊␊＊＼ρ．~",
	}, { // 3045
		mask: EncodeBackSlash | EncodeRightPeriod,
		in:   "␃␡\nψ＂}\x18Ｖ>Ｆ.χη＄]\nｓ␏λ4β␂\x1a␊␊＊\\ρ.．",
		out:  "␃␡\nψ＂}\x18Ｖ>Ｆ.χη＄]\nｓ␏λ4β␂\x1a␊␊＊＼ρ.‛．",
	}, { // 3046
		mask: EncodeBackSlash | EncodeRightPeriod,
		in:   "␃␡\nψ＂}\x18Ｖ>Ｆ.χη＄]\nｓ␏λ4β␂\x1a␊␊＊\\ρ．．",
		out:  "␃␡\nψ＂}\x18Ｖ>Ｆ.χη＄]\nｓ␏λ4β␂\x1a␊␊＊＼ρ．‛．",
	}, { // 3047
		mask: EncodeBackSlash | EncodeRightPeriod,
		in:   "␃␡\nψ＂}\x18Ｖ>Ｆ.χη＄]\nｓ␏λ4β␂\x1a␊␊＊\\ρI.",
		out:  "␃␡\nψ＂}\x18Ｖ>Ｆ.χη＄]\nｓ␏λ4β␂\x1a␊␊＊＼ρI．",
	}, { // 3048
		mask: EncodeBackSlash | EncodeRightPeriod,
		in:   "␃␡\nψ＂}\x18Ｖ>Ｆ.χη＄]\nｓ␏λ4β␂\x1a␊␊＊\\ρI．",
		out:  "␃␡\nψ＂}\x18Ｖ>Ｆ.χη＄]\nｓ␏λ4β␂\x1a␊␊＊＼ρI‛．",
	}, { // 3049
		mask: EncodeCrLf | EncodeRightPeriod,
		in:   "␊：C＿ρ:>Ｃ␊v.Ｅq␆]＄J\n６:\x18␐\x1fλβ＼␙ωι`",
		out:  "‛␊：C＿ρ:>Ｃ‛␊v.Ｅq␆]＄J␊６:\x18␐\x1fλβ＼␙ωι`",
	}, { // 3050
		mask: EncodeCrLf | EncodeRightPeriod,
		in:   ".．C＿ρ:>Ｃ␊v.Ｅq␆]＄J\n６:\x18␐\x1fλβ＼␙ωι`",
		out:  ".．C＿ρ:>Ｃ‛␊v.Ｅq␆]＄J␊６:\x18␐\x1fλβ＼␙ωι`",
	}, { // 3051
		mask: EncodeCrLf | EncodeRightPeriod,
		in:   "．．C＿ρ:>Ｃ␊v.Ｅq␆]＄J\n６:\x18␐\x1fλβ＼␙ωι`",
		out:  "．．C＿ρ:>Ｃ‛␊v.Ｅq␆]＄J␊６:\x18␐\x1fλβ＼␙ωι`",
	}, { // 3052
		mask: EncodeCrLf | EncodeRightPeriod,
		in:   ".：C＿ρ:>Ｃ␊v.Ｅq␆]＄J\n６:\x18␐\x1fλβ＼␙ω．`",
		out:  ".：C＿ρ:>Ｃ‛␊v.Ｅq␆]＄J␊６:\x18␐\x1fλβ＼␙ω．`",
	}, { // 3053
		mask: EncodeCrLf | EncodeRightPeriod,
		in:   "．：C＿ρ:>Ｃ␊v.Ｅq␆]＄J\n６:\x18␐\x1fλβ＼␙ω．`",
		out:  "．：C＿ρ:>Ｃ‛␊v.Ｅq␆]＄J␊６:\x18␐\x1fλβ＼␙ω．`",
	}, { // 3054
		mask: EncodeCrLf | EncodeRightPeriod,
		in:   ".：C＿ρ:>Ｃ␊v.Ｅq␆]＄J\n６:\x18␐\x1fλβ＼␙ωι．",
		out:  ".：C＿ρ:>Ｃ‛␊v.Ｅq␆]＄J␊６:\x18␐\x1fλβ＼␙ωι‛．",
	}, { // 3055
		mask: EncodeCrLf | EncodeRightPeriod,
		in:   "．：C＿ρ:>Ｃ␊v.Ｅq␆]＄J\n６:\x18␐\x1fλβ＼␙ωι．",
		out:  "．：C＿ρ:>Ｃ‛␊v.Ｅq␆]＄J␊６:\x18␐\x1fλβ＼␙ωι‛．",
	}, { // 3056
		mask: EncodeCrLf | EncodeRightPeriod,
		in:   "␊.C＿ρ:>Ｃ␊v.Ｅq␆]＄J\n６:\x18␐\x1fλβ＼␙ωι`",
		out:  "‛␊.C＿ρ:>Ｃ‛␊v.Ｅq␆]＄J␊６:\x18␐\x1fλβ＼␙ωι`",
	}, { // 3057
		mask: EncodeCrLf | EncodeRightPeriod,
		in:   "␊．C＿ρ:>Ｃ␊v.Ｅq␆]＄J\n６:\x18␐\x1fλβ＼␙ωι`",
		out:  "‛␊．C＿ρ:>Ｃ‛␊v.Ｅq␆]＄J␊６:\x18␐\x1fλβ＼␙ωι`",
	}, { // 3058
		mask: EncodeCrLf | EncodeRightPeriod,
		in:   "␊.C＿ρ:>Ｃ␊v.Ｅq␆]＄J\n６:\x18␐\x1fλβ＼␙ω．`",
		out:  "‛␊.C＿ρ:>Ｃ‛␊v.Ｅq␆]＄J␊６:\x18␐\x1fλβ＼␙ω．`",
	}, { // 3059
		mask: EncodeCrLf | EncodeRightPeriod,
		in:   "␊．C＿ρ:>Ｃ␊v.Ｅq␆]＄J\n６:\x18␐\x1fλβ＼␙ω．`",
		out:  "‛␊．C＿ρ:>Ｃ‛␊v.Ｅq␆]＄J␊６:\x18␐\x1fλβ＼␙ω．`",
	}, { // 3060
		mask: EncodeCrLf | EncodeRightPeriod,
		in:   "␊.C＿ρ:>Ｃ␊v.Ｅq␆]＄J\n６:\x18␐\x1fλβ＼␙ωι．",
		out:  "‛␊.C＿ρ:>Ｃ‛␊v.Ｅq␆]＄J␊６:\x18␐\x1fλβ＼␙ωι‛．",
	}, { // 3061
		mask: EncodeCrLf | EncodeRightPeriod,
		in:   "␊．C＿ρ:>Ｃ␊v.Ｅq␆]＄J\n６:\x18␐\x1fλβ＼␙ωι．",
		out:  "‛␊．C＿ρ:>Ｃ‛␊v.Ｅq␆]＄J␊６:\x18␐\x1fλβ＼␙ωι‛．",
	}, { // 3062
		mask: EncodeCrLf | EncodeRightPeriod,
		in:   "␊：C＿ρ:>Ｃ␊v.Ｅq␆]＄J\n６:\x18␐\x1fλβ＼␙ω.`",
		out:  "‛␊：C＿ρ:>Ｃ‛␊v.Ｅq␆]＄J␊６:\x18␐\x1fλβ＼␙ω.`",
	}, { // 3063
		mask: EncodeCrLf | EncodeRightPeriod,
		in:   "␊：C＿ρ:>Ｃ␊v.Ｅq␆]＄J\n６:\x18␐\x1fλβ＼␙ω．`",
		out:  "‛␊：C＿ρ:>Ｃ‛␊v.Ｅq␆]＄J␊６:\x18␐\x1fλβ＼␙ω．`",
	}, { // 3064
		mask: EncodeCrLf | EncodeRightPeriod,
		in:   "␊：C＿ρ:>Ｃ␊v.Ｅq␆]＄J\n６:\x18␐\x1fλβ＼␙ω.．",
		out:  "‛␊：C＿ρ:>Ｃ‛␊v.Ｅq␆]＄J␊６:\x18␐\x1fλβ＼␙ω.‛．",
	}, { // 3065
		mask: EncodeCrLf | EncodeRightPeriod,
		in:   "␊：C＿ρ:>Ｃ␊v.Ｅq␆]＄J\n６:\x18␐\x1fλβ＼␙ω．．",
		out:  "‛␊：C＿ρ:>Ｃ‛␊v.Ｅq␆]＄J␊６:\x18␐\x1fλβ＼␙ω．‛．",
	}, { // 3066
		mask: EncodeCrLf | EncodeRightPeriod,
		in:   "␊：C＿ρ:>Ｃ␊v.Ｅq␆]＄J\n６:\x18␐\x1fλβ＼␙ωι.",
		out:  "‛␊：C＿ρ:>Ｃ‛␊v.Ｅq␆]＄J␊６:\x18␐\x1fλβ＼␙ωι．",
	}, { // 3067
		mask: EncodeCrLf | EncodeRightPeriod,
		in:   "␊：C＿ρ:>Ｃ␊v.Ｅq␆]＄J\n６:\x18␐\x1fλβ＼␙ωι．",
		out:  "‛␊：C＿ρ:>Ｃ‛␊v.Ｅq␆]＄J␊６:\x18␐\x1fλβ＼␙ωι‛．",
	}, { // 3068
		mask: EncodeDel | EncodeRightPeriod,
		in:   "ｊ␃<βης?\x1b\v^.；Ｄ\\␛＼Pσ７[δ／\x02｀θｚ`␂/~",
		out:  "ｊ␃<βης?\x1b\v^.；Ｄ\\␛＼Pσ７[δ／\x02｀θｚ`␂/~",
	}, { // 3069
		mask: EncodeDel | EncodeRightPeriod,
		in:   ".．<βης?\x1b\v^.；Ｄ\\␛＼Pσ７[δ／\x02｀θｚ`␂/~",
		out:  ".．<βης?\x1b\v^.；Ｄ\\␛＼Pσ７[δ／\x02｀θｚ`␂/~",
	}, { // 3070
		mask: EncodeDel | EncodeRightPeriod,
		in:   "．．<βης?\x1b\v^.；Ｄ\\␛＼Pσ７[δ／\x02｀θｚ`␂/~",
		out:  "．．<βης?\x1b\v^.；Ｄ\\␛＼Pσ７[δ／\x02｀θｚ`␂/~",
	}, { // 3071
		mask: EncodeDel | EncodeRightPeriod,
		in:   ".␃<βης?\x1b\v^.；Ｄ\\␛＼Pσ７[δ／\x02｀θｚ`␂．~",
		out:  ".␃<βης?\x1b\v^.；Ｄ\\␛＼Pσ７[δ／\x02｀θｚ`␂．~",
	}, { // 3072
		mask: EncodeDel | EncodeRightPeriod,
		in:   "．␃<βης?\x1b\v^.；Ｄ\\␛＼Pσ７[δ／\x02｀θｚ`␂．~",
		out:  "．␃<βης?\x1b\v^.；Ｄ\\␛＼Pσ７[δ／\x02｀θｚ`␂．~",
	}, { // 3073
		mask: EncodeDel | EncodeRightPeriod,
		in:   ".␃<βης?\x1b\v^.；Ｄ\\␛＼Pσ７[δ／\x02｀θｚ`␂/．",
		out:  ".␃<βης?\x1b\v^.；Ｄ\\␛＼Pσ７[δ／\x02｀θｚ`␂/‛．",
	}, { // 3074
		mask: EncodeDel | EncodeRightPeriod,
		in:   "．␃<βης?\x1b\v^.；Ｄ\\␛＼Pσ７[δ／\x02｀θｚ`␂/．",
		out:  "．␃<βης?\x1b\v^.；Ｄ\\␛＼Pσ７[δ／\x02｀θｚ`␂/‛．",
	}, { // 3075
		mask: EncodeDel | EncodeRightPeriod,
		in:   "ｊ.<βης?\x1b\v^.；Ｄ\\␛＼Pσ７[δ／\x02｀θｚ`␂/~",
		out:  "ｊ.<βης?\x1b\v^.；Ｄ\\␛＼Pσ７[δ／\x02｀θｚ`␂/~",
	}, { // 3076
		mask: EncodeDel | EncodeRightPeriod,
		in:   "ｊ．<βης?\x1b\v^.；Ｄ\\␛＼Pσ７[δ／\x02｀θｚ`␂/~",
		out:  "ｊ．<βης?\x1b\v^.；Ｄ\\␛＼Pσ７[δ／\x02｀θｚ`␂/~",
	}, { // 3077
		mask: EncodeDel | EncodeRightPeriod,
		in:   "ｊ.<βης?\x1b\v^.；Ｄ\\␛＼Pσ７[δ／\x02｀θｚ`␂．~",
		out:  "ｊ.<βης?\x1b\v^.；Ｄ\\␛＼Pσ７[δ／\x02｀θｚ`␂．~",
	}, { // 3078
		mask: EncodeDel | EncodeRightPeriod,
		in:   "ｊ．<βης?\x1b\v^.；Ｄ\\␛＼Pσ７[δ／\x02｀θｚ`␂．~",
		out:  "ｊ．<βης?\x1b\v^.；Ｄ\\␛＼Pσ７[δ／\x02｀θｚ`␂．~",
	}, { // 3079
		mask: EncodeDel | EncodeRightPeriod,
		in:   "ｊ.<βης?\x1b\v^.；Ｄ\\␛＼Pσ７[δ／\x02｀θｚ`␂/．",
		out:  "ｊ.<βης?\x1b\v^.；Ｄ\\␛＼Pσ７[δ／\x02｀θｚ`␂/‛．",
	}, { // 3080
		mask: EncodeDel | EncodeRightPeriod,
		in:   "ｊ．<βης?\x1b\v^.；Ｄ\\␛＼Pσ７[δ／\x02｀θｚ`␂/．",
		out:  "ｊ．<βης?\x1b\v^.；Ｄ\\␛＼Pσ７[δ／\x02｀θｚ`␂/‛．",
	}, { // 3081
		mask: EncodeDel | EncodeRightPeriod,
		in:   "ｊ␃<βης?\x1b\v^.；Ｄ\\␛＼Pσ７[δ／\x02｀θｚ`␂.~",
		out:  "ｊ␃<βης?\x1b\v^.；Ｄ\\␛＼Pσ７[δ／\x02｀θｚ`␂.~",
	}, { // 3082
		mask: EncodeDel | EncodeRightPeriod,
		in:   "ｊ␃<βης?\x1b\v^.；Ｄ\\␛＼Pσ７[δ／\x02｀θｚ`␂．~",
		out:  "ｊ␃<βης?\x1b\v^.；Ｄ\\␛＼Pσ７[δ／\x02｀θｚ`␂．~",
	}, { // 3083
		mask: EncodeDel | EncodeRightPeriod,
		in:   "ｊ␃<βης?\x1b\v^.；Ｄ\\␛＼Pσ７[δ／\x02｀θｚ`␂.．",
		out:  "ｊ␃<βης?\x1b\v^.；Ｄ\\␛＼Pσ７[δ／\x02｀θｚ`␂.‛．",
	}, { // 3084
		mask: EncodeDel | EncodeRightPeriod,
		in:   "ｊ␃<βης?\x1b\v^.；Ｄ\\␛＼Pσ７[δ／\x02｀θｚ`␂．．",
		out:  "ｊ␃<βης?\x1b\v^.；Ｄ\\␛＼Pσ７[δ／\x02｀θｚ`␂．‛．",
	}, { // 3085
		mask: EncodeDel | EncodeRightPeriod,
		in:   "ｊ␃<βης?\x1b\v^.；Ｄ\\␛＼Pσ７[δ／\x02｀θｚ`␂/.",
		out:  "ｊ␃<βης?\x1b\v^.；Ｄ\\␛＼Pσ７[δ／\x02｀θｚ`␂/．",
	}, { // 3086
		mask: EncodeDel | EncodeRightPeriod,
		in:   "ｊ␃<βης?\x1b\v^.；Ｄ\\␛＼Pσ７[δ／\x02｀θｚ`␂/．",
		out:  "ｊ␃<βης?\x1b\v^.；Ｄ\\␛＼Pσ７[δ／\x02｀θｚ`␂/‛．",
	}, { // 3087
		mask: EncodeCtl | EncodeRightPeriod,
		in:   "３]＃iσ\x1b␞［θ␈.+πLθ␅χ\"β␖Ｊ]\v\x15[Q\x05ｋＤ␜",
		out:  "３]＃iσ␛‛␞［θ‛␈.+πLθ‛␅χ\"β‛␖Ｊ]␋␕[Q␅ｋＤ‛␜",
	}, { // 3088
		mask: EncodeCtl | EncodeRightPeriod,
		in:   ".．＃iσ\x1b␞［θ␈.+πLθ␅χ\"β␖Ｊ]\v\x15[Q\x05ｋＤ␜",
		out:  ".．＃iσ␛‛␞［θ‛␈.+πLθ‛␅χ\"β‛␖Ｊ]␋␕[Q␅ｋＤ‛␜",
	}, { // 3089
		mask: EncodeCtl | EncodeRightPeriod,
		in:   "．．＃iσ\x1b␞［θ␈.+πLθ␅χ\"β␖Ｊ]\v\x15[Q\x05ｋＤ␜",
		out:  "．．＃iσ␛‛␞［θ‛␈.+πLθ‛␅χ\"β‛␖Ｊ]␋␕[Q␅ｋＤ‛␜",
	}, { // 3090
		mask: EncodeCtl | EncodeRightPeriod,
		in:   ".]＃iσ\x1b␞［θ␈.+πLθ␅χ\"β␖Ｊ]\v\x15[Q\x05ｋ．␜",
		out:  ".]＃iσ␛‛␞［θ‛␈.+πLθ‛␅χ\"β‛␖Ｊ]␋␕[Q␅ｋ．‛␜",
	}, { // 3091
		mask: EncodeCtl | EncodeRightPeriod,
		in:   "．]＃iσ\x1b␞［θ␈.+πLθ␅χ\"β␖Ｊ]\v\x15[Q\x05ｋ．␜",
		out:  "．]＃iσ␛‛␞［θ‛␈.+πLθ‛␅χ\"β‛␖Ｊ]␋␕[Q␅ｋ．‛␜",
	}, { // 3092
		mask: EncodeCtl | EncodeRightPeriod,
		in:   ".]＃iσ\x1b␞［θ␈.+πLθ␅χ\"β␖Ｊ]\v\x15[Q\x05ｋＤ．",
		out:  ".]＃iσ␛‛␞［θ‛␈.+πLθ‛␅χ\"β‛␖Ｊ]␋␕[Q␅ｋＤ‛．",
	}, { // 3093
		mask: EncodeCtl | EncodeRightPeriod,
		in:   "．]＃iσ\x1b␞［θ␈.+πLθ␅χ\"β␖Ｊ]\v\x15[Q\x05ｋＤ．",
		out:  "．]＃iσ␛‛␞［θ‛␈.+πLθ‛␅χ\"β‛␖Ｊ]␋␕[Q␅ｋＤ‛．",
	}, { // 3094
		mask: EncodeCtl | EncodeRightPeriod,
		in:   "３.＃iσ\x1b␞［θ␈.+πLθ␅χ\"β␖Ｊ]\v\x15[Q\x05ｋＤ␜",
		out:  "３.＃iσ␛‛␞［θ‛␈.+πLθ‛␅χ\"β‛␖Ｊ]␋␕[Q␅ｋＤ‛␜",
	}, { // 3095
		mask: EncodeCtl | EncodeRightPeriod,
		in:   "３．＃iσ\x1b␞［θ␈.+πLθ␅χ\"β␖Ｊ]\v\x15[Q\x05ｋＤ␜",
		out:  "３．＃iσ␛‛␞［θ‛␈.+πLθ‛␅χ\"β‛␖Ｊ]␋␕[Q␅ｋＤ‛␜",
	}, { // 3096
		mask: EncodeCtl | EncodeRightPeriod,
		in:   "３.＃iσ\x1b␞［θ␈.+πLθ␅χ\"β␖Ｊ]\v\x15[Q\x05ｋ．␜",
		out:  "３.＃iσ␛‛␞［θ‛␈.+πLθ‛␅χ\"β‛␖Ｊ]␋␕[Q␅ｋ．‛␜",
	}, { // 3097
		mask: EncodeCtl | EncodeRightPeriod,
		in:   "３．＃iσ\x1b␞［θ␈.+πLθ␅χ\"β␖Ｊ]\v\x15[Q\x05ｋ．␜",
		out:  "３．＃iσ␛‛␞［θ‛␈.+πLθ‛␅χ\"β‛␖Ｊ]␋␕[Q␅ｋ．‛␜",
	}, { // 3098
		mask: EncodeCtl | EncodeRightPeriod,
		in:   "３.＃iσ\x1b␞［θ␈.+πLθ␅χ\"β␖Ｊ]\v\x15[Q\x05ｋＤ．",
		out:  "３.＃iσ␛‛␞［θ‛␈.+πLθ‛␅χ\"β‛␖Ｊ]␋␕[Q␅ｋＤ‛．",
	}, { // 3099
		mask: EncodeCtl | EncodeRightPeriod,
		in:   "３．＃iσ\x1b␞［θ␈.+πLθ␅χ\"β␖Ｊ]\v\x15[Q\x05ｋＤ．",
		out:  "３．＃iσ␛‛␞［θ‛␈.+πLθ‛␅χ\"β‛␖Ｊ]␋␕[Q␅ｋＤ‛．",
	}, { // 3100
		mask: EncodeCtl | EncodeRightPeriod,
		in:   "３]＃iσ\x1b␞［θ␈.+πLθ␅χ\"β␖Ｊ]\v\x15[Q\x05ｋ.␜",
		out:  "３]＃iσ␛‛␞［θ‛␈.+πLθ‛␅χ\"β‛␖Ｊ]␋␕[Q␅ｋ.‛␜",
	}, { // 3101
		mask: EncodeCtl | EncodeRightPeriod,
		in:   "３]＃iσ\x1b␞［θ␈.+πLθ␅χ\"β␖Ｊ]\v\x15[Q\x05ｋ．␜",
		out:  "３]＃iσ␛‛␞［θ‛␈.+πLθ‛␅χ\"β‛␖Ｊ]␋␕[Q␅ｋ．‛␜",
	}, { // 3102
		mask: EncodeCtl | EncodeRightPeriod,
		in:   "３]＃iσ\x1b␞［θ␈.+πLθ␅χ\"β␖Ｊ]\v\x15[Q\x05ｋ.．",
		out:  "３]＃iσ␛‛␞［θ‛␈.+πLθ‛␅χ\"β‛␖Ｊ]␋␕[Q␅ｋ.‛．",
	}, { // 3103
		mask: EncodeCtl | EncodeRightPeriod,
		in:   "３]＃iσ\x1b␞［θ␈.+πLθ␅χ\"β␖Ｊ]\v\x15[Q\x05ｋ．．",
		out:  "３]＃iσ␛‛␞［θ‛␈.+πLθ‛␅χ\"β‛␖Ｊ]␋␕[Q␅ｋ．‛．",
	}, { // 3104
		mask: EncodeCtl | EncodeRightPeriod,
		in:   "３]＃iσ\x1b␞［θ␈.+πLθ␅χ\"β␖Ｊ]\v\x15[Q\x05ｋＤ.",
		out:  "３]＃iσ␛‛␞［θ‛␈.+πLθ‛␅χ\"β‛␖Ｊ]␋␕[Q␅ｋＤ．",
	}, { // 3105
		mask: EncodeCtl | EncodeRightPeriod,
		in:   "３]＃iσ\x1b␞［θ␈.+πLθ␅χ\"β␖Ｊ]\v\x15[Q\x05ｋＤ．",
		out:  "３]＃iσ␛‛␞［θ‛␈.+πLθ‛␅χ\"β‛␖Ｊ]␋␕[Q␅ｋＤ‛．",
	}, { // 3106
		mask: EncodeRightCrLfHtVt,
		in:   "\t",
		out:  "␉",
	}, { // 3107
		mask: EncodeRightCrLfHtVt,
		in:   "\n",
		out:  "␊",
	}, { // 3108
		mask: EncodeRightCrLfHtVt,
		in:   "\v",
		out:  "␋",
	}, { // 3109
		mask: EncodeRightCrLfHtVt,
		in:   "\r",
		out:  "␍",
	}, { // 3110
		mask: EncodeZero | EncodeRightCrLfHtVt,
		in:   "\x1eτｉ␂␀␂ｓＹ,ｋ\tＬ␖τ>\\␎Ｃλ\x11{:f\arξMμEπ",
		out:  "\x1eτｉ␂‛␀␂ｓＹ,ｋ\tＬ␖τ>\\␎Ｃλ\x11{:f\arξMμEπ",
	}, { // 3111
		mask: EncodeZero | EncodeRightCrLfHtVt,
		in:   "\t␉ｉ␂␀␂ｓＹ,ｋ\tＬ␖τ>\\␎Ｃλ\x11{:f\arξMμEπ",
		out:  "\t␉ｉ␂‛␀␂ｓＹ,ｋ\tＬ␖τ>\\␎Ｃλ\x11{:f\arξMμEπ",
	}, { // 3112
		mask: EncodeZero | EncodeRightCrLfHtVt,
		in:   "␉␉ｉ␂␀␂ｓＹ,ｋ\tＬ␖τ>\\␎Ｃλ\x11{:f\arξMμEπ",
		out:  "␉␉ｉ␂‛␀␂ｓＹ,ｋ\tＬ␖τ>\\␎Ｃλ\x11{:f\arξMμEπ",
	}, { // 3113
		mask: EncodeZero | EncodeRightCrLfHtVt,
		in:   "\tτｉ␂␀␂ｓＹ,ｋ\tＬ␖τ>\\␎Ｃλ\x11{:f\arξMμ␉π",
		out:  "\tτｉ␂‛␀␂ｓＹ,ｋ\tＬ␖τ>\\␎Ｃλ\x11{:f\arξMμ␉π",
	}, { // 3114
		mask: EncodeZero | EncodeRightCrLfHtVt,
		in:   "␉τｉ␂␀␂ｓＹ,ｋ\tＬ␖τ>\\␎Ｃλ\x11{:f\arξMμ␉π",
		out:  "␉τｉ␂‛␀␂ｓＹ,ｋ\tＬ␖τ>\\␎Ｃλ\x11{:f\arξMμ␉π",
	}, { // 3115
		mask: EncodeZero | EncodeRightCrLfHtVt,
		in:   "\tτｉ␂␀␂ｓＹ,ｋ\tＬ␖τ>\\␎Ｃλ\x11{:f\arξMμE␉",
		out:  "\tτｉ␂‛␀␂ｓＹ,ｋ\tＬ␖τ>\\␎Ｃλ\x11{:f\arξMμE‛␉",
	}, { // 3116
		mask: EncodeZero | EncodeRightCrLfHtVt,
		in:   "␉τｉ␂␀␂ｓＹ,ｋ\tＬ␖τ>\\␎Ｃλ\x11{:f\arξMμE␉",
		out:  "␉τｉ␂‛␀␂ｓＹ,ｋ\tＬ␖τ>\\␎Ｃλ\x11{:f\arξMμE‛␉",
	}, { // 3117
		mask: EncodeZero | EncodeRightCrLfHtVt,
		in:   "\x1e\tｉ␂␀␂ｓＹ,ｋ\tＬ␖τ>\\␎Ｃλ\x11{:f\arξMμEπ",
		out:  "\x1e\tｉ␂‛␀␂ｓＹ,ｋ\tＬ␖τ>\\␎Ｃλ\x11{:f\arξMμEπ",
	}, { // 3118
		mask: EncodeZero | EncodeRightCrLfHtVt,
		in:   "\x1e␉ｉ␂␀␂ｓＹ,ｋ\tＬ␖τ>\\␎Ｃλ\x11{:f\arξMμEπ",
		out:  "\x1e␉ｉ␂‛␀␂ｓＹ,ｋ\tＬ␖τ>\\␎Ｃλ\x11{:f\arξMμEπ",
	}, { // 3119
		mask: EncodeZero | EncodeRightCrLfHtVt,
		in:   "\x1e\tｉ␂␀␂ｓＹ,ｋ\tＬ␖τ>\\␎Ｃλ\x11{:f\arξMμ␉π",
		out:  "\x1e\tｉ␂‛␀␂ｓＹ,ｋ\tＬ␖τ>\\␎Ｃλ\x11{:f\arξMμ␉π",
	}, { // 3120
		mask: EncodeZero | EncodeRightCrLfHtVt,
		in:   "\x1e␉ｉ␂␀␂ｓＹ,ｋ\tＬ␖τ>\\␎Ｃλ\x11{:f\arξMμ␉π",
		out:  "\x1e␉ｉ␂‛␀␂ｓＹ,ｋ\tＬ␖τ>\\␎Ｃλ\x11{:f\arξMμ␉π",
	}, { // 3121
		mask: EncodeZero | EncodeRightCrLfHtVt,
		in:   "\x1e\tｉ␂␀␂ｓＹ,ｋ\tＬ␖τ>\\␎Ｃλ\x11{:f\arξMμE␉",
		out:  "\x1e\tｉ␂‛␀␂ｓＹ,ｋ\tＬ␖τ>\\␎Ｃλ\x11{:f\arξMμE‛␉",
	}, { // 3122
		mask: EncodeZero | EncodeRightCrLfHtVt,
		in:   "\x1e␉ｉ␂␀␂ｓＹ,ｋ\tＬ␖τ>\\␎Ｃλ\x11{:f\arξMμE␉",
		out:  "\x1e␉ｉ␂‛␀␂ｓＹ,ｋ\tＬ␖τ>\\␎Ｃλ\x11{:f\arξMμE‛␉",
	}, { // 3123
		mask: EncodeZero | EncodeRightCrLfHtVt,
		in:   "\x1eτｉ␂␀␂ｓＹ,ｋ\tＬ␖τ>\\␎Ｃλ\x11{:f\arξMμ\tπ",
		out:  "\x1eτｉ␂‛␀␂ｓＹ,ｋ\tＬ␖τ>\\␎Ｃλ\x11{:f\arξMμ\tπ",
	}, { // 3124
		mask: EncodeZero | EncodeRightCrLfHtVt,
		in:   "\x1eτｉ␂␀␂ｓＹ,ｋ\tＬ␖τ>\\␎Ｃλ\x11{:f\arξMμ␉π",
		out:  "\x1eτｉ␂‛␀␂ｓＹ,ｋ\tＬ␖τ>\\␎Ｃλ\x11{:f\arξMμ␉π",
	}, { // 3125
		mask: EncodeZero | EncodeRightCrLfHtVt,
		in:   "\x1eτｉ␂␀␂ｓＹ,ｋ\tＬ␖τ>\\␎Ｃλ\x11{:f\arξMμ\t␉",
		out:  "\x1eτｉ␂‛␀␂ｓＹ,ｋ\tＬ␖τ>\\␎Ｃλ\x11{:f\arξMμ\t‛␉",
	}, { // 3126
		mask: EncodeZero | EncodeRightCrLfHtVt,
		in:   "\x1eτｉ␂␀␂ｓＹ,ｋ\tＬ␖τ>\\␎Ｃλ\x11{:f\arξMμ␉␉",
		out:  "\x1eτｉ␂‛␀␂ｓＹ,ｋ\tＬ␖τ>\\␎Ｃλ\x11{:f\arξMμ␉‛␉",
	}, { // 3127
		mask: EncodeZero | EncodeRightCrLfHtVt,
		in:   "\x1eτｉ␂␀␂ｓＹ,ｋ\tＬ␖τ>\\␎Ｃλ\x11{:f\arξMμE\t",
		out:  "\x1eτｉ␂‛␀␂ｓＹ,ｋ\tＬ␖τ>\\␎Ｃλ\x11{:f\arξMμE␉",
	}, { // 3128
		mask: EncodeZero | EncodeRightCrLfHtVt,
		in:   "\x1eτｉ␂␀␂ｓＹ,ｋ\tＬ␖τ>\\␎Ｃλ\x11{:f\arξMμE␉",
		out:  "\x1eτｉ␂‛␀␂ｓＹ,ｋ\tＬ␖τ>\\␎Ｃλ\x11{:f\arξMμE‛␉",
	}, { // 3129
		mask: EncodeZero | EncodeRightCrLfHtVt,
		in:   "ξ;\x19ο1χａ3κ\v\n＼＇？\x16i(λ\x14Ｎ\n␙２␡ｋＴσ\b&␕",
		out:  "ξ;\x19ο1χａ3κ\v\n＼＇？\x16i(λ\x14Ｎ\n␙２␡ｋＴσ\b&␕",
	}, { // 3130
		mask: EncodeZero | EncodeRightCrLfHtVt,
		in:   "\n␊\x19ο1χａ3κ\v\n＼＇？\x16i(λ\x14Ｎ\n␙２␡ｋＴσ\b&␕",
		out:  "\n␊\x19ο1χａ3κ\v\n＼＇？\x16i(λ\x14Ｎ\n␙２␡ｋＴσ\b&␕",
	}, { // 3131
		mask: EncodeZero | EncodeRightCrLfHtVt,
		in:   "␊␊\x19ο1χａ3κ\v\n＼＇？\x16i(λ\x14Ｎ\n␙２␡ｋＴσ\b&␕",
		out:  "␊␊\x19ο1χａ3κ\v\n＼＇？\x16i(λ\x14Ｎ\n␙２␡ｋＴσ\b&␕",
	}, { // 3132
		mask: EncodeZero | EncodeRightCrLfHtVt,
		in:   "\n;\x19ο1χａ3κ\v\n＼＇？\x16i(λ\x14Ｎ\n␙２␡ｋＴσ\b␊␕",
		out:  "\n;\x19ο1χａ3κ\v\n＼＇？\x16i(λ\x14Ｎ\n␙２␡ｋＴσ\b␊␕",
	}, { // 3133
		mask: EncodeZero | EncodeRightCrLfHtVt,
		in:   "␊;\x19ο1χａ3κ\v\n＼＇？\x16i(λ\x14Ｎ\n␙２␡ｋＴσ\b␊␕",
		out:  "␊;\x19ο1χａ3κ\v\n＼＇？\x16i(λ\x14Ｎ\n␙２␡ｋＴσ\b␊␕",
	}, { // 3134
		mask: EncodeZero | EncodeRightCrLfHtVt,
		in:   "\n;\x19ο1χａ3κ\v\n＼＇？\x16i(λ\x14Ｎ\n␙２␡ｋＴσ\b&␊",
		out:  "\n;\x19ο1χａ3κ\v\n＼＇？\x16i(λ\x14Ｎ\n␙２␡ｋＴσ\b&‛␊",
	}, { // 3135
		mask: EncodeZero | EncodeRightCrLfHtVt,
		in:   "␊;\x19ο1χａ3κ\v\n＼＇？\x16i(λ\x14Ｎ\n␙２␡ｋＴσ\b&␊",
		out:  "␊;\x19ο1χａ3κ\v\n＼＇？\x16i(λ\x14Ｎ\n␙２␡ｋＴσ\b&‛␊",
	}, { // 3136
		mask: EncodeZero | EncodeRightCrLfHtVt,
		in:   "ξ\n\x19ο1χａ3κ\v\n＼＇？\x16i(λ\x14Ｎ\n␙２␡ｋＴσ\b&␕",
		out:  "ξ\n\x19ο1χａ3κ\v\n＼＇？\x16i(λ\x14Ｎ\n␙２␡ｋＴσ\b&␕",
	}, { // 3137
		mask: EncodeZero | EncodeRightCrLfHtVt,
		in:   "ξ␊\x19ο1χａ3κ\v\n＼＇？\x16i(λ\x14Ｎ\n␙２␡ｋＴσ\b&␕",
		out:  "ξ␊\x19ο1χａ3κ\v\n＼＇？\x16i(λ\x14Ｎ\n␙２␡ｋＴσ\b&␕",
	}, { // 3138
		mask: EncodeZero | EncodeRightCrLfHtVt,
		in:   "ξ\n\x19ο1χａ3κ\v\n＼＇？\x16i(λ\x14Ｎ\n␙２␡ｋＴσ\b␊␕",
		out:  "ξ\n\x19ο1χａ3κ\v\n＼＇？\x16i(λ\x14Ｎ\n␙２␡ｋＴσ\b␊␕",
	}, { // 3139
		mask: EncodeZero | EncodeRightCrLfHtVt,
		in:   "ξ␊\x19ο1χａ3κ\v\n＼＇？\x16i(λ\x14Ｎ\n␙２␡ｋＴσ\b␊␕",
		out:  "ξ␊\x19ο1χａ3κ\v\n＼＇？\x16i(λ\x14Ｎ\n␙２␡ｋＴσ\b␊␕",
	}, { // 3140
		mask: EncodeZero | EncodeRightCrLfHtVt,
		in:   "ξ\n\x19ο1χａ3κ\v\n＼＇？\x16i(λ\x14Ｎ\n␙２␡ｋＴσ\b&␊",
		out:  "ξ\n\x19ο1χａ3κ\v\n＼＇？\x16i(λ\x14Ｎ\n␙２␡ｋＴσ\b&‛␊",
	}, { // 3141
		mask: EncodeZero | EncodeRightCrLfHtVt,
		in:   "ξ␊\x19ο1χａ3κ\v\n＼＇？\x16i(λ\x14Ｎ\n␙２␡ｋＴσ\b&␊",
		out:  "ξ␊\x19ο1χａ3κ\v\n＼＇？\x16i(λ\x14Ｎ\n␙２␡ｋＴσ\b&‛␊",
	}, { // 3142
		mask: EncodeZero | EncodeRightCrLfHtVt,
		in:   "ξ;\x19ο1χａ3κ\v\n＼＇？\x16i(λ\x14Ｎ\n␙２␡ｋＴσ\b\n␕",
		out:  "ξ;\x19ο1χａ3κ\v\n＼＇？\x16i(λ\x14Ｎ\n␙２␡ｋＴσ\b\n␕",
	}, { // 3143
		mask: EncodeZero | EncodeRightCrLfHtVt,
		in:   "ξ;\x19ο1χａ3κ\v\n＼＇？\x16i(λ\x14Ｎ\n␙２␡ｋＴσ\b␊␕",
		out:  "ξ;\x19ο1χａ3κ\v\n＼＇？\x16i(λ\x14Ｎ\n␙２␡ｋＴσ\b␊␕",
	}, { // 3144
		mask: EncodeZero | EncodeRightCrLfHtVt,
		in:   "ξ;\x19ο1χａ3κ\v\n＼＇？\x16i(λ\x14Ｎ\n␙２␡ｋＴσ\b\n␊",
		out:  "ξ;\x19ο1χａ3κ\v\n＼＇？\x16i(λ\x14Ｎ\n␙２␡ｋＴσ\b\n‛␊",
	}, { // 3145
		mask: EncodeZero | EncodeRightCrLfHtVt,
		in:   "ξ;\x19ο1χａ3κ\v\n＼＇？\x16i(λ\x14Ｎ\n␙２␡ｋＴσ\b␊␊",
		out:  "ξ;\x19ο1χａ3κ\v\n＼＇？\x16i(λ\x14Ｎ\n␙２␡ｋＴσ\b␊‛␊",
	}, { // 3146
		mask: EncodeZero | EncodeRightCrLfHtVt,
		in:   "ξ;\x19ο1χａ3κ\v\n＼＇？\x16i(λ\x14Ｎ\n␙２␡ｋＴσ\b&\n",
		out:  "ξ;\x19ο1χａ3κ\v\n＼＇？\x16i(λ\x14Ｎ\n␙２␡ｋＴσ\b&␊",
	}, { // 3147
		mask: EncodeZero | EncodeRightCrLfHtVt,
		in:   "ξ;\x19ο1χａ3κ\v\n＼＇？\x16i(λ\x14Ｎ\n␙２␡ｋＴσ\b&␊",
		out:  "ξ;\x19ο1χａ3κ\v\n＼＇？\x16i(λ\x14Ｎ\n␙２␡ｋＴσ\b&‛␊",
	}, { // 3148
		mask: EncodeZero | EncodeRightCrLfHtVt,
		in:   "Bｇ／\x04，\x0fｊ␌μ␖\v\f1\x161νωＩ␕\x15nｐων␁␓}ρ２S",
		out:  "Bｇ／\x04，\x0fｊ␌μ␖\v\f1\x161νωＩ␕\x15nｐων␁␓}ρ２S",
	}, { // 3149
		mask: EncodeZero | EncodeRightCrLfHtVt,
		in:   "\v␋／\x04，\x0fｊ␌μ␖\v\f1\x161νωＩ␕\x15nｐων␁␓}ρ２S",
		out:  "\v␋／\x04，\x0fｊ␌μ␖\v\f1\x161νωＩ␕\x15nｐων␁␓}ρ２S",
	}, { // 3150
		mask: EncodeZero | EncodeRightCrLfHtVt,
		in:   "␋␋／\x04，\x0fｊ␌μ␖\v\f1\x161νωＩ␕\x15nｐων␁␓}ρ２S",
		out:  "␋␋／\x04，\x0fｊ␌μ␖\v\f1\x161νωＩ␕\x15nｐων␁␓}ρ２S",
	}, { // 3151
		mask: EncodeZero | EncodeRightCrLfHtVt,
		in:   "\vｇ／\x04，\x0fｊ␌μ␖\v\f1\x161νωＩ␕\x15nｐων␁␓}ρ␋S",
		out:  "\vｇ／\x04，\x0fｊ␌μ␖\v\f1\x161νωＩ␕\x15nｐων␁␓}ρ␋S",
	}, { // 3152
		mask: EncodeZero | EncodeRightCrLfHtVt,
		in:   "␋ｇ／\x04，\x0fｊ␌μ␖\v\f1\x161νωＩ␕\x15nｐων␁␓}ρ␋S",
		out:  "␋ｇ／\x04，\x0fｊ␌μ␖\v\f1\x161νωＩ␕\x15nｐων␁␓}ρ␋S",
	}, { // 3153
		mask: EncodeZero | EncodeRightCrLfHtVt,
		in:   "\vｇ／\x04，\x0fｊ␌μ␖\v\f1\x161νωＩ␕\x15nｐων␁␓}ρ２␋",
		out:  "\vｇ／\x04，\x0fｊ␌μ␖\v\f1\x161νωＩ␕\x15nｐων␁␓}ρ２‛␋",
	}, { // 3154
		mask: EncodeZero | EncodeRightCrLfHtVt,
		in:   "␋ｇ／\x04，\x0fｊ␌μ␖\v\f1\x161νωＩ␕\x15nｐων␁␓}ρ２␋",
		out:  "␋ｇ／\x04，\x0fｊ␌μ␖\v\f1\x161νωＩ␕\x15nｐων␁␓}ρ２‛␋",
	}, { // 3155
		mask: EncodeZero | EncodeRightCrLfHtVt,
		in:   "B\v／\x04，\x0fｊ␌μ␖\v\f1\x161νωＩ␕\x15nｐων␁␓}ρ２S",
		out:  "B\v／\x04，\x0fｊ␌μ␖\v\f1\x161νωＩ␕\x15nｐων␁␓}ρ２S",
	}, { // 3156
		mask: EncodeZero | EncodeRightCrLfHtVt,
		in:   "B␋／\x04，\x0fｊ␌μ␖\v\f1\x161νωＩ␕\x15nｐων␁␓}ρ２S",
		out:  "B␋／\x04，\x0fｊ␌μ␖\v\f1\x161νωＩ␕\x15nｐων␁␓}ρ２S",
	}, { // 3157
		mask: EncodeZero | EncodeRightCrLfHtVt,
		in:   "B\v／\x04，\x0fｊ␌μ␖\v\f1\x161νωＩ␕\x15nｐων␁␓}ρ␋S",
		out:  "B\v／\x04，\x0fｊ␌μ␖\v\f1\x161νωＩ␕\x15nｐων␁␓}ρ␋S",
	}, { // 3158
		mask: EncodeZero | EncodeRightCrLfHtVt,
		in:   "B␋／\x04，\x0fｊ␌μ␖\v\f1\x161νωＩ␕\x15nｐων␁␓}ρ␋S",
		out:  "B␋／\x04，\x0fｊ␌μ␖\v\f1\x161νωＩ␕\x15nｐων␁␓}ρ␋S",
	}, { // 3159
		mask: EncodeZero | EncodeRightCrLfHtVt,
		in:   "B\v／\x04，\x0fｊ␌μ␖\v\f1\x161νωＩ␕\x15nｐων␁␓}ρ２␋",
		out:  "B\v／\x04，\x0fｊ␌μ␖\v\f1\x161νωＩ␕\x15nｐων␁␓}ρ２‛␋",
	}, { // 3160
		mask: EncodeZero | EncodeRightCrLfHtVt,
		in:   "B␋／\x04，\x0fｊ␌μ␖\v\f1\x161νωＩ␕\x15nｐων␁␓}ρ２␋",
		out:  "B␋／\x04，\x0fｊ␌μ␖\v\f1\x161νωＩ␕\x15nｐων␁␓}ρ２‛␋",
	}, { // 3161
		mask: EncodeZero | EncodeRightCrLfHtVt,
		in:   "Bｇ／\x04，\x0fｊ␌μ␖\v\f1\x161νωＩ␕\x15nｐων␁␓}ρ\vS",
		out:  "Bｇ／\x04，\x0fｊ␌μ␖\v\f1\x161νωＩ␕\x15nｐων␁␓}ρ\vS",
	}, { // 3162
		mask: EncodeZero | EncodeRightCrLfHtVt,
		in:   "Bｇ／\x04，\x0fｊ␌μ␖\v\f1\x161νωＩ␕\x15nｐων␁␓}ρ␋S",
		out:  "Bｇ／\x04，\x0fｊ␌μ␖\v\f1\x161νωＩ␕\x15nｐων␁␓}ρ␋S",
	}, { // 3163
		mask: EncodeZero | EncodeRightCrLfHtVt,
		in:   "Bｇ／\x04，\x0fｊ␌μ␖\v\f1\x161νωＩ␕\x15nｐων␁␓}ρ\v␋",
		out:  "Bｇ／\x04，\x0fｊ␌μ␖\v\f1\x161νωＩ␕\x15nｐων␁␓}ρ\v‛␋",
	}, { // 3164
		mask: EncodeZero | EncodeRightCrLfHtVt,
		in:   "Bｇ／\x04，\x0fｊ␌μ␖\v\f1\x161νωＩ␕\x15nｐων␁␓}ρ␋␋",
		out:  "Bｇ／\x04，\x0fｊ␌μ␖\v\f1\x161νωＩ␕\x15nｐων␁␓}ρ␋‛␋",
	}, { // 3165
		mask: EncodeZero | EncodeRightCrLfHtVt,
		in:   "Bｇ／\x04，\x0fｊ␌μ␖\v\f1\x161νωＩ␕\x15nｐων␁␓}ρ２\v",
		out:  "Bｇ／\x04，\x0fｊ␌μ␖\v\f1\x161νωＩ␕\x15nｐων␁␓}ρ２␋",
	}, { // 3166
		mask: EncodeZero | EncodeRightCrLfHtVt,
		in:   "Bｇ／\x04，\x0fｊ␌μ␖\v\f1\x161νωＩ␕\x15nｐων␁␓}ρ２␋",
		out:  "Bｇ／\x04，\x0fｊ␌μ␖\v\f1\x161νωＩ␕\x15nｐων␁␓}ρ２‛␋",
	}, { // 3167
		mask: EncodeZero | EncodeRightCrLfHtVt,
		in:   "ω\x04\x1a`ｘ␟:\x1c＇／\rς:>-Ｗ␝+；３7ςι␃βλ␗＃RF",
		out:  "ω\x04\x1a`ｘ␟:\x1c＇／\rς:>-Ｗ␝+；３7ςι␃βλ␗＃RF",
	}, { // 3168
		mask: EncodeZero | EncodeRightCrLfHtVt,
		in:   "\r␍\x1a`ｘ␟:\x1c＇／\rς:>-Ｗ␝+；３7ςι␃βλ␗＃RF",
		out:  "\r␍\x1a`ｘ␟:\x1c＇／\rς:>-Ｗ␝+；３7ςι␃βλ␗＃RF",
	}, { // 3169
		mask: EncodeZero | EncodeRightCrLfHtVt,
		in:   "␍␍\x1a`ｘ␟:\x1c＇／\rς:>-Ｗ␝+；３7ςι␃βλ␗＃RF",
		out:  "␍␍\x1a`ｘ␟:\x1c＇／\rς:>-Ｗ␝+；３7ςι␃βλ␗＃RF",
	}, { // 3170
		mask: EncodeZero | EncodeRightCrLfHtVt,
		in:   "\r\x04\x1a`ｘ␟:\x1c＇／\rς:>-Ｗ␝+；３7ςι␃βλ␗＃␍F",
		out:  "\r\x04\x1a`ｘ␟:\x1c＇／\rς:>-Ｗ␝+；３7ςι␃βλ␗＃␍F",
	}, { // 3171
		mask: EncodeZero | EncodeRightCrLfHtVt,
		in:   "␍\x04\x1a`ｘ␟:\x1c＇／\rς:>-Ｗ␝+；３7ςι␃βλ␗＃␍F",
		out:  "␍\x04\x1a`ｘ␟:\x1c＇／\rς:>-Ｗ␝+；３7ςι␃βλ␗＃␍F",
	}, { // 3172
		mask: EncodeZero | EncodeRightCrLfHtVt,
		in:   "\r\x04\x1a`ｘ␟:\x1c＇／\rς:>-Ｗ␝+；３7ςι␃βλ␗＃R␍",
		out:  "\r\x04\x1a`ｘ␟:\x1c＇／\rς:>-Ｗ␝+；３7ςι␃βλ␗＃R‛␍",
	}, { // 3173
		mask: EncodeZero | EncodeRightCrLfHtVt,
		in:   "␍\x04\x1a`ｘ␟:\x1c＇／\rς:>-Ｗ␝+；３7ςι␃βλ␗＃R␍",
		out:  "␍\x04\x1a`ｘ␟:\x1c＇／\rς:>-Ｗ␝+；３7ςι␃βλ␗＃R‛␍",
	}, { // 3174
		mask: EncodeZero | EncodeRightCrLfHtVt,
		in:   "ω\r\x1a`ｘ␟:\x1c＇／\rς:>-Ｗ␝+；３7ςι␃βλ␗＃RF",
		out:  "ω\r\x1a`ｘ␟:\x1c＇／\rς:>-Ｗ␝+；３7ςι␃βλ␗＃RF",
	}, { // 3175
		mask: EncodeZero | EncodeRightCrLfHtVt,
		in:   "ω␍\x1a`ｘ␟:\x1c＇／\rς:>-Ｗ␝+；３7ςι␃βλ␗＃RF",
		out:  "ω␍\x1a`ｘ␟:\x1c＇／\rς:>-Ｗ␝+；３7ςι␃βλ␗＃RF",
	}, { // 3176
		mask: EncodeZero | EncodeRightCrLfHtVt,
		in:   "ω\r\x1a`ｘ␟:\x1c＇／\rς:>-Ｗ␝+；３7ςι␃βλ␗＃␍F",
		out:  "ω\r\x1a`ｘ␟:\x1c＇／\rς:>-Ｗ␝+；３7ςι␃βλ␗＃␍F",
	}, { // 3177
		mask: EncodeZero | EncodeRightCrLfHtVt,
		in:   "ω␍\x1a`ｘ␟:\x1c＇／\rς:>-Ｗ␝+；３7ςι␃βλ␗＃␍F",
		out:  "ω␍\x1a`ｘ␟:\x1c＇／\rς:>-Ｗ␝+；３7ςι␃βλ␗＃␍F",
	}, { // 3178
		mask: EncodeZero | EncodeRightCrLfHtVt,
		in:   "ω\r\x1a`ｘ␟:\x1c＇／\rς:>-Ｗ␝+；３7ςι␃βλ␗＃R␍",
		out:  "ω\r\x1a`ｘ␟:\x1c＇／\rς:>-Ｗ␝+；３7ςι␃βλ␗＃R‛␍",
	}, { // 3179
		mask: EncodeZero | EncodeRightCrLfHtVt,
		in:   "ω␍\x1a`ｘ␟:\x1c＇／\rς:>-Ｗ␝+；３7ςι␃βλ␗＃R␍",
		out:  "ω␍\x1a`ｘ␟:\x1c＇／\rς:>-Ｗ␝+；３7ςι␃βλ␗＃R‛␍",
	}, { // 3180
		mask: EncodeZero | EncodeRightCrLfHtVt,
		in:   "ω\x04\x1a`ｘ␟:\x1c＇／\rς:>-Ｗ␝+；３7ςι␃βλ␗＃\rF",
		out:  "ω\x04\x1a`ｘ␟:\x1c＇／\rς:>-Ｗ␝+；３7ςι␃βλ␗＃\rF",
	}, { // 3181
		mask: EncodeZero | EncodeRightCrLfHtVt,
		in:   "ω\x04\x1a`ｘ␟:\x1c＇／\rς:>-Ｗ␝+；３7ςι␃βλ␗＃␍F",
		out:  "ω\x04\x1a`ｘ␟:\x1c＇／\rς:>-Ｗ␝+；３7ςι␃βλ␗＃␍F",
	}, { // 3182
		mask: EncodeZero | EncodeRightCrLfHtVt,
		in:   "ω\x04\x1a`ｘ␟:\x1c＇／\rς:>-Ｗ␝+；３7ςι␃βλ␗＃\r␍",
		out:  "ω\x04\x1a`ｘ␟:\x1c＇／\rς:>-Ｗ␝+；３7ςι␃βλ␗＃\r‛␍",
	}, { // 3183
		mask: EncodeZero | EncodeRightCrLfHtVt,
		in:   "ω\x04\x1a`ｘ␟:\x1c＇／\rς:>-Ｗ␝+；３7ςι␃βλ␗＃␍␍",
		out:  "ω\x04\x1a`ｘ␟:\x1c＇／\rς:>-Ｗ␝+；３7ςι␃βλ␗＃␍‛␍",
	}, { // 3184
		mask: EncodeZero | EncodeRightCrLfHtVt,
		in:   "ω\x04\x1a`ｘ␟:\x1c＇／\rς:>-Ｗ␝+；３7ςι␃βλ␗＃R\r",
		out:  "ω\x04\x1a`ｘ␟:\x1c＇／\rς:>-Ｗ␝+；３7ςι␃βλ␗＃R␍",
	}, { // 3185
		mask: EncodeZero | EncodeRightCrLfHtVt,
		in:   "ω\x04\x1a`ｘ␟:\x1c＇／\rς:>-Ｗ␝+；３7ςι␃βλ␗＃R␍",
		out:  "ω\x04\x1a`ｘ␟:\x1c＇／\rς:>-Ｗ␝+；３7ςι␃βλ␗＃R‛␍",
	}, { // 3186
		mask: EncodeSlash | EncodeRightCrLfHtVt,
		in:   "３A␜(｝ＡＨωιｆ\t\x16＄␎/\x1e␅φＫ\x04＃τG␚\r!δ%ι^",
		out:  "３A␜(｝ＡＨωιｆ\t\x16＄␎／\x1e␅φＫ\x04＃τG␚\r!δ%ι^",
	}, { // 3187
		mask: EncodeSlash | EncodeRightCrLfHtVt,
		in:   "\t␉␜(｝ＡＨωιｆ\t\x16＄␎/\x1e␅φＫ\x04＃τG␚\r!δ%ι^",
		out:  "\t␉␜(｝ＡＨωιｆ\t\x16＄␎／\x1e␅φＫ\x04＃τG␚\r!δ%ι^",
	}, { // 3188
		mask: EncodeSlash | EncodeRightCrLfHtVt,
		in:   "␉␉␜(｝ＡＨωιｆ\t\x16＄␎/\x1e␅φＫ\x04＃τG␚\r!δ%ι^",
		out:  "␉␉␜(｝ＡＨωιｆ\t\x16＄␎／\x1e␅φＫ\x04＃τG␚\r!δ%ι^",
	}, { // 3189
		mask: EncodeSlash | EncodeRightCrLfHtVt,
		in:   "\tA␜(｝ＡＨωιｆ\t\x16＄␎/\x1e␅φＫ\x04＃τG␚\r!δ%␉^",
		out:  "\tA␜(｝ＡＨωιｆ\t\x16＄␎／\x1e␅φＫ\x04＃τG␚\r!δ%␉^",
	}, { // 3190
		mask: EncodeSlash | EncodeRightCrLfHtVt,
		in:   "␉A␜(｝ＡＨωιｆ\t\x16＄␎/\x1e␅φＫ\x04＃τG␚\r!δ%␉^",
		out:  "␉A␜(｝ＡＨωιｆ\t\x16＄␎／\x1e␅φＫ\x04＃τG␚\r!δ%␉^",
	}, { // 3191
		mask: EncodeSlash | EncodeRightCrLfHtVt,
		in:   "\tA␜(｝ＡＨωιｆ\t\x16＄␎/\x1e␅φＫ\x04＃τG␚\r!δ%ι␉",
		out:  "\tA␜(｝ＡＨωιｆ\t\x16＄␎／\x1e␅φＫ\x04＃τG␚\r!δ%ι‛␉",
	}, { // 3192
		mask: EncodeSlash | EncodeRightCrLfHtVt,
		in:   "␉A␜(｝ＡＨωιｆ\t\x16＄␎/\x1e␅φＫ\x04＃τG␚\r!δ%ι␉",
		out:  "␉A␜(｝ＡＨωιｆ\t\x16＄␎／\x1e␅φＫ\x04＃τG␚\r!δ%ι‛␉",
	}, { // 3193
		mask: EncodeSlash | EncodeRightCrLfHtVt,
		in:   "３\t␜(｝ＡＨωιｆ\t\x16＄␎/\x1e␅φＫ\x04＃τG␚\r!δ%ι^",
		out:  "３\t␜(｝ＡＨωιｆ\t\x16＄␎／\x1e␅φＫ\x04＃τG␚\r!δ%ι^",
	}, { // 3194
		mask: EncodeSlash | EncodeRightCrLfHtVt,
		in:   "３␉␜(｝ＡＨωιｆ\t\x16＄␎/\x1e␅φＫ\x04＃τG␚\r!δ%ι^",
		out:  "３␉␜(｝ＡＨωιｆ\t\x16＄␎／\x1e␅φＫ\x04＃τG␚\r!δ%ι^",
	}, { // 3195
		mask: EncodeSlash | EncodeRightCrLfHtVt,
		in:   "３\t␜(｝ＡＨωιｆ\t\x16＄␎/\x1e␅φＫ\x04＃τG␚\r!δ%␉^",
		out:  "３\t␜(｝ＡＨωιｆ\t\x16＄␎／\x1e␅φＫ\x04＃τG␚\r!δ%␉^",
	}, { // 3196
		mask: EncodeSlash | EncodeRightCrLfHtVt,
		in:   "３␉␜(｝ＡＨωιｆ\t\x16＄␎/\x1e␅φＫ\x04＃τG␚\r!δ%␉^",
		out:  "３␉␜(｝ＡＨωιｆ\t\x16＄␎／\x1e␅φＫ\x04＃τG␚\r!δ%␉^",
	}, { // 3197
		mask: EncodeSlash | EncodeRightCrLfHtVt,
		in:   "３\t␜(｝ＡＨωιｆ\t\x16＄␎/\x1e␅φＫ\x04＃τG␚\r!δ%ι␉",
		out:  "３\t␜(｝ＡＨωιｆ\t\x16＄␎／\x1e␅φＫ\x04＃τG␚\r!δ%ι‛␉",
	}, { // 3198
		mask: EncodeSlash | EncodeRightCrLfHtVt,
		in:   "３␉␜(｝ＡＨωιｆ\t\x16＄␎/\x1e␅φＫ\x04＃τG␚\r!δ%ι␉",
		out:  "３␉␜(｝ＡＨωιｆ\t\x16＄␎／\x1e␅φＫ\x04＃τG␚\r!δ%ι‛␉",
	}, { // 3199
		mask: EncodeSlash | EncodeRightCrLfHtVt,
		in:   "３A␜(｝ＡＨωιｆ\t\x16＄␎/\x1e␅φＫ\x04＃τG␚\r!δ%\t^",
		out:  "３A␜(｝ＡＨωιｆ\t\x16＄␎／\x1e␅φＫ\x04＃τG␚\r!δ%\t^",
	}, { // 3200
		mask: EncodeSlash | EncodeRightCrLfHtVt,
		in:   "３A␜(｝ＡＨωιｆ\t\x16＄␎/\x1e␅φＫ\x04＃τG␚\r!δ%␉^",
		out:  "３A␜(｝ＡＨωιｆ\t\x16＄␎／\x1e␅φＫ\x04＃τG␚\r!δ%␉^",
	}, { // 3201
		mask: EncodeSlash | EncodeRightCrLfHtVt,
		in:   "３A␜(｝ＡＨωιｆ\t\x16＄␎/\x1e␅φＫ\x04＃τG␚\r!δ%\t␉",
		out:  "３A␜(｝ＡＨωιｆ\t\x16＄␎／\x1e␅φＫ\x04＃τG␚\r!δ%\t‛␉",
	}, { // 3202
		mask: EncodeSlash | EncodeRightCrLfHtVt,
		in:   "３A␜(｝ＡＨωιｆ\t\x16＄␎/\x1e␅φＫ\x04＃τG␚\r!δ%␉␉",
		out:  "３A␜(｝ＡＨωιｆ\t\x16＄␎／\x1e␅φＫ\x04＃τG␚\r!δ%␉‛␉",
	}, { // 3203
		mask: EncodeSlash | EncodeRightCrLfHtVt,
		in:   "３A␜(｝ＡＨωιｆ\t\x16＄␎/\x1e␅φＫ\x04＃τG␚\r!δ%ι\t",
		out:  "３A␜(｝ＡＨωιｆ\t\x16＄␎／\x1e␅φＫ\x04＃τG␚\r!δ%ι␉",
	}, { // 3204
		mask: EncodeSlash | EncodeRightCrLfHtVt,
		in:   "３A␜(｝ＡＨωιｆ\t\x16＄␎/\x1e␅φＫ\x04＃τG␚\r!δ%ι␉",
		out:  "３A␜(｝ＡＨωιｆ\t\x16＄␎／\x1e␅φＫ\x04＃τG␚\r!δ%ι‛␉",
	}, { // 3205
		mask: EncodeSlash | EncodeRightCrLfHtVt,
		in:   "β＠\x16'\x1cＭ11β\x0e\nκＮ＂δ！;δr/\x16｜\r␜ｆ］␅6η＾",
		out:  "β＠\x16'\x1cＭ11β\x0e\nκＮ＂δ！;δr／\x16｜\r␜ｆ］␅6η＾",
	}, { // 3206
		mask: EncodeSlash | EncodeRightCrLfHtVt,
		in:   "\n␊\x16'\x1cＭ11β\x0e\nκＮ＂δ！;δr/\x16｜\r␜ｆ］␅6η＾",
		out:  "\n␊\x16'\x1cＭ11β\x0e\nκＮ＂δ！;δr／\x16｜\r␜ｆ］␅6η＾",
	}, { // 3207
		mask: EncodeSlash | EncodeRightCrLfHtVt,
		in:   "␊␊\x16'\x1cＭ11β\x0e\nκＮ＂δ！;δr/\x16｜\r␜ｆ］␅6η＾",
		out:  "␊␊\x16'\x1cＭ11β\x0e\nκＮ＂δ！;δr／\x16｜\r␜ｆ］␅6η＾",
	}, { // 3208
		mask: EncodeSlash | EncodeRightCrLfHtVt,
		in:   "\n＠\x16'\x1cＭ11β\x0e\nκＮ＂δ！;δr/\x16｜\r␜ｆ］␅6␊＾",
		out:  "\n＠\x16'\x1cＭ11β\x0e\nκＮ＂δ！;δr／\x16｜\r␜ｆ］␅6␊＾",
	}, { // 3209
		mask: EncodeSlash | EncodeRightCrLfHtVt,
		in:   "␊＠\x16'\x1cＭ11β\x0e\nκＮ＂δ！;δr/\x16｜\r␜ｆ］␅6␊＾",
		out:  "␊＠\x16'\x1cＭ11β\x0e\nκＮ＂δ！;δr／\x16｜\r␜ｆ］␅6␊＾",
	}, { // 3210
		mask: EncodeSlash | EncodeRightCrLfHtVt,
		in:   "\n＠\x16'\x1cＭ11β\x0e\nκＮ＂δ！;δr/\x16｜\r␜ｆ］␅6η␊",
		out:  "\n＠\x16'\x1cＭ11β\x0e\nκＮ＂δ！;δr／\x16｜\r␜ｆ］␅6η‛␊",
	}, { // 3211
		mask: EncodeSlash | EncodeRightCrLfHtVt,
		in:   "␊＠\x16'\x1cＭ11β\x0e\nκＮ＂δ！;δr/\x16｜\r␜ｆ］␅6η␊",
		out:  "␊＠\x16'\x1cＭ11β\x0e\nκＮ＂δ！;δr／\x16｜\r␜ｆ］␅6η‛␊",
	}, { // 3212
		mask: EncodeSlash | EncodeRightCrLfHtVt,
		in:   "β\n\x16'\x1cＭ11β\x0e\nκＮ＂δ！;δr/\x16｜\r␜ｆ］␅6η＾",
		out:  "β\n\x16'\x1cＭ11β\x0e\nκＮ＂δ！;δr／\x16｜\r␜ｆ］␅6η＾",
	}, { // 3213
		mask: EncodeSlash | EncodeRightCrLfHtVt,
		in:   "β␊\x16'\x1cＭ11β\x0e\nκＮ＂δ！;δr/\x16｜\r␜ｆ］␅6η＾",
		out:  "β␊\x16'\x1cＭ11β\x0e\nκＮ＂δ！;δr／\x16｜\r␜ｆ］␅6η＾",
	}, { // 3214
		mask: EncodeSlash | EncodeRightCrLfHtVt,
		in:   "β\n\x16'\x1cＭ11β\x0e\nκＮ＂δ！;δr/\x16｜\r␜ｆ］␅6␊＾",
		out:  "β\n\x16'\x1cＭ11β\x0e\nκＮ＂δ！;δr／\x16｜\r␜ｆ］␅6␊＾",
	}, { // 3215
		mask: EncodeSlash | EncodeRightCrLfHtVt,
		in:   "β␊\x16'\x1cＭ11β\x0e\nκＮ＂δ！;δr/\x16｜\r␜ｆ］␅6␊＾",
		out:  "β␊\x16'\x1cＭ11β\x0e\nκＮ＂δ！;δr／\x16｜\r␜ｆ］␅6␊＾",
	}, { // 3216
		mask: EncodeSlash | EncodeRightCrLfHtVt,
		in:   "β\n\x16'\x1cＭ11β\x0e\nκＮ＂δ！;δr/\x16｜\r␜ｆ］␅6η␊",
		out:  "β\n\x16'\x1cＭ11β\x0e\nκＮ＂δ！;δr／\x16｜\r␜ｆ］␅6η‛␊",
	}, { // 3217
		mask: EncodeSlash | EncodeRightCrLfHtVt,
		in:   "β␊\x16'\x1cＭ11β\x0e\nκＮ＂δ！;δr/\x16｜\r␜ｆ］␅6η␊",
		out:  "β␊\x16'\x1cＭ11β\x0e\nκＮ＂δ！;δr／\x16｜\r␜ｆ］␅6η‛␊",
	}, { // 3218
		mask: EncodeSlash | EncodeRightCrLfHtVt,
		in:   "β＠\x16'\x1cＭ11β\x0e\nκＮ＂δ！;δr/\x16｜\r␜ｆ］␅6\n＾",
		out:  "β＠\x16'\x1cＭ11β\x0e\nκＮ＂δ！;δr／\x16｜\r␜ｆ］␅6\n＾",
	}, { // 3219
		mask: EncodeSlash | EncodeRightCrLfHtVt,
		in:   "β＠\x16'\x1cＭ11β\x0e\nκＮ＂δ！;δr/\x16｜\r␜ｆ］␅6␊＾",
		out:  "β＠\x16'\x1cＭ11β\x0e\nκＮ＂δ！;δr／\x16｜\r␜ｆ］␅6␊＾",
	}, { // 3220
		mask: EncodeSlash | EncodeRightCrLfHtVt,
		in:   "β＠\x16'\x1cＭ11β\x0e\nκＮ＂δ！;δr/\x16｜\r␜ｆ］␅6\n␊",
		out:  "β＠\x16'\x1cＭ11β\x0e\nκＮ＂δ！;δr／\x16｜\r␜ｆ］␅6\n‛␊",
	}, { // 3221
		mask: EncodeSlash | EncodeRightCrLfHtVt,
		in:   "β＠\x16'\x1cＭ11β\x0e\nκＮ＂δ！;δr/\x16｜\r␜ｆ］␅6␊␊",
		out:  "β＠\x16'\x1cＭ11β\x0e\nκＮ＂δ！;δr／\x16｜\r␜ｆ］␅6␊‛␊",
	}, { // 3222
		mask: EncodeSlash | EncodeRightCrLfHtVt,
		in:   "β＠\x16'\x1cＭ11β\x0e\nκＮ＂δ！;δr/\x16｜\r␜ｆ］␅6η\n",
		out:  "β＠\x16'\x1cＭ11β\x0e\nκＮ＂δ！;δr／\x16｜\r␜ｆ］␅6η␊",
	}, { // 3223
		mask: EncodeSlash | EncodeRightCrLfHtVt,
		in:   "β＠\x16'\x1cＭ11β\x0e\nκＮ＂δ！;δr/\x16｜\r␜ｆ］␅6η␊",
		out:  "β＠\x16'\x1cＭ11β\x0e\nκＮ＂δ！;δr／\x16｜\r␜ｆ］␅6η‛␊",
	}, { // 3224
		mask: EncodeSlash | EncodeRightCrLfHtVt,
		in:   "？８␌\n␏πAυπ＊\vVｐ/4␙＂λ␘\u007fτ{\v\n［g\\ε＊u",
		out:  "？８␌\n␏πAυπ＊\vVｐ／4␙＂λ␘\u007fτ{\v\n［g\\ε＊u",
	}, { // 3225
		mask: EncodeSlash | EncodeRightCrLfHtVt,
		in:   "\v␋␌\n␏πAυπ＊\vVｐ/4␙＂λ␘\u007fτ{\v\n［g\\ε＊u",
		out:  "\v␋␌\n␏πAυπ＊\vVｐ／4␙＂λ␘\u007fτ{\v\n［g\\ε＊u",
	}, { // 3226
		mask: EncodeSlash | EncodeRightCrLfHtVt,
		in:   "␋␋␌\n␏πAυπ＊\vVｐ/4␙＂λ␘\u007fτ{\v\n［g\\ε＊u",
		out:  "␋␋␌\n␏πAυπ＊\vVｐ／4␙＂λ␘\u007fτ{\v\n［g\\ε＊u",
	}, { // 3227
		mask: EncodeSlash | EncodeRightCrLfHtVt,
		in:   "\v８␌\n␏πAυπ＊\vVｐ/4␙＂λ␘\u007fτ{\v\n［g\\ε␋u",
		out:  "\v８␌\n␏πAυπ＊\vVｐ／4␙＂λ␘\u007fτ{\v\n［g\\ε␋u",
	}, { // 3228
		mask: EncodeSlash | EncodeRightCrLfHtVt,
		in:   "␋８␌\n␏πAυπ＊\vVｐ/4␙＂λ␘\u007fτ{\v\n［g\\ε␋u",
		out:  "␋８␌\n␏πAυπ＊\vVｐ／4␙＂λ␘\u007fτ{\v\n［g\\ε␋u",
	}, { // 3229
		mask: EncodeSlash | EncodeRightCrLfHtVt,
		in:   "\v８␌\n␏πAυπ＊\vVｐ/4␙＂λ␘\u007fτ{\v\n［g\\ε＊␋",
		out:  "\v８␌\n␏πAυπ＊\vVｐ／4␙＂λ␘\u007fτ{\v\n［g\\ε＊‛␋",
	}, { // 3230
		mask: EncodeSlash | EncodeRightCrLfHtVt,
		in:   "␋８␌\n␏πAυπ＊\vVｐ/4␙＂λ␘\u007fτ{\v\n［g\\ε＊␋",
		out:  "␋８␌\n␏πAυπ＊\vVｐ／4␙＂λ␘\u007fτ{\v\n［g\\ε＊‛␋",
	}, { // 3231
		mask: EncodeSlash | EncodeRightCrLfHtVt,
		in:   "？\v␌\n␏πAυπ＊\vVｐ/4␙＂λ␘\u007fτ{\v\n［g\\ε＊u",
		out:  "？\v␌\n␏πAυπ＊\vVｐ／4␙＂λ␘\u007fτ{\v\n［g\\ε＊u",
	}, { // 3232
		mask: EncodeSlash | EncodeRightCrLfHtVt,
		in:   "？␋␌\n␏πAυπ＊\vVｐ/4␙＂λ␘\u007fτ{\v\n［g\\ε＊u",
		out:  "？␋␌\n␏πAυπ＊\vVｐ／4␙＂λ␘\u007fτ{\v\n［g\\ε＊u",
	}, { // 3233
		mask: EncodeSlash | EncodeRightCrLfHtVt,
		in:   "？\v␌\n␏πAυπ＊\vVｐ/4␙＂λ␘\u007fτ{\v\n［g\\ε␋u",
		out:  "？\v␌\n␏πAυπ＊\vVｐ／4␙＂λ␘\u007fτ{\v\n［g\\ε␋u",
	}, { // 3234
		mask: EncodeSlash | EncodeRightCrLfHtVt,
		in:   "？␋␌\n␏πAυπ＊\vVｐ/4␙＂λ␘\u007fτ{\v\n［g\\ε␋u",
		out:  "？␋␌\n␏πAυπ＊\vVｐ／4␙＂λ␘\u007fτ{\v\n［g\\ε␋u",
	}, { // 3235
		mask: EncodeSlash | EncodeRightCrLfHtVt,
		in:   "？\v␌\n␏πAυπ＊\vVｐ/4␙＂λ␘\u007fτ{\v\n［g\\ε＊␋",
		out:  "？\v␌\n␏πAυπ＊\vVｐ／4␙＂λ␘\u007fτ{\v\n［g\\ε＊‛␋",
	}, { // 3236
		mask: EncodeSlash | EncodeRightCrLfHtVt,
		in:   "？␋␌\n␏πAυπ＊\vVｐ/4␙＂λ␘\u007fτ{\v\n［g\\ε＊␋",
		out:  "？␋␌\n␏πAυπ＊\vVｐ／4␙＂λ␘\u007fτ{\v\n［g\\ε＊‛␋",
	}, { // 3237
		mask: EncodeSlash | EncodeRightCrLfHtVt,
		in:   "？８␌\n␏πAυπ＊\vVｐ/4␙＂λ␘\u007fτ{\v\n［g\\ε\vu",
		out:  "？８␌\n␏πAυπ＊\vVｐ／4␙＂λ␘\u007fτ{\v\n［g\\ε\vu",
	}, { // 3238
		mask: EncodeSlash | EncodeRightCrLfHtVt,
		in:   "？８␌\n␏πAυπ＊\vVｐ/4␙＂λ␘\u007fτ{\v\n［g\\ε␋u",
		out:  "？８␌\n␏πAυπ＊\vVｐ／4␙＂λ␘\u007fτ{\v\n［g\\ε␋u",
	}, { // 3239
		mask: EncodeSlash | EncodeRightCrLfHtVt,
		in:   "？８␌\n␏πAυπ＊\vVｐ/4␙＂λ␘\u007fτ{\v\n［g\\ε\v␋",
		out:  "？８␌\n␏πAυπ＊\vVｐ／4␙＂λ␘\u007fτ{\v\n［g\\ε\v‛␋",
	}, { // 3240
		mask: EncodeSlash | EncodeRightCrLfHtVt,
		in:   "？８␌\n␏πAυπ＊\vVｐ/4␙＂λ␘\u007fτ{\v\n［g\\ε␋␋",
		out:  "？８␌\n␏πAυπ＊\vVｐ／4␙＂λ␘\u007fτ{\v\n［g\\ε␋‛␋",
	}, { // 3241
		mask: EncodeSlash | EncodeRightCrLfHtVt,
		in:   "？８␌\n␏πAυπ＊\vVｐ/4␙＂λ␘\u007fτ{\v\n［g\\ε＊\v",
		out:  "？８␌\n␏πAυπ＊\vVｐ／4␙＂λ␘\u007fτ{\v\n［g\\ε＊␋",
	}, { // 3242
		mask: EncodeSlash | EncodeRightCrLfHtVt,
		in:   "？８␌\n␏πAυπ＊\vVｐ/4␙＂λ␘\u007fτ{\v\n［g\\ε＊␋",
		out:  "？８␌\n␏πAυπ＊\vVｐ／4␙＂λ␘\u007fτ{\v\n［g\\ε＊‛␋",
	}, { // 3243
		mask: EncodeSlash | EncodeRightCrLfHtVt,
		in:   "Ｖυ`μＵ］CQ\x13}\r]J␔-␚γαδｅ＇`＼\x19!Ｎ：ｗ*␜",
		out:  "Ｖυ`μＵ］CQ\x13}\r]J␔-␚γαδｅ＇`＼\x19!Ｎ：ｗ*␜",
	}, { // 3244
		mask: EncodeSlash | EncodeRightCrLfHtVt,
		in:   "\r␍`μＵ］CQ\x13}\r]J␔-␚γαδｅ＇`＼\x19!Ｎ：ｗ*␜",
		out:  "\r␍`μＵ］CQ\x13}\r]J␔-␚γαδｅ＇`＼\x19!Ｎ：ｗ*␜",
	}, { // 3245
		mask: EncodeSlash | EncodeRightCrLfHtVt,
		in:   "␍␍`μＵ］CQ\x13}\r]J␔-␚γαδｅ＇`＼\x19!Ｎ：ｗ*␜",
		out:  "␍␍`μＵ］CQ\x13}\r]J␔-␚γαδｅ＇`＼\x19!Ｎ：ｗ*␜",
	}, { // 3246
		mask: EncodeSlash | EncodeRightCrLfHtVt,
		in:   "\rυ`μＵ］CQ\x13}\r]J␔-␚γαδｅ＇`＼\x19!Ｎ：ｗ␍␜",
		out:  "\rυ`μＵ］CQ\x13}\r]J␔-␚γαδｅ＇`＼\x19!Ｎ：ｗ␍␜",
	}, { // 3247
		mask: EncodeSlash | EncodeRightCrLfHtVt,
		in:   "␍υ`μＵ］CQ\x13}\r]J␔-␚γαδｅ＇`＼\x19!Ｎ：ｗ␍␜",
		out:  "␍υ`μＵ］CQ\x13}\r]J␔-␚γαδｅ＇`＼\x19!Ｎ：ｗ␍␜",
	}, { // 3248
		mask: EncodeSlash | EncodeRightCrLfHtVt,
		in:   "\rυ`μＵ］CQ\x13}\r]J␔-␚γαδｅ＇`＼\x19!Ｎ：ｗ*␍",
		out:  "\rυ`μＵ］CQ\x13}\r]J␔-␚γαδｅ＇`＼\x19!Ｎ：ｗ*‛␍",
	}, { // 3249
		mask: EncodeSlash | EncodeRightCrLfHtVt,
		in:   "␍υ`μＵ］CQ\x13}\r]J␔-␚γαδｅ＇`＼\x19!Ｎ：ｗ*␍",
		out:  "␍υ`μＵ］CQ\x13}\r]J␔-␚γαδｅ＇`＼\x19!Ｎ：ｗ*‛␍",
	}, { // 3250
		mask: EncodeSlash | EncodeRightCrLfHtVt,
		in:   "Ｖ\r`μＵ］CQ\x13}\r]J␔-␚γαδｅ＇`＼\x19!Ｎ：ｗ*␜",
		out:  "Ｖ\r`μＵ］CQ\x13}\r]J␔-␚γαδｅ＇`＼\x19!Ｎ：ｗ*␜",
	}, { // 3251
		mask: EncodeSlash | EncodeRightCrLfHtVt,
		in:   "Ｖ␍`μＵ］CQ\x13}\r]J␔-␚γαδｅ＇`＼\x19!Ｎ：ｗ*␜",
		out:  "Ｖ␍`μＵ］CQ\x13}\r]J␔-␚γαδｅ＇`＼\x19!Ｎ：ｗ*␜",
	}, { // 3252
		mask: EncodeSlash | EncodeRightCrLfHtVt,
		in:   "Ｖ\r`μＵ］CQ\x13}\r]J␔-␚γαδｅ＇`＼\x19!Ｎ：ｗ␍␜",
		out:  "Ｖ\r`μＵ］CQ\x13}\r]J␔-␚γαδｅ＇`＼\x19!Ｎ：ｗ␍␜",
	}, { // 3253
		mask: EncodeSlash | EncodeRightCrLfHtVt,
		in:   "Ｖ␍`μＵ］CQ\x13}\r]J␔-␚γαδｅ＇`＼\x19!Ｎ：ｗ␍␜",
		out:  "Ｖ␍`μＵ］CQ\x13}\r]J␔-␚γαδｅ＇`＼\x19!Ｎ：ｗ␍␜",
	}, { // 3254
		mask: EncodeSlash | EncodeRightCrLfHtVt,
		in:   "Ｖ\r`μＵ］CQ\x13}\r]J␔-␚γαδｅ＇`＼\x19!Ｎ：ｗ*␍",
		out:  "Ｖ\r`μＵ］CQ\x13}\r]J␔-␚γαδｅ＇`＼\x19!Ｎ：ｗ*‛␍",
	}, { // 3255
		mask: EncodeSlash | EncodeRightCrLfHtVt,
		in:   "Ｖ␍`μＵ］CQ\x13}\r]J␔-␚γαδｅ＇`＼\x19!Ｎ：ｗ*␍",
		out:  "Ｖ␍`μＵ］CQ\x13}\r]J␔-␚γαδｅ＇`＼\x19!Ｎ：ｗ*‛␍",
	}, { // 3256
		mask: EncodeSlash | EncodeRightCrLfHtVt,
		in:   "Ｖυ`μＵ］CQ\x13}\r]J␔-␚γαδｅ＇`＼\x19!Ｎ：ｗ\r␜",
		out:  "Ｖυ`μＵ］CQ\x13}\r]J␔-␚γαδｅ＇`＼\x19!Ｎ：ｗ\r␜",
	}, { // 3257
		mask: EncodeSlash | EncodeRightCrLfHtVt,
		in:   "Ｖυ`μＵ］CQ\x13}\r]J␔-␚γαδｅ＇`＼\x19!Ｎ：ｗ␍␜",
		out:  "Ｖυ`μＵ］CQ\x13}\r]J␔-␚γαδｅ＇`＼\x19!Ｎ：ｗ␍␜",
	}, { // 3258
		mask: EncodeSlash | EncodeRightCrLfHtVt,
		in:   "Ｖυ`μＵ］CQ\x13}\r]J␔-␚γαδｅ＇`＼\x19!Ｎ：ｗ\r␍",
		out:  "Ｖυ`μＵ］CQ\x13}\r]J␔-␚γαδｅ＇`＼\x19!Ｎ：ｗ\r‛␍",
	}, { // 3259
		mask: EncodeSlash | EncodeRightCrLfHtVt,
		in:   "Ｖυ`μＵ］CQ\x13}\r]J␔-␚γαδｅ＇`＼\x19!Ｎ：ｗ␍␍",
		out:  "Ｖυ`μＵ］CQ\x13}\r]J␔-␚γαδｅ＇`＼\x19!Ｎ：ｗ␍‛␍",
	}, { // 3260
		mask: EncodeSlash | EncodeRightCrLfHtVt,
		in:   "Ｖυ`μＵ］CQ\x13}\r]J␔-␚γαδｅ＇`＼\x19!Ｎ：ｗ*\r",
		out:  "Ｖυ`μＵ］CQ\x13}\r]J␔-␚γαδｅ＇`＼\x19!Ｎ：ｗ*␍",
	}, { // 3261
		mask: EncodeSlash | EncodeRightCrLfHtVt,
		in:   "Ｖυ`μＵ］CQ\x13}\r]J␔-␚γαδｅ＇`＼\x19!Ｎ：ｗ*␍",
		out:  "Ｖυ`μＵ］CQ\x13}\r]J␔-␚γαδｅ＇`＼\x19!Ｎ：ｗ*‛␍",
	}, { // 3262
		mask: EncodeSingleQuote | EncodeRightCrLfHtVt,
		in:   "^ψφ@\x0fｌ␅／␊E\tｈ;φ８κγ␑\x0ea\x05Z\x0f␇ｄκ␈！Eｙ",
		out:  "^ψφ@\x0fｌ␅／␊E\tｈ;φ８κγ␑\x0ea\x05Z\x0f␇ｄκ␈！Eｙ",
	}, { // 3263
		mask: EncodeSingleQuote | EncodeRightCrLfHtVt,
		in:   "\t␉φ@\x0fｌ␅／␊E\tｈ;φ８κγ␑\x0ea\x05Z\x0f␇ｄκ␈！Eｙ",
		out:  "\t␉φ@\x0fｌ␅／␊E\tｈ;φ８κγ␑\x0ea\x05Z\x0f␇ｄκ␈！Eｙ",
	}, { // 3264
		mask: EncodeSingleQuote | EncodeRightCrLfHtVt,
		in:   "␉␉φ@\x0fｌ␅／␊E\tｈ;φ８κγ␑\x0ea\x05Z\x0f␇ｄκ␈！Eｙ",
		out:  "␉␉φ@\x0fｌ␅／␊E\tｈ;φ８κγ␑\x0ea\x05Z\x0f␇ｄκ␈！Eｙ",
	}, { // 3265
		mask: EncodeSingleQuote | EncodeRightCrLfHtVt,
		in:   "\tψφ@\x0fｌ␅／␊E\tｈ;φ８κγ␑\x0ea\x05Z\x0f␇ｄκ␈！␉ｙ",
		out:  "\tψφ@\x0fｌ␅／␊E\tｈ;φ８κγ␑\x0ea\x05Z\x0f␇ｄκ␈！␉ｙ",
	}, { // 3266
		mask: EncodeSingleQuote | EncodeRightCrLfHtVt,
		in:   "␉ψφ@\x0fｌ␅／␊E\tｈ;φ８κγ␑\x0ea\x05Z\x0f␇ｄκ␈！␉ｙ",
		out:  "␉ψφ@\x0fｌ␅／␊E\tｈ;φ８κγ␑\x0ea\x05Z\x0f␇ｄκ␈！␉ｙ",
	}, { // 3267
		mask: EncodeSingleQuote | EncodeRightCrLfHtVt,
		in:   "\tψφ@\x0fｌ␅／␊E\tｈ;φ８κγ␑\x0ea\x05Z\x0f␇ｄκ␈！E␉",
		out:  "\tψφ@\x0fｌ␅／␊E\tｈ;φ８κγ␑\x0ea\x05Z\x0f␇ｄκ␈！E‛␉",
	}, { // 3268
		mask: EncodeSingleQuote | EncodeRightCrLfHtVt,
		in:   "␉ψφ@\x0fｌ␅／␊E\tｈ;φ８κγ␑\x0ea\x05Z\x0f␇ｄκ␈！E␉",
		out:  "␉ψφ@\x0fｌ␅／␊E\tｈ;φ８κγ␑\x0ea\x05Z\x0f␇ｄκ␈！E‛␉",
	}, { // 3269
		mask: EncodeSingleQuote | EncodeRightCrLfHtVt,
		in:   "^\tφ@\x0fｌ␅／␊E\tｈ;φ８κγ␑\x0ea\x05Z\x0f␇ｄκ␈！Eｙ",
		out:  "^\tφ@\x0fｌ␅／␊E\tｈ;φ８κγ␑\x0ea\x05Z\x0f␇ｄκ␈！Eｙ",
	}, { // 3270
		mask: EncodeSingleQuote | EncodeRightCrLfHtVt,
		in:   "^␉φ@\x0fｌ␅／␊E\tｈ;φ８κγ␑\x0ea\x05Z\x0f␇ｄκ␈！Eｙ",
		out:  "^␉φ@\x0fｌ␅／␊E\tｈ;φ８κγ␑\x0ea\x05Z\x0f␇ｄκ␈！Eｙ",
	}, { // 3271
		mask: EncodeSingleQuote | EncodeRightCrLfHtVt,
		in:   "^\tφ@\x0fｌ␅／␊E\tｈ;φ８κγ␑\x0ea\x05Z\x0f␇ｄκ␈！␉ｙ",
		out:  "^\tφ@\x0fｌ␅／␊E\tｈ;φ８κγ␑\x0ea\x05Z\x0f␇ｄκ␈！␉ｙ",
	}, { // 3272
		mask: EncodeSingleQuote | EncodeRightCrLfHtVt,
		in:   "^␉φ@\x0fｌ␅／␊E\tｈ;φ８κγ␑\x0ea\x05Z\x0f␇ｄκ␈！␉ｙ",
		out:  "^␉φ@\x0fｌ␅／␊E\tｈ;φ８κγ␑\x0ea\x05Z\x0f␇ｄκ␈！␉ｙ",
	}, { // 3273
		mask: EncodeSingleQuote | EncodeRightCrLfHtVt,
		in:   "^\tφ@\x0fｌ␅／␊E\tｈ;φ８κγ␑\x0ea\x05Z\x0f␇ｄκ␈！E␉",
		out:  "^\tφ@\x0fｌ␅／␊E\tｈ;φ８κγ␑\x0ea\x05Z\x0f␇ｄκ␈！E‛␉",
	}, { // 3274
		mask: EncodeSingleQuote | EncodeRightCrLfHtVt,
		in:   "^␉φ@\x0fｌ␅／␊E\tｈ;φ８κγ␑\x0ea\x05Z\x0f␇ｄκ␈！E␉",
		out:  "^␉φ@\x0fｌ␅／␊E\tｈ;φ８κγ␑\x0ea\x05Z\x0f␇ｄκ␈！E‛␉",
	}, { // 3275
		mask: EncodeSingleQuote | EncodeRightCrLfHtVt,
		in:   "^ψφ@\x0fｌ␅／␊E\tｈ;φ８κγ␑\x0ea\x05Z\x0f␇ｄκ␈！\tｙ",
		out:  "^ψφ@\x0fｌ␅／␊E\tｈ;φ８κγ␑\x0ea\x05Z\x0f␇ｄκ␈！\tｙ",
	}, { // 3276
		mask: EncodeSingleQuote | EncodeRightCrLfHtVt,
		in:   "^ψφ@\x0fｌ␅／␊E\tｈ;φ８κγ␑\x0ea\x05Z\x0f␇ｄκ␈！␉ｙ",
		out:  "^ψφ@\x0fｌ␅／␊E\tｈ;φ８κγ␑\x0ea\x05Z\x0f␇ｄκ␈！␉ｙ",
	}, { // 3277
		mask: EncodeSingleQuote | EncodeRightCrLfHtVt,
		in:   "^ψφ@\x0fｌ␅／␊E\tｈ;φ８κγ␑\x0ea\x05Z\x0f␇ｄκ␈！\t␉",
		out:  "^ψφ@\x0fｌ␅／␊E\tｈ;φ８κγ␑\x0ea\x05Z\x0f␇ｄκ␈！\t‛␉",
	}, { // 3278
		mask: EncodeSingleQuote | EncodeRightCrLfHtVt,
		in:   "^ψφ@\x0fｌ␅／␊E\tｈ;φ８κγ␑\x0ea\x05Z\x0f␇ｄκ␈！␉␉",
		out:  "^ψφ@\x0fｌ␅／␊E\tｈ;φ８κγ␑\x0ea\x05Z\x0f␇ｄκ␈！␉‛␉",
	}, { // 3279
		mask: EncodeSingleQuote | EncodeRightCrLfHtVt,
		in:   "^ψφ@\x0fｌ␅／␊E\tｈ;φ８κγ␑\x0ea\x05Z\x0f␇ｄκ␈！E\t",
		out:  "^ψφ@\x0fｌ␅／␊E\tｈ;φ８κγ␑\x0ea\x05Z\x0f␇ｄκ␈！E␉",
	}, { // 3280
		mask: EncodeSingleQuote | EncodeRightCrLfHtVt,
		in:   "^ψφ@\x0fｌ␅／␊E\tｈ;φ８κγ␑\x0ea\x05Z\x0f␇ｄκ␈！E␉",
		out:  "^ψφ@\x0fｌ␅／␊E\tｈ;φ８κγ␑\x0ea\x05Z\x0f␇ｄκ␈！E‛␉",
	}, { // 3281
		mask: EncodeSingleQuote | EncodeRightCrLfHtVt,
		in:   "βχ^＄／␒␀`ο\x10\n>␀ｃ＜9ｂlm～ｗ\tｗGπ％\x14β/χ",
		out:  "βχ^＄／␒‛␀`ο\x10\n>‛␀ｃ＜9ｂlm～ｗ\tｗGπ％\x14β/χ",
	}, { // 3282
		mask: EncodeSingleQuote | EncodeRightCrLfHtVt,
		in:   "\n␊^＄／␒␀`ο\x10\n>␀ｃ＜9ｂlm～ｗ\tｗGπ％\x14β/χ",
		out:  "\n␊^＄／␒‛␀`ο\x10\n>‛␀ｃ＜9ｂlm～ｗ\tｗGπ％\x14β/χ",
	}, { // 3283
		mask: EncodeSingleQuote | EncodeRightCrLfHtVt,
		in:   "␊␊^＄／␒␀`ο\x10\n>␀ｃ＜9ｂlm～ｗ\tｗGπ％\x14β/χ",
		out:  "␊␊^＄／␒‛␀`ο\x10\n>‛␀ｃ＜9ｂlm～ｗ\tｗGπ％\x14β/χ",
	}, { // 3284
		mask: EncodeSingleQuote | EncodeRightCrLfHtVt,
		in:   "\nχ^＄／␒␀`ο\x10\n>␀ｃ＜9ｂlm～ｗ\tｗGπ％\x14β␊χ",
		out:  "\nχ^＄／␒‛␀`ο\x10\n>‛␀ｃ＜9ｂlm～ｗ\tｗGπ％\x14β␊χ",
	}, { // 3285
		mask: EncodeSingleQuote | EncodeRightCrLfHtVt,
		in:   "␊χ^＄／␒␀`ο\x10\n>␀ｃ＜9ｂlm～ｗ\tｗGπ％\x14β␊χ",
		out:  "␊χ^＄／␒‛␀`ο\x10\n>‛␀ｃ＜9ｂlm～ｗ\tｗGπ％\x14β␊χ",
	}, { // 3286
		mask: EncodeSingleQuote | EncodeRightCrLfHtVt,
		in:   "\nχ^＄／␒␀`ο\x10\n>␀ｃ＜9ｂlm～ｗ\tｗGπ％\x14β/␊",
		out:  "\nχ^＄／␒‛␀`ο\x10\n>‛␀ｃ＜9ｂlm～ｗ\tｗGπ％\x14β/‛␊",
	}, { // 3287
		mask: EncodeSingleQuote | EncodeRightCrLfHtVt,
		in:   "␊χ^＄／␒␀`ο\x10\n>␀ｃ＜9ｂlm～ｗ\tｗGπ％\x14β/␊",
		out:  "␊χ^＄／␒‛␀`ο\x10\n>‛␀ｃ＜9ｂlm～ｗ\tｗGπ％\x14β/‛␊",
	}, { // 3288
		mask: EncodeSingleQuote | EncodeRightCrLfHtVt,
		in:   "β\n^＄／␒␀`ο\x10\n>␀ｃ＜9ｂlm～ｗ\tｗGπ％\x14β/χ",
		out:  "β\n^＄／␒‛␀`ο\x10\n>‛␀ｃ＜9ｂlm～ｗ\tｗGπ％\x14β/χ",
	}, { // 3289
		mask: EncodeSingleQuote | EncodeRightCrLfHtVt,
		in:   "β␊^＄／␒␀`ο\x10\n>␀ｃ＜9ｂlm～ｗ\tｗGπ％\x14β/χ",
		out:  "β␊^＄／␒‛␀`ο\x10\n>‛␀ｃ＜9ｂlm～ｗ\tｗGπ％\x14β/χ",
	}, { // 3290
		mask: EncodeSingleQuote | EncodeRightCrLfHtVt,
		in:   "β\n^＄／␒␀`ο\x10\n>␀ｃ＜9ｂlm～ｗ\tｗGπ％\x14β␊χ",
		out:  "β\n^＄／␒‛␀`ο\x10\n>‛␀ｃ＜9ｂlm～ｗ\tｗGπ％\x14β␊χ",
	}, { // 3291
		mask: EncodeSingleQuote | EncodeRightCrLfHtVt,
		in:   "β␊^＄／␒␀`ο\x10\n>␀ｃ＜9ｂlm～ｗ\tｗGπ％\x14β␊χ",
		out:  "β␊^＄／␒‛␀`ο\x10\n>‛␀ｃ＜9ｂlm～ｗ\tｗGπ％\x14β␊χ",
	}, { // 3292
		mask: EncodeSingleQuote | EncodeRightCrLfHtVt,
		in:   "β\n^＄／␒␀`ο\x10\n>␀ｃ＜9ｂlm～ｗ\tｗGπ％\x14β/␊",
		out:  "β\n^＄／␒‛␀`ο\x10\n>‛␀ｃ＜9ｂlm～ｗ\tｗGπ％\x14β/‛␊",
	}, { // 3293
		mask: EncodeSingleQuote | EncodeRightCrLfHtVt,
		in:   "β␊^＄／␒␀`ο\x10\n>␀ｃ＜9ｂlm～ｗ\tｗGπ％\x14β/␊",
		out:  "β␊^＄／␒‛␀`ο\x10\n>‛␀ｃ＜9ｂlm～ｗ\tｗGπ％\x14β/‛␊",
	}, { // 3294
		mask: EncodeSingleQuote | EncodeRightCrLfHtVt,
		in:   "βχ^＄／␒␀`ο\x10\n>␀ｃ＜9ｂlm～ｗ\tｗGπ％\x14β\nχ",
		out:  "βχ^＄／␒‛␀`ο\x10\n>‛␀ｃ＜9ｂlm～ｗ\tｗGπ％\x14β\nχ",
	}, { // 3295
		mask: EncodeSingleQuote | EncodeRightCrLfHtVt,
		in:   "βχ^＄／␒␀`ο\x10\n>␀ｃ＜9ｂlm～ｗ\tｗGπ％\x14β␊χ",
		out:  "βχ^＄／␒‛␀`ο\x10\n>‛␀ｃ＜9ｂlm～ｗ\tｗGπ％\x14β␊χ",
	}, { // 3296
		mask: EncodeSingleQuote | EncodeRightCrLfHtVt,
		in:   "βχ^＄／␒␀`ο\x10\n>␀ｃ＜9ｂlm～ｗ\tｗGπ％\x14β\n␊",
		out:  "βχ^＄／␒‛␀`ο\x10\n>‛␀ｃ＜9ｂlm～ｗ\tｗGπ％\x14β\n‛␊",
	}, { // 3297
		mask: EncodeSingleQuote | EncodeRightCrLfHtVt,
		in:   "βχ^＄／␒␀`ο\x10\n>␀ｃ＜9ｂlm～ｗ\tｗGπ％\x14β␊␊",
		out:  "βχ^＄／␒‛␀`ο\x10\n>‛␀ｃ＜9ｂlm～ｗ\tｗGπ％\x14β␊‛␊",
	}, { // 3298
		mask: EncodeSingleQuote | EncodeRightCrLfHtVt,
		in:   "βχ^＄／␒␀`ο\x10\n>␀ｃ＜9ｂlm～ｗ\tｗGπ％\x14β/\n",
		out:  "βχ^＄／␒‛␀`ο\x10\n>‛␀ｃ＜9ｂlm～ｗ\tｗGπ％\x14β/␊",
	}, { // 3299
		mask: EncodeSingleQuote | EncodeRightCrLfHtVt,
		in:   "βχ^＄／␒␀`ο\x10\n>␀ｃ＜9ｂlm～ｗ\tｗGπ％\x14β/␊",
		out:  "βχ^＄／␒‛␀`ο\x10\n>‛␀ｃ＜9ｂlm～ｗ\tｗGπ％\x14β/‛␊",
	}, { // 3300
		mask: EncodeSingleQuote | EncodeRightCrLfHtVt,
		in:   "O＂2␖＝ζDy＼`\v＇Gξ；\x1fλ！\x1bＬθητ\n？Ｚ:＜Ａ\x18",
		out:  "O＂2␖＝ζDy＼`\v‛＇Gξ；\x1fλ！\x1bＬθητ\n？Ｚ:＜Ａ\x18",
	}, { // 3301
		mask: EncodeSingleQuote | EncodeRightCrLfHtVt,
		in:   "\v␋2␖＝ζDy＼`\v＇Gξ；\x1fλ！\x1bＬθητ\n？Ｚ:＜Ａ\x18",
		out:  "\v␋2␖＝ζDy＼`\v‛＇Gξ；\x1fλ！\x1bＬθητ\n？Ｚ:＜Ａ\x18",
	}, { // 3302
		mask: EncodeSingleQuote | EncodeRightCrLfHtVt,
		in:   "␋␋2␖＝ζDy＼`\v＇Gξ；\x1fλ！\x1bＬθητ\n？Ｚ:＜Ａ\x18",
		out:  "␋␋2␖＝ζDy＼`\v‛＇Gξ；\x1fλ！\x1bＬθητ\n？Ｚ:＜Ａ\x18",
	}, { // 3303
		mask: EncodeSingleQuote | EncodeRightCrLfHtVt,
		in:   "\v＂2␖＝ζDy＼`\v＇Gξ；\x1fλ！\x1bＬθητ\n？Ｚ:＜␋\x18",
		out:  "\v＂2␖＝ζDy＼`\v‛＇Gξ；\x1fλ！\x1bＬθητ\n？Ｚ:＜␋\x18",
	}, { // 3304
		mask: EncodeSingleQuote | EncodeRightCrLfHtVt,
		in:   "␋＂2␖＝ζDy＼`\v＇Gξ；\x1fλ！\x1bＬθητ\n？Ｚ:＜␋\x18",
		out:  "␋＂2␖＝ζDy＼`\v‛＇Gξ；\x1fλ！\x1bＬθητ\n？Ｚ:＜␋\x18",
	}, { // 3305
		mask: EncodeSingleQuote | EncodeRightCrLfHtVt,
		in:   "\v＂2␖＝ζDy＼`\v＇Gξ；\x1fλ！\x1bＬθητ\n？Ｚ:＜Ａ␋",
		out:  "\v＂2␖＝ζDy＼`\v‛＇Gξ；\x1fλ！\x1bＬθητ\n？Ｚ:＜Ａ‛␋",
	}, { // 3306
		mask: EncodeSingleQuote | EncodeRightCrLfHtVt,
		in:   "␋＂2␖＝ζDy＼`\v＇Gξ；\x1fλ！\x1bＬθητ\n？Ｚ:＜Ａ␋",
		out:  "␋＂2␖＝ζDy＼`\v‛＇Gξ；\x1fλ！\x1bＬθητ\n？Ｚ:＜Ａ‛␋",
	}, { // 3307
		mask: EncodeSingleQuote | EncodeRightCrLfHtVt,
		in:   "O\v2␖＝ζDy＼`\v＇Gξ；\x1fλ！\x1bＬθητ\n？Ｚ:＜Ａ\x18",
		out:  "O\v2␖＝ζDy＼`\v‛＇Gξ；\x1fλ！\x1bＬθητ\n？Ｚ:＜Ａ\x18",
	}, { // 3308
		mask: EncodeSingleQuote | EncodeRightCrLfHtVt,
		in:   "O␋2␖＝ζDy＼`\v＇Gξ；\x1fλ！\x1bＬθητ\n？Ｚ:＜Ａ\x18",
		out:  "O␋2␖＝ζDy＼`\v‛＇Gξ；\x1fλ！\x1bＬθητ\n？Ｚ:＜Ａ\x18",
	}, { // 3309
		mask: EncodeSingleQuote | EncodeRightCrLfHtVt,
		in:   "O\v2␖＝ζDy＼`\v＇Gξ；\x1fλ！\x1bＬθητ\n？Ｚ:＜␋\x18",
		out:  "O\v2␖＝ζDy＼`\v‛＇Gξ；\x1fλ！\x1bＬθητ\n？Ｚ:＜␋\x18",
	}, { // 3310
		mask: EncodeSingleQuote | EncodeRightCrLfHtVt,
		in:   "O␋2␖＝ζDy＼`\v＇Gξ；\x1fλ！\x1bＬθητ\n？Ｚ:＜␋\x18",
		out:  "O␋2␖＝ζDy＼`\v‛＇Gξ；\x1fλ！\x1bＬθητ\n？Ｚ:＜␋\x18",
	}, { // 3311
		mask: EncodeSingleQuote | EncodeRightCrLfHtVt,
		in:   "O\v2␖＝ζDy＼`\v＇Gξ；\x1fλ！\x1bＬθητ\n？Ｚ:＜Ａ␋",
		out:  "O\v2␖＝ζDy＼`\v‛＇Gξ；\x1fλ！\x1bＬθητ\n？Ｚ:＜Ａ‛␋",
	}, { // 3312
		mask: EncodeSingleQuote | EncodeRightCrLfHtVt,
		in:   "O␋2␖＝ζDy＼`\v＇Gξ；\x1fλ！\x1bＬθητ\n？Ｚ:＜Ａ␋",
		out:  "O␋2␖＝ζDy＼`\v‛＇Gξ；\x1fλ！\x1bＬθητ\n？Ｚ:＜Ａ‛␋",
	}, { // 3313
		mask: EncodeSingleQuote | EncodeRightCrLfHtVt,
		in:   "O＂2␖＝ζDy＼`\v＇Gξ；\x1fλ！\x1bＬθητ\n？Ｚ:＜\v\x18",
		out:  "O＂2␖＝ζDy＼`\v‛＇Gξ；\x1fλ！\x1bＬθητ\n？Ｚ:＜\v\x18",
	}, { // 3314
		mask: EncodeSingleQuote | EncodeRightCrLfHtVt,
		in:   "O＂2␖＝ζDy＼`\v＇Gξ；\x1fλ！\x1bＬθητ\n？Ｚ:＜␋\x18",
		out:  "O＂2␖＝ζDy＼`\v‛＇Gξ；\x1fλ！\x1bＬθητ\n？Ｚ:＜␋\x18",
	}, { // 3315
		mask: EncodeSingleQuote | EncodeRightCrLfHtVt,
		in:   "O＂2␖＝ζDy＼`\v＇Gξ；\x1fλ！\x1bＬθητ\n？Ｚ:＜\v␋",
		out:  "O＂2␖＝ζDy＼`\v‛＇Gξ；\x1fλ！\x1bＬθητ\n？Ｚ:＜\v‛␋",
	}, { // 3316
		mask: EncodeSingleQuote | EncodeRightCrLfHtVt,
		in:   "O＂2␖＝ζDy＼`\v＇Gξ；\x1fλ！\x1bＬθητ\n？Ｚ:＜␋␋",
		out:  "O＂2␖＝ζDy＼`\v‛＇Gξ；\x1fλ！\x1bＬθητ\n？Ｚ:＜␋‛␋",
	}, { // 3317
		mask: EncodeSingleQuote | EncodeRightCrLfHtVt,
		in:   "O＂2␖＝ζDy＼`\v＇Gξ；\x1fλ！\x1bＬθητ\n？Ｚ:＜Ａ\v",
		out:  "O＂2␖＝ζDy＼`\v‛＇Gξ；\x1fλ！\x1bＬθητ\n？Ｚ:＜Ａ␋",
	}, { // 3318
		mask: EncodeSingleQuote | EncodeRightCrLfHtVt,
		in:   "O＂2␖＝ζDy＼`\v＇Gξ；\x1fλ！\x1bＬθητ\n？Ｚ:＜Ａ␋",
		out:  "O＂2␖＝ζDy＼`\v‛＇Gξ；\x1fλ！\x1bＬθητ\n？Ｚ:＜Ａ‛␋",
	}, { // 3319
		mask: EncodeSingleQuote | EncodeRightCrLfHtVt,
		in:   "：g\fL[ｍ;ψ\x15>\r［υｗ｝ｍ$｜α␞%2␊β１ω＊␚\x184",
		out:  "：g\fL[ｍ;ψ\x15>\r［υｗ｝ｍ$｜α␞%2␊β１ω＊␚\x184",
	}, { // 3320
		mask: EncodeSingleQuote | EncodeRightCrLfHtVt,
		in:   "\r␍\fL[ｍ;ψ\x15>\r［υｗ｝ｍ$｜α␞%2␊β１ω＊␚\x184",
		out:  "\r␍\fL[ｍ;ψ\x15>\r［υｗ｝ｍ$｜α␞%2␊β１ω＊␚\x184",
	}, { // 3321
		mask: EncodeSingleQuote | EncodeRightCrLfHtVt,
		in:   "␍␍\fL[ｍ;ψ\x15>\r［υｗ｝ｍ$｜α␞%2␊β１ω＊␚\x184",
		out:  "␍␍\fL[ｍ;ψ\x15>\r［υｗ｝ｍ$｜α␞%2␊β１ω＊␚\x184",
	}, { // 3322
		mask: EncodeSingleQuote | EncodeRightCrLfHtVt,
		in:   "\rg\fL[ｍ;ψ\x15>\r［υｗ｝ｍ$｜α␞%2␊β１ω＊␚␍4",
		out:  "\rg\fL[ｍ;ψ\x15>\r［υｗ｝ｍ$｜α␞%2␊β１ω＊␚␍4",
	}, { // 3323
		mask: EncodeSingleQuote | EncodeRightCrLfHtVt,
		in:   "␍g\fL[ｍ;ψ\x15>\r［υｗ｝ｍ$｜α␞%2␊β１ω＊␚␍4",
		out:  "␍g\fL[ｍ;ψ\x15>\r［υｗ｝ｍ$｜α␞%2␊β１ω＊␚␍4",
	}, { // 3324
		mask: EncodeSingleQuote | EncodeRightCrLfHtVt,
		in:   "\rg\fL[ｍ;ψ\x15>\r［υｗ｝ｍ$｜α␞%2␊β１ω＊␚\x18␍",
		out:  "\rg\fL[ｍ;ψ\x15>\r［υｗ｝ｍ$｜α␞%2␊β１ω＊␚\x18‛␍",
	}, { // 3325
		mask: EncodeSingleQuote | EncodeRightCrLfHtVt,
		in:   "␍g\fL[ｍ;ψ\x15>\r［υｗ｝ｍ$｜α␞%2␊β１ω＊␚\x18␍",
		out:  "␍g\fL[ｍ;ψ\x15>\r［υｗ｝ｍ$｜α␞%2␊β１ω＊␚\x18‛␍",
	}, { // 3326
		mask: EncodeSingleQuote | EncodeRightCrLfHtVt,
		in:   "：\r\fL[ｍ;ψ\x15>\r［υｗ｝ｍ$｜α␞%2␊β１ω＊␚\x184",
		out:  "：\r\fL[ｍ;ψ\x15>\r［υｗ｝ｍ$｜α␞%2␊β１ω＊␚\x184",
	}, { // 3327
		mask: EncodeSingleQuote | EncodeRightCrLfHtVt,
		in:   "：␍\fL[ｍ;ψ\x15>\r［υｗ｝ｍ$｜α␞%2␊β１ω＊␚\x184",
		out:  "：␍\fL[ｍ;ψ\x15>\r［υｗ｝ｍ$｜α␞%2␊β１ω＊␚\x184",
	}, { // 3328
		mask: EncodeSingleQuote | EncodeRightCrLfHtVt,
		in:   "：\r\fL[ｍ;ψ\x15>\r［υｗ｝ｍ$｜α␞%2␊β１ω＊␚␍4",
		out:  "：\r\fL[ｍ;ψ\x15>\r［υｗ｝ｍ$｜α␞%2␊β１ω＊␚␍4",
	}, { // 3329
		mask: EncodeSingleQuote | EncodeRightCrLfHtVt,
		in:   "：␍\fL[ｍ;ψ\x15>\r［υｗ｝ｍ$｜α␞%2␊β１ω＊␚␍4",
		out:  "：␍\fL[ｍ;ψ\x15>\r［υｗ｝ｍ$｜α␞%2␊β１ω＊␚␍4",
	}, { // 3330
		mask: EncodeSingleQuote | EncodeRightCrLfHtVt,
		in:   "：\r\fL[ｍ;ψ\x15>\r［υｗ｝ｍ$｜α␞%2␊β１ω＊␚\x18␍",
		out:  "：\r\fL[ｍ;ψ\x15>\r［υｗ｝ｍ$｜α␞%2␊β１ω＊␚\x18‛␍",
	}, { // 3331
		mask: EncodeSingleQuote | EncodeRightCrLfHtVt,
		in:   "：␍\fL[ｍ;ψ\x15>\r［υｗ｝ｍ$｜α␞%2␊β１ω＊␚\x18␍",
		out:  "：␍\fL[ｍ;ψ\x15>\r［υｗ｝ｍ$｜α␞%2␊β１ω＊␚\x18‛␍",
	}, { // 3332
		mask: EncodeSingleQuote | EncodeRightCrLfHtVt,
		in:   "：g\fL[ｍ;ψ\x15>\r［υｗ｝ｍ$｜α␞%2␊β１ω＊␚\r4",
		out:  "：g\fL[ｍ;ψ\x15>\r［υｗ｝ｍ$｜α␞%2␊β１ω＊␚\r4",
	}, { // 3333
		mask: EncodeSingleQuote | EncodeRightCrLfHtVt,
		in:   "：g\fL[ｍ;ψ\x15>\r［υｗ｝ｍ$｜α␞%2␊β１ω＊␚␍4",
		out:  "：g\fL[ｍ;ψ\x15>\r［υｗ｝ｍ$｜α␞%2␊β１ω＊␚␍4",
	}, { // 3334
		mask: EncodeSingleQuote | EncodeRightCrLfHtVt,
		in:   "：g\fL[ｍ;ψ\x15>\r［υｗ｝ｍ$｜α␞%2␊β１ω＊␚\r␍",
		out:  "：g\fL[ｍ;ψ\x15>\r［υｗ｝ｍ$｜α␞%2␊β１ω＊␚\r‛␍",
	}, { // 3335
		mask: EncodeSingleQuote | EncodeRightCrLfHtVt,
		in:   "：g\fL[ｍ;ψ\x15>\r［υｗ｝ｍ$｜α␞%2␊β１ω＊␚␍␍",
		out:  "：g\fL[ｍ;ψ\x15>\r［υｗ｝ｍ$｜α␞%2␊β１ω＊␚␍‛␍",
	}, { // 3336
		mask: EncodeSingleQuote | EncodeRightCrLfHtVt,
		in:   "：g\fL[ｍ;ψ\x15>\r［υｗ｝ｍ$｜α␞%2␊β１ω＊␚\x18\r",
		out:  "：g\fL[ｍ;ψ\x15>\r［υｗ｝ｍ$｜α␞%2␊β１ω＊␚\x18␍",
	}, { // 3337
		mask: EncodeSingleQuote | EncodeRightCrLfHtVt,
		in:   "：g\fL[ｍ;ψ\x15>\r［υｗ｝ｍ$｜α␞%2␊β１ω＊␚\x18␍",
		out:  "：g\fL[ｍ;ψ\x15>\r［υｗ｝ｍ$｜α␞%2␊β１ω＊␚\x18‛␍",
	}, { // 3338
		mask: EncodeBackQuote | EncodeRightCrLfHtVt,
		in:   "[ｏμx＂\x1aφＫ␝␑\t␈Bρ␔\u007f␁Ｚg［!eＱｍυl[\x02ψ\x1f",
		out:  "[ｏμx＂\x1aφＫ␝␑\t␈Bρ␔\u007f␁Ｚg［!eＱｍυl[\x02ψ\x1f",
	}, { // 3339
		mask: EncodeBackQuote | EncodeRightCrLfHtVt,
		in:   "\t␉μx＂\x1aφＫ␝␑\t␈Bρ␔\u007f␁Ｚg［!eＱｍυl[\x02ψ\x1f",
		out:  "\t␉μx＂\x1aφＫ␝␑\t␈Bρ␔\u007f␁Ｚg［!eＱｍυl[\x02ψ\x1f",
	}, { // 3340
		mask: EncodeBackQuote | EncodeRightCrLfHtVt,
		in:   "␉␉μx＂\x1aφＫ␝␑\t␈Bρ␔\u007f␁Ｚg［!eＱｍυl[\x02ψ\x1f",
		out:  "␉␉μx＂\x1aφＫ␝␑\t␈Bρ␔\u007f␁Ｚg［!eＱｍυl[\x02ψ\x1f",
	}, { // 3341
		mask: EncodeBackQuote | EncodeRightCrLfHtVt,
		in:   "\tｏμx＂\x1aφＫ␝␑\t␈Bρ␔\u007f␁Ｚg［!eＱｍυl[\x02␉\x1f",
		out:  "\tｏμx＂\x1aφＫ␝␑\t␈Bρ␔\u007f␁Ｚg［!eＱｍυl[\x02␉\x1f",
	}, { // 3342
		mask: EncodeBackQuote | EncodeRightCrLfHtVt,
		in:   "␉ｏμx＂\x1aφＫ␝␑\t␈Bρ␔\u007f␁Ｚg［!eＱｍυl[\x02␉\x1f",
		out:  "␉ｏμx＂\x1aφＫ␝␑\t␈Bρ␔\u007f␁Ｚg［!eＱｍυl[\x02␉\x1f",
	}, { // 3343
		mask: EncodeBackQuote | EncodeRightCrLfHtVt,
		in:   "\tｏμx＂\x1aφＫ␝␑\t␈Bρ␔\u007f␁Ｚg［!eＱｍυl[\x02ψ␉",
		out:  "\tｏμx＂\x1aφＫ␝␑\t␈Bρ␔\u007f␁Ｚg［!eＱｍυl[\x02ψ‛␉",
	}, { // 3344
		mask: EncodeBackQuote | EncodeRightCrLfHtVt,
		in:   "␉ｏμx＂\x1aφＫ␝␑\t␈Bρ␔\u007f␁Ｚg［!eＱｍυl[\x02ψ␉",
		out:  "␉ｏμx＂\x1aφＫ␝␑\t␈Bρ␔\u007f␁Ｚg［!eＱｍυl[\x02ψ‛␉",
	}, { // 3345
		mask: EncodeBackQuote | EncodeRightCrLfHtVt,
		in:   "[\tμx＂\x1aφＫ␝␑\t␈Bρ␔\u007f␁Ｚg［!eＱｍυl[\x02ψ\x1f",
		out:  "[\tμx＂\x1aφＫ␝␑\t␈Bρ␔\u007f␁Ｚg［!eＱｍυl[\x02ψ\x1f",
	}, { // 3346
		mask: EncodeBackQuote | EncodeRightCrLfHtVt,
		in:   "[␉μx＂\x1aφＫ␝␑\t␈Bρ␔\u007f␁Ｚg［!eＱｍυl[\x02ψ\x1f",
		out:  "[␉μx＂\x1aφＫ␝␑\t␈Bρ␔\u007f␁Ｚg［!eＱｍυl[\x02ψ\x1f",
	}, { // 3347
		mask: EncodeBackQuote | EncodeRightCrLfHtVt,
		in:   "[\tμx＂\x1aφＫ␝␑\t␈Bρ␔\u007f␁Ｚg［!eＱｍυl[\x02␉\x1f",
		out:  "[\tμx＂\x1aφＫ␝␑\t␈Bρ␔\u007f␁Ｚg［!eＱｍυl[\x02␉\x1f",
	}, { // 3348
		mask: EncodeBackQuote | EncodeRightCrLfHtVt,
		in:   "[␉μx＂\x1aφＫ␝␑\t␈Bρ␔\u007f␁Ｚg［!eＱｍυl[\x02␉\x1f",
		out:  "[␉μx＂\x1aφＫ␝␑\t␈Bρ␔\u007f␁Ｚg［!eＱｍυl[\x02␉\x1f",
	}, { // 3349
		mask: EncodeBackQuote | EncodeRightCrLfHtVt,
		in:   "[\tμx＂\x1aφＫ␝␑\t␈Bρ␔\u007f␁Ｚg［!eＱｍυl[\x02ψ␉",
		out:  "[\tμx＂\x1aφＫ␝␑\t␈Bρ␔\u007f␁Ｚg［!eＱｍυl[\x02ψ‛␉",
	}, { // 3350
		mask: EncodeBackQuote | EncodeRightCrLfHtVt,
		in:   "[␉μx＂\x1aφＫ␝␑\t␈Bρ␔\u007f␁Ｚg［!eＱｍυl[\x02ψ␉",
		out:  "[␉μx＂\x1aφＫ␝␑\t␈Bρ␔\u007f␁Ｚg［!eＱｍυl[\x02ψ‛␉",
	}, { // 3351
		mask: EncodeBackQuote | EncodeRightCrLfHtVt,
		in:   "[ｏμx＂\x1aφＫ␝␑\t␈Bρ␔\u007f␁Ｚg［!eＱｍυl[\x02\t\x1f",
		out:  "[ｏμx＂\x1aφＫ␝␑\t␈Bρ␔\u007f␁Ｚg［!eＱｍυl[\x02\t\x1f",
	}, { // 3352
		mask: EncodeBackQuote | EncodeRightCrLfHtVt,
		in:   "[ｏμx＂\x1aφＫ␝␑\t␈Bρ␔\u007f␁Ｚg［!eＱｍυl[\x02␉\x1f",
		out:  "[ｏμx＂\x1aφＫ␝␑\t␈Bρ␔\u007f␁Ｚg［!eＱｍυl[\x02␉\x1f",
	}, { // 3353
		mask: EncodeBackQuote | EncodeRightCrLfHtVt,
		in:   "[ｏμx＂\x1aφＫ␝␑\t␈Bρ␔\u007f␁Ｚg［!eＱｍυl[\x02\t␉",
		out:  "[ｏμx＂\x1aφＫ␝␑\t␈Bρ␔\u007f␁Ｚg［!eＱｍυl[\x02\t‛␉",
	}, { // 3354
		mask: EncodeBackQuote | EncodeRightCrLfHtVt,
		in:   "[ｏμx＂\x1aφＫ␝␑\t␈Bρ␔\u007f␁Ｚg［!eＱｍυl[\x02␉␉",
		out:  "[ｏμx＂\x1aφＫ␝␑\t␈Bρ␔\u007f␁Ｚg［!eＱｍυl[\x02␉‛␉",
	}, { // 3355
		mask: EncodeBackQuote | EncodeRightCrLfHtVt,
		in:   "[ｏμx＂\x1aφＫ␝␑\t␈Bρ␔\u007f␁Ｚg［!eＱｍυl[\x02ψ\t",
		out:  "[ｏμx＂\x1aφＫ␝␑\t␈Bρ␔\u007f␁Ｚg［!eＱｍυl[\x02ψ␉",
	}, { // 3356
		mask: EncodeBackQuote | EncodeRightCrLfHtVt,
		in:   "[ｏμx＂\x1aφＫ␝␑\t␈Bρ␔\u007f␁Ｚg［!eＱｍυl[\x02ψ␉",
		out:  "[ｏμx＂\x1aφＫ␝␑\t␈Bρ␔\u007f␁Ｚg［!eＱｍυl[\x02ψ‛␉",
	}, { // 3357
		mask: EncodeBackQuote | EncodeRightCrLfHtVt,
		in:   "ψ␑H\x1aＮUａ␟＂␃\noτβ｀;D\x1eθ６ＲgU␍[σιｃ\x1d␁",
		out:  "ψ␑H\x1aＮUａ␟＂␃\noτβ‛｀;D\x1eθ６ＲgU␍[σιｃ\x1d␁",
	}, { // 3358
		mask: EncodeBackQuote | EncodeRightCrLfHtVt,
		in:   "\n␊H\x1aＮUａ␟＂␃\noτβ｀;D\x1eθ６ＲgU␍[σιｃ\x1d␁",
		out:  "\n␊H\x1aＮUａ␟＂␃\noτβ‛｀;D\x1eθ６ＲgU␍[σιｃ\x1d␁",
	}, { // 3359
		mask: EncodeBackQuote | EncodeRightCrLfHtVt,
		in:   "␊␊H\x1aＮUａ␟＂␃\noτβ｀;D\x1eθ６ＲgU␍[σιｃ\x1d␁",
		out:  "␊␊H\x1aＮUａ␟＂␃\noτβ‛｀;D\x1eθ６ＲgU␍[σιｃ\x1d␁",
	}, { // 3360
		mask: EncodeBackQuote | EncodeRightCrLfHtVt,
		in:   "\n␑H\x1aＮUａ␟＂␃\noτβ｀;D\x1eθ６ＲgU␍[σιｃ␊␁",
		out:  "\n␑H\x1aＮUａ␟＂␃\noτβ‛｀;D\x1eθ６ＲgU␍[σιｃ␊␁",
	}, { // 3361
		mask: EncodeBackQuote | EncodeRightCrLfHtVt,
		in:   "␊␑H\x1aＮUａ␟＂␃\noτβ｀;D\x1eθ６ＲgU␍[σιｃ␊␁",
		out:  "␊␑H\x1aＮUａ␟＂␃\noτβ‛｀;D\x1eθ６ＲgU␍[σιｃ␊␁",
	}, { // 3362
		mask: EncodeBackQuote | EncodeRightCrLfHtVt,
		in:   "\n␑H\x1aＮUａ␟＂␃\noτβ｀;D\x1eθ６ＲgU␍[σιｃ\x1d␊",
		out:  "\n␑H\x1aＮUａ␟＂␃\noτβ‛｀;D\x1eθ６ＲgU␍[σιｃ\x1d‛␊",
	}, { // 3363
		mask: EncodeBackQuote | EncodeRightCrLfHtVt,
		in:   "␊␑H\x1aＮUａ␟＂␃\noτβ｀;D\x1eθ６ＲgU␍[σιｃ\x1d␊",
		out:  "␊␑H\x1aＮUａ␟＂␃\noτβ‛｀;D\x1eθ６ＲgU␍[σιｃ\x1d‛␊",
	}, { // 3364
		mask: EncodeBackQuote | EncodeRightCrLfHtVt,
		in:   "ψ\nH\x1aＮUａ␟＂␃\noτβ｀;D\x1eθ６ＲgU␍[σιｃ\x1d␁",
		out:  "ψ\nH\x1aＮUａ␟＂␃\noτβ‛｀;D\x1eθ６ＲgU␍[σιｃ\x1d␁",
	}, { // 3365
		mask: EncodeBackQuote | EncodeRightCrLfHtVt,
		in:   "ψ␊H\x1aＮUａ␟＂␃\noτβ｀;D\x1eθ６ＲgU␍[σιｃ\x1d␁",
		out:  "ψ␊H\x1aＮUａ␟＂␃\noτβ‛｀;D\x1eθ６ＲgU␍[σιｃ\x1d␁",
	}, { // 3366
		mask: EncodeBackQuote | EncodeRightCrLfHtVt,
		in:   "ψ\nH\x1aＮUａ␟＂␃\noτβ｀;D\x1eθ６ＲgU␍[σιｃ␊␁",
		out:  "ψ\nH\x1aＮUａ␟＂␃\noτβ‛｀;D\x1eθ６ＲgU␍[σιｃ␊␁",
	}, { // 3367
		mask: EncodeBackQuote | EncodeRightCrLfHtVt,
		in:   "ψ␊H\x1aＮUａ␟＂␃\noτβ｀;D\x1eθ６ＲgU␍[σιｃ␊␁",
		out:  "ψ␊H\x1aＮUａ␟＂␃\noτβ‛｀;D\x1eθ６ＲgU␍[σιｃ␊␁",
	}, { // 3368
		mask: EncodeBackQuote | EncodeRightCrLfHtVt,
		in:   "ψ\nH\x1aＮUａ␟＂␃\noτβ｀;D\x1eθ６ＲgU␍[σιｃ\x1d␊",
		out:  "ψ\nH\x1aＮUａ␟＂␃\noτβ‛｀;D\x1eθ６ＲgU␍[σιｃ\x1d‛␊",
	}, { // 3369
		mask: EncodeBackQuote | EncodeRightCrLfHtVt,
		in:   "ψ␊H\x1aＮUａ␟＂␃\noτβ｀;D\x1eθ６ＲgU␍[σιｃ\x1d␊",
		out:  "ψ␊H\x1aＮUａ␟＂␃\noτβ‛｀;D\x1eθ６ＲgU␍[σιｃ\x1d‛␊",
	}, { // 3370
		mask: EncodeBackQuote | EncodeRightCrLfHtVt,
		in:   "ψ␑H\x1aＮUａ␟＂␃\noτβ｀;D\x1eθ６ＲgU␍[σιｃ\n␁",
		out:  "ψ␑H\x1aＮUａ␟＂␃\noτβ‛｀;D\x1eθ６ＲgU␍[σιｃ\n␁",
	}, { // 3371
		mask: EncodeBackQuote | EncodeRightCrLfHtVt,
		in:   "ψ␑H\x1aＮUａ␟＂␃\noτβ｀;D\x1eθ６ＲgU␍[σιｃ␊␁",
		out:  "ψ␑H\x1aＮUａ␟＂␃\noτβ‛｀;D\x1eθ６ＲgU␍[σιｃ␊␁",
	}, { // 3372
		mask: EncodeBackQuote | EncodeRightCrLfHtVt,
		in:   "ψ␑H\x1aＮUａ␟＂␃\noτβ｀;D\x1eθ６ＲgU␍[σιｃ\n␊",
		out:  "ψ␑H\x1aＮUａ␟＂␃\noτβ‛｀;D\x1eθ６ＲgU␍[σιｃ\n‛␊",
	}, { // 3373
		mask: EncodeBackQuote | EncodeRightCrLfHtVt,
		in:   "ψ␑H\x1aＮUａ␟＂␃\noτβ｀;D\x1eθ６ＲgU␍[σιｃ␊␊",
		out:  "ψ␑H\x1aＮUａ␟＂␃\noτβ‛｀;D\x1eθ６ＲgU␍[σιｃ␊‛␊",
	}, { // 3374
		mask: EncodeBackQuote | EncodeRightCrLfHtVt,
		in:   "ψ␑H\x1aＮUａ␟＂␃\noτβ｀;D\x1eθ６ＲgU␍[σιｃ\x1d\n",
		out:  "ψ␑H\x1aＮUａ␟＂␃\noτβ‛｀;D\x1eθ６ＲgU␍[σιｃ\x1d␊",
	}, { // 3375
		mask: EncodeBackQuote | EncodeRightCrLfHtVt,
		in:   "ψ␑H\x1aＮUａ␟＂␃\noτβ｀;D\x1eθ６ＲgU␍[σιｃ\x1d␊",
		out:  "ψ␑H\x1aＮUａ␟＂␃\noτβ‛｀;D\x1eθ６ＲgU␍[σιｃ\x1d‛␊",
	}, { // 3376
		mask: EncodeBackQuote | EncodeRightCrLfHtVt,
		in:   "，Ｋβ␁\x0eVruξ}\v／␁]>␄\x1c␝\x16＂κ0\x12ξＯσ\x03σｋ\uff00",
		out:  "，Ｋβ␁\x0eVruξ}\v／␁]>␄\x1c␝\x16＂κ0\x12ξＯσ\x03σｋ\uff00",
	}, { // 3377
		mask: EncodeBackQuote | EncodeRightCrLfHtVt,
		in:   "\v␋β␁\x0eVruξ}\v／␁]>␄\x1c␝\x16＂κ0\x12ξＯσ\x03σｋ\uff00",
		out:  "\v␋β␁\x0eVruξ}\v／␁]>␄\x1c␝\x16＂κ0\x12ξＯσ\x03σｋ\uff00",
	}, { // 3378
		mask: EncodeBackQuote | EncodeRightCrLfHtVt,
		in:   "␋␋β␁\x0eVruξ}\v／␁]>␄\x1c␝\x16＂κ0\x12ξＯσ\x03σｋ\uff00",
		out:  "␋␋β␁\x0eVruξ}\v／␁]>␄\x1c␝\x16＂κ0\x12ξＯσ\x03σｋ\uff00",
	}, { // 3379
		mask: EncodeBackQuote | EncodeRightCrLfHtVt,
		in:   "\vＫβ␁\x0eVruξ}\v／␁]>␄\x1c␝\x16＂κ0\x12ξＯσ\x03σ␋\uff00",
		out:  "\vＫβ␁\x0eVruξ}\v／␁]>␄\x1c␝\x16＂κ0\x12ξＯσ\x03σ␋\uff00",
	}, { // 3380
		mask: EncodeBackQuote | EncodeRightCrLfHtVt,
		in:   "␋Ｋβ␁\x0eVruξ}\v／␁]>␄\x1c␝\x16＂κ0\x12ξＯσ\x03σ␋\uff00",
		out:  "␋Ｋβ␁\x0eVruξ}\v／␁]>␄\x1c␝\x16＂κ0\x12ξＯσ\x03σ␋\uff00",
	}, { // 3381
		mask: EncodeBackQuote | EncodeRightCrLfHtVt,
		in:   "\vＫβ␁\x0eVruξ}\v／␁]>␄\x1c␝\x16＂κ0\x12ξＯσ\x03σｋ␋",
		out:  "\vＫβ␁\x0eVruξ}\v／␁]>␄\x1c␝\x16＂κ0\x12ξＯσ\x03σｋ‛␋",
	}, { // 3382
		mask: EncodeBackQuote | EncodeRightCrLfHtVt,
		in:   "␋Ｋβ␁\x0eVruξ}\v／␁]>␄\x1c␝\x16＂κ0\x12ξＯσ\x03σｋ␋",
		out:  "␋Ｋβ␁\x0eVruξ}\v／␁]>␄\x1c␝\x16＂κ0\x12ξＯσ\x03σｋ‛␋",
	}, { // 3383
		mask: EncodeBackQuote | EncodeRightCrLfHtVt,
		in:   "，\vβ␁\x0eVruξ}\v／␁]>␄\x1c␝\x16＂κ0\x12ξＯσ\x03σｋ\uff00",
		out:  "，\vβ␁\x0eVruξ}\v／␁]>␄\x1c␝\x16＂κ0\x12ξＯσ\x03σｋ\uff00",
	}, { // 3384
		mask: EncodeBackQuote | EncodeRightCrLfHtVt,
		in:   "，␋β␁\x0eVruξ}\v／␁]>␄\x1c␝\x16＂κ0\x12ξＯσ\x03σｋ\uff00",
		out:  "，␋β␁\x0eVruξ}\v／␁]>␄\x1c␝\x16＂κ0\x12ξＯσ\x03σｋ\uff00",
	}, { // 3385
		mask: EncodeBackQuote | EncodeRightCrLfHtVt,
		in:   "，\vβ␁\x0eVruξ}\v／␁]>␄\x1c␝\x16＂κ0\x12ξＯσ\x03σ␋\uff00",
		out:  "，\vβ␁\x0eVruξ}\v／␁]>␄\x1c␝\x16＂κ0\x12ξＯσ\x03σ␋\uff00",
	}, { // 3386
		mask: EncodeBackQuote | EncodeRightCrLfHtVt,
		in:   "，␋β␁\x0eVruξ}\v／␁]>␄\x1c␝\x16＂κ0\x12ξＯσ\x03σ␋\uff00",
		out:  "，␋β␁\x0eVruξ}\v／␁]>␄\x1c␝\x16＂κ0\x12ξＯσ\x03σ␋\uff00",
	}, { // 3387
		mask: EncodeBackQuote | EncodeRightCrLfHtVt,
		in:   "，\vβ␁\x0eVruξ}\v／␁]>␄\x1c␝\x16＂κ0\x12ξＯσ\x03σｋ␋",
		out:  "，\vβ␁\x0eVruξ}\v／␁]>␄\x1c␝\x16＂κ0\x12ξＯσ\x03σｋ‛␋",
	}, { // 3388
		mask: EncodeBackQuote | EncodeRightCrLfHtVt,
		in:   "，␋β␁\x0eVruξ}\v／␁]>␄\x1c␝\x16＂κ0\x12ξＯσ\x03σｋ␋",
		out:  "，␋β␁\x0eVruξ}\v／␁]>␄\x1c␝\x16＂κ0\x12ξＯσ\x03σｋ‛␋",
	}, { // 3389
		mask: EncodeBackQuote | EncodeRightCrLfHtVt,
		in:   "，Ｋβ␁\x0eVruξ}\v／␁]>␄\x1c␝\x16＂κ0\x12ξＯσ\x03σ\v\uff00",
		out:  "，Ｋβ␁\x0eVruξ}\v／␁]>␄\x1c␝\x16＂κ0\x12ξＯσ\x03σ\v\uff00",
	}, { // 3390
		mask: EncodeBackQuote | EncodeRightCrLfHtVt,
		in:   "，Ｋβ␁\x0eVruξ}\v／␁]>␄\x1c␝\x16＂κ0\x12ξＯσ\x03σ␋\uff00",
		out:  "，Ｋβ␁\x0eVruξ}\v／␁]>␄\x1c␝\x16＂κ0\x12ξＯσ\x03σ␋\uff00",
	}, { // 3391
		mask: EncodeBackQuote | EncodeRightCrLfHtVt,
		in:   "，Ｋβ␁\x0eVruξ}\v／␁]>␄\x1c␝\x16＂κ0\x12ξＯσ\x03σ\v␋",
		out:  "，Ｋβ␁\x0eVruξ}\v／␁]>␄\x1c␝\x16＂κ0\x12ξＯσ\x03σ\v‛␋",
	}, { // 3392
		mask: EncodeBackQuote | EncodeRightCrLfHtVt,
		in:   "，Ｋβ␁\x0eVruξ}\v／␁]>␄\x1c␝\x16＂κ0\x12ξＯσ\x03σ␋␋",
		out:  "，Ｋβ␁\x0eVruξ}\v／␁]>␄\x1c␝\x16＂κ0\x12ξＯσ\x03σ␋‛␋",
	}, { // 3393
		mask: EncodeBackQuote | EncodeRightCrLfHtVt,
		in:   "，Ｋβ␁\x0eVruξ}\v／␁]>␄\x1c␝\x16＂κ0\x12ξＯσ\x03σｋ\v",
		out:  "，Ｋβ␁\x0eVruξ}\v／␁]>␄\x1c␝\x16＂κ0\x12ξＯσ\x03σｋ␋",
	}, { // 3394
		mask: EncodeBackQuote | EncodeRightCrLfHtVt,
		in:   "，Ｋβ␁\x0eVruξ}\v／␁]>␄\x1c␝\x16＂κ0\x12ξＯσ\x03σｋ␋",
		out:  "，Ｋβ␁\x0eVruξ}\v／␁]>␄\x1c␝\x16＂κ0\x12ξＯσ\x03σｋ‛␋",
	}, { // 3395
		mask: EncodeBackQuote | EncodeRightCrLfHtVt,
		in:   "3θＰ\x11π`ψ＃Gs\r/.\rξ＞␍＿＃ｋ:␓\x0eＲψ\vα｜␕）",
		out:  "3θＰ\x11π｀ψ＃Gs\r/.\rξ＞␍＿＃ｋ:␓\x0eＲψ\vα｜␕）",
	}, { // 3396
		mask: EncodeBackQuote | EncodeRightCrLfHtVt,
		in:   "\r␍Ｐ\x11π`ψ＃Gs\r/.\rξ＞␍＿＃ｋ:␓\x0eＲψ\vα｜␕）",
		out:  "\r␍Ｐ\x11π｀ψ＃Gs\r/.\rξ＞␍＿＃ｋ:␓\x0eＲψ\vα｜␕）",
	}, { // 3397
		mask: EncodeBackQuote | EncodeRightCrLfHtVt,
		in:   "␍␍Ｐ\x11π`ψ＃Gs\r/.\rξ＞␍＿＃ｋ:␓\x0eＲψ\vα｜␕）",
		out:  "␍␍Ｐ\x11π｀ψ＃Gs\r/.\rξ＞␍＿＃ｋ:␓\x0eＲψ\vα｜␕）",
	}, { // 3398
		mask: EncodeBackQuote | EncodeRightCrLfHtVt,
		in:   "\rθＰ\x11π`ψ＃Gs\r/.\rξ＞␍＿＃ｋ:␓\x0eＲψ\vα｜␍）",
		out:  "\rθＰ\x11π｀ψ＃Gs\r/.\rξ＞␍＿＃ｋ:␓\x0eＲψ\vα｜␍）",
	}, { // 3399
		mask: EncodeBackQuote | EncodeRightCrLfHtVt,
		in:   "␍θＰ\x11π`ψ＃Gs\r/.\rξ＞␍＿＃ｋ:␓\x0eＲψ\vα｜␍）",
		out:  "␍θＰ\x11π｀ψ＃Gs\r/.\rξ＞␍＿＃ｋ:␓\x0eＲψ\vα｜␍）",
	}, { // 3400
		mask: EncodeBackQuote | EncodeRightCrLfHtVt,
		in:   "\rθＰ\x11π`ψ＃Gs\r/.\rξ＞␍＿＃ｋ:␓\x0eＲψ\vα｜␕␍",
		out:  "\rθＰ\x11π｀ψ＃Gs\r/.\rξ＞␍＿＃ｋ:␓\x0eＲψ\vα｜␕‛␍",
	}, { // 3401
		mask: EncodeBackQuote | EncodeRightCrLfHtVt,
		in:   "␍θＰ\x11π`ψ＃Gs\r/.\rξ＞␍＿＃ｋ:␓\x0eＲψ\vα｜␕␍",
		out:  "␍θＰ\x11π｀ψ＃Gs\r/.\rξ＞␍＿＃ｋ:␓\x0eＲψ\vα｜␕‛␍",
	}, { // 3402
		mask: EncodeBackQuote | EncodeRightCrLfHtVt,
		in:   "3\rＰ\x11π`ψ＃Gs\r/.\rξ＞␍＿＃ｋ:␓\x0eＲψ\vα｜␕）",
		out:  "3\rＰ\x11π｀ψ＃Gs\r/.\rξ＞␍＿＃ｋ:␓\x0eＲψ\vα｜␕）",
	}, { // 3403
		mask: EncodeBackQuote | EncodeRightCrLfHtVt,
		in:   "3␍Ｐ\x11π`ψ＃Gs\r/.\rξ＞␍＿＃ｋ:␓\x0eＲψ\vα｜␕）",
		out:  "3␍Ｐ\x11π｀ψ＃Gs\r/.\rξ＞␍＿＃ｋ:␓\x0eＲψ\vα｜␕）",
	}, { // 3404
		mask: EncodeBackQuote | EncodeRightCrLfHtVt,
		in:   "3\rＰ\x11π`ψ＃Gs\r/.\rξ＞␍＿＃ｋ:␓\x0eＲψ\vα｜␍）",
		out:  "3\rＰ\x11π｀ψ＃Gs\r/.\rξ＞␍＿＃ｋ:␓\x0eＲψ\vα｜␍）",
	}, { // 3405
		mask: EncodeBackQuote | EncodeRightCrLfHtVt,
		in:   "3␍Ｐ\x11π`ψ＃Gs\r/.\rξ＞␍＿＃ｋ:␓\x0eＲψ\vα｜␍）",
		out:  "3␍Ｐ\x11π｀ψ＃Gs\r/.\rξ＞␍＿＃ｋ:␓\x0eＲψ\vα｜␍）",
	}, { // 3406
		mask: EncodeBackQuote | EncodeRightCrLfHtVt,
		in:   "3\rＰ\x11π`ψ＃Gs\r/.\rξ＞␍＿＃ｋ:␓\x0eＲψ\vα｜␕␍",
		out:  "3\rＰ\x11π｀ψ＃Gs\r/.\rξ＞␍＿＃ｋ:␓\x0eＲψ\vα｜␕‛␍",
	}, { // 3407
		mask: EncodeBackQuote | EncodeRightCrLfHtVt,
		in:   "3␍Ｐ\x11π`ψ＃Gs\r/.\rξ＞␍＿＃ｋ:␓\x0eＲψ\vα｜␕␍",
		out:  "3␍Ｐ\x11π｀ψ＃Gs\r/.\rξ＞␍＿＃ｋ:␓\x0eＲψ\vα｜␕‛␍",
	}, { // 3408
		mask: EncodeBackQuote | EncodeRightCrLfHtVt,
		in:   "3θＰ\x11π`ψ＃Gs\r/.\rξ＞␍＿＃ｋ:␓\x0eＲψ\vα｜\r）",
		out:  "3θＰ\x11π｀ψ＃Gs\r/.\rξ＞␍＿＃ｋ:␓\x0eＲψ\vα｜\r）",
	}, { // 3409
		mask: EncodeBackQuote | EncodeRightCrLfHtVt,
		in:   "3θＰ\x11π`ψ＃Gs\r/.\rξ＞␍＿＃ｋ:␓\x0eＲψ\vα｜␍）",
		out:  "3θＰ\x11π｀ψ＃Gs\r/.\rξ＞␍＿＃ｋ:␓\x0eＲψ\vα｜␍）",
	}, { // 3410
		mask: EncodeBackQuote | EncodeRightCrLfHtVt,
		in:   "3θＰ\x11π`ψ＃Gs\r/.\rξ＞␍＿＃ｋ:␓\x0eＲψ\vα｜\r␍",
		out:  "3θＰ\x11π｀ψ＃Gs\r/.\rξ＞␍＿＃ｋ:␓\x0eＲψ\vα｜\r‛␍",
	}, { // 3411
		mask: EncodeBackQuote | EncodeRightCrLfHtVt,
		in:   "3θＰ\x11π`ψ＃Gs\r/.\rξ＞␍＿＃ｋ:␓\x0eＲψ\vα｜␍␍",
		out:  "3θＰ\x11π｀ψ＃Gs\r/.\rξ＞␍＿＃ｋ:␓\x0eＲψ\vα｜␍‛␍",
	}, { // 3412
		mask: EncodeBackQuote | EncodeRightCrLfHtVt,
		in:   "3θＰ\x11π`ψ＃Gs\r/.\rξ＞␍＿＃ｋ:␓\x0eＲψ\vα｜␕\r",
		out:  "3θＰ\x11π｀ψ＃Gs\r/.\rξ＞␍＿＃ｋ:␓\x0eＲψ\vα｜␕␍",
	}, { // 3413
		mask: EncodeBackQuote | EncodeRightCrLfHtVt,
		in:   "3θＰ\x11π`ψ＃Gs\r/.\rξ＞␍＿＃ｋ:␓\x0eＲψ\vα｜␕␍",
		out:  "3θＰ\x11π｀ψ＃Gs\r/.\rξ＞␍＿＃ｋ:␓\x0eＲψ\vα｜␕‛␍",
	}, { // 3414
		mask: EncodeLtGt | EncodeRightCrLfHtVt,
		in:   "s␊ｚZ＄９＇φ／}\tq\x1e，βμ\u007f％;５c\x05%␒φ␑:φιｍ",
		out:  "s␊ｚZ＄９＇φ／}\tq\x1e，βμ\u007f％;５c\x05%␒φ␑:φιｍ",
	}, { // 3415
		mask: EncodeLtGt | EncodeRightCrLfHtVt,
		in:   "\t␉ｚZ＄９＇φ／}\tq\x1e，βμ\u007f％;５c\x05%␒φ␑:φιｍ",
		out:  "\t␉ｚZ＄９＇φ／}\tq\x1e，βμ\u007f％;５c\x05%␒φ␑:φιｍ",
	}, { // 3416
		mask: EncodeLtGt | EncodeRightCrLfHtVt,
		in:   "␉␉ｚZ＄９＇φ／}\tq\x1e，βμ\u007f％;５c\x05%␒φ␑:φιｍ",
		out:  "␉␉ｚZ＄９＇φ／}\tq\x1e，βμ\u007f％;５c\x05%␒φ␑:φιｍ",
	}, { // 3417
		mask: EncodeLtGt | EncodeRightCrLfHtVt,
		in:   "\t␊ｚZ＄９＇φ／}\tq\x1e，βμ\u007f％;５c\x05%␒φ␑:φ␉ｍ",
		out:  "\t␊ｚZ＄９＇φ／}\tq\x1e，βμ\u007f％;５c\x05%␒φ␑:φ␉ｍ",
	}, { // 3418
		mask: EncodeLtGt | EncodeRightCrLfHtVt,
		in:   "␉␊ｚZ＄９＇φ／}\tq\x1e，βμ\u007f％;５c\x05%␒φ␑:φ␉ｍ",
		out:  "␉␊ｚZ＄９＇φ／}\tq\x1e，βμ\u007f％;５c\x05%␒φ␑:φ␉ｍ",
	}, { // 3419
		mask: EncodeLtGt | EncodeRightCrLfHtVt,
		in:   "\t␊ｚZ＄９＇φ／}\tq\x1e，βμ\u007f％;５c\x05%␒φ␑:φι␉",
		out:  "\t␊ｚZ＄９＇φ／}\tq\x1e，βμ\u007f％;５c\x05%␒φ␑:φι‛␉",
	}, { // 3420
		mask: EncodeLtGt | EncodeRightCrLfHtVt,
		in:   "␉␊ｚZ＄９＇φ／}\tq\x1e，βμ\u007f％;５c\x05%␒φ␑:φι␉",
		out:  "␉␊ｚZ＄９＇φ／}\tq\x1e，βμ\u007f％;５c\x05%␒φ␑:φι‛␉",
	}, { // 3421
		mask: EncodeLtGt | EncodeRightCrLfHtVt,
		in:   "s\tｚZ＄９＇φ／}\tq\x1e，βμ\u007f％;５c\x05%␒φ␑:φιｍ",
		out:  "s\tｚZ＄９＇φ／}\tq\x1e，βμ\u007f％;５c\x05%␒φ␑:φιｍ",
	}, { // 3422
		mask: EncodeLtGt | EncodeRightCrLfHtVt,
		in:   "s␉ｚZ＄９＇φ／}\tq\x1e，βμ\u007f％;５c\x05%␒φ␑:φιｍ",
		out:  "s␉ｚZ＄９＇φ／}\tq\x1e，βμ\u007f％;５c\x05%␒φ␑:φιｍ",
	}, { // 3423
		mask: EncodeLtGt | EncodeRightCrLfHtVt,
		in:   "s\tｚZ＄９＇φ／}\tq\x1e，βμ\u007f％;５c\x05%␒φ␑:φ␉ｍ",
		out:  "s\tｚZ＄９＇φ／}\tq\x1e，βμ\u007f％;５c\x05%␒φ␑:φ␉ｍ",
	}, { // 3424
		mask: EncodeLtGt | EncodeRightCrLfHtVt,
		in:   "s␉ｚZ＄９＇φ／}\tq\x1e，βμ\u007f％;５c\x05%␒φ␑:φ␉ｍ",
		out:  "s␉ｚZ＄９＇φ／}\tq\x1e，βμ\u007f％;５c\x05%␒φ␑:φ␉ｍ",
	}, { // 3425
		mask: EncodeLtGt | EncodeRightCrLfHtVt,
		in:   "s\tｚZ＄９＇φ／}\tq\x1e，βμ\u007f％;５c\x05%␒φ␑:φι␉",
		out:  "s\tｚZ＄９＇φ／}\tq\x1e，βμ\u007f％;５c\x05%␒φ␑:φι‛␉",
	}, { // 3426
		mask: EncodeLtGt | EncodeRightCrLfHtVt,
		in:   "s␉ｚZ＄９＇φ／}\tq\x1e，βμ\u007f％;５c\x05%␒φ␑:φι␉",
		out:  "s␉ｚZ＄９＇φ／}\tq\x1e，βμ\u007f％;５c\x05%␒φ␑:φι‛␉",
	}, { // 3427
		mask: EncodeLtGt | EncodeRightCrLfHtVt,
		in:   "s␊ｚZ＄９＇φ／}\tq\x1e，βμ\u007f％;５c\x05%␒φ␑:φ\tｍ",
		out:  "s␊ｚZ＄９＇φ／}\tq\x1e，βμ\u007f％;５c\x05%␒φ␑:φ\tｍ",
	}, { // 3428
		mask: EncodeLtGt | EncodeRightCrLfHtVt,
		in:   "s␊ｚZ＄９＇φ／}\tq\x1e，βμ\u007f％;５c\x05%␒φ␑:φ␉ｍ",
		out:  "s␊ｚZ＄９＇φ／}\tq\x1e，βμ\u007f％;５c\x05%␒φ␑:φ␉ｍ",
	}, { // 3429
		mask: EncodeLtGt | EncodeRightCrLfHtVt,
		in:   "s␊ｚZ＄９＇φ／}\tq\x1e，βμ\u007f％;５c\x05%␒φ␑:φ\t␉",
		out:  "s␊ｚZ＄９＇φ／}\tq\x1e，βμ\u007f％;５c\x05%␒φ␑:φ\t‛␉",
	}, { // 3430
		mask: EncodeLtGt | EncodeRightCrLfHtVt,
		in:   "s␊ｚZ＄９＇φ／}\tq\x1e，βμ\u007f％;５c\x05%␒φ␑:φ␉␉",
		out:  "s␊ｚZ＄９＇φ／}\tq\x1e，βμ\u007f％;５c\x05%␒φ␑:φ␉‛␉",
	}, { // 3431
		mask: EncodeLtGt | EncodeRightCrLfHtVt,
		in:   "s␊ｚZ＄９＇φ／}\tq\x1e，βμ\u007f％;５c\x05%␒φ␑:φι\t",
		out:  "s␊ｚZ＄９＇φ／}\tq\x1e，βμ\u007f％;５c\x05%␒φ␑:φι␉",
	}, { // 3432
		mask: EncodeLtGt | EncodeRightCrLfHtVt,
		in:   "s␊ｚZ＄９＇φ／}\tq\x1e，βμ\u007f％;５c\x05%␒φ␑:φι␉",
		out:  "s␊ｚZ＄９＇φ／}\tq\x1e，βμ\u007f％;５c\x05%␒φ␑:φι‛␉",
	}, { // 3433
		mask: EncodeLtGt | EncodeRightCrLfHtVt,
		in:   "\x0e␄;'|␒ψαβ\a\nＪ␓Ｑ␙［\n\x13␜＊τ６?~U␊jντ%",
		out:  "\x0e␄;'|␒ψαβ\a\nＪ␓Ｑ␙［\n\x13␜＊τ６?~U␊jντ%",
	}, { // 3434
		mask: EncodeLtGt | EncodeRightCrLfHtVt,
		in:   "\n␊;'|␒ψαβ\a\nＪ␓Ｑ␙［\n\x13␜＊τ６?~U␊jντ%",
		out:  "\n␊;'|␒ψαβ\a\nＪ␓Ｑ␙［\n\x13␜＊τ６?~U␊jντ%",
	}, { // 3435
		mask: EncodeLtGt | EncodeRightCrLfHtVt,
		in:   "␊␊;'|␒ψαβ\a\nＪ␓Ｑ␙［\n\x13␜＊τ６?~U␊jντ%",
		out:  "␊␊;'|␒ψαβ\a\nＪ␓Ｑ␙［\n\x13␜＊τ６?~U␊jντ%",
	}, { // 3436
		mask: EncodeLtGt | EncodeRightCrLfHtVt,
		in:   "\n␄;'|␒ψαβ\a\nＪ␓Ｑ␙［\n\x13␜＊τ６?~U␊jν␊%",
		out:  "\n␄;'|␒ψαβ\a\nＪ␓Ｑ␙［\n\x13␜＊τ６?~U␊jν␊%",
	}, { // 3437
		mask: EncodeLtGt | EncodeRightCrLfHtVt,
		in:   "␊␄;'|␒ψαβ\a\nＪ␓Ｑ␙［\n\x13␜＊τ６?~U␊jν␊%",
		out:  "␊␄;'|␒ψαβ\a\nＪ␓Ｑ␙［\n\x13␜＊τ６?~U␊jν␊%",
	}, { // 3438
		mask: EncodeLtGt | EncodeRightCrLfHtVt,
		in:   "\n␄;'|␒ψαβ\a\nＪ␓Ｑ␙［\n\x13␜＊τ６?~U␊jντ␊",
		out:  "\n␄;'|␒ψαβ\a\nＪ␓Ｑ␙［\n\x13␜＊τ６?~U␊jντ‛␊",
	}, { // 3439
		mask: EncodeLtGt | EncodeRightCrLfHtVt,
		in:   "␊␄;'|␒ψαβ\a\nＪ␓Ｑ␙［\n\x13␜＊τ６?~U␊jντ␊",
		out:  "␊␄;'|␒ψαβ\a\nＪ␓Ｑ␙［\n\x13␜＊τ６?~U␊jντ‛␊",
	}, { // 3440
		mask: EncodeLtGt | EncodeRightCrLfHtVt,
		in:   "\x0e\n;'|␒ψαβ\a\nＪ␓Ｑ␙［\n\x13␜＊τ６?~U␊jντ%",
		out:  "\x0e\n;'|␒ψαβ\a\nＪ␓Ｑ␙［\n\x13␜＊τ６?~U␊jντ%",
	}, { // 3441
		mask: EncodeLtGt | EncodeRightCrLfHtVt,
		in:   "\x0e␊;'|␒ψαβ\a\nＪ␓Ｑ␙［\n\x13␜＊τ６?~U␊jντ%",
		out:  "\x0e␊;'|␒ψαβ\a\nＪ␓Ｑ␙［\n\x13␜＊τ６?~U␊jντ%",
	}, { // 3442
		mask: EncodeLtGt | EncodeRightCrLfHtVt,
		in:   "\x0e\n;'|␒ψαβ\a\nＪ␓Ｑ␙［\n\x13␜＊τ６?~U␊jν␊%",
		out:  "\x0e\n;'|␒ψαβ\a\nＪ␓Ｑ␙［\n\x13␜＊τ６?~U␊jν␊%",
	}, { // 3443
		mask: EncodeLtGt | EncodeRightCrLfHtVt,
		in:   "\x0e␊;'|␒ψαβ\a\nＪ␓Ｑ␙［\n\x13␜＊τ６?~U␊jν␊%",
		out:  "\x0e␊;'|␒ψαβ\a\nＪ␓Ｑ␙［\n\x13␜＊τ６?~U␊jν␊%",
	}, { // 3444
		mask: EncodeLtGt | EncodeRightCrLfHtVt,
		in:   "\x0e\n;'|␒ψαβ\a\nＪ␓Ｑ␙［\n\x13␜＊τ６?~U␊jντ␊",
		out:  "\x0e\n;'|␒ψαβ\a\nＪ␓Ｑ␙［\n\x13␜＊τ６?~U␊jντ‛␊",
	}, { // 3445
		mask: EncodeLtGt | EncodeRightCrLfHtVt,
		in:   "\x0e␊;'|␒ψαβ\a\nＪ␓Ｑ␙［\n\x13␜＊τ６?~U␊jντ␊",
		out:  "\x0e␊;'|␒ψαβ\a\nＪ␓Ｑ␙［\n\x13␜＊τ６?~U␊jντ‛␊",
	}, { // 3446
		mask: EncodeLtGt | EncodeRightCrLfHtVt,
		in:   "\x0e␄;'|␒ψαβ\a\nＪ␓Ｑ␙［\n\x13␜＊τ６?~U␊jν\n%",
		out:  "\x0e␄;'|␒ψαβ\a\nＪ␓Ｑ␙［\n\x13␜＊τ６?~U␊jν\n%",
	}, { // 3447
		mask: EncodeLtGt | EncodeRightCrLfHtVt,
		in:   "\x0e␄;'|␒ψαβ\a\nＪ␓Ｑ␙［\n\x13␜＊τ６?~U␊jν␊%",
		out:  "\x0e␄;'|␒ψαβ\a\nＪ␓Ｑ␙［\n\x13␜＊τ６?~U␊jν␊%",
	}, { // 3448
		mask: EncodeLtGt | EncodeRightCrLfHtVt,
		in:   "\x0e␄;'|␒ψαβ\a\nＪ␓Ｑ␙［\n\x13␜＊τ６?~U␊jν\n␊",
		out:  "\x0e␄;'|␒ψαβ\a\nＪ␓Ｑ␙［\n\x13␜＊τ６?~U␊jν\n‛␊",
	}, { // 3449
		mask: EncodeLtGt | EncodeRightCrLfHtVt,
		in:   "\x0e␄;'|␒ψαβ\a\nＪ␓Ｑ␙［\n\x13␜＊τ６?~U␊jν␊␊",
		out:  "\x0e␄;'|␒ψαβ\a\nＪ␓Ｑ␙［\n\x13␜＊τ６?~U␊jν␊‛␊",
	}, { // 3450
		mask: EncodeLtGt | EncodeRightCrLfHtVt,
		in:   "\x0e␄;'|␒ψαβ\a\nＪ␓Ｑ␙［\n\x13␜＊τ６?~U␊jντ\n",
		out:  "\x0e␄;'|␒ψαβ\a\nＪ␓Ｑ␙［\n\x13␜＊τ６?~U␊jντ␊",
	}, { // 3451
		mask: EncodeLtGt | EncodeRightCrLfHtVt,
		in:   "\x0e␄;'|␒ψαβ\a\nＪ␓Ｑ␙［\n\x13␜＊τ６?~U␊jντ␊",
		out:  "\x0e␄;'|␒ψαβ\a\nＪ␓Ｑ␙［\n\x13␜＊τ６?~U␊jντ‛␊",
	}, { // 3452
		mask: EncodeLtGt | EncodeRightCrLfHtVt,
		in:   "＂\\␒％γξν／［\x01\vＮπ＊\x16|n/\x00ＧβO␡\x1eiXＪαＫ␏",
		out:  "＂\\␒％γξν／［\x01\vＮπ＊\x16|n/␀ＧβO␡\x1eiXＪαＫ␏",
	}, { // 3453
		mask: EncodeLtGt | EncodeRightCrLfHtVt,
		in:   "\v␋␒％γξν／［\x01\vＮπ＊\x16|n/\x00ＧβO␡\x1eiXＪαＫ␏",
		out:  "\v␋␒％γξν／［\x01\vＮπ＊\x16|n/␀ＧβO␡\x1eiXＪαＫ␏",
	}, { // 3454
		mask: EncodeLtGt | EncodeRightCrLfHtVt,
		in:   "␋␋␒％γξν／［\x01\vＮπ＊\x16|n/\x00ＧβO␡\x1eiXＪαＫ␏",
		out:  "␋␋␒％γξν／［\x01\vＮπ＊\x16|n/␀ＧβO␡\x1eiXＪαＫ␏",
	}, { // 3455
		mask: EncodeLtGt | EncodeRightCrLfHtVt,
		in:   "\v\\␒％γξν／［\x01\vＮπ＊\x16|n/\x00ＧβO␡\x1eiXＪα␋␏",
		out:  "\v\\␒％γξν／［\x01\vＮπ＊\x16|n/␀ＧβO␡\x1eiXＪα␋␏",
	}, { // 3456
		mask: EncodeLtGt | EncodeRightCrLfHtVt,
		in:   "␋\\␒％γξν／［\x01\vＮπ＊\x16|n/\x00ＧβO␡\x1eiXＪα␋␏",
		out:  "␋\\␒％γξν／［\x01\vＮπ＊\x16|n/␀ＧβO␡\x1eiXＪα␋␏",
	}, { // 3457
		mask: EncodeLtGt | EncodeRightCrLfHtVt,
		in:   "\v\\␒％γξν／［\x01\vＮπ＊\x16|n/\x00ＧβO␡\x1eiXＪαＫ␋",
		out:  "\v\\␒％γξν／［\x01\vＮπ＊\x16|n/␀ＧβO␡\x1eiXＪαＫ‛␋",
	}, { // 3458
		mask: EncodeLtGt | EncodeRightCrLfHtVt,
		in:   "␋\\␒％γξν／［\x01\vＮπ＊\x16|n/\x00ＧβO␡\x1eiXＪαＫ␋",
		out:  "␋\\␒％γξν／［\x01\vＮπ＊\x16|n/␀ＧβO␡\x1eiXＪαＫ‛␋",
	}, { // 3459
		mask: EncodeLtGt | EncodeRightCrLfHtVt,
		in:   "＂\v␒％γξν／［\x01\vＮπ＊\x16|n/\x00ＧβO␡\x1eiXＪαＫ␏",
		out:  "＂\v␒％γξν／［\x01\vＮπ＊\x16|n/␀ＧβO␡\x1eiXＪαＫ␏",
	}, { // 3460
		mask: EncodeLtGt | EncodeRightCrLfHtVt,
		in:   "＂␋␒％γξν／［\x01\vＮπ＊\x16|n/\x00ＧβO␡\x1eiXＪαＫ␏",
		out:  "＂␋␒％γξν／［\x01\vＮπ＊\x16|n/␀ＧβO␡\x1eiXＪαＫ␏",
	}, { // 3461
		mask: EncodeLtGt | EncodeRightCrLfHtVt,
		in:   "＂\v␒％γξν／［\x01\vＮπ＊\x16|n/\x00ＧβO␡\x1eiXＪα␋␏",
		out:  "＂\v␒％γξν／［\x01\vＮπ＊\x16|n/␀ＧβO␡\x1eiXＪα␋␏",
	}, { // 3462
		mask: EncodeLtGt | EncodeRightCrLfHtVt,
		in:   "＂␋␒％γξν／［\x01\vＮπ＊\x16|n/\x00ＧβO␡\x1eiXＪα␋␏",
		out:  "＂␋␒％γξν／［\x01\vＮπ＊\x16|n/␀ＧβO␡\x1eiXＪα␋␏",
	}, { // 3463
		mask: EncodeLtGt | EncodeRightCrLfHtVt,
		in:   "＂\v␒％γξν／［\x01\vＮπ＊\x16|n/\x00ＧβO␡\x1eiXＪαＫ␋",
		out:  "＂\v␒％γξν／［\x01\vＮπ＊\x16|n/␀ＧβO␡\x1eiXＪαＫ‛␋",
	}, { // 3464
		mask: EncodeLtGt | EncodeRightCrLfHtVt,
		in:   "＂␋␒％γξν／［\x01\vＮπ＊\x16|n/\x00ＧβO␡\x1eiXＪαＫ␋",
		out:  "＂␋␒％γξν／［\x01\vＮπ＊\x16|n/␀ＧβO␡\x1eiXＪαＫ‛␋",
	}, { // 3465
		mask: EncodeLtGt | EncodeRightCrLfHtVt,
		in:   "＂\\␒％γξν／［\x01\vＮπ＊\x16|n/\x00ＧβO␡\x1eiXＪα\v␏",
		out:  "＂\\␒％γξν／［\x01\vＮπ＊\x16|n/␀ＧβO␡\x1eiXＪα\v␏",
	}, { // 3466
		mask: EncodeLtGt | EncodeRightCrLfHtVt,
		in:   "＂\\␒％γξν／［\x01\vＮπ＊\x16|n/\x00ＧβO␡\x1eiXＪα␋␏",
		out:  "＂\\␒％γξν／［\x01\vＮπ＊\x16|n/␀ＧβO␡\x1eiXＪα␋␏",
	}, { // 3467
		mask: EncodeLtGt | EncodeRightCrLfHtVt,
		in:   "＂\\␒％γξν／［\x01\vＮπ＊\x16|n/\x00ＧβO␡\x1eiXＪα\v␋",
		out:  "＂\\␒％γξν／［\x01\vＮπ＊\x16|n/␀ＧβO␡\x1eiXＪα\v‛␋",
	}, { // 3468
		mask: EncodeLtGt | EncodeRightCrLfHtVt,
		in:   "＂\\␒％γξν／［\x01\vＮπ＊\x16|n/\x00ＧβO␡\x1eiXＪα␋␋",
		out:  "＂\\␒％γξν／［\x01\vＮπ＊\x16|n/␀ＧβO␡\x1eiXＪα␋‛␋",
	}, { // 3469
		mask: EncodeLtGt | EncodeRightCrLfHtVt,
		in:   "＂\\␒％γξν／［\x01\vＮπ＊\x16|n/\x00ＧβO␡\x1eiXＪαＫ\v",
		out:  "＂\\␒％γξν／［\x01\vＮπ＊\x16|n/␀ＧβO␡\x1eiXＪαＫ␋",
	}, { // 3470
		mask: EncodeLtGt | EncodeRightCrLfHtVt,
		in:   "＂\\␒％γξν／［\x01\vＮπ＊\x16|n/\x00ＧβO␡\x1eiXＪαＫ␋",
		out:  "＂\\␒％γξν／［\x01\vＮπ＊\x16|n/␀ＧβO␡\x1eiXＪαＫ‛␋",
	}, { // 3471
		mask: EncodeLtGt | EncodeRightCrLfHtVt,
		in:   "[dψ␗η\x0f\x0f\x18>␘\r\v\nκｃ\"＾␎␓␗η3Ｊ６ｒ［G<α（",
		out:  "[dψ␗η\x0f\x0f\x18＞␘\r\v\nκｃ\"＾␎␓␗η3Ｊ６ｒ［G＜α（",
	}, { // 3472
		mask: EncodeLtGt | EncodeRightCrLfHtVt,
		in:   "\r␍ψ␗η\x0f\x0f\x18>␘\r\v\nκｃ\"＾␎␓␗η3Ｊ６ｒ［G<α（",
		out:  "\r␍ψ␗η\x0f\x0f\x18＞␘\r\v\nκｃ\"＾␎␓␗η3Ｊ６ｒ［G＜α（",
	}, { // 3473
		mask: EncodeLtGt | EncodeRightCrLfHtVt,
		in:   "␍␍ψ␗η\x0f\x0f\x18>␘\r\v\nκｃ\"＾␎␓␗η3Ｊ６ｒ［G<α（",
		out:  "␍␍ψ␗η\x0f\x0f\x18＞␘\r\v\nκｃ\"＾␎␓␗η3Ｊ６ｒ［G＜α（",
	}, { // 3474
		mask: EncodeLtGt | EncodeRightCrLfHtVt,
		in:   "\rdψ␗η\x0f\x0f\x18>␘\r\v\nκｃ\"＾␎␓␗η3Ｊ６ｒ［G<␍（",
		out:  "\rdψ␗η\x0f\x0f\x18＞␘\r\v\nκｃ\"＾␎␓␗η3Ｊ６ｒ［G＜␍（",
	}, { // 3475
		mask: EncodeLtGt | EncodeRightCrLfHtVt,
		in:   "␍dψ␗η\x0f\x0f\x18>␘\r\v\nκｃ\"＾␎␓␗η3Ｊ６ｒ［G<␍（",
		out:  "␍dψ␗η\x0f\x0f\x18＞␘\r\v\nκｃ\"＾␎␓␗η3Ｊ６ｒ［G＜␍（",
	}, { // 3476
		mask: EncodeLtGt | EncodeRightCrLfHtVt,
		in:   "\rdψ␗η\x0f\x0f\x18>␘\r\v\nκｃ\"＾␎␓␗η3Ｊ６ｒ［G<α␍",
		out:  "\rdψ␗η\x0f\x0f\x18＞␘\r\v\nκｃ\"＾␎␓␗η3Ｊ６ｒ［G＜α‛␍",
	}, { // 3477
		mask: EncodeLtGt | EncodeRightCrLfHtVt,
		in:   "␍dψ␗η\x0f\x0f\x18>␘\r\v\nκｃ\"＾␎␓␗η3Ｊ６ｒ［G<α␍",
		out:  "␍dψ␗η\x0f\x0f\x18＞␘\r\v\nκｃ\"＾␎␓␗η3Ｊ６ｒ［G＜α‛␍",
	}, { // 3478
		mask: EncodeLtGt | EncodeRightCrLfHtVt,
		in:   "[\rψ␗η\x0f\x0f\x18>␘\r\v\nκｃ\"＾␎␓␗η3Ｊ６ｒ［G<α（",
		out:  "[\rψ␗η\x0f\x0f\x18＞␘\r\v\nκｃ\"＾␎␓␗η3Ｊ６ｒ［G＜α（",
	}, { // 3479
		mask: EncodeLtGt | EncodeRightCrLfHtVt,
		in:   "[␍ψ␗η\x0f\x0f\x18>␘\r\v\nκｃ\"＾␎␓␗η3Ｊ６ｒ［G<α（",
		out:  "[␍ψ␗η\x0f\x0f\x18＞␘\r\v\nκｃ\"＾␎␓␗η3Ｊ６ｒ［G＜α（",
	}, { // 3480
		mask: EncodeLtGt | EncodeRightCrLfHtVt,
		in:   "[\rψ␗η\x0f\x0f\x18>␘\r\v\nκｃ\"＾␎␓␗η3Ｊ６ｒ［G<␍（",
		out:  "[\rψ␗η\x0f\x0f\x18＞␘\r\v\nκｃ\"＾␎␓␗η3Ｊ６ｒ［G＜␍（",
	}, { // 3481
		mask: EncodeLtGt | EncodeRightCrLfHtVt,
		in:   "[␍ψ␗η\x0f\x0f\x18>␘\r\v\nκｃ\"＾␎␓␗η3Ｊ６ｒ［G<␍（",
		out:  "[␍ψ␗η\x0f\x0f\x18＞␘\r\v\nκｃ\"＾␎␓␗η3Ｊ６ｒ［G＜␍（",
	}, { // 3482
		mask: EncodeLtGt | EncodeRightCrLfHtVt,
		in:   "[\rψ␗η\x0f\x0f\x18>␘\r\v\nκｃ\"＾␎␓␗η3Ｊ６ｒ［G<α␍",
		out:  "[\rψ␗η\x0f\x0f\x18＞␘\r\v\nκｃ\"＾␎␓␗η3Ｊ６ｒ［G＜α‛␍",
	}, { // 3483
		mask: EncodeLtGt | EncodeRightCrLfHtVt,
		in:   "[␍ψ␗η\x0f\x0f\x18>␘\r\v\nκｃ\"＾␎␓␗η3Ｊ６ｒ［G<α␍",
		out:  "[␍ψ␗η\x0f\x0f\x18＞␘\r\v\nκｃ\"＾␎␓␗η3Ｊ６ｒ［G＜α‛␍",
	}, { // 3484
		mask: EncodeLtGt | EncodeRightCrLfHtVt,
		in:   "[dψ␗η\x0f\x0f\x18>␘\r\v\nκｃ\"＾␎␓␗η3Ｊ６ｒ［G<\r（",
		out:  "[dψ␗η\x0f\x0f\x18＞␘\r\v\nκｃ\"＾␎␓␗η3Ｊ６ｒ［G＜\r（",
	}, { // 3485
		mask: EncodeLtGt | EncodeRightCrLfHtVt,
		in:   "[dψ␗η\x0f\x0f\x18>␘\r\v\nκｃ\"＾␎␓␗η3Ｊ６ｒ［G<␍（",
		out:  "[dψ␗η\x0f\x0f\x18＞␘\r\v\nκｃ\"＾␎␓␗η3Ｊ６ｒ［G＜␍（",
	}, { // 3486
		mask: EncodeLtGt | EncodeRightCrLfHtVt,
		in:   "[dψ␗η\x0f\x0f\x18>␘\r\v\nκｃ\"＾␎␓␗η3Ｊ６ｒ［G<\r␍",
		out:  "[dψ␗η\x0f\x0f\x18＞␘\r\v\nκｃ\"＾␎␓␗η3Ｊ６ｒ［G＜\r‛␍",
	}, { // 3487
		mask: EncodeLtGt | EncodeRightCrLfHtVt,
		in:   "[dψ␗η\x0f\x0f\x18>␘\r\v\nκｃ\"＾␎␓␗η3Ｊ６ｒ［G<␍␍",
		out:  "[dψ␗η\x0f\x0f\x18＞␘\r\v\nκｃ\"＾␎␓␗η3Ｊ６ｒ［G＜␍‛␍",
	}, { // 3488
		mask: EncodeLtGt | EncodeRightCrLfHtVt,
		in:   "[dψ␗η\x0f\x0f\x18>␘\r\v\nκｃ\"＾␎␓␗η3Ｊ６ｒ［G<α\r",
		out:  "[dψ␗η\x0f\x0f\x18＞␘\r\v\nκｃ\"＾␎␓␗η3Ｊ６ｒ［G＜α␍",
	}, { // 3489
		mask: EncodeLtGt | EncodeRightCrLfHtVt,
		in:   "[dψ␗η\x0f\x0f\x18>␘\r\v\nκｃ\"＾␎␓␗η3Ｊ６ｒ［G<α␍",
		out:  "[dψ␗η\x0f\x0f\x18＞␘\r\v\nκｃ\"＾␎␓␗η3Ｊ６ｒ［G＜α‛␍",
	}, { // 3490
		mask: EncodeSquareBracket | EncodeRightCrLfHtVt,
		in:   "＄％*\x02␗\u007fｍ>χρ\txνqＡ␒\x00␍ｒμ｜\a\x16γm␆>wχ␐",
		out:  "＄％*\x02␗\u007fｍ>χρ\txνqＡ␒␀␍ｒμ｜\a\x16γm␆>wχ␐",
	}, { // 3491
		mask: EncodeSquareBracket | EncodeRightCrLfHtVt,
		in:   "\t␉*\x02␗\u007fｍ>χρ\txνqＡ␒\x00␍ｒμ｜\a\x16γm␆>wχ␐",
		out:  "\t␉*\x02␗\u007fｍ>χρ\txνqＡ␒␀␍ｒμ｜\a\x16γm␆>wχ␐",
	}, { // 3492
		mask: EncodeSquareBracket | EncodeRightCrLfHtVt,
		in:   "␉␉*\x02␗\u007fｍ>χρ\txνqＡ␒\x00␍ｒμ｜\a\x16γm␆>wχ␐",
		out:  "␉␉*\x02␗\u007fｍ>χρ\txνqＡ␒␀␍ｒμ｜\a\x16γm␆>wχ␐",
	}, { // 3493
		mask: EncodeSquareBracket | EncodeRightCrLfHtVt,
		in:   "\t％*\x02␗\u007fｍ>χρ\txνqＡ␒\x00␍ｒμ｜\a\x16γm␆>w␉␐",
		out:  "\t％*\x02␗\u007fｍ>χρ\txνqＡ␒␀␍ｒμ｜\a\x16γm␆>w␉␐",
	}, { // 3494
		mask: EncodeSquareBracket | EncodeRightCrLfHtVt,
		in:   "␉％*\x02␗\u007fｍ>χρ\txνqＡ␒\x00␍ｒμ｜\a\x16γm␆>w␉␐",
		out:  "␉％*\x02␗\u007fｍ>χρ\txνqＡ␒␀␍ｒμ｜\a\x16γm␆>w␉␐",
	}, { // 3495
		mask: EncodeSquareBracket | EncodeRightCrLfHtVt,
		in:   "\t％*\x02␗\u007fｍ>χρ\txνqＡ␒\x00␍ｒμ｜\a\x16γm␆>wχ␉",
		out:  "\t％*\x02␗\u007fｍ>χρ\txνqＡ␒␀␍ｒμ｜\a\x16γm␆>wχ‛␉",
	}, { // 3496
		mask: EncodeSquareBracket | EncodeRightCrLfHtVt,
		in:   "␉％*\x02␗\u007fｍ>χρ\txνqＡ␒\x00␍ｒμ｜\a\x16γm␆>wχ␉",
		out:  "␉％*\x02␗\u007fｍ>χρ\txνqＡ␒␀␍ｒμ｜\a\x16γm␆>wχ‛␉",
	}, { // 3497
		mask: EncodeSquareBracket | EncodeRightCrLfHtVt,
		in:   "＄\t*\x02␗\u007fｍ>χρ\txνqＡ␒\x00␍ｒμ｜\a\x16γm␆>wχ␐",
		out:  "＄\t*\x02␗\u007fｍ>χρ\txνqＡ␒␀␍ｒμ｜\a\x16γm␆>wχ␐",
	}, { // 3498
		mask: EncodeSquareBracket | EncodeRightCrLfHtVt,
		in:   "＄␉*\x02␗\u007fｍ>χρ\txνqＡ␒\x00␍ｒμ｜\a\x16γm␆>wχ␐",
		out:  "＄␉*\x02␗\u007fｍ>χρ\txνqＡ␒␀␍ｒμ｜\a\x16γm␆>wχ␐",
	}, { // 3499
		mask: EncodeSquareBracket | EncodeRightCrLfHtVt,
		in:   "＄\t*\x02␗\u007fｍ>χρ\txνqＡ␒\x00␍ｒμ｜\a\x16γm␆>w␉␐",
		out:  "＄\t*\x02␗\u007fｍ>χρ\txνqＡ␒␀␍ｒμ｜\a\x16γm␆>w␉␐",
	}, { // 3500
		mask: EncodeSquareBracket | EncodeRightCrLfHtVt,
		in:   "＄␉*\x02␗\u007fｍ>χρ\txνqＡ␒\x00␍ｒμ｜\a\x16γm␆>w␉␐",
		out:  "＄␉*\x02␗\u007fｍ>χρ\txνqＡ␒␀␍ｒμ｜\a\x16γm␆>w␉␐",
	}, { // 3501
		mask: EncodeSquareBracket | EncodeRightCrLfHtVt,
		in:   "＄\t*\x02␗\u007fｍ>χρ\txνqＡ␒\x00␍ｒμ｜\a\x16γm␆>wχ␉",
		out:  "＄\t*\x02␗\u007fｍ>χρ\txνqＡ␒␀␍ｒμ｜\a\x16γm␆>wχ‛␉",
	}, { // 3502
		mask: EncodeSquareBracket | EncodeRightCrLfHtVt,
		in:   "＄␉*\x02␗\u007fｍ>χρ\txνqＡ␒\x00␍ｒμ｜\a\x16γm␆>wχ␉",
		out:  "＄␉*\x02␗\u007fｍ>χρ\txνqＡ␒␀␍ｒμ｜\a\x16γm␆>wχ‛␉",
	}, { // 3503
		mask: EncodeSquareBracket | EncodeRightCrLfHtVt,
		in:   "＄％*\x02␗\u007fｍ>χρ\txνqＡ␒\x00␍ｒμ｜\a\x16γm␆>w\t␐",
		out:  "＄％*\x02␗\u007fｍ>χρ\txνqＡ␒␀␍ｒμ｜\a\x16γm␆>w\t␐",
	}, { // 3504
		mask: EncodeSquareBracket | EncodeRightCrLfHtVt,
		in:   "＄％*\x02␗\u007fｍ>χρ\txνqＡ␒\x00␍ｒμ｜\a\x16γm␆>w␉␐",
		out:  "＄％*\x02␗\u007fｍ>χρ\txνqＡ␒␀␍ｒμ｜\a\x16γm␆>w␉␐",
	}, { // 3505
		mask: EncodeSquareBracket | EncodeRightCrLfHtVt,
		in:   "＄％*\x02␗\u007fｍ>χρ\txνqＡ␒\x00␍ｒμ｜\a\x16γm␆>w\t␉",
		out:  "＄％*\x02␗\u007fｍ>χρ\txνqＡ␒␀␍ｒμ｜\a\x16γm␆>w\t‛␉",
	}, { // 3506
		mask: EncodeSquareBracket | EncodeRightCrLfHtVt,
		in:   "＄％*\x02␗\u007fｍ>χρ\txνqＡ␒\x00␍ｒμ｜\a\x16γm␆>w␉␉",
		out:  "＄％*\x02␗\u007fｍ>χρ\txνqＡ␒␀␍ｒμ｜\a\x16γm␆>w␉‛␉",
	}, { // 3507
		mask: EncodeSquareBracket | EncodeRightCrLfHtVt,
		in:   "＄％*\x02␗\u007fｍ>χρ\txνqＡ␒\x00␍ｒμ｜\a\x16γm␆>wχ\t",
		out:  "＄％*\x02␗\u007fｍ>χρ\txνqＡ␒␀␍ｒμ｜\a\x16γm␆>wχ␉",
	}, { // 3508
		mask: EncodeSquareBracket | EncodeRightCrLfHtVt,
		in:   "＄％*\x02␗\u007fｍ>χρ\txνqＡ␒\x00␍ｒμ｜\a\x16γm␆>wχ␉",
		out:  "＄％*\x02␗\u007fｍ>χρ\txνqＡ␒␀␍ｒμ｜\a\x16γm␆>wχ‛␉",
	}, { // 3509
		mask: EncodeSquareBracket | EncodeRightCrLfHtVt,
		in:   "χＧ_␝\bFＤ\x0fτε\n␁βｉ␑fｔ␈θKσ\nl\x0e＃'\x00Ｇ␉M",
		out:  "χＧ_␝\bFＤ\x0fτε\n␁βｉ␑fｔ␈θKσ\nl\x0e＃'␀Ｇ␉M",
	}, { // 3510
		mask: EncodeSquareBracket | EncodeRightCrLfHtVt,
		in:   "\n␊_␝\bFＤ\x0fτε\n␁βｉ␑fｔ␈θKσ\nl\x0e＃'\x00Ｇ␉M",
		out:  "\n␊_␝\bFＤ\x0fτε\n␁βｉ␑fｔ␈θKσ\nl\x0e＃'␀Ｇ␉M",
	}, { // 3511
		mask: EncodeSquareBracket | EncodeRightCrLfHtVt,
		in:   "␊␊_␝\bFＤ\x0fτε\n␁βｉ␑fｔ␈θKσ\nl\x0e＃'\x00Ｇ␉M",
		out:  "␊␊_␝\bFＤ\x0fτε\n␁βｉ␑fｔ␈θKσ\nl\x0e＃'␀Ｇ␉M",
	}, { // 3512
		mask: EncodeSquareBracket | EncodeRightCrLfHtVt,
		in:   "\nＧ_␝\bFＤ\x0fτε\n␁βｉ␑fｔ␈θKσ\nl\x0e＃'\x00Ｇ␊M",
		out:  "\nＧ_␝\bFＤ\x0fτε\n␁βｉ␑fｔ␈θKσ\nl\x0e＃'␀Ｇ␊M",
	}, { // 3513
		mask: EncodeSquareBracket | EncodeRightCrLfHtVt,
		in:   "␊Ｇ_␝\bFＤ\x0fτε\n␁βｉ␑fｔ␈θKσ\nl\x0e＃'\x00Ｇ␊M",
		out:  "␊Ｇ_␝\bFＤ\x0fτε\n␁βｉ␑fｔ␈θKσ\nl\x0e＃'␀Ｇ␊M",
	}, { // 3514
		mask: EncodeSquareBracket | EncodeRightCrLfHtVt,
		in:   "\nＧ_␝\bFＤ\x0fτε\n␁βｉ␑fｔ␈θKσ\nl\x0e＃'\x00Ｇ␉␊",
		out:  "\nＧ_␝\bFＤ\x0fτε\n␁βｉ␑fｔ␈θKσ\nl\x0e＃'␀Ｇ␉‛␊",
	}, { // 3515
		mask: EncodeSquareBracket | EncodeRightCrLfHtVt,
		in:   "␊Ｇ_␝\bFＤ\x0fτε\n␁βｉ␑fｔ␈θKσ\nl\x0e＃'\x00Ｇ␉␊",
		out:  "␊Ｇ_␝\bFＤ\x0fτε\n␁βｉ␑fｔ␈θKσ\nl\x0e＃'␀Ｇ␉‛␊",
	}, { // 3516
		mask: EncodeSquareBracket | EncodeRightCrLfHtVt,
		in:   "χ\n_␝\bFＤ\x0fτε\n␁βｉ␑fｔ␈θKσ\nl\x0e＃'\x00Ｇ␉M",
		out:  "χ\n_␝\bFＤ\x0fτε\n␁βｉ␑fｔ␈θKσ\nl\x0e＃'␀Ｇ␉M",
	}, { // 3517
		mask: EncodeSquareBracket | EncodeRightCrLfHtVt,
		in:   "χ␊_␝\bFＤ\x0fτε\n␁βｉ␑fｔ␈θKσ\nl\x0e＃'\x00Ｇ␉M",
		out:  "χ␊_␝\bFＤ\x0fτε\n␁βｉ␑fｔ␈θKσ\nl\x0e＃'␀Ｇ␉M",
	}, { // 3518
		mask: EncodeSquareBracket | EncodeRightCrLfHtVt,
		in:   "χ\n_␝\bFＤ\x0fτε\n␁βｉ␑fｔ␈θKσ\nl\x0e＃'\x00Ｇ␊M",
		out:  "χ\n_␝\bFＤ\x0fτε\n␁βｉ␑fｔ␈θKσ\nl\x0e＃'␀Ｇ␊M",
	}, { // 3519
		mask: EncodeSquareBracket | EncodeRightCrLfHtVt,
		in:   "χ␊_␝\bFＤ\x0fτε\n␁βｉ␑fｔ␈θKσ\nl\x0e＃'\x00Ｇ␊M",
		out:  "χ␊_␝\bFＤ\x0fτε\n␁βｉ␑fｔ␈θKσ\nl\x0e＃'␀Ｇ␊M",
	}, { // 3520
		mask: EncodeSquareBracket | EncodeRightCrLfHtVt,
		in:   "χ\n_␝\bFＤ\x0fτε\n␁βｉ␑fｔ␈θKσ\nl\x0e＃'\x00Ｇ␉␊",
		out:  "χ\n_␝\bFＤ\x0fτε\n␁βｉ␑fｔ␈θKσ\nl\x0e＃'␀Ｇ␉‛␊",
	}, { // 3521
		mask: EncodeSquareBracket | EncodeRightCrLfHtVt,
		in:   "χ␊_␝\bFＤ\x0fτε\n␁βｉ␑fｔ␈θKσ\nl\x0e＃'\x00Ｇ␉␊",
		out:  "χ␊_␝\bFＤ\x0fτε\n␁βｉ␑fｔ␈θKσ\nl\x0e＃'␀Ｇ␉‛␊",
	}, { // 3522
		mask: EncodeSquareBracket | EncodeRightCrLfHtVt,
		in:   "χＧ_␝\bFＤ\x0fτε\n␁βｉ␑fｔ␈θKσ\nl\x0e＃'\x00Ｇ\nM",
		out:  "χＧ_␝\bFＤ\x0fτε\n␁βｉ␑fｔ␈θKσ\nl\x0e＃'␀Ｇ\nM",
	}, { // 3523
		mask: EncodeSquareBracket | EncodeRightCrLfHtVt,
		in:   "χＧ_␝\bFＤ\x0fτε\n␁βｉ␑fｔ␈θKσ\nl\x0e＃'\x00Ｇ␊M",
		out:  "χＧ_␝\bFＤ\x0fτε\n␁βｉ␑fｔ␈θKσ\nl\x0e＃'␀Ｇ␊M",
	}, { // 3524
		mask: EncodeSquareBracket | EncodeRightCrLfHtVt,
		in:   "χＧ_␝\bFＤ\x0fτε\n␁βｉ␑fｔ␈θKσ\nl\x0e＃'\x00Ｇ\n␊",
		out:  "χＧ_␝\bFＤ\x0fτε\n␁βｉ␑fｔ␈θKσ\nl\x0e＃'␀Ｇ\n‛␊",
	}, { // 3525
		mask: EncodeSquareBracket | EncodeRightCrLfHtVt,
		in:   "χＧ_␝\bFＤ\x0fτε\n␁βｉ␑fｔ␈θKσ\nl\x0e＃'\x00Ｇ␊␊",
		out:  "χＧ_␝\bFＤ\x0fτε\n␁βｉ␑fｔ␈θKσ\nl\x0e＃'␀Ｇ␊‛␊",
	}, { // 3526
		mask: EncodeSquareBracket | EncodeRightCrLfHtVt,
		in:   "χＧ_␝\bFＤ\x0fτε\n␁βｉ␑fｔ␈θKσ\nl\x0e＃'\x00Ｇ␉\n",
		out:  "χＧ_␝\bFＤ\x0fτε\n␁βｉ␑fｔ␈θKσ\nl\x0e＃'␀Ｇ␉␊",
	}, { // 3527
		mask: EncodeSquareBracket | EncodeRightCrLfHtVt,
		in:   "χＧ_␝\bFＤ\x0fτε\n␁βｉ␑fｔ␈θKσ\nl\x0e＃'\x00Ｇ␉␊",
		out:  "χＧ_␝\bFＤ\x0fτε\n␁βｉ␑fｔ␈θKσ\nl\x0e＃'␀Ｇ␉‛␊",
	}, { // 3528
		mask: EncodeSquareBracket | EncodeRightCrLfHtVt,
		in:   "␍ωj１␜␖ε[\"｛\v<ｘ\x1cN\t＃\x10Aγψλ～δ␛^＼\fr６",
		out:  "␍ωj１␜␖ε［\"｛\v<ｘ\x1cN\t＃\x10Aγψλ～δ␛^＼\fr６",
	}, { // 3529
		mask: EncodeSquareBracket | EncodeRightCrLfHtVt,
		in:   "\v␋j１␜␖ε[\"｛\v<ｘ\x1cN\t＃\x10Aγψλ～δ␛^＼\fr６",
		out:  "\v␋j１␜␖ε［\"｛\v<ｘ\x1cN\t＃\x10Aγψλ～δ␛^＼\fr６",
	}, { // 3530
		mask: EncodeSquareBracket | EncodeRightCrLfHtVt,
		in:   "␋␋j１␜␖ε[\"｛\v<ｘ\x1cN\t＃\x10Aγψλ～δ␛^＼\fr６",
		out:  "␋␋j１␜␖ε［\"｛\v<ｘ\x1cN\t＃\x10Aγψλ～δ␛^＼\fr６",
	}, { // 3531
		mask: EncodeSquareBracket | EncodeRightCrLfHtVt,
		in:   "\vωj１␜␖ε[\"｛\v<ｘ\x1cN\t＃\x10Aγψλ～δ␛^＼\f␋６",
		out:  "\vωj１␜␖ε［\"｛\v<ｘ\x1cN\t＃\x10Aγψλ～δ␛^＼\f␋６",
	}, { // 3532
		mask: EncodeSquareBracket | EncodeRightCrLfHtVt,
		in:   "␋ωj１␜␖ε[\"｛\v<ｘ\x1cN\t＃\x10Aγψλ～δ␛^＼\f␋６",
		out:  "␋ωj１␜␖ε［\"｛\v<ｘ\x1cN\t＃\x10Aγψλ～δ␛^＼\f␋６",
	}, { // 3533
		mask: EncodeSquareBracket | EncodeRightCrLfHtVt,
		in:   "\vωj１␜␖ε[\"｛\v<ｘ\x1cN\t＃\x10Aγψλ～δ␛^＼\fr␋",
		out:  "\vωj１␜␖ε［\"｛\v<ｘ\x1cN\t＃\x10Aγψλ～δ␛^＼\fr‛␋",
	}, { // 3534
		mask: EncodeSquareBracket | EncodeRightCrLfHtVt,
		in:   "␋ωj１␜␖ε[\"｛\v<ｘ\x1cN\t＃\x10Aγψλ～δ␛^＼\fr␋",
		out:  "␋ωj１␜␖ε［\"｛\v<ｘ\x1cN\t＃\x10Aγψλ～δ␛^＼\fr‛␋",
	}, { // 3535
		mask: EncodeSquareBracket | EncodeRightCrLfHtVt,
		in:   "␍\vj１␜␖ε[\"｛\v<ｘ\x1cN\t＃\x10Aγψλ～δ␛^＼\fr６",
		out:  "␍\vj１␜␖ε［\"｛\v<ｘ\x1cN\t＃\x10Aγψλ～δ␛^＼\fr６",
	}, { // 3536
		mask: EncodeSquareBracket | EncodeRightCrLfHtVt,
		in:   "␍␋j１␜␖ε[\"｛\v<ｘ\x1cN\t＃\x10Aγψλ～δ␛^＼\fr６",
		out:  "␍␋j１␜␖ε［\"｛\v<ｘ\x1cN\t＃\x10Aγψλ～δ␛^＼\fr６",
	}, { // 3537
		mask: EncodeSquareBracket | EncodeRightCrLfHtVt,
		in:   "␍\vj１␜␖ε[\"｛\v<ｘ\x1cN\t＃\x10Aγψλ～δ␛^＼\f␋６",
		out:  "␍\vj１␜␖ε［\"｛\v<ｘ\x1cN\t＃\x10Aγψλ～δ␛^＼\f␋６",
	}, { // 3538
		mask: EncodeSquareBracket | EncodeRightCrLfHtVt,
		in:   "␍␋j１␜␖ε[\"｛\v<ｘ\x1cN\t＃\x10Aγψλ～δ␛^＼\f␋６",
		out:  "␍␋j１␜␖ε［\"｛\v<ｘ\x1cN\t＃\x10Aγψλ～δ␛^＼\f␋６",
	}, { // 3539
		mask: EncodeSquareBracket | EncodeRightCrLfHtVt,
		in:   "␍\vj１␜␖ε[\"｛\v<ｘ\x1cN\t＃\x10Aγψλ～δ␛^＼\fr␋",
		out:  "␍\vj１␜␖ε［\"｛\v<ｘ\x1cN\t＃\x10Aγψλ～δ␛^＼\fr‛␋",
	}, { // 3540
		mask: EncodeSquareBracket | EncodeRightCrLfHtVt,
		in:   "␍␋j１␜␖ε[\"｛\v<ｘ\x1cN\t＃\x10Aγψλ～δ␛^＼\fr␋",
		out:  "␍␋j１␜␖ε［\"｛\v<ｘ\x1cN\t＃\x10Aγψλ～δ␛^＼\fr‛␋",
	}, { // 3541
		mask: EncodeSquareBracket | EncodeRightCrLfHtVt,
		in:   "␍ωj１␜␖ε[\"｛\v<ｘ\x1cN\t＃\x10Aγψλ～δ␛^＼\f\v６",
		out:  "␍ωj１␜␖ε［\"｛\v<ｘ\x1cN\t＃\x10Aγψλ～δ␛^＼\f\v６",
	}, { // 3542
		mask: EncodeSquareBracket | EncodeRightCrLfHtVt,
		in:   "␍ωj１␜␖ε[\"｛\v<ｘ\x1cN\t＃\x10Aγψλ～δ␛^＼\f␋６",
		out:  "␍ωj１␜␖ε［\"｛\v<ｘ\x1cN\t＃\x10Aγψλ～δ␛^＼\f␋６",
	}, { // 3543
		mask: EncodeSquareBracket | EncodeRightCrLfHtVt,
		in:   "␍ωj１␜␖ε[\"｛\v<ｘ\x1cN\t＃\x10Aγψλ～δ␛^＼\f\v␋",
		out:  "␍ωj１␜␖ε［\"｛\v<ｘ\x1cN\t＃\x10Aγψλ～δ␛^＼\f\v‛␋",
	}, { // 3544
		mask: EncodeSquareBracket | EncodeRightCrLfHtVt,
		in:   "␍ωj１␜␖ε[\"｛\v<ｘ\x1cN\t＃\x10Aγψλ～δ␛^＼\f␋␋",
		out:  "␍ωj１␜␖ε［\"｛\v<ｘ\x1cN\t＃\x10Aγψλ～δ␛^＼\f␋‛␋",
	}, { // 3545
		mask: EncodeSquareBracket | EncodeRightCrLfHtVt,
		in:   "␍ωj１␜␖ε[\"｛\v<ｘ\x1cN\t＃\x10Aγψλ～δ␛^＼\fr\v",
		out:  "␍ωj１␜␖ε［\"｛\v<ｘ\x1cN\t＃\x10Aγψλ～δ␛^＼\fr␋",
	}, { // 3546
		mask: EncodeSquareBracket | EncodeRightCrLfHtVt,
		in:   "␍ωj１␜␖ε[\"｛\v<ｘ\x1cN\t＃\x10Aγψλ～δ␛^＼\fr␋",
		out:  "␍ωj１␜␖ε［\"｛\v<ｘ\x1cN\t＃\x10Aγψλ～δ␛^＼\fr‛␋",
	}, { // 3547
		mask: EncodeSquareBracket | EncodeRightCrLfHtVt,
		in:   "αγ␚k␖<ε\vＪＤ\r``？ａ.*_\n␁␀＞τμ（ｘμｇ\x01\r",
		out:  "αγ␚k␖<ε\vＪＤ\r``？ａ.*_\n␁‛␀＞τμ（ｘμｇ\x01␍",
	}, { // 3548
		mask: EncodeSquareBracket | EncodeRightCrLfHtVt,
		in:   "\r␍␚k␖<ε\vＪＤ\r``？ａ.*_\n␁␀＞τμ（ｘμｇ\x01\r",
		out:  "\r␍␚k␖<ε\vＪＤ\r``？ａ.*_\n␁‛␀＞τμ（ｘμｇ\x01␍",
	}, { // 3549
		mask: EncodeSquareBracket | EncodeRightCrLfHtVt,
		in:   "␍␍␚k␖<ε\vＪＤ\r``？ａ.*_\n␁␀＞τμ（ｘμｇ\x01\r",
		out:  "␍␍␚k␖<ε\vＪＤ\r``？ａ.*_\n␁‛␀＞τμ（ｘμｇ\x01␍",
	}, { // 3550
		mask: EncodeSquareBracket | EncodeRightCrLfHtVt,
		in:   "\rγ␚k␖<ε\vＪＤ\r``？ａ.*_\n␁␀＞τμ（ｘμｇ␍\r",
		out:  "\rγ␚k␖<ε\vＪＤ\r``？ａ.*_\n␁‛␀＞τμ（ｘμｇ␍␍",
	}, { // 3551
		mask: EncodeSquareBracket | EncodeRightCrLfHtVt,
		in:   "␍γ␚k␖<ε\vＪＤ\r``？ａ.*_\n␁␀＞τμ（ｘμｇ␍\r",
		out:  "␍γ␚k␖<ε\vＪＤ\r``？ａ.*_\n␁‛␀＞τμ（ｘμｇ␍␍",
	}, { // 3552
		mask: EncodeSquareBracket | EncodeRightCrLfHtVt,
		in:   "\rγ␚k␖<ε\vＪＤ\r``？ａ.*_\n␁␀＞τμ（ｘμｇ\x01␍",
		out:  "\rγ␚k␖<ε\vＪＤ\r``？ａ.*_\n␁‛␀＞τμ（ｘμｇ\x01‛␍",
	}, { // 3553
		mask: EncodeSquareBracket | EncodeRightCrLfHtVt,
		in:   "␍γ␚k␖<ε\vＪＤ\r``？ａ.*_\n␁␀＞τμ（ｘμｇ\x01␍",
		out:  "␍γ␚k␖<ε\vＪＤ\r``？ａ.*_\n␁‛␀＞τμ（ｘμｇ\x01‛␍",
	}, { // 3554
		mask: EncodeSquareBracket | EncodeRightCrLfHtVt,
		in:   "α\r␚k␖<ε\vＪＤ\r``？ａ.*_\n␁␀＞τμ（ｘμｇ\x01\r",
		out:  "α\r␚k␖<ε\vＪＤ\r``？ａ.*_\n␁‛␀＞τμ（ｘμｇ\x01␍",
	}, { // 3555
		mask: EncodeSquareBracket | EncodeRightCrLfHtVt,
		in:   "α␍␚k␖<ε\vＪＤ\r``？ａ.*_\n␁␀＞τμ（ｘμｇ\x01\r",
		out:  "α␍␚k␖<ε\vＪＤ\r``？ａ.*_\n␁‛␀＞τμ（ｘμｇ\x01␍",
	}, { // 3556
		mask: EncodeSquareBracket | EncodeRightCrLfHtVt,
		in:   "α\r␚k␖<ε\vＪＤ\r``？ａ.*_\n␁␀＞τμ（ｘμｇ␍\r",
		out:  "α\r␚k␖<ε\vＪＤ\r``？ａ.*_\n␁‛␀＞τμ（ｘμｇ␍␍",
	}, { // 3557
		mask: EncodeSquareBracket | EncodeRightCrLfHtVt,
		in:   "α␍␚k␖<ε\vＪＤ\r``？ａ.*_\n␁␀＞τμ（ｘμｇ␍\r",
		out:  "α␍␚k␖<ε\vＪＤ\r``？ａ.*_\n␁‛␀＞τμ（ｘμｇ␍␍",
	}, { // 3558
		mask: EncodeSquareBracket | EncodeRightCrLfHtVt,
		in:   "α\r␚k␖<ε\vＪＤ\r``？ａ.*_\n␁␀＞τμ（ｘμｇ\x01␍",
		out:  "α\r␚k␖<ε\vＪＤ\r``？ａ.*_\n␁‛␀＞τμ（ｘμｇ\x01‛␍",
	}, { // 3559
		mask: EncodeSquareBracket | EncodeRightCrLfHtVt,
		in:   "α␍␚k␖<ε\vＪＤ\r``？ａ.*_\n␁␀＞τμ（ｘμｇ\x01␍",
		out:  "α␍␚k␖<ε\vＪＤ\r``？ａ.*_\n␁‛␀＞τμ（ｘμｇ\x01‛␍",
	}, { // 3560
		mask: EncodeSquareBracket | EncodeRightCrLfHtVt,
		in:   "αγ␚k␖<ε\vＪＤ\r``？ａ.*_\n␁␀＞τμ（ｘμｇ\r\r",
		out:  "αγ␚k␖<ε\vＪＤ\r``？ａ.*_\n␁‛␀＞τμ（ｘμｇ\r␍",
	}, { // 3561
		mask: EncodeSquareBracket | EncodeRightCrLfHtVt,
		in:   "αγ␚k␖<ε\vＪＤ\r``？ａ.*_\n␁␀＞τμ（ｘμｇ␍\r",
		out:  "αγ␚k␖<ε\vＪＤ\r``？ａ.*_\n␁‛␀＞τμ（ｘμｇ␍␍",
	}, { // 3562
		mask: EncodeSquareBracket | EncodeRightCrLfHtVt,
		in:   "αγ␚k␖<ε\vＪＤ\r``？ａ.*_\n␁␀＞τμ（ｘμｇ\r␍",
		out:  "αγ␚k␖<ε\vＪＤ\r``？ａ.*_\n␁‛␀＞τμ（ｘμｇ\r‛␍",
	}, { // 3563
		mask: EncodeSquareBracket | EncodeRightCrLfHtVt,
		in:   "αγ␚k␖<ε\vＪＤ\r``？ａ.*_\n␁␀＞τμ（ｘμｇ␍␍",
		out:  "αγ␚k␖<ε\vＪＤ\r``？ａ.*_\n␁‛␀＞τμ（ｘμｇ␍‛␍",
	}, { // 3564
		mask: EncodeSquareBracket | EncodeRightCrLfHtVt,
		in:   "αγ␚k␖<ε\vＪＤ\r``？ａ.*_\n␁␀＞τμ（ｘμｇ\x01\r",
		out:  "αγ␚k␖<ε\vＪＤ\r``？ａ.*_\n␁‛␀＞τμ（ｘμｇ\x01␍",
	}, { // 3565
		mask: EncodeSquareBracket | EncodeRightCrLfHtVt,
		in:   "αγ␚k␖<ε\vＪＤ\r``？ａ.*_\n␁␀＞τμ（ｘμｇ\x01␍",
		out:  "αγ␚k␖<ε\vＪＤ\r``？ａ.*_\n␁‛␀＞τμ（ｘμｇ\x01‛␍",
	}, { // 3566
		mask: EncodeSemicolon | EncodeRightCrLfHtVt,
		in:   "ρg３ρ\avＵ\x1d\bｔ\t＇ω␍:λ＊}6Ｎ\x12␈％<eξιｏZ␌",
		out:  "ρg３ρ\avＵ\x1d\bｔ\t＇ω␍:λ＊}6Ｎ\x12␈％<eξιｏZ␌",
	}, { // 3567
		mask: EncodeSemicolon | EncodeRightCrLfHtVt,
		in:   "\t␉３ρ\avＵ\x1d\bｔ\t＇ω␍:λ＊}6Ｎ\x12␈％<eξιｏZ␌",
		out:  "\t␉３ρ\avＵ\x1d\bｔ\t＇ω␍:λ＊}6Ｎ\x12␈％<eξιｏZ␌",
	}, { // 3568
		mask: EncodeSemicolon | EncodeRightCrLfHtVt,
		in:   "␉␉３ρ\avＵ\x1d\bｔ\t＇ω␍:λ＊}6Ｎ\x12␈％<eξιｏZ␌",
		out:  "␉␉３ρ\avＵ\x1d\bｔ\t＇ω␍:λ＊}6Ｎ\x12␈％<eξιｏZ␌",
	}, { // 3569
		mask: EncodeSemicolon | EncodeRightCrLfHtVt,
		in:   "\tg３ρ\avＵ\x1d\bｔ\t＇ω␍:λ＊}6Ｎ\x12␈％<eξιｏ␉␌",
		out:  "\tg３ρ\avＵ\x1d\bｔ\t＇ω␍:λ＊}6Ｎ\x12␈％<eξιｏ␉␌",
	}, { // 3570
		mask: EncodeSemicolon | EncodeRightCrLfHtVt,
		in:   "␉g３ρ\avＵ\x1d\bｔ\t＇ω␍:λ＊}6Ｎ\x12␈％<eξιｏ␉␌",
		out:  "␉g３ρ\avＵ\x1d\bｔ\t＇ω␍:λ＊}6Ｎ\x12␈％<eξιｏ␉␌",
	}, { // 3571
		mask: EncodeSemicolon | EncodeRightCrLfHtVt,
		in:   "\tg３ρ\avＵ\x1d\bｔ\t＇ω␍:λ＊}6Ｎ\x12␈％<eξιｏZ␉",
		out:  "\tg３ρ\avＵ\x1d\bｔ\t＇ω␍:λ＊}6Ｎ\x12␈％<eξιｏZ‛␉",
	}, { // 3572
		mask: EncodeSemicolon | EncodeRightCrLfHtVt,
		in:   "␉g３ρ\avＵ\x1d\bｔ\t＇ω␍:λ＊}6Ｎ\x12␈％<eξιｏZ␉",
		out:  "␉g３ρ\avＵ\x1d\bｔ\t＇ω␍:λ＊}6Ｎ\x12␈％<eξιｏZ‛␉",
	}, { // 3573
		mask: EncodeSemicolon | EncodeRightCrLfHtVt,
		in:   "ρ\t３ρ\avＵ\x1d\bｔ\t＇ω␍:λ＊}6Ｎ\x12␈％<eξιｏZ␌",
		out:  "ρ\t３ρ\avＵ\x1d\bｔ\t＇ω␍:λ＊}6Ｎ\x12␈％<eξιｏZ␌",
	}, { // 3574
		mask: EncodeSemicolon | EncodeRightCrLfHtVt,
		in:   "ρ␉３ρ\avＵ\x1d\bｔ\t＇ω␍:λ＊}6Ｎ\x12␈％<eξιｏZ␌",
		out:  "ρ␉３ρ\avＵ\x1d\bｔ\t＇ω␍:λ＊}6Ｎ\x12␈％<eξιｏZ␌",
	}, { // 3575
		mask: EncodeSemicolon | EncodeRightCrLfHtVt,
		in:   "ρ\t３ρ\avＵ\x1d\bｔ\t＇ω␍:λ＊}6Ｎ\x12␈％<eξιｏ␉␌",
		out:  "ρ\t３ρ\avＵ\x1d\bｔ\t＇ω␍:λ＊}6Ｎ\x12␈％<eξιｏ␉␌",
	}, { // 3576
		mask: EncodeSemicolon | EncodeRightCrLfHtVt,
		in:   "ρ␉３ρ\avＵ\x1d\bｔ\t＇ω␍:λ＊}6Ｎ\x12␈％<eξιｏ␉␌",
		out:  "ρ␉３ρ\avＵ\x1d\bｔ\t＇ω␍:λ＊}6Ｎ\x12␈％<eξιｏ␉␌",
	}, { // 3577
		mask: EncodeSemicolon | EncodeRightCrLfHtVt,
		in:   "ρ\t３ρ\avＵ\x1d\bｔ\t＇ω␍:λ＊}6Ｎ\x12␈％<eξιｏZ␉",
		out:  "ρ\t３ρ\avＵ\x1d\bｔ\t＇ω␍:λ＊}6Ｎ\x12␈％<eξιｏZ‛␉",
	}, { // 3578
		mask: EncodeSemicolon | EncodeRightCrLfHtVt,
		in:   "ρ␉３ρ\avＵ\x1d\bｔ\t＇ω␍:λ＊}6Ｎ\x12␈％<eξιｏZ␉",
		out:  "ρ␉３ρ\avＵ\x1d\bｔ\t＇ω␍:λ＊}6Ｎ\x12␈％<eξιｏZ‛␉",
	}, { // 3579
		mask: EncodeSemicolon | EncodeRightCrLfHtVt,
		in:   "ρg３ρ\avＵ\x1d\bｔ\t＇ω␍:λ＊}6Ｎ\x12␈％<eξιｏ\t␌",
		out:  "ρg３ρ\avＵ\x1d\bｔ\t＇ω␍:λ＊}6Ｎ\x12␈％<eξιｏ\t␌",
	}, { // 3580
		mask: EncodeSemicolon | EncodeRightCrLfHtVt,
		in:   "ρg３ρ\avＵ\x1d\bｔ\t＇ω␍:λ＊}6Ｎ\x12␈％<eξιｏ␉␌",
		out:  "ρg３ρ\avＵ\x1d\bｔ\t＇ω␍:λ＊}6Ｎ\x12␈％<eξιｏ␉␌",
	}, { // 3581
		mask: EncodeSemicolon | EncodeRightCrLfHtVt,
		in:   "ρg３ρ\avＵ\x1d\bｔ\t＇ω␍:λ＊}6Ｎ\x12␈％<eξιｏ\t␉",
		out:  "ρg３ρ\avＵ\x1d\bｔ\t＇ω␍:λ＊}6Ｎ\x12␈％<eξιｏ\t‛␉",
	}, { // 3582
		mask: EncodeSemicolon | EncodeRightCrLfHtVt,
		in:   "ρg３ρ\avＵ\x1d\bｔ\t＇ω␍:λ＊}6Ｎ\x12␈％<eξιｏ␉␉",
		out:  "ρg３ρ\avＵ\x1d\bｔ\t＇ω␍:λ＊}6Ｎ\x12␈％<eξιｏ␉‛␉",
	}, { // 3583
		mask: EncodeSemicolon | EncodeRightCrLfHtVt,
		in:   "ρg３ρ\avＵ\x1d\bｔ\t＇ω␍:λ＊}6Ｎ\x12␈％<eξιｏZ\t",
		out:  "ρg３ρ\avＵ\x1d\bｔ\t＇ω␍:λ＊}6Ｎ\x12␈％<eξιｏZ␉",
	}, { // 3584
		mask: EncodeSemicolon | EncodeRightCrLfHtVt,
		in:   "ρg３ρ\avＵ\x1d\bｔ\t＇ω␍:λ＊}6Ｎ\x12␈％<eξιｏZ␉",
		out:  "ρg３ρ\avＵ\x1d\bｔ\t＇ω␍:λ＊}6Ｎ\x12␈％<eξιｏZ‛␉",
	}, { // 3585
		mask: EncodeSemicolon | EncodeRightCrLfHtVt,
		in:   "＄νπＤ7n{␇R␃\n\x10^χ\x11ｌβ␍\x0e!｜␆Ｕε␘#\fｙ＇\x06",
		out:  "＄νπＤ7n{␇R␃\n\x10^χ\x11ｌβ␍\x0e!｜␆Ｕε␘#\fｙ＇\x06",
	}, { // 3586
		mask: EncodeSemicolon | EncodeRightCrLfHtVt,
		in:   "\n␊πＤ7n{␇R␃\n\x10^χ\x11ｌβ␍\x0e!｜␆Ｕε␘#\fｙ＇\x06",
		out:  "\n␊πＤ7n{␇R␃\n\x10^χ\x11ｌβ␍\x0e!｜␆Ｕε␘#\fｙ＇\x06",
	}, { // 3587
		mask: EncodeSemicolon | EncodeRightCrLfHtVt,
		in:   "␊␊πＤ7n{␇R␃\n\x10^χ\x11ｌβ␍\x0e!｜␆Ｕε␘#\fｙ＇\x06",
		out:  "␊␊πＤ7n{␇R␃\n\x10^χ\x11ｌβ␍\x0e!｜␆Ｕε␘#\fｙ＇\x06",
	}, { // 3588
		mask: EncodeSemicolon | EncodeRightCrLfHtVt,
		in:   "\nνπＤ7n{␇R␃\n\x10^χ\x11ｌβ␍\x0e!｜␆Ｕε␘#\fｙ␊\x06",
		out:  "\nνπＤ7n{␇R␃\n\x10^χ\x11ｌβ␍\x0e!｜␆Ｕε␘#\fｙ␊\x06",
	}, { // 3589
		mask: EncodeSemicolon | EncodeRightCrLfHtVt,
		in:   "␊νπＤ7n{␇R␃\n\x10^χ\x11ｌβ␍\x0e!｜␆Ｕε␘#\fｙ␊\x06",
		out:  "␊νπＤ7n{␇R␃\n\x10^χ\x11ｌβ␍\x0e!｜␆Ｕε␘#\fｙ␊\x06",
	}, { // 3590
		mask: EncodeSemicolon | EncodeRightCrLfHtVt,
		in:   "\nνπＤ7n{␇R␃\n\x10^χ\x11ｌβ␍\x0e!｜␆Ｕε␘#\fｙ＇␊",
		out:  "\nνπＤ7n{␇R␃\n\x10^χ\x11ｌβ␍\x0e!｜␆Ｕε␘#\fｙ＇‛␊",
	}, { // 3591
		mask: EncodeSemicolon | EncodeRightCrLfHtVt,
		in:   "␊νπＤ7n{␇R␃\n\x10^χ\x11ｌβ␍\x0e!｜␆Ｕε␘#\fｙ＇␊",
		out:  "␊νπＤ7n{␇R␃\n\x10^χ\x11ｌβ␍\x0e!｜␆Ｕε␘#\fｙ＇‛␊",
	}, { // 3592
		mask: EncodeSemicolon | EncodeRightCrLfHtVt,
		in:   "＄\nπＤ7n{␇R␃\n\x10^χ\x11ｌβ␍\x0e!｜␆Ｕε␘#\fｙ＇\x06",
		out:  "＄\nπＤ7n{␇R␃\n\x10^χ\x11ｌβ␍\x0e!｜␆Ｕε␘#\fｙ＇\x06",
	}, { // 3593
		mask: EncodeSemicolon | EncodeRightCrLfHtVt,
		in:   "＄␊πＤ7n{␇R␃\n\x10^χ\x11ｌβ␍\x0e!｜␆Ｕε␘#\fｙ＇\x06",
		out:  "＄␊πＤ7n{␇R␃\n\x10^χ\x11ｌβ␍\x0e!｜␆Ｕε␘#\fｙ＇\x06",
	}, { // 3594
		mask: EncodeSemicolon | EncodeRightCrLfHtVt,
		in:   "＄\nπＤ7n{␇R␃\n\x10^χ\x11ｌβ␍\x0e!｜␆Ｕε␘#\fｙ␊\x06",
		out:  "＄\nπＤ7n{␇R␃\n\x10^χ\x11ｌβ␍\x0e!｜␆Ｕε␘#\fｙ␊\x06",
	}, { // 3595
		mask: EncodeSemicolon | EncodeRightCrLfHtVt,
		in:   "＄␊πＤ7n{␇R␃\n\x10^χ\x11ｌβ␍\x0e!｜␆Ｕε␘#\fｙ␊\x06",
		out:  "＄␊πＤ7n{␇R␃\n\x10^χ\x11ｌβ␍\x0e!｜␆Ｕε␘#\fｙ␊\x06",
	}, { // 3596
		mask: EncodeSemicolon | EncodeRightCrLfHtVt,
		in:   "＄\nπＤ7n{␇R␃\n\x10^χ\x11ｌβ␍\x0e!｜␆Ｕε␘#\fｙ＇␊",
		out:  "＄\nπＤ7n{␇R␃\n\x10^χ\x11ｌβ␍\x0e!｜␆Ｕε␘#\fｙ＇‛␊",
	}, { // 3597
		mask: EncodeSemicolon | EncodeRightCrLfHtVt,
		in:   "＄␊πＤ7n{␇R␃\n\x10^χ\x11ｌβ␍\x0e!｜␆Ｕε␘#\fｙ＇␊",
		out:  "＄␊πＤ7n{␇R␃\n\x10^χ\x11ｌβ␍\x0e!｜␆Ｕε␘#\fｙ＇‛␊",
	}, { // 3598
		mask: EncodeSemicolon | EncodeRightCrLfHtVt,
		in:   "＄νπＤ7n{␇R␃\n\x10^χ\x11ｌβ␍\x0e!｜␆Ｕε␘#\fｙ\n\x06",
		out:  "＄νπＤ7n{␇R␃\n\x10^χ\x11ｌβ␍\x0e!｜␆Ｕε␘#\fｙ\n\x06",
	}, { // 3599
		mask: EncodeSemicolon | EncodeRightCrLfHtVt,
		in:   "＄νπＤ7n{␇R␃\n\x10^χ\x11ｌβ␍\x0e!｜␆Ｕε␘#\fｙ␊\x06",
		out:  "＄νπＤ7n{␇R␃\n\x10^χ\x11ｌβ␍\x0e!｜␆Ｕε␘#\fｙ␊\x06",
	}, { // 3600
		mask: EncodeSemicolon | EncodeRightCrLfHtVt,
		in:   "＄νπＤ7n{␇R␃\n\x10^χ\x11ｌβ␍\x0e!｜␆Ｕε␘#\fｙ\n␊",
		out:  "＄νπＤ7n{␇R␃\n\x10^χ\x11ｌβ␍\x0e!｜␆Ｕε␘#\fｙ\n‛␊",
	}, { // 3601
		mask: EncodeSemicolon | EncodeRightCrLfHtVt,
		in:   "＄νπＤ7n{␇R␃\n\x10^χ\x11ｌβ␍\x0e!｜␆Ｕε␘#\fｙ␊␊",
		out:  "＄νπＤ7n{␇R␃\n\x10^χ\x11ｌβ␍\x0e!｜␆Ｕε␘#\fｙ␊‛␊",
	}, { // 3602
		mask: EncodeSemicolon | EncodeRightCrLfHtVt,
		in:   "＄νπＤ7n{␇R␃\n\x10^χ\x11ｌβ␍\x0e!｜␆Ｕε␘#\fｙ＇\n",
		out:  "＄νπＤ7n{␇R␃\n\x10^χ\x11ｌβ␍\x0e!｜␆Ｕε␘#\fｙ＇␊",
	}, { // 3603
		mask: EncodeSemicolon | EncodeRightCrLfHtVt,
		in:   "＄νπＤ7n{␇R␃\n\x10^χ\x11ｌβ␍\x0e!｜␆Ｕε␘#\fｙ＇␊",
		out:  "＄νπＤ7n{␇R␃\n\x10^χ\x11ｌβ␍\x0e!｜␆Ｕε␘#\fｙ＇‛␊",
	}, { // 3604
		mask: EncodeSemicolon | EncodeRightCrLfHtVt,
		in:   "w｀９2w␟]ωｆρ\vβｔ＄Ａμ@γ;&␈｜２ζ␛j*\b\x14\x17",
		out:  "w｀９2w␟]ωｆρ\vβｔ＄Ａμ@γ；&␈｜２ζ␛j*\b\x14\x17",
	}, { // 3605
		mask: EncodeSemicolon | EncodeRightCrLfHtVt,
		in:   "\v␋９2w␟]ωｆρ\vβｔ＄Ａμ@γ;&␈｜２ζ␛j*\b\x14\x17",
		out:  "\v␋９2w␟]ωｆρ\vβｔ＄Ａμ@γ；&␈｜２ζ␛j*\b\x14\x17",
	}, { // 3606
		mask: EncodeSemicolon | EncodeRightCrLfHtVt,
		in:   "␋␋９2w␟]ωｆρ\vβｔ＄Ａμ@γ;&␈｜２ζ␛j*\b\x14\x17",
		out:  "␋␋９2w␟]ωｆρ\vβｔ＄Ａμ@γ；&␈｜２ζ␛j*\b\x14\x17",
	}, { // 3607
		mask: EncodeSemicolon | EncodeRightCrLfHtVt,
		in:   "\v｀９2w␟]ωｆρ\vβｔ＄Ａμ@γ;&␈｜２ζ␛j*\b␋\x17",
		out:  "\v｀９2w␟]ωｆρ\vβｔ＄Ａμ@γ；&␈｜２ζ␛j*\b␋\x17",
	}, { // 3608
		mask: EncodeSemicolon | EncodeRightCrLfHtVt,
		in:   "␋｀９2w␟]ωｆρ\vβｔ＄Ａμ@γ;&␈｜２ζ␛j*\b␋\x17",
		out:  "␋｀９2w␟]ωｆρ\vβｔ＄Ａμ@γ；&␈｜２ζ␛j*\b␋\x17",
	}, { // 3609
		mask: EncodeSemicolon | EncodeRightCrLfHtVt,
		in:   "\v｀９2w␟]ωｆρ\vβｔ＄Ａμ@γ;&␈｜２ζ␛j*\b\x14␋",
		out:  "\v｀９2w␟]ωｆρ\vβｔ＄Ａμ@γ；&␈｜２ζ␛j*\b\x14‛␋",
	}, { // 3610
		mask: EncodeSemicolon | EncodeRightCrLfHtVt,
		in:   "␋｀９2w␟]ωｆρ\vβｔ＄Ａμ@γ;&␈｜２ζ␛j*\b\x14␋",
		out:  "␋｀９2w␟]ωｆρ\vβｔ＄Ａμ@γ；&␈｜２ζ␛j*\b\x14‛␋",
	}, { // 3611
		mask: EncodeSemicolon | EncodeRightCrLfHtVt,
		in:   "w\v９2w␟]ωｆρ\vβｔ＄Ａμ@γ;&␈｜２ζ␛j*\b\x14\x17",
		out:  "w\v９2w␟]ωｆρ\vβｔ＄Ａμ@γ；&␈｜２ζ␛j*\b\x14\x17",
	}, { // 3612
		mask: EncodeSemicolon | EncodeRightCrLfHtVt,
		in:   "w␋９2w␟]ωｆρ\vβｔ＄Ａμ@γ;&␈｜２ζ␛j*\b\x14\x17",
		out:  "w␋９2w␟]ωｆρ\vβｔ＄Ａμ@γ；&␈｜２ζ␛j*\b\x14\x17",
	}, { // 3613
		mask: EncodeSemicolon | EncodeRightCrLfHtVt,
		in:   "w\v９2w␟]ωｆρ\vβｔ＄Ａμ@γ;&␈｜２ζ␛j*\b␋\x17",
		out:  "w\v９2w␟]ωｆρ\vβｔ＄Ａμ@γ；&␈｜２ζ␛j*\b␋\x17",
	}, { // 3614
		mask: EncodeSemicolon | EncodeRightCrLfHtVt,
		in:   "w␋９2w␟]ωｆρ\vβｔ＄Ａμ@γ;&␈｜２ζ␛j*\b␋\x17",
		out:  "w␋９2w␟]ωｆρ\vβｔ＄Ａμ@γ；&␈｜２ζ␛j*\b␋\x17",
	}, { // 3615
		mask: EncodeSemicolon | EncodeRightCrLfHtVt,
		in:   "w\v９2w␟]ωｆρ\vβｔ＄Ａμ@γ;&␈｜２ζ␛j*\b\x14␋",
		out:  "w\v９2w␟]ωｆρ\vβｔ＄Ａμ@γ；&␈｜２ζ␛j*\b\x14‛␋",
	}, { // 3616
		mask: EncodeSemicolon | EncodeRightCrLfHtVt,
		in:   "w␋９2w␟]ωｆρ\vβｔ＄Ａμ@γ;&␈｜２ζ␛j*\b\x14␋",
		out:  "w␋９2w␟]ωｆρ\vβｔ＄Ａμ@γ；&␈｜２ζ␛j*\b\x14‛␋",
	}, { // 3617
		mask: EncodeSemicolon | EncodeRightCrLfHtVt,
		in:   "w｀９2w␟]ωｆρ\vβｔ＄Ａμ@γ;&␈｜２ζ␛j*\b\v\x17",
		out:  "w｀９2w␟]ωｆρ\vβｔ＄Ａμ@γ；&␈｜２ζ␛j*\b\v\x17",
	}, { // 3618
		mask: EncodeSemicolon | EncodeRightCrLfHtVt,
		in:   "w｀９2w␟]ωｆρ\vβｔ＄Ａμ@γ;&␈｜２ζ␛j*\b␋\x17",
		out:  "w｀９2w␟]ωｆρ\vβｔ＄Ａμ@γ；&␈｜２ζ␛j*\b␋\x17",
	}, { // 3619
		mask: EncodeSemicolon | EncodeRightCrLfHtVt,
		in:   "w｀９2w␟]ωｆρ\vβｔ＄Ａμ@γ;&␈｜２ζ␛j*\b\v␋",
		out:  "w｀９2w␟]ωｆρ\vβｔ＄Ａμ@γ；&␈｜２ζ␛j*\b\v‛␋",
	}, { // 3620
		mask: EncodeSemicolon | EncodeRightCrLfHtVt,
		in:   "w｀９2w␟]ωｆρ\vβｔ＄Ａμ@γ;&␈｜２ζ␛j*\b␋␋",
		out:  "w｀９2w␟]ωｆρ\vβｔ＄Ａμ@γ；&␈｜２ζ␛j*\b␋‛␋",
	}, { // 3621
		mask: EncodeSemicolon | EncodeRightCrLfHtVt,
		in:   "w｀９2w␟]ωｆρ\vβｔ＄Ａμ@γ;&␈｜２ζ␛j*\b\x14\v",
		out:  "w｀９2w␟]ωｆρ\vβｔ＄Ａμ@γ；&␈｜２ζ␛j*\b\x14␋",
	}, { // 3622
		mask: EncodeSemicolon | EncodeRightCrLfHtVt,
		in:   "w｀９2w␟]ωｆρ\vβｔ＄Ａμ@γ;&␈｜２ζ␛j*\b\x14␋",
		out:  "w｀９2w␟]ωｆρ\vβｔ＄Ａμ@γ；&␈｜２ζ␛j*\b\x14‛␋",
	}, { // 3623
		mask: EncodeSemicolon | EncodeRightCrLfHtVt,
		in:   "␝5６␖！\x13T%\x18|\r␘\aＭ＄5!w\vρχι␅α␗␃６ρ\x16＋",
		out:  "␝5６␖！\x13T%\x18|\r␘\aＭ＄5!w\vρχι␅α␗␃６ρ\x16＋",
	}, { // 3624
		mask: EncodeSemicolon | EncodeRightCrLfHtVt,
		in:   "\r␍６␖！\x13T%\x18|\r␘\aＭ＄5!w\vρχι␅α␗␃６ρ\x16＋",
		out:  "\r␍６␖！\x13T%\x18|\r␘\aＭ＄5!w\vρχι␅α␗␃６ρ\x16＋",
	}, { // 3625
		mask: EncodeSemicolon | EncodeRightCrLfHtVt,
		in:   "␍␍６␖！\x13T%\x18|\r␘\aＭ＄5!w\vρχι␅α␗␃６ρ\x16＋",
		out:  "␍␍６␖！\x13T%\x18|\r␘\aＭ＄5!w\vρχι␅α␗␃６ρ\x16＋",
	}, { // 3626
		mask: EncodeSemicolon | EncodeRightCrLfHtVt,
		in:   "\r5６␖！\x13T%\x18|\r␘\aＭ＄5!w\vρχι␅α␗␃６ρ␍＋",
		out:  "\r5６␖！\x13T%\x18|\r␘\aＭ＄5!w\vρχι␅α␗␃６ρ␍＋",
	}, { // 3627
		mask: EncodeSemicolon | EncodeRightCrLfHtVt,
		in:   "␍5６␖！\x13T%\x18|\r␘\aＭ＄5!w\vρχι␅α␗␃６ρ␍＋",
		out:  "␍5６␖！\x13T%\x18|\r␘\aＭ＄5!w\vρχι␅α␗␃６ρ␍＋",
	}, { // 3628
		mask: EncodeSemicolon | EncodeRightCrLfHtVt,
		in:   "\r5６␖！\x13T%\x18|\r␘\aＭ＄5!w\vρχι␅α␗␃６ρ\x16␍",
		out:  "\r5６␖！\x13T%\x18|\r␘\aＭ＄5!w\vρχι␅α␗␃６ρ\x16‛␍",
	}, { // 3629
		mask: EncodeSemicolon | EncodeRightCrLfHtVt,
		in:   "␍5６␖！\x13T%\x18|\r␘\aＭ＄5!w\vρχι␅α␗␃６ρ\x16␍",
		out:  "␍5６␖！\x13T%\x18|\r␘\aＭ＄5!w\vρχι␅α␗␃６ρ\x16‛␍",
	}, { // 3630
		mask: EncodeSemicolon | EncodeRightCrLfHtVt,
		in:   "␝\r６␖！\x13T%\x18|\r␘\aＭ＄5!w\vρχι␅α␗␃６ρ\x16＋",
		out:  "␝\r６␖！\x13T%\x18|\r␘\aＭ＄5!w\vρχι␅α␗␃６ρ\x16＋",
	}, { // 3631
		mask: EncodeSemicolon | EncodeRightCrLfHtVt,
		in:   "␝␍６␖！\x13T%\x18|\r␘\aＭ＄5!w\vρχι␅α␗␃６ρ\x16＋",
		out:  "␝␍６␖！\x13T%\x18|\r␘\aＭ＄5!w\vρχι␅α␗␃６ρ\x16＋",
	}, { // 3632
		mask: EncodeSemicolon | EncodeRightCrLfHtVt,
		in:   "␝\r６␖！\x13T%\x18|\r␘\aＭ＄5!w\vρχι␅α␗␃６ρ␍＋",
		out:  "␝\r６␖！\x13T%\x18|\r␘\aＭ＄5!w\vρχι␅α␗␃６ρ␍＋",
	}, { // 3633
		mask: EncodeSemicolon | EncodeRightCrLfHtVt,
		in:   "␝␍６␖！\x13T%\x18|\r␘\aＭ＄5!w\vρχι␅α␗␃６ρ␍＋",
		out:  "␝␍６␖！\x13T%\x18|\r␘\aＭ＄5!w\vρχι␅α␗␃６ρ␍＋",
	}, { // 3634
		mask: EncodeSemicolon | EncodeRightCrLfHtVt,
		in:   "␝\r６␖！\x13T%\x18|\r␘\aＭ＄5!w\vρχι␅α␗␃６ρ\x16␍",
		out:  "␝\r６␖！\x13T%\x18|\r␘\aＭ＄5!w\vρχι␅α␗␃６ρ\x16‛␍",
	}, { // 3635
		mask: EncodeSemicolon | EncodeRightCrLfHtVt,
		in:   "␝␍６␖！\x13T%\x18|\r␘\aＭ＄5!w\vρχι␅α␗␃６ρ\x16␍",
		out:  "␝␍６␖！\x13T%\x18|\r␘\aＭ＄5!w\vρχι␅α␗␃６ρ\x16‛␍",
	}, { // 3636
		mask: EncodeSemicolon | EncodeRightCrLfHtVt,
		in:   "␝5６␖！\x13T%\x18|\r␘\aＭ＄5!w\vρχι␅α␗␃６ρ\r＋",
		out:  "␝5６␖！\x13T%\x18|\r␘\aＭ＄5!w\vρχι␅α␗␃６ρ\r＋",
	}, { // 3637
		mask: EncodeSemicolon | EncodeRightCrLfHtVt,
		in:   "␝5６␖！\x13T%\x18|\r␘\aＭ＄5!w\vρχι␅α␗␃６ρ␍＋",
		out:  "␝5６␖！\x13T%\x18|\r␘\aＭ＄5!w\vρχι␅α␗␃６ρ␍＋",
	}, { // 3638
		mask: EncodeSemicolon | EncodeRightCrLfHtVt,
		in:   "␝5６␖！\x13T%\x18|\r␘\aＭ＄5!w\vρχι␅α␗␃６ρ\r␍",
		out:  "␝5６␖！\x13T%\x18|\r␘\aＭ＄5!w\vρχι␅α␗␃６ρ\r‛␍",
	}, { // 3639
		mask: EncodeSemicolon | EncodeRightCrLfHtVt,
		in:   "␝5６␖！\x13T%\x18|\r␘\aＭ＄5!w\vρχι␅α␗␃６ρ␍␍",
		out:  "␝5６␖！\x13T%\x18|\r␘\aＭ＄5!w\vρχι␅α␗␃６ρ␍‛␍",
	}, { // 3640
		mask: EncodeSemicolon | EncodeRightCrLfHtVt,
		in:   "␝5６␖！\x13T%\x18|\r␘\aＭ＄5!w\vρχι␅α␗␃６ρ\x16\r",
		out:  "␝5６␖！\x13T%\x18|\r␘\aＭ＄5!w\vρχι␅α␗␃６ρ\x16␍",
	}, { // 3641
		mask: EncodeSemicolon | EncodeRightCrLfHtVt,
		in:   "␝5６␖！\x13T%\x18|\r␘\aＭ＄5!w\vρχι␅α␗␃６ρ\x16␍",
		out:  "␝5６␖！\x13T%\x18|\r␘\aＭ＄5!w\vρχι␅α␗␃６ρ\x16‛␍",
	}, { // 3642
		mask: EncodeDollar | EncodeRightCrLfHtVt,
		in:   "κθ␑X（Z␏ｘ＋\x16\t$χ␁θ\x0eｇ␋\n?／（q／ｑ&P\u007fγθ",
		out:  "κθ␑X（Z␏ｘ＋\x16\t＄χ␁θ\x0eｇ␋\n?／（q／ｑ&P\u007fγθ",
	}, { // 3643
		mask: EncodeDollar | EncodeRightCrLfHtVt,
		in:   "\t␉␑X（Z␏ｘ＋\x16\t$χ␁θ\x0eｇ␋\n?／（q／ｑ&P\u007fγθ",
		out:  "\t␉␑X（Z␏ｘ＋\x16\t＄χ␁θ\x0eｇ␋\n?／（q／ｑ&P\u007fγθ",
	}, { // 3644
		mask: EncodeDollar | EncodeRightCrLfHtVt,
		in:   "␉␉␑X（Z␏ｘ＋\x16\t$χ␁θ\x0eｇ␋\n?／（q／ｑ&P\u007fγθ",
		out:  "␉␉␑X（Z␏ｘ＋\x16\t＄χ␁θ\x0eｇ␋\n?／（q／ｑ&P\u007fγθ",
	}, { // 3645
		mask: EncodeDollar | EncodeRightCrLfHtVt,
		in:   "\tθ␑X（Z␏ｘ＋\x16\t$χ␁θ\x0eｇ␋\n?／（q／ｑ&P\u007f␉θ",
		out:  "\tθ␑X（Z␏ｘ＋\x16\t＄χ␁θ\x0eｇ␋\n?／（q／ｑ&P\u007f␉θ",
	}, { // 3646
		mask: EncodeDollar | EncodeRightCrLfHtVt,
		in:   "␉θ␑X（Z␏ｘ＋\x16\t$χ␁θ\x0eｇ␋\n?／（q／ｑ&P\u007f␉θ",
		out:  "␉θ␑X（Z␏ｘ＋\x16\t＄χ␁θ\x0eｇ␋\n?／（q／ｑ&P\u007f␉θ",
	}, { // 3647
		mask: EncodeDollar | EncodeRightCrLfHtVt,
		in:   "\tθ␑X（Z␏ｘ＋\x16\t$χ␁θ\x0eｇ␋\n?／（q／ｑ&P\u007fγ␉",
		out:  "\tθ␑X（Z␏ｘ＋\x16\t＄χ␁θ\x0eｇ␋\n?／（q／ｑ&P\u007fγ‛␉",
	}, { // 3648
		mask: EncodeDollar | EncodeRightCrLfHtVt,
		in:   "␉θ␑X（Z␏ｘ＋\x16\t$χ␁θ\x0eｇ␋\n?／（q／ｑ&P\u007fγ␉",
		out:  "␉θ␑X（Z␏ｘ＋\x16\t＄χ␁θ\x0eｇ␋\n?／（q／ｑ&P\u007fγ‛␉",
	}, { // 3649
		mask: EncodeDollar | EncodeRightCrLfHtVt,
		in:   "κ\t␑X（Z␏ｘ＋\x16\t$χ␁θ\x0eｇ␋\n?／（q／ｑ&P\u007fγθ",
		out:  "κ\t␑X（Z␏ｘ＋\x16\t＄χ␁θ\x0eｇ␋\n?／（q／ｑ&P\u007fγθ",
	}, { // 3650
		mask: EncodeDollar | EncodeRightCrLfHtVt,
		in:   "κ␉␑X（Z␏ｘ＋\x16\t$χ␁θ\x0eｇ␋\n?／（q／ｑ&P\u007fγθ",
		out:  "κ␉␑X（Z␏ｘ＋\x16\t＄χ␁θ\x0eｇ␋\n?／（q／ｑ&P\u007fγθ",
	}, { // 3651
		mask: EncodeDollar | EncodeRightCrLfHtVt,
		in:   "κ\t␑X（Z␏ｘ＋\x16\t$χ␁θ\x0eｇ␋\n?／（q／ｑ&P\u007f␉θ",
		out:  "κ\t␑X（Z␏ｘ＋\x16\t＄χ␁θ\x0eｇ␋\n?／（q／ｑ&P\u007f␉θ",
	}, { // 3652
		mask: EncodeDollar | EncodeRightCrLfHtVt,
		in:   "κ␉␑X（Z␏ｘ＋\x16\t$χ␁θ\x0eｇ␋\n?／（q／ｑ&P\u007f␉θ",
		out:  "κ␉␑X（Z␏ｘ＋\x16\t＄χ␁θ\x0eｇ␋\n?／（q／ｑ&P\u007f␉θ",
	}, { // 3653
		mask: EncodeDollar | EncodeRightCrLfHtVt,
		in:   "κ\t␑X（Z␏ｘ＋\x16\t$χ␁θ\x0eｇ␋\n?／（q／ｑ&P\u007fγ␉",
		out:  "κ\t␑X（Z␏ｘ＋\x16\t＄χ␁θ\x0eｇ␋\n?／（q／ｑ&P\u007fγ‛␉",
	}, { // 3654
		mask: EncodeDollar | EncodeRightCrLfHtVt,
		in:   "κ␉␑X（Z␏ｘ＋\x16\t$χ␁θ\x0eｇ␋\n?／（q／ｑ&P\u007fγ␉",
		out:  "κ␉␑X（Z␏ｘ＋\x16\t＄χ␁θ\x0eｇ␋\n?／（q／ｑ&P\u007fγ‛␉",
	}, { // 3655
		mask: EncodeDollar | EncodeRightCrLfHtVt,
		in:   "κθ␑X（Z␏ｘ＋\x16\t$χ␁θ\x0eｇ␋\n?／（q／ｑ&P\u007f\tθ",
		out:  "κθ␑X（Z␏ｘ＋\x16\t＄χ␁θ\x0eｇ␋\n?／（q／ｑ&P\u007f\tθ",
	}, { // 3656
		mask: EncodeDollar | EncodeRightCrLfHtVt,
		in:   "κθ␑X（Z␏ｘ＋\x16\t$χ␁θ\x0eｇ␋\n?／（q／ｑ&P\u007f␉θ",
		out:  "κθ␑X（Z␏ｘ＋\x16\t＄χ␁θ\x0eｇ␋\n?／（q／ｑ&P\u007f␉θ",
	}, { // 3657
		mask: EncodeDollar | EncodeRightCrLfHtVt,
		in:   "κθ␑X（Z␏ｘ＋\x16\t$χ␁θ\x0eｇ␋\n?／（q／ｑ&P\u007f\t␉",
		out:  "κθ␑X（Z␏ｘ＋\x16\t＄χ␁θ\x0eｇ␋\n?／（q／ｑ&P\u007f\t‛␉",
	}, { // 3658
		mask: EncodeDollar | EncodeRightCrLfHtVt,
		in:   "κθ␑X（Z␏ｘ＋\x16\t$χ␁θ\x0eｇ␋\n?／（q／ｑ&P\u007f␉␉",
		out:  "κθ␑X（Z␏ｘ＋\x16\t＄χ␁θ\x0eｇ␋\n?／（q／ｑ&P\u007f␉‛␉",
	}, { // 3659
		mask: EncodeDollar | EncodeRightCrLfHtVt,
		in:   "κθ␑X（Z␏ｘ＋\x16\t$χ␁θ\x0eｇ␋\n?／（q／ｑ&P\u007fγ\t",
		out:  "κθ␑X（Z␏ｘ＋\x16\t＄χ␁θ\x0eｇ␋\n?／（q／ｑ&P\u007fγ␉",
	}, { // 3660
		mask: EncodeDollar | EncodeRightCrLfHtVt,
		in:   "κθ␑X（Z␏ｘ＋\x16\t$χ␁θ\x0eｇ␋\n?／（q／ｑ&P\u007fγ␉",
		out:  "κθ␑X（Z␏ｘ＋\x16\t＄χ␁θ\x0eｇ␋\n?／（q／ｑ&P\u007fγ‛␉",
	}, { // 3661
		mask: EncodeDollar | EncodeRightCrLfHtVt,
		in:   "\\Q＆εχ␉/␗$Ｉ\nlθ＋λ>［␟｜yδ␕\x11;ＷN２␑φ\n",
		out:  "\\Q＆εχ␉/␗＄Ｉ\nlθ＋λ>［␟｜yδ␕\x11;ＷN２␑φ␊",
	}, { // 3662
		mask: EncodeDollar | EncodeRightCrLfHtVt,
		in:   "\n␊＆εχ␉/␗$Ｉ\nlθ＋λ>［␟｜yδ␕\x11;ＷN２␑φ\n",
		out:  "\n␊＆εχ␉/␗＄Ｉ\nlθ＋λ>［␟｜yδ␕\x11;ＷN２␑φ␊",
	}, { // 3663
		mask: EncodeDollar | EncodeRightCrLfHtVt,
		in:   "␊␊＆εχ␉/␗$Ｉ\nlθ＋λ>［␟｜yδ␕\x11;ＷN２␑φ\n",
		out:  "␊␊＆εχ␉/␗＄Ｉ\nlθ＋λ>［␟｜yδ␕\x11;ＷN２␑φ␊",
	}, { // 3664
		mask: EncodeDollar | EncodeRightCrLfHtVt,
		in:   "\nQ＆εχ␉/␗$Ｉ\nlθ＋λ>［␟｜yδ␕\x11;ＷN２␑␊\n",
		out:  "\nQ＆εχ␉/␗＄Ｉ\nlθ＋λ>［␟｜yδ␕\x11;ＷN２␑␊␊",
	}, { // 3665
		mask: EncodeDollar | EncodeRightCrLfHtVt,
		in:   "␊Q＆εχ␉/␗$Ｉ\nlθ＋λ>［␟｜yδ␕\x11;ＷN２␑␊\n",
		out:  "␊Q＆εχ␉/␗＄Ｉ\nlθ＋λ>［␟｜yδ␕\x11;ＷN２␑␊␊",
	}, { // 3666
		mask: EncodeDollar | EncodeRightCrLfHtVt,
		in:   "\nQ＆εχ␉/␗$Ｉ\nlθ＋λ>［␟｜yδ␕\x11;ＷN２␑φ␊",
		out:  "\nQ＆εχ␉/␗＄Ｉ\nlθ＋λ>［␟｜yδ␕\x11;ＷN２␑φ‛␊",
	}, { // 3667
		mask: EncodeDollar | EncodeRightCrLfHtVt,
		in:   "␊Q＆εχ␉/␗$Ｉ\nlθ＋λ>［␟｜yδ␕\x11;ＷN２␑φ␊",
		out:  "␊Q＆εχ␉/␗＄Ｉ\nlθ＋λ>［␟｜yδ␕\x11;ＷN２␑φ‛␊",
	}, { // 3668
		mask: EncodeDollar | EncodeRightCrLfHtVt,
		in:   "\\\n＆εχ␉/␗$Ｉ\nlθ＋λ>［␟｜yδ␕\x11;ＷN２␑φ\n",
		out:  "\\\n＆εχ␉/␗＄Ｉ\nlθ＋λ>［␟｜yδ␕\x11;ＷN２␑φ␊",
	}, { // 3669
		mask: EncodeDollar | EncodeRightCrLfHtVt,
		in:   "\\␊＆εχ␉/␗$Ｉ\nlθ＋λ>［␟｜yδ␕\x11;ＷN２␑φ\n",
		out:  "\\␊＆εχ␉/␗＄Ｉ\nlθ＋λ>［␟｜yδ␕\x11;ＷN２␑φ␊",
	}, { // 3670
		mask: EncodeDollar | EncodeRightCrLfHtVt,
		in:   "\\\n＆εχ␉/␗$Ｉ\nlθ＋λ>［␟｜yδ␕\x11;ＷN２␑␊\n",
		out:  "\\\n＆εχ␉/␗＄Ｉ\nlθ＋λ>［␟｜yδ␕\x11;ＷN２␑␊␊",
	}, { // 3671
		mask: EncodeDollar | EncodeRightCrLfHtVt,
		in:   "\\␊＆εχ␉/␗$Ｉ\nlθ＋λ>［␟｜yδ␕\x11;ＷN２␑␊\n",
		out:  "\\␊＆εχ␉/␗＄Ｉ\nlθ＋λ>［␟｜yδ␕\x11;ＷN２␑␊␊",
	}, { // 3672
		mask: EncodeDollar | EncodeRightCrLfHtVt,
		in:   "\\\n＆εχ␉/␗$Ｉ\nlθ＋λ>［␟｜yδ␕\x11;ＷN２␑φ␊",
		out:  "\\\n＆εχ␉/␗＄Ｉ\nlθ＋λ>［␟｜yδ␕\x11;ＷN２␑φ‛␊",
	}, { // 3673
		mask: EncodeDollar | EncodeRightCrLfHtVt,
		in:   "\\␊＆εχ␉/␗$Ｉ\nlθ＋λ>［␟｜yδ␕\x11;ＷN２␑φ␊",
		out:  "\\␊＆εχ␉/␗＄Ｉ\nlθ＋λ>［␟｜yδ␕\x11;ＷN２␑φ‛␊",
	}, { // 3674
		mask: EncodeDollar | EncodeRightCrLfHtVt,
		in:   "\\Q＆εχ␉/␗$Ｉ\nlθ＋λ>［␟｜yδ␕\x11;ＷN２␑\n\n",
		out:  "\\Q＆εχ␉/␗＄Ｉ\nlθ＋λ>［␟｜yδ␕\x11;ＷN２␑\n␊",
	}, { // 3675
		mask: EncodeDollar | EncodeRightCrLfHtVt,
		in:   "\\Q＆εχ␉/␗$Ｉ\nlθ＋λ>［␟｜yδ␕\x11;ＷN２␑␊\n",
		out:  "\\Q＆εχ␉/␗＄Ｉ\nlθ＋λ>［␟｜yδ␕\x11;ＷN２␑␊␊",
	}, { // 3676
		mask: EncodeDollar | EncodeRightCrLfHtVt,
		in:   "\\Q＆εχ␉/␗$Ｉ\nlθ＋λ>［␟｜yδ␕\x11;ＷN２␑\n␊",
		out:  "\\Q＆εχ␉/␗＄Ｉ\nlθ＋λ>［␟｜yδ␕\x11;ＷN２␑\n‛␊",
	}, { // 3677
		mask: EncodeDollar | EncodeRightCrLfHtVt,
		in:   "\\Q＆εχ␉/␗$Ｉ\nlθ＋λ>［␟｜yδ␕\x11;ＷN２␑␊␊",
		out:  "\\Q＆εχ␉/␗＄Ｉ\nlθ＋λ>［␟｜yδ␕\x11;ＷN２␑␊‛␊",
	}, { // 3678
		mask: EncodeDollar | EncodeRightCrLfHtVt,
		in:   "\\Q＆εχ␉/␗$Ｉ\nlθ＋λ>［␟｜yδ␕\x11;ＷN２␑φ\n",
		out:  "\\Q＆εχ␉/␗＄Ｉ\nlθ＋λ>［␟｜yδ␕\x11;ＷN２␑φ␊",
	}, { // 3679
		mask: EncodeDollar | EncodeRightCrLfHtVt,
		in:   "\\Q＆εχ␉/␗$Ｉ\nlθ＋λ>［␟｜yδ␕\x11;ＷN２␑φ␊",
		out:  "\\Q＆εχ␉/␗＄Ｉ\nlθ＋λ>［␟｜yδ␕\x11;ＷN２␑φ‛␊",
	}, { // 3680
		mask: EncodeDollar | EncodeRightCrLfHtVt,
		in:   "ｇλ␡5＄␙|\x01ｃ７\vl＇＂␑?\x15ς/bιβχ[\bＰμ[＂\x03",
		out:  "ｇλ␡5‛＄␙|\x01ｃ７\vl＇＂␑?\x15ς/bιβχ[\bＰμ[＂\x03",
	}, { // 3681
		mask: EncodeDollar | EncodeRightCrLfHtVt,
		in:   "\v␋␡5＄␙|\x01ｃ７\vl＇＂␑?\x15ς/bιβχ[\bＰμ[＂\x03",
		out:  "\v␋␡5‛＄␙|\x01ｃ７\vl＇＂␑?\x15ς/bιβχ[\bＰμ[＂\x03",
	}, { // 3682
		mask: EncodeDollar | EncodeRightCrLfHtVt,
		in:   "␋␋␡5＄␙|\x01ｃ７\vl＇＂␑?\x15ς/bιβχ[\bＰμ[＂\x03",
		out:  "␋␋␡5‛＄␙|\x01ｃ７\vl＇＂␑?\x15ς/bιβχ[\bＰμ[＂\x03",
	}, { // 3683
		mask: EncodeDollar | EncodeRightCrLfHtVt,
		in:   "\vλ␡5＄␙|\x01ｃ７\vl＇＂␑?\x15ς/bιβχ[\bＰμ[␋\x03",
		out:  "\vλ␡5‛＄␙|\x01ｃ７\vl＇＂␑?\x15ς/bιβχ[\bＰμ[␋\x03",
	}, { // 3684
		mask: EncodeDollar | EncodeRightCrLfHtVt,
		in:   "␋λ␡5＄␙|\x01ｃ７\vl＇＂␑?\x15ς/bιβχ[\bＰμ[␋\x03",
		out:  "␋λ␡5‛＄␙|\x01ｃ７\vl＇＂␑?\x15ς/bιβχ[\bＰμ[␋\x03",
	}, { // 3685
		mask: EncodeDollar | EncodeRightCrLfHtVt,
		in:   "\vλ␡5＄␙|\x01ｃ７\vl＇＂␑?\x15ς/bιβχ[\bＰμ[＂␋",
		out:  "\vλ␡5‛＄␙|\x01ｃ７\vl＇＂␑?\x15ς/bιβχ[\bＰμ[＂‛␋",
	}, { // 3686
		mask: EncodeDollar | EncodeRightCrLfHtVt,
		in:   "␋λ␡5＄␙|\x01ｃ７\vl＇＂␑?\x15ς/bιβχ[\bＰμ[＂␋",
		out:  "␋λ␡5‛＄␙|\x01ｃ７\vl＇＂␑?\x15ς/bιβχ[\bＰμ[＂‛␋",
	}, { // 3687
		mask: EncodeDollar | EncodeRightCrLfHtVt,
		in:   "ｇ\v␡5＄␙|\x01ｃ７\vl＇＂␑?\x15ς/bιβχ[\bＰμ[＂\x03",
		out:  "ｇ\v␡5‛＄␙|\x01ｃ７\vl＇＂␑?\x15ς/bιβχ[\bＰμ[＂\x03",
	}, { // 3688
		mask: EncodeDollar | EncodeRightCrLfHtVt,
		in:   "ｇ␋␡5＄␙|\x01ｃ７\vl＇＂␑?\x15ς/bιβχ[\bＰμ[＂\x03",
		out:  "ｇ␋␡5‛＄␙|\x01ｃ７\vl＇＂␑?\x15ς/bιβχ[\bＰμ[＂\x03",
	}, { // 3689
		mask: EncodeDollar | EncodeRightCrLfHtVt,
		in:   "ｇ\v␡5＄␙|\x01ｃ７\vl＇＂␑?\x15ς/bιβχ[\bＰμ[␋\x03",
		out:  "ｇ\v␡5‛＄␙|\x01ｃ７\vl＇＂␑?\x15ς/bιβχ[\bＰμ[␋\x03",
	}, { // 3690
		mask: EncodeDollar | EncodeRightCrLfHtVt,
		in:   "ｇ␋␡5＄␙|\x01ｃ７\vl＇＂␑?\x15ς/bιβχ[\bＰμ[␋\x03",
		out:  "ｇ␋␡5‛＄␙|\x01ｃ７\vl＇＂␑?\x15ς/bιβχ[\bＰμ[␋\x03",
	}, { // 3691
		mask: EncodeDollar | EncodeRightCrLfHtVt,
		in:   "ｇ\v␡5＄␙|\x01ｃ７\vl＇＂␑?\x15ς/bιβχ[\bＰμ[＂␋",
		out:  "ｇ\v␡5‛＄␙|\x01ｃ７\vl＇＂␑?\x15ς/bιβχ[\bＰμ[＂‛␋",
	}, { // 3692
		mask: EncodeDollar | EncodeRightCrLfHtVt,
		in:   "ｇ␋␡5＄␙|\x01ｃ７\vl＇＂␑?\x15ς/bιβχ[\bＰμ[＂␋",
		out:  "ｇ␋␡5‛＄␙|\x01ｃ７\vl＇＂␑?\x15ς/bιβχ[\bＰμ[＂‛␋",
	}, { // 3693
		mask: EncodeDollar | EncodeRightCrLfHtVt,
		in:   "ｇλ␡5＄␙|\x01ｃ７\vl＇＂␑?\x15ς/bιβχ[\bＰμ[\v\x03",
		out:  "ｇλ␡5‛＄␙|\x01ｃ７\vl＇＂␑?\x15ς/bιβχ[\bＰμ[\v\x03",
	}, { // 3694
		mask: EncodeDollar | EncodeRightCrLfHtVt,
		in:   "ｇλ␡5＄␙|\x01ｃ７\vl＇＂␑?\x15ς/bιβχ[\bＰμ[␋\x03",
		out:  "ｇλ␡5‛＄␙|\x01ｃ７\vl＇＂␑?\x15ς/bιβχ[\bＰμ[␋\x03",
	}, { // 3695
		mask: EncodeDollar | EncodeRightCrLfHtVt,
		in:   "ｇλ␡5＄␙|\x01ｃ７\vl＇＂␑?\x15ς/bιβχ[\bＰμ[\v␋",
		out:  "ｇλ␡5‛＄␙|\x01ｃ７\vl＇＂␑?\x15ς/bιβχ[\bＰμ[\v‛␋",
	}, { // 3696
		mask: EncodeDollar | EncodeRightCrLfHtVt,
		in:   "ｇλ␡5＄␙|\x01ｃ７\vl＇＂␑?\x15ς/bιβχ[\bＰμ[␋␋",
		out:  "ｇλ␡5‛＄␙|\x01ｃ７\vl＇＂␑?\x15ς/bιβχ[\bＰμ[␋‛␋",
	}, { // 3697
		mask: EncodeDollar | EncodeRightCrLfHtVt,
		in:   "ｇλ␡5＄␙|\x01ｃ７\vl＇＂␑?\x15ς/bιβχ[\bＰμ[＂\v",
		out:  "ｇλ␡5‛＄␙|\x01ｃ７\vl＇＂␑?\x15ς/bιβχ[\bＰμ[＂␋",
	}, { // 3698
		mask: EncodeDollar | EncodeRightCrLfHtVt,
		in:   "ｇλ␡5＄␙|\x01ｃ７\vl＇＂␑?\x15ς/bιβχ[\bＰμ[＂␋",
		out:  "ｇλ␡5‛＄␙|\x01ｃ７\vl＇＂␑?\x15ς/bιβχ[\bＰμ[＂‛␋",
	}, { // 3699
		mask: EncodeDollar | EncodeRightCrLfHtVt,
		in:   "␚！４κ［\x18=｝\x0e？\rχ␑\x1bｚ\b␚␕J~χFＸ\x1cνι\x1fα[5",
		out:  "␚！４κ［\x18=｝\x0e？\rχ␑\x1bｚ\b␚␕J~χFＸ\x1cνι\x1fα[5",
	}, { // 3700
		mask: EncodeDollar | EncodeRightCrLfHtVt,
		in:   "\r␍４κ［\x18=｝\x0e？\rχ␑\x1bｚ\b␚␕J~χFＸ\x1cνι\x1fα[5",
		out:  "\r␍４κ［\x18=｝\x0e？\rχ␑\x1bｚ\b␚␕J~χFＸ\x1cνι\x1fα[5",
	}, { // 3701
		mask: EncodeDollar | EncodeRightCrLfHtVt,
		in:   "␍␍４κ［\x18=｝\x0e？\rχ␑\x1bｚ\b␚␕J~χFＸ\x1cνι\x1fα[5",
		out:  "␍␍４κ［\x18=｝\x0e？\rχ␑\x1bｚ\b␚␕J~χFＸ\x1cνι\x1fα[5",
	}, { // 3702
		mask: EncodeDollar | EncodeRightCrLfHtVt,
		in:   "\r！４κ［\x18=｝\x0e？\rχ␑\x1bｚ\b␚␕J~χFＸ\x1cνι\x1fα␍5",
		out:  "\r！４κ［\x18=｝\x0e？\rχ␑\x1bｚ\b␚␕J~χFＸ\x1cνι\x1fα␍5",
	}, { // 3703
		mask: EncodeDollar | EncodeRightCrLfHtVt,
		in:   "␍！４κ［\x18=｝\x0e？\rχ␑\x1bｚ\b␚␕J~χFＸ\x1cνι\x1fα␍5",
		out:  "␍！４κ［\x18=｝\x0e？\rχ␑\x1bｚ\b␚␕J~χFＸ\x1cνι\x1fα␍5",
	}, { // 3704
		mask: EncodeDollar | EncodeRightCrLfHtVt,
		in:   "\r！４κ［\x18=｝\x0e？\rχ␑\x1bｚ\b␚␕J~χFＸ\x1cνι\x1fα[␍",
		out:  "\r！４κ［\x18=｝\x0e？\rχ␑\x1bｚ\b␚␕J~χFＸ\x1cνι\x1fα[‛␍",
	}, { // 3705
		mask: EncodeDollar | EncodeRightCrLfHtVt,
		in:   "␍！４κ［\x18=｝\x0e？\rχ␑\x1bｚ\b␚␕J~χFＸ\x1cνι\x1fα[␍",
		out:  "␍！４κ［\x18=｝\x0e？\rχ␑\x1bｚ\b␚␕J~χFＸ\x1cνι\x1fα[‛␍",
	}, { // 3706
		mask: EncodeDollar | EncodeRightCrLfHtVt,
		in:   "␚\r４κ［\x18=｝\x0e？\rχ␑\x1bｚ\b␚␕J~χFＸ\x1cνι\x1fα[5",
		out:  "␚\r４κ［\x18=｝\x0e？\rχ␑\x1bｚ\b␚␕J~χFＸ\x1cνι\x1fα[5",
	}, { // 3707
		mask: EncodeDollar | EncodeRightCrLfHtVt,
		in:   "␚␍４κ［\x18=｝\x0e？\rχ␑\x1bｚ\b␚␕J~χFＸ\x1cνι\x1fα[5",
		out:  "␚␍４κ［\x18=｝\x0e？\rχ␑\x1bｚ\b␚␕J~χFＸ\x1cνι\x1fα[5",
	}, { // 3708
		mask: EncodeDollar | EncodeRightCrLfHtVt,
		in:   "␚\r４κ［\x18=｝\x0e？\rχ␑\x1bｚ\b␚␕J~χFＸ\x1cνι\x1fα␍5",
		out:  "␚\r４κ［\x18=｝\x0e？\rχ␑\x1bｚ\b␚␕J~χFＸ\x1cνι\x1fα␍5",
	}, { // 3709
		mask: EncodeDollar | EncodeRightCrLfHtVt,
		in:   "␚␍４κ［\x18=｝\x0e？\rχ␑\x1bｚ\b␚␕J~χFＸ\x1cνι\x1fα␍5",
		out:  "␚␍４κ［\x18=｝\x0e？\rχ␑\x1bｚ\b␚␕J~χFＸ\x1cνι\x1fα␍5",
	}, { // 3710
		mask: EncodeDollar | EncodeRightCrLfHtVt,
		in:   "␚\r４κ［\x18=｝\x0e？\rχ␑\x1bｚ\b␚␕J~χFＸ\x1cνι\x1fα[␍",
		out:  "␚\r４κ［\x18=｝\x0e？\rχ␑\x1bｚ\b␚␕J~χFＸ\x1cνι\x1fα[‛␍",
	}, { // 3711
		mask: EncodeDollar | EncodeRightCrLfHtVt,
		in:   "␚␍４κ［\x18=｝\x0e？\rχ␑\x1bｚ\b␚␕J~χFＸ\x1cνι\x1fα[␍",
		out:  "␚␍４κ［\x18=｝\x0e？\rχ␑\x1bｚ\b␚␕J~χFＸ\x1cνι\x1fα[‛␍",
	}, { // 3712
		mask: EncodeDollar | EncodeRightCrLfHtVt,
		in:   "␚！４κ［\x18=｝\x0e？\rχ␑\x1bｚ\b␚␕J~χFＸ\x1cνι\x1fα\r5",
		out:  "␚！４κ［\x18=｝\x0e？\rχ␑\x1bｚ\b␚␕J~χFＸ\x1cνι\x1fα\r5",
	}, { // 3713
		mask: EncodeDollar | EncodeRightCrLfHtVt,
		in:   "␚！４κ［\x18=｝\x0e？\rχ␑\x1bｚ\b␚␕J~χFＸ\x1cνι\x1fα␍5",
		out:  "␚！４κ［\x18=｝\x0e？\rχ␑\x1bｚ\b␚␕J~χFＸ\x1cνι\x1fα␍5",
	}, { // 3714
		mask: EncodeDollar | EncodeRightCrLfHtVt,
		in:   "␚！４κ［\x18=｝\x0e？\rχ␑\x1bｚ\b␚␕J~χFＸ\x1cνι\x1fα\r␍",
		out:  "␚！４κ［\x18=｝\x0e？\rχ␑\x1bｚ\b␚␕J~χFＸ\x1cνι\x1fα\r‛␍",
	}, { // 3715
		mask: EncodeDollar | EncodeRightCrLfHtVt,
		in:   "␚！４κ［\x18=｝\x0e？\rχ␑\x1bｚ\b␚␕J~χFＸ\x1cνι\x1fα␍␍",
		out:  "␚！４κ［\x18=｝\x0e？\rχ␑\x1bｚ\b␚␕J~χFＸ\x1cνι\x1fα␍‛␍",
	}, { // 3716
		mask: EncodeDollar | EncodeRightCrLfHtVt,
		in:   "␚！４κ［\x18=｝\x0e？\rχ␑\x1bｚ\b␚␕J~χFＸ\x1cνι\x1fα[\r",
		out:  "␚！４κ［\x18=｝\x0e？\rχ␑\x1bｚ\b␚␕J~χFＸ\x1cνι\x1fα[␍",
	}, { // 3717
		mask: EncodeDollar | EncodeRightCrLfHtVt,
		in:   "␚！４κ［\x18=｝\x0e？\rχ␑\x1bｚ\b␚␕J~χFＸ\x1cνι\x1fα[␍",
		out:  "␚！４κ［\x18=｝\x0e？\rχ␑\x1bｚ\b␚␕J~χFＸ\x1cνι\x1fα[‛␍",
	}, { // 3718
		mask: EncodeDoubleQuote | EncodeRightCrLfHtVt,
		in:   "＜ιＡζ;\x1d'？A␓\tγ#␈Ｚ0ＳＴ?ｊ\x15＼＄：β`φ\x17cω",
		out:  "＜ιＡζ;\x1d'？A␓\tγ#␈Ｚ0ＳＴ?ｊ\x15＼＄：β`φ\x17cω",
	}, { // 3719
		mask: EncodeDoubleQuote | EncodeRightCrLfHtVt,
		in:   "\t␉Ａζ;\x1d'？A␓\tγ#␈Ｚ0ＳＴ?ｊ\x15＼＄：β`φ\x17cω",
		out:  "\t␉Ａζ;\x1d'？A␓\tγ#␈Ｚ0ＳＴ?ｊ\x15＼＄：β`φ\x17cω",
	}, { // 3720
		mask: EncodeDoubleQuote | EncodeRightCrLfHtVt,
		in:   "␉␉Ａζ;\x1d'？A␓\tγ#␈Ｚ0ＳＴ?ｊ\x15＼＄：β`φ\x17cω",
		out:  "␉␉Ａζ;\x1d'？A␓\tγ#␈Ｚ0ＳＴ?ｊ\x15＼＄：β`φ\x17cω",
	}, { // 3721
		mask: EncodeDoubleQuote | EncodeRightCrLfHtVt,
		in:   "\tιＡζ;\x1d'？A␓\tγ#␈Ｚ0ＳＴ?ｊ\x15＼＄：β`φ\x17␉ω",
		out:  "\tιＡζ;\x1d'？A␓\tγ#␈Ｚ0ＳＴ?ｊ\x15＼＄：β`φ\x17␉ω",
	}, { // 3722
		mask: EncodeDoubleQuote | EncodeRightCrLfHtVt,
		in:   "␉ιＡζ;\x1d'？A␓\tγ#␈Ｚ0ＳＴ?ｊ\x15＼＄：β`φ\x17␉ω",
		out:  "␉ιＡζ;\x1d'？A␓\tγ#␈Ｚ0ＳＴ?ｊ\x15＼＄：β`φ\x17␉ω",
	}, { // 3723
		mask: EncodeDoubleQuote | EncodeRightCrLfHtVt,
		in:   "\tιＡζ;\x1d'？A␓\tγ#␈Ｚ0ＳＴ?ｊ\x15＼＄：β`φ\x17c␉",
		out:  "\tιＡζ;\x1d'？A␓\tγ#␈Ｚ0ＳＴ?ｊ\x15＼＄：β`φ\x17c‛␉",
	}, { // 3724
		mask: EncodeDoubleQuote | EncodeRightCrLfHtVt,
		in:   "␉ιＡζ;\x1d'？A␓\tγ#␈Ｚ0ＳＴ?ｊ\x15＼＄：β`φ\x17c␉",
		out:  "␉ιＡζ;\x1d'？A␓\tγ#␈Ｚ0ＳＴ?ｊ\x15＼＄：β`φ\x17c‛␉",
	}, { // 3725
		mask: EncodeDoubleQuote | EncodeRightCrLfHtVt,
		in:   "＜\tＡζ;\x1d'？A␓\tγ#␈Ｚ0ＳＴ?ｊ\x15＼＄：β`φ\x17cω",
		out:  "＜\tＡζ;\x1d'？A␓\tγ#␈Ｚ0ＳＴ?ｊ\x15＼＄：β`φ\x17cω",
	}, { // 3726
		mask: EncodeDoubleQuote | EncodeRightCrLfHtVt,
		in:   "＜␉Ａζ;\x1d'？A␓\tγ#␈Ｚ0ＳＴ?ｊ\x15＼＄：β`φ\x17cω",
		out:  "＜␉Ａζ;\x1d'？A␓\tγ#␈Ｚ0ＳＴ?ｊ\x15＼＄：β`φ\x17cω",
	}, { // 3727
		mask: EncodeDoubleQuote | EncodeRightCrLfHtVt,
		in:   "＜\tＡζ;\x1d'？A␓\tγ#␈Ｚ0ＳＴ?ｊ\x15＼＄：β`φ\x17␉ω",
		out:  "＜\tＡζ;\x1d'？A␓\tγ#␈Ｚ0ＳＴ?ｊ\x15＼＄：β`φ\x17␉ω",
	}, { // 3728
		mask: EncodeDoubleQuote | EncodeRightCrLfHtVt,
		in:   "＜␉Ａζ;\x1d'？A␓\tγ#␈Ｚ0ＳＴ?ｊ\x15＼＄：β`φ\x17␉ω",
		out:  "＜␉Ａζ;\x1d'？A␓\tγ#␈Ｚ0ＳＴ?ｊ\x15＼＄：β`φ\x17␉ω",
	}, { // 3729
		mask: EncodeDoubleQuote | EncodeRightCrLfHtVt,
		in:   "＜\tＡζ;\x1d'？A␓\tγ#␈Ｚ0ＳＴ?ｊ\x15＼＄：β`φ\x17c␉",
		out:  "＜\tＡζ;\x1d'？A␓\tγ#␈Ｚ0ＳＴ?ｊ\x15＼＄：β`φ\x17c‛␉",
	}, { // 3730
		mask: EncodeDoubleQuote | EncodeRightCrLfHtVt,
		in:   "＜␉Ａζ;\x1d'？A␓\tγ#␈Ｚ0ＳＴ?ｊ\x15＼＄：β`φ\x17c␉",
		out:  "＜␉Ａζ;\x1d'？A␓\tγ#␈Ｚ0ＳＴ?ｊ\x15＼＄：β`φ\x17c‛␉",
	}, { // 3731
		mask: EncodeDoubleQuote | EncodeRightCrLfHtVt,
		in:   "＜ιＡζ;\x1d'？A␓\tγ#␈Ｚ0ＳＴ?ｊ\x15＼＄：β`φ\x17\tω",
		out:  "＜ιＡζ;\x1d'？A␓\tγ#␈Ｚ0ＳＴ?ｊ\x15＼＄：β`φ\x17\tω",
	}, { // 3732
		mask: EncodeDoubleQuote | EncodeRightCrLfHtVt,
		in:   "＜ιＡζ;\x1d'？A␓\tγ#␈Ｚ0ＳＴ?ｊ\x15＼＄：β`φ\x17␉ω",
		out:  "＜ιＡζ;\x1d'？A␓\tγ#␈Ｚ0ＳＴ?ｊ\x15＼＄：β`φ\x17␉ω",
	}, { // 3733
		mask: EncodeDoubleQuote | EncodeRightCrLfHtVt,
		in:   "＜ιＡζ;\x1d'？A␓\tγ#␈Ｚ0ＳＴ?ｊ\x15＼＄：β`φ\x17\t␉",
		out:  "＜ιＡζ;\x1d'？A␓\tγ#␈Ｚ0ＳＴ?ｊ\x15＼＄：β`φ\x17\t‛␉",
	}, { // 3734
		mask: EncodeDoubleQuote | EncodeRightCrLfHtVt,
		in:   "＜ιＡζ;\x1d'？A␓\tγ#␈Ｚ0ＳＴ?ｊ\x15＼＄：β`φ\x17␉␉",
		out:  "＜ιＡζ;\x1d'？A␓\tγ#␈Ｚ0ＳＴ?ｊ\x15＼＄：β`φ\x17␉‛␉",
	}, { // 3735
		mask: EncodeDoubleQuote | EncodeRightCrLfHtVt,
		in:   "＜ιＡζ;\x1d'？A␓\tγ#␈Ｚ0ＳＴ?ｊ\x15＼＄：β`φ\x17c\t",
		out:  "＜ιＡζ;\x1d'？A␓\tγ#␈Ｚ0ＳＴ?ｊ\x15＼＄：β`φ\x17c␉",
	}, { // 3736
		mask: EncodeDoubleQuote | EncodeRightCrLfHtVt,
		in:   "＜ιＡζ;\x1d'？A␓\tγ#␈Ｚ0ＳＴ?ｊ\x15＼＄：β`φ\x17c␉",
		out:  "＜ιＡζ;\x1d'？A␓\tγ#␈Ｚ0ＳＴ?ｊ\x15＼＄：β`φ\x17c‛␉",
	}, { // 3737
		mask: EncodeDoubleQuote | EncodeRightCrLfHtVt,
		in:   "Ｓ␓\x18\t␌＿*υRｂ\n␊^％h\x17ν␅␕ι//ι；@␘８ζ\a+",
		out:  "Ｓ␓\x18\t␌＿*υRｂ\n␊^％h\x17ν␅␕ι//ι；@␘８ζ\a+",
	}, { // 3738
		mask: EncodeDoubleQuote | EncodeRightCrLfHtVt,
		in:   "\n␊\x18\t␌＿*υRｂ\n␊^％h\x17ν␅␕ι//ι；@␘８ζ\a+",
		out:  "\n␊\x18\t␌＿*υRｂ\n␊^％h\x17ν␅␕ι//ι；@␘８ζ\a+",
	}, { // 3739
		mask: EncodeDoubleQuote | EncodeRightCrLfHtVt,
		in:   "␊␊\x18\t␌＿*υRｂ\n␊^％h\x17ν␅␕ι//ι；@␘８ζ\a+",
		out:  "␊␊\x18\t␌＿*υRｂ\n␊^％h\x17ν␅␕ι//ι；@␘８ζ\a+",
	}, { // 3740
		mask: EncodeDoubleQuote | EncodeRightCrLfHtVt,
		in:   "\n␓\x18\t␌＿*υRｂ\n␊^％h\x17ν␅␕ι//ι；@␘８ζ␊+",
		out:  "\n␓\x18\t␌＿*υRｂ\n␊^％h\x17ν␅␕ι//ι；@␘８ζ␊+",
	}, { // 3741
		mask: EncodeDoubleQuote | EncodeRightCrLfHtVt,
		in:   "␊␓\x18\t␌＿*υRｂ\n␊^％h\x17ν␅␕ι//ι；@␘８ζ␊+",
		out:  "␊␓\x18\t␌＿*υRｂ\n␊^％h\x17ν␅␕ι//ι；@␘８ζ␊+",
	}, { // 3742
		mask: EncodeDoubleQuote | EncodeRightCrLfHtVt,
		in:   "\n␓\x18\t␌＿*υRｂ\n␊^％h\x17ν␅␕ι//ι；@␘８ζ\a␊",
		out:  "\n␓\x18\t␌＿*υRｂ\n␊^％h\x17ν␅␕ι//ι；@␘８ζ\a‛␊",
	}, { // 3743
		mask: EncodeDoubleQuote | EncodeRightCrLfHtVt,
		in:   "␊␓\x18\t␌＿*υRｂ\n␊^％h\x17ν␅␕ι//ι；@␘８ζ\a␊",
		out:  "␊␓\x18\t␌＿*υRｂ\n␊^％h\x17ν␅␕ι//ι；@␘８ζ\a‛␊",
	}, { // 3744
		mask: EncodeDoubleQuote | EncodeRightCrLfHtVt,
		in:   "Ｓ\n\x18\t␌＿*υRｂ\n␊^％h\x17ν␅␕ι//ι；@␘８ζ\a+",
		out:  "Ｓ\n\x18\t␌＿*υRｂ\n␊^％h\x17ν␅␕ι//ι；@␘８ζ\a+",
	}, { // 3745
		mask: EncodeDoubleQuote | EncodeRightCrLfHtVt,
		in:   "Ｓ␊\x18\t␌＿*υRｂ\n␊^％h\x17ν␅␕ι//ι；@␘８ζ\a+",
		out:  "Ｓ␊\x18\t␌＿*υRｂ\n␊^％h\x17ν␅␕ι//ι；@␘８ζ\a+",
	}, { // 3746
		mask: EncodeDoubleQuote | EncodeRightCrLfHtVt,
		in:   "Ｓ\n\x18\t␌＿*υRｂ\n␊^％h\x17ν␅␕ι//ι；@␘８ζ␊+",
		out:  "Ｓ\n\x18\t␌＿*υRｂ\n␊^％h\x17ν␅␕ι//ι；@␘８ζ␊+",
	}, { // 3747
		mask: EncodeDoubleQuote | EncodeRightCrLfHtVt,
		in:   "Ｓ␊\x18\t␌＿*υRｂ\n␊^％h\x17ν␅␕ι//ι；@␘８ζ␊+",
		out:  "Ｓ␊\x18\t␌＿*υRｂ\n␊^％h\x17ν␅␕ι//ι；@␘８ζ␊+",
	}, { // 3748
		mask: EncodeDoubleQuote | EncodeRightCrLfHtVt,
		in:   "Ｓ\n\x18\t␌＿*υRｂ\n␊^％h\x17ν␅␕ι//ι；@␘８ζ\a␊",
		out:  "Ｓ\n\x18\t␌＿*υRｂ\n␊^％h\x17ν␅␕ι//ι；@␘８ζ\a‛␊",
	}, { // 3749
		mask: EncodeDoubleQuote | EncodeRightCrLfHtVt,
		in:   "Ｓ␊\x18\t␌＿*υRｂ\n␊^％h\x17ν␅␕ι//ι；@␘８ζ\a␊",
		out:  "Ｓ␊\x18\t␌＿*υRｂ\n␊^％h\x17ν␅␕ι//ι；@␘８ζ\a‛␊",
	}, { // 3750
		mask: EncodeDoubleQuote | EncodeRightCrLfHtVt,
		in:   "Ｓ␓\x18\t␌＿*υRｂ\n␊^％h\x17ν␅␕ι//ι；@␘８ζ\n+",
		out:  "Ｓ␓\x18\t␌＿*υRｂ\n␊^％h\x17ν␅␕ι//ι；@␘８ζ\n+",
	}, { // 3751
		mask: EncodeDoubleQuote | EncodeRightCrLfHtVt,
		in:   "Ｓ␓\x18\t␌＿*υRｂ\n␊^％h\x17ν␅␕ι//ι；@␘８ζ␊+",
		out:  "Ｓ␓\x18\t␌＿*υRｂ\n␊^％h\x17ν␅␕ι//ι；@␘８ζ␊+",
	}, { // 3752
		mask: EncodeDoubleQuote | EncodeRightCrLfHtVt,
		in:   "Ｓ␓\x18\t␌＿*υRｂ\n␊^％h\x17ν␅␕ι//ι；@␘８ζ\n␊",
		out:  "Ｓ␓\x18\t␌＿*υRｂ\n␊^％h\x17ν␅␕ι//ι；@␘８ζ\n‛␊",
	}, { // 3753
		mask: EncodeDoubleQuote | EncodeRightCrLfHtVt,
		in:   "Ｓ␓\x18\t␌＿*υRｂ\n␊^％h\x17ν␅␕ι//ι；@␘８ζ␊␊",
		out:  "Ｓ␓\x18\t␌＿*υRｂ\n␊^％h\x17ν␅␕ι//ι；@␘８ζ␊‛␊",
	}, { // 3754
		mask: EncodeDoubleQuote | EncodeRightCrLfHtVt,
		in:   "Ｓ␓\x18\t␌＿*υRｂ\n␊^％h\x17ν␅␕ι//ι；@␘８ζ\a\n",
		out:  "Ｓ␓\x18\t␌＿*υRｂ\n␊^％h\x17ν␅␕ι//ι；@␘８ζ\a␊",
	}, { // 3755
		mask: EncodeDoubleQuote | EncodeRightCrLfHtVt,
		in:   "Ｓ␓\x18\t␌＿*υRｂ\n␊^％h\x17ν␅␕ι//ι；@␘８ζ\a␊",
		out:  "Ｓ␓\x18\t␌＿*υRｂ\n␊^％h\x17ν␅␕ι//ι；@␘８ζ\a‛␊",
	}, { // 3756
		mask: EncodeDoubleQuote | EncodeRightCrLfHtVt,
		in:   "４δs：\x14\b\nα\x1b`\vσω␕）Ｑυu␒［Jdｗ%ｓ␟o␏！ψ",
		out:  "４δs：\x14\b\nα\x1b`\vσω␕）Ｑυu␒［Jdｗ%ｓ␟o␏！ψ",
	}, { // 3757
		mask: EncodeDoubleQuote | EncodeRightCrLfHtVt,
		in:   "\v␋s：\x14\b\nα\x1b`\vσω␕）Ｑυu␒［Jdｗ%ｓ␟o␏！ψ",
		out:  "\v␋s：\x14\b\nα\x1b`\vσω␕）Ｑυu␒［Jdｗ%ｓ␟o␏！ψ",
	}, { // 3758
		mask: EncodeDoubleQuote | EncodeRightCrLfHtVt,
		in:   "␋␋s：\x14\b\nα\x1b`\vσω␕）Ｑυu␒［Jdｗ%ｓ␟o␏！ψ",
		out:  "␋␋s：\x14\b\nα\x1b`\vσω␕）Ｑυu␒［Jdｗ%ｓ␟o␏！ψ",
	}, { // 3759
		mask: EncodeDoubleQuote | EncodeRightCrLfHtVt,
		in:   "\vδs：\x14\b\nα\x1b`\vσω␕）Ｑυu␒［Jdｗ%ｓ␟o␏␋ψ",
		out:  "\vδs：\x14\b\nα\x1b`\vσω␕）Ｑυu␒［Jdｗ%ｓ␟o␏␋ψ",
	}, { // 3760
		mask: EncodeDoubleQuote | EncodeRightCrLfHtVt,
		in:   "␋δs：\x14\b\nα\x1b`\vσω␕）Ｑυu␒［Jdｗ%ｓ␟o␏␋ψ",
		out:  "␋δs：\x14\b\nα\x1b`\vσω␕）Ｑυu␒［Jdｗ%ｓ␟o␏␋ψ",
	}, { // 3761
		mask: EncodeDoubleQuote | EncodeRightCrLfHtVt,
		in:   "\vδs：\x14\b\nα\x1b`\vσω␕）Ｑυu␒［Jdｗ%ｓ␟o␏！␋",
		out:  "\vδs：\x14\b\nα\x1b`\vσω␕）Ｑυu␒［Jdｗ%ｓ␟o␏！‛␋",
	}, { // 3762
		mask: EncodeDoubleQuote | EncodeRightCrLfHtVt,
		in:   "␋δs：\x14\b\nα\x1b`\vσω␕）Ｑυu␒［Jdｗ%ｓ␟o␏！␋",
		out:  "␋δs：\x14\b\nα\x1b`\vσω␕）Ｑυu␒［Jdｗ%ｓ␟o␏！‛␋",
	}, { // 3763
		mask: EncodeDoubleQuote | EncodeRightCrLfHtVt,
		in:   "４\vs：\x14\b\nα\x1b`\vσω␕）Ｑυu␒［Jdｗ%ｓ␟o␏！ψ",
		out:  "４\vs：\x14\b\nα\x1b`\vσω␕）Ｑυu␒［Jdｗ%ｓ␟o␏！ψ",
	}, { // 3764
		mask: EncodeDoubleQuote | EncodeRightCrLfHtVt,
		in:   "４␋s：\x14\b\nα\x1b`\vσω␕）Ｑυu␒［Jdｗ%ｓ␟o␏！ψ",
		out:  "４␋s：\x14\b\nα\x1b`\vσω␕）Ｑυu␒［Jdｗ%ｓ␟o␏！ψ",
	}, { // 3765
		mask: EncodeDoubleQuote | EncodeRightCrLfHtVt,
		in:   "４\vs：\x14\b\nα\x1b`\vσω␕）Ｑυu␒［Jdｗ%ｓ␟o␏␋ψ",
		out:  "４\vs：\x14\b\nα\x1b`\vσω␕）Ｑυu␒［Jdｗ%ｓ␟o␏␋ψ",
	}, { // 3766
		mask: EncodeDoubleQuote | EncodeRightCrLfHtVt,
		in:   "４␋s：\x14\b\nα\x1b`\vσω␕）Ｑυu␒［Jdｗ%ｓ␟o␏␋ψ",
		out:  "４␋s：\x14\b\nα\x1b`\vσω␕）Ｑυu␒［Jdｗ%ｓ␟o␏␋ψ",
	}, { // 3767
		mask: EncodeDoubleQuote | EncodeRightCrLfHtVt,
		in:   "４\vs：\x14\b\nα\x1b`\vσω␕）Ｑυu␒［Jdｗ%ｓ␟o␏！␋",
		out:  "４\vs：\x14\b\nα\x1b`\vσω␕）Ｑυu␒［Jdｗ%ｓ␟o␏！‛␋",
	}, { // 3768
		mask: EncodeDoubleQuote | EncodeRightCrLfHtVt,
		in:   "４␋s：\x14\b\nα\x1b`\vσω␕）Ｑυu␒［Jdｗ%ｓ␟o␏！␋",
		out:  "４␋s：\x14\b\nα\x1b`\vσω␕）Ｑυu␒［Jdｗ%ｓ␟o␏！‛␋",
	}, { // 3769
		mask: EncodeDoubleQuote | EncodeRightCrLfHtVt,
		in:   "４δs：\x14\b\nα\x1b`\vσω␕）Ｑυu␒［Jdｗ%ｓ␟o␏\vψ",
		out:  "４δs：\x14\b\nα\x1b`\vσω␕）Ｑυu␒［Jdｗ%ｓ␟o␏\vψ",
	}, { // 3770
		mask: EncodeDoubleQuote | EncodeRightCrLfHtVt,
		in:   "４δs：\x14\b\nα\x1b`\vσω␕）Ｑυu␒［Jdｗ%ｓ␟o␏␋ψ",
		out:  "４δs：\x14\b\nα\x1b`\vσω␕）Ｑυu␒［Jdｗ%ｓ␟o␏␋ψ",
	}, { // 3771
		mask: EncodeDoubleQuote | EncodeRightCrLfHtVt,
		in:   "４δs：\x14\b\nα\x1b`\vσω␕）Ｑυu␒［Jdｗ%ｓ␟o␏\v␋",
		out:  "４δs：\x14\b\nα\x1b`\vσω␕）Ｑυu␒［Jdｗ%ｓ␟o␏\v‛␋",
	}, { // 3772
		mask: EncodeDoubleQuote | EncodeRightCrLfHtVt,
		in:   "４δs：\x14\b\nα\x1b`\vσω␕）Ｑυu␒［Jdｗ%ｓ␟o␏␋␋",
		out:  "４δs：\x14\b\nα\x1b`\vσω␕）Ｑυu␒［Jdｗ%ｓ␟o␏␋‛␋",
	}, { // 3773
		mask: EncodeDoubleQuote | EncodeRightCrLfHtVt,
		in:   "４δs：\x14\b\nα\x1b`\vσω␕）Ｑυu␒［Jdｗ%ｓ␟o␏！\v",
		out:  "４δs：\x14\b\nα\x1b`\vσω␕）Ｑυu␒［Jdｗ%ｓ␟o␏！␋",
	}, { // 3774
		mask: EncodeDoubleQuote | EncodeRightCrLfHtVt,
		in:   "４δs：\x14\b\nα\x1b`\vσω␕）Ｑυu␒［Jdｗ%ｓ␟o␏！␋",
		out:  "４δs：\x14\b\nα\x1b`\vσω␕）Ｑυu␒［Jdｗ%ｓ␟o␏！‛␋",
	}, { // 3775
		mask: EncodeDoubleQuote | EncodeRightCrLfHtVt,
		in:   "［.␋\x1e?\x02χK␍\r\r\x00８␡ε&τζο3\x0eπａ␊␚ｄ＂C｛␒",
		out:  "［.␋\x1e?\x02χK␍\r\r␀８␡ε&τζο3\x0eπａ␊␚ｄ‛＂C｛␒",
	}, { // 3776
		mask: EncodeDoubleQuote | EncodeRightCrLfHtVt,
		in:   "\r␍␋\x1e?\x02χK␍\r\r\x00８␡ε&τζο3\x0eπａ␊␚ｄ＂C｛␒",
		out:  "\r␍␋\x1e?\x02χK␍\r\r␀８␡ε&τζο3\x0eπａ␊␚ｄ‛＂C｛␒",
	}, { // 3777
		mask: EncodeDoubleQuote | EncodeRightCrLfHtVt,
		in:   "␍␍␋\x1e?\x02χK␍\r\r\x00８␡ε&τζο3\x0eπａ␊␚ｄ＂C｛␒",
		out:  "␍␍␋\x1e?\x02χK␍\r\r␀８␡ε&τζο3\x0eπａ␊␚ｄ‛＂C｛␒",
	}, { // 3778
		mask: EncodeDoubleQuote | EncodeRightCrLfHtVt,
		in:   "\r.␋\x1e?\x02χK␍\r\r\x00８␡ε&τζο3\x0eπａ␊␚ｄ＂C␍␒",
		out:  "\r.␋\x1e?\x02χK␍\r\r␀８␡ε&τζο3\x0eπａ␊␚ｄ‛＂C␍␒",
	}, { // 3779
		mask: EncodeDoubleQuote | EncodeRightCrLfHtVt,
		in:   "␍.␋\x1e?\x02χK␍\r\r\x00８␡ε&τζο3\x0eπａ␊␚ｄ＂C␍␒",
		out:  "␍.␋\x1e?\x02χK␍\r\r␀８␡ε&τζο3\x0eπａ␊␚ｄ‛＂C␍␒",
	}, { // 3780
		mask: EncodeDoubleQuote | EncodeRightCrLfHtVt,
		in:   "\r.␋\x1e?\x02χK␍\r\r\x00８␡ε&τζο3\x0eπａ␊␚ｄ＂C｛␍",
		out:  "\r.␋\x1e?\x02χK␍\r\r␀８␡ε&τζο3\x0eπａ␊␚ｄ‛＂C｛‛␍",
	}, { // 3781
		mask: EncodeDoubleQuote | EncodeRightCrLfHtVt,
		in:   "␍.␋\x1e?\x02χK␍\r\r\x00８␡ε&τζο3\x0eπａ␊␚ｄ＂C｛␍",
		out:  "␍.␋\x1e?\x02χK␍\r\r␀８␡ε&τζο3\x0eπａ␊␚ｄ‛＂C｛‛␍",
	}, { // 3782
		mask: EncodeDoubleQuote | EncodeRightCrLfHtVt,
		in:   "［\r␋\x1e?\x02χK␍\r\r\x00８␡ε&τζο3\x0eπａ␊␚ｄ＂C｛␒",
		out:  "［\r␋\x1e?\x02χK␍\r\r␀８␡ε&τζο3\x0eπａ␊␚ｄ‛＂C｛␒",
	}, { // 3783
		mask: EncodeDoubleQuote | EncodeRightCrLfHtVt,
		in:   "［␍␋\x1e?\x02χK␍\r\r\x00８␡ε&τζο3\x0eπａ␊␚ｄ＂C｛␒",
		out:  "［␍␋\x1e?\x02χK␍\r\r␀８␡ε&τζο3\x0eπａ␊␚ｄ‛＂C｛␒",
	}, { // 3784
		mask: EncodeDoubleQuote | EncodeRightCrLfHtVt,
		in:   "［\r␋\x1e?\x02χK␍\r\r\x00８␡ε&τζο3\x0eπａ␊␚ｄ＂C␍␒",
		out:  "［\r␋\x1e?\x02χK␍\r\r␀８␡ε&τζο3\x0eπａ␊␚ｄ‛＂C␍␒",
	}, { // 3785
		mask: EncodeDoubleQuote | EncodeRightCrLfHtVt,
		in:   "［␍␋\x1e?\x02χK␍\r\r\x00８␡ε&τζο3\x0eπａ␊␚ｄ＂C␍␒",
		out:  "［␍␋\x1e?\x02χK␍\r\r␀８␡ε&τζο3\x0eπａ␊␚ｄ‛＂C␍␒",
	}, { // 3786
		mask: EncodeDoubleQuote | EncodeRightCrLfHtVt,
		in:   "［\r␋\x1e?\x02χK␍\r\r\x00８␡ε&τζο3\x0eπａ␊␚ｄ＂C｛␍",
		out:  "［\r␋\x1e?\x02χK␍\r\r␀８␡ε&τζο3\x0eπａ␊␚ｄ‛＂C｛‛␍",
	}, { // 3787
		mask: EncodeDoubleQuote | EncodeRightCrLfHtVt,
		in:   "［␍␋\x1e?\x02χK␍\r\r\x00８␡ε&τζο3\x0eπａ␊␚ｄ＂C｛␍",
		out:  "［␍␋\x1e?\x02χK␍\r\r␀８␡ε&τζο3\x0eπａ␊␚ｄ‛＂C｛‛␍",
	}, { // 3788
		mask: EncodeDoubleQuote | EncodeRightCrLfHtVt,
		in:   "［.␋\x1e?\x02χK␍\r\r\x00８␡ε&τζο3\x0eπａ␊␚ｄ＂C\r␒",
		out:  "［.␋\x1e?\x02χK␍\r\r␀８␡ε&τζο3\x0eπａ␊␚ｄ‛＂C\r␒",
	}, { // 3789
		mask: EncodeDoubleQuote | EncodeRightCrLfHtVt,
		in:   "［.␋\x1e?\x02χK␍\r\r\x00８␡ε&τζο3\x0eπａ␊␚ｄ＂C␍␒",
		out:  "［.␋\x1e?\x02χK␍\r\r␀８␡ε&τζο3\x0eπａ␊␚ｄ‛＂C␍␒",
	}, { // 3790
		mask: EncodeDoubleQuote | EncodeRightCrLfHtVt,
		in:   "［.␋\x1e?\x02χK␍\r\r\x00８␡ε&τζο3\x0eπａ␊␚ｄ＂C\r␍",
		out:  "［.␋\x1e?\x02χK␍\r\r␀８␡ε&τζο3\x0eπａ␊␚ｄ‛＂C\r‛␍",
	}, { // 3791
		mask: EncodeDoubleQuote | EncodeRightCrLfHtVt,
		in:   "［.␋\x1e?\x02χK␍\r\r\x00８␡ε&τζο3\x0eπａ␊␚ｄ＂C␍␍",
		out:  "［.␋\x1e?\x02χK␍\r\r␀８␡ε&τζο3\x0eπａ␊␚ｄ‛＂C␍‛␍",
	}, { // 3792
		mask: EncodeDoubleQuote | EncodeRightCrLfHtVt,
		in:   "［.␋\x1e?\x02χK␍\r\r\x00８␡ε&τζο3\x0eπａ␊␚ｄ＂C｛\r",
		out:  "［.␋\x1e?\x02χK␍\r\r␀８␡ε&τζο3\x0eπａ␊␚ｄ‛＂C｛␍",
	}, { // 3793
		mask: EncodeDoubleQuote | EncodeRightCrLfHtVt,
		in:   "［.␋\x1e?\x02χK␍\r\r\x00８␡ε&τζο3\x0eπａ␊␚ｄ＂C｛␍",
		out:  "［.␋\x1e?\x02χK␍\r\r␀８␡ε&τζο3\x0eπａ␊␚ｄ‛＂C｛‛␍",
	}, { // 3794
		mask: EncodeColon | EncodeRightCrLfHtVt,
		in:   "DςUr␝;␉\x19␓␀\tδλ$ｕＮ7/ψＤ９\x0e\x1c#*␛ＳＨβδ",
		out:  "DςUr␝;␉\x19␓‛␀\tδλ$ｕＮ7/ψＤ９\x0e\x1c#*␛ＳＨβδ",
	}, { // 3795
		mask: EncodeColon | EncodeRightCrLfHtVt,
		in:   "\t␉Ur␝;␉\x19␓␀\tδλ$ｕＮ7/ψＤ９\x0e\x1c#*␛ＳＨβδ",
		out:  "\t␉Ur␝;␉\x19␓‛␀\tδλ$ｕＮ7/ψＤ９\x0e\x1c#*␛ＳＨβδ",
	}, { // 3796
		mask: EncodeColon | EncodeRightCrLfHtVt,
		in:   "␉␉Ur␝;␉\x19␓␀\tδλ$ｕＮ7/ψＤ９\x0e\x1c#*␛ＳＨβδ",
		out:  "␉␉Ur␝;␉\x19␓‛␀\tδλ$ｕＮ7/ψＤ９\x0e\x1c#*␛ＳＨβδ",
	}, { // 3797
		mask: EncodeColon | EncodeRightCrLfHtVt,
		in:   "\tςUr␝;␉\x19␓␀\tδλ$ｕＮ7/ψＤ９\x0e\x1c#*␛ＳＨ␉δ",
		out:  "\tςUr␝;␉\x19␓‛␀\tδλ$ｕＮ7/ψＤ９\x0e\x1c#*␛ＳＨ␉δ",
	}, { // 3798
		mask: EncodeColon | EncodeRightCrLfHtVt,
		in:   "␉ςUr␝;␉\x19␓␀\tδλ$ｕＮ7/ψＤ９\x0e\x1c#*␛ＳＨ␉δ",
		out:  "␉ςUr␝;␉\x19␓‛␀\tδλ$ｕＮ7/ψＤ９\x0e\x1c#*␛ＳＨ␉δ",
	}, { // 3799
		mask: EncodeColon | EncodeRightCrLfHtVt,
		in:   "\tςUr␝;␉\x19␓␀\tδλ$ｕＮ7/ψＤ９\x0e\x1c#*␛ＳＨβ␉",
		out:  "\tςUr␝;␉\x19␓‛␀\tδλ$ｕＮ7/ψＤ９\x0e\x1c#*␛ＳＨβ‛␉",
	}, { // 3800
		mask: EncodeColon | EncodeRightCrLfHtVt,
		in:   "␉ςUr␝;␉\x19␓␀\tδλ$ｕＮ7/ψＤ９\x0e\x1c#*␛ＳＨβ␉",
		out:  "␉ςUr␝;␉\x19␓‛␀\tδλ$ｕＮ7/ψＤ９\x0e\x1c#*␛ＳＨβ‛␉",
	}, { // 3801
		mask: EncodeColon | EncodeRightCrLfHtVt,
		in:   "D\tUr␝;␉\x19␓␀\tδλ$ｕＮ7/ψＤ９\x0e\x1c#*␛ＳＨβδ",
		out:  "D\tUr␝;␉\x19␓‛␀\tδλ$ｕＮ7/ψＤ９\x0e\x1c#*␛ＳＨβδ",
	}, { // 3802
		mask: EncodeColon | EncodeRightCrLfHtVt,
		in:   "D␉Ur␝;␉\x19␓␀\tδλ$ｕＮ7/ψＤ９\x0e\x1c#*␛ＳＨβδ",
		out:  "D␉Ur␝;␉\x19␓‛␀\tδλ$ｕＮ7/ψＤ９\x0e\x1c#*␛ＳＨβδ",
	}, { // 3803
		mask: EncodeColon | EncodeRightCrLfHtVt,
		in:   "D\tUr␝;␉\x19␓␀\tδλ$ｕＮ7/ψＤ９\x0e\x1c#*␛ＳＨ␉δ",
		out:  "D\tUr␝;␉\x19␓‛␀\tδλ$ｕＮ7/ψＤ９\x0e\x1c#*␛ＳＨ␉δ",
	}, { // 3804
		mask: EncodeColon | EncodeRightCrLfHtVt,
		in:   "D␉Ur␝;␉\x19␓␀\tδλ$ｕＮ7/ψＤ９\x0e\x1c#*␛ＳＨ␉δ",
		out:  "D␉Ur␝;␉\x19␓‛␀\tδλ$ｕＮ7/ψＤ９\x0e\x1c#*␛ＳＨ␉δ",
	}, { // 3805
		mask: EncodeColon | EncodeRightCrLfHtVt,
		in:   "D\tUr␝;␉\x19␓␀\tδλ$ｕＮ7/ψＤ９\x0e\x1c#*␛ＳＨβ␉",
		out:  "D\tUr␝;␉\x19␓‛␀\tδλ$ｕＮ7/ψＤ９\x0e\x1c#*␛ＳＨβ‛␉",
	}, { // 3806
		mask: EncodeColon | EncodeRightCrLfHtVt,
		in:   "D␉Ur␝;␉\x19␓␀\tδλ$ｕＮ7/ψＤ９\x0e\x1c#*␛ＳＨβ␉",
		out:  "D␉Ur␝;␉\x19␓‛␀\tδλ$ｕＮ7/ψＤ９\x0e\x1c#*␛ＳＨβ‛␉",
	}, { // 3807
		mask: EncodeColon | EncodeRightCrLfHtVt,
		in:   "DςUr␝;␉\x19␓␀\tδλ$ｕＮ7/ψＤ９\x0e\x1c#*␛ＳＨ\tδ",
		out:  "DςUr␝;␉\x19␓‛␀\tδλ$ｕＮ7/ψＤ９\x0e\x1c#*␛ＳＨ\tδ",
	}, { // 3808
		mask: EncodeColon | EncodeRightCrLfHtVt,
		in:   "DςUr␝;␉\x19␓␀\tδλ$ｕＮ7/ψＤ９\x0e\x1c#*␛ＳＨ␉δ",
		out:  "DςUr␝;␉\x19␓‛␀\tδλ$ｕＮ7/ψＤ９\x0e\x1c#*␛ＳＨ␉δ",
	}, { // 3809
		mask: EncodeColon | EncodeRightCrLfHtVt,
		in:   "DςUr␝;␉\x19␓␀\tδλ$ｕＮ7/ψＤ９\x0e\x1c#*␛ＳＨ\t␉",
		out:  "DςUr␝;␉\x19␓‛␀\tδλ$ｕＮ7/ψＤ９\x0e\x1c#*␛ＳＨ\t‛␉",
	}, { // 3810
		mask: EncodeColon | EncodeRightCrLfHtVt,
		in:   "DςUr␝;␉\x19␓␀\tδλ$ｕＮ7/ψＤ９\x0e\x1c#*␛ＳＨ␉␉",
		out:  "DςUr␝;␉\x19␓‛␀\tδλ$ｕＮ7/ψＤ９\x0e\x1c#*␛ＳＨ␉‛␉",
	}, { // 3811
		mask: EncodeColon | EncodeRightCrLfHtVt,
		in:   "DςUr␝;␉\x19␓␀\tδλ$ｕＮ7/ψＤ９\x0e\x1c#*␛ＳＨβ\t",
		out:  "DςUr␝;␉\x19␓‛␀\tδλ$ｕＮ7/ψＤ９\x0e\x1c#*␛ＳＨβ␉",
	}, { // 3812
		mask: EncodeColon | EncodeRightCrLfHtVt,
		in:   "DςUr␝;␉\x19␓␀\tδλ$ｕＮ7/ψＤ９\x0e\x1c#*␛ＳＨβ␉",
		out:  "DςUr␝;␉\x19␓‛␀\tδλ$ｕＮ7/ψＤ９\x0e\x1c#*␛ＳＨβ‛␉",
	}, { // 3813
		mask: EncodeColon | EncodeRightCrLfHtVt,
		in:   "Ｃγ！\x1e\r\b:B␚ρ\n[n>！τｑ＂π＊]\x04\vδ␂３α␒４␉",
		out:  "Ｃγ！\x1e\r\b：B␚ρ\n[n>！τｑ＂π＊]\x04\vδ␂３α␒４‛␉",
	}, { // 3814
		mask: EncodeColon | EncodeRightCrLfHtVt,
		in:   "\n␊！\x1e\r\b:B␚ρ\n[n>！τｑ＂π＊]\x04\vδ␂３α␒４␉",
		out:  "\n␊！\x1e\r\b：B␚ρ\n[n>！τｑ＂π＊]\x04\vδ␂３α␒４‛␉",
	}, { // 3815
		mask: EncodeColon | EncodeRightCrLfHtVt,
		in:   "␊␊！\x1e\r\b:B␚ρ\n[n>！τｑ＂π＊]\x04\vδ␂３α␒４␉",
		out:  "␊␊！\x1e\r\b：B␚ρ\n[n>！τｑ＂π＊]\x04\vδ␂３α␒４‛␉",
	}, { // 3816
		mask: EncodeColon | EncodeRightCrLfHtVt,
		in:   "\nγ！\x1e\r\b:B␚ρ\n[n>！τｑ＂π＊]\x04\vδ␂３α␒␊␉",
		out:  "\nγ！\x1e\r\b：B␚ρ\n[n>！τｑ＂π＊]\x04\vδ␂３α␒␊‛␉",
	}, { // 3817
		mask: EncodeColon | EncodeRightCrLfHtVt,
		in:   "␊γ！\x1e\r\b:B␚ρ\n[n>！τｑ＂π＊]\x04\vδ␂３α␒␊␉",
		out:  "␊γ！\x1e\r\b：B␚ρ\n[n>！τｑ＂π＊]\x04\vδ␂３α␒␊‛␉",
	}, { // 3818
		mask: EncodeColon | EncodeRightCrLfHtVt,
		in:   "\nγ！\x1e\r\b:B␚ρ\n[n>！τｑ＂π＊]\x04\vδ␂３α␒４␊",
		out:  "\nγ！\x1e\r\b：B␚ρ\n[n>！τｑ＂π＊]\x04\vδ␂３α␒４‛␊",
	}, { // 3819
		mask: EncodeColon | EncodeRightCrLfHtVt,
		in:   "␊γ！\x1e\r\b:B␚ρ\n[n>！τｑ＂π＊]\x04\vδ␂３α␒４␊",
		out:  "␊γ！\x1e\r\b：B␚ρ\n[n>！τｑ＂π＊]\x04\vδ␂３α␒４‛␊",
	}, { // 3820
		mask: EncodeColon | EncodeRightCrLfHtVt,
		in:   "Ｃ\n！\x1e\r\b:B␚ρ\n[n>！τｑ＂π＊]\x04\vδ␂３α␒４␉",
		out:  "Ｃ\n！\x1e\r\b：B␚ρ\n[n>！τｑ＂π＊]\x04\vδ␂３α␒４‛␉",
	}, { // 3821
		mask: EncodeColon | EncodeRightCrLfHtVt,
		in:   "Ｃ␊！\x1e\r\b:B␚ρ\n[n>！τｑ＂π＊]\x04\vδ␂３α␒４␉",
		out:  "Ｃ␊！\x1e\r\b：B␚ρ\n[n>！τｑ＂π＊]\x04\vδ␂３α␒４‛␉",
	}, { // 3822
		mask: EncodeColon | EncodeRightCrLfHtVt,
		in:   "Ｃ\n！\x1e\r\b:B␚ρ\n[n>！τｑ＂π＊]\x04\vδ␂３α␒␊␉",
		out:  "Ｃ\n！\x1e\r\b：B␚ρ\n[n>！τｑ＂π＊]\x04\vδ␂３α␒␊‛␉",
	}, { // 3823
		mask: EncodeColon | EncodeRightCrLfHtVt,
		in:   "Ｃ␊！\x1e\r\b:B␚ρ\n[n>！τｑ＂π＊]\x04\vδ␂３α␒␊␉",
		out:  "Ｃ␊！\x1e\r\b：B␚ρ\n[n>！τｑ＂π＊]\x04\vδ␂３α␒␊‛␉",
	}, { // 3824
		mask: EncodeColon | EncodeRightCrLfHtVt,
		in:   "Ｃ\n！\x1e\r\b:B␚ρ\n[n>！τｑ＂π＊]\x04\vδ␂３α␒４␊",
		out:  "Ｃ\n！\x1e\r\b：B␚ρ\n[n>！τｑ＂π＊]\x04\vδ␂３α␒４‛␊",
	}, { // 3825
		mask: EncodeColon | EncodeRightCrLfHtVt,
		in:   "Ｃ␊！\x1e\r\b:B␚ρ\n[n>！τｑ＂π＊]\x04\vδ␂３α␒４␊",
		out:  "Ｃ␊！\x1e\r\b：B␚ρ\n[n>！τｑ＂π＊]\x04\vδ␂３α␒４‛␊",
	}, { // 3826
		mask: EncodeColon | EncodeRightCrLfHtVt,
		in:   "Ｃγ！\x1e\r\b:B␚ρ\n[n>！τｑ＂π＊]\x04\vδ␂３α␒\n␉",
		out:  "Ｃγ！\x1e\r\b：B␚ρ\n[n>！τｑ＂π＊]\x04\vδ␂３α␒\n‛␉",
	}, { // 3827
		mask: EncodeColon | EncodeRightCrLfHtVt,
		in:   "Ｃγ！\x1e\r\b:B␚ρ\n[n>！τｑ＂π＊]\x04\vδ␂３α␒␊␉",
		out:  "Ｃγ！\x1e\r\b：B␚ρ\n[n>！τｑ＂π＊]\x04\vδ␂３α␒␊‛␉",
	}, { // 3828
		mask: EncodeColon | EncodeRightCrLfHtVt,
		in:   "Ｃγ！\x1e\r\b:B␚ρ\n[n>！τｑ＂π＊]\x04\vδ␂３α␒\n␊",
		out:  "Ｃγ！\x1e\r\b：B␚ρ\n[n>！τｑ＂π＊]\x04\vδ␂３α␒\n‛␊",
	}, { // 3829
		mask: EncodeColon | EncodeRightCrLfHtVt,
		in:   "Ｃγ！\x1e\r\b:B␚ρ\n[n>！τｑ＂π＊]\x04\vδ␂３α␒␊␊",
		out:  "Ｃγ！\x1e\r\b：B␚ρ\n[n>！τｑ＂π＊]\x04\vδ␂３α␒␊‛␊",
	}, { // 3830
		mask: EncodeColon | EncodeRightCrLfHtVt,
		in:   "Ｃγ！\x1e\r\b:B␚ρ\n[n>！τｑ＂π＊]\x04\vδ␂３α␒４\n",
		out:  "Ｃγ！\x1e\r\b：B␚ρ\n[n>！τｑ＂π＊]\x04\vδ␂３α␒４␊",
	}, { // 3831
		mask: EncodeColon | EncodeRightCrLfHtVt,
		in:   "Ｃγ！\x1e\r\b:B␚ρ\n[n>！τｑ＂π＊]\x04\vδ␂３α␒４␊",
		out:  "Ｃγ！\x1e\r\b：B␚ρ\n[n>！τｑ＂π＊]\x04\vδ␂３α␒４‛␊",
	}, { // 3832
		mask: EncodeColon | EncodeRightCrLfHtVt,
		in:   "γＭ]\x11λ．␄１\x1cI\vκ\x10ι\x10πXＢ␘\x1f ＄C␒％＊6ｋ＜β",
		out:  "γＭ]\x11λ．␄１\x1cI\vκ\x10ι\x10πXＢ␘\x1f ＄C␒％＊6ｋ＜β",
	}, { // 3833
		mask: EncodeColon | EncodeRightCrLfHtVt,
		in:   "\v␋]\x11λ．␄１\x1cI\vκ\x10ι\x10πXＢ␘\x1f ＄C␒％＊6ｋ＜β",
		out:  "\v␋]\x11λ．␄１\x1cI\vκ\x10ι\x10πXＢ␘\x1f ＄C␒％＊6ｋ＜β",
	}, { // 3834
		mask: EncodeColon | EncodeRightCrLfHtVt,
		in:   "␋␋]\x11λ．␄１\x1cI\vκ\x10ι\x10πXＢ␘\x1f ＄C␒％＊6ｋ＜β",
		out:  "␋␋]\x11λ．␄１\x1cI\vκ\x10ι\x10πXＢ␘\x1f ＄C␒％＊6ｋ＜β",
	}, { // 3835
		mask: EncodeColon | EncodeRightCrLfHtVt,
		in:   "\vＭ]\x11λ．␄１\x1cI\vκ\x10ι\x10πXＢ␘\x1f ＄C␒％＊6ｋ␋β",
		out:  "\vＭ]\x11λ．␄１\x1cI\vκ\x10ι\x10πXＢ␘\x1f ＄C␒％＊6ｋ␋β",
	}, { // 3836
		mask: EncodeColon | EncodeRightCrLfHtVt,
		in:   "␋Ｍ]\x11λ．␄１\x1cI\vκ\x10ι\x10πXＢ␘\x1f ＄C␒％＊6ｋ␋β",
		out:  "␋Ｍ]\x11λ．␄１\x1cI\vκ\x10ι\x10πXＢ␘\x1f ＄C␒％＊6ｋ␋β",
	}, { // 3837
		mask: EncodeColon | EncodeRightCrLfHtVt,
		in:   "\vＭ]\x11λ．␄１\x1cI\vκ\x10ι\x10πXＢ␘\x1f ＄C␒％＊6ｋ＜␋",
		out:  "\vＭ]\x11λ．␄１\x1cI\vκ\x10ι\x10πXＢ␘\x1f ＄C␒％＊6ｋ＜‛␋",
	}, { // 3838
		mask: EncodeColon | EncodeRightCrLfHtVt,
		in:   "␋Ｍ]\x11λ．␄１\x1cI\vκ\x10ι\x10πXＢ␘\x1f ＄C␒％＊6ｋ＜␋",
		out:  "␋Ｍ]\x11λ．␄１\x1cI\vκ\x10ι\x10πXＢ␘\x1f ＄C␒％＊6ｋ＜‛␋",
	}, { // 3839
		mask: EncodeColon | EncodeRightCrLfHtVt,
		in:   "γ\v]\x11λ．␄１\x1cI\vκ\x10ι\x10πXＢ␘\x1f ＄C␒％＊6ｋ＜β",
		out:  "γ\v]\x11λ．␄１\x1cI\vκ\x10ι\x10πXＢ␘\x1f ＄C␒％＊6ｋ＜β",
	}, { // 3840
		mask: EncodeColon | EncodeRightCrLfHtVt,
		in:   "γ␋]\x11λ．␄１\x1cI\vκ\x10ι\x10πXＢ␘\x1f ＄C␒％＊6ｋ＜β",
		out:  "γ␋]\x11λ．␄１\x1cI\vκ\x10ι\x10πXＢ␘\x1f ＄C␒％＊6ｋ＜β",
	}, { // 3841
		mask: EncodeColon | EncodeRightCrLfHtVt,
		in:   "γ\v]\x11λ．␄１\x1cI\vκ\x10ι\x10πXＢ␘\x1f ＄C␒％＊6ｋ␋β",
		out:  "γ\v]\x11λ．␄１\x1cI\vκ\x10ι\x10πXＢ␘\x1f ＄C␒％＊6ｋ␋β",
	}, { // 3842
		mask: EncodeColon | EncodeRightCrLfHtVt,
		in:   "γ␋]\x11λ．␄１\x1cI\vκ\x10ι\x10πXＢ␘\x1f ＄C␒％＊6ｋ␋β",
		out:  "γ␋]\x11λ．␄１\x1cI\vκ\x10ι\x10πXＢ␘\x1f ＄C␒％＊6ｋ␋β",
	}, { // 3843
		mask: EncodeColon | EncodeRightCrLfHtVt,
		in:   "γ\v]\x11λ．␄１\x1cI\vκ\x10ι\x10πXＢ␘\x1f ＄C␒％＊6ｋ＜␋",
		out:  "γ\v]\x11λ．␄１\x1cI\vκ\x10ι\x10πXＢ␘\x1f ＄C␒％＊6ｋ＜‛␋",
	}, { // 3844
		mask: EncodeColon | EncodeRightCrLfHtVt,
		in:   "γ␋]\x11λ．␄１\x1cI\vκ\x10ι\x10πXＢ␘\x1f ＄C␒％＊6ｋ＜␋",
		out:  "γ␋]\x11λ．␄１\x1cI\vκ\x10ι\x10πXＢ␘\x1f ＄C␒％＊6ｋ＜‛␋",
	}, { // 3845
		mask: EncodeColon | EncodeRightCrLfHtVt,
		in:   "γＭ]\x11λ．␄１\x1cI\vκ\x10ι\x10πXＢ␘\x1f ＄C␒％＊6ｋ\vβ",
		out:  "γＭ]\x11λ．␄１\x1cI\vκ\x10ι\x10πXＢ␘\x1f ＄C␒％＊6ｋ\vβ",
	}, { // 3846
		mask: EncodeColon | EncodeRightCrLfHtVt,
		in:   "γＭ]\x11λ．␄１\x1cI\vκ\x10ι\x10πXＢ␘\x1f ＄C␒％＊6ｋ␋β",
		out:  "γＭ]\x11λ．␄１\x1cI\vκ\x10ι\x10πXＢ␘\x1f ＄C␒％＊6ｋ␋β",
	}, { // 3847
		mask: EncodeColon | EncodeRightCrLfHtVt,
		in:   "γＭ]\x11λ．␄１\x1cI\vκ\x10ι\x10πXＢ␘\x1f ＄C␒％＊6ｋ\v␋",
		out:  "γＭ]\x11λ．␄１\x1cI\vκ\x10ι\x10πXＢ␘\x1f ＄C␒％＊6ｋ\v‛␋",
	}, { // 3848
		mask: EncodeColon | EncodeRightCrLfHtVt,
		in:   "γＭ]\x11λ．␄１\x1cI\vκ\x10ι\x10πXＢ␘\x1f ＄C␒％＊6ｋ␋␋",
		out:  "γＭ]\x11λ．␄１\x1cI\vκ\x10ι\x10πXＢ␘\x1f ＄C␒％＊6ｋ␋‛␋",
	}, { // 3849
		mask: EncodeColon | EncodeRightCrLfHtVt,
		in:   "γＭ]\x11λ．␄１\x1cI\vκ\x10ι\x10πXＢ␘\x1f ＄C␒％＊6ｋ＜\v",
		out:  "γＭ]\x11λ．␄１\x1cI\vκ\x10ι\x10πXＢ␘\x1f ＄C␒％＊6ｋ＜␋",
	}, { // 3850
		mask: EncodeColon | EncodeRightCrLfHtVt,
		in:   "γＭ]\x11λ．␄１\x1cI\vκ\x10ι\x10πXＢ␘\x1f ＄C␒％＊6ｋ＜␋",
		out:  "γＭ]\x11λ．␄１\x1cI\vκ\x10ι\x10πXＢ␘\x1f ＄C␒％＊6ｋ＜‛␋",
	}, { // 3851
		mask: EncodeColon | EncodeRightCrLfHtVt,
		in:   "υδ\x18\x05＂Uρο\x159\r\x02L＠V＃u\x04＼␂＆＃σｚ\x1c1αＤ␍／",
		out:  "υδ\x18\x05＂Uρο\x159\r\x02L＠V＃u\x04＼␂＆＃σｚ\x1c1αＤ␍／",
	}, { // 3852
		mask: EncodeColon | EncodeRightCrLfHtVt,
		in:   "\r␍\x18\x05＂Uρο\x159\r\x02L＠V＃u\x04＼␂＆＃σｚ\x1c1αＤ␍／",
		out:  "\r␍\x18\x05＂Uρο\x159\r\x02L＠V＃u\x04＼␂＆＃σｚ\x1c1αＤ␍／",
	}, { // 3853
		mask: EncodeColon | EncodeRightCrLfHtVt,
		in:   "␍␍\x18\x05＂Uρο\x159\r\x02L＠V＃u\x04＼␂＆＃σｚ\x1c1αＤ␍／",
		out:  "␍␍\x18\x05＂Uρο\x159\r\x02L＠V＃u\x04＼␂＆＃σｚ\x1c1αＤ␍／",
	}, { // 3854
		mask: EncodeColon | EncodeRightCrLfHtVt,
		in:   "\rδ\x18\x05＂Uρο\x159\r\x02L＠V＃u\x04＼␂＆＃σｚ\x1c1αＤ␍／",
		out:  "\rδ\x18\x05＂Uρο\x159\r\x02L＠V＃u\x04＼␂＆＃σｚ\x1c1αＤ␍／",
	}, { // 3855
		mask: EncodeColon | EncodeRightCrLfHtVt,
		in:   "␍δ\x18\x05＂Uρο\x159\r\x02L＠V＃u\x04＼␂＆＃σｚ\x1c1αＤ␍／",
		out:  "␍δ\x18\x05＂Uρο\x159\r\x02L＠V＃u\x04＼␂＆＃σｚ\x1c1αＤ␍／",
	}, { // 3856
		mask: EncodeColon | EncodeRightCrLfHtVt,
		in:   "\rδ\x18\x05＂Uρο\x159\r\x02L＠V＃u\x04＼␂＆＃σｚ\x1c1αＤ␍␍",
		out:  "\rδ\x18\x05＂Uρο\x159\r\x02L＠V＃u\x04＼␂＆＃σｚ\x1c1αＤ␍‛␍",
	}, { // 3857
		mask: EncodeColon | EncodeRightCrLfHtVt,
		in:   "␍δ\x18\x05＂Uρο\x159\r\x02L＠V＃u\x04＼␂＆＃σｚ\x1c1αＤ␍␍",
		out:  "␍δ\x18\x05＂Uρο\x159\r\x02L＠V＃u\x04＼␂＆＃σｚ\x1c1αＤ␍‛␍",
	}, { // 3858
		mask: EncodeColon | EncodeRightCrLfHtVt,
		in:   "υ\r\x18\x05＂Uρο\x159\r\x02L＠V＃u\x04＼␂＆＃σｚ\x1c1αＤ␍／",
		out:  "υ\r\x18\x05＂Uρο\x159\r\x02L＠V＃u\x04＼␂＆＃σｚ\x1c1αＤ␍／",
	}, { // 3859
		mask: EncodeColon | EncodeRightCrLfHtVt,
		in:   "υ␍\x18\x05＂Uρο\x159\r\x02L＠V＃u\x04＼␂＆＃σｚ\x1c1αＤ␍／",
		out:  "υ␍\x18\x05＂Uρο\x159\r\x02L＠V＃u\x04＼␂＆＃σｚ\x1c1αＤ␍／",
	}, { // 3860
		mask: EncodeColon | EncodeRightCrLfHtVt,
		in:   "υ\r\x18\x05＂Uρο\x159\r\x02L＠V＃u\x04＼␂＆＃σｚ\x1c1αＤ␍／",
		out:  "υ\r\x18\x05＂Uρο\x159\r\x02L＠V＃u\x04＼␂＆＃σｚ\x1c1αＤ␍／",
	}, { // 3861
		mask: EncodeColon | EncodeRightCrLfHtVt,
		in:   "υ␍\x18\x05＂Uρο\x159\r\x02L＠V＃u\x04＼␂＆＃σｚ\x1c1αＤ␍／",
		out:  "υ␍\x18\x05＂Uρο\x159\r\x02L＠V＃u\x04＼␂＆＃σｚ\x1c1αＤ␍／",
	}, { // 3862
		mask: EncodeColon | EncodeRightCrLfHtVt,
		in:   "υ\r\x18\x05＂Uρο\x159\r\x02L＠V＃u\x04＼␂＆＃σｚ\x1c1αＤ␍␍",
		out:  "υ\r\x18\x05＂Uρο\x159\r\x02L＠V＃u\x04＼␂＆＃σｚ\x1c1αＤ␍‛␍",
	}, { // 3863
		mask: EncodeColon | EncodeRightCrLfHtVt,
		in:   "υ␍\x18\x05＂Uρο\x159\r\x02L＠V＃u\x04＼␂＆＃σｚ\x1c1αＤ␍␍",
		out:  "υ␍\x18\x05＂Uρο\x159\r\x02L＠V＃u\x04＼␂＆＃σｚ\x1c1αＤ␍‛␍",
	}, { // 3864
		mask: EncodeColon | EncodeRightCrLfHtVt,
		in:   "υδ\x18\x05＂Uρο\x159\r\x02L＠V＃u\x04＼␂＆＃σｚ\x1c1αＤ\r／",
		out:  "υδ\x18\x05＂Uρο\x159\r\x02L＠V＃u\x04＼␂＆＃σｚ\x1c1αＤ\r／",
	}, { // 3865
		mask: EncodeColon | EncodeRightCrLfHtVt,
		in:   "υδ\x18\x05＂Uρο\x159\r\x02L＠V＃u\x04＼␂＆＃σｚ\x1c1αＤ␍／",
		out:  "υδ\x18\x05＂Uρο\x159\r\x02L＠V＃u\x04＼␂＆＃σｚ\x1c1αＤ␍／",
	}, { // 3866
		mask: EncodeColon | EncodeRightCrLfHtVt,
		in:   "υδ\x18\x05＂Uρο\x159\r\x02L＠V＃u\x04＼␂＆＃σｚ\x1c1αＤ\r␍",
		out:  "υδ\x18\x05＂Uρο\x159\r\x02L＠V＃u\x04＼␂＆＃σｚ\x1c1αＤ\r‛␍",
	}, { // 3867
		mask: EncodeColon | EncodeRightCrLfHtVt,
		in:   "υδ\x18\x05＂Uρο\x159\r\x02L＠V＃u\x04＼␂＆＃σｚ\x1c1αＤ␍␍",
		out:  "υδ\x18\x05＂Uρο\x159\r\x02L＠V＃u\x04＼␂＆＃σｚ\x1c1αＤ␍‛␍",
	}, { // 3868
		mask: EncodeColon | EncodeRightCrLfHtVt,
		in:   "υδ\x18\x05＂Uρο\x159\r\x02L＠V＃u\x04＼␂＆＃σｚ\x1c1αＤ␍\r",
		out:  "υδ\x18\x05＂Uρο\x159\r\x02L＠V＃u\x04＼␂＆＃σｚ\x1c1αＤ␍␍",
	}, { // 3869
		mask: EncodeColon | EncodeRightCrLfHtVt,
		in:   "υδ\x18\x05＂Uρο\x159\r\x02L＠V＃u\x04＼␂＆＃σｚ\x1c1αＤ␍␍",
		out:  "υδ\x18\x05＂Uρο\x159\r\x02L＠V＃u\x04＼␂＆＃σｚ\x1c1αＤ␍‛␍",
	}, { // 3870
		mask: EncodeQuestion | EncodeRightCrLfHtVt,
		in:   "*\x02σ␂\x1aθ␃ρz#\t：␡␃＃\x13Z␅＾|ａκeψ␑ｇ*η]A",
		out:  "*\x02σ␂\x1aθ␃ρz#\t：␡␃＃\x13Z␅＾|ａκeψ␑ｇ*η]A",
	}, { // 3871
		mask: EncodeQuestion | EncodeRightCrLfHtVt,
		in:   "\t␉σ␂\x1aθ␃ρz#\t：␡␃＃\x13Z␅＾|ａκeψ␑ｇ*η]A",
		out:  "\t␉σ␂\x1aθ␃ρz#\t：␡␃＃\x13Z␅＾|ａκeψ␑ｇ*η]A",
	}, { // 3872
		mask: EncodeQuestion | EncodeRightCrLfHtVt,
		in:   "␉␉σ␂\x1aθ␃ρz#\t：␡␃＃\x13Z␅＾|ａκeψ␑ｇ*η]A",
		out:  "␉␉σ␂\x1aθ␃ρz#\t：␡␃＃\x13Z␅＾|ａκeψ␑ｇ*η]A",
	}, { // 3873
		mask: EncodeQuestion | EncodeRightCrLfHtVt,
		in:   "\t\x02σ␂\x1aθ␃ρz#\t：␡␃＃\x13Z␅＾|ａκeψ␑ｇ*η␉A",
		out:  "\t\x02σ␂\x1aθ␃ρz#\t：␡␃＃\x13Z␅＾|ａκeψ␑ｇ*η␉A",
	}, { // 3874
		mask: EncodeQuestion | EncodeRightCrLfHtVt,
		in:   "␉\x02σ␂\x1aθ␃ρz#\t：␡␃＃\x13Z␅＾|ａκeψ␑ｇ*η␉A",
		out:  "␉\x02σ␂\x1aθ␃ρz#\t：␡␃＃\x13Z␅＾|ａκeψ␑ｇ*η␉A",
	}, { // 3875
		mask: EncodeQuestion | EncodeRightCrLfHtVt,
		in:   "\t\x02σ␂\x1aθ␃ρz#\t：␡␃＃\x13Z␅＾|ａκeψ␑ｇ*η]␉",
		out:  "\t\x02σ␂\x1aθ␃ρz#\t：␡␃＃\x13Z␅＾|ａκeψ␑ｇ*η]‛␉",
	}, { // 3876
		mask: EncodeQuestion | EncodeRightCrLfHtVt,
		in:   "␉\x02σ␂\x1aθ␃ρz#\t：␡␃＃\x13Z␅＾|ａκeψ␑ｇ*η]␉",
		out:  "␉\x02σ␂\x1aθ␃ρz#\t：␡␃＃\x13Z␅＾|ａκeψ␑ｇ*η]‛␉",
	}, { // 3877
		mask: EncodeQuestion | EncodeRightCrLfHtVt,
		in:   "*\tσ␂\x1aθ␃ρz#\t：␡␃＃\x13Z␅＾|ａκeψ␑ｇ*η]A",
		out:  "*\tσ␂\x1aθ␃ρz#\t：␡␃＃\x13Z␅＾|ａκeψ␑ｇ*η]A",
	}, { // 3878
		mask: EncodeQuestion | EncodeRightCrLfHtVt,
		in:   "*␉σ␂\x1aθ␃ρz#\t：␡␃＃\x13Z␅＾|ａκeψ␑ｇ*η]A",
		out:  "*␉σ␂\x1aθ␃ρz#\t：␡␃＃\x13Z␅＾|ａκeψ␑ｇ*η]A",
	}, { // 3879
		mask: EncodeQuestion | EncodeRightCrLfHtVt,
		in:   "*\tσ␂\x1aθ␃ρz#\t：␡␃＃\x13Z␅＾|ａκeψ␑ｇ*η␉A",
		out:  "*\tσ␂\x1aθ␃ρz#\t：␡␃＃\x13Z␅＾|ａκeψ␑ｇ*η␉A",
	}, { // 3880
		mask: EncodeQuestion | EncodeRightCrLfHtVt,
		in:   "*␉σ␂\x1aθ␃ρz#\t：␡␃＃\x13Z␅＾|ａκeψ␑ｇ*η␉A",
		out:  "*␉σ␂\x1aθ␃ρz#\t：␡␃＃\x13Z␅＾|ａκeψ␑ｇ*η␉A",
	}, { // 3881
		mask: EncodeQuestion | EncodeRightCrLfHtVt,
		in:   "*\tσ␂\x1aθ␃ρz#\t：␡␃＃\x13Z␅＾|ａκeψ␑ｇ*η]␉",
		out:  "*\tσ␂\x1aθ␃ρz#\t：␡␃＃\x13Z␅＾|ａκeψ␑ｇ*η]‛␉",
	}, { // 3882
		mask: EncodeQuestion | EncodeRightCrLfHtVt,
		in:   "*␉σ␂\x1aθ␃ρz#\t：␡␃＃\x13Z␅＾|ａκeψ␑ｇ*η]␉",
		out:  "*␉σ␂\x1aθ␃ρz#\t：␡␃＃\x13Z␅＾|ａκeψ␑ｇ*η]‛␉",
	}, { // 3883
		mask: EncodeQuestion | EncodeRightCrLfHtVt,
		in:   "*\x02σ␂\x1aθ␃ρz#\t：␡␃＃\x13Z␅＾|ａκeψ␑ｇ*η\tA",
		out:  "*\x02σ␂\x1aθ␃ρz#\t：␡␃＃\x13Z␅＾|ａκeψ␑ｇ*η\tA",
	}, { // 3884
		mask: EncodeQuestion | EncodeRightCrLfHtVt,
		in:   "*\x02σ␂\x1aθ␃ρz#\t：␡␃＃\x13Z␅＾|ａκeψ␑ｇ*η␉A",
		out:  "*\x02σ␂\x1aθ␃ρz#\t：␡␃＃\x13Z␅＾|ａκeψ␑ｇ*η␉A",
	}, { // 3885
		mask: EncodeQuestion | EncodeRightCrLfHtVt,
		in:   "*\x02σ␂\x1aθ␃ρz#\t：␡␃＃\x13Z␅＾|ａκeψ␑ｇ*η\t␉",
		out:  "*\x02σ␂\x1aθ␃ρz#\t：␡␃＃\x13Z␅＾|ａκeψ␑ｇ*η\t‛␉",
	}, { // 3886
		mask: EncodeQuestion | EncodeRightCrLfHtVt,
		in:   "*\x02σ␂\x1aθ␃ρz#\t：␡␃＃\x13Z␅＾|ａκeψ␑ｇ*η␉␉",
		out:  "*\x02σ␂\x1aθ␃ρz#\t：␡␃＃\x13Z␅＾|ａκeψ␑ｇ*η␉‛␉",
	}, { // 3887
		mask: EncodeQuestion | EncodeRightCrLfHtVt,
		in:   "*\x02σ␂\x1aθ␃ρz#\t：␡␃＃\x13Z␅＾|ａκeψ␑ｇ*η]\t",
		out:  "*\x02σ␂\x1aθ␃ρz#\t：␡␃＃\x13Z␅＾|ａκeψ␑ｇ*η]␉",
	}, { // 3888
		mask: EncodeQuestion | EncodeRightCrLfHtVt,
		in:   "*\x02σ␂\x1aθ␃ρz#\t：␡␃＃\x13Z␅＾|ａκeψ␑ｇ*η]␉",
		out:  "*\x02σ␂\x1aθ␃ρz#\t：␡␃＃\x13Z␅＾|ａκeψ␑ｇ*η]‛␉",
	}, { // 3889
		mask: EncodeQuestion | EncodeRightCrLfHtVt,
		in:   "ε␔＠`ｄｒ␔%\bZ\n>␝５\x17：&οτνQ%␃␍ｓ␈}μuκ",
		out:  "ε␔＠`ｄｒ␔%\bZ\n>␝５\x17：&οτνQ%␃␍ｓ␈}μuκ",
	}, { // 3890
		mask: EncodeQuestion | EncodeRightCrLfHtVt,
		in:   "\n␊＠`ｄｒ␔%\bZ\n>␝５\x17：&οτνQ%␃␍ｓ␈}μuκ",
		out:  "\n␊＠`ｄｒ␔%\bZ\n>␝５\x17：&οτνQ%␃␍ｓ␈}μuκ",
	}, { // 3891
		mask: EncodeQuestion | EncodeRightCrLfHtVt,
		in:   "␊␊＠`ｄｒ␔%\bZ\n>␝５\x17：&οτνQ%␃␍ｓ␈}μuκ",
		out:  "␊␊＠`ｄｒ␔%\bZ\n>␝５\x17：&οτνQ%␃␍ｓ␈}μuκ",
	}, { // 3892
		mask: EncodeQuestion | EncodeRightCrLfHtVt,
		in:   "\n␔＠`ｄｒ␔%\bZ\n>␝５\x17：&οτνQ%␃␍ｓ␈}μ␊κ",
		out:  "\n␔＠`ｄｒ␔%\bZ\n>␝５\x17：&οτνQ%␃␍ｓ␈}μ␊κ",
	}, { // 3893
		mask: EncodeQuestion | EncodeRightCrLfHtVt,
		in:   "␊␔＠`ｄｒ␔%\bZ\n>␝５\x17：&οτνQ%␃␍ｓ␈}μ␊κ",
		out:  "␊␔＠`ｄｒ␔%\bZ\n>␝５\x17：&οτνQ%␃␍ｓ␈}μ␊κ",
	}, { // 3894
		mask: EncodeQuestion | EncodeRightCrLfHtVt,
		in:   "\n␔＠`ｄｒ␔%\bZ\n>␝５\x17：&οτνQ%␃␍ｓ␈}μu␊",
		out:  "\n␔＠`ｄｒ␔%\bZ\n>␝５\x17：&οτνQ%␃␍ｓ␈}μu‛␊",
	}, { // 3895
		mask: EncodeQuestion | EncodeRightCrLfHtVt,
		in:   "␊␔＠`ｄｒ␔%\bZ\n>␝５\x17：&οτνQ%␃␍ｓ␈}μu␊",
		out:  "␊␔＠`ｄｒ␔%\bZ\n>␝５\x17：&οτνQ%␃␍ｓ␈}μu‛␊",
	}, { // 3896
		mask: EncodeQuestion | EncodeRightCrLfHtVt,
		in:   "ε\n＠`ｄｒ␔%\bZ\n>␝５\x17：&οτνQ%␃␍ｓ␈}μuκ",
		out:  "ε\n＠`ｄｒ␔%\bZ\n>␝５\x17：&οτνQ%␃␍ｓ␈}μuκ",
	}, { // 3897
		mask: EncodeQuestion | EncodeRightCrLfHtVt,
		in:   "ε␊＠`ｄｒ␔%\bZ\n>␝５\x17：&οτνQ%␃␍ｓ␈}μuκ",
		out:  "ε␊＠`ｄｒ␔%\bZ\n>␝５\x17：&οτνQ%␃␍ｓ␈}μuκ",
	}, { // 3898
		mask: EncodeQuestion | EncodeRightCrLfHtVt,
		in:   "ε\n＠`ｄｒ␔%\bZ\n>␝５\x17：&οτνQ%␃␍ｓ␈}μ␊κ",
		out:  "ε\n＠`ｄｒ␔%\bZ\n>␝５\x17：&οτνQ%␃␍ｓ␈}μ␊κ",
	}, { // 3899
		mask: EncodeQuestion | EncodeRightCrLfHtVt,
		in:   "ε␊＠`ｄｒ␔%\bZ\n>␝５\x17：&οτνQ%␃␍ｓ␈}μ␊κ",
		out:  "ε␊＠`ｄｒ␔%\bZ\n>␝５\x17：&οτνQ%␃␍ｓ␈}μ␊κ",
	}, { // 3900
		mask: EncodeQuestion | EncodeRightCrLfHtVt,
		in:   "ε\n＠`ｄｒ␔%\bZ\n>␝５\x17：&οτνQ%␃␍ｓ␈}μu␊",
		out:  "ε\n＠`ｄｒ␔%\bZ\n>␝５\x17：&οτνQ%␃␍ｓ␈}μu‛␊",
	}, { // 3901
		mask: EncodeQuestion | EncodeRightCrLfHtVt,
		in:   "ε␊＠`ｄｒ␔%\bZ\n>␝５\x17：&οτνQ%␃␍ｓ␈}μu␊",
		out:  "ε␊＠`ｄｒ␔%\bZ\n>␝５\x17：&οτνQ%␃␍ｓ␈}μu‛␊",
	}, { // 3902
		mask: EncodeQuestion | EncodeRightCrLfHtVt,
		in:   "ε␔＠`ｄｒ␔%\bZ\n>␝５\x17：&οτνQ%␃␍ｓ␈}μ\nκ",
		out:  "ε␔＠`ｄｒ␔%\bZ\n>␝５\x17：&οτνQ%␃␍ｓ␈}μ\nκ",
	}, { // 3903
		mask: EncodeQuestion | EncodeRightCrLfHtVt,
		in:   "ε␔＠`ｄｒ␔%\bZ\n>␝５\x17：&οτνQ%␃␍ｓ␈}μ␊κ",
		out:  "ε␔＠`ｄｒ␔%\bZ\n>␝５\x17：&οτνQ%␃␍ｓ␈}μ␊κ",
	}, { // 3904
		mask: EncodeQuestion | EncodeRightCrLfHtVt,
		in:   "ε␔＠`ｄｒ␔%\bZ\n>␝５\x17：&οτνQ%␃␍ｓ␈}μ\n␊",
		out:  "ε␔＠`ｄｒ␔%\bZ\n>␝５\x17：&οτνQ%␃␍ｓ␈}μ\n‛␊",
	}, { // 3905
		mask: EncodeQuestion | EncodeRightCrLfHtVt,
		in:   "ε␔＠`ｄｒ␔%\bZ\n>␝５\x17：&οτνQ%␃␍ｓ␈}μ␊␊",
		out:  "ε␔＠`ｄｒ␔%\bZ\n>␝５\x17：&οτνQ%␃␍ｓ␈}μ␊‛␊",
	}, { // 3906
		mask: EncodeQuestion | EncodeRightCrLfHtVt,
		in:   "ε␔＠`ｄｒ␔%\bZ\n>␝５\x17：&οτνQ%␃␍ｓ␈}μu\n",
		out:  "ε␔＠`ｄｒ␔%\bZ\n>␝５\x17：&οτνQ%␃␍ｓ␈}μu␊",
	}, { // 3907
		mask: EncodeQuestion | EncodeRightCrLfHtVt,
		in:   "ε␔＠`ｄｒ␔%\bZ\n>␝５\x17：&οτνQ%␃␍ｓ␈}μu␊",
		out:  "ε␔＠`ｄｒ␔%\bZ\n>␝５\x17：&οτνQ%␃␍ｓ␈}μu‛␊",
	}, { // 3908
		mask: EncodeQuestion | EncodeRightCrLfHtVt,
		in:   "F|［．mτ[ｖπ␕\v\x1bη\x12\x19Uκｎ＜＃␝ｉ␔\rωＤjχＺk",
		out:  "F|［．mτ[ｖπ␕\v\x1bη\x12\x19Uκｎ＜＃␝ｉ␔\rωＤjχＺk",
	}, { // 3909
		mask: EncodeQuestion | EncodeRightCrLfHtVt,
		in:   "\v␋［．mτ[ｖπ␕\v\x1bη\x12\x19Uκｎ＜＃␝ｉ␔\rωＤjχＺk",
		out:  "\v␋［．mτ[ｖπ␕\v\x1bη\x12\x19Uκｎ＜＃␝ｉ␔\rωＤjχＺk",
	}, { // 3910
		mask: EncodeQuestion | EncodeRightCrLfHtVt,
		in:   "␋␋［．mτ[ｖπ␕\v\x1bη\x12\x19Uκｎ＜＃␝ｉ␔\rωＤjχＺk",
		out:  "␋␋［．mτ[ｖπ␕\v\x1bη\x12\x19Uκｎ＜＃␝ｉ␔\rωＤjχＺk",
	}, { // 3911
		mask: EncodeQuestion | EncodeRightCrLfHtVt,
		in:   "\v|［．mτ[ｖπ␕\v\x1bη\x12\x19Uκｎ＜＃␝ｉ␔\rωＤjχ␋k",
		out:  "\v|［．mτ[ｖπ␕\v\x1bη\x12\x19Uκｎ＜＃␝ｉ␔\rωＤjχ␋k",
	}, { // 3912
		mask: EncodeQuestion | EncodeRightCrLfHtVt,
		in:   "␋|［．mτ[ｖπ␕\v\x1bη\x12\x19Uκｎ＜＃␝ｉ␔\rωＤjχ␋k",
		out:  "␋|［．mτ[ｖπ␕\v\x1bη\x12\x19Uκｎ＜＃␝ｉ␔\rωＤjχ␋k",
	}, { // 3913
		mask: EncodeQuestion | EncodeRightCrLfHtVt,
		in:   "\v|［．mτ[ｖπ␕\v\x1bη\x12\x19Uκｎ＜＃␝ｉ␔\rωＤjχＺ␋",
		out:  "\v|［．mτ[ｖπ␕\v\x1bη\x12\x19Uκｎ＜＃␝ｉ␔\rωＤjχＺ‛␋",
	}, { // 3914
		mask: EncodeQuestion | EncodeRightCrLfHtVt,
		in:   "␋|［．mτ[ｖπ␕\v\x1bη\x12\x19Uκｎ＜＃␝ｉ␔\rωＤjχＺ␋",
		out:  "␋|［．mτ[ｖπ␕\v\x1bη\x12\x19Uκｎ＜＃␝ｉ␔\rωＤjχＺ‛␋",
	}, { // 3915
		mask: EncodeQuestion | EncodeRightCrLfHtVt,
		in:   "F\v［．mτ[ｖπ␕\v\x1bη\x12\x19Uκｎ＜＃␝ｉ␔\rωＤjχＺk",
		out:  "F\v［．mτ[ｖπ␕\v\x1bη\x12\x19Uκｎ＜＃␝ｉ␔\rωＤjχＺk",
	}, { // 3916
		mask: EncodeQuestion | EncodeRightCrLfHtVt,
		in:   "F␋［．mτ[ｖπ␕\v\x1bη\x12\x19Uκｎ＜＃␝ｉ␔\rωＤjχＺk",
		out:  "F␋［．mτ[ｖπ␕\v\x1bη\x12\x19Uκｎ＜＃␝ｉ␔\rωＤjχＺk",
	}, { // 3917
		mask: EncodeQuestion | EncodeRightCrLfHtVt,
		in:   "F\v［．mτ[ｖπ␕\v\x1bη\x12\x19Uκｎ＜＃␝ｉ␔\rωＤjχ␋k",
		out:  "F\v［．mτ[ｖπ␕\v\x1bη\x12\x19Uκｎ＜＃␝ｉ␔\rωＤjχ␋k",
	}, { // 3918
		mask: EncodeQuestion | EncodeRightCrLfHtVt,
		in:   "F␋［．mτ[ｖπ␕\v\x1bη\x12\x19Uκｎ＜＃␝ｉ␔\rωＤjχ␋k",
		out:  "F␋［．mτ[ｖπ␕\v\x1bη\x12\x19Uκｎ＜＃␝ｉ␔\rωＤjχ␋k",
	}, { // 3919
		mask: EncodeQuestion | EncodeRightCrLfHtVt,
		in:   "F\v［．mτ[ｖπ␕\v\x1bη\x12\x19Uκｎ＜＃␝ｉ␔\rωＤjχＺ␋",
		out:  "F\v［．mτ[ｖπ␕\v\x1bη\x12\x19Uκｎ＜＃␝ｉ␔\rωＤjχＺ‛␋",
	}, { // 3920
		mask: EncodeQuestion | EncodeRightCrLfHtVt,
		in:   "F␋［．mτ[ｖπ␕\v\x1bη\x12\x19Uκｎ＜＃␝ｉ␔\rωＤjχＺ␋",
		out:  "F␋［．mτ[ｖπ␕\v\x1bη\x12\x19Uκｎ＜＃␝ｉ␔\rωＤjχＺ‛␋",
	}, { // 3921
		mask: EncodeQuestion | EncodeRightCrLfHtVt,
		in:   "F|［．mτ[ｖπ␕\v\x1bη\x12\x19Uκｎ＜＃␝ｉ␔\rωＤjχ\vk",
		out:  "F|［．mτ[ｖπ␕\v\x1bη\x12\x19Uκｎ＜＃␝ｉ␔\rωＤjχ\vk",
	}, { // 3922
		mask: EncodeQuestion | EncodeRightCrLfHtVt,
		in:   "F|［．mτ[ｖπ␕\v\x1bη\x12\x19Uκｎ＜＃␝ｉ␔\rωＤjχ␋k",
		out:  "F|［．mτ[ｖπ␕\v\x1bη\x12\x19Uκｎ＜＃␝ｉ␔\rωＤjχ␋k",
	}, { // 3923
		mask: EncodeQuestion | EncodeRightCrLfHtVt,
		in:   "F|［．mτ[ｖπ␕\v\x1bη\x12\x19Uκｎ＜＃␝ｉ␔\rωＤjχ\v␋",
		out:  "F|［．mτ[ｖπ␕\v\x1bη\x12\x19Uκｎ＜＃␝ｉ␔\rωＤjχ\v‛␋",
	}, { // 3924
		mask: EncodeQuestion | EncodeRightCrLfHtVt,
		in:   "F|［．mτ[ｖπ␕\v\x1bη\x12\x19Uκｎ＜＃␝ｉ␔\rωＤjχ␋␋",
		out:  "F|［．mτ[ｖπ␕\v\x1bη\x12\x19Uκｎ＜＃␝ｉ␔\rωＤjχ␋‛␋",
	}, { // 3925
		mask: EncodeQuestion | EncodeRightCrLfHtVt,
		in:   "F|［．mτ[ｖπ␕\v\x1bη\x12\x19Uκｎ＜＃␝ｉ␔\rωＤjχＺ\v",
		out:  "F|［．mτ[ｖπ␕\v\x1bη\x12\x19Uκｎ＜＃␝ｉ␔\rωＤjχＺ␋",
	}, { // 3926
		mask: EncodeQuestion | EncodeRightCrLfHtVt,
		in:   "F|［．mτ[ｖπ␕\v\x1bη\x12\x19Uκｎ＜＃␝ｉ␔\rωＤjχＺ␋",
		out:  "F|［．mτ[ｖπ␕\v\x1bη\x12\x19Uκｎ＜＃␝ｉ␔\rωＤjχＺ‛␋",
	}, { // 3927
		mask: EncodeQuestion | EncodeRightCrLfHtVt,
		in:   "\x17０␛\n␉ξβ1ς␔\rκ,\x06Ａω［g\"：␊Ｔqπ(ｃ～-\x00[",
		out:  "\x17０␛\n␉ξβ1ς␔\rκ,\x06Ａω［g\"：␊Ｔqπ(ｃ～-␀[",
	}, { // 3928
		mask: EncodeQuestion | EncodeRightCrLfHtVt,
		in:   "\r␍␛\n␉ξβ1ς␔\rκ,\x06Ａω［g\"：␊Ｔqπ(ｃ～-\x00[",
		out:  "\r␍␛\n␉ξβ1ς␔\rκ,\x06Ａω［g\"：␊Ｔqπ(ｃ～-␀[",
	}, { // 3929
		mask: EncodeQuestion | EncodeRightCrLfHtVt,
		in:   "␍␍␛\n␉ξβ1ς␔\rκ,\x06Ａω［g\"：␊Ｔqπ(ｃ～-\x00[",
		out:  "␍␍␛\n␉ξβ1ς␔\rκ,\x06Ａω［g\"：␊Ｔqπ(ｃ～-␀[",
	}, { // 3930
		mask: EncodeQuestion | EncodeRightCrLfHtVt,
		in:   "\r０␛\n␉ξβ1ς␔\rκ,\x06Ａω［g\"：␊Ｔqπ(ｃ～-␍[",
		out:  "\r０␛\n␉ξβ1ς␔\rκ,\x06Ａω［g\"：␊Ｔqπ(ｃ～-␍[",
	}, { // 3931
		mask: EncodeQuestion | EncodeRightCrLfHtVt,
		in:   "␍０␛\n␉ξβ1ς␔\rκ,\x06Ａω［g\"：␊Ｔqπ(ｃ～-␍[",
		out:  "␍０␛\n␉ξβ1ς␔\rκ,\x06Ａω［g\"：␊Ｔqπ(ｃ～-␍[",
	}, { // 3932
		mask: EncodeQuestion | EncodeRightCrLfHtVt,
		in:   "\r０␛\n␉ξβ1ς␔\rκ,\x06Ａω［g\"：␊Ｔqπ(ｃ～-\x00␍",
		out:  "\r０␛\n␉ξβ1ς␔\rκ,\x06Ａω［g\"：␊Ｔqπ(ｃ～-␀‛␍",
	}, { // 3933
		mask: EncodeQuestion | EncodeRightCrLfHtVt,
		in:   "␍０␛\n␉ξβ1ς␔\rκ,\x06Ａω［g\"：␊Ｔqπ(ｃ～-\x00␍",
		out:  "␍０␛\n␉ξβ1ς␔\rκ,\x06Ａω［g\"：␊Ｔqπ(ｃ～-␀‛␍",
	}, { // 3934
		mask: EncodeQuestion | EncodeRightCrLfHtVt,
		in:   "\x17\r␛\n␉ξβ1ς␔\rκ,\x06Ａω［g\"：␊Ｔqπ(ｃ～-\x00[",
		out:  "\x17\r␛\n␉ξβ1ς␔\rκ,\x06Ａω［g\"：␊Ｔqπ(ｃ～-␀[",
	}, { // 3935
		mask: EncodeQuestion | EncodeRightCrLfHtVt,
		in:   "\x17␍␛\n␉ξβ1ς␔\rκ,\x06Ａω［g\"：␊Ｔqπ(ｃ～-\x00[",
		out:  "\x17␍␛\n␉ξβ1ς␔\rκ,\x06Ａω［g\"：␊Ｔqπ(ｃ～-␀[",
	}, { // 3936
		mask: EncodeQuestion | EncodeRightCrLfHtVt,
		in:   "\x17\r␛\n␉ξβ1ς␔\rκ,\x06Ａω［g\"：␊Ｔqπ(ｃ～-␍[",
		out:  "\x17\r␛\n␉ξβ1ς␔\rκ,\x06Ａω［g\"：␊Ｔqπ(ｃ～-␍[",
	}, { // 3937
		mask: EncodeQuestion | EncodeRightCrLfHtVt,
		in:   "\x17␍␛\n␉ξβ1ς␔\rκ,\x06Ａω［g\"：␊Ｔqπ(ｃ～-␍[",
		out:  "\x17␍␛\n␉ξβ1ς␔\rκ,\x06Ａω［g\"：␊Ｔqπ(ｃ～-␍[",
	}, { // 3938
		mask: EncodeQuestion | EncodeRightCrLfHtVt,
		in:   "\x17\r␛\n␉ξβ1ς␔\rκ,\x06Ａω［g\"：␊Ｔqπ(ｃ～-\x00␍",
		out:  "\x17\r␛\n␉ξβ1ς␔\rκ,\x06Ａω［g\"：␊Ｔqπ(ｃ～-␀‛␍",
	}, { // 3939
		mask: EncodeQuestion | EncodeRightCrLfHtVt,
		in:   "\x17␍␛\n␉ξβ1ς␔\rκ,\x06Ａω［g\"：␊Ｔqπ(ｃ～-\x00␍",
		out:  "\x17␍␛\n␉ξβ1ς␔\rκ,\x06Ａω［g\"：␊Ｔqπ(ｃ～-␀‛␍",
	}, { // 3940
		mask: EncodeQuestion | EncodeRightCrLfHtVt,
		in:   "\x17０␛\n␉ξβ1ς␔\rκ,\x06Ａω［g\"：␊Ｔqπ(ｃ～-\r[",
		out:  "\x17０␛\n␉ξβ1ς␔\rκ,\x06Ａω［g\"：␊Ｔqπ(ｃ～-\r[",
	}, { // 3941
		mask: EncodeQuestion | EncodeRightCrLfHtVt,
		in:   "\x17０␛\n␉ξβ1ς␔\rκ,\x06Ａω［g\"：␊Ｔqπ(ｃ～-␍[",
		out:  "\x17０␛\n␉ξβ1ς␔\rκ,\x06Ａω［g\"：␊Ｔqπ(ｃ～-␍[",
	}, { // 3942
		mask: EncodeQuestion | EncodeRightCrLfHtVt,
		in:   "\x17０␛\n␉ξβ1ς␔\rκ,\x06Ａω［g\"：␊Ｔqπ(ｃ～-\r␍",
		out:  "\x17０␛\n␉ξβ1ς␔\rκ,\x06Ａω［g\"：␊Ｔqπ(ｃ～-\r‛␍",
	}, { // 3943
		mask: EncodeQuestion | EncodeRightCrLfHtVt,
		in:   "\x17０␛\n␉ξβ1ς␔\rκ,\x06Ａω［g\"：␊Ｔqπ(ｃ～-␍␍",
		out:  "\x17０␛\n␉ξβ1ς␔\rκ,\x06Ａω［g\"：␊Ｔqπ(ｃ～-␍‛␍",
	}, { // 3944
		mask: EncodeQuestion | EncodeRightCrLfHtVt,
		in:   "\x17０␛\n␉ξβ1ς␔\rκ,\x06Ａω［g\"：␊Ｔqπ(ｃ～-\x00\r",
		out:  "\x17０␛\n␉ξβ1ς␔\rκ,\x06Ａω［g\"：␊Ｔqπ(ｃ～-␀␍",
	}, { // 3945
		mask: EncodeQuestion | EncodeRightCrLfHtVt,
		in:   "\x17０␛\n␉ξβ1ς␔\rκ,\x06Ａω［g\"：␊Ｔqπ(ｃ～-\x00␍",
		out:  "\x17０␛\n␉ξβ1ς␔\rκ,\x06Ａω［g\"：␊Ｔqπ(ｃ～-␀‛␍",
	}, { // 3946
		mask: EncodeAsterisk | EncodeRightCrLfHtVt,
		in:   "ο\x11<␇␍η\x1cαα␔\tsＧσπＧ␟Ｔ\x1b＃\a^>＇ｚu６e0\x10",
		out:  "ο\x11<␇␍η\x1cαα␔\tsＧσπＧ␟Ｔ\x1b＃\a^>＇ｚu６e0\x10",
	}, { // 3947
		mask: EncodeAsterisk | EncodeRightCrLfHtVt,
		in:   "\t␉<␇␍η\x1cαα␔\tsＧσπＧ␟Ｔ\x1b＃\a^>＇ｚu６e0\x10",
		out:  "\t␉<␇␍η\x1cαα␔\tsＧσπＧ␟Ｔ\x1b＃\a^>＇ｚu６e0\x10",
	}, { // 3948
		mask: EncodeAsterisk | EncodeRightCrLfHtVt,
		in:   "␉␉<␇␍η\x1cαα␔\tsＧσπＧ␟Ｔ\x1b＃\a^>＇ｚu６e0\x10",
		out:  "␉␉<␇␍η\x1cαα␔\tsＧσπＧ␟Ｔ\x1b＃\a^>＇ｚu６e0\x10",
	}, { // 3949
		mask: EncodeAsterisk | EncodeRightCrLfHtVt,
		in:   "\t\x11<␇␍η\x1cαα␔\tsＧσπＧ␟Ｔ\x1b＃\a^>＇ｚu６e␉\x10",
		out:  "\t\x11<␇␍η\x1cαα␔\tsＧσπＧ␟Ｔ\x1b＃\a^>＇ｚu６e␉\x10",
	}, { // 3950
		mask: EncodeAsterisk | EncodeRightCrLfHtVt,
		in:   "␉\x11<␇␍η\x1cαα␔\tsＧσπＧ␟Ｔ\x1b＃\a^>＇ｚu６e␉\x10",
		out:  "␉\x11<␇␍η\x1cαα␔\tsＧσπＧ␟Ｔ\x1b＃\a^>＇ｚu６e␉\x10",
	}, { // 3951
		mask: EncodeAsterisk | EncodeRightCrLfHtVt,
		in:   "\t\x11<␇␍η\x1cαα␔\tsＧσπＧ␟Ｔ\x1b＃\a^>＇ｚu６e0␉",
		out:  "\t\x11<␇␍η\x1cαα␔\tsＧσπＧ␟Ｔ\x1b＃\a^>＇ｚu６e0‛␉",
	}, { // 3952
		mask: EncodeAsterisk | EncodeRightCrLfHtVt,
		in:   "␉\x11<␇␍η\x1cαα␔\tsＧσπＧ␟Ｔ\x1b＃\a^>＇ｚu６e0␉",
		out:  "␉\x11<␇␍η\x1cαα␔\tsＧσπＧ␟Ｔ\x1b＃\a^>＇ｚu６e0‛␉",
	}, { // 3953
		mask: EncodeAsterisk | EncodeRightCrLfHtVt,
		in:   "ο\t<␇␍η\x1cαα␔\tsＧσπＧ␟Ｔ\x1b＃\a^>＇ｚu６e0\x10",
		out:  "ο\t<␇␍η\x1cαα␔\tsＧσπＧ␟Ｔ\x1b＃\a^>＇ｚu６e0\x10",
	}, { // 3954
		mask: EncodeAsterisk | EncodeRightCrLfHtVt,
		in:   "ο␉<␇␍η\x1cαα␔\tsＧσπＧ␟Ｔ\x1b＃\a^>＇ｚu６e0\x10",
		out:  "ο␉<␇␍η\x1cαα␔\tsＧσπＧ␟Ｔ\x1b＃\a^>＇ｚu６e0\x10",
	}, { // 3955
		mask: EncodeAsterisk | EncodeRightCrLfHtVt,
		in:   "ο\t<␇␍η\x1cαα␔\tsＧσπＧ␟Ｔ\x1b＃\a^>＇ｚu６e␉\x10",
		out:  "ο\t<␇␍η\x1cαα␔\tsＧσπＧ␟Ｔ\x1b＃\a^>＇ｚu６e␉\x10",
	}, { // 3956
		mask: EncodeAsterisk | EncodeRightCrLfHtVt,
		in:   "ο␉<␇␍η\x1cαα␔\tsＧσπＧ␟Ｔ\x1b＃\a^>＇ｚu６e␉\x10",
		out:  "ο␉<␇␍η\x1cαα␔\tsＧσπＧ␟Ｔ\x1b＃\a^>＇ｚu６e␉\x10",
	}, { // 3957
		mask: EncodeAsterisk | EncodeRightCrLfHtVt,
		in:   "ο\t<␇␍η\x1cαα␔\tsＧσπＧ␟Ｔ\x1b＃\a^>＇ｚu６e0␉",
		out:  "ο\t<␇␍η\x1cαα␔\tsＧσπＧ␟Ｔ\x1b＃\a^>＇ｚu６e0‛␉",
	}, { // 3958
		mask: EncodeAsterisk | EncodeRightCrLfHtVt,
		in:   "ο␉<␇␍η\x1cαα␔\tsＧσπＧ␟Ｔ\x1b＃\a^>＇ｚu６e0␉",
		out:  "ο␉<␇␍η\x1cαα␔\tsＧσπＧ␟Ｔ\x1b＃\a^>＇ｚu６e0‛␉",
	}, { // 3959
		mask: EncodeAsterisk | EncodeRightCrLfHtVt,
		in:   "ο\x11<␇␍η\x1cαα␔\tsＧσπＧ␟Ｔ\x1b＃\a^>＇ｚu６e\t\x10",
		out:  "ο\x11<␇␍η\x1cαα␔\tsＧσπＧ␟Ｔ\x1b＃\a^>＇ｚu６e\t\x10",
	}, { // 3960
		mask: EncodeAsterisk | EncodeRightCrLfHtVt,
		in:   "ο\x11<␇␍η\x1cαα␔\tsＧσπＧ␟Ｔ\x1b＃\a^>＇ｚu６e␉\x10",
		out:  "ο\x11<␇␍η\x1cαα␔\tsＧσπＧ␟Ｔ\x1b＃\a^>＇ｚu６e␉\x10",
	}, { // 3961
		mask: EncodeAsterisk | EncodeRightCrLfHtVt,
		in:   "ο\x11<␇␍η\x1cαα␔\tsＧσπＧ␟Ｔ\x1b＃\a^>＇ｚu６e\t␉",
		out:  "ο\x11<␇␍η\x1cαα␔\tsＧσπＧ␟Ｔ\x1b＃\a^>＇ｚu６e\t‛␉",
	}, { // 3962
		mask: EncodeAsterisk | EncodeRightCrLfHtVt,
		in:   "ο\x11<␇␍η\x1cαα␔\tsＧσπＧ␟Ｔ\x1b＃\a^>＇ｚu６e␉␉",
		out:  "ο\x11<␇␍η\x1cαα␔\tsＧσπＧ␟Ｔ\x1b＃\a^>＇ｚu６e␉‛␉",
	}, { // 3963
		mask: EncodeAsterisk | EncodeRightCrLfHtVt,
		in:   "ο\x11<␇␍η\x1cαα␔\tsＧσπＧ␟Ｔ\x1b＃\a^>＇ｚu６e0\t",
		out:  "ο\x11<␇␍η\x1cαα␔\tsＧσπＧ␟Ｔ\x1b＃\a^>＇ｚu６e0␉",
	}, { // 3964
		mask: EncodeAsterisk | EncodeRightCrLfHtVt,
		in:   "ο\x11<␇␍η\x1cαα␔\tsＧσπＧ␟Ｔ\x1b＃\a^>＇ｚu６e0␉",
		out:  "ο\x11<␇␍η\x1cαα␔\tsＧσπＧ␟Ｔ\x1b＃\a^>＇ｚu６e0‛␉",
	}, { // 3965
		mask: EncodeAsterisk | EncodeRightCrLfHtVt,
		in:   "ｖｔ*ｑω\fι)\"｀\n｝#\\ι｀\x04␕θad\\μ␐｜αｌｚ␗\x12",
		out:  "ｖｔ＊ｑω\fι)\"｀\n｝#\\ι｀\x04␕θad\\μ␐｜αｌｚ␗\x12",
	}, { // 3966
		mask: EncodeAsterisk | EncodeRightCrLfHtVt,
		in:   "\n␊*ｑω\fι)\"｀\n｝#\\ι｀\x04␕θad\\μ␐｜αｌｚ␗\x12",
		out:  "\n␊＊ｑω\fι)\"｀\n｝#\\ι｀\x04␕θad\\μ␐｜αｌｚ␗\x12",
	}, { // 3967
		mask: EncodeAsterisk | EncodeRightCrLfHtVt,
		in:   "␊␊*ｑω\fι)\"｀\n｝#\\ι｀\x04␕θad\\μ␐｜αｌｚ␗\x12",
		out:  "␊␊＊ｑω\fι)\"｀\n｝#\\ι｀\x04␕θad\\μ␐｜αｌｚ␗\x12",
	}, { // 3968
		mask: EncodeAsterisk | EncodeRightCrLfHtVt,
		in:   "\nｔ*ｑω\fι)\"｀\n｝#\\ι｀\x04␕θad\\μ␐｜αｌｚ␊\x12",
		out:  "\nｔ＊ｑω\fι)\"｀\n｝#\\ι｀\x04␕θad\\μ␐｜αｌｚ␊\x12",
	}, { // 3969
		mask: EncodeAsterisk | EncodeRightCrLfHtVt,
		in:   "␊ｔ*ｑω\fι)\"｀\n｝#\\ι｀\x04␕θad\\μ␐｜αｌｚ␊\x12",
		out:  "␊ｔ＊ｑω\fι)\"｀\n｝#\\ι｀\x04␕θad\\μ␐｜αｌｚ␊\x12",
	}, { // 3970
		mask: EncodeAsterisk | EncodeRightCrLfHtVt,
		in:   "\nｔ*ｑω\fι)\"｀\n｝#\\ι｀\x04␕θad\\μ␐｜αｌｚ␗␊",
		out:  "\nｔ＊ｑω\fι)\"｀\n｝#\\ι｀\x04␕θad\\μ␐｜αｌｚ␗‛␊",
	}, { // 3971
		mask: EncodeAsterisk | EncodeRightCrLfHtVt,
		in:   "␊ｔ*ｑω\fι)\"｀\n｝#\\ι｀\x04␕θad\\μ␐｜αｌｚ␗␊",
		out:  "␊ｔ＊ｑω\fι)\"｀\n｝#\\ι｀\x04␕θad\\μ␐｜αｌｚ␗‛␊",
	}, { // 3972
		mask: EncodeAsterisk | EncodeRightCrLfHtVt,
		in:   "ｖ\n*ｑω\fι)\"｀\n｝#\\ι｀\x04␕θad\\μ␐｜αｌｚ␗\x12",
		out:  "ｖ\n＊ｑω\fι)\"｀\n｝#\\ι｀\x04␕θad\\μ␐｜αｌｚ␗\x12",
	}, { // 3973
		mask: EncodeAsterisk | EncodeRightCrLfHtVt,
		in:   "ｖ␊*ｑω\fι)\"｀\n｝#\\ι｀\x04␕θad\\μ␐｜αｌｚ␗\x12",
		out:  "ｖ␊＊ｑω\fι)\"｀\n｝#\\ι｀\x04␕θad\\μ␐｜αｌｚ␗\x12",
	}, { // 3974
		mask: EncodeAsterisk | EncodeRightCrLfHtVt,
		in:   "ｖ\n*ｑω\fι)\"｀\n｝#\\ι｀\x04␕θad\\μ␐｜αｌｚ␊\x12",
		out:  "ｖ\n＊ｑω\fι)\"｀\n｝#\\ι｀\x04␕θad\\μ␐｜αｌｚ␊\x12",
	}, { // 3975
		mask: EncodeAsterisk | EncodeRightCrLfHtVt,
		in:   "ｖ␊*ｑω\fι)\"｀\n｝#\\ι｀\x04␕θad\\μ␐｜αｌｚ␊\x12",
		out:  "ｖ␊＊ｑω\fι)\"｀\n｝#\\ι｀\x04␕θad\\μ␐｜αｌｚ␊\x12",
	}, { // 3976
		mask: EncodeAsterisk | EncodeRightCrLfHtVt,
		in:   "ｖ\n*ｑω\fι)\"｀\n｝#\\ι｀\x04␕θad\\μ␐｜αｌｚ␗␊",
		out:  "ｖ\n＊ｑω\fι)\"｀\n｝#\\ι｀\x04␕θad\\μ␐｜αｌｚ␗‛␊",
	}, { // 3977
		mask: EncodeAsterisk | EncodeRightCrLfHtVt,
		in:   "ｖ␊*ｑω\fι)\"｀\n｝#\\ι｀\x04␕θad\\μ␐｜αｌｚ␗␊",
		out:  "ｖ␊＊ｑω\fι)\"｀\n｝#\\ι｀\x04␕θad\\μ␐｜αｌｚ␗‛␊",
	}, { // 3978
		mask: EncodeAsterisk | EncodeRightCrLfHtVt,
		in:   "ｖｔ*ｑω\fι)\"｀\n｝#\\ι｀\x04␕θad\\μ␐｜αｌｚ\n\x12",
		out:  "ｖｔ＊ｑω\fι)\"｀\n｝#\\ι｀\x04␕θad\\μ␐｜αｌｚ\n\x12",
	}, { // 3979
		mask: EncodeAsterisk | EncodeRightCrLfHtVt,
		in:   "ｖｔ*ｑω\fι)\"｀\n｝#\\ι｀\x04␕θad\\μ␐｜αｌｚ␊\x12",
		out:  "ｖｔ＊ｑω\fι)\"｀\n｝#\\ι｀\x04␕θad\\μ␐｜αｌｚ␊\x12",
	}, { // 3980
		mask: EncodeAsterisk | EncodeRightCrLfHtVt,
		in:   "ｖｔ*ｑω\fι)\"｀\n｝#\\ι｀\x04␕θad\\μ␐｜αｌｚ\n␊",
		out:  "ｖｔ＊ｑω\fι)\"｀\n｝#\\ι｀\x04␕θad\\μ␐｜αｌｚ\n‛␊",
	}, { // 3981
		mask: EncodeAsterisk | EncodeRightCrLfHtVt,
		in:   "ｖｔ*ｑω\fι)\"｀\n｝#\\ι｀\x04␕θad\\μ␐｜αｌｚ␊␊",
		out:  "ｖｔ＊ｑω\fι)\"｀\n｝#\\ι｀\x04␕θad\\μ␐｜αｌｚ␊‛␊",
	}, { // 3982
		mask: EncodeAsterisk | EncodeRightCrLfHtVt,
		in:   "ｖｔ*ｑω\fι)\"｀\n｝#\\ι｀\x04␕θad\\μ␐｜αｌｚ␗\n",
		out:  "ｖｔ＊ｑω\fι)\"｀\n｝#\\ι｀\x04␕θad\\μ␐｜αｌｚ␗␊",
	}, { // 3983
		mask: EncodeAsterisk | EncodeRightCrLfHtVt,
		in:   "ｖｔ*ｑω\fι)\"｀\n｝#\\ι｀\x04␕θad\\μ␐｜αｌｚ␗␊",
		out:  "ｖｔ＊ｑω\fι)\"｀\n｝#\\ι｀\x04␕θad\\μ␐｜αｌｚ␗‛␊",
	}, { // 3984
		mask: EncodeAsterisk | EncodeRightCrLfHtVt,
		in:   "pιβ＼\aο＇␊ｓ５\v\x1dＭ2 *｜Ｄ\x06：Ｔ␜:␆λνε'r\t",
		out:  "pιβ＼\aο＇␊ｓ５\v\x1dＭ2 ＊｜Ｄ\x06：Ｔ␜:␆λνε'r␉",
	}, { // 3985
		mask: EncodeAsterisk | EncodeRightCrLfHtVt,
		in:   "\v␋β＼\aο＇␊ｓ５\v\x1dＭ2 *｜Ｄ\x06：Ｔ␜:␆λνε'r\t",
		out:  "\v␋β＼\aο＇␊ｓ５\v\x1dＭ2 ＊｜Ｄ\x06：Ｔ␜:␆λνε'r␉",
	}, { // 3986
		mask: EncodeAsterisk | EncodeRightCrLfHtVt,
		in:   "␋␋β＼\aο＇␊ｓ５\v\x1dＭ2 *｜Ｄ\x06：Ｔ␜:␆λνε'r\t",
		out:  "␋␋β＼\aο＇␊ｓ５\v\x1dＭ2 ＊｜Ｄ\x06：Ｔ␜:␆λνε'r␉",
	}, { // 3987
		mask: EncodeAsterisk | EncodeRightCrLfHtVt,
		in:   "\vιβ＼\aο＇␊ｓ５\v\x1dＭ2 *｜Ｄ\x06：Ｔ␜:␆λνε'␋\t",
		out:  "\vιβ＼\aο＇␊ｓ５\v\x1dＭ2 ＊｜Ｄ\x06：Ｔ␜:␆λνε'␋␉",
	}, { // 3988
		mask: EncodeAsterisk | EncodeRightCrLfHtVt,
		in:   "␋ιβ＼\aο＇␊ｓ５\v\x1dＭ2 *｜Ｄ\x06：Ｔ␜:␆λνε'␋\t",
		out:  "␋ιβ＼\aο＇␊ｓ５\v\x1dＭ2 ＊｜Ｄ\x06：Ｔ␜:␆λνε'␋␉",
	}, { // 3989
		mask: EncodeAsterisk | EncodeRightCrLfHtVt,
		in:   "\vιβ＼\aο＇␊ｓ５\v\x1dＭ2 *｜Ｄ\x06：Ｔ␜:␆λνε'r␋",
		out:  "\vιβ＼\aο＇␊ｓ５\v\x1dＭ2 ＊｜Ｄ\x06：Ｔ␜:␆λνε'r‛␋",
	}, { // 3990
		mask: EncodeAsterisk | EncodeRightCrLfHtVt,
		in:   "␋ιβ＼\aο＇␊ｓ５\v\x1dＭ2 *｜Ｄ\x06：Ｔ␜:␆λνε'r␋",
		out:  "␋ιβ＼\aο＇␊ｓ５\v\x1dＭ2 ＊｜Ｄ\x06：Ｔ␜:␆λνε'r‛␋",
	}, { // 3991
		mask: EncodeAsterisk | EncodeRightCrLfHtVt,
		in:   "p\vβ＼\aο＇␊ｓ５\v\x1dＭ2 *｜Ｄ\x06：Ｔ␜:␆λνε'r\t",
		out:  "p\vβ＼\aο＇␊ｓ５\v\x1dＭ2 ＊｜Ｄ\x06：Ｔ␜:␆λνε'r␉",
	}, { // 3992
		mask: EncodeAsterisk | EncodeRightCrLfHtVt,
		in:   "p␋β＼\aο＇␊ｓ５\v\x1dＭ2 *｜Ｄ\x06：Ｔ␜:␆λνε'r\t",
		out:  "p␋β＼\aο＇␊ｓ５\v\x1dＭ2 ＊｜Ｄ\x06：Ｔ␜:␆λνε'r␉",
	}, { // 3993
		mask: EncodeAsterisk | EncodeRightCrLfHtVt,
		in:   "p\vβ＼\aο＇␊ｓ５\v\x1dＭ2 *｜Ｄ\x06：Ｔ␜:␆λνε'␋\t",
		out:  "p\vβ＼\aο＇␊ｓ５\v\x1dＭ2 ＊｜Ｄ\x06：Ｔ␜:␆λνε'␋␉",
	}, { // 3994
		mask: EncodeAsterisk | EncodeRightCrLfHtVt,
		in:   "p␋β＼\aο＇␊ｓ５\v\x1dＭ2 *｜Ｄ\x06：Ｔ␜:␆λνε'␋\t",
		out:  "p␋β＼\aο＇␊ｓ５\v\x1dＭ2 ＊｜Ｄ\x06：Ｔ␜:␆λνε'␋␉",
	}, { // 3995
		mask: EncodeAsterisk | EncodeRightCrLfHtVt,
		in:   "p\vβ＼\aο＇␊ｓ５\v\x1dＭ2 *｜Ｄ\x06：Ｔ␜:␆λνε'r␋",
		out:  "p\vβ＼\aο＇␊ｓ５\v\x1dＭ2 ＊｜Ｄ\x06：Ｔ␜:␆λνε'r‛␋",
	}, { // 3996
		mask: EncodeAsterisk | EncodeRightCrLfHtVt,
		in:   "p␋β＼\aο＇␊ｓ５\v\x1dＭ2 *｜Ｄ\x06：Ｔ␜:␆λνε'r␋",
		out:  "p␋β＼\aο＇␊ｓ５\v\x1dＭ2 ＊｜Ｄ\x06：Ｔ␜:␆λνε'r‛␋",
	}, { // 3997
		mask: EncodeAsterisk | EncodeRightCrLfHtVt,
		in:   "pιβ＼\aο＇␊ｓ５\v\x1dＭ2 *｜Ｄ\x06：Ｔ␜:␆λνε'\v\t",
		out:  "pιβ＼\aο＇␊ｓ５\v\x1dＭ2 ＊｜Ｄ\x06：Ｔ␜:␆λνε'\v␉",
	}, { // 3998
		mask: EncodeAsterisk | EncodeRightCrLfHtVt,
		in:   "pιβ＼\aο＇␊ｓ５\v\x1dＭ2 *｜Ｄ\x06：Ｔ␜:␆λνε'␋\t",
		out:  "pιβ＼\aο＇␊ｓ５\v\x1dＭ2 ＊｜Ｄ\x06：Ｔ␜:␆λνε'␋␉",
	}, { // 3999
		mask: EncodeAsterisk | EncodeRightCrLfHtVt,
		in:   "pιβ＼\aο＇␊ｓ５\v\x1dＭ2 *｜Ｄ\x06：Ｔ␜:␆λνε'\v␋",
		out:  "pιβ＼\aο＇␊ｓ５\v\x1dＭ2 ＊｜Ｄ\x06：Ｔ␜:␆λνε'\v‛␋",
	}, { // 4000
		mask: EncodeAsterisk | EncodeRightCrLfHtVt,
		in:   "pιβ＼\aο＇␊ｓ５\v\x1dＭ2 *｜Ｄ\x06：Ｔ␜:␆λνε'␋␋",
		out:  "pιβ＼\aο＇␊ｓ５\v\x1dＭ2 ＊｜Ｄ\x06：Ｔ␜:␆λνε'␋‛␋",
	}, { // 4001
		mask: EncodeAsterisk | EncodeRightCrLfHtVt,
		in:   "pιβ＼\aο＇␊ｓ５\v\x1dＭ2 *｜Ｄ\x06：Ｔ␜:␆λνε'r\v",
		out:  "pιβ＼\aο＇␊ｓ５\v\x1dＭ2 ＊｜Ｄ\x06：Ｔ␜:␆λνε'r␋",
	}, { // 4002
		mask: EncodeAsterisk | EncodeRightCrLfHtVt,
		in:   "pιβ＼\aο＇␊ｓ５\v\x1dＭ2 *｜Ｄ\x06：Ｔ␜:␆λνε'r␋",
		out:  "pιβ＼\aο＇␊ｓ５\v\x1dＭ2 ＊｜Ｄ\x06：Ｔ␜:␆λνε'r‛␋",
	}, { // 4003
		mask: EncodeAsterisk | EncodeRightCrLfHtVt,
		in:   "/␔␐\fυL␎θσn\r６νιχ%］b:W：);ｉ\b)＇ｎＣ␐",
		out:  "/␔␐\fυL␎θσn\r６νιχ%］b:W：);ｉ\b)＇ｎＣ␐",
	}, { // 4004
		mask: EncodeAsterisk | EncodeRightCrLfHtVt,
		in:   "\r␍␐\fυL␎θσn\r６νιχ%］b:W：);ｉ\b)＇ｎＣ␐",
		out:  "\r␍␐\fυL␎θσn\r６νιχ%］b:W：);ｉ\b)＇ｎＣ␐",
	}, { // 4005
		mask: EncodeAsterisk | EncodeRightCrLfHtVt,
		in:   "␍␍␐\fυL␎θσn\r６νιχ%］b:W：);ｉ\b)＇ｎＣ␐",
		out:  "␍␍␐\fυL␎θσn\r６νιχ%］b:W：);ｉ\b)＇ｎＣ␐",
	}, { // 4006
		mask: EncodeAsterisk | EncodeRightCrLfHtVt,
		in:   "\r␔␐\fυL␎θσn\r６νιχ%］b:W：);ｉ\b)＇ｎ␍␐",
		out:  "\r␔␐\fυL␎θσn\r６νιχ%］b:W：);ｉ\b)＇ｎ␍␐",
	}, { // 4007
		mask: EncodeAsterisk | EncodeRightCrLfHtVt,
		in:   "␍␔␐\fυL␎θσn\r６νιχ%］b:W：);ｉ\b)＇ｎ␍␐",
		out:  "␍␔␐\fυL␎θσn\r６νιχ%］b:W：);ｉ\b)＇ｎ␍␐",
	}, { // 4008
		mask: EncodeAsterisk | EncodeRightCrLfHtVt,
		in:   "\r␔␐\fυL␎θσn\r６νιχ%］b:W：);ｉ\b)＇ｎＣ␍",
		out:  "\r␔␐\fυL␎θσn\r６νιχ%］b:W：);ｉ\b)＇ｎＣ‛␍",
	}, { // 4009
		mask: EncodeAsterisk | EncodeRightCrLfHtVt,
		in:   "␍␔␐\fυL␎θσn\r６νιχ%］b:W：);ｉ\b)＇ｎＣ␍",
		out:  "␍␔␐\fυL␎θσn\r６νιχ%］b:W：);ｉ\b)＇ｎＣ‛␍",
	}, { // 4010
		mask: EncodeAsterisk | EncodeRightCrLfHtVt,
		in:   "/\r␐\fυL␎θσn\r６νιχ%］b:W：);ｉ\b)＇ｎＣ␐",
		out:  "/\r␐\fυL␎θσn\r６νιχ%］b:W：);ｉ\b)＇ｎＣ␐",
	}, { // 4011
		mask: EncodeAsterisk | EncodeRightCrLfHtVt,
		in:   "/␍␐\fυL␎θσn\r６νιχ%］b:W：);ｉ\b)＇ｎＣ␐",
		out:  "/␍␐\fυL␎θσn\r６νιχ%］b:W：);ｉ\b)＇ｎＣ␐",
	}, { // 4012
		mask: EncodeAsterisk | EncodeRightCrLfHtVt,
		in:   "/\r␐\fυL␎θσn\r６νιχ%］b:W：);ｉ\b)＇ｎ␍␐",
		out:  "/\r␐\fυL␎θσn\r６νιχ%］b:W：);ｉ\b)＇ｎ␍␐",
	}, { // 4013
		mask: EncodeAsterisk | EncodeRightCrLfHtVt,
		in:   "/␍␐\fυL␎θσn\r６νιχ%］b:W：);ｉ\b)＇ｎ␍␐",
		out:  "/␍␐\fυL␎θσn\r６νιχ%］b:W：);ｉ\b)＇ｎ␍␐",
	}, { // 4014
		mask: EncodeAsterisk | EncodeRightCrLfHtVt,
		in:   "/\r␐\fυL␎θσn\r６νιχ%］b:W：);ｉ\b)＇ｎＣ␍",
		out:  "/\r␐\fυL␎θσn\r６νιχ%］b:W：);ｉ\b)＇ｎＣ‛␍",
	}, { // 4015
		mask: EncodeAsterisk | EncodeRightCrLfHtVt,
		in:   "/␍␐\fυL␎θσn\r６νιχ%］b:W：);ｉ\b)＇ｎＣ␍",
		out:  "/␍␐\fυL␎θσn\r６νιχ%］b:W：);ｉ\b)＇ｎＣ‛␍",
	}, { // 4016
		mask: EncodeAsterisk | EncodeRightCrLfHtVt,
		in:   "/␔␐\fυL␎θσn\r６νιχ%］b:W：);ｉ\b)＇ｎ\r␐",
		out:  "/␔␐\fυL␎θσn\r６νιχ%］b:W：);ｉ\b)＇ｎ\r␐",
	}, { // 4017
		mask: EncodeAsterisk | EncodeRightCrLfHtVt,
		in:   "/␔␐\fυL␎θσn\r６νιχ%］b:W：);ｉ\b)＇ｎ␍␐",
		out:  "/␔␐\fυL␎θσn\r６νιχ%］b:W：);ｉ\b)＇ｎ␍␐",
	}, { // 4018
		mask: EncodeAsterisk | EncodeRightCrLfHtVt,
		in:   "/␔␐\fυL␎θσn\r６νιχ%］b:W：);ｉ\b)＇ｎ\r␍",
		out:  "/␔␐\fυL␎θσn\r６νιχ%］b:W：);ｉ\b)＇ｎ\r‛␍",
	}, { // 4019
		mask: EncodeAsterisk | EncodeRightCrLfHtVt,
		in:   "/␔␐\fυL␎θσn\r６νιχ%］b:W：);ｉ\b)＇ｎ␍␍",
		out:  "/␔␐\fυL␎θσn\r６νιχ%］b:W：);ｉ\b)＇ｎ␍‛␍",
	}, { // 4020
		mask: EncodeAsterisk | EncodeRightCrLfHtVt,
		in:   "/␔␐\fυL␎θσn\r６νιχ%］b:W：);ｉ\b)＇ｎＣ\r",
		out:  "/␔␐\fυL␎θσn\r６νιχ%］b:W：);ｉ\b)＇ｎＣ␍",
	}, { // 4021
		mask: EncodeAsterisk | EncodeRightCrLfHtVt,
		in:   "/␔␐\fυL␎θσn\r６νιχ%］b:W：);ｉ\b)＇ｎＣ␍",
		out:  "/␔␐\fυL␎θσn\r６νιχ%］b:W：);ｉ\b)＇ｎＣ‛␍",
	}, { // 4022
		mask: EncodePipe | EncodeRightCrLfHtVt,
		in:   "FA\x10␟π\x11νA\x0e（\tｘ␒＂\x10jζｗ％ν\x01\x1eτ]μＴ␘␁Ｇ:",
		out:  "FA\x10␟π\x11νA\x0e（\tｘ␒＂\x10jζｗ％ν\x01\x1eτ]μＴ␘␁Ｇ:",
	}, { // 4023
		mask: EncodePipe | EncodeRightCrLfHtVt,
		in:   "\t␉\x10␟π\x11νA\x0e（\tｘ␒＂\x10jζｗ％ν\x01\x1eτ]μＴ␘␁Ｇ:",
		out:  "\t␉\x10␟π\x11νA\x0e（\tｘ␒＂\x10jζｗ％ν\x01\x1eτ]μＴ␘␁Ｇ:",
	}, { // 4024
		mask: EncodePipe | EncodeRightCrLfHtVt,
		in:   "␉␉\x10␟π\x11νA\x0e（\tｘ␒＂\x10jζｗ％ν\x01\x1eτ]μＴ␘␁Ｇ:",
		out:  "␉␉\x10␟π\x11νA\x0e（\tｘ␒＂\x10jζｗ％ν\x01\x1eτ]μＴ␘␁Ｇ:",
	}, { // 4025
		mask: EncodePipe | EncodeRightCrLfHtVt,
		in:   "\tA\x10␟π\x11νA\x0e（\tｘ␒＂\x10jζｗ％ν\x01\x1eτ]μＴ␘␁␉:",
		out:  "\tA\x10␟π\x11νA\x0e（\tｘ␒＂\x10jζｗ％ν\x01\x1eτ]μＴ␘␁␉:",
	}, { // 4026
		mask: EncodePipe | EncodeRightCrLfHtVt,
		in:   "␉A\x10␟π\x11νA\x0e（\tｘ␒＂\x10jζｗ％ν\x01\x1eτ]μＴ␘␁␉:",
		out:  "␉A\x10␟π\x11νA\x0e（\tｘ␒＂\x10jζｗ％ν\x01\x1eτ]μＴ␘␁␉:",
	}, { // 4027
		mask: EncodePipe | EncodeRightCrLfHtVt,
		in:   "\tA\x10␟π\x11νA\x0e（\tｘ␒＂\x10jζｗ％ν\x01\x1eτ]μＴ␘␁Ｇ␉",
		out:  "\tA\x10␟π\x11νA\x0e（\tｘ␒＂\x10jζｗ％ν\x01\x1eτ]μＴ␘␁Ｇ‛␉",
	}, { // 4028
		mask: EncodePipe | EncodeRightCrLfHtVt,
		in:   "␉A\x10␟π\x11νA\x0e（\tｘ␒＂\x10jζｗ％ν\x01\x1eτ]μＴ␘␁Ｇ␉",
		out:  "␉A\x10␟π\x11νA\x0e（\tｘ␒＂\x10jζｗ％ν\x01\x1eτ]μＴ␘␁Ｇ‛␉",
	}, { // 4029
		mask: EncodePipe | EncodeRightCrLfHtVt,
		in:   "F\t\x10␟π\x11νA\x0e（\tｘ␒＂\x10jζｗ％ν\x01\x1eτ]μＴ␘␁Ｇ:",
		out:  "F\t\x10␟π\x11νA\x0e（\tｘ␒＂\x10jζｗ％ν\x01\x1eτ]μＴ␘␁Ｇ:",
	}, { // 4030
		mask: EncodePipe | EncodeRightCrLfHtVt,
		in:   "F␉\x10␟π\x11νA\x0e（\tｘ␒＂\x10jζｗ％ν\x01\x1eτ]μＴ␘␁Ｇ:",
		out:  "F␉\x10␟π\x11νA\x0e（\tｘ␒＂\x10jζｗ％ν\x01\x1eτ]μＴ␘␁Ｇ:",
	}, { // 4031
		mask: EncodePipe | EncodeRightCrLfHtVt,
		in:   "F\t\x10␟π\x11νA\x0e（\tｘ␒＂\x10jζｗ％ν\x01\x1eτ]μＴ␘␁␉:",
		out:  "F\t\x10␟π\x11νA\x0e（\tｘ␒＂\x10jζｗ％ν\x01\x1eτ]μＴ␘␁␉:",
	}, { // 4032
		mask: EncodePipe | EncodeRightCrLfHtVt,
		in:   "F␉\x10␟π\x11νA\x0e（\tｘ␒＂\x10jζｗ％ν\x01\x1eτ]μＴ␘␁␉:",
		out:  "F␉\x10␟π\x11νA\x0e（\tｘ␒＂\x10jζｗ％ν\x01\x1eτ]μＴ␘␁␉:",
	}, { // 4033
		mask: EncodePipe | EncodeRightCrLfHtVt,
		in:   "F\t\x10␟π\x11νA\x0e（\tｘ␒＂\x10jζｗ％ν\x01\x1eτ]μＴ␘␁Ｇ␉",
		out:  "F\t\x10␟π\x11νA\x0e（\tｘ␒＂\x10jζｗ％ν\x01\x1eτ]μＴ␘␁Ｇ‛␉",
	}, { // 4034
		mask: EncodePipe | EncodeRightCrLfHtVt,
		in:   "F␉\x10␟π\x11νA\x0e（\tｘ␒＂\x10jζｗ％ν\x01\x1eτ]μＴ␘␁Ｇ␉",
		out:  "F␉\x10␟π\x11νA\x0e（\tｘ␒＂\x10jζｗ％ν\x01\x1eτ]μＴ␘␁Ｇ‛␉",
	}, { // 4035
		mask: EncodePipe | EncodeRightCrLfHtVt,
		in:   "FA\x10␟π\x11νA\x0e（\tｘ␒＂\x10jζｗ％ν\x01\x1eτ]μＴ␘␁\t:",
		out:  "FA\x10␟π\x11νA\x0e（\tｘ␒＂\x10jζｗ％ν\x01\x1eτ]μＴ␘␁\t:",
	}, { // 4036
		mask: EncodePipe | EncodeRightCrLfHtVt,
		in:   "FA\x10␟π\x11νA\x0e（\tｘ␒＂\x10jζｗ％ν\x01\x1eτ]μＴ␘␁␉:",
		out:  "FA\x10␟π\x11νA\x0e（\tｘ␒＂\x10jζｗ％ν\x01\x1eτ]μＴ␘␁␉:",
	}, { // 4037
		mask: EncodePipe | EncodeRightCrLfHtVt,
		in:   "FA\x10␟π\x11νA\x0e（\tｘ␒＂\x10jζｗ％ν\x01\x1eτ]μＴ␘␁\t␉",
		out:  "FA\x10␟π\x11νA\x0e（\tｘ␒＂\x10jζｗ％ν\x01\x1eτ]μＴ␘␁\t‛␉",
	}, { // 4038
		mask: EncodePipe | EncodeRightCrLfHtVt,
		in:   "FA\x10␟π\x11νA\x0e（\tｘ␒＂\x10jζｗ％ν\x01\x1eτ]μＴ␘␁␉␉",
		out:  "FA\x10␟π\x11νA\x0e（\tｘ␒＂\x10jζｗ％ν\x01\x1eτ]μＴ␘␁␉‛␉",
	}, { // 4039
		mask: EncodePipe | EncodeRightCrLfHtVt,
		in:   "FA\x10␟π\x11νA\x0e（\tｘ␒＂\x10jζｗ％ν\x01\x1eτ]μＴ␘␁Ｇ\t",
		out:  "FA\x10␟π\x11νA\x0e（\tｘ␒＂\x10jζｗ％ν\x01\x1eτ]μＴ␘␁Ｇ␉",
	}, { // 4040
		mask: EncodePipe | EncodeRightCrLfHtVt,
		in:   "FA\x10␟π\x11νA\x0e（\tｘ␒＂\x10jζｗ％ν\x01\x1eτ]μＴ␘␁Ｇ␉",
		out:  "FA\x10␟π\x11νA\x0e（\tｘ␒＂\x10jζｗ％ν\x01\x1eτ]μＴ␘␁Ｇ‛␉",
	}, { // 4041
		mask: EncodePipe | EncodeRightCrLfHtVt,
		in:   "␑＞V｛\x1cγ|｝ο\x13\nＱf␁σχZ?ε＊；Y\n␘J␘ρOＪ\a",
		out:  "␑＞V｛\x1cγ｜｝ο\x13\nＱf␁σχZ?ε＊；Y\n␘J␘ρOＪ\a",
	}, { // 4042
		mask: EncodePipe | EncodeRightCrLfHtVt,
		in:   "\n␊V｛\x1cγ|｝ο\x13\nＱf␁σχZ?ε＊；Y\n␘J␘ρOＪ\a",
		out:  "\n␊V｛\x1cγ｜｝ο\x13\nＱf␁σχZ?ε＊；Y\n␘J␘ρOＪ\a",
	}, { // 4043
		mask: EncodePipe | EncodeRightCrLfHtVt,
		in:   "␊␊V｛\x1cγ|｝ο\x13\nＱf␁σχZ?ε＊；Y\n␘J␘ρOＪ\a",
		out:  "␊␊V｛\x1cγ｜｝ο\x13\nＱf␁σχZ?ε＊；Y\n␘J␘ρOＪ\a",
	}, { // 4044
		mask: EncodePipe | EncodeRightCrLfHtVt,
		in:   "\n＞V｛\x1cγ|｝ο\x13\nＱf␁σχZ?ε＊；Y\n␘J␘ρO␊\a",
		out:  "\n＞V｛\x1cγ｜｝ο\x13\nＱf␁σχZ?ε＊；Y\n␘J␘ρO␊\a",
	}, { // 4045
		mask: EncodePipe | EncodeRightCrLfHtVt,
		in:   "␊＞V｛\x1cγ|｝ο\x13\nＱf␁σχZ?ε＊；Y\n␘J␘ρO␊\a",
		out:  "␊＞V｛\x1cγ｜｝ο\x13\nＱf␁σχZ?ε＊；Y\n␘J␘ρO␊\a",
	}, { // 4046
		mask: EncodePipe | EncodeRightCrLfHtVt,
		in:   "\n＞V｛\x1cγ|｝ο\x13\nＱf␁σχZ?ε＊；Y\n␘J␘ρOＪ␊",
		out:  "\n＞V｛\x1cγ｜｝ο\x13\nＱf␁σχZ?ε＊；Y\n␘J␘ρOＪ‛␊",
	}, { // 4047
		mask: EncodePipe | EncodeRightCrLfHtVt,
		in:   "␊＞V｛\x1cγ|｝ο\x13\nＱf␁σχZ?ε＊；Y\n␘J␘ρOＪ␊",
		out:  "␊＞V｛\x1cγ｜｝ο\x13\nＱf␁σχZ?ε＊；Y\n␘J␘ρOＪ‛␊",
	}, { // 4048
		mask: EncodePipe | EncodeRightCrLfHtVt,
		in:   "␑\nV｛\x1cγ|｝ο\x13\nＱf␁σχZ?ε＊；Y\n␘J␘ρOＪ\a",
		out:  "␑\nV｛\x1cγ｜｝ο\x13\nＱf␁σχZ?ε＊；Y\n␘J␘ρOＪ\a",
	}, { // 4049
		mask: EncodePipe | EncodeRightCrLfHtVt,
		in:   "␑␊V｛\x1cγ|｝ο\x13\nＱf␁σχZ?ε＊；Y\n␘J␘ρOＪ\a",
		out:  "␑␊V｛\x1cγ｜｝ο\x13\nＱf␁σχZ?ε＊；Y\n␘J␘ρOＪ\a",
	}, { // 4050
		mask: EncodePipe | EncodeRightCrLfHtVt,
		in:   "␑\nV｛\x1cγ|｝ο\x13\nＱf␁σχZ?ε＊；Y\n␘J␘ρO␊\a",
		out:  "␑\nV｛\x1cγ｜｝ο\x13\nＱf␁σχZ?ε＊；Y\n␘J␘ρO␊\a",
	}, { // 4051
		mask: EncodePipe | EncodeRightCrLfHtVt,
		in:   "␑␊V｛\x1cγ|｝ο\x13\nＱf␁σχZ?ε＊；Y\n␘J␘ρO␊\a",
		out:  "␑␊V｛\x1cγ｜｝ο\x13\nＱf␁σχZ?ε＊；Y\n␘J␘ρO␊\a",
	}, { // 4052
		mask: EncodePipe | EncodeRightCrLfHtVt,
		in:   "␑\nV｛\x1cγ|｝ο\x13\nＱf␁σχZ?ε＊；Y\n␘J␘ρOＪ␊",
		out:  "␑\nV｛\x1cγ｜｝ο\x13\nＱf␁σχZ?ε＊；Y\n␘J␘ρOＪ‛␊",
	}, { // 4053
		mask: EncodePipe | EncodeRightCrLfHtVt,
		in:   "␑␊V｛\x1cγ|｝ο\x13\nＱf␁σχZ?ε＊；Y\n␘J␘ρOＪ␊",
		out:  "␑␊V｛\x1cγ｜｝ο\x13\nＱf␁σχZ?ε＊；Y\n␘J␘ρOＪ‛␊",
	}, { // 4054
		mask: EncodePipe | EncodeRightCrLfHtVt,
		in:   "␑＞V｛\x1cγ|｝ο\x13\nＱf␁σχZ?ε＊；Y\n␘J␘ρO\n\a",
		out:  "␑＞V｛\x1cγ｜｝ο\x13\nＱf␁σχZ?ε＊；Y\n␘J␘ρO\n\a",
	}, { // 4055
		mask: EncodePipe | EncodeRightCrLfHtVt,
		in:   "␑＞V｛\x1cγ|｝ο\x13\nＱf␁σχZ?ε＊；Y\n␘J␘ρO␊\a",
		out:  "␑＞V｛\x1cγ｜｝ο\x13\nＱf␁σχZ?ε＊；Y\n␘J␘ρO␊\a",
	}, { // 4056
		mask: EncodePipe | EncodeRightCrLfHtVt,
		in:   "␑＞V｛\x1cγ|｝ο\x13\nＱf␁σχZ?ε＊；Y\n␘J␘ρO\n␊",
		out:  "␑＞V｛\x1cγ｜｝ο\x13\nＱf␁σχZ?ε＊；Y\n␘J␘ρO\n‛␊",
	}, { // 4057
		mask: EncodePipe | EncodeRightCrLfHtVt,
		in:   "␑＞V｛\x1cγ|｝ο\x13\nＱf␁σχZ?ε＊；Y\n␘J␘ρO␊␊",
		out:  "␑＞V｛\x1cγ｜｝ο\x13\nＱf␁σχZ?ε＊；Y\n␘J␘ρO␊‛␊",
	}, { // 4058
		mask: EncodePipe | EncodeRightCrLfHtVt,
		in:   "␑＞V｛\x1cγ|｝ο\x13\nＱf␁σχZ?ε＊；Y\n␘J␘ρOＪ\n",
		out:  "␑＞V｛\x1cγ｜｝ο\x13\nＱf␁σχZ?ε＊；Y\n␘J␘ρOＪ␊",
	}, { // 4059
		mask: EncodePipe | EncodeRightCrLfHtVt,
		in:   "␑＞V｛\x1cγ|｝ο\x13\nＱf␁σχZ?ε＊；Y\n␘J␘ρOＪ␊",
		out:  "␑＞V｛\x1cγ｜｝ο\x13\nＱf␁σχZ?ε＊；Y\n␘J␘ρOＪ‛␊",
	}, { // 4060
		mask: EncodePipe | EncodeRightCrLfHtVt,
		in:   "ｇ（=0ξ\x1cδ＞]w\vNδ\uff00／␔Ｃ\x12:␝\tεjε％ρ;ｖ>␝",
		out:  "ｇ（=0ξ\x1cδ＞]w\vNδ\uff00／␔Ｃ\x12:␝\tεjε％ρ;ｖ>␝",
	}, { // 4061
		mask: EncodePipe | EncodeRightCrLfHtVt,
		in:   "\v␋=0ξ\x1cδ＞]w\vNδ\uff00／␔Ｃ\x12:␝\tεjε％ρ;ｖ>␝",
		out:  "\v␋=0ξ\x1cδ＞]w\vNδ\uff00／␔Ｃ\x12:␝\tεjε％ρ;ｖ>␝",
	}, { // 4062
		mask: EncodePipe | EncodeRightCrLfHtVt,
		in:   "␋␋=0ξ\x1cδ＞]w\vNδ\uff00／␔Ｃ\x12:␝\tεjε％ρ;ｖ>␝",
		out:  "␋␋=0ξ\x1cδ＞]w\vNδ\uff00／␔Ｃ\x12:␝\tεjε％ρ;ｖ>␝",
	}, { // 4063
		mask: EncodePipe | EncodeRightCrLfHtVt,
		in:   "\v（=0ξ\x1cδ＞]w\vNδ\uff00／␔Ｃ\x12:␝\tεjε％ρ;ｖ␋␝",
		out:  "\v（=0ξ\x1cδ＞]w\vNδ\uff00／␔Ｃ\x12:␝\tεjε％ρ;ｖ␋␝",
	}, { // 4064
		mask: EncodePipe | EncodeRightCrLfHtVt,
		in:   "␋（=0ξ\x1cδ＞]w\vNδ\uff00／␔Ｃ\x12:␝\tεjε％ρ;ｖ␋␝",
		out:  "␋（=0ξ\x1cδ＞]w\vNδ\uff00／␔Ｃ\x12:␝\tεjε％ρ;ｖ␋␝",
	}, { // 4065
		mask: EncodePipe | EncodeRightCrLfHtVt,
		in:   "\v（=0ξ\x1cδ＞]w\vNδ\uff00／␔Ｃ\x12:␝\tεjε％ρ;ｖ>␋",
		out:  "\v（=0ξ\x1cδ＞]w\vNδ\uff00／␔Ｃ\x12:␝\tεjε％ρ;ｖ>‛␋",
	}, { // 4066
		mask: EncodePipe | EncodeRightCrLfHtVt,
		in:   "␋（=0ξ\x1cδ＞]w\vNδ\uff00／␔Ｃ\x12:␝\tεjε％ρ;ｖ>␋",
		out:  "␋（=0ξ\x1cδ＞]w\vNδ\uff00／␔Ｃ\x12:␝\tεjε％ρ;ｖ>‛␋",
	}, { // 4067
		mask: EncodePipe | EncodeRightCrLfHtVt,
		in:   "ｇ\v=0ξ\x1cδ＞]w\vNδ\uff00／␔Ｃ\x12:␝\tεjε％ρ;ｖ>␝",
		out:  "ｇ\v=0ξ\x1cδ＞]w\vNδ\uff00／␔Ｃ\x12:␝\tεjε％ρ;ｖ>␝",
	}, { // 4068
		mask: EncodePipe | EncodeRightCrLfHtVt,
		in:   "ｇ␋=0ξ\x1cδ＞]w\vNδ\uff00／␔Ｃ\x12:␝\tεjε％ρ;ｖ>␝",
		out:  "ｇ␋=0ξ\x1cδ＞]w\vNδ\uff00／␔Ｃ\x12:␝\tεjε％ρ;ｖ>␝",
	}, { // 4069
		mask: EncodePipe | EncodeRightCrLfHtVt,
		in:   "ｇ\v=0ξ\x1cδ＞]w\vNδ\uff00／␔Ｃ\x12:␝\tεjε％ρ;ｖ␋␝",
		out:  "ｇ\v=0ξ\x1cδ＞]w\vNδ\uff00／␔Ｃ\x12:␝\tεjε％ρ;ｖ␋␝",
	}, { // 4070
		mask: EncodePipe | EncodeRightCrLfHtVt,
		in:   "ｇ␋=0ξ\x1cδ＞]w\vNδ\uff00／␔Ｃ\x12:␝\tεjε％ρ;ｖ␋␝",
		out:  "ｇ␋=0ξ\x1cδ＞]w\vNδ\uff00／␔Ｃ\x12:␝\tεjε％ρ;ｖ␋␝",
	}, { // 4071
		mask: EncodePipe | EncodeRightCrLfHtVt,
		in:   "ｇ\v=0ξ\x1cδ＞]w\vNδ\uff00／␔Ｃ\x12:␝\tεjε％ρ;ｖ>␋",
		out:  "ｇ\v=0ξ\x1cδ＞]w\vNδ\uff00／␔Ｃ\x12:␝\tεjε％ρ;ｖ>‛␋",
	}, { // 4072
		mask: EncodePipe | EncodeRightCrLfHtVt,
		in:   "ｇ␋=0ξ\x1cδ＞]w\vNδ\uff00／␔Ｃ\x12:␝\tεjε％ρ;ｖ>␋",
		out:  "ｇ␋=0ξ\x1cδ＞]w\vNδ\uff00／␔Ｃ\x12:␝\tεjε％ρ;ｖ>‛␋",
	}, { // 4073
		mask: EncodePipe | EncodeRightCrLfHtVt,
		in:   "ｇ（=0ξ\x1cδ＞]w\vNδ\uff00／␔Ｃ\x12:␝\tεjε％ρ;ｖ\v␝",
		out:  "ｇ（=0ξ\x1cδ＞]w\vNδ\uff00／␔Ｃ\x12:␝\tεjε％ρ;ｖ\v␝",
	}, { // 4074
		mask: EncodePipe | EncodeRightCrLfHtVt,
		in:   "ｇ（=0ξ\x1cδ＞]w\vNδ\uff00／␔Ｃ\x12:␝\tεjε％ρ;ｖ␋␝",
		out:  "ｇ（=0ξ\x1cδ＞]w\vNδ\uff00／␔Ｃ\x12:␝\tεjε％ρ;ｖ␋␝",
	}, { // 4075
		mask: EncodePipe | EncodeRightCrLfHtVt,
		in:   "ｇ（=0ξ\x1cδ＞]w\vNδ\uff00／␔Ｃ\x12:␝\tεjε％ρ;ｖ\v␋",
		out:  "ｇ（=0ξ\x1cδ＞]w\vNδ\uff00／␔Ｃ\x12:␝\tεjε％ρ;ｖ\v‛␋",
	}, { // 4076
		mask: EncodePipe | EncodeRightCrLfHtVt,
		in:   "ｇ（=0ξ\x1cδ＞]w\vNδ\uff00／␔Ｃ\x12:␝\tεjε％ρ;ｖ␋␋",
		out:  "ｇ（=0ξ\x1cδ＞]w\vNδ\uff00／␔Ｃ\x12:␝\tεjε％ρ;ｖ␋‛␋",
	}, { // 4077
		mask: EncodePipe | EncodeRightCrLfHtVt,
		in:   "ｇ（=0ξ\x1cδ＞]w\vNδ\uff00／␔Ｃ\x12:␝\tεjε％ρ;ｖ>\v",
		out:  "ｇ（=0ξ\x1cδ＞]w\vNδ\uff00／␔Ｃ\x12:␝\tεjε％ρ;ｖ>␋",
	}, { // 4078
		mask: EncodePipe | EncodeRightCrLfHtVt,
		in:   "ｇ（=0ξ\x1cδ＞]w\vNδ\uff00／␔Ｃ\x12:␝\tεjε％ρ;ｖ>␋",
		out:  "ｇ（=0ξ\x1cδ＞]w\vNδ\uff00／␔Ｃ\x12:␝\tεjε％ρ;ｖ>‛␋",
	}, { // 4079
		mask: EncodePipe | EncodeRightCrLfHtVt,
		in:   "k=］\nｅτξ\x18ρ\x1f\r｀␚\nZωK\x11dＶαε＝␃␕␈@＋␗Ｙ",
		out:  "k=］\nｅτξ\x18ρ\x1f\r｀␚\nZωK\x11dＶαε＝␃␕␈@＋␗Ｙ",
	}, { // 4080
		mask: EncodePipe | EncodeRightCrLfHtVt,
		in:   "\r␍］\nｅτξ\x18ρ\x1f\r｀␚\nZωK\x11dＶαε＝␃␕␈@＋␗Ｙ",
		out:  "\r␍］\nｅτξ\x18ρ\x1f\r｀␚\nZωK\x11dＶαε＝␃␕␈@＋␗Ｙ",
	}, { // 4081
		mask: EncodePipe | EncodeRightCrLfHtVt,
		in:   "␍␍］\nｅτξ\x18ρ\x1f\r｀␚\nZωK\x11dＶαε＝␃␕␈@＋␗Ｙ",
		out:  "␍␍］\nｅτξ\x18ρ\x1f\r｀␚\nZωK\x11dＶαε＝␃␕␈@＋␗Ｙ",
	}, { // 4082
		mask: EncodePipe | EncodeRightCrLfHtVt,
		in:   "\r=］\nｅτξ\x18ρ\x1f\r｀␚\nZωK\x11dＶαε＝␃␕␈@＋␍Ｙ",
		out:  "\r=］\nｅτξ\x18ρ\x1f\r｀␚\nZωK\x11dＶαε＝␃␕␈@＋␍Ｙ",
	}, { // 4083
		mask: EncodePipe | EncodeRightCrLfHtVt,
		in:   "␍=］\nｅτξ\x18ρ\x1f\r｀␚\nZωK\x11dＶαε＝␃␕␈@＋␍Ｙ",
		out:  "␍=］\nｅτξ\x18ρ\x1f\r｀␚\nZωK\x11dＶαε＝␃␕␈@＋␍Ｙ",
	}, { // 4084
		mask: EncodePipe | EncodeRightCrLfHtVt,
		in:   "\r=］\nｅτξ\x18ρ\x1f\r｀␚\nZωK\x11dＶαε＝␃␕␈@＋␗␍",
		out:  "\r=］\nｅτξ\x18ρ\x1f\r｀␚\nZωK\x11dＶαε＝␃␕␈@＋␗‛␍",
	}, { // 4085
		mask: EncodePipe | EncodeRightCrLfHtVt,
		in:   "␍=］\nｅτξ\x18ρ\x1f\r｀␚\nZωK\x11dＶαε＝␃␕␈@＋␗␍",
		out:  "␍=］\nｅτξ\x18ρ\x1f\r｀␚\nZωK\x11dＶαε＝␃␕␈@＋␗‛␍",
	}, { // 4086
		mask: EncodePipe | EncodeRightCrLfHtVt,
		in:   "k\r］\nｅτξ\x18ρ\x1f\r｀␚\nZωK\x11dＶαε＝␃␕␈@＋␗Ｙ",
		out:  "k\r］\nｅτξ\x18ρ\x1f\r｀␚\nZωK\x11dＶαε＝␃␕␈@＋␗Ｙ",
	}, { // 4087
		mask: EncodePipe | EncodeRightCrLfHtVt,
		in:   "k␍］\nｅτξ\x18ρ\x1f\r｀␚\nZωK\x11dＶαε＝␃␕␈@＋␗Ｙ",
		out:  "k␍］\nｅτξ\x18ρ\x1f\r｀␚\nZωK\x11dＶαε＝␃␕␈@＋␗Ｙ",
	}, { // 4088
		mask: EncodePipe | EncodeRightCrLfHtVt,
		in:   "k\r］\nｅτξ\x18ρ\x1f\r｀␚\nZωK\x11dＶαε＝␃␕␈@＋␍Ｙ",
		out:  "k\r］\nｅτξ\x18ρ\x1f\r｀␚\nZωK\x11dＶαε＝␃␕␈@＋␍Ｙ",
	}, { // 4089
		mask: EncodePipe | EncodeRightCrLfHtVt,
		in:   "k␍］\nｅτξ\x18ρ\x1f\r｀␚\nZωK\x11dＶαε＝␃␕␈@＋␍Ｙ",
		out:  "k␍］\nｅτξ\x18ρ\x1f\r｀␚\nZωK\x11dＶαε＝␃␕␈@＋␍Ｙ",
	}, { // 4090
		mask: EncodePipe | EncodeRightCrLfHtVt,
		in:   "k\r］\nｅτξ\x18ρ\x1f\r｀␚\nZωK\x11dＶαε＝␃␕␈@＋␗␍",
		out:  "k\r］\nｅτξ\x18ρ\x1f\r｀␚\nZωK\x11dＶαε＝␃␕␈@＋␗‛␍",
	}, { // 4091
		mask: EncodePipe | EncodeRightCrLfHtVt,
		in:   "k␍］\nｅτξ\x18ρ\x1f\r｀␚\nZωK\x11dＶαε＝␃␕␈@＋␗␍",
		out:  "k␍］\nｅτξ\x18ρ\x1f\r｀␚\nZωK\x11dＶαε＝␃␕␈@＋␗‛␍",
	}, { // 4092
		mask: EncodePipe | EncodeRightCrLfHtVt,
		in:   "k=］\nｅτξ\x18ρ\x1f\r｀␚\nZωK\x11dＶαε＝␃␕␈@＋\rＹ",
		out:  "k=］\nｅτξ\x18ρ\x1f\r｀␚\nZωK\x11dＶαε＝␃␕␈@＋\rＹ",
	}, { // 4093
		mask: EncodePipe | EncodeRightCrLfHtVt,
		in:   "k=］\nｅτξ\x18ρ\x1f\r｀␚\nZωK\x11dＶαε＝␃␕␈@＋␍Ｙ",
		out:  "k=］\nｅτξ\x18ρ\x1f\r｀␚\nZωK\x11dＶαε＝␃␕␈@＋␍Ｙ",
	}, { // 4094
		mask: EncodePipe | EncodeRightCrLfHtVt,
		in:   "k=］\nｅτξ\x18ρ\x1f\r｀␚\nZωK\x11dＶαε＝␃␕␈@＋\r␍",
		out:  "k=］\nｅτξ\x18ρ\x1f\r｀␚\nZωK\x11dＶαε＝␃␕␈@＋\r‛␍",
	}, { // 4095
		mask: EncodePipe | EncodeRightCrLfHtVt,
		in:   "k=］\nｅτξ\x18ρ\x1f\r｀␚\nZωK\x11dＶαε＝␃␕␈@＋␍␍",
		out:  "k=］\nｅτξ\x18ρ\x1f\r｀␚\nZωK\x11dＶαε＝␃␕␈@＋␍‛␍",
	}, { // 4096
		mask: EncodePipe | EncodeRightCrLfHtVt,
		in:   "k=］\nｅτξ\x18ρ\x1f\r｀␚\nZωK\x11dＶαε＝␃␕␈@＋␗\r",
		out:  "k=］\nｅτξ\x18ρ\x1f\r｀␚\nZωK\x11dＶαε＝␃␕␈@＋␗␍",
	}, { // 4097
		mask: EncodePipe | EncodeRightCrLfHtVt,
		in:   "k=］\nｅτξ\x18ρ\x1f\r｀␚\nZωK\x11dＶαε＝␃␕␈@＋␗␍",
		out:  "k=］\nｅτξ\x18ρ\x1f\r｀␚\nZωK\x11dＶαε＝␃␕␈@＋␗‛␍",
	}, { // 4098
		mask: EncodeHash | EncodeRightCrLfHtVt,
		in:   "\x12:p␂␙b*a．D\tζα\x03\x13ｙＹ␎ρ(␑＿ξＶη]␘#＆␟",
		out:  "\x12:p␂␙b*a．D\tζα\x03\x13ｙＹ␎ρ(␑＿ξＶη]␘＃＆␟",
	}, { // 4099
		mask: EncodeHash | EncodeRightCrLfHtVt,
		in:   "\t␉p␂␙b*a．D\tζα\x03\x13ｙＹ␎ρ(␑＿ξＶη]␘#＆␟",
		out:  "\t␉p␂␙b*a．D\tζα\x03\x13ｙＹ␎ρ(␑＿ξＶη]␘＃＆␟",
	}, { // 4100
		mask: EncodeHash | EncodeRightCrLfHtVt,
		in:   "␉␉p␂␙b*a．D\tζα\x03\x13ｙＹ␎ρ(␑＿ξＶη]␘#＆␟",
		out:  "␉␉p␂␙b*a．D\tζα\x03\x13ｙＹ␎ρ(␑＿ξＶη]␘＃＆␟",
	}, { // 4101
		mask: EncodeHash | EncodeRightCrLfHtVt,
		in:   "\t:p␂␙b*a．D\tζα\x03\x13ｙＹ␎ρ(␑＿ξＶη]␘#␉␟",
		out:  "\t:p␂␙b*a．D\tζα\x03\x13ｙＹ␎ρ(␑＿ξＶη]␘＃␉␟",
	}, { // 4102
		mask: EncodeHash | EncodeRightCrLfHtVt,
		in:   "␉:p␂␙b*a．D\tζα\x03\x13ｙＹ␎ρ(␑＿ξＶη]␘#␉␟",
		out:  "␉:p␂␙b*a．D\tζα\x03\x13ｙＹ␎ρ(␑＿ξＶη]␘＃␉␟",
	}, { // 4103
		mask: EncodeHash | EncodeRightCrLfHtVt,
		in:   "\t:p␂␙b*a．D\tζα\x03\x13ｙＹ␎ρ(␑＿ξＶη]␘#＆␉",
		out:  "\t:p␂␙b*a．D\tζα\x03\x13ｙＹ␎ρ(␑＿ξＶη]␘＃＆‛␉",
	}, { // 4104
		mask: EncodeHash | EncodeRightCrLfHtVt,
		in:   "␉:p␂␙b*a．D\tζα\x03\x13ｙＹ␎ρ(␑＿ξＶη]␘#＆␉",
		out:  "␉:p␂␙b*a．D\tζα\x03\x13ｙＹ␎ρ(␑＿ξＶη]␘＃＆‛␉",
	}, { // 4105
		mask: EncodeHash | EncodeRightCrLfHtVt,
		in:   "\x12\tp␂␙b*a．D\tζα\x03\x13ｙＹ␎ρ(␑＿ξＶη]␘#＆␟",
		out:  "\x12\tp␂␙b*a．D\tζα\x03\x13ｙＹ␎ρ(␑＿ξＶη]␘＃＆␟",
	}, { // 4106
		mask: EncodeHash | EncodeRightCrLfHtVt,
		in:   "\x12␉p␂␙b*a．D\tζα\x03\x13ｙＹ␎ρ(␑＿ξＶη]␘#＆␟",
		out:  "\x12␉p␂␙b*a．D\tζα\x03\x13ｙＹ␎ρ(␑＿ξＶη]␘＃＆␟",
	}, { // 4107
		mask: EncodeHash | EncodeRightCrLfHtVt,
		in:   "\x12\tp␂␙b*a．D\tζα\x03\x13ｙＹ␎ρ(␑＿ξＶη]␘#␉␟",
		out:  "\x12\tp␂␙b*a．D\tζα\x03\x13ｙＹ␎ρ(␑＿ξＶη]␘＃␉␟",
	}, { // 4108
		mask: EncodeHash | EncodeRightCrLfHtVt,
		in:   "\x12␉p␂␙b*a．D\tζα\x03\x13ｙＹ␎ρ(␑＿ξＶη]␘#␉␟",
		out:  "\x12␉p␂␙b*a．D\tζα\x03\x13ｙＹ␎ρ(␑＿ξＶη]␘＃␉␟",
	}, { // 4109
		mask: EncodeHash | EncodeRightCrLfHtVt,
		in:   "\x12\tp␂␙b*a．D\tζα\x03\x13ｙＹ␎ρ(␑＿ξＶη]␘#＆␉",
		out:  "\x12\tp␂␙b*a．D\tζα\x03\x13ｙＹ␎ρ(␑＿ξＶη]␘＃＆‛␉",
	}, { // 4110
		mask: EncodeHash | EncodeRightCrLfHtVt,
		in:   "\x12␉p␂␙b*a．D\tζα\x03\x13ｙＹ␎ρ(␑＿ξＶη]␘#＆␉",
		out:  "\x12␉p␂␙b*a．D\tζα\x03\x13ｙＹ␎ρ(␑＿ξＶη]␘＃＆‛␉",
	}, { // 4111
		mask: EncodeHash | EncodeRightCrLfHtVt,
		in:   "\x12:p␂␙b*a．D\tζα\x03\x13ｙＹ␎ρ(␑＿ξＶη]␘#\t␟",
		out:  "\x12:p␂␙b*a．D\tζα\x03\x13ｙＹ␎ρ(␑＿ξＶη]␘＃\t␟",
	}, { // 4112
		mask: EncodeHash | EncodeRightCrLfHtVt,
		in:   "\x12:p␂␙b*a．D\tζα\x03\x13ｙＹ␎ρ(␑＿ξＶη]␘#␉␟",
		out:  "\x12:p␂␙b*a．D\tζα\x03\x13ｙＹ␎ρ(␑＿ξＶη]␘＃␉␟",
	}, { // 4113
		mask: EncodeHash | EncodeRightCrLfHtVt,
		in:   "\x12:p␂␙b*a．D\tζα\x03\x13ｙＹ␎ρ(␑＿ξＶη]␘#\t␉",
		out:  "\x12:p␂␙b*a．D\tζα\x03\x13ｙＹ␎ρ(␑＿ξＶη]␘＃\t‛␉",
	}, { // 4114
		mask: EncodeHash | EncodeRightCrLfHtVt,
		in:   "\x12:p␂␙b*a．D\tζα\x03\x13ｙＹ␎ρ(␑＿ξＶη]␘#␉␉",
		out:  "\x12:p␂␙b*a．D\tζα\x03\x13ｙＹ␎ρ(␑＿ξＶη]␘＃␉‛␉",
	}, { // 4115
		mask: EncodeHash | EncodeRightCrLfHtVt,
		in:   "\x12:p␂␙b*a．D\tζα\x03\x13ｙＹ␎ρ(␑＿ξＶη]␘#＆\t",
		out:  "\x12:p␂␙b*a．D\tζα\x03\x13ｙＹ␎ρ(␑＿ξＶη]␘＃＆␉",
	}, { // 4116
		mask: EncodeHash | EncodeRightCrLfHtVt,
		in:   "\x12:p␂␙b*a．D\tζα\x03\x13ｙＹ␎ρ(␑＿ξＶη]␘#＆␉",
		out:  "\x12:p␂␙b*a．D\tζα\x03\x13ｙＹ␎ρ(␑＿ξＶη]␘＃＆‛␉",
	}, { // 4117
		mask: EncodeHash | EncodeRightCrLfHtVt,
		in:   "\x13．＞；ι␊\"］`w\nμω＝`\x10\\αχ␊%␔?|Ｕι＇Ｙ\x14９",
		out:  "\x13．＞；ι␊\"］`w\nμω＝`\x10\\αχ␊%␔?|Ｕι＇Ｙ\x14９",
	}, { // 4118
		mask: EncodeHash | EncodeRightCrLfHtVt,
		in:   "\n␊＞；ι␊\"］`w\nμω＝`\x10\\αχ␊%␔?|Ｕι＇Ｙ\x14９",
		out:  "\n␊＞；ι␊\"］`w\nμω＝`\x10\\αχ␊%␔?|Ｕι＇Ｙ\x14９",
	}, { // 4119
		mask: EncodeHash | EncodeRightCrLfHtVt,
		in:   "␊␊＞；ι␊\"］`w\nμω＝`\x10\\αχ␊%␔?|Ｕι＇Ｙ\x14９",
		out:  "␊␊＞；ι␊\"］`w\nμω＝`\x10\\αχ␊%␔?|Ｕι＇Ｙ\x14９",
	}, { // 4120
		mask: EncodeHash | EncodeRightCrLfHtVt,
		in:   "\n．＞；ι␊\"］`w\nμω＝`\x10\\αχ␊%␔?|Ｕι＇Ｙ␊９",
		out:  "\n．＞；ι␊\"］`w\nμω＝`\x10\\αχ␊%␔?|Ｕι＇Ｙ␊９",
	}, { // 4121
		mask: EncodeHash | EncodeRightCrLfHtVt,
		in:   "␊．＞；ι␊\"］`w\nμω＝`\x10\\αχ␊%␔?|Ｕι＇Ｙ␊９",
		out:  "␊．＞；ι␊\"］`w\nμω＝`\x10\\αχ␊%␔?|Ｕι＇Ｙ␊９",
	}, { // 4122
		mask: EncodeHash | EncodeRightCrLfHtVt,
		in:   "\n．＞；ι␊\"］`w\nμω＝`\x10\\αχ␊%␔?|Ｕι＇Ｙ\x14␊",
		out:  "\n．＞；ι␊\"］`w\nμω＝`\x10\\αχ␊%␔?|Ｕι＇Ｙ\x14‛␊",
	}, { // 4123
		mask: EncodeHash | EncodeRightCrLfHtVt,
		in:   "␊．＞；ι␊\"］`w\nμω＝`\x10\\αχ␊%␔?|Ｕι＇Ｙ\x14␊",
		out:  "␊．＞；ι␊\"］`w\nμω＝`\x10\\αχ␊%␔?|Ｕι＇Ｙ\x14‛␊",
	}, { // 4124
		mask: EncodeHash | EncodeRightCrLfHtVt,
		in:   "\x13\n＞；ι␊\"］`w\nμω＝`\x10\\αχ␊%␔?|Ｕι＇Ｙ\x14９",
		out:  "\x13\n＞；ι␊\"］`w\nμω＝`\x10\\αχ␊%␔?|Ｕι＇Ｙ\x14９",
	}, { // 4125
		mask: EncodeHash | EncodeRightCrLfHtVt,
		in:   "\x13␊＞；ι␊\"］`w\nμω＝`\x10\\αχ␊%␔?|Ｕι＇Ｙ\x14９",
		out:  "\x13␊＞；ι␊\"］`w\nμω＝`\x10\\αχ␊%␔?|Ｕι＇Ｙ\x14９",
	}, { // 4126
		mask: EncodeHash | EncodeRightCrLfHtVt,
		in:   "\x13\n＞；ι␊\"］`w\nμω＝`\x10\\αχ␊%␔?|Ｕι＇Ｙ␊９",
		out:  "\x13\n＞；ι␊\"］`w\nμω＝`\x10\\αχ␊%␔?|Ｕι＇Ｙ␊９",
	}, { // 4127
		mask: EncodeHash | EncodeRightCrLfHtVt,
		in:   "\x13␊＞；ι␊\"］`w\nμω＝`\x10\\αχ␊%␔?|Ｕι＇Ｙ␊９",
		out:  "\x13␊＞；ι␊\"］`w\nμω＝`\x10\\αχ␊%␔?|Ｕι＇Ｙ␊９",
	}, { // 4128
		mask: EncodeHash | EncodeRightCrLfHtVt,
		in:   "\x13\n＞；ι␊\"］`w\nμω＝`\x10\\αχ␊%␔?|Ｕι＇Ｙ\x14␊",
		out:  "\x13\n＞；ι␊\"］`w\nμω＝`\x10\\αχ␊%␔?|Ｕι＇Ｙ\x14‛␊",
	}, { // 4129
		mask: EncodeHash | EncodeRightCrLfHtVt,
		in:   "\x13␊＞；ι␊\"］`w\nμω＝`\x10\\αχ␊%␔?|Ｕι＇Ｙ\x14␊",
		out:  "\x13␊＞；ι␊\"］`w\nμω＝`\x10\\αχ␊%␔?|Ｕι＇Ｙ\x14‛␊",
	}, { // 4130
		mask: EncodeHash | EncodeRightCrLfHtVt,
		in:   "\x13．＞；ι␊\"］`w\nμω＝`\x10\\αχ␊%␔?|Ｕι＇Ｙ\n９",
		out:  "\x13．＞；ι␊\"］`w\nμω＝`\x10\\αχ␊%␔?|Ｕι＇Ｙ\n９",
	}, { // 4131
		mask: EncodeHash | EncodeRightCrLfHtVt,
		in:   "\x13．＞；ι␊\"］`w\nμω＝`\x10\\αχ␊%␔?|Ｕι＇Ｙ␊９",
		out:  "\x13．＞；ι␊\"］`w\nμω＝`\x10\\αχ␊%␔?|Ｕι＇Ｙ␊９",
	}, { // 4132
		mask: EncodeHash | EncodeRightCrLfHtVt,
		in:   "\x13．＞；ι␊\"］`w\nμω＝`\x10\\αχ␊%␔?|Ｕι＇Ｙ\n␊",
		out:  "\x13．＞；ι␊\"］`w\nμω＝`\x10\\αχ␊%␔?|Ｕι＇Ｙ\n‛␊",
	}, { // 4133
		mask: EncodeHash | EncodeRightCrLfHtVt,
		in:   "\x13．＞；ι␊\"］`w\nμω＝`\x10\\αχ␊%␔?|Ｕι＇Ｙ␊␊",
		out:  "\x13．＞；ι␊\"］`w\nμω＝`\x10\\αχ␊%␔?|Ｕι＇Ｙ␊‛␊",
	}, { // 4134
		mask: EncodeHash | EncodeRightCrLfHtVt,
		in:   "\x13．＞；ι␊\"］`w\nμω＝`\x10\\αχ␊%␔?|Ｕι＇Ｙ\x14\n",
		out:  "\x13．＞；ι␊\"］`w\nμω＝`\x10\\αχ␊%␔?|Ｕι＇Ｙ\x14␊",
	}, { // 4135
		mask: EncodeHash | EncodeRightCrLfHtVt,
		in:   "\x13．＞；ι␊\"］`w\nμω＝`\x10\\αχ␊%␔?|Ｕι＇Ｙ\x14␊",
		out:  "\x13．＞；ι␊\"］`w\nμω＝`\x10\\αχ␊%␔?|Ｕι＇Ｙ\x14‛␊",
	}, { // 4136
		mask: EncodeHash | EncodeRightCrLfHtVt,
		in:   "ｃ0G␙ｋ␇\x13\n\x19γ\v␍O␆ζＲ\x04κｈς\x0fｈ／\x1f␓~οp(ι",
		out:  "ｃ0G␙ｋ␇\x13\n\x19γ\v␍O␆ζＲ\x04κｈς\x0fｈ／\x1f␓~οp(ι",
	}, { // 4137
		mask: EncodeHash | EncodeRightCrLfHtVt,
		in:   "\v␋G␙ｋ␇\x13\n\x19γ\v␍O␆ζＲ\x04κｈς\x0fｈ／\x1f␓~οp(ι",
		out:  "\v␋G␙ｋ␇\x13\n\x19γ\v␍O␆ζＲ\x04κｈς\x0fｈ／\x1f␓~οp(ι",
	}, { // 4138
		mask: EncodeHash | EncodeRightCrLfHtVt,
		in:   "␋␋G␙ｋ␇\x13\n\x19γ\v␍O␆ζＲ\x04κｈς\x0fｈ／\x1f␓~οp(ι",
		out:  "␋␋G␙ｋ␇\x13\n\x19γ\v␍O␆ζＲ\x04κｈς\x0fｈ／\x1f␓~οp(ι",
	}, { // 4139
		mask: EncodeHash | EncodeRightCrLfHtVt,
		in:   "\v0G␙ｋ␇\x13\n\x19γ\v␍O␆ζＲ\x04κｈς\x0fｈ／\x1f␓~οp␋ι",
		out:  "\v0G␙ｋ␇\x13\n\x19γ\v␍O␆ζＲ\x04κｈς\x0fｈ／\x1f␓~οp␋ι",
	}, { // 4140
		mask: EncodeHash | EncodeRightCrLfHtVt,
		in:   "␋0G␙ｋ␇\x13\n\x19γ\v␍O␆ζＲ\x04κｈς\x0fｈ／\x1f␓~οp␋ι",
		out:  "␋0G␙ｋ␇\x13\n\x19γ\v␍O␆ζＲ\x04κｈς\x0fｈ／\x1f␓~οp␋ι",
	}, { // 4141
		mask: EncodeHash | EncodeRightCrLfHtVt,
		in:   "\v0G␙ｋ␇\x13\n\x19γ\v␍O␆ζＲ\x04κｈς\x0fｈ／\x1f␓~οp(␋",
		out:  "\v0G␙ｋ␇\x13\n\x19γ\v␍O␆ζＲ\x04κｈς\x0fｈ／\x1f␓~οp(‛␋",
	}, { // 4142
		mask: EncodeHash | EncodeRightCrLfHtVt,
		in:   "␋0G␙ｋ␇\x13\n\x19γ\v␍O␆ζＲ\x04κｈς\x0fｈ／\x1f␓~οp(␋",
		out:  "␋0G␙ｋ␇\x13\n\x19γ\v␍O␆ζＲ\x04κｈς\x0fｈ／\x1f␓~οp(‛␋",
	}, { // 4143
		mask: EncodeHash | EncodeRightCrLfHtVt,
		in:   "ｃ\vG␙ｋ␇\x13\n\x19γ\v␍O␆ζＲ\x04κｈς\x0fｈ／\x1f␓~οp(ι",
		out:  "ｃ\vG␙ｋ␇\x13\n\x19γ\v␍O␆ζＲ\x04κｈς\x0fｈ／\x1f␓~οp(ι",
	}, { // 4144
		mask: EncodeHash | EncodeRightCrLfHtVt,
		in:   "ｃ␋G␙ｋ␇\x13\n\x19γ\v␍O␆ζＲ\x04κｈς\x0fｈ／\x1f␓~οp(ι",
		out:  "ｃ␋G␙ｋ␇\x13\n\x19γ\v␍O␆ζＲ\x04κｈς\x0fｈ／\x1f␓~οp(ι",
	}, { // 4145
		mask: EncodeHash | EncodeRightCrLfHtVt,
		in:   "ｃ\vG␙ｋ␇\x13\n\x19γ\v␍O␆ζＲ\x04κｈς\x0fｈ／\x1f␓~οp␋ι",
		out:  "ｃ\vG␙ｋ␇\x13\n\x19γ\v␍O␆ζＲ\x04κｈς\x0fｈ／\x1f␓~οp␋ι",
	}, { // 4146
		mask: EncodeHash | EncodeRightCrLfHtVt,
		in:   "ｃ␋G␙ｋ␇\x13\n\x19γ\v␍O␆ζＲ\x04κｈς\x0fｈ／\x1f␓~οp␋ι",
		out:  "ｃ␋G␙ｋ␇\x13\n\x19γ\v␍O␆ζＲ\x04κｈς\x0fｈ／\x1f␓~οp␋ι",
	}, { // 4147
		mask: EncodeHash | EncodeRightCrLfHtVt,
		in:   "ｃ\vG␙ｋ␇\x13\n\x19γ\v␍O␆ζＲ\x04κｈς\x0fｈ／\x1f␓~οp(␋",
		out:  "ｃ\vG␙ｋ␇\x13\n\x19γ\v␍O␆ζＲ\x04κｈς\x0fｈ／\x1f␓~οp(‛␋",
	}, { // 4148
		mask: EncodeHash | EncodeRightCrLfHtVt,
		in:   "ｃ␋G␙ｋ␇\x13\n\x19γ\v␍O␆ζＲ\x04κｈς\x0fｈ／\x1f␓~οp(␋",
		out:  "ｃ␋G␙ｋ␇\x13\n\x19γ\v␍O␆ζＲ\x04κｈς\x0fｈ／\x1f␓~οp(‛␋",
	}, { // 4149
		mask: EncodeHash | EncodeRightCrLfHtVt,
		in:   "ｃ0G␙ｋ␇\x13\n\x19γ\v␍O␆ζＲ\x04κｈς\x0fｈ／\x1f␓~οp\vι",
		out:  "ｃ0G␙ｋ␇\x13\n\x19γ\v␍O␆ζＲ\x04κｈς\x0fｈ／\x1f␓~οp\vι",
	}, { // 4150
		mask: EncodeHash | EncodeRightCrLfHtVt,
		in:   "ｃ0G␙ｋ␇\x13\n\x19γ\v␍O␆ζＲ\x04κｈς\x0fｈ／\x1f␓~οp␋ι",
		out:  "ｃ0G␙ｋ␇\x13\n\x19γ\v␍O␆ζＲ\x04κｈς\x0fｈ／\x1f␓~οp␋ι",
	}, { // 4151
		mask: EncodeHash | EncodeRightCrLfHtVt,
		in:   "ｃ0G␙ｋ␇\x13\n\x19γ\v␍O␆ζＲ\x04κｈς\x0fｈ／\x1f␓~οp\v␋",
		out:  "ｃ0G␙ｋ␇\x13\n\x19γ\v␍O␆ζＲ\x04κｈς\x0fｈ／\x1f␓~οp\v‛␋",
	}, { // 4152
		mask: EncodeHash | EncodeRightCrLfHtVt,
		in:   "ｃ0G␙ｋ␇\x13\n\x19γ\v␍O␆ζＲ\x04κｈς\x0fｈ／\x1f␓~οp␋␋",
		out:  "ｃ0G␙ｋ␇\x13\n\x19γ\v␍O␆ζＲ\x04κｈς\x0fｈ／\x1f␓~οp␋‛␋",
	}, { // 4153
		mask: EncodeHash | EncodeRightCrLfHtVt,
		in:   "ｃ0G␙ｋ␇\x13\n\x19γ\v␍O␆ζＲ\x04κｈς\x0fｈ／\x1f␓~οp(\v",
		out:  "ｃ0G␙ｋ␇\x13\n\x19γ\v␍O␆ζＲ\x04κｈς\x0fｈ／\x1f␓~οp(␋",
	}, { // 4154
		mask: EncodeHash | EncodeRightCrLfHtVt,
		in:   "ｃ0G␙ｋ␇\x13\n\x19γ\v␍O␆ζＲ\x04κｈς\x0fｈ／\x1f␓~οp(␋",
		out:  "ｃ0G␙ｋ␇\x13\n\x19γ\v␍O␆ζＲ\x04κｈς\x0fｈ／\x1f␓~οp(‛␋",
	}, { // 4155
		mask: EncodeHash | EncodeRightCrLfHtVt,
		in:   "εδπ\x1e：ｌ|SＫ`\r\x12G：～ｏμtＬ\n％φ_\x1d／Ｕ@\x1b␎␐",
		out:  "εδπ\x1e：ｌ|SＫ`\r\x12G：～ｏμtＬ\n％φ_\x1d／Ｕ@\x1b␎␐",
	}, { // 4156
		mask: EncodeHash | EncodeRightCrLfHtVt,
		in:   "\r␍π\x1e：ｌ|SＫ`\r\x12G：～ｏμtＬ\n％φ_\x1d／Ｕ@\x1b␎␐",
		out:  "\r␍π\x1e：ｌ|SＫ`\r\x12G：～ｏμtＬ\n％φ_\x1d／Ｕ@\x1b␎␐",
	}, { // 4157
		mask: EncodeHash | EncodeRightCrLfHtVt,
		in:   "␍␍π\x1e：ｌ|SＫ`\r\x12G：～ｏμtＬ\n％φ_\x1d／Ｕ@\x1b␎␐",
		out:  "␍␍π\x1e：ｌ|SＫ`\r\x12G：～ｏμtＬ\n％φ_\x1d／Ｕ@\x1b␎␐",
	}, { // 4158
		mask: EncodeHash | EncodeRightCrLfHtVt,
		in:   "\rδπ\x1e：ｌ|SＫ`\r\x12G：～ｏμtＬ\n％φ_\x1d／Ｕ@\x1b␍␐",
		out:  "\rδπ\x1e：ｌ|SＫ`\r\x12G：～ｏμtＬ\n％φ_\x1d／Ｕ@\x1b␍␐",
	}, { // 4159
		mask: EncodeHash | EncodeRightCrLfHtVt,
		in:   "␍δπ\x1e：ｌ|SＫ`\r\x12G：～ｏμtＬ\n％φ_\x1d／Ｕ@\x1b␍␐",
		out:  "␍δπ\x1e：ｌ|SＫ`\r\x12G：～ｏμtＬ\n％φ_\x1d／Ｕ@\x1b␍␐",
	}, { // 4160
		mask: EncodeHash | EncodeRightCrLfHtVt,
		in:   "\rδπ\x1e：ｌ|SＫ`\r\x12G：～ｏμtＬ\n％φ_\x1d／Ｕ@\x1b␎␍",
		out:  "\rδπ\x1e：ｌ|SＫ`\r\x12G：～ｏμtＬ\n％φ_\x1d／Ｕ@\x1b␎‛␍",
	}, { // 4161
		mask: EncodeHash | EncodeRightCrLfHtVt,
		in:   "␍δπ\x1e：ｌ|SＫ`\r\x12G：～ｏμtＬ\n％φ_\x1d／Ｕ@\x1b␎␍",
		out:  "␍δπ\x1e：ｌ|SＫ`\r\x12G：～ｏμtＬ\n％φ_\x1d／Ｕ@\x1b␎‛␍",
	}, { // 4162
		mask: EncodeHash | EncodeRightCrLfHtVt,
		in:   "ε\rπ\x1e：ｌ|SＫ`\r\x12G：～ｏμtＬ\n％φ_\x1d／Ｕ@\x1b␎␐",
		out:  "ε\rπ\x1e：ｌ|SＫ`\r\x12G：～ｏμtＬ\n％φ_\x1d／Ｕ@\x1b␎␐",
	}, { // 4163
		mask: EncodeHash | EncodeRightCrLfHtVt,
		in:   "ε␍π\x1e：ｌ|SＫ`\r\x12G：～ｏμtＬ\n％φ_\x1d／Ｕ@\x1b␎␐",
		out:  "ε␍π\x1e：ｌ|SＫ`\r\x12G：～ｏμtＬ\n％φ_\x1d／Ｕ@\x1b␎␐",
	}, { // 4164
		mask: EncodeHash | EncodeRightCrLfHtVt,
		in:   "ε\rπ\x1e：ｌ|SＫ`\r\x12G：～ｏμtＬ\n％φ_\x1d／Ｕ@\x1b␍␐",
		out:  "ε\rπ\x1e：ｌ|SＫ`\r\x12G：～ｏμtＬ\n％φ_\x1d／Ｕ@\x1b␍␐",
	}, { // 4165
		mask: EncodeHash | EncodeRightCrLfHtVt,
		in:   "ε␍π\x1e：ｌ|SＫ`\r\x12G：～ｏμtＬ\n％φ_\x1d／Ｕ@\x1b␍␐",
		out:  "ε␍π\x1e：ｌ|SＫ`\r\x12G：～ｏμtＬ\n％φ_\x1d／Ｕ@\x1b␍␐",
	}, { // 4166
		mask: EncodeHash | EncodeRightCrLfHtVt,
		in:   "ε\rπ\x1e：ｌ|SＫ`\r\x12G：～ｏμtＬ\n％φ_\x1d／Ｕ@\x1b␎␍",
		out:  "ε\rπ\x1e：ｌ|SＫ`\r\x12G：～ｏμtＬ\n％φ_\x1d／Ｕ@\x1b␎‛␍",
	}, { // 4167
		mask: EncodeHash | EncodeRightCrLfHtVt,
		in:   "ε␍π\x1e：ｌ|SＫ`\r\x12G：～ｏμtＬ\n％φ_\x1d／Ｕ@\x1b␎␍",
		out:  "ε␍π\x1e：ｌ|SＫ`\r\x12G：～ｏμtＬ\n％φ_\x1d／Ｕ@\x1b␎‛␍",
	}, { // 4168
		mask: EncodeHash | EncodeRightCrLfHtVt,
		in:   "εδπ\x1e：ｌ|SＫ`\r\x12G：～ｏμtＬ\n％φ_\x1d／Ｕ@\x1b\r␐",
		out:  "εδπ\x1e：ｌ|SＫ`\r\x12G：～ｏμtＬ\n％φ_\x1d／Ｕ@\x1b\r␐",
	}, { // 4169
		mask: EncodeHash | EncodeRightCrLfHtVt,
		in:   "εδπ\x1e：ｌ|SＫ`\r\x12G：～ｏμtＬ\n％φ_\x1d／Ｕ@\x1b␍␐",
		out:  "εδπ\x1e：ｌ|SＫ`\r\x12G：～ｏμtＬ\n％φ_\x1d／Ｕ@\x1b␍␐",
	}, { // 4170
		mask: EncodeHash | EncodeRightCrLfHtVt,
		in:   "εδπ\x1e：ｌ|SＫ`\r\x12G：～ｏμtＬ\n％φ_\x1d／Ｕ@\x1b\r␍",
		out:  "εδπ\x1e：ｌ|SＫ`\r\x12G：～ｏμtＬ\n％φ_\x1d／Ｕ@\x1b\r‛␍",
	}, { // 4171
		mask: EncodeHash | EncodeRightCrLfHtVt,
		in:   "εδπ\x1e：ｌ|SＫ`\r\x12G：～ｏμtＬ\n％φ_\x1d／Ｕ@\x1b␍␍",
		out:  "εδπ\x1e：ｌ|SＫ`\r\x12G：～ｏμtＬ\n％φ_\x1d／Ｕ@\x1b␍‛␍",
	}, { // 4172
		mask: EncodeHash | EncodeRightCrLfHtVt,
		in:   "εδπ\x1e：ｌ|SＫ`\r\x12G：～ｏμtＬ\n％φ_\x1d／Ｕ@\x1b␎\r",
		out:  "εδπ\x1e：ｌ|SＫ`\r\x12G：～ｏμtＬ\n％φ_\x1d／Ｕ@\x1b␎␍",
	}, { // 4173
		mask: EncodeHash | EncodeRightCrLfHtVt,
		in:   "εδπ\x1e：ｌ|SＫ`\r\x12G：～ｏμtＬ\n％φ_\x1d／Ｕ@\x1b␎␍",
		out:  "εδπ\x1e：ｌ|SＫ`\r\x12G：～ｏμtＬ\n％φ_\x1d／Ｕ@\x1b␎‛␍",
	}, { // 4174
		mask: EncodePercent | EncodeRightCrLfHtVt,
		in:   "％Ｉ\r|｜<\vπＰｏ\tYβ(％＜\x1f>μξ＠\"zＦ␐␋ω`ρ％",
		out:  "‛％Ｉ\r|｜<\vπＰｏ\tYβ(‛％＜\x1f>μξ＠\"zＦ␐␋ω`ρ‛％",
	}, { // 4175
		mask: EncodePercent | EncodeRightCrLfHtVt,
		in:   "\t␉\r|｜<\vπＰｏ\tYβ(％＜\x1f>μξ＠\"zＦ␐␋ω`ρ％",
		out:  "\t␉\r|｜<\vπＰｏ\tYβ(‛％＜\x1f>μξ＠\"zＦ␐␋ω`ρ‛％",
	}, { // 4176
		mask: EncodePercent | EncodeRightCrLfHtVt,
		in:   "␉␉\r|｜<\vπＰｏ\tYβ(％＜\x1f>μξ＠\"zＦ␐␋ω`ρ％",
		out:  "␉␉\r|｜<\vπＰｏ\tYβ(‛％＜\x1f>μξ＠\"zＦ␐␋ω`ρ‛％",
	}, { // 4177
		mask: EncodePercent | EncodeRightCrLfHtVt,
		in:   "\tＩ\r|｜<\vπＰｏ\tYβ(％＜\x1f>μξ＠\"zＦ␐␋ω`␉％",
		out:  "\tＩ\r|｜<\vπＰｏ\tYβ(‛％＜\x1f>μξ＠\"zＦ␐␋ω`␉‛％",
	}, { // 4178
		mask: EncodePercent | EncodeRightCrLfHtVt,
		in:   "␉Ｉ\r|｜<\vπＰｏ\tYβ(％＜\x1f>μξ＠\"zＦ␐␋ω`␉％",
		out:  "␉Ｉ\r|｜<\vπＰｏ\tYβ(‛％＜\x1f>μξ＠\"zＦ␐␋ω`␉‛％",
	}, { // 4179
		mask: EncodePercent | EncodeRightCrLfHtVt,
		in:   "\tＩ\r|｜<\vπＰｏ\tYβ(％＜\x1f>μξ＠\"zＦ␐␋ω`ρ␉",
		out:  "\tＩ\r|｜<\vπＰｏ\tYβ(‛％＜\x1f>μξ＠\"zＦ␐␋ω`ρ‛␉",
	}, { // 4180
		mask: EncodePercent | EncodeRightCrLfHtVt,
		in:   "␉Ｉ\r|｜<\vπＰｏ\tYβ(％＜\x1f>μξ＠\"zＦ␐␋ω`ρ␉",
		out:  "␉Ｉ\r|｜<\vπＰｏ\tYβ(‛％＜\x1f>μξ＠\"zＦ␐␋ω`ρ‛␉",
	}, { // 4181
		mask: EncodePercent | EncodeRightCrLfHtVt,
		in:   "％\t\r|｜<\vπＰｏ\tYβ(％＜\x1f>μξ＠\"zＦ␐␋ω`ρ％",
		out:  "‛％\t\r|｜<\vπＰｏ\tYβ(‛％＜\x1f>μξ＠\"zＦ␐␋ω`ρ‛％",
	}, { // 4182
		mask: EncodePercent | EncodeRightCrLfHtVt,
		in:   "％␉\r|｜<\vπＰｏ\tYβ(％＜\x1f>μξ＠\"zＦ␐␋ω`ρ％",
		out:  "‛％␉\r|｜<\vπＰｏ\tYβ(‛％＜\x1f>μξ＠\"zＦ␐␋ω`ρ‛％",
	}, { // 4183
		mask: EncodePercent | EncodeRightCrLfHtVt,
		in:   "％\t\r|｜<\vπＰｏ\tYβ(％＜\x1f>μξ＠\"zＦ␐␋ω`␉％",
		out:  "‛％\t\r|｜<\vπＰｏ\tYβ(‛％＜\x1f>μξ＠\"zＦ␐␋ω`␉‛％",
	}, { // 4184
		mask: EncodePercent | EncodeRightCrLfHtVt,
		in:   "％␉\r|｜<\vπＰｏ\tYβ(％＜\x1f>μξ＠\"zＦ␐␋ω`␉％",
		out:  "‛％␉\r|｜<\vπＰｏ\tYβ(‛％＜\x1f>μξ＠\"zＦ␐␋ω`␉‛％",
	}, { // 4185
		mask: EncodePercent | EncodeRightCrLfHtVt,
		in:   "％\t\r|｜<\vπＰｏ\tYβ(％＜\x1f>μξ＠\"zＦ␐␋ω`ρ␉",
		out:  "‛％\t\r|｜<\vπＰｏ\tYβ(‛％＜\x1f>μξ＠\"zＦ␐␋ω`ρ‛␉",
	}, { // 4186
		mask: EncodePercent | EncodeRightCrLfHtVt,
		in:   "％␉\r|｜<\vπＰｏ\tYβ(％＜\x1f>μξ＠\"zＦ␐␋ω`ρ␉",
		out:  "‛％␉\r|｜<\vπＰｏ\tYβ(‛％＜\x1f>μξ＠\"zＦ␐␋ω`ρ‛␉",
	}, { // 4187
		mask: EncodePercent | EncodeRightCrLfHtVt,
		in:   "％Ｉ\r|｜<\vπＰｏ\tYβ(％＜\x1f>μξ＠\"zＦ␐␋ω`\t％",
		out:  "‛％Ｉ\r|｜<\vπＰｏ\tYβ(‛％＜\x1f>μξ＠\"zＦ␐␋ω`\t‛％",
	}, { // 4188
		mask: EncodePercent | EncodeRightCrLfHtVt,
		in:   "％Ｉ\r|｜<\vπＰｏ\tYβ(％＜\x1f>μξ＠\"zＦ␐␋ω`␉％",
		out:  "‛％Ｉ\r|｜<\vπＰｏ\tYβ(‛％＜\x1f>μξ＠\"zＦ␐␋ω`␉‛％",
	}, { // 4189
		mask: EncodePercent | EncodeRightCrLfHtVt,
		in:   "％Ｉ\r|｜<\vπＰｏ\tYβ(％＜\x1f>μξ＠\"zＦ␐␋ω`\t␉",
		out:  "‛％Ｉ\r|｜<\vπＰｏ\tYβ(‛％＜\x1f>μξ＠\"zＦ␐␋ω`\t‛␉",
	}, { // 4190
		mask: EncodePercent | EncodeRightCrLfHtVt,
		in:   "％Ｉ\r|｜<\vπＰｏ\tYβ(％＜\x1f>μξ＠\"zＦ␐␋ω`␉␉",
		out:  "‛％Ｉ\r|｜<\vπＰｏ\tYβ(‛％＜\x1f>μξ＠\"zＦ␐␋ω`␉‛␉",
	}, { // 4191
		mask: EncodePercent | EncodeRightCrLfHtVt,
		in:   "％Ｉ\r|｜<\vπＰｏ\tYβ(％＜\x1f>μξ＠\"zＦ␐␋ω`ρ\t",
		out:  "‛％Ｉ\r|｜<\vπＰｏ\tYβ(‛％＜\x1f>μξ＠\"zＦ␐␋ω`ρ␉",
	}, { // 4192
		mask: EncodePercent | EncodeRightCrLfHtVt,
		in:   "％Ｉ\r|｜<\vπＰｏ\tYβ(％＜\x1f>μξ＠\"zＦ␐␋ω`ρ␉",
		out:  "‛％Ｉ\r|｜<\vπＰｏ\tYβ(‛％＜\x1f>μξ＠\"zＦ␐␋ω`ρ‛␉",
	}, { // 4193
		mask: EncodePercent | EncodeRightCrLfHtVt,
		in:   "＂\x1bＯ＊δ;[４␝λ\n␐ο\f]θ\"η\x17o␒~\tＭη]\r｜８ｊ",
		out:  "＂\x1bＯ＊δ;[４␝λ\n␐ο\f]θ\"η\x17o␒~\tＭη]\r｜８ｊ",
	}, { // 4194
		mask: EncodePercent | EncodeRightCrLfHtVt,
		in:   "\n␊Ｏ＊δ;[４␝λ\n␐ο\f]θ\"η\x17o␒~\tＭη]\r｜８ｊ",
		out:  "\n␊Ｏ＊δ;[４␝λ\n␐ο\f]θ\"η\x17o␒~\tＭη]\r｜８ｊ",
	}, { // 4195
		mask: EncodePercent | EncodeRightCrLfHtVt,
		in:   "␊␊Ｏ＊δ;[４␝λ\n␐ο\f]θ\"η\x17o␒~\tＭη]\r｜８ｊ",
		out:  "␊␊Ｏ＊δ;[４␝λ\n␐ο\f]θ\"η\x17o␒~\tＭη]\r｜８ｊ",
	}, { // 4196
		mask: EncodePercent | EncodeRightCrLfHtVt,
		in:   "\n\x1bＯ＊δ;[４␝λ\n␐ο\f]θ\"η\x17o␒~\tＭη]\r｜␊ｊ",
		out:  "\n\x1bＯ＊δ;[４␝λ\n␐ο\f]θ\"η\x17o␒~\tＭη]\r｜␊ｊ",
	}, { // 4197
		mask: EncodePercent | EncodeRightCrLfHtVt,
		in:   "␊\x1bＯ＊δ;[４␝λ\n␐ο\f]θ\"η\x17o␒~\tＭη]\r｜␊ｊ",
		out:  "␊\x1bＯ＊δ;[４␝λ\n␐ο\f]θ\"η\x17o␒~\tＭη]\r｜␊ｊ",
	}, { // 4198
		mask: EncodePercent | EncodeRightCrLfHtVt,
		in:   "\n\x1bＯ＊δ;[４␝λ\n␐ο\f]θ\"η\x17o␒~\tＭη]\r｜８␊",
		out:  "\n\x1bＯ＊δ;[４␝λ\n␐ο\f]θ\"η\x17o␒~\tＭη]\r｜８‛␊",
	}, { // 4199
		mask: EncodePercent | EncodeRightCrLfHtVt,
		in:   "␊\x1bＯ＊δ;[４␝λ\n␐ο\f]θ\"η\x17o␒~\tＭη]\r｜８␊",
		out:  "␊\x1bＯ＊δ;[４␝λ\n␐ο\f]θ\"η\x17o␒~\tＭη]\r｜８‛␊",
	}, { // 4200
		mask: EncodePercent | EncodeRightCrLfHtVt,
		in:   "＂\nＯ＊δ;[４␝λ\n␐ο\f]θ\"η\x17o␒~\tＭη]\r｜８ｊ",
		out:  "＂\nＯ＊δ;[４␝λ\n␐ο\f]θ\"η\x17o␒~\tＭη]\r｜８ｊ",
	}, { // 4201
		mask: EncodePercent | EncodeRightCrLfHtVt,
		in:   "＂␊Ｏ＊δ;[４␝λ\n␐ο\f]θ\"η\x17o␒~\tＭη]\r｜８ｊ",
		out:  "＂␊Ｏ＊δ;[４␝λ\n␐ο\f]θ\"η\x17o␒~\tＭη]\r｜８ｊ",
	}, { // 4202
		mask: EncodePercent | EncodeRightCrLfHtVt,
		in:   "＂\nＯ＊δ;[４␝λ\n␐ο\f]θ\"η\x17o␒~\tＭη]\r｜␊ｊ",
		out:  "＂\nＯ＊δ;[４␝λ\n␐ο\f]θ\"η\x17o␒~\tＭη]\r｜␊ｊ",
	}, { // 4203
		mask: EncodePercent | EncodeRightCrLfHtVt,
		in:   "＂␊Ｏ＊δ;[４␝λ\n␐ο\f]θ\"η\x17o␒~\tＭη]\r｜␊ｊ",
		out:  "＂␊Ｏ＊δ;[４␝λ\n␐ο\f]θ\"η\x17o␒~\tＭη]\r｜␊ｊ",
	}, { // 4204
		mask: EncodePercent | EncodeRightCrLfHtVt,
		in:   "＂\nＯ＊δ;[４␝λ\n␐ο\f]θ\"η\x17o␒~\tＭη]\r｜８␊",
		out:  "＂\nＯ＊δ;[４␝λ\n␐ο\f]θ\"η\x17o␒~\tＭη]\r｜８‛␊",
	}, { // 4205
		mask: EncodePercent | EncodeRightCrLfHtVt,
		in:   "＂␊Ｏ＊δ;[４␝λ\n␐ο\f]θ\"η\x17o␒~\tＭη]\r｜８␊",
		out:  "＂␊Ｏ＊δ;[４␝λ\n␐ο\f]θ\"η\x17o␒~\tＭη]\r｜８‛␊",
	}, { // 4206
		mask: EncodePercent | EncodeRightCrLfHtVt,
		in:   "＂\x1bＯ＊δ;[４␝λ\n␐ο\f]θ\"η\x17o␒~\tＭη]\r｜\nｊ",
		out:  "＂\x1bＯ＊δ;[４␝λ\n␐ο\f]θ\"η\x17o␒~\tＭη]\r｜\nｊ",
	}, { // 4207
		mask: EncodePercent | EncodeRightCrLfHtVt,
		in:   "＂\x1bＯ＊δ;[４␝λ\n␐ο\f]θ\"η\x17o␒~\tＭη]\r｜␊ｊ",
		out:  "＂\x1bＯ＊δ;[４␝λ\n␐ο\f]θ\"η\x17o␒~\tＭη]\r｜␊ｊ",
	}, { // 4208
		mask: EncodePercent | EncodeRightCrLfHtVt,
		in:   "＂\x1bＯ＊δ;[４␝λ\n␐ο\f]θ\"η\x17o␒~\tＭη]\r｜\n␊",
		out:  "＂\x1bＯ＊δ;[４␝λ\n␐ο\f]θ\"η\x17o␒~\tＭη]\r｜\n‛␊",
	}, { // 4209
		mask: EncodePercent | EncodeRightCrLfHtVt,
		in:   "＂\x1bＯ＊δ;[４␝λ\n␐ο\f]θ\"η\x17o␒~\tＭη]\r｜␊␊",
		out:  "＂\x1bＯ＊δ;[４␝λ\n␐ο\f]θ\"η\x17o␒~\tＭη]\r｜␊‛␊",
	}, { // 4210
		mask: EncodePercent | EncodeRightCrLfHtVt,
		in:   "＂\x1bＯ＊δ;[４␝λ\n␐ο\f]θ\"η\x17o␒~\tＭη]\r｜８\n",
		out:  "＂\x1bＯ＊δ;[４␝λ\n␐ο\f]θ\"η\x17o␒~\tＭη]\r｜８␊",
	}, { // 4211
		mask: EncodePercent | EncodeRightCrLfHtVt,
		in:   "＂\x1bＯ＊δ;[４␝λ\n␐ο\f]θ\"η\x17o␒~\tＭη]\r｜８␊",
		out:  "＂\x1bＯ＊δ;[４␝λ\n␐ο\f]θ\"η\x17o␒~\tＭη]\r｜８‛␊",
	}, { // 4212
		mask: EncodePercent | EncodeRightCrLfHtVt,
		in:   "\x00␉Ｒ\v5γ␂\\␊\x1a\v␁ｈnＦς．υ␕ψＥθG8\\Ｗ|&\x14＂",
		out:  "␀␉Ｒ\v5γ␂\\␊\x1a\v␁ｈnＦς．υ␕ψＥθG8\\Ｗ|&\x14＂",
	}, { // 4213
		mask: EncodePercent | EncodeRightCrLfHtVt,
		in:   "\v␋Ｒ\v5γ␂\\␊\x1a\v␁ｈnＦς．υ␕ψＥθG8\\Ｗ|&\x14＂",
		out:  "\v␋Ｒ\v5γ␂\\␊\x1a\v␁ｈnＦς．υ␕ψＥθG8\\Ｗ|&\x14＂",
	}, { // 4214
		mask: EncodePercent | EncodeRightCrLfHtVt,
		in:   "␋␋Ｒ\v5γ␂\\␊\x1a\v␁ｈnＦς．υ␕ψＥθG8\\Ｗ|&\x14＂",
		out:  "␋␋Ｒ\v5γ␂\\␊\x1a\v␁ｈnＦς．υ␕ψＥθG8\\Ｗ|&\x14＂",
	}, { // 4215
		mask: EncodePercent | EncodeRightCrLfHtVt,
		in:   "\v␉Ｒ\v5γ␂\\␊\x1a\v␁ｈnＦς．υ␕ψＥθG8\\Ｗ|&␋＂",
		out:  "\v␉Ｒ\v5γ␂\\␊\x1a\v␁ｈnＦς．υ␕ψＥθG8\\Ｗ|&␋＂",
	}, { // 4216
		mask: EncodePercent | EncodeRightCrLfHtVt,
		in:   "␋␉Ｒ\v5γ␂\\␊\x1a\v␁ｈnＦς．υ␕ψＥθG8\\Ｗ|&␋＂",
		out:  "␋␉Ｒ\v5γ␂\\␊\x1a\v␁ｈnＦς．υ␕ψＥθG8\\Ｗ|&␋＂",
	}, { // 4217
		mask: EncodePercent | EncodeRightCrLfHtVt,
		in:   "\v␉Ｒ\v5γ␂\\␊\x1a\v␁ｈnＦς．υ␕ψＥθG8\\Ｗ|&\x14␋",
		out:  "\v␉Ｒ\v5γ␂\\␊\x1a\v␁ｈnＦς．υ␕ψＥθG8\\Ｗ|&\x14‛␋",
	}, { // 4218
		mask: EncodePercent | EncodeRightCrLfHtVt,
		in:   "␋␉Ｒ\v5γ␂\\␊\x1a\v␁ｈnＦς．υ␕ψＥθG8\\Ｗ|&\x14␋",
		out:  "␋␉Ｒ\v5γ␂\\␊\x1a\v␁ｈnＦς．υ␕ψＥθG8\\Ｗ|&\x14‛␋",
	}, { // 4219
		mask: EncodePercent | EncodeRightCrLfHtVt,
		in:   "\x00\vＲ\v5γ␂\\␊\x1a\v␁ｈnＦς．υ␕ψＥθG8\\Ｗ|&\x14＂",
		out:  "␀\vＲ\v5γ␂\\␊\x1a\v␁ｈnＦς．υ␕ψＥθG8\\Ｗ|&\x14＂",
	}, { // 4220
		mask: EncodePercent | EncodeRightCrLfHtVt,
		in:   "\x00␋Ｒ\v5γ␂\\␊\x1a\v␁ｈnＦς．υ␕ψＥθG8\\Ｗ|&\x14＂",
		out:  "␀␋Ｒ\v5γ␂\\␊\x1a\v␁ｈnＦς．υ␕ψＥθG8\\Ｗ|&\x14＂",
	}, { // 4221
		mask: EncodePercent | EncodeRightCrLfHtVt,
		in:   "\x00\vＲ\v5γ␂\\␊\x1a\v␁ｈnＦς．υ␕ψＥθG8\\Ｗ|&␋＂",
		out:  "␀\vＲ\v5γ␂\\␊\x1a\v␁ｈnＦς．υ␕ψＥθG8\\Ｗ|&␋＂",
	}, { // 4222
		mask: EncodePercent | EncodeRightCrLfHtVt,
		in:   "\x00␋Ｒ\v5γ␂\\␊\x1a\v␁ｈnＦς．υ␕ψＥθG8\\Ｗ|&␋＂",
		out:  "␀␋Ｒ\v5γ␂\\␊\x1a\v␁ｈnＦς．υ␕ψＥθG8\\Ｗ|&␋＂",
	}, { // 4223
		mask: EncodePercent | EncodeRightCrLfHtVt,
		in:   "\x00\vＲ\v5γ␂\\␊\x1a\v␁ｈnＦς．υ␕ψＥθG8\\Ｗ|&\x14␋",
		out:  "␀\vＲ\v5γ␂\\␊\x1a\v␁ｈnＦς．υ␕ψＥθG8\\Ｗ|&\x14‛␋",
	}, { // 4224
		mask: EncodePercent | EncodeRightCrLfHtVt,
		in:   "\x00␋Ｒ\v5γ␂\\␊\x1a\v␁ｈnＦς．υ␕ψＥθG8\\Ｗ|&\x14␋",
		out:  "␀␋Ｒ\v5γ␂\\␊\x1a\v␁ｈnＦς．υ␕ψＥθG8\\Ｗ|&\x14‛␋",
	}, { // 4225
		mask: EncodePercent | EncodeRightCrLfHtVt,
		in:   "\x00␉Ｒ\v5γ␂\\␊\x1a\v␁ｈnＦς．υ␕ψＥθG8\\Ｗ|&\v＂",
		out:  "␀␉Ｒ\v5γ␂\\␊\x1a\v␁ｈnＦς．υ␕ψＥθG8\\Ｗ|&\v＂",
	}, { // 4226
		mask: EncodePercent | EncodeRightCrLfHtVt,
		in:   "\x00␉Ｒ\v5γ␂\\␊\x1a\v␁ｈnＦς．υ␕ψＥθG8\\Ｗ|&␋＂",
		out:  "␀␉Ｒ\v5γ␂\\␊\x1a\v␁ｈnＦς．υ␕ψＥθG8\\Ｗ|&␋＂",
	}, { // 4227
		mask: EncodePercent | EncodeRightCrLfHtVt,
		in:   "\x00␉Ｒ\v5γ␂\\␊\x1a\v␁ｈnＦς．υ␕ψＥθG8\\Ｗ|&\v␋",
		out:  "␀␉Ｒ\v5γ␂\\␊\x1a\v␁ｈnＦς．υ␕ψＥθG8\\Ｗ|&\v‛␋",
	}, { // 4228
		mask: EncodePercent | EncodeRightCrLfHtVt,
		in:   "\x00␉Ｒ\v5γ␂\\␊\x1a\v␁ｈnＦς．υ␕ψＥθG8\\Ｗ|&␋␋",
		out:  "␀␉Ｒ\v5γ␂\\␊\x1a\v␁ｈnＦς．υ␕ψＥθG8\\Ｗ|&␋‛␋",
	}, { // 4229
		mask: EncodePercent | EncodeRightCrLfHtVt,
		in:   "\x00␉Ｒ\v5γ␂\\␊\x1a\v␁ｈnＦς．υ␕ψＥθG8\\Ｗ|&\x14\v",
		out:  "␀␉Ｒ\v5γ␂\\␊\x1a\v␁ｈnＦς．υ␕ψＥθG8\\Ｗ|&\x14␋",
	}, { // 4230
		mask: EncodePercent | EncodeRightCrLfHtVt,
		in:   "\x00␉Ｒ\v5γ␂\\␊\x1a\v␁ｈnＦς．υ␕ψＥθG8\\Ｗ|&\x14␋",
		out:  "␀␉Ｒ\v5γ␂\\␊\x1a\v␁ｈnＦς．υ␕ψＥθG8\\Ｗ|&\x14‛␋",
	}, { // 4231
		mask: EncodePercent | EncodeRightCrLfHtVt,
		in:   "w］φθ＂τ␡2\\\x0f\rδ␜Ｊ\x13,␍$A␁．_]υＺ\x03\x0eｍςａ",
		out:  "w］φθ＂τ␡2\\\x0f\rδ␜Ｊ\x13,␍$A␁．_]υＺ\x03\x0eｍςａ",
	}, { // 4232
		mask: EncodePercent | EncodeRightCrLfHtVt,
		in:   "\r␍φθ＂τ␡2\\\x0f\rδ␜Ｊ\x13,␍$A␁．_]υＺ\x03\x0eｍςａ",
		out:  "\r␍φθ＂τ␡2\\\x0f\rδ␜Ｊ\x13,␍$A␁．_]υＺ\x03\x0eｍςａ",
	}, { // 4233
		mask: EncodePercent | EncodeRightCrLfHtVt,
		in:   "␍␍φθ＂τ␡2\\\x0f\rδ␜Ｊ\x13,␍$A␁．_]υＺ\x03\x0eｍςａ",
		out:  "␍␍φθ＂τ␡2\\\x0f\rδ␜Ｊ\x13,␍$A␁．_]υＺ\x03\x0eｍςａ",
	}, { // 4234
		mask: EncodePercent | EncodeRightCrLfHtVt,
		in:   "\r］φθ＂τ␡2\\\x0f\rδ␜Ｊ\x13,␍$A␁．_]υＺ\x03\x0eｍ␍ａ",
		out:  "\r］φθ＂τ␡2\\\x0f\rδ␜Ｊ\x13,␍$A␁．_]υＺ\x03\x0eｍ␍ａ",
	}, { // 4235
		mask: EncodePercent | EncodeRightCrLfHtVt,
		in:   "␍］φθ＂τ␡2\\\x0f\rδ␜Ｊ\x13,␍$A␁．_]υＺ\x03\x0eｍ␍ａ",
		out:  "␍］φθ＂τ␡2\\\x0f\rδ␜Ｊ\x13,␍$A␁．_]υＺ\x03\x0eｍ␍ａ",
	}, { // 4236
		mask: EncodePercent | EncodeRightCrLfHtVt,
		in:   "\r］φθ＂τ␡2\\\x0f\rδ␜Ｊ\x13,␍$A␁．_]υＺ\x03\x0eｍς␍",
		out:  "\r］φθ＂τ␡2\\\x0f\rδ␜Ｊ\x13,␍$A␁．_]υＺ\x03\x0eｍς‛␍",
	}, { // 4237
		mask: EncodePercent | EncodeRightCrLfHtVt,
		in:   "␍］φθ＂τ␡2\\\x0f\rδ␜Ｊ\x13,␍$A␁．_]υＺ\x03\x0eｍς␍",
		out:  "␍］φθ＂τ␡2\\\x0f\rδ␜Ｊ\x13,␍$A␁．_]υＺ\x03\x0eｍς‛␍",
	}, { // 4238
		mask: EncodePercent | EncodeRightCrLfHtVt,
		in:   "w\rφθ＂τ␡2\\\x0f\rδ␜Ｊ\x13,␍$A␁．_]υＺ\x03\x0eｍςａ",
		out:  "w\rφθ＂τ␡2\\\x0f\rδ␜Ｊ\x13,␍$A␁．_]υＺ\x03\x0eｍςａ",
	}, { // 4239
		mask: EncodePercent | EncodeRightCrLfHtVt,
		in:   "w␍φθ＂τ␡2\\\x0f\rδ␜Ｊ\x13,␍$A␁．_]υＺ\x03\x0eｍςａ",
		out:  "w␍φθ＂τ␡2\\\x0f\rδ␜Ｊ\x13,␍$A␁．_]υＺ\x03\x0eｍςａ",
	}, { // 4240
		mask: EncodePercent | EncodeRightCrLfHtVt,
		in:   "w\rφθ＂τ␡2\\\x0f\rδ␜Ｊ\x13,␍$A␁．_]υＺ\x03\x0eｍ␍ａ",
		out:  "w\rφθ＂τ␡2\\\x0f\rδ␜Ｊ\x13,␍$A␁．_]υＺ\x03\x0eｍ␍ａ",
	}, { // 4241
		mask: EncodePercent | EncodeRightCrLfHtVt,
		in:   "w␍φθ＂τ␡2\\\x0f\rδ␜Ｊ\x13,␍$A␁．_]υＺ\x03\x0eｍ␍ａ",
		out:  "w␍φθ＂τ␡2\\\x0f\rδ␜Ｊ\x13,␍$A␁．_]υＺ\x03\x0eｍ␍ａ",
	}, { // 4242
		mask: EncodePercent | EncodeRightCrLfHtVt,
		in:   "w\rφθ＂τ␡2\\\x0f\rδ␜Ｊ\x13,␍$A␁．_]υＺ\x03\x0eｍς␍",
		out:  "w\rφθ＂τ␡2\\\x0f\rδ␜Ｊ\x13,␍$A␁．_]υＺ\x03\x0eｍς‛␍",
	}, { // 4243
		mask: EncodePercent | EncodeRightCrLfHtVt,
		in:   "w␍φθ＂τ␡2\\\x0f\rδ␜Ｊ\x13,␍$A␁．_]υＺ\x03\x0eｍς␍",
		out:  "w␍φθ＂τ␡2\\\x0f\rδ␜Ｊ\x13,␍$A␁．_]υＺ\x03\x0eｍς‛␍",
	}, { // 4244
		mask: EncodePercent | EncodeRightCrLfHtVt,
		in:   "w］φθ＂τ␡2\\\x0f\rδ␜Ｊ\x13,␍$A␁．_]υＺ\x03\x0eｍ\rａ",
		out:  "w］φθ＂τ␡2\\\x0f\rδ␜Ｊ\x13,␍$A␁．_]υＺ\x03\x0eｍ\rａ",
	}, { // 4245
		mask: EncodePercent | EncodeRightCrLfHtVt,
		in:   "w］φθ＂τ␡2\\\x0f\rδ␜Ｊ\x13,␍$A␁．_]υＺ\x03\x0eｍ␍ａ",
		out:  "w］φθ＂τ␡2\\\x0f\rδ␜Ｊ\x13,␍$A␁．_]υＺ\x03\x0eｍ␍ａ",
	}, { // 4246
		mask: EncodePercent | EncodeRightCrLfHtVt,
		in:   "w］φθ＂τ␡2\\\x0f\rδ␜Ｊ\x13,␍$A␁．_]υＺ\x03\x0eｍ\r␍",
		out:  "w］φθ＂τ␡2\\\x0f\rδ␜Ｊ\x13,␍$A␁．_]υＺ\x03\x0eｍ\r‛␍",
	}, { // 4247
		mask: EncodePercent | EncodeRightCrLfHtVt,
		in:   "w］φθ＂τ␡2\\\x0f\rδ␜Ｊ\x13,␍$A␁．_]υＺ\x03\x0eｍ␍␍",
		out:  "w］φθ＂τ␡2\\\x0f\rδ␜Ｊ\x13,␍$A␁．_]υＺ\x03\x0eｍ␍‛␍",
	}, { // 4248
		mask: EncodePercent | EncodeRightCrLfHtVt,
		in:   "w］φθ＂τ␡2\\\x0f\rδ␜Ｊ\x13,␍$A␁．_]υＺ\x03\x0eｍς\r",
		out:  "w］φθ＂τ␡2\\\x0f\rδ␜Ｊ\x13,␍$A␁．_]υＺ\x03\x0eｍς␍",
	}, { // 4249
		mask: EncodePercent | EncodeRightCrLfHtVt,
		in:   "w］φθ＂τ␡2\\\x0f\rδ␜Ｊ\x13,␍$A␁．_]υＺ\x03\x0eｍς␍",
		out:  "w］φθ＂τ␡2\\\x0f\rδ␜Ｊ\x13,␍$A␁．_]υＺ\x03\x0eｍς‛␍",
	}, { // 4250
		mask: EncodeBackSlash | EncodeRightCrLfHtVt,
		in:   "\rυｚ␝\x1b-Ｇι!π\t␅ε？\x17＜\rγ␊＃␄:M$}＞！␗rθ",
		out:  "\rυｚ␝\x1b-Ｇι!π\t␅ε？\x17＜\rγ␊＃␄:M$}＞！␗rθ",
	}, { // 4251
		mask: EncodeBackSlash | EncodeRightCrLfHtVt,
		in:   "\t␉ｚ␝\x1b-Ｇι!π\t␅ε？\x17＜\rγ␊＃␄:M$}＞！␗rθ",
		out:  "\t␉ｚ␝\x1b-Ｇι!π\t␅ε？\x17＜\rγ␊＃␄:M$}＞！␗rθ",
	}, { // 4252
		mask: EncodeBackSlash | EncodeRightCrLfHtVt,
		in:   "␉␉ｚ␝\x1b-Ｇι!π\t␅ε？\x17＜\rγ␊＃␄:M$}＞！␗rθ",
		out:  "␉␉ｚ␝\x1b-Ｇι!π\t␅ε？\x17＜\rγ␊＃␄:M$}＞！␗rθ",
	}, { // 4253
		mask: EncodeBackSlash | EncodeRightCrLfHtVt,
		in:   "\tυｚ␝\x1b-Ｇι!π\t␅ε？\x17＜\rγ␊＃␄:M$}＞！␗␉θ",
		out:  "\tυｚ␝\x1b-Ｇι!π\t␅ε？\x17＜\rγ␊＃␄:M$}＞！␗␉θ",
	}, { // 4254
		mask: EncodeBackSlash | EncodeRightCrLfHtVt,
		in:   "␉υｚ␝\x1b-Ｇι!π\t␅ε？\x17＜\rγ␊＃␄:M$}＞！␗␉θ",
		out:  "␉υｚ␝\x1b-Ｇι!π\t␅ε？\x17＜\rγ␊＃␄:M$}＞！␗␉θ",
	}, { // 4255
		mask: EncodeBackSlash | EncodeRightCrLfHtVt,
		in:   "\tυｚ␝\x1b-Ｇι!π\t␅ε？\x17＜\rγ␊＃␄:M$}＞！␗r␉",
		out:  "\tυｚ␝\x1b-Ｇι!π\t␅ε？\x17＜\rγ␊＃␄:M$}＞！␗r‛␉",
	}, { // 4256
		mask: EncodeBackSlash | EncodeRightCrLfHtVt,
		in:   "␉υｚ␝\x1b-Ｇι!π\t␅ε？\x17＜\rγ␊＃␄:M$}＞！␗r␉",
		out:  "␉υｚ␝\x1b-Ｇι!π\t␅ε？\x17＜\rγ␊＃␄:M$}＞！␗r‛␉",
	}, { // 4257
		mask: EncodeBackSlash | EncodeRightCrLfHtVt,
		in:   "\r\tｚ␝\x1b-Ｇι!π\t␅ε？\x17＜\rγ␊＃␄:M$}＞！␗rθ",
		out:  "\r\tｚ␝\x1b-Ｇι!π\t␅ε？\x17＜\rγ␊＃␄:M$}＞！␗rθ",
	}, { // 4258
		mask: EncodeBackSlash | EncodeRightCrLfHtVt,
		in:   "\r␉ｚ␝\x1b-Ｇι!π\t␅ε？\x17＜\rγ␊＃␄:M$}＞！␗rθ",
		out:  "\r␉ｚ␝\x1b-Ｇι!π\t␅ε？\x17＜\rγ␊＃␄:M$}＞！␗rθ",
	}, { // 4259
		mask: EncodeBackSlash | EncodeRightCrLfHtVt,
		in:   "\r\tｚ␝\x1b-Ｇι!π\t␅ε？\x17＜\rγ␊＃␄:M$}＞！␗␉θ",
		out:  "\r\tｚ␝\x1b-Ｇι!π\t␅ε？\x17＜\rγ␊＃␄:M$}＞！␗␉θ",
	}, { // 4260
		mask: EncodeBackSlash | EncodeRightCrLfHtVt,
		in:   "\r␉ｚ␝\x1b-Ｇι!π\t␅ε？\x17＜\rγ␊＃␄:M$}＞！␗␉θ",
		out:  "\r␉ｚ␝\x1b-Ｇι!π\t␅ε？\x17＜\rγ␊＃␄:M$}＞！␗␉θ",
	}, { // 4261
		mask: EncodeBackSlash | EncodeRightCrLfHtVt,
		in:   "\r\tｚ␝\x1b-Ｇι!π\t␅ε？\x17＜\rγ␊＃␄:M$}＞！␗r␉",
		out:  "\r\tｚ␝\x1b-Ｇι!π\t␅ε？\x17＜\rγ␊＃␄:M$}＞！␗r‛␉",
	}, { // 4262
		mask: EncodeBackSlash | EncodeRightCrLfHtVt,
		in:   "\r␉ｚ␝\x1b-Ｇι!π\t␅ε？\x17＜\rγ␊＃␄:M$}＞！␗r␉",
		out:  "\r␉ｚ␝\x1b-Ｇι!π\t␅ε？\x17＜\rγ␊＃␄:M$}＞！␗r‛␉",
	}, { // 4263
		mask: EncodeBackSlash | EncodeRightCrLfHtVt,
		in:   "\rυｚ␝\x1b-Ｇι!π\t␅ε？\x17＜\rγ␊＃␄:M$}＞！␗\tθ",
		out:  "\rυｚ␝\x1b-Ｇι!π\t␅ε？\x17＜\rγ␊＃␄:M$}＞！␗\tθ",
	}, { // 4264
		mask: EncodeBackSlash | EncodeRightCrLfHtVt,
		in:   "\rυｚ␝\x1b-Ｇι!π\t␅ε？\x17＜\rγ␊＃␄:M$}＞！␗␉θ",
		out:  "\rυｚ␝\x1b-Ｇι!π\t␅ε？\x17＜\rγ␊＃␄:M$}＞！␗␉θ",
	}, { // 4265
		mask: EncodeBackSlash | EncodeRightCrLfHtVt,
		in:   "\rυｚ␝\x1b-Ｇι!π\t␅ε？\x17＜\rγ␊＃␄:M$}＞！␗\t␉",
		out:  "\rυｚ␝\x1b-Ｇι!π\t␅ε？\x17＜\rγ␊＃␄:M$}＞！␗\t‛␉",
	}, { // 4266
		mask: EncodeBackSlash | EncodeRightCrLfHtVt,
		in:   "\rυｚ␝\x1b-Ｇι!π\t␅ε？\x17＜\rγ␊＃␄:M$}＞！␗␉␉",
		out:  "\rυｚ␝\x1b-Ｇι!π\t␅ε？\x17＜\rγ␊＃␄:M$}＞！␗␉‛␉",
	}, { // 4267
		mask: EncodeBackSlash | EncodeRightCrLfHtVt,
		in:   "\rυｚ␝\x1b-Ｇι!π\t␅ε？\x17＜\rγ␊＃␄:M$}＞！␗r\t",
		out:  "\rυｚ␝\x1b-Ｇι!π\t␅ε？\x17＜\rγ␊＃␄:M$}＞！␗r␉",
	}, { // 4268
		mask: EncodeBackSlash | EncodeRightCrLfHtVt,
		in:   "\rυｚ␝\x1b-Ｇι!π\t␅ε？\x17＜\rγ␊＃␄:M$}＞！␗r␉",
		out:  "\rυｚ␝\x1b-Ｇι!π\t␅ε？\x17＜\rγ␊＃␄:M$}＞！␗r‛␉",
	}, { // 4269
		mask: EncodeBackSlash | EncodeRightCrLfHtVt,
		in:   "Ｂ\x02２#δM␊,［ο\n：α\"B␌*［B#Ｓξα\x1d␏Ｏ：n␔ψ",
		out:  "Ｂ\x02２#δM␊,［ο\n：α\"B␌*［B#Ｓξα\x1d␏Ｏ：n␔ψ",
	}, { // 4270
		mask: EncodeBackSlash | EncodeRightCrLfHtVt,
		in:   "\n␊２#δM␊,［ο\n：α\"B␌*［B#Ｓξα\x1d␏Ｏ：n␔ψ",
		out:  "\n␊２#δM␊,［ο\n：α\"B␌*［B#Ｓξα\x1d␏Ｏ：n␔ψ",
	}, { // 4271
		mask: EncodeBackSlash | EncodeRightCrLfHtVt,
		in:   "␊␊２#δM␊,［ο\n：α\"B␌*［B#Ｓξα\x1d␏Ｏ：n␔ψ",
		out:  "␊␊２#δM␊,［ο\n：α\"B␌*［B#Ｓξα\x1d␏Ｏ：n␔ψ",
	}, { // 4272
		mask: EncodeBackSlash | EncodeRightCrLfHtVt,
		in:   "\n\x02２#δM␊,［ο\n：α\"B␌*［B#Ｓξα\x1d␏Ｏ：n␊ψ",
		out:  "\n\x02２#δM␊,［ο\n：α\"B␌*［B#Ｓξα\x1d␏Ｏ：n␊ψ",
	}, { // 4273
		mask: EncodeBackSlash | EncodeRightCrLfHtVt,
		in:   "␊\x02２#δM␊,［ο\n：α\"B␌*［B#Ｓξα\x1d␏Ｏ：n␊ψ",
		out:  "␊\x02２#δM␊,［ο\n：α\"B␌*［B#Ｓξα\x1d␏Ｏ：n␊ψ",
	}, { // 4274
		mask: EncodeBackSlash | EncodeRightCrLfHtVt,
		in:   "\n\x02２#δM␊,［ο\n：α\"B␌*［B#Ｓξα\x1d␏Ｏ：n␔␊",
		out:  "\n\x02２#δM␊,［ο\n：α\"B␌*［B#Ｓξα\x1d␏Ｏ：n␔‛␊",
	}, { // 4275
		mask: EncodeBackSlash | EncodeRightCrLfHtVt,
		in:   "␊\x02２#δM␊,［ο\n：α\"B␌*［B#Ｓξα\x1d␏Ｏ：n␔␊",
		out:  "␊\x02２#δM␊,［ο\n：α\"B␌*［B#Ｓξα\x1d␏Ｏ：n␔‛␊",
	}, { // 4276
		mask: EncodeBackSlash | EncodeRightCrLfHtVt,
		in:   "Ｂ\n２#δM␊,［ο\n：α\"B␌*［B#Ｓξα\x1d␏Ｏ：n␔ψ",
		out:  "Ｂ\n２#δM␊,［ο\n：α\"B␌*［B#Ｓξα\x1d␏Ｏ：n␔ψ",
	}, { // 4277
		mask: EncodeBackSlash | EncodeRightCrLfHtVt,
		in:   "Ｂ␊２#δM␊,［ο\n：α\"B␌*［B#Ｓξα\x1d␏Ｏ：n␔ψ",
		out:  "Ｂ␊２#δM␊,［ο\n：α\"B␌*［B#Ｓξα\x1d␏Ｏ：n␔ψ",
	}, { // 4278
		mask: EncodeBackSlash | EncodeRightCrLfHtVt,
		in:   "Ｂ\n２#δM␊,［ο\n：α\"B␌*［B#Ｓξα\x1d␏Ｏ：n␊ψ",
		out:  "Ｂ\n２#δM␊,［ο\n：α\"B␌*［B#Ｓξα\x1d␏Ｏ：n␊ψ",
	}, { // 4279
		mask: EncodeBackSlash | EncodeRightCrLfHtVt,
		in:   "Ｂ␊２#δM␊,［ο\n：α\"B␌*［B#Ｓξα\x1d␏Ｏ：n␊ψ",
		out:  "Ｂ␊２#δM␊,［ο\n：α\"B␌*［B#Ｓξα\x1d␏Ｏ：n␊ψ",
	}, { // 4280
		mask: EncodeBackSlash | EncodeRightCrLfHtVt,
		in:   "Ｂ\n２#δM␊,［ο\n：α\"B␌*［B#Ｓξα\x1d␏Ｏ：n␔␊",
		out:  "Ｂ\n２#δM␊,［ο\n：α\"B␌*［B#Ｓξα\x1d␏Ｏ：n␔‛␊",
	}, { // 4281
		mask: EncodeBackSlash | EncodeRightCrLfHtVt,
		in:   "Ｂ␊２#δM␊,［ο\n：α\"B␌*［B#Ｓξα\x1d␏Ｏ：n␔␊",
		out:  "Ｂ␊２#δM␊,［ο\n：α\"B␌*［B#Ｓξα\x1d␏Ｏ：n␔‛␊",
	}, { // 4282
		mask: EncodeBackSlash | EncodeRightCrLfHtVt,
		in:   "Ｂ\x02２#δM␊,［ο\n：α\"B␌*［B#Ｓξα\x1d␏Ｏ：n\nψ",
		out:  "Ｂ\x02２#δM␊,［ο\n：α\"B␌*［B#Ｓξα\x1d␏Ｏ：n\nψ",
	}, { // 4283
		mask: EncodeBackSlash | EncodeRightCrLfHtVt,
		in:   "Ｂ\x02２#δM␊,［ο\n：α\"B␌*［B#Ｓξα\x1d␏Ｏ：n␊ψ",
		out:  "Ｂ\x02２#δM␊,［ο\n：α\"B␌*［B#Ｓξα\x1d␏Ｏ：n␊ψ",
	}, { // 4284
		mask: EncodeBackSlash | EncodeRightCrLfHtVt,
		in:   "Ｂ\x02２#δM␊,［ο\n：α\"B␌*［B#Ｓξα\x1d␏Ｏ：n\n␊",
		out:  "Ｂ\x02２#δM␊,［ο\n：α\"B␌*［B#Ｓξα\x1d␏Ｏ：n\n‛␊",
	}, { // 4285
		mask: EncodeBackSlash | EncodeRightCrLfHtVt,
		in:   "Ｂ\x02２#δM␊,［ο\n：α\"B␌*［B#Ｓξα\x1d␏Ｏ：n␊␊",
		out:  "Ｂ\x02２#δM␊,［ο\n：α\"B␌*［B#Ｓξα\x1d␏Ｏ：n␊‛␊",
	}, { // 4286
		mask: EncodeBackSlash | EncodeRightCrLfHtVt,
		in:   "Ｂ\x02２#δM␊,［ο\n：α\"B␌*［B#Ｓξα\x1d␏Ｏ：n␔\n",
		out:  "Ｂ\x02２#δM␊,［ο\n：α\"B␌*［B#Ｓξα\x1d␏Ｏ：n␔␊",
	}, { // 4287
		mask: EncodeBackSlash | EncodeRightCrLfHtVt,
		in:   "Ｂ\x02２#δM␊,［ο\n：α\"B␌*［B#Ｓξα\x1d␏Ｏ：n␔␊",
		out:  "Ｂ\x02２#δM␊,［ο\n：α\"B␌*［B#Ｓξα\x1d␏Ｏ：n␔‛␊",
	}, { // 4288
		mask: EncodeBackSlash | EncodeRightCrLfHtVt,
		in:   "`ρ/Ａ\x1eξ｜lι␝\vＬ／␅␚＠4ξ\x00\x1ds0＼Ｐ␂|^μ：]",
		out:  "`ρ/Ａ\x1eξ｜lι␝\vＬ／␅␚＠4ξ␀\x1ds0‛＼Ｐ␂|^μ：]",
	}, { // 4289
		mask: EncodeBackSlash | EncodeRightCrLfHtVt,
		in:   "\v␋/Ａ\x1eξ｜lι␝\vＬ／␅␚＠4ξ\x00\x1ds0＼Ｐ␂|^μ：]",
		out:  "\v␋/Ａ\x1eξ｜lι␝\vＬ／␅␚＠4ξ␀\x1ds0‛＼Ｐ␂|^μ：]",
	}, { // 4290
		mask: EncodeBackSlash | EncodeRightCrLfHtVt,
		in:   "␋␋/Ａ\x1eξ｜lι␝\vＬ／␅␚＠4ξ\x00\x1ds0＼Ｐ␂|^μ：]",
		out:  "␋␋/Ａ\x1eξ｜lι␝\vＬ／␅␚＠4ξ␀\x1ds0‛＼Ｐ␂|^μ：]",
	}, { // 4291
		mask: EncodeBackSlash | EncodeRightCrLfHtVt,
		in:   "\vρ/Ａ\x1eξ｜lι␝\vＬ／␅␚＠4ξ\x00\x1ds0＼Ｐ␂|^μ␋]",
		out:  "\vρ/Ａ\x1eξ｜lι␝\vＬ／␅␚＠4ξ␀\x1ds0‛＼Ｐ␂|^μ␋]",
	}, { // 4292
		mask: EncodeBackSlash | EncodeRightCrLfHtVt,
		in:   "␋ρ/Ａ\x1eξ｜lι␝\vＬ／␅␚＠4ξ\x00\x1ds0＼Ｐ␂|^μ␋]",
		out:  "␋ρ/Ａ\x1eξ｜lι␝\vＬ／␅␚＠4ξ␀\x1ds0‛＼Ｐ␂|^μ␋]",
	}, { // 4293
		mask: EncodeBackSlash | EncodeRightCrLfHtVt,
		in:   "\vρ/Ａ\x1eξ｜lι␝\vＬ／␅␚＠4ξ\x00\x1ds0＼Ｐ␂|^μ：␋",
		out:  "\vρ/Ａ\x1eξ｜lι␝\vＬ／␅␚＠4ξ␀\x1ds0‛＼Ｐ␂|^μ：‛␋",
	}, { // 4294
		mask: EncodeBackSlash | EncodeRightCrLfHtVt,
		in:   "␋ρ/Ａ\x1eξ｜lι␝\vＬ／␅␚＠4ξ\x00\x1ds0＼Ｐ␂|^μ：␋",
		out:  "␋ρ/Ａ\x1eξ｜lι␝\vＬ／␅␚＠4ξ␀\x1ds0‛＼Ｐ␂|^μ：‛␋",
	}, { // 4295
		mask: EncodeBackSlash | EncodeRightCrLfHtVt,
		in:   "`\v/Ａ\x1eξ｜lι␝\vＬ／␅␚＠4ξ\x00\x1ds0＼Ｐ␂|^μ：]",
		out:  "`\v/Ａ\x1eξ｜lι␝\vＬ／␅␚＠4ξ␀\x1ds0‛＼Ｐ␂|^μ：]",
	}, { // 4296
		mask: EncodeBackSlash | EncodeRightCrLfHtVt,
		in:   "`␋/Ａ\x1eξ｜lι␝\vＬ／␅␚＠4ξ\x00\x1ds0＼Ｐ␂|^μ：]",
		out:  "`␋/Ａ\x1eξ｜lι␝\vＬ／␅␚＠4ξ␀\x1ds0‛＼Ｐ␂|^μ：]",
	}, { // 4297
		mask: EncodeBackSlash | EncodeRightCrLfHtVt,
		in:   "`\v/Ａ\x1eξ｜lι␝\vＬ／␅␚＠4ξ\x00\x1ds0＼Ｐ␂|^μ␋]",
		out:  "`\v/Ａ\x1eξ｜lι␝\vＬ／␅␚＠4ξ␀\x1ds0‛＼Ｐ␂|^μ␋]",
	}, { // 4298
		mask: EncodeBackSlash | EncodeRightCrLfHtVt,
		in:   "`␋/Ａ\x1eξ｜lι␝\vＬ／␅␚＠4ξ\x00\x1ds0＼Ｐ␂|^μ␋]",
		out:  "`␋/Ａ\x1eξ｜lι␝\vＬ／␅␚＠4ξ␀\x1ds0‛＼Ｐ␂|^μ␋]",
	}, { // 4299
		mask: EncodeBackSlash | EncodeRightCrLfHtVt,
		in:   "`\v/Ａ\x1eξ｜lι␝\vＬ／␅␚＠4ξ\x00\x1ds0＼Ｐ␂|^μ：␋",
		out:  "`\v/Ａ\x1eξ｜lι␝\vＬ／␅␚＠4ξ␀\x1ds0‛＼Ｐ␂|^μ：‛␋",
	}, { // 4300
		mask: EncodeBackSlash | EncodeRightCrLfHtVt,
		in:   "`␋/Ａ\x1eξ｜lι␝\vＬ／␅␚＠4ξ\x00\x1ds0＼Ｐ␂|^μ：␋",
		out:  "`␋/Ａ\x1eξ｜lι␝\vＬ／␅␚＠4ξ␀\x1ds0‛＼Ｐ␂|^μ：‛␋",
	}, { // 4301
		mask: EncodeBackSlash | EncodeRightCrLfHtVt,
		in:   "`ρ/Ａ\x1eξ｜lι␝\vＬ／␅␚＠4ξ\x00\x1ds0＼Ｐ␂|^μ\v]",
		out:  "`ρ/Ａ\x1eξ｜lι␝\vＬ／␅␚＠4ξ␀\x1ds0‛＼Ｐ␂|^μ\v]",
	}, { // 4302
		mask: EncodeBackSlash | EncodeRightCrLfHtVt,
		in:   "`ρ/Ａ\x1eξ｜lι␝\vＬ／␅␚＠4ξ\x00\x1ds0＼Ｐ␂|^μ␋]",
		out:  "`ρ/Ａ\x1eξ｜lι␝\vＬ／␅␚＠4ξ␀\x1ds0‛＼Ｐ␂|^μ␋]",
	}, { // 4303
		mask: EncodeBackSlash | EncodeRightCrLfHtVt,
		in:   "`ρ/Ａ\x1eξ｜lι␝\vＬ／␅␚＠4ξ\x00\x1ds0＼Ｐ␂|^μ\v␋",
		out:  "`ρ/Ａ\x1eξ｜lι␝\vＬ／␅␚＠4ξ␀\x1ds0‛＼Ｐ␂|^μ\v‛␋",
	}, { // 4304
		mask: EncodeBackSlash | EncodeRightCrLfHtVt,
		in:   "`ρ/Ａ\x1eξ｜lι␝\vＬ／␅␚＠4ξ\x00\x1ds0＼Ｐ␂|^μ␋␋",
		out:  "`ρ/Ａ\x1eξ｜lι␝\vＬ／␅␚＠4ξ␀\x1ds0‛＼Ｐ␂|^μ␋‛␋",
	}, { // 4305
		mask: EncodeBackSlash | EncodeRightCrLfHtVt,
		in:   "`ρ/Ａ\x1eξ｜lι␝\vＬ／␅␚＠4ξ\x00\x1ds0＼Ｐ␂|^μ：\v",
		out:  "`ρ/Ａ\x1eξ｜lι␝\vＬ／␅␚＠4ξ␀\x1ds0‛＼Ｐ␂|^μ：␋",
	}, { // 4306
		mask: EncodeBackSlash | EncodeRightCrLfHtVt,
		in:   "`ρ/Ａ\x1eξ｜lι␝\vＬ／␅␚＠4ξ\x00\x1ds0＼Ｐ␂|^μ：␋",
		out:  "`ρ/Ａ\x1eξ｜lι␝\vＬ／␅␚＠4ξ␀\x1ds0‛＼Ｐ␂|^μ：‛␋",
	}, { // 4307
		mask: EncodeBackSlash | EncodeRightCrLfHtVt,
		in:   "φ#␊n＃β＝φ\x1dv\rｔR／\x00ζτ+\x06＂P␕Ｊ\x03␑ａｇχ\"Ｗ",
		out:  "φ#␊n＃β＝φ\x1dv\rｔR／␀ζτ+\x06＂P␕Ｊ\x03␑ａｇχ\"Ｗ",
	}, { // 4308
		mask: EncodeBackSlash | EncodeRightCrLfHtVt,
		in:   "\r␍␊n＃β＝φ\x1dv\rｔR／\x00ζτ+\x06＂P␕Ｊ\x03␑ａｇχ\"Ｗ",
		out:  "\r␍␊n＃β＝φ\x1dv\rｔR／␀ζτ+\x06＂P␕Ｊ\x03␑ａｇχ\"Ｗ",
	}, { // 4309
		mask: EncodeBackSlash | EncodeRightCrLfHtVt,
		in:   "␍␍␊n＃β＝φ\x1dv\rｔR／\x00ζτ+\x06＂P␕Ｊ\x03␑ａｇχ\"Ｗ",
		out:  "␍␍␊n＃β＝φ\x1dv\rｔR／␀ζτ+\x06＂P␕Ｊ\x03␑ａｇχ\"Ｗ",
	}, { // 4310
		mask: EncodeBackSlash | EncodeRightCrLfHtVt,
		in:   "\r#␊n＃β＝φ\x1dv\rｔR／\x00ζτ+\x06＂P␕Ｊ\x03␑ａｇχ␍Ｗ",
		out:  "\r#␊n＃β＝φ\x1dv\rｔR／␀ζτ+\x06＂P␕Ｊ\x03␑ａｇχ␍Ｗ",
	}, { // 4311
		mask: EncodeBackSlash | EncodeRightCrLfHtVt,
		in:   "␍#␊n＃β＝φ\x1dv\rｔR／\x00ζτ+\x06＂P␕Ｊ\x03␑ａｇχ␍Ｗ",
		out:  "␍#␊n＃β＝φ\x1dv\rｔR／␀ζτ+\x06＂P␕Ｊ\x03␑ａｇχ␍Ｗ",
	}, { // 4312
		mask: EncodeBackSlash | EncodeRightCrLfHtVt,
		in:   "\r#␊n＃β＝φ\x1dv\rｔR／\x00ζτ+\x06＂P␕Ｊ\x03␑ａｇχ\"␍",
		out:  "\r#␊n＃β＝φ\x1dv\rｔR／␀ζτ+\x06＂P␕Ｊ\x03␑ａｇχ\"‛␍",
	}, { // 4313
		mask: EncodeBackSlash | EncodeRightCrLfHtVt,
		in:   "␍#␊n＃β＝φ\x1dv\rｔR／\x00ζτ+\x06＂P␕Ｊ\x03␑ａｇχ\"␍",
		out:  "␍#␊n＃β＝φ\x1dv\rｔR／␀ζτ+\x06＂P␕Ｊ\x03␑ａｇχ\"‛␍",
	}, { // 4314
		mask: EncodeBackSlash | EncodeRightCrLfHtVt,
		in:   "φ\r␊n＃β＝φ\x1dv\rｔR／\x00ζτ+\x06＂P␕Ｊ\x03␑ａｇχ\"Ｗ",
		out:  "φ\r␊n＃β＝φ\x1dv\rｔR／␀ζτ+\x06＂P␕Ｊ\x03␑ａｇχ\"Ｗ",
	}, { // 4315
		mask: EncodeBackSlash | EncodeRightCrLfHtVt,
		in:   "φ␍␊n＃β＝φ\x1dv\rｔR／\x00ζτ+\x06＂P␕Ｊ\x03␑ａｇχ\"Ｗ",
		out:  "φ␍␊n＃β＝φ\x1dv\rｔR／␀ζτ+\x06＂P␕Ｊ\x03␑ａｇχ\"Ｗ",
	}, { // 4316
		mask: EncodeBackSlash | EncodeRightCrLfHtVt,
		in:   "φ\r␊n＃β＝φ\x1dv\rｔR／\x00ζτ+\x06＂P␕Ｊ\x03␑ａｇχ␍Ｗ",
		out:  "φ\r␊n＃β＝φ\x1dv\rｔR／␀ζτ+\x06＂P␕Ｊ\x03␑ａｇχ␍Ｗ",
	}, { // 4317
		mask: EncodeBackSlash | EncodeRightCrLfHtVt,
		in:   "φ␍␊n＃β＝φ\x1dv\rｔR／\x00ζτ+\x06＂P␕Ｊ\x03␑ａｇχ␍Ｗ",
		out:  "φ␍␊n＃β＝φ\x1dv\rｔR／␀ζτ+\x06＂P␕Ｊ\x03␑ａｇχ␍Ｗ",
	}, { // 4318
		mask: EncodeBackSlash | EncodeRightCrLfHtVt,
		in:   "φ\r␊n＃β＝φ\x1dv\rｔR／\x00ζτ+\x06＂P␕Ｊ\x03␑ａｇχ\"␍",
		out:  "φ\r␊n＃β＝φ\x1dv\rｔR／␀ζτ+\x06＂P␕Ｊ\x03␑ａｇχ\"‛␍",
	}, { // 4319
		mask: EncodeBackSlash | EncodeRightCrLfHtVt,
		in:   "φ␍␊n＃β＝φ\x1dv\rｔR／\x00ζτ+\x06＂P␕Ｊ\x03␑ａｇχ\"␍",
		out:  "φ␍␊n＃β＝φ\x1dv\rｔR／␀ζτ+\x06＂P␕Ｊ\x03␑ａｇχ\"‛␍",
	}, { // 4320
		mask: EncodeBackSlash | EncodeRightCrLfHtVt,
		in:   "φ#␊n＃β＝φ\x1dv\rｔR／\x00ζτ+\x06＂P␕Ｊ\x03␑ａｇχ\rＷ",
		out:  "φ#␊n＃β＝φ\x1dv\rｔR／␀ζτ+\x06＂P␕Ｊ\x03␑ａｇχ\rＷ",
	}, { // 4321
		mask: EncodeBackSlash | EncodeRightCrLfHtVt,
		in:   "φ#␊n＃β＝φ\x1dv\rｔR／\x00ζτ+\x06＂P␕Ｊ\x03␑ａｇχ␍Ｗ",
		out:  "φ#␊n＃β＝φ\x1dv\rｔR／␀ζτ+\x06＂P␕Ｊ\x03␑ａｇχ␍Ｗ",
	}, { // 4322
		mask: EncodeBackSlash | EncodeRightCrLfHtVt,
		in:   "φ#␊n＃β＝φ\x1dv\rｔR／\x00ζτ+\x06＂P␕Ｊ\x03␑ａｇχ\r␍",
		out:  "φ#␊n＃β＝φ\x1dv\rｔR／␀ζτ+\x06＂P␕Ｊ\x03␑ａｇχ\r‛␍",
	}, { // 4323
		mask: EncodeBackSlash | EncodeRightCrLfHtVt,
		in:   "φ#␊n＃β＝φ\x1dv\rｔR／\x00ζτ+\x06＂P␕Ｊ\x03␑ａｇχ␍␍",
		out:  "φ#␊n＃β＝φ\x1dv\rｔR／␀ζτ+\x06＂P␕Ｊ\x03␑ａｇχ␍‛␍",
	}, { // 4324
		mask: EncodeBackSlash | EncodeRightCrLfHtVt,
		in:   "φ#␊n＃β＝φ\x1dv\rｔR／\x00ζτ+\x06＂P␕Ｊ\x03␑ａｇχ\"\r",
		out:  "φ#␊n＃β＝φ\x1dv\rｔR／␀ζτ+\x06＂P␕Ｊ\x03␑ａｇχ\"␍",
	}, { // 4325
		mask: EncodeBackSlash | EncodeRightCrLfHtVt,
		in:   "φ#␊n＃β＝φ\x1dv\rｔR／\x00ζτ+\x06＂P␕Ｊ\x03␑ａｇχ\"␍",
		out:  "φ#␊n＃β＝φ\x1dv\rｔR／␀ζτ+\x06＂P␕Ｊ\x03␑ａｇχ\"‛␍",
	}, { // 4326
		mask: EncodeDel | EncodeRightCrLfHtVt,
		in:   "ｉζξ=\u007f＄␟%ζ␚\t␆E］１`;ψ7ζ＋]␖␛\x03]\x14ｏ０u",
		out:  "ｉζξ=␡＄␟%ζ␚\t␆E］１`;ψ7ζ＋]␖␛\x03]\x14ｏ０u",
	}, { // 4327
		mask: EncodeDel | EncodeRightCrLfHtVt,
		in:   "\t␉ξ=\u007f＄␟%ζ␚\t␆E］１`;ψ7ζ＋]␖␛\x03]\x14ｏ０u",
		out:  "\t␉ξ=␡＄␟%ζ␚\t␆E］１`;ψ7ζ＋]␖␛\x03]\x14ｏ０u",
	}, { // 4328
		mask: EncodeDel | EncodeRightCrLfHtVt,
		in:   "␉␉ξ=\u007f＄␟%ζ␚\t␆E］１`;ψ7ζ＋]␖␛\x03]\x14ｏ０u",
		out:  "␉␉ξ=␡＄␟%ζ␚\t␆E］１`;ψ7ζ＋]␖␛\x03]\x14ｏ０u",
	}, { // 4329
		mask: EncodeDel | EncodeRightCrLfHtVt,
		in:   "\tζξ=\u007f＄␟%ζ␚\t␆E］１`;ψ7ζ＋]␖␛\x03]\x14ｏ␉u",
		out:  "\tζξ=␡＄␟%ζ␚\t␆E］１`;ψ7ζ＋]␖␛\x03]\x14ｏ␉u",
	}, { // 4330
		mask: EncodeDel | EncodeRightCrLfHtVt,
		in:   "␉ζξ=\u007f＄␟%ζ␚\t␆E］１`;ψ7ζ＋]␖␛\x03]\x14ｏ␉u",
		out:  "␉ζξ=␡＄␟%ζ␚\t␆E］１`;ψ7ζ＋]␖␛\x03]\x14ｏ␉u",
	}, { // 4331
		mask: EncodeDel | EncodeRightCrLfHtVt,
		in:   "\tζξ=\u007f＄␟%ζ␚\t␆E］１`;ψ7ζ＋]␖␛\x03]\x14ｏ０␉",
		out:  "\tζξ=␡＄␟%ζ␚\t␆E］１`;ψ7ζ＋]␖␛\x03]\x14ｏ０‛␉",
	}, { // 4332
		mask: EncodeDel | EncodeRightCrLfHtVt,
		in:   "␉ζξ=\u007f＄␟%ζ␚\t␆E］１`;ψ7ζ＋]␖␛\x03]\x14ｏ０␉",
		out:  "␉ζξ=␡＄␟%ζ␚\t␆E］１`;ψ7ζ＋]␖␛\x03]\x14ｏ０‛␉",
	}, { // 4333
		mask: EncodeDel | EncodeRightCrLfHtVt,
		in:   "ｉ\tξ=\u007f＄␟%ζ␚\t␆E］１`;ψ7ζ＋]␖␛\x03]\x14ｏ０u",
		out:  "ｉ\tξ=␡＄␟%ζ␚\t␆E］１`;ψ7ζ＋]␖␛\x03]\x14ｏ０u",
	}, { // 4334
		mask: EncodeDel | EncodeRightCrLfHtVt,
		in:   "ｉ␉ξ=\u007f＄␟%ζ␚\t␆E］１`;ψ7ζ＋]␖␛\x03]\x14ｏ０u",
		out:  "ｉ␉ξ=␡＄␟%ζ␚\t␆E］１`;ψ7ζ＋]␖␛\x03]\x14ｏ０u",
	}, { // 4335
		mask: EncodeDel | EncodeRightCrLfHtVt,
		in:   "ｉ\tξ=\u007f＄␟%ζ␚\t␆E］１`;ψ7ζ＋]␖␛\x03]\x14ｏ␉u",
		out:  "ｉ\tξ=␡＄␟%ζ␚\t␆E］１`;ψ7ζ＋]␖␛\x03]\x14ｏ␉u",
	}, { // 4336
		mask: EncodeDel | EncodeRightCrLfHtVt,
		in:   "ｉ␉ξ=\u007f＄␟%ζ␚\t␆E］１`;ψ7ζ＋]␖␛\x03]\x14ｏ␉u",
		out:  "ｉ␉ξ=␡＄␟%ζ␚\t␆E］１`;ψ7ζ＋]␖␛\x03]\x14ｏ␉u",
	}, { // 4337
		mask: EncodeDel | EncodeRightCrLfHtVt,
		in:   "ｉ\tξ=\u007f＄␟%ζ␚\t␆E］１`;ψ7ζ＋]␖␛\x03]\x14ｏ０␉",
		out:  "ｉ\tξ=␡＄␟%ζ␚\t␆E］１`;ψ7ζ＋]␖␛\x03]\x14ｏ０‛␉",
	}, { // 4338
		mask: EncodeDel | EncodeRightCrLfHtVt,
		in:   "ｉ␉ξ=\u007f＄␟%ζ␚\t␆E］１`;ψ7ζ＋]␖␛\x03]\x14ｏ０␉",
		out:  "ｉ␉ξ=␡＄␟%ζ␚\t␆E］１`;ψ7ζ＋]␖␛\x03]\x14ｏ０‛␉",
	}, { // 4339
		mask: EncodeDel | EncodeRightCrLfHtVt,
		in:   "ｉζξ=\u007f＄␟%ζ␚\t␆E］１`;ψ7ζ＋]␖␛\x03]\x14ｏ\tu",
		out:  "ｉζξ=␡＄␟%ζ␚\t␆E］１`;ψ7ζ＋]␖␛\x03]\x14ｏ\tu",
	}, { // 4340
		mask: EncodeDel | EncodeRightCrLfHtVt,
		in:   "ｉζξ=\u007f＄␟%ζ␚\t␆E］１`;ψ7ζ＋]␖␛\x03]\x14ｏ␉u",
		out:  "ｉζξ=␡＄␟%ζ␚\t␆E］１`;ψ7ζ＋]␖␛\x03]\x14ｏ␉u",
	}, { // 4341
		mask: EncodeDel | EncodeRightCrLfHtVt,
		in:   "ｉζξ=\u007f＄␟%ζ␚\t␆E］１`;ψ7ζ＋]␖␛\x03]\x14ｏ\t␉",
		out:  "ｉζξ=␡＄␟%ζ␚\t␆E］１`;ψ7ζ＋]␖␛\x03]\x14ｏ\t‛␉",
	}, { // 4342
		mask: EncodeDel | EncodeRightCrLfHtVt,
		in:   "ｉζξ=\u007f＄␟%ζ␚\t␆E］１`;ψ7ζ＋]␖␛\x03]\x14ｏ␉␉",
		out:  "ｉζξ=␡＄␟%ζ␚\t␆E］１`;ψ7ζ＋]␖␛\x03]\x14ｏ␉‛␉",
	}, { // 4343
		mask: EncodeDel | EncodeRightCrLfHtVt,
		in:   "ｉζξ=\u007f＄␟%ζ␚\t␆E］１`;ψ7ζ＋]␖␛\x03]\x14ｏ０\t",
		out:  "ｉζξ=␡＄␟%ζ␚\t␆E］１`;ψ7ζ＋]␖␛\x03]\x14ｏ０␉",
	}, { // 4344
		mask: EncodeDel | EncodeRightCrLfHtVt,
		in:   "ｉζξ=\u007f＄␟%ζ␚\t␆E］１`;ψ7ζ＋]␖␛\x03]\x14ｏ０␉",
		out:  "ｉζξ=␡＄␟%ζ␚\t␆E］１`;ψ7ζ＋]␖␛\x03]\x14ｏ０‛␉",
	}, { // 4345
		mask: EncodeDel | EncodeRightCrLfHtVt,
		in:   "␍G␇α７␈QＴμ；\nβ\x0fＶβY?VＷ \rK＼ς\u007fν\x0f；␃\x05",
		out:  "␍G␇α７␈QＴμ；\nβ\x0fＶβY?VＷ \rK＼ς␡ν\x0f；␃\x05",
	}, { // 4346
		mask: EncodeDel | EncodeRightCrLfHtVt,
		in:   "\n␊␇α７␈QＴμ；\nβ\x0fＶβY?VＷ \rK＼ς\u007fν\x0f；␃\x05",
		out:  "\n␊␇α７␈QＴμ；\nβ\x0fＶβY?VＷ \rK＼ς␡ν\x0f；␃\x05",
	}, { // 4347
		mask: EncodeDel | EncodeRightCrLfHtVt,
		in:   "␊␊␇α７␈QＴμ；\nβ\x0fＶβY?VＷ \rK＼ς\u007fν\x0f；␃\x05",
		out:  "␊␊␇α７␈QＴμ；\nβ\x0fＶβY?VＷ \rK＼ς␡ν\x0f；␃\x05",
	}, { // 4348
		mask: EncodeDel | EncodeRightCrLfHtVt,
		in:   "\nG␇α７␈QＴμ；\nβ\x0fＶβY?VＷ \rK＼ς\u007fν\x0f；␊\x05",
		out:  "\nG␇α７␈QＴμ；\nβ\x0fＶβY?VＷ \rK＼ς␡ν\x0f；␊\x05",
	}, { // 4349
		mask: EncodeDel | EncodeRightCrLfHtVt,
		in:   "␊G␇α７␈QＴμ；\nβ\x0fＶβY?VＷ \rK＼ς\u007fν\x0f；␊\x05",
		out:  "␊G␇α７␈QＴμ；\nβ\x0fＶβY?VＷ \rK＼ς␡ν\x0f；␊\x05",
	}, { // 4350
		mask: EncodeDel | EncodeRightCrLfHtVt,
		in:   "\nG␇α７␈QＴμ；\nβ\x0fＶβY?VＷ \rK＼ς\u007fν\x0f；␃␊",
		out:  "\nG␇α７␈QＴμ；\nβ\x0fＶβY?VＷ \rK＼ς␡ν\x0f；␃‛␊",
	}, { // 4351
		mask: EncodeDel | EncodeRightCrLfHtVt,
		in:   "␊G␇α７␈QＴμ；\nβ\x0fＶβY?VＷ \rK＼ς\u007fν\x0f；␃␊",
		out:  "␊G␇α７␈QＴμ；\nβ\x0fＶβY?VＷ \rK＼ς␡ν\x0f；␃‛␊",
	}, { // 4352
		mask: EncodeDel | EncodeRightCrLfHtVt,
		in:   "␍\n␇α７␈QＴμ；\nβ\x0fＶβY?VＷ \rK＼ς\u007fν\x0f；␃\x05",
		out:  "␍\n␇α７␈QＴμ；\nβ\x0fＶβY?VＷ \rK＼ς␡ν\x0f；␃\x05",
	}, { // 4353
		mask: EncodeDel | EncodeRightCrLfHtVt,
		in:   "␍␊␇α７␈QＴμ；\nβ\x0fＶβY?VＷ \rK＼ς\u007fν\x0f；␃\x05",
		out:  "␍␊␇α７␈QＴμ；\nβ\x0fＶβY?VＷ \rK＼ς␡ν\x0f；␃\x05",
	}, { // 4354
		mask: EncodeDel | EncodeRightCrLfHtVt,
		in:   "␍\n␇α７␈QＴμ；\nβ\x0fＶβY?VＷ \rK＼ς\u007fν\x0f；␊\x05",
		out:  "␍\n␇α７␈QＴμ；\nβ\x0fＶβY?VＷ \rK＼ς␡ν\x0f；␊\x05",
	}, { // 4355
		mask: EncodeDel | EncodeRightCrLfHtVt,
		in:   "␍␊␇α７␈QＴμ；\nβ\x0fＶβY?VＷ \rK＼ς\u007fν\x0f；␊\x05",
		out:  "␍␊␇α７␈QＴμ；\nβ\x0fＶβY?VＷ \rK＼ς␡ν\x0f；␊\x05",
	}, { // 4356
		mask: EncodeDel | EncodeRightCrLfHtVt,
		in:   "␍\n␇α７␈QＴμ；\nβ\x0fＶβY?VＷ \rK＼ς\u007fν\x0f；␃␊",
		out:  "␍\n␇α７␈QＴμ；\nβ\x0fＶβY?VＷ \rK＼ς␡ν\x0f；␃‛␊",
	}, { // 4357
		mask: EncodeDel | EncodeRightCrLfHtVt,
		in:   "␍␊␇α７␈QＴμ；\nβ\x0fＶβY?VＷ \rK＼ς\u007fν\x0f；␃␊",
		out:  "␍␊␇α７␈QＴμ；\nβ\x0fＶβY?VＷ \rK＼ς␡ν\x0f；␃‛␊",
	}, { // 4358
		mask: EncodeDel | EncodeRightCrLfHtVt,
		in:   "␍G␇α７␈QＴμ；\nβ\x0fＶβY?VＷ \rK＼ς\u007fν\x0f；\n\x05",
		out:  "␍G␇α７␈QＴμ；\nβ\x0fＶβY?VＷ \rK＼ς␡ν\x0f；\n\x05",
	}, { // 4359
		mask: EncodeDel | EncodeRightCrLfHtVt,
		in:   "␍G␇α７␈QＴμ；\nβ\x0fＶβY?VＷ \rK＼ς\u007fν\x0f；␊\x05",
		out:  "␍G␇α７␈QＴμ；\nβ\x0fＶβY?VＷ \rK＼ς␡ν\x0f；␊\x05",
	}, { // 4360
		mask: EncodeDel | EncodeRightCrLfHtVt,
		in:   "␍G␇α７␈QＴμ；\nβ\x0fＶβY?VＷ \rK＼ς\u007fν\x0f；\n␊",
		out:  "␍G␇α７␈QＴμ；\nβ\x0fＶβY?VＷ \rK＼ς␡ν\x0f；\n‛␊",
	}, { // 4361
		mask: EncodeDel | EncodeRightCrLfHtVt,
		in:   "␍G␇α７␈QＴμ；\nβ\x0fＶβY?VＷ \rK＼ς\u007fν\x0f；␊␊",
		out:  "␍G␇α７␈QＴμ；\nβ\x0fＶβY?VＷ \rK＼ς␡ν\x0f；␊‛␊",
	}, { // 4362
		mask: EncodeDel | EncodeRightCrLfHtVt,
		in:   "␍G␇α７␈QＴμ；\nβ\x0fＶβY?VＷ \rK＼ς\u007fν\x0f；␃\n",
		out:  "␍G␇α７␈QＴμ；\nβ\x0fＶβY?VＷ \rK＼ς␡ν\x0f；␃␊",
	}, { // 4363
		mask: EncodeDel | EncodeRightCrLfHtVt,
		in:   "␍G␇α７␈QＴμ；\nβ\x0fＶβY?VＷ \rK＼ς\u007fν\x0f；␃␊",
		out:  "␍G␇α７␈QＴμ；\nβ\x0fＶβY?VＷ \rK＼ς␡ν\x0f；␃‛␊",
	}, { // 4364
		mask: EncodeDel | EncodeRightCrLfHtVt,
		in:   "1%｀＊\\Wγκ␐＆\vη␘␝\x04\x0e|π＞ｏκｌ＂␔TＦ:\x03fλ",
		out:  "1%｀＊\\Wγκ␐＆\vη␘␝\x04\x0e|π＞ｏκｌ＂␔TＦ:\x03fλ",
	}, { // 4365
		mask: EncodeDel | EncodeRightCrLfHtVt,
		in:   "\v␋｀＊\\Wγκ␐＆\vη␘␝\x04\x0e|π＞ｏκｌ＂␔TＦ:\x03fλ",
		out:  "\v␋｀＊\\Wγκ␐＆\vη␘␝\x04\x0e|π＞ｏκｌ＂␔TＦ:\x03fλ",
	}, { // 4366
		mask: EncodeDel | EncodeRightCrLfHtVt,
		in:   "␋␋｀＊\\Wγκ␐＆\vη␘␝\x04\x0e|π＞ｏκｌ＂␔TＦ:\x03fλ",
		out:  "␋␋｀＊\\Wγκ␐＆\vη␘␝\x04\x0e|π＞ｏκｌ＂␔TＦ:\x03fλ",
	}, { // 4367
		mask: EncodeDel | EncodeRightCrLfHtVt,
		in:   "\v%｀＊\\Wγκ␐＆\vη␘␝\x04\x0e|π＞ｏκｌ＂␔TＦ:\x03␋λ",
		out:  "\v%｀＊\\Wγκ␐＆\vη␘␝\x04\x0e|π＞ｏκｌ＂␔TＦ:\x03␋λ",
	}, { // 4368
		mask: EncodeDel | EncodeRightCrLfHtVt,
		in:   "␋%｀＊\\Wγκ␐＆\vη␘␝\x04\x0e|π＞ｏκｌ＂␔TＦ:\x03␋λ",
		out:  "␋%｀＊\\Wγκ␐＆\vη␘␝\x04\x0e|π＞ｏκｌ＂␔TＦ:\x03␋λ",
	}, { // 4369
		mask: EncodeDel | EncodeRightCrLfHtVt,
		in:   "\v%｀＊\\Wγκ␐＆\vη␘␝\x04\x0e|π＞ｏκｌ＂␔TＦ:\x03f␋",
		out:  "\v%｀＊\\Wγκ␐＆\vη␘␝\x04\x0e|π＞ｏκｌ＂␔TＦ:\x03f‛␋",
	}, { // 4370
		mask: EncodeDel | EncodeRightCrLfHtVt,
		in:   "␋%｀＊\\Wγκ␐＆\vη␘␝\x04\x0e|π＞ｏκｌ＂␔TＦ:\x03f␋",
		out:  "␋%｀＊\\Wγκ␐＆\vη␘␝\x04\x0e|π＞ｏκｌ＂␔TＦ:\x03f‛␋",
	}, { // 4371
		mask: EncodeDel | EncodeRightCrLfHtVt,
		in:   "1\v｀＊\\Wγκ␐＆\vη␘␝\x04\x0e|π＞ｏκｌ＂␔TＦ:\x03fλ",
		out:  "1\v｀＊\\Wγκ␐＆\vη␘␝\x04\x0e|π＞ｏκｌ＂␔TＦ:\x03fλ",
	}, { // 4372
		mask: EncodeDel | EncodeRightCrLfHtVt,
		in:   "1␋｀＊\\Wγκ␐＆\vη␘␝\x04\x0e|π＞ｏκｌ＂␔TＦ:\x03fλ",
		out:  "1␋｀＊\\Wγκ␐＆\vη␘␝\x04\x0e|π＞ｏκｌ＂␔TＦ:\x03fλ",
	}, { // 4373
		mask: EncodeDel | EncodeRightCrLfHtVt,
		in:   "1\v｀＊\\Wγκ␐＆\vη␘␝\x04\x0e|π＞ｏκｌ＂␔TＦ:\x03␋λ",
		out:  "1\v｀＊\\Wγκ␐＆\vη␘␝\x04\x0e|π＞ｏκｌ＂␔TＦ:\x03␋λ",
	}, { // 4374
		mask: EncodeDel | EncodeRightCrLfHtVt,
		in:   "1␋｀＊\\Wγκ␐＆\vη␘␝\x04\x0e|π＞ｏκｌ＂␔TＦ:\x03␋λ",
		out:  "1␋｀＊\\Wγκ␐＆\vη␘␝\x04\x0e|π＞ｏκｌ＂␔TＦ:\x03␋λ",
	}, { // 4375
		mask: EncodeDel | EncodeRightCrLfHtVt,
		in:   "1\v｀＊\\Wγκ␐＆\vη␘␝\x04\x0e|π＞ｏκｌ＂␔TＦ:\x03f␋",
		out:  "1\v｀＊\\Wγκ␐＆\vη␘␝\x04\x0e|π＞ｏκｌ＂␔TＦ:\x03f‛␋",
	}, { // 4376
		mask: EncodeDel | EncodeRightCrLfHtVt,
		in:   "1␋｀＊\\Wγκ␐＆\vη␘␝\x04\x0e|π＞ｏκｌ＂␔TＦ:\x03f␋",
		out:  "1␋｀＊\\Wγκ␐＆\vη␘␝\x04\x0e|π＞ｏκｌ＂␔TＦ:\x03f‛␋",
	}, { // 4377
		mask: EncodeDel | EncodeRightCrLfHtVt,
		in:   "1%｀＊\\Wγκ␐＆\vη␘␝\x04\x0e|π＞ｏκｌ＂␔TＦ:\x03\vλ",
		out:  "1%｀＊\\Wγκ␐＆\vη␘␝\x04\x0e|π＞ｏκｌ＂␔TＦ:\x03\vλ",
	}, { // 4378
		mask: EncodeDel | EncodeRightCrLfHtVt,
		in:   "1%｀＊\\Wγκ␐＆\vη␘␝\x04\x0e|π＞ｏκｌ＂␔TＦ:\x03␋λ",
		out:  "1%｀＊\\Wγκ␐＆\vη␘␝\x04\x0e|π＞ｏκｌ＂␔TＦ:\x03␋λ",
	}, { // 4379
		mask: EncodeDel | EncodeRightCrLfHtVt,
		in:   "1%｀＊\\Wγκ␐＆\vη␘␝\x04\x0e|π＞ｏκｌ＂␔TＦ:\x03\v␋",
		out:  "1%｀＊\\Wγκ␐＆\vη␘␝\x04\x0e|π＞ｏκｌ＂␔TＦ:\x03\v‛␋",
	}, { // 4380
		mask: EncodeDel | EncodeRightCrLfHtVt,
		in:   "1%｀＊\\Wγκ␐＆\vη␘␝\x04\x0e|π＞ｏκｌ＂␔TＦ:\x03␋␋",
		out:  "1%｀＊\\Wγκ␐＆\vη␘␝\x04\x0e|π＞ｏκｌ＂␔TＦ:\x03␋‛␋",
	}, { // 4381
		mask: EncodeDel | EncodeRightCrLfHtVt,
		in:   "1%｀＊\\Wγκ␐＆\vη␘␝\x04\x0e|π＞ｏκｌ＂␔TＦ:\x03f\v",
		out:  "1%｀＊\\Wγκ␐＆\vη␘␝\x04\x0e|π＞ｏκｌ＂␔TＦ:\x03f␋",
	}, { // 4382
		mask: EncodeDel | EncodeRightCrLfHtVt,
		in:   "1%｀＊\\Wγκ␐＆\vη␘␝\x04\x0e|π＞ｏκｌ＂␔TＦ:\x03f␋",
		out:  "1%｀＊\\Wγκ␐＆\vη␘␝\x04\x0e|π＞ｏκｌ＂␔TＦ:\x03f‛␋",
	}, { // 4383
		mask: EncodeDel | EncodeRightCrLfHtVt,
		in:   "ｓκα＃＿\x1c,｀ＰE\r\n\\␙σ＜δ␐οο(\u007f／\aFZ␊／$ｌ",
		out:  "ｓκα＃＿\x1c,｀ＰE\r\n\\␙σ＜δ␐οο(␡／\aFZ␊／$ｌ",
	}, { // 4384
		mask: EncodeDel | EncodeRightCrLfHtVt,
		in:   "\r␍α＃＿\x1c,｀ＰE\r\n\\␙σ＜δ␐οο(\u007f／\aFZ␊／$ｌ",
		out:  "\r␍α＃＿\x1c,｀ＰE\r\n\\␙σ＜δ␐οο(␡／\aFZ␊／$ｌ",
	}, { // 4385
		mask: EncodeDel | EncodeRightCrLfHtVt,
		in:   "␍␍α＃＿\x1c,｀ＰE\r\n\\␙σ＜δ␐οο(\u007f／\aFZ␊／$ｌ",
		out:  "␍␍α＃＿\x1c,｀ＰE\r\n\\␙σ＜δ␐οο(␡／\aFZ␊／$ｌ",
	}, { // 4386
		mask: EncodeDel | EncodeRightCrLfHtVt,
		in:   "\rκα＃＿\x1c,｀ＰE\r\n\\␙σ＜δ␐οο(\u007f／\aFZ␊／␍ｌ",
		out:  "\rκα＃＿\x1c,｀ＰE\r\n\\␙σ＜δ␐οο(␡／\aFZ␊／␍ｌ",
	}, { // 4387
		mask: EncodeDel | EncodeRightCrLfHtVt,
		in:   "␍κα＃＿\x1c,｀ＰE\r\n\\␙σ＜δ␐οο(\u007f／\aFZ␊／␍ｌ",
		out:  "␍κα＃＿\x1c,｀ＰE\r\n\\␙σ＜δ␐οο(␡／\aFZ␊／␍ｌ",
	}, { // 4388
		mask: EncodeDel | EncodeRightCrLfHtVt,
		in:   "\rκα＃＿\x1c,｀ＰE\r\n\\␙σ＜δ␐οο(\u007f／\aFZ␊／$␍",
		out:  "\rκα＃＿\x1c,｀ＰE\r\n\\␙σ＜δ␐οο(␡／\aFZ␊／$‛␍",
	}, { // 4389
		mask: EncodeDel | EncodeRightCrLfHtVt,
		in:   "␍κα＃＿\x1c,｀ＰE\r\n\\␙σ＜δ␐οο(\u007f／\aFZ␊／$␍",
		out:  "␍κα＃＿\x1c,｀ＰE\r\n\\␙σ＜δ␐οο(␡／\aFZ␊／$‛␍",
	}, { // 4390
		mask: EncodeDel | EncodeRightCrLfHtVt,
		in:   "ｓ\rα＃＿\x1c,｀ＰE\r\n\\␙σ＜δ␐οο(\u007f／\aFZ␊／$ｌ",
		out:  "ｓ\rα＃＿\x1c,｀ＰE\r\n\\␙σ＜δ␐οο(␡／\aFZ␊／$ｌ",
	}, { // 4391
		mask: EncodeDel | EncodeRightCrLfHtVt,
		in:   "ｓ␍α＃＿\x1c,｀ＰE\r\n\\␙σ＜δ␐οο(\u007f／\aFZ␊／$ｌ",
		out:  "ｓ␍α＃＿\x1c,｀ＰE\r\n\\␙σ＜δ␐οο(␡／\aFZ␊／$ｌ",
	}, { // 4392
		mask: EncodeDel | EncodeRightCrLfHtVt,
		in:   "ｓ\rα＃＿\x1c,｀ＰE\r\n\\␙σ＜δ␐οο(\u007f／\aFZ␊／␍ｌ",
		out:  "ｓ\rα＃＿\x1c,｀ＰE\r\n\\␙σ＜δ␐οο(␡／\aFZ␊／␍ｌ",
	}, { // 4393
		mask: EncodeDel | EncodeRightCrLfHtVt,
		in:   "ｓ␍α＃＿\x1c,｀ＰE\r\n\\␙σ＜δ␐οο(\u007f／\aFZ␊／␍ｌ",
		out:  "ｓ␍α＃＿\x1c,｀ＰE\r\n\\␙σ＜δ␐οο(␡／\aFZ␊／␍ｌ",
	}, { // 4394
		mask: EncodeDel | EncodeRightCrLfHtVt,
		in:   "ｓ\rα＃＿\x1c,｀ＰE\r\n\\␙σ＜δ␐οο(\u007f／\aFZ␊／$␍",
		out:  "ｓ\rα＃＿\x1c,｀ＰE\r\n\\␙σ＜δ␐οο(␡／\aFZ␊／$‛␍",
	}, { // 4395
		mask: EncodeDel | EncodeRightCrLfHtVt,
		in:   "ｓ␍α＃＿\x1c,｀ＰE\r\n\\␙σ＜δ␐οο(\u007f／\aFZ␊／$␍",
		out:  "ｓ␍α＃＿\x1c,｀ＰE\r\n\\␙σ＜δ␐οο(␡／\aFZ␊／$‛␍",
	}, { // 4396
		mask: EncodeDel | EncodeRightCrLfHtVt,
		in:   "ｓκα＃＿\x1c,｀ＰE\r\n\\␙σ＜δ␐οο(\u007f／\aFZ␊／\rｌ",
		out:  "ｓκα＃＿\x1c,｀ＰE\r\n\\␙σ＜δ␐οο(␡／\aFZ␊／\rｌ",
	}, { // 4397
		mask: EncodeDel | EncodeRightCrLfHtVt,
		in:   "ｓκα＃＿\x1c,｀ＰE\r\n\\␙σ＜δ␐οο(\u007f／\aFZ␊／␍ｌ",
		out:  "ｓκα＃＿\x1c,｀ＰE\r\n\\␙σ＜δ␐οο(␡／\aFZ␊／␍ｌ",
	}, { // 4398
		mask: EncodeDel | EncodeRightCrLfHtVt,
		in:   "ｓκα＃＿\x1c,｀ＰE\r\n\\␙σ＜δ␐οο(\u007f／\aFZ␊／\r␍",
		out:  "ｓκα＃＿\x1c,｀ＰE\r\n\\␙σ＜δ␐οο(␡／\aFZ␊／\r‛␍",
	}, { // 4399
		mask: EncodeDel | EncodeRightCrLfHtVt,
		in:   "ｓκα＃＿\x1c,｀ＰE\r\n\\␙σ＜δ␐οο(\u007f／\aFZ␊／␍␍",
		out:  "ｓκα＃＿\x1c,｀ＰE\r\n\\␙σ＜δ␐οο(␡／\aFZ␊／␍‛␍",
	}, { // 4400
		mask: EncodeDel | EncodeRightCrLfHtVt,
		in:   "ｓκα＃＿\x1c,｀ＰE\r\n\\␙σ＜δ␐οο(\u007f／\aFZ␊／$\r",
		out:  "ｓκα＃＿\x1c,｀ＰE\r\n\\␙σ＜δ␐οο(␡／\aFZ␊／$␍",
	}, { // 4401
		mask: EncodeDel | EncodeRightCrLfHtVt,
		in:   "ｓκα＃＿\x1c,｀ＰE\r\n\\␙σ＜δ␐οο(\u007f／\aFZ␊／$␍",
		out:  "ｓκα＃＿\x1c,｀ＰE\r\n\\␙σ＜δ␐οο(␡／\aFZ␊／$‛␍",
	}, { // 4402
		mask: EncodeLeftSpace,
		in:   "  ",
		out:  "␠ ",
	}, { // 4403
		mask: EncodeLeftPeriod,
		in:   "..",
		out:  "．.",
	}, { // 4404
		mask: EncodeLeftTilde,
		in:   "~~",
		out:  "～~",
	}, { // 4405
		mask: EncodeRightSpace,
		in:   "  ",
		out:  " ␠",
	}, { // 4406
		mask: EncodeRightPeriod,
		in:   "..",
		out:  ".．",
	}, { // 4407
		mask: EncodeLeftSpace | EncodeRightPeriod,
		in:   " .",
		out:  "␠．",
	}, { // 4408
		mask: EncodeLeftSpace | EncodeRightSpace,
		in:   " ",
		out:  "␠",
	}, { // 4409
		mask: EncodeLeftSpace | EncodeRightSpace,
		in:   "  ",
		out:  "␠␠",
	}, { // 4410
		mask: EncodeLeftSpace | EncodeRightSpace,
		in:   "   ",
		out:  "␠ ␠",
	}, { // 4411
		mask: EncodeLeftPeriod | EncodeRightPeriod,
		in:   "...",
		out:  "．.．",
	}, { // 4412
		mask: EncodeRightPeriod | EncodeRightSpace,
		in:   "a. ",
		out:  "a.␠",
	}, { // 4413
		mask: EncodeRightPeriod | EncodeRightSpace,
		in:   "a .",
		out:  "a ．",
	},
}

var testCasesDoubleEdge = []testCase{
	{ // 0
		mask: EncodeZero | EncodeLeftSpace | EncodeLeftPeriod,
		in:   " .υ␃ｖA\vθＴ+Ｙ［３｜ιδ\x1e\"\x1a\x1b␗2?%{␎d＇.β",
		out:  "␠.υ␃ｖA\vθＴ+Ｙ［３｜ιδ\x1e\"\x1a\x1b␗2?%{␎d＇.β",
	}, { // 1
		mask: EncodeZero | EncodeLeftSpace | EncodeLeftPeriod,
		in:   "␠.υ␃ｖA\vθＴ+Ｙ［３｜ιδ\x1e\"\x1a\x1b␗2?%{␎d＇.β",
		out:  "‛␠.υ␃ｖA\vθＴ+Ｙ［３｜ιδ\x1e\"\x1a\x1b␗2?%{␎d＇.β",
	}, { // 2
		mask: EncodeZero | EncodeLeftSpace | EncodeLeftPeriod,
		in:   "ρ.υ␃ｖA\vθＴ+Ｙ［３｜ιδ\x1e\"\x1a\x1b␗2?%{␎d＇. ",
		out:  "ρ.υ␃ｖA\vθＴ+Ｙ［３｜ιδ\x1e\"\x1a\x1b␗2?%{␎d＇. ",
	}, { // 3
		mask: EncodeZero | EncodeLeftSpace | EncodeLeftPeriod,
		in:   "ρ.υ␃ｖA\vθＴ+Ｙ［３｜ιδ\x1e\"\x1a\x1b␗2?%{␎d＇.␠",
		out:  "ρ.υ␃ｖA\vθＴ+Ｙ［３｜ιδ\x1e\"\x1a\x1b␗2?%{␎d＇.␠",
	}, { // 4
		mask: EncodeSlash | EncodeLeftSpace | EncodeLeftPeriod,
		in:   " .␎＂S＂？[Ｈ1／φＹ\r０４ιq.υ␘+\x1bｐω\x16\nψ.P",
		out:  "␠.␎＂S＂？[Ｈ1‛／φＹ\r０４ιq.υ␘+\x1bｐω\x16\nψ.P",
	}, { // 5
		mask: EncodeSlash | EncodeLeftSpace | EncodeLeftPeriod,
		in:   "␠.␎＂S＂？[Ｈ1／φＹ\r０４ιq.υ␘+\x1bｐω\x16\nψ.P",
		out:  "‛␠.␎＂S＂？[Ｈ1‛／φＹ\r０４ιq.υ␘+\x1bｐω\x16\nψ.P",
	}, { // 6
		mask: EncodeSlash | EncodeLeftSpace | EncodeLeftPeriod,
		in:   "\x12.␎＂S＂？[Ｈ1／φＹ\r０４ιq.υ␘+\x1bｐω\x16\nψ. ",
		out:  "\x12.␎＂S＂？[Ｈ1‛／φＹ\r０４ιq.υ␘+\x1bｐω\x16\nψ. ",
	}, { // 7
		mask: EncodeSlash | EncodeLeftSpace | EncodeLeftPeriod,
		in:   "\x12.␎＂S＂？[Ｈ1／φＹ\r０４ιq.υ␘+\x1bｐω\x16\nψ.␠",
		out:  "\x12.␎＂S＂？[Ｈ1‛／φＹ\r０４ιq.υ␘+\x1bｐω\x16\nψ.␠",
	}, { // 8
		mask: EncodeSingleQuote | EncodeLeftSpace | EncodeLeftPeriod,
		in:   " .πNfμφγ%ｍ＼\\␊␑␃４`ｙ＆\x03\x1fτ，l\x01＄\r␟.h",
		out:  "␠.πNfμφγ%ｍ＼\\␊␑␃４`ｙ＆\x03\x1fτ，l\x01＄\r␟.h",
	}, { // 9
		mask: EncodeSingleQuote | EncodeLeftSpace | EncodeLeftPeriod,
		in:   "␠.πNfμφγ%ｍ＼\\␊␑␃４`ｙ＆\x03\x1fτ，l\x01＄\r␟.h",
		out:  "‛␠.πNfμφγ%ｍ＼\\␊␑␃４`ｙ＆\x03\x1fτ，l\x01＄\r␟.h",
	}, { // 10
		mask: EncodeSingleQuote | EncodeLeftSpace | EncodeLeftPeriod,
		in:   "χ.πNfμφγ%ｍ＼\\␊␑␃４`ｙ＆\x03\x1fτ，l\x01＄\r␟. ",
		out:  "χ.πNfμφγ%ｍ＼\\␊␑␃４`ｙ＆\x03\x1fτ，l\x01＄\r␟. ",
	}, { // 11
		mask: EncodeSingleQuote | EncodeLeftSpace | EncodeLeftPeriod,
		in:   "χ.πNfμφγ%ｍ＼\\␊␑␃４`ｙ＆\x03\x1fτ，l\x01＄\r␟.␠",
		out:  "χ.πNfμφγ%ｍ＼\\␊␑␃４`ｙ＆\x03\x1fτ，l\x01＄\r␟.␠",
	}, { // 12
		mask: EncodeBackQuote | EncodeLeftSpace | EncodeLeftPeriod,
		in:   " .␔φ␊=@x\x1e\x00|-κ␊σ~βν\t＝＄Ｑ\f；␛\x1bＴ␀.␖",
		out:  "␠.␔φ␊=@x\x1e␀|-κ␊σ~βν\t＝＄Ｑ\f；␛\x1bＴ‛␀.␖",
	}, { // 13
		mask: EncodeBackQuote | EncodeLeftSpace | EncodeLeftPeriod,
		in:   "␠.␔φ␊=@x\x1e\x00|-κ␊σ~βν\t＝＄Ｑ\f；␛\x1bＴ␀.␖",
		out:  "‛␠.␔φ␊=@x\x1e␀|-κ␊σ~βν\t＝＄Ｑ\f；␛\x1bＴ‛␀.␖",
	}, { // 14
		mask: EncodeBackQuote | EncodeLeftSpace | EncodeLeftPeriod,
		in:   "／.␔φ␊=@x\x1e\x00|-κ␊σ~βν\t＝＄Ｑ\f；␛\x1bＴ␀. ",
		out:  "／.␔φ␊=@x\x1e␀|-κ␊σ~βν\t＝＄Ｑ\f；␛\x1bＴ‛␀. ",
	}, { // 15
		mask: EncodeBackQuote | EncodeLeftSpace | EncodeLeftPeriod,
		in:   "／.␔φ␊=@x\x1e\x00|-κ␊σ~βν\t＝＄Ｑ\f；␛\x1bＴ␀.␠",
		out:  "／.␔φ␊=@x\x1e␀|-κ␊σ~βν\t＝＄Ｑ\f；␛\x1bＴ‛␀.␠",
	}, { // 16
		mask: EncodeLtGt | EncodeLeftSpace | EncodeLeftPeriod,
		in:   " .λτ＆␊ｐU:I\x18\x18＞5␕］＇\x19;φνO\x17\x12η␗λ␌.Ｙ",
		out:  "␠.λτ＆␊ｐU:I\x18\x18‛＞5␕］＇\x19;φνO\x17\x12η␗λ␌.Ｙ",
	}, { // 17
		mask: EncodeLtGt | EncodeLeftSpace | EncodeLeftPeriod,
		in:   "␠.λτ＆␊ｐU:I\x18\x18＞5␕］＇\x19;φνO\x17\x12η␗λ␌.Ｙ",
		out:  "‛␠.λτ＆␊ｐU:I\x18\x18‛＞5␕］＇\x19;φνO\x17\x12η␗λ␌.Ｙ",
	}, { // 18
		mask: EncodeLtGt | EncodeLeftSpace | EncodeLeftPeriod,
		in:   "␌.λτ＆␊ｐU:I\x18\x18＞5␕］＇\x19;φνO\x17\x12η␗λ␌. ",
		out:  "␌.λτ＆␊ｐU:I\x18\x18‛＞5␕］＇\x19;φνO\x17\x12η␗λ␌. ",
	}, { // 19
		mask: EncodeLtGt | EncodeLeftSpace | EncodeLeftPeriod,
		in:   "␌.λτ＆␊ｐU:I\x18\x18＞5␕］＇\x19;φνO\x17\x12η␗λ␌.␠",
		out:  "␌.λτ＆␊ｐU:I\x18\x18‛＞5␕］＇\x19;φνO\x17\x12η␗λ␌.␠",
	}, { // 20
		mask: EncodeSquareBracket | EncodeLeftSpace | EncodeLeftPeriod,
		in:   " .␗\x04/ο＆␜γｗζ=␏４n␉\x1fＺNZ␝φ\u007fJＯφｍ\r.o",
		out:  "␠.␗\x04/ο＆␜γｗζ=␏４n␉\x1fＺNZ␝φ\u007fJＯφｍ\r.o",
	}, { // 21
		mask: EncodeSquareBracket | EncodeLeftSpace | EncodeLeftPeriod,
		in:   "␠.␗\x04/ο＆␜γｗζ=␏４n␉\x1fＺNZ␝φ\u007fJＯφｍ\r.o",
		out:  "‛␠.␗\x04/ο＆␜γｗζ=␏４n␉\x1fＺNZ␝φ\u007fJＯφｍ\r.o",
	}, { // 22
		mask: EncodeSquareBracket | EncodeLeftSpace | EncodeLeftPeriod,
		in:   "␑.␗\x04/ο＆␜γｗζ=␏４n␉\x1fＺNZ␝φ\u007fJＯφｍ\r. ",
		out:  "␑.␗\x04/ο＆␜γｗζ=␏４n␉\x1fＺNZ␝φ\u007fJＯφｍ\r. ",
	}, { // 23
		mask: EncodeSquareBracket | EncodeLeftSpace | EncodeLeftPeriod,
		in:   "␑.␗\x04/ο＆␜γｗζ=␏４n␉\x1fＺNZ␝φ\u007fJＯφｍ\r.␠",
		out:  "␑.␗\x04/ο＆␜γｗζ=␏４n␉\x1fＺNZ␝φ\u007fJＯφｍ\r.␠",
	}, { // 24
		mask: EncodeSemicolon | EncodeLeftSpace | EncodeLeftPeriod,
		in:   " .< ｀␅\b:␅r％?ξγ\"ｑ\x13λ\x02τｏ␍nνξ7␎／.｜",
		out:  "␠.< ｀␅\b:␅r％?ξγ\"ｑ\x13λ\x02τｏ␍nνξ7␎／.｜",
	}, { // 25
		mask: EncodeSemicolon | EncodeLeftSpace | EncodeLeftPeriod,
		in:   "␠.< ｀␅\b:␅r％?ξγ\"ｑ\x13λ\x02τｏ␍nνξ7␎／.｜",
		out:  "‛␠.< ｀␅\b:␅r％?ξγ\"ｑ\x13λ\x02τｏ␍nνξ7␎／.｜",
	}, { // 26
		mask: EncodeSemicolon | EncodeLeftSpace | EncodeLeftPeriod,
		in:   "Ｓ.< ｀␅\b:␅r％?ξγ\"ｑ\x13λ\x02τｏ␍nνξ7␎／. ",
		out:  "Ｓ.< ｀␅\b:␅r％?ξγ\"ｑ\x13λ\x02τｏ␍nνξ7␎／. ",
	}, { // 27
		mask: EncodeSemicolon | EncodeLeftSpace | EncodeLeftPeriod,
		in:   "Ｓ.< ｀␅\b:␅r％?ξγ\"ｑ\x13λ\x02τｏ␍nνξ7␎／.␠",
		out:  "Ｓ.< ｀␅\b:␅r％?ξγ\"ｑ\x13λ\x02τｏ␍nνξ7␎／.␠",
	}, { // 28
		mask: EncodeDollar | EncodeLeftSpace | EncodeLeftPeriod,
		in:   " .<％␉ｎ\x1cκ+η␋χ<\a8␏/｜σνRπ;\x12＃？５３.｀",
		out:  "␠.<％␉ｎ\x1cκ+η␋χ<\a8␏/｜σνRπ;\x12＃？５３.｀",
	}, { // 29
		mask: EncodeDollar | EncodeLeftSpace | EncodeLeftPeriod,
		in:   "␠.<％␉ｎ\x1cκ+η␋χ<\a8␏/｜σνRπ;\x12＃？５３.｀",
		out:  "‛␠.<％␉ｎ\x1cκ+η␋χ<\a8␏/｜σνRπ;\x12＃？５３.｀",
	}, { // 30
		mask: EncodeDollar | EncodeLeftSpace | EncodeLeftPeriod,
		in:   "␂.<％␉ｎ\x1cκ+η␋χ<\a8␏/｜σνRπ;\x12＃？５３. ",
		out:  "␂.<％␉ｎ\x1cκ+η␋χ<\a8␏/｜σνRπ;\x12＃？５３. ",
	}, { // 31
		mask: EncodeDollar | EncodeLeftSpace | EncodeLeftPeriod,
		in:   "␂.<％␉ｎ\x1cκ+η␋χ<\a8␏/｜σνRπ;\x12＃？５３.␠",
		out:  "␂.<％␉ｎ\x1cκ+η␋χ<\a8␏/｜σνRπ;\x12＃？５３.␠",
	}, { // 32
		mask: EncodeDoubleQuote | EncodeLeftSpace | EncodeLeftPeriod,
		in:   " .␆␞␑ωｅａδＫ␜|<kd|＊␉Bδ＇?ｙθωJ＃/.F",
		out:  "␠.␆␞␑ωｅａδＫ␜|<kd|＊␉Bδ＇?ｙθωJ＃/.F",
	}, { // 33
		mask: EncodeDoubleQuote | EncodeLeftSpace | EncodeLeftPeriod,
		in:   "␠.␆␞␑ωｅａδＫ␜|<kd|＊␉Bδ＇?ｙθωJ＃/.F",
		out:  "‛␠.␆␞␑ωｅａδＫ␜|<kd|＊␉Bδ＇?ｙθωJ＃/.F",
	}, { // 34
		mask: EncodeDoubleQuote | EncodeLeftSpace | EncodeLeftPeriod,
		in:   "\x01.␆␞␑ωｅａδＫ␜|<kd|＊␉Bδ＇?ｙθωJ＃/. ",
		out:  "\x01.␆␞␑ωｅａδＫ␜|<kd|＊␉Bδ＇?ｙθωJ＃/. ",
	}, { // 35
		mask: EncodeDoubleQuote | EncodeLeftSpace | EncodeLeftPeriod,
		in:   "\x01.␆␞␑ωｅａδＫ␜|<kd|＊␉Bδ＇?ｙθωJ＃/.␠",
		out:  "\x01.␆␞␑ωｅａδＫ␜|<kd|＊␉Bδ＇?ｙθωJ＃/.␠",
	}, { // 36
		mask: EncodeColon | EncodeLeftSpace | EncodeLeftPeriod,
		in:   " .ω7αＳ␖MＵ\x16}\x1b＇β␍｜␊τ]!ｅ␊'χF\r_Ｉ.ο",
		out:  "␠.ω7αＳ␖MＵ\x16}\x1b＇β␍｜␊τ]!ｅ␊'χF\r_Ｉ.ο",
	}, { // 37
		mask: EncodeColon | EncodeLeftSpace | EncodeLeftPeriod,
		in:   "␠.ω7αＳ␖MＵ\x16}\x1b＇β␍｜␊τ]!ｅ␊'χF\r_Ｉ.ο",
		out:  "‛␠.ω7αＳ␖MＵ\x16}\x1b＇β␍｜␊τ]!ｅ␊'χF\r_Ｉ.ο",
	}, { // 38
		mask: EncodeColon | EncodeLeftSpace | EncodeLeftPeriod,
		in:   "\r.ω7αＳ␖MＵ\x16}\x1b＇β␍｜␊τ]!ｅ␊'χF\r_Ｉ. ",
		out:  "\r.ω7αＳ␖MＵ\x16}\x1b＇β␍｜␊τ]!ｅ␊'χF\r_Ｉ. ",
	}, { // 39
		mask: EncodeColon | EncodeLeftSpace | EncodeLeftPeriod,
		in:   "\r.ω7αＳ␖MＵ\x16}\x1b＇β␍｜␊τ]!ｅ␊'χF\r_Ｉ.␠",
		out:  "\r.ω7αＳ␖MＵ\x16}\x1b＇β␍｜␊τ]!ｅ␊'χF\r_Ｉ.␠",
	}, { // 40
		mask: EncodeQuestion | EncodeLeftSpace | EncodeLeftPeriod,
		in:   " .＜\x18，％／\"θμ;｝λ<ζｄｙ８9Y␇$Z\rι$\f／.^",
		out:  "␠.＜\x18，％／\"θμ;｝λ<ζｄｙ８9Y␇$Z\rι$\f／.^",
	}, { // 41
		mask: EncodeQuestion | EncodeLeftSpace | EncodeLeftPeriod,
		in:   "␠.＜\x18，％／\"θμ;｝λ<ζｄｙ８9Y␇$Z\rι$\f／.^",
		out:  "‛␠.＜\x18，％／\"θμ;｝λ<ζｄｙ８9Y␇$Z\rι$\f／.^",
	}, { // 42
		mask: EncodeQuestion | EncodeLeftSpace | EncodeLeftPeriod,
		in:   "＋.＜\x18，％／\"θμ;｝λ<ζｄｙ８9Y␇$Z\rι$\f／. ",
		out:  "＋.＜\x18，％／\"θμ;｝λ<ζｄｙ８9Y␇$Z\rι$\f／. ",
	}, { // 43
		mask: EncodeQuestion | EncodeLeftSpace | EncodeLeftPeriod,
		in:   "＋.＜\x18，％／\"θμ;｝λ<ζｄｙ８9Y␇$Z\rι$\f／.␠",
		out:  "＋.＜\x18，％／\"θμ;｝λ<ζｄｙ８9Y␇$Z\rι$\f／.␠",
	}, { // 44
		mask: EncodeAsterisk | EncodeLeftSpace | EncodeLeftPeriod,
		in:   " .␡λ\x03\x02\x13;ｕ＞␀［χhＭ*ψξ␜:\aiσＬeNς＂.:",
		out:  "␠.␡λ\x03\x02\x13;ｕ＞‛␀［χhＭ＊ψξ␜:\aiσＬeNς＂.:",
	}, { // 45
		mask: EncodeAsterisk | EncodeLeftSpace | EncodeLeftPeriod,
		in:   "␠.␡λ\x03\x02\x13;ｕ＞␀［χhＭ*ψξ␜:\aiσＬeNς＂.:",
		out:  "‛␠.␡λ\x03\x02\x13;ｕ＞‛␀［χhＭ＊ψξ␜:\aiσＬeNς＂.:",
	}, { // 46
		mask: EncodeAsterisk | EncodeLeftSpace | EncodeLeftPeriod,
		in:   "＂.␡λ\x03\x02\x13;ｕ＞␀［χhＭ*ψξ␜:\aiσＬeNς＂. ",
		out:  "＂.␡λ\x03\x02\x13;ｕ＞‛␀［χhＭ＊ψξ␜:\aiσＬeNς＂. ",
	}, { // 47
		mask: EncodeAsterisk | EncodeLeftSpace | EncodeLeftPeriod,
		in:   "＂.␡λ\x03\x02\x13;ｕ＞␀［χhＭ*ψξ␜:\aiσＬeNς＂.␠",
		out:  "＂.␡λ\x03\x02\x13;ｕ＞‛␀［χhＭ＊ψξ␜:\aiσＬeNς＂.␠",
	}, { // 48
		mask: EncodePipe | EncodeLeftSpace | EncodeLeftPeriod,
		in:   " .Ｓ\x1cＥωaι␀w？␋)τψＹ＞ｔ\x1b\x13ｈσ；'8\">｀.*",
		out:  "␠.Ｓ\x1cＥωaι‛␀w？␋)τψＹ＞ｔ\x1b\x13ｈσ；'8\">｀.*",
	}, { // 49
		mask: EncodePipe | EncodeLeftSpace | EncodeLeftPeriod,
		in:   "␠.Ｓ\x1cＥωaι␀w？␋)τψＹ＞ｔ\x1b\x13ｈσ；'8\">｀.*",
		out:  "‛␠.Ｓ\x1cＥωaι‛␀w？␋)τψＹ＞ｔ\x1b\x13ｈσ；'8\">｀.*",
	}, { // 50
		mask: EncodePipe | EncodeLeftSpace | EncodeLeftPeriod,
		in:   "τ.Ｓ\x1cＥωaι␀w？␋)τψＹ＞ｔ\x1b\x13ｈσ；'8\">｀. ",
		out:  "τ.Ｓ\x1cＥωaι‛␀w？␋)τψＹ＞ｔ\x1b\x13ｈσ；'8\">｀. ",
	}, { // 51
		mask: EncodePipe | EncodeLeftSpace | EncodeLeftPeriod,
		in:   "τ.Ｓ\x1cＥωaι␀w？␋)τψＹ＞ｔ\x1b\x13ｈσ；'8\">｀.␠",
		out:  "τ.Ｓ\x1cＥωaι‛␀w？␋)τψＹ＞ｔ\x1b\x13ｈσ；'8\">｀.␠",
	}, { // 52
		mask: EncodeHash | EncodeLeftSpace | EncodeLeftPeriod,
		in:   " .φ\"\x00？V␊\rKδ９Ｙς:ξＣ［␂P\x11＊οＱ6\\␖τ.b",
		out:  "␠.φ\"␀？V␊\rKδ９Ｙς:ξＣ［␂P\x11＊οＱ6\\␖τ.b",
	}, { // 53
		mask: EncodeHash | EncodeLeftSpace | EncodeLeftPeriod,
		in:   "␠.φ\"\x00？V␊\rKδ９Ｙς:ξＣ［␂P\x11＊οＱ6\\␖τ.b",
		out:  "‛␠.φ\"␀？V␊\rKδ９Ｙς:ξＣ［␂P\x11＊οＱ6\\␖τ.b",
	}, { // 54
		mask: EncodeHash | EncodeLeftSpace | EncodeLeftPeriod,
		in:   "%.φ\"\x00？V␊\rKδ９Ｙς:ξＣ［␂P\x11＊οＱ6\\␖τ. ",
		out:  "%.φ\"␀？V␊\rKδ９Ｙς:ξＣ［␂P\x11＊οＱ6\\␖τ. ",
	}, { // 55
		mask: EncodeHash | EncodeLeftSpace | EncodeLeftPeriod,
		in:   "%.φ\"\x00？V␊\rKδ９Ｙς:ξＣ［␂P\x11＊οＱ6\\␖τ.␠",
		out:  "%.φ\"␀？V␊\rKδ９Ｙς:ξＣ［␂P\x11＊οＱ6\\␖τ.␠",
	}, { // 56
		mask: EncodePercent | EncodeLeftSpace | EncodeLeftPeriod,
		in:   " .ρ$｀，␂+.␞γT]ｋ␊\nｅν␇\x19;\aρ]ｉ␂Ｏθ.:",
		out:  "␠.ρ$｀，␂+.␞γT]ｋ␊\nｅν␇\x19;\aρ]ｉ␂Ｏθ.:",
	}, { // 57
		mask: EncodePercent | EncodeLeftSpace | EncodeLeftPeriod,
		in:   "␠.ρ$｀，␂+.␞γT]ｋ␊\nｅν␇\x19;\aρ]ｉ␂Ｏθ.:",
		out:  "‛␠.ρ$｀，␂+.␞γT]ｋ␊\nｅν␇\x19;\aρ]ｉ␂Ｏθ.:",
	}, { // 58
		mask: EncodePercent | EncodeLeftSpace | EncodeLeftPeriod,
		in:   "θ.ρ$｀，␂+.␞γT]ｋ␊\nｅν␇\x19;\aρ]ｉ␂Ｏθ. ",
		out:  "θ.ρ$｀，␂+.␞γT]ｋ␊\nｅν␇\x19;\aρ]ｉ␂Ｏθ. ",
	}, { // 59
		mask: EncodePercent | EncodeLeftSpace | EncodeLeftPeriod,
		in:   "θ.ρ$｀，␂+.␞γT]ｋ␊\nｅν␇\x19;\aρ]ｉ␂Ｏθ.␠",
		out:  "θ.ρ$｀，␂+.␞γT]ｋ␊\nｅν␇\x19;\aρ]ｉ␂Ｏθ.␠",
	}, { // 60
		mask: EncodeBackSlash | EncodeLeftSpace | EncodeLeftPeriod,
		in:   " .\tｋ＊ρςｍ<ο!\f2s\x1e=#ψ\x1a␎␄␀＂χ␝␙σ］.?",
		out:  "␠.\tｋ＊ρςｍ<ο!\f2s\x1e=#ψ\x1a␎␄‛␀＂χ␝␙σ］.?",
	}, { // 61
		mask: EncodeBackSlash | EncodeLeftSpace | EncodeLeftPeriod,
		in:   "␠.\tｋ＊ρςｍ<ο!\f2s\x1e=#ψ\x1a␎␄␀＂χ␝␙σ］.?",
		out:  "‛␠.\tｋ＊ρςｍ<ο!\f2s\x1e=#ψ\x1a␎␄‛␀＂χ␝␙σ］.?",
	}, { // 62
		mask: EncodeBackSlash | EncodeLeftSpace | EncodeLeftPeriod,
		in:   "％.\tｋ＊ρςｍ<ο!\f2s\x1e=#ψ\x1a␎␄␀＂χ␝␙σ］. ",
		out:  "％.\tｋ＊ρςｍ<ο!\f2s\x1e=#ψ\x1a␎␄‛␀＂χ␝␙σ］. ",
	}, { // 63
		mask: EncodeBackSlash | EncodeLeftSpace | EncodeLeftPeriod,
		in:   "％.\tｋ＊ρςｍ<ο!\f2s\x1e=#ψ\x1a␎␄␀＂χ␝␙σ］.␠",
		out:  "％.\tｋ＊ρςｍ<ο!\f2s\x1e=#ψ\x1a␎␄‛␀＂χ␝␙σ］.␠",
	}, { // 64
		mask: EncodeCrLf | EncodeLeftSpace | EncodeLeftPeriod,
		in:   " .＄βκ␟β\x0e␛T\x1fl＃；，\bξ\a＃␝H8␔@:%πｃ.\x19",
		out:  "␠.＄βκ␟β\x0e␛T\x1fl＃；，\bξ\a＃␝H8␔@:%πｃ.\x19",
	}, { // 65
		mask: EncodeCrLf | EncodeLeftSpace | EncodeLeftPeriod,
		in:   "␠.＄βκ␟β\x0e␛T\x1fl＃；，\bξ\a＃␝H8␔@:%πｃ.\x19",
		out:  "‛␠.＄βκ␟β\x0e␛T\x1fl＃；，\bξ\a＃␝H8␔@:%πｃ.\x19",
	}, { // 66
		mask: EncodeCrLf | EncodeLeftSpace | EncodeLeftPeriod,
		in:   "μ.＄βκ␟β\x0e␛T\x1fl＃；，\bξ\a＃␝H8␔@:%πｃ. ",
		out:  "μ.＄βκ␟β\x0e␛T\x1fl＃；，\bξ\a＃␝H8␔@:%πｃ. ",
	}, { // 67
		mask: EncodeCrLf | EncodeLeftSpace | EncodeLeftPeriod,
		in:   "μ.＄βκ␟β\x0e␛T\x1fl＃；，\bξ\a＃␝H8␔@:%πｃ.␠",
		out:  "μ.＄βκ␟β\x0e␛T\x1fl＃；，\bξ\a＃␝H8␔@:%πｃ.␠",
	}, { // 68
		mask: EncodeDel | EncodeLeftSpace | EncodeLeftPeriod,
		in:   " .\x12␂λ\x06］␔＞␓9ςｅＰ｀\x1aλ＄εo\x1d（@\f \x1cψｏ.C",
		out:  "␠.\x12␂λ\x06］␔＞␓9ςｅＰ｀\x1aλ＄εo\x1d（@\f \x1cψｏ.C",
	}, { // 69
		mask: EncodeDel | EncodeLeftSpace | EncodeLeftPeriod,
		in:   "␠.\x12␂λ\x06］␔＞␓9ςｅＰ｀\x1aλ＄εo\x1d（@\f \x1cψｏ.C",
		out:  "‛␠.\x12␂λ\x06］␔＞␓9ςｅＰ｀\x1aλ＄εo\x1d（@\f \x1cψｏ.C",
	}, { // 70
		mask: EncodeDel | EncodeLeftSpace | EncodeLeftPeriod,
		in:   "Ｓ.\x12␂λ\x06］␔＞␓9ςｅＰ｀\x1aλ＄εo\x1d（@\f \x1cψｏ. ",
		out:  "Ｓ.\x12␂λ\x06］␔＞␓9ςｅＰ｀\x1aλ＄εo\x1d（@\f \x1cψｏ. ",
	}, { // 71
		mask: EncodeDel | EncodeLeftSpace | EncodeLeftPeriod,
		in:   "Ｓ.\x12␂λ\x06］␔＞␓9ςｅＰ｀\x1aλ＄εo\x1d（@\f \x1cψｏ.␠",
		out:  "Ｓ.\x12␂λ\x06］␔＞␓9ςｅＰ｀\x1aλ＄εo\x1d（@\f \x1cψｏ.␠",
	}, { // 72
		mask: EncodeCtl | EncodeLeftSpace | EncodeLeftPeriod,
		in:   " .␇v<Ｐ\x14＋␈\n\x01 'NH｜`α␏＃ω\x05｜συκ\x14␝.］",
		out:  "␠.‛␇v<Ｐ␔＋‛␈␊␁ 'NH｜`α‛␏＃ω␅｜συκ␔‛␝.］",
	}, { // 73
		mask: EncodeCtl | EncodeLeftSpace | EncodeLeftPeriod,
		in:   "␠.␇v<Ｐ\x14＋␈\n\x01 'NH｜`α␏＃ω\x05｜συκ\x14␝.］",
		out:  "‛␠.‛␇v<Ｐ␔＋‛␈␊␁ 'NH｜`α‛␏＃ω␅｜συκ␔‛␝.］",
	}, { // 74
		mask: EncodeCtl | EncodeLeftSpace | EncodeLeftPeriod,
		in:   "ζ.␇v<Ｐ\x14＋␈\n\x01 'NH｜`α␏＃ω\x05｜συκ\x14␝. ",
		out:  "ζ.‛␇v<Ｐ␔＋‛␈␊␁ 'NH｜`α‛␏＃ω␅｜συκ␔‛␝. ",
	}, { // 75
		mask: EncodeCtl | EncodeLeftSpace | EncodeLeftPeriod,
		in:   "ζ.␇v<Ｐ\x14＋␈\n\x01 'NH｜`α␏＃ω\x05｜συκ\x14␝.␠",
		out:  "ζ.‛␇v<Ｐ␔＋‛␈␊␁ 'NH｜`α‛␏＃ω␅｜συκ␔‛␝.␠",
	}, { // 76
		mask: EncodeZero | EncodeLeftSpace | EncodeLeftTilde,
		in:   " ~9␄g｝␎ρ\\κｌ\x15ｙ\x03␐␚$θ｜`.b␊δαｖν:~␆",
		out:  "␠~9␄g｝␎ρ\\κｌ\x15ｙ\x03␐␚$θ｜`.b␊δαｖν:~␆",
	}, { // 77
		mask: EncodeZero | EncodeLeftSpace | EncodeLeftTilde,
		in:   "␠~9␄g｝␎ρ\\κｌ\x15ｙ\x03␐␚$θ｜`.b␊δαｖν:~␆",
		out:  "‛␠~9␄g｝␎ρ\\κｌ\x15ｙ\x03␐␚$θ｜`.b␊δαｖν:~␆",
	}, { // 78
		mask: EncodeZero | EncodeLeftSpace | EncodeLeftTilde,
		in:   "q~9␄g｝␎ρ\\κｌ\x15ｙ\x03␐␚$θ｜`.b␊δαｖν:~ ",
		out:  "q~9␄g｝␎ρ\\κｌ\x15ｙ\x03␐␚$θ｜`.b␊δαｖν:~ ",
	}, { // 79
		mask: EncodeZero | EncodeLeftSpace | EncodeLeftTilde,
		in:   "q~9␄g｝␎ρ\\κｌ\x15ｙ\x03␐␚$θ｜`.b␊δαｖν:~␠",
		out:  "q~9␄g｝␎ρ\\κｌ\x15ｙ\x03␐␚$θ｜`.b␊δαｖν:~␠",
	}, { // 80
		mask: EncodeSlash | EncodeLeftSpace | EncodeLeftTilde,
		in:   " ~␓W␟\u007fυ␋r：βF;Ｑξ\x1d%：Ｌτ\x10&δ[＝\x01；R~ρ",
		out:  "␠~␓W␟\u007fυ␋r：βF;Ｑξ\x1d%：Ｌτ\x10&δ[＝\x01；R~ρ",
	}, { // 81
		mask: EncodeSlash | EncodeLeftSpace | EncodeLeftTilde,
		in:   "␠~␓W␟\u007fυ␋r：βF;Ｑξ\x1d%：Ｌτ\x10&δ[＝\x01；R~ρ",
		out:  "‛␠~␓W␟\u007fυ␋r：βF;Ｑξ\x1d%：Ｌτ\x10&δ[＝\x01；R~ρ",
	}, { // 82
		mask: EncodeSlash | EncodeLeftSpace | EncodeLeftTilde,
		in:   "ｈ~␓W␟\u007fυ␋r：βF;Ｑξ\x1d%：Ｌτ\x10&δ[＝\x01；R~ ",
		out:  "ｈ~␓W␟\u007fυ␋r：βF;Ｑξ\x1d%：Ｌτ\x10&δ[＝\x01；R~ ",
	}, { // 83
		mask: EncodeSlash | EncodeLeftSpace | EncodeLeftTilde,
		in:   "ｈ~␓W␟\u007fυ␋r：βF;Ｑξ\x1d%：Ｌτ\x10&δ[＝\x01；R~␠",
		out:  "ｈ~␓W␟\u007fυ␋r：βF;Ｑξ\x1d%：Ｌτ\x10&δ[＝\x01；R~␠",
	}, { // 84
		mask: EncodeSingleQuote | EncodeLeftSpace | EncodeLeftTilde,
		in:   " ~@ｗ␊ρ␈B（νζλ\x19ｙ␋␖/ｙ？;␂N␀α(＞ς\"~#",
		out:  "␠~@ｗ␊ρ␈B（νζλ\x19ｙ␋␖/ｙ？;␂N‛␀α(＞ς\"~#",
	}, { // 85
		mask: EncodeSingleQuote | EncodeLeftSpace | EncodeLeftTilde,
		in:   "␠~@ｗ␊ρ␈B（νζλ\x19ｙ␋␖/ｙ？;␂N␀α(＞ς\"~#",
		out:  "‛␠~@ｗ␊ρ␈B（νζλ\x19ｙ␋␖/ｙ？;␂N‛␀α(＞ς\"~#",
	}, { // 86
		mask: EncodeSingleQuote | EncodeLeftSpace | EncodeLeftTilde,
		in:   "F~@ｗ␊ρ␈B（νζλ\x19ｙ␋␖/ｙ？;␂N␀α(＞ς\"~ ",
		out:  "F~@ｗ␊ρ␈B（νζλ\x19ｙ␋␖/ｙ？;␂N‛␀α(＞ς\"~ ",
	}, { // 87
		mask: EncodeSingleQuote | EncodeLeftSpace | EncodeLeftTilde,
		in:   "F~@ｗ␊ρ␈B（νζλ\x19ｙ␋␖/ｙ？;␂N␀α(＞ς\"~␠",
		out:  "F~@ｗ␊ρ␈B（νζλ\x19ｙ␋␖/ｙ？;␂N‛␀α(＞ς\"~␠",
	}, { // 88
		mask: EncodeBackQuote | EncodeLeftSpace | EncodeLeftTilde,
		in:   " ~1ｅ＊λ2\x13␞γ！δL|＜q\x16.\x1e７␟␑δ\x04␍Ｊ␚/~ｚ",
		out:  "␠~1ｅ＊λ2\x13␞γ！δL|＜q\x16.\x1e７␟␑δ\x04␍Ｊ␚/~ｚ",
	}, { // 89
		mask: EncodeBackQuote | EncodeLeftSpace | EncodeLeftTilde,
		in:   "␠~1ｅ＊λ2\x13␞γ！δL|＜q\x16.\x1e７␟␑δ\x04␍Ｊ␚/~ｚ",
		out:  "‛␠~1ｅ＊λ2\x13␞γ！δL|＜q\x16.\x1e７␟␑δ\x04␍Ｊ␚/~ｚ",
	}, { // 90
		mask: EncodeBackQuote | EncodeLeftSpace | EncodeLeftTilde,
		in:   "ς~1ｅ＊λ2\x13␞γ！δL|＜q\x16.\x1e７␟␑δ\x04␍Ｊ␚/~ ",
		out:  "ς~1ｅ＊λ2\x13␞γ！δL|＜q\x16.\x1e７␟␑δ\x04␍Ｊ␚/~ ",
	}, { // 91
		mask: EncodeBackQuote | EncodeLeftSpace | EncodeLeftTilde,
		in:   "ς~1ｅ＊λ2\x13␞γ！δL|＜q\x16.\x1e７␟␑δ\x04␍Ｊ␚/~␠",
		out:  "ς~1ｅ＊λ2\x13␞γ！δL|＜q\x16.\x1e７␟␑δ\x04␍Ｊ␚/~␠",
	}, { // 92
		mask: EncodeLtGt | EncodeLeftSpace | EncodeLeftTilde,
		in:   " ~７π＊ω\rLλ\x1e␗＝a␆\x0eβυｋRα␜␄ＣD\uff00$＃\x10~K",
		out:  "␠~７π＊ω\rLλ\x1e␗＝a␆\x0eβυｋRα␜␄ＣD\uff00$＃\x10~K",
	}, { // 93
		mask: EncodeLtGt | EncodeLeftSpace | EncodeLeftTilde,
		in:   "␠~７π＊ω\rLλ\x1e␗＝a␆\x0eβυｋRα␜␄ＣD\uff00$＃\x10~K",
		out:  "‛␠~７π＊ω\rLλ\x1e␗＝a␆\x0eβυｋRα␜␄ＣD\uff00$＃\x10~K",
	}, { // 94
		mask: EncodeLtGt | EncodeLeftSpace | EncodeLeftTilde,
		in:   "\x1e~７π＊ω\rLλ\x1e␗＝a␆\x0eβυｋRα␜␄ＣD\uff00$＃\x10~ ",
		out:  "\x1e~７π＊ω\rLλ\x1e␗＝a␆\x0eβυｋRα␜␄ＣD\uff00$＃\x10~ ",
	}, { // 95
		mask: EncodeLtGt | EncodeLeftSpace | EncodeLeftTilde,
		in:   "\x1e~７π＊ω\rLλ\x1e␗＝a␆\x0eβυｋRα␜␄ＣD\uff00$＃\x10~␠",
		out:  "\x1e~７π＊ω\rLλ\x1e␗＝a␆\x0eβυｋRα␜␄ＣD\uff00$＃\x10~␠",
	}, { // 96
		mask: EncodeSquareBracket | EncodeLeftSpace | EncodeLeftTilde,
		in:   " ~?βＳＦμ－\x18＿ςτ}\r␋／3\x17O＆\u007f；＞G␂I＜ρ~：",
		out:  "␠~?βＳＦμ－\x18＿ςτ}\r␋／3\x17O＆\u007f；＞G␂I＜ρ~：",
	}, { // 97
		mask: EncodeSquareBracket | EncodeLeftSpace | EncodeLeftTilde,
		in:   "␠~?βＳＦμ－\x18＿ςτ}\r␋／3\x17O＆\u007f；＞G␂I＜ρ~：",
		out:  "‛␠~?βＳＦμ－\x18＿ςτ}\r␋／3\x17O＆\u007f；＞G␂I＜ρ~：",
	}, { // 98
		mask: EncodeSquareBracket | EncodeLeftSpace | EncodeLeftTilde,
		in:   "$~?βＳＦμ－\x18＿ςτ}\r␋／3\x17O＆\u007f；＞G␂I＜ρ~ ",
		out:  "$~?βＳＦμ－\x18＿ςτ}\r␋／3\x17O＆\u007f；＞G␂I＜ρ~ ",
	}, { // 99
		mask: EncodeSquareBracket | EncodeLeftSpace | EncodeLeftTilde,
		in:   "$~?βＳＦμ－\x18＿ςτ}\r␋／3\x17O＆\u007f；＞G␂I＜ρ~␠",
		out:  "$~?βＳＦμ－\x18＿ςτ}\r␋／3\x17O＆\u007f；＞G␂I＜ρ~␠",
	}, { // 100
		mask: EncodeSemicolon | EncodeLeftSpace | EncodeLeftTilde,
		in:   " ~＜\x02＋ａ／０\x0e␐u<'ｅYqρ#υπ␚＞＼κ\x17_ｖ6~z",
		out:  "␠~＜\x02＋ａ／０\x0e␐u<'ｅYqρ#υπ␚＞＼κ\x17_ｖ6~z",
	}, { // 101
		mask: EncodeSemicolon | EncodeLeftSpace | EncodeLeftTilde,
		in:   "␠~＜\x02＋ａ／０\x0e␐u<'ｅYqρ#υπ␚＞＼κ\x17_ｖ6~z",
		out:  "‛␠~＜\x02＋ａ／０\x0e␐u<'ｅYqρ#υπ␚＞＼κ\x17_ｖ6~z",
	}, { // 102
		mask: EncodeSemicolon | EncodeLeftSpace | EncodeLeftTilde,
		in:   "ς~＜\x02＋ａ／０\x0e␐u<'ｅYqρ#υπ␚＞＼κ\x17_ｖ6~ ",
		out:  "ς~＜\x02＋ａ／０\x0e␐u<'ｅYqρ#υπ␚＞＼κ\x17_ｖ6~ ",
	}, { // 103
		mask: EncodeSemicolon | EncodeLeftSpace | EncodeLeftTilde,
		in:   "ς~＜\x02＋ａ／０\x0e␐u<'ｅYqρ#υπ␚＞＼κ\x17_ｖ6~␠",
		out:  "ς~＜\x02＋ａ／０\x0e␐u<'ｅYqρ#υπ␚＞＼κ\x17_ｖ6~␠",
	}, { // 104
		mask: EncodeDollar | EncodeLeftSpace | EncodeLeftTilde,
		in:   " ~ｒ␘d\x1cD＊␅＇-b\x17μ\x1e*ζ９χｂξ␏KＡ？／Ｘ$~ς",
		out:  "␠~ｒ␘d\x1cD＊␅＇-b\x17μ\x1e*ζ９χｂξ␏KＡ？／Ｘ＄~ς",
	}, { // 105
		mask: EncodeDollar | EncodeLeftSpace | EncodeLeftTilde,
		in:   "␠~ｒ␘d\x1cD＊␅＇-b\x17μ\x1e*ζ９χｂξ␏KＡ？／Ｘ$~ς",
		out:  "‛␠~ｒ␘d\x1cD＊␅＇-b\x17μ\x1e*ζ９χｂξ␏KＡ？／Ｘ＄~ς",
	}, { // 106
		mask: EncodeDollar | EncodeLeftSpace | EncodeLeftTilde,
		in:   "\x17~ｒ␘d\x1cD＊␅＇-b\x17μ\x1e*ζ９χｂξ␏KＡ？／Ｘ$~ ",
		out:  "\x17~ｒ␘d\x1cD＊␅＇-b\x17μ\x1e*ζ９χｂξ␏KＡ？／Ｘ＄~ ",
	}, { // 107
		mask: EncodeDollar | EncodeLeftSpace | EncodeLeftTilde,
		in:   "\x17~ｒ␘d\x1cD＊␅＇-b\x17μ\x1e*ζ９χｂξ␏KＡ？／Ｘ$~␠",
		out:  "\x17~ｒ␘d\x1cD＊␅＇-b\x17μ\x1e*ζ９χｂξ␏KＡ？／Ｘ＄~␠",
	}, { // 108
		mask: EncodeDoubleQuote | EncodeLeftSpace | EncodeLeftTilde,
		in:   " ~p？αρ\x13␉␌␈＞ν\x1b＝\x0e\x18－␙P\x19jLτi?Ｋ#１~μ",
		out:  "␠~p？αρ\x13␉␌␈＞ν\x1b＝\x0e\x18－␙P\x19jLτi?Ｋ#１~μ",
	}, { // 109
		mask: EncodeDoubleQuote | EncodeLeftSpace | EncodeLeftTilde,
		in:   "␠~p？αρ\x13␉␌␈＞ν\x1b＝\x0e\x18－␙P\x19jLτi?Ｋ#１~μ",
		out:  "‛␠~p？αρ\x13␉␌␈＞ν\x1b＝\x0e\x18－␙P\x19jLτi?Ｋ#１~μ",
	}, { // 110
		mask: EncodeDoubleQuote | EncodeLeftSpace | EncodeLeftTilde,
		in:   "＃~p？αρ\x13␉␌␈＞ν\x1b＝\x0e\x18－␙P\x19jLτi?Ｋ#１~ ",
		out:  "＃~p？αρ\x13␉␌␈＞ν\x1b＝\x0e\x18－␙P\x19jLτi?Ｋ#１~ ",
	}, { // 111
		mask: EncodeDoubleQuote | EncodeLeftSpace | EncodeLeftTilde,
		in:   "＃~p？αρ\x13␉␌␈＞ν\x1b＝\x0e\x18－␙P\x19jLτi?Ｋ#１~␠",
		out:  "＃~p？αρ\x13␉␌␈＞ν\x1b＝\x0e\x18－␙P\x19jLτi?Ｋ#１~␠",
	}, { // 112
		mask: EncodeColon | EncodeLeftSpace | EncodeLeftTilde,
		in:   " ~！\x10\x1cｈ；␌␛\x03G\x1e＼[η\x18.λd?ω６␂%␡␐θβ~β",
		out:  "␠~！\x10\x1cｈ；␌␛\x03G\x1e＼[η\x18.λd?ω６␂%␡␐θβ~β",
	}, { // 113
		mask: EncodeColon | EncodeLeftSpace | EncodeLeftTilde,
		in:   "␠~！\x10\x1cｈ；␌␛\x03G\x1e＼[η\x18.λd?ω６␂%␡␐θβ~β",
		out:  "‛␠~！\x10\x1cｈ；␌␛\x03G\x1e＼[η\x18.λd?ω６␂%␡␐θβ~β",
	}, { // 114
		mask: EncodeColon | EncodeLeftSpace | EncodeLeftTilde,
		in:   "＿~！\x10\x1cｈ；␌␛\x03G\x1e＼[η\x18.λd?ω６␂%␡␐θβ~ ",
		out:  "＿~！\x10\x1cｈ；␌␛\x03G\x1e＼[η\x18.λd?ω６␂%␡␐θβ~ ",
	}, { // 115
		mask: EncodeColon | EncodeLeftSpace | EncodeLeftTilde,
		in:   "＿~！\x10\x1cｈ；␌␛\x03G\x1e＼[η\x18.λd?ω６␂%␡␐θβ~␠",
		out:  "＿~！\x10\x1cｈ；␌␛\x03G\x1e＼[η\x18.λd?ω６␂%␡␐θβ~␠",
	}, { // 116
		mask: EncodeQuestion | EncodeLeftSpace | EncodeLeftTilde,
		in:   " ~μ/v/ｇ\x1e＜？1␄］)\x15␖Q：Ｄαsιπρ\uff00Ｋ\bχ~\x04",
		out:  "␠~μ/v/ｇ\x1e＜‛？1␄］)\x15␖Q：Ｄαsιπρ\uff00Ｋ\bχ~\x04",
	}, { // 117
		mask: EncodeQuestion | EncodeLeftSpace | EncodeLeftTilde,
		in:   "␠~μ/v/ｇ\x1e＜？1␄］)\x15␖Q：Ｄαsιπρ\uff00Ｋ\bχ~\x04",
		out:  "‛␠~μ/v/ｇ\x1e＜‛？1␄］)\x15␖Q：Ｄαsιπρ\uff00Ｋ\bχ~\x04",
	}, { // 118
		mask: EncodeQuestion | EncodeLeftSpace | EncodeLeftTilde,
		in:   "＂~μ/v/ｇ\x1e＜？1␄］)\x15␖Q：Ｄαsιπρ\uff00Ｋ\bχ~ ",
		out:  "＂~μ/v/ｇ\x1e＜‛？1␄］)\x15␖Q：Ｄαsιπρ\uff00Ｋ\bχ~ ",
	}, { // 119
		mask: EncodeQuestion | EncodeLeftSpace | EncodeLeftTilde,
		in:   "＂~μ/v/ｇ\x1e＜？1␄］)\x15␖Q：Ｄαsιπρ\uff00Ｋ\bχ~␠",
		out:  "＂~μ/v/ｇ\x1e＜‛？1␄］)\x15␖Q：Ｄαsιπρ\uff00Ｋ\bχ~␠",
	}, { // 120
		mask: EncodeAsterisk | EncodeLeftSpace | EncodeLeftTilde,
		in:   " ~␌P␓\x04]ＡFκq␁>%η\t\x12ε`ρＳ＜｀n：＂χ９~ζ",
		out:  "␠~␌P␓\x04]ＡFκq␁>%η\t\x12ε`ρＳ＜｀n：＂χ９~ζ",
	}, { // 121
		mask: EncodeAsterisk | EncodeLeftSpace | EncodeLeftTilde,
		in:   "␠~␌P␓\x04]ＡFκq␁>%η\t\x12ε`ρＳ＜｀n：＂χ９~ζ",
		out:  "‛␠~␌P␓\x04]ＡFκq␁>%η\t\x12ε`ρＳ＜｀n：＂χ９~ζ",
	}, { // 122
		mask: EncodeAsterisk | EncodeLeftSpace | EncodeLeftTilde,
		in:   "Ａ~␌P␓\x04]ＡFκq␁>%η\t\x12ε`ρＳ＜｀n：＂χ９~ ",
		out:  "Ａ~␌P␓\x04]ＡFκq␁>%η\t\x12ε`ρＳ＜｀n：＂χ９~ ",
	}, { // 123
		mask: EncodeAsterisk | EncodeLeftSpace | EncodeLeftTilde,
		in:   "Ａ~␌P␓\x04]ＡFκq␁>%η\t\x12ε`ρＳ＜｀n：＂χ９~␠",
		out:  "Ａ~␌P␓\x04]ＡFκq␁>%η\t\x12ε`ρＳ＜｀n：＂χ９~␠",
	}, { // 124
		mask: EncodePipe | EncodeLeftSpace | EncodeLeftTilde,
		in:   " ~ωｂｆ３υｆ␐␊EχsW\x15␡`r␚＃μ']\x16Sφ␈\x1f~ｆ",
		out:  "␠~ωｂｆ３υｆ␐␊EχsW\x15␡`r␚＃μ']\x16Sφ␈\x1f~ｆ",
	}, { // 125
		mask: EncodePipe | EncodeLeftSpace | EncodeLeftTilde,
		in:   "␠~ωｂｆ３υｆ␐␊EχsW\x15␡`r␚＃μ']\x16Sφ␈\x1f~ｆ",
		out:  "‛␠~ωｂｆ３υｆ␐␊EχsW\x15␡`r␚＃μ']\x16Sφ␈\x1f~ｆ",
	}, { // 126
		mask: EncodePipe | EncodeLeftSpace | EncodeLeftTilde,
		in:   "ξ~ωｂｆ３υｆ␐␊EχsW\x15␡`r␚＃μ']\x16Sφ␈\x1f~ ",
		out:  "ξ~ωｂｆ３υｆ␐␊EχsW\x15␡`r␚＃μ']\x16Sφ␈\x1f~ ",
	}, { // 127
		mask: EncodePipe | EncodeLeftSpace | EncodeLeftTilde,
		in:   "ξ~ωｂｆ３υｆ␐␊EχsW\x15␡`r␚＃μ']\x16Sφ␈\x1f~␠",
		out:  "ξ~ωｂｆ３υｆ␐␊EχsW\x15␡`r␚＃μ']\x16Sφ␈\x1f~␠",
	}, { // 128
		mask: EncodeHash | EncodeLeftSpace | EncodeLeftTilde,
		in:   " ~$]δ\x10ｆｚＱm＃␡βＦ／σ］ａ␓␞δ?G:λ\\δ/~\x03",
		out:  "␠~$]δ\x10ｆｚＱm‛＃␡βＦ／σ］ａ␓␞δ?G:λ\\δ/~\x03",
	}, { // 129
		mask: EncodeHash | EncodeLeftSpace | EncodeLeftTilde,
		in:   "␠~$]δ\x10ｆｚＱm＃␡βＦ／σ］ａ␓␞δ?G:λ\\δ/~\x03",
		out:  "‛␠~$]δ\x10ｆｚＱm‛＃␡βＦ／σ］ａ␓␞δ?G:λ\\δ/~\x03",
	}, { // 130
		mask: EncodeHash | EncodeLeftSpace | EncodeLeftTilde,
		in:   "G~$]δ\x10ｆｚＱm＃␡βＦ／σ］ａ␓␞δ?G:λ\\δ/~ ",
		out:  "G~$]δ\x10ｆｚＱm‛＃␡βＦ／σ］ａ␓␞δ?G:λ\\δ/~ ",
	}, { // 131
		mask: EncodeHash | EncodeLeftSpace | EncodeLeftTilde,
		in:   "G~$]δ\x10ｆｚＱm＃␡βＦ／σ］ａ␓␞δ?G:λ\\δ/~␠",
		out:  "G~$]δ\x10ｆｚＱm‛＃␡βＦ／σ］ａ␓␞δ?G:λ\\δ/~␠",
	}, { // 132
		mask: EncodePercent | EncodeLeftSpace | EncodeLeftTilde,
		in:   " ~\x06[\x17ｘ，ＲQςεP\u007fL␘\x140θβＤ4␙\uff000κＫρ␓~＊",
		out:  "␠~\x06[\x17ｘ，ＲQςεP\u007fL␘\x140θβＤ4␙\uff000κＫρ␓~＊",
	}, { // 133
		mask: EncodePercent | EncodeLeftSpace | EncodeLeftTilde,
		in:   "␠~\x06[\x17ｘ，ＲQςεP\u007fL␘\x140θβＤ4␙\uff000κＫρ␓~＊",
		out:  "‛␠~\x06[\x17ｘ，ＲQςεP\u007fL␘\x140θβＤ4␙\uff000κＫρ␓~＊",
	}, { // 134
		mask: EncodePercent | EncodeLeftSpace | EncodeLeftTilde,
		in:   "␘~\x06[\x17ｘ，ＲQςεP\u007fL␘\x140θβＤ4␙\uff000κＫρ␓~ ",
		out:  "␘~\x06[\x17ｘ，ＲQςεP\u007fL␘\x140θβＤ4␙\uff000κＫρ␓~ ",
	}, { // 135
		mask: EncodePercent | EncodeLeftSpace | EncodeLeftTilde,
		in:   "␘~\x06[\x17ｘ，ＲQςεP\u007fL␘\x140θβＤ4␙\uff000κＫρ␓~␠",
		out:  "␘~\x06[\x17ｘ，ＲQςεP\u007fL␘\x140θβＤ4␙\uff000κＫρ␓~␠",
	}, { // 136
		mask: EncodeBackSlash | EncodeLeftSpace | EncodeLeftTilde,
		in:   " ~＂\x1d␊Zw％）\x0f␜５Q＇ο␒π｜␖Ｘι?απW\x0eο\r~Ｈ",
		out:  "␠~＂\x1d␊Zw％）\x0f␜５Q＇ο␒π｜␖Ｘι?απW\x0eο\r~Ｈ",
	}, { // 137
		mask: EncodeBackSlash | EncodeLeftSpace | EncodeLeftTilde,
		in:   "␠~＂\x1d␊Zw％）\x0f␜５Q＇ο␒π｜␖Ｘι?απW\x0eο\r~Ｈ",
		out:  "‛␠~＂\x1d␊Zw％）\x0f␜５Q＇ο␒π｜␖Ｘι?απW\x0eο\r~Ｈ",
	}, { // 138
		mask: EncodeBackSlash | EncodeLeftSpace | EncodeLeftTilde,
		in:   "\r~＂\x1d␊Zw％）\x0f␜５Q＇ο␒π｜␖Ｘι?απW\x0eο\r~ ",
		out:  "\r~＂\x1d␊Zw％）\x0f␜５Q＇ο␒π｜␖Ｘι?απW\x0eο\r~ ",
	}, { // 139
		mask: EncodeBackSlash | EncodeLeftSpace | EncodeLeftTilde,
		in:   "\r~＂\x1d␊Zw％）\x0f␜５Q＇ο␒π｜␖Ｘι?απW\x0eο\r~␠",
		out:  "\r~＂\x1d␊Zw％）\x0f␜５Q＇ο␒π｜␖Ｘι?απW\x0eο\r~␠",
	}, { // 140
		mask: EncodeCrLf | EncodeLeftSpace | EncodeLeftTilde,
		in:   " ~～γ；δ\x0e\x18X＄:］I＞E～␄ε\x13λ␏\x1dκ\uff00ξmA␝~５",
		out:  "␠~～γ；δ\x0e\x18X＄:］I＞E～␄ε\x13λ␏\x1dκ\uff00ξmA␝~５",
	}, { // 141
		mask: EncodeCrLf | EncodeLeftSpace | EncodeLeftTilde,
		in:   "␠~～γ；δ\x0e\x18X＄:］I＞E～␄ε\x13λ␏\x1dκ\uff00ξmA␝~５",
		out:  "‛␠~～γ；δ\x0e\x18X＄:］I＞E～␄ε\x13λ␏\x1dκ\uff00ξmA␝~５",
	}, { // 142
		mask: EncodeCrLf | EncodeLeftSpace | EncodeLeftTilde,
		in:   "／~～γ；δ\x0e\x18X＄:］I＞E～␄ε\x13λ␏\x1dκ\uff00ξmA␝~ ",
		out:  "／~～γ；δ\x0e\x18X＄:］I＞E～␄ε\x13λ␏\x1dκ\uff00ξmA␝~ ",
	}, { // 143
		mask: EncodeCrLf | EncodeLeftSpace | EncodeLeftTilde,
		in:   "／~～γ；δ\x0e\x18X＄:］I＞E～␄ε\x13λ␏\x1dκ\uff00ξmA␝~␠",
		out:  "／~～γ；δ\x0e\x18X＄:］I＞E～␄ε\x13λ␏\x1dκ\uff00ξmA␝~␠",
	}, { // 144
		mask: EncodeDel | EncodeLeftSpace | EncodeLeftTilde,
		in:   " ~\rζ\x10ｕι␎m／␔␅m／gπ\x03\x1f\x02９／ψυσd＊Ｃ␚~(",
		out:  "␠~\rζ\x10ｕι␎m／␔␅m／gπ\x03\x1f\x02９／ψυσd＊Ｃ␚~(",
	}, { // 145
		mask: EncodeDel | EncodeLeftSpace | EncodeLeftTilde,
		in:   "␠~\rζ\x10ｕι␎m／␔␅m／gπ\x03\x1f\x02９／ψυσd＊Ｃ␚~(",
		out:  "‛␠~\rζ\x10ｕι␎m／␔␅m／gπ\x03\x1f\x02９／ψυσd＊Ｃ␚~(",
	}, { // 146
		mask: EncodeDel | EncodeLeftSpace | EncodeLeftTilde,
		in:   "ｒ~\rζ\x10ｕι␎m／␔␅m／gπ\x03\x1f\x02９／ψυσd＊Ｃ␚~ ",
		out:  "ｒ~\rζ\x10ｕι␎m／␔␅m／gπ\x03\x1f\x02９／ψυσd＊Ｃ␚~ ",
	}, { // 147
		mask: EncodeDel | EncodeLeftSpace | EncodeLeftTilde,
		in:   "ｒ~\rζ\x10ｕι␎m／␔␅m／gπ\x03\x1f\x02９／ψυσd＊Ｃ␚~␠",
		out:  "ｒ~\rζ\x10ｕι␎m／␔␅m／gπ\x03\x1f\x02９／ψυσd＊Ｃ␚~␠",
	}, { // 148
		mask: EncodeCtl | EncodeLeftSpace | EncodeLeftTilde,
		in:   " ~␒＝\x1b；；＼β\x19Jｋ\x12/iＺv\a}tθｄ％～\x1eξ｀σ~ι",
		out:  "␠~‛␒＝␛；；＼β␙Jｋ␒/iＺv␇}tθｄ％～␞ξ｀σ~ι",
	}, { // 149
		mask: EncodeCtl | EncodeLeftSpace | EncodeLeftTilde,
		in:   "␠~␒＝\x1b；；＼β\x19Jｋ\x12/iＺv\a}tθｄ％～\x1eξ｀σ~ι",
		out:  "‛␠~‛␒＝␛；；＼β␙Jｋ␒/iＺv␇}tθｄ％～␞ξ｀σ~ι",
	}, { // 150
		mask: EncodeCtl | EncodeLeftSpace | EncodeLeftTilde,
		in:   "c~␒＝\x1b；；＼β\x19Jｋ\x12/iＺv\a}tθｄ％～\x1eξ｀σ~ ",
		out:  "c~‛␒＝␛；；＼β␙Jｋ␒/iＺv␇}tθｄ％～␞ξ｀σ~ ",
	}, { // 151
		mask: EncodeCtl | EncodeLeftSpace | EncodeLeftTilde,
		in:   "c~␒＝\x1b；；＼β\x19Jｋ\x12/iＺv\a}tθｄ％～\x1eξ｀σ~␠",
		out:  "c~‛␒＝␛；；＼β␙Jｋ␒/iＺv␇}tθｄ％～␞ξ｀σ~␠",
	}, { // 152
		mask: EncodeZero | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   " \t］␊φ>\x11␀δ\"β７w｀␍３δ\x15φＥ＇␕lν＄W␅>\tJ",
		out:  "␠\t］␊φ>\x11‛␀δ\"β７w｀␍３δ\x15φＥ＇␕lν＄W␅>\tJ",
	}, { // 153
		mask: EncodeZero | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "␠\t］␊φ>\x11␀δ\"β７w｀␍３δ\x15φＥ＇␕lν＄W␅>\tJ",
		out:  "‛␠\t］␊φ>\x11‛␀δ\"β７w｀␍３δ\x15φＥ＇␕lν＄W␅>\tJ",
	}, { // 154
		mask: EncodeZero | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   " \n］␊φ>\x11␀δ\"β７w｀␍３δ\x15φＥ＇␕lν＄W␅>\nJ",
		out:  "␠\n］␊φ>\x11‛␀δ\"β７w｀␍３δ\x15φＥ＇␕lν＄W␅>\nJ",
	}, { // 155
		mask: EncodeZero | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "␠\n］␊φ>\x11␀δ\"β７w｀␍３δ\x15φＥ＇␕lν＄W␅>\nJ",
		out:  "‛␠\n］␊φ>\x11‛␀δ\"β７w｀␍３δ\x15φＥ＇␕lν＄W␅>\nJ",
	}, { // 156
		mask: EncodeZero | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   " \v］␊φ>\x11␀δ\"β７w｀␍３δ\x15φＥ＇␕lν＄W␅>\vJ",
		out:  "␠\v］␊φ>\x11‛␀δ\"β７w｀␍３δ\x15φＥ＇␕lν＄W␅>\vJ",
	}, { // 157
		mask: EncodeZero | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "␠\v］␊φ>\x11␀δ\"β７w｀␍３δ\x15φＥ＇␕lν＄W␅>\vJ",
		out:  "‛␠\v］␊φ>\x11‛␀δ\"β７w｀␍３δ\x15φＥ＇␕lν＄W␅>\vJ",
	}, { // 158
		mask: EncodeZero | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   " \r］␊φ>\x11␀δ\"β７w｀␍３δ\x15φＥ＇␕lν＄W␅>\rJ",
		out:  "␠\r］␊φ>\x11‛␀δ\"β７w｀␍３δ\x15φＥ＇␕lν＄W␅>\rJ",
	}, { // 159
		mask: EncodeZero | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "␠\r］␊φ>\x11␀δ\"β７w｀␍３δ\x15φＥ＇␕lν＄W␅>\rJ",
		out:  "‛␠\r］␊φ>\x11‛␀δ\"β７w｀␍３δ\x15φＥ＇␕lν＄W␅>\rJ",
	}, { // 160
		mask: EncodeZero | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "o\t］␊φ>\x11␀δ\"β７w｀␍３δ\x15φＥ＇␕lν＄W␅>\t ",
		out:  "o\t］␊φ>\x11‛␀δ\"β７w｀␍３δ\x15φＥ＇␕lν＄W␅>\t ",
	}, { // 161
		mask: EncodeZero | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "o\t］␊φ>\x11␀δ\"β７w｀␍３δ\x15φＥ＇␕lν＄W␅>\t␠",
		out:  "o\t］␊φ>\x11‛␀δ\"β７w｀␍３δ\x15φＥ＇␕lν＄W␅>\t␠",
	}, { // 162
		mask: EncodeZero | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "o\n］␊φ>\x11␀δ\"β７w｀␍３δ\x15φＥ＇␕lν＄W␅>\n ",
		out:  "o\n］␊φ>\x11‛␀δ\"β７w｀␍３δ\x15φＥ＇␕lν＄W␅>\n ",
	}, { // 163
		mask: EncodeZero | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "o\n］␊φ>\x11␀δ\"β７w｀␍３δ\x15φＥ＇␕lν＄W␅>\n␠",
		out:  "o\n］␊φ>\x11‛␀δ\"β７w｀␍３δ\x15φＥ＇␕lν＄W␅>\n␠",
	}, { // 164
		mask: EncodeZero | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "o\v］␊φ>\x11␀δ\"β７w｀␍３δ\x15φＥ＇␕lν＄W␅>\v ",
		out:  "o\v］␊φ>\x11‛␀δ\"β７w｀␍３δ\x15φＥ＇␕lν＄W␅>\v ",
	}, { // 165
		mask: EncodeZero | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "o\v］␊φ>\x11␀δ\"β７w｀␍３δ\x15φＥ＇␕lν＄W␅>\v␠",
		out:  "o\v］␊φ>\x11‛␀δ\"β７w｀␍３δ\x15φＥ＇␕lν＄W␅>\v␠",
	}, { // 166
		mask: EncodeZero | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "o\r］␊φ>\x11␀δ\"β７w｀␍３δ\x15φＥ＇␕lν＄W␅>\r ",
		out:  "o\r］␊φ>\x11‛␀δ\"β７w｀␍３δ\x15φＥ＇␕lν＄W␅>\r ",
	}, { // 167
		mask: EncodeZero | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "o\r］␊φ>\x11␀δ\"β７w｀␍３δ\x15φＥ＇␕lν＄W␅>\r␠",
		out:  "o\r］␊φ>\x11‛␀δ\"β７w｀␍３δ\x15φＥ＇␕lν＄W␅>\r␠",
	}, { // 168
		mask: EncodeSlash | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   " \t｜γςx\x15ｒ␗ξγ｜ｙ＜*␝？］~βB\x01uＨ\x03\r+7\t\x11",
		out:  "␠\t｜γςx\x15ｒ␗ξγ｜ｙ＜*␝？］~βB\x01uＨ\x03\r+7\t\x11",
	}, { // 169
		mask: EncodeSlash | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "␠\t｜γςx\x15ｒ␗ξγ｜ｙ＜*␝？］~βB\x01uＨ\x03\r+7\t\x11",
		out:  "‛␠\t｜γςx\x15ｒ␗ξγ｜ｙ＜*␝？］~βB\x01uＨ\x03\r+7\t\x11",
	}, { // 170
		mask: EncodeSlash | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   " \n｜γςx\x15ｒ␗ξγ｜ｙ＜*␝？］~βB\x01uＨ\x03\r+7\n\x11",
		out:  "␠\n｜γςx\x15ｒ␗ξγ｜ｙ＜*␝？］~βB\x01uＨ\x03\r+7\n\x11",
	}, { // 171
		mask: EncodeSlash | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "␠\n｜γςx\x15ｒ␗ξγ｜ｙ＜*␝？］~βB\x01uＨ\x03\r+7\n\x11",
		out:  "‛␠\n｜γςx\x15ｒ␗ξγ｜ｙ＜*␝？］~βB\x01uＨ\x03\r+7\n\x11",
	}, { // 172
		mask: EncodeSlash | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   " \v｜γςx\x15ｒ␗ξγ｜ｙ＜*␝？］~βB\x01uＨ\x03\r+7\v\x11",
		out:  "␠\v｜γςx\x15ｒ␗ξγ｜ｙ＜*␝？］~βB\x01uＨ\x03\r+7\v\x11",
	}, { // 173
		mask: EncodeSlash | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "␠\v｜γςx\x15ｒ␗ξγ｜ｙ＜*␝？］~βB\x01uＨ\x03\r+7\v\x11",
		out:  "‛␠\v｜γςx\x15ｒ␗ξγ｜ｙ＜*␝？］~βB\x01uＨ\x03\r+7\v\x11",
	}, { // 174
		mask: EncodeSlash | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   " \r｜γςx\x15ｒ␗ξγ｜ｙ＜*␝？］~βB\x01uＨ\x03\r+7\r\x11",
		out:  "␠\r｜γςx\x15ｒ␗ξγ｜ｙ＜*␝？］~βB\x01uＨ\x03\r+7\r\x11",
	}, { // 175
		mask: EncodeSlash | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "␠\r｜γςx\x15ｒ␗ξγ｜ｙ＜*␝？］~βB\x01uＨ\x03\r+7\r\x11",
		out:  "‛␠\r｜γςx\x15ｒ␗ξγ｜ｙ＜*␝？］~βB\x01uＨ\x03\r+7\r\x11",
	}, { // 176
		mask: EncodeSlash | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "Ｑ\t｜γςx\x15ｒ␗ξγ｜ｙ＜*␝？］~βB\x01uＨ\x03\r+7\t ",
		out:  "Ｑ\t｜γςx\x15ｒ␗ξγ｜ｙ＜*␝？］~βB\x01uＨ\x03\r+7\t ",
	}, { // 177
		mask: EncodeSlash | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "Ｑ\t｜γςx\x15ｒ␗ξγ｜ｙ＜*␝？］~βB\x01uＨ\x03\r+7\t␠",
		out:  "Ｑ\t｜γςx\x15ｒ␗ξγ｜ｙ＜*␝？］~βB\x01uＨ\x03\r+7\t␠",
	}, { // 178
		mask: EncodeSlash | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "Ｑ\n｜γςx\x15ｒ␗ξγ｜ｙ＜*␝？］~βB\x01uＨ\x03\r+7\n ",
		out:  "Ｑ\n｜γςx\x15ｒ␗ξγ｜ｙ＜*␝？］~βB\x01uＨ\x03\r+7\n ",
	}, { // 179
		mask: EncodeSlash | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "Ｑ\n｜γςx\x15ｒ␗ξγ｜ｙ＜*␝？］~βB\x01uＨ\x03\r+7\n␠",
		out:  "Ｑ\n｜γςx\x15ｒ␗ξγ｜ｙ＜*␝？］~βB\x01uＨ\x03\r+7\n␠",
	}, { // 180
		mask: EncodeSlash | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "Ｑ\v｜γςx\x15ｒ␗ξγ｜ｙ＜*␝？］~βB\x01uＨ\x03\r+7\v ",
		out:  "Ｑ\v｜γςx\x15ｒ␗ξγ｜ｙ＜*␝？］~βB\x01uＨ\x03\r+7\v ",
	}, { // 181
		mask: EncodeSlash | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "Ｑ\v｜γςx\x15ｒ␗ξγ｜ｙ＜*␝？］~βB\x01uＨ\x03\r+7\v␠",
		out:  "Ｑ\v｜γςx\x15ｒ␗ξγ｜ｙ＜*␝？］~βB\x01uＨ\x03\r+7\v␠",
	}, { // 182
		mask: EncodeSlash | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "Ｑ\r｜γςx\x15ｒ␗ξγ｜ｙ＜*␝？］~βB\x01uＨ\x03\r+7\r ",
		out:  "Ｑ\r｜γςx\x15ｒ␗ξγ｜ｙ＜*␝？］~βB\x01uＨ\x03\r+7\r ",
	}, { // 183
		mask: EncodeSlash | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "Ｑ\r｜γςx\x15ｒ␗ξγ｜ｙ＜*␝？］~βB\x01uＨ\x03\r+7\r␠",
		out:  "Ｑ\r｜γςx\x15ｒ␗ξγ｜ｙ＜*␝？］~βB\x01uＨ\x03\r+7\r␠",
	}, { // 184
		mask: EncodeSingleQuote | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   " \t}β#␄？␈Ｔｔ\x1cζ`j\x1akmαＵ１␍θN，␑\bＡP\t␉",
		out:  "␠\t}β#␄？␈Ｔｔ\x1cζ`j\x1akmαＵ１␍θN，␑\bＡP\t␉",
	}, { // 185
		mask: EncodeSingleQuote | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "␠\t}β#␄？␈Ｔｔ\x1cζ`j\x1akmαＵ１␍θN，␑\bＡP\t␉",
		out:  "‛␠\t}β#␄？␈Ｔｔ\x1cζ`j\x1akmαＵ１␍θN，␑\bＡP\t␉",
	}, { // 186
		mask: EncodeSingleQuote | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   " \n}β#␄？␈Ｔｔ\x1cζ`j\x1akmαＵ１␍θN，␑\bＡP\n␉",
		out:  "␠\n}β#␄？␈Ｔｔ\x1cζ`j\x1akmαＵ１␍θN，␑\bＡP\n␉",
	}, { // 187
		mask: EncodeSingleQuote | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "␠\n}β#␄？␈Ｔｔ\x1cζ`j\x1akmαＵ１␍θN，␑\bＡP\n␉",
		out:  "‛␠\n}β#␄？␈Ｔｔ\x1cζ`j\x1akmαＵ１␍θN，␑\bＡP\n␉",
	}, { // 188
		mask: EncodeSingleQuote | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   " \v}β#␄？␈Ｔｔ\x1cζ`j\x1akmαＵ１␍θN，␑\bＡP\v␉",
		out:  "␠\v}β#␄？␈Ｔｔ\x1cζ`j\x1akmαＵ１␍θN，␑\bＡP\v␉",
	}, { // 189
		mask: EncodeSingleQuote | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "␠\v}β#␄？␈Ｔｔ\x1cζ`j\x1akmαＵ１␍θN，␑\bＡP\v␉",
		out:  "‛␠\v}β#␄？␈Ｔｔ\x1cζ`j\x1akmαＵ１␍θN，␑\bＡP\v␉",
	}, { // 190
		mask: EncodeSingleQuote | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   " \r}β#␄？␈Ｔｔ\x1cζ`j\x1akmαＵ１␍θN，␑\bＡP\r␉",
		out:  "␠\r}β#␄？␈Ｔｔ\x1cζ`j\x1akmαＵ１␍θN，␑\bＡP\r␉",
	}, { // 191
		mask: EncodeSingleQuote | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "␠\r}β#␄？␈Ｔｔ\x1cζ`j\x1akmαＵ１␍θN，␑\bＡP\r␉",
		out:  "‛␠\r}β#␄？␈Ｔｔ\x1cζ`j\x1akmαＵ１␍θN，␑\bＡP\r␉",
	}, { // 192
		mask: EncodeSingleQuote | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "\x16\t}β#␄？␈Ｔｔ\x1cζ`j\x1akmαＵ１␍θN，␑\bＡP\t ",
		out:  "\x16\t}β#␄？␈Ｔｔ\x1cζ`j\x1akmαＵ１␍θN，␑\bＡP\t ",
	}, { // 193
		mask: EncodeSingleQuote | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "\x16\t}β#␄？␈Ｔｔ\x1cζ`j\x1akmαＵ１␍θN，␑\bＡP\t␠",
		out:  "\x16\t}β#␄？␈Ｔｔ\x1cζ`j\x1akmαＵ１␍θN，␑\bＡP\t␠",
	}, { // 194
		mask: EncodeSingleQuote | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "\x16\n}β#␄？␈Ｔｔ\x1cζ`j\x1akmαＵ１␍θN，␑\bＡP\n ",
		out:  "\x16\n}β#␄？␈Ｔｔ\x1cζ`j\x1akmαＵ１␍θN，␑\bＡP\n ",
	}, { // 195
		mask: EncodeSingleQuote | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "\x16\n}β#␄？␈Ｔｔ\x1cζ`j\x1akmαＵ１␍θN，␑\bＡP\n␠",
		out:  "\x16\n}β#␄？␈Ｔｔ\x1cζ`j\x1akmαＵ１␍θN，␑\bＡP\n␠",
	}, { // 196
		mask: EncodeSingleQuote | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "\x16\v}β#␄？␈Ｔｔ\x1cζ`j\x1akmαＵ１␍θN，␑\bＡP\v ",
		out:  "\x16\v}β#␄？␈Ｔｔ\x1cζ`j\x1akmαＵ１␍θN，␑\bＡP\v ",
	}, { // 197
		mask: EncodeSingleQuote | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "\x16\v}β#␄？␈Ｔｔ\x1cζ`j\x1akmαＵ１␍θN，␑\bＡP\v␠",
		out:  "\x16\v}β#␄？␈Ｔｔ\x1cζ`j\x1akmαＵ１␍θN，␑\bＡP\v␠",
	}, { // 198
		mask: EncodeSingleQuote | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "\x16\r}β#␄？␈Ｔｔ\x1cζ`j\x1akmαＵ１␍θN，␑\bＡP\r ",
		out:  "\x16\r}β#␄？␈Ｔｔ\x1cζ`j\x1akmαＵ１␍θN，␑\bＡP\r ",
	}, { // 199
		mask: EncodeSingleQuote | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "\x16\r}β#␄？␈Ｔｔ\x1cζ`j\x1akmαＵ１␍θN，␑\bＡP\r␠",
		out:  "\x16\r}β#␄？␈Ｔｔ\x1cζ`j\x1akmαＵ１␍θN，␑\bＡP\r␠",
	}, { // 200
		mask: EncodeBackQuote | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   " \t\x12Uｐ␕ξｚf\t␕＼\b｀\a>Iβｊ\x1f＇K｀λ８υ\\c\tπ",
		out:  "␠\t\x12Uｐ␕ξｚf\t␕＼\b‛｀\a>Iβｊ\x1f＇K‛｀λ８υ\\c\tπ",
	}, { // 201
		mask: EncodeBackQuote | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "␠\t\x12Uｐ␕ξｚf\t␕＼\b｀\a>Iβｊ\x1f＇K｀λ８υ\\c\tπ",
		out:  "‛␠\t\x12Uｐ␕ξｚf\t␕＼\b‛｀\a>Iβｊ\x1f＇K‛｀λ８υ\\c\tπ",
	}, { // 202
		mask: EncodeBackQuote | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   " \n\x12Uｐ␕ξｚf\t␕＼\b｀\a>Iβｊ\x1f＇K｀λ８υ\\c\nπ",
		out:  "␠\n\x12Uｐ␕ξｚf\t␕＼\b‛｀\a>Iβｊ\x1f＇K‛｀λ８υ\\c\nπ",
	}, { // 203
		mask: EncodeBackQuote | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "␠\n\x12Uｐ␕ξｚf\t␕＼\b｀\a>Iβｊ\x1f＇K｀λ８υ\\c\nπ",
		out:  "‛␠\n\x12Uｐ␕ξｚf\t␕＼\b‛｀\a>Iβｊ\x1f＇K‛｀λ８υ\\c\nπ",
	}, { // 204
		mask: EncodeBackQuote | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   " \v\x12Uｐ␕ξｚf\t␕＼\b｀\a>Iβｊ\x1f＇K｀λ８υ\\c\vπ",
		out:  "␠\v\x12Uｐ␕ξｚf\t␕＼\b‛｀\a>Iβｊ\x1f＇K‛｀λ８υ\\c\vπ",
	}, { // 205
		mask: EncodeBackQuote | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "␠\v\x12Uｐ␕ξｚf\t␕＼\b｀\a>Iβｊ\x1f＇K｀λ８υ\\c\vπ",
		out:  "‛␠\v\x12Uｐ␕ξｚf\t␕＼\b‛｀\a>Iβｊ\x1f＇K‛｀λ８υ\\c\vπ",
	}, { // 206
		mask: EncodeBackQuote | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   " \r\x12Uｐ␕ξｚf\t␕＼\b｀\a>Iβｊ\x1f＇K｀λ８υ\\c\rπ",
		out:  "␠\r\x12Uｐ␕ξｚf\t␕＼\b‛｀\a>Iβｊ\x1f＇K‛｀λ８υ\\c\rπ",
	}, { // 207
		mask: EncodeBackQuote | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "␠\r\x12Uｐ␕ξｚf\t␕＼\b｀\a>Iβｊ\x1f＇K｀λ８υ\\c\rπ",
		out:  "‛␠\r\x12Uｐ␕ξｚf\t␕＼\b‛｀\a>Iβｊ\x1f＇K‛｀λ８υ\\c\rπ",
	}, { // 208
		mask: EncodeBackQuote | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "␎\t\x12Uｐ␕ξｚf\t␕＼\b｀\a>Iβｊ\x1f＇K｀λ８υ\\c\t ",
		out:  "␎\t\x12Uｐ␕ξｚf\t␕＼\b‛｀\a>Iβｊ\x1f＇K‛｀λ８υ\\c\t ",
	}, { // 209
		mask: EncodeBackQuote | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "␎\t\x12Uｐ␕ξｚf\t␕＼\b｀\a>Iβｊ\x1f＇K｀λ８υ\\c\t␠",
		out:  "␎\t\x12Uｐ␕ξｚf\t␕＼\b‛｀\a>Iβｊ\x1f＇K‛｀λ８υ\\c\t␠",
	}, { // 210
		mask: EncodeBackQuote | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "␎\n\x12Uｐ␕ξｚf\t␕＼\b｀\a>Iβｊ\x1f＇K｀λ８υ\\c\n ",
		out:  "␎\n\x12Uｐ␕ξｚf\t␕＼\b‛｀\a>Iβｊ\x1f＇K‛｀λ８υ\\c\n ",
	}, { // 211
		mask: EncodeBackQuote | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "␎\n\x12Uｐ␕ξｚf\t␕＼\b｀\a>Iβｊ\x1f＇K｀λ８υ\\c\n␠",
		out:  "␎\n\x12Uｐ␕ξｚf\t␕＼\b‛｀\a>Iβｊ\x1f＇K‛｀λ８υ\\c\n␠",
	}, { // 212
		mask: EncodeBackQuote | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "␎\v\x12Uｐ␕ξｚf\t␕＼\b｀\a>Iβｊ\x1f＇K｀λ８υ\\c\v ",
		out:  "␎\v\x12Uｐ␕ξｚf\t␕＼\b‛｀\a>Iβｊ\x1f＇K‛｀λ８υ\\c\v ",
	}, { // 213
		mask: EncodeBackQuote | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "␎\v\x12Uｐ␕ξｚf\t␕＼\b｀\a>Iβｊ\x1f＇K｀λ８υ\\c\v␠",
		out:  "␎\v\x12Uｐ␕ξｚf\t␕＼\b‛｀\a>Iβｊ\x1f＇K‛｀λ８υ\\c\v␠",
	}, { // 214
		mask: EncodeBackQuote | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "␎\r\x12Uｐ␕ξｚf\t␕＼\b｀\a>Iβｊ\x1f＇K｀λ８υ\\c\r ",
		out:  "␎\r\x12Uｐ␕ξｚf\t␕＼\b‛｀\a>Iβｊ\x1f＇K‛｀λ８υ\\c\r ",
	}, { // 215
		mask: EncodeBackQuote | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "␎\r\x12Uｐ␕ξｚf\t␕＼\b｀\a>Iβｊ\x1f＇K｀λ８υ\\c\r␠",
		out:  "␎\r\x12Uｐ␕ξｚf\t␕＼\b‛｀\a>Iβｊ\x1f＇K‛｀λ８υ\\c\r␠",
	}, { // 216
		mask: EncodeLtGt | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   " \t␁>η～␀\nκＷK\x05\rχδ＞－σＮ\x1aZ$ι：␞ｊ+\x02\t\x12",
		out:  "␠\t␁＞η～‛␀\nκＷK\x05\rχδ‛＞－σＮ\x1aZ$ι：␞ｊ+\x02\t\x12",
	}, { // 217
		mask: EncodeLtGt | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "␠\t␁>η～␀\nκＷK\x05\rχδ＞－σＮ\x1aZ$ι：␞ｊ+\x02\t\x12",
		out:  "‛␠\t␁＞η～‛␀\nκＷK\x05\rχδ‛＞－σＮ\x1aZ$ι：␞ｊ+\x02\t\x12",
	}, { // 218
		mask: EncodeLtGt | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   " \n␁>η～␀\nκＷK\x05\rχδ＞－σＮ\x1aZ$ι：␞ｊ+\x02\n\x12",
		out:  "␠\n␁＞η～‛␀\nκＷK\x05\rχδ‛＞－σＮ\x1aZ$ι：␞ｊ+\x02\n\x12",
	}, { // 219
		mask: EncodeLtGt | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "␠\n␁>η～␀\nκＷK\x05\rχδ＞－σＮ\x1aZ$ι：␞ｊ+\x02\n\x12",
		out:  "‛␠\n␁＞η～‛␀\nκＷK\x05\rχδ‛＞－σＮ\x1aZ$ι：␞ｊ+\x02\n\x12",
	}, { // 220
		mask: EncodeLtGt | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   " \v␁>η～␀\nκＷK\x05\rχδ＞－σＮ\x1aZ$ι：␞ｊ+\x02\v\x12",
		out:  "␠\v␁＞η～‛␀\nκＷK\x05\rχδ‛＞－σＮ\x1aZ$ι：␞ｊ+\x02\v\x12",
	}, { // 221
		mask: EncodeLtGt | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "␠\v␁>η～␀\nκＷK\x05\rχδ＞－σＮ\x1aZ$ι：␞ｊ+\x02\v\x12",
		out:  "‛␠\v␁＞η～‛␀\nκＷK\x05\rχδ‛＞－σＮ\x1aZ$ι：␞ｊ+\x02\v\x12",
	}, { // 222
		mask: EncodeLtGt | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   " \r␁>η～␀\nκＷK\x05\rχδ＞－σＮ\x1aZ$ι：␞ｊ+\x02\r\x12",
		out:  "␠\r␁＞η～‛␀\nκＷK\x05\rχδ‛＞－σＮ\x1aZ$ι：␞ｊ+\x02\r\x12",
	}, { // 223
		mask: EncodeLtGt | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "␠\r␁>η～␀\nκＷK\x05\rχδ＞－σＮ\x1aZ$ι：␞ｊ+\x02\r\x12",
		out:  "‛␠\r␁＞η～‛␀\nκＷK\x05\rχδ‛＞－σＮ\x1aZ$ι：␞ｊ+\x02\r\x12",
	}, { // 224
		mask: EncodeLtGt | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "ｍ\t␁>η～␀\nκＷK\x05\rχδ＞－σＮ\x1aZ$ι：␞ｊ+\x02\t ",
		out:  "ｍ\t␁＞η～‛␀\nκＷK\x05\rχδ‛＞－σＮ\x1aZ$ι：␞ｊ+\x02\t ",
	}, { // 225
		mask: EncodeLtGt | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "ｍ\t␁>η～␀\nκＷK\x05\rχδ＞－σＮ\x1aZ$ι：␞ｊ+\x02\t␠",
		out:  "ｍ\t␁＞η～‛␀\nκＷK\x05\rχδ‛＞－σＮ\x1aZ$ι：␞ｊ+\x02\t␠",
	}, { // 226
		mask: EncodeLtGt | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "ｍ\n␁>η～␀\nκＷK\x05\rχδ＞－σＮ\x1aZ$ι：␞ｊ+\x02\n ",
		out:  "ｍ\n␁＞η～‛␀\nκＷK\x05\rχδ‛＞－σＮ\x1aZ$ι：␞ｊ+\x02\n ",
	}, { // 227
		mask: EncodeLtGt | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "ｍ\n␁>η～␀\nκＷK\x05\rχδ＞－σＮ\x1aZ$ι：␞ｊ+\x02\n␠",
		out:  "ｍ\n␁＞η～‛␀\nκＷK\x05\rχδ‛＞－σＮ\x1aZ$ι：␞ｊ+\x02\n␠",
	}, { // 228
		mask: EncodeLtGt | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "ｍ\v␁>η～␀\nκＷK\x05\rχδ＞－σＮ\x1aZ$ι：␞ｊ+\x02\v ",
		out:  "ｍ\v␁＞η～‛␀\nκＷK\x05\rχδ‛＞－σＮ\x1aZ$ι：␞ｊ+\x02\v ",
	}, { // 229
		mask: EncodeLtGt | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "ｍ\v␁>η～␀\nκＷK\x05\rχδ＞－σＮ\x1aZ$ι：␞ｊ+\x02\v␠",
		out:  "ｍ\v␁＞η～‛␀\nκＷK\x05\rχδ‛＞－σＮ\x1aZ$ι：␞ｊ+\x02\v␠",
	}, { // 230
		mask: EncodeLtGt | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "ｍ\r␁>η～␀\nκＷK\x05\rχδ＞－σＮ\x1aZ$ι：␞ｊ+\x02\r ",
		out:  "ｍ\r␁＞η～‛␀\nκＷK\x05\rχδ‛＞－σＮ\x1aZ$ι：␞ｊ+\x02\r ",
	}, { // 231
		mask: EncodeLtGt | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "ｍ\r␁>η～␀\nκＷK\x05\rχδ＞－σＮ\x1aZ$ι：␞ｊ+\x02\r␠",
		out:  "ｍ\r␁＞η～‛␀\nκＷK\x05\rχδ‛＞－σＮ\x1aZ$ι：␞ｊ+\x02\r␠",
	}, { // 232
		mask: EncodeSquareBracket | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   " \t0%ς\x17ηπ７>␊␡␛D\x04FＸbｐ\x1e＊κ␜φ\x00％]=\t＼",
		out:  "␠\t0%ς\x17ηπ７>␊␡␛D\x04FＸbｐ\x1e＊κ␜φ␀％］=\t＼",
	}, { // 233
		mask: EncodeSquareBracket | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "␠\t0%ς\x17ηπ７>␊␡␛D\x04FＸbｐ\x1e＊κ␜φ\x00％]=\t＼",
		out:  "‛␠\t0%ς\x17ηπ７>␊␡␛D\x04FＸbｐ\x1e＊κ␜φ␀％］=\t＼",
	}, { // 234
		mask: EncodeSquareBracket | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   " \n0%ς\x17ηπ７>␊␡␛D\x04FＸbｐ\x1e＊κ␜φ\x00％]=\n＼",
		out:  "␠\n0%ς\x17ηπ７>␊␡␛D\x04FＸbｐ\x1e＊κ␜φ␀％］=\n＼",
	}, { // 235
		mask: EncodeSquareBracket | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "␠\n0%ς\x17ηπ７>␊␡␛D\x04FＸbｐ\x1e＊κ␜φ\x00％]=\n＼",
		out:  "‛␠\n0%ς\x17ηπ７>␊␡␛D\x04FＸbｐ\x1e＊κ␜φ␀％］=\n＼",
	}, { // 236
		mask: EncodeSquareBracket | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   " \v0%ς\x17ηπ７>␊␡␛D\x04FＸbｐ\x1e＊κ␜φ\x00％]=\v＼",
		out:  "␠\v0%ς\x17ηπ７>␊␡␛D\x04FＸbｐ\x1e＊κ␜φ␀％］=\v＼",
	}, { // 237
		mask: EncodeSquareBracket | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "␠\v0%ς\x17ηπ７>␊␡␛D\x04FＸbｐ\x1e＊κ␜φ\x00％]=\v＼",
		out:  "‛␠\v0%ς\x17ηπ７>␊␡␛D\x04FＸbｐ\x1e＊κ␜φ␀％］=\v＼",
	}, { // 238
		mask: EncodeSquareBracket | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   " \r0%ς\x17ηπ７>␊␡␛D\x04FＸbｐ\x1e＊κ␜φ\x00％]=\r＼",
		out:  "␠\r0%ς\x17ηπ７>␊␡␛D\x04FＸbｐ\x1e＊κ␜φ␀％］=\r＼",
	}, { // 239
		mask: EncodeSquareBracket | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "␠\r0%ς\x17ηπ７>␊␡␛D\x04FＸbｐ\x1e＊κ␜φ\x00％]=\r＼",
		out:  "‛␠\r0%ς\x17ηπ７>␊␡␛D\x04FＸbｐ\x1e＊κ␜φ␀％］=\r＼",
	}, { // 240
		mask: EncodeSquareBracket | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "␟\t0%ς\x17ηπ７>␊␡␛D\x04FＸbｐ\x1e＊κ␜φ\x00％]=\t ",
		out:  "␟\t0%ς\x17ηπ７>␊␡␛D\x04FＸbｐ\x1e＊κ␜φ␀％］=\t ",
	}, { // 241
		mask: EncodeSquareBracket | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "␟\t0%ς\x17ηπ７>␊␡␛D\x04FＸbｐ\x1e＊κ␜φ\x00％]=\t␠",
		out:  "␟\t0%ς\x17ηπ７>␊␡␛D\x04FＸbｐ\x1e＊κ␜φ␀％］=\t␠",
	}, { // 242
		mask: EncodeSquareBracket | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "␟\n0%ς\x17ηπ７>␊␡␛D\x04FＸbｐ\x1e＊κ␜φ\x00％]=\n ",
		out:  "␟\n0%ς\x17ηπ７>␊␡␛D\x04FＸbｐ\x1e＊κ␜φ␀％］=\n ",
	}, { // 243
		mask: EncodeSquareBracket | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "␟\n0%ς\x17ηπ７>␊␡␛D\x04FＸbｐ\x1e＊κ␜φ\x00％]=\n␠",
		out:  "␟\n0%ς\x17ηπ７>␊␡␛D\x04FＸbｐ\x1e＊κ␜φ␀％］=\n␠",
	}, { // 244
		mask: EncodeSquareBracket | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "␟\v0%ς\x17ηπ７>␊␡␛D\x04FＸbｐ\x1e＊κ␜φ\x00％]=\v ",
		out:  "␟\v0%ς\x17ηπ７>␊␡␛D\x04FＸbｐ\x1e＊κ␜φ␀％］=\v ",
	}, { // 245
		mask: EncodeSquareBracket | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "␟\v0%ς\x17ηπ７>␊␡␛D\x04FＸbｐ\x1e＊κ␜φ\x00％]=\v␠",
		out:  "␟\v0%ς\x17ηπ７>␊␡␛D\x04FＸbｐ\x1e＊κ␜φ␀％］=\v␠",
	}, { // 246
		mask: EncodeSquareBracket | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "␟\r0%ς\x17ηπ７>␊␡␛D\x04FＸbｐ\x1e＊κ␜φ\x00％]=\r ",
		out:  "␟\r0%ς\x17ηπ７>␊␡␛D\x04FＸbｐ\x1e＊κ␜φ␀％］=\r ",
	}, { // 247
		mask: EncodeSquareBracket | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "␟\r0%ς\x17ηπ７>␊␡␛D\x04FＸbｐ\x1e＊κ␜φ\x00％]=\r␠",
		out:  "␟\r0%ς\x17ηπ７>␊␡␛D\x04FＸbｐ\x1e＊κ␜φ␀％］=\r␠",
	}, { // 248
		mask: EncodeSemicolon | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   " \t\x13Iｅ\x19␔＂4μ␔␄Ｆ$φｗ：Hη\rνI｛！H␋\vσ\tσ",
		out:  "␠\t\x13Iｅ\x19␔＂4μ␔␄Ｆ$φｗ：Hη\rνI｛！H␋\vσ\tσ",
	}, { // 249
		mask: EncodeSemicolon | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "␠\t\x13Iｅ\x19␔＂4μ␔␄Ｆ$φｗ：Hη\rνI｛！H␋\vσ\tσ",
		out:  "‛␠\t\x13Iｅ\x19␔＂4μ␔␄Ｆ$φｗ：Hη\rνI｛！H␋\vσ\tσ",
	}, { // 250
		mask: EncodeSemicolon | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   " \n\x13Iｅ\x19␔＂4μ␔␄Ｆ$φｗ：Hη\rνI｛！H␋\vσ\nσ",
		out:  "␠\n\x13Iｅ\x19␔＂4μ␔␄Ｆ$φｗ：Hη\rνI｛！H␋\vσ\nσ",
	}, { // 251
		mask: EncodeSemicolon | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "␠\n\x13Iｅ\x19␔＂4μ␔␄Ｆ$φｗ：Hη\rνI｛！H␋\vσ\nσ",
		out:  "‛␠\n\x13Iｅ\x19␔＂4μ␔␄Ｆ$φｗ：Hη\rνI｛！H␋\vσ\nσ",
	}, { // 252
		mask: EncodeSemicolon | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   " \v\x13Iｅ\x19␔＂4μ␔␄Ｆ$φｗ：Hη\rνI｛！H␋\vσ\vσ",
		out:  "␠\v\x13Iｅ\x19␔＂4μ␔␄Ｆ$φｗ：Hη\rνI｛！H␋\vσ\vσ",
	}, { // 253
		mask: EncodeSemicolon | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "␠\v\x13Iｅ\x19␔＂4μ␔␄Ｆ$φｗ：Hη\rνI｛！H␋\vσ\vσ",
		out:  "‛␠\v\x13Iｅ\x19␔＂4μ␔␄Ｆ$φｗ：Hη\rνI｛！H␋\vσ\vσ",
	}, { // 254
		mask: EncodeSemicolon | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   " \r\x13Iｅ\x19␔＂4μ␔␄Ｆ$φｗ：Hη\rνI｛！H␋\vσ\rσ",
		out:  "␠\r\x13Iｅ\x19␔＂4μ␔␄Ｆ$φｗ：Hη\rνI｛！H␋\vσ\rσ",
	}, { // 255
		mask: EncodeSemicolon | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "␠\r\x13Iｅ\x19␔＂4μ␔␄Ｆ$φｗ：Hη\rνI｛！H␋\vσ\rσ",
		out:  "‛␠\r\x13Iｅ\x19␔＂4μ␔␄Ｆ$φｗ：Hη\rνI｛！H␋\vσ\rσ",
	}, { // 256
		mask: EncodeSemicolon | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "$\t\x13Iｅ\x19␔＂4μ␔␄Ｆ$φｗ：Hη\rνI｛！H␋\vσ\t ",
		out:  "$\t\x13Iｅ\x19␔＂4μ␔␄Ｆ$φｗ：Hη\rνI｛！H␋\vσ\t ",
	}, { // 257
		mask: EncodeSemicolon | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "$\t\x13Iｅ\x19␔＂4μ␔␄Ｆ$φｗ：Hη\rνI｛！H␋\vσ\t␠",
		out:  "$\t\x13Iｅ\x19␔＂4μ␔␄Ｆ$φｗ：Hη\rνI｛！H␋\vσ\t␠",
	}, { // 258
		mask: EncodeSemicolon | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "$\n\x13Iｅ\x19␔＂4μ␔␄Ｆ$φｗ：Hη\rνI｛！H␋\vσ\n ",
		out:  "$\n\x13Iｅ\x19␔＂4μ␔␄Ｆ$φｗ：Hη\rνI｛！H␋\vσ\n ",
	}, { // 259
		mask: EncodeSemicolon | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "$\n\x13Iｅ\x19␔＂4μ␔␄Ｆ$φｗ：Hη\rνI｛！H␋\vσ\n␠",
		out:  "$\n\x13Iｅ\x19␔＂4μ␔␄Ｆ$φｗ：Hη\rνI｛！H␋\vσ\n␠",
	}, { // 260
		mask: EncodeSemicolon | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "$\v\x13Iｅ\x19␔＂4μ␔␄Ｆ$φｗ：Hη\rνI｛！H␋\vσ\v ",
		out:  "$\v\x13Iｅ\x19␔＂4μ␔␄Ｆ$φｗ：Hη\rνI｛！H␋\vσ\v ",
	}, { // 261
		mask: EncodeSemicolon | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "$\v\x13Iｅ\x19␔＂4μ␔␄Ｆ$φｗ：Hη\rνI｛！H␋\vσ\v␠",
		out:  "$\v\x13Iｅ\x19␔＂4μ␔␄Ｆ$φｗ：Hη\rνI｛！H␋\vσ\v␠",
	}, { // 262
		mask: EncodeSemicolon | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "$\r\x13Iｅ\x19␔＂4μ␔␄Ｆ$φｗ：Hη\rνI｛！H␋\vσ\r ",
		out:  "$\r\x13Iｅ\x19␔＂4μ␔␄Ｆ$φｗ：Hη\rνI｛！H␋\vσ\r ",
	}, { // 263
		mask: EncodeSemicolon | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "$\r\x13Iｅ\x19␔＂4μ␔␄Ｆ$φｗ：Hη\rνI｛！H␋\vσ\r␠",
		out:  "$\r\x13Iｅ\x19␔＂4μ␔␄Ｆ$φｗ：Hη\rνI｛！H␋\vσ\r␠",
	}, { // 264
		mask: EncodeDollar | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   " \t␚＃\x04ｚ1πτ␒\x11ι␌Xο＝＜␍｜χηcQＺ\x1d;\x06j\tＥ",
		out:  "␠\t␚＃\x04ｚ1πτ␒\x11ι␌Xο＝＜␍｜χηcQＺ\x1d;\x06j\tＥ",
	}, { // 265
		mask: EncodeDollar | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "␠\t␚＃\x04ｚ1πτ␒\x11ι␌Xο＝＜␍｜χηcQＺ\x1d;\x06j\tＥ",
		out:  "‛␠\t␚＃\x04ｚ1πτ␒\x11ι␌Xο＝＜␍｜χηcQＺ\x1d;\x06j\tＥ",
	}, { // 266
		mask: EncodeDollar | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   " \n␚＃\x04ｚ1πτ␒\x11ι␌Xο＝＜␍｜χηcQＺ\x1d;\x06j\nＥ",
		out:  "␠\n␚＃\x04ｚ1πτ␒\x11ι␌Xο＝＜␍｜χηcQＺ\x1d;\x06j\nＥ",
	}, { // 267
		mask: EncodeDollar | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "␠\n␚＃\x04ｚ1πτ␒\x11ι␌Xο＝＜␍｜χηcQＺ\x1d;\x06j\nＥ",
		out:  "‛␠\n␚＃\x04ｚ1πτ␒\x11ι␌Xο＝＜␍｜χηcQＺ\x1d;\x06j\nＥ",
	}, { // 268
		mask: EncodeDollar | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   " \v␚＃\x04ｚ1πτ␒\x11ι␌Xο＝＜␍｜χηcQＺ\x1d;\x06j\vＥ",
		out:  "␠\v␚＃\x04ｚ1πτ␒\x11ι␌Xο＝＜␍｜χηcQＺ\x1d;\x06j\vＥ",
	}, { // 269
		mask: EncodeDollar | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "␠\v␚＃\x04ｚ1πτ␒\x11ι␌Xο＝＜␍｜χηcQＺ\x1d;\x06j\vＥ",
		out:  "‛␠\v␚＃\x04ｚ1πτ␒\x11ι␌Xο＝＜␍｜χηcQＺ\x1d;\x06j\vＥ",
	}, { // 270
		mask: EncodeDollar | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   " \r␚＃\x04ｚ1πτ␒\x11ι␌Xο＝＜␍｜χηcQＺ\x1d;\x06j\rＥ",
		out:  "␠\r␚＃\x04ｚ1πτ␒\x11ι␌Xο＝＜␍｜χηcQＺ\x1d;\x06j\rＥ",
	}, { // 271
		mask: EncodeDollar | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "␠\r␚＃\x04ｚ1πτ␒\x11ι␌Xο＝＜␍｜χηcQＺ\x1d;\x06j\rＥ",
		out:  "‛␠\r␚＃\x04ｚ1πτ␒\x11ι␌Xο＝＜␍｜χηcQＺ\x1d;\x06j\rＥ",
	}, { // 272
		mask: EncodeDollar | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "/\t␚＃\x04ｚ1πτ␒\x11ι␌Xο＝＜␍｜χηcQＺ\x1d;\x06j\t ",
		out:  "/\t␚＃\x04ｚ1πτ␒\x11ι␌Xο＝＜␍｜χηcQＺ\x1d;\x06j\t ",
	}, { // 273
		mask: EncodeDollar | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "/\t␚＃\x04ｚ1πτ␒\x11ι␌Xο＝＜␍｜χηcQＺ\x1d;\x06j\t␠",
		out:  "/\t␚＃\x04ｚ1πτ␒\x11ι␌Xο＝＜␍｜χηcQＺ\x1d;\x06j\t␠",
	}, { // 274
		mask: EncodeDollar | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "/\n␚＃\x04ｚ1πτ␒\x11ι␌Xο＝＜␍｜χηcQＺ\x1d;\x06j\n ",
		out:  "/\n␚＃\x04ｚ1πτ␒\x11ι␌Xο＝＜␍｜χηcQＺ\x1d;\x06j\n ",
	}, { // 275
		mask: EncodeDollar | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "/\n␚＃\x04ｚ1πτ␒\x11ι␌Xο＝＜␍｜χηcQＺ\x1d;\x06j\n␠",
		out:  "/\n␚＃\x04ｚ1πτ␒\x11ι␌Xο＝＜␍｜χηcQＺ\x1d;\x06j\n␠",
	}, { // 276
		mask: EncodeDollar | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "/\v␚＃\x04ｚ1πτ␒\x11ι␌Xο＝＜␍｜χηcQＺ\x1d;\x06j\v ",
		out:  "/\v␚＃\x04ｚ1πτ␒\x11ι␌Xο＝＜␍｜χηcQＺ\x1d;\x06j\v ",
	}, { // 277
		mask: EncodeDollar | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "/\v␚＃\x04ｚ1πτ␒\x11ι␌Xο＝＜␍｜χηcQＺ\x1d;\x06j\v␠",
		out:  "/\v␚＃\x04ｚ1πτ␒\x11ι␌Xο＝＜␍｜χηcQＺ\x1d;\x06j\v␠",
	}, { // 278
		mask: EncodeDollar | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "/\r␚＃\x04ｚ1πτ␒\x11ι␌Xο＝＜␍｜χηcQＺ\x1d;\x06j\r ",
		out:  "/\r␚＃\x04ｚ1πτ␒\x11ι␌Xο＝＜␍｜χηcQＺ\x1d;\x06j\r ",
	}, { // 279
		mask: EncodeDollar | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "/\r␚＃\x04ｚ1πτ␒\x11ι␌Xο＝＜␍｜χηcQＺ\x1d;\x06j\r␠",
		out:  "/\r␚＃\x04ｚ1πτ␒\x11ι␌Xο＝＜␍｜χηcQＺ\x1d;\x06j\r␠",
	}, { // 280
		mask: EncodeDoubleQuote | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   " \tCχ]x，Ｐ＄Sξξλ␝:ａ\x1b\vκ␟ε％␔ｈｘ\x14iR\t\x10",
		out:  "␠\tCχ]x，Ｐ＄Sξξλ␝:ａ\x1b\vκ␟ε％␔ｈｘ\x14iR\t\x10",
	}, { // 281
		mask: EncodeDoubleQuote | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "␠\tCχ]x，Ｐ＄Sξξλ␝:ａ\x1b\vκ␟ε％␔ｈｘ\x14iR\t\x10",
		out:  "‛␠\tCχ]x，Ｐ＄Sξξλ␝:ａ\x1b\vκ␟ε％␔ｈｘ\x14iR\t\x10",
	}, { // 282
		mask: EncodeDoubleQuote | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   " \nCχ]x，Ｐ＄Sξξλ␝:ａ\x1b\vκ␟ε％␔ｈｘ\x14iR\n\x10",
		out:  "␠\nCχ]x，Ｐ＄Sξξλ␝:ａ\x1b\vκ␟ε％␔ｈｘ\x14iR\n\x10",
	}, { // 283
		mask: EncodeDoubleQuote | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "␠\nCχ]x，Ｐ＄Sξξλ␝:ａ\x1b\vκ␟ε％␔ｈｘ\x14iR\n\x10",
		out:  "‛␠\nCχ]x，Ｐ＄Sξξλ␝:ａ\x1b\vκ␟ε％␔ｈｘ\x14iR\n\x10",
	}, { // 284
		mask: EncodeDoubleQuote | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   " \vCχ]x，Ｐ＄Sξξλ␝:ａ\x1b\vκ␟ε％␔ｈｘ\x14iR\v\x10",
		out:  "␠\vCχ]x，Ｐ＄Sξξλ␝:ａ\x1b\vκ␟ε％␔ｈｘ\x14iR\v\x10",
	}, { // 285
		mask: EncodeDoubleQuote | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "␠\vCχ]x，Ｐ＄Sξξλ␝:ａ\x1b\vκ␟ε％␔ｈｘ\x14iR\v\x10",
		out:  "‛␠\vCχ]x，Ｐ＄Sξξλ␝:ａ\x1b\vκ␟ε％␔ｈｘ\x14iR\v\x10",
	}, { // 286
		mask: EncodeDoubleQuote | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   " \rCχ]x，Ｐ＄Sξξλ␝:ａ\x1b\vκ␟ε％␔ｈｘ\x14iR\r\x10",
		out:  "␠\rCχ]x，Ｐ＄Sξξλ␝:ａ\x1b\vκ␟ε％␔ｈｘ\x14iR\r\x10",
	}, { // 287
		mask: EncodeDoubleQuote | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "␠\rCχ]x，Ｐ＄Sξξλ␝:ａ\x1b\vκ␟ε％␔ｈｘ\x14iR\r\x10",
		out:  "‛␠\rCχ]x，Ｐ＄Sξξλ␝:ａ\x1b\vκ␟ε％␔ｈｘ\x14iR\r\x10",
	}, { // 288
		mask: EncodeDoubleQuote | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "␊\tCχ]x，Ｐ＄Sξξλ␝:ａ\x1b\vκ␟ε％␔ｈｘ\x14iR\t ",
		out:  "‛␊\tCχ]x，Ｐ＄Sξξλ␝:ａ\x1b\vκ␟ε％␔ｈｘ\x14iR\t ",
	}, { // 289
		mask: EncodeDoubleQuote | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "␊\tCχ]x，Ｐ＄Sξξλ␝:ａ\x1b\vκ␟ε％␔ｈｘ\x14iR\t␠",
		out:  "‛␊\tCχ]x，Ｐ＄Sξξλ␝:ａ\x1b\vκ␟ε％␔ｈｘ\x14iR\t␠",
	}, { // 290
		mask: EncodeDoubleQuote | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "␊\nCχ]x，Ｐ＄Sξξλ␝:ａ\x1b\vκ␟ε％␔ｈｘ\x14iR\n ",
		out:  "‛␊\nCχ]x，Ｐ＄Sξξλ␝:ａ\x1b\vκ␟ε％␔ｈｘ\x14iR\n ",
	}, { // 291
		mask: EncodeDoubleQuote | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "␊\nCχ]x，Ｐ＄Sξξλ␝:ａ\x1b\vκ␟ε％␔ｈｘ\x14iR\n␠",
		out:  "‛␊\nCχ]x，Ｐ＄Sξξλ␝:ａ\x1b\vκ␟ε％␔ｈｘ\x14iR\n␠",
	}, { // 292
		mask: EncodeDoubleQuote | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "␊\vCχ]x，Ｐ＄Sξξλ␝:ａ\x1b\vκ␟ε％␔ｈｘ\x14iR\v ",
		out:  "‛␊\vCχ]x，Ｐ＄Sξξλ␝:ａ\x1b\vκ␟ε％␔ｈｘ\x14iR\v ",
	}, { // 293
		mask: EncodeDoubleQuote | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "␊\vCχ]x，Ｐ＄Sξξλ␝:ａ\x1b\vκ␟ε％␔ｈｘ\x14iR\v␠",
		out:  "‛␊\vCχ]x，Ｐ＄Sξξλ␝:ａ\x1b\vκ␟ε％␔ｈｘ\x14iR\v␠",
	}, { // 294
		mask: EncodeDoubleQuote | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "␊\rCχ]x，Ｐ＄Sξξλ␝:ａ\x1b\vκ␟ε％␔ｈｘ\x14iR\r ",
		out:  "‛␊\rCχ]x，Ｐ＄Sξξλ␝:ａ\x1b\vκ␟ε％␔ｈｘ\x14iR\r ",
	}, { // 295
		mask: EncodeDoubleQuote | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "␊\rCχ]x，Ｐ＄Sξξλ␝:ａ\x1b\vκ␟ε％␔ｈｘ\x14iR\r␠",
		out:  "‛␊\rCχ]x，Ｐ＄Sξξλ␝:ａ\x1b\vκ␟ε％␔ｈｘ\x14iR\r␠",
	}, { // 296
		mask: EncodeColon | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   " \tηπ？\x13）␞ＳI␞ακ\f␁Ｅa＜z］οｕ/\a␍W\x12Ｘ\t\x02",
		out:  "␠\tηπ？\x13）␞ＳI␞ακ\f␁Ｅa＜z］οｕ/\a␍W\x12Ｘ\t\x02",
	}, { // 297
		mask: EncodeColon | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "␠\tηπ？\x13）␞ＳI␞ακ\f␁Ｅa＜z］οｕ/\a␍W\x12Ｘ\t\x02",
		out:  "‛␠\tηπ？\x13）␞ＳI␞ακ\f␁Ｅa＜z］οｕ/\a␍W\x12Ｘ\t\x02",
	}, { // 298
		mask: EncodeColon | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   " \nηπ？\x13）␞ＳI␞ακ\f␁Ｅa＜z］οｕ/\a␍W\x12Ｘ\n\x02",
		out:  "␠\nηπ？\x13）␞ＳI␞ακ\f␁Ｅa＜z］οｕ/\a␍W\x12Ｘ\n\x02",
	}, { // 299
		mask: EncodeColon | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "␠\nηπ？\x13）␞ＳI␞ακ\f␁Ｅa＜z］οｕ/\a␍W\x12Ｘ\n\x02",
		out:  "‛␠\nηπ？\x13）␞ＳI␞ακ\f␁Ｅa＜z］οｕ/\a␍W\x12Ｘ\n\x02",
	}, { // 300
		mask: EncodeColon | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   " \vηπ？\x13）␞ＳI␞ακ\f␁Ｅa＜z］οｕ/\a␍W\x12Ｘ\v\x02",
		out:  "␠\vηπ？\x13）␞ＳI␞ακ\f␁Ｅa＜z］οｕ/\a␍W\x12Ｘ\v\x02",
	}, { // 301
		mask: EncodeColon | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "␠\vηπ？\x13）␞ＳI␞ακ\f␁Ｅa＜z］οｕ/\a␍W\x12Ｘ\v\x02",
		out:  "‛␠\vηπ？\x13）␞ＳI␞ακ\f␁Ｅa＜z］οｕ/\a␍W\x12Ｘ\v\x02",
	}, { // 302
		mask: EncodeColon | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   " \rηπ？\x13）␞ＳI␞ακ\f␁Ｅa＜z］οｕ/\a␍W\x12Ｘ\r\x02",
		out:  "␠\rηπ？\x13）␞ＳI␞ακ\f␁Ｅa＜z］οｕ/\a␍W\x12Ｘ\r\x02",
	}, { // 303
		mask: EncodeColon | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "␠\rηπ？\x13）␞ＳI␞ακ\f␁Ｅa＜z］οｕ/\a␍W\x12Ｘ\r\x02",
		out:  "‛␠\rηπ？\x13）␞ＳI␞ακ\f␁Ｅa＜z］οｕ/\a␍W\x12Ｘ\r\x02",
	}, { // 304
		mask: EncodeColon | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "t\tηπ？\x13）␞ＳI␞ακ\f␁Ｅa＜z］οｕ/\a␍W\x12Ｘ\t ",
		out:  "t\tηπ？\x13）␞ＳI␞ακ\f␁Ｅa＜z］οｕ/\a␍W\x12Ｘ\t ",
	}, { // 305
		mask: EncodeColon | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "t\tηπ？\x13）␞ＳI␞ακ\f␁Ｅa＜z］οｕ/\a␍W\x12Ｘ\t␠",
		out:  "t\tηπ？\x13）␞ＳI␞ακ\f␁Ｅa＜z］οｕ/\a␍W\x12Ｘ\t␠",
	}, { // 306
		mask: EncodeColon | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "t\nηπ？\x13）␞ＳI␞ακ\f␁Ｅa＜z］οｕ/\a␍W\x12Ｘ\n ",
		out:  "t\nηπ？\x13）␞ＳI␞ακ\f␁Ｅa＜z］οｕ/\a␍W\x12Ｘ\n ",
	}, { // 307
		mask: EncodeColon | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "t\nηπ？\x13）␞ＳI␞ακ\f␁Ｅa＜z］οｕ/\a␍W\x12Ｘ\n␠",
		out:  "t\nηπ？\x13）␞ＳI␞ακ\f␁Ｅa＜z］οｕ/\a␍W\x12Ｘ\n␠",
	}, { // 308
		mask: EncodeColon | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "t\vηπ？\x13）␞ＳI␞ακ\f␁Ｅa＜z］οｕ/\a␍W\x12Ｘ\v ",
		out:  "t\vηπ？\x13）␞ＳI␞ακ\f␁Ｅa＜z］οｕ/\a␍W\x12Ｘ\v ",
	}, { // 309
		mask: EncodeColon | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "t\vηπ？\x13）␞ＳI␞ακ\f␁Ｅa＜z］οｕ/\a␍W\x12Ｘ\v␠",
		out:  "t\vηπ？\x13）␞ＳI␞ακ\f␁Ｅa＜z］οｕ/\a␍W\x12Ｘ\v␠",
	}, { // 310
		mask: EncodeColon | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "t\rηπ？\x13）␞ＳI␞ακ\f␁Ｅa＜z］οｕ/\a␍W\x12Ｘ\r ",
		out:  "t\rηπ？\x13）␞ＳI␞ακ\f␁Ｅa＜z］οｕ/\a␍W\x12Ｘ\r ",
	}, { // 311
		mask: EncodeColon | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "t\rηπ？\x13）␞ＳI␞ακ\f␁Ｅa＜z］οｕ/\a␍W\x12Ｘ\r␠",
		out:  "t\rηπ？\x13）␞ＳI␞ακ\f␁Ｅa＜z］οｕ/\a␍W\x12Ｘ\r␠",
	}, { // 312
		mask: EncodeQuestion | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   " \t\x12␝␜G{␄ω%．N;％HｐｄξＺη＾\x0f␆$]\u007fο␘\tπ",
		out:  "␠\t\x12␝␜G{␄ω%．N;％HｐｄξＺη＾\x0f␆$]\u007fο␘\tπ",
	}, { // 313
		mask: EncodeQuestion | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "␠\t\x12␝␜G{␄ω%．N;％HｐｄξＺη＾\x0f␆$]\u007fο␘\tπ",
		out:  "‛␠\t\x12␝␜G{␄ω%．N;％HｐｄξＺη＾\x0f␆$]\u007fο␘\tπ",
	}, { // 314
		mask: EncodeQuestion | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   " \n\x12␝␜G{␄ω%．N;％HｐｄξＺη＾\x0f␆$]\u007fο␘\nπ",
		out:  "␠\n\x12␝␜G{␄ω%．N;％HｐｄξＺη＾\x0f␆$]\u007fο␘\nπ",
	}, { // 315
		mask: EncodeQuestion | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "␠\n\x12␝␜G{␄ω%．N;％HｐｄξＺη＾\x0f␆$]\u007fο␘\nπ",
		out:  "‛␠\n\x12␝␜G{␄ω%．N;％HｐｄξＺη＾\x0f␆$]\u007fο␘\nπ",
	}, { // 316
		mask: EncodeQuestion | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   " \v\x12␝␜G{␄ω%．N;％HｐｄξＺη＾\x0f␆$]\u007fο␘\vπ",
		out:  "␠\v\x12␝␜G{␄ω%．N;％HｐｄξＺη＾\x0f␆$]\u007fο␘\vπ",
	}, { // 317
		mask: EncodeQuestion | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "␠\v\x12␝␜G{␄ω%．N;％HｐｄξＺη＾\x0f␆$]\u007fο␘\vπ",
		out:  "‛␠\v\x12␝␜G{␄ω%．N;％HｐｄξＺη＾\x0f␆$]\u007fο␘\vπ",
	}, { // 318
		mask: EncodeQuestion | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   " \r\x12␝␜G{␄ω%．N;％HｐｄξＺη＾\x0f␆$]\u007fο␘\rπ",
		out:  "␠\r\x12␝␜G{␄ω%．N;％HｐｄξＺη＾\x0f␆$]\u007fο␘\rπ",
	}, { // 319
		mask: EncodeQuestion | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "␠\r\x12␝␜G{␄ω%．N;％HｐｄξＺη＾\x0f␆$]\u007fο␘\rπ",
		out:  "‛␠\r\x12␝␜G{␄ω%．N;％HｐｄξＺη＾\x0f␆$]\u007fο␘\rπ",
	}, { // 320
		mask: EncodeQuestion | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "β\t\x12␝␜G{␄ω%．N;％HｐｄξＺη＾\x0f␆$]\u007fο␘\t ",
		out:  "β\t\x12␝␜G{␄ω%．N;％HｐｄξＺη＾\x0f␆$]\u007fο␘\t ",
	}, { // 321
		mask: EncodeQuestion | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "β\t\x12␝␜G{␄ω%．N;％HｐｄξＺη＾\x0f␆$]\u007fο␘\t␠",
		out:  "β\t\x12␝␜G{␄ω%．N;％HｐｄξＺη＾\x0f␆$]\u007fο␘\t␠",
	}, { // 322
		mask: EncodeQuestion | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "β\n\x12␝␜G{␄ω%．N;％HｐｄξＺη＾\x0f␆$]\u007fο␘\n ",
		out:  "β\n\x12␝␜G{␄ω%．N;％HｐｄξＺη＾\x0f␆$]\u007fο␘\n ",
	}, { // 323
		mask: EncodeQuestion | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "β\n\x12␝␜G{␄ω%．N;％HｐｄξＺη＾\x0f␆$]\u007fο␘\n␠",
		out:  "β\n\x12␝␜G{␄ω%．N;％HｐｄξＺη＾\x0f␆$]\u007fο␘\n␠",
	}, { // 324
		mask: EncodeQuestion | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "β\v\x12␝␜G{␄ω%．N;％HｐｄξＺη＾\x0f␆$]\u007fο␘\v ",
		out:  "β\v\x12␝␜G{␄ω%．N;％HｐｄξＺη＾\x0f␆$]\u007fο␘\v ",
	}, { // 325
		mask: EncodeQuestion | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "β\v\x12␝␜G{␄ω%．N;％HｐｄξＺη＾\x0f␆$]\u007fο␘\v␠",
		out:  "β\v\x12␝␜G{␄ω%．N;％HｐｄξＺη＾\x0f␆$]\u007fο␘\v␠",
	}, { // 326
		mask: EncodeQuestion | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "β\r\x12␝␜G{␄ω%．N;％HｐｄξＺη＾\x0f␆$]\u007fο␘\r ",
		out:  "β\r\x12␝␜G{␄ω%．N;％HｐｄξＺη＾\x0f␆$]\u007fο␘\r ",
	}, { // 327
		mask: EncodeQuestion | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "β\r\x12␝␜G{␄ω%．N;％HｐｄξＺη＾\x0f␆$]\u007fο␘\r␠",
		out:  "β\r\x12␝␜G{␄ω%．N;％HｐｄξＺη＾\x0f␆$]\u007fο␘\r␠",
	}, { // 328
		mask: EncodeAsterisk | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   " \tοV(5\x1b＃␋ψ␡␚（W］τς\x1fd．α>ν｜7\r％\x14\t｀",
		out:  "␠\tοV(5\x1b＃␋ψ␡␚（W］τς\x1fd．α>ν｜7\r％\x14\t｀",
	}, { // 329
		mask: EncodeAsterisk | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "␠\tοV(5\x1b＃␋ψ␡␚（W］τς\x1fd．α>ν｜7\r％\x14\t｀",
		out:  "‛␠\tοV(5\x1b＃␋ψ␡␚（W］τς\x1fd．α>ν｜7\r％\x14\t｀",
	}, { // 330
		mask: EncodeAsterisk | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   " \nοV(5\x1b＃␋ψ␡␚（W］τς\x1fd．α>ν｜7\r％\x14\n｀",
		out:  "␠\nοV(5\x1b＃␋ψ␡␚（W］τς\x1fd．α>ν｜7\r％\x14\n｀",
	}, { // 331
		mask: EncodeAsterisk | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "␠\nοV(5\x1b＃␋ψ␡␚（W］τς\x1fd．α>ν｜7\r％\x14\n｀",
		out:  "‛␠\nοV(5\x1b＃␋ψ␡␚（W］τς\x1fd．α>ν｜7\r％\x14\n｀",
	}, { // 332
		mask: EncodeAsterisk | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   " \vοV(5\x1b＃␋ψ␡␚（W］τς\x1fd．α>ν｜7\r％\x14\v｀",
		out:  "␠\vοV(5\x1b＃␋ψ␡␚（W］τς\x1fd．α>ν｜7\r％\x14\v｀",
	}, { // 333
		mask: EncodeAsterisk | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "␠\vοV(5\x1b＃␋ψ␡␚（W］τς\x1fd．α>ν｜7\r％\x14\v｀",
		out:  "‛␠\vοV(5\x1b＃␋ψ␡␚（W］τς\x1fd．α>ν｜7\r％\x14\v｀",
	}, { // 334
		mask: EncodeAsterisk | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   " \rοV(5\x1b＃␋ψ␡␚（W］τς\x1fd．α>ν｜7\r％\x14\r｀",
		out:  "␠\rοV(5\x1b＃␋ψ␡␚（W］τς\x1fd．α>ν｜7\r％\x14\r｀",
	}, { // 335
		mask: EncodeAsterisk | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "␠\rοV(5\x1b＃␋ψ␡␚（W］τς\x1fd．α>ν｜7\r％\x14\r｀",
		out:  "‛␠\rοV(5\x1b＃␋ψ␡␚（W］τς\x1fd．α>ν｜7\r％\x14\r｀",
	}, { // 336
		mask: EncodeAsterisk | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "]\tοV(5\x1b＃␋ψ␡␚（W］τς\x1fd．α>ν｜7\r％\x14\t ",
		out:  "]\tοV(5\x1b＃␋ψ␡␚（W］τς\x1fd．α>ν｜7\r％\x14\t ",
	}, { // 337
		mask: EncodeAsterisk | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "]\tοV(5\x1b＃␋ψ␡␚（W］τς\x1fd．α>ν｜7\r％\x14\t␠",
		out:  "]\tοV(5\x1b＃␋ψ␡␚（W］τς\x1fd．α>ν｜7\r％\x14\t␠",
	}, { // 338
		mask: EncodeAsterisk | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "]\nοV(5\x1b＃␋ψ␡␚（W］τς\x1fd．α>ν｜7\r％\x14\n ",
		out:  "]\nοV(5\x1b＃␋ψ␡␚（W］τς\x1fd．α>ν｜7\r％\x14\n ",
	}, { // 339
		mask: EncodeAsterisk | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "]\nοV(5\x1b＃␋ψ␡␚（W］τς\x1fd．α>ν｜7\r％\x14\n␠",
		out:  "]\nοV(5\x1b＃␋ψ␡␚（W］τς\x1fd．α>ν｜7\r％\x14\n␠",
	}, { // 340
		mask: EncodeAsterisk | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "]\vοV(5\x1b＃␋ψ␡␚（W］τς\x1fd．α>ν｜7\r％\x14\v ",
		out:  "]\vοV(5\x1b＃␋ψ␡␚（W］τς\x1fd．α>ν｜7\r％\x14\v ",
	}, { // 341
		mask: EncodeAsterisk | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "]\vοV(5\x1b＃␋ψ␡␚（W］τς\x1fd．α>ν｜7\r％\x14\v␠",
		out:  "]\vοV(5\x1b＃␋ψ␡␚（W］τς\x1fd．α>ν｜7\r％\x14\v␠",
	}, { // 342
		mask: EncodeAsterisk | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "]\rοV(5\x1b＃␋ψ␡␚（W］τς\x1fd．α>ν｜7\r％\x14\r ",
		out:  "]\rοV(5\x1b＃␋ψ␡␚（W］τς\x1fd．α>ν｜7\r％\x14\r ",
	}, { // 343
		mask: EncodeAsterisk | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "]\rοV(5\x1b＃␋ψ␡␚（W］τς\x1fd．α>ν｜7\r％\x14\r␠",
		out:  "]\rοV(5\x1b＃␋ψ␡␚（W］τς\x1fd．α>ν｜7\r％\x14\r␠",
	}, { // 344
		mask: EncodePipe | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   " \t␔I\x0e\rκ$γ[？J?Ｄ=␕QＵ␂␏ｔ}ηλ｀\bＵｆ\tγ",
		out:  "␠\t␔I\x0e\rκ$γ[？J?Ｄ=␕QＵ␂␏ｔ}ηλ｀\bＵｆ\tγ",
	}, { // 345
		mask: EncodePipe | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "␠\t␔I\x0e\rκ$γ[？J?Ｄ=␕QＵ␂␏ｔ}ηλ｀\bＵｆ\tγ",
		out:  "‛␠\t␔I\x0e\rκ$γ[？J?Ｄ=␕QＵ␂␏ｔ}ηλ｀\bＵｆ\tγ",
	}, { // 346
		mask: EncodePipe | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   " \n␔I\x0e\rκ$γ[？J?Ｄ=␕QＵ␂␏ｔ}ηλ｀\bＵｆ\nγ",
		out:  "␠\n␔I\x0e\rκ$γ[？J?Ｄ=␕QＵ␂␏ｔ}ηλ｀\bＵｆ\nγ",
	}, { // 347
		mask: EncodePipe | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "␠\n␔I\x0e\rκ$γ[？J?Ｄ=␕QＵ␂␏ｔ}ηλ｀\bＵｆ\nγ",
		out:  "‛␠\n␔I\x0e\rκ$γ[？J?Ｄ=␕QＵ␂␏ｔ}ηλ｀\bＵｆ\nγ",
	}, { // 348
		mask: EncodePipe | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   " \v␔I\x0e\rκ$γ[？J?Ｄ=␕QＵ␂␏ｔ}ηλ｀\bＵｆ\vγ",
		out:  "␠\v␔I\x0e\rκ$γ[？J?Ｄ=␕QＵ␂␏ｔ}ηλ｀\bＵｆ\vγ",
	}, { // 349
		mask: EncodePipe | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "␠\v␔I\x0e\rκ$γ[？J?Ｄ=␕QＵ␂␏ｔ}ηλ｀\bＵｆ\vγ",
		out:  "‛␠\v␔I\x0e\rκ$γ[？J?Ｄ=␕QＵ␂␏ｔ}ηλ｀\bＵｆ\vγ",
	}, { // 350
		mask: EncodePipe | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   " \r␔I\x0e\rκ$γ[？J?Ｄ=␕QＵ␂␏ｔ}ηλ｀\bＵｆ\rγ",
		out:  "␠\r␔I\x0e\rκ$γ[？J?Ｄ=␕QＵ␂␏ｔ}ηλ｀\bＵｆ\rγ",
	}, { // 351
		mask: EncodePipe | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "␠\r␔I\x0e\rκ$γ[？J?Ｄ=␕QＵ␂␏ｔ}ηλ｀\bＵｆ\rγ",
		out:  "‛␠\r␔I\x0e\rκ$γ[？J?Ｄ=␕QＵ␂␏ｔ}ηλ｀\bＵｆ\rγ",
	}, { // 352
		mask: EncodePipe | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "\x17\t␔I\x0e\rκ$γ[？J?Ｄ=␕QＵ␂␏ｔ}ηλ｀\bＵｆ\t ",
		out:  "\x17\t␔I\x0e\rκ$γ[？J?Ｄ=␕QＵ␂␏ｔ}ηλ｀\bＵｆ\t ",
	}, { // 353
		mask: EncodePipe | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "\x17\t␔I\x0e\rκ$γ[？J?Ｄ=␕QＵ␂␏ｔ}ηλ｀\bＵｆ\t␠",
		out:  "\x17\t␔I\x0e\rκ$γ[？J?Ｄ=␕QＵ␂␏ｔ}ηλ｀\bＵｆ\t␠",
	}, { // 354
		mask: EncodePipe | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "\x17\n␔I\x0e\rκ$γ[？J?Ｄ=␕QＵ␂␏ｔ}ηλ｀\bＵｆ\n ",
		out:  "\x17\n␔I\x0e\rκ$γ[？J?Ｄ=␕QＵ␂␏ｔ}ηλ｀\bＵｆ\n ",
	}, { // 355
		mask: EncodePipe | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "\x17\n␔I\x0e\rκ$γ[？J?Ｄ=␕QＵ␂␏ｔ}ηλ｀\bＵｆ\n␠",
		out:  "\x17\n␔I\x0e\rκ$γ[？J?Ｄ=␕QＵ␂␏ｔ}ηλ｀\bＵｆ\n␠",
	}, { // 356
		mask: EncodePipe | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "\x17\v␔I\x0e\rκ$γ[？J?Ｄ=␕QＵ␂␏ｔ}ηλ｀\bＵｆ\v ",
		out:  "\x17\v␔I\x0e\rκ$γ[？J?Ｄ=␕QＵ␂␏ｔ}ηλ｀\bＵｆ\v ",
	}, { // 357
		mask: EncodePipe | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "\x17\v␔I\x0e\rκ$γ[？J?Ｄ=␕QＵ␂␏ｔ}ηλ｀\bＵｆ\v␠",
		out:  "\x17\v␔I\x0e\rκ$γ[？J?Ｄ=␕QＵ␂␏ｔ}ηλ｀\bＵｆ\v␠",
	}, { // 358
		mask: EncodePipe | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "\x17\r␔I\x0e\rκ$γ[？J?Ｄ=␕QＵ␂␏ｔ}ηλ｀\bＵｆ\r ",
		out:  "\x17\r␔I\x0e\rκ$γ[？J?Ｄ=␕QＵ␂␏ｔ}ηλ｀\bＵｆ\r ",
	}, { // 359
		mask: EncodePipe | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "\x17\r␔I\x0e\rκ$γ[？J?Ｄ=␕QＵ␂␏ｔ}ηλ｀\bＵｆ\r␠",
		out:  "\x17\r␔I\x0e\rκ$γ[？J?Ｄ=␕QＵ␂␏ｔ}ηλ｀\bＵｆ\r␠",
	}, { // 360
		mask: EncodeHash | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   " \t␝υγφσ？X｀\a\n．5lwｊ\x18ρF｀Ｙ\x1cK␊β\n：\t␕",
		out:  "␠\t␝υγφσ？X｀\a\n．5lwｊ\x18ρF｀Ｙ\x1cK␊β\n：\t␕",
	}, { // 361
		mask: EncodeHash | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "␠\t␝υγφσ？X｀\a\n．5lwｊ\x18ρF｀Ｙ\x1cK␊β\n：\t␕",
		out:  "‛␠\t␝υγφσ？X｀\a\n．5lwｊ\x18ρF｀Ｙ\x1cK␊β\n：\t␕",
	}, { // 362
		mask: EncodeHash | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   " \n␝υγφσ？X｀\a\n．5lwｊ\x18ρF｀Ｙ\x1cK␊β\n：\n␕",
		out:  "␠\n␝υγφσ？X｀\a\n．5lwｊ\x18ρF｀Ｙ\x1cK␊β\n：\n␕",
	}, { // 363
		mask: EncodeHash | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "␠\n␝υγφσ？X｀\a\n．5lwｊ\x18ρF｀Ｙ\x1cK␊β\n：\n␕",
		out:  "‛␠\n␝υγφσ？X｀\a\n．5lwｊ\x18ρF｀Ｙ\x1cK␊β\n：\n␕",
	}, { // 364
		mask: EncodeHash | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   " \v␝υγφσ？X｀\a\n．5lwｊ\x18ρF｀Ｙ\x1cK␊β\n：\v␕",
		out:  "␠\v␝υγφσ？X｀\a\n．5lwｊ\x18ρF｀Ｙ\x1cK␊β\n：\v␕",
	}, { // 365
		mask: EncodeHash | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "␠\v␝υγφσ？X｀\a\n．5lwｊ\x18ρF｀Ｙ\x1cK␊β\n：\v␕",
		out:  "‛␠\v␝υγφσ？X｀\a\n．5lwｊ\x18ρF｀Ｙ\x1cK␊β\n：\v␕",
	}, { // 366
		mask: EncodeHash | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   " \r␝υγφσ？X｀\a\n．5lwｊ\x18ρF｀Ｙ\x1cK␊β\n：\r␕",
		out:  "␠\r␝υγφσ？X｀\a\n．5lwｊ\x18ρF｀Ｙ\x1cK␊β\n：\r␕",
	}, { // 367
		mask: EncodeHash | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "␠\r␝υγφσ？X｀\a\n．5lwｊ\x18ρF｀Ｙ\x1cK␊β\n：\r␕",
		out:  "‛␠\r␝υγφσ？X｀\a\n．5lwｊ\x18ρF｀Ｙ\x1cK␊β\n：\r␕",
	}, { // 368
		mask: EncodeHash | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "\f\t␝υγφσ？X｀\a\n．5lwｊ\x18ρF｀Ｙ\x1cK␊β\n：\t ",
		out:  "\f\t␝υγφσ？X｀\a\n．5lwｊ\x18ρF｀Ｙ\x1cK␊β\n：\t ",
	}, { // 369
		mask: EncodeHash | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "\f\t␝υγφσ？X｀\a\n．5lwｊ\x18ρF｀Ｙ\x1cK␊β\n：\t␠",
		out:  "\f\t␝υγφσ？X｀\a\n．5lwｊ\x18ρF｀Ｙ\x1cK␊β\n：\t␠",
	}, { // 370
		mask: EncodeHash | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "\f\n␝υγφσ？X｀\a\n．5lwｊ\x18ρF｀Ｙ\x1cK␊β\n：\n ",
		out:  "\f\n␝υγφσ？X｀\a\n．5lwｊ\x18ρF｀Ｙ\x1cK␊β\n：\n ",
	}, { // 371
		mask: EncodeHash | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "\f\n␝υγφσ？X｀\a\n．5lwｊ\x18ρF｀Ｙ\x1cK␊β\n：\n␠",
		out:  "\f\n␝υγφσ？X｀\a\n．5lwｊ\x18ρF｀Ｙ\x1cK␊β\n：\n␠",
	}, { // 372
		mask: EncodeHash | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "\f\v␝υγφσ？X｀\a\n．5lwｊ\x18ρF｀Ｙ\x1cK␊β\n：\v ",
		out:  "\f\v␝υγφσ？X｀\a\n．5lwｊ\x18ρF｀Ｙ\x1cK␊β\n：\v ",
	}, { // 373
		mask: EncodeHash | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "\f\v␝υγφσ？X｀\a\n．5lwｊ\x18ρF｀Ｙ\x1cK␊β\n：\v␠",
		out:  "\f\v␝υγφσ？X｀\a\n．5lwｊ\x18ρF｀Ｙ\x1cK␊β\n：\v␠",
	}, { // 374
		mask: EncodeHash | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "\f\r␝υγφσ？X｀\a\n．5lwｊ\x18ρF｀Ｙ\x1cK␊β\n：\r ",
		out:  "\f\r␝υγφσ？X｀\a\n．5lwｊ\x18ρF｀Ｙ\x1cK␊β\n：\r ",
	}, { // 375
		mask: EncodeHash | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "\f\r␝υγφσ？X｀\a\n．5lwｊ\x18ρF｀Ｙ\x1cK␊β\n：\r␠",
		out:  "\f\r␝υγφσ？X｀\a\n．5lwｊ\x18ρF｀Ｙ\x1cK␊β\n：\r␠",
	}, { // 376
		mask: EncodePercent | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   " \tψπ␔$＂␟｜\rＳ[o*+gπ：＞5ｘνο：υ{␉\r\tk",
		out:  "␠\tψπ␔$＂␟｜\rＳ[o*+gπ：＞5ｘνο：υ{␉\r\tk",
	}, { // 377
		mask: EncodePercent | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "␠\tψπ␔$＂␟｜\rＳ[o*+gπ：＞5ｘνο：υ{␉\r\tk",
		out:  "‛␠\tψπ␔$＂␟｜\rＳ[o*+gπ：＞5ｘνο：υ{␉\r\tk",
	}, { // 378
		mask: EncodePercent | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   " \nψπ␔$＂␟｜\rＳ[o*+gπ：＞5ｘνο：υ{␉\r\nk",
		out:  "␠\nψπ␔$＂␟｜\rＳ[o*+gπ：＞5ｘνο：υ{␉\r\nk",
	}, { // 379
		mask: EncodePercent | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "␠\nψπ␔$＂␟｜\rＳ[o*+gπ：＞5ｘνο：υ{␉\r\nk",
		out:  "‛␠\nψπ␔$＂␟｜\rＳ[o*+gπ：＞5ｘνο：υ{␉\r\nk",
	}, { // 380
		mask: EncodePercent | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   " \vψπ␔$＂␟｜\rＳ[o*+gπ：＞5ｘνο：υ{␉\r\vk",
		out:  "␠\vψπ␔$＂␟｜\rＳ[o*+gπ：＞5ｘνο：υ{␉\r\vk",
	}, { // 381
		mask: EncodePercent | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "␠\vψπ␔$＂␟｜\rＳ[o*+gπ：＞5ｘνο：υ{␉\r\vk",
		out:  "‛␠\vψπ␔$＂␟｜\rＳ[o*+gπ：＞5ｘνο：υ{␉\r\vk",
	}, { // 382
		mask: EncodePercent | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   " \rψπ␔$＂␟｜\rＳ[o*+gπ：＞5ｘνο：υ{␉\r\rk",
		out:  "␠\rψπ␔$＂␟｜\rＳ[o*+gπ：＞5ｘνο：υ{␉\r\rk",
	}, { // 383
		mask: EncodePercent | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "␠\rψπ␔$＂␟｜\rＳ[o*+gπ：＞5ｘνο：υ{␉\r\rk",
		out:  "‛␠\rψπ␔$＂␟｜\rＳ[o*+gπ：＞5ｘνο：υ{␉\r\rk",
	}, { // 384
		mask: EncodePercent | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "４\tψπ␔$＂␟｜\rＳ[o*+gπ：＞5ｘνο：υ{␉\r\t ",
		out:  "４\tψπ␔$＂␟｜\rＳ[o*+gπ：＞5ｘνο：υ{␉\r\t ",
	}, { // 385
		mask: EncodePercent | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "４\tψπ␔$＂␟｜\rＳ[o*+gπ：＞5ｘνο：υ{␉\r\t␠",
		out:  "４\tψπ␔$＂␟｜\rＳ[o*+gπ：＞5ｘνο：υ{␉\r\t␠",
	}, { // 386
		mask: EncodePercent | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "４\nψπ␔$＂␟｜\rＳ[o*+gπ：＞5ｘνο：υ{␉\r\n ",
		out:  "４\nψπ␔$＂␟｜\rＳ[o*+gπ：＞5ｘνο：υ{␉\r\n ",
	}, { // 387
		mask: EncodePercent | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "４\nψπ␔$＂␟｜\rＳ[o*+gπ：＞5ｘνο：υ{␉\r\n␠",
		out:  "４\nψπ␔$＂␟｜\rＳ[o*+gπ：＞5ｘνο：υ{␉\r\n␠",
	}, { // 388
		mask: EncodePercent | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "４\vψπ␔$＂␟｜\rＳ[o*+gπ：＞5ｘνο：υ{␉\r\v ",
		out:  "４\vψπ␔$＂␟｜\rＳ[o*+gπ：＞5ｘνο：υ{␉\r\v ",
	}, { // 389
		mask: EncodePercent | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "４\vψπ␔$＂␟｜\rＳ[o*+gπ：＞5ｘνο：υ{␉\r\v␠",
		out:  "４\vψπ␔$＂␟｜\rＳ[o*+gπ：＞5ｘνο：υ{␉\r\v␠",
	}, { // 390
		mask: EncodePercent | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "４\rψπ␔$＂␟｜\rＳ[o*+gπ：＞5ｘνο：υ{␉\r\r ",
		out:  "４\rψπ␔$＂␟｜\rＳ[o*+gπ：＞5ｘνο：υ{␉\r\r ",
	}, { // 391
		mask: EncodePercent | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "４\rψπ␔$＂␟｜\rＳ[o*+gπ：＞5ｘνο：υ{␉\r\r␠",
		out:  "４\rψπ␔$＂␟｜\rＳ[o*+gπ：＞5ｘνο：υ{␉\r\r␠",
	}, { // 392
		mask: EncodeBackSlash | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   " \t␔ｇ9\x1a;\x02␖ηω，␀3μ␊:：ε\nζｅνMc[NＱ\t：",
		out:  "␠\t␔ｇ9\x1a;\x02␖ηω，‛␀3μ␊:：ε\nζｅνMc[NＱ\t：",
	}, { // 393
		mask: EncodeBackSlash | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "␠\t␔ｇ9\x1a;\x02␖ηω，␀3μ␊:：ε\nζｅνMc[NＱ\t：",
		out:  "‛␠\t␔ｇ9\x1a;\x02␖ηω，‛␀3μ␊:：ε\nζｅνMc[NＱ\t：",
	}, { // 394
		mask: EncodeBackSlash | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   " \n␔ｇ9\x1a;\x02␖ηω，␀3μ␊:：ε\nζｅνMc[NＱ\n：",
		out:  "␠\n␔ｇ9\x1a;\x02␖ηω，‛␀3μ␊:：ε\nζｅνMc[NＱ\n：",
	}, { // 395
		mask: EncodeBackSlash | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "␠\n␔ｇ9\x1a;\x02␖ηω，␀3μ␊:：ε\nζｅνMc[NＱ\n：",
		out:  "‛␠\n␔ｇ9\x1a;\x02␖ηω，‛␀3μ␊:：ε\nζｅνMc[NＱ\n：",
	}, { // 396
		mask: EncodeBackSlash | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   " \v␔ｇ9\x1a;\x02␖ηω，␀3μ␊:：ε\nζｅνMc[NＱ\v：",
		out:  "␠\v␔ｇ9\x1a;\x02␖ηω，‛␀3μ␊:：ε\nζｅνMc[NＱ\v：",
	}, { // 397
		mask: EncodeBackSlash | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "␠\v␔ｇ9\x1a;\x02␖ηω，␀3μ␊:：ε\nζｅνMc[NＱ\v：",
		out:  "‛␠\v␔ｇ9\x1a;\x02␖ηω，‛␀3μ␊:：ε\nζｅνMc[NＱ\v：",
	}, { // 398
		mask: EncodeBackSlash | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   " \r␔ｇ9\x1a;\x02␖ηω，␀3μ␊:：ε\nζｅνMc[NＱ\r：",
		out:  "␠\r␔ｇ9\x1a;\x02␖ηω，‛␀3μ␊:：ε\nζｅνMc[NＱ\r：",
	}, { // 399
		mask: EncodeBackSlash | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "␠\r␔ｇ9\x1a;\x02␖ηω，␀3μ␊:：ε\nζｅνMc[NＱ\r：",
		out:  "‛␠\r␔ｇ9\x1a;\x02␖ηω，‛␀3μ␊:：ε\nζｅνMc[NＱ\r：",
	}, { // 400
		mask: EncodeBackSlash | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "/\t␔ｇ9\x1a;\x02␖ηω，␀3μ␊:：ε\nζｅνMc[NＱ\t ",
		out:  "/\t␔ｇ9\x1a;\x02␖ηω，‛␀3μ␊:：ε\nζｅνMc[NＱ\t ",
	}, { // 401
		mask: EncodeBackSlash | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "/\t␔ｇ9\x1a;\x02␖ηω，␀3μ␊:：ε\nζｅνMc[NＱ\t␠",
		out:  "/\t␔ｇ9\x1a;\x02␖ηω，‛␀3μ␊:：ε\nζｅνMc[NＱ\t␠",
	}, { // 402
		mask: EncodeBackSlash | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "/\n␔ｇ9\x1a;\x02␖ηω，␀3μ␊:：ε\nζｅνMc[NＱ\n ",
		out:  "/\n␔ｇ9\x1a;\x02␖ηω，‛␀3μ␊:：ε\nζｅνMc[NＱ\n ",
	}, { // 403
		mask: EncodeBackSlash | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "/\n␔ｇ9\x1a;\x02␖ηω，␀3μ␊:：ε\nζｅνMc[NＱ\n␠",
		out:  "/\n␔ｇ9\x1a;\x02␖ηω，‛␀3μ␊:：ε\nζｅνMc[NＱ\n␠",
	}, { // 404
		mask: EncodeBackSlash | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "/\v␔ｇ9\x1a;\x02␖ηω，␀3μ␊:：ε\nζｅνMc[NＱ\v ",
		out:  "/\v␔ｇ9\x1a;\x02␖ηω，‛␀3μ␊:：ε\nζｅνMc[NＱ\v ",
	}, { // 405
		mask: EncodeBackSlash | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "/\v␔ｇ9\x1a;\x02␖ηω，␀3μ␊:：ε\nζｅνMc[NＱ\v␠",
		out:  "/\v␔ｇ9\x1a;\x02␖ηω，‛␀3μ␊:：ε\nζｅνMc[NＱ\v␠",
	}, { // 406
		mask: EncodeBackSlash | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "/\r␔ｇ9\x1a;\x02␖ηω，␀3μ␊:：ε\nζｅνMc[NＱ\r ",
		out:  "/\r␔ｇ9\x1a;\x02␖ηω，‛␀3μ␊:：ε\nζｅνMc[NＱ\r ",
	}, { // 407
		mask: EncodeBackSlash | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "/\r␔ｇ9\x1a;\x02␖ηω，␀3μ␊:：ε\nζｅνMc[NＱ\r␠",
		out:  "/\r␔ｇ9\x1a;\x02␖ηω，‛␀3μ␊:：ε\nζｅνMc[NＱ\r␠",
	}, { // 408
		mask: EncodeDel | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   " \t␔θf␙R？:ａ/ε｀２␏\x1eδυ@ςＮ8\"␏２δ\"｜\t5",
		out:  "␠\t␔θf␙R？:ａ/ε｀２␏\x1eδυ@ςＮ8\"␏２δ\"｜\t5",
	}, { // 409
		mask: EncodeDel | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "␠\t␔θf␙R？:ａ/ε｀２␏\x1eδυ@ςＮ8\"␏２δ\"｜\t5",
		out:  "‛␠\t␔θf␙R？:ａ/ε｀２␏\x1eδυ@ςＮ8\"␏２δ\"｜\t5",
	}, { // 410
		mask: EncodeDel | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   " \n␔θf␙R？:ａ/ε｀２␏\x1eδυ@ςＮ8\"␏２δ\"｜\n5",
		out:  "␠\n␔θf␙R？:ａ/ε｀２␏\x1eδυ@ςＮ8\"␏２δ\"｜\n5",
	}, { // 411
		mask: EncodeDel | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "␠\n␔θf␙R？:ａ/ε｀２␏\x1eδυ@ςＮ8\"␏２δ\"｜\n5",
		out:  "‛␠\n␔θf␙R？:ａ/ε｀２␏\x1eδυ@ςＮ8\"␏２δ\"｜\n5",
	}, { // 412
		mask: EncodeDel | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   " \v␔θf␙R？:ａ/ε｀２␏\x1eδυ@ςＮ8\"␏２δ\"｜\v5",
		out:  "␠\v␔θf␙R？:ａ/ε｀２␏\x1eδυ@ςＮ8\"␏２δ\"｜\v5",
	}, { // 413
		mask: EncodeDel | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "␠\v␔θf␙R？:ａ/ε｀２␏\x1eδυ@ςＮ8\"␏２δ\"｜\v5",
		out:  "‛␠\v␔θf␙R？:ａ/ε｀２␏\x1eδυ@ςＮ8\"␏２δ\"｜\v5",
	}, { // 414
		mask: EncodeDel | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   " \r␔θf␙R？:ａ/ε｀２␏\x1eδυ@ςＮ8\"␏２δ\"｜\r5",
		out:  "␠\r␔θf␙R？:ａ/ε｀２␏\x1eδυ@ςＮ8\"␏２δ\"｜\r5",
	}, { // 415
		mask: EncodeDel | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "␠\r␔θf␙R？:ａ/ε｀２␏\x1eδυ@ςＮ8\"␏２δ\"｜\r5",
		out:  "‛␠\r␔θf␙R？:ａ/ε｀２␏\x1eδυ@ςＮ8\"␏２δ\"｜\r5",
	}, { // 416
		mask: EncodeDel | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "\x01\t␔θf␙R？:ａ/ε｀２␏\x1eδυ@ςＮ8\"␏２δ\"｜\t ",
		out:  "\x01\t␔θf␙R？:ａ/ε｀２␏\x1eδυ@ςＮ8\"␏２δ\"｜\t ",
	}, { // 417
		mask: EncodeDel | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "\x01\t␔θf␙R？:ａ/ε｀２␏\x1eδυ@ςＮ8\"␏２δ\"｜\t␠",
		out:  "\x01\t␔θf␙R？:ａ/ε｀２␏\x1eδυ@ςＮ8\"␏２δ\"｜\t␠",
	}, { // 418
		mask: EncodeDel | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "\x01\n␔θf␙R？:ａ/ε｀２␏\x1eδυ@ςＮ8\"␏２δ\"｜\n ",
		out:  "\x01\n␔θf␙R？:ａ/ε｀２␏\x1eδυ@ςＮ8\"␏２δ\"｜\n ",
	}, { // 419
		mask: EncodeDel | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "\x01\n␔θf␙R？:ａ/ε｀２␏\x1eδυ@ςＮ8\"␏２δ\"｜\n␠",
		out:  "\x01\n␔θf␙R？:ａ/ε｀２␏\x1eδυ@ςＮ8\"␏２δ\"｜\n␠",
	}, { // 420
		mask: EncodeDel | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "\x01\v␔θf␙R？:ａ/ε｀２␏\x1eδυ@ςＮ8\"␏２δ\"｜\v ",
		out:  "\x01\v␔θf␙R？:ａ/ε｀２␏\x1eδυ@ςＮ8\"␏２δ\"｜\v ",
	}, { // 421
		mask: EncodeDel | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "\x01\v␔θf␙R？:ａ/ε｀２␏\x1eδυ@ςＮ8\"␏２δ\"｜\v␠",
		out:  "\x01\v␔θf␙R？:ａ/ε｀２␏\x1eδυ@ςＮ8\"␏２δ\"｜\v␠",
	}, { // 422
		mask: EncodeDel | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "\x01\r␔θf␙R？:ａ/ε｀２␏\x1eδυ@ςＮ8\"␏２δ\"｜\r ",
		out:  "\x01\r␔θf␙R？:ａ/ε｀２␏\x1eδυ@ςＮ8\"␏２δ\"｜\r ",
	}, { // 423
		mask: EncodeDel | EncodeLeftSpace | EncodeLeftCrLfHtVt,
		in:   "\x01\r␔θf␙R？:ａ/ε｀２␏\x1eδυ@ςＮ8\"␏２δ\"｜\r␠",
		out:  "\x01\r␔θf␙R？:ａ/ε｀２␏\x1eδυ@ςＮ8\"␏２δ\"｜\r␠",
	}, { // 424
		mask: EncodeZero | EncodeLeftSpace | EncodeRightSpace,
		in:   "  \nχ＄SＺWα\x1c\x1d＂τ＠７＠αe␚ＭL\x138*␐７\b␍ δ",
		out:  "␠ \nχ＄SＺWα\x1c\x1d＂τ＠７＠αe␚ＭL\x138*␐７\b␍ δ",
	}, { // 425
		mask: EncodeZero | EncodeLeftSpace | EncodeRightSpace,
		in:   "␠ \nχ＄SＺWα\x1c\x1d＂τ＠７＠αe␚ＭL\x138*␐７\b␍ δ",
		out:  "‛␠ \nχ＄SＺWα\x1c\x1d＂τ＠７＠αe␚ＭL\x138*␐７\b␍ δ",
	}, { // 426
		mask: EncodeZero | EncodeLeftSpace | EncodeRightSpace,
		in:   "␜ \nχ＄SＺWα\x1c\x1d＂τ＠７＠αe␚ＭL\x138*␐７\b␍  ",
		out:  "␜ \nχ＄SＺWα\x1c\x1d＂τ＠７＠αe␚ＭL\x138*␐７\b␍ ␠",
	}, { // 427
		mask: EncodeZero | EncodeLeftSpace | EncodeRightSpace,
		in:   "␜ \nχ＄SＺWα\x1c\x1d＂τ＠７＠αe␚ＭL\x138*␐７\b␍ ␠",
		out:  "␜ \nχ＄SＺWα\x1c\x1d＂τ＠７＠αe␚ＭL\x138*␐７\b␍ ‛␠",
	}, { // 428
		mask: EncodeSlash | EncodeLeftSpace | EncodeRightSpace,
		in:   "  σＬ\x10␊]φ］｝\x1c␛\x04４％κ'\x06？-a：ｊqaχ＿` θ",
		out:  "␠ σＬ\x10␊]φ］｝\x1c␛\x04４％κ'\x06？-a：ｊqaχ＿` θ",
	}, { // 429
		mask: EncodeSlash | EncodeLeftSpace | EncodeRightSpace,
		in:   "␠ σＬ\x10␊]φ］｝\x1c␛\x04４％κ'\x06？-a：ｊqaχ＿` θ",
		out:  "‛␠ σＬ\x10␊]φ］｝\x1c␛\x04４％κ'\x06？-a：ｊqaχ＿` θ",
	}, { // 430
		mask: EncodeSlash | EncodeLeftSpace | EncodeRightSpace,
		in:   "ζ σＬ\x10␊]φ］｝\x1c␛\x04４％κ'\x06？-a：ｊqaχ＿`  ",
		out:  "ζ σＬ\x10␊]φ］｝\x1c␛\x04４％κ'\x06？-a：ｊqaχ＿` ␠",
	}, { // 431
		mask: EncodeSlash | EncodeLeftSpace | EncodeRightSpace,
		in:   "ζ σＬ\x10␊]φ］｝\x1c␛\x04４％κ'\x06？-a：ｊqaχ＿` ␠",
		out:  "ζ σＬ\x10␊]φ］｝\x1c␛\x04４％κ'\x06？-a：ｊqaχ＿` ‛␠",
	}, { // 432
		mask: EncodeSingleQuote | EncodeLeftSpace | EncodeRightSpace,
		in:   "  Ｄ8␞＃\x12)ν\a\x02］λＦυ␓＇μωＥ␟/\x1d@r␊Kσ !",
		out:  "␠ Ｄ8␞＃\x12)ν\a\x02］λＦυ␓‛＇μωＥ␟/\x1d@r␊Kσ !",
	}, { // 433
		mask: EncodeSingleQuote | EncodeLeftSpace | EncodeRightSpace,
		in:   "␠ Ｄ8␞＃\x12)ν\a\x02］λＦυ␓＇μωＥ␟/\x1d@r␊Kσ !",
		out:  "‛␠ Ｄ8␞＃\x12)ν\a\x02］λＦυ␓‛＇μωＥ␟/\x1d@r␊Kσ !",
	}, { // 434
		mask: EncodeSingleQuote | EncodeLeftSpace | EncodeRightSpace,
		in:   "／ Ｄ8␞＃\x12)ν\a\x02］λＦυ␓＇μωＥ␟/\x1d@r␊Kσ  ",
		out:  "／ Ｄ8␞＃\x12)ν\a\x02］λＦυ␓‛＇μωＥ␟/\x1d@r␊Kσ ␠",
	}, { // 435
		mask: EncodeSingleQuote | EncodeLeftSpace | EncodeRightSpace,
		in:   "／ Ｄ8␞＃\x12)ν\a\x02］λＦυ␓＇μωＥ␟/\x1d@r␊Kσ ␠",
		out:  "／ Ｄ8␞＃\x12)ν\a\x02］λＦυ␓‛＇μωＥ␟/\x1d@r␊Kσ ‛␠",
	}, { // 436
		mask: EncodeBackQuote | EncodeLeftSpace | EncodeRightSpace,
		in:   "  yλη／\x12\n␛＄\uff00Ｌλ␕\x12␛$Ｃ:'.υ３τjρ\x01g ␋",
		out:  "␠ yλη／\x12\n␛＄\uff00Ｌλ␕\x12␛$Ｃ:'.υ３τjρ\x01g ␋",
	}, { // 437
		mask: EncodeBackQuote | EncodeLeftSpace | EncodeRightSpace,
		in:   "␠ yλη／\x12\n␛＄\uff00Ｌλ␕\x12␛$Ｃ:'.υ３τjρ\x01g ␋",
		out:  "‛␠ yλη／\x12\n␛＄\uff00Ｌλ␕\x12␛$Ｃ:'.υ３τjρ\x01g ␋",
	}, { // 438
		mask: EncodeBackQuote | EncodeLeftSpace | EncodeRightSpace,
		in:   "␀ yλη／\x12\n␛＄\uff00Ｌλ␕\x12␛$Ｃ:'.υ３τjρ\x01g  ",
		out:  "‛␀ yλη／\x12\n␛＄\uff00Ｌλ␕\x12␛$Ｃ:'.υ３τjρ\x01g ␠",
	}, { // 439
		mask: EncodeBackQuote | EncodeLeftSpace | EncodeRightSpace,
		in:   "␀ yλη／\x12\n␛＄\uff00Ｌλ␕\x12␛$Ｃ:'.υ３τjρ\x01g ␠",
		out:  "‛␀ yλη／\x12\n␛＄\uff00Ｌλ␕\x12␛$Ｃ:'.υ３τjρ\x01g ‛␠",
	}, { // 440
		mask: EncodeLtGt | EncodeLeftSpace | EncodeRightSpace,
		in:   "  ＊o;ςν＼ηＢ␅`\u007f｀>␅#Y：[＝πω␉Ｒnι\r ；",
		out:  "␠ ＊o;ςν＼ηＢ␅`\u007f｀＞␅#Y：[＝πω␉Ｒnι\r ；",
	}, { // 441
		mask: EncodeLtGt | EncodeLeftSpace | EncodeRightSpace,
		in:   "␠ ＊o;ςν＼ηＢ␅`\u007f｀>␅#Y：[＝πω␉Ｒnι\r ；",
		out:  "‛␠ ＊o;ςν＼ηＢ␅`\u007f｀＞␅#Y：[＝πω␉Ｒnι\r ；",
	}, { // 442
		mask: EncodeLtGt | EncodeLeftSpace | EncodeRightSpace,
		in:   "9 ＊o;ςν＼ηＢ␅`\u007f｀>␅#Y：[＝πω␉Ｒnι\r  ",
		out:  "9 ＊o;ςν＼ηＢ␅`\u007f｀＞␅#Y：[＝πω␉Ｒnι\r ␠",
	}, { // 443
		mask: EncodeLtGt | EncodeLeftSpace | EncodeRightSpace,
		in:   "9 ＊o;ςν＼ηＢ␅`\u007f｀>␅#Y：[＝πω␉Ｒnι\r ␠",
		out:  "9 ＊o;ςν＼ηＢ␅`\u007f｀＞␅#Y：[＝πω␉Ｒnι\r ‛␠",
	}, { // 444
		mask: EncodeSquareBracket | EncodeLeftSpace | EncodeRightSpace,
		in:   "  π␊k`＇&η｜τ*#ｖ\"q␄５r`\x06␟γ␖θ␜]φ \x1f",
		out:  "␠ π␊k`＇&η｜τ*#ｖ\"q␄５r`\x06␟γ␖θ␜］φ \x1f",
	}, { // 445
		mask: EncodeSquareBracket | EncodeLeftSpace | EncodeRightSpace,
		in:   "␠ π␊k`＇&η｜τ*#ｖ\"q␄５r`\x06␟γ␖θ␜]φ \x1f",
		out:  "‛␠ π␊k`＇&η｜τ*#ｖ\"q␄５r`\x06␟γ␖θ␜］φ \x1f",
	}, { // 446
		mask: EncodeSquareBracket | EncodeLeftSpace | EncodeRightSpace,
		in:   "Ｃ π␊k`＇&η｜τ*#ｖ\"q␄５r`\x06␟γ␖θ␜]φ  ",
		out:  "Ｃ π␊k`＇&η｜τ*#ｖ\"q␄５r`\x06␟γ␖θ␜］φ ␠",
	}, { // 447
		mask: EncodeSquareBracket | EncodeLeftSpace | EncodeRightSpace,
		in:   "Ｃ π␊k`＇&η｜τ*#ｖ\"q␄５r`\x06␟γ␖θ␜]φ ␠",
		out:  "Ｃ π␊k`＇&η｜τ*#ｖ\"q␄５r`\x06␟γ␖θ␜］φ ‛␠",
	}, { // 448
		mask: EncodeSemicolon | EncodeLeftSpace | EncodeRightSpace,
		in:   "  οH\x16}'ηα␀␍Ｃ␍｛πmＹωＰ／␊｛A\n\\ｑ\x19q `",
		out:  "␠ οH\x16}'ηα‛␀␍Ｃ␍｛πmＹωＰ／␊｛A\n\\ｑ\x19q `",
	}, { // 449
		mask: EncodeSemicolon | EncodeLeftSpace | EncodeRightSpace,
		in:   "␠ οH\x16}'ηα␀␍Ｃ␍｛πmＹωＰ／␊｛A\n\\ｑ\x19q `",
		out:  "‛␠ οH\x16}'ηα‛␀␍Ｃ␍｛πmＹωＰ／␊｛A\n\\ｑ\x19q `",
	}, { // 450
		mask: EncodeSemicolon | EncodeLeftSpace | EncodeRightSpace,
		in:   "␘ οH\x16}'ηα␀␍Ｃ␍｛πmＹωＰ／␊｛A\n\\ｑ\x19q  ",
		out:  "␘ οH\x16}'ηα‛␀␍Ｃ␍｛πmＹωＰ／␊｛A\n\\ｑ\x19q ␠",
	}, { // 451
		mask: EncodeSemicolon | EncodeLeftSpace | EncodeRightSpace,
		in:   "␘ οH\x16}'ηα␀␍Ｃ␍｛πmＹωＰ／␊｛A\n\\ｑ\x19q ␠",
		out:  "␘ οH\x16}'ηα‛␀␍Ｃ␍｛πmＹωＰ／␊｛A\n\\ｑ\x19q ‛␠",
	}, { // 452
		mask: EncodeDollar | EncodeLeftSpace | EncodeRightSpace,
		in:   "  ζ＃＼␄\x12＞&\x11z␓ｎπ>λητＡ8\x14u␂－ｗcυｐ @",
		out:  "␠ ζ＃＼␄\x12＞&\x11z␓ｎπ>λητＡ8\x14u␂－ｗcυｐ @",
	}, { // 453
		mask: EncodeDollar | EncodeLeftSpace | EncodeRightSpace,
		in:   "␠ ζ＃＼␄\x12＞&\x11z␓ｎπ>λητＡ8\x14u␂－ｗcυｐ @",
		out:  "‛␠ ζ＃＼␄\x12＞&\x11z␓ｎπ>λητＡ8\x14u␂－ｗcυｐ @",
	}, { // 454
		mask: EncodeDollar | EncodeLeftSpace | EncodeRightSpace,
		in:   "\x16 ζ＃＼␄\x12＞&\x11z␓ｎπ>λητＡ8\x14u␂－ｗcυｐ  ",
		out:  "\x16 ζ＃＼␄\x12＞&\x11z␓ｎπ>λητＡ8\x14u␂－ｗcυｐ ␠",
	}, { // 455
		mask: EncodeDollar | EncodeLeftSpace | EncodeRightSpace,
		in:   "\x16 ζ＃＼␄\x12＞&\x11z␓ｎπ>λητＡ8\x14u␂－ｗcυｐ ␠",
		out:  "\x16 ζ＃＼␄\x12＞&\x11z␓ｎπ>λητＡ8\x14u␂－ｗcυｐ ‛␠",
	}, { // 456
		mask: EncodeDoubleQuote | EncodeLeftSpace | EncodeRightSpace,
		in:   "  _␏Aｉb\x02＼\x18ｐｑξ]；χα␌>\\λ␏␛＊：\x1714 6",
		out:  "␠ _␏Aｉb\x02＼\x18ｐｑξ]；χα␌>\\λ␏␛＊：\x1714 6",
	}, { // 457
		mask: EncodeDoubleQuote | EncodeLeftSpace | EncodeRightSpace,
		in:   "␠ _␏Aｉb\x02＼\x18ｐｑξ]；χα␌>\\λ␏␛＊：\x1714 6",
		out:  "‛␠ _␏Aｉb\x02＼\x18ｐｑξ]；χα␌>\\λ␏␛＊：\x1714 6",
	}, { // 458
		mask: EncodeDoubleQuote | EncodeLeftSpace | EncodeRightSpace,
		in:   "ｋ _␏Aｉb\x02＼\x18ｐｑξ]；χα␌>\\λ␏␛＊：\x1714  ",
		out:  "ｋ _␏Aｉb\x02＼\x18ｐｑξ]；χα␌>\\λ␏␛＊：\x1714 ␠",
	}, { // 459
		mask: EncodeDoubleQuote | EncodeLeftSpace | EncodeRightSpace,
		in:   "ｋ _␏Aｉb\x02＼\x18ｐｑξ]；χα␌>\\λ␏␛＊：\x1714 ␠",
		out:  "ｋ _␏Aｉb\x02＼\x18ｐｑξ]；χα␌>\\λ␏␛＊：\x1714 ‛␠",
	}, { // 460
		mask: EncodeColon | EncodeLeftSpace | EncodeRightSpace,
		in:   "  \x10｛␒＞｛<σ3␜４ｑ|␗␈Iιλp\n；\x1eνμε␍* P",
		out:  "␠ \x10｛␒＞｛<σ3␜４ｑ|␗␈Iιλp\n；\x1eνμε␍* P",
	}, { // 461
		mask: EncodeColon | EncodeLeftSpace | EncodeRightSpace,
		in:   "␠ \x10｛␒＞｛<σ3␜４ｑ|␗␈Iιλp\n；\x1eνμε␍* P",
		out:  "‛␠ \x10｛␒＞｛<σ3␜４ｑ|␗␈Iιλp\n；\x1eνμε␍* P",
	}, { // 462
		mask: EncodeColon | EncodeLeftSpace | EncodeRightSpace,
		in:   "\x1c \x10｛␒＞｛<σ3␜４ｑ|␗␈Iιλp\n；\x1eνμε␍*  ",
		out:  "\x1c \x10｛␒＞｛<σ3␜４ｑ|␗␈Iιλp\n；\x1eνμε␍* ␠",
	}, { // 463
		mask: EncodeColon | EncodeLeftSpace | EncodeRightSpace,
		in:   "\x1c \x10｛␒＞｛<σ3␜４ｑ|␗␈Iιλp\n；\x1eνμε␍* ␠",
		out:  "\x1c \x10｛␒＞｛<σ3␜４ｑ|␗␈Iιλp\n；\x1eνμε␍* ‛␠",
	}, { // 464
		mask: EncodeQuestion | EncodeLeftSpace | EncodeRightSpace,
		in:   "  <＜κλ\rｑF＇\x16,＄#<ζ␊\x11D＄␌␊ＱυＢ］\"θ !",
		out:  "␠ <＜κλ\rｑF＇\x16,＄#<ζ␊\x11D＄␌␊ＱυＢ］\"θ !",
	}, { // 465
		mask: EncodeQuestion | EncodeLeftSpace | EncodeRightSpace,
		in:   "␠ <＜κλ\rｑF＇\x16,＄#<ζ␊\x11D＄␌␊ＱυＢ］\"θ !",
		out:  "‛␠ <＜κλ\rｑF＇\x16,＄#<ζ␊\x11D＄␌␊ＱυＢ］\"θ !",
	}, { // 466
		mask: EncodeQuestion | EncodeLeftSpace | EncodeRightSpace,
		in:   "Ｐ <＜κλ\rｑF＇\x16,＄#<ζ␊\x11D＄␌␊ＱυＢ］\"θ  ",
		out:  "Ｐ <＜κλ\rｑF＇\x16,＄#<ζ␊\x11D＄␌␊ＱυＢ］\"θ ␠",
	}, { // 467
		mask: EncodeQuestion | EncodeLeftSpace | EncodeRightSpace,
		in:   "Ｐ <＜κλ\rｑF＇\x16,＄#<ζ␊\x11D＄␌␊ＱυＢ］\"θ ␠",
		out:  "Ｐ <＜κλ\rｑF＇\x16,＄#<ζ␊\x11D＄␌␊ＱυＢ］\"θ ‛␠",
	}, { // 468
		mask: EncodeAsterisk | EncodeLeftSpace | EncodeRightSpace,
		in:   "  ｑx\x11＞\r８\x15ρ|ψ\\Ｚηtφ␕ｙ␃I'%μ４＜Ｕ3 ＊",
		out:  "␠ ｑx\x11＞\r８\x15ρ|ψ\\Ｚηtφ␕ｙ␃I'%μ４＜Ｕ3 ‛＊",
	}, { // 469
		mask: EncodeAsterisk | EncodeLeftSpace | EncodeRightSpace,
		in:   "␠ ｑx\x11＞\r８\x15ρ|ψ\\Ｚηtφ␕ｙ␃I'%μ４＜Ｕ3 ＊",
		out:  "‛␠ ｑx\x11＞\r８\x15ρ|ψ\\Ｚηtφ␕ｙ␃I'%μ４＜Ｕ3 ‛＊",
	}, { // 470
		mask: EncodeAsterisk | EncodeLeftSpace | EncodeRightSpace,
		in:   "␞ ｑx\x11＞\r８\x15ρ|ψ\\Ｚηtφ␕ｙ␃I'%μ４＜Ｕ3  ",
		out:  "␞ ｑx\x11＞\r８\x15ρ|ψ\\Ｚηtφ␕ｙ␃I'%μ４＜Ｕ3 ␠",
	}, { // 471
		mask: EncodeAsterisk | EncodeLeftSpace | EncodeRightSpace,
		in:   "␞ ｑx\x11＞\r８\x15ρ|ψ\\Ｚηtφ␕ｙ␃I'%μ４＜Ｕ3 ␠",
		out:  "␞ ｑx\x11＞\r８\x15ρ|ψ\\Ｚηtφ␕ｙ␃I'%μ４＜Ｕ3 ‛␠",
	}, { // 472
		mask: EncodePipe | EncodeLeftSpace | EncodeRightSpace,
		in:   "  χD？?J␚δ＇2ς\x1eｍjｍο］;␊/␌*kｍ\x12＜ｐ ξ",
		out:  "␠ χD？?J␚δ＇2ς\x1eｍjｍο］;␊/␌*kｍ\x12＜ｐ ξ",
	}, { // 473
		mask: EncodePipe | EncodeLeftSpace | EncodeRightSpace,
		in:   "␠ χD？?J␚δ＇2ς\x1eｍjｍο］;␊/␌*kｍ\x12＜ｐ ξ",
		out:  "‛␠ χD？?J␚δ＇2ς\x1eｍjｍο］;␊/␌*kｍ\x12＜ｐ ξ",
	}, { // 474
		mask: EncodePipe | EncodeLeftSpace | EncodeRightSpace,
		in:   "３ χD？?J␚δ＇2ς\x1eｍjｍο］;␊/␌*kｍ\x12＜ｐ  ",
		out:  "３ χD？?J␚δ＇2ς\x1eｍjｍο］;␊/␌*kｍ\x12＜ｐ ␠",
	}, { // 475
		mask: EncodePipe | EncodeLeftSpace | EncodeRightSpace,
		in:   "３ χD？?J␚δ＇2ς\x1eｍjｍο］;␊/␌*kｍ\x12＜ｐ ␠",
		out:  "３ χD？?J␚δ＇2ς\x1eｍjｍο］;␊/␌*kｍ\x12＜ｐ ‛␠",
	}, { // 476
		mask: EncodeHash | EncodeLeftSpace | EncodeRightSpace,
		in:   "  ｓ＠κＬx\x0fδ\bＴowj\nρ\x05ε␜／ο－␑␁-δ\x1a␕ ␛",
		out:  "␠ ｓ＠κＬx\x0fδ\bＴowj\nρ\x05ε␜／ο－␑␁-δ\x1a␕ ␛",
	}, { // 477
		mask: EncodeHash | EncodeLeftSpace | EncodeRightSpace,
		in:   "␠ ｓ＠κＬx\x0fδ\bＴowj\nρ\x05ε␜／ο－␑␁-δ\x1a␕ ␛",
		out:  "‛␠ ｓ＠κＬx\x0fδ\bＴowj\nρ\x05ε␜／ο－␑␁-δ\x1a␕ ␛",
	}, { // 478
		mask: EncodeHash | EncodeLeftSpace | EncodeRightSpace,
		in:   "r ｓ＠κＬx\x0fδ\bＴowj\nρ\x05ε␜／ο－␑␁-δ\x1a␕  ",
		out:  "r ｓ＠κＬx\x0fδ\bＴowj\nρ\x05ε␜／ο－␑␁-δ\x1a␕ ␠",
	}, { // 479
		mask: EncodeHash | EncodeLeftSpace | EncodeRightSpace,
		in:   "r ｓ＠κＬx\x0fδ\bＴowj\nρ\x05ε␜／ο－␑␁-δ\x1a␕ ␠",
		out:  "r ｓ＠κＬx\x0fδ\bＴowj\nρ\x05ε␜／ο－␑␁-δ\x1a␕ ‛␠",
	}, { // 480
		mask: EncodePercent | EncodeLeftSpace | EncodeRightSpace,
		in:   "  εＰ␈\"｝ι\x05π．\x06␍Eyｓ~｜，ε\u007f\x1d$␆:｝3π ␅",
		out:  "␠ εＰ␈\"｝ι\x05π．\x06␍Eyｓ~｜，ε\u007f\x1d$␆:｝3π ␅",
	}, { // 481
		mask: EncodePercent | EncodeLeftSpace | EncodeRightSpace,
		in:   "␠ εＰ␈\"｝ι\x05π．\x06␍Eyｓ~｜，ε\u007f\x1d$␆:｝3π ␅",
		out:  "‛␠ εＰ␈\"｝ι\x05π．\x06␍Eyｓ~｜，ε\u007f\x1d$␆:｝3π ␅",
	}, { // 482
		mask: EncodePercent | EncodeLeftSpace | EncodeRightSpace,
		in:   "ι εＰ␈\"｝ι\x05π．\x06␍Eyｓ~｜，ε\u007f\x1d$␆:｝3π  ",
		out:  "ι εＰ␈\"｝ι\x05π．\x06␍Eyｓ~｜，ε\u007f\x1d$␆:｝3π ␠",
	}, { // 483
		mask: EncodePercent | EncodeLeftSpace | EncodeRightSpace,
		in:   "ι εＰ␈\"｝ι\x05π．\x06␍Eyｓ~｜，ε\u007f\x1d$␆:｝3π ␠",
		out:  "ι εＰ␈\"｝ι\x05π．\x06␍Eyｓ~｜，ε\u007f\x1d$␆:｝3π ‛␠",
	}, { // 484
		mask: EncodeBackSlash | EncodeLeftSpace | EncodeRightSpace,
		in:   "  |ＤＬＸ|\x1dυ␟ｇg#␞,␙␙ηｉ^␊5\x1bς&␋\x13γ χ",
		out:  "␠ |ＤＬＸ|\x1dυ␟ｇg#␞,␙␙ηｉ^␊5\x1bς&␋\x13γ χ",
	}, { // 485
		mask: EncodeBackSlash | EncodeLeftSpace | EncodeRightSpace,
		in:   "␠ |ＤＬＸ|\x1dυ␟ｇg#␞,␙␙ηｉ^␊5\x1bς&␋\x13γ χ",
		out:  "‛␠ |ＤＬＸ|\x1dυ␟ｇg#␞,␙␙ηｉ^␊5\x1bς&␋\x13γ χ",
	}, { // 486
		mask: EncodeBackSlash | EncodeLeftSpace | EncodeRightSpace,
		in:   "α |ＤＬＸ|\x1dυ␟ｇg#␞,␙␙ηｉ^␊5\x1bς&␋\x13γ  ",
		out:  "α |ＤＬＸ|\x1dυ␟ｇg#␞,␙␙ηｉ^␊5\x1bς&␋\x13γ ␠",
	}, { // 487
		mask: EncodeBackSlash | EncodeLeftSpace | EncodeRightSpace,
		in:   "α |ＤＬＸ|\x1dυ␟ｇg#␞,␙␙ηｉ^␊5\x1bς&␋\x13γ ␠",
		out:  "α |ＤＬＸ|\x1dυ␟ｇg#␞,␙␙ηｉ^␊5\x1bς&␋\x13γ ‛␠",
	}, { // 488
		mask: EncodeCrLf | EncodeLeftSpace | EncodeRightSpace,
		in:   "  pαρvＨι␎ςＭ＆＜\n\x03␚I␞μＯ;\x0eh\vo%<␘ Ｓ",
		out:  "␠ pαρvＨι␎ςＭ＆＜␊\x03␚I␞μＯ;\x0eh\vo%<␘ Ｓ",
	}, { // 489
		mask: EncodeCrLf | EncodeLeftSpace | EncodeRightSpace,
		in:   "␠ pαρvＨι␎ςＭ＆＜\n\x03␚I␞μＯ;\x0eh\vo%<␘ Ｓ",
		out:  "‛␠ pαρvＨι␎ςＭ＆＜␊\x03␚I␞μＯ;\x0eh\vo%<␘ Ｓ",
	}, { // 490
		mask: EncodeCrLf | EncodeLeftSpace | EncodeRightSpace,
		in:   "η pαρvＨι␎ςＭ＆＜\n\x03␚I␞μＯ;\x0eh\vo%<␘  ",
		out:  "η pαρvＨι␎ςＭ＆＜␊\x03␚I␞μＯ;\x0eh\vo%<␘ ␠",
	}, { // 491
		mask: EncodeCrLf | EncodeLeftSpace | EncodeRightSpace,
		in:   "η pαρvＨι␎ςＭ＆＜\n\x03␚I␞μＯ;\x0eh\vo%<␘ ␠",
		out:  "η pαρvＨι␎ςＭ＆＜␊\x03␚I␞μＯ;\x0eh\vo%<␘ ‛␠",
	}, { // 492
		mask: EncodeDel | EncodeLeftSpace | EncodeRightSpace,
		in:   "  \x0e␉Ｈｐi␗7)␘␏ω：ｎ␐g｜\x14σχ\x1bω␒lσε& ｕ",
		out:  "␠ \x0e␉Ｈｐi␗7)␘␏ω：ｎ␐g｜\x14σχ\x1bω␒lσε& ｕ",
	}, { // 493
		mask: EncodeDel | EncodeLeftSpace | EncodeRightSpace,
		in:   "␠ \x0e␉Ｈｐi␗7)␘␏ω：ｎ␐g｜\x14σχ\x1bω␒lσε& ｕ",
		out:  "‛␠ \x0e␉Ｈｐi␗7)␘␏ω：ｎ␐g｜\x14σχ\x1bω␒lσε& ｕ",
	}, { // 494
		mask: EncodeDel | EncodeLeftSpace | EncodeRightSpace,
		in:   "\x1e \x0e␉Ｈｐi␗7)␘␏ω：ｎ␐g｜\x14σχ\x1bω␒lσε&  ",
		out:  "\x1e \x0e␉Ｈｐi␗7)␘␏ω：ｎ␐g｜\x14σχ\x1bω␒lσε& ␠",
	}, { // 495
		mask: EncodeDel | EncodeLeftSpace | EncodeRightSpace,
		in:   "\x1e \x0e␉Ｈｐi␗7)␘␏ω：ｎ␐g｜\x14σχ\x1bω␒lσε& ␠",
		out:  "\x1e \x0e␉Ｈｐi␗7)␘␏ω：ｎ␐g｜\x14σχ\x1bω␒lσε& ‛␠",
	}, { // 496
		mask: EncodeCtl | EncodeLeftSpace | EncodeRightSpace,
		in:   "  (＆␘χ｀\x0f<:＇8\r' \x11$（［γζε｝␍；_Ｎ［ ３",
		out:  "␠ (＆‛␘χ｀␏<:＇8␍' ␑$（［γζε｝‛␍；_Ｎ［ ３",
	}, { // 497
		mask: EncodeCtl | EncodeLeftSpace | EncodeRightSpace,
		in:   "␠ (＆␘χ｀\x0f<:＇8\r' \x11$（［γζε｝␍；_Ｎ［ ３",
		out:  "‛␠ (＆‛␘χ｀␏<:＇8␍' ␑$（［γζε｝‛␍；_Ｎ［ ３",
	}, { // 498
		mask: EncodeCtl | EncodeLeftSpace | EncodeRightSpace,
		in:   "1 (＆␘χ｀\x0f<:＇8\r' \x11$（［γζε｝␍；_Ｎ［  ",
		out:  "1 (＆‛␘χ｀␏<:＇8␍' ␑$（［γζε｝‛␍；_Ｎ［ ␠",
	}, { // 499
		mask: EncodeCtl | EncodeLeftSpace | EncodeRightSpace,
		in:   "1 (＆␘χ｀\x0f<:＇8\r' \x11$（［γζε｝␍；_Ｎ［ ␠",
		out:  "1 (＆‛␘χ｀␏<:＇8␍' ␑$（［γζε｝‛␍；_Ｎ［ ‛␠",
	}, { // 500
		mask: EncodeZero | EncodeLeftSpace | EncodeRightPeriod,
		in:   " .'/␕␍ν␕μγＵυ␑｛\n|δ＾G␘]\r\x11５3［｜K..",
		out:  "␠.'/␕␍ν␕μγＵυ␑｛\n|δ＾G␘]\r\x11５3［｜K.．",
	}, { // 501
		mask: EncodeZero | EncodeLeftSpace | EncodeRightPeriod,
		in:   "␠.'/␕␍ν␕μγＵυ␑｛\n|δ＾G␘]\r\x11５3［｜K..",
		out:  "‛␠.'/␕␍ν␕μγＵυ␑｛\n|δ＾G␘]\r\x11５3［｜K.．",
	}, { // 502
		mask: EncodeZero | EncodeLeftSpace | EncodeRightPeriod,
		in:   "？.'/␕␍ν␕μγＵυ␑｛\n|δ＾G␘]\r\x11５3［｜K. ",
		out:  "？.'/␕␍ν␕μγＵυ␑｛\n|δ＾G␘]\r\x11５3［｜K. ",
	}, { // 503
		mask: EncodeZero | EncodeLeftSpace | EncodeRightPeriod,
		in:   "？.'/␕␍ν␕μγＵυ␑｛\n|δ＾G␘]\r\x11５3［｜K.␠",
		out:  "？.'/␕␍ν␕μγＵυ␑｛\n|δ＾G␘]\r\x11５3［｜K.␠",
	}, { // 504
		mask: EncodeSlash | EncodeLeftSpace | EncodeRightPeriod,
		in:   " .?χζo-Mιd［␓ｊEｊω＇\x13νｖ～/U␜␞*２χ.\x0f",
		out:  "␠.?χζo-Mιd［␓ｊEｊω＇\x13νｖ～／U␜␞*２χ.\x0f",
	}, { // 505
		mask: EncodeSlash | EncodeLeftSpace | EncodeRightPeriod,
		in:   "␠.?χζo-Mιd［␓ｊEｊω＇\x13νｖ～/U␜␞*２χ.\x0f",
		out:  "‛␠.?χζo-Mιd［␓ｊEｊω＇\x13νｖ～／U␜␞*２χ.\x0f",
	}, { // 506
		mask: EncodeSlash | EncodeLeftSpace | EncodeRightPeriod,
		in:   "\x05.?χζo-Mιd［␓ｊEｊω＇\x13νｖ～/U␜␞*２χ. ",
		out:  "\x05.?χζo-Mιd［␓ｊEｊω＇\x13νｖ～／U␜␞*２χ. ",
	}, { // 507
		mask: EncodeSlash | EncodeLeftSpace | EncodeRightPeriod,
		in:   "\x05.?χζo-Mιd［␓ｊEｊω＇\x13νｖ～/U␜␞*２χ.␠",
		out:  "\x05.?χζo-Mιd［␓ｊEｊω＇\x13νｖ～／U␜␞*２χ.␠",
	}, { // 508
		mask: EncodeSingleQuote | EncodeLeftSpace | EncodeRightPeriod,
		in:   " .{η␄／δ９Ｋ％\\ｓ\x03Ｋ#ＳS：ψ\\*␃]:5ηG７.␊",
		out:  "␠.{η␄／δ９Ｋ％\\ｓ\x03Ｋ#ＳS：ψ\\*␃]:5ηG７.␊",
	}, { // 509
		mask: EncodeSingleQuote | EncodeLeftSpace | EncodeRightPeriod,
		in:   "␠.{η␄／δ９Ｋ％\\ｓ\x03Ｋ#ＳS：ψ\\*␃]:5ηG７.␊",
		out:  "‛␠.{η␄／δ９Ｋ％\\ｓ\x03Ｋ#ＳS：ψ\\*␃]:5ηG７.␊",
	}, { // 510
		mask: EncodeSingleQuote | EncodeLeftSpace | EncodeRightPeriod,
		in:   "*.{η␄／δ９Ｋ％\\ｓ\x03Ｋ#ＳS：ψ\\*␃]:5ηG７. ",
		out:  "*.{η␄／δ９Ｋ％\\ｓ\x03Ｋ#ＳS：ψ\\*␃]:5ηG７. ",
	}, { // 511
		mask: EncodeSingleQuote | EncodeLeftSpace | EncodeRightPeriod,
		in:   "*.{η␄／δ９Ｋ％\\ｓ\x03Ｋ#ＳS：ψ\\*␃]:5ηG７.␠",
		out:  "*.{η␄／δ９Ｋ％\\ｓ\x03Ｋ#ＳS：ψ\\*␃]:5ηG７.␠",
	}, { // 512
		mask: EncodeBackQuote | EncodeLeftSpace | EncodeRightPeriod,
		in:   " .\x05＼pξuτη\"\x1c\x1e9]\x10␖ｒ９％πｔＥ␃␍θ␔<ο.|",
		out:  "␠.\x05＼pξuτη\"\x1c\x1e9]\x10␖ｒ９％πｔＥ␃␍θ␔<ο.|",
	}, { // 513
		mask: EncodeBackQuote | EncodeLeftSpace | EncodeRightPeriod,
		in:   "␠.\x05＼pξuτη\"\x1c\x1e9]\x10␖ｒ９％πｔＥ␃␍θ␔<ο.|",
		out:  "‛␠.\x05＼pξuτη\"\x1c\x1e9]\x10␖ｒ９％πｔＥ␃␍θ␔<ο.|",
	}, { // 514
		mask: EncodeBackQuote | EncodeLeftSpace | EncodeRightPeriod,
		in:   "Ｅ.\x05＼pξuτη\"\x1c\x1e9]\x10␖ｒ９％πｔＥ␃␍θ␔<ο. ",
		out:  "Ｅ.\x05＼pξuτη\"\x1c\x1e9]\x10␖ｒ９％πｔＥ␃␍θ␔<ο. ",
	}, { // 515
		mask: EncodeBackQuote | EncodeLeftSpace | EncodeRightPeriod,
		in:   "Ｅ.\x05＼pξuτη\"\x1c\x1e9]\x10␖ｒ９％πｔＥ␃␍θ␔<ο.␠",
		out:  "Ｅ.\x05＼pξuτη\"\x1c\x1e9]\x10␖ｒ９％πｔＥ␃␍θ␔<ο.␠",
	}, { // 516
		mask: EncodeLtGt | EncodeLeftSpace | EncodeRightPeriod,
		in:   " ./\x17Wμ(ＴＬ\vＧｍ－E．＜␊υαξη$＼=\r␚κ␛.b",
		out:  "␠./\x17Wμ(ＴＬ\vＧｍ－E．‛＜␊υαξη$＼=\r␚κ␛.b",
	}, { // 517
		mask: EncodeLtGt | EncodeLeftSpace | EncodeRightPeriod,
		in:   "␠./\x17Wμ(ＴＬ\vＧｍ－E．＜␊υαξη$＼=\r␚κ␛.b",
		out:  "‛␠./\x17Wμ(ＴＬ\vＧｍ－E．‛＜␊υαξη$＼=\r␚κ␛.b",
	}, { // 518
		mask: EncodeLtGt | EncodeLeftSpace | EncodeRightPeriod,
		in:   "\u007f./\x17Wμ(ＴＬ\vＧｍ－E．＜␊υαξη$＼=\r␚κ␛. ",
		out:  "\u007f./\x17Wμ(ＴＬ\vＧｍ－E．‛＜␊υαξη$＼=\r␚κ␛. ",
	}, { // 519
		mask: EncodeLtGt | EncodeLeftSpace | EncodeRightPeriod,
		in:   "\u007f./\x17Wμ(ＴＬ\vＧｍ－E．＜␊υαξη$＼=\r␚κ␛.␠",
		out:  "\u007f./\x17Wμ(ＴＬ\vＧｍ－E．‛＜␊υαξη$＼=\r␚κ␛.␠",
	}, { // 520
		mask: EncodeSquareBracket | EncodeLeftSpace | EncodeRightPeriod,
		in:   " .\x05K\u007fνＥａhμ\\ο␊w&␄~πｘ␙6\x06；␔␜Ｅ\rδ.␍",
		out:  "␠.\x05K\u007fνＥａhμ\\ο␊w&␄~πｘ␙6\x06；␔␜Ｅ\rδ.␍",
	}, { // 521
		mask: EncodeSquareBracket | EncodeLeftSpace | EncodeRightPeriod,
		in:   "␠.\x05K\u007fνＥａhμ\\ο␊w&␄~πｘ␙6\x06；␔␜Ｅ\rδ.␍",
		out:  "‛␠.\x05K\u007fνＥａhμ\\ο␊w&␄~πｘ␙6\x06；␔␜Ｅ\rδ.␍",
	}, { // 522
		mask: EncodeSquareBracket | EncodeLeftSpace | EncodeRightPeriod,
		in:   "ｖ.\x05K\u007fνＥａhμ\\ο␊w&␄~πｘ␙6\x06；␔␜Ｅ\rδ. ",
		out:  "ｖ.\x05K\u007fνＥａhμ\\ο␊w&␄~πｘ␙6\x06；␔␜Ｅ\rδ. ",
	}, { // 523
		mask: EncodeSquareBracket | EncodeLeftSpace | EncodeRightPeriod,
		in:   "ｖ.\x05K\u007fνＥａhμ\\ο␊w&␄~πｘ␙6\x06；␔␜Ｅ\rδ.␠",
		out:  "ｖ.\x05K\u007fνＥａhμ\\ο␊w&␄~πｘ␙6\x06；␔␜Ｅ\rδ.␠",
	}, { // 524
		mask: EncodeSemicolon | EncodeLeftSpace | EncodeRightPeriod,
		in:   " .）δσ／|π＞\x11e{\n␞Ｌ８]］ι＇\n␍ξｋw\x00ξ\a.␂",
		out:  "␠.）δσ／|π＞\x11e{\n␞Ｌ８]］ι＇\n␍ξｋw␀ξ\a.␂",
	}, { // 525
		mask: EncodeSemicolon | EncodeLeftSpace | EncodeRightPeriod,
		in:   "␠.）δσ／|π＞\x11e{\n␞Ｌ８]］ι＇\n␍ξｋw\x00ξ\a.␂",
		out:  "‛␠.）δσ／|π＞\x11e{\n␞Ｌ８]］ι＇\n␍ξｋw␀ξ\a.␂",
	}, { // 526
		mask: EncodeSemicolon | EncodeLeftSpace | EncodeRightPeriod,
		in:   "４.）δσ／|π＞\x11e{\n␞Ｌ８]］ι＇\n␍ξｋw\x00ξ\a. ",
		out:  "４.）δσ／|π＞\x11e{\n␞Ｌ８]］ι＇\n␍ξｋw␀ξ\a. ",
	}, { // 527
		mask: EncodeSemicolon | EncodeLeftSpace | EncodeRightPeriod,
		in:   "４.）δσ／|π＞\x11e{\n␞Ｌ８]］ι＇\n␍ξｋw\x00ξ\a.␠",
		out:  "４.）δσ／|π＞\x11e{\n␞Ｌ８]］ι＇\n␍ξｋw␀ξ\a.␠",
	}, { // 528
		mask: EncodeDollar | EncodeLeftSpace | EncodeRightPeriod,
		in:   " .］σωN］α␞＊＿６\x12␉]P\x03＼?＆\x1cω\nδ \x1b｜Ｔ.:",
		out:  "␠.］σωN］α␞＊＿６\x12␉]P\x03＼?＆\x1cω\nδ \x1b｜Ｔ.:",
	}, { // 529
		mask: EncodeDollar | EncodeLeftSpace | EncodeRightPeriod,
		in:   "␠.］σωN］α␞＊＿６\x12␉]P\x03＼?＆\x1cω\nδ \x1b｜Ｔ.:",
		out:  "‛␠.］σωN］α␞＊＿６\x12␉]P\x03＼?＆\x1cω\nδ \x1b｜Ｔ.:",
	}, { // 530
		mask: EncodeDollar | EncodeLeftSpace | EncodeRightPeriod,
		in:   "κ.］σωN］α␞＊＿６\x12␉]P\x03＼?＆\x1cω\nδ \x1b｜Ｔ. ",
		out:  "κ.］σωN］α␞＊＿６\x12␉]P\x03＼?＆\x1cω\nδ \x1b｜Ｔ. ",
	}, { // 531
		mask: EncodeDollar | EncodeLeftSpace | EncodeRightPeriod,
		in:   "κ.］σωN］α␞＊＿６\x12␉]P\x03＼?＆\x1cω\nδ \x1b｜Ｔ.␠",
		out:  "κ.］σωN］α␞＊＿６\x12␉]P\x03＼?＆\x1cω\nδ \x1b｜Ｔ.␠",
	}, { // 532
		mask: EncodeDoubleQuote | EncodeLeftSpace | EncodeRightPeriod,
		in:   " .\rＩfi][［.␡␍\"／$λπψ：V␕＝␄ε␛]\x0f＄.0",
		out:  "␠.\rＩfi][［.␡␍＂／$λπψ：V␕＝␄ε␛]\x0f＄.0",
	}, { // 533
		mask: EncodeDoubleQuote | EncodeLeftSpace | EncodeRightPeriod,
		in:   "␠.\rＩfi][［.␡␍\"／$λπψ：V␕＝␄ε␛]\x0f＄.0",
		out:  "‛␠.\rＩfi][［.␡␍＂／$λπψ：V␕＝␄ε␛]\x0f＄.0",
	}, { // 534
		mask: EncodeDoubleQuote | EncodeLeftSpace | EncodeRightPeriod,
		in:   "η.\rＩfi][［.␡␍\"／$λπψ：V␕＝␄ε␛]\x0f＄. ",
		out:  "η.\rＩfi][［.␡␍＂／$λπψ：V␕＝␄ε␛]\x0f＄. ",
	}, { // 535
		mask: EncodeDoubleQuote | EncodeLeftSpace | EncodeRightPeriod,
		in:   "η.\rＩfi][［.␡␍\"／$λπψ：V␕＝␄ε␛]\x0f＄.␠",
		out:  "η.\rＩfi][［.␡␍＂／$λπψ：V␕＝␄ε␛]\x0f＄.␠",
	}, { // 536
		mask: EncodeColon | EncodeLeftSpace | EncodeRightPeriod,
		in:   " .␕２４:ω␚\x00\x01kP\x11N␁ρνｄiολ␟[＊IＰγ␖.%",
		out:  "␠.␕２４：ω␚␀\x01kP\x11N␁ρνｄiολ␟[＊IＰγ␖.%",
	}, { // 537
		mask: EncodeColon | EncodeLeftSpace | EncodeRightPeriod,
		in:   "␠.␕２４:ω␚\x00\x01kP\x11N␁ρνｄiολ␟[＊IＰγ␖.%",
		out:  "‛␠.␕２４：ω␚␀\x01kP\x11N␁ρνｄiολ␟[＊IＰγ␖.%",
	}, { // 538
		mask: EncodeColon | EncodeLeftSpace | EncodeRightPeriod,
		in:   "；.␕２４:ω␚\x00\x01kP\x11N␁ρνｄiολ␟[＊IＰγ␖. ",
		out:  "；.␕２４：ω␚␀\x01kP\x11N␁ρνｄiολ␟[＊IＰγ␖. ",
	}, { // 539
		mask: EncodeColon | EncodeLeftSpace | EncodeRightPeriod,
		in:   "；.␕２４:ω␚\x00\x01kP\x11N␁ρνｄiολ␟[＊IＰγ␖.␠",
		out:  "；.␕２４：ω␚␀\x01kP\x11N␁ρνｄiολ␟[＊IＰγ␖.␠",
	}, { // 540
		mask: EncodeQuestion | EncodeLeftSpace | EncodeRightPeriod,
		in:   " .rψκj\x0eθ␁\r_ＣζM?␑\x1f5０\x00｀｜ｈ0＋φυ$.９",
		out:  "␠.rψκj\x0eθ␁\r_ＣζM？␑\x1f5０␀｀｜ｈ0＋φυ$.９",
	}, { // 541
		mask: EncodeQuestion | EncodeLeftSpace | EncodeRightPeriod,
		in:   "␠.rψκj\x0eθ␁\r_ＣζM?␑\x1f5０\x00｀｜ｈ0＋φυ$.９",
		out:  "‛␠.rψκj\x0eθ␁\r_ＣζM？␑\x1f5０␀｀｜ｈ0＋φυ$.９",
	}, { // 542
		mask: EncodeQuestion | EncodeLeftSpace | EncodeRightPeriod,
		in:   "ｌ.rψκj\x0eθ␁\r_ＣζM?␑\x1f5０\x00｀｜ｈ0＋φυ$. ",
		out:  "ｌ.rψκj\x0eθ␁\r_ＣζM？␑\x1f5０␀｀｜ｈ0＋φυ$. ",
	}, { // 543
		mask: EncodeQuestion | EncodeLeftSpace | EncodeRightPeriod,
		in:   "ｌ.rψκj\x0eθ␁\r_ＣζM?␑\x1f5０\x00｀｜ｈ0＋φυ$.␠",
		out:  "ｌ.rψκj\x0eθ␁\r_ＣζM？␑\x1f5０␀｀｜ｈ0＋φυ$.␠",
	}, { // 544
		mask: EncodeAsterisk | EncodeLeftSpace | EncodeRightPeriod,
		in:   " .iι␍ｎ４\x1fυI]ν\f?_/６<\x1b␇␇␊η８＄ψ\x17T.＃",
		out:  "␠.iι␍ｎ４\x1fυI]ν\f?_/６<\x1b␇␇␊η８＄ψ\x17T.＃",
	}, { // 545
		mask: EncodeAsterisk | EncodeLeftSpace | EncodeRightPeriod,
		in:   "␠.iι␍ｎ４\x1fυI]ν\f?_/６<\x1b␇␇␊η８＄ψ\x17T.＃",
		out:  "‛␠.iι␍ｎ４\x1fυI]ν\f?_/６<\x1b␇␇␊η８＄ψ\x17T.＃",
	}, { // 546
		mask: EncodeAsterisk | EncodeLeftSpace | EncodeRightPeriod,
		in:   "ρ.iι␍ｎ４\x1fυI]ν\f?_/６<\x1b␇␇␊η８＄ψ\x17T. ",
		out:  "ρ.iι␍ｎ４\x1fυI]ν\f?_/６<\x1b␇␇␊η８＄ψ\x17T. ",
	}, { // 547
		mask: EncodeAsterisk | EncodeLeftSpace | EncodeRightPeriod,
		in:   "ρ.iι␍ｎ４\x1fυI]ν\f?_/６<\x1b␇␇␊η８＄ψ\x17T.␠",
		out:  "ρ.iι␍ｎ４\x1fυI]ν\f?_/６<\x1b␇␇␊η８＄ψ\x17T.␠",
	}, { // 548
		mask: EncodePipe | EncodeLeftSpace | EncodeRightPeriod,
		in:   " .\v#\"\x10？Ｑ\r＞｜␊␍'π<Tυ=θ␊σi～ε３|ｏ.．",
		out:  "␠.\v#\"\x10？Ｑ\r＞‛｜␊␍'π<Tυ=θ␊σi～ε３｜ｏ.‛．",
	}, { // 549
		mask: EncodePipe | EncodeLeftSpace | EncodeRightPeriod,
		in:   "␠.\v#\"\x10？Ｑ\r＞｜␊␍'π<Tυ=θ␊σi～ε３|ｏ.．",
		out:  "‛␠.\v#\"\x10？Ｑ\r＞‛｜␊␍'π<Tυ=θ␊σi～ε３｜ｏ.‛．",
	}, { // 550
		mask: EncodePipe | EncodeLeftSpace | EncodeRightPeriod,
		in:   "０.\v#\"\x10？Ｑ\r＞｜␊␍'π<Tυ=θ␊σi～ε３|ｏ. ",
		out:  "０.\v#\"\x10？Ｑ\r＞‛｜␊␍'π<Tυ=θ␊σi～ε３｜ｏ. ",
	}, { // 551
		mask: EncodePipe | EncodeLeftSpace | EncodeRightPeriod,
		in:   "０.\v#\"\x10？Ｑ\r＞｜␊␍'π<Tυ=θ␊σi～ε３|ｏ.␠",
		out:  "０.\v#\"\x10？Ｑ\r＞‛｜␊␍'π<Tυ=θ␊σi～ε３｜ｏ.␠",
	}, { // 552
		mask: EncodeHash | EncodeLeftSpace | EncodeRightPeriod,
		in:   " .ｌ:wＣ／\x03／bςδ９ηcX/εｉ＃%ｓ\x00\x15␟Ｕυκ.＇",
		out:  "␠.ｌ:wＣ／\x03／bςδ９ηcX/εｉ‛＃%ｓ␀\x15␟Ｕυκ.＇",
	}, { // 553
		mask: EncodeHash | EncodeLeftSpace | EncodeRightPeriod,
		in:   "␠.ｌ:wＣ／\x03／bςδ９ηcX/εｉ＃%ｓ\x00\x15␟Ｕυκ.＇",
		out:  "‛␠.ｌ:wＣ／\x03／bςδ９ηcX/εｉ‛＃%ｓ␀\x15␟Ｕυκ.＇",
	}, { // 554
		mask: EncodeHash | EncodeLeftSpace | EncodeRightPeriod,
		in:   "m.ｌ:wＣ／\x03／bςδ９ηcX/εｉ＃%ｓ\x00\x15␟Ｕυκ. ",
		out:  "m.ｌ:wＣ／\x03／bςδ９ηcX/εｉ‛＃%ｓ␀\x15␟Ｕυκ. ",
	}, { // 555
		mask: EncodeHash | EncodeLeftSpace | EncodeRightPeriod,
		in:   "m.ｌ:wＣ／\x03／bςδ９ηcX/εｉ＃%ｓ\x00\x15␟Ｕυκ.␠",
		out:  "m.ｌ:wＣ／\x03／bςδ９ηcX/εｉ‛＃%ｓ␀\x15␟Ｕυκ.␠",
	}, { // 556
		mask: EncodePercent | EncodeLeftSpace | EncodeRightPeriod,
		in:   " .ｍ:ζ＇：\x1fυ,ｋz'＞*\nｗ\\␞XＸ␘το\x17Yυ␋.␋",
		out:  "␠.ｍ:ζ＇：\x1fυ,ｋz'＞*\nｗ\\␞XＸ␘το\x17Yυ␋.␋",
	}, { // 557
		mask: EncodePercent | EncodeLeftSpace | EncodeRightPeriod,
		in:   "␠.ｍ:ζ＇：\x1fυ,ｋz'＞*\nｗ\\␞XＸ␘το\x17Yυ␋.␋",
		out:  "‛␠.ｍ:ζ＇：\x1fυ,ｋz'＞*\nｗ\\␞XＸ␘το\x17Yυ␋.␋",
	}, { // 558
		mask: EncodePercent | EncodeLeftSpace | EncodeRightPeriod,
		in:   "Ｄ.ｍ:ζ＇：\x1fυ,ｋz'＞*\nｗ\\␞XＸ␘το\x17Yυ␋. ",
		out:  "Ｄ.ｍ:ζ＇：\x1fυ,ｋz'＞*\nｗ\\␞XＸ␘το\x17Yυ␋. ",
	}, { // 559
		mask: EncodePercent | EncodeLeftSpace | EncodeRightPeriod,
		in:   "Ｄ.ｍ:ζ＇：\x1fυ,ｋz'＞*\nｗ\\␞XＸ␘το\x17Yυ␋.␠",
		out:  "Ｄ.ｍ:ζ＇：\x1fυ,ｋz'＞*\nｗ\\␞XＸ␘το\x17Yυ␋.␠",
	}, { // 560
		mask: EncodeBackSlash | EncodeLeftSpace | EncodeRightPeriod,
		in:   " .ｍWt\vg\uff00μ␛φ␙χθq\x17/Ｚβψ］／：？ｊ$\n .#",
		out:  "␠.ｍWt\vg\uff00μ␛φ␙χθq\x17/Ｚβψ］／：？ｊ$\n .#",
	}, { // 561
		mask: EncodeBackSlash | EncodeLeftSpace | EncodeRightPeriod,
		in:   "␠.ｍWt\vg\uff00μ␛φ␙χθq\x17/Ｚβψ］／：？ｊ$\n .#",
		out:  "‛␠.ｍWt\vg\uff00μ␛φ␙χθq\x17/Ｚβψ］／：？ｊ$\n .#",
	}, { // 562
		mask: EncodeBackSlash | EncodeLeftSpace | EncodeRightPeriod,
		in:   "｀.ｍWt\vg\uff00μ␛φ␙χθq\x17/Ｚβψ］／：？ｊ$\n . ",
		out:  "｀.ｍWt\vg\uff00μ␛φ␙χθq\x17/Ｚβψ］／：？ｊ$\n . ",
	}, { // 563
		mask: EncodeBackSlash | EncodeLeftSpace | EncodeRightPeriod,
		in:   "｀.ｍWt\vg\uff00μ␛φ␙χθq\x17/Ｚβψ］／：？ｊ$\n .␠",
		out:  "｀.ｍWt\vg\uff00μ␛φ␙χθq\x17/Ｚβψ］／：？ｊ$\n .␠",
	}, { // 564
		mask: EncodeCrLf | EncodeLeftSpace | EncodeRightPeriod,
		in:   " .\x17ｍψ)λμ／\n*␄Ｅ＠*Ｆ␕␓＄␞\"'κμAｂR＞.1",
		out:  "␠.\x17ｍψ)λμ／␊*␄Ｅ＠*Ｆ␕␓＄␞\"'κμAｂR＞.1",
	}, { // 565
		mask: EncodeCrLf | EncodeLeftSpace | EncodeRightPeriod,
		in:   "␠.\x17ｍψ)λμ／\n*␄Ｅ＠*Ｆ␕␓＄␞\"'κμAｂR＞.1",
		out:  "‛␠.\x17ｍψ)λμ／␊*␄Ｅ＠*Ｆ␕␓＄␞\"'κμAｂR＞.1",
	}, { // 566
		mask: EncodeCrLf | EncodeLeftSpace | EncodeRightPeriod,
		in:   "ο.\x17ｍψ)λμ／\n*␄Ｅ＠*Ｆ␕␓＄␞\"'κμAｂR＞. ",
		out:  "ο.\x17ｍψ)λμ／␊*␄Ｅ＠*Ｆ␕␓＄␞\"'κμAｂR＞. ",
	}, { // 567
		mask: EncodeCrLf | EncodeLeftSpace | EncodeRightPeriod,
		in:   "ο.\x17ｍψ)λμ／\n*␄Ｅ＠*Ｆ␕␓＄␞\"'κμAｂR＞.␠",
		out:  "ο.\x17ｍψ)λμ／␊*␄Ｅ＠*Ｆ␕␓＄␞\"'κμAｂR＞.␠",
	}, { // 568
		mask: EncodeDel | EncodeLeftSpace | EncodeRightPeriod,
		in:   " .K［ρ］ｚ␖κ＾\x1b.\x16α~V\x02\t？５＜vψ␁fｑχ␟.:",
		out:  "␠.K［ρ］ｚ␖κ＾\x1b.\x16α~V\x02\t？５＜vψ␁fｑχ␟.:",
	}, { // 569
		mask: EncodeDel | EncodeLeftSpace | EncodeRightPeriod,
		in:   "␠.K［ρ］ｚ␖κ＾\x1b.\x16α~V\x02\t？５＜vψ␁fｑχ␟.:",
		out:  "‛␠.K［ρ］ｚ␖κ＾\x1b.\x16α~V\x02\t？５＜vψ␁fｑχ␟.:",
	}, { // 570
		mask: EncodeDel | EncodeLeftSpace | EncodeRightPeriod,
		in:   "＞.K［ρ］ｚ␖κ＾\x1b.\x16α~V\x02\t？５＜vψ␁fｑχ␟. ",
		out:  "＞.K［ρ］ｚ␖κ＾\x1b.\x16α~V\x02\t？５＜vψ␁fｑχ␟. ",
	}, { // 571
		mask: EncodeDel | EncodeLeftSpace | EncodeRightPeriod,
		in:   "＞.K［ρ］ｚ␖κ＾\x1b.\x16α~V\x02\t？５＜vψ␁fｑχ␟.␠",
		out:  "＞.K［ρ］ｚ␖κ＾\x1b.\x16α~V\x02\t？５＜vψ␁fｑχ␟.␠",
	}, { // 572
		mask: EncodeCtl | EncodeLeftSpace | EncodeRightPeriod,
		in:   " .ζε\x1e/8\x1cＨμ␂\x1aIＴSψ␉ρ＇（]N7ν＼／␃Ｅ.３",
		out:  "␠.ζε␞/8␜Ｈμ‛␂␚IＴSψ‛␉ρ＇（]N7ν＼／‛␃Ｅ.３",
	}, { // 573
		mask: EncodeCtl | EncodeLeftSpace | EncodeRightPeriod,
		in:   "␠.ζε\x1e/8\x1cＨμ␂\x1aIＴSψ␉ρ＇（]N7ν＼／␃Ｅ.３",
		out:  "‛␠.ζε␞/8␜Ｈμ‛␂␚IＴSψ‛␉ρ＇（]N7ν＼／‛␃Ｅ.３",
	}, { // 574
		mask: EncodeCtl | EncodeLeftSpace | EncodeRightPeriod,
		in:   "｀.ζε\x1e/8\x1cＨμ␂\x1aIＴSψ␉ρ＇（]N7ν＼／␃Ｅ. ",
		out:  "｀.ζε␞/8␜Ｈμ‛␂␚IＴSψ‛␉ρ＇（]N7ν＼／‛␃Ｅ. ",
	}, { // 575
		mask: EncodeCtl | EncodeLeftSpace | EncodeRightPeriod,
		in:   "｀.ζε\x1e/8\x1cＨμ␂\x1aIＴSψ␉ρ＇（]N7ν＼／␃Ｅ.␠",
		out:  "｀.ζε␞/8␜Ｈμ‛␂␚IＴSψ‛␉ρ＇（]N7ν＼／‛␃Ｅ.␠",
	}, { // 576
		mask: EncodeZero | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   " \t]ｙＦπ\x15ε％␅σ］d\x02\x0fV３φＤ＞␉\x11Sｑ\x15u␂?\t␚",
		out:  "␠\t]ｙＦπ\x15ε％␅σ］d\x02\x0fV３φＤ＞␉\x11Sｑ\x15u␂?\t␚",
	}, { // 577
		mask: EncodeZero | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "␠\t]ｙＦπ\x15ε％␅σ］d\x02\x0fV３φＤ＞␉\x11Sｑ\x15u␂?\t␚",
		out:  "‛␠\t]ｙＦπ\x15ε％␅σ］d\x02\x0fV３φＤ＞␉\x11Sｑ\x15u␂?\t␚",
	}, { // 578
		mask: EncodeZero | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   " \n]ｙＦπ\x15ε％␅σ］d\x02\x0fV３φＤ＞␉\x11Sｑ\x15u␂?\n␚",
		out:  "␠\n]ｙＦπ\x15ε％␅σ］d\x02\x0fV３φＤ＞␉\x11Sｑ\x15u␂?\n␚",
	}, { // 579
		mask: EncodeZero | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "␠\n]ｙＦπ\x15ε％␅σ］d\x02\x0fV３φＤ＞␉\x11Sｑ\x15u␂?\n␚",
		out:  "‛␠\n]ｙＦπ\x15ε％␅σ］d\x02\x0fV３φＤ＞␉\x11Sｑ\x15u␂?\n␚",
	}, { // 580
		mask: EncodeZero | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   " \v]ｙＦπ\x15ε％␅σ］d\x02\x0fV３φＤ＞␉\x11Sｑ\x15u␂?\v␚",
		out:  "␠\v]ｙＦπ\x15ε％␅σ］d\x02\x0fV３φＤ＞␉\x11Sｑ\x15u␂?\v␚",
	}, { // 581
		mask: EncodeZero | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "␠\v]ｙＦπ\x15ε％␅σ］d\x02\x0fV３φＤ＞␉\x11Sｑ\x15u␂?\v␚",
		out:  "‛␠\v]ｙＦπ\x15ε％␅σ］d\x02\x0fV３φＤ＞␉\x11Sｑ\x15u␂?\v␚",
	}, { // 582
		mask: EncodeZero | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   " \r]ｙＦπ\x15ε％␅σ］d\x02\x0fV３φＤ＞␉\x11Sｑ\x15u␂?\r␚",
		out:  "␠\r]ｙＦπ\x15ε％␅σ］d\x02\x0fV３φＤ＞␉\x11Sｑ\x15u␂?\r␚",
	}, { // 583
		mask: EncodeZero | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "␠\r]ｙＦπ\x15ε％␅σ］d\x02\x0fV３φＤ＞␉\x11Sｑ\x15u␂?\r␚",
		out:  "‛␠\r]ｙＦπ\x15ε％␅σ］d\x02\x0fV３φＤ＞␉\x11Sｑ\x15u␂?\r␚",
	}, { // 584
		mask: EncodeZero | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "ζ\t]ｙＦπ\x15ε％␅σ］d\x02\x0fV３φＤ＞␉\x11Sｑ\x15u␂?\t ",
		out:  "ζ\t]ｙＦπ\x15ε％␅σ］d\x02\x0fV３φＤ＞␉\x11Sｑ\x15u␂?\t ",
	}, { // 585
		mask: EncodeZero | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "ζ\t]ｙＦπ\x15ε％␅σ］d\x02\x0fV３φＤ＞␉\x11Sｑ\x15u␂?\t␠",
		out:  "ζ\t]ｙＦπ\x15ε％␅σ］d\x02\x0fV３φＤ＞␉\x11Sｑ\x15u␂?\t␠",
	}, { // 586
		mask: EncodeZero | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "ζ\n]ｙＦπ\x15ε％␅σ］d\x02\x0fV３φＤ＞␉\x11Sｑ\x15u␂?\n ",
		out:  "ζ\n]ｙＦπ\x15ε％␅σ］d\x02\x0fV３φＤ＞␉\x11Sｑ\x15u␂?\n ",
	}, { // 587
		mask: EncodeZero | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "ζ\n]ｙＦπ\x15ε％␅σ］d\x02\x0fV３φＤ＞␉\x11Sｑ\x15u␂?\n␠",
		out:  "ζ\n]ｙＦπ\x15ε％␅σ］d\x02\x0fV３φＤ＞␉\x11Sｑ\x15u␂?\n␠",
	}, { // 588
		mask: EncodeZero | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "ζ\v]ｙＦπ\x15ε％␅σ］d\x02\x0fV３φＤ＞␉\x11Sｑ\x15u␂?\v ",
		out:  "ζ\v]ｙＦπ\x15ε％␅σ］d\x02\x0fV３φＤ＞␉\x11Sｑ\x15u␂?\v ",
	}, { // 589
		mask: EncodeZero | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "ζ\v]ｙＦπ\x15ε％␅σ］d\x02\x0fV３φＤ＞␉\x11Sｑ\x15u␂?\v␠",
		out:  "ζ\v]ｙＦπ\x15ε％␅σ］d\x02\x0fV３φＤ＞␉\x11Sｑ\x15u␂?\v␠",
	}, { // 590
		mask: EncodeZero | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "ζ\r]ｙＦπ\x15ε％␅σ］d\x02\x0fV３φＤ＞␉\x11Sｑ\x15u␂?\r ",
		out:  "ζ\r]ｙＦπ\x15ε％␅σ］d\x02\x0fV３φＤ＞␉\x11Sｑ\x15u␂?\r ",
	}, { // 591
		mask: EncodeZero | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "ζ\r]ｙＦπ\x15ε％␅σ］d\x02\x0fV３φＤ＞␉\x11Sｑ\x15u␂?\r␠",
		out:  "ζ\r]ｙＦπ\x15ε％␅σ］d\x02\x0fV３φＤ＞␉\x11Sｑ\x15u␂?\r␠",
	}, { // 592
		mask: EncodeSlash | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   " \t％＜%ζｅf␙ξγ;␎\x03＂eｂ\x1fδ|$C\x0eρ＾Ｄ！␉\tη",
		out:  "␠\t％＜%ζｅf␙ξγ;␎\x03＂eｂ\x1fδ|$C\x0eρ＾Ｄ！␉\tη",
	}, { // 593
		mask: EncodeSlash | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "␠\t％＜%ζｅf␙ξγ;␎\x03＂eｂ\x1fδ|$C\x0eρ＾Ｄ！␉\tη",
		out:  "‛␠\t％＜%ζｅf␙ξγ;␎\x03＂eｂ\x1fδ|$C\x0eρ＾Ｄ！␉\tη",
	}, { // 594
		mask: EncodeSlash | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   " \n％＜%ζｅf␙ξγ;␎\x03＂eｂ\x1fδ|$C\x0eρ＾Ｄ！␉\nη",
		out:  "␠\n％＜%ζｅf␙ξγ;␎\x03＂eｂ\x1fδ|$C\x0eρ＾Ｄ！␉\nη",
	}, { // 595
		mask: EncodeSlash | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "␠\n％＜%ζｅf␙ξγ;␎\x03＂eｂ\x1fδ|$C\x0eρ＾Ｄ！␉\nη",
		out:  "‛␠\n％＜%ζｅf␙ξγ;␎\x03＂eｂ\x1fδ|$C\x0eρ＾Ｄ！␉\nη",
	}, { // 596
		mask: EncodeSlash | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   " \v％＜%ζｅf␙ξγ;␎\x03＂eｂ\x1fδ|$C\x0eρ＾Ｄ！␉\vη",
		out:  "␠\v％＜%ζｅf␙ξγ;␎\x03＂eｂ\x1fδ|$C\x0eρ＾Ｄ！␉\vη",
	}, { // 597
		mask: EncodeSlash | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "␠\v％＜%ζｅf␙ξγ;␎\x03＂eｂ\x1fδ|$C\x0eρ＾Ｄ！␉\vη",
		out:  "‛␠\v％＜%ζｅf␙ξγ;␎\x03＂eｂ\x1fδ|$C\x0eρ＾Ｄ！␉\vη",
	}, { // 598
		mask: EncodeSlash | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   " \r％＜%ζｅf␙ξγ;␎\x03＂eｂ\x1fδ|$C\x0eρ＾Ｄ！␉\rη",
		out:  "␠\r％＜%ζｅf␙ξγ;␎\x03＂eｂ\x1fδ|$C\x0eρ＾Ｄ！␉\rη",
	}, { // 599
		mask: EncodeSlash | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "␠\r％＜%ζｅf␙ξγ;␎\x03＂eｂ\x1fδ|$C\x0eρ＾Ｄ！␉\rη",
		out:  "‛␠\r％＜%ζｅf␙ξγ;␎\x03＂eｂ\x1fδ|$C\x0eρ＾Ｄ！␉\rη",
	}, { // 600
		mask: EncodeSlash | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "＾\t％＜%ζｅf␙ξγ;␎\x03＂eｂ\x1fδ|$C\x0eρ＾Ｄ！␉\t ",
		out:  "＾\t％＜%ζｅf␙ξγ;␎\x03＂eｂ\x1fδ|$C\x0eρ＾Ｄ！␉\t ",
	}, { // 601
		mask: EncodeSlash | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "＾\t％＜%ζｅf␙ξγ;␎\x03＂eｂ\x1fδ|$C\x0eρ＾Ｄ！␉\t␠",
		out:  "＾\t％＜%ζｅf␙ξγ;␎\x03＂eｂ\x1fδ|$C\x0eρ＾Ｄ！␉\t␠",
	}, { // 602
		mask: EncodeSlash | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "＾\n％＜%ζｅf␙ξγ;␎\x03＂eｂ\x1fδ|$C\x0eρ＾Ｄ！␉\n ",
		out:  "＾\n％＜%ζｅf␙ξγ;␎\x03＂eｂ\x1fδ|$C\x0eρ＾Ｄ！␉\n ",
	}, { // 603
		mask: EncodeSlash | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "＾\n％＜%ζｅf␙ξγ;␎\x03＂eｂ\x1fδ|$C\x0eρ＾Ｄ！␉\n␠",
		out:  "＾\n％＜%ζｅf␙ξγ;␎\x03＂eｂ\x1fδ|$C\x0eρ＾Ｄ！␉\n␠",
	}, { // 604
		mask: EncodeSlash | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "＾\v％＜%ζｅf␙ξγ;␎\x03＂eｂ\x1fδ|$C\x0eρ＾Ｄ！␉\v ",
		out:  "＾\v％＜%ζｅf␙ξγ;␎\x03＂eｂ\x1fδ|$C\x0eρ＾Ｄ！␉\v ",
	}, { // 605
		mask: EncodeSlash | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "＾\v％＜%ζｅf␙ξγ;␎\x03＂eｂ\x1fδ|$C\x0eρ＾Ｄ！␉\v␠",
		out:  "＾\v％＜%ζｅf␙ξγ;␎\x03＂eｂ\x1fδ|$C\x0eρ＾Ｄ！␉\v␠",
	}, { // 606
		mask: EncodeSlash | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "＾\r％＜%ζｅf␙ξγ;␎\x03＂eｂ\x1fδ|$C\x0eρ＾Ｄ！␉\r ",
		out:  "＾\r％＜%ζｅf␙ξγ;␎\x03＂eｂ\x1fδ|$C\x0eρ＾Ｄ！␉\r ",
	}, { // 607
		mask: EncodeSlash | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "＾\r％＜%ζｅf␙ξγ;␎\x03＂eｂ\x1fδ|$C\x0eρ＾Ｄ！␉\r␠",
		out:  "＾\r％＜%ζｅf␙ξγ;␎\x03＂eｂ\x1fδ|$C\x0eρ＾Ｄ！␉\r␠",
	}, { // 608
		mask: EncodeSingleQuote | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   " \t␝\x1aρＷerχξ␐ν/␙Bξ\x1e\x1e;\x02Ｓ，\x1f␙Ｗ＄υ\x12\tw",
		out:  "␠\t␝\x1aρＷerχξ␐ν/␙Bξ\x1e\x1e;\x02Ｓ，\x1f␙Ｗ＄υ\x12\tw",
	}, { // 609
		mask: EncodeSingleQuote | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "␠\t␝\x1aρＷerχξ␐ν/␙Bξ\x1e\x1e;\x02Ｓ，\x1f␙Ｗ＄υ\x12\tw",
		out:  "‛␠\t␝\x1aρＷerχξ␐ν/␙Bξ\x1e\x1e;\x02Ｓ，\x1f␙Ｗ＄υ\x12\tw",
	}, { // 610
		mask: EncodeSingleQuote | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   " \n␝\x1aρＷerχξ␐ν/␙Bξ\x1e\x1e;\x02Ｓ，\x1f␙Ｗ＄υ\x12\nw",
		out:  "␠\n␝\x1aρＷerχξ␐ν/␙Bξ\x1e\x1e;\x02Ｓ，\x1f␙Ｗ＄υ\x12\nw",
	}, { // 611
		mask: EncodeSingleQuote | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "␠\n␝\x1aρＷerχξ␐ν/␙Bξ\x1e\x1e;\x02Ｓ，\x1f␙Ｗ＄υ\x12\nw",
		out:  "‛␠\n␝\x1aρＷerχξ␐ν/␙Bξ\x1e\x1e;\x02Ｓ，\x1f␙Ｗ＄υ\x12\nw",
	}, { // 612
		mask: EncodeSingleQuote | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   " \v␝\x1aρＷerχξ␐ν/␙Bξ\x1e\x1e;\x02Ｓ，\x1f␙Ｗ＄υ\x12\vw",
		out:  "␠\v␝\x1aρＷerχξ␐ν/␙Bξ\x1e\x1e;\x02Ｓ，\x1f␙Ｗ＄υ\x12\vw",
	}, { // 613
		mask: EncodeSingleQuote | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "␠\v␝\x1aρＷerχξ␐ν/␙Bξ\x1e\x1e;\x02Ｓ，\x1f␙Ｗ＄υ\x12\vw",
		out:  "‛␠\v␝\x1aρＷerχξ␐ν/␙Bξ\x1e\x1e;\x02Ｓ，\x1f␙Ｗ＄υ\x12\vw",
	}, { // 614
		mask: EncodeSingleQuote | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   " \r␝\x1aρＷerχξ␐ν/␙Bξ\x1e\x1e;\x02Ｓ，\x1f␙Ｗ＄υ\x12\rw",
		out:  "␠\r␝\x1aρＷerχξ␐ν/␙Bξ\x1e\x1e;\x02Ｓ，\x1f␙Ｗ＄υ\x12\rw",
	}, { // 615
		mask: EncodeSingleQuote | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "␠\r␝\x1aρＷerχξ␐ν/␙Bξ\x1e\x1e;\x02Ｓ，\x1f␙Ｗ＄υ\x12\rw",
		out:  "‛␠\r␝\x1aρＷerχξ␐ν/␙Bξ\x1e\x1e;\x02Ｓ，\x1f␙Ｗ＄υ\x12\rw",
	}, { // 616
		mask: EncodeSingleQuote | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "＝\t␝\x1aρＷerχξ␐ν/␙Bξ\x1e\x1e;\x02Ｓ，\x1f␙Ｗ＄υ\x12\t ",
		out:  "＝\t␝\x1aρＷerχξ␐ν/␙Bξ\x1e\x1e;\x02Ｓ，\x1f␙Ｗ＄υ\x12\t ",
	}, { // 617
		mask: EncodeSingleQuote | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "＝\t␝\x1aρＷerχξ␐ν/␙Bξ\x1e\x1e;\x02Ｓ，\x1f␙Ｗ＄υ\x12\t␠",
		out:  "＝\t␝\x1aρＷerχξ␐ν/␙Bξ\x1e\x1e;\x02Ｓ，\x1f␙Ｗ＄υ\x12\t␠",
	}, { // 618
		mask: EncodeSingleQuote | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "＝\n␝\x1aρＷerχξ␐ν/␙Bξ\x1e\x1e;\x02Ｓ，\x1f␙Ｗ＄υ\x12\n ",
		out:  "＝\n␝\x1aρＷerχξ␐ν/␙Bξ\x1e\x1e;\x02Ｓ，\x1f␙Ｗ＄υ\x12\n ",
	}, { // 619
		mask: EncodeSingleQuote | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "＝\n␝\x1aρＷerχξ␐ν/␙Bξ\x1e\x1e;\x02Ｓ，\x1f␙Ｗ＄υ\x12\n␠",
		out:  "＝\n␝\x1aρＷerχξ␐ν/␙Bξ\x1e\x1e;\x02Ｓ，\x1f␙Ｗ＄υ\x12\n␠",
	}, { // 620
		mask: EncodeSingleQuote | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "＝\v␝\x1aρＷerχξ␐ν/␙Bξ\x1e\x1e;\x02Ｓ，\x1f␙Ｗ＄υ\x12\v ",
		out:  "＝\v␝\x1aρＷerχξ␐ν/␙Bξ\x1e\x1e;\x02Ｓ，\x1f␙Ｗ＄υ\x12\v ",
	}, { // 621
		mask: EncodeSingleQuote | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "＝\v␝\x1aρＷerχξ␐ν/␙Bξ\x1e\x1e;\x02Ｓ，\x1f␙Ｗ＄υ\x12\v␠",
		out:  "＝\v␝\x1aρＷerχξ␐ν/␙Bξ\x1e\x1e;\x02Ｓ，\x1f␙Ｗ＄υ\x12\v␠",
	}, { // 622
		mask: EncodeSingleQuote | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "＝\r␝\x1aρＷerχξ␐ν/␙Bξ\x1e\x1e;\x02Ｓ，\x1f␙Ｗ＄υ\x12\r ",
		out:  "＝\r␝\x1aρＷerχξ␐ν/␙Bξ\x1e\x1e;\x02Ｓ，\x1f␙Ｗ＄υ\x12\r ",
	}, { // 623
		mask: EncodeSingleQuote | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "＝\r␝\x1aρＷerχξ␐ν/␙Bξ\x1e\x1e;\x02Ｓ，\x1f␙Ｗ＄υ\x12\r␠",
		out:  "＝\r␝\x1aρＷerχξ␐ν/␙Bξ\x1e\x1e;\x02Ｓ，\x1f␙Ｗ＄υ\x12\r␠",
	}, { // 624
		mask: EncodeBackQuote | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   " \t'ι?？\x14φ/ＫJｃ,␊\t␆\x19＜ξ>ξWY␗Ｆ?１Ｆ\t␐",
		out:  "␠\t'ι?？\x14φ/ＫJｃ,␊\t␆\x19＜ξ>ξWY␗Ｆ?１Ｆ\t␐",
	}, { // 625
		mask: EncodeBackQuote | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "␠\t'ι?？\x14φ/ＫJｃ,␊\t␆\x19＜ξ>ξWY␗Ｆ?１Ｆ\t␐",
		out:  "‛␠\t'ι?？\x14φ/ＫJｃ,␊\t␆\x19＜ξ>ξWY␗Ｆ?１Ｆ\t␐",
	}, { // 626
		mask: EncodeBackQuote | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   " \n'ι?？\x14φ/ＫJｃ,␊\t␆\x19＜ξ>ξWY␗Ｆ?１Ｆ\n␐",
		out:  "␠\n'ι?？\x14φ/ＫJｃ,␊\t␆\x19＜ξ>ξWY␗Ｆ?１Ｆ\n␐",
	}, { // 627
		mask: EncodeBackQuote | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "␠\n'ι?？\x14φ/ＫJｃ,␊\t␆\x19＜ξ>ξWY␗Ｆ?１Ｆ\n␐",
		out:  "‛␠\n'ι?？\x14φ/ＫJｃ,␊\t␆\x19＜ξ>ξWY␗Ｆ?１Ｆ\n␐",
	}, { // 628
		mask: EncodeBackQuote | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   " \v'ι?？\x14φ/ＫJｃ,␊\t␆\x19＜ξ>ξWY␗Ｆ?１Ｆ\v␐",
		out:  "␠\v'ι?？\x14φ/ＫJｃ,␊\t␆\x19＜ξ>ξWY␗Ｆ?１Ｆ\v␐",
	}, { // 629
		mask: EncodeBackQuote | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "␠\v'ι?？\x14φ/ＫJｃ,␊\t␆\x19＜ξ>ξWY␗Ｆ?１Ｆ\v␐",
		out:  "‛␠\v'ι?？\x14φ/ＫJｃ,␊\t␆\x19＜ξ>ξWY␗Ｆ?１Ｆ\v␐",
	}, { // 630
		mask: EncodeBackQuote | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   " \r'ι?？\x14φ/ＫJｃ,␊\t␆\x19＜ξ>ξWY␗Ｆ?１Ｆ\r␐",
		out:  "␠\r'ι?？\x14φ/ＫJｃ,␊\t␆\x19＜ξ>ξWY␗Ｆ?１Ｆ\r␐",
	}, { // 631
		mask: EncodeBackQuote | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "␠\r'ι?？\x14φ/ＫJｃ,␊\t␆\x19＜ξ>ξWY␗Ｆ?１Ｆ\r␐",
		out:  "‛␠\r'ι?？\x14φ/ＫJｃ,␊\t␆\x19＜ξ>ξWY␗Ｆ?１Ｆ\r␐",
	}, { // 632
		mask: EncodeBackQuote | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "ν\t'ι?？\x14φ/ＫJｃ,␊\t␆\x19＜ξ>ξWY␗Ｆ?１Ｆ\t ",
		out:  "ν\t'ι?？\x14φ/ＫJｃ,␊\t␆\x19＜ξ>ξWY␗Ｆ?１Ｆ\t ",
	}, { // 633
		mask: EncodeBackQuote | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "ν\t'ι?？\x14φ/ＫJｃ,␊\t␆\x19＜ξ>ξWY␗Ｆ?１Ｆ\t␠",
		out:  "ν\t'ι?？\x14φ/ＫJｃ,␊\t␆\x19＜ξ>ξWY␗Ｆ?１Ｆ\t␠",
	}, { // 634
		mask: EncodeBackQuote | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "ν\n'ι?？\x14φ/ＫJｃ,␊\t␆\x19＜ξ>ξWY␗Ｆ?１Ｆ\n ",
		out:  "ν\n'ι?？\x14φ/ＫJｃ,␊\t␆\x19＜ξ>ξWY␗Ｆ?１Ｆ\n ",
	}, { // 635
		mask: EncodeBackQuote | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "ν\n'ι?？\x14φ/ＫJｃ,␊\t␆\x19＜ξ>ξWY␗Ｆ?１Ｆ\n␠",
		out:  "ν\n'ι?？\x14φ/ＫJｃ,␊\t␆\x19＜ξ>ξWY␗Ｆ?１Ｆ\n␠",
	}, { // 636
		mask: EncodeBackQuote | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "ν\v'ι?？\x14φ/ＫJｃ,␊\t␆\x19＜ξ>ξWY␗Ｆ?１Ｆ\v ",
		out:  "ν\v'ι?？\x14φ/ＫJｃ,␊\t␆\x19＜ξ>ξWY␗Ｆ?１Ｆ\v ",
	}, { // 637
		mask: EncodeBackQuote | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "ν\v'ι?？\x14φ/ＫJｃ,␊\t␆\x19＜ξ>ξWY␗Ｆ?１Ｆ\v␠",
		out:  "ν\v'ι?？\x14φ/ＫJｃ,␊\t␆\x19＜ξ>ξWY␗Ｆ?１Ｆ\v␠",
	}, { // 638
		mask: EncodeBackQuote | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "ν\r'ι?？\x14φ/ＫJｃ,␊\t␆\x19＜ξ>ξWY␗Ｆ?１Ｆ\r ",
		out:  "ν\r'ι?？\x14φ/ＫJｃ,␊\t␆\x19＜ξ>ξWY␗Ｆ?１Ｆ\r ",
	}, { // 639
		mask: EncodeBackQuote | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "ν\r'ι?？\x14φ/ＫJｃ,␊\t␆\x19＜ξ>ξWY␗Ｆ?１Ｆ\r␠",
		out:  "ν\r'ι?？\x14φ/ＫJｃ,␊\t␆\x19＜ξ>ξWY␗Ｆ?１Ｆ\r␠",
	}, { // 640
		mask: EncodeLtGt | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   " \t:χEGｄｅνE\x1eρＲ␎␏［␔β\x1bλη％␊\\l<␡\x1c\tＰ",
		out:  "␠\t:χEGｄｅνE\x1eρＲ␎␏［␔β\x1bλη％␊\\l＜␡\x1c\tＰ",
	}, { // 641
		mask: EncodeLtGt | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "␠\t:χEGｄｅνE\x1eρＲ␎␏［␔β\x1bλη％␊\\l<␡\x1c\tＰ",
		out:  "‛␠\t:χEGｄｅνE\x1eρＲ␎␏［␔β\x1bλη％␊\\l＜␡\x1c\tＰ",
	}, { // 642
		mask: EncodeLtGt | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   " \n:χEGｄｅνE\x1eρＲ␎␏［␔β\x1bλη％␊\\l<␡\x1c\nＰ",
		out:  "␠\n:χEGｄｅνE\x1eρＲ␎␏［␔β\x1bλη％␊\\l＜␡\x1c\nＰ",
	}, { // 643
		mask: EncodeLtGt | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "␠\n:χEGｄｅνE\x1eρＲ␎␏［␔β\x1bλη％␊\\l<␡\x1c\nＰ",
		out:  "‛␠\n:χEGｄｅνE\x1eρＲ␎␏［␔β\x1bλη％␊\\l＜␡\x1c\nＰ",
	}, { // 644
		mask: EncodeLtGt | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   " \v:χEGｄｅνE\x1eρＲ␎␏［␔β\x1bλη％␊\\l<␡\x1c\vＰ",
		out:  "␠\v:χEGｄｅνE\x1eρＲ␎␏［␔β\x1bλη％␊\\l＜␡\x1c\vＰ",
	}, { // 645
		mask: EncodeLtGt | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "␠\v:χEGｄｅνE\x1eρＲ␎␏［␔β\x1bλη％␊\\l<␡\x1c\vＰ",
		out:  "‛␠\v:χEGｄｅνE\x1eρＲ␎␏［␔β\x1bλη％␊\\l＜␡\x1c\vＰ",
	}, { // 646
		mask: EncodeLtGt | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   " \r:χEGｄｅνE\x1eρＲ␎␏［␔β\x1bλη％␊\\l<␡\x1c\rＰ",
		out:  "␠\r:χEGｄｅνE\x1eρＲ␎␏［␔β\x1bλη％␊\\l＜␡\x1c\rＰ",
	}, { // 647
		mask: EncodeLtGt | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "␠\r:χEGｄｅνE\x1eρＲ␎␏［␔β\x1bλη％␊\\l<␡\x1c\rＰ",
		out:  "‛␠\r:χEGｄｅνE\x1eρＲ␎␏［␔β\x1bλη％␊\\l＜␡\x1c\rＰ",
	}, { // 648
		mask: EncodeLtGt | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "\x00\t:χEGｄｅνE\x1eρＲ␎␏［␔β\x1bλη％␊\\l<␡\x1c\t ",
		out:  "␀\t:χEGｄｅνE\x1eρＲ␎␏［␔β\x1bλη％␊\\l＜␡\x1c\t ",
	}, { // 649
		mask: EncodeLtGt | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "\x00\t:χEGｄｅνE\x1eρＲ␎␏［␔β\x1bλη％␊\\l<␡\x1c\t␠",
		out:  "␀\t:χEGｄｅνE\x1eρＲ␎␏［␔β\x1bλη％␊\\l＜␡\x1c\t␠",
	}, { // 650
		mask: EncodeLtGt | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "\x00\n:χEGｄｅνE\x1eρＲ␎␏［␔β\x1bλη％␊\\l<␡\x1c\n ",
		out:  "␀\n:χEGｄｅνE\x1eρＲ␎␏［␔β\x1bλη％␊\\l＜␡\x1c\n ",
	}, { // 651
		mask: EncodeLtGt | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "\x00\n:χEGｄｅνE\x1eρＲ␎␏［␔β\x1bλη％␊\\l<␡\x1c\n␠",
		out:  "␀\n:χEGｄｅνE\x1eρＲ␎␏［␔β\x1bλη％␊\\l＜␡\x1c\n␠",
	}, { // 652
		mask: EncodeLtGt | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "\x00\v:χEGｄｅνE\x1eρＲ␎␏［␔β\x1bλη％␊\\l<␡\x1c\v ",
		out:  "␀\v:χEGｄｅνE\x1eρＲ␎␏［␔β\x1bλη％␊\\l＜␡\x1c\v ",
	}, { // 653
		mask: EncodeLtGt | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "\x00\v:χEGｄｅνE\x1eρＲ␎␏［␔β\x1bλη％␊\\l<␡\x1c\v␠",
		out:  "␀\v:χEGｄｅνE\x1eρＲ␎␏［␔β\x1bλη％␊\\l＜␡\x1c\v␠",
	}, { // 654
		mask: EncodeLtGt | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "\x00\r:χEGｄｅνE\x1eρＲ␎␏［␔β\x1bλη％␊\\l<␡\x1c\r ",
		out:  "␀\r:χEGｄｅνE\x1eρＲ␎␏［␔β\x1bλη％␊\\l＜␡\x1c\r ",
	}, { // 655
		mask: EncodeLtGt | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "\x00\r:χEGｄｅνE\x1eρＲ␎␏［␔β\x1bλη％␊\\l<␡\x1c\r␠",
		out:  "␀\r:χEGｄｅνE\x1eρＲ␎␏［␔β\x1bλη％␊\\l＜␡\x1c\r␠",
	}, { // 656
		mask: EncodeSquareBracket | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   " \t$␏＋：Vν\x17π，θξ|\u007fＤＣ0]␁９Dｉ＼βε␏＄\t\x03",
		out:  "␠\t$␏＋：Vν\x17π，θξ|\u007fＤＣ0］␁９Dｉ＼βε␏＄\t\x03",
	}, { // 657
		mask: EncodeSquareBracket | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "␠\t$␏＋：Vν\x17π，θξ|\u007fＤＣ0]␁９Dｉ＼βε␏＄\t\x03",
		out:  "‛␠\t$␏＋：Vν\x17π，θξ|\u007fＤＣ0］␁９Dｉ＼βε␏＄\t\x03",
	}, { // 658
		mask: EncodeSquareBracket | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   " \n$␏＋：Vν\x17π，θξ|\u007fＤＣ0]␁９Dｉ＼βε␏＄\n\x03",
		out:  "␠\n$␏＋：Vν\x17π，θξ|\u007fＤＣ0］␁９Dｉ＼βε␏＄\n\x03",
	}, { // 659
		mask: EncodeSquareBracket | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "␠\n$␏＋：Vν\x17π，θξ|\u007fＤＣ0]␁９Dｉ＼βε␏＄\n\x03",
		out:  "‛␠\n$␏＋：Vν\x17π，θξ|\u007fＤＣ0］␁９Dｉ＼βε␏＄\n\x03",
	}, { // 660
		mask: EncodeSquareBracket | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   " \v$␏＋：Vν\x17π，θξ|\u007fＤＣ0]␁９Dｉ＼βε␏＄\v\x03",
		out:  "␠\v$␏＋：Vν\x17π，θξ|\u007fＤＣ0］␁９Dｉ＼βε␏＄\v\x03",
	}, { // 661
		mask: EncodeSquareBracket | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "␠\v$␏＋：Vν\x17π，θξ|\u007fＤＣ0]␁９Dｉ＼βε␏＄\v\x03",
		out:  "‛␠\v$␏＋：Vν\x17π，θξ|\u007fＤＣ0］␁９Dｉ＼βε␏＄\v\x03",
	}, { // 662
		mask: EncodeSquareBracket | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   " \r$␏＋：Vν\x17π，θξ|\u007fＤＣ0]␁９Dｉ＼βε␏＄\r\x03",
		out:  "␠\r$␏＋：Vν\x17π，θξ|\u007fＤＣ0］␁９Dｉ＼βε␏＄\r\x03",
	}, { // 663
		mask: EncodeSquareBracket | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "␠\r$␏＋：Vν\x17π，θξ|\u007fＤＣ0]␁９Dｉ＼βε␏＄\r\x03",
		out:  "‛␠\r$␏＋：Vν\x17π，θξ|\u007fＤＣ0］␁９Dｉ＼βε␏＄\r\x03",
	}, { // 664
		mask: EncodeSquareBracket | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "`\t$␏＋：Vν\x17π，θξ|\u007fＤＣ0]␁９Dｉ＼βε␏＄\t ",
		out:  "`\t$␏＋：Vν\x17π，θξ|\u007fＤＣ0］␁９Dｉ＼βε␏＄\t ",
	}, { // 665
		mask: EncodeSquareBracket | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "`\t$␏＋：Vν\x17π，θξ|\u007fＤＣ0]␁９Dｉ＼βε␏＄\t␠",
		out:  "`\t$␏＋：Vν\x17π，θξ|\u007fＤＣ0］␁９Dｉ＼βε␏＄\t␠",
	}, { // 666
		mask: EncodeSquareBracket | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "`\n$␏＋：Vν\x17π，θξ|\u007fＤＣ0]␁９Dｉ＼βε␏＄\n ",
		out:  "`\n$␏＋：Vν\x17π，θξ|\u007fＤＣ0］␁９Dｉ＼βε␏＄\n ",
	}, { // 667
		mask: EncodeSquareBracket | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "`\n$␏＋：Vν\x17π，θξ|\u007fＤＣ0]␁９Dｉ＼βε␏＄\n␠",
		out:  "`\n$␏＋：Vν\x17π，θξ|\u007fＤＣ0］␁９Dｉ＼βε␏＄\n␠",
	}, { // 668
		mask: EncodeSquareBracket | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "`\v$␏＋：Vν\x17π，θξ|\u007fＤＣ0]␁９Dｉ＼βε␏＄\v ",
		out:  "`\v$␏＋：Vν\x17π，θξ|\u007fＤＣ0］␁９Dｉ＼βε␏＄\v ",
	}, { // 669
		mask: EncodeSquareBracket | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "`\v$␏＋：Vν\x17π，θξ|\u007fＤＣ0]␁９Dｉ＼βε␏＄\v␠",
		out:  "`\v$␏＋：Vν\x17π，θξ|\u007fＤＣ0］␁９Dｉ＼βε␏＄\v␠",
	}, { // 670
		mask: EncodeSquareBracket | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "`\r$␏＋：Vν\x17π，θξ|\u007fＤＣ0]␁９Dｉ＼βε␏＄\r ",
		out:  "`\r$␏＋：Vν\x17π，θξ|\u007fＤＣ0］␁９Dｉ＼βε␏＄\r ",
	}, { // 671
		mask: EncodeSquareBracket | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "`\r$␏＋：Vν\x17π，θξ|\u007fＤＣ0]␁９Dｉ＼βε␏＄\r␠",
		out:  "`\r$␏＋：Vν\x17π，θξ|\u007fＤＣ0］␁９Dｉ＼βε␏＄\r␠",
	}, { // 672
		mask: EncodeSemicolon | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   " \t＞␛Ｚ｀\x01JhοＳ\t␎\x0f＃γχ＃ι␄Wςφz％\x026#\tｎ",
		out:  "␠\t＞␛Ｚ｀\x01JhοＳ\t␎\x0f＃γχ＃ι␄Wςφz％\x026#\tｎ",
	}, { // 673
		mask: EncodeSemicolon | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "␠\t＞␛Ｚ｀\x01JhοＳ\t␎\x0f＃γχ＃ι␄Wςφz％\x026#\tｎ",
		out:  "‛␠\t＞␛Ｚ｀\x01JhοＳ\t␎\x0f＃γχ＃ι␄Wςφz％\x026#\tｎ",
	}, { // 674
		mask: EncodeSemicolon | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   " \n＞␛Ｚ｀\x01JhοＳ\t␎\x0f＃γχ＃ι␄Wςφz％\x026#\nｎ",
		out:  "␠\n＞␛Ｚ｀\x01JhοＳ\t␎\x0f＃γχ＃ι␄Wςφz％\x026#\nｎ",
	}, { // 675
		mask: EncodeSemicolon | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "␠\n＞␛Ｚ｀\x01JhοＳ\t␎\x0f＃γχ＃ι␄Wςφz％\x026#\nｎ",
		out:  "‛␠\n＞␛Ｚ｀\x01JhοＳ\t␎\x0f＃γχ＃ι␄Wςφz％\x026#\nｎ",
	}, { // 676
		mask: EncodeSemicolon | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   " \v＞␛Ｚ｀\x01JhοＳ\t␎\x0f＃γχ＃ι␄Wςφz％\x026#\vｎ",
		out:  "␠\v＞␛Ｚ｀\x01JhοＳ\t␎\x0f＃γχ＃ι␄Wςφz％\x026#\vｎ",
	}, { // 677
		mask: EncodeSemicolon | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "␠\v＞␛Ｚ｀\x01JhοＳ\t␎\x0f＃γχ＃ι␄Wςφz％\x026#\vｎ",
		out:  "‛␠\v＞␛Ｚ｀\x01JhοＳ\t␎\x0f＃γχ＃ι␄Wςφz％\x026#\vｎ",
	}, { // 678
		mask: EncodeSemicolon | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   " \r＞␛Ｚ｀\x01JhοＳ\t␎\x0f＃γχ＃ι␄Wςφz％\x026#\rｎ",
		out:  "␠\r＞␛Ｚ｀\x01JhοＳ\t␎\x0f＃γχ＃ι␄Wςφz％\x026#\rｎ",
	}, { // 679
		mask: EncodeSemicolon | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "␠\r＞␛Ｚ｀\x01JhοＳ\t␎\x0f＃γχ＃ι␄Wςφz％\x026#\rｎ",
		out:  "‛␠\r＞␛Ｚ｀\x01JhοＳ\t␎\x0f＃γχ＃ι␄Wςφz％\x026#\rｎ",
	}, { // 680
		mask: EncodeSemicolon | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "\t\t＞␛Ｚ｀\x01JhοＳ\t␎\x0f＃γχ＃ι␄Wςφz％\x026#\t ",
		out:  "\t\t＞␛Ｚ｀\x01JhοＳ\t␎\x0f＃γχ＃ι␄Wςφz％\x026#\t ",
	}, { // 681
		mask: EncodeSemicolon | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "\t\t＞␛Ｚ｀\x01JhοＳ\t␎\x0f＃γχ＃ι␄Wςφz％\x026#\t␠",
		out:  "\t\t＞␛Ｚ｀\x01JhοＳ\t␎\x0f＃γχ＃ι␄Wςφz％\x026#\t␠",
	}, { // 682
		mask: EncodeSemicolon | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "\t\n＞␛Ｚ｀\x01JhοＳ\t␎\x0f＃γχ＃ι␄Wςφz％\x026#\n ",
		out:  "\t\n＞␛Ｚ｀\x01JhοＳ\t␎\x0f＃γχ＃ι␄Wςφz％\x026#\n ",
	}, { // 683
		mask: EncodeSemicolon | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "\t\n＞␛Ｚ｀\x01JhοＳ\t␎\x0f＃γχ＃ι␄Wςφz％\x026#\n␠",
		out:  "\t\n＞␛Ｚ｀\x01JhοＳ\t␎\x0f＃γχ＃ι␄Wςφz％\x026#\n␠",
	}, { // 684
		mask: EncodeSemicolon | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "\t\v＞␛Ｚ｀\x01JhοＳ\t␎\x0f＃γχ＃ι␄Wςφz％\x026#\v ",
		out:  "\t\v＞␛Ｚ｀\x01JhοＳ\t␎\x0f＃γχ＃ι␄Wςφz％\x026#\v ",
	}, { // 685
		mask: EncodeSemicolon | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "\t\v＞␛Ｚ｀\x01JhοＳ\t␎\x0f＃γχ＃ι␄Wςφz％\x026#\v␠",
		out:  "\t\v＞␛Ｚ｀\x01JhοＳ\t␎\x0f＃γχ＃ι␄Wςφz％\x026#\v␠",
	}, { // 686
		mask: EncodeSemicolon | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "\t\r＞␛Ｚ｀\x01JhοＳ\t␎\x0f＃γχ＃ι␄Wςφz％\x026#\r ",
		out:  "\t\r＞␛Ｚ｀\x01JhοＳ\t␎\x0f＃γχ＃ι␄Wςφz％\x026#\r ",
	}, { // 687
		mask: EncodeSemicolon | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "\t\r＞␛Ｚ｀\x01JhοＳ\t␎\x0f＃γχ＃ι␄Wςφz％\x026#\r␠",
		out:  "\t\r＞␛Ｚ｀\x01JhοＳ\t␎\x0f＃γχ＃ι␄Wςφz％\x026#\r␠",
	}, { // 688
		mask: EncodeDollar | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   " \t\x13＄\x1fχ\\＂ｆε␖2[\x1fρ␓７.Ｃ＃ο！\x192ε␟（n\tτ",
		out:  "␠\t\x13‛＄\x1fχ\\＂ｆε␖2[\x1fρ␓７.Ｃ＃ο！\x192ε␟（n\tτ",
	}, { // 689
		mask: EncodeDollar | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "␠\t\x13＄\x1fχ\\＂ｆε␖2[\x1fρ␓７.Ｃ＃ο！\x192ε␟（n\tτ",
		out:  "‛␠\t\x13‛＄\x1fχ\\＂ｆε␖2[\x1fρ␓７.Ｃ＃ο！\x192ε␟（n\tτ",
	}, { // 690
		mask: EncodeDollar | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   " \n\x13＄\x1fχ\\＂ｆε␖2[\x1fρ␓７.Ｃ＃ο！\x192ε␟（n\nτ",
		out:  "␠\n\x13‛＄\x1fχ\\＂ｆε␖2[\x1fρ␓７.Ｃ＃ο！\x192ε␟（n\nτ",
	}, { // 691
		mask: EncodeDollar | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "␠\n\x13＄\x1fχ\\＂ｆε␖2[\x1fρ␓７.Ｃ＃ο！\x192ε␟（n\nτ",
		out:  "‛␠\n\x13‛＄\x1fχ\\＂ｆε␖2[\x1fρ␓７.Ｃ＃ο！\x192ε␟（n\nτ",
	}, { // 692
		mask: EncodeDollar | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   " \v\x13＄\x1fχ\\＂ｆε␖2[\x1fρ␓７.Ｃ＃ο！\x192ε␟（n\vτ",
		out:  "␠\v\x13‛＄\x1fχ\\＂ｆε␖2[\x1fρ␓７.Ｃ＃ο！\x192ε␟（n\vτ",
	}, { // 693
		mask: EncodeDollar | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "␠\v\x13＄\x1fχ\\＂ｆε␖2[\x1fρ␓７.Ｃ＃ο！\x192ε␟（n\vτ",
		out:  "‛␠\v\x13‛＄\x1fχ\\＂ｆε␖2[\x1fρ␓７.Ｃ＃ο！\x192ε␟（n\vτ",
	}, { // 694
		mask: EncodeDollar | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   " \r\x13＄\x1fχ\\＂ｆε␖2[\x1fρ␓７.Ｃ＃ο！\x192ε␟（n\rτ",
		out:  "␠\r\x13‛＄\x1fχ\\＂ｆε␖2[\x1fρ␓７.Ｃ＃ο！\x192ε␟（n\rτ",
	}, { // 695
		mask: EncodeDollar | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "␠\r\x13＄\x1fχ\\＂ｆε␖2[\x1fρ␓７.Ｃ＃ο！\x192ε␟（n\rτ",
		out:  "‛␠\r\x13‛＄\x1fχ\\＂ｆε␖2[\x1fρ␓７.Ｃ＃ο！\x192ε␟（n\rτ",
	}, { // 696
		mask: EncodeDollar | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "␅\t\x13＄\x1fχ\\＂ｆε␖2[\x1fρ␓７.Ｃ＃ο！\x192ε␟（n\t ",
		out:  "␅\t\x13‛＄\x1fχ\\＂ｆε␖2[\x1fρ␓７.Ｃ＃ο！\x192ε␟（n\t ",
	}, { // 697
		mask: EncodeDollar | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "␅\t\x13＄\x1fχ\\＂ｆε␖2[\x1fρ␓７.Ｃ＃ο！\x192ε␟（n\t␠",
		out:  "␅\t\x13‛＄\x1fχ\\＂ｆε␖2[\x1fρ␓７.Ｃ＃ο！\x192ε␟（n\t␠",
	}, { // 698
		mask: EncodeDollar | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "␅\n\x13＄\x1fχ\\＂ｆε␖2[\x1fρ␓７.Ｃ＃ο！\x192ε␟（n\n ",
		out:  "␅\n\x13‛＄\x1fχ\\＂ｆε␖2[\x1fρ␓７.Ｃ＃ο！\x192ε␟（n\n ",
	}, { // 699
		mask: EncodeDollar | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "␅\n\x13＄\x1fχ\\＂ｆε␖2[\x1fρ␓７.Ｃ＃ο！\x192ε␟（n\n␠",
		out:  "␅\n\x13‛＄\x1fχ\\＂ｆε␖2[\x1fρ␓７.Ｃ＃ο！\x192ε␟（n\n␠",
	}, { // 700
		mask: EncodeDollar | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "␅\v\x13＄\x1fχ\\＂ｆε␖2[\x1fρ␓７.Ｃ＃ο！\x192ε␟（n\v ",
		out:  "␅\v\x13‛＄\x1fχ\\＂ｆε␖2[\x1fρ␓７.Ｃ＃ο！\x192ε␟（n\v ",
	}, { // 701
		mask: EncodeDollar | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "␅\v\x13＄\x1fχ\\＂ｆε␖2[\x1fρ␓７.Ｃ＃ο！\x192ε␟（n\v␠",
		out:  "␅\v\x13‛＄\x1fχ\\＂ｆε␖2[\x1fρ␓７.Ｃ＃ο！\x192ε␟（n\v␠",
	}, { // 702
		mask: EncodeDollar | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "␅\r\x13＄\x1fχ\\＂ｆε␖2[\x1fρ␓７.Ｃ＃ο！\x192ε␟（n\r ",
		out:  "␅\r\x13‛＄\x1fχ\\＂ｆε␖2[\x1fρ␓７.Ｃ＃ο！\x192ε␟（n\r ",
	}, { // 703
		mask: EncodeDollar | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "␅\r\x13＄\x1fχ\\＂ｆε␖2[\x1fρ␓７.Ｃ＃ο！\x192ε␟（n\r␠",
		out:  "␅\r\x13‛＄\x1fχ\\＂ｆε␖2[\x1fρ␓７.Ｃ＃ο！\x192ε␟（n\r␠",
	}, { // 704
		mask: EncodeDoubleQuote | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   " \t ？␂ｑ>＜ηψ]R（８~&ｓ_\f\\ν；＼γ0：α\x02\tｊ",
		out:  "␠\t ？␂ｑ>＜ηψ]R（８~&ｓ_\f\\ν；＼γ0：α\x02\tｊ",
	}, { // 705
		mask: EncodeDoubleQuote | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "␠\t ？␂ｑ>＜ηψ]R（８~&ｓ_\f\\ν；＼γ0：α\x02\tｊ",
		out:  "‛␠\t ？␂ｑ>＜ηψ]R（８~&ｓ_\f\\ν；＼γ0：α\x02\tｊ",
	}, { // 706
		mask: EncodeDoubleQuote | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   " \n ？␂ｑ>＜ηψ]R（８~&ｓ_\f\\ν；＼γ0：α\x02\nｊ",
		out:  "␠\n ？␂ｑ>＜ηψ]R（８~&ｓ_\f\\ν；＼γ0：α\x02\nｊ",
	}, { // 707
		mask: EncodeDoubleQuote | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "␠\n ？␂ｑ>＜ηψ]R（８~&ｓ_\f\\ν；＼γ0：α\x02\nｊ",
		out:  "‛␠\n ？␂ｑ>＜ηψ]R（８~&ｓ_\f\\ν；＼γ0：α\x02\nｊ",
	}, { // 708
		mask: EncodeDoubleQuote | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   " \v ？␂ｑ>＜ηψ]R（８~&ｓ_\f\\ν；＼γ0：α\x02\vｊ",
		out:  "␠\v ？␂ｑ>＜ηψ]R（８~&ｓ_\f\\ν；＼γ0：α\x02\vｊ",
	}, { // 709
		mask: EncodeDoubleQuote | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "␠\v ？␂ｑ>＜ηψ]R（８~&ｓ_\f\\ν；＼γ0：α\x02\vｊ",
		out:  "‛␠\v ？␂ｑ>＜ηψ]R（８~&ｓ_\f\\ν；＼γ0：α\x02\vｊ",
	}, { // 710
		mask: EncodeDoubleQuote | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   " \r ？␂ｑ>＜ηψ]R（８~&ｓ_\f\\ν；＼γ0：α\x02\rｊ",
		out:  "␠\r ？␂ｑ>＜ηψ]R（８~&ｓ_\f\\ν；＼γ0：α\x02\rｊ",
	}, { // 711
		mask: EncodeDoubleQuote | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "␠\r ？␂ｑ>＜ηψ]R（８~&ｓ_\f\\ν；＼γ0：α\x02\rｊ",
		out:  "‛␠\r ？␂ｑ>＜ηψ]R（８~&ｓ_\f\\ν；＼γ0：α\x02\rｊ",
	}, { // 712
		mask: EncodeDoubleQuote | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "\x1c\t ？␂ｑ>＜ηψ]R（８~&ｓ_\f\\ν；＼γ0：α\x02\t ",
		out:  "\x1c\t ？␂ｑ>＜ηψ]R（８~&ｓ_\f\\ν；＼γ0：α\x02\t ",
	}, { // 713
		mask: EncodeDoubleQuote | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "\x1c\t ？␂ｑ>＜ηψ]R（８~&ｓ_\f\\ν；＼γ0：α\x02\t␠",
		out:  "\x1c\t ？␂ｑ>＜ηψ]R（８~&ｓ_\f\\ν；＼γ0：α\x02\t␠",
	}, { // 714
		mask: EncodeDoubleQuote | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "\x1c\n ？␂ｑ>＜ηψ]R（８~&ｓ_\f\\ν；＼γ0：α\x02\n ",
		out:  "\x1c\n ？␂ｑ>＜ηψ]R（８~&ｓ_\f\\ν；＼γ0：α\x02\n ",
	}, { // 715
		mask: EncodeDoubleQuote | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "\x1c\n ？␂ｑ>＜ηψ]R（８~&ｓ_\f\\ν；＼γ0：α\x02\n␠",
		out:  "\x1c\n ？␂ｑ>＜ηψ]R（８~&ｓ_\f\\ν；＼γ0：α\x02\n␠",
	}, { // 716
		mask: EncodeDoubleQuote | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "\x1c\v ？␂ｑ>＜ηψ]R（８~&ｓ_\f\\ν；＼γ0：α\x02\v ",
		out:  "\x1c\v ？␂ｑ>＜ηψ]R（８~&ｓ_\f\\ν；＼γ0：α\x02\v ",
	}, { // 717
		mask: EncodeDoubleQuote | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "\x1c\v ？␂ｑ>＜ηψ]R（８~&ｓ_\f\\ν；＼γ0：α\x02\v␠",
		out:  "\x1c\v ？␂ｑ>＜ηψ]R（８~&ｓ_\f\\ν；＼γ0：α\x02\v␠",
	}, { // 718
		mask: EncodeDoubleQuote | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "\x1c\r ？␂ｑ>＜ηψ]R（８~&ｓ_\f\\ν；＼γ0：α\x02\r ",
		out:  "\x1c\r ？␂ｑ>＜ηψ]R（８~&ｓ_\f\\ν；＼γ0：α\x02\r ",
	}, { // 719
		mask: EncodeDoubleQuote | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "\x1c\r ？␂ｑ>＜ηψ]R（８~&ｓ_\f\\ν；＼γ0：α\x02\r␠",
		out:  "\x1c\r ？␂ｑ>＜ηψ]R（８~&ｓ_\f\\ν；＼γ0：α\x02\r␠",
	}, { // 720
		mask: EncodeColon | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   " \t)Ｈ１/(σ／␖/Ｕ␙｜v␕\nη｀\t␄α[+～χnθ\t;",
		out:  "␠\t)Ｈ１/(σ／␖/Ｕ␙｜v␕\nη｀\t␄α[+～χnθ\t;",
	}, { // 721
		mask: EncodeColon | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "␠\t)Ｈ１/(σ／␖/Ｕ␙｜v␕\nη｀\t␄α[+～χnθ\t;",
		out:  "‛␠\t)Ｈ１/(σ／␖/Ｕ␙｜v␕\nη｀\t␄α[+～χnθ\t;",
	}, { // 722
		mask: EncodeColon | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   " \n)Ｈ１/(σ／␖/Ｕ␙｜v␕\nη｀\t␄α[+～χnθ\n;",
		out:  "␠\n)Ｈ１/(σ／␖/Ｕ␙｜v␕\nη｀\t␄α[+～χnθ\n;",
	}, { // 723
		mask: EncodeColon | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "␠\n)Ｈ１/(σ／␖/Ｕ␙｜v␕\nη｀\t␄α[+～χnθ\n;",
		out:  "‛␠\n)Ｈ１/(σ／␖/Ｕ␙｜v␕\nη｀\t␄α[+～χnθ\n;",
	}, { // 724
		mask: EncodeColon | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   " \v)Ｈ１/(σ／␖/Ｕ␙｜v␕\nη｀\t␄α[+～χnθ\v;",
		out:  "␠\v)Ｈ１/(σ／␖/Ｕ␙｜v␕\nη｀\t␄α[+～χnθ\v;",
	}, { // 725
		mask: EncodeColon | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "␠\v)Ｈ１/(σ／␖/Ｕ␙｜v␕\nη｀\t␄α[+～χnθ\v;",
		out:  "‛␠\v)Ｈ１/(σ／␖/Ｕ␙｜v␕\nη｀\t␄α[+～χnθ\v;",
	}, { // 726
		mask: EncodeColon | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   " \r)Ｈ１/(σ／␖/Ｕ␙｜v␕\nη｀\t␄α[+～χnθ\r;",
		out:  "␠\r)Ｈ１/(σ／␖/Ｕ␙｜v␕\nη｀\t␄α[+～χnθ\r;",
	}, { // 727
		mask: EncodeColon | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "␠\r)Ｈ１/(σ／␖/Ｕ␙｜v␕\nη｀\t␄α[+～χnθ\r;",
		out:  "‛␠\r)Ｈ１/(σ／␖/Ｕ␙｜v␕\nη｀\t␄α[+～χnθ\r;",
	}, { // 728
		mask: EncodeColon | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "ρ\t)Ｈ１/(σ／␖/Ｕ␙｜v␕\nη｀\t␄α[+～χnθ\t ",
		out:  "ρ\t)Ｈ１/(σ／␖/Ｕ␙｜v␕\nη｀\t␄α[+～χnθ\t ",
	}, { // 729
		mask: EncodeColon | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "ρ\t)Ｈ１/(σ／␖/Ｕ␙｜v␕\nη｀\t␄α[+～χnθ\t␠",
		out:  "ρ\t)Ｈ１/(σ／␖/Ｕ␙｜v␕\nη｀\t␄α[+～χnθ\t␠",
	}, { // 730
		mask: EncodeColon | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "ρ\n)Ｈ１/(σ／␖/Ｕ␙｜v␕\nη｀\t␄α[+～χnθ\n ",
		out:  "ρ\n)Ｈ１/(σ／␖/Ｕ␙｜v␕\nη｀\t␄α[+～χnθ\n ",
	}, { // 731
		mask: EncodeColon | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "ρ\n)Ｈ１/(σ／␖/Ｕ␙｜v␕\nη｀\t␄α[+～χnθ\n␠",
		out:  "ρ\n)Ｈ１/(σ／␖/Ｕ␙｜v␕\nη｀\t␄α[+～χnθ\n␠",
	}, { // 732
		mask: EncodeColon | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "ρ\v)Ｈ１/(σ／␖/Ｕ␙｜v␕\nη｀\t␄α[+～χnθ\v ",
		out:  "ρ\v)Ｈ１/(σ／␖/Ｕ␙｜v␕\nη｀\t␄α[+～χnθ\v ",
	}, { // 733
		mask: EncodeColon | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "ρ\v)Ｈ１/(σ／␖/Ｕ␙｜v␕\nη｀\t␄α[+～χnθ\v␠",
		out:  "ρ\v)Ｈ１/(σ／␖/Ｕ␙｜v␕\nη｀\t␄α[+～χnθ\v␠",
	}, { // 734
		mask: EncodeColon | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "ρ\r)Ｈ１/(σ／␖/Ｕ␙｜v␕\nη｀\t␄α[+～χnθ\r ",
		out:  "ρ\r)Ｈ１/(σ／␖/Ｕ␙｜v␕\nη｀\t␄α[+～χnθ\r ",
	}, { // 735
		mask: EncodeColon | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "ρ\r)Ｈ１/(σ／␖/Ｕ␙｜v␕\nη｀\t␄α[+～χnθ\r␠",
		out:  "ρ\r)Ｈ１/(σ／␖/Ｕ␙｜v␕\nη｀\t␄α[+～χnθ\r␠",
	}, { // 736
		mask: EncodeQuestion | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   " \tＯ｝\nα;␀␇␁*Oy＂␍W␌ｕθςＴ!\x1dτψζ%＠\t\r",
		out:  "␠\tＯ｝\nα;‛␀␇␁*Oy＂␍W␌ｕθςＴ!\x1dτψζ%＠\t␍",
	}, { // 737
		mask: EncodeQuestion | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "␠\tＯ｝\nα;␀␇␁*Oy＂␍W␌ｕθςＴ!\x1dτψζ%＠\t\r",
		out:  "‛␠\tＯ｝\nα;‛␀␇␁*Oy＂␍W␌ｕθςＴ!\x1dτψζ%＠\t␍",
	}, { // 738
		mask: EncodeQuestion | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   " \nＯ｝\nα;␀␇␁*Oy＂␍W␌ｕθςＴ!\x1dτψζ%＠\n\r",
		out:  "␠\nＯ｝\nα;‛␀␇␁*Oy＂␍W␌ｕθςＴ!\x1dτψζ%＠\n␍",
	}, { // 739
		mask: EncodeQuestion | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "␠\nＯ｝\nα;␀␇␁*Oy＂␍W␌ｕθςＴ!\x1dτψζ%＠\n\r",
		out:  "‛␠\nＯ｝\nα;‛␀␇␁*Oy＂␍W␌ｕθςＴ!\x1dτψζ%＠\n␍",
	}, { // 740
		mask: EncodeQuestion | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   " \vＯ｝\nα;␀␇␁*Oy＂␍W␌ｕθςＴ!\x1dτψζ%＠\v\r",
		out:  "␠\vＯ｝\nα;‛␀␇␁*Oy＂␍W␌ｕθςＴ!\x1dτψζ%＠\v␍",
	}, { // 741
		mask: EncodeQuestion | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "␠\vＯ｝\nα;␀␇␁*Oy＂␍W␌ｕθςＴ!\x1dτψζ%＠\v\r",
		out:  "‛␠\vＯ｝\nα;‛␀␇␁*Oy＂␍W␌ｕθςＴ!\x1dτψζ%＠\v␍",
	}, { // 742
		mask: EncodeQuestion | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   " \rＯ｝\nα;␀␇␁*Oy＂␍W␌ｕθςＴ!\x1dτψζ%＠\r\r",
		out:  "␠\rＯ｝\nα;‛␀␇␁*Oy＂␍W␌ｕθςＴ!\x1dτψζ%＠\r␍",
	}, { // 743
		mask: EncodeQuestion | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "␠\rＯ｝\nα;␀␇␁*Oy＂␍W␌ｕθςＴ!\x1dτψζ%＠\r\r",
		out:  "‛␠\rＯ｝\nα;‛␀␇␁*Oy＂␍W␌ｕθςＴ!\x1dτψζ%＠\r␍",
	}, { // 744
		mask: EncodeQuestion | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "ｙ\tＯ｝\nα;␀␇␁*Oy＂␍W␌ｕθςＴ!\x1dτψζ%＠\t ",
		out:  "ｙ\tＯ｝\nα;‛␀␇␁*Oy＂␍W␌ｕθςＴ!\x1dτψζ%＠\t ",
	}, { // 745
		mask: EncodeQuestion | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "ｙ\tＯ｝\nα;␀␇␁*Oy＂␍W␌ｕθςＴ!\x1dτψζ%＠\t␠",
		out:  "ｙ\tＯ｝\nα;‛␀␇␁*Oy＂␍W␌ｕθςＴ!\x1dτψζ%＠\t␠",
	}, { // 746
		mask: EncodeQuestion | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "ｙ\nＯ｝\nα;␀␇␁*Oy＂␍W␌ｕθςＴ!\x1dτψζ%＠\n ",
		out:  "ｙ\nＯ｝\nα;‛␀␇␁*Oy＂␍W␌ｕθςＴ!\x1dτψζ%＠\n ",
	}, { // 747
		mask: EncodeQuestion | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "ｙ\nＯ｝\nα;␀␇␁*Oy＂␍W␌ｕθςＴ!\x1dτψζ%＠\n␠",
		out:  "ｙ\nＯ｝\nα;‛␀␇␁*Oy＂␍W␌ｕθςＴ!\x1dτψζ%＠\n␠",
	}, { // 748
		mask: EncodeQuestion | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "ｙ\vＯ｝\nα;␀␇␁*Oy＂␍W␌ｕθςＴ!\x1dτψζ%＠\v ",
		out:  "ｙ\vＯ｝\nα;‛␀␇␁*Oy＂␍W␌ｕθςＴ!\x1dτψζ%＠\v ",
	}, { // 749
		mask: EncodeQuestion | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "ｙ\vＯ｝\nα;␀␇␁*Oy＂␍W␌ｕθςＴ!\x1dτψζ%＠\v␠",
		out:  "ｙ\vＯ｝\nα;‛␀␇␁*Oy＂␍W␌ｕθςＴ!\x1dτψζ%＠\v␠",
	}, { // 750
		mask: EncodeQuestion | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "ｙ\rＯ｝\nα;␀␇␁*Oy＂␍W␌ｕθςＴ!\x1dτψζ%＠\r ",
		out:  "ｙ\rＯ｝\nα;‛␀␇␁*Oy＂␍W␌ｕθςＴ!\x1dτψζ%＠\r ",
	}, { // 751
		mask: EncodeQuestion | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "ｙ\rＯ｝\nα;␀␇␁*Oy＂␍W␌ｕθςＴ!\x1dτψζ%＠\r␠",
		out:  "ｙ\rＯ｝\nα;‛␀␇␁*Oy＂␍W␌ｕθςＴ!\x1dτψζ%＠\r␠",
	}, { // 752
		mask: EncodeAsterisk | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   " \t>Sg５ｅ|τ␊␞］\\␎π4－␈υιU＊␖οτ\rl<\tｆ",
		out:  "␠\t>Sg５ｅ|τ␊␞］\\␎π4－␈υιU‛＊␖οτ\rl<\tｆ",
	}, { // 753
		mask: EncodeAsterisk | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "␠\t>Sg５ｅ|τ␊␞］\\␎π4－␈υιU＊␖οτ\rl<\tｆ",
		out:  "‛␠\t>Sg５ｅ|τ␊␞］\\␎π4－␈υιU‛＊␖οτ\rl<\tｆ",
	}, { // 754
		mask: EncodeAsterisk | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   " \n>Sg５ｅ|τ␊␞］\\␎π4－␈υιU＊␖οτ\rl<\nｆ",
		out:  "␠\n>Sg５ｅ|τ␊␞］\\␎π4－␈υιU‛＊␖οτ\rl<\nｆ",
	}, { // 755
		mask: EncodeAsterisk | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "␠\n>Sg５ｅ|τ␊␞］\\␎π4－␈υιU＊␖οτ\rl<\nｆ",
		out:  "‛␠\n>Sg５ｅ|τ␊␞］\\␎π4－␈υιU‛＊␖οτ\rl<\nｆ",
	}, { // 756
		mask: EncodeAsterisk | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   " \v>Sg５ｅ|τ␊␞］\\␎π4－␈υιU＊␖οτ\rl<\vｆ",
		out:  "␠\v>Sg５ｅ|τ␊␞］\\␎π4－␈υιU‛＊␖οτ\rl<\vｆ",
	}, { // 757
		mask: EncodeAsterisk | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "␠\v>Sg５ｅ|τ␊␞］\\␎π4－␈υιU＊␖οτ\rl<\vｆ",
		out:  "‛␠\v>Sg５ｅ|τ␊␞］\\␎π4－␈υιU‛＊␖οτ\rl<\vｆ",
	}, { // 758
		mask: EncodeAsterisk | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   " \r>Sg５ｅ|τ␊␞］\\␎π4－␈υιU＊␖οτ\rl<\rｆ",
		out:  "␠\r>Sg５ｅ|τ␊␞］\\␎π4－␈υιU‛＊␖οτ\rl<\rｆ",
	}, { // 759
		mask: EncodeAsterisk | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "␠\r>Sg５ｅ|τ␊␞］\\␎π4－␈υιU＊␖οτ\rl<\rｆ",
		out:  "‛␠\r>Sg５ｅ|τ␊␞］\\␎π4－␈υιU‛＊␖οτ\rl<\rｆ",
	}, { // 760
		mask: EncodeAsterisk | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "\b\t>Sg５ｅ|τ␊␞］\\␎π4－␈υιU＊␖οτ\rl<\t ",
		out:  "\b\t>Sg５ｅ|τ␊␞］\\␎π4－␈υιU‛＊␖οτ\rl<\t ",
	}, { // 761
		mask: EncodeAsterisk | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "\b\t>Sg５ｅ|τ␊␞］\\␎π4－␈υιU＊␖οτ\rl<\t␠",
		out:  "\b\t>Sg５ｅ|τ␊␞］\\␎π4－␈υιU‛＊␖οτ\rl<\t␠",
	}, { // 762
		mask: EncodeAsterisk | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "\b\n>Sg５ｅ|τ␊␞］\\␎π4－␈υιU＊␖οτ\rl<\n ",
		out:  "\b\n>Sg５ｅ|τ␊␞］\\␎π4－␈υιU‛＊␖οτ\rl<\n ",
	}, { // 763
		mask: EncodeAsterisk | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "\b\n>Sg５ｅ|τ␊␞］\\␎π4－␈υιU＊␖οτ\rl<\n␠",
		out:  "\b\n>Sg５ｅ|τ␊␞］\\␎π4－␈υιU‛＊␖οτ\rl<\n␠",
	}, { // 764
		mask: EncodeAsterisk | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "\b\v>Sg５ｅ|τ␊␞］\\␎π4－␈υιU＊␖οτ\rl<\v ",
		out:  "\b\v>Sg５ｅ|τ␊␞］\\␎π4－␈υιU‛＊␖οτ\rl<\v ",
	}, { // 765
		mask: EncodeAsterisk | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "\b\v>Sg５ｅ|τ␊␞］\\␎π4－␈υιU＊␖οτ\rl<\v␠",
		out:  "\b\v>Sg５ｅ|τ␊␞］\\␎π4－␈υιU‛＊␖οτ\rl<\v␠",
	}, { // 766
		mask: EncodeAsterisk | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "\b\r>Sg５ｅ|τ␊␞］\\␎π4－␈υιU＊␖οτ\rl<\r ",
		out:  "\b\r>Sg５ｅ|τ␊␞］\\␎π4－␈υιU‛＊␖οτ\rl<\r ",
	}, { // 767
		mask: EncodeAsterisk | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "\b\r>Sg５ｅ|τ␊␞］\\␎π4－␈υιU＊␖οτ\rl<\r␠",
		out:  "\b\r>Sg５ｅ|τ␊␞］\\␎π4－␈υιU‛＊␖οτ\rl<\r␠",
	}, { // 768
		mask: EncodePipe | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   " \t\x11φε＂\x1b␎.｀i\x1c\x04Ｚο<Dｉ=Ｕ#σ?：ψ␡␜４\tς",
		out:  "␠\t\x11φε＂\x1b␎.｀i\x1c\x04Ｚο<Dｉ=Ｕ#σ?：ψ␡␜４\tς",
	}, { // 769
		mask: EncodePipe | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "␠\t\x11φε＂\x1b␎.｀i\x1c\x04Ｚο<Dｉ=Ｕ#σ?：ψ␡␜４\tς",
		out:  "‛␠\t\x11φε＂\x1b␎.｀i\x1c\x04Ｚο<Dｉ=Ｕ#σ?：ψ␡␜４\tς",
	}, { // 770
		mask: EncodePipe | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   " \n\x11φε＂\x1b␎.｀i\x1c\x04Ｚο<Dｉ=Ｕ#σ?：ψ␡␜４\nς",
		out:  "␠\n\x11φε＂\x1b␎.｀i\x1c\x04Ｚο<Dｉ=Ｕ#σ?：ψ␡␜４\nς",
	}, { // 771
		mask: EncodePipe | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "␠\n\x11φε＂\x1b␎.｀i\x1c\x04Ｚο<Dｉ=Ｕ#σ?：ψ␡␜４\nς",
		out:  "‛␠\n\x11φε＂\x1b␎.｀i\x1c\x04Ｚο<Dｉ=Ｕ#σ?：ψ␡␜４\nς",
	}, { // 772
		mask: EncodePipe | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   " \v\x11φε＂\x1b␎.｀i\x1c\x04Ｚο<Dｉ=Ｕ#σ?：ψ␡␜４\vς",
		out:  "␠\v\x11φε＂\x1b␎.｀i\x1c\x04Ｚο<Dｉ=Ｕ#σ?：ψ␡␜４\vς",
	}, { // 773
		mask: EncodePipe | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "␠\v\x11φε＂\x1b␎.｀i\x1c\x04Ｚο<Dｉ=Ｕ#σ?：ψ␡␜４\vς",
		out:  "‛␠\v\x11φε＂\x1b␎.｀i\x1c\x04Ｚο<Dｉ=Ｕ#σ?：ψ␡␜４\vς",
	}, { // 774
		mask: EncodePipe | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   " \r\x11φε＂\x1b␎.｀i\x1c\x04Ｚο<Dｉ=Ｕ#σ?：ψ␡␜４\rς",
		out:  "␠\r\x11φε＂\x1b␎.｀i\x1c\x04Ｚο<Dｉ=Ｕ#σ?：ψ␡␜４\rς",
	}, { // 775
		mask: EncodePipe | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "␠\r\x11φε＂\x1b␎.｀i\x1c\x04Ｚο<Dｉ=Ｕ#σ?：ψ␡␜４\rς",
		out:  "‛␠\r\x11φε＂\x1b␎.｀i\x1c\x04Ｚο<Dｉ=Ｕ#σ?：ψ␡␜４\rς",
	}, { // 776
		mask: EncodePipe | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "␈\t\x11φε＂\x1b␎.｀i\x1c\x04Ｚο<Dｉ=Ｕ#σ?：ψ␡␜４\t ",
		out:  "␈\t\x11φε＂\x1b␎.｀i\x1c\x04Ｚο<Dｉ=Ｕ#σ?：ψ␡␜４\t ",
	}, { // 777
		mask: EncodePipe | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "␈\t\x11φε＂\x1b␎.｀i\x1c\x04Ｚο<Dｉ=Ｕ#σ?：ψ␡␜４\t␠",
		out:  "␈\t\x11φε＂\x1b␎.｀i\x1c\x04Ｚο<Dｉ=Ｕ#σ?：ψ␡␜４\t␠",
	}, { // 778
		mask: EncodePipe | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "␈\n\x11φε＂\x1b␎.｀i\x1c\x04Ｚο<Dｉ=Ｕ#σ?：ψ␡␜４\n ",
		out:  "␈\n\x11φε＂\x1b␎.｀i\x1c\x04Ｚο<Dｉ=Ｕ#σ?：ψ␡␜４\n ",
	}, { // 779
		mask: EncodePipe | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "␈\n\x11φε＂\x1b␎.｀i\x1c\x04Ｚο<Dｉ=Ｕ#σ?：ψ␡␜４\n␠",
		out:  "␈\n\x11φε＂\x1b␎.｀i\x1c\x04Ｚο<Dｉ=Ｕ#σ?：ψ␡␜４\n␠",
	}, { // 780
		mask: EncodePipe | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "␈\v\x11φε＂\x1b␎.｀i\x1c\x04Ｚο<Dｉ=Ｕ#σ?：ψ␡␜４\v ",
		out:  "␈\v\x11φε＂\x1b␎.｀i\x1c\x04Ｚο<Dｉ=Ｕ#σ?：ψ␡␜４\v ",
	}, { // 781
		mask: EncodePipe | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "␈\v\x11φε＂\x1b␎.｀i\x1c\x04Ｚο<Dｉ=Ｕ#σ?：ψ␡␜４\v␠",
		out:  "␈\v\x11φε＂\x1b␎.｀i\x1c\x04Ｚο<Dｉ=Ｕ#σ?：ψ␡␜４\v␠",
	}, { // 782
		mask: EncodePipe | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "␈\r\x11φε＂\x1b␎.｀i\x1c\x04Ｚο<Dｉ=Ｕ#σ?：ψ␡␜４\r ",
		out:  "␈\r\x11φε＂\x1b␎.｀i\x1c\x04Ｚο<Dｉ=Ｕ#σ?：ψ␡␜４\r ",
	}, { // 783
		mask: EncodePipe | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "␈\r\x11φε＂\x1b␎.｀i\x1c\x04Ｚο<Dｉ=Ｕ#σ?：ψ␡␜４\r␠",
		out:  "␈\r\x11φε＂\x1b␎.｀i\x1c\x04Ｚο<Dｉ=Ｕ#σ?：ψ␡␜４\r␠",
	}, { // 784
		mask: EncodeHash | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   " \t\x04\x05ξ］HＹ\\␡ο\n\x15＄#5ｑＰ&␜x␊ω$Ｈ＆λ␞\tα",
		out:  "␠\t\x04\x05ξ］HＹ\\␡ο\n\x15＄＃5ｑＰ&␜x␊ω$Ｈ＆λ␞\tα",
	}, { // 785
		mask: EncodeHash | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "␠\t\x04\x05ξ］HＹ\\␡ο\n\x15＄#5ｑＰ&␜x␊ω$Ｈ＆λ␞\tα",
		out:  "‛␠\t\x04\x05ξ］HＹ\\␡ο\n\x15＄＃5ｑＰ&␜x␊ω$Ｈ＆λ␞\tα",
	}, { // 786
		mask: EncodeHash | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   " \n\x04\x05ξ］HＹ\\␡ο\n\x15＄#5ｑＰ&␜x␊ω$Ｈ＆λ␞\nα",
		out:  "␠\n\x04\x05ξ］HＹ\\␡ο\n\x15＄＃5ｑＰ&␜x␊ω$Ｈ＆λ␞\nα",
	}, { // 787
		mask: EncodeHash | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "␠\n\x04\x05ξ］HＹ\\␡ο\n\x15＄#5ｑＰ&␜x␊ω$Ｈ＆λ␞\nα",
		out:  "‛␠\n\x04\x05ξ］HＹ\\␡ο\n\x15＄＃5ｑＰ&␜x␊ω$Ｈ＆λ␞\nα",
	}, { // 788
		mask: EncodeHash | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   " \v\x04\x05ξ］HＹ\\␡ο\n\x15＄#5ｑＰ&␜x␊ω$Ｈ＆λ␞\vα",
		out:  "␠\v\x04\x05ξ］HＹ\\␡ο\n\x15＄＃5ｑＰ&␜x␊ω$Ｈ＆λ␞\vα",
	}, { // 789
		mask: EncodeHash | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "␠\v\x04\x05ξ］HＹ\\␡ο\n\x15＄#5ｑＰ&␜x␊ω$Ｈ＆λ␞\vα",
		out:  "‛␠\v\x04\x05ξ］HＹ\\␡ο\n\x15＄＃5ｑＰ&␜x␊ω$Ｈ＆λ␞\vα",
	}, { // 790
		mask: EncodeHash | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   " \r\x04\x05ξ］HＹ\\␡ο\n\x15＄#5ｑＰ&␜x␊ω$Ｈ＆λ␞\rα",
		out:  "␠\r\x04\x05ξ］HＹ\\␡ο\n\x15＄＃5ｑＰ&␜x␊ω$Ｈ＆λ␞\rα",
	}, { // 791
		mask: EncodeHash | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "␠\r\x04\x05ξ］HＹ\\␡ο\n\x15＄#5ｑＰ&␜x␊ω$Ｈ＆λ␞\rα",
		out:  "‛␠\r\x04\x05ξ］HＹ\\␡ο\n\x15＄＃5ｑＰ&␜x␊ω$Ｈ＆λ␞\rα",
	}, { // 792
		mask: EncodeHash | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "ς\t\x04\x05ξ］HＹ\\␡ο\n\x15＄#5ｑＰ&␜x␊ω$Ｈ＆λ␞\t ",
		out:  "ς\t\x04\x05ξ］HＹ\\␡ο\n\x15＄＃5ｑＰ&␜x␊ω$Ｈ＆λ␞\t ",
	}, { // 793
		mask: EncodeHash | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "ς\t\x04\x05ξ］HＹ\\␡ο\n\x15＄#5ｑＰ&␜x␊ω$Ｈ＆λ␞\t␠",
		out:  "ς\t\x04\x05ξ］HＹ\\␡ο\n\x15＄＃5ｑＰ&␜x␊ω$Ｈ＆λ␞\t␠",
	}, { // 794
		mask: EncodeHash | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "ς\n\x04\x05ξ］HＹ\\␡ο\n\x15＄#5ｑＰ&␜x␊ω$Ｈ＆λ␞\n ",
		out:  "ς\n\x04\x05ξ］HＹ\\␡ο\n\x15＄＃5ｑＰ&␜x␊ω$Ｈ＆λ␞\n ",
	}, { // 795
		mask: EncodeHash | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "ς\n\x04\x05ξ］HＹ\\␡ο\n\x15＄#5ｑＰ&␜x␊ω$Ｈ＆λ␞\n␠",
		out:  "ς\n\x04\x05ξ］HＹ\\␡ο\n\x15＄＃5ｑＰ&␜x␊ω$Ｈ＆λ␞\n␠",
	}, { // 796
		mask: EncodeHash | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "ς\v\x04\x05ξ］HＹ\\␡ο\n\x15＄#5ｑＰ&␜x␊ω$Ｈ＆λ␞\v ",
		out:  "ς\v\x04\x05ξ］HＹ\\␡ο\n\x15＄＃5ｑＰ&␜x␊ω$Ｈ＆λ␞\v ",
	}, { // 797
		mask: EncodeHash | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "ς\v\x04\x05ξ］HＹ\\␡ο\n\x15＄#5ｑＰ&␜x␊ω$Ｈ＆λ␞\v␠",
		out:  "ς\v\x04\x05ξ］HＹ\\␡ο\n\x15＄＃5ｑＰ&␜x␊ω$Ｈ＆λ␞\v␠",
	}, { // 798
		mask: EncodeHash | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "ς\r\x04\x05ξ］HＹ\\␡ο\n\x15＄#5ｑＰ&␜x␊ω$Ｈ＆λ␞\r ",
		out:  "ς\r\x04\x05ξ］HＹ\\␡ο\n\x15＄＃5ｑＰ&␜x␊ω$Ｈ＆λ␞\r ",
	}, { // 799
		mask: EncodeHash | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "ς\r\x04\x05ξ］HＹ\\␡ο\n\x15＄#5ｑＰ&␜x␊ω$Ｈ＆λ␞\r␠",
		out:  "ς\r\x04\x05ξ］HＹ\\␡ο\n\x15＄＃5ｑＰ&␜x␊ω$Ｈ＆λ␞\r␠",
	}, { // 800
		mask: EncodePercent | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   " \tξ＇;cＵ'␜βvT\fφ␏ｍ[␕κ｜\rθＦ\fmψＪ:\tＫ",
		out:  "␠\tξ＇;cＵ'␜βvT\fφ␏ｍ[␕κ｜\rθＦ\fmψＪ:\tＫ",
	}, { // 801
		mask: EncodePercent | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "␠\tξ＇;cＵ'␜βvT\fφ␏ｍ[␕κ｜\rθＦ\fmψＪ:\tＫ",
		out:  "‛␠\tξ＇;cＵ'␜βvT\fφ␏ｍ[␕κ｜\rθＦ\fmψＪ:\tＫ",
	}, { // 802
		mask: EncodePercent | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   " \nξ＇;cＵ'␜βvT\fφ␏ｍ[␕κ｜\rθＦ\fmψＪ:\nＫ",
		out:  "␠\nξ＇;cＵ'␜βvT\fφ␏ｍ[␕κ｜\rθＦ\fmψＪ:\nＫ",
	}, { // 803
		mask: EncodePercent | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "␠\nξ＇;cＵ'␜βvT\fφ␏ｍ[␕κ｜\rθＦ\fmψＪ:\nＫ",
		out:  "‛␠\nξ＇;cＵ'␜βvT\fφ␏ｍ[␕κ｜\rθＦ\fmψＪ:\nＫ",
	}, { // 804
		mask: EncodePercent | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   " \vξ＇;cＵ'␜βvT\fφ␏ｍ[␕κ｜\rθＦ\fmψＪ:\vＫ",
		out:  "␠\vξ＇;cＵ'␜βvT\fφ␏ｍ[␕κ｜\rθＦ\fmψＪ:\vＫ",
	}, { // 805
		mask: EncodePercent | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "␠\vξ＇;cＵ'␜βvT\fφ␏ｍ[␕κ｜\rθＦ\fmψＪ:\vＫ",
		out:  "‛␠\vξ＇;cＵ'␜βvT\fφ␏ｍ[␕κ｜\rθＦ\fmψＪ:\vＫ",
	}, { // 806
		mask: EncodePercent | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   " \rξ＇;cＵ'␜βvT\fφ␏ｍ[␕κ｜\rθＦ\fmψＪ:\rＫ",
		out:  "␠\rξ＇;cＵ'␜βvT\fφ␏ｍ[␕κ｜\rθＦ\fmψＪ:\rＫ",
	}, { // 807
		mask: EncodePercent | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "␠\rξ＇;cＵ'␜βvT\fφ␏ｍ[␕κ｜\rθＦ\fmψＪ:\rＫ",
		out:  "‛␠\rξ＇;cＵ'␜βvT\fφ␏ｍ[␕κ｜\rθＦ\fmψＪ:\rＫ",
	}, { // 808
		mask: EncodePercent | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "]\tξ＇;cＵ'␜βvT\fφ␏ｍ[␕κ｜\rθＦ\fmψＪ:\t ",
		out:  "]\tξ＇;cＵ'␜βvT\fφ␏ｍ[␕κ｜\rθＦ\fmψＪ:\t ",
	}, { // 809
		mask: EncodePercent | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "]\tξ＇;cＵ'␜βvT\fφ␏ｍ[␕κ｜\rθＦ\fmψＪ:\t␠",
		out:  "]\tξ＇;cＵ'␜βvT\fφ␏ｍ[␕κ｜\rθＦ\fmψＪ:\t␠",
	}, { // 810
		mask: EncodePercent | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "]\nξ＇;cＵ'␜βvT\fφ␏ｍ[␕κ｜\rθＦ\fmψＪ:\n ",
		out:  "]\nξ＇;cＵ'␜βvT\fφ␏ｍ[␕κ｜\rθＦ\fmψＪ:\n ",
	}, { // 811
		mask: EncodePercent | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "]\nξ＇;cＵ'␜βvT\fφ␏ｍ[␕κ｜\rθＦ\fmψＪ:\n␠",
		out:  "]\nξ＇;cＵ'␜βvT\fφ␏ｍ[␕κ｜\rθＦ\fmψＪ:\n␠",
	}, { // 812
		mask: EncodePercent | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "]\vξ＇;cＵ'␜βvT\fφ␏ｍ[␕κ｜\rθＦ\fmψＪ:\v ",
		out:  "]\vξ＇;cＵ'␜βvT\fφ␏ｍ[␕κ｜\rθＦ\fmψＪ:\v ",
	}, { // 813
		mask: EncodePercent | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "]\vξ＇;cＵ'␜βvT\fφ␏ｍ[␕κ｜\rθＦ\fmψＪ:\v␠",
		out:  "]\vξ＇;cＵ'␜βvT\fφ␏ｍ[␕κ｜\rθＦ\fmψＪ:\v␠",
	}, { // 814
		mask: EncodePercent | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "]\rξ＇;cＵ'␜βvT\fφ␏ｍ[␕κ｜\rθＦ\fmψＪ:\r ",
		out:  "]\rξ＇;cＵ'␜βvT\fφ␏ｍ[␕κ｜\rθＦ\fmψＪ:\r ",
	}, { // 815
		mask: EncodePercent | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "]\rξ＇;cＵ'␜βvT\fφ␏ｍ[␕κ｜\rθＦ\fmψＪ:\r␠",
		out:  "]\rξ＇;cＵ'␜βvT\fφ␏ｍ[␕κ｜\rθＦ\fmψＪ:\r␠",
	}, { // 816
		mask: EncodeBackSlash | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   " \tα\x11\x0e␕␍ｙ？\x1dＪ］Ｗ␔ης&ρu␛θ\b<\x02?｛ｕ／\t:",
		out:  "␠\tα\x11\x0e␕␍ｙ？\x1dＪ］Ｗ␔ης&ρu␛θ\b<\x02?｛ｕ／\t:",
	}, { // 817
		mask: EncodeBackSlash | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "␠\tα\x11\x0e␕␍ｙ？\x1dＪ］Ｗ␔ης&ρu␛θ\b<\x02?｛ｕ／\t:",
		out:  "‛␠\tα\x11\x0e␕␍ｙ？\x1dＪ］Ｗ␔ης&ρu␛θ\b<\x02?｛ｕ／\t:",
	}, { // 818
		mask: EncodeBackSlash | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   " \nα\x11\x0e␕␍ｙ？\x1dＪ］Ｗ␔ης&ρu␛θ\b<\x02?｛ｕ／\n:",
		out:  "␠\nα\x11\x0e␕␍ｙ？\x1dＪ］Ｗ␔ης&ρu␛θ\b<\x02?｛ｕ／\n:",
	}, { // 819
		mask: EncodeBackSlash | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "␠\nα\x11\x0e␕␍ｙ？\x1dＪ］Ｗ␔ης&ρu␛θ\b<\x02?｛ｕ／\n:",
		out:  "‛␠\nα\x11\x0e␕␍ｙ？\x1dＪ］Ｗ␔ης&ρu␛θ\b<\x02?｛ｕ／\n:",
	}, { // 820
		mask: EncodeBackSlash | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   " \vα\x11\x0e␕␍ｙ？\x1dＪ］Ｗ␔ης&ρu␛θ\b<\x02?｛ｕ／\v:",
		out:  "␠\vα\x11\x0e␕␍ｙ？\x1dＪ］Ｗ␔ης&ρu␛θ\b<\x02?｛ｕ／\v:",
	}, { // 821
		mask: EncodeBackSlash | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "␠\vα\x11\x0e␕␍ｙ？\x1dＪ］Ｗ␔ης&ρu␛θ\b<\x02?｛ｕ／\v:",
		out:  "‛␠\vα\x11\x0e␕␍ｙ？\x1dＪ］Ｗ␔ης&ρu␛θ\b<\x02?｛ｕ／\v:",
	}, { // 822
		mask: EncodeBackSlash | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   " \rα\x11\x0e␕␍ｙ？\x1dＪ］Ｗ␔ης&ρu␛θ\b<\x02?｛ｕ／\r:",
		out:  "␠\rα\x11\x0e␕␍ｙ？\x1dＪ］Ｗ␔ης&ρu␛θ\b<\x02?｛ｕ／\r:",
	}, { // 823
		mask: EncodeBackSlash | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "␠\rα\x11\x0e␕␍ｙ？\x1dＪ］Ｗ␔ης&ρu␛θ\b<\x02?｛ｕ／\r:",
		out:  "‛␠\rα\x11\x0e␕␍ｙ？\x1dＪ］Ｗ␔ης&ρu␛θ\b<\x02?｛ｕ／\r:",
	}, { // 824
		mask: EncodeBackSlash | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "q\tα\x11\x0e␕␍ｙ？\x1dＪ］Ｗ␔ης&ρu␛θ\b<\x02?｛ｕ／\t ",
		out:  "q\tα\x11\x0e␕␍ｙ？\x1dＪ］Ｗ␔ης&ρu␛θ\b<\x02?｛ｕ／\t ",
	}, { // 825
		mask: EncodeBackSlash | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "q\tα\x11\x0e␕␍ｙ？\x1dＪ］Ｗ␔ης&ρu␛θ\b<\x02?｛ｕ／\t␠",
		out:  "q\tα\x11\x0e␕␍ｙ？\x1dＪ］Ｗ␔ης&ρu␛θ\b<\x02?｛ｕ／\t␠",
	}, { // 826
		mask: EncodeBackSlash | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "q\nα\x11\x0e␕␍ｙ？\x1dＪ］Ｗ␔ης&ρu␛θ\b<\x02?｛ｕ／\n ",
		out:  "q\nα\x11\x0e␕␍ｙ？\x1dＪ］Ｗ␔ης&ρu␛θ\b<\x02?｛ｕ／\n ",
	}, { // 827
		mask: EncodeBackSlash | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "q\nα\x11\x0e␕␍ｙ？\x1dＪ］Ｗ␔ης&ρu␛θ\b<\x02?｛ｕ／\n␠",
		out:  "q\nα\x11\x0e␕␍ｙ？\x1dＪ］Ｗ␔ης&ρu␛θ\b<\x02?｛ｕ／\n␠",
	}, { // 828
		mask: EncodeBackSlash | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "q\vα\x11\x0e␕␍ｙ？\x1dＪ］Ｗ␔ης&ρu␛θ\b<\x02?｛ｕ／\v ",
		out:  "q\vα\x11\x0e␕␍ｙ？\x1dＪ］Ｗ␔ης&ρu␛θ\b<\x02?｛ｕ／\v ",
	}, { // 829
		mask: EncodeBackSlash | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "q\vα\x11\x0e␕␍ｙ？\x1dＪ］Ｗ␔ης&ρu␛θ\b<\x02?｛ｕ／\v␠",
		out:  "q\vα\x11\x0e␕␍ｙ？\x1dＪ］Ｗ␔ης&ρu␛θ\b<\x02?｛ｕ／\v␠",
	}, { // 830
		mask: EncodeBackSlash | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "q\rα\x11\x0e␕␍ｙ？\x1dＪ］Ｗ␔ης&ρu␛θ\b<\x02?｛ｕ／\r ",
		out:  "q\rα\x11\x0e␕␍ｙ？\x1dＪ］Ｗ␔ης&ρu␛θ\b<\x02?｛ｕ／\r ",
	}, { // 831
		mask: EncodeBackSlash | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "q\rα\x11\x0e␕␍ｙ？\x1dＪ］Ｗ␔ης&ρu␛θ\b<\x02?｛ｕ／\r␠",
		out:  "q\rα\x11\x0e␕␍ｙ？\x1dＪ］Ｗ␔ης&ρu␛θ\b<\x02?｛ｕ／\r␠",
	}, { // 832
		mask: EncodeDel | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   " \t␃ω\x05␆］ｄｘφμrξ／␘[;,％Ｚ／␓?i[ε\u007fT\tθ",
		out:  "␠\t␃ω\x05␆］ｄｘφμrξ／␘[;,％Ｚ／␓?i[ε␡T\tθ",
	}, { // 833
		mask: EncodeDel | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "␠\t␃ω\x05␆］ｄｘφμrξ／␘[;,％Ｚ／␓?i[ε\u007fT\tθ",
		out:  "‛␠\t␃ω\x05␆］ｄｘφμrξ／␘[;,％Ｚ／␓?i[ε␡T\tθ",
	}, { // 834
		mask: EncodeDel | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   " \n␃ω\x05␆］ｄｘφμrξ／␘[;,％Ｚ／␓?i[ε\u007fT\nθ",
		out:  "␠\n␃ω\x05␆］ｄｘφμrξ／␘[;,％Ｚ／␓?i[ε␡T\nθ",
	}, { // 835
		mask: EncodeDel | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "␠\n␃ω\x05␆］ｄｘφμrξ／␘[;,％Ｚ／␓?i[ε\u007fT\nθ",
		out:  "‛␠\n␃ω\x05␆］ｄｘφμrξ／␘[;,％Ｚ／␓?i[ε␡T\nθ",
	}, { // 836
		mask: EncodeDel | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   " \v␃ω\x05␆］ｄｘφμrξ／␘[;,％Ｚ／␓?i[ε\u007fT\vθ",
		out:  "␠\v␃ω\x05␆］ｄｘφμrξ／␘[;,％Ｚ／␓?i[ε␡T\vθ",
	}, { // 837
		mask: EncodeDel | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "␠\v␃ω\x05␆］ｄｘφμrξ／␘[;,％Ｚ／␓?i[ε\u007fT\vθ",
		out:  "‛␠\v␃ω\x05␆］ｄｘφμrξ／␘[;,％Ｚ／␓?i[ε␡T\vθ",
	}, { // 838
		mask: EncodeDel | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   " \r␃ω\x05␆］ｄｘφμrξ／␘[;,％Ｚ／␓?i[ε\u007fT\rθ",
		out:  "␠\r␃ω\x05␆］ｄｘφμrξ／␘[;,％Ｚ／␓?i[ε␡T\rθ",
	}, { // 839
		mask: EncodeDel | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "␠\r␃ω\x05␆］ｄｘφμrξ／␘[;,％Ｚ／␓?i[ε\u007fT\rθ",
		out:  "‛␠\r␃ω\x05␆］ｄｘφμrξ／␘[;,％Ｚ／␓?i[ε␡T\rθ",
	}, { // 840
		mask: EncodeDel | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "E\t␃ω\x05␆］ｄｘφμrξ／␘[;,％Ｚ／␓?i[ε\u007fT\t ",
		out:  "E\t␃ω\x05␆］ｄｘφμrξ／␘[;,％Ｚ／␓?i[ε␡T\t ",
	}, { // 841
		mask: EncodeDel | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "E\t␃ω\x05␆］ｄｘφμrξ／␘[;,％Ｚ／␓?i[ε\u007fT\t␠",
		out:  "E\t␃ω\x05␆］ｄｘφμrξ／␘[;,％Ｚ／␓?i[ε␡T\t␠",
	}, { // 842
		mask: EncodeDel | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "E\n␃ω\x05␆］ｄｘφμrξ／␘[;,％Ｚ／␓?i[ε\u007fT\n ",
		out:  "E\n␃ω\x05␆］ｄｘφμrξ／␘[;,％Ｚ／␓?i[ε␡T\n ",
	}, { // 843
		mask: EncodeDel | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "E\n␃ω\x05␆］ｄｘφμrξ／␘[;,％Ｚ／␓?i[ε\u007fT\n␠",
		out:  "E\n␃ω\x05␆］ｄｘφμrξ／␘[;,％Ｚ／␓?i[ε␡T\n␠",
	}, { // 844
		mask: EncodeDel | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "E\v␃ω\x05␆］ｄｘφμrξ／␘[;,％Ｚ／␓?i[ε\u007fT\v ",
		out:  "E\v␃ω\x05␆］ｄｘφμrξ／␘[;,％Ｚ／␓?i[ε␡T\v ",
	}, { // 845
		mask: EncodeDel | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "E\v␃ω\x05␆］ｄｘφμrξ／␘[;,％Ｚ／␓?i[ε\u007fT\v␠",
		out:  "E\v␃ω\x05␆］ｄｘφμrξ／␘[;,％Ｚ／␓?i[ε␡T\v␠",
	}, { // 846
		mask: EncodeDel | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "E\r␃ω\x05␆］ｄｘφμrξ／␘[;,％Ｚ／␓?i[ε\u007fT\r ",
		out:  "E\r␃ω\x05␆］ｄｘφμrξ／␘[;,％Ｚ／␓?i[ε␡T\r ",
	}, { // 847
		mask: EncodeDel | EncodeLeftSpace | EncodeRightCrLfHtVt,
		in:   "E\r␃ω\x05␆］ｄｘφμrξ／␘[;,％Ｚ／␓?i[ε\u007fT\r␠",
		out:  "E\r␃ω\x05␆］ｄｘφμrξ／␘[;,％Ｚ／␓?i[ε␡T\r␠",
	}, { // 848
		mask: EncodeZero | EncodeLeftPeriod | EncodeLeftSpace,
		in:   ". ｎＮ>␀\x1bω`ρ␍␈＇＄4Ｙτ\r␍Ｌ｀Zν`η\a\rH ；",
		out:  "． ｎＮ>‛␀\x1bω`ρ␍␈＇＄4Ｙτ\r␍Ｌ｀Zν`η\a\rH ；",
	}, { // 849
		mask: EncodeZero | EncodeLeftPeriod | EncodeLeftSpace,
		in:   "． ｎＮ>␀\x1bω`ρ␍␈＇＄4Ｙτ\r␍Ｌ｀Zν`η\a\rH ；",
		out:  "‛． ｎＮ>‛␀\x1bω`ρ␍␈＇＄4Ｙτ\r␍Ｌ｀Zν`η\a\rH ；",
	}, { // 850
		mask: EncodeZero | EncodeLeftPeriod | EncodeLeftSpace,
		in:   "/ ｎＮ>␀\x1bω`ρ␍␈＇＄4Ｙτ\r␍Ｌ｀Zν`η\a\rH .",
		out:  "/ ｎＮ>‛␀\x1bω`ρ␍␈＇＄4Ｙτ\r␍Ｌ｀Zν`η\a\rH .",
	}, { // 851
		mask: EncodeZero | EncodeLeftPeriod | EncodeLeftSpace,
		in:   "/ ｎＮ>␀\x1bω`ρ␍␈＇＄4Ｙτ\r␍Ｌ｀Zν`η\a\rH ．",
		out:  "/ ｎＮ>‛␀\x1bω`ρ␍␈＇＄4Ｙτ\r␍Ｌ｀Zν`η\a\rH ．",
	}, { // 852
		mask: EncodeSlash | EncodeLeftPeriod | EncodeLeftSpace,
		in:   ". ＞\uff00␗I␄\x18ＵεJυ？|/ςＮ\x1e\rδt␂γ␛<Ｆｃα C",
		out:  "． ＞\uff00␗I␄\x18ＵεJυ？|／ςＮ\x1e\rδt␂γ␛<Ｆｃα C",
	}, { // 853
		mask: EncodeSlash | EncodeLeftPeriod | EncodeLeftSpace,
		in:   "． ＞\uff00␗I␄\x18ＵεJυ？|/ςＮ\x1e\rδt␂γ␛<Ｆｃα C",
		out:  "‛． ＞\uff00␗I␄\x18ＵεJυ？|／ςＮ\x1e\rδt␂γ␛<Ｆｃα C",
	}, { // 854
		mask: EncodeSlash | EncodeLeftPeriod | EncodeLeftSpace,
		in:   "h ＞\uff00␗I␄\x18ＵεJυ？|/ςＮ\x1e\rδt␂γ␛<Ｆｃα .",
		out:  "h ＞\uff00␗I␄\x18ＵεJυ？|／ςＮ\x1e\rδt␂γ␛<Ｆｃα .",
	}, { // 855
		mask: EncodeSlash | EncodeLeftPeriod | EncodeLeftSpace,
		in:   "h ＞\uff00␗I␄\x18ＵεJυ？|/ςＮ\x1e\rδt␂γ␛<Ｆｃα ．",
		out:  "h ＞\uff00␗I␄\x18ＵεJυ？|／ςＮ\x1e\rδt␂γ␛<Ｆｃα ．",
	}, { // 856
		mask: EncodeSingleQuote | EncodeLeftPeriod | EncodeLeftSpace,
		in:   ". ␆ζ␃4ε\x00\x16␡Ｅ\x1cτο＝wl␝^|~＝\x10/ν␗l＇ ｅ",
		out:  "． ␆ζ␃4ε␀\x16␡Ｅ\x1cτο＝wl␝^|~＝\x10/ν␗l‛＇ ｅ",
	}, { // 857
		mask: EncodeSingleQuote | EncodeLeftPeriod | EncodeLeftSpace,
		in:   "． ␆ζ␃4ε\x00\x16␡Ｅ\x1cτο＝wl␝^|~＝\x10/ν␗l＇ ｅ",
		out:  "‛． ␆ζ␃4ε␀\x16␡Ｅ\x1cτο＝wl␝^|~＝\x10/ν␗l‛＇ ｅ",
	}, { // 858
		mask: EncodeSingleQuote | EncodeLeftPeriod | EncodeLeftSpace,
		in:   "｜ ␆ζ␃4ε\x00\x16␡Ｅ\x1cτο＝wl␝^|~＝\x10/ν␗l＇ .",
		out:  "｜ ␆ζ␃4ε␀\x16␡Ｅ\x1cτο＝wl␝^|~＝\x10/ν␗l‛＇ .",
	}, { // 859
		mask: EncodeSingleQuote | EncodeLeftPeriod | EncodeLeftSpace,
		in:   "｜ ␆ζ␃4ε\x00\x16␡Ｅ\x1cτο＝wl␝^|~＝\x10/ν␗l＇ ．",
		out:  "｜ ␆ζ␃4ε␀\x16␡Ｅ\x1cτο＝wl␝^|~＝\x10/ν␗l‛＇ ．",
	}, { // 860
		mask: EncodeBackQuote | EncodeLeftPeriod | EncodeLeftSpace,
		in:   ". [｛$u＼Muτ？YrＫｔ<γ␜＼κ\x10：ｅ？＜ε\x12ν σ",
		out:  "． [｛$u＼Muτ？YrＫｔ<γ␜＼κ\x10：ｅ？＜ε\x12ν σ",
	}, { // 861
		mask: EncodeBackQuote | EncodeLeftPeriod | EncodeLeftSpace,
		in:   "． [｛$u＼Muτ？YrＫｔ<γ␜＼κ\x10：ｅ？＜ε\x12ν σ",
		out:  "‛． [｛$u＼Muτ？YrＫｔ<γ␜＼κ\x10：ｅ？＜ε\x12ν σ",
	}, { // 862
		mask: EncodeBackQuote | EncodeLeftPeriod | EncodeLeftSpace,
		in:   "＿ [｛$u＼Muτ？YrＫｔ<γ␜＼κ\x10：ｅ？＜ε\x12ν .",
		out:  "＿ [｛$u＼Muτ？YrＫｔ<γ␜＼κ\x10：ｅ？＜ε\x12ν .",
	}, { // 863
		mask: EncodeBackQuote | EncodeLeftPeriod | EncodeLeftSpace,
		in:   "＿ [｛$u＼Muτ？YrＫｔ<γ␜＼κ\x10：ｅ？＜ε\x12ν ．",
		out:  "＿ [｛$u＼Muτ？YrＫｔ<γ␜＼κ\x10：ｅ？＜ε\x12ν ．",
	}, { // 864
		mask: EncodeLtGt | EncodeLeftPeriod | EncodeLeftSpace,
		in:   ". EλRａ\x1fＬ\x1dＱｋ\x17τK/θｉ_｜Rν％\x0eδ\x0e␘＼＜ ε",
		out:  "． EλRａ\x1fＬ\x1dＱｋ\x17τK/θｉ_｜Rν％\x0eδ\x0e␘＼‛＜ ε",
	}, { // 865
		mask: EncodeLtGt | EncodeLeftPeriod | EncodeLeftSpace,
		in:   "． EλRａ\x1fＬ\x1dＱｋ\x17τK/θｉ_｜Rν％\x0eδ\x0e␘＼＜ ε",
		out:  "‛． EλRａ\x1fＬ\x1dＱｋ\x17τK/θｉ_｜Rν％\x0eδ\x0e␘＼‛＜ ε",
	}, { // 866
		mask: EncodeLtGt | EncodeLeftPeriod | EncodeLeftSpace,
		in:   "\" EλRａ\x1fＬ\x1dＱｋ\x17τK/θｉ_｜Rν％\x0eδ\x0e␘＼＜ .",
		out:  "\" EλRａ\x1fＬ\x1dＱｋ\x17τK/θｉ_｜Rν％\x0eδ\x0e␘＼‛＜ .",
	}, { // 867
		mask: EncodeLtGt | EncodeLeftPeriod | EncodeLeftSpace,
		in:   "\" EλRａ\x1fＬ\x1dＱｋ\x17τK/θｉ_｜Rν％\x0eδ\x0e␘＼＜ ．",
		out:  "\" EλRａ\x1fＬ\x1dＱｋ\x17τK/θｉ_｜Rν％\x0eδ\x0e␘＼‛＜ ．",
	}, { // 868
		mask: EncodeSquareBracket | EncodeLeftPeriod | EncodeLeftSpace,
		in:   ". O４xωκＸＤe\x1e\x1eF］ｘβ\x1fηＦ1\x16\r6；＞␂␃\r η",
		out:  "． O４xωκＸＤe\x1e\x1eF‛］ｘβ\x1fηＦ1\x16\r6；＞␂␃\r η",
	}, { // 869
		mask: EncodeSquareBracket | EncodeLeftPeriod | EncodeLeftSpace,
		in:   "． O４xωκＸＤe\x1e\x1eF］ｘβ\x1fηＦ1\x16\r6；＞␂␃\r η",
		out:  "‛． O４xωκＸＤe\x1e\x1eF‛］ｘβ\x1fηＦ1\x16\r6；＞␂␃\r η",
	}, { // 870
		mask: EncodeSquareBracket | EncodeLeftPeriod | EncodeLeftSpace,
		in:   "． O４xωκＸＤe\x1e\x1eF］ｘβ\x1fηＦ1\x16\r6；＞␂␃\r .",
		out:  "‛． O４xωκＸＤe\x1e\x1eF‛］ｘβ\x1fηＦ1\x16\r6；＞␂␃\r .",
	}, { // 871
		mask: EncodeSquareBracket | EncodeLeftPeriod | EncodeLeftSpace,
		in:   "． O４xωκＸＤe\x1e\x1eF］ｘβ\x1fηＦ1\x16\r6；＞␂␃\r ．",
		out:  "‛． O４xωκＸＤe\x1e\x1eF‛］ｘβ\x1fηＦ1\x16\r6；＞␂␃\r ．",
	}, { // 872
		mask: EncodeSemicolon | EncodeLeftPeriod | EncodeLeftSpace,
		in:   ". ␍χοＦ\v<Gｌω␀\x03\x15＇ς＃\rEXχ：^Ｊ␃\\？ｎ ?",
		out:  "． ␍χοＦ\v<Gｌω‛␀\x03\x15＇ς＃\rEXχ：^Ｊ␃\\？ｎ ?",
	}, { // 873
		mask: EncodeSemicolon | EncodeLeftPeriod | EncodeLeftSpace,
		in:   "． ␍χοＦ\v<Gｌω␀\x03\x15＇ς＃\rEXχ：^Ｊ␃\\？ｎ ?",
		out:  "‛． ␍χοＦ\v<Gｌω‛␀\x03\x15＇ς＃\rEXχ：^Ｊ␃\\？ｎ ?",
	}, { // 874
		mask: EncodeSemicolon | EncodeLeftPeriod | EncodeLeftSpace,
		in:   "？ ␍χοＦ\v<Gｌω␀\x03\x15＇ς＃\rEXχ：^Ｊ␃\\？ｎ .",
		out:  "？ ␍χοＦ\v<Gｌω‛␀\x03\x15＇ς＃\rEXχ：^Ｊ␃\\？ｎ .",
	}, { // 875
		mask: EncodeSemicolon | EncodeLeftPeriod | EncodeLeftSpace,
		in:   "？ ␍χοＦ\v<Gｌω␀\x03\x15＇ς＃\rEXχ：^Ｊ␃\\？ｎ ．",
		out:  "？ ␍χοＦ\v<Gｌω‛␀\x03\x15＇ς＃\rEXχ：^Ｊ␃\\？ｎ ．",
	}, { // 876
		mask: EncodeDollar | EncodeLeftPeriod | EncodeLeftSpace,
		in:   ". #/σττ`␟:␏ａt␐ｄA｝ι␗ιψ\f＃#␈{\x01␍ ＇",
		out:  "． #/σττ`␟:␏ａt␐ｄA｝ι␗ιψ\f＃#␈{\x01␍ ＇",
	}, { // 877
		mask: EncodeDollar | EncodeLeftPeriod | EncodeLeftSpace,
		in:   "． #/σττ`␟:␏ａt␐ｄA｝ι␗ιψ\f＃#␈{\x01␍ ＇",
		out:  "‛． #/σττ`␟:␏ａt␐ｄA｝ι␗ιψ\f＃#␈{\x01␍ ＇",
	}, { // 878
		mask: EncodeDollar | EncodeLeftPeriod | EncodeLeftSpace,
		in:   "Ｌ #/σττ`␟:␏ａt␐ｄA｝ι␗ιψ\f＃#␈{\x01␍ .",
		out:  "Ｌ #/σττ`␟:␏ａt␐ｄA｝ι␗ιψ\f＃#␈{\x01␍ .",
	}, { // 879
		mask: EncodeDollar | EncodeLeftPeriod | EncodeLeftSpace,
		in:   "Ｌ #/σττ`␟:␏ａt␐ｄA｝ι␗ιψ\f＃#␈{\x01␍ ．",
		out:  "Ｌ #/σττ`␟:␏ａt␐ｄA｝ι␗ιψ\f＃#␈{\x01␍ ．",
	}, { // 880
		mask: EncodeDoubleQuote | EncodeLeftPeriod | EncodeLeftSpace,
		in:   ". ␏ξ\x01␑]υ~＜\x00␄<ｓ␓]｜␕Ｗ$#χｎ1Ｏ3oχ ␛",
		out:  "． ␏ξ\x01␑]υ~＜␀␄<ｓ␓]｜␕Ｗ$#χｎ1Ｏ3oχ ␛",
	}, { // 881
		mask: EncodeDoubleQuote | EncodeLeftPeriod | EncodeLeftSpace,
		in:   "． ␏ξ\x01␑]υ~＜\x00␄<ｓ␓]｜␕Ｗ$#χｎ1Ｏ3oχ ␛",
		out:  "‛． ␏ξ\x01␑]υ~＜␀␄<ｓ␓]｜␕Ｗ$#χｎ1Ｏ3oχ ␛",
	}, { // 882
		mask: EncodeDoubleQuote | EncodeLeftPeriod | EncodeLeftSpace,
		in:   "ο ␏ξ\x01␑]υ~＜\x00␄<ｓ␓]｜␕Ｗ$#χｎ1Ｏ3oχ .",
		out:  "ο ␏ξ\x01␑]υ~＜␀␄<ｓ␓]｜␕Ｗ$#χｎ1Ｏ3oχ .",
	}, { // 883
		mask: EncodeDoubleQuote | EncodeLeftPeriod | EncodeLeftSpace,
		in:   "ο ␏ξ\x01␑]υ~＜\x00␄<ｓ␓]｜␕Ｗ$#χｎ1Ｏ3oχ ．",
		out:  "ο ␏ξ\x01␑]υ~＜␀␄<ｓ␓]｜␕Ｗ$#χｎ1Ｏ3oχ ．",
	}, { // 884
		mask: EncodeColon | EncodeLeftPeriod | EncodeLeftSpace,
		in:   ". \"ξＬ$␁\x03οG．ι5ｘ\x16␑＇F=ｔρc'␀ψχ＆\r ␛",
		out:  "． \"ξＬ$␁\x03οG．ι5ｘ\x16␑＇F=ｔρc'‛␀ψχ＆\r ␛",
	}, { // 885
		mask: EncodeColon | EncodeLeftPeriod | EncodeLeftSpace,
		in:   "． \"ξＬ$␁\x03οG．ι5ｘ\x16␑＇F=ｔρc'␀ψχ＆\r ␛",
		out:  "‛． \"ξＬ$␁\x03οG．ι5ｘ\x16␑＇F=ｔρc'‛␀ψχ＆\r ␛",
	}, { // 886
		mask: EncodeColon | EncodeLeftPeriod | EncodeLeftSpace,
		in:   "＄ \"ξＬ$␁\x03οG．ι5ｘ\x16␑＇F=ｔρc'␀ψχ＆\r .",
		out:  "＄ \"ξＬ$␁\x03οG．ι5ｘ\x16␑＇F=ｔρc'‛␀ψχ＆\r .",
	}, { // 887
		mask: EncodeColon | EncodeLeftPeriod | EncodeLeftSpace,
		in:   "＄ \"ξＬ$␁\x03οG．ι5ｘ\x16␑＇F=ｔρc'␀ψχ＆\r ．",
		out:  "＄ \"ξＬ$␁\x03οG．ι5ｘ\x16␑＇F=ｔρc'‛␀ψχ＆\r ．",
	}, { // 888
		mask: EncodeQuestion | EncodeLeftPeriod | EncodeLeftSpace,
		in:   ". υcυ０＞␛\aL＞\x13<θ\n］｜γ#θ＃χ␒@\x1d<␘＂ +",
		out:  "． υcυ０＞␛\aL＞\x13<θ\n］｜γ#θ＃χ␒@\x1d<␘＂ +",
	}, { // 889
		mask: EncodeQuestion | EncodeLeftPeriod | EncodeLeftSpace,
		in:   "． υcυ０＞␛\aL＞\x13<θ\n］｜γ#θ＃χ␒@\x1d<␘＂ +",
		out:  "‛． υcυ０＞␛\aL＞\x13<θ\n］｜γ#θ＃χ␒@\x1d<␘＂ +",
	}, { // 890
		mask: EncodeQuestion | EncodeLeftPeriod | EncodeLeftSpace,
		in:   "\uff00 υcυ０＞␛\aL＞\x13<θ\n］｜γ#θ＃χ␒@\x1d<␘＂ .",
		out:  "\uff00 υcυ０＞␛\aL＞\x13<θ\n］｜γ#θ＃χ␒@\x1d<␘＂ .",
	}, { // 891
		mask: EncodeQuestion | EncodeLeftPeriod | EncodeLeftSpace,
		in:   "\uff00 υcυ０＞␛\aL＞\x13<θ\n］｜γ#θ＃χ␒@\x1d<␘＂ ．",
		out:  "\uff00 υcυ０＞␛\aL＞\x13<θ\n］｜γ#θ＃χ␒@\x1d<␘＂ ．",
	}, { // 892
		mask: EncodeAsterisk | EncodeLeftPeriod | EncodeLeftSpace,
		in:   ". <ς＄γqS８２πJ＜\x00\x1ca｛7＄␒2\rςγ＄Ｒ\rＵ \x1b",
		out:  "． <ς＄γqS８２πJ＜␀\x1ca｛7＄␒2\rςγ＄Ｒ\rＵ \x1b",
	}, { // 893
		mask: EncodeAsterisk | EncodeLeftPeriod | EncodeLeftSpace,
		in:   "． <ς＄γqS８２πJ＜\x00\x1ca｛7＄␒2\rςγ＄Ｒ\rＵ \x1b",
		out:  "‛． <ς＄γqS８２πJ＜␀\x1ca｛7＄␒2\rςγ＄Ｒ\rＵ \x1b",
	}, { // 894
		mask: EncodeAsterisk | EncodeLeftPeriod | EncodeLeftSpace,
		in:   "␓ <ς＄γqS８２πJ＜\x00\x1ca｛7＄␒2\rςγ＄Ｒ\rＵ .",
		out:  "␓ <ς＄γqS８２πJ＜␀\x1ca｛7＄␒2\rςγ＄Ｒ\rＵ .",
	}, { // 895
		mask: EncodeAsterisk | EncodeLeftPeriod | EncodeLeftSpace,
		in:   "␓ <ς＄γqS８２πJ＜\x00\x1ca｛7＄␒2\rςγ＄Ｒ\rＵ ．",
		out:  "␓ <ς＄γqS８２πJ＜␀\x1ca｛7＄␒2\rςγ＄Ｒ\rＵ ．",
	}, { // 896
		mask: EncodePipe | EncodeLeftPeriod | EncodeLeftSpace,
		in:   ". \x0f#χ\x03\"␍\uff00\x13ν\x06：␊ｑrJ7σχ？␆Ｇυ＜Ａ\r␋ 0",
		out:  "． \x0f#χ\x03\"␍\uff00\x13ν\x06：␊ｑrJ7σχ？␆Ｇυ＜Ａ\r␋ 0",
	}, { // 897
		mask: EncodePipe | EncodeLeftPeriod | EncodeLeftSpace,
		in:   "． \x0f#χ\x03\"␍\uff00\x13ν\x06：␊ｑrJ7σχ？␆Ｇυ＜Ａ\r␋ 0",
		out:  "‛． \x0f#χ\x03\"␍\uff00\x13ν\x06：␊ｑrJ7σχ？␆Ｇυ＜Ａ\r␋ 0",
	}, { // 898
		mask: EncodePipe | EncodeLeftPeriod | EncodeLeftSpace,
		in:   "P \x0f#χ\x03\"␍\uff00\x13ν\x06：␊ｑrJ7σχ？␆Ｇυ＜Ａ\r␋ .",
		out:  "P \x0f#χ\x03\"␍\uff00\x13ν\x06：␊ｑrJ7σχ？␆Ｇυ＜Ａ\r␋ .",
	}, { // 899
		mask: EncodePipe | EncodeLeftPeriod | EncodeLeftSpace,
		in:   "P \x0f#χ\x03\"␍\uff00\x13ν\x06：␊ｑrJ7σχ？␆Ｇυ＜Ａ\r␋ ．",
		out:  "P \x0f#χ\x03\"␍\uff00\x13ν\x06：␊ｑrJ7σχ？␆Ｇυ＜Ａ\r␋ ．",
	}, { // 900
		mask: EncodeHash | EncodeLeftPeriod | EncodeLeftSpace,
		in:   ". κ@>Jl＆␅π␘\u007fιc␊υ[φ\x01？＞Ｑ＿４Ｚ4A\x13 \t",
		out:  "． κ@>Jl＆␅π␘\u007fιc␊υ[φ\x01？＞Ｑ＿４Ｚ4A\x13 \t",
	}, { // 901
		mask: EncodeHash | EncodeLeftPeriod | EncodeLeftSpace,
		in:   "． κ@>Jl＆␅π␘\u007fιc␊υ[φ\x01？＞Ｑ＿４Ｚ4A\x13 \t",
		out:  "‛． κ@>Jl＆␅π␘\u007fιc␊υ[φ\x01？＞Ｑ＿４Ｚ4A\x13 \t",
	}, { // 902
		mask: EncodeHash | EncodeLeftPeriod | EncodeLeftSpace,
		in:   "π κ@>Jl＆␅π␘\u007fιc␊υ[φ\x01？＞Ｑ＿４Ｚ4A\x13 .",
		out:  "π κ@>Jl＆␅π␘\u007fιc␊υ[φ\x01？＞Ｑ＿４Ｚ4A\x13 .",
	}, { // 903
		mask: EncodeHash | EncodeLeftPeriod | EncodeLeftSpace,
		in:   "π κ@>Jl＆␅π␘\u007fιc␊υ[φ\x01？＞Ｑ＿４Ｚ4A\x13 ．",
		out:  "π κ@>Jl＆␅π␘\u007fιc␊υ[φ\x01？＞Ｑ＿４Ｚ4A\x13 ．",
	}, { // 904
		mask: EncodePercent | EncodeLeftPeriod | EncodeLeftSpace,
		in:   ". ␓ｄ␃.τ\x14␙ζ\x0fm\nＲｈ８x/c␂＆υε\\λιR␐ Y",
		out:  "． ␓ｄ␃.τ\x14␙ζ\x0fm\nＲｈ８x/c␂＆υε\\λιR␐ Y",
	}, { // 905
		mask: EncodePercent | EncodeLeftPeriod | EncodeLeftSpace,
		in:   "． ␓ｄ␃.τ\x14␙ζ\x0fm\nＲｈ８x/c␂＆υε\\λιR␐ Y",
		out:  "‛． ␓ｄ␃.τ\x14␙ζ\x0fm\nＲｈ８x/c␂＆υε\\λιR␐ Y",
	}, { // 906
		mask: EncodePercent | EncodeLeftPeriod | EncodeLeftSpace,
		in:   "␘ ␓ｄ␃.τ\x14␙ζ\x0fm\nＲｈ８x/c␂＆υε\\λιR␐ .",
		out:  "␘ ␓ｄ␃.τ\x14␙ζ\x0fm\nＲｈ８x/c␂＆υε\\λιR␐ .",
	}, { // 907
		mask: EncodePercent | EncodeLeftPeriod | EncodeLeftSpace,
		in:   "␘ ␓ｄ␃.τ\x14␙ζ\x0fm\nＲｈ８x/c␂＆υε\\λιR␐ ．",
		out:  "␘ ␓ｄ␃.τ\x14␙ζ\x0fm\nＲｈ８x/c␂＆υε\\λιR␐ ．",
	}, { // 908
		mask: EncodeBackSlash | EncodeLeftPeriod | EncodeLeftSpace,
		in:   ". ？z\x12␁＠α?；z？＝␄αＰν<7<`h$ω\x04，υＬ Ｎ",
		out:  "． ？z\x12␁＠α?；z？＝␄αＰν<7<`h$ω\x04，υＬ Ｎ",
	}, { // 909
		mask: EncodeBackSlash | EncodeLeftPeriod | EncodeLeftSpace,
		in:   "． ？z\x12␁＠α?；z？＝␄αＰν<7<`h$ω\x04，υＬ Ｎ",
		out:  "‛． ？z\x12␁＠α?；z？＝␄αＰν<7<`h$ω\x04，υＬ Ｎ",
	}, { // 910
		mask: EncodeBackSlash | EncodeLeftPeriod | EncodeLeftSpace,
		in:   "＜ ？z\x12␁＠α?；z？＝␄αＰν<7<`h$ω\x04，υＬ .",
		out:  "＜ ？z\x12␁＠α?；z？＝␄αＰν<7<`h$ω\x04，υＬ .",
	}, { // 911
		mask: EncodeBackSlash | EncodeLeftPeriod | EncodeLeftSpace,
		in:   "＜ ？z\x12␁＠α?；z？＝␄αＰν<7<`h$ω\x04，υＬ ．",
		out:  "＜ ？z\x12␁＠α?；z？＝␄αＰν<7<`h$ω\x04，υＬ ．",
	}, { // 912
		mask: EncodeCrLf | EncodeLeftPeriod | EncodeLeftSpace,
		in:   ". ０␆π:\x17*ε_\x0fＥψｆｋ?␊Ｖ\b＇␙ψDλγｑ␕/ ␍",
		out:  "． ０␆π:\x17*ε_\x0fＥψｆｋ?‛␊Ｖ\b＇␙ψDλγｑ␕/ ‛␍",
	}, { // 913
		mask: EncodeCrLf | EncodeLeftPeriod | EncodeLeftSpace,
		in:   "． ０␆π:\x17*ε_\x0fＥψｆｋ?␊Ｖ\b＇␙ψDλγｑ␕/ ␍",
		out:  "‛． ０␆π:\x17*ε_\x0fＥψｆｋ?‛␊Ｖ\b＇␙ψDλγｑ␕/ ‛␍",
	}, { // 914
		mask: EncodeCrLf | EncodeLeftPeriod | EncodeLeftSpace,
		in:   "  ０␆π:\x17*ε_\x0fＥψｆｋ?␊Ｖ\b＇␙ψDλγｑ␕/ .",
		out:  "␠ ０␆π:\x17*ε_\x0fＥψｆｋ?‛␊Ｖ\b＇␙ψDλγｑ␕/ .",
	}, { // 915
		mask: EncodeCrLf | EncodeLeftPeriod | EncodeLeftSpace,
		in:   "  ０␆π:\x17*ε_\x0fＥψｆｋ?␊Ｖ\b＇␙ψDλγｑ␕/ ．",
		out:  "␠ ０␆π:\x17*ε_\x0fＥψｆｋ?‛␊Ｖ\b＇␙ψDλγｑ␕/ ．",
	}, { // 916
		mask: EncodeDel | EncodeLeftPeriod | EncodeLeftSpace,
		in:   ". ␍␊Ｄσ␡ｌ\x1dw\rｃaο+｜␕'Ｋ[{\x16'Ｃχδ＠␚ \u007f",
		out:  "． ␍␊Ｄσ‛␡ｌ\x1dw\rｃaο+｜␕'Ｋ[{\x16'Ｃχδ＠␚ ␡",
	}, { // 917
		mask: EncodeDel | EncodeLeftPeriod | EncodeLeftSpace,
		in:   "． ␍␊Ｄσ␡ｌ\x1dw\rｃaο+｜␕'Ｋ[{\x16'Ｃχδ＠␚ \u007f",
		out:  "‛． ␍␊Ｄσ‛␡ｌ\x1dw\rｃaο+｜␕'Ｋ[{\x16'Ｃχδ＠␚ ␡",
	}, { // 918
		mask: EncodeDel | EncodeLeftPeriod | EncodeLeftSpace,
		in:   "[ ␍␊Ｄσ␡ｌ\x1dw\rｃaο+｜␕'Ｋ[{\x16'Ｃχδ＠␚ .",
		out:  "[ ␍␊Ｄσ‛␡ｌ\x1dw\rｃaο+｜␕'Ｋ[{\x16'Ｃχδ＠␚ .",
	}, { // 919
		mask: EncodeDel | EncodeLeftPeriod | EncodeLeftSpace,
		in:   "[ ␍␊Ｄσ␡ｌ\x1dw\rｃaο+｜␕'Ｋ[{\x16'Ｃχδ＠␚ ．",
		out:  "[ ␍␊Ｄσ‛␡ｌ\x1dw\rｃaο+｜␕'Ｋ[{\x16'Ｃχδ＠␚ ．",
	}, { // 920
		mask: EncodeCtl | EncodeLeftPeriod | EncodeLeftSpace,
		in:   ". ␃\x18Ｐ\x0e\x16OP\aＩ／κ␚ｑ$Qγ␄ωαy\x06π␆ｎ␟α ｋ",
		out:  "． ‛␃␘Ｐ␎␖OP␇Ｉ／κ‛␚ｑ$Qγ‛␄ωαy␆π‛␆ｎ‛␟α ｋ",
	}, { // 921
		mask: EncodeCtl | EncodeLeftPeriod | EncodeLeftSpace,
		in:   "． ␃\x18Ｐ\x0e\x16OP\aＩ／κ␚ｑ$Qγ␄ωαy\x06π␆ｎ␟α ｋ",
		out:  "‛． ‛␃␘Ｐ␎␖OP␇Ｉ／κ‛␚ｑ$Qγ‛␄ωαy␆π‛␆ｎ‛␟α ｋ",
	}, { // 922
		mask: EncodeCtl | EncodeLeftPeriod | EncodeLeftSpace,
		in:   "5 ␃\x18Ｐ\x0e\x16OP\aＩ／κ␚ｑ$Qγ␄ωαy\x06π␆ｎ␟α .",
		out:  "5 ‛␃␘Ｐ␎␖OP␇Ｉ／κ‛␚ｑ$Qγ‛␄ωαy␆π‛␆ｎ‛␟α .",
	}, { // 923
		mask: EncodeCtl | EncodeLeftPeriod | EncodeLeftSpace,
		in:   "5 ␃\x18Ｐ\x0e\x16OP\aＩ／κ␚ｑ$Qγ␄ωαy\x06π␆ｎ␟α ．",
		out:  "5 ‛␃␘Ｐ␎␖OP␇Ｉ／κ‛␚ｑ$Qγ‛␄ωαy␆π‛␆ｎ‛␟α ．",
	}, { // 924
		mask: EncodeZero | EncodeLeftPeriod | EncodeLeftTilde,
		in:   ".~l␚␃;βｆχ␅␘|＊ γＩ＋\v␗ｈψc\x12\n３/＊δ~\x0e",
		out:  "．~l␚␃;βｆχ␅␘|＊ γＩ＋\v␗ｈψc\x12\n３/＊δ~\x0e",
	}, { // 925
		mask: EncodeZero | EncodeLeftPeriod | EncodeLeftTilde,
		in:   "．~l␚␃;βｆχ␅␘|＊ γＩ＋\v␗ｈψc\x12\n３/＊δ~\x0e",
		out:  "‛．~l␚␃;βｆχ␅␘|＊ γＩ＋\v␗ｈψc\x12\n３/＊δ~\x0e",
	}, { // 926
		mask: EncodeZero | EncodeLeftPeriod | EncodeLeftTilde,
		in:   "γ~l␚␃;βｆχ␅␘|＊ γＩ＋\v␗ｈψc\x12\n３/＊δ~.",
		out:  "γ~l␚␃;βｆχ␅␘|＊ γＩ＋\v␗ｈψc\x12\n３/＊δ~.",
	}, { // 927
		mask: EncodeZero | EncodeLeftPeriod | EncodeLeftTilde,
		in:   "γ~l␚␃;βｆχ␅␘|＊ γＩ＋\v␗ｈψc\x12\n３/＊δ~．",
		out:  "γ~l␚␃;βｆχ␅␘|＊ γＩ＋\v␗ｈψc\x12\n３/＊δ~．",
	}, { // 928
		mask: EncodeSlash | EncodeLeftPeriod | EncodeLeftTilde,
		in:   ".~␇#２Ｐγ\u007f４\x1d＃K？Zτz␌␄x␖\x13χ）φG－\r\x15~δ",
		out:  "．~␇#２Ｐγ\u007f４\x1d＃K？Zτz␌␄x␖\x13χ）φG－\r\x15~δ",
	}, { // 929
		mask: EncodeSlash | EncodeLeftPeriod | EncodeLeftTilde,
		in:   "．~␇#２Ｐγ\u007f４\x1d＃K？Zτz␌␄x␖\x13χ）φG－\r\x15~δ",
		out:  "‛．~␇#２Ｐγ\u007f４\x1d＃K？Zτz␌␄x␖\x13χ）φG－\r\x15~δ",
	}, { // 930
		mask: EncodeSlash | EncodeLeftPeriod | EncodeLeftTilde,
		in:   "/~␇#２Ｐγ\u007f４\x1d＃K？Zτz␌␄x␖\x13χ）φG－\r\x15~.",
		out:  "／~␇#２Ｐγ\u007f４\x1d＃K？Zτz␌␄x␖\x13χ）φG－\r\x15~.",
	}, { // 931
		mask: EncodeSlash | EncodeLeftPeriod | EncodeLeftTilde,
		in:   "/~␇#２Ｐγ\u007f４\x1d＃K？Zτz␌␄x␖\x13χ）φG－\r\x15~．",
		out:  "／~␇#２Ｐγ\u007f４\x1d＃K？Zτz␌␄x␖\x13χ）φG－\r\x15~．",
	}, { // 932
		mask: EncodeSingleQuote | EncodeLeftPeriod | EncodeLeftTilde,
		in:   ".~s␃Fω＠２＇λ␖\x13[σｉ\x12\x13！␘␐(ν\x13ｈτφ9\x16~Ｌ",
		out:  "．~s␃Fω＠２‛＇λ␖\x13[σｉ\x12\x13！␘␐(ν\x13ｈτφ9\x16~Ｌ",
	}, { // 933
		mask: EncodeSingleQuote | EncodeLeftPeriod | EncodeLeftTilde,
		in:   "．~s␃Fω＠２＇λ␖\x13[σｉ\x12\x13！␘␐(ν\x13ｈτφ9\x16~Ｌ",
		out:  "‛．~s␃Fω＠２‛＇λ␖\x13[σｉ\x12\x13！␘␐(ν\x13ｈτφ9\x16~Ｌ",
	}, { // 934
		mask: EncodeSingleQuote | EncodeLeftPeriod | EncodeLeftTilde,
		in:   "\a~s␃Fω＠２＇λ␖\x13[σｉ\x12\x13！␘␐(ν\x13ｈτφ9\x16~.",
		out:  "\a~s␃Fω＠２‛＇λ␖\x13[σｉ\x12\x13！␘␐(ν\x13ｈτφ9\x16~.",
	}, { // 935
		mask: EncodeSingleQuote | EncodeLeftPeriod | EncodeLeftTilde,
		in:   "\a~s␃Fω＠２＇λ␖\x13[σｉ\x12\x13！␘␐(ν\x13ｈτφ9\x16~．",
		out:  "\a~s␃Fω＠２‛＇λ␖\x13[σｉ\x12\x13！␘␐(ν\x13ｈτφ9\x16~．",
	}, { // 936
		mask: EncodeBackQuote | EncodeLeftPeriod | EncodeLeftTilde,
		in:   ".~\bＷ␔L）␚δ5γικ\\θ＃ｆＱ\n\x12␏４\"＝\x19＃οR~'",
		out:  "．~\bＷ␔L）␚δ5γικ\\θ＃ｆＱ\n\x12␏４\"＝\x19＃οR~'",
	}, { // 937
		mask: EncodeBackQuote | EncodeLeftPeriod | EncodeLeftTilde,
		in:   "．~\bＷ␔L）␚δ5γικ\\θ＃ｆＱ\n\x12␏４\"＝\x19＃οR~'",
		out:  "‛．~\bＷ␔L）␚δ5γικ\\θ＃ｆＱ\n\x12␏４\"＝\x19＃οR~'",
	}, { // 938
		mask: EncodeBackQuote | EncodeLeftPeriod | EncodeLeftTilde,
		in:   "$~\bＷ␔L）␚δ5γικ\\θ＃ｆＱ\n\x12␏４\"＝\x19＃οR~.",
		out:  "$~\bＷ␔L）␚δ5γικ\\θ＃ｆＱ\n\x12␏４\"＝\x19＃οR~.",
	}, { // 939
		mask: EncodeBackQuote | EncodeLeftPeriod | EncodeLeftTilde,
		in:   "$~\bＷ␔L）␚δ5γικ\\θ＃ｆＱ\n\x12␏４\"＝\x19＃οR~．",
		out:  "$~\bＷ␔L）␚δ5γικ\\θ＃ｆＱ\n\x12␏４\"＝\x19＃οR~．",
	}, { // 940
		mask: EncodeLtGt | EncodeLeftPeriod | EncodeLeftTilde,
		in:   ".~yπξ＾A／＃8\x11ｖ［/%\x06φ＊'φδＪ␂α＜ｐ：9~␕",
		out:  "．~yπξ＾A／＃8\x11ｖ［/%\x06φ＊'φδＪ␂α‛＜ｐ：9~␕",
	}, { // 941
		mask: EncodeLtGt | EncodeLeftPeriod | EncodeLeftTilde,
		in:   "．~yπξ＾A／＃8\x11ｖ［/%\x06φ＊'φδＪ␂α＜ｐ：9~␕",
		out:  "‛．~yπξ＾A／＃8\x11ｖ［/%\x06φ＊'φδＪ␂α‛＜ｐ：9~␕",
	}, { // 942
		mask: EncodeLtGt | EncodeLeftPeriod | EncodeLeftTilde,
		in:   "\"~yπξ＾A／＃8\x11ｖ［/%\x06φ＊'φδＪ␂α＜ｐ：9~.",
		out:  "\"~yπξ＾A／＃8\x11ｖ［/%\x06φ＊'φδＪ␂α‛＜ｐ：9~.",
	}, { // 943
		mask: EncodeLtGt | EncodeLeftPeriod | EncodeLeftTilde,
		in:   "\"~yπξ＾A／＃8\x11ｖ［/%\x06φ＊'φδＪ␂α＜ｐ：9~．",
		out:  "\"~yπξ＾A／＃8\x11ｖ［/%\x06φ＊'φδＪ␂α‛＜ｐ：9~．",
	}, { // 944
		mask: EncodeSquareBracket | EncodeLeftPeriod | EncodeLeftTilde,
		in:   ".~\x14τF＼:␝μｎ／%λ6\x1cｈ\bζＨ%ι~＾\x11=υ＂%~／",
		out:  "．~\x14τF＼:␝μｎ／%λ6\x1cｈ\bζＨ%ι~＾\x11=υ＂%~／",
	}, { // 945
		mask: EncodeSquareBracket | EncodeLeftPeriod | EncodeLeftTilde,
		in:   "．~\x14τF＼:␝μｎ／%λ6\x1cｈ\bζＨ%ι~＾\x11=υ＂%~／",
		out:  "‛．~\x14τF＼:␝μｎ／%λ6\x1cｈ\bζＨ%ι~＾\x11=υ＂%~／",
	}, { // 946
		mask: EncodeSquareBracket | EncodeLeftPeriod | EncodeLeftTilde,
		in:   "ｗ~\x14τF＼:␝μｎ／%λ6\x1cｈ\bζＨ%ι~＾\x11=υ＂%~.",
		out:  "ｗ~\x14τF＼:␝μｎ／%λ6\x1cｈ\bζＨ%ι~＾\x11=υ＂%~.",
	}, { // 947
		mask: EncodeSquareBracket | EncodeLeftPeriod | EncodeLeftTilde,
		in:   "ｗ~\x14τF＼:␝μｎ／%λ6\x1cｈ\bζＨ%ι~＾\x11=υ＂%~．",
		out:  "ｗ~\x14τF＼:␝μｎ／%λ6\x1cｈ\bζＨ%ι~＾\x11=υ＂%~．",
	}, { // 948
		mask: EncodeSemicolon | EncodeLeftPeriod | EncodeLeftTilde,
		in:   ".~␝δ␗f\x0f$ｃ@7h␒ε␊␊＂ν\x1elυ］－␒`６\x1f|~＠",
		out:  "．~␝δ␗f\x0f$ｃ@7h␒ε␊␊＂ν\x1elυ］－␒`６\x1f|~＠",
	}, { // 949
		mask: EncodeSemicolon | EncodeLeftPeriod | EncodeLeftTilde,
		in:   "．~␝δ␗f\x0f$ｃ@7h␒ε␊␊＂ν\x1elυ］－␒`６\x1f|~＠",
		out:  "‛．~␝δ␗f\x0f$ｃ@7h␒ε␊␊＂ν\x1elυ］－␒`６\x1f|~＠",
	}, { // 950
		mask: EncodeSemicolon | EncodeLeftPeriod | EncodeLeftTilde,
		in:   "]~␝δ␗f\x0f$ｃ@7h␒ε␊␊＂ν\x1elυ］－␒`６\x1f|~.",
		out:  "]~␝δ␗f\x0f$ｃ@7h␒ε␊␊＂ν\x1elυ］－␒`６\x1f|~.",
	}, { // 951
		mask: EncodeSemicolon | EncodeLeftPeriod | EncodeLeftTilde,
		in:   "]~␝δ␗f\x0f$ｃ@7h␒ε␊␊＂ν\x1elυ］－␒`６\x1f|~．",
		out:  "]~␝δ␗f\x0f$ｃ@7h␒ε␊␊＂ν\x1elυ］－␒`６\x1f|~．",
	}, { // 952
		mask: EncodeDollar | EncodeLeftPeriod | EncodeLeftTilde,
		in:   ".~Uα␎Ｒ␈\x17\\＃ｈ：９\x18＊/αE；␎ο\uff00sｑK\fζ}~\x15",
		out:  "．~Uα␎Ｒ␈\x17\\＃ｈ：９\x18＊/αE；␎ο\uff00sｑK\fζ}~\x15",
	}, { // 953
		mask: EncodeDollar | EncodeLeftPeriod | EncodeLeftTilde,
		in:   "．~Uα␎Ｒ␈\x17\\＃ｈ：９\x18＊/αE；␎ο\uff00sｑK\fζ}~\x15",
		out:  "‛．~Uα␎Ｒ␈\x17\\＃ｈ：９\x18＊/αE；␎ο\uff00sｑK\fζ}~\x15",
	}, { // 954
		mask: EncodeDollar | EncodeLeftPeriod | EncodeLeftTilde,
		in:   "ς~Uα␎Ｒ␈\x17\\＃ｈ：９\x18＊/αE；␎ο\uff00sｑK\fζ}~.",
		out:  "ς~Uα␎Ｒ␈\x17\\＃ｈ：９\x18＊/αE；␎ο\uff00sｑK\fζ}~.",
	}, { // 955
		mask: EncodeDollar | EncodeLeftPeriod | EncodeLeftTilde,
		in:   "ς~Uα␎Ｒ␈\x17\\＃ｈ：９\x18＊/αE；␎ο\uff00sｑK\fζ}~．",
		out:  "ς~Uα␎Ｒ␈\x17\\＃ｈ：９\x18＊/αE；␎ο\uff00sｑK\fζ}~．",
	}, { // 956
		mask: EncodeDoubleQuote | EncodeLeftPeriod | EncodeLeftTilde,
		in:   ".~\x190M\x1f/ε␡A␉>\\ξＫ\x18;;δ／η｜␛Ｋ＄ορ５~Ｖ",
		out:  "．~\x190M\x1f/ε␡A␉>\\ξＫ\x18;;δ／η｜␛Ｋ＄ορ５~Ｖ",
	}, { // 957
		mask: EncodeDoubleQuote | EncodeLeftPeriod | EncodeLeftTilde,
		in:   "．~\x190M\x1f/ε␡A␉>\\ξＫ\x18;;δ／η｜␛Ｋ＄ορ５~Ｖ",
		out:  "‛．~\x190M\x1f/ε␡A␉>\\ξＫ\x18;;δ／η｜␛Ｋ＄ορ５~Ｖ",
	}, { // 958
		mask: EncodeDoubleQuote | EncodeLeftPeriod | EncodeLeftTilde,
		in:   "ｏ~\x190M\x1f/ε␡A␉>\\ξＫ\x18;;δ／η｜␛Ｋ＄ορ５~.",
		out:  "ｏ~\x190M\x1f/ε␡A␉>\\ξＫ\x18;;δ／η｜␛Ｋ＄ορ５~.",
	}, { // 959
		mask: EncodeDoubleQuote | EncodeLeftPeriod | EncodeLeftTilde,
		in:   "ｏ~\x190M\x1f/ε␡A␉>\\ξＫ\x18;;δ／η｜␛Ｋ＄ορ５~．",
		out:  "ｏ~\x190M\x1f/ε␡A␉>\\ξＫ\x18;;δ／η｜␛Ｋ＄ορ５~．",
	}, { // 960
		mask: EncodeColon | EncodeLeftPeriod | EncodeLeftTilde,
		in:   ".~\x0e␆\x12K`piχ␞＋;\x13ｚζ␚\"／Ｋθαwψｂ␎ο４~＜",
		out:  "．~\x0e␆\x12K`piχ␞＋;\x13ｚζ␚\"／Ｋθαwψｂ␎ο４~＜",
	}, { // 961
		mask: EncodeColon | EncodeLeftPeriod | EncodeLeftTilde,
		in:   "．~\x0e␆\x12K`piχ␞＋;\x13ｚζ␚\"／Ｋθαwψｂ␎ο４~＜",
		out:  "‛．~\x0e␆\x12K`piχ␞＋;\x13ｚζ␚\"／Ｋθαwψｂ␎ο４~＜",
	}, { // 962
		mask: EncodeColon | EncodeLeftPeriod | EncodeLeftTilde,
		in:   "ｈ~\x0e␆\x12K`piχ␞＋;\x13ｚζ␚\"／Ｋθαwψｂ␎ο４~.",
		out:  "ｈ~\x0e␆\x12K`piχ␞＋;\x13ｚζ␚\"／Ｋθαwψｂ␎ο４~.",
	}, { // 963
		mask: EncodeColon | EncodeLeftPeriod | EncodeLeftTilde,
		in:   "ｈ~\x0e␆\x12K`piχ␞＋;\x13ｚζ␚\"／Ｋθαwψｂ␎ο４~．",
		out:  "ｈ~\x0e␆\x12K`piχ␞＋;\x13ｚζ␚\"／Ｋθαwψｂ␎ο４~．",
	}, { // 964
		mask: EncodeQuestion | EncodeLeftPeriod | EncodeLeftTilde,
		in:   ".~\x1fδβｉ＂\x10#λθ␈\x1d\x17␊／＂：␙*5>fB３t＆␖~β",
		out:  "．~\x1fδβｉ＂\x10#λθ␈\x1d\x17␊／＂：␙*5>fB３t＆␖~β",
	}, { // 965
		mask: EncodeQuestion | EncodeLeftPeriod | EncodeLeftTilde,
		in:   "．~\x1fδβｉ＂\x10#λθ␈\x1d\x17␊／＂：␙*5>fB３t＆␖~β",
		out:  "‛．~\x1fδβｉ＂\x10#λθ␈\x1d\x17␊／＂：␙*5>fB３t＆␖~β",
	}, { // 966
		mask: EncodeQuestion | EncodeLeftPeriod | EncodeLeftTilde,
		in:   "7~\x1fδβｉ＂\x10#λθ␈\x1d\x17␊／＂：␙*5>fB３t＆␖~.",
		out:  "7~\x1fδβｉ＂\x10#λθ␈\x1d\x17␊／＂：␙*5>fB３t＆␖~.",
	}, { // 967
		mask: EncodeQuestion | EncodeLeftPeriod | EncodeLeftTilde,
		in:   "7~\x1fδβｉ＂\x10#λθ␈\x1d\x17␊／＂：␙*5>fB３t＆␖~．",
		out:  "7~\x1fδβｉ＂\x10#λθ␈\x1d\x17␊／＂：␙*5>fB３t＆␖~．",
	}, { // 968
		mask: EncodeAsterisk | EncodeLeftPeriod | EncodeLeftTilde,
		in:   ".~ς\u007f｀Ｘ␑␄/Ｃ\x01κV;γＬ／C␜\\μβ;ｏ␚βz\u007f~＄",
		out:  "．~ς\u007f｀Ｘ␑␄/Ｃ\x01κV;γＬ／C␜\\μβ;ｏ␚βz\u007f~＄",
	}, { // 969
		mask: EncodeAsterisk | EncodeLeftPeriod | EncodeLeftTilde,
		in:   "．~ς\u007f｀Ｘ␑␄/Ｃ\x01κV;γＬ／C␜\\μβ;ｏ␚βz\u007f~＄",
		out:  "‛．~ς\u007f｀Ｘ␑␄/Ｃ\x01κV;γＬ／C␜\\μβ;ｏ␚βz\u007f~＄",
	}, { // 970
		mask: EncodeAsterisk | EncodeLeftPeriod | EncodeLeftTilde,
		in:   "\x05~ς\u007f｀Ｘ␑␄/Ｃ\x01κV;γＬ／C␜\\μβ;ｏ␚βz\u007f~.",
		out:  "\x05~ς\u007f｀Ｘ␑␄/Ｃ\x01κV;γＬ／C␜\\μβ;ｏ␚βz\u007f~.",
	}, { // 971
		mask: EncodeAsterisk | EncodeLeftPeriod | EncodeLeftTilde,
		in:   "\x05~ς\u007f｀Ｘ␑␄/Ｃ\x01κV;γＬ／C␜\\μβ;ｏ␚βz\u007f~．",
		out:  "\x05~ς\u007f｀Ｘ␑␄/Ｃ\x01κV;γＬ／C␜\\μβ;ｏ␚βz\u007f~．",
	}, { // 972
		mask: EncodePipe | EncodeLeftPeriod | EncodeLeftTilde,
		in:   ".~*ＶＢｚ␌ \x05｀v：␙␙｀lδｏυε\x19υ␡ξ\x1e，KP~β",
		out:  "．~*ＶＢｚ␌ \x05｀v：␙␙｀lδｏυε\x19υ␡ξ\x1e，KP~β",
	}, { // 973
		mask: EncodePipe | EncodeLeftPeriod | EncodeLeftTilde,
		in:   "．~*ＶＢｚ␌ \x05｀v：␙␙｀lδｏυε\x19υ␡ξ\x1e，KP~β",
		out:  "‛．~*ＶＢｚ␌ \x05｀v：␙␙｀lδｏυε\x19υ␡ξ\x1e，KP~β",
	}, { // 974
		mask: EncodePipe | EncodeLeftPeriod | EncodeLeftTilde,
		in:   "'~*ＶＢｚ␌ \x05｀v：␙␙｀lδｏυε\x19υ␡ξ\x1e，KP~.",
		out:  "'~*ＶＢｚ␌ \x05｀v：␙␙｀lδｏυε\x19υ␡ξ\x1e，KP~.",
	}, { // 975
		mask: EncodePipe | EncodeLeftPeriod | EncodeLeftTilde,
		in:   "'~*ＶＢｚ␌ \x05｀v：␙␙｀lδｏυε\x19υ␡ξ\x1e，KP~．",
		out:  "'~*ＶＢｚ␌ \x05｀v：␙␙｀lδｏυε\x19υ␡ξ\x1e，KP~．",
	}, { // 976
		mask: EncodeHash | EncodeLeftPeriod | EncodeLeftTilde,
		in:   ".~␆ι＿:␜\x1b\x18␏ｕχ␏τ＊Ｂｆwa\x10\x04\\␊]rρψ\v~\x1d",
		out:  "．~␆ι＿:␜\x1b\x18␏ｕχ␏τ＊Ｂｆwa\x10\x04\\␊]rρψ\v~\x1d",
	}, { // 977
		mask: EncodeHash | EncodeLeftPeriod | EncodeLeftTilde,
		in:   "．~␆ι＿:␜\x1b\x18␏ｕχ␏τ＊Ｂｆwa\x10\x04\\␊]rρψ\v~\x1d",
		out:  "‛．~␆ι＿:␜\x1b\x18␏ｕχ␏τ＊Ｂｆwa\x10\x04\\␊]rρψ\v~\x1d",
	}, { // 978
		mask: EncodeHash | EncodeLeftPeriod | EncodeLeftTilde,
		in:   "σ~␆ι＿:␜\x1b\x18␏ｕχ␏τ＊Ｂｆwa\x10\x04\\␊]rρψ\v~.",
		out:  "σ~␆ι＿:␜\x1b\x18␏ｕχ␏τ＊Ｂｆwa\x10\x04\\␊]rρψ\v~.",
	}, { // 979
		mask: EncodeHash | EncodeLeftPeriod | EncodeLeftTilde,
		in:   "σ~␆ι＿:␜\x1b\x18␏ｕχ␏τ＊Ｂｆwa\x10\x04\\␊]rρψ\v~．",
		out:  "σ~␆ι＿:␜\x1b\x18␏ｕχ␏τ＊Ｂｆwa\x10\x04\\␊]rρψ\v~．",
	}, { // 980
		mask: EncodePercent | EncodeLeftPeriod | EncodeLeftTilde,
		in:   ".~$\aδξ０|σ␛ＭIι\x05\x1b？␃＠␐Z␡ｖ#␊%Ｃ␋\t~K",
		out:  "．~$\aδξ０|σ␛ＭIι\x05\x1b？␃＠␐Z␡ｖ#␊％Ｃ␋\t~K",
	}, { // 981
		mask: EncodePercent | EncodeLeftPeriod | EncodeLeftTilde,
		in:   "．~$\aδξ０|σ␛ＭIι\x05\x1b？␃＠␐Z␡ｖ#␊%Ｃ␋\t~K",
		out:  "‛．~$\aδξ０|σ␛ＭIι\x05\x1b？␃＠␐Z␡ｖ#␊％Ｃ␋\t~K",
	}, { // 982
		mask: EncodePercent | EncodeLeftPeriod | EncodeLeftTilde,
		in:   "θ~$\aδξ０|σ␛ＭIι\x05\x1b？␃＠␐Z␡ｖ#␊%Ｃ␋\t~.",
		out:  "θ~$\aδξ０|σ␛ＭIι\x05\x1b？␃＠␐Z␡ｖ#␊％Ｃ␋\t~.",
	}, { // 983
		mask: EncodePercent | EncodeLeftPeriod | EncodeLeftTilde,
		in:   "θ~$\aδξ０|σ␛ＭIι\x05\x1b？␃＠␐Z␡ｖ#␊%Ｃ␋\t~．",
		out:  "θ~$\aδξ０|σ␛ＭIι\x05\x1b？␃＠␐Z␡ｖ#␊％Ｃ␋\t~．",
	}, { // 984
		mask: EncodeBackSlash | EncodeLeftPeriod | EncodeLeftTilde,
		in:   ".~zε４#\x13υξ␚λ␆#i４␒Ｗa␌Mμ｀ｒτ＞Ｊ\b:~]",
		out:  "．~zε４#\x13υξ␚λ␆#i４␒Ｗa␌Mμ｀ｒτ＞Ｊ\b:~]",
	}, { // 985
		mask: EncodeBackSlash | EncodeLeftPeriod | EncodeLeftTilde,
		in:   "．~zε４#\x13υξ␚λ␆#i４␒Ｗa␌Mμ｀ｒτ＞Ｊ\b:~]",
		out:  "‛．~zε４#\x13υξ␚λ␆#i４␒Ｗa␌Mμ｀ｒτ＞Ｊ\b:~]",
	}, { // 986
		mask: EncodeBackSlash | EncodeLeftPeriod | EncodeLeftTilde,
		in:   "％~zε４#\x13υξ␚λ␆#i４␒Ｗa␌Mμ｀ｒτ＞Ｊ\b:~.",
		out:  "％~zε４#\x13υξ␚λ␆#i４␒Ｗa␌Mμ｀ｒτ＞Ｊ\b:~.",
	}, { // 987
		mask: EncodeBackSlash | EncodeLeftPeriod | EncodeLeftTilde,
		in:   "％~zε４#\x13υξ␚λ␆#i４␒Ｗa␌Mμ｀ｒτ＞Ｊ\b:~．",
		out:  "％~zε４#\x13υξ␚λ␆#i４␒Ｗa␌Mμ｀ｒτ＞Ｊ\b:~．",
	}, { // 988
		mask: EncodeCrLf | EncodeLeftPeriod | EncodeLeftTilde,
		in:   ".~（:α@Ｅ␈νε\x1dζ９\x1cς␍}␗f␕\x02\b2＊␚':Ｂ~＆",
		out:  "．~（:α@Ｅ␈νε\x1dζ９\x1cς‛␍}␗f␕\x02\b2＊␚':Ｂ~＆",
	}, { // 989
		mask: EncodeCrLf | EncodeLeftPeriod | EncodeLeftTilde,
		in:   "．~（:α@Ｅ␈νε\x1dζ９\x1cς␍}␗f␕\x02\b2＊␚':Ｂ~＆",
		out:  "‛．~（:α@Ｅ␈νε\x1dζ９\x1cς‛␍}␗f␕\x02\b2＊␚':Ｂ~＆",
	}, { // 990
		mask: EncodeCrLf | EncodeLeftPeriod | EncodeLeftTilde,
		in:   "i~（:α@Ｅ␈νε\x1dζ９\x1cς␍}␗f␕\x02\b2＊␚':Ｂ~.",
		out:  "i~（:α@Ｅ␈νε\x1dζ９\x1cς‛␍}␗f␕\x02\b2＊␚':Ｂ~.",
	}, { // 991
		mask: EncodeCrLf | EncodeLeftPeriod | EncodeLeftTilde,
		in:   "i~（:α@Ｅ␈νε\x1dζ９\x1cς␍}␗f␕\x02\b2＊␚':Ｂ~．",
		out:  "i~（:α@Ｅ␈νε\x1dζ９\x1cς‛␍}␗f␕\x02\b2＊␚':Ｂ~．",
	}, { // 992
		mask: EncodeDel | EncodeLeftPeriod | EncodeLeftTilde,
		in:   ".~μＨ＼φ$＂＊␓\x18σfβ␋␌｜Ｖ@|␀=πＨ\x0e%>*~C",
		out:  "．~μＨ＼φ$＂＊␓\x18σfβ␋␌｜Ｖ@|‛␀=πＨ\x0e%>*~C",
	}, { // 993
		mask: EncodeDel | EncodeLeftPeriod | EncodeLeftTilde,
		in:   "．~μＨ＼φ$＂＊␓\x18σfβ␋␌｜Ｖ@|␀=πＨ\x0e%>*~C",
		out:  "‛．~μＨ＼φ$＂＊␓\x18σfβ␋␌｜Ｖ@|‛␀=πＨ\x0e%>*~C",
	}, { // 994
		mask: EncodeDel | EncodeLeftPeriod | EncodeLeftTilde,
		in:   "\uff00~μＨ＼φ$＂＊␓\x18σfβ␋␌｜Ｖ@|␀=πＨ\x0e%>*~.",
		out:  "\uff00~μＨ＼φ$＂＊␓\x18σfβ␋␌｜Ｖ@|‛␀=πＨ\x0e%>*~.",
	}, { // 995
		mask: EncodeDel | EncodeLeftPeriod | EncodeLeftTilde,
		in:   "\uff00~μＨ＼φ$＂＊␓\x18σfβ␋␌｜Ｖ@|␀=πＨ\x0e%>*~．",
		out:  "\uff00~μＨ＼φ$＂＊␓\x18σfβ␋␌｜Ｖ@|‛␀=πＨ\x0e%>*~．",
	}, { // 996
		mask: EncodeCtl | EncodeLeftPeriod | EncodeLeftTilde,
		in:   ".~＄χα＼Ｌι\x06O］␇r\x15#8/ζα＜ｘ\u007f＝τ3>＄＇~Ｈ",
		out:  "．~＄χα＼Ｌι␆O］‛␇r␕#8/ζα＜ｘ\u007f＝τ3>＄＇~Ｈ",
	}, { // 997
		mask: EncodeCtl | EncodeLeftPeriod | EncodeLeftTilde,
		in:   "．~＄χα＼Ｌι\x06O］␇r\x15#8/ζα＜ｘ\u007f＝τ3>＄＇~Ｈ",
		out:  "‛．~＄χα＼Ｌι␆O］‛␇r␕#8/ζα＜ｘ\u007f＝τ3>＄＇~Ｈ",
	}, { // 998
		mask: EncodeCtl | EncodeLeftPeriod | EncodeLeftTilde,
		in:   "M~＄χα＼Ｌι\x06O］␇r\x15#8/ζα＜ｘ\u007f＝τ3>＄＇~.",
		out:  "M~＄χα＼Ｌι␆O］‛␇r␕#8/ζα＜ｘ\u007f＝τ3>＄＇~.",
	}, { // 999
		mask: EncodeCtl | EncodeLeftPeriod | EncodeLeftTilde,
		in:   "M~＄χα＼Ｌι\x06O］␇r\x15#8/ζα＜ｘ\u007f＝τ3>＄＇~．",
		out:  "M~＄χα＼Ｌι␆O］‛␇r␕#8/ζα＜ｘ\u007f＝τ3>＄＇~．",
	}, { // 1000
		mask: EncodeZero | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   ".\t？τλX；`＃␂|ο［\bIe\x1b６\x0eＭ␒｀＄λαY\x17α\tＢ",
		out:  "．\t？τλX；`＃␂|ο［\bIe\x1b６\x0eＭ␒｀＄λαY\x17α\tＢ",
	}, { // 1001
		mask: EncodeZero | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "．\t？τλX；`＃␂|ο［\bIe\x1b６\x0eＭ␒｀＄λαY\x17α\tＢ",
		out:  "‛．\t？τλX；`＃␂|ο［\bIe\x1b６\x0eＭ␒｀＄λαY\x17α\tＢ",
	}, { // 1002
		mask: EncodeZero | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   ".\n？τλX；`＃␂|ο［\bIe\x1b６\x0eＭ␒｀＄λαY\x17α\nＢ",
		out:  "．\n？τλX；`＃␂|ο［\bIe\x1b６\x0eＭ␒｀＄λαY\x17α\nＢ",
	}, { // 1003
		mask: EncodeZero | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "．\n？τλX；`＃␂|ο［\bIe\x1b６\x0eＭ␒｀＄λαY\x17α\nＢ",
		out:  "‛．\n？τλX；`＃␂|ο［\bIe\x1b６\x0eＭ␒｀＄λαY\x17α\nＢ",
	}, { // 1004
		mask: EncodeZero | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   ".\v？τλX；`＃␂|ο［\bIe\x1b６\x0eＭ␒｀＄λαY\x17α\vＢ",
		out:  "．\v？τλX；`＃␂|ο［\bIe\x1b６\x0eＭ␒｀＄λαY\x17α\vＢ",
	}, { // 1005
		mask: EncodeZero | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "．\v？τλX；`＃␂|ο［\bIe\x1b６\x0eＭ␒｀＄λαY\x17α\vＢ",
		out:  "‛．\v？τλX；`＃␂|ο［\bIe\x1b６\x0eＭ␒｀＄λαY\x17α\vＢ",
	}, { // 1006
		mask: EncodeZero | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   ".\r？τλX；`＃␂|ο［\bIe\x1b６\x0eＭ␒｀＄λαY\x17α\rＢ",
		out:  "．\r？τλX；`＃␂|ο［\bIe\x1b６\x0eＭ␒｀＄λαY\x17α\rＢ",
	}, { // 1007
		mask: EncodeZero | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "．\r？τλX；`＃␂|ο［\bIe\x1b６\x0eＭ␒｀＄λαY\x17α\rＢ",
		out:  "‛．\r？τλX；`＃␂|ο［\bIe\x1b６\x0eＭ␒｀＄λαY\x17α\rＢ",
	}, { // 1008
		mask: EncodeZero | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "`\t？τλX；`＃␂|ο［\bIe\x1b６\x0eＭ␒｀＄λαY\x17α\t.",
		out:  "`\t？τλX；`＃␂|ο［\bIe\x1b６\x0eＭ␒｀＄λαY\x17α\t.",
	}, { // 1009
		mask: EncodeZero | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "`\t？τλX；`＃␂|ο［\bIe\x1b６\x0eＭ␒｀＄λαY\x17α\t．",
		out:  "`\t？τλX；`＃␂|ο［\bIe\x1b６\x0eＭ␒｀＄λαY\x17α\t．",
	}, { // 1010
		mask: EncodeZero | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "`\n？τλX；`＃␂|ο［\bIe\x1b６\x0eＭ␒｀＄λαY\x17α\n.",
		out:  "`\n？τλX；`＃␂|ο［\bIe\x1b６\x0eＭ␒｀＄λαY\x17α\n.",
	}, { // 1011
		mask: EncodeZero | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "`\n？τλX；`＃␂|ο［\bIe\x1b６\x0eＭ␒｀＄λαY\x17α\n．",
		out:  "`\n？τλX；`＃␂|ο［\bIe\x1b６\x0eＭ␒｀＄λαY\x17α\n．",
	}, { // 1012
		mask: EncodeZero | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "`\v？τλX；`＃␂|ο［\bIe\x1b６\x0eＭ␒｀＄λαY\x17α\v.",
		out:  "`\v？τλX；`＃␂|ο［\bIe\x1b６\x0eＭ␒｀＄λαY\x17α\v.",
	}, { // 1013
		mask: EncodeZero | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "`\v？τλX；`＃␂|ο［\bIe\x1b６\x0eＭ␒｀＄λαY\x17α\v．",
		out:  "`\v？τλX；`＃␂|ο［\bIe\x1b６\x0eＭ␒｀＄λαY\x17α\v．",
	}, { // 1014
		mask: EncodeZero | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "`\r？τλX；`＃␂|ο［\bIe\x1b６\x0eＭ␒｀＄λαY\x17α\r.",
		out:  "`\r？τλX；`＃␂|ο［\bIe\x1b６\x0eＭ␒｀＄λαY\x17α\r.",
	}, { // 1015
		mask: EncodeZero | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "`\r？τλX；`＃␂|ο［\bIe\x1b６\x0eＭ␒｀＄λαY\x17α\r．",
		out:  "`\r？τλX；`＃␂|ο［\bIe\x1b６\x0eＭ␒｀＄λαY\x17α\r．",
	}, { // 1016
		mask: EncodeSlash | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   ".\t＄\\δｘTＦ＄κ／ε：ｉ\aδξ`ρ\nｒ␘Ｖd\x06？\x04＇\tW",
		out:  "．\t＄\\δｘTＦ＄κ‛／ε：ｉ\aδξ`ρ\nｒ␘Ｖd\x06？\x04＇\tW",
	}, { // 1017
		mask: EncodeSlash | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "．\t＄\\δｘTＦ＄κ／ε：ｉ\aδξ`ρ\nｒ␘Ｖd\x06？\x04＇\tW",
		out:  "‛．\t＄\\δｘTＦ＄κ‛／ε：ｉ\aδξ`ρ\nｒ␘Ｖd\x06？\x04＇\tW",
	}, { // 1018
		mask: EncodeSlash | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   ".\n＄\\δｘTＦ＄κ／ε：ｉ\aδξ`ρ\nｒ␘Ｖd\x06？\x04＇\nW",
		out:  "．\n＄\\δｘTＦ＄κ‛／ε：ｉ\aδξ`ρ\nｒ␘Ｖd\x06？\x04＇\nW",
	}, { // 1019
		mask: EncodeSlash | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "．\n＄\\δｘTＦ＄κ／ε：ｉ\aδξ`ρ\nｒ␘Ｖd\x06？\x04＇\nW",
		out:  "‛．\n＄\\δｘTＦ＄κ‛／ε：ｉ\aδξ`ρ\nｒ␘Ｖd\x06？\x04＇\nW",
	}, { // 1020
		mask: EncodeSlash | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   ".\v＄\\δｘTＦ＄κ／ε：ｉ\aδξ`ρ\nｒ␘Ｖd\x06？\x04＇\vW",
		out:  "．\v＄\\δｘTＦ＄κ‛／ε：ｉ\aδξ`ρ\nｒ␘Ｖd\x06？\x04＇\vW",
	}, { // 1021
		mask: EncodeSlash | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "．\v＄\\δｘTＦ＄κ／ε：ｉ\aδξ`ρ\nｒ␘Ｖd\x06？\x04＇\vW",
		out:  "‛．\v＄\\δｘTＦ＄κ‛／ε：ｉ\aδξ`ρ\nｒ␘Ｖd\x06？\x04＇\vW",
	}, { // 1022
		mask: EncodeSlash | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   ".\r＄\\δｘTＦ＄κ／ε：ｉ\aδξ`ρ\nｒ␘Ｖd\x06？\x04＇\rW",
		out:  "．\r＄\\δｘTＦ＄κ‛／ε：ｉ\aδξ`ρ\nｒ␘Ｖd\x06？\x04＇\rW",
	}, { // 1023
		mask: EncodeSlash | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "．\r＄\\δｘTＦ＄κ／ε：ｉ\aδξ`ρ\nｒ␘Ｖd\x06？\x04＇\rW",
		out:  "‛．\r＄\\δｘTＦ＄κ‛／ε：ｉ\aδξ`ρ\nｒ␘Ｖd\x06？\x04＇\rW",
	}, { // 1024
		mask: EncodeSlash | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "y\t＄\\δｘTＦ＄κ／ε：ｉ\aδξ`ρ\nｒ␘Ｖd\x06？\x04＇\t.",
		out:  "y\t＄\\δｘTＦ＄κ‛／ε：ｉ\aδξ`ρ\nｒ␘Ｖd\x06？\x04＇\t.",
	}, { // 1025
		mask: EncodeSlash | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "y\t＄\\δｘTＦ＄κ／ε：ｉ\aδξ`ρ\nｒ␘Ｖd\x06？\x04＇\t．",
		out:  "y\t＄\\δｘTＦ＄κ‛／ε：ｉ\aδξ`ρ\nｒ␘Ｖd\x06？\x04＇\t．",
	}, { // 1026
		mask: EncodeSlash | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "y\n＄\\δｘTＦ＄κ／ε：ｉ\aδξ`ρ\nｒ␘Ｖd\x06？\x04＇\n.",
		out:  "y\n＄\\δｘTＦ＄κ‛／ε：ｉ\aδξ`ρ\nｒ␘Ｖd\x06？\x04＇\n.",
	}, { // 1027
		mask: EncodeSlash | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "y\n＄\\δｘTＦ＄κ／ε：ｉ\aδξ`ρ\nｒ␘Ｖd\x06？\x04＇\n．",
		out:  "y\n＄\\δｘTＦ＄κ‛／ε：ｉ\aδξ`ρ\nｒ␘Ｖd\x06？\x04＇\n．",
	}, { // 1028
		mask: EncodeSlash | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "y\v＄\\δｘTＦ＄κ／ε：ｉ\aδξ`ρ\nｒ␘Ｖd\x06？\x04＇\v.",
		out:  "y\v＄\\δｘTＦ＄κ‛／ε：ｉ\aδξ`ρ\nｒ␘Ｖd\x06？\x04＇\v.",
	}, { // 1029
		mask: EncodeSlash | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "y\v＄\\δｘTＦ＄κ／ε：ｉ\aδξ`ρ\nｒ␘Ｖd\x06？\x04＇\v．",
		out:  "y\v＄\\δｘTＦ＄κ‛／ε：ｉ\aδξ`ρ\nｒ␘Ｖd\x06？\x04＇\v．",
	}, { // 1030
		mask: EncodeSlash | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "y\r＄\\δｘTＦ＄κ／ε：ｉ\aδξ`ρ\nｒ␘Ｖd\x06？\x04＇\r.",
		out:  "y\r＄\\δｘTＦ＄κ‛／ε：ｉ\aδξ`ρ\nｒ␘Ｖd\x06？\x04＇\r.",
	}, { // 1031
		mask: EncodeSlash | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "y\r＄\\δｘTＦ＄κ／ε：ｉ\aδξ`ρ\nｒ␘Ｖd\x06？\x04＇\r．",
		out:  "y\r＄\\δｘTＦ＄κ‛／ε：ｉ\aδξ`ρ\nｒ␘Ｖd\x06？\x04＇\r．",
	}, { // 1032
		mask: EncodeSingleQuote | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   ".\tｙ␒&i\x11\x14␑ηｘ\x19␖XχＶY␀＂\x01␡\\θλ␕XθＲ\t;",
		out:  "．\tｙ␒&i\x11\x14␑ηｘ\x19␖XχＶY‛␀＂\x01␡\\θλ␕XθＲ\t;",
	}, { // 1033
		mask: EncodeSingleQuote | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "．\tｙ␒&i\x11\x14␑ηｘ\x19␖XχＶY␀＂\x01␡\\θλ␕XθＲ\t;",
		out:  "‛．\tｙ␒&i\x11\x14␑ηｘ\x19␖XχＶY‛␀＂\x01␡\\θλ␕XθＲ\t;",
	}, { // 1034
		mask: EncodeSingleQuote | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   ".\nｙ␒&i\x11\x14␑ηｘ\x19␖XχＶY␀＂\x01␡\\θλ␕XθＲ\n;",
		out:  "．\nｙ␒&i\x11\x14␑ηｘ\x19␖XχＶY‛␀＂\x01␡\\θλ␕XθＲ\n;",
	}, { // 1035
		mask: EncodeSingleQuote | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "．\nｙ␒&i\x11\x14␑ηｘ\x19␖XχＶY␀＂\x01␡\\θλ␕XθＲ\n;",
		out:  "‛．\nｙ␒&i\x11\x14␑ηｘ\x19␖XχＶY‛␀＂\x01␡\\θλ␕XθＲ\n;",
	}, { // 1036
		mask: EncodeSingleQuote | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   ".\vｙ␒&i\x11\x14␑ηｘ\x19␖XχＶY␀＂\x01␡\\θλ␕XθＲ\v;",
		out:  "．\vｙ␒&i\x11\x14␑ηｘ\x19␖XχＶY‛␀＂\x01␡\\θλ␕XθＲ\v;",
	}, { // 1037
		mask: EncodeSingleQuote | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "．\vｙ␒&i\x11\x14␑ηｘ\x19␖XχＶY␀＂\x01␡\\θλ␕XθＲ\v;",
		out:  "‛．\vｙ␒&i\x11\x14␑ηｘ\x19␖XχＶY‛␀＂\x01␡\\θλ␕XθＲ\v;",
	}, { // 1038
		mask: EncodeSingleQuote | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   ".\rｙ␒&i\x11\x14␑ηｘ\x19␖XχＶY␀＂\x01␡\\θλ␕XθＲ\r;",
		out:  "．\rｙ␒&i\x11\x14␑ηｘ\x19␖XχＶY‛␀＂\x01␡\\θλ␕XθＲ\r;",
	}, { // 1039
		mask: EncodeSingleQuote | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "．\rｙ␒&i\x11\x14␑ηｘ\x19␖XχＶY␀＂\x01␡\\θλ␕XθＲ\r;",
		out:  "‛．\rｙ␒&i\x11\x14␑ηｘ\x19␖XχＶY‛␀＂\x01␡\\θλ␕XθＲ\r;",
	}, { // 1040
		mask: EncodeSingleQuote | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "ο\tｙ␒&i\x11\x14␑ηｘ\x19␖XχＶY␀＂\x01␡\\θλ␕XθＲ\t.",
		out:  "ο\tｙ␒&i\x11\x14␑ηｘ\x19␖XχＶY‛␀＂\x01␡\\θλ␕XθＲ\t.",
	}, { // 1041
		mask: EncodeSingleQuote | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "ο\tｙ␒&i\x11\x14␑ηｘ\x19␖XχＶY␀＂\x01␡\\θλ␕XθＲ\t．",
		out:  "ο\tｙ␒&i\x11\x14␑ηｘ\x19␖XχＶY‛␀＂\x01␡\\θλ␕XθＲ\t．",
	}, { // 1042
		mask: EncodeSingleQuote | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "ο\nｙ␒&i\x11\x14␑ηｘ\x19␖XχＶY␀＂\x01␡\\θλ␕XθＲ\n.",
		out:  "ο\nｙ␒&i\x11\x14␑ηｘ\x19␖XχＶY‛␀＂\x01␡\\θλ␕XθＲ\n.",
	}, { // 1043
		mask: EncodeSingleQuote | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "ο\nｙ␒&i\x11\x14␑ηｘ\x19␖XχＶY␀＂\x01␡\\θλ␕XθＲ\n．",
		out:  "ο\nｙ␒&i\x11\x14␑ηｘ\x19␖XχＶY‛␀＂\x01␡\\θλ␕XθＲ\n．",
	}, { // 1044
		mask: EncodeSingleQuote | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "ο\vｙ␒&i\x11\x14␑ηｘ\x19␖XχＶY␀＂\x01␡\\θλ␕XθＲ\v.",
		out:  "ο\vｙ␒&i\x11\x14␑ηｘ\x19␖XχＶY‛␀＂\x01␡\\θλ␕XθＲ\v.",
	}, { // 1045
		mask: EncodeSingleQuote | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "ο\vｙ␒&i\x11\x14␑ηｘ\x19␖XχＶY␀＂\x01␡\\θλ␕XθＲ\v．",
		out:  "ο\vｙ␒&i\x11\x14␑ηｘ\x19␖XχＶY‛␀＂\x01␡\\θλ␕XθＲ\v．",
	}, { // 1046
		mask: EncodeSingleQuote | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "ο\rｙ␒&i\x11\x14␑ηｘ\x19␖XχＶY␀＂\x01␡\\θλ␕XθＲ\r.",
		out:  "ο\rｙ␒&i\x11\x14␑ηｘ\x19␖XχＶY‛␀＂\x01␡\\θλ␕XθＲ\r.",
	}, { // 1047
		mask: EncodeSingleQuote | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "ο\rｙ␒&i\x11\x14␑ηｘ\x19␖XχＶY␀＂\x01␡\\θλ␕XθＲ\r．",
		out:  "ο\rｙ␒&i\x11\x14␑ηｘ\x19␖XχＶY‛␀＂\x01␡\\θλ␕XθＲ\r．",
	}, { // 1048
		mask: EncodeBackQuote | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   ".\tｄ１Ｕ␡␉]3#␋χ:φTζ\x12φ？＆␇jU＠\"υαｉ\t＼",
		out:  "．\tｄ１Ｕ␡␉]3#␋χ:φTζ\x12φ？＆␇jU＠\"υαｉ\t＼",
	}, { // 1049
		mask: EncodeBackQuote | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "．\tｄ１Ｕ␡␉]3#␋χ:φTζ\x12φ？＆␇jU＠\"υαｉ\t＼",
		out:  "‛．\tｄ１Ｕ␡␉]3#␋χ:φTζ\x12φ？＆␇jU＠\"υαｉ\t＼",
	}, { // 1050
		mask: EncodeBackQuote | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   ".\nｄ１Ｕ␡␉]3#␋χ:φTζ\x12φ？＆␇jU＠\"υαｉ\n＼",
		out:  "．\nｄ１Ｕ␡␉]3#␋χ:φTζ\x12φ？＆␇jU＠\"υαｉ\n＼",
	}, { // 1051
		mask: EncodeBackQuote | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "．\nｄ１Ｕ␡␉]3#␋χ:φTζ\x12φ？＆␇jU＠\"υαｉ\n＼",
		out:  "‛．\nｄ１Ｕ␡␉]3#␋χ:φTζ\x12φ？＆␇jU＠\"υαｉ\n＼",
	}, { // 1052
		mask: EncodeBackQuote | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   ".\vｄ１Ｕ␡␉]3#␋χ:φTζ\x12φ？＆␇jU＠\"υαｉ\v＼",
		out:  "．\vｄ１Ｕ␡␉]3#␋χ:φTζ\x12φ？＆␇jU＠\"υαｉ\v＼",
	}, { // 1053
		mask: EncodeBackQuote | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "．\vｄ１Ｕ␡␉]3#␋χ:φTζ\x12φ？＆␇jU＠\"υαｉ\v＼",
		out:  "‛．\vｄ１Ｕ␡␉]3#␋χ:φTζ\x12φ？＆␇jU＠\"υαｉ\v＼",
	}, { // 1054
		mask: EncodeBackQuote | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   ".\rｄ１Ｕ␡␉]3#␋χ:φTζ\x12φ？＆␇jU＠\"υαｉ\r＼",
		out:  "．\rｄ１Ｕ␡␉]3#␋χ:φTζ\x12φ？＆␇jU＠\"υαｉ\r＼",
	}, { // 1055
		mask: EncodeBackQuote | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "．\rｄ１Ｕ␡␉]3#␋χ:φTζ\x12φ？＆␇jU＠\"υαｉ\r＼",
		out:  "‛．\rｄ１Ｕ␡␉]3#␋χ:φTζ\x12φ？＆␇jU＠\"υαｉ\r＼",
	}, { // 1056
		mask: EncodeBackQuote | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "\x06\tｄ１Ｕ␡␉]3#␋χ:φTζ\x12φ？＆␇jU＠\"υαｉ\t.",
		out:  "\x06\tｄ１Ｕ␡␉]3#␋χ:φTζ\x12φ？＆␇jU＠\"υαｉ\t.",
	}, { // 1057
		mask: EncodeBackQuote | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "\x06\tｄ１Ｕ␡␉]3#␋χ:φTζ\x12φ？＆␇jU＠\"υαｉ\t．",
		out:  "\x06\tｄ１Ｕ␡␉]3#␋χ:φTζ\x12φ？＆␇jU＠\"υαｉ\t．",
	}, { // 1058
		mask: EncodeBackQuote | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "\x06\nｄ１Ｕ␡␉]3#␋χ:φTζ\x12φ？＆␇jU＠\"υαｉ\n.",
		out:  "\x06\nｄ１Ｕ␡␉]3#␋χ:φTζ\x12φ？＆␇jU＠\"υαｉ\n.",
	}, { // 1059
		mask: EncodeBackQuote | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "\x06\nｄ１Ｕ␡␉]3#␋χ:φTζ\x12φ？＆␇jU＠\"υαｉ\n．",
		out:  "\x06\nｄ１Ｕ␡␉]3#␋χ:φTζ\x12φ？＆␇jU＠\"υαｉ\n．",
	}, { // 1060
		mask: EncodeBackQuote | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "\x06\vｄ１Ｕ␡␉]3#␋χ:φTζ\x12φ？＆␇jU＠\"υαｉ\v.",
		out:  "\x06\vｄ１Ｕ␡␉]3#␋χ:φTζ\x12φ？＆␇jU＠\"υαｉ\v.",
	}, { // 1061
		mask: EncodeBackQuote | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "\x06\vｄ１Ｕ␡␉]3#␋χ:φTζ\x12φ？＆␇jU＠\"υαｉ\v．",
		out:  "\x06\vｄ１Ｕ␡␉]3#␋χ:φTζ\x12φ？＆␇jU＠\"υαｉ\v．",
	}, { // 1062
		mask: EncodeBackQuote | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "\x06\rｄ１Ｕ␡␉]3#␋χ:φTζ\x12φ？＆␇jU＠\"υαｉ\r.",
		out:  "\x06\rｄ１Ｕ␡␉]3#␋χ:φTζ\x12φ？＆␇jU＠\"υαｉ\r.",
	}, { // 1063
		mask: EncodeBackQuote | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "\x06\rｄ１Ｕ␡␉]3#␋χ:φTζ\x12φ？＆␇jU＠\"υαｉ\r．",
		out:  "\x06\rｄ１Ｕ␡␉]3#␋χ:φTζ\x12φ？＆␇jU＠\"υαｉ\r．",
	}, { // 1064
		mask: EncodeLtGt | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   ".\t>Lρ＃lγ＝ｎ:␂\x1b｝wｋ\fOδ␚TαＱ␓＜\x17θX\tβ",
		out:  "．\t＞Lρ＃lγ＝ｎ:␂\x1b｝wｋ\fOδ␚TαＱ␓‛＜\x17θX\tβ",
	}, { // 1065
		mask: EncodeLtGt | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "．\t>Lρ＃lγ＝ｎ:␂\x1b｝wｋ\fOδ␚TαＱ␓＜\x17θX\tβ",
		out:  "‛．\t＞Lρ＃lγ＝ｎ:␂\x1b｝wｋ\fOδ␚TαＱ␓‛＜\x17θX\tβ",
	}, { // 1066
		mask: EncodeLtGt | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   ".\n>Lρ＃lγ＝ｎ:␂\x1b｝wｋ\fOδ␚TαＱ␓＜\x17θX\nβ",
		out:  "．\n＞Lρ＃lγ＝ｎ:␂\x1b｝wｋ\fOδ␚TαＱ␓‛＜\x17θX\nβ",
	}, { // 1067
		mask: EncodeLtGt | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "．\n>Lρ＃lγ＝ｎ:␂\x1b｝wｋ\fOδ␚TαＱ␓＜\x17θX\nβ",
		out:  "‛．\n＞Lρ＃lγ＝ｎ:␂\x1b｝wｋ\fOδ␚TαＱ␓‛＜\x17θX\nβ",
	}, { // 1068
		mask: EncodeLtGt | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   ".\v>Lρ＃lγ＝ｎ:␂\x1b｝wｋ\fOδ␚TαＱ␓＜\x17θX\vβ",
		out:  "．\v＞Lρ＃lγ＝ｎ:␂\x1b｝wｋ\fOδ␚TαＱ␓‛＜\x17θX\vβ",
	}, { // 1069
		mask: EncodeLtGt | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "．\v>Lρ＃lγ＝ｎ:␂\x1b｝wｋ\fOδ␚TαＱ␓＜\x17θX\vβ",
		out:  "‛．\v＞Lρ＃lγ＝ｎ:␂\x1b｝wｋ\fOδ␚TαＱ␓‛＜\x17θX\vβ",
	}, { // 1070
		mask: EncodeLtGt | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   ".\r>Lρ＃lγ＝ｎ:␂\x1b｝wｋ\fOδ␚TαＱ␓＜\x17θX\rβ",
		out:  "．\r＞Lρ＃lγ＝ｎ:␂\x1b｝wｋ\fOδ␚TαＱ␓‛＜\x17θX\rβ",
	}, { // 1071
		mask: EncodeLtGt | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "．\r>Lρ＃lγ＝ｎ:␂\x1b｝wｋ\fOδ␚TαＱ␓＜\x17θX\rβ",
		out:  "‛．\r＞Lρ＃lγ＝ｎ:␂\x1b｝wｋ\fOδ␚TαＱ␓‛＜\x17θX\rβ",
	}, { // 1072
		mask: EncodeLtGt | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "<\t>Lρ＃lγ＝ｎ:␂\x1b｝wｋ\fOδ␚TαＱ␓＜\x17θX\t.",
		out:  "＜\t＞Lρ＃lγ＝ｎ:␂\x1b｝wｋ\fOδ␚TαＱ␓‛＜\x17θX\t.",
	}, { // 1073
		mask: EncodeLtGt | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "<\t>Lρ＃lγ＝ｎ:␂\x1b｝wｋ\fOδ␚TαＱ␓＜\x17θX\t．",
		out:  "＜\t＞Lρ＃lγ＝ｎ:␂\x1b｝wｋ\fOδ␚TαＱ␓‛＜\x17θX\t．",
	}, { // 1074
		mask: EncodeLtGt | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "<\n>Lρ＃lγ＝ｎ:␂\x1b｝wｋ\fOδ␚TαＱ␓＜\x17θX\n.",
		out:  "＜\n＞Lρ＃lγ＝ｎ:␂\x1b｝wｋ\fOδ␚TαＱ␓‛＜\x17θX\n.",
	}, { // 1075
		mask: EncodeLtGt | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "<\n>Lρ＃lγ＝ｎ:␂\x1b｝wｋ\fOδ␚TαＱ␓＜\x17θX\n．",
		out:  "＜\n＞Lρ＃lγ＝ｎ:␂\x1b｝wｋ\fOδ␚TαＱ␓‛＜\x17θX\n．",
	}, { // 1076
		mask: EncodeLtGt | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "<\v>Lρ＃lγ＝ｎ:␂\x1b｝wｋ\fOδ␚TαＱ␓＜\x17θX\v.",
		out:  "＜\v＞Lρ＃lγ＝ｎ:␂\x1b｝wｋ\fOδ␚TαＱ␓‛＜\x17θX\v.",
	}, { // 1077
		mask: EncodeLtGt | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "<\v>Lρ＃lγ＝ｎ:␂\x1b｝wｋ\fOδ␚TαＱ␓＜\x17θX\v．",
		out:  "＜\v＞Lρ＃lγ＝ｎ:␂\x1b｝wｋ\fOδ␚TαＱ␓‛＜\x17θX\v．",
	}, { // 1078
		mask: EncodeLtGt | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "<\r>Lρ＃lγ＝ｎ:␂\x1b｝wｋ\fOδ␚TαＱ␓＜\x17θX\r.",
		out:  "＜\r＞Lρ＃lγ＝ｎ:␂\x1b｝wｋ\fOδ␚TαＱ␓‛＜\x17θX\r.",
	}, { // 1079
		mask: EncodeLtGt | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "<\r>Lρ＃lγ＝ｎ:␂\x1b｝wｋ\fOδ␚TαＱ␓＜\x17θX\r．",
		out:  "＜\r＞Lρ＃lγ＝ｎ:␂\x1b｝wｋ\fOδ␚TαＱ␓‛＜\x17θX\r．",
	}, { // 1080
		mask: EncodeSquareBracket | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   ".\t~δＲ;ιvω\x1f；\r３＞Ｓ␎7％\x16␃！ζ＼λο７'\"\t6",
		out:  "．\t~δＲ;ιvω\x1f；\r３＞Ｓ␎7％\x16␃！ζ＼λο７'\"\t6",
	}, { // 1081
		mask: EncodeSquareBracket | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "．\t~δＲ;ιvω\x1f；\r３＞Ｓ␎7％\x16␃！ζ＼λο７'\"\t6",
		out:  "‛．\t~δＲ;ιvω\x1f；\r３＞Ｓ␎7％\x16␃！ζ＼λο７'\"\t6",
	}, { // 1082
		mask: EncodeSquareBracket | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   ".\n~δＲ;ιvω\x1f；\r３＞Ｓ␎7％\x16␃！ζ＼λο７'\"\n6",
		out:  "．\n~δＲ;ιvω\x1f；\r３＞Ｓ␎7％\x16␃！ζ＼λο７'\"\n6",
	}, { // 1083
		mask: EncodeSquareBracket | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "．\n~δＲ;ιvω\x1f；\r３＞Ｓ␎7％\x16␃！ζ＼λο７'\"\n6",
		out:  "‛．\n~δＲ;ιvω\x1f；\r３＞Ｓ␎7％\x16␃！ζ＼λο７'\"\n6",
	}, { // 1084
		mask: EncodeSquareBracket | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   ".\v~δＲ;ιvω\x1f；\r３＞Ｓ␎7％\x16␃！ζ＼λο７'\"\v6",
		out:  "．\v~δＲ;ιvω\x1f；\r３＞Ｓ␎7％\x16␃！ζ＼λο７'\"\v6",
	}, { // 1085
		mask: EncodeSquareBracket | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "．\v~δＲ;ιvω\x1f；\r３＞Ｓ␎7％\x16␃！ζ＼λο７'\"\v6",
		out:  "‛．\v~δＲ;ιvω\x1f；\r３＞Ｓ␎7％\x16␃！ζ＼λο７'\"\v6",
	}, { // 1086
		mask: EncodeSquareBracket | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   ".\r~δＲ;ιvω\x1f；\r３＞Ｓ␎7％\x16␃！ζ＼λο７'\"\r6",
		out:  "．\r~δＲ;ιvω\x1f；\r３＞Ｓ␎7％\x16␃！ζ＼λο７'\"\r6",
	}, { // 1087
		mask: EncodeSquareBracket | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "．\r~δＲ;ιvω\x1f；\r３＞Ｓ␎7％\x16␃！ζ＼λο７'\"\r6",
		out:  "‛．\r~δＲ;ιvω\x1f；\r３＞Ｓ␎7％\x16␃！ζ＼λο７'\"\r6",
	}, { // 1088
		mask: EncodeSquareBracket | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "］\t~δＲ;ιvω\x1f；\r３＞Ｓ␎7％\x16␃！ζ＼λο７'\"\t.",
		out:  "‛］\t~δＲ;ιvω\x1f；\r３＞Ｓ␎7％\x16␃！ζ＼λο７'\"\t.",
	}, { // 1089
		mask: EncodeSquareBracket | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "］\t~δＲ;ιvω\x1f；\r３＞Ｓ␎7％\x16␃！ζ＼λο７'\"\t．",
		out:  "‛］\t~δＲ;ιvω\x1f；\r３＞Ｓ␎7％\x16␃！ζ＼λο７'\"\t．",
	}, { // 1090
		mask: EncodeSquareBracket | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "］\n~δＲ;ιvω\x1f；\r３＞Ｓ␎7％\x16␃！ζ＼λο７'\"\n.",
		out:  "‛］\n~δＲ;ιvω\x1f；\r３＞Ｓ␎7％\x16␃！ζ＼λο７'\"\n.",
	}, { // 1091
		mask: EncodeSquareBracket | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "］\n~δＲ;ιvω\x1f；\r３＞Ｓ␎7％\x16␃！ζ＼λο７'\"\n．",
		out:  "‛］\n~δＲ;ιvω\x1f；\r３＞Ｓ␎7％\x16␃！ζ＼λο７'\"\n．",
	}, { // 1092
		mask: EncodeSquareBracket | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "］\v~δＲ;ιvω\x1f；\r３＞Ｓ␎7％\x16␃！ζ＼λο７'\"\v.",
		out:  "‛］\v~δＲ;ιvω\x1f；\r３＞Ｓ␎7％\x16␃！ζ＼λο７'\"\v.",
	}, { // 1093
		mask: EncodeSquareBracket | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "］\v~δＲ;ιvω\x1f；\r３＞Ｓ␎7％\x16␃！ζ＼λο７'\"\v．",
		out:  "‛］\v~δＲ;ιvω\x1f；\r３＞Ｓ␎7％\x16␃！ζ＼λο７'\"\v．",
	}, { // 1094
		mask: EncodeSquareBracket | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "］\r~δＲ;ιvω\x1f；\r３＞Ｓ␎7％\x16␃！ζ＼λο７'\"\r.",
		out:  "‛］\r~δＲ;ιvω\x1f；\r３＞Ｓ␎7％\x16␃！ζ＼λο７'\"\r.",
	}, { // 1095
		mask: EncodeSquareBracket | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "］\r~δＲ;ιvω\x1f；\r３＞Ｓ␎7％\x16␃！ζ＼λο７'\"\r．",
		out:  "‛］\r~δＲ;ιvω\x1f；\r３＞Ｓ␎7％\x16␃！ζ＼λο７'\"\r．",
	}, { // 1096
		mask: EncodeSemicolon | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   ".\t;\x1f␚M-～␍␀εＯＺ*\r｜ε,αα［\v\x1f␛QＥν␋\t:",
		out:  "．\t；\x1f␚M-～␍‛␀εＯＺ*\r｜ε,αα［\v\x1f␛QＥν␋\t:",
	}, { // 1097
		mask: EncodeSemicolon | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "．\t;\x1f␚M-～␍␀εＯＺ*\r｜ε,αα［\v\x1f␛QＥν␋\t:",
		out:  "‛．\t；\x1f␚M-～␍‛␀εＯＺ*\r｜ε,αα［\v\x1f␛QＥν␋\t:",
	}, { // 1098
		mask: EncodeSemicolon | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   ".\n;\x1f␚M-～␍␀εＯＺ*\r｜ε,αα［\v\x1f␛QＥν␋\n:",
		out:  "．\n；\x1f␚M-～␍‛␀εＯＺ*\r｜ε,αα［\v\x1f␛QＥν␋\n:",
	}, { // 1099
		mask: EncodeSemicolon | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "．\n;\x1f␚M-～␍␀εＯＺ*\r｜ε,αα［\v\x1f␛QＥν␋\n:",
		out:  "‛．\n；\x1f␚M-～␍‛␀εＯＺ*\r｜ε,αα［\v\x1f␛QＥν␋\n:",
	}, { // 1100
		mask: EncodeSemicolon | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   ".\v;\x1f␚M-～␍␀εＯＺ*\r｜ε,αα［\v\x1f␛QＥν␋\v:",
		out:  "．\v；\x1f␚M-～␍‛␀εＯＺ*\r｜ε,αα［\v\x1f␛QＥν␋\v:",
	}, { // 1101
		mask: EncodeSemicolon | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "．\v;\x1f␚M-～␍␀εＯＺ*\r｜ε,αα［\v\x1f␛QＥν␋\v:",
		out:  "‛．\v；\x1f␚M-～␍‛␀εＯＺ*\r｜ε,αα［\v\x1f␛QＥν␋\v:",
	}, { // 1102
		mask: EncodeSemicolon | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   ".\r;\x1f␚M-～␍␀εＯＺ*\r｜ε,αα［\v\x1f␛QＥν␋\r:",
		out:  "．\r；\x1f␚M-～␍‛␀εＯＺ*\r｜ε,αα［\v\x1f␛QＥν␋\r:",
	}, { // 1103
		mask: EncodeSemicolon | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "．\r;\x1f␚M-～␍␀εＯＺ*\r｜ε,αα［\v\x1f␛QＥν␋\r:",
		out:  "‛．\r；\x1f␚M-～␍‛␀εＯＺ*\r｜ε,αα［\v\x1f␛QＥν␋\r:",
	}, { // 1104
		mask: EncodeSemicolon | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "␊\t;\x1f␚M-～␍␀εＯＺ*\r｜ε,αα［\v\x1f␛QＥν␋\t.",
		out:  "‛␊\t；\x1f␚M-～␍‛␀εＯＺ*\r｜ε,αα［\v\x1f␛QＥν␋\t.",
	}, { // 1105
		mask: EncodeSemicolon | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "␊\t;\x1f␚M-～␍␀εＯＺ*\r｜ε,αα［\v\x1f␛QＥν␋\t．",
		out:  "‛␊\t；\x1f␚M-～␍‛␀εＯＺ*\r｜ε,αα［\v\x1f␛QＥν␋\t．",
	}, { // 1106
		mask: EncodeSemicolon | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "␊\n;\x1f␚M-～␍␀εＯＺ*\r｜ε,αα［\v\x1f␛QＥν␋\n.",
		out:  "‛␊\n；\x1f␚M-～␍‛␀εＯＺ*\r｜ε,αα［\v\x1f␛QＥν␋\n.",
	}, { // 1107
		mask: EncodeSemicolon | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "␊\n;\x1f␚M-～␍␀εＯＺ*\r｜ε,αα［\v\x1f␛QＥν␋\n．",
		out:  "‛␊\n；\x1f␚M-～␍‛␀εＯＺ*\r｜ε,αα［\v\x1f␛QＥν␋\n．",
	}, { // 1108
		mask: EncodeSemicolon | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "␊\v;\x1f␚M-～␍␀εＯＺ*\r｜ε,αα［\v\x1f␛QＥν␋\v.",
		out:  "‛␊\v；\x1f␚M-～␍‛␀εＯＺ*\r｜ε,αα［\v\x1f␛QＥν␋\v.",
	}, { // 1109
		mask: EncodeSemicolon | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "␊\v;\x1f␚M-～␍␀εＯＺ*\r｜ε,αα［\v\x1f␛QＥν␋\v．",
		out:  "‛␊\v；\x1f␚M-～␍‛␀εＯＺ*\r｜ε,αα［\v\x1f␛QＥν␋\v．",
	}, { // 1110
		mask: EncodeSemicolon | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "␊\r;\x1f␚M-～␍␀εＯＺ*\r｜ε,αα［\v\x1f␛QＥν␋\r.",
		out:  "‛␊\r；\x1f␚M-～␍‛␀εＯＺ*\r｜ε,αα［\v\x1f␛QＥν␋\r.",
	}, { // 1111
		mask: EncodeSemicolon | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "␊\r;\x1f␚M-～␍␀εＯＺ*\r｜ε,αα［\v\x1f␛QＥν␋\r．",
		out:  "‛␊\r；\x1f␚M-～␍‛␀εＯＺ*\r｜ε,αα［\v\x1f␛QＥν␋\r．",
	}, { // 1112
		mask: EncodeDollar | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   ".\tχxｙ␈｛νO%n␈；\x13␅NＥ\x1bｕ$␍δε␓`Ｖ%β\t\x19",
		out:  "．\tχxｙ␈｛νO%n␈；\x13␅NＥ\x1bｕ＄␍δε␓`Ｖ%β\t\x19",
	}, { // 1113
		mask: EncodeDollar | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "．\tχxｙ␈｛νO%n␈；\x13␅NＥ\x1bｕ$␍δε␓`Ｖ%β\t\x19",
		out:  "‛．\tχxｙ␈｛νO%n␈；\x13␅NＥ\x1bｕ＄␍δε␓`Ｖ%β\t\x19",
	}, { // 1114
		mask: EncodeDollar | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   ".\nχxｙ␈｛νO%n␈；\x13␅NＥ\x1bｕ$␍δε␓`Ｖ%β\n\x19",
		out:  "．\nχxｙ␈｛νO%n␈；\x13␅NＥ\x1bｕ＄␍δε␓`Ｖ%β\n\x19",
	}, { // 1115
		mask: EncodeDollar | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "．\nχxｙ␈｛νO%n␈；\x13␅NＥ\x1bｕ$␍δε␓`Ｖ%β\n\x19",
		out:  "‛．\nχxｙ␈｛νO%n␈；\x13␅NＥ\x1bｕ＄␍δε␓`Ｖ%β\n\x19",
	}, { // 1116
		mask: EncodeDollar | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   ".\vχxｙ␈｛νO%n␈；\x13␅NＥ\x1bｕ$␍δε␓`Ｖ%β\v\x19",
		out:  "．\vχxｙ␈｛νO%n␈；\x13␅NＥ\x1bｕ＄␍δε␓`Ｖ%β\v\x19",
	}, { // 1117
		mask: EncodeDollar | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "．\vχxｙ␈｛νO%n␈；\x13␅NＥ\x1bｕ$␍δε␓`Ｖ%β\v\x19",
		out:  "‛．\vχxｙ␈｛νO%n␈；\x13␅NＥ\x1bｕ＄␍δε␓`Ｖ%β\v\x19",
	}, { // 1118
		mask: EncodeDollar | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   ".\rχxｙ␈｛νO%n␈；\x13␅NＥ\x1bｕ$␍δε␓`Ｖ%β\r\x19",
		out:  "．\rχxｙ␈｛νO%n␈；\x13␅NＥ\x1bｕ＄␍δε␓`Ｖ%β\r\x19",
	}, { // 1119
		mask: EncodeDollar | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "．\rχxｙ␈｛νO%n␈；\x13␅NＥ\x1bｕ$␍δε␓`Ｖ%β\r\x19",
		out:  "‛．\rχxｙ␈｛νO%n␈；\x13␅NＥ\x1bｕ＄␍δε␓`Ｖ%β\r\x19",
	}, { // 1120
		mask: EncodeDollar | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "ο\tχxｙ␈｛νO%n␈；\x13␅NＥ\x1bｕ$␍δε␓`Ｖ%β\t.",
		out:  "ο\tχxｙ␈｛νO%n␈；\x13␅NＥ\x1bｕ＄␍δε␓`Ｖ%β\t.",
	}, { // 1121
		mask: EncodeDollar | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "ο\tχxｙ␈｛νO%n␈；\x13␅NＥ\x1bｕ$␍δε␓`Ｖ%β\t．",
		out:  "ο\tχxｙ␈｛νO%n␈；\x13␅NＥ\x1bｕ＄␍δε␓`Ｖ%β\t．",
	}, { // 1122
		mask: EncodeDollar | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "ο\nχxｙ␈｛νO%n␈；\x13␅NＥ\x1bｕ$␍δε␓`Ｖ%β\n.",
		out:  "ο\nχxｙ␈｛νO%n␈；\x13␅NＥ\x1bｕ＄␍δε␓`Ｖ%β\n.",
	}, { // 1123
		mask: EncodeDollar | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "ο\nχxｙ␈｛νO%n␈；\x13␅NＥ\x1bｕ$␍δε␓`Ｖ%β\n．",
		out:  "ο\nχxｙ␈｛νO%n␈；\x13␅NＥ\x1bｕ＄␍δε␓`Ｖ%β\n．",
	}, { // 1124
		mask: EncodeDollar | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "ο\vχxｙ␈｛νO%n␈；\x13␅NＥ\x1bｕ$␍δε␓`Ｖ%β\v.",
		out:  "ο\vχxｙ␈｛νO%n␈；\x13␅NＥ\x1bｕ＄␍δε␓`Ｖ%β\v.",
	}, { // 1125
		mask: EncodeDollar | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "ο\vχxｙ␈｛νO%n␈；\x13␅NＥ\x1bｕ$␍δε␓`Ｖ%β\v．",
		out:  "ο\vχxｙ␈｛νO%n␈；\x13␅NＥ\x1bｕ＄␍δε␓`Ｖ%β\v．",
	}, { // 1126
		mask: EncodeDollar | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "ο\rχxｙ␈｛νO%n␈；\x13␅NＥ\x1bｕ$␍δε␓`Ｖ%β\r.",
		out:  "ο\rχxｙ␈｛νO%n␈；\x13␅NＥ\x1bｕ＄␍δε␓`Ｖ%β\r.",
	}, { // 1127
		mask: EncodeDollar | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "ο\rχxｙ␈｛νO%n␈；\x13␅NＥ\x1bｕ$␍δε␓`Ｖ%β\r．",
		out:  "ο\rχxｙ␈｛νO%n␈；\x13␅NＥ\x1bｕ＄␍δε␓`Ｖ%β\r．",
	}, { // 1128
		mask: EncodeDoubleQuote | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   ".\t\x0f％；κ+5η｜χ␚\x02SＹ|\v␛␓<／␉CG␚!ηβ\t\x1b",
		out:  "．\t\x0f％；κ+5η｜χ␚\x02SＹ|\v␛␓<／␉CG␚!ηβ\t\x1b",
	}, { // 1129
		mask: EncodeDoubleQuote | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "．\t\x0f％；κ+5η｜χ␚\x02SＹ|\v␛␓<／␉CG␚!ηβ\t\x1b",
		out:  "‛．\t\x0f％；κ+5η｜χ␚\x02SＹ|\v␛␓<／␉CG␚!ηβ\t\x1b",
	}, { // 1130
		mask: EncodeDoubleQuote | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   ".\n\x0f％；κ+5η｜χ␚\x02SＹ|\v␛␓<／␉CG␚!ηβ\n\x1b",
		out:  "．\n\x0f％；κ+5η｜χ␚\x02SＹ|\v␛␓<／␉CG␚!ηβ\n\x1b",
	}, { // 1131
		mask: EncodeDoubleQuote | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "．\n\x0f％；κ+5η｜χ␚\x02SＹ|\v␛␓<／␉CG␚!ηβ\n\x1b",
		out:  "‛．\n\x0f％；κ+5η｜χ␚\x02SＹ|\v␛␓<／␉CG␚!ηβ\n\x1b",
	}, { // 1132
		mask: EncodeDoubleQuote | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   ".\v\x0f％；κ+5η｜χ␚\x02SＹ|\v␛␓<／␉CG␚!ηβ\v\x1b",
		out:  "．\v\x0f％；κ+5η｜χ␚\x02SＹ|\v␛␓<／␉CG␚!ηβ\v\x1b",
	}, { // 1133
		mask: EncodeDoubleQuote | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "．\v\x0f％；κ+5η｜χ␚\x02SＹ|\v␛␓<／␉CG␚!ηβ\v\x1b",
		out:  "‛．\v\x0f％；κ+5η｜χ␚\x02SＹ|\v␛␓<／␉CG␚!ηβ\v\x1b",
	}, { // 1134
		mask: EncodeDoubleQuote | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   ".\r\x0f％；κ+5η｜χ␚\x02SＹ|\v␛␓<／␉CG␚!ηβ\r\x1b",
		out:  "．\r\x0f％；κ+5η｜χ␚\x02SＹ|\v␛␓<／␉CG␚!ηβ\r\x1b",
	}, { // 1135
		mask: EncodeDoubleQuote | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "．\r\x0f％；κ+5η｜χ␚\x02SＹ|\v␛␓<／␉CG␚!ηβ\r\x1b",
		out:  "‛．\r\x0f％；κ+5η｜χ␚\x02SＹ|\v␛␓<／␉CG␚!ηβ\r\x1b",
	}, { // 1136
		mask: EncodeDoubleQuote | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "τ\t\x0f％；κ+5η｜χ␚\x02SＹ|\v␛␓<／␉CG␚!ηβ\t.",
		out:  "τ\t\x0f％；κ+5η｜χ␚\x02SＹ|\v␛␓<／␉CG␚!ηβ\t.",
	}, { // 1137
		mask: EncodeDoubleQuote | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "τ\t\x0f％；κ+5η｜χ␚\x02SＹ|\v␛␓<／␉CG␚!ηβ\t．",
		out:  "τ\t\x0f％；κ+5η｜χ␚\x02SＹ|\v␛␓<／␉CG␚!ηβ\t．",
	}, { // 1138
		mask: EncodeDoubleQuote | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "τ\n\x0f％；κ+5η｜χ␚\x02SＹ|\v␛␓<／␉CG␚!ηβ\n.",
		out:  "τ\n\x0f％；κ+5η｜χ␚\x02SＹ|\v␛␓<／␉CG␚!ηβ\n.",
	}, { // 1139
		mask: EncodeDoubleQuote | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "τ\n\x0f％；κ+5η｜χ␚\x02SＹ|\v␛␓<／␉CG␚!ηβ\n．",
		out:  "τ\n\x0f％；κ+5η｜χ␚\x02SＹ|\v␛␓<／␉CG␚!ηβ\n．",
	}, { // 1140
		mask: EncodeDoubleQuote | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "τ\v\x0f％；κ+5η｜χ␚\x02SＹ|\v␛␓<／␉CG␚!ηβ\v.",
		out:  "τ\v\x0f％；κ+5η｜χ␚\x02SＹ|\v␛␓<／␉CG␚!ηβ\v.",
	}, { // 1141
		mask: EncodeDoubleQuote | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "τ\v\x0f％；κ+5η｜χ␚\x02SＹ|\v␛␓<／␉CG␚!ηβ\v．",
		out:  "τ\v\x0f％；κ+5η｜χ␚\x02SＹ|\v␛␓<／␉CG␚!ηβ\v．",
	}, { // 1142
		mask: EncodeDoubleQuote | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "τ\r\x0f％；κ+5η｜χ␚\x02SＹ|\v␛␓<／␉CG␚!ηβ\r.",
		out:  "τ\r\x0f％；κ+5η｜χ␚\x02SＹ|\v␛␓<／␉CG␚!ηβ\r.",
	}, { // 1143
		mask: EncodeDoubleQuote | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "τ\r\x0f％；κ+5η｜χ␚\x02SＹ|\v␛␓<／␉CG␚!ηβ\r．",
		out:  "τ\r\x0f％；κ+5η｜χ␚\x02SＹ|\v␛␓<／␉CG␚!ηβ\r．",
	}, { // 1144
		mask: EncodeColon | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   ".\tｑ＠ςTμπ６\u007f：?\\3｀␙σβ｜：\x0e␞*#η`.Ｒ\tｖ",
		out:  "．\tｑ＠ςTμπ６\u007f‛：?\\3｀␙σβ｜‛：\x0e␞*#η`.Ｒ\tｖ",
	}, { // 1145
		mask: EncodeColon | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "．\tｑ＠ςTμπ６\u007f：?\\3｀␙σβ｜：\x0e␞*#η`.Ｒ\tｖ",
		out:  "‛．\tｑ＠ςTμπ６\u007f‛：?\\3｀␙σβ｜‛：\x0e␞*#η`.Ｒ\tｖ",
	}, { // 1146
		mask: EncodeColon | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   ".\nｑ＠ςTμπ６\u007f：?\\3｀␙σβ｜：\x0e␞*#η`.Ｒ\nｖ",
		out:  "．\nｑ＠ςTμπ６\u007f‛：?\\3｀␙σβ｜‛：\x0e␞*#η`.Ｒ\nｖ",
	}, { // 1147
		mask: EncodeColon | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "．\nｑ＠ςTμπ６\u007f：?\\3｀␙σβ｜：\x0e␞*#η`.Ｒ\nｖ",
		out:  "‛．\nｑ＠ςTμπ６\u007f‛：?\\3｀␙σβ｜‛：\x0e␞*#η`.Ｒ\nｖ",
	}, { // 1148
		mask: EncodeColon | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   ".\vｑ＠ςTμπ６\u007f：?\\3｀␙σβ｜：\x0e␞*#η`.Ｒ\vｖ",
		out:  "．\vｑ＠ςTμπ６\u007f‛：?\\3｀␙σβ｜‛：\x0e␞*#η`.Ｒ\vｖ",
	}, { // 1149
		mask: EncodeColon | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "．\vｑ＠ςTμπ６\u007f：?\\3｀␙σβ｜：\x0e␞*#η`.Ｒ\vｖ",
		out:  "‛．\vｑ＠ςTμπ６\u007f‛：?\\3｀␙σβ｜‛：\x0e␞*#η`.Ｒ\vｖ",
	}, { // 1150
		mask: EncodeColon | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   ".\rｑ＠ςTμπ６\u007f：?\\3｀␙σβ｜：\x0e␞*#η`.Ｒ\rｖ",
		out:  "．\rｑ＠ςTμπ６\u007f‛：?\\3｀␙σβ｜‛：\x0e␞*#η`.Ｒ\rｖ",
	}, { // 1151
		mask: EncodeColon | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "．\rｑ＠ςTμπ６\u007f：?\\3｀␙σβ｜：\x0e␞*#η`.Ｒ\rｖ",
		out:  "‛．\rｑ＠ςTμπ６\u007f‛：?\\3｀␙σβ｜‛：\x0e␞*#η`.Ｒ\rｖ",
	}, { // 1152
		mask: EncodeColon | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "␁\tｑ＠ςTμπ６\u007f：?\\3｀␙σβ｜：\x0e␞*#η`.Ｒ\t.",
		out:  "␁\tｑ＠ςTμπ６\u007f‛：?\\3｀␙σβ｜‛：\x0e␞*#η`.Ｒ\t.",
	}, { // 1153
		mask: EncodeColon | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "␁\tｑ＠ςTμπ６\u007f：?\\3｀␙σβ｜：\x0e␞*#η`.Ｒ\t．",
		out:  "␁\tｑ＠ςTμπ６\u007f‛：?\\3｀␙σβ｜‛：\x0e␞*#η`.Ｒ\t．",
	}, { // 1154
		mask: EncodeColon | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "␁\nｑ＠ςTμπ６\u007f：?\\3｀␙σβ｜：\x0e␞*#η`.Ｒ\n.",
		out:  "␁\nｑ＠ςTμπ６\u007f‛：?\\3｀␙σβ｜‛：\x0e␞*#η`.Ｒ\n.",
	}, { // 1155
		mask: EncodeColon | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "␁\nｑ＠ςTμπ６\u007f：?\\3｀␙σβ｜：\x0e␞*#η`.Ｒ\n．",
		out:  "␁\nｑ＠ςTμπ６\u007f‛：?\\3｀␙σβ｜‛：\x0e␞*#η`.Ｒ\n．",
	}, { // 1156
		mask: EncodeColon | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "␁\vｑ＠ςTμπ６\u007f：?\\3｀␙σβ｜：\x0e␞*#η`.Ｒ\v.",
		out:  "␁\vｑ＠ςTμπ６\u007f‛：?\\3｀␙σβ｜‛：\x0e␞*#η`.Ｒ\v.",
	}, { // 1157
		mask: EncodeColon | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "␁\vｑ＠ςTμπ６\u007f：?\\3｀␙σβ｜：\x0e␞*#η`.Ｒ\v．",
		out:  "␁\vｑ＠ςTμπ６\u007f‛：?\\3｀␙σβ｜‛：\x0e␞*#η`.Ｒ\v．",
	}, { // 1158
		mask: EncodeColon | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "␁\rｑ＠ςTμπ６\u007f：?\\3｀␙σβ｜：\x0e␞*#η`.Ｒ\r.",
		out:  "␁\rｑ＠ςTμπ６\u007f‛：?\\3｀␙σβ｜‛：\x0e␞*#η`.Ｒ\r.",
	}, { // 1159
		mask: EncodeColon | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "␁\rｑ＠ςTμπ６\u007f：?\\3｀␙σβ｜：\x0e␞*#η`.Ｒ\r．",
		out:  "␁\rｑ＠ςTμπ６\u007f‛：?\\3｀␙σβ｜‛：\x0e␞*#η`.Ｒ\r．",
	}, { // 1160
		mask: EncodeQuestion | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   ".\t\x17ν;］\x17␒ςm＠]αμ\uff00Ｉ+␏４S＼τ＆xo%␎\x1f\t？",
		out:  "．\t\x17ν;］\x17␒ςm＠]αμ\uff00Ｉ+␏４S＼τ＆xo%␎\x1f\t‛？",
	}, { // 1161
		mask: EncodeQuestion | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "．\t\x17ν;］\x17␒ςm＠]αμ\uff00Ｉ+␏４S＼τ＆xo%␎\x1f\t？",
		out:  "‛．\t\x17ν;］\x17␒ςm＠]αμ\uff00Ｉ+␏４S＼τ＆xo%␎\x1f\t‛？",
	}, { // 1162
		mask: EncodeQuestion | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   ".\n\x17ν;］\x17␒ςm＠]αμ\uff00Ｉ+␏４S＼τ＆xo%␎\x1f\n？",
		out:  "．\n\x17ν;］\x17␒ςm＠]αμ\uff00Ｉ+␏４S＼τ＆xo%␎\x1f\n‛？",
	}, { // 1163
		mask: EncodeQuestion | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "．\n\x17ν;］\x17␒ςm＠]αμ\uff00Ｉ+␏４S＼τ＆xo%␎\x1f\n？",
		out:  "‛．\n\x17ν;］\x17␒ςm＠]αμ\uff00Ｉ+␏４S＼τ＆xo%␎\x1f\n‛？",
	}, { // 1164
		mask: EncodeQuestion | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   ".\v\x17ν;］\x17␒ςm＠]αμ\uff00Ｉ+␏４S＼τ＆xo%␎\x1f\v？",
		out:  "．\v\x17ν;］\x17␒ςm＠]αμ\uff00Ｉ+␏４S＼τ＆xo%␎\x1f\v‛？",
	}, { // 1165
		mask: EncodeQuestion | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "．\v\x17ν;］\x17␒ςm＠]αμ\uff00Ｉ+␏４S＼τ＆xo%␎\x1f\v？",
		out:  "‛．\v\x17ν;］\x17␒ςm＠]αμ\uff00Ｉ+␏４S＼τ＆xo%␎\x1f\v‛？",
	}, { // 1166
		mask: EncodeQuestion | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   ".\r\x17ν;］\x17␒ςm＠]αμ\uff00Ｉ+␏４S＼τ＆xo%␎\x1f\r？",
		out:  "．\r\x17ν;］\x17␒ςm＠]αμ\uff00Ｉ+␏４S＼τ＆xo%␎\x1f\r‛？",
	}, { // 1167
		mask: EncodeQuestion | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "．\r\x17ν;］\x17␒ςm＠]αμ\uff00Ｉ+␏４S＼τ＆xo%␎\x1f\r？",
		out:  "‛．\r\x17ν;］\x17␒ςm＠]αμ\uff00Ｉ+␏４S＼τ＆xo%␎\x1f\r‛？",
	}, { // 1168
		mask: EncodeQuestion | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "␎\t\x17ν;］\x17␒ςm＠]αμ\uff00Ｉ+␏４S＼τ＆xo%␎\x1f\t.",
		out:  "␎\t\x17ν;］\x17␒ςm＠]αμ\uff00Ｉ+␏４S＼τ＆xo%␎\x1f\t.",
	}, { // 1169
		mask: EncodeQuestion | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "␎\t\x17ν;］\x17␒ςm＠]αμ\uff00Ｉ+␏４S＼τ＆xo%␎\x1f\t．",
		out:  "␎\t\x17ν;］\x17␒ςm＠]αμ\uff00Ｉ+␏４S＼τ＆xo%␎\x1f\t．",
	}, { // 1170
		mask: EncodeQuestion | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "␎\n\x17ν;］\x17␒ςm＠]αμ\uff00Ｉ+␏４S＼τ＆xo%␎\x1f\n.",
		out:  "␎\n\x17ν;］\x17␒ςm＠]αμ\uff00Ｉ+␏４S＼τ＆xo%␎\x1f\n.",
	}, { // 1171
		mask: EncodeQuestion | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "␎\n\x17ν;］\x17␒ςm＠]αμ\uff00Ｉ+␏４S＼τ＆xo%␎\x1f\n．",
		out:  "␎\n\x17ν;］\x17␒ςm＠]αμ\uff00Ｉ+␏４S＼τ＆xo%␎\x1f\n．",
	}, { // 1172
		mask: EncodeQuestion | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "␎\v\x17ν;］\x17␒ςm＠]αμ\uff00Ｉ+␏４S＼τ＆xo%␎\x1f\v.",
		out:  "␎\v\x17ν;］\x17␒ςm＠]αμ\uff00Ｉ+␏４S＼τ＆xo%␎\x1f\v.",
	}, { // 1173
		mask: EncodeQuestion | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "␎\v\x17ν;］\x17␒ςm＠]αμ\uff00Ｉ+␏４S＼τ＆xo%␎\x1f\v．",
		out:  "␎\v\x17ν;］\x17␒ςm＠]αμ\uff00Ｉ+␏４S＼τ＆xo%␎\x1f\v．",
	}, { // 1174
		mask: EncodeQuestion | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "␎\r\x17ν;］\x17␒ςm＠]αμ\uff00Ｉ+␏４S＼τ＆xo%␎\x1f\r.",
		out:  "␎\r\x17ν;］\x17␒ςm＠]αμ\uff00Ｉ+␏４S＼τ＆xo%␎\x1f\r.",
	}, { // 1175
		mask: EncodeQuestion | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "␎\r\x17ν;］\x17␒ςm＠]αμ\uff00Ｉ+␏４S＼τ＆xo%␎\x1f\r．",
		out:  "␎\r\x17ν;］\x17␒ςm＠]αμ\uff00Ｉ+␏４S＼τ＆xo%␎\x1f\r．",
	}, { // 1176
		mask: EncodeAsterisk | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   ".\tθ．～␍\n\x00ι ␍＞８:δω␖3＝␐δ␛９[β0ＹG\t\v",
		out:  "．\tθ．～␍\n␀ι ␍＞８:δω␖3＝␐δ␛９[β0ＹG\t\v",
	}, { // 1177
		mask: EncodeAsterisk | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "．\tθ．～␍\n\x00ι ␍＞８:δω␖3＝␐δ␛９[β0ＹG\t\v",
		out:  "‛．\tθ．～␍\n␀ι ␍＞８:δω␖3＝␐δ␛９[β0ＹG\t\v",
	}, { // 1178
		mask: EncodeAsterisk | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   ".\nθ．～␍\n\x00ι ␍＞８:δω␖3＝␐δ␛９[β0ＹG\n\v",
		out:  "．\nθ．～␍\n␀ι ␍＞８:δω␖3＝␐δ␛９[β0ＹG\n\v",
	}, { // 1179
		mask: EncodeAsterisk | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "．\nθ．～␍\n\x00ι ␍＞８:δω␖3＝␐δ␛９[β0ＹG\n\v",
		out:  "‛．\nθ．～␍\n␀ι ␍＞８:δω␖3＝␐δ␛９[β0ＹG\n\v",
	}, { // 1180
		mask: EncodeAsterisk | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   ".\vθ．～␍\n\x00ι ␍＞８:δω␖3＝␐δ␛９[β0ＹG\v\v",
		out:  "．\vθ．～␍\n␀ι ␍＞８:δω␖3＝␐δ␛９[β0ＹG\v\v",
	}, { // 1181
		mask: EncodeAsterisk | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "．\vθ．～␍\n\x00ι ␍＞８:δω␖3＝␐δ␛９[β0ＹG\v\v",
		out:  "‛．\vθ．～␍\n␀ι ␍＞８:δω␖3＝␐δ␛９[β0ＹG\v\v",
	}, { // 1182
		mask: EncodeAsterisk | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   ".\rθ．～␍\n\x00ι ␍＞８:δω␖3＝␐δ␛９[β0ＹG\r\v",
		out:  "．\rθ．～␍\n␀ι ␍＞８:δω␖3＝␐δ␛９[β0ＹG\r\v",
	}, { // 1183
		mask: EncodeAsterisk | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "．\rθ．～␍\n\x00ι ␍＞８:δω␖3＝␐δ␛９[β0ＹG\r\v",
		out:  "‛．\rθ．～␍\n␀ι ␍＞８:δω␖3＝␐δ␛９[β0ＹG\r\v",
	}, { // 1184
		mask: EncodeAsterisk | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "\b\tθ．～␍\n\x00ι ␍＞８:δω␖3＝␐δ␛９[β0ＹG\t.",
		out:  "\b\tθ．～␍\n␀ι ␍＞８:δω␖3＝␐δ␛９[β0ＹG\t.",
	}, { // 1185
		mask: EncodeAsterisk | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "\b\tθ．～␍\n\x00ι ␍＞８:δω␖3＝␐δ␛９[β0ＹG\t．",
		out:  "\b\tθ．～␍\n␀ι ␍＞８:δω␖3＝␐δ␛９[β0ＹG\t．",
	}, { // 1186
		mask: EncodeAsterisk | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "\b\nθ．～␍\n\x00ι ␍＞８:δω␖3＝␐δ␛９[β0ＹG\n.",
		out:  "\b\nθ．～␍\n␀ι ␍＞８:δω␖3＝␐δ␛９[β0ＹG\n.",
	}, { // 1187
		mask: EncodeAsterisk | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "\b\nθ．～␍\n\x00ι ␍＞８:δω␖3＝␐δ␛９[β0ＹG\n．",
		out:  "\b\nθ．～␍\n␀ι ␍＞８:δω␖3＝␐δ␛９[β0ＹG\n．",
	}, { // 1188
		mask: EncodeAsterisk | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "\b\vθ．～␍\n\x00ι ␍＞８:δω␖3＝␐δ␛９[β0ＹG\v.",
		out:  "\b\vθ．～␍\n␀ι ␍＞８:δω␖3＝␐δ␛９[β0ＹG\v.",
	}, { // 1189
		mask: EncodeAsterisk | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "\b\vθ．～␍\n\x00ι ␍＞８:δω␖3＝␐δ␛９[β0ＹG\v．",
		out:  "\b\vθ．～␍\n␀ι ␍＞８:δω␖3＝␐δ␛９[β0ＹG\v．",
	}, { // 1190
		mask: EncodeAsterisk | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "\b\rθ．～␍\n\x00ι ␍＞８:δω␖3＝␐δ␛９[β0ＹG\r.",
		out:  "\b\rθ．～␍\n␀ι ␍＞８:δω␖3＝␐δ␛９[β0ＹG\r.",
	}, { // 1191
		mask: EncodeAsterisk | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "\b\rθ．～␍\n\x00ι ␍＞８:δω␖3＝␐δ␛９[β0ＹG\r．",
		out:  "\b\rθ．～␍\n␀ι ␍＞８:δω␖3＝␐δ␛９[β0ＹG\r．",
	}, { // 1192
		mask: EncodePipe | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   ".\t␜<ξ?uf\x11Ｒφ｛␟dｒGY\vξ␇＋$␄λ\x0e１K␝\t＜",
		out:  "．\t␜<ξ?uf\x11Ｒφ｛␟dｒGY\vξ␇＋$␄λ\x0e１K␝\t＜",
	}, { // 1193
		mask: EncodePipe | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "．\t␜<ξ?uf\x11Ｒφ｛␟dｒGY\vξ␇＋$␄λ\x0e１K␝\t＜",
		out:  "‛．\t␜<ξ?uf\x11Ｒφ｛␟dｒGY\vξ␇＋$␄λ\x0e１K␝\t＜",
	}, { // 1194
		mask: EncodePipe | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   ".\n␜<ξ?uf\x11Ｒφ｛␟dｒGY\vξ␇＋$␄λ\x0e１K␝\n＜",
		out:  "．\n␜<ξ?uf\x11Ｒφ｛␟dｒGY\vξ␇＋$␄λ\x0e１K␝\n＜",
	}, { // 1195
		mask: EncodePipe | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "．\n␜<ξ?uf\x11Ｒφ｛␟dｒGY\vξ␇＋$␄λ\x0e１K␝\n＜",
		out:  "‛．\n␜<ξ?uf\x11Ｒφ｛␟dｒGY\vξ␇＋$␄λ\x0e１K␝\n＜",
	}, { // 1196
		mask: EncodePipe | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   ".\v␜<ξ?uf\x11Ｒφ｛␟dｒGY\vξ␇＋$␄λ\x0e１K␝\v＜",
		out:  "．\v␜<ξ?uf\x11Ｒφ｛␟dｒGY\vξ␇＋$␄λ\x0e１K␝\v＜",
	}, { // 1197
		mask: EncodePipe | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "．\v␜<ξ?uf\x11Ｒφ｛␟dｒGY\vξ␇＋$␄λ\x0e１K␝\v＜",
		out:  "‛．\v␜<ξ?uf\x11Ｒφ｛␟dｒGY\vξ␇＋$␄λ\x0e１K␝\v＜",
	}, { // 1198
		mask: EncodePipe | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   ".\r␜<ξ?uf\x11Ｒφ｛␟dｒGY\vξ␇＋$␄λ\x0e１K␝\r＜",
		out:  "．\r␜<ξ?uf\x11Ｒφ｛␟dｒGY\vξ␇＋$␄λ\x0e１K␝\r＜",
	}, { // 1199
		mask: EncodePipe | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "．\r␜<ξ?uf\x11Ｒφ｛␟dｒGY\vξ␇＋$␄λ\x0e１K␝\r＜",
		out:  "‛．\r␜<ξ?uf\x11Ｒφ｛␟dｒGY\vξ␇＋$␄λ\x0e１K␝\r＜",
	}, { // 1200
		mask: EncodePipe | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "ξ\t␜<ξ?uf\x11Ｒφ｛␟dｒGY\vξ␇＋$␄λ\x0e１K␝\t.",
		out:  "ξ\t␜<ξ?uf\x11Ｒφ｛␟dｒGY\vξ␇＋$␄λ\x0e１K␝\t.",
	}, { // 1201
		mask: EncodePipe | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "ξ\t␜<ξ?uf\x11Ｒφ｛␟dｒGY\vξ␇＋$␄λ\x0e１K␝\t．",
		out:  "ξ\t␜<ξ?uf\x11Ｒφ｛␟dｒGY\vξ␇＋$␄λ\x0e１K␝\t．",
	}, { // 1202
		mask: EncodePipe | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "ξ\n␜<ξ?uf\x11Ｒφ｛␟dｒGY\vξ␇＋$␄λ\x0e１K␝\n.",
		out:  "ξ\n␜<ξ?uf\x11Ｒφ｛␟dｒGY\vξ␇＋$␄λ\x0e１K␝\n.",
	}, { // 1203
		mask: EncodePipe | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "ξ\n␜<ξ?uf\x11Ｒφ｛␟dｒGY\vξ␇＋$␄λ\x0e１K␝\n．",
		out:  "ξ\n␜<ξ?uf\x11Ｒφ｛␟dｒGY\vξ␇＋$␄λ\x0e１K␝\n．",
	}, { // 1204
		mask: EncodePipe | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "ξ\v␜<ξ?uf\x11Ｒφ｛␟dｒGY\vξ␇＋$␄λ\x0e１K␝\v.",
		out:  "ξ\v␜<ξ?uf\x11Ｒφ｛␟dｒGY\vξ␇＋$␄λ\x0e１K␝\v.",
	}, { // 1205
		mask: EncodePipe | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "ξ\v␜<ξ?uf\x11Ｒφ｛␟dｒGY\vξ␇＋$␄λ\x0e１K␝\v．",
		out:  "ξ\v␜<ξ?uf\x11Ｒφ｛␟dｒGY\vξ␇＋$␄λ\x0e１K␝\v．",
	}, { // 1206
		mask: EncodePipe | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "ξ\r␜<ξ?uf\x11Ｒφ｛␟dｒGY\vξ␇＋$␄λ\x0e１K␝\r.",
		out:  "ξ\r␜<ξ?uf\x11Ｒφ｛␟dｒGY\vξ␇＋$␄λ\x0e１K␝\r.",
	}, { // 1207
		mask: EncodePipe | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "ξ\r␜<ξ?uf\x11Ｒφ｛␟dｒGY\vξ␇＋$␄λ\x0e１K␝\r．",
		out:  "ξ\r␜<ξ?uf\x11Ｒφ｛␟dｒGY\vξ␇＋$␄λ\x0e１K␝\r．",
	}, { // 1208
		mask: EncodeHash | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   ".\t*Jｍ\b\\␃7s／ζj＇m］＇\x05λＦｐξi\x0f＄！＇ξ\tτ",
		out:  "．\t*Jｍ\b\\␃7s／ζj＇m］＇\x05λＦｐξi\x0f＄！＇ξ\tτ",
	}, { // 1209
		mask: EncodeHash | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "．\t*Jｍ\b\\␃7s／ζj＇m］＇\x05λＦｐξi\x0f＄！＇ξ\tτ",
		out:  "‛．\t*Jｍ\b\\␃7s／ζj＇m］＇\x05λＦｐξi\x0f＄！＇ξ\tτ",
	}, { // 1210
		mask: EncodeHash | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   ".\n*Jｍ\b\\␃7s／ζj＇m］＇\x05λＦｐξi\x0f＄！＇ξ\nτ",
		out:  "．\n*Jｍ\b\\␃7s／ζj＇m］＇\x05λＦｐξi\x0f＄！＇ξ\nτ",
	}, { // 1211
		mask: EncodeHash | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "．\n*Jｍ\b\\␃7s／ζj＇m］＇\x05λＦｐξi\x0f＄！＇ξ\nτ",
		out:  "‛．\n*Jｍ\b\\␃7s／ζj＇m］＇\x05λＦｐξi\x0f＄！＇ξ\nτ",
	}, { // 1212
		mask: EncodeHash | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   ".\v*Jｍ\b\\␃7s／ζj＇m］＇\x05λＦｐξi\x0f＄！＇ξ\vτ",
		out:  "．\v*Jｍ\b\\␃7s／ζj＇m］＇\x05λＦｐξi\x0f＄！＇ξ\vτ",
	}, { // 1213
		mask: EncodeHash | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "．\v*Jｍ\b\\␃7s／ζj＇m］＇\x05λＦｐξi\x0f＄！＇ξ\vτ",
		out:  "‛．\v*Jｍ\b\\␃7s／ζj＇m］＇\x05λＦｐξi\x0f＄！＇ξ\vτ",
	}, { // 1214
		mask: EncodeHash | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   ".\r*Jｍ\b\\␃7s／ζj＇m］＇\x05λＦｐξi\x0f＄！＇ξ\rτ",
		out:  "．\r*Jｍ\b\\␃7s／ζj＇m］＇\x05λＦｐξi\x0f＄！＇ξ\rτ",
	}, { // 1215
		mask: EncodeHash | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "．\r*Jｍ\b\\␃7s／ζj＇m］＇\x05λＦｐξi\x0f＄！＇ξ\rτ",
		out:  "‛．\r*Jｍ\b\\␃7s／ζj＇m］＇\x05λＦｐξi\x0f＄！＇ξ\rτ",
	}, { // 1216
		mask: EncodeHash | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "␅\t*Jｍ\b\\␃7s／ζj＇m］＇\x05λＦｐξi\x0f＄！＇ξ\t.",
		out:  "␅\t*Jｍ\b\\␃7s／ζj＇m］＇\x05λＦｐξi\x0f＄！＇ξ\t.",
	}, { // 1217
		mask: EncodeHash | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "␅\t*Jｍ\b\\␃7s／ζj＇m］＇\x05λＦｐξi\x0f＄！＇ξ\t．",
		out:  "␅\t*Jｍ\b\\␃7s／ζj＇m］＇\x05λＦｐξi\x0f＄！＇ξ\t．",
	}, { // 1218
		mask: EncodeHash | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "␅\n*Jｍ\b\\␃7s／ζj＇m］＇\x05λＦｐξi\x0f＄！＇ξ\n.",
		out:  "␅\n*Jｍ\b\\␃7s／ζj＇m］＇\x05λＦｐξi\x0f＄！＇ξ\n.",
	}, { // 1219
		mask: EncodeHash | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "␅\n*Jｍ\b\\␃7s／ζj＇m］＇\x05λＦｐξi\x0f＄！＇ξ\n．",
		out:  "␅\n*Jｍ\b\\␃7s／ζj＇m］＇\x05λＦｐξi\x0f＄！＇ξ\n．",
	}, { // 1220
		mask: EncodeHash | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "␅\v*Jｍ\b\\␃7s／ζj＇m］＇\x05λＦｐξi\x0f＄！＇ξ\v.",
		out:  "␅\v*Jｍ\b\\␃7s／ζj＇m］＇\x05λＦｐξi\x0f＄！＇ξ\v.",
	}, { // 1221
		mask: EncodeHash | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "␅\v*Jｍ\b\\␃7s／ζj＇m］＇\x05λＦｐξi\x0f＄！＇ξ\v．",
		out:  "␅\v*Jｍ\b\\␃7s／ζj＇m］＇\x05λＦｐξi\x0f＄！＇ξ\v．",
	}, { // 1222
		mask: EncodeHash | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "␅\r*Jｍ\b\\␃7s／ζj＇m］＇\x05λＦｐξi\x0f＄！＇ξ\r.",
		out:  "␅\r*Jｍ\b\\␃7s／ζj＇m］＇\x05λＦｐξi\x0f＄！＇ξ\r.",
	}, { // 1223
		mask: EncodeHash | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "␅\r*Jｍ\b\\␃7s／ζj＇m］＇\x05λＦｐξi\x0f＄！＇ξ\r．",
		out:  "␅\r*Jｍ\b\\␃7s／ζj＇m］＇\x05λＦｐξi\x0f＄！＇ξ\r．",
	}, { // 1224
		mask: EncodePercent | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   ".\tκ～\a｀κvＱYλ（\x0e\v␚ｐFπα｝;δ'？\x06␄␁#\t␒",
		out:  "．\tκ～\a｀κvＱYλ（\x0e\v␚ｐFπα｝;δ'？\x06␄␁#\t␒",
	}, { // 1225
		mask: EncodePercent | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "．\tκ～\a｀κvＱYλ（\x0e\v␚ｐFπα｝;δ'？\x06␄␁#\t␒",
		out:  "‛．\tκ～\a｀κvＱYλ（\x0e\v␚ｐFπα｝;δ'？\x06␄␁#\t␒",
	}, { // 1226
		mask: EncodePercent | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   ".\nκ～\a｀κvＱYλ（\x0e\v␚ｐFπα｝;δ'？\x06␄␁#\n␒",
		out:  "．\nκ～\a｀κvＱYλ（\x0e\v␚ｐFπα｝;δ'？\x06␄␁#\n␒",
	}, { // 1227
		mask: EncodePercent | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "．\nκ～\a｀κvＱYλ（\x0e\v␚ｐFπα｝;δ'？\x06␄␁#\n␒",
		out:  "‛．\nκ～\a｀κvＱYλ（\x0e\v␚ｐFπα｝;δ'？\x06␄␁#\n␒",
	}, { // 1228
		mask: EncodePercent | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   ".\vκ～\a｀κvＱYλ（\x0e\v␚ｐFπα｝;δ'？\x06␄␁#\v␒",
		out:  "．\vκ～\a｀κvＱYλ（\x0e\v␚ｐFπα｝;δ'？\x06␄␁#\v␒",
	}, { // 1229
		mask: EncodePercent | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "．\vκ～\a｀κvＱYλ（\x0e\v␚ｐFπα｝;δ'？\x06␄␁#\v␒",
		out:  "‛．\vκ～\a｀κvＱYλ（\x0e\v␚ｐFπα｝;δ'？\x06␄␁#\v␒",
	}, { // 1230
		mask: EncodePercent | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   ".\rκ～\a｀κvＱYλ（\x0e\v␚ｐFπα｝;δ'？\x06␄␁#\r␒",
		out:  "．\rκ～\a｀κvＱYλ（\x0e\v␚ｐFπα｝;δ'？\x06␄␁#\r␒",
	}, { // 1231
		mask: EncodePercent | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "．\rκ～\a｀κvＱYλ（\x0e\v␚ｐFπα｝;δ'？\x06␄␁#\r␒",
		out:  "‛．\rκ～\a｀κvＱYλ（\x0e\v␚ｐFπα｝;δ'？\x06␄␁#\r␒",
	}, { // 1232
		mask: EncodePercent | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "7\tκ～\a｀κvＱYλ（\x0e\v␚ｐFπα｝;δ'？\x06␄␁#\t.",
		out:  "7\tκ～\a｀κvＱYλ（\x0e\v␚ｐFπα｝;δ'？\x06␄␁#\t.",
	}, { // 1233
		mask: EncodePercent | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "7\tκ～\a｀κvＱYλ（\x0e\v␚ｐFπα｝;δ'？\x06␄␁#\t．",
		out:  "7\tκ～\a｀κvＱYλ（\x0e\v␚ｐFπα｝;δ'？\x06␄␁#\t．",
	}, { // 1234
		mask: EncodePercent | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "7\nκ～\a｀κvＱYλ（\x0e\v␚ｐFπα｝;δ'？\x06␄␁#\n.",
		out:  "7\nκ～\a｀κvＱYλ（\x0e\v␚ｐFπα｝;δ'？\x06␄␁#\n.",
	}, { // 1235
		mask: EncodePercent | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "7\nκ～\a｀κvＱYλ（\x0e\v␚ｐFπα｝;δ'？\x06␄␁#\n．",
		out:  "7\nκ～\a｀κvＱYλ（\x0e\v␚ｐFπα｝;δ'？\x06␄␁#\n．",
	}, { // 1236
		mask: EncodePercent | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "7\vκ～\a｀κvＱYλ（\x0e\v␚ｐFπα｝;δ'？\x06␄␁#\v.",
		out:  "7\vκ～\a｀κvＱYλ（\x0e\v␚ｐFπα｝;δ'？\x06␄␁#\v.",
	}, { // 1237
		mask: EncodePercent | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "7\vκ～\a｀κvＱYλ（\x0e\v␚ｐFπα｝;δ'？\x06␄␁#\v．",
		out:  "7\vκ～\a｀κvＱYλ（\x0e\v␚ｐFπα｝;δ'？\x06␄␁#\v．",
	}, { // 1238
		mask: EncodePercent | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "7\rκ～\a｀κvＱYλ（\x0e\v␚ｐFπα｝;δ'？\x06␄␁#\r.",
		out:  "7\rκ～\a｀κvＱYλ（\x0e\v␚ｐFπα｝;δ'？\x06␄␁#\r.",
	}, { // 1239
		mask: EncodePercent | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "7\rκ～\a｀κvＱYλ（\x0e\v␚ｐFπα｝;δ'？\x06␄␁#\r．",
		out:  "7\rκ～\a｀κvＱYλ（\x0e\v␚ｐFπα｝;δ'？\x06␄␁#\r．",
	}, { // 1240
		mask: EncodeBackSlash | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   ".\tS；]θe␖4\x11:ξ｛9＋<ｙ\f\x1e␓␎␟ξ^λυ＼␏\tｘ",
		out:  "．\tS；]θe␖4\x11:ξ｛9＋<ｙ\f\x1e␓␎␟ξ^λυ‛＼␏\tｘ",
	}, { // 1241
		mask: EncodeBackSlash | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "．\tS；]θe␖4\x11:ξ｛9＋<ｙ\f\x1e␓␎␟ξ^λυ＼␏\tｘ",
		out:  "‛．\tS；]θe␖4\x11:ξ｛9＋<ｙ\f\x1e␓␎␟ξ^λυ‛＼␏\tｘ",
	}, { // 1242
		mask: EncodeBackSlash | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   ".\nS；]θe␖4\x11:ξ｛9＋<ｙ\f\x1e␓␎␟ξ^λυ＼␏\nｘ",
		out:  "．\nS；]θe␖4\x11:ξ｛9＋<ｙ\f\x1e␓␎␟ξ^λυ‛＼␏\nｘ",
	}, { // 1243
		mask: EncodeBackSlash | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "．\nS；]θe␖4\x11:ξ｛9＋<ｙ\f\x1e␓␎␟ξ^λυ＼␏\nｘ",
		out:  "‛．\nS；]θe␖4\x11:ξ｛9＋<ｙ\f\x1e␓␎␟ξ^λυ‛＼␏\nｘ",
	}, { // 1244
		mask: EncodeBackSlash | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   ".\vS；]θe␖4\x11:ξ｛9＋<ｙ\f\x1e␓␎␟ξ^λυ＼␏\vｘ",
		out:  "．\vS；]θe␖4\x11:ξ｛9＋<ｙ\f\x1e␓␎␟ξ^λυ‛＼␏\vｘ",
	}, { // 1245
		mask: EncodeBackSlash | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "．\vS；]θe␖4\x11:ξ｛9＋<ｙ\f\x1e␓␎␟ξ^λυ＼␏\vｘ",
		out:  "‛．\vS；]θe␖4\x11:ξ｛9＋<ｙ\f\x1e␓␎␟ξ^λυ‛＼␏\vｘ",
	}, { // 1246
		mask: EncodeBackSlash | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   ".\rS；]θe␖4\x11:ξ｛9＋<ｙ\f\x1e␓␎␟ξ^λυ＼␏\rｘ",
		out:  "．\rS；]θe␖4\x11:ξ｛9＋<ｙ\f\x1e␓␎␟ξ^λυ‛＼␏\rｘ",
	}, { // 1247
		mask: EncodeBackSlash | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "．\rS；]θe␖4\x11:ξ｛9＋<ｙ\f\x1e␓␎␟ξ^λυ＼␏\rｘ",
		out:  "‛．\rS；]θe␖4\x11:ξ｛9＋<ｙ\f\x1e␓␎␟ξ^λυ‛＼␏\rｘ",
	}, { // 1248
		mask: EncodeBackSlash | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "Ｐ\tS；]θe␖4\x11:ξ｛9＋<ｙ\f\x1e␓␎␟ξ^λυ＼␏\t.",
		out:  "Ｐ\tS；]θe␖4\x11:ξ｛9＋<ｙ\f\x1e␓␎␟ξ^λυ‛＼␏\t.",
	}, { // 1249
		mask: EncodeBackSlash | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "Ｐ\tS；]θe␖4\x11:ξ｛9＋<ｙ\f\x1e␓␎␟ξ^λυ＼␏\t．",
		out:  "Ｐ\tS；]θe␖4\x11:ξ｛9＋<ｙ\f\x1e␓␎␟ξ^λυ‛＼␏\t．",
	}, { // 1250
		mask: EncodeBackSlash | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "Ｐ\nS；]θe␖4\x11:ξ｛9＋<ｙ\f\x1e␓␎␟ξ^λυ＼␏\n.",
		out:  "Ｐ\nS；]θe␖4\x11:ξ｛9＋<ｙ\f\x1e␓␎␟ξ^λυ‛＼␏\n.",
	}, { // 1251
		mask: EncodeBackSlash | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "Ｐ\nS；]θe␖4\x11:ξ｛9＋<ｙ\f\x1e␓␎␟ξ^λυ＼␏\n．",
		out:  "Ｐ\nS；]θe␖4\x11:ξ｛9＋<ｙ\f\x1e␓␎␟ξ^λυ‛＼␏\n．",
	}, { // 1252
		mask: EncodeBackSlash | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "Ｐ\vS；]θe␖4\x11:ξ｛9＋<ｙ\f\x1e␓␎␟ξ^λυ＼␏\v.",
		out:  "Ｐ\vS；]θe␖4\x11:ξ｛9＋<ｙ\f\x1e␓␎␟ξ^λυ‛＼␏\v.",
	}, { // 1253
		mask: EncodeBackSlash | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "Ｐ\vS；]θe␖4\x11:ξ｛9＋<ｙ\f\x1e␓␎␟ξ^λυ＼␏\v．",
		out:  "Ｐ\vS；]θe␖4\x11:ξ｛9＋<ｙ\f\x1e␓␎␟ξ^λυ‛＼␏\v．",
	}, { // 1254
		mask: EncodeBackSlash | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "Ｐ\rS；]θe␖4\x11:ξ｛9＋<ｙ\f\x1e␓␎␟ξ^λυ＼␏\r.",
		out:  "Ｐ\rS；]θe␖4\x11:ξ｛9＋<ｙ\f\x1e␓␎␟ξ^λυ‛＼␏\r.",
	}, { // 1255
		mask: EncodeBackSlash | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "Ｐ\rS；]θe␖4\x11:ξ｛9＋<ｙ\f\x1e␓␎␟ξ^λυ＼␏\r．",
		out:  "Ｐ\rS；]θe␖4\x11:ξ｛9＋<ｙ\f\x1e␓␎␟ξ^λυ‛＼␏\r．",
	}, { // 1256
		mask: EncodeDel | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   ".\t$＇ς６\r>ς␌ek]5～ν␀／）ＧＱＡ\x10ε␟αCσ\t[",
		out:  "．\t$＇ς６\r>ς␌ek]5～ν‛␀／）ＧＱＡ\x10ε␟αCσ\t[",
	}, { // 1257
		mask: EncodeDel | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "．\t$＇ς６\r>ς␌ek]5～ν␀／）ＧＱＡ\x10ε␟αCσ\t[",
		out:  "‛．\t$＇ς６\r>ς␌ek]5～ν‛␀／）ＧＱＡ\x10ε␟αCσ\t[",
	}, { // 1258
		mask: EncodeDel | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   ".\n$＇ς６\r>ς␌ek]5～ν␀／）ＧＱＡ\x10ε␟αCσ\n[",
		out:  "．\n$＇ς６\r>ς␌ek]5～ν‛␀／）ＧＱＡ\x10ε␟αCσ\n[",
	}, { // 1259
		mask: EncodeDel | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "．\n$＇ς６\r>ς␌ek]5～ν␀／）ＧＱＡ\x10ε␟αCσ\n[",
		out:  "‛．\n$＇ς６\r>ς␌ek]5～ν‛␀／）ＧＱＡ\x10ε␟αCσ\n[",
	}, { // 1260
		mask: EncodeDel | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   ".\v$＇ς６\r>ς␌ek]5～ν␀／）ＧＱＡ\x10ε␟αCσ\v[",
		out:  "．\v$＇ς６\r>ς␌ek]5～ν‛␀／）ＧＱＡ\x10ε␟αCσ\v[",
	}, { // 1261
		mask: EncodeDel | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "．\v$＇ς６\r>ς␌ek]5～ν␀／）ＧＱＡ\x10ε␟αCσ\v[",
		out:  "‛．\v$＇ς６\r>ς␌ek]5～ν‛␀／）ＧＱＡ\x10ε␟αCσ\v[",
	}, { // 1262
		mask: EncodeDel | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   ".\r$＇ς６\r>ς␌ek]5～ν␀／）ＧＱＡ\x10ε␟αCσ\r[",
		out:  "．\r$＇ς６\r>ς␌ek]5～ν‛␀／）ＧＱＡ\x10ε␟αCσ\r[",
	}, { // 1263
		mask: EncodeDel | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "．\r$＇ς６\r>ς␌ek]5～ν␀／）ＧＱＡ\x10ε␟αCσ\r[",
		out:  "‛．\r$＇ς６\r>ς␌ek]5～ν‛␀／）ＧＱＡ\x10ε␟αCσ\r[",
	}, { // 1264
		mask: EncodeDel | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "n\t$＇ς６\r>ς␌ek]5～ν␀／）ＧＱＡ\x10ε␟αCσ\t.",
		out:  "n\t$＇ς６\r>ς␌ek]5～ν‛␀／）ＧＱＡ\x10ε␟αCσ\t.",
	}, { // 1265
		mask: EncodeDel | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "n\t$＇ς６\r>ς␌ek]5～ν␀／）ＧＱＡ\x10ε␟αCσ\t．",
		out:  "n\t$＇ς６\r>ς␌ek]5～ν‛␀／）ＧＱＡ\x10ε␟αCσ\t．",
	}, { // 1266
		mask: EncodeDel | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "n\n$＇ς６\r>ς␌ek]5～ν␀／）ＧＱＡ\x10ε␟αCσ\n.",
		out:  "n\n$＇ς６\r>ς␌ek]5～ν‛␀／）ＧＱＡ\x10ε␟αCσ\n.",
	}, { // 1267
		mask: EncodeDel | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "n\n$＇ς６\r>ς␌ek]5～ν␀／）ＧＱＡ\x10ε␟αCσ\n．",
		out:  "n\n$＇ς６\r>ς␌ek]5～ν‛␀／）ＧＱＡ\x10ε␟αCσ\n．",
	}, { // 1268
		mask: EncodeDel | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "n\v$＇ς６\r>ς␌ek]5～ν␀／）ＧＱＡ\x10ε␟αCσ\v.",
		out:  "n\v$＇ς６\r>ς␌ek]5～ν‛␀／）ＧＱＡ\x10ε␟αCσ\v.",
	}, { // 1269
		mask: EncodeDel | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "n\v$＇ς６\r>ς␌ek]5～ν␀／）ＧＱＡ\x10ε␟αCσ\v．",
		out:  "n\v$＇ς６\r>ς␌ek]5～ν‛␀／）ＧＱＡ\x10ε␟αCσ\v．",
	}, { // 1270
		mask: EncodeDel | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "n\r$＇ς６\r>ς␌ek]5～ν␀／）ＧＱＡ\x10ε␟αCσ\r.",
		out:  "n\r$＇ς６\r>ς␌ek]5～ν‛␀／）ＧＱＡ\x10ε␟αCσ\r.",
	}, { // 1271
		mask: EncodeDel | EncodeLeftPeriod | EncodeLeftCrLfHtVt,
		in:   "n\r$＇ς６\r>ς␌ek]5～ν␀／）ＧＱＡ\x10ε␟αCσ\r．",
		out:  "n\r$＇ς６\r>ς␌ek]5～ν‛␀／）ＧＱＡ\x10ε␟αCσ\r．",
	}, { // 1272
		mask: EncodeZero | EncodeLeftPeriod | EncodeRightSpace,
		in:   ". φ!␘π['；␝g␜％ι＊␉\x0fＧδ␋<ωG＋ｑP\vγ Q",
		out:  "． φ!␘π['；␝g␜％ι＊␉\x0fＧδ␋<ωG＋ｑP\vγ Q",
	}, { // 1273
		mask: EncodeZero | EncodeLeftPeriod | EncodeRightSpace,
		in:   "． φ!␘π['；␝g␜％ι＊␉\x0fＧδ␋<ωG＋ｑP\vγ Q",
		out:  "‛． φ!␘π['；␝g␜％ι＊␉\x0fＧδ␋<ωG＋ｑP\vγ Q",
	}, { // 1274
		mask: EncodeZero | EncodeLeftPeriod | EncodeRightSpace,
		in:   "\x18 φ!␘π['；␝g␜％ι＊␉\x0fＧδ␋<ωG＋ｑP\vγ .",
		out:  "\x18 φ!␘π['；␝g␜％ι＊␉\x0fＧδ␋<ωG＋ｑP\vγ .",
	}, { // 1275
		mask: EncodeZero | EncodeLeftPeriod | EncodeRightSpace,
		in:   "\x18 φ!␘π['；␝g␜％ι＊␉\x0fＧδ␋<ωG＋ｑP\vγ ．",
		out:  "\x18 φ!␘π['；␝g␜％ι＊␉\x0fＧδ␋<ωG＋ｑP\vγ ．",
	}, { // 1276
		mask: EncodeSlash | EncodeLeftPeriod | EncodeRightSpace,
		in:   ". οxμ\x1bｍ｜␉ν␖ω|］ωσ\x10?０␈␏Y␔Ｚ\x1e?；e d",
		out:  "． οxμ\x1bｍ｜␉ν␖ω|］ωσ\x10?０␈␏Y␔Ｚ\x1e?；e d",
	}, { // 1277
		mask: EncodeSlash | EncodeLeftPeriod | EncodeRightSpace,
		in:   "． οxμ\x1bｍ｜␉ν␖ω|］ωσ\x10?０␈␏Y␔Ｚ\x1e?；e d",
		out:  "‛． οxμ\x1bｍ｜␉ν␖ω|］ωσ\x10?０␈␏Y␔Ｚ\x1e?；e d",
	}, { // 1278
		mask: EncodeSlash | EncodeLeftPeriod | EncodeRightSpace,
		in:   "\x17 οxμ\x1bｍ｜␉ν␖ω|］ωσ\x10?０␈␏Y␔Ｚ\x1e?；e .",
		out:  "\x17 οxμ\x1bｍ｜␉ν␖ω|］ωσ\x10?０␈␏Y␔Ｚ\x1e?；e .",
	}, { // 1279
		mask: EncodeSlash | EncodeLeftPeriod | EncodeRightSpace,
		in:   "\x17 οxμ\x1bｍ｜␉ν␖ω|］ωσ\x10?０␈␏Y␔Ｚ\x1e?；e ．",
		out:  "\x17 οxμ\x1bｍ｜␉ν␖ω|］ωσ\x10?０␈␏Y␔Ｚ\x1e?；e ．",
	}, { // 1280
		mask: EncodeSingleQuote | EncodeLeftPeriod | EncodeRightSpace,
		in:   ". 'ο:\x18\x1bnｅ4a␄\x00␛ｄ7(，/ｑ＜＊ｇＹO␕ζο θ",
		out:  "． ＇ο:\x18\x1bnｅ4a␄␀␛ｄ7(，/ｑ＜＊ｇＹO␕ζο θ",
	}, { // 1281
		mask: EncodeSingleQuote | EncodeLeftPeriod | EncodeRightSpace,
		in:   "． 'ο:\x18\x1bnｅ4a␄\x00␛ｄ7(，/ｑ＜＊ｇＹO␕ζο θ",
		out:  "‛． ＇ο:\x18\x1bnｅ4a␄␀␛ｄ7(，/ｑ＜＊ｇＹO␕ζο θ",
	}, { // 1282
		mask: EncodeSingleQuote | EncodeLeftPeriod | EncodeRightSpace,
		in:   "␀ 'ο:\x18\x1bnｅ4a␄\x00␛ｄ7(，/ｑ＜＊ｇＹO␕ζο .",
		out:  "‛␀ ＇ο:\x18\x1bnｅ4a␄␀␛ｄ7(，/ｑ＜＊ｇＹO␕ζο .",
	}, { // 1283
		mask: EncodeSingleQuote | EncodeLeftPeriod | EncodeRightSpace,
		in:   "␀ 'ο:\x18\x1bnｅ4a␄\x00␛ｄ7(，/ｑ＜＊ｇＹO␕ζο ．",
		out:  "‛␀ ＇ο:\x18\x1bnｅ4a␄␀␛ｄ7(，/ｑ＜＊ｇＹO␕ζο ．",
	}, { // 1284
		mask: EncodeBackQuote | EncodeLeftPeriod | EncodeRightSpace,
		in:   ". σＲ３β\u007f␌ｄω␈af8[zκ␕＂\x0e＞|U\x06＜\x04，υ p",
		out:  "． σＲ３β\u007f␌ｄω␈af8[zκ␕＂\x0e＞|U\x06＜\x04，υ p",
	}, { // 1285
		mask: EncodeBackQuote | EncodeLeftPeriod | EncodeRightSpace,
		in:   "． σＲ３β\u007f␌ｄω␈af8[zκ␕＂\x0e＞|U\x06＜\x04，υ p",
		out:  "‛． σＲ３β\u007f␌ｄω␈af8[zκ␕＂\x0e＞|U\x06＜\x04，υ p",
	}, { // 1286
		mask: EncodeBackQuote | EncodeLeftPeriod | EncodeRightSpace,
		in:   "␞ σＲ３β\u007f␌ｄω␈af8[zκ␕＂\x0e＞|U\x06＜\x04，υ .",
		out:  "␞ σＲ３β\u007f␌ｄω␈af8[zκ␕＂\x0e＞|U\x06＜\x04，υ .",
	}, { // 1287
		mask: EncodeBackQuote | EncodeLeftPeriod | EncodeRightSpace,
		in:   "␞ σＲ３β\u007f␌ｄω␈af8[zκ␕＂\x0e＞|U\x06＜\x04，υ ．",
		out:  "␞ σＲ３β\u007f␌ｄω␈af8[zκ␕＂\x0e＞|U\x06＜\x04，υ ．",
	}, { // 1288
		mask: EncodeLtGt | EncodeLeftPeriod | EncodeRightSpace,
		in:   ". ]␊＂wＫμκ８\tＷξ{Ｔ␀-:<ｚ␑\\Cς７o?␖ ψ",
		out:  "． ]␊＂wＫμκ８\tＷξ{Ｔ‛␀-:＜ｚ␑\\Cς７o?␖ ψ",
	}, { // 1289
		mask: EncodeLtGt | EncodeLeftPeriod | EncodeRightSpace,
		in:   "． ]␊＂wＫμκ８\tＷξ{Ｔ␀-:<ｚ␑\\Cς７o?␖ ψ",
		out:  "‛． ]␊＂wＫμκ８\tＷξ{Ｔ‛␀-:＜ｚ␑\\Cς７o?␖ ψ",
	}, { // 1290
		mask: EncodeLtGt | EncodeLeftPeriod | EncodeRightSpace,
		in:   "␍ ]␊＂wＫμκ８\tＷξ{Ｔ␀-:<ｚ␑\\Cς７o?␖ .",
		out:  "␍ ]␊＂wＫμκ８\tＷξ{Ｔ‛␀-:＜ｚ␑\\Cς７o?␖ .",
	}, { // 1291
		mask: EncodeLtGt | EncodeLeftPeriod | EncodeRightSpace,
		in:   "␍ ]␊＂wＫμκ８\tＷξ{Ｔ␀-:<ｚ␑\\Cς７o?␖ ．",
		out:  "␍ ]␊＂wＫμκ８\tＷξ{Ｔ‛␀-:＜ｚ␑\\Cς７o?␖ ．",
	}, { // 1292
		mask: EncodeSquareBracket | EncodeLeftPeriod | EncodeRightSpace,
		in:   ". κ␛/６X␀␓θ＇9q＞Ｂ\x18\x05\b／ν8ε\u007f\n＿V5σ ＜",
		out:  "． κ␛/６X‛␀␓θ＇9q＞Ｂ\x18\x05\b／ν8ε\u007f\n＿V5σ ＜",
	}, { // 1293
		mask: EncodeSquareBracket | EncodeLeftPeriod | EncodeRightSpace,
		in:   "． κ␛/６X␀␓θ＇9q＞Ｂ\x18\x05\b／ν8ε\u007f\n＿V5σ ＜",
		out:  "‛． κ␛/６X‛␀␓θ＇9q＞Ｂ\x18\x05\b／ν8ε\u007f\n＿V5σ ＜",
	}, { // 1294
		mask: EncodeSquareBracket | EncodeLeftPeriod | EncodeRightSpace,
		in:   "κ κ␛/６X␀␓θ＇9q＞Ｂ\x18\x05\b／ν8ε\u007f\n＿V5σ .",
		out:  "κ κ␛/６X‛␀␓θ＇9q＞Ｂ\x18\x05\b／ν8ε\u007f\n＿V5σ .",
	}, { // 1295
		mask: EncodeSquareBracket | EncodeLeftPeriod | EncodeRightSpace,
		in:   "κ κ␛/６X␀␓θ＇9q＞Ｂ\x18\x05\b／ν8ε\u007f\n＿V5σ ．",
		out:  "κ κ␛/６X‛␀␓θ＇9q＞Ｂ\x18\x05\b／ν8ε\u007f\n＿V5σ ．",
	}, { // 1296
		mask: EncodeSemicolon | EncodeLeftPeriod | EncodeRightSpace,
		in:   ". C␌ＲωＨ␉ｈ～１\x1eψ?␕Pς\x13p\x11\n\x1a.␄␄fψ\r ＂",
		out:  "． C␌ＲωＨ␉ｈ～１\x1eψ?␕Pς\x13p\x11\n\x1a.␄␄fψ\r ＂",
	}, { // 1297
		mask: EncodeSemicolon | EncodeLeftPeriod | EncodeRightSpace,
		in:   "． C␌ＲωＨ␉ｈ～１\x1eψ?␕Pς\x13p\x11\n\x1a.␄␄fψ\r ＂",
		out:  "‛． C␌ＲωＨ␉ｈ～１\x1eψ?␕Pς\x13p\x11\n\x1a.␄␄fψ\r ＂",
	}, { // 1298
		mask: EncodeSemicolon | EncodeLeftPeriod | EncodeRightSpace,
		in:   "ψ C␌ＲωＨ␉ｈ～１\x1eψ?␕Pς\x13p\x11\n\x1a.␄␄fψ\r .",
		out:  "ψ C␌ＲωＨ␉ｈ～１\x1eψ?␕Pς\x13p\x11\n\x1a.␄␄fψ\r .",
	}, { // 1299
		mask: EncodeSemicolon | EncodeLeftPeriod | EncodeRightSpace,
		in:   "ψ C␌ＲωＨ␉ｈ～１\x1eψ?␕Pς\x13p\x11\n\x1a.␄␄fψ\r ．",
		out:  "ψ C␌ＲωＨ␉ｈ～１\x1eψ?␕Pς\x13p\x11\n\x1a.␄␄fψ\r ．",
	}, { // 1300
		mask: EncodeDollar | EncodeLeftPeriod | EncodeRightSpace,
		in:   ". ＼␡␂␘＇φa\rj6J'ζsＱ>(ωｏ\x1dβ|␈\f４ｚ α",
		out:  "． ＼␡␂␘＇φa\rj6J'ζsＱ>(ωｏ\x1dβ|␈\f４ｚ α",
	}, { // 1301
		mask: EncodeDollar | EncodeLeftPeriod | EncodeRightSpace,
		in:   "． ＼␡␂␘＇φa\rj6J'ζsＱ>(ωｏ\x1dβ|␈\f４ｚ α",
		out:  "‛． ＼␡␂␘＇φa\rj6J'ζsＱ>(ωｏ\x1dβ|␈\f４ｚ α",
	}, { // 1302
		mask: EncodeDollar | EncodeLeftPeriod | EncodeRightSpace,
		in:   "␏ ＼␡␂␘＇φa\rj6J'ζsＱ>(ωｏ\x1dβ|␈\f４ｚ .",
		out:  "␏ ＼␡␂␘＇φa\rj6J'ζsＱ>(ωｏ\x1dβ|␈\f４ｚ .",
	}, { // 1303
		mask: EncodeDollar | EncodeLeftPeriod | EncodeRightSpace,
		in:   "␏ ＼␡␂␘＇φa\rj6J'ζsＱ>(ωｏ\x1dβ|␈\f４ｚ ．",
		out:  "␏ ＼␡␂␘＇φa\rj6J'ζsＱ>(ωｏ\x1dβ|␈\f４ｚ ．",
	}, { // 1304
		mask: EncodeDoubleQuote | EncodeLeftPeriod | EncodeRightSpace,
		in:   ". ['ξτ２τ␌␁μεm␈\\XＤ␌=６\x18\x19ω␊\x02\x00K０ Ｓ",
		out:  "． ['ξτ２τ␌␁μεm␈\\XＤ␌=６\x18\x19ω␊\x02␀K０ Ｓ",
	}, { // 1305
		mask: EncodeDoubleQuote | EncodeLeftPeriod | EncodeRightSpace,
		in:   "． ['ξτ２τ␌␁μεm␈\\XＤ␌=６\x18\x19ω␊\x02\x00K０ Ｓ",
		out:  "‛． ['ξτ２τ␌␁μεm␈\\XＤ␌=６\x18\x19ω␊\x02␀K０ Ｓ",
	}, { // 1306
		mask: EncodeDoubleQuote | EncodeLeftPeriod | EncodeRightSpace,
		in:   "␊ ['ξτ２τ␌␁μεm␈\\XＤ␌=６\x18\x19ω␊\x02\x00K０ .",
		out:  "␊ ['ξτ２τ␌␁μεm␈\\XＤ␌=６\x18\x19ω␊\x02␀K０ .",
	}, { // 1307
		mask: EncodeDoubleQuote | EncodeLeftPeriod | EncodeRightSpace,
		in:   "␊ ['ξτ２τ␌␁μεm␈\\XＤ␌=６\x18\x19ω␊\x02\x00K０ ．",
		out:  "␊ ['ξτ２τ␌␁μεm␈\\XＤ␌=６\x18\x19ω␊\x02␀K０ ．",
	}, { // 1308
		mask: EncodeColon | EncodeLeftPeriod | EncodeRightSpace,
		in:   ". ～\n'<C␋|\x16␟／μ\r!Ｙδ｀ζ␛VζJη␊Ｒ\uff00{ ς",
		out:  "． ～\n'<C␋|\x16␟／μ\r!Ｙδ｀ζ␛VζJη␊Ｒ\uff00{ ς",
	}, { // 1309
		mask: EncodeColon | EncodeLeftPeriod | EncodeRightSpace,
		in:   "． ～\n'<C␋|\x16␟／μ\r!Ｙδ｀ζ␛VζJη␊Ｒ\uff00{ ς",
		out:  "‛． ～\n'<C␋|\x16␟／μ\r!Ｙδ｀ζ␛VζJη␊Ｒ\uff00{ ς",
	}, { // 1310
		mask: EncodeColon | EncodeLeftPeriod | EncodeRightSpace,
		in:   "～ ～\n'<C␋|\x16␟／μ\r!Ｙδ｀ζ␛VζJη␊Ｒ\uff00{ .",
		out:  "～ ～\n'<C␋|\x16␟／μ\r!Ｙδ｀ζ␛VζJη␊Ｒ\uff00{ .",
	}, { // 1311
		mask: EncodeColon | EncodeLeftPeriod | EncodeRightSpace,
		in:   "～ ～\n'<C␋|\x16␟／μ\r!Ｙδ｀ζ␛VζJη␊Ｒ\uff00{ ．",
		out:  "～ ～\n'<C␋|\x16␟／μ\r!Ｙδ｀ζ␛VζJη␊Ｒ\uff00{ ．",
	}, { // 1312
		mask: EncodeQuestion | EncodeLeftPeriod | EncodeRightSpace,
		in:   ". ␆χｌ␐υ]ｏj␆）<πoζ␑:Ｉαη\r␈?ａ?␐\x19 \"",
		out:  "． ␆χｌ␐υ]ｏj␆）<πoζ␑:Ｉαη\r␈？ａ？␐\x19 \"",
	}, { // 1313
		mask: EncodeQuestion | EncodeLeftPeriod | EncodeRightSpace,
		in:   "． ␆χｌ␐υ]ｏj␆）<πoζ␑:Ｉαη\r␈?ａ?␐\x19 \"",
		out:  "‛． ␆χｌ␐υ]ｏj␆）<πoζ␑:Ｉαη\r␈？ａ？␐\x19 \"",
	}, { // 1314
		mask: EncodeQuestion | EncodeLeftPeriod | EncodeRightSpace,
		in:   "Ｍ ␆χｌ␐υ]ｏj␆）<πoζ␑:Ｉαη\r␈?ａ?␐\x19 .",
		out:  "Ｍ ␆χｌ␐υ]ｏj␆）<πoζ␑:Ｉαη\r␈？ａ？␐\x19 .",
	}, { // 1315
		mask: EncodeQuestion | EncodeLeftPeriod | EncodeRightSpace,
		in:   "Ｍ ␆χｌ␐υ]ｏj␆）<πoζ␑:Ｉαη\r␈?ａ?␐\x19 ．",
		out:  "Ｍ ␆χｌ␐υ]ｏj␆）<πoζ␑:Ｉαη\r␈？ａ？␐\x19 ．",
	}, { // 1316
		mask: EncodeAsterisk | EncodeLeftPeriod | EncodeRightSpace,
		in:   ". ␈π\nγ＠w␅%␗*]ρ\x13\x04F＂␀\x17ｖθ／／：.zu ν",
		out:  "． ␈π\nγ＠w␅%␗＊]ρ\x13\x04F＂‛␀\x17ｖθ／／：.zu ν",
	}, { // 1317
		mask: EncodeAsterisk | EncodeLeftPeriod | EncodeRightSpace,
		in:   "． ␈π\nγ＠w␅%␗*]ρ\x13\x04F＂␀\x17ｖθ／／：.zu ν",
		out:  "‛． ␈π\nγ＠w␅%␗＊]ρ\x13\x04F＂‛␀\x17ｖθ／／：.zu ν",
	}, { // 1318
		mask: EncodeAsterisk | EncodeLeftPeriod | EncodeRightSpace,
		in:   "４ ␈π\nγ＠w␅%␗*]ρ\x13\x04F＂␀\x17ｖθ／／：.zu .",
		out:  "４ ␈π\nγ＠w␅%␗＊]ρ\x13\x04F＂‛␀\x17ｖθ／／：.zu .",
	}, { // 1319
		mask: EncodeAsterisk | EncodeLeftPeriod | EncodeRightSpace,
		in:   "４ ␈π\nγ＠w␅%␗*]ρ\x13\x04F＂␀\x17ｖθ／／：.zu ．",
		out:  "４ ␈π\nγ＠w␅%␗＊]ρ\x13\x04F＂‛␀\x17ｖθ／／：.zu ．",
	}, { // 1320
		mask: EncodePipe | EncodeLeftPeriod | EncodeRightSpace,
		in:   ". ；\x14＝π／\x19ρδ｜\x10Ｂg␗W\n\uff00␈β＇oｓ>\"eζ\x10 ε",
		out:  "． ；\x14＝π／\x19ρδ‛｜\x10Ｂg␗W\n\uff00␈β＇oｓ>\"eζ\x10 ε",
	}, { // 1321
		mask: EncodePipe | EncodeLeftPeriod | EncodeRightSpace,
		in:   "． ；\x14＝π／\x19ρδ｜\x10Ｂg␗W\n\uff00␈β＇oｓ>\"eζ\x10 ε",
		out:  "‛． ；\x14＝π／\x19ρδ‛｜\x10Ｂg␗W\n\uff00␈β＇oｓ>\"eζ\x10 ε",
	}, { // 1322
		mask: EncodePipe | EncodeLeftPeriod | EncodeRightSpace,
		in:   "␏ ；\x14＝π／\x19ρδ｜\x10Ｂg␗W\n\uff00␈β＇oｓ>\"eζ\x10 .",
		out:  "␏ ；\x14＝π／\x19ρδ‛｜\x10Ｂg␗W\n\uff00␈β＇oｓ>\"eζ\x10 .",
	}, { // 1323
		mask: EncodePipe | EncodeLeftPeriod | EncodeRightSpace,
		in:   "␏ ；\x14＝π／\x19ρδ｜\x10Ｂg␗W\n\uff00␈β＇oｓ>\"eζ\x10 ．",
		out:  "␏ ；\x14＝π／\x19ρδ‛｜\x10Ｂg␗W\n\uff00␈β＇oｓ>\"eζ\x10 ．",
	}, { // 1324
		mask: EncodeHash | EncodeLeftPeriod | EncodeRightSpace,
		in:   ". ␍+２\x1c？～χυ␖␝\x16ψμ\"2＊+[Ｓ^?＊\x19␖ζ+ ｚ",
		out:  "． ␍+２\x1c？～χυ␖␝\x16ψμ\"2＊+[Ｓ^?＊\x19␖ζ+ ｚ",
	}, { // 1325
		mask: EncodeHash | EncodeLeftPeriod | EncodeRightSpace,
		in:   "． ␍+２\x1c？～χυ␖␝\x16ψμ\"2＊+[Ｓ^?＊\x19␖ζ+ ｚ",
		out:  "‛． ␍+２\x1c？～χυ␖␝\x16ψμ\"2＊+[Ｓ^?＊\x19␖ζ+ ｚ",
	}, { // 1326
		mask: EncodeHash | EncodeLeftPeriod | EncodeRightSpace,
		in:   "ν ␍+２\x1c？～χυ␖␝\x16ψμ\"2＊+[Ｓ^?＊\x19␖ζ+ .",
		out:  "ν ␍+２\x1c？～χυ␖␝\x16ψμ\"2＊+[Ｓ^?＊\x19␖ζ+ .",
	}, { // 1327
		mask: EncodeHash | EncodeLeftPeriod | EncodeRightSpace,
		in:   "ν ␍+２\x1c？～χυ␖␝\x16ψμ\"2＊+[Ｓ^?＊\x19␖ζ+ ．",
		out:  "ν ␍+２\x1c？～χυ␖␝\x16ψμ\"2＊+[Ｓ^?＊\x19␖ζ+ ．",
	}, { // 1328
		mask: EncodePercent | EncodeLeftPeriod | EncodeRightSpace,
		in:   ". [␗\azς$␔ｌχ␍␆＼\x048φｕＷ\x1a4#／ξ\x1d␀ic π",
		out:  "． [␗\azς$␔ｌχ␍␆＼\x048φｕＷ\x1a4#／ξ\x1d‛␀ic π",
	}, { // 1329
		mask: EncodePercent | EncodeLeftPeriod | EncodeRightSpace,
		in:   "． [␗\azς$␔ｌχ␍␆＼\x048φｕＷ\x1a4#／ξ\x1d␀ic π",
		out:  "‛． [␗\azς$␔ｌχ␍␆＼\x048φｕＷ\x1a4#／ξ\x1d‛␀ic π",
	}, { // 1330
		mask: EncodePercent | EncodeLeftPeriod | EncodeRightSpace,
		in:   "ｅ [␗\azς$␔ｌχ␍␆＼\x048φｕＷ\x1a4#／ξ\x1d␀ic .",
		out:  "ｅ [␗\azς$␔ｌχ␍␆＼\x048φｕＷ\x1a4#／ξ\x1d‛␀ic .",
	}, { // 1331
		mask: EncodePercent | EncodeLeftPeriod | EncodeRightSpace,
		in:   "ｅ [␗\azς$␔ｌχ␍␆＼\x048φｕＷ\x1a4#／ξ\x1d␀ic ．",
		out:  "ｅ [␗\azς$␔ｌχ␍␆＼\x048φｕＷ\x1a4#／ξ\x1d‛␀ic ．",
	}, { // 1332
		mask: EncodeBackSlash | EncodeLeftPeriod | EncodeRightSpace,
		in:   ". Ｙｊ␀ｃ\rφWη\x19B\v␅␅｛7ｊ(%␌Pρ␘ξ?κｃ \x0f",
		out:  "． Ｙｊ‛␀ｃ\rφWη\x19B\v␅␅｛7ｊ(%␌Pρ␘ξ?κｃ \x0f",
	}, { // 1333
		mask: EncodeBackSlash | EncodeLeftPeriod | EncodeRightSpace,
		in:   "． Ｙｊ␀ｃ\rφWη\x19B\v␅␅｛7ｊ(%␌Pρ␘ξ?κｃ \x0f",
		out:  "‛． Ｙｊ‛␀ｃ\rφWη\x19B\v␅␅｛7ｊ(%␌Pρ␘ξ?κｃ \x0f",
	}, { // 1334
		mask: EncodeBackSlash | EncodeLeftPeriod | EncodeRightSpace,
		in:   "␅ Ｙｊ␀ｃ\rφWη\x19B\v␅␅｛7ｊ(%␌Pρ␘ξ?κｃ .",
		out:  "␅ Ｙｊ‛␀ｃ\rφWη\x19B\v␅␅｛7ｊ(%␌Pρ␘ξ?κｃ .",
	}, { // 1335
		mask: EncodeBackSlash | EncodeLeftPeriod | EncodeRightSpace,
		in:   "␅ Ｙｊ␀ｃ\rφWη\x19B\v␅␅｛7ｊ(%␌Pρ␘ξ?κｃ ．",
		out:  "␅ Ｙｊ‛␀ｃ\rφWη\x19B\v␅␅｛7ｊ(%␌Pρ␘ξ?κｃ ．",
	}, { // 1336
		mask: EncodeCrLf | EncodeLeftPeriod | EncodeRightSpace,
		in:   ". ｛＇＇[i␖␇τ：\n\x00nξ<(φ$F␡\x1b␙／Hｍθ\a ＂",
		out:  "． ｛＇＇[i␖␇τ：␊␀nξ<(φ$F␡\x1b␙／Hｍθ\a ＂",
	}, { // 1337
		mask: EncodeCrLf | EncodeLeftPeriod | EncodeRightSpace,
		in:   "． ｛＇＇[i␖␇τ：\n\x00nξ<(φ$F␡\x1b␙／Hｍθ\a ＂",
		out:  "‛． ｛＇＇[i␖␇τ：␊␀nξ<(φ$F␡\x1b␙／Hｍθ\a ＂",
	}, { // 1338
		mask: EncodeCrLf | EncodeLeftPeriod | EncodeRightSpace,
		in:   "Ｎ ｛＇＇[i␖␇τ：\n\x00nξ<(φ$F␡\x1b␙／Hｍθ\a .",
		out:  "Ｎ ｛＇＇[i␖␇τ：␊␀nξ<(φ$F␡\x1b␙／Hｍθ\a .",
	}, { // 1339
		mask: EncodeCrLf | EncodeLeftPeriod | EncodeRightSpace,
		in:   "Ｎ ｛＇＇[i␖␇τ：\n\x00nξ<(φ$F␡\x1b␙／Hｍθ\a ．",
		out:  "Ｎ ｛＇＇[i␖␇τ：␊␀nξ<(φ$F␡\x1b␙／Hｍθ\a ．",
	}, { // 1340
		mask: EncodeDel | EncodeLeftPeriod | EncodeRightSpace,
		in:   ". *Ｍ␃%οＱ＇␀␚ψ␂８ＭG％MFο\x04␔τ［\f&\x13\x1e θ",
		out:  "． *Ｍ␃%οＱ＇‛␀␚ψ␂８ＭG％MFο\x04␔τ［\f&\x13\x1e θ",
	}, { // 1341
		mask: EncodeDel | EncodeLeftPeriod | EncodeRightSpace,
		in:   "． *Ｍ␃%οＱ＇␀␚ψ␂８ＭG％MFο\x04␔τ［\f&\x13\x1e θ",
		out:  "‛． *Ｍ␃%οＱ＇‛␀␚ψ␂８ＭG％MFο\x04␔τ［\f&\x13\x1e θ",
	}, { // 1342
		mask: EncodeDel | EncodeLeftPeriod | EncodeRightSpace,
		in:   "ζ *Ｍ␃%οＱ＇␀␚ψ␂８ＭG％MFο\x04␔τ［\f&\x13\x1e .",
		out:  "ζ *Ｍ␃%οＱ＇‛␀␚ψ␂８ＭG％MFο\x04␔τ［\f&\x13\x1e .",
	}, { // 1343
		mask: EncodeDel | EncodeLeftPeriod | EncodeRightSpace,
		in:   "ζ *Ｍ␃%οＱ＇␀␚ψ␂８ＭG％MFο\x04␔τ［\f&\x13\x1e ．",
		out:  "ζ *Ｍ␃%οＱ＇‛␀␚ψ␂８ＭG％MFο\x04␔τ［\f&\x13\x1e ．",
	}, { // 1344
		mask: EncodeCtl | EncodeLeftPeriod | EncodeRightSpace,
		in:   ". ␛␋~\t\nＵωｋ＾ρ\n\nV␞}ν|σα␓κyＫ\x01Ｕ\uff00 ␍",
		out:  "． ‛␛‛␋~␉␊Ｕωｋ＾ρ␊␊V‛␞}ν|σα‛␓κyＫ␁Ｕ\uff00 ‛␍",
	}, { // 1345
		mask: EncodeCtl | EncodeLeftPeriod | EncodeRightSpace,
		in:   "． ␛␋~\t\nＵωｋ＾ρ\n\nV␞}ν|σα␓κyＫ\x01Ｕ\uff00 ␍",
		out:  "‛． ‛␛‛␋~␉␊Ｕωｋ＾ρ␊␊V‛␞}ν|σα‛␓κyＫ␁Ｕ\uff00 ‛␍",
	}, { // 1346
		mask: EncodeCtl | EncodeLeftPeriod | EncodeRightSpace,
		in:   "␘ ␛␋~\t\nＵωｋ＾ρ\n\nV␞}ν|σα␓κyＫ\x01Ｕ\uff00 .",
		out:  "‛␘ ‛␛‛␋~␉␊Ｕωｋ＾ρ␊␊V‛␞}ν|σα‛␓κyＫ␁Ｕ\uff00 .",
	}, { // 1347
		mask: EncodeCtl | EncodeLeftPeriod | EncodeRightSpace,
		in:   "␘ ␛␋~\t\nＵωｋ＾ρ\n\nV␞}ν|σα␓κyＫ\x01Ｕ\uff00 ．",
		out:  "‛␘ ‛␛‛␋~␉␊Ｕωｋ＾ρ␊␊V‛␞}ν|σα‛␓κyＫ␁Ｕ\uff00 ．",
	}, { // 1348
		mask: EncodeZero | EncodeLeftPeriod | EncodeRightPeriod,
		in:   "..λＫ%\x04␐\x15νｓ%α␅␖<␖\uff00Ｘ␟S５\x12f｀οＣyθ.\x00",
		out:  "．.λＫ%\x04␐\x15νｓ%α␅␖<␖\uff00Ｘ␟S５\x12f｀οＣyθ.␀",
	}, { // 1349
		mask: EncodeZero | EncodeLeftPeriod | EncodeRightPeriod,
		in:   "．.λＫ%\x04␐\x15νｓ%α␅␖<␖\uff00Ｘ␟S５\x12f｀οＣyθ.\x00",
		out:  "‛．.λＫ%\x04␐\x15νｓ%α␅␖<␖\uff00Ｘ␟S５\x12f｀οＣyθ.␀",
	}, { // 1350
		mask: EncodeZero | EncodeLeftPeriod | EncodeRightPeriod,
		in:   "9.λＫ%\x04␐\x15νｓ%α␅␖<␖\uff00Ｘ␟S５\x12f｀οＣyθ..",
		out:  "9.λＫ%\x04␐\x15νｓ%α␅␖<␖\uff00Ｘ␟S５\x12f｀οＣyθ.．",
	}, { // 1351
		mask: EncodeZero | EncodeLeftPeriod | EncodeRightPeriod,
		in:   "9.λＫ%\x04␐\x15νｓ%α␅␖<␖\uff00Ｘ␟S５\x12f｀οＣyθ.．",
		out:  "9.λＫ%\x04␐\x15νｓ%α␅␖<␖\uff00Ｘ␟S５\x12f｀οＣyθ.‛．",
	}, { // 1352
		mask: EncodeSlash | EncodeLeftPeriod | EncodeRightPeriod,
		in:   "..４\x1e［\x1d\x12\bλC｝1␓；［␗εＥｙ␈␏ω；\u007fυ+Pς._",
		out:  "．.４\x1e［\x1d\x12\bλC｝1␓；［␗εＥｙ␈␏ω；\u007fυ+Pς._",
	}, { // 1353
		mask: EncodeSlash | EncodeLeftPeriod | EncodeRightPeriod,
		in:   "．.４\x1e［\x1d\x12\bλC｝1␓；［␗εＥｙ␈␏ω；\u007fυ+Pς._",
		out:  "‛．.４\x1e［\x1d\x12\bλC｝1␓；［␗εＥｙ␈␏ω；\u007fυ+Pς._",
	}, { // 1354
		mask: EncodeSlash | EncodeLeftPeriod | EncodeRightPeriod,
		in:   "α.４\x1e［\x1d\x12\bλC｝1␓；［␗εＥｙ␈␏ω；\u007fυ+Pς..",
		out:  "α.４\x1e［\x1d\x12\bλC｝1␓；［␗εＥｙ␈␏ω；\u007fυ+Pς.．",
	}, { // 1355
		mask: EncodeSlash | EncodeLeftPeriod | EncodeRightPeriod,
		in:   "α.４\x1e［\x1d\x12\bλC｝1␓；［␗εＥｙ␈␏ω；\u007fυ+Pς.．",
		out:  "α.４\x1e［\x1d\x12\bλC｝1␓；［␗εＥｙ␈␏ω；\u007fυ+Pς.‛．",
	}, { // 1356
		mask: EncodeSingleQuote | EncodeLeftPeriod | EncodeRightPeriod,
		in:   "..F␄χQ\x14␚Ｌ]␉ιρ\x0fζ{Ｚ\x04ｏ＂％␂␙QςＲ\x18ｏ.3",
		out:  "．.F␄χQ\x14␚Ｌ]␉ιρ\x0fζ{Ｚ\x04ｏ＂％␂␙QςＲ\x18ｏ.3",
	}, { // 1357
		mask: EncodeSingleQuote | EncodeLeftPeriod | EncodeRightPeriod,
		in:   "．.F␄χQ\x14␚Ｌ]␉ιρ\x0fζ{Ｚ\x04ｏ＂％␂␙QςＲ\x18ｏ.3",
		out:  "‛．.F␄χQ\x14␚Ｌ]␉ιρ\x0fζ{Ｚ\x04ｏ＂％␂␙QςＲ\x18ｏ.3",
	}, { // 1358
		mask: EncodeSingleQuote | EncodeLeftPeriod | EncodeRightPeriod,
		in:   "ι.F␄χQ\x14␚Ｌ]␉ιρ\x0fζ{Ｚ\x04ｏ＂％␂␙QςＲ\x18ｏ..",
		out:  "ι.F␄χQ\x14␚Ｌ]␉ιρ\x0fζ{Ｚ\x04ｏ＂％␂␙QςＲ\x18ｏ.．",
	}, { // 1359
		mask: EncodeSingleQuote | EncodeLeftPeriod | EncodeRightPeriod,
		in:   "ι.F␄χQ\x14␚Ｌ]␉ιρ\x0fζ{Ｚ\x04ｏ＂％␂␙QςＲ\x18ｏ.．",
		out:  "ι.F␄χQ\x14␚Ｌ]␉ιρ\x0fζ{Ｚ\x04ｏ＂％␂␙QςＲ\x18ｏ.‛．",
	}, { // 1360
		mask: EncodeBackQuote | EncodeLeftPeriod | EncodeRightPeriod,
		in:   "..[\x12πS２＞\x13_θιｘ␊␍$］\f␡[２ηψ9K␏α＜.＇",
		out:  "．.[\x12πS２＞\x13_θιｘ␊␍$］\f␡[２ηψ9K␏α＜.＇",
	}, { // 1361
		mask: EncodeBackQuote | EncodeLeftPeriod | EncodeRightPeriod,
		in:   "．.[\x12πS２＞\x13_θιｘ␊␍$］\f␡[２ηψ9K␏α＜.＇",
		out:  "‛．.[\x12πS２＞\x13_θιｘ␊␍$］\f␡[２ηψ9K␏α＜.＇",
	}, { // 1362
		mask: EncodeBackQuote | EncodeLeftPeriod | EncodeRightPeriod,
		in:   "M.[\x12πS２＞\x13_θιｘ␊␍$］\f␡[２ηψ9K␏α＜..",
		out:  "M.[\x12πS２＞\x13_θιｘ␊␍$］\f␡[２ηψ9K␏α＜.．",
	}, { // 1363
		mask: EncodeBackQuote | EncodeLeftPeriod | EncodeRightPeriod,
		in:   "M.[\x12πS２＞\x13_θιｘ␊␍$］\f␡[２ηψ9K␏α＜.．",
		out:  "M.[\x12πS２＞\x13_θιｘ␊␍$］\f␡[２ηψ9K␏α＜.‛．",
	}, { // 1364
		mask: EncodeLtGt | EncodeLeftPeriod | EncodeRightPeriod,
		in:   "..υ｜)δ＂\r␡κ␡ｊoμ>＞U［s/｛！６\x01 #βｏ.／",
		out:  "．.υ｜)δ＂\r␡κ␡ｊoμ＞‛＞U［s/｛！６\x01 #βｏ.／",
	}, { // 1365
		mask: EncodeLtGt | EncodeLeftPeriod | EncodeRightPeriod,
		in:   "．.υ｜)δ＂\r␡κ␡ｊoμ>＞U［s/｛！６\x01 #βｏ.／",
		out:  "‛．.υ｜)δ＂\r␡κ␡ｊoμ＞‛＞U［s/｛！６\x01 #βｏ.／",
	}, { // 1366
		mask: EncodeLtGt | EncodeLeftPeriod | EncodeRightPeriod,
		in:   "ρ.υ｜)δ＂\r␡κ␡ｊoμ>＞U［s/｛！６\x01 #βｏ..",
		out:  "ρ.υ｜)δ＂\r␡κ␡ｊoμ＞‛＞U［s/｛！６\x01 #βｏ.．",
	}, { // 1367
		mask: EncodeLtGt | EncodeLeftPeriod | EncodeRightPeriod,
		in:   "ρ.υ｜)δ＂\r␡κ␡ｊoμ>＞U［s/｛！６\x01 #βｏ.．",
		out:  "ρ.υ｜)δ＂\r␡κ␡ｊoμ＞‛＞U［s/｛！６\x01 #βｏ.‛．",
	}, { // 1368
		mask: EncodeSquareBracket | EncodeLeftPeriod | EncodeRightPeriod,
		in:   "..Y`u＂δＤρ\\Ｖ␖δ␃｝＄?f+JＵ｀␡κ\x10\x1dvφ.？",
		out:  "．.Y`u＂δＤρ\\Ｖ␖δ␃｝＄?f+JＵ｀␡κ\x10\x1dvφ.？",
	}, { // 1369
		mask: EncodeSquareBracket | EncodeLeftPeriod | EncodeRightPeriod,
		in:   "．.Y`u＂δＤρ\\Ｖ␖δ␃｝＄?f+JＵ｀␡κ\x10\x1dvφ.？",
		out:  "‛．.Y`u＂δＤρ\\Ｖ␖δ␃｝＄?f+JＵ｀␡κ\x10\x1dvφ.？",
	}, { // 1370
		mask: EncodeSquareBracket | EncodeLeftPeriod | EncodeRightPeriod,
		in:   "[.Y`u＂δＤρ\\Ｖ␖δ␃｝＄?f+JＵ｀␡κ\x10\x1dvφ..",
		out:  "［.Y`u＂δＤρ\\Ｖ␖δ␃｝＄?f+JＵ｀␡κ\x10\x1dvφ.．",
	}, { // 1371
		mask: EncodeSquareBracket | EncodeLeftPeriod | EncodeRightPeriod,
		in:   "[.Y`u＂δＤρ\\Ｖ␖δ␃｝＄?f+JＵ｀␡κ\x10\x1dvφ.．",
		out:  "［.Y`u＂δＤρ\\Ｖ␖δ␃｝＄?f+JＵ｀␡κ\x10\x1dvφ.‛．",
	}, { // 1372
		mask: EncodeSemicolon | EncodeLeftPeriod | EncodeRightPeriod,
		in:   "..\tｄρ␄g␈\x12␋μπU!␕ｘ<δφ$／-［:\x18ＪＨ｝.η",
		out:  "．.\tｄρ␄g␈\x12␋μπU!␕ｘ<δφ$／-［:\x18ＪＨ｝.η",
	}, { // 1373
		mask: EncodeSemicolon | EncodeLeftPeriod | EncodeRightPeriod,
		in:   "．.\tｄρ␄g␈\x12␋μπU!␕ｘ<δφ$／-［:\x18ＪＨ｝.η",
		out:  "‛．.\tｄρ␄g␈\x12␋μπU!␕ｘ<δφ$／-［:\x18ＪＨ｝.η",
	}, { // 1374
		mask: EncodeSemicolon | EncodeLeftPeriod | EncodeRightPeriod,
		in:   "(.\tｄρ␄g␈\x12␋μπU!␕ｘ<δφ$／-［:\x18ＪＨ｝..",
		out:  "(.\tｄρ␄g␈\x12␋μπU!␕ｘ<δφ$／-［:\x18ＪＨ｝.．",
	}, { // 1375
		mask: EncodeSemicolon | EncodeLeftPeriod | EncodeRightPeriod,
		in:   "(.\tｄρ␄g␈\x12␋μπU!␕ｘ<δφ$／-［:\x18ＪＨ｝.．",
		out:  "(.\tｄρ␄g␈\x12␋μπU!␕ｘ<δφ$／-［:\x18ＪＨ｝.‛．",
	}, { // 1376
		mask: EncodeDollar | EncodeLeftPeriod | EncodeRightPeriod,
		in:   "..#＝σｙk（０＼\x0f\x0fυ␀␒τ\rYθχsｄ␀\x14$%|␁.ι",
		out:  "．.#＝σｙk（０＼\x0f\x0fυ‛␀␒τ\rYθχsｄ‛␀\x14＄%|␁.ι",
	}, { // 1377
		mask: EncodeDollar | EncodeLeftPeriod | EncodeRightPeriod,
		in:   "．.#＝σｙk（０＼\x0f\x0fυ␀␒τ\rYθχsｄ␀\x14$%|␁.ι",
		out:  "‛．.#＝σｙk（０＼\x0f\x0fυ‛␀␒τ\rYθχsｄ‛␀\x14＄%|␁.ι",
	}, { // 1378
		mask: EncodeDollar | EncodeLeftPeriod | EncodeRightPeriod,
		in:   "ｓ.#＝σｙk（０＼\x0f\x0fυ␀␒τ\rYθχsｄ␀\x14$%|␁..",
		out:  "ｓ.#＝σｙk（０＼\x0f\x0fυ‛␀␒τ\rYθχsｄ‛␀\x14＄%|␁.．",
	}, { // 1379
		mask: EncodeDollar | EncodeLeftPeriod | EncodeRightPeriod,
		in:   "ｓ.#＝σｙk（０＼\x0f\x0fυ␀␒τ\rYθχsｄ␀\x14$%|␁.．",
		out:  "ｓ.#＝σｙk（０＼\x0f\x0fυ‛␀␒τ\rYθχsｄ‛␀\x14＄%|␁.‛．",
	}, { // 1380
		mask: EncodeDoubleQuote | EncodeLeftPeriod | EncodeRightPeriod,
		in:   "..␆␑ＯPω\x02*τ␛␝I/W\x0f/πε@Ｉ~Ｂ␚－／Uφ.ξ",
		out:  "．.␆␑ＯPω\x02*τ␛␝I/W\x0f/πε@Ｉ~Ｂ␚－／Uφ.ξ",
	}, { // 1381
		mask: EncodeDoubleQuote | EncodeLeftPeriod | EncodeRightPeriod,
		in:   "．.␆␑ＯPω\x02*τ␛␝I/W\x0f/πε@Ｉ~Ｂ␚－／Uφ.ξ",
		out:  "‛．.␆␑ＯPω\x02*τ␛␝I/W\x0f/πε@Ｉ~Ｂ␚－／Uφ.ξ",
	}, { // 1382
		mask: EncodeDoubleQuote | EncodeLeftPeriod | EncodeRightPeriod,
		in:   "␈.␆␑ＯPω\x02*τ␛␝I/W\x0f/πε@Ｉ~Ｂ␚－／Uφ..",
		out:  "␈.␆␑ＯPω\x02*τ␛␝I/W\x0f/πε@Ｉ~Ｂ␚－／Uφ.．",
	}, { // 1383
		mask: EncodeDoubleQuote | EncodeLeftPeriod | EncodeRightPeriod,
		in:   "␈.␆␑ＯPω\x02*τ␛␝I/W\x0f/πε@Ｉ~Ｂ␚－／Uφ.．",
		out:  "␈.␆␑ＯPω\x02*τ␛␝I/W\x0f/πε@Ｉ~Ｂ␚－／Uφ.‛．",
	}, { // 1384
		mask: EncodeColon | EncodeLeftPeriod | EncodeRightPeriod,
		in:   "..\u007f␒.$＼<δ｀δＢOＡ␛␊\aＥmθＴ␝\x17ε[ω\x1bλ.3",
		out:  "．.\u007f␒.$＼<δ｀δＢOＡ␛␊\aＥmθＴ␝\x17ε[ω\x1bλ.3",
	}, { // 1385
		mask: EncodeColon | EncodeLeftPeriod | EncodeRightPeriod,
		in:   "．.\u007f␒.$＼<δ｀δＢOＡ␛␊\aＥmθＴ␝\x17ε[ω\x1bλ.3",
		out:  "‛．.\u007f␒.$＼<δ｀δＢOＡ␛␊\aＥmθＴ␝\x17ε[ω\x1bλ.3",
	}, { // 1386
		mask: EncodeColon | EncodeLeftPeriod | EncodeRightPeriod,
		in:   "：.\u007f␒.$＼<δ｀δＢOＡ␛␊\aＥmθＴ␝\x17ε[ω\x1bλ..",
		out:  "‛：.\u007f␒.$＼<δ｀δＢOＡ␛␊\aＥmθＴ␝\x17ε[ω\x1bλ.．",
	}, { // 1387
		mask: EncodeColon | EncodeLeftPeriod | EncodeRightPeriod,
		in:   "：.\u007f␒.$＼<δ｀δＢOＡ␛␊\aＥmθＴ␝\x17ε[ω\x1bλ.．",
		out:  "‛：.\u007f␒.$＼<δ｀δＢOＡ␛␊\aＥmθＴ␝\x17ε[ω\x1bλ.‛．",
	}, { // 1388
		mask: EncodeQuestion | EncodeLeftPeriod | EncodeRightPeriod,
		in:   "..ｈ\bb3\x00 νυ␟␊6␡␚ｖν＜\x1cρ]␈\x1b＄\\９Ｚ'.ι",
		out:  "．.ｈ\bb3␀ νυ␟␊6␡␚ｖν＜\x1cρ]␈\x1b＄\\９Ｚ'.ι",
	}, { // 1389
		mask: EncodeQuestion | EncodeLeftPeriod | EncodeRightPeriod,
		in:   "．.ｈ\bb3\x00 νυ␟␊6␡␚ｖν＜\x1cρ]␈\x1b＄\\９Ｚ'.ι",
		out:  "‛．.ｈ\bb3␀ νυ␟␊6␡␚ｖν＜\x1cρ]␈\x1b＄\\９Ｚ'.ι",
	}, { // 1390
		mask: EncodeQuestion | EncodeLeftPeriod | EncodeRightPeriod,
		in:   "M.ｈ\bb3\x00 νυ␟␊6␡␚ｖν＜\x1cρ]␈\x1b＄\\９Ｚ'..",
		out:  "M.ｈ\bb3␀ νυ␟␊6␡␚ｖν＜\x1cρ]␈\x1b＄\\９Ｚ'.．",
	}, { // 1391
		mask: EncodeQuestion | EncodeLeftPeriod | EncodeRightPeriod,
		in:   "M.ｈ\bb3\x00 νυ␟␊6␡␚ｖν＜\x1cρ]␈\x1b＄\\９Ｚ'.．",
		out:  "M.ｈ\bb3␀ νυ␟␊6␡␚ｖν＜\x1cρ]␈\x1b＄\\９Ｚ'.‛．",
	}, { // 1392
		mask: EncodeAsterisk | EncodeLeftPeriod | EncodeRightPeriod,
		in:   "..#\x13＼ςyｕλ\x0f７７｜η\f{␗␑ς$９ζπｖ：␘j\b.>",
		out:  "．.#\x13＼ςyｕλ\x0f７７｜η\f{␗␑ς$９ζπｖ：␘j\b.>",
	}, { // 1393
		mask: EncodeAsterisk | EncodeLeftPeriod | EncodeRightPeriod,
		in:   "．.#\x13＼ςyｕλ\x0f７７｜η\f{␗␑ς$９ζπｖ：␘j\b.>",
		out:  "‛．.#\x13＼ςyｕλ\x0f７７｜η\f{␗␑ς$９ζπｖ：␘j\b.>",
	}, { // 1394
		mask: EncodeAsterisk | EncodeLeftPeriod | EncodeRightPeriod,
		in:   "␞.#\x13＼ςyｕλ\x0f７７｜η\f{␗␑ς$９ζπｖ：␘j\b..",
		out:  "␞.#\x13＼ςyｕλ\x0f７７｜η\f{␗␑ς$９ζπｖ：␘j\b.．",
	}, { // 1395
		mask: EncodeAsterisk | EncodeLeftPeriod | EncodeRightPeriod,
		in:   "␞.#\x13＼ςyｕλ\x0f７７｜η\f{␗␑ς$９ζπｖ：␘j\b.．",
		out:  "␞.#\x13＼ςyｕλ\x0f７７｜η\f{␗␑ς$９ζπｖ：␘j\b.‛．",
	}, { // 1396
		mask: EncodePipe | EncodeLeftPeriod | EncodeRightPeriod,
		in:   "..Ｎβ\x10οq\x06\\'␁％ξ␉Ｕ|pHχ\x1b＇π）␉μ\v＊&.␈",
		out:  "．.Ｎβ\x10οq\x06\\'␁％ξ␉Ｕ｜pHχ\x1b＇π）␉μ\v＊&.␈",
	}, { // 1397
		mask: EncodePipe | EncodeLeftPeriod | EncodeRightPeriod,
		in:   "．.Ｎβ\x10οq\x06\\'␁％ξ␉Ｕ|pHχ\x1b＇π）␉μ\v＊&.␈",
		out:  "‛．.Ｎβ\x10οq\x06\\'␁％ξ␉Ｕ｜pHχ\x1b＇π）␉μ\v＊&.␈",
	}, { // 1398
		mask: EncodePipe | EncodeLeftPeriod | EncodeRightPeriod,
		in:   "：.Ｎβ\x10οq\x06\\'␁％ξ␉Ｕ|pHχ\x1b＇π）␉μ\v＊&..",
		out:  "：.Ｎβ\x10οq\x06\\'␁％ξ␉Ｕ｜pHχ\x1b＇π）␉μ\v＊&.．",
	}, { // 1399
		mask: EncodePipe | EncodeLeftPeriod | EncodeRightPeriod,
		in:   "：.Ｎβ\x10οq\x06\\'␁％ξ␉Ｕ|pHχ\x1b＇π）␉μ\v＊&.．",
		out:  "：.Ｎβ\x10οq\x06\\'␁％ξ␉Ｕ｜pHχ\x1b＇π）␉μ\v＊&.‛．",
	}, { // 1400
		mask: EncodeHash | EncodeLeftPeriod | EncodeRightPeriod,
		in:   "..ξκμ,[εＯ｜*␐＇μ]K／\x11t\x01／＃\x18ｉ2Ｑ␔β.␔",
		out:  "．.ξκμ,[εＯ｜*␐＇μ]K／\x11t\x01／‛＃\x18ｉ2Ｑ␔β.␔",
	}, { // 1401
		mask: EncodeHash | EncodeLeftPeriod | EncodeRightPeriod,
		in:   "．.ξκμ,[εＯ｜*␐＇μ]K／\x11t\x01／＃\x18ｉ2Ｑ␔β.␔",
		out:  "‛．.ξκμ,[εＯ｜*␐＇μ]K／\x11t\x01／‛＃\x18ｉ2Ｑ␔β.␔",
	}, { // 1402
		mask: EncodeHash | EncodeLeftPeriod | EncodeRightPeriod,
		in:   "2.ξκμ,[εＯ｜*␐＇μ]K／\x11t\x01／＃\x18ｉ2Ｑ␔β..",
		out:  "2.ξκμ,[εＯ｜*␐＇μ]K／\x11t\x01／‛＃\x18ｉ2Ｑ␔β.．",
	}, { // 1403
		mask: EncodeHash | EncodeLeftPeriod | EncodeRightPeriod,
		in:   "2.ξκμ,[εＯ｜*␐＇μ]K／\x11t\x01／＃\x18ｉ2Ｑ␔β.．",
		out:  "2.ξκμ,[εＯ｜*␐＇μ]K／\x11t\x01／‛＃\x18ｉ2Ｑ␔β.‛．",
	}, { // 1404
		mask: EncodePercent | EncodeLeftPeriod | EncodeRightPeriod,
		in:   "..\x18［［$\x15x＃５#νｎ\x11-＊ω＊ςHθ-ａX＇\x01φs.␌",
		out:  "．.\x18［［$\x15x＃５#νｎ\x11-＊ω＊ςHθ-ａX＇\x01φs.␌",
	}, { // 1405
		mask: EncodePercent | EncodeLeftPeriod | EncodeRightPeriod,
		in:   "．.\x18［［$\x15x＃５#νｎ\x11-＊ω＊ςHθ-ａX＇\x01φs.␌",
		out:  "‛．.\x18［［$\x15x＃５#νｎ\x11-＊ω＊ςHθ-ａX＇\x01φs.␌",
	}, { // 1406
		mask: EncodePercent | EncodeLeftPeriod | EncodeRightPeriod,
		in:   "＊.\x18［［$\x15x＃５#νｎ\x11-＊ω＊ςHθ-ａX＇\x01φs..",
		out:  "＊.\x18［［$\x15x＃５#νｎ\x11-＊ω＊ςHθ-ａX＇\x01φs.．",
	}, { // 1407
		mask: EncodePercent | EncodeLeftPeriod | EncodeRightPeriod,
		in:   "＊.\x18［［$\x15x＃５#νｎ\x11-＊ω＊ςHθ-ａX＇\x01φs.．",
		out:  "＊.\x18［［$\x15x＃５#νｎ\x11-＊ω＊ςHθ-ａX＇\x01φs.‛．",
	}, { // 1408
		mask: EncodeBackSlash | EncodeLeftPeriod | EncodeRightPeriod,
		in:   "..\x1eJ＼␍Y␊<|θ３\nς］＃]9＄．\rDｐfＶε_＊.ς",
		out:  "．.\x1eJ‛＼␍Y␊<|θ３\nς］＃]9＄．\rDｐfＶε_＊.ς",
	}, { // 1409
		mask: EncodeBackSlash | EncodeLeftPeriod | EncodeRightPeriod,
		in:   "．.\x1eJ＼␍Y␊<|θ３\nς］＃]9＄．\rDｐfＶε_＊.ς",
		out:  "‛．.\x1eJ‛＼␍Y␊<|θ３\nς］＃]9＄．\rDｐfＶε_＊.ς",
	}, { // 1410
		mask: EncodeBackSlash | EncodeLeftPeriod | EncodeRightPeriod,
		in:   "υ.\x1eJ＼␍Y␊<|θ３\nς］＃]9＄．\rDｐfＶε_＊..",
		out:  "υ.\x1eJ‛＼␍Y␊<|θ３\nς］＃]9＄．\rDｐfＶε_＊.．",
	}, { // 1411
		mask: EncodeBackSlash | EncodeLeftPeriod | EncodeRightPeriod,
		in:   "υ.\x1eJ＼␍Y␊<|θ３\nς］＃]9＄．\rDｐfＶε_＊.．",
		out:  "υ.\x1eJ‛＼␍Y␊<|θ３\nς］＃]9＄．\rDｐfＶε_＊.‛．",
	}, { // 1412
		mask: EncodeCrLf | EncodeLeftPeriod | EncodeRightPeriod,
		in:   "..κ?ｈ\uff00；Ｏθ_\"０Ｒ?\x04＂␀4＊υη␛\x11$j@\x04\x05.＋",
		out:  "．.κ?ｈ\uff00；Ｏθ_\"０Ｒ?\x04＂‛␀4＊υη␛\x11$j@\x04\x05.＋",
	}, { // 1413
		mask: EncodeCrLf | EncodeLeftPeriod | EncodeRightPeriod,
		in:   "．.κ?ｈ\uff00；Ｏθ_\"０Ｒ?\x04＂␀4＊υη␛\x11$j@\x04\x05.＋",
		out:  "‛．.κ?ｈ\uff00；Ｏθ_\"０Ｒ?\x04＂‛␀4＊υη␛\x11$j@\x04\x05.＋",
	}, { // 1414
		mask: EncodeCrLf | EncodeLeftPeriod | EncodeRightPeriod,
		in:   "υ.κ?ｈ\uff00；Ｏθ_\"０Ｒ?\x04＂␀4＊υη␛\x11$j@\x04\x05..",
		out:  "υ.κ?ｈ\uff00；Ｏθ_\"０Ｒ?\x04＂‛␀4＊υη␛\x11$j@\x04\x05.．",
	}, { // 1415
		mask: EncodeCrLf | EncodeLeftPeriod | EncodeRightPeriod,
		in:   "υ.κ?ｈ\uff00；Ｏθ_\"０Ｒ?\x04＂␀4＊υη␛\x11$j@\x04\x05.．",
		out:  "υ.κ?ｈ\uff00；Ｏθ_\"０Ｒ?\x04＂‛␀4＊υη␛\x11$j@\x04\x05.‛．",
	}, { // 1416
		mask: EncodeDel | EncodeLeftPeriod | EncodeRightPeriod,
		in:   "..％ηＯ\x12ω？]｝Ｊ＜:o␝％＊φ/ζ8＇ρ8Ｔ\x1b:e.\"",
		out:  "．.％ηＯ\x12ω？]｝Ｊ＜:o␝％＊φ/ζ8＇ρ8Ｔ\x1b:e.\"",
	}, { // 1417
		mask: EncodeDel | EncodeLeftPeriod | EncodeRightPeriod,
		in:   "．.％ηＯ\x12ω？]｝Ｊ＜:o␝％＊φ/ζ8＇ρ8Ｔ\x1b:e.\"",
		out:  "‛．.％ηＯ\x12ω？]｝Ｊ＜:o␝％＊φ/ζ8＇ρ8Ｔ\x1b:e.\"",
	}, { // 1418
		mask: EncodeDel | EncodeLeftPeriod | EncodeRightPeriod,
		in:   "␚.％ηＯ\x12ω？]｝Ｊ＜:o␝％＊φ/ζ8＇ρ8Ｔ\x1b:e..",
		out:  "␚.％ηＯ\x12ω？]｝Ｊ＜:o␝％＊φ/ζ8＇ρ8Ｔ\x1b:e.．",
	}, { // 1419
		mask: EncodeDel | EncodeLeftPeriod | EncodeRightPeriod,
		in:   "␚.％ηＯ\x12ω？]｝Ｊ＜:o␝％＊φ/ζ8＇ρ8Ｔ\x1b:e.．",
		out:  "␚.％ηＯ\x12ω？]｝Ｊ＜:o␝％＊φ/ζ8＇ρ8Ｔ\x1b:e.‛．",
	}, { // 1420
		mask: EncodeCtl | EncodeLeftPeriod | EncodeRightPeriod,
		in:   "..&ａ／ξλ␜\x12ν␌\x16f/γ}／␜ＳＹ4L␃␋#8ｈ９.ψ",
		out:  "．.&ａ／ξλ‛␜␒ν‛␌␖f/γ}／‛␜ＳＹ4L‛␃‛␋#8ｈ９.ψ",
	}, { // 1421
		mask: EncodeCtl | EncodeLeftPeriod | EncodeRightPeriod,
		in:   "．.&ａ／ξλ␜\x12ν␌\x16f/γ}／␜ＳＹ4L␃␋#8ｈ９.ψ",
		out:  "‛．.&ａ／ξλ‛␜␒ν‛␌␖f/γ}／‛␜ＳＹ4L‛␃‛␋#8ｈ９.ψ",
	}, { // 1422
		mask: EncodeCtl | EncodeLeftPeriod | EncodeRightPeriod,
		in:   "α.&ａ／ξλ␜\x12ν␌\x16f/γ}／␜ＳＹ4L␃␋#8ｈ９..",
		out:  "α.&ａ／ξλ‛␜␒ν‛␌␖f/γ}／‛␜ＳＹ4L‛␃‛␋#8ｈ９.．",
	}, { // 1423
		mask: EncodeCtl | EncodeLeftPeriod | EncodeRightPeriod,
		in:   "α.&ａ／ξλ␜\x12ν␌\x16f/γ}／␜ＳＹ4L␃␋#8ｈ９.．",
		out:  "α.&ａ／ξλ‛␜␒ν‛␌␖f/γ}／‛␜ＳＹ4L‛␃‛␋#8ｈ９.‛．",
	}, { // 1424
		mask: EncodeZero | EncodeLeftPeriod | EncodeRightCrLfHtVt,
		in:   ".\tε&␆ｂ\x0f\v１]␒\n＊ς６α␘#EｚGλＫ＇G＃τ␂\t]",
		out:  "．\tε&␆ｂ\x0f\v１]␒\n＊ς６α␘#EｚGλＫ＇G＃τ␂\t]",
	}, { // 1425
		mask: EncodeZero | EncodeLeftPeriod | EncodeRightCrLfHtVt,
		in:   "．\tε&␆ｂ\x0f\v１]␒\n＊ς６α␘#EｚGλＫ＇G＃τ␂\t]",
		out:  "‛．\tε&␆ｂ\x0f\v１]␒\n＊ς６α␘#EｚGλＫ＇G＃τ␂\t]",
	}, { // 1426
		mask: EncodeZero | EncodeLeftPeriod | EncodeRightCrLfHtVt,
		in:   ".\nε&␆ｂ\x0f\v１]␒\n＊ς６α␘#EｚGλＫ＇G＃τ␂\n]",
		out:  "．\nε&␆ｂ\x0f\v１]␒\n＊ς６α␘#EｚGλＫ＇G＃τ␂\n]",
	}, { // 1427
		mask: EncodeZero | EncodeLeftPeriod | EncodeRightCrLfHtVt,
		in:   "．\nε&␆ｂ\x0f\v１]␒\n＊ς６α␘#EｚGλＫ＇G＃τ␂\n]",
		out:  "‛．\nε&␆ｂ\x0f\v１]␒\n＊ς６α␘#EｚGλＫ＇G＃τ␂\n]",
	}, { // 1428
		mask: EncodeZero | EncodeLeftPeriod | EncodeRightCrLfHtVt,
		in:   ".\vε&␆ｂ\x0f\v１]␒\n＊ς６α␘#EｚGλＫ＇G＃τ␂\v]",
		out:  "．\vε&␆ｂ\x0f\v１]␒\n＊ς６α␘#EｚGλＫ＇G＃τ␂\v]",
	}, { // 1429
		mask: EncodeZero | EncodeLeftPeriod | EncodeRightCrLfHtVt,
		in:   "．\vε&␆ｂ\x0f\v１]␒\n＊ς６α␘#EｚGλＫ＇G＃τ␂\v]",
		out:  "‛．\vε&␆ｂ\x0f\v１]␒\n＊ς６α␘#EｚGλＫ＇G＃τ␂\v]",
	}, { // 1430
		mask: EncodeZero | EncodeLeftPeriod | EncodeRightCrLfHtVt,
		in:   ".\rε&␆ｂ\x0f\v１]␒\n＊ς６α␘#EｚGλＫ＇G＃τ␂\r]",
		out:  "．\rε&␆ｂ\x0f\v１]␒\n＊ς６α␘#EｚGλＫ＇G＃τ␂\r]",
	}, { // 1431
		mask: EncodeZero | EncodeLeftPeriod | EncodeRightCrLfHtVt,
		in:   "．\rε&␆ｂ\x0f\v１]␒\n＊ς６α␘#EｚGλＫ＇G＃τ␂\r]",
		out:  "‛．\rε&␆ｂ\x0f\v１]␒\n＊ς６α␘#EｚGλＫ＇G＃τ␂\r]",
	}, { // 1432
		mask: EncodeZero | EncodeLeftPeriod | EncodeRightCrLfHtVt,
		in:   ":\tε&␆ｂ\x0f\v１]␒\n＊ς６α␘#EｚGλＫ＇G＃τ␂\t.",
		out:  ":\tε&␆ｂ\x0f\v１]␒\n＊ς６α␘#EｚGλＫ＇G＃τ␂\t.",
	}, { // 1433
		mask: EncodeZero | EncodeLeftPeriod | EncodeRightCrLfHtVt,
		in:   ":\tε&␆ｂ\x0f\v１]␒\n＊ς６α␘#EｚGλＫ＇G＃τ␂\t．",
		out:  ":\tε&␆ｂ\x0f\v１]␒\n＊ς６α␘#EｚGλＫ＇G＃τ␂\t．",
	}, { // 1434
		mask: EncodeZero | EncodeLeftPeriod | EncodeRightCrLfHtVt,
		in:   ":\nε&␆ｂ\x0f\v１]␒\n＊ς６α␘#EｚGλＫ＇G＃τ␂\n.",
		out:  ":\nε&␆ｂ\x0f\v１]␒\n＊ς６α␘#EｚGλＫ＇G＃τ␂\n.",
	}, { // 1435
		mask: EncodeZero | EncodeLeftPeriod | EncodeRightCrLfHtVt,
		in:   ":\nε&␆ｂ\x0f\v１]␒\n＊ς６α␘#EｚGλＫ＇G＃τ␂\n．",
		out:  ":\nε&␆ｂ\x0f\v１]␒\n＊ς６α␘#EｚGλＫ＇G＃τ␂\n．",
	}, { // 1436
		mask: EncodeZero | EncodeLeftPeriod | EncodeRightCrLfHtVt,
		in:   ":\vε&␆ｂ\x0f\v１]␒\n＊ς６α␘#EｚGλＫ＇G＃τ␂\v.",
		out:  ":\vε&␆ｂ\x0f\v１]␒\n＊ς６α␘#EｚGλＫ＇G＃τ␂\v.",
	}, { // 1437
		mask: EncodeZero | EncodeLeftPeriod | EncodeRightCrLfHtVt,
		in:   ":\vε&␆ｂ\x0f\v１]␒\n＊ς６α␘#EｚGλＫ＇G＃τ␂\v．",
		out:  ":\vε&␆ｂ\x0f\v１]␒\n＊ς６α␘#EｚGλＫ＇G＃τ␂\v．",
	}, { // 1438
		mask: EncodeZero | EncodeLeftPeriod | EncodeRightCrLfHtVt,
		in:   ":\rε&␆ｂ\x0f\v１]␒\n＊ς６α␘#EｚGλＫ＇G＃τ␂\r.",
		out:  ":\rε&␆ｂ\x0f\v１]␒\n＊ς６α␘#EｚGλＫ＇G＃τ␂\r.",
	}, { // 1439
		mask: EncodeZero | EncodeLeftPeriod | EncodeRightCrLfHtVt,
		in:   ":\rε&␆ｂ\x0f\v１]␒\n＊ς６α␘#EｚGλＫ＇G＃τ␂\r．",
		out:  ":\rε&␆ｂ\x0f\v１]␒\n＊ς６α␘#EｚGλＫ＇G＃τ␂\r．",
	}, { // 1440
		mask: EncodeSlash | EncodeLeftPeriod | EncodeRightCrLfHtVt,
		in:   ".\t␘␜\nr\x04χχ␟\x1f\x1bｒj｜？ς\b｜␙ω\bsｆｐυ＄v\t）",
		out:  "．\t␘␜\nr\x04χχ␟\x1f\x1bｒj｜？ς\b｜␙ω\bsｆｐυ＄v\t）",
	}, { // 1441
		mask: EncodeSlash | EncodeLeftPeriod | EncodeRightCrLfHtVt,
		in:   "．\t␘␜\nr\x04χχ␟\x1f\x1bｒj｜？ς\b｜␙ω\bsｆｐυ＄v\t）",
		out:  "‛．\t␘␜\nr\x04χχ␟\x1f\x1bｒj｜？ς\b｜␙ω\bsｆｐυ＄v\t）",
	}, { // 1442
		mask: EncodeSlash | EncodeLeftPeriod | EncodeRightCrLfHtVt,
		in:   ".\n␘␜\nr\x04χχ␟\x1f\x1bｒj｜？ς\b｜␙ω\bsｆｐυ＄v\n）",
		out:  "．\n␘␜\nr\x04χχ␟\x1f\x1bｒj｜？ς\b｜␙ω\bsｆｐυ＄v\n）",
	}, { // 1443
		mask: EncodeSlash | EncodeLeftPeriod | EncodeRightCrLfHtVt,
		in:   "．\n␘␜\nr\x04χχ␟\x1f\x1bｒj｜？ς\b｜␙ω\bsｆｐυ＄v\n）",
		out:  "‛．\n␘␜\nr\x04χχ␟\x1f\x1bｒj｜？ς\b｜␙ω\bsｆｐυ＄v\n）",
	}, { // 1444
		mask: EncodeSlash | EncodeLeftPeriod | EncodeRightCrLfHtVt,
		in:   ".\v␘␜\nr\x04χχ␟\x1f\x1bｒj｜？ς\b｜␙ω\bsｆｐυ＄v\v）",
		out:  "．\v␘␜\nr\x04χχ␟\x1f\x1bｒj｜？ς\b｜␙ω\bsｆｐυ＄v\v）",
	}, { // 1445
		mask: EncodeSlash | EncodeLeftPeriod | EncodeRightCrLfHtVt,
		in:   "．\v␘␜\nr\x04χχ␟\x1f\x1bｒj｜？ς\b｜␙ω\bsｆｐυ＄v\v）",
		out:  "‛．\v␘␜\nr\x04χχ␟\x1f\x1bｒj｜？ς\b｜␙ω\bsｆｐυ＄v\v）",
	}, { // 1446
		mask: EncodeSlash | EncodeLeftPeriod | EncodeRightCrLfHtVt,
		in:   ".\r␘␜\nr\x04χχ␟\x1f\x1bｒj｜？ς\b｜␙ω\bsｆｐυ＄v\r）",
		out:  "．\r␘␜\nr\x04χχ␟\x1f\x1bｒj｜？ς\b｜␙ω\bsｆｐυ＄v\r）",
	}, { // 1447
		mask: EncodeSlash | EncodeLeftPeriod | EncodeRightCrLfHtVt,
		in:   "．\r␘␜\nr\x04χχ␟\x1f\x1bｒj｜？ς\b｜␙ω\bsｆｐυ＄v\r）",
		out:  "‛．\r␘␜\nr\x04χχ␟\x1f\x1bｒj｜？ς\b｜␙ω\bsｆｐυ＄v\r）",
	}, { // 1448
		mask: EncodeSlash | EncodeLeftPeriod | EncodeRightCrLfHtVt,
		in:   "ψ\t␘␜\nr\x04χχ␟\x1f\x1bｒj｜？ς\b｜␙ω\bsｆｐυ＄v\t.",
		out:  "ψ\t␘␜\nr\x04χχ␟\x1f\x1bｒj｜？ς\b｜␙ω\bsｆｐυ＄v\t.",
	}, { // 1449
		mask: EncodeSlash | EncodeLeftPeriod | EncodeRightCrLfHtVt,
		in:   "ψ\t␘␜\nr\x04χχ␟\x1f\x1bｒj｜？ς\b｜␙ω\bsｆｐυ＄v\t．",
		out:  "ψ\t␘␜\nr\x04χχ␟\x1f\x1bｒj｜？ς\b｜␙ω\bsｆｐυ＄v\t．",
	}, { // 1450
		mask: EncodeSlash | EncodeLeftPeriod | EncodeRightCrLfHtVt,
		in:   "ψ\n␘␜\nr\x04χχ␟\x1f\x1bｒj｜？ς\b｜␙ω\bsｆｐυ＄v\n.",
		out:  "ψ\n␘␜\nr\x04χχ␟\x1f\x1bｒj｜？ς\b｜␙ω\bsｆｐυ＄v\n.",
	}, { // 1451
		mask: EncodeSlash | EncodeLeftPeriod | EncodeRightCrLfHtVt,
		in:   "ψ\n␘␜\nr\x04χχ␟\x1f\x1bｒj｜？ς\b｜␙ω\bsｆｐυ＄v\n．",
		out:  "ψ\n␘␜\nr\x04χχ␟\x1f\x1bｒj｜？ς\b｜␙ω\bsｆｐυ＄v\n．",
	}, { // 1452
		mask: EncodeSlash | EncodeLeftPeriod | EncodeRightCrLfHtVt,
		in:   "ψ\v␘␜\nr\x04χχ␟\x1f\x1bｒj｜？ς\b｜␙ω\bsｆｐυ＄v\v.",
		out:  "ψ\v␘␜\nr\x04χχ␟\x1f\x1bｒj｜？ς\b｜␙ω\bsｆｐυ＄v\v.",
	}, { // 1453
		mask: EncodeSlash | EncodeLeftPeriod | EncodeRightCrLfHtVt,
		in:   "ψ\v␘␜\nr\x04χχ␟\x1f\x1bｒj｜？ς\b｜␙ω\bsｆｐυ＄v\v．",
		out:  "ψ\v␘␜\nr\x04χχ␟\x1f\x1bｒj｜？ς\b｜␙ω\bsｆｐυ＄v\v．",
	}, { // 1454
		mask: EncodeSlash | EncodeLeftPeriod | EncodeRightCrLfHtVt,
		in:   "ψ\r␘␜\nr\x04χχ␟\x1f\x1bｒj｜？ς\b｜␙ω\bsｆｐυ＄v\r.",
		out:  "ψ\r␘␜\nr\x04χχ␟\x1f\x1bｒj｜？ς\b｜␙ω\bsｆｐυ＄v\r.",
	}, { // 1455
		mask: EncodeSlash | EncodeLeftPeriod | EncodeRightCrLfHtVt,
		in:   "ψ\r␘␜\nr\x04χχ␟\x1f\x1bｒj｜？ς\b｜␙ω\bsｆｐυ＄v\r．",
		out:  "ψ\r␘␜\nr\x04χχ␟\x1f\x1bｒj｜？ς\b｜␙ω\bsｆｐυ＄v\r．",
	}, { // 1456
		mask: EncodeSingleQuote | EncodeLeftPeriod | EncodeRightCrLfHtVt,
		in:   ".\t\x01\f/xυ␆ｚ％υ＞ｔｕ␛７(Kｍα␆/>]Qχ4＜\tμ",
		out:  "．\t\x01\f/xυ␆ｚ％υ＞ｔｕ␛７(Kｍα␆/>]Qχ4＜\tμ",
	}, { // 1457
		mask: EncodeSingleQuote | EncodeLeftPeriod | EncodeRightCrLfHtVt,
		in:   "．\t\x01\f/xυ␆ｚ％υ＞ｔｕ␛７(Kｍα␆/>]Qχ4＜\tμ",
		out:  "‛．\t\x01\f/xυ␆ｚ％υ＞ｔｕ␛７(Kｍα␆/>]Qχ4＜\tμ",
	}, { // 1458
		mask: EncodeSingleQuote | EncodeLeftPeriod | EncodeRightCrLfHtVt,
		in:   ".\n\x01\f/xυ␆ｚ％υ＞ｔｕ␛７(Kｍα␆/>]Qχ4＜\nμ",
		out:  "．\n\x01\f/xυ␆ｚ％υ＞ｔｕ␛７(Kｍα␆/>]Qχ4＜\nμ",
	}, { // 1459
		mask: EncodeSingleQuote | EncodeLeftPeriod | EncodeRightCrLfHtVt,
		in:   "．\n\x01\f/xυ␆ｚ％υ＞ｔｕ␛７(Kｍα␆/>]Qχ4＜\nμ",
		out:  "‛．\n\x01\f/xυ␆ｚ％υ＞ｔｕ␛７(Kｍα␆/>]Qχ4＜\nμ",
	}, { // 1460
		mask: EncodeSingleQuote | EncodeLeftPeriod | EncodeRightCrLfHtVt,
		in:   ".\v\x01\f/xυ␆ｚ％υ＞ｔｕ␛７(Kｍα␆/>]Qχ4＜\vμ",
		out:  "．\v\x01\f/xυ␆ｚ％υ＞ｔｕ␛７(Kｍα␆/>]Qχ4＜\vμ",
	}, { // 1461
		mask: EncodeSingleQuote | EncodeLeftPeriod | EncodeRightCrLfHtVt,
		in:   "．\v\x01\f/xυ␆ｚ％υ＞ｔｕ␛７(Kｍα␆/>]Qχ4＜\vμ",
		out:  "‛．\v\x01\f/xυ␆ｚ％υ＞ｔｕ␛７(Kｍα␆/>]Qχ4＜\vμ",
	}, { // 1462
		mask: EncodeSingleQuote | EncodeLeftPeriod | EncodeRightCrLfHtVt,
		in:   ".\r\x01\f/xυ␆ｚ％υ＞ｔｕ␛７(Kｍα␆/>]Qχ4＜\rμ",
		out:  "．\r\x01\f/xυ␆ｚ％υ＞ｔｕ␛７(Kｍα␆/>]Qχ4＜\rμ",
	}, { // 1463
		mask: EncodeSingleQuote | EncodeLeftPeriod | EncodeRightCrLfHtVt,
		in:   "．\r\x01\f/xυ␆ｚ％υ＞ｔｕ␛７(Kｍα␆/>]Qχ4＜\rμ",
		out:  "‛．\r\x01\f/xυ␆ｚ％υ＞ｔｕ␛７(Kｍα␆/>]Qχ4＜\rμ",
	}, { // 1464
		mask: EncodeSingleQuote | EncodeLeftPeriod | EncodeRightCrLfHtVt,
		in:   "ｏ\t\x01\f/xυ␆ｚ％υ＞ｔｕ␛７(Kｍα␆/>]Qχ4＜\t.",
		out:  "ｏ\t\x01\f/xυ␆ｚ％υ＞ｔｕ␛７(Kｍα␆/>]Qχ4＜\t.",
	}, { // 1465
		mask: EncodeSingleQuote | EncodeLeftPeriod | EncodeRightCrLfHtVt,
		in:   "ｏ\t\x01\f/xυ␆ｚ％υ＞ｔｕ␛７(Kｍα␆/>]Qχ4＜\t．",
		out:  "ｏ\t\x01\f/xυ␆ｚ％υ＞ｔｕ␛７(Kｍα␆/>]Qχ4＜\t．",
	}, { // 1466
		mask: EncodeSingleQuote | EncodeLeftPeriod | EncodeRightCrLfHtVt,
		in:   "ｏ\n\x01\f/xυ␆ｚ％υ＞ｔｕ␛７(Kｍα␆/>]Qχ4＜\n.",
		out:  "ｏ\n\x01\f/xυ␆ｚ％υ＞ｔｕ␛７(Kｍα␆/>]Qχ4＜\n.",
	}, { // 1467
		mask: EncodeSingleQuote | EncodeLeftPeriod | EncodeRightCrLfHtVt,
		in:   "ｏ\n\x01\f/xυ␆ｚ％υ＞ｔｕ␛７(Kｍα␆/>]Qχ4＜\n．",
		out:  "ｏ\n\x01\f/xυ␆ｚ％υ＞ｔｕ␛７(Kｍα␆/>]Qχ4＜\n．",
	}, { // 1468
		mask: EncodeSingleQuote | EncodeLeftPeriod | EncodeRightCrLfHtVt,
		in:   "ｏ\v\x01\f/xυ␆ｚ％υ＞ｔｕ␛７(Kｍα␆/>]Qχ4＜\v.",
		out:  "ｏ\v\x01\f/xυ␆ｚ％υ＞ｔｕ␛７(Kｍα␆/>]Qχ4＜\v.",
	}, { // 1469
		mask: EncodeSingleQuote | EncodeLeftPeriod | EncodeRightCrLfHtVt,
		in:   "ｏ\v\x01\f/xυ␆ｚ％υ＞ｔｕ␛７(Kｍα␆/>]Qχ4＜\v．",
		out:  "ｏ\v\x01\f/xυ␆ｚ％υ＞ｔｕ␛７(Kｍα␆/>]Qχ4＜\v．",
	}, { // 1470
		mask: EncodeSingleQuote | EncodeLeftPeriod | EncodeRightCrLfHtVt,
		in:   "ｏ\r\x01\f/xυ␆ｚ％υ＞ｔｕ␛７(Kｍα␆/>]Qχ4＜\r.",
		out:  "ｏ\r\x01\f/xυ␆ｚ％υ＞ｔｕ␛７(Kｍα␆/>]Qχ4＜\r.",
	}, { // 1471
		mask: EncodeSingleQuote | EncodeLeftPeriod | EncodeRightCrLfHtVt,
		in:   "ｏ\r\x01\f/xυ␆ｚ％υ＞ｔｕ␛７(Kｍα␆/>]Qχ4＜\r．",
		out:  "ｏ\r\x01\f/xυ␆ｚ％υ＞ｔｕ␛７(Kｍα␆/>]Qχ4＜\r．",
	}, { // 1472
		mask: EncodeBackQuote | EncodeLeftPeriod | EncodeRightCrLfHtVt,
		in:   ".\t␇[）＂o'\"π％π＂ｂ.1Ｋ:\x1fH～；θ ␎η`％\t%",
		out:  "．\t␇[）＂o'\"π％π＂ｂ.1Ｋ:\x1fH～；θ ␎η｀％\t%",
	}, { // 1473
		mask: EncodeBackQuote | EncodeLeftPeriod | EncodeRightCrLfHtVt,
		in:   "．\t␇[）＂o'\"π％π＂ｂ.1Ｋ:\x1fH～；θ ␎η`％\t%",
		out:  "‛．\t␇[）＂o'\"π％π＂ｂ.1Ｋ:\x1fH～；θ ␎η｀％\t%",
	}, { // 1474
		mask: EncodeBackQuote | EncodeLeftPeriod | EncodeRightCrLfHtVt,
		in:   ".\n␇[）＂o'\"π％π＂ｂ.1Ｋ:\x1fH～；θ ␎η`％\n%",
		out:  "．\n␇[）＂o'\"π％π＂ｂ.1Ｋ:\x1fH～；θ ␎η｀％\n%",
	}, { // 1475
		mask: EncodeBackQuote | EncodeLeftPeriod | EncodeRightCrLfHtVt,
		in:   "．\n␇[）＂o'\"π％π＂ｂ.1Ｋ:\x1fH～；θ ␎η`％\n%",
		out:  "‛．\n␇[）＂o'\"π％π＂ｂ.1Ｋ:\x1fH～；θ ␎η｀％\n%",
	}, { // 1476
		mask: EncodeBackQuote | EncodeLeftPeriod | EncodeRightCrLfHtVt,
		in:   ".\v␇[）＂o'\"π％π＂ｂ.1Ｋ:\x1fH～；θ ␎η`％\v%",
		out:  "．\v␇[）＂o'\"π％π＂ｂ.1Ｋ:\x1fH～；θ ␎η｀％\v%",
	}, { // 1477
		mask: EncodeBackQuote | EncodeLeftPeriod | EncodeRightCrLfHtVt,
		in:   "．\v␇[）＂o'\"π％π＂ｂ.1Ｋ:\x1fH～；θ ␎η`％\v%",
		out:  "‛．\v␇[）＂o'\"π％π＂ｂ.1Ｋ:\x1fH～；θ ␎η｀％\v%",
	}, { // 1478
		mask: EncodeBackQuote | EncodeLeftPeriod | EncodeRightCrLfHtVt,
		in:   ".\r␇[）＂o'\"π％π＂ｂ.1Ｋ:\x1fH～；θ ␎η`％\r%",
		out:  "．\r␇[）＂o'\"π％π＂ｂ.1Ｋ:\x1fH～；θ ␎η｀％\r%",
	}, { // 1479
		mask: EncodeBackQuote | EncodeLeftPeriod | EncodeRightCrLfHtVt,
		in:   "．\r␇[）＂o'\"π％π＂ｂ.1Ｋ:\x1fH～；θ ␎η`％\r%",
		out:  "‛．\r␇[）＂o'\"π％π＂ｂ.1Ｋ:\x1fH～；θ ␎η｀％\r%",
	}, { // 1480
		mask: EncodeBackQuote | EncodeLeftPeriod | EncodeRightCrLfHtVt,
		in:   "α\t␇[）＂o'\"π％π＂ｂ.1Ｋ:\x1fH～；θ ␎η`％\t.",
		out:  "α\t␇[）＂o'\"π％π＂ｂ.1Ｋ:\x1fH～；θ ␎η｀％\t.",
	}, { // 1481
		mask: EncodeBackQuote | EncodeLeftPeriod | EncodeRightCrLfHtVt,
		in:   "α\t␇[）＂o'\"π％π＂ｂ.1Ｋ:\x1fH～；θ ␎η`％\t．",
		out:  "α\t␇[）＂o'\"π％π＂ｂ.1Ｋ:\x1fH～；θ ␎η｀％\t．",
	}, { // 1482
		mask: EncodeBackQuote | EncodeLeftPeriod | EncodeRightCrLfHtVt,
		in:   "α\n␇[）＂o'\"π％π＂ｂ.1Ｋ:\x1fH～；θ ␎η`％\n.",
		out:  "α\n␇[）＂o'\"π％π＂ｂ.1Ｋ:\x1fH～；θ ␎η｀％\n.",
	}, { // 1483
		mask: EncodeBackQuote | EncodeLeftPeriod | EncodeRightCrLfHtVt,
		in:   "α\n␇[）＂o'\"π％π＂ｂ.1Ｋ:\x1fH～；θ ␎η`％\n．",
		out:  "α\n␇[）＂o'\"π％π＂ｂ.1Ｋ:\x1fH～；θ ␎η｀％\n．",
	}, { // 1484
		mask: EncodeBackQuote | EncodeLeftPeriod | EncodeRightCrLfHtVt,
		in:   "α\v␇[）＂o'\"π％π＂ｂ.1Ｋ:\x1fH～；θ ␎η`％\v.",
		out:  "α\v␇[）＂o'\"π％π＂ｂ.1Ｋ:\x1fH～；θ ␎η｀％\v.",
	}, { // 1485
		mask: EncodeBackQuote | EncodeLeftPeriod | EncodeRightCrLfHtVt,
		in:   "α\v␇[）＂o'\"π％π＂ｂ.1Ｋ:\x1fH～；θ ␎η`％\v．",
		out:  "α\v␇[）＂o'\"π％π＂ｂ.1Ｋ:\x1fH～；θ ␎η｀％\v．",
	}, { // 1486
		mask: EncodeBackQuote | EncodeLeftPeriod | EncodeRightCrLfHtVt,
		in:   "α\r␇[）＂o'\"π％π＂ｂ.1Ｋ:\x1fH～；θ ␎η`％\r.",
		out:  "α\r␇[）＂o'\"π％π＂ｂ.1Ｋ:\x1fH～；θ ␎η｀％\r.",
	}, { // 1487
		mask: EncodeBackQuote | EncodeLeftPeriod | EncodeRightCrLfHtVt,
		in:   "α\r␇[）＂o'\"π％π＂ｂ.1Ｋ:\x1fH～；θ ␎η`％\r．",
		out:  "α\r␇[）＂o'\"π％π＂ｂ.1Ｋ:\x1fH～；θ ␎η｀％\r．",
	}, { // 1488
		mask: EncodeLtGt | EncodeLeftPeriod | EncodeRightCrLfHtVt,
		in:   ".\t～;γ＃␓ｐ６s\x03τｚx␑␄\x00\x16\rβ％Cζ:c＞ν␊\t!",
		out:  "．\t～;γ＃␓ｐ６s\x03τｚx␑␄␀\x16\rβ％Cζ:c‛＞ν␊\t!",
	}, { // 1489
		mask: EncodeLtGt | EncodeLeftPeriod | EncodeRightCrLfHtVt,
		in:   "．\t～;γ＃␓ｐ６s\x03τｚx␑␄\x00\x16\rβ％Cζ:c＞ν␊\t!",
		out:  "‛．\t～;γ＃␓ｐ６s\x03τｚx␑␄␀\x16\rβ％Cζ:c‛＞ν␊\t!",
	}, { // 1490
		mask: EncodeLtGt | EncodeLeftPeriod | EncodeRightCrLfHtVt,
		in:   ".\n～;γ＃␓ｐ６s\x03τｚx␑␄\x00\x16\rβ％Cζ:c＞ν␊\n!",
		out:  "．\n～;γ＃␓ｐ６s\x03τｚx␑␄␀\x16\rβ％Cζ:c‛＞ν␊\n!",
	}, { // 1491
		mask: EncodeLtGt | EncodeLeftPeriod | EncodeRightCrLfHtVt,
		in:   "．\n～;γ＃␓ｐ６s\x03τｚx␑␄\x00\x16\rβ％Cζ:c＞ν␊\n!",
		out:  "‛．\n～;γ＃␓ｐ６s\x03τｚx␑␄␀\x16\rβ％Cζ:c‛＞ν␊\n!",
	}, { // 1492
		mask: EncodeLtGt | EncodeLeftPeriod | EncodeRightCrLfHtVt,
		in:   ".\v～;γ＃␓ｐ６s\x03τｚx␑␄\x00\x16\rβ％Cζ:c＞ν␊\v!",
		out:  "．\v～;γ＃␓ｐ６s\x03τｚx␑␄␀\x16\rβ％Cζ:c‛＞ν␊\v!",
	}, { // 1493
		mask: EncodeLtGt | EncodeLeftPeriod | EncodeRightCrLfHtVt,
		in:   "．\v～;γ＃␓ｐ６s\x03τｚx␑␄\x00\x16\rβ％Cζ:c＞ν␊\v!",
		out:  "‛．\v～;γ＃␓ｐ６s\x03τｚx␑␄␀\x16\rβ％Cζ:c‛＞ν␊\v!",
	}, { // 1494
		mask: EncodeLtGt | EncodeLeftPeriod | EncodeRightCrLfHtVt,
		in:   ".\r～;γ＃␓ｐ６s\x03τｚx␑␄\x00\x16\rβ％Cζ:c＞ν␊\r!",
		out:  "．\r～;γ＃␓ｐ６s\x03τｚx␑␄␀\x16\rβ％Cζ:c‛＞ν␊\r!",
	}, { // 1495
		mask: EncodeLtGt | EncodeLeftPeriod | EncodeRightCrLfHtVt,
		in:   "．\r～;γ＃␓ｐ６s\x03τｚx␑␄\x00\x16\rβ％Cζ:c＞ν␊\r!",
		out:  "‛．\r～;γ＃␓ｐ６s\x03τｚx␑␄␀\x16\rβ％Cζ:c‛＞ν␊\r!",
	}, { // 1496
		mask: EncodeLtGt | EncodeLeftPeriod | EncodeRightCrLfHtVt,
		in:   "＞\t～;γ＃␓ｐ６s\x03τｚx␑␄\x00\x16\rβ％Cζ:c＞ν␊\t.",
		out:  "‛＞\t～;γ＃␓ｐ６s\x03τｚx␑␄␀\x16\rβ％Cζ:c‛＞ν␊\t.",
	}, { // 1497
		mask: EncodeLtGt | EncodeLeftPeriod | EncodeRightCrLfHtVt,
		in:   "＞\t～;γ＃␓ｐ６s\x03τｚx␑␄\x00\x16\rβ％Cζ:c＞ν␊\t．",
		out:  "‛＞\t～;γ＃␓ｐ６s\x03τｚx␑␄␀\x16\rβ％Cζ:c‛＞ν␊\t．",
	}, { // 1498
		mask: EncodeLtGt | EncodeLeftPeriod | EncodeRightCrLfHtVt,
		in:   "＞\n～;γ＃␓ｐ６s\x03τｚx␑␄\x00\x16\rβ％Cζ:c＞ν␊\n.",
		out:  "‛＞\n～;γ＃␓ｐ６s\x03τｚx␑␄␀\x16\rβ％Cζ:c‛＞ν␊\n.",
	}, { // 1499
		mask: EncodeLtGt | EncodeLeftPeriod | EncodeRightCrLfHtVt,
		in:   "＞\n～;γ＃␓ｐ６s\x03τｚx␑␄\x00\x16\rβ％Cζ:c＞ν␊\n．",
		out:  "‛＞\n～;γ＃␓ｐ６s\x03τｚx␑␄␀\x16\rβ％Cζ:c‛＞ν␊\n．",
	}, { // 1500
		mask: EncodeLtGt | EncodeLeftPeriod | EncodeRightCrLfHtVt,
		in:   "＞\v～;γ＃␓ｐ６s\x03τｚx␑␄\x00\x16\rβ％Cζ:c＞ν␊\v.",
		out:  "‛＞\v～;γ＃␓ｐ６s\x03τｚx␑␄␀\x16\rβ％Cζ:c‛＞ν␊\v.",
	}, { // 1501
		mask: EncodeLtGt | EncodeLeftPeriod | EncodeRightCrLfHtVt,
		in:   "＞\v～;γ＃␓ｐ６s\x03τｚx␑␄\x00\x16\rβ％Cζ:c＞ν␊\v．",
		out:  "‛＞\v～;γ＃␓ｐ６s\x03τｚx␑␄␀\x16\rβ％Cζ:c‛＞ν␊\v．",
	}, { // 1502
		mask: EncodeLtGt | EncodeLeftPeriod | EncodeRightCrLfHtVt,
		in:   "＞\r～;γ＃␓ｐ６s\x03τｚx␑␄\x00\x16\rβ％Cζ:c＞ν␊\r.",
		out:  "‛＞\r～;γ＃␓ｐ６s\x03τｚx␑␄␀\x16\rβ％Cζ:c‛＞ν␊\r.",
	}, { // 1503
		mask: EncodeLtGt | EncodeLeftPeriod | EncodeRightCrLfHtVt,
		in:   "＞\r～;γ＃␓ｐ６s\x03τｚx␑␄\x00\x16\rβ％Cζ:c＞ν␊\r．",
		out:  "‛＞\r～;γ＃␓ｐ６s\x03τｚx␑␄␀\x16\rβ％Cζ:c‛＞ν␊\r．",
	}, { // 1504
		mask: EncodeSquareBracket | EncodeLeftPeriod | EncodeRightCrLfHtVt,
		in:   ".\t␅␒\x1fλ|\"｜＄\x12␐3\x19␊ο＾-ρ４θ*δ#AZt｜\tｌ",
		out:  "．\t␅␒\x1fλ|\"｜＄\x12␐3\x19␊ο＾-ρ４θ*δ#AZt｜\tｌ",
	}, { // 1505
		mask: EncodeSquareBracket | EncodeLeftPeriod | EncodeRightCrLfHtVt,
		in:   "．\t␅␒\x1fλ|\"｜＄\x12␐3\x19␊ο＾-ρ４θ*δ#AZt｜\tｌ",
		out:  "‛．\t␅␒\x1fλ|\"｜＄\x12␐3\x19␊ο＾-ρ４θ*δ#AZt｜\tｌ",
	}, { // 1506
		mask: EncodeSquareBracket | EncodeLeftPeriod | EncodeRightCrLfHtVt,
		in:   ".\n␅␒\x1fλ|\"｜＄\x12␐3\x19␊ο＾-ρ４θ*δ#AZt｜\nｌ",
		out:  "．\n␅␒\x1fλ|\"｜＄\x12␐3\x19␊ο＾-ρ４θ*δ#AZt｜\nｌ",
	}, { // 1507
		mask: EncodeSquareBracket | EncodeLeftPeriod | EncodeRightCrLfHtVt,
		in:   "．\n␅␒\x1fλ|\"｜＄\x12␐3\x19␊ο＾-ρ４θ*δ#AZt｜\nｌ",
		out:  "‛．\n␅␒\x1fλ|\"｜＄\x12␐3\x19␊ο＾-ρ４θ*δ#AZt｜\nｌ",
	}, { // 1508
		mask: EncodeSquareBracket | EncodeLeftPeriod | EncodeRightCrLfHtVt,
		in:   ".\v␅␒\x1fλ|\"｜＄\x12␐3\x19␊ο＾-ρ４θ*δ#AZt｜\vｌ",
		out:  "．\v␅␒\x1fλ|\"｜＄\x12␐3\x19␊ο＾-ρ４θ*δ#AZt｜\vｌ",
	}, { // 1509
		mask: EncodeSquareBracket | EncodeLeftPeriod | EncodeRightCrLfHtVt,
		in:   "．\v␅␒\x1fλ|\"｜＄\x12␐3\x19␊ο＾-ρ４θ*δ#AZt｜\vｌ",
		out:  "‛．\v␅␒\x1fλ|\"｜＄\x12␐3\x19␊ο＾-ρ４θ*δ#AZt｜\vｌ",
	}, { // 1510
		mask: EncodeSquareBracket | EncodeLeftPeriod | EncodeRightCrLfHtVt,
		in:   ".\r␅␒\x1fλ|\"｜＄\x12␐3\x19␊ο＾-ρ４θ*δ#AZt｜\rｌ",
		out:  "．\r␅␒\x1fλ|\"｜＄\x12␐3\x19␊ο＾-ρ４θ*δ#AZt｜\rｌ",
	}, { // 1511
		mask: EncodeSquareBracket | EncodeLeftPeriod | EncodeRightCrLfHtVt,
		in:   "．\r␅␒\x1fλ|\"｜＄\x12␐3\x19␊ο＾-ρ４θ*δ#AZt｜\rｌ",
		out:  "‛．\r␅␒\x1fλ|\"｜＄\x12␐3\x19␊ο＾-ρ４θ*δ#AZt｜\rｌ",
	}, { // 1512
		mask: EncodeSquareBracket | EncodeLeftPeriod | EncodeRightCrLfHtVt,
		in:   "Ｙ\t␅␒\x1fλ|\"｜＄\x12␐3\x19␊ο＾-ρ４θ*δ#AZt｜\t.",
		out:  "Ｙ\t␅␒\x1fλ|\"｜＄\x12␐3\x19␊ο＾-ρ４θ*δ#AZt｜\t.",
	}, { // 1513
		mask: EncodeSquareBracket | EncodeLeftPeriod | EncodeRightCrLfHtVt,
		in:   "Ｙ\t␅␒\x1fλ|\"｜＄\x12␐3\x19␊ο＾-ρ４θ*δ#AZt｜\t．",
		out:  "Ｙ\t␅␒\x1fλ|\"｜＄\x12␐3\x19␊ο＾-ρ４θ*δ#AZt｜\t．",
	}, { // 1514
		mask: EncodeSquareBracket | EncodeLeftPeriod | EncodeRightCrLfHtVt,
		in:   "Ｙ\n␅␒\x1fλ|\"｜＄\x12␐3\x19␊ο＾-ρ４θ*δ#AZt｜\n.",
		out:  "Ｙ\n␅␒\x1fλ|\"｜＄\x12␐3\x19␊ο＾-ρ４θ*δ#AZt｜\n.",
	}, { // 1515
		mask: EncodeSquareBracket | EncodeLeftPeriod | EncodeRightCrLfHtVt,
		in:   "Ｙ\n␅␒\x1fλ|\"｜＄\x12␐3\x19␊ο＾-ρ４θ*δ#AZt｜\n．",
		out:  "Ｙ\n␅␒\x1fλ|\"｜＄\x12␐3\x19␊ο＾-ρ４θ*δ#AZt｜\n．",
	}, { // 1516
		mask: EncodeSquareBracket | EncodeLeftPeriod | EncodeRightCrLfHtVt,
		in:   "Ｙ\v␅␒\x1fλ|\"｜＄\x12␐3\x19␊ο＾-ρ４θ*δ#AZt｜\v.",
		out:  "Ｙ\v␅␒\x1fλ|\"｜＄\x12␐3\x19␊ο＾-ρ４θ*δ#AZt｜\v.",
	}, { // 1517
		mask: EncodeSquareBracket | EncodeLeftPeriod | EncodeRightCrLfHtVt,
		in:   "Ｙ\v␅␒\x1fλ|\"｜＄\x12␐3\x19␊ο＾-ρ４θ*δ#AZt｜\v．",
		out:  "Ｙ\v␅␒\x1fλ|\"｜＄\x12␐3\x19␊ο＾-ρ４θ*δ#AZt｜\v．",
	}, { // 1518
		mask: EncodeSquareBracket | EncodeLeftPeriod | EncodeRightCrLfHtVt,
		in:   "Ｙ\r␅␒\x1fλ|\"｜＄\x12␐3\x19␊ο＾-ρ４θ*δ#AZt｜\r.",
		out:  "Ｙ\r␅␒\x1fλ|\"｜＄\x12␐3\x19␊ο＾-ρ４θ*δ#AZt｜\r.",
	}, { // 1519
		mask: EncodeSquareBracket | EncodeLeftPeriod | EncodeRightCrLfHtVt,
		in:   "Ｙ\r␅␒\x1fλ|\"｜＄\x12␐3\x19␊ο＾-ρ４θ*δ#AZt｜\r．",
		out:  "Ｙ\r␅␒\x1fλ|\"｜＄\x12␐3\x19␊ο＾-ρ４θ*δ#AZt｜\r．",
	}, { // 1520
		mask: EncodeSemicolon | EncodeLeftPeriod | EncodeRightCrLfHtVt,
		in:   ".\tｍ／␖５θςbτ\tA=\bυ（：Ｓ９；b3yχ/␋\x10σ\t␆",
		out:  "．\tｍ／␖５θςbτ\tA=\bυ（：Ｓ９‛；b3yχ/␋\x10σ\t␆",
	}, { // 1521
		mask: EncodeSemicolon | EncodeLeftPeriod | EncodeRightCrLfHtVt,
		in:   "．\tｍ／␖５θςbτ\tA=\bυ（：Ｓ９；b3yχ/␋\x10σ\t␆",
		out:  "‛．\tｍ／␖５θςbτ\tA=\bυ（：Ｓ９‛；b3yχ/␋\x10σ\t␆",
	}, { // 1522
		mask: EncodeSemicolon | EncodeLeftPeriod | EncodeRightCrLfHtVt,
		in:   ".\nｍ／␖５θςbτ\tA=\bυ（：Ｓ９；b3yχ/␋\x10σ\n␆",
		out:  "．\nｍ／␖５θςbτ\tA=\bυ（：Ｓ９‛；b3yχ/␋\x10σ\n␆",
	}, { // 1523
		mask: EncodeSemicolon | EncodeLeftPeriod | EncodeRightCrLfHtVt,
		in:   "．\nｍ／␖５θςbτ\tA=\bυ（：Ｓ９；b3yχ/␋\x10σ\n␆",
		out:  "‛．\nｍ／␖５θςbτ\tA=\bυ（：Ｓ９‛；b3yχ/␋\x10σ\n␆",
	}, { // 1524
		mask: EncodeSemicolon | EncodeLeftPeriod | EncodeRightCrLfHtVt,
		in:   ".\vｍ／␖５θςbτ\tA=\bυ（：Ｓ９；b3yχ/␋\x10σ\v␆",
		out:  "．\vｍ／␖５θςbτ\tA=\bυ（：Ｓ９‛；b3yχ/␋\x10σ\v␆",
	}, { // 1525
		mask: EncodeSemicolon | EncodeLeftPeriod | EncodeRightCrLfHtVt,
		in:   "．\vｍ／␖５θςbτ\tA=\bυ（：Ｓ９；b3yχ/␋\x10σ\v␆",
		out:  "‛．\vｍ／␖５θςbτ\tA=\bυ（：Ｓ９‛；b3yχ/␋\x10σ\v␆",
	}, { // 1526
		mask: EncodeSemicolon | EncodeLeftPeriod | EncodeRightCrLfHtVt,
		in:   ".\rｍ／␖５θςbτ\tA=\bυ（：Ｓ９；b3yχ/␋\x10σ\r␆",
		out:  "．\rｍ／␖５θςbτ\tA=\bυ（：Ｓ９‛；b3yχ/␋\x10σ\r␆",
	}, { // 1527
		mask: EncodeSemicolon | EncodeLeftPeriod | EncodeRightCrLfHtVt,
		in:   "．\rｍ／␖５θςbτ\tA=\bυ（：Ｓ９；b3yχ/␋\x10σ\r␆",
		out:  "‛．\rｍ／␖５θςbτ\tA=\bυ（：Ｓ９‛；b3yχ/␋\x10σ\r␆",
	}, { // 1528
		mask: EncodeSemicolon | EncodeLeftPeriod | EncodeRightCrLfHtVt,
		in:   "`\tｍ／␖５θςbτ\tA=\bυ（：Ｓ９；b3yχ/␋\x10σ\t.",
		out:  "`\tｍ／␖５θςbτ\tA=\bυ（：Ｓ９‛；b3yχ/␋\x10σ\t.",
	}, { // 1529
		mask: EncodeSemicolon | EncodeLeftPeriod | EncodeRightCrLfHtVt,
		in:   "`\tｍ／␖５θςbτ\tA=\bυ（：Ｓ９；b3yχ/␋\x10σ\t．",
		out:  "`\tｍ／␖５θςbτ\tA=\bυ（：Ｓ９‛；b3yχ/␋\x10σ\t．",
	}, { // 1530
		mask: EncodeSemicolon | EncodeLeftPeriod | EncodeRightCrLfHtVt,
		in:   "`\nｍ／␖５θςbτ\tA=\bυ（：Ｓ９；b3yχ/␋\x10σ\n.",
		out:  "`\nｍ／␖５θςbτ\tA=\bυ（：Ｓ９‛；b3yχ/␋\x10σ\n.",
	}, { // 1531
		mask: EncodeSemicolon | EncodeLeftPeriod | EncodeRightCrLfHtVt,
		in:   "`\nｍ／␖５θςbτ\tA=\bυ（：Ｓ９；b3yχ/␋\x10σ\n．",
		out:  "`\nｍ／␖５θςbτ\tA=\bυ（：Ｓ９‛；b3yχ/␋\x10σ\n．",
	}, { // 1532
		mask: EncodeSemicolon | EncodeLeftPeriod | EncodeRightCrLfHtVt,
		in:   "`\vｍ／␖５θςbτ\tA=\bυ（：Ｓ９；b3yχ/␋\x10σ\v.",
		out:  "`\vｍ／␖５θςbτ\tA=\bυ（：Ｓ９‛；b3yχ/␋\x10σ\v.",
	}, { // 1533
		mask: EncodeSemicolon | EncodeLeftPeriod | EncodeRightCrLfHtVt,
		in:   "`\vｍ／␖５θςbτ\tA=\bυ（：Ｓ９；b3yχ/␋\x10σ\v．",
		out:  "`\vｍ／␖５θςbτ\tA=\bυ（：Ｓ９‛；b3yχ/␋\x10σ\v．",
	}, { // 1534
		mask: EncodeSemicolon | EncodeLeftPeriod | EncodeRightCrLfHtVt,
		in:   "`\rｍ／␖５θςbτ\tA=\bυ（：Ｓ９；b3yχ/␋\x10σ\r.",
		out:  "`\rｍ／␖５θςbτ\tA=\bυ（：Ｓ９‛；b3yχ/␋\x10σ\r.",
	}, { // 1535
		mask: EncodeSemicolon | EncodeLeftPeriod | EncodeRightCrLfHtVt,
		in:   "`\rｍ／␖５θςbτ\tA=\bυ（：Ｓ９；b3yχ/␋\x10σ\r．",
		out:  "`\rｍ／␖５θςbτ\tA=\bυ（：Ｓ９‛；b3yχ/␋\x10σ\r．",
	}, { // 1536
		mask: EncodeDollar | EncodeLeftPeriod | EncodeRightCrLfHtVt,
		in:   ".\t[<ςＱτh␎｀}\x1e␍\x14\"Ｙ␄ｓ]ｎ＊σb␡␁&ｈW\t\n",
		out:  "．\t[<ςＱτh␎｀}\x1e␍\x14\"Ｙ␄ｓ]ｎ＊σb␡␁&ｈW\t␊",
	}, { // 1537
		mask: EncodeDollar | EncodeLeftPeriod | EncodeRightCrLfHtVt,
		in:   "．\t[<ςＱτh␎｀}\x1e␍\x14\"Ｙ␄ｓ]ｎ＊σb␡␁&ｈW\t\n",
		out:  "‛．\t[<ςＱτh␎｀}\x1e␍\x14\"Ｙ␄ｓ]ｎ＊σb␡␁&ｈW\t␊",
	}, { // 1538
		mask: EncodeDollar | EncodeLeftPeriod | EncodeRightCrLfHtVt,
		in:   ".\n[<ςＱτh␎｀}\x1e␍\x14\"Ｙ␄ｓ]ｎ＊σb␡␁&ｈW\n\n",
		out:  "．\n[<ςＱτh␎｀}\x1e␍\x14\"Ｙ␄ｓ]ｎ＊σb␡␁&ｈW\n␊",
	}, { // 1539
		mask: EncodeDollar | EncodeLeftPeriod | EncodeRightCrLfHtVt,
		in:   "．\n[<ςＱτh␎｀}\x1e␍\x14\"Ｙ␄ｓ]ｎ＊σb␡␁&ｈW\n\n",
		out:  "‛．\n[<ςＱτh␎｀}\x1e␍\x14\"Ｙ␄ｓ]ｎ＊σb␡␁&ｈW\n␊",
	}, { // 1540
		mask: EncodeDollar | EncodeLeftPeriod | EncodeRightCrLfHtVt,
		in:   ".\v[<ςＱτh␎｀}\x1e␍\x14\"Ｙ␄ｓ]ｎ＊σb␡␁&ｈW\v\n",
		out:  "．\v[<ςＱτh␎｀}\x1e␍\x14\"Ｙ␄ｓ]ｎ＊σb␡␁&ｈW\v␊",
	}, { // 1541
		mask: EncodeDollar | EncodeLeftPeriod | EncodeRightCrLfHtVt,
		in:   "．\v[<ςＱτh␎｀}\x1e␍\x14\"Ｙ␄ｓ]ｎ＊σb␡␁&ｈW\v\n",
		out:  "‛．\v[<ςＱτh␎｀}\x1e␍\x14\"Ｙ␄ｓ]ｎ＊σb␡␁&ｈW\v␊",
	}, { // 1542
		mask: EncodeDollar | EncodeLeftPeriod | EncodeRightCrLfHtVt,
		in:   ".\r[<ςＱτh␎｀}\x1e␍\x14\"Ｙ␄ｓ]ｎ＊σb␡␁&ｈW\r\n",
		out:  "．\r[<ςＱτh␎｀}\x1e␍\x14\"Ｙ␄ｓ]ｎ＊σb␡␁&ｈW\r␊",
	}, { // 1543
		mask: EncodeDollar | EncodeLeftPeriod | EncodeRightCrLfHtVt,
		in:   "．\r[<ςＱτh␎｀}\x1e␍\x14\"Ｙ␄ｓ]ｎ＊σb␡␁&ｈW\r\n",
		out:  "‛．\r[<ςＱτh␎｀}\x1e␍\x14\"Ｙ␄ｓ]ｎ＊σb␡␁&ｈW\r␊",
	}, { // 1544
		mask: EncodeDollar | EncodeLeftPeriod | EncodeRightCrLfHtVt,
		in:   "η\t[<ςＱτh␎｀}\x1e␍\x14\"Ｙ␄ｓ]ｎ＊σb␡␁&ｈW\t.",
		out:  "η\t[<ςＱτh␎｀}\x1e␍\x14\"Ｙ␄ｓ]ｎ＊σb␡␁&ｈW\t.",
	}, { // 1545
		mask: EncodeDollar | EncodeLeftPeriod | EncodeRightCrLfHtVt,
		in:   "η\t[<ςＱτh␎｀}\x1e␍\x14\"Ｙ␄ｓ]ｎ＊σb␡␁&ｈW\t．",
		out:  "η\t[<ςＱτh␎｀}\x1e␍\x14\"Ｙ␄ｓ]ｎ＊σb␡␁&ｈW\t．",
	}, { // 1546
		mask: EncodeDollar | EncodeLeftPeriod | EncodeRightCrLfHtVt,
		in:   "η\n[<ςＱτh␎｀}\x1e␍\x14\"Ｙ␄ｓ]ｎ＊σb␡␁&ｈW\n.",
		out:  "η\n[<ςＱτh␎｀}\x1e␍\x14\"Ｙ␄ｓ]ｎ＊σb␡␁&ｈW\n.",
	}, { // 1547
		mask: EncodeDollar | EncodeLeftPeriod | EncodeRightCrLfHtVt,
		in:   "η\n[<ςＱτh␎｀}\x1e␍\x14\"Ｙ␄ｓ]ｎ＊σb␡␁&ｈW\n．",
		out:  "η\n[<ςＱτh␎｀}\x1e␍\x14\"Ｙ␄ｓ]ｎ＊σb␡␁&ｈW\n．",
	}, { // 1548
		mask: EncodeDollar | EncodeLeftPeriod | EncodeRightCrLfHtVt,
		in:   "η\v[<ςＱτh␎｀}\x1e␍\x14\"Ｙ␄ｓ]ｎ＊σb␡␁&ｈW\v.",
		out:  "η\v[<ςＱτh␎｀}\x1e␍\x14\"Ｙ␄ｓ]ｎ＊σb␡␁&ｈW\v.",
	}, { // 1549
		mask: EncodeDollar | EncodeLeftPeriod | EncodeRightCrLfHtVt,
		in:   "η\v[<ςＱτh␎｀}\x1e␍\x14\"Ｙ␄ｓ]ｎ＊σb␡␁&ｈW\v．",
		out:  "η\v[<ςＱτh␎｀}\x1e␍\x14\"Ｙ␄ｓ]ｎ＊σb␡␁&ｈW\v．",
	}, { // 1550
		mask: EncodeDollar | EncodeLeftPeriod | EncodeRightCrLfHtVt,
		in:   "η\r[<ςＱτh␎｀}\x1e␍\x14\"Ｙ␄ｓ]ｎ＊σb␡␁&ｈW\r.",
		out:  "η\r[<ςＱτh␎｀}\x1e␍\x14\"Ｙ␄ｓ]ｎ＊σb␡␁&ｈW\r.",
	}, { // 1551
		mask: EncodeDollar | EncodeLeftPeriod | EncodeRightCrLfHtVt,
		in:   "η\r[<ςＱτh␎｀}\x1e␍\x14\"Ｙ␄ｓ]ｎ＊σb␡␁&ｈW\r．",
		out:  "η\r[<ςＱτh␎｀}\x1e␍\x14\"Ｙ␄ｓ]ｎ＊σb␡␁&ｈW\r．",
	}, { // 1552
		mask: EncodeDoubleQuote | EncodeLeftPeriod | EncodeRightCrLfHtVt,
		in:   ".\t\x1f；\\ｔα\x04ω＄Xｒ＠ｓ␊ι␛␄␘Dλo＃\n/n\bｂ\tδ",
		out:  "．\t\x1f；\\ｔα\x04ω＄Xｒ＠ｓ␊ι␛␄␘Dλo＃\n/n\bｂ\tδ",
	}, { // 1553
		mask: EncodeDoubleQuote | EncodeLeftPeriod | EncodeRightCrLfHtVt,
		in:   "．\t\x1f；\\ｔα\x04ω＄Xｒ＠ｓ␊ι␛␄␘Dλo＃\n/n\bｂ\tδ",
		out:  "‛．\t\x1f；\\ｔα\x04ω＄Xｒ＠ｓ␊ι␛␄␘Dλo＃\n/n\bｂ\tδ",
	}, { // 1554
		mask: EncodeDoubleQuote | EncodeLeftPeriod | EncodeRightCrLfHtVt,
		in:   ".\n\x1f；\\ｔα\x04ω＄Xｒ＠ｓ␊ι␛␄␘Dλo＃\n/n\bｂ\nδ",
		out:  "．\n\x1f；\\ｔα\x04ω＄Xｒ＠ｓ␊ι␛␄␘Dλo＃\n/n\bｂ\nδ",
	}, { // 1555
		mask: EncodeDoubleQuote | EncodeLeftPeriod | EncodeRightCrLfHtVt,
		in:   "．\n\x1f；\\ｔα\x04ω＄Xｒ＠ｓ␊ι␛␄␘Dλo＃\n/n\bｂ\nδ",
		out:  "‛．\n\x1f；\\ｔα\x04ω＄Xｒ＠ｓ␊ι␛␄␘Dλo＃\n/n\bｂ\nδ",
	}, { // 1556
		mask: EncodeDoubleQuote | EncodeLeftPeriod | EncodeRightCrLfHtVt,
		in:   ".\v\x1f；\\ｔα\x04ω＄Xｒ＠ｓ␊ι␛␄␘Dλo＃\n/n\bｂ\vδ",
		out:  "．\v\x1f；\\ｔα\x04ω＄Xｒ＠ｓ␊ι␛␄␘Dλo＃\n/n\bｂ\vδ",
	}, { // 1557
		mask: EncodeDoubleQuote | EncodeLeftPeriod | EncodeRightCrLfHtVt,
		in:   "．\v\x1f；\\ｔα\x04ω＄Xｒ＠ｓ␊ι␛␄␘Dλo＃\n/n\bｂ\vδ",
		out:  "‛．\v\x1f；\\ｔα\x04ω＄Xｒ＠ｓ␊ι␛␄␘Dλo＃\n/n\bｂ\vδ",
	}, { // 1558
		mask: EncodeDoubleQuote | EncodeLeftPeriod | EncodeRightCrLfHtVt,
		in:   ".\r\x1f；\\ｔα\x04ω＄Xｒ＠ｓ␊ι␛␄␘Dλo＃\n/n\bｂ\rδ",
		out:  "．\r\x1f；\\ｔα\x04ω＄Xｒ＠ｓ␊ι␛␄␘Dλo＃\n/n\bｂ\rδ",
	}, { // 1559
		mask: EncodeDoubleQuote | EncodeLeftPeriod | EncodeRightCrLfHtVt,
		in:   "．\r\x1f；\\ｔα\x04ω＄Xｒ＠ｓ␊ι␛␄␘Dλo＃\n/n\bｂ\rδ",
		out:  "‛．\r\x1f；\\ｔα\x04ω＄Xｒ＠ｓ␊ι␛␄␘Dλo＃\n/n\bｂ\rδ",
	}, { // 1560
		mask: EncodeDoubleQuote | EncodeLeftPeriod | EncodeRightCrLfHtVt,
		in:   "[\t\x1f；\\ｔα\x04ω＄Xｒ＠ｓ␊ι␛␄␘Dλo＃\n/n\bｂ\t.",
		out:  "[\t\x1f；\\ｔα\x04ω＄Xｒ＠ｓ␊ι␛␄␘Dλo＃\n/n\bｂ\t.",
	}, { // 1561
		mask: EncodeDoubleQuote | EncodeLeftPeriod | EncodeRightCrLfHtVt,
		in:   "[\t\x1f；\\ｔα\x04ω＄Xｒ＠ｓ␊ι␛␄␘Dλo＃\n/n\bｂ\t．",
		out:  "[\t\x1f；\\ｔα\x04ω＄Xｒ＠ｓ␊ι␛␄␘Dλo＃\n/n\bｂ\t．",
	}, { // 1562
		mask: EncodeDoubleQuote | EncodeLeftPeriod | EncodeRightCrLfHtVt,
		in:   "[\n\x1f；\\ｔα\x04ω＄Xｒ＠ｓ␊ι␛␄␘Dλo＃\n/n\bｂ\n.",
		out:  "[\n\x1f；\\ｔα\x04ω＄Xｒ＠ｓ␊ι␛␄␘Dλo＃\n/n\bｂ\n.",
	}, { // 1563
		mask: EncodeDoubleQuote | EncodeLeftPeriod | EncodeRightCrLfHtVt,
		in:   "[\n\x1f；\\ｔα\x04ω＄Xｒ＠ｓ␊ι␛␄␘Dλo＃\n/n\bｂ\n．",
		out:  "[\n\x1f；\\ｔα\x04ω＄Xｒ＠ｓ␊ι␛␄␘Dλo＃\n/n\bｂ\n．",
	}, { // 1564
		mask: EncodeDoubleQuote | EncodeLeftPeriod | EncodeRightCrLfHtVt,
		in:   "[\v\x1f；\\ｔα\x04ω＄Xｒ＠ｓ␊ι␛␄␘Dλo＃\n/n\bｂ\v.",
		out:  "[\v\x1f；\\ｔα\x04ω＄Xｒ＠ｓ␊ι␛␄␘Dλo＃\n/n\bｂ\v.",
	}, { // 1565
		mask: EncodeDoubleQuote | EncodeLeftPeriod | EncodeRightCrLfHtVt,
		in:   "[\v\x1f；\\ｔα\x04ω＄Xｒ＠ｓ␊ι␛␄␘Dλo＃\n/n\bｂ\v．",
		out:  "[\v\x1f；\\ｔα\x04ω＄Xｒ＠ｓ␊ι␛␄␘Dλo＃\n/n\bｂ\v．",
	}, { // 1566
		mask: EncodeDoubleQuote | EncodeLeftPeriod | EncodeRightCrLfHtVt,
		in:   "[\r\x1f；\\ｔα\x04ω＄Xｒ＠ｓ␊ι␛␄␘Dλo＃\n/n\bｂ\r.",
		out:  "[\r\x1f；\\ｔα\x04ω＄Xｒ＠ｓ␊ι␛␄␘Dλo＃\n/n\bｂ\r.",
	}, { // 1567
		mask: EncodeDoubleQuote | EncodeLeftPeriod | EncodeRightCrLfHtVt,
		in:   "[\r\x1f；\\ｔα\x04ω＄Xｒ＠ｓ␊ι␛␄␘Dλo＃\n/n\bｂ\r．",
		out:  "[\r\x1f；\\ｔα\x04ω＄Xｒ＠ｓ␊ι␛␄␘Dλo＃\n/n\bｂ\r．",
	}, { // 1568
		mask: EncodeColon | EncodeLeftPeriod | EncodeRightCrLfHtVt,
		in:   ".\t\x17Ｖ␒␍９λφ+o\x1c1Nｅ\\␘＼１\x02ψβ；γρ{\uff00.\t␗",
		out:  "．\t\x17Ｖ␒␍９λφ+o\x1c1Nｅ\\␘＼１\x02ψβ；γρ{\uff00.\t␗",
	}, { // 1569
		mask: EncodeColon | EncodeLeftPeriod | EncodeRightCrLfHtVt,
		in:   "．\t\x17Ｖ␒␍９λφ+o\x1c1Nｅ\\␘＼１\x02ψβ；γρ{\uff00.\t␗",
		out:  "‛．\t\x17Ｖ␒␍９λφ+o\x1c1Nｅ\