#include "rheolef.h"
#include "sphere.h"
#include "helmholtz_band_assembly.h"
#include "banded_level_set_aux.h"
using namespace std;
using namespace rheolef;

// normal in X on C(0,1) is vector OX:
point normal (const point& x) { return x; }

int main (int argc, char**argv) {
  geo Lambda (argv[1]);
  Float tol = (argc > 2) ? atof(argv[2]) : 1e-10;
  size_t d = Lambda.dimension();
  space Vh (Lambda, "P1");
  field phi_h_lambda = interpolate(Vh, phi);
  geo band = banded_level_set (phi_h_lambda);

  // compute nh
  space Bh  (band, "P1");
  Bh.block("isolated");
  space Bvh (band, "P1", "vector");
  field phi_h = interpolate(Bh, phi);
  field nh = interpolate (Bvh, normal);

  // compute kappa_h = div_s(nh)
  form ms (Bh, Bh,  "mass_s", phi_h);
  form bs (Bvh, Bh, "div_s", phi_h);
  field lh = bs*nh;
  csr<Float> M = band_assembly<Float> (ms, phi_h);
  vec<Float> L(M.nrow(), 0.0);
  for (size_t i = 0; i < lh.u.size(); i++) L.at(i) = lh.u.at(i);
  for (size_t i = lh.u.size(); i < L.size(); i++) L.at(i) = 0;
  vec<Float> U (L.size());
  ssk<Float> fact_M = ldlt(M);
  U = fact_M.solve(L);
  field kappa_h(Bh);
  kappa_h.b = 0;
  for (size_t i = 0; i < kappa_h.u.size(); i++) kappa_h.u.at(i) = U.at(i);

  // kappa_h is defined on beta_h: restrict-it on Gamma_h
  field kappa_h_s = zero_level_set (kappa_h, phi_h);

  // kappa=1 : error may be zero, up to machine precision !
  field one (kappa_h_s.get_space(), 1.0);
  Float err = dot(kappa_h_s - one, kappa_h_s - one);
  cerr << "err = " << err << endl;
  cerr << "tol = " << tol << endl;
  return (err <= tol) ? 0 : 1;
}
