/*
 * Decompiled with CFR 0.152.
 */
package org.rosuda.REngine.Rserve;

import java.io.Serializable;
import org.rosuda.REngine.Rserve.RConnection;
import org.rosuda.REngine.Rserve.RserveException;
import org.rosuda.REngine.Rserve.protocol.RPacket;
import org.rosuda.REngine.Rserve.protocol.RTalk;

public class RSession
implements Serializable {
    private static final long serialVersionUID = -7048099825974875604L;
    String host;
    int port;
    byte[] key;
    transient RPacket attachPacket = null;
    int rsrvVersion;

    protected RSession() {
    }

    RSession(RConnection rConnection, RPacket rPacket) throws RserveException {
        this.host = rConnection.host;
        this.rsrvVersion = rConnection.rsrvVersion;
        byte[] byArray = rPacket.getCont();
        if (byArray == null || byArray.length != 44) {
            throw new RserveException(rConnection, "Invalid response to session detach request.");
        }
        this.port = RTalk.getInt(byArray, 4);
        this.key = new byte[32];
        System.arraycopy(byArray, 12, this.key, 0, 32);
    }

    public RConnection attach() throws RserveException {
        RConnection rConnection = new RConnection(this);
        this.attachPacket = rConnection.rt.request(-1);
        return rConnection;
    }
}

