// This file was generated by gir (https://github.com/gtk-rs/gir)
// from gir-files (https://github.com/gtk-rs/gir-files)
// DO NOT EDIT

use crate::{
    Adjustment, Align, Buildable, CellRenderer, Container, Entry, MovementStep, ResizeMode,
    Scrollable, ScrollablePolicy, Tooltip, TreeIter, TreeModel, TreePath, TreeSelection,
    TreeViewColumn, TreeViewDropPosition, TreeViewGridLines, Widget,
};
use glib::{
    prelude::*,
    signal::{connect_raw, SignalHandlerId},
    translate::*,
};
use std::{boxed::Box as Box_, fmt, mem, mem::transmute, ptr};

glib::wrapper! {
    #[doc(alias = "GtkTreeView")]
    pub struct TreeView(Object<ffi::GtkTreeView, ffi::GtkTreeViewClass>) @extends Container, Widget, @implements Buildable, Scrollable;

    match fn {
        type_ => || ffi::gtk_tree_view_get_type(),
    }
}

impl TreeView {
    pub const NONE: Option<&'static TreeView> = None;

    #[doc(alias = "gtk_tree_view_new")]
    pub fn new() -> TreeView {
        assert_initialized_main_thread!();
        unsafe { Widget::from_glib_none(ffi::gtk_tree_view_new()).unsafe_cast() }
    }

    #[doc(alias = "gtk_tree_view_new_with_model")]
    #[doc(alias = "new_with_model")]
    pub fn with_model(model: &impl IsA<TreeModel>) -> TreeView {
        skip_assert_initialized!();
        unsafe {
            Widget::from_glib_none(ffi::gtk_tree_view_new_with_model(
                model.as_ref().to_glib_none().0,
            ))
            .unsafe_cast()
        }
    }

    // rustdoc-stripper-ignore-next
    /// Creates a new builder-pattern struct instance to construct [`TreeView`] objects.
    ///
    /// This method returns an instance of [`TreeViewBuilder`](crate::builders::TreeViewBuilder) which can be used to create [`TreeView`] objects.
    pub fn builder() -> TreeViewBuilder {
        TreeViewBuilder::new()
    }
}

impl Default for TreeView {
    fn default() -> Self {
        Self::new()
    }
}

// rustdoc-stripper-ignore-next
/// A [builder-pattern] type to construct [`TreeView`] objects.
///
/// [builder-pattern]: https://doc.rust-lang.org/1.0.0/style/ownership/builders.html
#[must_use = "The builder must be built to be used"]
pub struct TreeViewBuilder {
    builder: glib::object::ObjectBuilder<'static, TreeView>,
}

impl TreeViewBuilder {
    fn new() -> Self {
        Self {
            builder: glib::object::Object::builder(),
        }
    }

    pub fn activate_on_single_click(self, activate_on_single_click: bool) -> Self {
        Self {
            builder: self
                .builder
                .property("activate-on-single-click", activate_on_single_click),
        }
    }

    pub fn enable_grid_lines(self, enable_grid_lines: TreeViewGridLines) -> Self {
        Self {
            builder: self
                .builder
                .property("enable-grid-lines", enable_grid_lines),
        }
    }

    pub fn enable_search(self, enable_search: bool) -> Self {
        Self {
            builder: self.builder.property("enable-search", enable_search),
        }
    }

    pub fn enable_tree_lines(self, enable_tree_lines: bool) -> Self {
        Self {
            builder: self
                .builder
                .property("enable-tree-lines", enable_tree_lines),
        }
    }

    pub fn expander_column(self, expander_column: &impl IsA<TreeViewColumn>) -> Self {
        Self {
            builder: self
                .builder
                .property("expander-column", expander_column.clone().upcast()),
        }
    }

    pub fn fixed_height_mode(self, fixed_height_mode: bool) -> Self {
        Self {
            builder: self
                .builder
                .property("fixed-height-mode", fixed_height_mode),
        }
    }

    pub fn headers_clickable(self, headers_clickable: bool) -> Self {
        Self {
            builder: self
                .builder
                .property("headers-clickable", headers_clickable),
        }
    }

    pub fn headers_visible(self, headers_visible: bool) -> Self {
        Self {
            builder: self.builder.property("headers-visible", headers_visible),
        }
    }

    pub fn hover_expand(self, hover_expand: bool) -> Self {
        Self {
            builder: self.builder.property("hover-expand", hover_expand),
        }
    }

    pub fn hover_selection(self, hover_selection: bool) -> Self {
        Self {
            builder: self.builder.property("hover-selection", hover_selection),
        }
    }

    pub fn level_indentation(self, level_indentation: i32) -> Self {
        Self {
            builder: self
                .builder
                .property("level-indentation", level_indentation),
        }
    }

    pub fn model(self, model: &impl IsA<TreeModel>) -> Self {
        Self {
            builder: self.builder.property("model", model.clone().upcast()),
        }
    }

    pub fn reorderable(self, reorderable: bool) -> Self {
        Self {
            builder: self.builder.property("reorderable", reorderable),
        }
    }

    pub fn rubber_banding(self, rubber_banding: bool) -> Self {
        Self {
            builder: self.builder.property("rubber-banding", rubber_banding),
        }
    }

    pub fn search_column(self, search_column: i32) -> Self {
        Self {
            builder: self.builder.property("search-column", search_column),
        }
    }

    pub fn show_expanders(self, show_expanders: bool) -> Self {
        Self {
            builder: self.builder.property("show-expanders", show_expanders),
        }
    }

    pub fn tooltip_column(self, tooltip_column: i32) -> Self {
        Self {
            builder: self.builder.property("tooltip-column", tooltip_column),
        }
    }

    pub fn border_width(self, border_width: u32) -> Self {
        Self {
            builder: self.builder.property("border-width", border_width),
        }
    }

    pub fn child(self, child: &impl IsA<Widget>) -> Self {
        Self {
            builder: self.builder.property("child", child.clone().upcast()),
        }
    }

    pub fn resize_mode(self, resize_mode: ResizeMode) -> Self {
        Self {
            builder: self.builder.property("resize-mode", resize_mode),
        }
    }

    pub fn app_paintable(self, app_paintable: bool) -> Self {
        Self {
            builder: self.builder.property("app-paintable", app_paintable),
        }
    }

    pub fn can_default(self, can_default: bool) -> Self {
        Self {
            builder: self.builder.property("can-default", can_default),
        }
    }

    pub fn can_focus(self, can_focus: bool) -> Self {
        Self {
            builder: self.builder.property("can-focus", can_focus),
        }
    }

    pub fn events(self, events: gdk::EventMask) -> Self {
        Self {
            builder: self.builder.property("events", events),
        }
    }

    pub fn expand(self, expand: bool) -> Self {
        Self {
            builder: self.builder.property("expand", expand),
        }
    }

    pub fn focus_on_click(self, focus_on_click: bool) -> Self {
        Self {
            builder: self.builder.property("focus-on-click", focus_on_click),
        }
    }

    pub fn halign(self, halign: Align) -> Self {
        Self {
            builder: self.builder.property("halign", halign),
        }
    }

    pub fn has_default(self, has_default: bool) -> Self {
        Self {
            builder: self.builder.property("has-default", has_default),
        }
    }

    pub fn has_focus(self, has_focus: bool) -> Self {
        Self {
            builder: self.builder.property("has-focus", has_focus),
        }
    }

    pub fn has_tooltip(self, has_tooltip: bool) -> Self {
        Self {
            builder: self.builder.property("has-tooltip", has_tooltip),
        }
    }

    pub fn height_request(self, height_request: i32) -> Self {
        Self {
            builder: self.builder.property("height-request", height_request),
        }
    }

    pub fn hexpand(self, hexpand: bool) -> Self {
        Self {
            builder: self.builder.property("hexpand", hexpand),
        }
    }

    pub fn hexpand_set(self, hexpand_set: bool) -> Self {
        Self {
            builder: self.builder.property("hexpand-set", hexpand_set),
        }
    }

    pub fn is_focus(self, is_focus: bool) -> Self {
        Self {
            builder: self.builder.property("is-focus", is_focus),
        }
    }

    pub fn margin(self, margin: i32) -> Self {
        Self {
            builder: self.builder.property("margin", margin),
        }
    }

    pub fn margin_bottom(self, margin_bottom: i32) -> Self {
        Self {
            builder: self.builder.property("margin-bottom", margin_bottom),
        }
    }

    pub fn margin_end(self, margin_end: i32) -> Self {
        Self {
            builder: self.builder.property("margin-end", margin_end),
        }
    }

    pub fn margin_start(self, margin_start: i32) -> Self {
        Self {
            builder: self.builder.property("margin-start", margin_start),
        }
    }

    pub fn margin_top(self, margin_top: i32) -> Self {
        Self {
            builder: self.builder.property("margin-top", margin_top),
        }
    }

    pub fn name(self, name: impl Into<glib::GString>) -> Self {
        Self {
            builder: self.builder.property("name", name.into()),
        }
    }

    pub fn no_show_all(self, no_show_all: bool) -> Self {
        Self {
            builder: self.builder.property("no-show-all", no_show_all),
        }
    }

    pub fn opacity(self, opacity: f64) -> Self {
        Self {
            builder: self.builder.property("opacity", opacity),
        }
    }

    pub fn parent(self, parent: &impl IsA<Container>) -> Self {
        Self {
            builder: self.builder.property("parent", parent.clone().upcast()),
        }
    }

    pub fn receives_default(self, receives_default: bool) -> Self {
        Self {
            builder: self.builder.property("receives-default", receives_default),
        }
    }

    pub fn sensitive(self, sensitive: bool) -> Self {
        Self {
            builder: self.builder.property("sensitive", sensitive),
        }
    }

    pub fn tooltip_markup(self, tooltip_markup: impl Into<glib::GString>) -> Self {
        Self {
            builder: self
                .builder
                .property("tooltip-markup", tooltip_markup.into()),
        }
    }

    pub fn tooltip_text(self, tooltip_text: impl Into<glib::GString>) -> Self {
        Self {
            builder: self.builder.property("tooltip-text", tooltip_text.into()),
        }
    }

    pub fn valign(self, valign: Align) -> Self {
        Self {
            builder: self.builder.property("valign", valign),
        }
    }

    pub fn vexpand(self, vexpand: bool) -> Self {
        Self {
            builder: self.builder.property("vexpand", vexpand),
        }
    }

    pub fn vexpand_set(self, vexpand_set: bool) -> Self {
        Self {
            builder: self.builder.property("vexpand-set", vexpand_set),
        }
    }

    pub fn visible(self, visible: bool) -> Self {
        Self {
            builder: self.builder.property("visible", visible),
        }
    }

    pub fn width_request(self, width_request: i32) -> Self {
        Self {
            builder: self.builder.property("width-request", width_request),
        }
    }

    pub fn hadjustment(self, hadjustment: &impl IsA<Adjustment>) -> Self {
        Self {
            builder: self
                .builder
                .property("hadjustment", hadjustment.clone().upcast()),
        }
    }

    pub fn hscroll_policy(self, hscroll_policy: ScrollablePolicy) -> Self {
        Self {
            builder: self.builder.property("hscroll-policy", hscroll_policy),
        }
    }

    pub fn vadjustment(self, vadjustment: &impl IsA<Adjustment>) -> Self {
        Self {
            builder: self
                .builder
                .property("vadjustment", vadjustment.clone().upcast()),
        }
    }

    pub fn vscroll_policy(self, vscroll_policy: ScrollablePolicy) -> Self {
        Self {
            builder: self.builder.property("vscroll-policy", vscroll_policy),
        }
    }

    // rustdoc-stripper-ignore-next
    /// Build the [`TreeView`].
    #[must_use = "Building the object from the builder is usually expensive and is not expected to have side effects"]
    pub fn build(self) -> TreeView {
        self.builder.build()
    }
}

mod sealed {
    pub trait Sealed {}
    impl<T: super::IsA<super::TreeView>> Sealed for T {}
}

pub trait TreeViewExt: IsA<TreeView> + sealed::Sealed + 'static {
    #[doc(alias = "gtk_tree_view_append_column")]
    fn append_column(&self, column: &impl IsA<TreeViewColumn>) -> i32 {
        unsafe {
            ffi::gtk_tree_view_append_column(
                self.as_ref().to_glib_none().0,
                column.as_ref().to_glib_none().0,
            )
        }
    }

    #[doc(alias = "gtk_tree_view_collapse_all")]
    fn collapse_all(&self) {
        unsafe {
            ffi::gtk_tree_view_collapse_all(self.as_ref().to_glib_none().0);
        }
    }

    #[doc(alias = "gtk_tree_view_collapse_row")]
    fn collapse_row(&self, path: &TreePath) -> bool {
        unsafe {
            from_glib(ffi::gtk_tree_view_collapse_row(
                self.as_ref().to_glib_none().0,
                mut_override(path.to_glib_none().0),
            ))
        }
    }

    #[doc(alias = "gtk_tree_view_columns_autosize")]
    fn columns_autosize(&self) {
        unsafe {
            ffi::gtk_tree_view_columns_autosize(self.as_ref().to_glib_none().0);
        }
    }

    #[doc(alias = "gtk_tree_view_convert_bin_window_to_tree_coords")]
    fn convert_bin_window_to_tree_coords(&self, bx: i32, by: i32) -> (i32, i32) {
        unsafe {
            let mut tx = mem::MaybeUninit::uninit();
            let mut ty = mem::MaybeUninit::uninit();
            ffi::gtk_tree_view_convert_bin_window_to_tree_coords(
                self.as_ref().to_glib_none().0,
                bx,
                by,
                tx.as_mut_ptr(),
                ty.as_mut_ptr(),
            );
            (tx.assume_init(), ty.assume_init())
        }
    }

    #[doc(alias = "gtk_tree_view_convert_bin_window_to_widget_coords")]
    fn convert_bin_window_to_widget_coords(&self, bx: i32, by: i32) -> (i32, i32) {
        unsafe {
            let mut wx = mem::MaybeUninit::uninit();
            let mut wy = mem::MaybeUninit::uninit();
            ffi::gtk_tree_view_convert_bin_window_to_widget_coords(
                self.as_ref().to_glib_none().0,
                bx,
                by,
                wx.as_mut_ptr(),
                wy.as_mut_ptr(),
            );
            (wx.assume_init(), wy.assume_init())
        }
    }

    #[doc(alias = "gtk_tree_view_convert_tree_to_bin_window_coords")]
    fn convert_tree_to_bin_window_coords(&self, tx: i32, ty: i32) -> (i32, i32) {
        unsafe {
            let mut bx = mem::MaybeUninit::uninit();
            let mut by = mem::MaybeUninit::uninit();
            ffi::gtk_tree_view_convert_tree_to_bin_window_coords(
                self.as_ref().to_glib_none().0,
                tx,
                ty,
                bx.as_mut_ptr(),
                by.as_mut_ptr(),
            );
            (bx.assume_init(), by.assume_init())
        }
    }

    #[doc(alias = "gtk_tree_view_convert_tree_to_widget_coords")]
    fn convert_tree_to_widget_coords(&self, tx: i32, ty: i32) -> (i32, i32) {
        unsafe {
            let mut wx = mem::MaybeUninit::uninit();
            let mut wy = mem::MaybeUninit::uninit();
            ffi::gtk_tree_view_convert_tree_to_widget_coords(
                self.as_ref().to_glib_none().0,
                tx,
                ty,
                wx.as_mut_ptr(),
                wy.as_mut_ptr(),
            );
            (wx.assume_init(), wy.assume_init())
        }
    }

    #[doc(alias = "gtk_tree_view_convert_widget_to_bin_window_coords")]
    fn convert_widget_to_bin_window_coords(&self, wx: i32, wy: i32) -> (i32, i32) {
        unsafe {
            let mut bx = mem::MaybeUninit::uninit();
            let mut by = mem::MaybeUninit::uninit();
            ffi::gtk_tree_view_convert_widget_to_bin_window_coords(
                self.as_ref().to_glib_none().0,
                wx,
                wy,
                bx.as_mut_ptr(),
                by.as_mut_ptr(),
            );
            (bx.assume_init(), by.assume_init())
        }
    }

    #[doc(alias = "gtk_tree_view_convert_widget_to_tree_coords")]
    fn convert_widget_to_tree_coords(&self, wx: i32, wy: i32) -> (i32, i32) {
        unsafe {
            let mut tx = mem::MaybeUninit::uninit();
            let mut ty = mem::MaybeUninit::uninit();
            ffi::gtk_tree_view_convert_widget_to_tree_coords(
                self.as_ref().to_glib_none().0,
                wx,
                wy,
                tx.as_mut_ptr(),
                ty.as_mut_ptr(),
            );
            (tx.assume_init(), ty.assume_init())
        }
    }

    #[doc(alias = "gtk_tree_view_create_row_drag_icon")]
    fn create_row_drag_icon(&self, path: &TreePath) -> Option<cairo::Surface> {
        unsafe {
            from_glib_full(ffi::gtk_tree_view_create_row_drag_icon(
                self.as_ref().to_glib_none().0,
                mut_override(path.to_glib_none().0),
            ))
        }
    }

    #[doc(alias = "gtk_tree_view_expand_all")]
    fn expand_all(&self) {
        unsafe {
            ffi::gtk_tree_view_expand_all(self.as_ref().to_glib_none().0);
        }
    }

    #[doc(alias = "gtk_tree_view_expand_row")]
    fn expand_row(&self, path: &TreePath, open_all: bool) -> bool {
        unsafe {
            from_glib(ffi::gtk_tree_view_expand_row(
                self.as_ref().to_glib_none().0,
                mut_override(path.to_glib_none().0),
                open_all.into_glib(),
            ))
        }
    }

    #[doc(alias = "gtk_tree_view_expand_to_path")]
    fn expand_to_path(&self, path: &TreePath) {
        unsafe {
            ffi::gtk_tree_view_expand_to_path(
                self.as_ref().to_glib_none().0,
                mut_override(path.to_glib_none().0),
            );
        }
    }

    #[doc(alias = "gtk_tree_view_get_activate_on_single_click")]
    #[doc(alias = "get_activate_on_single_click")]
    fn activates_on_single_click(&self) -> bool {
        unsafe {
            from_glib(ffi::gtk_tree_view_get_activate_on_single_click(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "gtk_tree_view_get_background_area")]
    #[doc(alias = "get_background_area")]
    fn background_area(
        &self,
        path: Option<&TreePath>,
        column: Option<&impl IsA<TreeViewColumn>>,
    ) -> gdk::Rectangle {
        unsafe {
            let mut rect = gdk::Rectangle::uninitialized();
            ffi::gtk_tree_view_get_background_area(
                self.as_ref().to_glib_none().0,
                mut_override(path.to_glib_none().0),
                column.map(|p| p.as_ref()).to_glib_none().0,
                rect.to_glib_none_mut().0,
            );
            rect
        }
    }

    #[doc(alias = "gtk_tree_view_get_bin_window")]
    #[doc(alias = "get_bin_window")]
    fn bin_window(&self) -> Option<gdk::Window> {
        unsafe {
            from_glib_none(ffi::gtk_tree_view_get_bin_window(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "gtk_tree_view_get_cell_area")]
    #[doc(alias = "get_cell_area")]
    fn cell_area(
        &self,
        path: Option<&TreePath>,
        column: Option<&impl IsA<TreeViewColumn>>,
    ) -> gdk::Rectangle {
        unsafe {
            let mut rect = gdk::Rectangle::uninitialized();
            ffi::gtk_tree_view_get_cell_area(
                self.as_ref().to_glib_none().0,
                mut_override(path.to_glib_none().0),
                column.map(|p| p.as_ref()).to_glib_none().0,
                rect.to_glib_none_mut().0,
            );
            rect
        }
    }

    #[doc(alias = "gtk_tree_view_get_column")]
    #[doc(alias = "get_column")]
    fn column(&self, n: i32) -> Option<TreeViewColumn> {
        unsafe {
            from_glib_none(ffi::gtk_tree_view_get_column(
                self.as_ref().to_glib_none().0,
                n,
            ))
        }
    }

    #[doc(alias = "gtk_tree_view_get_columns")]
    #[doc(alias = "get_columns")]
    fn columns(&self) -> Vec<TreeViewColumn> {
        unsafe {
            FromGlibPtrContainer::from_glib_container(ffi::gtk_tree_view_get_columns(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "gtk_tree_view_get_cursor")]
    #[doc(alias = "get_cursor")]
    fn cursor(&self) -> (Option<TreePath>, Option<TreeViewColumn>) {
        unsafe {
            let mut path = ptr::null_mut();
            let mut focus_column = ptr::null_mut();
            ffi::gtk_tree_view_get_cursor(
                self.as_ref().to_glib_none().0,
                &mut path,
                &mut focus_column,
            );
            (from_glib_full(path), from_glib_none(focus_column))
        }
    }

    #[doc(alias = "gtk_tree_view_get_dest_row_at_pos")]
    #[doc(alias = "get_dest_row_at_pos")]
    fn dest_row_at_pos(
        &self,
        drag_x: i32,
        drag_y: i32,
    ) -> Option<(Option<TreePath>, TreeViewDropPosition)> {
        unsafe {
            let mut path = ptr::null_mut();
            let mut pos = mem::MaybeUninit::uninit();
            let ret = from_glib(ffi::gtk_tree_view_get_dest_row_at_pos(
                self.as_ref().to_glib_none().0,
                drag_x,
                drag_y,
                &mut path,
                pos.as_mut_ptr(),
            ));
            if ret {
                Some((from_glib_full(path), from_glib(pos.assume_init())))
            } else {
                None
            }
        }
    }

    #[doc(alias = "gtk_tree_view_get_drag_dest_row")]
    #[doc(alias = "get_drag_dest_row")]
    fn drag_dest_row(&self) -> (Option<TreePath>, TreeViewDropPosition) {
        unsafe {
            let mut path = ptr::null_mut();
            let mut pos = mem::MaybeUninit::uninit();
            ffi::gtk_tree_view_get_drag_dest_row(
                self.as_ref().to_glib_none().0,
                &mut path,
                pos.as_mut_ptr(),
            );
            (from_glib_full(path), from_glib(pos.assume_init()))
        }
    }

    #[doc(alias = "gtk_tree_view_get_enable_search")]
    #[doc(alias = "get_enable_search")]
    fn enables_search(&self) -> bool {
        unsafe {
            from_glib(ffi::gtk_tree_view_get_enable_search(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "gtk_tree_view_get_enable_tree_lines")]
    #[doc(alias = "get_enable_tree_lines")]
    fn enables_tree_lines(&self) -> bool {
        unsafe {
            from_glib(ffi::gtk_tree_view_get_enable_tree_lines(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "gtk_tree_view_get_expander_column")]
    #[doc(alias = "get_expander_column")]
    fn expander_column(&self) -> Option<TreeViewColumn> {
        unsafe {
            from_glib_none(ffi::gtk_tree_view_get_expander_column(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "gtk_tree_view_get_fixed_height_mode")]
    #[doc(alias = "get_fixed_height_mode")]
    fn is_fixed_height_mode(&self) -> bool {
        unsafe {
            from_glib(ffi::gtk_tree_view_get_fixed_height_mode(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "gtk_tree_view_get_grid_lines")]
    #[doc(alias = "get_grid_lines")]
    fn grid_lines(&self) -> TreeViewGridLines {
        unsafe {
            from_glib(ffi::gtk_tree_view_get_grid_lines(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "gtk_tree_view_get_headers_clickable")]
    #[doc(alias = "get_headers_clickable")]
    fn is_headers_clickable(&self) -> bool {
        unsafe {
            from_glib(ffi::gtk_tree_view_get_headers_clickable(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "gtk_tree_view_get_headers_visible")]
    #[doc(alias = "get_headers_visible")]
    fn is_headers_visible(&self) -> bool {
        unsafe {
            from_glib(ffi::gtk_tree_view_get_headers_visible(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "gtk_tree_view_get_hover_expand")]
    #[doc(alias = "get_hover_expand")]
    fn hover_expands(&self) -> bool {
        unsafe {
            from_glib(ffi::gtk_tree_view_get_hover_expand(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "gtk_tree_view_get_hover_selection")]
    #[doc(alias = "get_hover_selection")]
    fn is_hover_selection(&self) -> bool {
        unsafe {
            from_glib(ffi::gtk_tree_view_get_hover_selection(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "gtk_tree_view_get_level_indentation")]
    #[doc(alias = "get_level_indentation")]
    fn level_indentation(&self) -> i32 {
        unsafe { ffi::gtk_tree_view_get_level_indentation(self.as_ref().to_glib_none().0) }
    }

    #[doc(alias = "gtk_tree_view_get_model")]
    #[doc(alias = "get_model")]
    fn model(&self) -> Option<TreeModel> {
        unsafe { from_glib_none(ffi::gtk_tree_view_get_model(self.as_ref().to_glib_none().0)) }
    }

    #[doc(alias = "gtk_tree_view_get_n_columns")]
    #[doc(alias = "get_n_columns")]
    fn n_columns(&self) -> u32 {
        unsafe { ffi::gtk_tree_view_get_n_columns(self.as_ref().to_glib_none().0) }
    }

    #[doc(alias = "gtk_tree_view_get_path_at_pos")]
    #[doc(alias = "get_path_at_pos")]
    fn path_at_pos(
        &self,
        x: i32,
        y: i32,
    ) -> Option<(Option<TreePath>, Option<TreeViewColumn>, i32, i32)> {
        unsafe {
            let mut path = ptr::null_mut();
            let mut column = ptr::null_mut();
            let mut cell_x = mem::MaybeUninit::uninit();
            let mut cell_y = mem::MaybeUninit::uninit();
            let ret = from_glib(ffi::gtk_tree_view_get_path_at_pos(
                self.as_ref().to_glib_none().0,
                x,
                y,
                &mut path,
                &mut column,
                cell_x.as_mut_ptr(),
                cell_y.as_mut_ptr(),
            ));
            if ret {
                Some((
                    from_glib_full(path),
                    from_glib_none(column),
                    cell_x.assume_init(),
                    cell_y.assume_init(),
                ))
            } else {
                None
            }
        }
    }

    #[doc(alias = "gtk_tree_view_get_reorderable")]
    #[doc(alias = "get_reorderable")]
    fn is_reorderable(&self) -> bool {
        unsafe {
            from_glib(ffi::gtk_tree_view_get_reorderable(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    //#[doc(alias = "gtk_tree_view_get_row_separator_func")]
    //#[doc(alias = "get_row_separator_func")]
    //fn row_separator_func(&self) -> Option<Box_<dyn Fn(&TreeModel, &TreeIter) -> bool + 'static>> {
    //    unsafe { TODO: call ffi:gtk_tree_view_get_row_separator_func() }
    //}

    #[doc(alias = "gtk_tree_view_get_rubber_banding")]
    #[doc(alias = "get_rubber_banding")]
    fn is_rubber_banding(&self) -> bool {
        unsafe {
            from_glib(ffi::gtk_tree_view_get_rubber_banding(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "gtk_tree_view_get_search_column")]
    #[doc(alias = "get_search_column")]
    fn search_column(&self) -> i32 {
        unsafe { ffi::gtk_tree_view_get_search_column(self.as_ref().to_glib_none().0) }
    }

    #[doc(alias = "gtk_tree_view_get_search_entry")]
    #[doc(alias = "get_search_entry")]
    fn search_entry(&self) -> Option<Entry> {
        unsafe {
            from_glib_none(ffi::gtk_tree_view_get_search_entry(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    //#[doc(alias = "gtk_tree_view_get_search_equal_func")]
    //#[doc(alias = "get_search_equal_func")]
    //fn search_equal_func(&self) -> Option<Box_<dyn Fn(&TreeModel, i32, &str, &TreeIter) -> bool + 'static>> {
    //    unsafe { TODO: call ffi:gtk_tree_view_get_search_equal_func() }
    //}

    //#[doc(alias = "gtk_tree_view_get_search_position_func")]
    //#[doc(alias = "get_search_position_func")]
    //fn search_position_func(&self) -> Option<Box_<dyn Fn(&TreeView, &Widget) + 'static>> {
    //    unsafe { TODO: call ffi:gtk_tree_view_get_search_position_func() }
    //}

    #[doc(alias = "gtk_tree_view_get_selection")]
    #[doc(alias = "get_selection")]
    fn selection(&self) -> TreeSelection {
        unsafe {
            from_glib_none(ffi::gtk_tree_view_get_selection(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "gtk_tree_view_get_show_expanders")]
    #[doc(alias = "get_show_expanders")]
    fn shows_expanders(&self) -> bool {
        unsafe {
            from_glib(ffi::gtk_tree_view_get_show_expanders(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "gtk_tree_view_get_tooltip_column")]
    #[doc(alias = "get_tooltip_column")]
    fn tooltip_column(&self) -> i32 {
        unsafe { ffi::gtk_tree_view_get_tooltip_column(self.as_ref().to_glib_none().0) }
    }

    #[doc(alias = "gtk_tree_view_get_tooltip_context")]
    #[doc(alias = "get_tooltip_context")]
    fn tooltip_context(
        &self,
        x: &mut i32,
        y: &mut i32,
        keyboard_tip: bool,
    ) -> Option<(Option<TreeModel>, TreePath, TreeIter)> {
        unsafe {
            let mut model = ptr::null_mut();
            let mut path = ptr::null_mut();
            let mut iter = TreeIter::uninitialized();
            let ret = from_glib(ffi::gtk_tree_view_get_tooltip_context(
                self.as_ref().to_glib_none().0,
                x,
                y,
                keyboard_tip.into_glib(),
                &mut model,
                &mut path,
                iter.to_glib_none_mut().0,
            ));
            if ret {
                Some((from_glib_none(model), from_glib_full(path), iter))
            } else {
                None
            }
        }
    }

    #[doc(alias = "gtk_tree_view_get_visible_range")]
    #[doc(alias = "get_visible_range")]
    fn visible_range(&self) -> Option<(TreePath, TreePath)> {
        unsafe {
            let mut start_path = ptr::null_mut();
            let mut end_path = ptr::null_mut();
            let ret = from_glib(ffi::gtk_tree_view_get_visible_range(
                self.as_ref().to_glib_none().0,
                &mut start_path,
                &mut end_path,
            ));
            if ret {
                Some((from_glib_full(start_path), from_glib_full(end_path)))
            } else {
                None
            }
        }
    }

    #[doc(alias = "gtk_tree_view_get_visible_rect")]
    #[doc(alias = "get_visible_rect")]
    fn visible_rect(&self) -> gdk::Rectangle {
        unsafe {
            let mut visible_rect = gdk::Rectangle::uninitialized();
            ffi::gtk_tree_view_get_visible_rect(
                self.as_ref().to_glib_none().0,
                visible_rect.to_glib_none_mut().0,
            );
            visible_rect
        }
    }

    #[doc(alias = "gtk_tree_view_insert_column")]
    fn insert_column(&self, column: &impl IsA<TreeViewColumn>, position: i32) -> i32 {
        unsafe {
            ffi::gtk_tree_view_insert_column(
                self.as_ref().to_glib_none().0,
                column.as_ref().to_glib_none().0,
                position,
            )
        }
    }

    //#[doc(alias = "gtk_tree_view_insert_column_with_attributes")]
    //fn insert_column_with_attributes(&self, position: i32, title: &str, cell: &impl IsA<CellRenderer>, : /*Unknown conversion*//*Unimplemented*/Basic: VarArgs) -> i32 {
    //    unsafe { TODO: call ffi:gtk_tree_view_insert_column_with_attributes() }
    //}

    #[doc(alias = "gtk_tree_view_insert_column_with_data_func")]
    fn insert_column_with_data_func<
        P: Fn(&TreeViewColumn, &CellRenderer, &TreeModel, &TreeIter) + 'static,
    >(
        &self,
        position: i32,
        title: &str,
        cell: &impl IsA<CellRenderer>,
        func: P,
    ) -> i32 {
        let func_data: Box_<P> = Box_::new(func);
        unsafe extern "C" fn func_func<
            P: Fn(&TreeViewColumn, &CellRenderer, &TreeModel, &TreeIter) + 'static,
        >(
            tree_column: *mut ffi::GtkTreeViewColumn,
            cell: *mut ffi::GtkCellRenderer,
            tree_model: *mut ffi::GtkTreeModel,
            iter: *mut ffi::GtkTreeIter,
            data: glib::ffi::gpointer,
        ) {
            let tree_column = from_glib_borrow(tree_column);
            let cell = from_glib_borrow(cell);
            let tree_model = from_glib_borrow(tree_model);
            let iter = from_glib_borrow(iter);
            let callback: &P = &*(data as *mut _);
            (*callback)(&tree_column, &cell, &tree_model, &iter)
        }
        let func = Some(func_func::<P> as _);
        unsafe extern "C" fn dnotify_func<
            P: Fn(&TreeViewColumn, &CellRenderer, &TreeModel, &TreeIter) + 'static,
        >(
            data: glib::ffi::gpointer,
        ) {
            let _callback: Box_<P> = Box_::from_raw(data as *mut _);
        }
        let destroy_call6 = Some(dnotify_func::<P> as _);
        let super_callback0: Box_<P> = func_data;
        unsafe {
            ffi::gtk_tree_view_insert_column_with_data_func(
                self.as_ref().to_glib_none().0,
                position,
                title.to_glib_none().0,
                cell.as_ref().to_glib_none().0,
                func,
                Box_::into_raw(super_callback0) as *mut _,
                destroy_call6,
            )
        }
    }

    #[doc(alias = "gtk_tree_view_is_blank_at_pos")]
    fn is_blank_at_pos(
        &self,
        x: i32,
        y: i32,
    ) -> Option<(Option<TreePath>, Option<TreeViewColumn>, i32, i32)> {
        unsafe {
            let mut path = ptr::null_mut();
            let mut column = ptr::null_mut();
            let mut cell_x = mem::MaybeUninit::uninit();
            let mut cell_y = mem::MaybeUninit::uninit();
            let ret = from_glib(ffi::gtk_tree_view_is_blank_at_pos(
                self.as_ref().to_glib_none().0,
                x,
                y,
                &mut path,
                &mut column,
                cell_x.as_mut_ptr(),
                cell_y.as_mut_ptr(),
            ));
            if ret {
                Some((
                    from_glib_full(path),
                    from_glib_none(column),
                    cell_x.assume_init(),
                    cell_y.assume_init(),
                ))
            } else {
                None
            }
        }
    }

    #[doc(alias = "gtk_tree_view_is_rubber_banding_active")]
    fn is_rubber_banding_active(&self) -> bool {
        unsafe {
            from_glib(ffi::gtk_tree_view_is_rubber_banding_active(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "gtk_tree_view_map_expanded_rows")]
    fn map_expanded_rows<P: FnMut(&TreeView, &TreePath)>(&self, func: P) {
        let func_data: P = func;
        unsafe extern "C" fn func_func<P: FnMut(&TreeView, &TreePath)>(
            tree_view: *mut ffi::GtkTreeView,
            path: *mut ffi::GtkTreePath,
            user_data: glib::ffi::gpointer,
        ) {
            let tree_view = from_glib_borrow(tree_view);
            let path = from_glib_borrow(path);
            let callback: *mut P = user_data as *const _ as usize as *mut P;
            (*callback)(&tree_view, &path)
        }
        let func = Some(func_func::<P> as _);
        let super_callback0: &P = &func_data;
        unsafe {
            ffi::gtk_tree_view_map_expanded_rows(
                self.as_ref().to_glib_none().0,
                func,
                super_callback0 as *const _ as usize as *mut _,
            );
        }
    }

    #[doc(alias = "gtk_tree_view_move_column_after")]
    fn move_column_after(
        &self,
        column: &impl IsA<TreeViewColumn>,
        base_column: Option<&impl IsA<TreeViewColumn>>,
    ) {
        unsafe {
            ffi::gtk_tree_view_move_column_after(
                self.as_ref().to_glib_none().0,
                column.as_ref().to_glib_none().0,
                base_column.map(|p| p.as_ref()).to_glib_none().0,
            );
        }
    }

    #[doc(alias = "gtk_tree_view_remove_column")]
    fn remove_column(&self, column: &impl IsA<TreeViewColumn>) -> i32 {
        unsafe {
            ffi::gtk_tree_view_remove_column(
                self.as_ref().to_glib_none().0,
                column.as_ref().to_glib_none().0,
            )
        }
    }

    #[doc(alias = "gtk_tree_view_row_activated")]
    fn row_activated(&self, path: &TreePath, column: &impl IsA<TreeViewColumn>) {
        unsafe {
            ffi::gtk_tree_view_row_activated(
                self.as_ref().to_glib_none().0,
                mut_override(path.to_glib_none().0),
                column.as_ref().to_glib_none().0,
            );
        }
    }

    #[doc(alias = "gtk_tree_view_row_expanded")]
    fn row_expanded(&self, path: &TreePath) -> bool {
        unsafe {
            from_glib(ffi::gtk_tree_view_row_expanded(
                self.as_ref().to_glib_none().0,
                mut_override(path.to_glib_none().0),
            ))
        }
    }

    #[doc(alias = "gtk_tree_view_scroll_to_cell")]
    fn scroll_to_cell(
        &self,
        path: Option<&TreePath>,
        column: Option<&impl IsA<TreeViewColumn>>,
        use_align: bool,
        row_align: f32,
        col_align: f32,
    ) {
        unsafe {
            ffi::gtk_tree_view_scroll_to_cell(
                self.as_ref().to_glib_none().0,
                mut_override(path.to_glib_none().0),
                column.map(|p| p.as_ref()).to_glib_none().0,
                use_align.into_glib(),
                row_align,
                col_align,
            );
        }
    }

    #[doc(alias = "gtk_tree_view_scroll_to_point")]
    fn scroll_to_point(&self, tree_x: i32, tree_y: i32) {
        unsafe {
            ffi::gtk_tree_view_scroll_to_point(self.as_ref().to_glib_none().0, tree_x, tree_y);
        }
    }

    #[doc(alias = "gtk_tree_view_set_activate_on_single_click")]
    fn set_activate_on_single_click(&self, single: bool) {
        unsafe {
            ffi::gtk_tree_view_set_activate_on_single_click(
                self.as_ref().to_glib_none().0,
                single.into_glib(),
            );
        }
    }

    #[doc(alias = "gtk_tree_view_set_column_drag_function")]
    fn set_column_drag_function(
        &self,
        func: Option<
            Box_<
                dyn Fn(&TreeView, &TreeViewColumn, &TreeViewColumn, &TreeViewColumn) -> bool
                    + 'static,
            >,
        >,
    ) {
        let func_data: Box_<
            Option<
                Box_<
                    dyn Fn(&TreeView, &TreeViewColumn, &TreeViewColumn, &TreeViewColumn) -> bool
                        + 'static,
                >,
            >,
        > = Box_::new(func);
        unsafe extern "C" fn func_func(
            tree_view: *mut ffi::GtkTreeView,
            column: *mut ffi::GtkTreeViewColumn,
            prev_column: *mut ffi::GtkTreeViewColumn,
            next_column: *mut ffi::GtkTreeViewColumn,
            data: glib::ffi::gpointer,
        ) -> glib::ffi::gboolean {
            let tree_view = from_glib_borrow(tree_view);
            let column = from_glib_borrow(column);
            let prev_column = from_glib_borrow(prev_column);
            let next_column = from_glib_borrow(next_column);
            let callback: &Option<
                Box_<
                    dyn Fn(&TreeView, &TreeViewColumn, &TreeViewColumn, &TreeViewColumn) -> bool
                        + 'static,
                >,
            > = &*(data as *mut _);
            if let Some(ref callback) = *callback {
                callback(&tree_view, &column, &prev_column, &next_column)
            } else {
                panic!("cannot get closure...")
            }
            .into_glib()
        }
        let func = if func_data.is_some() {
            Some(func_func as _)
        } else {
            None
        };
        unsafe extern "C" fn destroy_func(data: glib::ffi::gpointer) {
            let _callback: Box_<
                Option<
                    Box_<
                        dyn Fn(&TreeView, &TreeViewColumn, &TreeViewColumn, &TreeViewColumn) -> bool
                            + 'static,
                    >,
                >,
            > = Box_::from_raw(data as *mut _);
        }
        let destroy_call3 = Some(destroy_func as _);
        let super_callback0: Box_<
            Option<
                Box_<
                    dyn Fn(&TreeView, &TreeViewColumn, &TreeViewColumn, &TreeViewColumn) -> bool
                        + 'static,
                >,
            >,
        > = func_data;
        unsafe {
            ffi::gtk_tree_view_set_column_drag_function(
                self.as_ref().to_glib_none().0,
                func,
                Box_::into_raw(super_callback0) as *mut _,
                destroy_call3,
            );
        }
    }

    #[doc(alias = "gtk_tree_view_set_cursor")]
    fn set_cursor(
        &self,
        path: &TreePath,
        focus_column: Option<&impl IsA<TreeViewColumn>>,
        start_editing: bool,
    ) {
        unsafe {
            ffi::gtk_tree_view_set_cursor(
                self.as_ref().to_glib_none().0,
                mut_override(path.to_glib_none().0),
                focus_column.map(|p| p.as_ref()).to_glib_none().0,
                start_editing.into_glib(),
            );
        }
    }

    #[doc(alias = "gtk_tree_view_set_cursor_on_cell")]
    fn set_cursor_on_cell(
        &self,
        path: &TreePath,
        focus_column: Option<&impl IsA<TreeViewColumn>>,
        focus_cell: Option<&impl IsA<CellRenderer>>,
        start_editing: bool,
    ) {
        unsafe {
            ffi::gtk_tree_view_set_cursor_on_cell(
                self.as_ref().to_glib_none().0,
                mut_override(path.to_glib_none().0),
                focus_column.map(|p| p.as_ref()).to_glib_none().0,
                focus_cell.map(|p| p.as_ref()).to_glib_none().0,
                start_editing.into_glib(),
            );
        }
    }

    #[doc(alias = "gtk_tree_view_set_drag_dest_row")]
    fn set_drag_dest_row(&self, path: Option<&TreePath>, pos: TreeViewDropPosition) {
        unsafe {
            ffi::gtk_tree_view_set_drag_dest_row(
                self.as_ref().to_glib_none().0,
                mut_override(path.to_glib_none().0),
                pos.into_glib(),
            );
        }
    }

    #[doc(alias = "gtk_tree_view_set_enable_search")]
    fn set_enable_search(&self, enable_search: bool) {
        unsafe {
            ffi::gtk_tree_view_set_enable_search(
                self.as_ref().to_glib_none().0,
                enable_search.into_glib(),
            );
        }
    }

    #[doc(alias = "gtk_tree_view_set_enable_tree_lines")]
    fn set_enable_tree_lines(&self, enabled: bool) {
        unsafe {
            ffi::gtk_tree_view_set_enable_tree_lines(
                self.as_ref().to_glib_none().0,
                enabled.into_glib(),
            );
        }
    }

    #[doc(alias = "gtk_tree_view_set_expander_column")]
    fn set_expander_column(&self, column: Option<&impl IsA<TreeViewColumn>>) {
        unsafe {
            ffi::gtk_tree_view_set_expander_column(
                self.as_ref().to_glib_none().0,
                column.map(|p| p.as_ref()).to_glib_none().0,
            );
        }
    }

    #[doc(alias = "gtk_tree_view_set_fixed_height_mode")]
    fn set_fixed_height_mode(&self, enable: bool) {
        unsafe {
            ffi::gtk_tree_view_set_fixed_height_mode(
                self.as_ref().to_glib_none().0,
                enable.into_glib(),
            );
        }
    }

    #[doc(alias = "gtk_tree_view_set_grid_lines")]
    fn set_grid_lines(&self, grid_lines: TreeViewGridLines) {
        unsafe {
            ffi::gtk_tree_view_set_grid_lines(
                self.as_ref().to_glib_none().0,
                grid_lines.into_glib(),
            );
        }
    }

    #[doc(alias = "gtk_tree_view_set_headers_clickable")]
    fn set_headers_clickable(&self, setting: bool) {
        unsafe {
            ffi::gtk_tree_view_set_headers_clickable(
                self.as_ref().to_glib_none().0,
                setting.into_glib(),
            );
        }
    }

    #[doc(alias = "gtk_tree_view_set_headers_visible")]
    fn set_headers_visible(&self, headers_visible: bool) {
        unsafe {
            ffi::gtk_tree_view_set_headers_visible(
                self.as_ref().to_glib_none().0,
                headers_visible.into_glib(),
            );
        }
    }

    #[doc(alias = "gtk_tree_view_set_hover_expand")]
    fn set_hover_expand(&self, expand: bool) {
        unsafe {
            ffi::gtk_tree_view_set_hover_expand(self.as_ref().to_glib_none().0, expand.into_glib());
        }
    }

    #[doc(alias = "gtk_tree_view_set_hover_selection")]
    fn set_hover_selection(&self, hover: bool) {
        unsafe {
            ffi::gtk_tree_view_set_hover_selection(
                self.as_ref().to_glib_none().0,
                hover.into_glib(),
            );
        }
    }

    #[doc(alias = "gtk_tree_view_set_level_indentation")]
    fn set_level_indentation(&self, indentation: i32) {
        unsafe {
            ffi::gtk_tree_view_set_level_indentation(self.as_ref().to_glib_none().0, indentation);
        }
    }

    #[doc(alias = "gtk_tree_view_set_model")]
    fn set_model(&self, model: Option<&impl IsA<TreeModel>>) {
        unsafe {
            ffi::gtk_tree_view_set_model(
                self.as_ref().to_glib_none().0,
                model.map(|p| p.as_ref()).to_glib_none().0,
            );
        }
    }

    #[doc(alias = "gtk_tree_view_set_reorderable")]
    fn set_reorderable(&self, reorderable: bool) {
        unsafe {
            ffi::gtk_tree_view_set_reorderable(
                self.as_ref().to_glib_none().0,
                reorderable.into_glib(),
            );
        }
    }

    #[doc(alias = "gtk_tree_view_set_row_separator_func")]
    fn set_row_separator_func(
        &self,
        func: Option<Box_<dyn Fn(&TreeModel, &TreeIter) -> bool + 'static>>,
    ) {
        let func_data: Box_<Option<Box_<dyn Fn(&TreeModel, &TreeIter) -> bool + 'static>>> =
            Box_::new(func);
        unsafe extern "C" fn func_func(
            model: *mut ffi::GtkTreeModel,
            iter: *mut ffi::GtkTreeIter,
            data: glib::ffi::gpointer,
        ) -> glib::ffi::gboolean {
            let model = from_glib_borrow(model);
            let iter = from_glib_borrow(iter);
            let callback: &Option<Box_<dyn Fn(&TreeModel, &TreeIter) -> bool + 'static>> =
                &*(data as *mut _);
            if let Some(ref callback) = *callback {
                callback(&model, &iter)
            } else {
                panic!("cannot get closure...")
            }
            .into_glib()
        }
        let func = if func_data.is_some() {
            Some(func_func as _)
        } else {
            None
        };
        unsafe extern "C" fn destroy_func(data: glib::ffi::gpointer) {
            let _callback: Box_<Option<Box_<dyn Fn(&TreeModel, &TreeIter) -> bool + 'static>>> =
                Box_::from_raw(data as *mut _);
        }
        let destroy_call3 = Some(destroy_func as _);
        let super_callback0: Box_<Option<Box_<dyn Fn(&TreeModel, &TreeIter) -> bool + 'static>>> =
            func_data;
        unsafe {
            ffi::gtk_tree_view_set_row_separator_func(
                self.as_ref().to_glib_none().0,
                func,
                Box_::into_raw(super_callback0) as *mut _,
                destroy_call3,
            );
        }
    }

    #[doc(alias = "gtk_tree_view_set_rubber_banding")]
    fn set_rubber_banding(&self, enable: bool) {
        unsafe {
            ffi::gtk_tree_view_set_rubber_banding(
                self.as_ref().to_glib_none().0,
                enable.into_glib(),
            );
        }
    }

    #[doc(alias = "gtk_tree_view_set_search_column")]
    fn set_search_column(&self, column: i32) {
        unsafe {
            ffi::gtk_tree_view_set_search_column(self.as_ref().to_glib_none().0, column);
        }
    }

    #[doc(alias = "gtk_tree_view_set_search_entry")]
    fn set_search_entry(&self, entry: Option<&impl IsA<Entry>>) {
        unsafe {
            ffi::gtk_tree_view_set_search_entry(
                self.as_ref().to_glib_none().0,
                entry.map(|p| p.as_ref()).to_glib_none().0,
            );
        }
    }

    #[doc(alias = "gtk_tree_view_set_search_equal_func")]
    fn set_search_equal_func<P: Fn(&TreeModel, i32, &str, &TreeIter) -> bool + 'static>(
        &self,
        search_equal_func: P,
    ) {
        let search_equal_func_data: Box_<P> = Box_::new(search_equal_func);
        unsafe extern "C" fn search_equal_func_func<
            P: Fn(&TreeModel, i32, &str, &TreeIter) -> bool + 'static,
        >(
            model: *mut ffi::GtkTreeModel,
            column: libc::c_int,
            key: *const libc::c_char,
            iter: *mut ffi::GtkTreeIter,
            search_data: glib::ffi::gpointer,
        ) -> glib::ffi::gboolean {
            let model = from_glib_borrow(model);
            let key: Borrowed<glib::GString> = from_glib_borrow(key);
            let iter = from_glib_borrow(iter);
            let callback: &P = &*(search_data as *mut _);
            (*callback)(&model, column, key.as_str(), &iter).into_glib()
        }
        let search_equal_func = Some(search_equal_func_func::<P> as _);
        unsafe extern "C" fn search_destroy_func<
            P: Fn(&TreeModel, i32, &str, &TreeIter) -> bool + 'static,
        >(
            data: glib::ffi::gpointer,
        ) {
            let _callback: Box_<P> = Box_::from_raw(data as *mut _);
        }
        let destroy_call3 = Some(search_destroy_func::<P> as _);
        let super_callback0: Box_<P> = search_equal_func_data;
        unsafe {
            ffi::gtk_tree_view_set_search_equal_func(
                self.as_ref().to_glib_none().0,
                search_equal_func,
                Box_::into_raw(super_callback0) as *mut _,
                destroy_call3,
            );
        }
    }

    #[doc(alias = "gtk_tree_view_set_search_position_func")]
    fn set_search_position_func(&self, func: Option<Box_<dyn Fn(&TreeView, &Widget) + 'static>>) {
        let func_data: Box_<Option<Box_<dyn Fn(&TreeView, &Widget) + 'static>>> = Box_::new(func);
        unsafe extern "C" fn func_func(
            tree_view: *mut ffi::GtkTreeView,
            search_dialog: *mut ffi::GtkWidget,
            user_data: glib::ffi::gpointer,
        ) {
            let tree_view = from_glib_borrow(tree_view);
            let search_dialog = from_glib_borrow(search_dialog);
            let callback: &Option<Box_<dyn Fn(&TreeView, &Widget) + 'static>> =
                &*(user_data as *mut _);
            if let Some(ref callback) = *callback {
                callback(&tree_view, &search_dialog)
            } else {
                panic!("cannot get closure...")
            }
        }
        let func = if func_data.is_some() {
            Some(func_func as _)
        } else {
            None
        };
        unsafe extern "C" fn destroy_func(data: glib::ffi::gpointer) {
            let _callback: Box_<Option<Box_<dyn Fn(&TreeView, &Widget) + 'static>>> =
                Box_::from_raw(data as *mut _);
        }
        let destroy_call3 = Some(destroy_func as _);
        let super_callback0: Box_<Option<Box_<dyn Fn(&TreeView, &Widget) + 'static>>> = func_data;
        unsafe {
            ffi::gtk_tree_view_set_search_position_func(
                self.as_ref().to_glib_none().0,
                func,
                Box_::into_raw(super_callback0) as *mut _,
                destroy_call3,
            );
        }
    }

    #[doc(alias = "gtk_tree_view_set_show_expanders")]
    fn set_show_expanders(&self, enabled: bool) {
        unsafe {
            ffi::gtk_tree_view_set_show_expanders(
                self.as_ref().to_glib_none().0,
                enabled.into_glib(),
            );
        }
    }

    #[doc(alias = "gtk_tree_view_set_tooltip_cell")]
    fn set_tooltip_cell(
        &self,
        tooltip: &Tooltip,
        path: Option<&TreePath>,
        column: Option<&impl IsA<TreeViewColumn>>,
        cell: Option<&impl IsA<CellRenderer>>,
    ) {
        unsafe {
            ffi::gtk_tree_view_set_tooltip_cell(
                self.as_ref().to_glib_none().0,
                tooltip.to_glib_none().0,
                mut_override(path.to_glib_none().0),
                column.map(|p| p.as_ref()).to_glib_none().0,
                cell.map(|p| p.as_ref()).to_glib_none().0,
            );
        }
    }

    #[doc(alias = "gtk_tree_view_set_tooltip_column")]
    fn set_tooltip_column(&self, column: i32) {
        unsafe {
            ffi::gtk_tree_view_set_tooltip_column(self.as_ref().to_glib_none().0, column);
        }
    }

    #[doc(alias = "gtk_tree_view_set_tooltip_row")]
    fn set_tooltip_row(&self, tooltip: &Tooltip, path: &TreePath) {
        unsafe {
            ffi::gtk_tree_view_set_tooltip_row(
                self.as_ref().to_glib_none().0,
                tooltip.to_glib_none().0,
                mut_override(path.to_glib_none().0),
            );
        }
    }

    #[doc(alias = "gtk_tree_view_unset_rows_drag_dest")]
    fn unset_rows_drag_dest(&self) {
        unsafe {
            ffi::gtk_tree_view_unset_rows_drag_dest(self.as_ref().to_glib_none().0);
        }
    }

    #[doc(alias = "gtk_tree_view_unset_rows_drag_source")]
    fn unset_rows_drag_source(&self) {
        unsafe {
            ffi::gtk_tree_view_unset_rows_drag_source(self.as_ref().to_glib_none().0);
        }
    }

    #[doc(alias = "enable-grid-lines")]
    fn enable_grid_lines(&self) -> TreeViewGridLines {
        ObjectExt::property(self.as_ref(), "enable-grid-lines")
    }

    #[doc(alias = "enable-grid-lines")]
    fn set_enable_grid_lines(&self, enable_grid_lines: TreeViewGridLines) {
        ObjectExt::set_property(self.as_ref(), "enable-grid-lines", enable_grid_lines)
    }

    #[doc(alias = "columns-changed")]
    fn connect_columns_changed<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn columns_changed_trampoline<P: IsA<TreeView>, F: Fn(&P) + 'static>(
            this: *mut ffi::GtkTreeView,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(TreeView::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"columns-changed\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    columns_changed_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "cursor-changed")]
    fn connect_cursor_changed<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn cursor_changed_trampoline<P: IsA<TreeView>, F: Fn(&P) + 'static>(
            this: *mut ffi::GtkTreeView,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(TreeView::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"cursor-changed\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    cursor_changed_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "expand-collapse-cursor-row")]
    fn connect_expand_collapse_cursor_row<F: Fn(&Self, bool, bool, bool) -> bool + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn expand_collapse_cursor_row_trampoline<
            P: IsA<TreeView>,
            F: Fn(&P, bool, bool, bool) -> bool + 'static,
        >(
            this: *mut ffi::GtkTreeView,
            object: glib::ffi::gboolean,
            p0: glib::ffi::gboolean,
            p1: glib::ffi::gboolean,
            f: glib::ffi::gpointer,
        ) -> glib::ffi::gboolean {
            let f: &F = &*(f as *const F);
            f(
                TreeView::from_glib_borrow(this).unsafe_cast_ref(),
                from_glib(object),
                from_glib(p0),
                from_glib(p1),
            )
            .into_glib()
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"expand-collapse-cursor-row\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    expand_collapse_cursor_row_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn emit_expand_collapse_cursor_row(&self, object: bool, p0: bool, p1: bool) -> bool {
        self.emit_by_name("expand-collapse-cursor-row", &[&object, &p0, &p1])
    }

    #[doc(alias = "move-cursor")]
    fn connect_move_cursor<F: Fn(&Self, MovementStep, i32) -> bool + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn move_cursor_trampoline<
            P: IsA<TreeView>,
            F: Fn(&P, MovementStep, i32) -> bool + 'static,
        >(
            this: *mut ffi::GtkTreeView,
            step: ffi::GtkMovementStep,
            direction: libc::c_int,
            f: glib::ffi::gpointer,
        ) -> glib::ffi::gboolean {
            let f: &F = &*(f as *const F);
            f(
                TreeView::from_glib_borrow(this).unsafe_cast_ref(),
                from_glib(step),
                direction,
            )
            .into_glib()
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"move-cursor\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    move_cursor_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn emit_move_cursor(&self, step: MovementStep, direction: i32) -> bool {
        self.emit_by_name("move-cursor", &[&step, &direction])
    }

    #[doc(alias = "row-activated")]
    fn connect_row_activated<F: Fn(&Self, &TreePath, &TreeViewColumn) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn row_activated_trampoline<
            P: IsA<TreeView>,
            F: Fn(&P, &TreePath, &TreeViewColumn) + 'static,
        >(
            this: *mut ffi::GtkTreeView,
            path: *mut ffi::GtkTreePath,
            column: *mut ffi::GtkTreeViewColumn,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(
                TreeView::from_glib_borrow(this).unsafe_cast_ref(),
                &from_glib_borrow(path),
                &from_glib_borrow(column),
            )
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"row-activated\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    row_activated_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn emit_row_activated(&self, path: &TreePath, column: &TreeViewColumn) {
        self.emit_by_name::<()>("row-activated", &[&path, &column]);
    }

    #[doc(alias = "row-collapsed")]
    fn connect_row_collapsed<F: Fn(&Self, &TreeIter, &TreePath) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn row_collapsed_trampoline<
            P: IsA<TreeView>,
            F: Fn(&P, &TreeIter, &TreePath) + 'static,
        >(
            this: *mut ffi::GtkTreeView,
            iter: *mut ffi::GtkTreeIter,
            path: *mut ffi::GtkTreePath,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(
                TreeView::from_glib_borrow(this).unsafe_cast_ref(),
                &from_glib_borrow(iter),
                &from_glib_borrow(path),
            )
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"row-collapsed\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    row_collapsed_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "row-expanded")]
    fn connect_row_expanded<F: Fn(&Self, &TreeIter, &TreePath) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn row_expanded_trampoline<
            P: IsA<TreeView>,
            F: Fn(&P, &TreeIter, &TreePath) + 'static,
        >(
            this: *mut ffi::GtkTreeView,
            iter: *mut ffi::GtkTreeIter,
            path: *mut ffi::GtkTreePath,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(
                TreeView::from_glib_borrow(this).unsafe_cast_ref(),
                &from_glib_borrow(iter),
                &from_glib_borrow(path),
            )
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"row-expanded\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    row_expanded_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "select-all")]
    fn connect_select_all<F: Fn(&Self) -> bool + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn select_all_trampoline<
            P: IsA<TreeView>,
            F: Fn(&P) -> bool + 'static,
        >(
            this: *mut ffi::GtkTreeView,
            f: glib::ffi::gpointer,
        ) -> glib::ffi::gboolean {
            let f: &F = &*(f as *const F);
            f(TreeView::from_glib_borrow(this).unsafe_cast_ref()).into_glib()
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"select-all\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    select_all_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn emit_select_all(&self) -> bool {
        self.emit_by_name("select-all", &[])
    }

    #[doc(alias = "select-cursor-parent")]
    fn connect_select_cursor_parent<F: Fn(&Self) -> bool + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn select_cursor_parent_trampoline<
            P: IsA<TreeView>,
            F: Fn(&P) -> bool + 'static,
        >(
            this: *mut ffi::GtkTreeView,
            f: glib::ffi::gpointer,
        ) -> glib::ffi::gboolean {
            let f: &F = &*(f as *const F);
            f(TreeView::from_glib_borrow(this).unsafe_cast_ref()).into_glib()
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"select-cursor-parent\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    select_cursor_parent_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn emit_select_cursor_parent(&self) -> bool {
        self.emit_by_name("select-cursor-parent", &[])
    }

    #[doc(alias = "select-cursor-row")]
    fn connect_select_cursor_row<F: Fn(&Self, bool) -> bool + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn select_cursor_row_trampoline<
            P: IsA<TreeView>,
            F: Fn(&P, bool) -> bool + 'static,
        >(
            this: *mut ffi::GtkTreeView,
            object: glib::ffi::gboolean,
            f: glib::ffi::gpointer,
        ) -> glib::ffi::gboolean {
            let f: &F = &*(f as *const F);
            f(
                TreeView::from_glib_borrow(this).unsafe_cast_ref(),
                from_glib(object),
            )
            .into_glib()
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"select-cursor-row\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    select_cursor_row_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn emit_select_cursor_row(&self, object: bool) -> bool {
        self.emit_by_name("select-cursor-row", &[&object])
    }

    #[doc(alias = "start-interactive-search")]
    fn connect_start_interactive_search<F: Fn(&Self) -> bool + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn start_interactive_search_trampoline<
            P: IsA<TreeView>,
            F: Fn(&P) -> bool + 'static,
        >(
            this: *mut ffi::GtkTreeView,
            f: glib::ffi::gpointer,
        ) -> glib::ffi::gboolean {
            let f: &F = &*(f as *const F);
            f(TreeView::from_glib_borrow(this).unsafe_cast_ref()).into_glib()
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"start-interactive-search\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    start_interactive_search_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn emit_start_interactive_search(&self) -> bool {
        self.emit_by_name("start-interactive-search", &[])
    }

    #[doc(alias = "test-collapse-row")]
    fn connect_test_collapse_row<
        F: Fn(&Self, &TreeIter, &TreePath) -> glib::Propagation + 'static,
    >(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn test_collapse_row_trampoline<
            P: IsA<TreeView>,
            F: Fn(&P, &TreeIter, &TreePath) -> glib::Propagation + 'static,
        >(
            this: *mut ffi::GtkTreeView,
            iter: *mut ffi::GtkTreeIter,
            path: *mut ffi::GtkTreePath,
            f: glib::ffi::gpointer,
        ) -> glib::ffi::gboolean {
            let f: &F = &*(f as *const F);
            f(
                TreeView::from_glib_borrow(this).unsafe_cast_ref(),
                &from_glib_borrow(iter),
                &from_glib_borrow(path),
            )
            .into_glib()
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"test-collapse-row\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    test_collapse_row_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "test-expand-row")]
    fn connect_test_expand_row<
        F: Fn(&Self, &TreeIter, &TreePath) -> glib::Propagation + 'static,
    >(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn test_expand_row_trampoline<
            P: IsA<TreeView>,
            F: Fn(&P, &TreeIter, &TreePath) -> glib::Propagation + 'static,
        >(
            this: *mut ffi::GtkTreeView,
            iter: *mut ffi::GtkTreeIter,
            path: *mut ffi::GtkTreePath,
            f: glib::ffi::gpointer,
        ) -> glib::ffi::gboolean {
            let f: &F = &*(f as *const F);
            f(
                TreeView::from_glib_borrow(this).unsafe_cast_ref(),
                &from_glib_borrow(iter),
                &from_glib_borrow(path),
            )
            .into_glib()
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"test-expand-row\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    test_expand_row_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "toggle-cursor-row")]
    fn connect_toggle_cursor_row<F: Fn(&Self) -> bool + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn toggle_cursor_row_trampoline<
            P: IsA<TreeView>,
            F: Fn(&P) -> bool + 'static,
        >(
            this: *mut ffi::GtkTreeView,
            f: glib::ffi::gpointer,
        ) -> glib::ffi::gboolean {
            let f: &F = &*(f as *const F);
            f(TreeView::from_glib_borrow(this).unsafe_cast_ref()).into_glib()
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"toggle-cursor-row\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    toggle_cursor_row_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn emit_toggle_cursor_row(&self) -> bool {
        self.emit_by_name("toggle-cursor-row", &[])
    }

    #[doc(alias = "unselect-all")]
    fn connect_unselect_all<F: Fn(&Self) -> bool + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn unselect_all_trampoline<
            P: IsA<TreeView>,
            F: Fn(&P) -> bool + 'static,
        >(
            this: *mut ffi::GtkTreeView,
            f: glib::ffi::gpointer,
        ) -> glib::ffi::gboolean {
            let f: &F = &*(f as *const F);
            f(TreeView::from_glib_borrow(this).unsafe_cast_ref()).into_glib()
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"unselect-all\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    unselect_all_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn emit_unselect_all(&self) -> bool {
        self.emit_by_name("unselect-all", &[])
    }

    #[doc(alias = "activate-on-single-click")]
    fn connect_activate_on_single_click_notify<F: Fn(&Self) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn notify_activate_on_single_click_trampoline<
            P: IsA<TreeView>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::GtkTreeView,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(TreeView::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::activate-on-single-click\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_activate_on_single_click_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "enable-grid-lines")]
    fn connect_enable_grid_lines_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_enable_grid_lines_trampoline<
            P: IsA<TreeView>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::GtkTreeView,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(TreeView::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::enable-grid-lines\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_enable_grid_lines_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "enable-search")]
    fn connect_enable_search_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_enable_search_trampoline<
            P: IsA<TreeView>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::GtkTreeView,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(TreeView::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::enable-search\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_enable_search_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "enable-tree-lines")]
    fn connect_enable_tree_lines_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_enable_tree_lines_trampoline<
            P: IsA<TreeView>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::GtkTreeView,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(TreeView::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::enable-tree-lines\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_enable_tree_lines_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "expander-column")]
    fn connect_expander_column_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_expander_column_trampoline<
            P: IsA<TreeView>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::GtkTreeView,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(TreeView::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::expander-column\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_expander_column_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "fixed-height-mode")]
    fn connect_fixed_height_mode_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_fixed_height_mode_trampoline<
            P: IsA<TreeView>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::GtkTreeView,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(TreeView::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::fixed-height-mode\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_fixed_height_mode_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "headers-clickable")]
    fn connect_headers_clickable_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_headers_clickable_trampoline<
            P: IsA<TreeView>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::GtkTreeView,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(TreeView::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::headers-clickable\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_headers_clickable_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "headers-visible")]
    fn connect_headers_visible_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_headers_visible_trampoline<
            P: IsA<TreeView>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::GtkTreeView,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(TreeView::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::headers-visible\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_headers_visible_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "hover-expand")]
    fn connect_hover_expand_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_hover_expand_trampoline<
            P: IsA<TreeView>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::GtkTreeView,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(TreeView::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::hover-expand\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_hover_expand_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "hover-selection")]
    fn connect_hover_selection_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_hover_selection_trampoline<
            P: IsA<TreeView>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::GtkTreeView,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(TreeView::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::hover-selection\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_hover_selection_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "level-indentation")]
    fn connect_level_indentation_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_level_indentation_trampoline<
            P: IsA<TreeView>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::GtkTreeView,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(TreeView::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::level-indentation\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_level_indentation_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "model")]
    fn connect_model_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_model_trampoline<P: IsA<TreeView>, F: Fn(&P) + 'static>(
            this: *mut ffi::GtkTreeView,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(TreeView::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::model\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_model_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "reorderable")]
    fn connect_reorderable_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_reorderable_trampoline<
            P: IsA<TreeView>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::GtkTreeView,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(TreeView::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::reorderable\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_reorderable_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "rubber-banding")]
    fn connect_rubber_banding_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_rubber_banding_trampoline<
            P: IsA<TreeView>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::GtkTreeView,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(TreeView::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::rubber-banding\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_rubber_banding_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "search-column")]
    fn connect_search_column_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_search_column_trampoline<
            P: IsA<TreeView>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::GtkTreeView,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(TreeView::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::search-column\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_search_column_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "show-expanders")]
    fn connect_show_expanders_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_show_expanders_trampoline<
            P: IsA<TreeView>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::GtkTreeView,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(TreeView::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::show-expanders\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_show_expanders_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "tooltip-column")]
    fn connect_tooltip_column_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_tooltip_column_trampoline<
            P: IsA<TreeView>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::GtkTreeView,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(TreeView::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::tooltip-column\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_tooltip_column_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }
}

impl<O: IsA<TreeView>> TreeViewExt for O {}

impl fmt::Display for TreeView {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        f.write_str("TreeView")
    }
}
