# -*- coding: utf-8 -*-
#
# Copyright 2014 Bernard Yue
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#
from __future__ import unicode_literals, absolute_import
import textwrap


cuhk_traditional = ''.join(textwrap.dedent("""
貝車夾見壯妝兒長東岡戔糾來侖兩門協亞軋狀訂訃計飛風負貞釓釔軌軍紇紅紀紉紈紆約紂後
勁剄剋則厙帥閂為韋係俠頁唄員狽狹財貢倉倀個倆倫們剗剛芻純紡紛級納紐紕紝紗紓紋紜紖
紙島峽峽峴釘釕釙釗針凍鬥訌記訐訖訕討訊訓迴浹涇郟徑庫馬畝豈氣軔軒孫閃陝陘陣師時書
烏挾脅覎隻衹訛訪訣訥訟設訢訩許訝堊堅埡執軛軟區敗絆紬絀紿紱紼紺紹紳細紲組終畢閉參
側偉偵從徠釵釧釣釩釹釺釤釷産悵陳陸陰處帶帳頂頃崬崗動務販貫貨貧貪責婦婁婭乾掆捲掄
捫掃捨掗剮規覓視匭國圇華莊飢梘條梟將專脛淶淪淺淵連這啢啓問啞鹵麥鳥牽氫殺術烴習現
郵魚斬張眾晝硃惡惻悶惱愜惲貳賁貶貸費貴賀貺買貿貰貼貽貯鈀鈈鈔鈄鈍鈁鈣鈎鈥鈞鈧鈉鈕
鈐鈦鈃釾報場堝堯備傖傢傘㑳筆殘廁測渢溈渦渾湯湞詞詆詁訶詎評詘訴詗詒詛詐詔診覘硨硤
硯棖棟棡棗棧創剴單喬喪喎喲絰給絎絳絞結絕絝絡絨絲統絢腖腎脹隊階陽馱馮馭發復軲軤軻
軺軼軫軸媯媧頇順項須壺畫揮揀揚幾間開閔閏閑進痙凱殼睏嵐勞勝勛虜欽韌飥圍幃幀無鄉鄆
尋氬猶雲葤愛愴愷愾頒頓頏頎頌頑頊預綁綆經絹綏綈綃綉鉍鉢鈸鉑鈿鈷鉀鈳鈴鉚鉬鈮鈹鉕鉛
鉗鈰鉈鉭鉉鈾鈺鉞鉦補裏裊裝滄溝滅溮溳準詫該詬詿詭話詼詰誇誆誄詮詩試詳詡詢詣誅腸腡
腦腫馳馴飭飿飯飪飩飲飫傳僅僂僉傾傷傭傴債蒓莢莖莧達過違運當魛搗搶損電煩煉煢煒煬楓
極楊業楨鳬鳩賅賈賄賃賂賊資幹嗊嗎嗆嗇嗩嗚號匯彙會琿瑋蛺蜆筧節較輅軾載輊塏塊塒塗塢
塤塋壼睞亂媽獁猻獅黽寜農羥義巰肅歲聖勢竪鄔鄖鄒暘暈爺園圓隕閘盞銨鉺銃銚銱銩鉻鉿鉸
銬銠銘銓銣銫銅銑銜鉶銥銦銀銪銖骯誒誠誕誥誨誡誑誚認誦說誣誤誘語爾嘔嗶嘗嘍嘜嘆嘖慪
慚慘慣慳慶態慟漚滻滌漢滸滬漸漣漊滷滿滲滎漁漲滯漬飽餄餎飼飾餏飴綳綢綽緋綱綸緄緊綾
綹綠綿綺綣綬綰網維綫緒綜綻緇綴賓賒賑駁摻摜摑摳摟摶摺暢塵墊塹稱種碭碸碩遞遜遠對奪
奬奩罰閥閣閨閡閤閩䦛僨僥僕僑僞瘋瘍鳳鳴鳶韍輔輕輒趕趙構榖榿槍榮幗幘劃夥夢禍禕禎際
監盡箋皸匱萊領頗嶁嶇嶄犖屢瑪瑲瑣麼麽齊戧熗熒寢實廎颯颱壽臺圖團窪窩聞覡厭勩與嫗獄
殞製皚鋨鋇銼鋤鋒鋯鋏鋦鋃鋰鋁鋩鋪鋟銳鋱銻鋌銷鋅銹鋥噁嘸嘩嘰嘮噴噝嘵嘯餌餃餉養歐毆
罷罵鴇鳾鴉鴆輩輥輝輛輪輦輞輜幣幟潷澗漿澆潔潰澇潑潤潿潯潁編締緞緱緩緝緘緙練緬緲緡
緦緹緯線緗緣緻標樅槳樂樓槧樞樣樁彆彈撥撣撫擊撟撈撓撲撳撏摯層賜賧賦賡賫賤賚賣賠䝼
賞賢賬質賙嬋嫿嬌嬈嫵嫻諂調誹課諒論請誶誰諗談諉誼諏諍諄諑廠廢廣廟廡徹徵齒衝衛䦟閫
閬閭閱瘡瘧瘞鄲鄧鄰鄭憚憤憒憐慮憫慤慫憮憲憂導敵數墮墳墜髮範篋魴魯魷膚膕膠膞麩複駙
駕駒駑駟駛駘駝駔駐頜頡頦鞏颳劊劌劍劇劉葒葷蕒萬葦萵葉翬價儉儈儂儀億踐嶠嶗嶔嶢靚寬
審寫厲璉瑩碼確磑鬧盤窮熱毿殤蝕蝸蝦適豎興暫皺錒錛錶錯錘鍀錠鋼錮錦鋸錁錕錸錄鍆錳鍩
錇錢錫鍁錚錙錐噯噠噹噸噲駡噥噦嬡嬙諳諤諶諦諜諷諱諢諫謀諾諞謂諧諝諼諺謁諛諭諮諸餓
餑餜餒餘甌鮁鮑鮒鮎鮍鮃鮐鮣鮓辦憊懇憑憶懌應儐儕儔儘穇積穌穎艙蒼蓋蓀蒔輳輻輯輸縗縛
縞縑縉縟縧縣縊縈縕縝縐縋閶閽閿閹閼閻閾磣磧磚赬鴟鴣鴒鴝鴕鴞鴨鴦鴛遲遼遷選遺熾燈燜
燒燙燁擔擋撿據擓擄撻撾擁擇殫殨澱澮澠濃澾澦澤濁窵窶窺獨獪獫篤篩築賭賵賴奮龜駭駱駢
頷頰頸頻頲頭頹頤樺機樸橋橈樹橢璣璡劑舉墾壇瞘瞜瞞褲鄶鄴曆曇曉曄歷龍瘻瘮盧螞螄螢膩
親覦隨險學嶨嶧踴禦醞戰鎄鍔鍤鍍鍛鍋鍰鍵鍇錨鎇鎂鍬鍥鍶鍚鍘鍺鍾曖璦環鴯鴿鴰鴴鴻鵁鴷
鵂鵃闆闊闌闃闋闈幫謗謊講謎謐謙謖謚謄謝謔謠謅篳簍簀蓽蔔蓯蔣蓮蔞蔦蔭濱濟濜濫濛濘澀
濕濤濰擯擱擠擬擰餅餷餶館餛餞餡燦燴營燭聰聯聳聲禪償優齔檉檔檜檟檢檣騁駿駸醜膽膾臉
膿癉癆療癇點糞糝縫績縲縭縷縵繆縹縴繅縮總縱縶賻購賽賺尷覯覬轂轄輿轅輾鮭鮫鮚鮦鮪鮮
鮝鮺蟈螻蟎蟄還邁韓嚇嚀獲獰磯磽艱襇襉褳褸褻矯屨颶顆虧勵隸斂殮瞭臨嶺嶸嶼耬懞懨彌嬪
嬰牆蹌趨麯雖戲壓隱黿齋氈額題顔顒顓鵝鵓鵠鵑鵜鵡鵒邇謳謭謹謾謬謨謫擺擷擴攆擾擻攄擲
鎊鎬鎘鎵鎸鎧鎦鎿鎳鎪鎖䥇鎢鎰鎮鎡斃蹕蹣檳櫃檻檸檯殯臏臍叢竄竅蟬蟲蟣蟯蕆蕩蕢蕁蕎蕘
蕪蕭蕕蕓雛雞雙雜儲礎闖闔闓闕闐簞簡簣簫鼕瀆濺瀏濾濼濾瀋瀉斷懟懣豐鯁鯀鯇鯉鯊獷獵歸
穢穡瞼醬醫燼燾覲舊騍騎騏騅壙壘鄺䙡聵聶職耮禮癘糧魎繚繞繕繒織嚕嚙轆轉翹鞦軀鬆觴嬸
韙鬩餳歟賾贄贅礙鵪鶉鶇鶊鶄鶓鵬鵮鵲襖襠襝鏰鏢鏟鏑鏡鏗鏈鏤鏝鏘鏹鎩鏜鏇鏞鏨鏃邊癟瀕
瀨瀝瀧瀟餺餾饃餿餼辭蠆蟶蟻蠅鯧鯛鯡鯨鯤鯪鯢鯰鯖鯫鯔懲懷懶寵疇禱禰顛類顙願櫝櫟櫓櫚
櫞櫛牘犢關鬍壞壢壟壚繯繪繫繭繮繳繰繩繡繹薈薊薦薑薔薌蕷穫穩譏譎譜譙識譚譖證轎轔轍
曠臘離難嚦嚨嚮麗簾簽飀颼攏隴廬氌羅羆矇龐騙騖蹺蹻瓊璽覷勸獸獺獻爍韜韞霧厴贋贊贈鰐
鯿鰆鰈鰒鰉鯽鰌鰍鰓鰂鶚鶿鷀鶡鶘鶪鶥鶖鶩齙齣齟齡齠齜寶辮繽繼繾攙攔攖闡闞懺懸櫬櫪櫳
櫨櫧籌籃觸黨鐙鐓鐨鏵鐧鐫鐦鐒鐐鐃鏺鏷鐠鐥鐘鐯竇躉礬礦礪礫豶薺藉藎藍薩艦覺癤癢癥饉
饅饊饈競嚳嚴嚶巋瀾瀲瀰襤騮騫騷騸騰騶騭曨朧瓏爐臚顢獼麵聹飄蠐蠑贍贏釋糰犧鹹響龑譯
議譫罌驁驃驂驄騾驀驅䎱襬襪辯飆鶬鶻鶴鷄鶺鶼鷉鷂鶯攛㩳攝鹺纏纊纍纈續鐺鐸鐶鐳鐮鐵鐿
鐲躊躋躍灃灄顧顥鰥鰜鰟鰭鰣鰨鰧鰮䱷轟護譴譽齎殲贐懼懾櫸欄櫻饋饒饌蠟蠣癩癧斕覽爛儷
儺糲礱髏衊囁囂囀闢闥鞽藭藪藥藝屬齦瓔竈鰲鰾鰹鰳鰱鰻鰵鰷鰼鱈鱅鷗鷚鷖鷓鷙鑌鑔鑊鑒鑄
攢攤囅囉囈顫襯襲齪齬韃韁糴覿巔巒讀讅龔龕驊驕驍歡霽籟籠籙籜灕灑灘藶藺蘢蘆蘋蘄蘇蘀
蘊轢轡酈聾聽艫孌孿玀竊權贖罎儻儼彎饗蠨鬚癬癮癭躑躓變讎讌讋鑣鑞鑥鑠鑕鱉鱖鱗鱔鱘鱒
纔纖纓蠱㘚囌齏鷦鷲鷯鷺鷥鷳鷸攪攣驚驗驛蘭蘞蘚邐邏戀轤欒欏黴籤顬顯曬體髒躚饜靨癰臢
瓚靄靆靂靈壩髕鬢蠶讒讖讕讓癲癱籪贛灝鱟鱠鱧鱣羈鹼鹽攬釀鷿鸊鷹鸇顰韆齲齷艷驟囑靉籩
籬籮躥躡鱨鱭觀黌髖鑭鑲鑰欖顱臠蘿蠻糶廳鼉灣釁纘鑹鑷饞韉灤驢釃黶趲躦矚鱷鱸讜讞黷驥
驤纜躪鸕鑾鑼鑿鑽顳顴灧釅鐝钁钂欞鸚戇鸛驪鬱鱺鸝鸞饢籲
""").split())

cuhk_simplified = ''.join(textwrap.dedent("""
贝车夹见壮妆儿长东冈戋纠来仑两门协亚轧状订讣计飞风负贞钆钇轨军纥红纪纫纨纡约纣后
劲刭克则厍帅闩为韦系侠页呗员狈狭财贡仓伥个俩伦们刬刚刍纯纺纷级纳纽纰纴纱纾纹纭纼
纸岛崃峡岘钉钌钋钊针冻斗讧记讦讫讪讨讯训回浃泾郏径库马亩岂气轫轩孙闪陕陉阵师时书
乌挟胁觃只只讹访诀讷讼设䜣讻许讶垩坚垭执轭软区败绊䌷绌绐绂绋绀绍绅细绁组终毕闭参
侧伟侦从徕钗钏钓钒钕钎钐钍产怅陈陆阴处带帐顶顷岽岗动务贩贯货贫贪责妇娄娅干㧏卷抡
扪扫舍挜剐规觅视匦国囵华庄饥枧条枭将专胫涞沦浅渊连这唡启问哑卤麦鸟牵氢杀术烃习现
邮鱼斩张众昼朱恶恻闷恼惬恽贰贲贬贷费贵贺贶买贸贳贴贻贮钯钚钞钭钝钫钙钩钬钧钪钠钮
钤钛钘䥺报场埚尧备伧家伞㑇笔残厕测沨沩涡浑汤浈词诋诂诃讵评诎诉诇诒诅诈诏诊觇砗硖
砚枨栋㭎枣栈创剀单乔丧㖞哟绖给绗绛绞结绝绔络绒丝统绚胨肾胀队阶阳驮冯驭发复轱轷轲
轺轶轸轴妫娲顸顺项须壶画挥拣扬几间开闵闰闲进痉凯壳困岚劳胜勋虏钦韧饦围帏帧无乡郓
寻氩犹云荮爱怆恺忾颁顿颃颀颂顽顼预绑绠经绢绥绨绡绣铋钵钹铂钿钴钾钶铃铆钼铌铍钷铅
钳铈铊钽铉铀钰钺钲补里袅装沧沟灭浉涢准诧该诟诖诡话诙诘夸诓诔诠诗试详诩询诣诛肠脶
脑肿驰驯饬饳饭饪饨饮饫传仅偻佥倾伤佣伛债莼荚茎苋达过违运当鱽捣抢损电烦炼茕炜炀枫
极杨业桢凫鸠赅贾贿赁赂贼资干唝吗呛啬唢呜号汇汇会珲玮蛱蚬笕节较辂轼载轾垲块埘涂坞
埙茔壸睐乱妈犸狲狮黾宁农羟义巯肃岁圣势竖邬郧邹旸晕爷园圆陨闸盏铵铒铳铫铞铥铬铪铰
铐铑铭铨铷铯铜铣衔铏铱铟银铕铢肮诶诚诞诰诲诫诳诮认诵说诬误诱语尔呕哔尝喽唛叹啧怄
惭惨惯悭庆态恸沤浐涤汉浒沪渐涟溇卤满渗荥渔涨滞渍饱饸饹饲饰饻饴绷绸绰绯纲纶绲紧绫
绺绿绵绮绻绶绾网维线绪综绽缁缀宾赊赈驳掺掼掴抠搂抟折畅尘垫堑称种砀砜硕递逊远对夺
奖奁罚阀阁闺阂合闽䦶偾侥仆侨伪疯疡凤鸣鸢韨辅轻辄赶赵构谷桤枪荣帼帻划伙梦祸祎祯际
监尽笺皲匮莱领颇嵝岖崭荦屡玛玱琐么么齐戗炝荧寝实庼飒台寿台图团洼窝闻觋厌勚与妪狱
殒制皑锇钡锉锄锋锆铗锔锒锂铝铓铺锓锐铽锑铤销锌锈锃恶呒哗叽唠喷咝哓啸饵饺饷养欧殴
罢骂鸨䴓鸦鸩辈辊辉辆轮辇辋辎币帜滗涧浆浇洁溃涝泼润涠浔颍编缔缎缑缓缉缄缂练缅缈缗
缌缇纬线缃缘致标枞桨乐楼椠枢样桩别弹拨掸抚击挢捞挠扑揿挦挚层赐赕赋赓赍贱赉卖赔䞍
赏贤账质赒婵婳娇娆妩娴谄调诽课谅论请谇谁谂谈诿谊诹诤谆诼厂废广庙庑彻征齿冲卫䦷阃
阆闾阅疮疟瘗郸邓邻郑惮愤愦怜虑悯悫怂怃宪忧导敌数堕坟坠发范箧鲂鲁鱿肤腘胶䏝麸复驸
驾驹驽驷驶骀驼驵驻颌颉颏巩刮刽刿剑剧刘荭荤荬万苇莴叶翚价俭侩侬仪亿践峤崂嵚峣靓宽
审写厉琏莹码确硙闹盘穷热毵殇蚀蜗虾适竖兴暂皱锕锛表错锤锝锭钢锢锦锯锞锟铼录钔锰锘
锫钱钖锨铮锱锥嗳哒当吨哙骂哝哕嫒嫱谙谔谌谛谍讽讳诨谏谋诺谝谓谐谞谖谚谒谀谕谘诸饿
饽馃馁余瓯鲅鲍鲋鲇鲏鲆鲐䲟鲊办惫恳凭忆怿应傧侪俦尽䅟积稣颖舱苍盖荪莳辏辐辑输缞缚
缟缣缙缛绦县缢萦缊缜绉缒阊阍阌阉阏阎阈碜碛砖赪鸱鸪鸰鸲鸵鸮鸭鸯鸳迟辽迁选遗炽灯焖
烧烫烨担挡捡据㧟掳挞挝拥择殚㱮淀浍渑浓㳠滪泽浊窎窭窥独狯猃笃筛筑赌赗赖奋龟骇骆骈
颔颊颈频颋头颓颐桦机朴桥桡树椭玑琎剂举垦坛眍䁖瞒裤郐邺历昙晓晔历龙瘘瘆卢蚂蛳萤腻
亲觎随险学峃峄踊御酝战锿锷锸镀锻锅锾键锴锚镅镁锹锲锶钖铡锗钟暧瑷环鸸鸽鸹鸻鸿䴔䴕
鸺鸼板阔阑阒阕闱帮谤谎讲谜谧谦谡谥誊谢谑谣诌筚篓箦荜卜苁蒋莲蒌茑荫滨济浕滥蒙泞涩
湿涛潍摈搁挤拟拧饼馇馉馆馄饯馅灿烩营烛聪联耸声禅偿优龀柽档桧槚检樯骋骏骎丑胆脍脸
脓瘅痨疗痫点粪糁缝绩缧缡缕缦缪缥纤缫缩总纵絷赙购赛赚尴觏觊毂辖舆辕辗鲑鲛鲒鲖鲔鲜
鲞鲝蝈蝼螨蛰还迈韩吓咛获狞矶硗艰裥裥裢褛亵矫屦飓颗亏励隶敛殓了临岭嵘屿耧蒙恹弥嫔
婴墙跄趋曲虽戏压隐鼋斋毡额题颜颙颛鹅鹁鹄鹃鹈鹉鹆迩讴谫谨谩谬谟谪摆撷扩撵扰擞摅掷
镑镐镉镓镌铠镏镎镍锼锁䦂钨镒镇镃毙跸蹒槟柜槛柠台殡膑脐丛窜窍蝉虫虮蛲蒇荡蒉荨荞荛
芜萧莸芸雏鸡双杂储础闯阖闿阙阗箪简篑箫冬渎溅浏泸泺滤沈泻断怼懑丰鲠鲧鲩鲤鲨犷猎归
秽穑睑酱医烬焘觐旧骒骑骐骓圹垒邝䙌聩聂职耢礼疠粮魉缭绕缮缯织噜啮辘转翘秋躯松觞婶
韪阋饧欤赜贽赘碍鹌鹑鸫鹒䴖鹋鹏鹐鹊袄裆裣镚镖铲镝镜铿链镂镘锵镪铩镗旋镛錾镞边瘪濒
濑沥泷潇馎馏馍馊饩辞虿蛏蚁蝇鲳鲷鲱鲸鲲鲮鲵鲶鲭鲰鲻惩怀懒宠畴祷祢颠类颡愿椟栎橹榈
橼栉牍犊关胡坏坜垄垆缳绘系茧缰缴缲绳绣绎荟蓟荐姜蔷芗蓣获稳讥谲谱谯识谭谮证轿辚辙
旷腊离难呖咙向丽帘签飗飕拢陇庐氇罗罴蒙庞骗骛跷硚琼玺觑劝兽獭献烁韬韫雾厣赝赞赠鳄
鳊䲠鲽鳆鳇鲫䲡鳅鳃鲗鹗鹚鹚鹖鹕䴗鹛鹙鹜龅出龃龄龆龇宝辫缤继缱搀拦撄阐阚忏悬榇枥栊
栌槠筹篮触党镫镦镄铧锏镌锎铹镣铙䥽镤镨䦅钟䦃窦趸矾矿砺砾豮荠借荩蓝萨舰觉疖痒症馑
馒馓馐竞喾严嘤岿澜潋弥褴骝骞骚骟腾驺骘昽胧珑炉胪颟猕面聍飘蛴蝾赡赢释团牺咸响䶮译
议谵罂骜骠骖骢骡蓦驱䎬摆袜辩飙鸧鹘鹤鸡鹡鹣䴘鹞莺撺㧐摄鹾缠纩累缬续铛铎镮镭镰铁镱
镯踌跻跃沣滠顾颢鳏鳒鳑鳍鲥鳎䲢鳁䲣轰护谴誉赍歼赆惧慑榉栏樱馈饶馔蜡蛎癞疬斓览烂俪
傩粝砻髅蔑嗫嚣啭辟闼鞒䓖薮药艺属龈璎灶鳌鳔鲣鳓鲢鳗鳘鲦鳛鳕鳙鸥鹨鹥鹧鸷镔镲镬鉴铸
攒摊冁啰呓颤衬袭龊龉鞑缰籴觌巅峦读谉龚龛骅骄骁欢霁籁笼箓箨漓洒滩苈蔺茏芦苹蕲苏萚
蕴轹辔郦聋听舻娈孪猡窃权赎坛傥俨弯飨蟏须癣瘾瘿踯踬变雠䜩詟镳镴镥铄锧鳖鳜鳞鳝鲟鳟
才纤缨蛊㘎苏齑鹪鹫鹩鹭鸶鹇鹬搅挛惊验驿兰蔹藓逦逻恋轳栾椤霉签颥显晒体脏跹餍靥痈臜
瓒霭叇雳灵坝髌鬓蚕谗谶谰让癫瘫簖赣灏鲎鲙鳢鳣羁硷盐揽酿䴙䴙鹰鹯颦千龋龌艳骤嘱叆笾
篱箩蹿蹑鲿鲚观黉髋镧镶钥榄颅脔萝蛮粜厅鼍湾衅缵镩镊馋鞯滦驴酾黡趱躜瞩鳄鲈谠谳黩骥
骧缆躏鸬銮锣凿钻颞颧滟酽镢䦆镋棂鹦戆鹳骊郁鲡鹂鸾馕吁
""").split())

extra_traditional = ''.join(textwrap.dedent("""
膁鬨瀠颻襆鏍閎憖丟眥氳漵媼饑鯒齕虯瘺湊奐緓寧薘輟鰩脫蓴鏌貟鮋瑤輈琺兌鍠廩撚羨闤奧
棲鋶餱鯕鉤翽鐋嚌溜缽訁膃搖頴輇袞別佇闠齧詵掙產屜嶽雋闍獎鋣餕減堿著煥郤銍鎣遝镟禿
魨襴梔贇閌貲潛癡哢偽祿騌敘谘茲鳲槁壋魢柵巹鏽鸏繃筍彥糸颭傑鈒夠瀦阪鯷蒞墶簹鈽汙蝟
囪鐔悅璿嫋姍穠櫫勻鰏瘓唕鵐鮶噓淚橫並棬檁暉亙掛薟矓詖佘換鈑渙鶤鶲毀晉絏鏐內卻災鸌
鋙鰠騤馹荊颸魺矽讚爿驏緶脈箏褘崠嬤刪盜況顎繢鎔強嘽懍灩腳脊崢溫靦豬齶呼萇崍嚐閒錩
冪簷咼棄闒虛羋輬吒攜轀瑒彠韻壪綌贗玨檮怵錡屍鵷貓靜鯝淩藹綞鷊摣訒躕醱蘺鶹贓鮜爭崳
噅驌濔淨駰唚澩繈拋豔硜娛喚蔥紵鼴廈慍贔粵戶賕弳兗扡滾纇瀘璫艤驦劄鮊稟煙飣湧醃瘂屆
廝俁鼇躒齇秈遙絛槨黲鯴歿稈蠔傯嶴臥獮艸譾臟猙鮞榪糊淒緔鮳呂軑鞀瀅沒甕涼檾鱝恥嗬餖
鋝紮垵煆蹤苧鰃誌嶮吳饁廄顏觶騂麅堖紘螿鯗裡閈氹瑉躂屙廚剝棶錆鸘犛黃詠淥鬁疊熲鯵臒
湣驫鱯冇隉褌鎛綯璵諡勱軹決穭蠍鱂猛凜啟鵯鼂窯洶鷁燉韝跡幬閆撐銛譸愨鳧頮睜櫥鷫異颮
逕鰁稅穀錟嚲廂齗呱覥鬮歎鱤蹠颺蓧勳蛻劈冊钜宮皰侶擼礄錈鴬鍈遊魘塚坰椏戩於襏屭
""").split())

extra_simplified = ''.join(textwrap.dedent("""
肷闹潆飖幞镙闳慭丢眦氲溆媪饥鲬龁虬瘘凑奂绬宁荙辍鳐脱莼镆贠鲉瑶辀珐兑锽廪捻羡阛奥
栖锍糇鲯钩翙铴哜熘钵讠腽摇颕辁衮别伫阓啮诜挣产屉岳隽阇奖铘馂减碱着焕郄铚蓥沓碹秃
鲀襕栀赟闶赀潜痴咔伪禄骔叙咨兹鸤藁垱鱾栅卺锈鹲绷笋彦纟飐杰钑够潴坂鳀莅垯筜钸污猬
囱镡悦璇袅姗秾橥匀鲾痪唣鹀鲪嘘泪横并桊檩晖亘挂莶眬诐畲换钣涣鹍鹟毁晋绁镠内却灾鹱
铻鳋骙驲荆飔鲄硅赞丬骣缏脉筝袆岽嬷删盗况颚缋镕强啴懔滟脚嵴峥温腼猪腭唿苌崃尝闲锠
幂檐呙弃阘虚芈辌咤携辒玚彟韵塆绤赝珏梼憷锜尸鹓猫静鲴凌蔼缍鹝揸讱蹰酦蓠鹠赃鲘争嵛
咴骕沵净骃吣泶襁抛艳硁娱唤葱纻鼹厦愠赑粤户赇弪兖扦滚颣泸珰舣骦札鲌禀烟饤涌腌痖届
厮俣鳌跞齄籼遥绦椁黪鲺殁秆蚝偬岙卧狝艹谫脏狰鲕杩煳凄绱鲓吕轪鼗滢没瓮凉苘鲼耻呵饾
锊扎埯煅踪苎鳂志崄吴馌厩颜觯骍狍垴纮螀鲞里闬凼珉跶疴厨剥梾锖鹴牦黄咏渌疬叠颎鲹癯
愍骉鳠没陧裈镈绹玙谥劢轵决稆蝎鳉勐凛启鹎鼌窑汹鹢炖鞴迹帱闫撑铦诪悫凫颒睁橱鹔异飑
迳鳈税谷锬亸厢龂哌觍阄叹鳡跖飏莜勋蜕噼册鉅宫疱侣撸硚锩鸴锳游魇冢垧桠戬于袯屃
""").split())

simplified_charmap = cuhk_simplified + extra_simplified
traditional_charmap = cuhk_traditional + extra_traditional
