1.1 ライブコーディング

# ライブコーディング

Sonic Piの最もエキサイティングな側面のひとつは、まるでギターをライブで演奏するかのように、
ライブでコードを書いて音楽を作ることができることです。つまり、ステージやコンサートでSonic Piが
使えるということです！

## 心を解き放て

これからチュートリアルで、実際のSonic Piの詳しい使い方に入る前に、まず、
ライブコーディングがどんなものか体験してみましょう。あまり（もしくは全然）わからなくても、
心配ご無用！そのまま席についたまま、楽しんでいきましょう。

## ライブループ

さぁ、はじめましょう！下のコードを上の空欄のWorkspace（ワークスペース）にコピーしてみましょう。

```
live_loop :flibble do
 sample :bd_haus, rate: 1
 sleep 0.5
end
```

左上の`Run`（再生）ボタンを押すと、いい感じの速さでバスドラムの音が聞こえてきます。
`Stop`（停止）ボタンを押せば、いつでも音を止めることができます。ですが、
まだ`Stop`（停止）ボタンを押さずに、次のステップを実行しましょう。

1. -バスドラムがまだ鳴っていることを確認します。
2. -`sleep`の値を、`0.5`から、`1`より大きい値に書き換えてみましょう。
3. -`Run`（再生）ボタンをもう一度押します。
4. -ドラムの早さがどのように変わったかを確認してみましょう。 
5. -この瞬間を忘れないでください。これが、あなたが初めてSonic Piでライブコーディングをした瞬間です。*この瞬間を忘れないでください。*そしてこれが最後にはならないはず・・・

これは簡単でした。では他の要素を加えてみましょう。`sample :bd_haus`の上に、
`sample :ambi_choir, rate: 0.3` を追加してみます。コードはこのようになるはずです。

```
live_loop :flibble do
 sample :ambi_choir, rate: 0.3
 sample :bd_haus, rate: 1
 sleep 1
end
```

では、ちょっと遊んでみましょう。値を変えてみてください。大きな値、小さな値、もしくはマイナスの値にしたとき、
何が起こるでしょうか？では、`:ambi_choir` の `rate:` の値をほんの少し（0.29などに）変えた時、どうなるでしょう？
`sleep` の値をすごく小さくすると、どうでしょう？操作が速すぎると、エラーが出て
コンピュータが止まってしまいます。これはコンピュータがついていけないからです。
（そんな時は、より大きい値を `sleep` に設定して`Run`ボタンをもう一度押しましょう。）
では、`sample` の行に `#` をつけることで、 「コメント」してみてください。

```
live_loop :flibble do
 sample :ambi_choir, rate: 0.3
#  sample :bd_haus, rate: 1
 sleep 1
end

```

コンピュータに#をつけた行を無視するよう命令したので、聞こえませんね。これはコメントと呼ばれます。
Sonic Piでは、要素を削除したり追加したりするのにコメントを使います。
最後に、楽しむための技をお伝えしましょう。以下のコードを、上の空欄のWorkspace(ワークスペース)にコピーします。
そして、2つは同時にループ（繰り返し）します。まずは精一杯、体験して楽しみましょう！

いくつかを試してみましょう。

* `rate:`の青い値を変更し、`sample`の音が変わることを聞いてみましょう。
* `sleep`の時間を変更し、それぞれのループを異なる速度で繰り返すのを聞いてみましょう。
* `sample`の行のコメントを解除して（ `#`を削除）、ギターの逆再生を楽しみましょう。
* いくつかの`mix:` の値を`0` (最小値) から `1` (最大値)の間で変えてみましょう。

`Run` ボタンを押し、次に繰り返しがどう変化したかに耳を傾けることを忘れないでください。 
うまくいかなくても気にしないでください。`Stop`ボタンを押して、Workspace内のコードを削除して、
新しいコードをコピーアンドペーストして、再び演奏の準備をすれば良いです。
失敗することがどんなことよりも学習の近道になるのですから。

```
live_loop :guit do
 with_fx :echo, mix: 0.3, phase: 0.25 do
   sample :guit_em9, rate: 0.5
 end
#  sample :guit_em9, rate: -0.5
 sleep 8
end

live_loop :boom do
 with_fx :reverb, room: 1 do
   sample :bd_boom, amp: 10, rate: 1
 end
 sleep 8
end
```

さあ、これらが実際にどう動くか好奇心が動き出すまで、
そしてあなたが次に何をしたらいいかを知りたくなるまで、演奏と実験を続けましょう。
さあ、残りのチュートリアルを読む準備ができました。

次にあなたを待っているものは・・・
