/* -*- mode: C++ ; c-file-style: "stroustrup" -*- *****************************
 * Source-Highlight-Ide
 * Copyright (C) 2007-2009   Lorenzo Bettini <http://www.lorenzobettini.it>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the Qwt License, Version 1.0
 *****************************************************************************/

/*
  This file contains NO source code, just some documentation for doxygen to
  parse.
*/

/*!
  \mainpage SourceHighlightIDE - an IDE for GNU Source-Highlight

Sourcehighlightide is an IDE for GNU Source-highlight,
http://www.gnu.org/software/src-highlite,
(given a source file, produces a document with syntax highlighting);
 in particular, it is useful when you have to develop a new language definition
 file for source-highlight (Source-highlight reads source language specifications dynamically,
 thus it can be easily extended
 (without recompiling the sources) for handling new languages),
  modify an existing one, and, most importantly, debug a language definition file.

  \image html source-highlight-ide.png Source-Highlight-Ide main window

  \section homepage Project page
  The official project page is hosted at http://srchighliteide.sourceforge.net/

  \section license License

  Source-Highlight-Ide is distributed under the terms of the \ref gpllicence.

  \section installation Installation

To build it I suggest to create a separate directory, e.g., build
cd there and run

\code
qmake ../source-highlight-ide.pro
make
\endcode

Remember that you must have already installed the source-highlight-qt
library.  

The qmake project of Source-Highlight-Ide uses pkg-config,
http://pkg-config.freedesktop.org (if this tool is installed
in your system), to detect the library Source-Highlight-Qt
(and implicitly also the GNU Source-Highlight library).

If you installed that in a standard place (e.g., <tt>/usr</tt>
or in a system directory where ldconfig and pkg_config find it) then
this should be enough.

Otherwise you must specify the directory where pkg_config can find
the file <tt>source-highlight-qt4.pc</tt> and <tt>source-highlight.pc</tt>);
note that <tt>source-highlight-qt4.pc</tt> will also contain the
references to GNU Source-highlight library and headers,
so you won't have to worry about that. 

for instance, if you installed source-higlight-qt library in
<tt>~/usr/local</tt>, then the .pc file will be in
<tt>~/usr/local/lib/pkgconfig</tt> and you'll need to use this directory
for setting <tt>PKG_CONFIG_PATH</tt>, e.g.,

\code
PKG_CONFIG_PATH=~/usr/local/lib/pkgconfig/ qmake ../qsource-highlight.pro
make
\endcode

the executable binary will be created in the directory bin

If pkg-config is not installed in your system, you'll have to specify
the <tt>LIBS</tt> and <tt>INCLUDEPATH</tt> qmake variables manually,
using the correct path, for instance:

\code
LIBS += -L~/usr/local/lib -lsource-highlight-qt4
INCLUDEPATH = ~/usr/local/include
\endcode

You can also specify the name of the libraries to use
by using <tt>SOURCE_HIGHLIGHT_QT_LIB</tt>, <tt>SOURCE_HIGHLIGHT_LIB</tt>, and
<tt>BOOST_REGEX</tt> for source-highlight-qt, source-highlight and
boost regex (used by source-highlight), respectively.
This is useful if pkg-config is not installed in your system.

Once the building has sucessfully finished, 
you can install the files with the command make install;
binaries will be installed into <tt>/bin</tt> and documentation
(both html documentation and the one readable with qt assistant)
into <tt>/share/doc/source-highlight-ide/html</tt>.

You can customize the root of the installation directory 
with the environment variable <tt>INSTALL_ROOT</tt>; for instance,

\code
INSTALL_ROOT=$HOME/usr/local make install
\endcode

You might need to become root if you install in a path different
from your home.

  \section sourcehighlightsettings Source-Highlight Settings

  Source-highlight library uses a path (called data dir) to search for language definition file,
  output format definition files, style files, etc.
  This path must be set correctly otherwise highlighting features will not work.
  In a standard installation this path should already be set appropriately.
  However, if you use a non standard installation of source-highlight,
  this path might not be set correctly (a symptom is when you get errors when
  trying to perform highlighting, or a message box shows up when you run
  Source-Highlight-Ide).

  You can set this path using the Settings -> Source-highlight Settings menu.
  This will bring a dialog where you can set the path (or choose it with the browse button);
  notice that the dialog also checks whether the currently selected path is
  a valid path for source-highlight.

  \image html settings-ok.png correct settings

  \image html settings-wrong.png wrong settings

  Tip:

  In order to be a valid path, it should contain at least lang.map file and .lang, .outlang, .style files.

  \section basic Basic Usage

  Source-Highlight-Ide can be used as an editor for Source-Highlight .lang
  definition files (left text edit); moreover, an example input file can be
  opened (right text edit, top) that will be used to produce html highlighted output
  (right text edit, bottom); the highlighted output can be seen both in
  source format (html) and in a preview format.

  This way, while writing the language definition file, it is also possible
  to check on-the-fly whether the output is the one expected.
  The highlighting can be performed by using the menu or the toolbar button:

  \image html highlight.png

  Source-Highlight-Ide is a MDI application, thus, several .lang definition
  files can be opened.

  \section debug Debug

  Although you can use Source-Highlight-Ide for testing a language definition file
  while you're editing it, the feature that can be most useful is the debugging mechanism.

  You start debugging by using the button "Debug", and then press "Step" for
  formatting element by element the parts of the input file that is to be formatted.
  You can interrupt the debugging by using the button "Stop".

  During debuggin, the debugging frame will appear under the lang definition file
  text editor ("Debugging Info").

  The debugging steps at each matched regular expression and the one that was matched
  is shown in the debugger frame and the text editor of the language definition file
  will position in the corresponding line.
  In the "highlighted output" part you can check the pieces of the input file that are
  being formatted.

  \image html source-highlight-ide-debug.png

  Notice that if the language definition file includes another one, the editor window
  will open the included file containing the current matched regular expression.
  For instance, in the above screenshot, the editor is positioned on c_comment.lang
  since that is included in cpp.lang (which was the original language definition file
  we were debugging).  However, when the debugging finishes, the original lang
  file will be shown in the text editor.


*/

/*!
  \page gpllicence GNU GPL Licence
  \verbinclude "COPYING"
*/

