from __future__ import print_function



class _MockMeta(type):
    def __getattr__(self, name):
        return _Mock()

class _Mock(object):
    __metaclass__ = _MockMeta
    def __init__(self, *a, **kw):
        object.__init__(self)
        for k,v in kw.iteritems():
            setattr(self, k, v)
    def __getattr__(*a, **kw): return _Mock()
    def __call__(*a, **kw): return _Mock()
    def __getitem__(*a, **kw): return _Mock()
    def __int__(*a, **kw): return 1
    def __contains__(*a, **kw): return False
    def __len__(*a, **kw): return 1
    def __iter__(*a, **kw): return iter([])
    def __exit__(*a, **kw): return False
    def __complex__(*a, **kw): return 1j
    def __float__(*a, **kw): return 1.0
    def __bool__(*a, **kw): return True
    def __nonzero__(*a, **kw): return True
    def __oct__(*a, **kw): return 1
    def __hex__(*a, **kw): return 0x1
    def __long__(*a, **kw): return long(1)
    def __index__(*a, **kw): return 1       


absolute_import = _Mock()

atexit = _Mock()

errno = _Mock()

ioloop = _Mock()

iteritems = _Mock()

string_types = _Mock()

time = _Mock()

validate_string_dict = _Mock()

validate_string_list = _Mock()

zmq = _Mock()

zmqstream = _Mock()



class HBChannel(_Mock):
  pass
  _Thread__initialized = False
  _exiting = False
  time_to_dead = 3.0

class HBChannelABC(_Mock):
  pass
  _abc_negative_cache_version = 50

class IOPubChannel(_Mock):
  pass
  _Thread__initialized = False
  _exiting = False

class IOPubChannelABC(_Mock):
  pass
  _abc_negative_cache_version = 49

class InvalidPortNumber(_Mock):
  pass


class ShellChannel(_Mock):
  pass
  _Thread__initialized = False
  _exiting = False
  allow_stdin = True

class ShellChannelABC(_Mock):
  pass
  _abc_negative_cache_version = 48

class StdInChannel(_Mock):
  pass
  _Thread__initialized = False
  _exiting = False

class StdInChannelABC(_Mock):
  pass
  _abc_negative_cache_version = 51

class Thread(_Mock):
  pass
  _Thread__initialized = False

class ZMQError(_Mock):
  pass


class ZMQSocketChannel(_Mock):
  pass
  _Thread__initialized = False
  _exiting = False

