from __future__ import print_function



class _MockMeta(type):
    def __getattr__(self, name):
        return _Mock()

class _Mock(object):
    __metaclass__ = _MockMeta
    def __init__(self, *a, **kw):
        object.__init__(self)
        for k,v in kw.iteritems():
            setattr(self, k, v)
    def __getattr__(*a, **kw): return _Mock()
    def __call__(*a, **kw): return _Mock()
    def __getitem__(*a, **kw): return _Mock()
    def __int__(*a, **kw): return 1
    def __contains__(*a, **kw): return False
    def __len__(*a, **kw): return 1
    def __iter__(*a, **kw): return iter([])
    def __exit__(*a, **kw): return False
    def __complex__(*a, **kw): return 1j
    def __float__(*a, **kw): return 1.0
    def __bool__(*a, **kw): return True
    def __nonzero__(*a, **kw): return True
    def __oct__(*a, **kw): return 1
    def __hex__(*a, **kw): return 0x1
    def __long__(*a, **kw): return long(1)
    def __index__(*a, **kw): return 1       


qwtDegree2Pos = _Mock()

qwtPolar2Pos = _Mock()

toNumpy = _Mock()

toQImage = _Mock()

QWT_VERSION = 328195

QWT_VERSION_STR = '5.2.3'

class QwtAbstractScale(_Mock):
  pass


class QwtAbstractScaleDraw(_Mock):
  pass
  Backbone = 1
  Labels = 4
  Ticks = 2

class QwtAbstractSlider(_Mock):
  pass
  DrawChildren = 2
  DrawWindowBackground = 1
  IgnoreMask = 4
  PdmDepth = 6
  PdmDpiX = 7
  PdmDpiY = 8
  PdmHeight = 2
  PdmHeightMM = 4
  PdmNumColors = 5
  PdmPhysicalDpiX = 9
  PdmPhysicalDpiY = 10
  PdmWidth = 1
  PdmWidthMM = 3
  ScrDirect = 3
  ScrMouse = 1
  ScrNone = 0
  ScrPage = 4
  ScrTimer = 2

class QwtAlphaColorMap(_Mock):
  pass
  Indexed = 1
  RGB = 0

class QwtAnalogClock(_Mock):
  pass
  Clockwise = 0
  CounterClockwise = 1
  DrawChildren = 2
  DrawWindowBackground = 1
  HourHand = 2
  IgnoreMask = 4
  MinuteHand = 1
  NHands = 3
  PdmDepth = 6
  PdmDpiX = 7
  PdmDpiY = 8
  PdmHeight = 2
  PdmHeightMM = 4
  PdmNumColors = 5
  PdmPhysicalDpiX = 9
  PdmPhysicalDpiY = 10
  PdmWidth = 1
  PdmWidthMM = 3
  Plain = 16
  Raised = 32
  RotateNeedle = 0
  RotateScale = 1
  ScaleBackbone = 1
  ScaleLabel = 4
  ScaleTicks = 2
  ScrDirect = 3
  ScrMouse = 1
  ScrNone = 0
  ScrPage = 4
  ScrTimer = 2
  SecondHand = 0
  Sunken = 48

class QwtArrayData(_Mock):
  pass


class QwtArrayDouble(_Mock):
  pass


class QwtArrayInt(_Mock):
  pass


class QwtArrayQwtDoubleInterval(_Mock):
  pass


class QwtArrayQwtDoublePoint(_Mock):
  pass


class QwtArrowButton(_Mock):
  pass
  DrawChildren = 2
  DrawWindowBackground = 1
  IgnoreMask = 4
  PdmDepth = 6
  PdmDpiX = 7
  PdmDpiY = 8
  PdmHeight = 2
  PdmHeightMM = 4
  PdmNumColors = 5
  PdmPhysicalDpiX = 9
  PdmPhysicalDpiY = 10
  PdmWidth = 1
  PdmWidthMM = 3

class QwtClipper(_Mock):
  pass


class QwtColorMap(_Mock):
  pass
  Indexed = 1
  RGB = 0

class QwtCompass(_Mock):
  pass
  Clockwise = 0
  CounterClockwise = 1
  DrawChildren = 2
  DrawWindowBackground = 1
  IgnoreMask = 4
  PdmDepth = 6
  PdmDpiX = 7
  PdmDpiY = 8
  PdmHeight = 2
  PdmHeightMM = 4
  PdmNumColors = 5
  PdmPhysicalDpiX = 9
  PdmPhysicalDpiY = 10
  PdmWidth = 1
  PdmWidthMM = 3
  Plain = 16
  Raised = 32
  RotateNeedle = 0
  RotateScale = 1
  ScaleBackbone = 1
  ScaleLabel = 4
  ScaleTicks = 2
  ScrDirect = 3
  ScrMouse = 1
  ScrNone = 0
  ScrPage = 4
  ScrTimer = 2
  Sunken = 48

class QwtCompassMagnetNeedle(_Mock):
  pass
  ThinStyle = 1
  TriangleStyle = 0

class QwtCompassRose(_Mock):
  pass


class QwtCompassWindArrow(_Mock):
  pass
  Style1 = 0
  Style2 = 1

class QwtCounter(_Mock):
  pass
  Button1 = 0
  Button2 = 1
  Button3 = 2
  ButtonCnt = 3
  DrawChildren = 2
  DrawWindowBackground = 1
  IgnoreMask = 4
  PdmDepth = 6
  PdmDpiX = 7
  PdmDpiY = 8
  PdmHeight = 2
  PdmHeightMM = 4
  PdmNumColors = 5
  PdmPhysicalDpiX = 9
  PdmPhysicalDpiY = 10
  PdmWidth = 1
  PdmWidthMM = 3

class QwtCurveFitter(_Mock):
  pass


class QwtData(_Mock):
  pass


class QwtDial(_Mock):
  pass
  Clockwise = 0
  CounterClockwise = 1
  DrawChildren = 2
  DrawWindowBackground = 1
  IgnoreMask = 4
  PdmDepth = 6
  PdmDpiX = 7
  PdmDpiY = 8
  PdmHeight = 2
  PdmHeightMM = 4
  PdmNumColors = 5
  PdmPhysicalDpiX = 9
  PdmPhysicalDpiY = 10
  PdmWidth = 1
  PdmWidthMM = 3
  Plain = 16
  Raised = 32
  RotateNeedle = 0
  RotateScale = 1
  ScaleBackbone = 1
  ScaleLabel = 4
  ScaleTicks = 2
  ScrDirect = 3
  ScrMouse = 1
  ScrNone = 0
  ScrPage = 4
  ScrTimer = 2
  Sunken = 48

class QwtDialNeedle(_Mock):
  pass


class QwtDialScaleDraw(_Mock):
  pass
  Backbone = 1
  Labels = 4
  Ticks = 2

class QwtDialSimpleNeedle(_Mock):
  pass
  Arrow = 0
  Ray = 1

class QwtDoubleInterval(_Mock):
  pass
  ExcludeBorders = 3
  ExcludeMaximum = 2
  ExcludeMinimum = 1
  IncludeBorders = 0

class QwtDoubleRange(_Mock):
  pass


class QwtDynGridLayout(_Mock):
  pass
  SetDefaultConstraint = 0
  SetFixedSize = 3
  SetMaximumSize = 4
  SetMinAndMaxSize = 5
  SetMinimumSize = 2
  SetNoConstraint = 1

class QwtEventPattern(_Mock):
  pass
  KeyAbort = 2
  KeyDown = 6
  KeyHome = 9
  KeyLeft = 3
  KeyPatternCount = 10
  KeyRedo = 7
  KeyRight = 4
  KeySelect1 = 0
  KeySelect2 = 1
  KeyUndo = 8
  KeyUp = 5
  MousePatternCount = 6
  MouseSelect1 = 0
  MouseSelect2 = 1
  MouseSelect3 = 2
  MouseSelect4 = 3
  MouseSelect5 = 4
  MouseSelect6 = 5

class QwtIntervalData(_Mock):
  pass


class QwtKnob(_Mock):
  pass
  Dot = 1
  DrawChildren = 2
  DrawWindowBackground = 1
  IgnoreMask = 4
  Line = 0
  PdmDepth = 6
  PdmDpiX = 7
  PdmDpiY = 8
  PdmHeight = 2
  PdmHeightMM = 4
  PdmNumColors = 5
  PdmPhysicalDpiX = 9
  PdmPhysicalDpiY = 10
  PdmWidth = 1
  PdmWidthMM = 3
  ScrDirect = 3
  ScrMouse = 1
  ScrNone = 0
  ScrPage = 4
  ScrTimer = 2

class QwtLegend(_Mock):
  pass
  AutoIdentifier = 2
  Box = 1
  CheckableItem = 2
  ClickableItem = 1
  DrawChildren = 2
  DrawWindowBackground = 1
  FixedIdentifier = 1
  HLine = 4
  IgnoreMask = 4
  NoFrame = 0
  NoIdentifier = 0
  Panel = 2
  PdmDepth = 6
  PdmDpiX = 7
  PdmDpiY = 8
  PdmHeight = 2
  PdmHeightMM = 4
  PdmNumColors = 5
  PdmPhysicalDpiX = 9
  PdmPhysicalDpiY = 10
  PdmWidth = 1
  PdmWidthMM = 3
  Plain = 16
  Raised = 32
  ReadOnlyItem = 0
  Shadow_Mask = 240
  Shape_Mask = 15
  StyledPanel = 6
  Sunken = 48
  VLine = 5
  WinPanel = 3

class QwtLegendItem(_Mock):
  pass
  Box = 1
  DrawChildren = 2
  DrawWindowBackground = 1
  HLine = 4
  IgnoreMask = 4
  NoFrame = 0
  NoIdentifier = 0
  Panel = 2
  PdmDepth = 6
  PdmDpiX = 7
  PdmDpiY = 8
  PdmHeight = 2
  PdmHeightMM = 4
  PdmNumColors = 5
  PdmPhysicalDpiX = 9
  PdmPhysicalDpiY = 10
  PdmWidth = 1
  PdmWidthMM = 3
  Plain = 16
  Raised = 32
  Shadow_Mask = 240
  Shape_Mask = 15
  ShowLine = 1
  ShowSymbol = 2
  ShowText = 4
  StyledPanel = 6
  Sunken = 48
  VLine = 5
  WinPanel = 3

class QwtLegendItemManager(_Mock):
  pass


class QwtLinearColorMap(_Mock):
  pass
  FixedColors = 0
  Indexed = 1
  RGB = 0
  ScaledColors = 1

class QwtLinearScaleEngine(_Mock):
  pass
  Floating = 4
  IncludeReference = 1
  Inverted = 8
  NoAttribute = 0
  Symmetric = 2

class QwtLog10ScaleEngine(_Mock):
  pass
  Floating = 4
  IncludeReference = 1
  Inverted = 8
  NoAttribute = 0
  Symmetric = 2

class QwtMagnifier(_Mock):
  pass


class QwtMetricsMap(_Mock):
  pass


class QwtPainter(_Mock):
  pass


class QwtPanner(_Mock):
  pass
  DrawChildren = 2
  DrawWindowBackground = 1
  IgnoreMask = 4
  PdmDepth = 6
  PdmDpiX = 7
  PdmDpiY = 8
  PdmHeight = 2
  PdmHeightMM = 4
  PdmNumColors = 5
  PdmPhysicalDpiX = 9
  PdmPhysicalDpiY = 10
  PdmWidth = 1
  PdmWidthMM = 3

class QwtPicker(_Mock):
  pass
  ActiveOnly = 2
  AlwaysOff = 0
  AlwaysOn = 1
  CenterToCorner = 128
  CenterToRadius = 256
  ClickSelection = 1024
  CornerToCorner = 64
  CrossRubberBand = 3
  DragSelection = 2048
  EllipseRubberBand = 5
  HLineRubberBand = 1
  KeepSize = 1
  KeyAbort = 2
  KeyDown = 6
  KeyHome = 9
  KeyLeft = 3
  KeyPatternCount = 10
  KeyRedo = 7
  KeyRight = 4
  KeySelect1 = 0
  KeySelect2 = 1
  KeyUndo = 8
  KeyUp = 5
  MousePatternCount = 6
  MouseSelect1 = 0
  MouseSelect2 = 1
  MouseSelect3 = 2
  MouseSelect4 = 3
  MouseSelect5 = 4
  MouseSelect6 = 5
  NoRubberBand = 0
  NoSelection = 0
  PointSelection = 1
  PolygonRubberBand = 6
  PolygonSelection = 4
  RectRubberBand = 4
  RectSelection = 2
  Stretch = 0
  UserRubberBand = 100
  VLineRubberBand = 2

class QwtPickerClickPointMachine(_Mock):
  pass
  Append = 1
  Begin = 0
  End = 3
  Move = 2

class QwtPickerClickRectMachine(_Mock):
  pass
  Append = 1
  Begin = 0
  End = 3
  Move = 2

class QwtPickerDragPointMachine(_Mock):
  pass
  Append = 1
  Begin = 0
  End = 3
  Move = 2

class QwtPickerDragRectMachine(_Mock):
  pass
  Append = 1
  Begin = 0
  End = 3
  Move = 2

class QwtPickerMachine(_Mock):
  pass
  Append = 1
  Begin = 0
  End = 3
  Move = 2

class QwtPickerPolygonMachine(_Mock):
  pass
  Append = 1
  Begin = 0
  End = 3
  Move = 2

class QwtPlainTextEngine(_Mock):
  pass


class QwtPlot(_Mock):
  pass
  BottomLegend = 2
  Box = 1
  DrawChildren = 2
  DrawWindowBackground = 1
  ExternalLegend = 4
  HLine = 4
  IgnoreMask = 4
  LeftLegend = 0
  NoFrame = 0
  Panel = 2
  PdmDepth = 6
  PdmDpiX = 7
  PdmDpiY = 8
  PdmHeight = 2
  PdmHeightMM = 4
  PdmNumColors = 5
  PdmPhysicalDpiX = 9
  PdmPhysicalDpiY = 10
  PdmWidth = 1
  PdmWidthMM = 3
  Plain = 16
  Raised = 32
  RightLegend = 1
  Shadow_Mask = 240
  Shape_Mask = 15
  StyledPanel = 6
  Sunken = 48
  TopLegend = 3
  VLine = 5
  WinPanel = 3
  axisCnt = 4
  xBottom = 2
  xTop = 3
  yLeft = 0
  yRight = 1

class QwtPlotCanvas(_Mock):
  pass
  Box = 1
  CanvasFocusIndicator = 1
  DrawChildren = 2
  DrawWindowBackground = 1
  HLine = 4
  IgnoreMask = 4
  ItemFocusIndicator = 2
  NoFocusIndicator = 0
  NoFrame = 0
  PaintCached = 1
  PaintPacked = 2
  Panel = 2
  PdmDepth = 6
  PdmDpiX = 7
  PdmDpiY = 8
  PdmHeight = 2
  PdmHeightMM = 4
  PdmNumColors = 5
  PdmPhysicalDpiX = 9
  PdmPhysicalDpiY = 10
  PdmWidth = 1
  PdmWidthMM = 3
  Plain = 16
  Raised = 32
  Shadow_Mask = 240
  Shape_Mask = 15
  StyledPanel = 6
  Sunken = 48
  VLine = 5
  WinPanel = 3

class QwtPlotCurve(_Mock):
  pass
  AutoScale = 2
  ClipPolygons = 2
  Dots = 4
  Fitted = 2
  Inverted = 1
  Legend = 1
  Lines = 1
  NoCurve = 0
  PaintFiltered = 1
  RenderAntialiased = 1
  Rtti_PlotCurve = 4
  Rtti_PlotGrid = 1
  Rtti_PlotHistogram = 5
  Rtti_PlotItem = 0
  Rtti_PlotMarker = 3
  Rtti_PlotSVG = 7
  Rtti_PlotScale = 2
  Rtti_PlotSpectrogram = 6
  Rtti_PlotUserItem = 1000
  Steps = 3
  Sticks = 2
  UserCurve = 100
  Xfy = 1
  Yfx = 0

class QwtPlotDict(_Mock):
  pass


class QwtPlotGrid(_Mock):
  pass
  AutoScale = 2
  Legend = 1
  RenderAntialiased = 1
  Rtti_PlotCurve = 4
  Rtti_PlotGrid = 1
  Rtti_PlotHistogram = 5
  Rtti_PlotItem = 0
  Rtti_PlotMarker = 3
  Rtti_PlotSVG = 7
  Rtti_PlotScale = 2
  Rtti_PlotSpectrogram = 6
  Rtti_PlotUserItem = 1000

class QwtPlotItem(_Mock):
  pass
  AutoScale = 2
  Legend = 1
  RenderAntialiased = 1
  Rtti_PlotCurve = 4
  Rtti_PlotGrid = 1
  Rtti_PlotHistogram = 5
  Rtti_PlotItem = 0
  Rtti_PlotMarker = 3
  Rtti_PlotSVG = 7
  Rtti_PlotScale = 2
  Rtti_PlotSpectrogram = 6
  Rtti_PlotUserItem = 1000

class QwtPlotLayout(_Mock):
  pass
  AlignScales = 1
  IgnoreFrames = 4
  IgnoreLegend = 16
  IgnoreMargin = 8
  IgnoreScrollbars = 2

class QwtPlotMagnifier(_Mock):
  pass


class QwtPlotMarker(_Mock):
  pass
  AutoScale = 2
  Cross = 3
  HLine = 1
  Legend = 1
  NoLine = 0
  RenderAntialiased = 1
  Rtti_PlotCurve = 4
  Rtti_PlotGrid = 1
  Rtti_PlotHistogram = 5
  Rtti_PlotItem = 0
  Rtti_PlotMarker = 3
  Rtti_PlotSVG = 7
  Rtti_PlotScale = 2
  Rtti_PlotSpectrogram = 6
  Rtti_PlotUserItem = 1000
  VLine = 2

class QwtPlotPanner(_Mock):
  pass
  DrawChildren = 2
  DrawWindowBackground = 1
  IgnoreMask = 4
  PdmDepth = 6
  PdmDpiX = 7
  PdmDpiY = 8
  PdmHeight = 2
  PdmHeightMM = 4
  PdmNumColors = 5
  PdmPhysicalDpiX = 9
  PdmPhysicalDpiY = 10
  PdmWidth = 1
  PdmWidthMM = 3

class QwtPlotPicker(_Mock):
  pass
  ActiveOnly = 2
  AlwaysOff = 0
  AlwaysOn = 1
  CenterToCorner = 128
  CenterToRadius = 256
  ClickSelection = 1024
  CornerToCorner = 64
  CrossRubberBand = 3
  DragSelection = 2048
  EllipseRubberBand = 5
  HLineRubberBand = 1
  KeepSize = 1
  KeyAbort = 2
  KeyDown = 6
  KeyHome = 9
  KeyLeft = 3
  KeyPatternCount = 10
  KeyRedo = 7
  KeyRight = 4
  KeySelect1 = 0
  KeySelect2 = 1
  KeyUndo = 8
  KeyUp = 5
  MousePatternCount = 6
  MouseSelect1 = 0
  MouseSelect2 = 1
  MouseSelect3 = 2
  MouseSelect4 = 3
  MouseSelect5 = 4
  MouseSelect6 = 5
  NoRubberBand = 0
  NoSelection = 0
  PointSelection = 1
  PolygonRubberBand = 6
  PolygonSelection = 4
  RectRubberBand = 4
  RectSelection = 2
  Stretch = 0
  UserRubberBand = 100
  VLineRubberBand = 2

class QwtPlotPrintFilter(_Mock):
  pass
  AxisScale = 9
  AxisTitle = 10
  CanvasBackground = 8
  Curve = 2
  CurveSymbol = 3
  Legend = 1
  MajorGrid = 6
  Marker = 4
  MarkerSymbol = 5
  MinorGrid = 7
  PrintAll = -33
  PrintBackground = 16
  PrintFrameWithScales = 32
  PrintGrid = 8
  PrintLegend = 4
  PrintMargin = 1
  PrintTitle = 2
  Title = 0
  WidgetBackground = 11

class QwtPlotRasterItem(_Mock):
  pass
  AutoScale = 2
  Legend = 1
  NoCache = 0
  PaintCache = 1
  RenderAntialiased = 1
  Rtti_PlotCurve = 4
  Rtti_PlotGrid = 1
  Rtti_PlotHistogram = 5
  Rtti_PlotItem = 0
  Rtti_PlotMarker = 3
  Rtti_PlotSVG = 7
  Rtti_PlotScale = 2
  Rtti_PlotSpectrogram = 6
  Rtti_PlotUserItem = 1000
  ScreenCache = 2

class QwtPlotRescaler(_Mock):
  pass
  ExpandBoth = 2
  ExpandDown = 1
  ExpandUp = 0
  Expanding = 1
  Fitting = 2
  Fixed = 0

class QwtPlotScaleItem(_Mock):
  pass
  AutoScale = 2
  Legend = 1
  RenderAntialiased = 1
  Rtti_PlotCurve = 4
  Rtti_PlotGrid = 1
  Rtti_PlotHistogram = 5
  Rtti_PlotItem = 0
  Rtti_PlotMarker = 3
  Rtti_PlotSVG = 7
  Rtti_PlotScale = 2
  Rtti_PlotSpectrogram = 6
  Rtti_PlotUserItem = 1000

class QwtPlotSpectrogram(_Mock):
  pass
  AutoScale = 2
  ContourMode = 2
  ImageMode = 1
  Legend = 1
  NoCache = 0
  PaintCache = 1
  RenderAntialiased = 1
  Rtti_PlotCurve = 4
  Rtti_PlotGrid = 1
  Rtti_PlotHistogram = 5
  Rtti_PlotItem = 0
  Rtti_PlotMarker = 3
  Rtti_PlotSVG = 7
  Rtti_PlotScale = 2
  Rtti_PlotSpectrogram = 6
  Rtti_PlotUserItem = 1000
  ScreenCache = 2

class QwtPlotSvgItem(_Mock):
  pass
  AutoScale = 2
  Legend = 1
  RenderAntialiased = 1
  Rtti_PlotCurve = 4
  Rtti_PlotGrid = 1
  Rtti_PlotHistogram = 5
  Rtti_PlotItem = 0
  Rtti_PlotMarker = 3
  Rtti_PlotSVG = 7
  Rtti_PlotScale = 2
  Rtti_PlotSpectrogram = 6
  Rtti_PlotUserItem = 1000

class QwtPlotZoomer(_Mock):
  pass
  ActiveOnly = 2
  AlwaysOff = 0
  AlwaysOn = 1
  CenterToCorner = 128
  CenterToRadius = 256
  ClickSelection = 1024
  CornerToCorner = 64
  CrossRubberBand = 3
  DragSelection = 2048
  EllipseRubberBand = 5
  HLineRubberBand = 1
  KeepSize = 1
  KeyAbort = 2
  KeyDown = 6
  KeyHome = 9
  KeyLeft = 3
  KeyPatternCount = 10
  KeyRedo = 7
  KeyRight = 4
  KeySelect1 = 0
  KeySelect2 = 1
  KeyUndo = 8
  KeyUp = 5
  MousePatternCount = 6
  MouseSelect1 = 0
  MouseSelect2 = 1
  MouseSelect3 = 2
  MouseSelect4 = 3
  MouseSelect5 = 4
  MouseSelect6 = 5
  NoRubberBand = 0
  NoSelection = 0
  PointSelection = 1
  PolygonRubberBand = 6
  PolygonSelection = 4
  RectRubberBand = 4
  RectSelection = 2
  Stretch = 0
  UserRubberBand = 100
  VLineRubberBand = 2

class QwtPolygonFData(_Mock):
  pass


class QwtRasterData(_Mock):
  pass
  IgnoreAllVerticesOnLevel = 1
  IgnoreOutOfRange = 2

class QwtRichTextEngine(_Mock):
  pass


class QwtRoundScaleDraw(_Mock):
  pass
  Backbone = 1
  Labels = 4
  Ticks = 2

class QwtScaleArithmetic(_Mock):
  pass


class QwtScaleDiv(_Mock):
  pass
  MajorTick = 2
  MediumTick = 1
  MinorTick = 0
  NTickTypes = 3
  NoTick = -1

class QwtScaleDraw(_Mock):
  pass
  Backbone = 1
  BottomScale = 0
  Labels = 4
  LeftScale = 2
  RightScale = 3
  Ticks = 2
  TopScale = 1

class QwtScaleEngine(_Mock):
  pass
  Floating = 4
  IncludeReference = 1
  Inverted = 8
  NoAttribute = 0
  Symmetric = 2

class QwtScaleMap(_Mock):
  pass
  LogMax = 1e+150
  LogMin = 1e-150

class QwtScaleTransformation(_Mock):
  pass
  Linear = 0
  Log10 = 1
  Other = 2

class QwtScaleWidget(_Mock):
  pass
  DrawChildren = 2
  DrawWindowBackground = 1
  IgnoreMask = 4
  PdmDepth = 6
  PdmDpiX = 7
  PdmDpiY = 8
  PdmHeight = 2
  PdmHeightMM = 4
  PdmNumColors = 5
  PdmPhysicalDpiX = 9
  PdmPhysicalDpiY = 10
  PdmWidth = 1
  PdmWidthMM = 3

class QwtSimpleCompassRose(_Mock):
  pass


class QwtSlider(_Mock):
  pass
  BgBoth = 3
  BgSlot = 2
  BgTrough = 1
  BottomScale = 4
  DrawChildren = 2
  DrawWindowBackground = 1
  IgnoreMask = 4
  LeftScale = 1
  NoScale = 0
  PdmDepth = 6
  PdmDpiX = 7
  PdmDpiY = 8
  PdmHeight = 2
  PdmHeightMM = 4
  PdmNumColors = 5
  PdmPhysicalDpiX = 9
  PdmPhysicalDpiY = 10
  PdmWidth = 1
  PdmWidthMM = 3
  RightScale = 2
  ScrDirect = 3
  ScrMouse = 1
  ScrNone = 0
  ScrPage = 4
  ScrTimer = 2
  TopScale = 3

class QwtSpline(_Mock):
  pass
  Natural = 0
  Periodic = 1

class QwtSplineCurveFitter(_Mock):
  pass
  Auto = 0
  ParametricSpline = 2
  Spline = 1

class QwtSymbol(_Mock):
  pass
  Cross = 8
  DTriangle = 4
  Diamond = 2
  Ellipse = 0
  HLine = 10
  Hexagon = 14
  LTriangle = 6
  NoSymbol = -1
  RTriangle = 7
  Rect = 1
  Star1 = 12
  Star2 = 13
  StyleCnt = 15
  Triangle = 3
  UTriangle = 5
  VLine = 11
  XCross = 9

class QwtText(_Mock):
  pass
  AutoText = 0
  MathMLText = 3
  MinimumLayout = 1
  OtherFormat = 100
  PaintBackground = 4
  PaintUsingTextColor = 2
  PaintUsingTextFont = 1
  PlainText = 1
  RichText = 2
  TeXText = 4

class QwtTextEngine(_Mock):
  pass


class QwtTextLabel(_Mock):
  pass
  Box = 1
  DrawChildren = 2
  DrawWindowBackground = 1
  HLine = 4
  IgnoreMask = 4
  NoFrame = 0
  Panel = 2
  PdmDepth = 6
  PdmDpiX = 7
  PdmDpiY = 8
  PdmHeight = 2
  PdmHeightMM = 4
  PdmNumColors = 5
  PdmPhysicalDpiX = 9
  PdmPhysicalDpiY = 10
  PdmWidth = 1
  PdmWidthMM = 3
  Plain = 16
  Raised = 32
  Shadow_Mask = 240
  Shape_Mask = 15
  StyledPanel = 6
  Sunken = 48
  VLine = 5
  WinPanel = 3

class QwtThermo(_Mock):
  pass
  BottomScale = 4
  DrawChildren = 2
  DrawWindowBackground = 1
  IgnoreMask = 4
  LeftScale = 1
  NoScale = 0
  PdmDepth = 6
  PdmDpiX = 7
  PdmDpiY = 8
  PdmHeight = 2
  PdmHeightMM = 4
  PdmNumColors = 5
  PdmPhysicalDpiX = 9
  PdmPhysicalDpiY = 10
  PdmWidth = 1
  PdmWidthMM = 3
  RightScale = 2
  TopScale = 3

class QwtWheel(_Mock):
  pass
  DrawChildren = 2
  DrawWindowBackground = 1
  IgnoreMask = 4
  PdmDepth = 6
  PdmDpiX = 7
  PdmDpiY = 8
  PdmHeight = 2
  PdmHeightMM = 4
  PdmNumColors = 5
  PdmPhysicalDpiX = 9
  PdmPhysicalDpiY = 10
  PdmWidth = 1
  PdmWidthMM = 3
  ScrDirect = 3
  ScrMouse = 1
  ScrNone = 0
  ScrPage = 4
  ScrTimer = 2

