/* -*- Mode: C++; indent-tabs-mode: nil; tab-width: 4 -*-
 * -*- coding: utf-8 -*-
 *
 * Copyright (C) 2020 KylinSoft Co., Ltd.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef BRIGHTTHREAD_H
#define BRIGHTTHREAD_H

#include <QThread>
#include <QMutex>
class QGSettings;

class BrightThread : public QThread
{
    Q_OBJECT
public:
    BrightThread(QObject *parent = nullptr, double bright = 100.0);
//    BrightThread(QObject *parent = nullptr);
    ~BrightThread();
    void stopImmediately();

protected:
    void run();

private:
    double brightness;
    double currentBrightness;
    QGSettings *mpowerSettings;
    bool m_isCanRun;
    QMutex m_lock;
};

#endif // BRIGHTTHREAD_H
