/* umockdev.c generated by valac 0.44.9, the Vala compiler
 * generated from umockdev.vala, do not modify */

/*
 * Copyright (C) 2012-2013 Canonical Ltd.
 * Author: Martin Pitt <martin.pitt@ubuntu.com>
 *
 * umockdev is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * umockdev is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; If not, see <http://www.gnu.org/licenses/>.
 */
/**
 * SECTION:umockdev
 * @title: umockdev
 * @short_description: Build a test bed for testing software that handles Linux
 * hardware devices.
 *
 * Please see README.rst about an overview of the parts of umockdev, and how
 * they fit together.
 */
/**
 * SECTION:functions
 * @title: global functions
 * @short_description: Global functions
 *
 * These work independently from #Testbed objects.
 */
/**
 * SECTION:umockdeverror
 * @title: umockdev errors
 * @short_description: #GError types for parsing umockdev files
 * hardware devices.
 *
 * See #GError for more information on error domains.
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include "uevent_sender.h"
#include <unistd.h>
#include <glib/gstdio.h>
#include <errno.h>
#include <gio/gio.h>
#include <stdarg.h>
#include <sys/socket.h>
#include <linux/input.h>
#include <time.h>
#include <pty.h>
#include <termios.h>
#include <stdio.h>
#include <sys/select.h>
#include <sys/time.h>
#include <gobject/gvaluecollector.h>
#include <gio/gunixsocketaddress.h>
#include <sys/stat.h>
#include <sys/types.h>

#define UMOCKDEV_TYPE_TESTBED (umockdev_testbed_get_type ())
#define UMOCKDEV_TESTBED(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), UMOCKDEV_TYPE_TESTBED, UMockdevTestbed))
#define UMOCKDEV_TESTBED_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), UMOCKDEV_TYPE_TESTBED, UMockdevTestbedClass))
#define UMOCKDEV_IS_TESTBED(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), UMOCKDEV_TYPE_TESTBED))
#define UMOCKDEV_IS_TESTBED_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), UMOCKDEV_TYPE_TESTBED))
#define UMOCKDEV_TESTBED_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), UMOCKDEV_TYPE_TESTBED, UMockdevTestbedClass))

typedef struct _UMockdevTestbed UMockdevTestbed;
typedef struct _UMockdevTestbedClass UMockdevTestbedClass;
typedef struct _UMockdevTestbedPrivate UMockdevTestbedPrivate;

#define UMOCKDEV_TYPE_SCRIPT_RUNNER (umockdev_script_runner_get_type ())
#define UMOCKDEV_SCRIPT_RUNNER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), UMOCKDEV_TYPE_SCRIPT_RUNNER, UMockdevScriptRunner))
#define UMOCKDEV_SCRIPT_RUNNER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), UMOCKDEV_TYPE_SCRIPT_RUNNER, UMockdevScriptRunnerClass))
#define UMOCKDEV_IS_SCRIPT_RUNNER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), UMOCKDEV_TYPE_SCRIPT_RUNNER))
#define UMOCKDEV_IS_SCRIPT_RUNNER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), UMOCKDEV_TYPE_SCRIPT_RUNNER))
#define UMOCKDEV_SCRIPT_RUNNER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), UMOCKDEV_TYPE_SCRIPT_RUNNER, UMockdevScriptRunnerClass))

typedef struct _UMockdevScriptRunner UMockdevScriptRunner;
typedef struct _UMockdevScriptRunnerClass UMockdevScriptRunnerClass;

#define UMOCKDEV_TYPE_SOCKET_SERVER (umockdev_socket_server_get_type ())
#define UMOCKDEV_SOCKET_SERVER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), UMOCKDEV_TYPE_SOCKET_SERVER, UMockdevSocketServer))
#define UMOCKDEV_SOCKET_SERVER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), UMOCKDEV_TYPE_SOCKET_SERVER, UMockdevSocketServerClass))
#define UMOCKDEV_IS_SOCKET_SERVER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), UMOCKDEV_TYPE_SOCKET_SERVER))
#define UMOCKDEV_IS_SOCKET_SERVER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), UMOCKDEV_TYPE_SOCKET_SERVER))
#define UMOCKDEV_SOCKET_SERVER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), UMOCKDEV_TYPE_SOCKET_SERVER, UMockdevSocketServerClass))

typedef struct _UMockdevSocketServer UMockdevSocketServer;
typedef struct _UMockdevSocketServerClass UMockdevSocketServerClass;
enum  {
	UMOCKDEV_TESTBED_0_PROPERTY,
	UMOCKDEV_TESTBED_NUM_PROPERTIES
};
static GParamSpec* umockdev_testbed_properties[UMOCKDEV_TESTBED_NUM_PROPERTIES];
#define _umockdev_socket_server_unref0(var) ((var == NULL) ? NULL : (var = (umockdev_socket_server_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
#define _uevent_sender_close0(var) ((var == NULL) ? NULL : (var = (uevent_sender_close (var), NULL)))
#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_match_info_unref0(var) ((var == NULL) ? NULL : (var = (g_match_info_unref (var), NULL)))
#define _umockdev_script_runner_unref0(var) ((var == NULL) ? NULL : (var = (umockdev_script_runner_unref (var), NULL)))
#define _fclose0(var) ((var == NULL) ? NULL : (var = (fclose (var), NULL)))
#define _g_dir_close0(var) ((var == NULL) ? NULL : (var = (g_dir_close (var), NULL)))
typedef struct _UMockdevScriptRunnerPrivate UMockdevScriptRunnerPrivate;
#define _g_thread_unref0(var) ((var == NULL) ? NULL : (var = (g_thread_unref (var), NULL)))
#define _g_string_free0(var) ((var == NULL) ? NULL : (var = (g_string_free (var, TRUE), NULL)))
typedef struct _UMockdevParamSpecScriptRunner UMockdevParamSpecScriptRunner;
typedef struct _UMockdevSocketServerPrivate UMockdevSocketServerPrivate;
typedef struct _UMockdevParamSpecSocketServer UMockdevParamSpecSocketServer;
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _UMockdevTestbed {
	GObject parent_instance;
	UMockdevTestbedPrivate * priv;
};

struct _UMockdevTestbedClass {
	GObjectClass parent_class;
};

struct _UMockdevTestbedPrivate {
	gchar* root_dir;
	gchar* sys_dir;
	GRegex* re_record_val;
	GRegex* re_record_keyval;
	GRegex* re_record_optval;
	uevent_sender* ev_sender;
	GHashTable* dev_fd;
	GHashTable* dev_script_runner;
	UMockdevSocketServer* socket_server;
};

typedef enum  {
	UMOCKDEV_ERROR_PARSE,
	UMOCKDEV_ERROR_VALUE
} UMockdevError;
#define UMOCKDEV_ERROR umockdev_error_quark ()
struct _UMockdevScriptRunner {
	GTypeInstance parent_instance;
	volatile int ref_count;
	UMockdevScriptRunnerPrivate * priv;
};

struct _UMockdevScriptRunnerClass {
	GTypeClass parent_class;
	void (*finalize) (UMockdevScriptRunner *self);
};

struct _UMockdevScriptRunnerPrivate {
	gchar* _device;
	gchar* script_file;
	GThread* thread;
	FILE* script;
	gint fd;
	gboolean running;
	guint fuzz;
};

struct _UMockdevParamSpecScriptRunner {
	GParamSpec parent_instance;
};

struct _UMockdevSocketServer {
	GTypeInstance parent_instance;
	volatile int ref_count;
	UMockdevSocketServerPrivate * priv;
};

struct _UMockdevSocketServerClass {
	GTypeClass parent_class;
	void (*finalize) (UMockdevSocketServer *self);
};

struct _UMockdevSocketServerPrivate {
	GSocket** listen_sockets;
	gint listen_sockets_length1;
	gint _listen_sockets_size_;
	GHashTable* socket_scriptfile;
	GHashTable* script_runners;
	GThread* thread;
	gboolean running;
	gint ctrl_r;
	gint ctrl_w;
};

struct _UMockdevParamSpecSocketServer {
	GParamSpec parent_instance;
};

/**
 * UMockdevError:
 * @UMOCKDEV_ERROR_PARSE:
 * There is a malformed or missing line in the device description.
 * @UMOCKDEV_ERROR_VALUE:
 * A value in the device description has an invalid value, for example a device
 * path does not start with "/devices/".
 *
 * Error codes for parsing umockdev files.
 */

extern gboolean umockdev___in_mock_env_initialized;
gboolean umockdev___in_mock_env_initialized = FALSE;
extern gboolean umockdev___in_mock_env_result;
gboolean umockdev___in_mock_env_result = FALSE;
static gint UMockdevTestbed_private_offset;
static gpointer umockdev_testbed_parent_class = NULL;
static GHashTable* umockdev_testbed_bus_lookup_table;
static GHashTable* umockdev_testbed_bus_lookup_table = NULL;
static gint UMockdevScriptRunner_private_offset;
static gpointer umockdev_script_runner_parent_class = NULL;
static gint UMockdevSocketServer_private_offset;
static gpointer umockdev_socket_server_parent_class = NULL;

GType umockdev_testbed_get_type (void) G_GNUC_CONST;
gpointer umockdev_script_runner_ref (gpointer instance);
void umockdev_script_runner_unref (gpointer instance);
GParamSpec* umockdev_param_spec_script_runner (const gchar* name,
                                               const gchar* nick,
                                               const gchar* blurb,
                                               GType object_type,
                                               GParamFlags flags);
void umockdev_value_set_script_runner (GValue* value,
                                       gpointer v_object);
void umockdev_value_take_script_runner (GValue* value,
                                        gpointer v_object);
gpointer umockdev_value_get_script_runner (const GValue* value);
GType umockdev_script_runner_get_type (void) G_GNUC_CONST;
gpointer umockdev_socket_server_ref (gpointer instance);
void umockdev_socket_server_unref (gpointer instance);
GParamSpec* umockdev_param_spec_socket_server (const gchar* name,
                                               const gchar* nick,
                                               const gchar* blurb,
                                               GType object_type,
                                               GParamFlags flags);
void umockdev_value_set_socket_server (GValue* value,
                                       gpointer v_object);
void umockdev_value_take_socket_server (GValue* value,
                                        gpointer v_object);
gpointer umockdev_value_get_socket_server (const GValue* value);
GType umockdev_socket_server_get_type (void) G_GNUC_CONST;
void umockdev_script_runner_stop (UMockdevScriptRunner* self);
void umockdev_socket_server_stop (UMockdevSocketServer* self);
void umockdev_remove_dir (const gchar* path,
                          gboolean remove_toplevel);
UMockdevTestbed* umockdev_testbed_new (void);
UMockdevTestbed* umockdev_testbed_construct (GType object_type);
static void _g_free0_ (gpointer var);
static void _umockdev_script_runner_unref0_ (gpointer var);
gchar* umockdev_testbed_get_root_dir (UMockdevTestbed* self);
gchar* umockdev_testbed_get_sys_dir (UMockdevTestbed* self);
void umockdev_testbed_set_attribute (UMockdevTestbed* self,
                                     const gchar* devpath,
                                     const gchar* name,
                                     const gchar* value);
void umockdev_testbed_set_attribute_binary (UMockdevTestbed* self,
                                            const gchar* devpath,
                                            const gchar* name,
                                            guint8* value,
                                            gint value_length1);
void umockdev_testbed_set_attribute_int (UMockdevTestbed* self,
                                         const gchar* devpath,
                                         const gchar* name,
                                         gint value);
void umockdev_testbed_set_attribute_hex (UMockdevTestbed* self,
                                         const gchar* devpath,
                                         const gchar* name,
                                         guint value);
void umockdev_testbed_set_attribute_link (UMockdevTestbed* self,
                                          const gchar* devpath,
                                          const gchar* name,
                                          const gchar* value);
gchar* umockdev_testbed_get_property (UMockdevTestbed* self,
                                      const gchar* devpath,
                                      const gchar* name);
void umockdev_testbed_set_property (UMockdevTestbed* self,
                                    const gchar* devpath,
                                    const gchar* name,
                                    const gchar* value);
void umockdev_testbed_set_property_int (UMockdevTestbed* self,
                                        const gchar* devpath,
                                        const gchar* name,
                                        gint value);
void umockdev_testbed_set_property_hex (UMockdevTestbed* self,
                                        const gchar* devpath,
                                        const gchar* name,
                                        guint value);
gchar* umockdev_testbed_add_devicev (UMockdevTestbed* self,
                                     const gchar* subsystem,
                                     const gchar* name,
                                     const gchar* parent,
                                     gchar** attributes,
                                     gchar** properties);
static gboolean umockdev_testbed_subsystem_is_bus (const gchar* subsystem);
gchar* umockdev_make_dotdots (const gchar* path);
gboolean umockdev_in_mock_environment (void);
void umockdev_testbed_uevent (UMockdevTestbed* self,
                              const gchar* devpath,
                              const gchar* action);
gchar* umockdev_testbed_add_device (UMockdevTestbed* self,
                                    const gchar* subsystem,
                                    const gchar* name,
                                    const gchar* parent,
                                    ...);
static void _vala_array_add1 (gchar** * array,
                       int* length,
                       int* size,
                       gchar* value);
static void _vala_array_add2 (gchar** * array,
                       int* length,
                       int* size,
                       gchar* value);
void umockdev_testbed_remove_device (UMockdevTestbed* self,
                                     const gchar* syspath);
gchar* umockdev_find_devnode (const gchar* devpath);
GQuark umockdev_error_quark (void);
gboolean umockdev_testbed_add_from_string (UMockdevTestbed* self,
                                           const gchar* data,
                                           GError** error);
static gchar* umockdev_testbed_add_dev_from_string (UMockdevTestbed* self,
                                             const gchar* data,
                                             GError** error);
gboolean umockdev_testbed_add_from_file (UMockdevTestbed* self,
                                         const gchar* path,
                                         GError** error);
gboolean umockdev_testbed_load_ioctl (UMockdevTestbed* self,
                                      const gchar* dev,
                                      const gchar* recordfile,
                                      GError** error);
static guint8* _vala_array_dup1 (guint8* self,
                          int length);
gboolean umockdev_testbed_load_script (UMockdevTestbed* self,
                                       const gchar* dev,
                                       const gchar* recordfile,
                                       GError** error);
gint umockdev_testbed_get_dev_fd (UMockdevTestbed* self,
                                  const gchar* devnode);
UMockdevScriptRunner* umockdev_script_runner_new (const gchar* device,
                                                  const gchar* script_file,
                                                  gint fd,
                                                  GError** error);
UMockdevScriptRunner* umockdev_script_runner_construct (GType object_type,
                                                        const gchar* device,
                                                        const gchar* script_file,
                                                        gint fd,
                                                        GError** error);
gboolean umockdev_testbed_load_socket_script (UMockdevTestbed* self,
                                              const gchar* path,
                                              gint type,
                                              const gchar* recordfile,
                                              GError** error);
UMockdevSocketServer* umockdev_socket_server_new (void);
UMockdevSocketServer* umockdev_socket_server_construct (GType object_type);
void umockdev_socket_server_add (UMockdevSocketServer* self,
                                 const gchar* sock_path,
                                 gint fd,
                                 const gchar* record_file);
gboolean umockdev_testbed_load_evemu_events (UMockdevTestbed* self,
                                             const gchar* dev,
                                             const gchar* eventsfile,
                                             GError** error);
gchar* umockdev_script_runner_encode (guint8* data,
                                      gint data_length1);
static GHashTable* umockdev_testbed_create_bus_lookup (void);
static gchar* umockdev_testbed_record_parse_line (UMockdevTestbed* self,
                                           const gchar* data,
                                           gchar* type,
                                           gchar* * key,
                                           gchar* * val);
static void _vala_array_add3 (gchar** * array,
                       int* length,
                       int* size,
                       gchar* value);
static void _vala_array_add4 (gchar** * array,
                       int* length,
                       int* size,
                       gchar* value);
static void _vala_array_add5 (gchar** * array,
                       int* length,
                       int* size,
                       gchar* value);
static void _vala_array_add6 (gchar** * array,
                       int* length,
                       int* size,
                       gchar* value);
static void _vala_array_add7 (gchar** * array,
                       int* length,
                       int* size,
                       gchar* value);
static void _vala_array_add8 (gchar** * array,
                       int* length,
                       int* size,
                       gchar* value);
static void _vala_array_add9 (gchar** * array,
                       int* length,
                       int* size,
                       gchar* value);
static void _vala_array_add10 (gchar** * array,
                        int* length,
                        int* size,
                        gchar* value);
guint8* umockdev_decode_hex (const gchar* data,
                             gint* result_length1,
                             GError** error);
static void _vala_array_add11 (gchar** * array,
                        int* length,
                        int* size,
                        gchar* value);
static void umockdev_testbed_create_node_for_device (UMockdevTestbed* self,
                                              const gchar* subsystem,
                                              const gchar* node_path,
                                              guint8* node_contents,
                                              gint node_contents_length1,
                                              const gchar* majmin,
                                              GError** error);
void umockdev_testbed_disable (UMockdevTestbed* self);
void umockdev_testbed_enable (UMockdevTestbed* self);
void umockdev_testbed_clear (UMockdevTestbed* self);
static void umockdev_testbed_finalize (GObject * obj);
guint8 umockdev_hexdigit (gchar c);
static void umockdev_script_runner_set_device (UMockdevScriptRunner* self,
                                        const gchar* value);
static void* umockdev_script_runner_run (UMockdevScriptRunner* self);
static gpointer _umockdev_script_runner_run_gthread_func (gpointer self);
const gchar* umockdev_script_runner_get_device (UMockdevScriptRunner* self);
static guint8* umockdev_script_runner_next_line (UMockdevScriptRunner* self,
                                          gchar* op,
                                          guint32* delta,
                                          gint* result_length1);
static void umockdev_script_runner_op_write (UMockdevScriptRunner* self,
                                      guint8* data,
                                      gint data_length1,
                                      guint32 delta);
static guint8* umockdev_script_runner_decode (const gchar* quoted,
                                       gint* result_length1);
static guint umockdev_script_runner_hamming (guint8* d1,
                                      gint d1_length1,
                                      guint8* d2,
                                      gint d2_length1);
static void _vala_array_add12 (guint8* * array,
                        int* length,
                        int* size,
                        guint8 value);
static void _vala_array_add13 (guint8* * array,
                        int* length,
                        int* size,
                        guint8 value);
static void _vala_array_add14 (guint8* * array,
                        int* length,
                        int* size,
                        guint8 value);
static void _vala_array_add15 (guint8* * array,
                        int* length,
                        int* size,
                        guint8 value);
static void _vala_array_add16 (guint8* * array,
                        int* length,
                        int* size,
                        guint8 value);
static void _vala_array_add17 (guint8* * array,
                        int* length,
                        int* size,
                        guint8 value);
static void _vala_array_add18 (guint8* * array,
                        int* length,
                        int* size,
                        guint8 value);
static void _vala_array_add19 (guint8* * array,
                        int* length,
                        int* size,
                        guint8 value);
static void umockdev_script_runner_finalize (UMockdevScriptRunner * obj);
static void* umockdev_socket_server_run (UMockdevSocketServer* self);
static gpointer _umockdev_socket_server_run_gthread_func (gpointer self);
static void _vala_array_add20 (GSocket** * array,
                        int* length,
                        int* size,
                        GSocket* value);
static void umockdev_socket_server_finalize (UMockdevSocketServer * obj);
static void _vala_array_destroy (gpointer array,
                          gint array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gint array_length,
                       GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);

static inline gpointer
umockdev_testbed_get_instance_private (UMockdevTestbed* self)
{
	return G_STRUCT_MEMBER_P (self, UMockdevTestbed_private_offset);
}

/**
     * umockdev_testbed_new:
     *
     * Create a new #UMockdevTestbed object. This is initially empty, call
     * methods like #umockdev_testbed_add_device or
     * #umockdev_testbed_add_from_string to fill it.
     *
     * Returns: The newly created #UMockdevTestbed object.
     */
static void
_g_free0_ (gpointer var)
{
	var = (g_free (var), NULL);
}

static void
_umockdev_script_runner_unref0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (umockdev_script_runner_unref (var), NULL));
}

UMockdevTestbed*
umockdev_testbed_construct (GType object_type)
{
	UMockdevTestbed * self = NULL;
	const gchar* _tmp4_;
	gchar* _tmp5_;
	const gchar* _tmp6_;
	GHashFunc _tmp7_;
	GEqualFunc _tmp8_;
	GHashTable* _tmp9_;
	GHashFunc _tmp10_;
	GEqualFunc _tmp11_;
	GHashTable* _tmp12_;
	const gchar* _tmp13_;
	const gchar* _tmp14_;
	GError* _inner_error0_ = NULL;
	self = (UMockdevTestbed*) g_object_new (object_type, NULL);
	{
		gchar* _tmp0_ = NULL;
		gchar* _tmp1_;
		gchar* _tmp2_;
		_tmp1_ = g_dir_make_tmp ("umockdev.XXXXXX", &_inner_error0_);
		_tmp0_ = _tmp1_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == G_FILE_ERROR) {
				goto __catch0_g_file_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp2_ = _tmp0_;
		_tmp0_ = NULL;
		_g_free0 (self->priv->root_dir);
		self->priv->root_dir = _tmp2_;
		_g_free0 (_tmp0_);
	}
	goto __finally0;
	__catch0_g_file_error:
	{
		GError* e = NULL;
		const gchar* _tmp3_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp3_ = e->message;
		g_error ("umockdev.vala:70: Cannot create temporary directory: %s", _tmp3_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return NULL;
	}
	_tmp4_ = self->priv->root_dir;
	_tmp5_ = g_build_filename (_tmp4_, "sys", NULL);
	_g_free0 (self->priv->sys_dir);
	self->priv->sys_dir = _tmp5_;
	_tmp6_ = self->priv->sys_dir;
	g_mkdir (_tmp6_, 0755);
	_tmp7_ = g_str_hash;
	_tmp8_ = g_str_equal;
	_tmp9_ = g_hash_table_new_full (_tmp7_, _tmp8_, _g_free0_, NULL);
	_g_hash_table_unref0 (self->priv->dev_fd);
	self->priv->dev_fd = _tmp9_;
	_tmp10_ = g_str_hash;
	_tmp11_ = g_str_equal;
	_tmp12_ = g_hash_table_new_full (_tmp10_, _tmp11_, _g_free0_, _umockdev_script_runner_unref0_);
	_g_hash_table_unref0 (self->priv->dev_script_runner);
	self->priv->dev_script_runner = _tmp12_;
	_tmp13_ = self->priv->root_dir;
	g_setenv ("UMOCKDEV_DIR", _tmp13_, TRUE);
	_tmp14_ = self->priv->root_dir;
	g_debug ("umockdev.vala:79: Created udev test bed %s", _tmp14_);
	return self;
}

UMockdevTestbed*
umockdev_testbed_new (void)
{
	return umockdev_testbed_construct (UMOCKDEV_TYPE_TESTBED);
}

/**
     * umockdev_testbed_get_root_dir:
     * @self: A #UMockdevTestbed.
     *
     * Get the root directory for the testbed. This is mostly useful for
     * setting up the "dev/" or "proc/" testbed directories in this root
     * directory. For getting the mocked "sys/" dir, use
     * #umockdev_testbed_get_sys_dir.
     *
     * Returns: The testbed's root directory.
     */
gchar*
umockdev_testbed_get_root_dir (UMockdevTestbed* self)
{
	const gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->root_dir;
	_tmp1_ = g_strdup (_tmp0_);
	result = _tmp1_;
	return result;
}

/**
     * umockdev_testbed_get_sys_dir:
     * @self: A #UMockdevTestbed.
     *
     * Get the sysfs directory for the testbed.
     *
     * Returns: The testbed's sysfs directory.
     */
gchar*
umockdev_testbed_get_sys_dir (UMockdevTestbed* self)
{
	const gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->sys_dir;
	_tmp1_ = g_strdup (_tmp0_);
	result = _tmp1_;
	return result;
}

/**
     * umockdev_testbed_set_attribute:
     * @self: A #UMockdevTestbed.
     * @devpath: The full device path, as returned by #umockdev_testbed_add_device()
     * @name: Attribute name
     * @value: Attribute string value
     *
     * Set a text sysfs attribute for a device.
     */
static guint8*
string_get_data (const gchar* self,
                 gint* result_length1)
{
	guint8* result;
	guint8* res = NULL;
	gint res_length1;
	gint _res_size_;
	gint _tmp0_;
	gint _tmp1_;
	guint8* _tmp2_;
	gint _tmp2__length1;
	g_return_val_if_fail (self != NULL, NULL);
	res = (guint8*) self;
	res_length1 = -1;
	_res_size_ = res_length1;
	_tmp0_ = strlen (self);
	_tmp1_ = _tmp0_;
	res_length1 = (gint) _tmp1_;
	_tmp2_ = res;
	_tmp2__length1 = res_length1;
	if (result_length1) {
		*result_length1 = _tmp2__length1;
	}
	result = _tmp2_;
	return result;
}

void
umockdev_testbed_set_attribute (UMockdevTestbed* self,
                                const gchar* devpath,
                                const gchar* name,
                                const gchar* value)
{
	guint8* _tmp0_;
	gint _tmp0__length1;
	guint8* _tmp1_;
	gint _tmp1__length1;
	g_return_if_fail (self != NULL);
	g_return_if_fail (devpath != NULL);
	g_return_if_fail (name != NULL);
	g_return_if_fail (value != NULL);
	_tmp0_ = string_get_data (value, &_tmp0__length1);
	_tmp1_ = _tmp0_;
	_tmp1__length1 = _tmp0__length1;
	umockdev_testbed_set_attribute_binary (self, devpath, name, _tmp1_, (gint) _tmp1__length1);
}

/**
     * umockdev_testbed_set_attribute_binary:
     * @self: A #UMockdevTestbed.
     * @devpath: The full device path, as returned by #umockdev_testbed_add_device()
     * @name: Attribute name (may contain leading directories like
     *        "queue/rotational")
     * @value: Attribute binary value
     * @value_length1: Length of @value in bytes.
     *
     * Set a binary sysfs attribute for a device.
     */
static gboolean
string_contains (const gchar* self,
                 const gchar* needle)
{
	gchar* _tmp0_;
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (needle != NULL, FALSE);
	_tmp0_ = strstr ((gchar*) self, (gchar*) needle);
	result = _tmp0_ != NULL;
	return result;
}

void
umockdev_testbed_set_attribute_binary (UMockdevTestbed* self,
                                       const gchar* devpath,
                                       const gchar* name,
                                       guint8* value,
                                       gint value_length1)
{
	gchar* attr_path = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (devpath != NULL);
	g_return_if_fail (name != NULL);
	_tmp0_ = self->priv->root_dir;
	_tmp1_ = g_build_filename (_tmp0_, devpath, name, NULL);
	attr_path = _tmp1_;
	if (string_contains (name, "/")) {
		gchar* d = NULL;
		const gchar* _tmp2_;
		gchar* _tmp3_;
		const gchar* _tmp4_;
		_tmp2_ = attr_path;
		_tmp3_ = g_path_get_dirname (_tmp2_);
		d = _tmp3_;
		_tmp4_ = d;
		if (g_mkdir_with_parents (_tmp4_, 0755) != 0) {
			const gchar* _tmp5_;
			const gchar* _tmp6_;
			_tmp5_ = d;
			_tmp6_ = g_strerror (errno);
			g_error ("umockdev.vala:165: cannot create attribute subdir '%s': %s", _tmp5_, _tmp6_);
		}
		_g_free0 (d);
	}
	{
		const gchar* _tmp7_;
		_tmp7_ = attr_path;
		g_file_set_contents (_tmp7_, (const char*) value, (size_t) value_length1, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == G_FILE_ERROR) {
				goto __catch1_g_file_error;
			}
			_g_free0 (attr_path);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
	goto __finally1;
	__catch1_g_file_error:
	{
		GError* e = NULL;
		const gchar* _tmp8_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp8_ = e->message;
		g_error ("umockdev.vala:171: Cannot write attribute file: %s", _tmp8_);
		_g_error_free0 (e);
	}
	__finally1:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_free0 (attr_path);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	_g_free0 (attr_path);
}

/**
     * umockdev_testbed_set_attribute_int:
     * @self: A #UMockdevTestbed.
     * @devpath: The full device path, as returned by #umockdev_testbed_add_device()
     * @name: Attribute name (may contain leading directories like
     *        "queue/rotational")
     * @value: Attribute integer value
     *
     * Set an integer sysfs attribute for a device.
     */
void
umockdev_testbed_set_attribute_int (UMockdevTestbed* self,
                                    const gchar* devpath,
                                    const gchar* name,
                                    gint value)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (devpath != NULL);
	g_return_if_fail (name != NULL);
	_tmp0_ = g_strdup_printf ("%i", value);
	_tmp1_ = _tmp0_;
	umockdev_testbed_set_attribute (self, devpath, name, _tmp1_);
	_g_free0 (_tmp1_);
}

/**
     * umockdev_testbed_set_attribute_hex:
     * @self: A #UMockdevTestbed.
     * @devpath: The full device path, as returned by #umockdev_testbed_add_device()
     * @name: Attribute name
     * @value: Attribute integer value
     *
     * Set an integer sysfs attribute for a device. Set an integer udev
     * property for a device. @value is interpreted as a hexadecimal number.
     * For example, for value==31 this sets the attribute contents to "1f".
     */
void
umockdev_testbed_set_attribute_hex (UMockdevTestbed* self,
                                    const gchar* devpath,
                                    const gchar* name,
                                    guint value)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (devpath != NULL);
	g_return_if_fail (name != NULL);
	_tmp0_ = g_strdup_printf ("%x", value);
	_tmp1_ = _tmp0_;
	umockdev_testbed_set_attribute (self, devpath, name, _tmp1_);
	_g_free0 (_tmp1_);
}

/**
     * umockdev_testbed_set_attribute_link:
     * @self: A #UMockdevTestbed.
     * @devpath: The full device path, as returned by #umockdev_testbed_add_device()
     * @name: Attribute name
     * @value: Attribute link target value
     *
     * Set a symlink sysfs attribute for a device; this is primarily important
     * for setting "driver" links.
     */
void
umockdev_testbed_set_attribute_link (UMockdevTestbed* self,
                                     const gchar* devpath,
                                     const gchar* name,
                                     const gchar* value)
{
	gchar* path = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* dir = NULL;
	gchar* _tmp2_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (devpath != NULL);
	g_return_if_fail (name != NULL);
	g_return_if_fail (value != NULL);
	_tmp0_ = self->priv->root_dir;
	_tmp1_ = g_build_filename (_tmp0_, devpath, name, NULL);
	path = _tmp1_;
	_tmp2_ = g_path_get_dirname (path);
	dir = _tmp2_;
	if (g_mkdir_with_parents (dir, 0755) != 0) {
		const gchar* _tmp3_;
		_tmp3_ = g_strerror (errno);
		g_error ("umockdev.vala:221: cannot create attribute dir '%s': %s", dir, _tmp3_);
	}
	if (symlink (value, path) < 0) {
		const gchar* _tmp4_;
		_tmp4_ = g_strerror (errno);
		g_error ("umockdev.vala:223: Cannot create symlink %s: %s", path, _tmp4_);
	}
	_g_free0 (dir);
	_g_free0 (path);
}

/**
     * umockdev_testbed_get_property:
     * @self: A #UMockdevTestbed.
     * @devpath: The full device path, as returned by #umockdev_testbed_add_device()
     * @name: Property name
     *
     * Get a string udev property for a device. Note that this is mostly for
     * testing umockdev itself; for real application testing, use
     * libudev/gudev.
     *
     * Returns: property value, or %NULL if it does not exist
     */
static glong
string_strnlen (gchar* str,
                glong maxlen)
{
	gchar* end = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	glong result = 0L;
	_tmp0_ = memchr (str, 0, (gsize) maxlen);
	end = _tmp0_;
	_tmp1_ = end;
	if (_tmp1_ == NULL) {
		result = maxlen;
		return result;
	} else {
		gchar* _tmp2_;
		_tmp2_ = end;
		result = (glong) (_tmp2_ - str);
		return result;
	}
}

static gchar*
string_substring (const gchar* self,
                  glong offset,
                  glong len)
{
	glong string_length = 0L;
	gboolean _tmp0_ = FALSE;
	gchar* _tmp3_;
	gchar* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	if (offset >= ((glong) 0)) {
		_tmp0_ = len >= ((glong) 0);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		string_length = string_strnlen ((gchar*) self, offset + len);
	} else {
		gint _tmp1_;
		gint _tmp2_;
		_tmp1_ = strlen (self);
		_tmp2_ = _tmp1_;
		string_length = (glong) _tmp2_;
	}
	if (offset < ((glong) 0)) {
		offset = string_length + offset;
		g_return_val_if_fail (offset >= ((glong) 0), NULL);
	} else {
		g_return_val_if_fail (offset <= string_length, NULL);
	}
	if (len < ((glong) 0)) {
		len = string_length - offset;
	}
	g_return_val_if_fail ((offset + len) <= string_length, NULL);
	_tmp3_ = g_strndup (((gchar*) self) + offset, (gsize) len);
	result = _tmp3_;
	return result;
}

gchar*
umockdev_testbed_get_property (UMockdevTestbed* self,
                               const gchar* devpath,
                               const gchar* name)
{
	gchar* uevent_path = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* ret = NULL;
	GFile* f = NULL;
	const gchar* _tmp2_;
	GFile* _tmp3_;
	gchar* prefix = NULL;
	gchar* _tmp4_;
	GError* _inner_error0_ = NULL;
	gchar* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (devpath != NULL, NULL);
	g_return_val_if_fail (name != NULL, NULL);
	_tmp0_ = self->priv->root_dir;
	_tmp1_ = g_build_filename (_tmp0_, devpath, "uevent", NULL);
	uevent_path = _tmp1_;
	ret = NULL;
	_tmp2_ = uevent_path;
	_tmp3_ = g_file_new_for_path (_tmp2_);
	f = _tmp3_;
	_tmp4_ = g_strconcat (name, "=", NULL);
	prefix = _tmp4_;
	{
		GFileInputStream* _tmp5_ = NULL;
		GFile* _tmp6_;
		GFileInputStream* _tmp7_;
		GDataInputStream* inp = NULL;
		GDataInputStream* _tmp8_;
		gchar* line = NULL;
		gsize len = 0UL;
		GDataInputStream* _tmp22_;
		_tmp6_ = f;
		_tmp7_ = g_file_read (_tmp6_, NULL, &_inner_error0_);
		_tmp5_ = _tmp7_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch2_g_error;
		}
		_tmp8_ = g_data_input_stream_new ((GInputStream*) _tmp5_);
		inp = _tmp8_;
		while (TRUE) {
			gchar* _tmp9_ = NULL;
			GDataInputStream* _tmp10_;
			gsize _tmp11_ = 0UL;
			gchar* _tmp12_;
			gchar* _tmp13_;
			const gchar* _tmp14_;
			const gchar* _tmp15_;
			const gchar* _tmp16_;
			_tmp10_ = inp;
			_tmp12_ = g_data_input_stream_read_line (_tmp10_, &_tmp11_, NULL, &_inner_error0_);
			len = _tmp11_;
			_tmp9_ = _tmp12_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				_g_free0 (line);
				_g_object_unref0 (inp);
				_g_object_unref0 (_tmp5_);
				goto __catch2_g_error;
			}
			_tmp13_ = _tmp9_;
			_tmp9_ = NULL;
			_g_free0 (line);
			line = _tmp13_;
			_tmp14_ = line;
			if (!(_tmp14_ != NULL)) {
				_g_free0 (_tmp9_);
				break;
			}
			_tmp15_ = line;
			_tmp16_ = prefix;
			if (g_str_has_prefix (_tmp15_, _tmp16_)) {
				const gchar* _tmp17_;
				const gchar* _tmp18_;
				gint _tmp19_;
				gint _tmp20_;
				gchar* _tmp21_;
				_tmp17_ = line;
				_tmp18_ = prefix;
				_tmp19_ = strlen (_tmp18_);
				_tmp20_ = _tmp19_;
				_tmp21_ = string_substring (_tmp17_, (glong) _tmp20_, (glong) -1);
				_g_free0 (ret);
				ret = _tmp21_;
				_g_free0 (_tmp9_);
				break;
			}
			_g_free0 (_tmp9_);
		}
		_tmp22_ = inp;
		g_input_stream_close ((GInputStream*) _tmp22_, NULL, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_free0 (line);
			_g_object_unref0 (inp);
			_g_object_unref0 (_tmp5_);
			goto __catch2_g_error;
		}
		_g_free0 (line);
		_g_object_unref0 (inp);
		_g_object_unref0 (_tmp5_);
	}
	goto __finally2;
	__catch2_g_error:
	{
		GError* e = NULL;
		const gchar* _tmp23_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp23_ = e->message;
		g_error ("umockdev.vala:258: Cannot read uevent file: %s", _tmp23_);
		_g_error_free0 (e);
	}
	__finally2:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_free0 (prefix);
		_g_object_unref0 (f);
		_g_free0 (ret);
		_g_free0 (uevent_path);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return NULL;
	}
	result = ret;
	_g_free0 (prefix);
	_g_object_unref0 (f);
	_g_free0 (uevent_path);
	return result;
}

/**
     * umockdev_testbed_set_property:
     * @self: A #UMockdevTestbed.
     * @devpath: The full device path, as returned by #umockdev_testbed_add_device()
     * @name: Property name
     * @value: Property string value
     *
     * Set a string udev property for a device.
     */
void
umockdev_testbed_set_property (UMockdevTestbed* self,
                               const gchar* devpath,
                               const gchar* name,
                               const gchar* value)
{
	gchar* uevent_path = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* props = NULL;
	gchar* _tmp2_;
	gchar* real_value = NULL;
	gboolean _tmp3_ = FALSE;
	GFile* f = NULL;
	const gchar* _tmp6_;
	GFile* _tmp7_;
	gboolean existing = FALSE;
	gchar* prefix = NULL;
	gchar* _tmp8_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (devpath != NULL);
	g_return_if_fail (name != NULL);
	g_return_if_fail (value != NULL);
	_tmp0_ = self->priv->root_dir;
	_tmp1_ = g_build_filename (_tmp0_, devpath, "uevent", NULL);
	uevent_path = _tmp1_;
	_tmp2_ = g_strdup ("");
	props = _tmp2_;
	if (g_strcmp0 (name, "DEVNAME") == 0) {
		_tmp3_ = g_str_has_prefix (value, "/dev/");
	} else {
		_tmp3_ = FALSE;
	}
	if (_tmp3_) {
		gchar* _tmp4_;
		_tmp4_ = string_substring (value, (glong) 5, (glong) -1);
		_g_free0 (real_value);
		real_value = _tmp4_;
	} else {
		gchar* _tmp5_;
		_tmp5_ = g_strdup (value);
		_g_free0 (real_value);
		real_value = _tmp5_;
	}
	_tmp6_ = uevent_path;
	_tmp7_ = g_file_new_for_path (_tmp6_);
	f = _tmp7_;
	existing = FALSE;
	_tmp8_ = g_strconcat (name, "=", NULL);
	prefix = _tmp8_;
	{
		GFileInputStream* _tmp9_ = NULL;
		GFile* _tmp10_;
		GFileInputStream* _tmp11_;
		GDataInputStream* inp = NULL;
		GDataInputStream* _tmp12_;
		gchar* line = NULL;
		gsize len = 0UL;
		GDataInputStream* _tmp34_;
		const gchar* _tmp43_;
		const gchar* _tmp44_;
		guint8* _tmp45_;
		gint _tmp45__length1;
		guint8* _tmp46_;
		gint _tmp46__length1;
		_tmp10_ = f;
		_tmp11_ = g_file_read (_tmp10_, NULL, &_inner_error0_);
		_tmp9_ = _tmp11_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch3_g_error;
		}
		_tmp12_ = g_data_input_stream_new ((GInputStream*) _tmp9_);
		inp = _tmp12_;
		while (TRUE) {
			gchar* _tmp13_ = NULL;
			GDataInputStream* _tmp14_;
			gsize _tmp15_ = 0UL;
			gchar* _tmp16_;
			gchar* _tmp17_;
			const gchar* _tmp18_;
			const gchar* _tmp19_;
			const gchar* _tmp20_;
			_tmp14_ = inp;
			_tmp16_ = g_data_input_stream_read_line (_tmp14_, &_tmp15_, NULL, &_inner_error0_);
			len = _tmp15_;
			_tmp13_ = _tmp16_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				_g_free0 (line);
				_g_object_unref0 (inp);
				_g_object_unref0 (_tmp9_);
				goto __catch3_g_error;
			}
			_tmp17_ = _tmp13_;
			_tmp13_ = NULL;
			_g_free0 (line);
			line = _tmp17_;
			_tmp18_ = line;
			if (!(_tmp18_ != NULL)) {
				_g_free0 (_tmp13_);
				break;
			}
			_tmp19_ = line;
			_tmp20_ = prefix;
			if (g_str_has_prefix (_tmp19_, _tmp20_)) {
				const gchar* _tmp21_;
				const gchar* _tmp22_;
				const gchar* _tmp23_;
				gchar* _tmp24_;
				gchar* _tmp25_;
				gchar* _tmp26_;
				gchar* _tmp27_;
				gchar* _tmp28_;
				existing = TRUE;
				_tmp21_ = props;
				_tmp22_ = prefix;
				_tmp23_ = real_value;
				_tmp24_ = g_strconcat (_tmp22_, _tmp23_, NULL);
				_tmp25_ = _tmp24_;
				_tmp26_ = g_strconcat (_tmp25_, "\n", NULL);
				_tmp27_ = _tmp26_;
				_tmp28_ = g_strconcat (_tmp21_, _tmp27_, NULL);
				_g_free0 (props);
				props = _tmp28_;
				_g_free0 (_tmp27_);
				_g_free0 (_tmp25_);
			} else {
				const gchar* _tmp29_;
				const gchar* _tmp30_;
				gchar* _tmp31_;
				gchar* _tmp32_;
				gchar* _tmp33_;
				_tmp29_ = props;
				_tmp30_ = line;
				_tmp31_ = g_strconcat (_tmp30_, "\n", NULL);
				_tmp32_ = _tmp31_;
				_tmp33_ = g_strconcat (_tmp29_, _tmp32_, NULL);
				_g_free0 (props);
				props = _tmp33_;
				_g_free0 (_tmp32_);
			}
			_g_free0 (_tmp13_);
		}
		_tmp34_ = inp;
		g_input_stream_close ((GInputStream*) _tmp34_, NULL, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_free0 (line);
			_g_object_unref0 (inp);
			_g_object_unref0 (_tmp9_);
			goto __catch3_g_error;
		}
		if (!existing) {
			const gchar* _tmp35_;
			const gchar* _tmp36_;
			const gchar* _tmp37_;
			gchar* _tmp38_;
			gchar* _tmp39_;
			gchar* _tmp40_;
			gchar* _tmp41_;
			gchar* _tmp42_;
			_tmp35_ = props;
			_tmp36_ = prefix;
			_tmp37_ = real_value;
			_tmp38_ = g_strconcat (_tmp36_, _tmp37_, NULL);
			_tmp39_ = _tmp38_;
			_tmp40_ = g_strconcat (_tmp39_, "\n", NULL);
			_tmp41_ = _tmp40_;
			_tmp42_ = g_strconcat (_tmp35_, _tmp41_, NULL);
			_g_free0 (props);
			props = _tmp42_;
			_g_free0 (_tmp41_);
			_g_free0 (_tmp39_);
		}
		_tmp43_ = uevent_path;
		_tmp44_ = props;
		_tmp45_ = string_get_data (_tmp44_, &_tmp45__length1);
		_tmp46_ = _tmp45_;
		_tmp46__length1 = _tmp45__length1;
		g_file_set_contents (_tmp43_, (const char*) _tmp46_, (size_t) _tmp46__length1, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_free0 (line);
			_g_object_unref0 (inp);
			_g_object_unref0 (_tmp9_);
			goto __catch3_g_error;
		}
		_g_free0 (line);
		_g_object_unref0 (inp);
		_g_object_unref0 (_tmp9_);
	}
	goto __finally3;
	__catch3_g_error:
	{
		GError* e = NULL;
		const gchar* _tmp47_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp47_ = e->message;
		g_error ("umockdev.vala:311: Cannot update uevent file: %s", _tmp47_);
		_g_error_free0 (e);
	}
	__finally3:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_free0 (prefix);
		_g_object_unref0 (f);
		_g_free0 (real_value);
		_g_free0 (props);
		_g_free0 (uevent_path);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	_g_free0 (prefix);
	_g_object_unref0 (f);
	_g_free0 (real_value);
	_g_free0 (props);
	_g_free0 (uevent_path);
}

/**
     * umockdev_testbed_set_property_int:
     * @self: A #UMockdevTestbed.
     * @devpath: The full device path, as returned by #umockdev_testbed_add_device()
     * @name: Property name
     * @value: Property integer value
     *
     * Set an integer udev property for a device.
     */
void
umockdev_testbed_set_property_int (UMockdevTestbed* self,
                                   const gchar* devpath,
                                   const gchar* name,
                                   gint value)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (devpath != NULL);
	g_return_if_fail (name != NULL);
	_tmp0_ = g_strdup_printf ("%i", value);
	_tmp1_ = _tmp0_;
	umockdev_testbed_set_property (self, devpath, name, _tmp1_);
	_g_free0 (_tmp1_);
}

/**
     * umockdev_testbed_set_property_hex:
     * @self: A #UMockdevTestbed.
     * @devpath: The full device path, as returned by #umockdev_testbed_add_device()
     * @name: Property name
     * @value: Property integer value
     *
     * Set an integer udev property for a device. @value is interpreted as a
     * hexadecimal number. For example, for value==31 this sets the property's
     * value to "1f".
     */
void
umockdev_testbed_set_property_hex (UMockdevTestbed* self,
                                   const gchar* devpath,
                                   const gchar* name,
                                   guint value)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (devpath != NULL);
	g_return_if_fail (name != NULL);
	_tmp0_ = g_strdup_printf ("%x", value);
	_tmp1_ = _tmp0_;
	umockdev_testbed_set_property (self, devpath, name, _tmp1_);
	_g_free0 (_tmp1_);
}

/**
     * umockdev_testbed_add_devicev:
     * @self: A #UMockdevTestbed.
     * @subsystem: The subsystem name, e. g. "usb"
     * @name: The device name; arbitrary, but needs to be unique within the testbed
     * @parent: (allow-none): device path of the parent device. Use %NULL for a
     *          top-level device.
     * @attributes: (array zero-terminated=1):
     *              A list of device sysfs attributes, alternating names and
     *              values, terminated with %NULL:
     *              { "key1", "value1", "key2", "value2", ..., NULL }
     * @properties: (array zero-terminated=1):
     *              A list of device udev properties; same format as @attributes
     *
     * This method is mostly meant for language bindings (where it is named
     * umockdev_testbed_add_device()). For C programs it is usually more convenient to
     * use umockdev_testbed_add_device().
     *
     * Add a new device to the testbed. A Linux kernel device always has a
     * subsystem (such as "usb" or "pci"), and a device name. The test bed only
     * builds a very simple sysfs structure without nested namespaces, so it
     * requires device names to be unique. Some gudev client programs might make
     * assumptions about the name (e. g. a SCSI disk block device should be called
     * sdaN). A device also has an arbitrary number of sysfs attributes and udev
     * properties; usually you should specify them upon creation, but it is also
     * possible to change them later on with umockdev_testbed_set_attribute() and
     * umockdev_testbed_set_property().
     *
     * Returns: The sysfs path for the newly created device. Free with g_free().
     *
     * Rename to: umockdev_testbed_add_device
     */
static gint
string_index_of (const gchar* self,
                 const gchar* needle,
                 gint start_index)
{
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gint result = 0;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (needle != NULL, 0);
	_tmp0_ = strstr (((gchar*) self) + start_index, (gchar*) needle);
	_result_ = _tmp0_;
	_tmp1_ = _result_;
	if (_tmp1_ != NULL) {
		gchar* _tmp2_;
		_tmp2_ = _result_;
		result = (gint) (_tmp2_ - ((gchar*) self));
		return result;
	} else {
		result = -1;
		return result;
	}
}

static gchar*
string_replace (const gchar* self,
                const gchar* old,
                const gchar* replacement)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	GError* _inner_error0_ = NULL;
	gchar* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (old != NULL, NULL);
	g_return_val_if_fail (replacement != NULL, NULL);
	if ((*((gchar*) self)) == '\0') {
		_tmp1_ = TRUE;
	} else {
		_tmp1_ = (*((gchar*) old)) == '\0';
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = g_strcmp0 (old, replacement) == 0;
	}
	if (_tmp0_) {
		gchar* _tmp2_;
		_tmp2_ = g_strdup (self);
		result = _tmp2_;
		return result;
	}
	{
		GRegex* regex = NULL;
		gchar* _tmp3_;
		gchar* _tmp4_;
		GRegex* _tmp5_;
		GRegex* _tmp6_;
		gchar* _tmp7_ = NULL;
		GRegex* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
		_tmp3_ = g_regex_escape_string (old, -1);
		_tmp4_ = _tmp3_;
		_tmp5_ = g_regex_new (_tmp4_, 0, 0, &_inner_error0_);
		_tmp6_ = _tmp5_;
		_g_free0 (_tmp4_);
		regex = _tmp6_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch4_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp8_ = regex;
		_tmp9_ = g_regex_replace_literal (_tmp8_, self, (gssize) -1, 0, replacement, 0, &_inner_error0_);
		_tmp7_ = _tmp9_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_regex_unref0 (regex);
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch4_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp10_ = _tmp7_;
		_tmp7_ = NULL;
		result = _tmp10_;
		_g_free0 (_tmp7_);
		_g_regex_unref0 (regex);
		return result;
	}
	goto __finally4;
	__catch4_g_regex_error:
	{
		GError* e = NULL;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		g_assert_not_reached ();
		_g_error_free0 (e);
	}
	__finally4:
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
	g_clear_error (&_inner_error0_);
	return NULL;
}

gchar*
umockdev_testbed_add_devicev (UMockdevTestbed* self,
                              const gchar* subsystem,
                              const gchar* name,
                              const gchar* parent,
                              gchar** attributes,
                              gchar** properties)
{
	gchar* dev_path = NULL;
	gchar* dev_node = NULL;
	gchar* dev_dir = NULL;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	gchar* _tmp4_;
	gboolean _tmp5_ = FALSE;
	const gchar* _tmp6_;
	gchar* dev_path_no_sys = NULL;
	const gchar* _tmp11_;
	const gchar* _tmp12_;
	gchar* _tmp13_;
	const gchar* _tmp14_;
	gchar* props = NULL;
	gchar* _tmp70_;
	const gchar* _tmp95_;
	const gchar* _tmp96_;
	gchar* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (subsystem != NULL, NULL);
	g_return_val_if_fail (name != NULL, NULL);
	dev_node = NULL;
	if (parent != NULL) {
		gchar* _tmp0_;
		if (!g_str_has_prefix (parent, "/sys/")) {
			g_critical ("umockdev.vala:386: add_devicev(): parent device %s does not start with" \
" /sys/", parent);
			result = NULL;
			_g_free0 (dev_node);
			_g_free0 (dev_path);
			return result;
		}
		if (!g_file_test (parent, G_FILE_TEST_IS_DIR)) {
			g_critical ("umockdev.vala:390: add_devicev(): parent device %s does not exist", parent);
			result = NULL;
			_g_free0 (dev_node);
			_g_free0 (dev_path);
			return result;
		}
		_tmp0_ = g_build_filename (parent, name, NULL);
		_g_free0 (dev_path);
		dev_path = _tmp0_;
	} else {
		gchar* _tmp1_;
		_tmp1_ = g_build_filename ("/sys/devices", name, NULL);
		_g_free0 (dev_path);
		dev_path = _tmp1_;
	}
	_tmp2_ = self->priv->root_dir;
	_tmp3_ = dev_path;
	_tmp4_ = g_build_filename (_tmp2_, _tmp3_, NULL);
	dev_dir = _tmp4_;
	_tmp6_ = dev_dir;
	if (g_file_test (_tmp6_, G_FILE_TEST_EXISTS)) {
		const gchar* _tmp7_;
		gchar* _tmp8_;
		gchar* _tmp9_;
		_tmp7_ = dev_dir;
		_tmp8_ = g_build_filename (_tmp7_, "uevent", NULL);
		_tmp9_ = _tmp8_;
		_tmp5_ = g_file_test (_tmp9_, G_FILE_TEST_EXISTS);
		_g_free0 (_tmp9_);
	} else {
		_tmp5_ = FALSE;
	}
	if (_tmp5_) {
		const gchar* _tmp10_;
		_tmp10_ = dev_dir;
		g_error ("umockdev.vala:401: device %s already exists", _tmp10_);
	}
	_tmp11_ = dev_path;
	_tmp12_ = dev_path;
	_tmp13_ = string_substring (_tmp11_, (glong) string_index_of (_tmp12_, "/devices/", 0), (glong) -1);
	dev_path_no_sys = _tmp13_;
	_tmp14_ = dev_dir;
	if (g_mkdir_with_parents (_tmp14_, 0755) != 0) {
		const gchar* _tmp15_;
		const gchar* _tmp16_;
		_tmp15_ = dev_dir;
		_tmp16_ = g_strerror (errno);
		g_error ("umockdev.vala:407: cannot create dev dir '%s': %s", _tmp15_, _tmp16_);
	}
	if (!umockdev_testbed_subsystem_is_bus (subsystem)) {
		gchar* class_dir = NULL;
		const gchar* _tmp17_;
		gchar* _tmp18_;
		const gchar* _tmp19_;
		const gchar* _tmp22_;
		gchar* _tmp23_;
		gchar* _tmp24_;
		gchar* _tmp25_;
		gchar* _tmp26_;
		const gchar* _tmp27_;
		gchar* _tmp28_;
		gchar* _tmp29_;
		const gchar* _tmp30_;
		gchar* _tmp31_;
		gchar* _tmp32_;
		const gchar* _tmp33_;
		gchar* _tmp34_;
		gchar* _tmp35_;
		gchar* _tmp36_;
		gchar* _tmp37_;
		_tmp17_ = self->priv->sys_dir;
		_tmp18_ = g_build_filename (_tmp17_, "class", subsystem, NULL);
		class_dir = _tmp18_;
		_tmp19_ = class_dir;
		if (g_mkdir_with_parents (_tmp19_, 0755) != 0) {
			const gchar* _tmp20_;
			const gchar* _tmp21_;
			_tmp20_ = class_dir;
			_tmp21_ = g_strerror (errno);
			g_error ("umockdev.vala:412: cannot create class dir '%s': %s", _tmp20_, _tmp21_);
		}
		_tmp22_ = dev_path;
		_tmp23_ = umockdev_make_dotdots (_tmp22_);
		_tmp24_ = _tmp23_;
		_tmp25_ = g_build_filename (_tmp24_, "class", subsystem, NULL);
		_tmp26_ = _tmp25_;
		_tmp27_ = dev_dir;
		_tmp28_ = g_build_filename (_tmp27_, "subsystem", NULL);
		_tmp29_ = _tmp28_;
		_vala_assert (symlink (_tmp26_, _tmp29_) == 0, "FileUtils.symlink(Path.build_filename(make_dotdots(dev_path), \"class\", subsystem),                                      Path.build_filename(dev_dir, \"subsystem\")) == 0");
		_g_free0 (_tmp29_);
		_g_free0 (_tmp26_);
		_g_free0 (_tmp24_);
		_tmp30_ = dev_path_no_sys;
		_tmp31_ = g_build_filename ("..", "..", _tmp30_, NULL);
		_tmp32_ = _tmp31_;
		_tmp33_ = class_dir;
		_tmp34_ = g_path_get_basename (name);
		_tmp35_ = _tmp34_;
		_tmp36_ = g_build_filename (_tmp33_, _tmp35_, NULL);
		_tmp37_ = _tmp36_;
		_vala_assert (symlink (_tmp32_, _tmp37_) == 0, "FileUtils.symlink(Path.build_filename(\"..\", \"..\", dev_path_no_sys),                                      Path.build_filename(class_dir, Path.get_basename(name))) == 0");
		_g_free0 (_tmp37_);
		_g_free0 (_tmp35_);
		_g_free0 (_tmp32_);
		_g_free0 (class_dir);
	} else {
		gchar* bus_dir = NULL;
		const gchar* _tmp38_;
		gchar* _tmp39_;
		const gchar* _tmp40_;
		const gchar* _tmp41_;
		gchar* _tmp42_;
		gchar* _tmp43_;
		const gchar* _tmp44_;
		gchar* _tmp45_;
		gchar* _tmp46_;
		gchar* _tmp47_;
		gchar* _tmp48_;
		const gchar* _tmp49_;
		gchar* _tmp50_;
		gchar* _tmp51_;
		gchar* _tmp52_;
		gchar* _tmp53_;
		const gchar* _tmp54_;
		gchar* _tmp55_;
		gchar* _tmp56_;
		_tmp38_ = self->priv->sys_dir;
		_tmp39_ = g_build_filename (_tmp38_, "bus", subsystem, "devices", NULL);
		bus_dir = _tmp39_;
		_tmp40_ = bus_dir;
		_vala_assert (g_mkdir_with_parents (_tmp40_, 0755) == 0, "DirUtils.create_with_parents(bus_dir, 0755) == 0");
		_tmp41_ = dev_path_no_sys;
		_tmp42_ = g_build_filename ("..", "..", "..", _tmp41_, NULL);
		_tmp43_ = _tmp42_;
		_tmp44_ = bus_dir;
		_tmp45_ = g_path_get_basename (name);
		_tmp46_ = _tmp45_;
		_tmp47_ = g_build_filename (_tmp44_, _tmp46_, NULL);
		_tmp48_ = _tmp47_;
		_vala_assert (symlink (_tmp43_, _tmp48_) == 0, "FileUtils.symlink(Path.build_filename(\"..\", \"..\", \"..\", dev_path_no_sys),                                      Path.build_filename(bus_dir, Path.get_basename(name))) == 0");
		_g_free0 (_tmp48_);
		_g_free0 (_tmp46_);
		_g_free0 (_tmp43_);
		_tmp49_ = dev_path;
		_tmp50_ = umockdev_make_dotdots (_tmp49_);
		_tmp51_ = _tmp50_;
		_tmp52_ = g_build_filename (_tmp51_, "bus", subsystem, NULL);
		_tmp53_ = _tmp52_;
		_tmp54_ = dev_dir;
		_tmp55_ = g_build_filename (_tmp54_, "subsystem", NULL);
		_tmp56_ = _tmp55_;
		_vala_assert (symlink (_tmp53_, _tmp56_) == 0, "FileUtils.symlink(Path.build_filename(make_dotdots(dev_path), \"bus\", subsystem),                                      Path.build_filename(dev_dir, \"subsystem\")) == 0");
		_g_free0 (_tmp56_);
		_g_free0 (_tmp53_);
		_g_free0 (_tmp51_);
		_g_free0 (bus_dir);
	}
	if (g_strcmp0 (subsystem, "block") == 0) {
		gchar* block_dir = NULL;
		const gchar* _tmp57_;
		gchar* _tmp58_;
		const gchar* _tmp59_;
		const gchar* _tmp62_;
		gchar* _tmp63_;
		gchar* _tmp64_;
		const gchar* _tmp65_;
		gchar* _tmp66_;
		gchar* _tmp67_;
		gchar* _tmp68_;
		gchar* _tmp69_;
		_tmp57_ = self->priv->sys_dir;
		_tmp58_ = g_build_filename (_tmp57_, "block", NULL);
		block_dir = _tmp58_;
		_tmp59_ = block_dir;
		if (g_mkdir_with_parents (_tmp59_, 0755) != 0) {
			const gchar* _tmp60_;
			const gchar* _tmp61_;
			_tmp60_ = block_dir;
			_tmp61_ = g_strerror (errno);
			g_error ("umockdev.vala:439: cannot create block dir '%s': %s", _tmp60_, _tmp61_);
		}
		_tmp62_ = dev_path_no_sys;
		_tmp63_ = g_build_filename ("..", _tmp62_, NULL);
		_tmp64_ = _tmp63_;
		_tmp65_ = block_dir;
		_tmp66_ = g_path_get_basename (name);
		_tmp67_ = _tmp66_;
		_tmp68_ = g_build_filename (_tmp65_, _tmp67_, NULL);
		_tmp69_ = _tmp68_;
		_vala_assert (symlink (_tmp64_, _tmp69_) == 0, "FileUtils.symlink(Path.build_filename(\"..\", dev_path_no_sys),                                      Path.build_filename(block_dir, Path.get_basename(name))) == 0");
		_g_free0 (_tmp69_);
		_g_free0 (_tmp67_);
		_g_free0 (_tmp64_);
		_g_free0 (block_dir);
	}
	_tmp70_ = g_strdup ("");
	props = _tmp70_;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp71_ = FALSE;
			_tmp71_ = TRUE;
			while (TRUE) {
				gboolean _tmp72_ = FALSE;
				const gchar* _tmp73_;
				if (!_tmp71_) {
					i = i + 2;
				}
				_tmp71_ = FALSE;
				if (!(i < (_vala_array_length (properties) - 1))) {
					break;
				}
				_tmp73_ = properties[i];
				if (g_strcmp0 (_tmp73_, "DEVNAME") == 0) {
					const gchar* _tmp74_;
					_tmp74_ = properties[i + 1];
					_tmp72_ = g_str_has_prefix (_tmp74_, "/dev/");
				} else {
					_tmp72_ = FALSE;
				}
				if (_tmp72_) {
					const gchar* _tmp75_;
					gchar* _tmp76_;
					const gchar* _tmp77_;
					const gchar* _tmp78_;
					gchar* _tmp79_;
					gchar* _tmp80_;
					gchar* _tmp81_;
					gchar* _tmp82_;
					gchar* _tmp83_;
					_tmp75_ = properties[i + 1];
					_tmp76_ = string_substring (_tmp75_, (glong) 5, (glong) -1);
					_g_free0 (dev_node);
					dev_node = _tmp76_;
					_tmp77_ = props;
					_tmp78_ = dev_node;
					_tmp79_ = g_strconcat ("DEVNAME=", _tmp78_, NULL);
					_tmp80_ = _tmp79_;
					_tmp81_ = g_strconcat (_tmp80_, "\n", NULL);
					_tmp82_ = _tmp81_;
					_tmp83_ = g_strconcat (_tmp77_, _tmp82_, NULL);
					_g_free0 (props);
					props = _tmp83_;
					_g_free0 (_tmp82_);
					_g_free0 (_tmp80_);
				} else {
					const gchar* _tmp84_;
					const gchar* _tmp85_;
					gchar* _tmp86_;
					gchar* _tmp87_;
					const gchar* _tmp88_;
					gchar* _tmp89_;
					gchar* _tmp90_;
					gchar* _tmp91_;
					gchar* _tmp92_;
					gchar* _tmp93_;
					_tmp84_ = props;
					_tmp85_ = properties[i];
					_tmp86_ = g_strconcat (_tmp85_, "=", NULL);
					_tmp87_ = _tmp86_;
					_tmp88_ = properties[i + 1];
					_tmp89_ = g_strconcat (_tmp87_, _tmp88_, NULL);
					_tmp90_ = _tmp89_;
					_tmp91_ = g_strconcat (_tmp90_, "\n", NULL);
					_tmp92_ = _tmp91_;
					_tmp93_ = g_strconcat (_tmp84_, _tmp92_, NULL);
					_g_free0 (props);
					props = _tmp93_;
					_g_free0 (_tmp92_);
					_g_free0 (_tmp90_);
					_g_free0 (_tmp87_);
				}
			}
		}
	}
	if ((_vala_array_length (properties) % 2) != 0) {
		const gchar* _tmp94_;
		_tmp94_ = properties[_vala_array_length (properties) - 1];
		g_warning ("umockdev.vala:455: add_devicev: Ignoring property key '%s' without val" \
"ue", _tmp94_);
	}
	_tmp95_ = dev_path;
	_tmp96_ = props;
	umockdev_testbed_set_attribute (self, _tmp95_, "uevent", _tmp96_);
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp97_ = FALSE;
			_tmp97_ = TRUE;
			while (TRUE) {
				const gchar* _tmp98_;
				const gchar* _tmp99_;
				const gchar* _tmp100_;
				gboolean _tmp101_ = FALSE;
				const gchar* _tmp102_;
				if (!_tmp97_) {
					i = i + 2;
				}
				_tmp97_ = FALSE;
				if (!(i < (_vala_array_length (attributes) - 1))) {
					break;
				}
				_tmp98_ = dev_path;
				_tmp99_ = attributes[i];
				_tmp100_ = attributes[i + 1];
				umockdev_testbed_set_attribute (self, _tmp98_, _tmp99_, _tmp100_);
				_tmp102_ = attributes[i];
				if (g_strcmp0 (_tmp102_, "dev") == 0) {
					const gchar* _tmp103_;
					_tmp103_ = dev_node;
					_tmp101_ = _tmp103_ != NULL;
				} else {
					_tmp101_ = FALSE;
				}
				if (_tmp101_) {
					gchar* infodir = NULL;
					const gchar* _tmp104_;
					gchar* _tmp105_;
					const gchar* _tmp106_;
					const gchar* _tmp107_;
					const gchar* _tmp108_;
					const gchar* _tmp109_;
					gchar* _tmp110_;
					gchar* _tmp111_;
					gchar* _tmp112_;
					gchar* _tmp113_;
					const gchar* _tmp114_ = NULL;
					const gchar* _tmp115_;
					gchar* sysdev_dir = NULL;
					const gchar* _tmp116_;
					gchar* _tmp117_;
					const gchar* _tmp118_;
					gchar* dest = NULL;
					const gchar* _tmp121_;
					const gchar* _tmp122_;
					gchar* _tmp123_;
					const gchar* _tmp124_;
					_tmp104_ = self->priv->root_dir;
					_tmp105_ = g_build_filename (_tmp104_, "dev", ".node", NULL);
					infodir = _tmp105_;
					_tmp106_ = infodir;
					g_mkdir_with_parents (_tmp106_, 0755);
					_tmp107_ = attributes[i + 1];
					_tmp108_ = infodir;
					_tmp109_ = dev_node;
					_tmp110_ = string_replace (_tmp109_, "/", "_");
					_tmp111_ = _tmp110_;
					_tmp112_ = g_build_filename (_tmp108_, _tmp111_, NULL);
					_tmp113_ = _tmp112_;
					_vala_assert (symlink (_tmp107_, _tmp113_) == 0, "FileUtils.symlink(attributes[i+1],                                          Path.build_filename(infodir, dev_node.replace(\"/\", \"_\"))) == 0");
					_g_free0 (_tmp113_);
					_g_free0 (_tmp111_);
					_tmp115_ = dev_path;
					if (string_contains (_tmp115_, "/block/")) {
						_tmp114_ = "block";
					} else {
						_tmp114_ = "char";
					}
					_tmp116_ = self->priv->sys_dir;
					_tmp117_ = g_build_filename (_tmp116_, "dev", _tmp114_, NULL);
					sysdev_dir = _tmp117_;
					_tmp118_ = sysdev_dir;
					if (g_mkdir_with_parents (_tmp118_, 0755) != 0) {
						const gchar* _tmp119_;
						const gchar* _tmp120_;
						_tmp119_ = sysdev_dir;
						_tmp120_ = g_strerror (errno);
						g_error ("umockdev.vala:472: cannot create dir '%s': %s", _tmp119_, _tmp120_);
					}
					_tmp121_ = sysdev_dir;
					_tmp122_ = attributes[i + 1];
					_tmp123_ = g_build_filename (_tmp121_, _tmp122_, NULL);
					dest = _tmp123_;
					_tmp124_ = dest;
					if (!g_file_test (_tmp124_, G_FILE_TEST_EXISTS)) {
						const gchar* _tmp125_;
						gchar* _tmp126_;
						gchar* _tmp127_;
						gchar* _tmp128_;
						gchar* _tmp129_;
						const gchar* _tmp130_;
						gboolean _tmp131_;
						_tmp125_ = dev_path;
						_tmp126_ = string_substring (_tmp125_, (glong) 5, (glong) -1);
						_tmp127_ = _tmp126_;
						_tmp128_ = g_strconcat ("../../", _tmp127_, NULL);
						_tmp129_ = _tmp128_;
						_tmp130_ = dest;
						_tmp131_ = symlink (_tmp129_, _tmp130_) < 0;
						_g_free0 (_tmp129_);
						_g_free0 (_tmp127_);
						if (_tmp131_) {
							const gchar* _tmp132_;
							const gchar* _tmp133_;
							gchar* _tmp134_;
							gchar* _tmp135_;
							const gchar* _tmp136_;
							_tmp132_ = dest;
							_tmp133_ = dev_path;
							_tmp134_ = string_substring (_tmp133_, (glong) 5, (glong) -1);
							_tmp135_ = _tmp134_;
							_tmp136_ = g_strerror (errno);
							g_error ("umockdev.vala:476: add_device %s: failed to symlink %s to %s: %s\n", name, _tmp132_, _tmp135_, _tmp136_);
							_g_free0 (_tmp135_);
						}
					}
					_g_free0 (dest);
					_g_free0 (sysdev_dir);
					_g_free0 (infodir);
				}
			}
		}
	}
	if ((_vala_array_length (attributes) % 2) != 0) {
		const gchar* _tmp137_;
		_tmp137_ = attributes[_vala_array_length (attributes) - 1];
		g_warning ("umockdev.vala:482: add_devicev: Ignoring attribute key '%s' without va" \
"lue", _tmp137_);
	}
	if (umockdev_in_mock_environment ()) {
		const gchar* _tmp138_;
		_tmp138_ = dev_path;
		umockdev_testbed_uevent (self, _tmp138_, "add");
	}
	result = dev_path;
	_g_free0 (props);
	_g_free0 (dev_path_no_sys);
	_g_free0 (dev_dir);
	_g_free0 (dev_node);
	return result;
}

/**
     * umockdev_testbed_add_device: (skip)
     * @self: A #UMockdevTestbed.
     * @subsystem: The subsystem name, e. g. "usb"
     * @name: The device name; arbitrary, but needs to be unique within the testbed
     * @parent: (allow-none): device path of the parent device. Use %NULL for a
     *          top-level device.
     * @...: Arbitrarily many pairs of sysfs attributes (alternating names and
     *       values), terminated by %NULL, followed by arbitrarily many pairs of udev
     *       properties, terminated by another %NULL.
     *
     * Add a new device to the testbed. A Linux kernel device always has a
     * subsystem (such as "usb" or "pci"), and a device name. The test bed only
     * builds a very simple sysfs structure without nested namespaces, so it
     * requires device names to be unique. Some gudev client programs might make
     * assumptions about the name (e. g. a SCSI disk block device should be called
     * sdaN). A device also has an arbitrary number of sysfs attributes and udev
     * properties; usually you should specify them upon creation, but it is also
     * possible to change them later on with umockdev_testbed_set_attribute() and
     * umockdev_testbed_set_property().
     *
     * Example:
     *   |[
     *   umockdev_testbed_add_device (testbed, "usb", "dev1", NULL,
     *                              "idVendor", "0815", "idProduct", "AFFE", NULL,
     *                              "ID_MODEL", "KoolGadget", NULL);
     *   ]|
     *
     * Returns: The sysfs path for the newly created device. Free with g_free().
     */
static void
_vala_array_add1 (gchar** * array,
                  int* length,
                  int* size,
                  gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static void
_vala_array_add2 (gchar** * array,
                  int* length,
                  int* size,
                  gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

gchar*
umockdev_testbed_add_device (UMockdevTestbed* self,
                             const gchar* subsystem,
                             const gchar* name,
                             const gchar* parent,
                             ...)
{
	gchar** attributes = NULL;
	gchar** _tmp0_;
	gint attributes_length1;
	gint _attributes_size_;
	gchar** properties = NULL;
	gchar** _tmp1_;
	gint properties_length1;
	gint _properties_size_;
	gint arg_set = 0;
	va_list l = {0};
	gchar** _tmp11_;
	gint _tmp11__length1;
	gchar** _tmp12_;
	gint _tmp12__length1;
	gchar* _tmp13_;
	gchar* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (subsystem != NULL, NULL);
	g_return_val_if_fail (name != NULL, NULL);
	_tmp0_ = g_new0 (gchar*, 0 + 1);
	attributes = _tmp0_;
	attributes_length1 = 0;
	_attributes_size_ = attributes_length1;
	_tmp1_ = g_new0 (gchar*, 0 + 1);
	properties = _tmp1_;
	properties_length1 = 0;
	_properties_size_ = properties_length1;
	arg_set = 0;
	va_start (l, parent);
	while (TRUE) {
		gchar* arg = NULL;
		const gchar* _tmp2_;
		gchar* _tmp3_;
		const gchar* _tmp4_;
		_tmp2_ = va_arg (l, gchar*);
		_tmp3_ = g_strdup (_tmp2_);
		arg = _tmp3_;
		_tmp4_ = arg;
		if (_tmp4_ == NULL) {
			arg_set = arg_set + 1;
			if (arg_set > 1) {
				_g_free0 (arg);
				break;
			} else {
				_g_free0 (arg);
				continue;
			}
		}
		if (arg_set == 0) {
			gchar** _tmp5_;
			gint _tmp5__length1;
			const gchar* _tmp6_;
			gchar* _tmp7_;
			_tmp5_ = attributes;
			_tmp5__length1 = attributes_length1;
			_tmp6_ = arg;
			_tmp7_ = g_strdup (_tmp6_);
			_vala_array_add1 (&attributes, &attributes_length1, &_attributes_size_, _tmp7_);
		} else {
			gchar** _tmp8_;
			gint _tmp8__length1;
			const gchar* _tmp9_;
			gchar* _tmp10_;
			_tmp8_ = properties;
			_tmp8__length1 = properties_length1;
			_tmp9_ = arg;
			_tmp10_ = g_strdup (_tmp9_);
			_vala_array_add2 (&properties, &properties_length1, &_properties_size_, _tmp10_);
		}
		_g_free0 (arg);
	}
	_tmp11_ = attributes;
	_tmp11__length1 = attributes_length1;
	_tmp12_ = properties;
	_tmp12__length1 = properties_length1;
	_tmp13_ = umockdev_testbed_add_devicev (self, subsystem, name, parent, _tmp11_, _tmp12_);
	result = _tmp13_;
	va_end (l);
	properties = (_vala_array_free (properties, properties_length1, (GDestroyNotify) g_free), NULL);
	attributes = (_vala_array_free (attributes, attributes_length1, (GDestroyNotify) g_free), NULL);
	return result;
}

/**
     * umockdev_testbed_remove_device:
     * @self: A #UMockdevTestbed.
     * @syspath: Sysfs path of device
     *
     * Remove a device from the testbed. This removes the sysfs directory, the
     * /sys/class/ link, the device node, and all other information related to
     * it. Note that this will also remove all child devices (i. e.
     * subdirectories of @syspath).
     */
void
umockdev_testbed_remove_device (UMockdevTestbed* self,
                                const gchar* syspath)
{
	gchar* real_path = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* devname = NULL;
	gchar* _tmp2_;
	const gchar* _tmp3_;
	gchar* subsystem = NULL;
	const gchar* _tmp40_;
	const gchar* _tmp41_;
	const gchar* _tmp42_;
	gchar* _tmp43_;
	gchar* _tmp44_;
	const gchar* _tmp45_;
	const gchar* _tmp46_;
	gchar* _tmp47_;
	gchar* _tmp48_;
	const gchar* _tmp49_;
	const gchar* _tmp63_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (syspath != NULL);
	_tmp0_ = self->priv->root_dir;
	_tmp1_ = g_build_filename (_tmp0_, syspath, NULL);
	real_path = _tmp1_;
	_tmp2_ = g_path_get_basename (syspath);
	devname = _tmp2_;
	_tmp3_ = real_path;
	if (!g_file_test (_tmp3_, G_FILE_TEST_IS_DIR)) {
		g_critical ("umockdev.vala:562: umockdev_testbed_remove_device(): device %s does no" \
"t exist", syspath);
		_g_free0 (devname);
		_g_free0 (real_path);
		return;
	}
	{
		gchar* _tmp4_ = NULL;
		const gchar* _tmp5_;
		gchar* _tmp6_;
		gchar* _tmp7_;
		gchar* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
		_tmp5_ = real_path;
		_tmp6_ = g_build_filename (_tmp5_, "subsystem", NULL);
		_tmp7_ = _tmp6_;
		_tmp8_ = g_file_read_link (_tmp7_, &_inner_error0_);
		_tmp9_ = _tmp8_;
		_g_free0 (_tmp7_);
		_tmp4_ = _tmp9_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == G_FILE_ERROR) {
				goto __catch5_g_file_error;
			}
			_g_free0 (subsystem);
			_g_free0 (devname);
			_g_free0 (real_path);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
		_tmp10_ = g_path_get_basename (_tmp4_);
		_g_free0 (subsystem);
		subsystem = _tmp10_;
		_g_free0 (_tmp4_);
	}
	goto __finally5;
	__catch5_g_file_error:
	{
		GError* e = NULL;
		GError* _tmp11_;
		const gchar* _tmp12_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp11_ = e;
		_tmp12_ = _tmp11_->message;
		g_critical ("umockdev.vala:572: umockdev_testbed_remove_device(): cannot determine " \
"subsystem of %s: %s", syspath, _tmp12_);
		_g_error_free0 (e);
		_g_free0 (subsystem);
		_g_free0 (devname);
		_g_free0 (real_path);
		return;
	}
	__finally5:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_free0 (subsystem);
		_g_free0 (devname);
		_g_free0 (real_path);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	{
		gchar* dev_maj_min = NULL;
		const gchar* _tmp13_;
		gchar* _tmp14_;
		gchar* _tmp15_;
		gchar* _tmp16_ = NULL;
		const gchar* _tmp17_ = NULL;
		const gchar* _tmp18_;
		const gchar* _tmp19_;
		gchar* _tmp20_;
		gchar* _tmp21_;
		gchar* dev_node = NULL;
		const gchar* _tmp22_;
		gchar* _tmp23_;
		const gchar* _tmp24_;
		_tmp13_ = real_path;
		_tmp14_ = g_build_filename (_tmp13_, "dev", NULL);
		_tmp15_ = _tmp14_;
		g_file_get_contents (_tmp15_, &_tmp16_, NULL, &_inner_error0_);
		_g_free0 (dev_maj_min);
		dev_maj_min = _tmp16_;
		_g_free0 (_tmp15_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_free0 (dev_maj_min);
			if (_inner_error0_->domain == G_FILE_ERROR) {
				goto __catch6_g_file_error;
			}
			_g_free0 (subsystem);
			_g_free0 (devname);
			_g_free0 (real_path);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
		if (string_contains (syspath, "/block/")) {
			_tmp17_ = "block";
		} else {
			_tmp17_ = "char";
		}
		_tmp18_ = self->priv->sys_dir;
		_tmp19_ = dev_maj_min;
		_tmp20_ = g_build_filename (_tmp18_, "dev", _tmp17_, _tmp19_, NULL);
		_tmp21_ = _tmp20_;
		g_unlink (_tmp21_);
		_g_free0 (_tmp21_);
		_tmp22_ = real_path;
		_tmp23_ = umockdev_find_devnode (_tmp22_);
		dev_node = _tmp23_;
		_tmp24_ = dev_node;
		if (_tmp24_ != NULL) {
			gchar* real_node = NULL;
			const gchar* _tmp25_;
			const gchar* _tmp26_;
			gchar* _tmp27_;
			const gchar* _tmp28_;
			const gchar* _tmp29_;
			gchar* _tmp30_;
			gchar* _tmp31_;
			const gchar* _tmp32_;
			const gchar* _tmp33_;
			gchar* _tmp34_;
			gchar* _tmp35_;
			gchar* _tmp36_;
			gchar* _tmp37_;
			gchar* _tmp38_;
			gchar* _tmp39_;
			_tmp25_ = self->priv->root_dir;
			_tmp26_ = dev_node;
			_tmp27_ = g_build_filename (_tmp25_, _tmp26_, NULL);
			real_node = _tmp27_;
			_tmp28_ = real_node;
			g_unlink (_tmp28_);
			_tmp29_ = real_node;
			_tmp30_ = g_path_get_dirname (_tmp29_);
			_tmp31_ = _tmp30_;
			g_rmdir (_tmp31_);
			_g_free0 (_tmp31_);
			_tmp32_ = self->priv->root_dir;
			_tmp33_ = dev_node;
			_tmp34_ = string_substring (_tmp33_, (glong) 5, (glong) -1);
			_tmp35_ = _tmp34_;
			_tmp36_ = string_replace (_tmp35_, "/", "_");
			_tmp37_ = _tmp36_;
			_tmp38_ = g_build_filename (_tmp32_, "dev", ".node", _tmp37_, NULL);
			_tmp39_ = _tmp38_;
			g_unlink (_tmp39_);
			_g_free0 (_tmp39_);
			_g_free0 (_tmp37_);
			_g_free0 (_tmp35_);
			_g_free0 (real_node);
		}
		_g_free0 (dev_node);
		_g_free0 (dev_maj_min);
	}
	goto __finally6;
	__catch6_g_file_error:
	{
		GError* e = NULL;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_g_error_free0 (e);
	}
	__finally6:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_free0 (subsystem);
		_g_free0 (devname);
		_g_free0 (real_path);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	_tmp40_ = self->priv->sys_dir;
	_tmp41_ = subsystem;
	_tmp42_ = devname;
	_tmp43_ = g_build_filename (_tmp40_, "class", _tmp41_, _tmp42_, NULL);
	_tmp44_ = _tmp43_;
	g_unlink (_tmp44_);
	_g_free0 (_tmp44_);
	_tmp45_ = self->priv->sys_dir;
	_tmp46_ = subsystem;
	_tmp47_ = g_build_filename (_tmp45_, "class", _tmp46_, NULL);
	_tmp48_ = _tmp47_;
	g_rmdir (_tmp48_);
	_g_free0 (_tmp48_);
	_tmp49_ = subsystem;
	if (umockdev_testbed_subsystem_is_bus (_tmp49_)) {
		const gchar* _tmp50_;
		const gchar* _tmp51_;
		const gchar* _tmp52_;
		gchar* _tmp53_;
		gchar* _tmp54_;
		const gchar* _tmp55_;
		const gchar* _tmp56_;
		gchar* _tmp57_;
		gchar* _tmp58_;
		const gchar* _tmp59_;
		const gchar* _tmp60_;
		gchar* _tmp61_;
		gchar* _tmp62_;
		_tmp50_ = self->priv->sys_dir;
		_tmp51_ = subsystem;
		_tmp52_ = devname;
		_tmp53_ = g_build_filename (_tmp50_, "bus", _tmp51_, "devices", _tmp52_, NULL);
		_tmp54_ = _tmp53_;
		g_unlink (_tmp54_);
		_g_free0 (_tmp54_);
		_tmp55_ = self->priv->sys_dir;
		_tmp56_ = subsystem;
		_tmp57_ = g_build_filename (_tmp55_, "bus", _tmp56_, "devices", NULL);
		_tmp58_ = _tmp57_;
		g_rmdir (_tmp58_);
		_g_free0 (_tmp58_);
		_tmp59_ = self->priv->sys_dir;
		_tmp60_ = subsystem;
		_tmp61_ = g_build_filename (_tmp59_, "bus", _tmp60_, NULL);
		_tmp62_ = _tmp61_;
		g_rmdir (_tmp62_);
		_g_free0 (_tmp62_);
	}
	_tmp63_ = real_path;
	umockdev_remove_dir (_tmp63_, TRUE);
	_g_free0 (subsystem);
	_g_free0 (devname);
	_g_free0 (real_path);
}

/**
     * umockdev_testbed_add_from_string:
     * @self: A #UMockdevTestbed.
     * @data: Description of the device(s) as generated with umockdev-record
     * @error: return location for a GError, or %NULL
     *
     * Add a set of devices to the testbed from a textual description. This reads
     * the format generated by the umockdev-record tool.
     *
     * Each paragraph defines one device. A line starts with a type tag (like 'E'),
     * followed by a colon, followed by either a value or a "key=value" assignment,
     * depending on the type tag. A device description must start with a 'P:' line.
     * Available type tags are:
     * <itemizedlist>
     *   <listitem><type>P:</type> <emphasis>path</emphasis>: device path in sysfs, starting with
     *             <filename>/devices/</filename>; must occur exactly once at the
     *             start of device definition</listitem>
     *   <listitem><type>E:</type> <emphasis>key=value</emphasis>: udev property
     *             </listitem>
     *   <listitem><type>A:</type> <emphasis>key=value</emphasis>: ASCII sysfs
     *             attribute, with backslash-style escaping of \ (\\) and newlines
     *             (\n)</listitem>
     *   <listitem><type>H:</type> <emphasis>key=value</emphasis>: binary sysfs
     *             attribute, with the value being written as continuous hex string
     *             (e. g. 0081FE0A..)</listitem>
     *   <listitem><type>N:</type> <emphasis>devname</emphasis>[=<emphasis>contents</emphasis>]:
     *             device node name (without the <filename>/dev/</filename>
     *             prefix); if <emphasis>contents</emphasis> is given (encoded in a
     *             continuous hex string), it creates a
     *             <filename>/dev/devname</filename> in the mock environment with
     *             the given contents, otherwise the created dev file will be a
     *             pty; see #umockdev_testbed_get_dev_fd for details.</listitem>
     *   <listitem><type>S:</type> <emphasis>linkname</emphasis>: device node
     *             symlink (without the <filename>/dev/</filename> prefix); ignored right
     *             now.</listitem>
     * </itemizedlist>
     *
     * Returns: %TRUE on success, %FALSE if the data is invalid and an error
     *          occurred.
     */
static gchar
string_get (const gchar* self,
            glong index)
{
	gchar _tmp0_;
	gchar result = '\0';
	g_return_val_if_fail (self != NULL, '\0');
	_tmp0_ = ((gchar*) self)[index];
	result = _tmp0_;
	return result;
}

gboolean
umockdev_testbed_add_from_string (UMockdevTestbed* self,
                                  const gchar* data,
                                  GError** error)
{
	gchar* cur_data = NULL;
	gchar* _tmp18_;
	GError* _inner_error0_ = NULL;
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (data != NULL, FALSE);
	{
		GRegex* _tmp0_;
		GRegex* _tmp5_;
		GRegex* _tmp10_;
		_tmp0_ = self->priv->re_record_val;
		if (_tmp0_ == NULL) {
			GRegex* _tmp1_ = NULL;
			GRegex* _tmp2_;
			GRegex* _tmp4_;
			_tmp2_ = g_regex_new ("^([PS]): (.*)(?>\n|$)", 0, 0, &_inner_error0_);
			_tmp1_ = _tmp2_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				gboolean _tmp3_ = FALSE;
				if (_inner_error0_->domain == G_REGEX_ERROR) {
					goto __catch7_g_regex_error;
				}
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return _tmp3_;
			}
			_tmp4_ = _tmp1_;
			_tmp1_ = NULL;
			_g_regex_unref0 (self->priv->re_record_val);
			self->priv->re_record_val = _tmp4_;
			_g_regex_unref0 (_tmp1_);
		}
		_tmp5_ = self->priv->re_record_keyval;
		if (_tmp5_ == NULL) {
			GRegex* _tmp6_ = NULL;
			GRegex* _tmp7_;
			GRegex* _tmp9_;
			_tmp7_ = g_regex_new ("^([EAHL]): ([^=\n]+)=(.*)(?>\n|$)", 0, 0, &_inner_error0_);
			_tmp6_ = _tmp7_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				gboolean _tmp8_ = FALSE;
				if (_inner_error0_->domain == G_REGEX_ERROR) {
					goto __catch7_g_regex_error;
				}
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return _tmp8_;
			}
			_tmp9_ = _tmp6_;
			_tmp6_ = NULL;
			_g_regex_unref0 (self->priv->re_record_keyval);
			self->priv->re_record_keyval = _tmp9_;
			_g_regex_unref0 (_tmp6_);
		}
		_tmp10_ = self->priv->re_record_optval;
		if (_tmp10_ == NULL) {
			GRegex* _tmp11_ = NULL;
			GRegex* _tmp12_;
			GRegex* _tmp14_;
			_tmp12_ = g_regex_new ("^([N]): ([^=\n]+)(?>=([0-9A-F]+))?(?>\n|$)", 0, 0, &_inner_error0_);
			_tmp11_ = _tmp12_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				gboolean _tmp13_ = FALSE;
				if (_inner_error0_->domain == G_REGEX_ERROR) {
					goto __catch7_g_regex_error;
				}
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return _tmp13_;
			}
			_tmp14_ = _tmp11_;
			_tmp11_ = NULL;
			_g_regex_unref0 (self->priv->re_record_optval);
			self->priv->re_record_optval = _tmp14_;
			_g_regex_unref0 (_tmp11_);
		}
	}
	goto __finally7;
	__catch7_g_regex_error:
	{
		GError* e = NULL;
		const gchar* _tmp15_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp15_ = e->message;
		g_error ("umockdev.vala:657: Internal error, cannot create regex: %s", _tmp15_);
		_g_error_free0 (e);
	}
	__finally7:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == UMOCKDEV_ERROR) {
			gboolean _tmp16_ = FALSE;
			g_propagate_error (error, _inner_error0_);
			return _tmp16_;
		} else {
			gboolean _tmp17_ = FALSE;
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return _tmp17_;
		}
	}
	_tmp18_ = g_strdup (data);
	cur_data = _tmp18_;
	while (TRUE) {
		const gchar* _tmp19_;
		gchar* _tmp20_ = NULL;
		const gchar* _tmp21_;
		gchar* _tmp22_;
		gchar* _tmp25_;
		_tmp19_ = cur_data;
		if (!(string_get (_tmp19_, (glong) 0) != '\0')) {
			break;
		}
		_tmp21_ = cur_data;
		_tmp22_ = umockdev_testbed_add_dev_from_string (self, _tmp21_, &_inner_error0_);
		_tmp20_ = _tmp22_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == UMOCKDEV_ERROR) {
				gboolean _tmp23_ = FALSE;
				g_propagate_error (error, _inner_error0_);
				_g_free0 (cur_data);
				return _tmp23_;
			} else {
				gboolean _tmp24_ = FALSE;
				_g_free0 (cur_data);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return _tmp24_;
			}
		}
		_tmp25_ = _tmp20_;
		_tmp20_ = NULL;
		_g_free0 (cur_data);
		cur_data = _tmp25_;
		_g_free0 (_tmp20_);
	}
	result = TRUE;
	_g_free0 (cur_data);
	return result;
}

/**
     * umockdev_testbed_add_from_file:
     * @self: A #UMockdevTestbed.
     * @path: Path to file with description of the device(s) as generated with umockdev-record
     * @error: return location for a GError, or %NULL
     *
     * Add a set of devices to the testbed from a textual description. This
     * reads a file with the format generated by the umockdev-record tool, and
     * is mostly a convenience wrapper around
     * @umockdev_testbed_add_from_string.
     *
     * Returns: %TRUE on success, %FALSE if the @path cannot be read or thhe
     *          data is invalid and an error occurred.
     */
gboolean
umockdev_testbed_add_from_file (UMockdevTestbed* self,
                                const gchar* path,
                                GError** error)
{
	gchar* contents = NULL;
	gchar* _tmp0_ = NULL;
	gboolean _tmp3_ = FALSE;
	const gchar* _tmp4_;
	GError* _inner_error0_ = NULL;
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (path != NULL, FALSE);
	g_file_get_contents (path, &_tmp0_, NULL, &_inner_error0_);
	_g_free0 (contents);
	contents = _tmp0_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if ((_inner_error0_->domain == UMOCKDEV_ERROR) || (_inner_error0_->domain == G_FILE_ERROR)) {
			gboolean _tmp1_ = FALSE;
			g_propagate_error (error, _inner_error0_);
			_g_free0 (contents);
			return _tmp1_;
		} else {
			gboolean _tmp2_ = FALSE;
			_g_free0 (contents);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return _tmp2_;
		}
	}
	_tmp4_ = contents;
	_tmp3_ = umockdev_testbed_add_from_string (self, _tmp4_, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if ((_inner_error0_->domain == UMOCKDEV_ERROR) || (_inner_error0_->domain == G_FILE_ERROR)) {
			gboolean _tmp5_ = FALSE;
			g_propagate_error (error, _inner_error0_);
			_g_free0 (contents);
			return _tmp5_;
		} else {
			gboolean _tmp6_ = FALSE;
			_g_free0 (contents);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return _tmp6_;
		}
	}
	result = _tmp3_;
	_g_free0 (contents);
	return result;
}

/**
     * umockdev_testbed_uevent:
     * @self: A #UMockdevTestbed.
     * @devpath: The full device path, as returned by #umockdev_testbed_add_device()
     * @action: "add", "remove", or "change"
     *
     * Generate an uevent for a device.
     */
void
umockdev_testbed_uevent (UMockdevTestbed* self,
                         const gchar* devpath,
                         const gchar* action)
{
	uevent_sender* _tmp0_;
	uevent_sender* _tmp4_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (devpath != NULL);
	g_return_if_fail (action != NULL);
	_tmp0_ = self->priv->ev_sender;
	if (_tmp0_ == NULL) {
		const gchar* _tmp1_;
		uevent_sender* _tmp2_;
		uevent_sender* _tmp3_;
		g_debug ("umockdev.vala:700: umockdev_testbed_uevent: lazily initializing uevent" \
"_sender");
		_tmp1_ = self->priv->root_dir;
		_tmp2_ = uevent_sender_open (_tmp1_);
		_uevent_sender_close0 (self->priv->ev_sender);
		self->priv->ev_sender = _tmp2_;
		_tmp3_ = self->priv->ev_sender;
		_vala_assert (_tmp3_ != NULL, "this.ev_sender != null");
	}
	g_debug ("umockdev.vala:704: umockdev_testbed_uevent: sending uevent %s for devi" \
"ce %s", action, devpath);
	_tmp4_ = self->priv->ev_sender;
	uevent_sender_send (_tmp4_, devpath, action);
}

/**
     * umockdev_testbed_load_ioctl:
     * @self: A #UMockdevTestbed.
     * @dev: Device path (/dev/...) for which to load the ioctl record.
     *       %NULL is valid; in this case the ioctl record is associated with
     *       the device node it was recorded from.
     * @recordfile: Path of the ioctl record file.
     * @error: return location for a GError, or %NULL
     *
     * Load an ioctl record file for a particular device into the testbed.
     * ioctl records can be created with umockdev-record --ioctl.
     * They can optionally be xz compressed to save space (but then are
     * required to have an .xz file name suffix).
     *
     * Returns: %TRUE on success, %FALSE if the data is invalid and an error
     *          occurred.
     */
static guint8*
_vala_array_dup1 (guint8* self,
                  int length)
{
	return g_memdup (self, length * sizeof (guint8));
}

gboolean
umockdev_testbed_load_ioctl (UMockdevTestbed* self,
                             const gchar* dev,
                             const gchar* recordfile,
                             GError** error)
{
	GDataInputStream* recording = NULL;
	gchar* owned_dev = NULL;
	gchar* _tmp0_;
	const gchar* _tmp25_;
	gchar* dest = NULL;
	const gchar* _tmp48_;
	const gchar* _tmp49_;
	gchar* _tmp50_;
	const gchar* _tmp51_;
	gchar* _tmp52_;
	gchar* _tmp53_;
	gchar* contents = NULL;
	GDataInputStream* _tmp54_;
	gchar* _tmp55_;
	const gchar* _tmp57_;
	gboolean _tmp59_ = FALSE;
	const gchar* _tmp60_;
	const gchar* _tmp61_;
	GError* _inner_error0_ = NULL;
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (recordfile != NULL, FALSE);
	_tmp0_ = g_strdup (dev);
	owned_dev = _tmp0_;
	if (g_str_has_suffix (recordfile, ".xz")) {
		{
			gchar* contents = NULL;
			gint exit = 0;
			gchar* _tmp1_;
			gchar* _tmp2_;
			gchar* _tmp3_;
			gchar** _tmp4_;
			gchar** _tmp5_;
			gint _tmp5__length1;
			gchar* _tmp6_ = NULL;
			gint _tmp7_ = 0;
			const gchar* _tmp9_;
			guint8* _tmp10_;
			gint _tmp10__length1;
			guint8* _tmp11_;
			gint _tmp11__length1;
			guint8* _tmp12_;
			gint _tmp12__length1;
			GMemoryInputStream* _tmp13_;
			GMemoryInputStream* _tmp14_;
			GDataInputStream* _tmp15_;
			_tmp1_ = g_strdup ("xz");
			_tmp2_ = g_strdup ("-cd");
			_tmp3_ = g_strdup (recordfile);
			_tmp4_ = g_new0 (gchar*, 3 + 1);
			_tmp4_[0] = _tmp1_;
			_tmp4_[1] = _tmp2_;
			_tmp4_[2] = _tmp3_;
			_tmp5_ = _tmp4_;
			_tmp5__length1 = 3;
			g_spawn_sync (NULL, _tmp5_, NULL, G_SPAWN_SEARCH_PATH, NULL, NULL, &_tmp6_, NULL, &_tmp7_, &_inner_error0_);
			_g_free0 (contents);
			contents = _tmp6_;
			exit = _tmp7_;
			_tmp5_ = (_vala_array_free (_tmp5_, _tmp5__length1, (GDestroyNotify) g_free), NULL);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				gboolean _tmp8_ = FALSE;
				_g_free0 (contents);
				if (_inner_error0_->domain == G_SPAWN_ERROR) {
					goto __catch8_g_spawn_error;
				}
				_g_free0 (owned_dev);
				_g_object_unref0 (recording);
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return _tmp8_;
			}
			_vala_assert (exit == 0, "exit == 0");
			_tmp9_ = contents;
			_tmp10_ = string_get_data (_tmp9_, &_tmp10__length1);
			_tmp11_ = _tmp10_;
			_tmp11__length1 = _tmp10__length1;
			_tmp12_ = (_tmp11_ != NULL) ? _vala_array_dup1 (_tmp11_, _tmp11__length1) : ((gpointer) _tmp11_);
			_tmp12__length1 = _tmp11__length1;
			_tmp13_ = (GMemoryInputStream*) g_memory_input_stream_new_from_data (_tmp12_, _tmp12__length1, NULL);
			_tmp14_ = _tmp13_;
			_tmp15_ = g_data_input_stream_new ((GInputStream*) _tmp14_);
			_g_object_unref0 (recording);
			recording = _tmp15_;
			_g_object_unref0 (_tmp14_);
			_g_free0 (contents);
		}
		goto __finally8;
		__catch8_g_spawn_error:
		{
			GError* e = NULL;
			const gchar* _tmp16_;
			e = _inner_error0_;
			_inner_error0_ = NULL;
			_tmp16_ = e->message;
			g_error ("umockdev.vala:745: Cannot call xz to decompress %s: %s", recordfile, _tmp16_);
			_g_error_free0 (e);
		}
		__finally8:
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			gboolean _tmp17_ = FALSE;
			g_propagate_error (error, _inner_error0_);
			_g_free0 (owned_dev);
			_g_object_unref0 (recording);
			return _tmp17_;
		}
	} else {
		GFileInputStream* _tmp18_ = NULL;
		GFile* _tmp19_;
		GFile* _tmp20_;
		GFileInputStream* _tmp21_;
		GFileInputStream* _tmp22_;
		GDataInputStream* _tmp24_;
		_tmp19_ = g_file_new_for_path (recordfile);
		_tmp20_ = _tmp19_;
		_tmp21_ = g_file_read (_tmp20_, NULL, &_inner_error0_);
		_tmp22_ = _tmp21_;
		_g_object_unref0 (_tmp20_);
		_tmp18_ = _tmp22_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			gboolean _tmp23_ = FALSE;
			g_propagate_error (error, _inner_error0_);
			_g_free0 (owned_dev);
			_g_object_unref0 (recording);
			return _tmp23_;
		}
		_tmp24_ = g_data_input_stream_new ((GInputStream*) _tmp18_);
		_g_object_unref0 (recording);
		recording = _tmp24_;
		_g_object_unref0 (_tmp18_);
	}
	_tmp25_ = owned_dev;
	if (_tmp25_ == NULL) {
		gchar* line = NULL;
		GDataInputStream* _tmp26_;
		gchar* _tmp27_;
		const gchar* _tmp37_;
		GMatchInfo* header_matcher = NULL;
		GRegex* _tmp38_ = NULL;
		GRegex* _tmp39_;
		const gchar* _tmp41_;
		GMatchInfo* _tmp42_ = NULL;
		gboolean _tmp43_;
		GMatchInfo* _tmp44_;
		gchar* _tmp45_;
		GDataInputStream* _tmp46_;
		_tmp26_ = recording;
		_tmp27_ = g_data_input_stream_read_line (_tmp26_, NULL, NULL, &_inner_error0_);
		line = _tmp27_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			gboolean _tmp28_ = FALSE;
			g_propagate_error (error, _inner_error0_);
			_g_free0 (owned_dev);
			_g_object_unref0 (recording);
			return _tmp28_;
		}
		while (TRUE) {
			gboolean _tmp29_ = FALSE;
			const gchar* _tmp30_;
			gchar* _tmp32_ = NULL;
			GDataInputStream* _tmp33_;
			gchar* _tmp34_;
			gchar* _tmp36_;
			_tmp30_ = line;
			if (_tmp30_ != NULL) {
				const gchar* _tmp31_;
				_tmp31_ = line;
				_tmp29_ = g_str_has_prefix (_tmp31_, "#");
			} else {
				_tmp29_ = FALSE;
			}
			if (!_tmp29_) {
				break;
			}
			_tmp33_ = recording;
			_tmp34_ = g_data_input_stream_read_line (_tmp33_, NULL, NULL, &_inner_error0_);
			_tmp32_ = _tmp34_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				gboolean _tmp35_ = FALSE;
				g_propagate_error (error, _inner_error0_);
				_g_free0 (line);
				_g_free0 (owned_dev);
				_g_object_unref0 (recording);
				return _tmp35_;
			}
			_tmp36_ = _tmp32_;
			_tmp32_ = NULL;
			_g_free0 (line);
			line = _tmp36_;
			_g_free0 (_tmp32_);
		}
		_tmp37_ = line;
		if (_tmp37_ == NULL) {
			g_error ("umockdev.vala:760: ioctl recording file %s has no non-comment content", recordfile);
		}
		_tmp39_ = g_regex_new ("^@DEV (.*)(\n|$)", 0, 0, &_inner_error0_);
		_tmp38_ = _tmp39_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			gboolean _tmp40_ = FALSE;
			g_propagate_error (error, _inner_error0_);
			_g_match_info_unref0 (header_matcher);
			_g_free0 (line);
			_g_free0 (owned_dev);
			_g_object_unref0 (recording);
			return _tmp40_;
		}
		_tmp41_ = line;
		_tmp43_ = g_regex_match (_tmp38_, _tmp41_, 0, &_tmp42_);
		_g_match_info_unref0 (header_matcher);
		header_matcher = _tmp42_;
		if (!_tmp43_) {
			g_error ("umockdev.vala:764: null passed for device node, but recording %s has n" \
"o @DEV header", recordfile);
		}
		_tmp44_ = header_matcher;
		_tmp45_ = g_match_info_fetch (_tmp44_, 1);
		_g_free0 (owned_dev);
		owned_dev = _tmp45_;
		_tmp46_ = recording;
		g_seekable_seek ((GSeekable*) _tmp46_, (gint64) 0, G_SEEK_SET, NULL, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			gboolean _tmp47_ = FALSE;
			g_propagate_error (error, _inner_error0_);
			_g_regex_unref0 (_tmp38_);
			_g_match_info_unref0 (header_matcher);
			_g_free0 (line);
			_g_free0 (owned_dev);
			_g_object_unref0 (recording);
			return _tmp47_;
		}
		_g_regex_unref0 (_tmp38_);
		_g_match_info_unref0 (header_matcher);
		_g_free0 (line);
	}
	_tmp48_ = self->priv->root_dir;
	_tmp49_ = owned_dev;
	_tmp50_ = g_build_filename (_tmp48_, "ioctl", _tmp49_, NULL);
	dest = _tmp50_;
	_tmp51_ = dest;
	_tmp52_ = g_path_get_dirname (_tmp51_);
	_tmp53_ = _tmp52_;
	_vala_assert (g_mkdir_with_parents (_tmp53_, 0755) == 0, "DirUtils.create_with_parents(Path.get_dirname(dest), 0755) == 0");
	_g_free0 (_tmp53_);
	_tmp54_ = recording;
	_tmp55_ = g_data_input_stream_read_upto (_tmp54_, "", (gssize) 0, NULL, NULL, &_inner_error0_);
	contents = _tmp55_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		gboolean _tmp56_ = FALSE;
		g_propagate_error (error, _inner_error0_);
		_g_free0 (dest);
		_g_free0 (owned_dev);
		_g_object_unref0 (recording);
		return _tmp56_;
	}
	_tmp57_ = contents;
	if (_tmp57_ == NULL) {
		gchar* _tmp58_;
		_tmp58_ = g_strdup ("");
		_g_free0 (contents);
		contents = _tmp58_;
	}
	_tmp60_ = dest;
	_tmp61_ = contents;
	_tmp59_ = g_file_set_contents (_tmp60_, _tmp61_, (gssize) -1, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		gboolean _tmp62_ = FALSE;
		g_propagate_error (error, _inner_error0_);
		_g_free0 (contents);
		_g_free0 (dest);
		_g_free0 (owned_dev);
		_g_object_unref0 (recording);
		return _tmp62_;
	}
	result = _tmp59_;
	_g_free0 (contents);
	_g_free0 (dest);
	_g_free0 (owned_dev);
	_g_object_unref0 (recording);
	return result;
}

/**
     * umockdev_testbed_load_script:
     * @self: A #UMockdevTestbed.
     * @dev: Device path (/dev/...) for which to load the script record.
     *       %NULL is valid; in this case the script is associated with
     *       the device node it was recorded from.
     * @recordfile: Path of the script record file.
     * @error: return location for a GError, or %NULL
     *
     * Load a script record file for a particular device into the testbed.
     * script records can be created with umockdev-record --script.
     *
     * Returns: %TRUE on success, %FALSE if @recordfile is invalid and an error
     *          occurred.
     */
gboolean
umockdev_testbed_load_script (UMockdevTestbed* self,
                              const gchar* dev,
                              const gchar* recordfile,
                              GError** error)
{
	gchar* owned_dev = NULL;
	gchar* _tmp0_;
	const gchar* _tmp1_;
	GHashTable* _tmp29_;
	const gchar* _tmp30_;
	gint fd = 0;
	const gchar* _tmp31_;
	UMockdevScriptRunner* _tmp38_ = NULL;
	const gchar* _tmp39_;
	UMockdevScriptRunner* _tmp40_;
	GHashTable* _tmp42_;
	const gchar* _tmp43_;
	gchar* _tmp44_;
	UMockdevScriptRunner* _tmp45_;
	GError* _inner_error0_ = NULL;
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (recordfile != NULL, FALSE);
	_tmp0_ = g_strdup (dev);
	owned_dev = _tmp0_;
	_tmp1_ = owned_dev;
	if (_tmp1_ == NULL) {
		GFileInputStream* _tmp2_ = NULL;
		GFile* _tmp3_;
		GFile* _tmp4_;
		GFileInputStream* _tmp5_;
		GFileInputStream* _tmp6_;
		GDataInputStream* recording = NULL;
		GDataInputStream* _tmp8_;
		gchar* line = NULL;
		GDataInputStream* _tmp9_;
		gchar* _tmp10_;
		const gchar* _tmp20_;
		GMatchInfo* header_matcher = NULL;
		GRegex* _tmp21_ = NULL;
		GRegex* _tmp22_;
		const gchar* _tmp24_;
		GMatchInfo* _tmp25_ = NULL;
		gboolean _tmp26_;
		GMatchInfo* _tmp27_;
		gchar* _tmp28_;
		_tmp3_ = g_file_new_for_path (recordfile);
		_tmp4_ = _tmp3_;
		_tmp5_ = g_file_read (_tmp4_, NULL, &_inner_error0_);
		_tmp6_ = _tmp5_;
		_g_object_unref0 (_tmp4_);
		_tmp2_ = _tmp6_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			gboolean _tmp7_ = FALSE;
			g_propagate_error (error, _inner_error0_);
			_g_free0 (owned_dev);
			return _tmp7_;
		}
		_tmp8_ = g_data_input_stream_new ((GInputStream*) _tmp2_);
		recording = _tmp8_;
		_tmp9_ = recording;
		_tmp10_ = g_data_input_stream_read_line (_tmp9_, NULL, NULL, &_inner_error0_);
		line = _tmp10_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			gboolean _tmp11_ = FALSE;
			g_propagate_error (error, _inner_error0_);
			_g_object_unref0 (recording);
			_g_object_unref0 (_tmp2_);
			_g_free0 (owned_dev);
			return _tmp11_;
		}
		while (TRUE) {
			gboolean _tmp12_ = FALSE;
			const gchar* _tmp13_;
			gchar* _tmp15_ = NULL;
			GDataInputStream* _tmp16_;
			gchar* _tmp17_;
			gchar* _tmp19_;
			_tmp13_ = line;
			if (_tmp13_ != NULL) {
				const gchar* _tmp14_;
				_tmp14_ = line;
				_tmp12_ = g_str_has_prefix (_tmp14_, "#");
			} else {
				_tmp12_ = FALSE;
			}
			if (!_tmp12_) {
				break;
			}
			_tmp16_ = recording;
			_tmp17_ = g_data_input_stream_read_line (_tmp16_, NULL, NULL, &_inner_error0_);
			_tmp15_ = _tmp17_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				gboolean _tmp18_ = FALSE;
				g_propagate_error (error, _inner_error0_);
				_g_free0 (line);
				_g_object_unref0 (recording);
				_g_object_unref0 (_tmp2_);
				_g_free0 (owned_dev);
				return _tmp18_;
			}
			_tmp19_ = _tmp15_;
			_tmp15_ = NULL;
			_g_free0 (line);
			line = _tmp19_;
			_g_free0 (_tmp15_);
		}
		_tmp20_ = line;
		if (_tmp20_ == NULL) {
			g_error ("umockdev.vala:806: script recording %s has no non-comment content", recordfile);
		}
		_tmp22_ = g_regex_new ("^d 0 (.*)(\n|$)", 0, 0, &_inner_error0_);
		_tmp21_ = _tmp22_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			gboolean _tmp23_ = FALSE;
			g_propagate_error (error, _inner_error0_);
			_g_match_info_unref0 (header_matcher);
			_g_free0 (line);
			_g_object_unref0 (recording);
			_g_object_unref0 (_tmp2_);
			_g_free0 (owned_dev);
			return _tmp23_;
		}
		_tmp24_ = line;
		_tmp26_ = g_regex_match (_tmp21_, _tmp24_, 0, &_tmp25_);
		_g_match_info_unref0 (header_matcher);
		header_matcher = _tmp25_;
		if (!_tmp26_) {
			g_error ("umockdev.vala:810: null passed for device node, but recording %s has n" \
"o d 0 header", recordfile);
		}
		_tmp27_ = header_matcher;
		_tmp28_ = g_match_info_fetch (_tmp27_, 1);
		_g_free0 (owned_dev);
		owned_dev = _tmp28_;
		_g_regex_unref0 (_tmp21_);
		_g_match_info_unref0 (header_matcher);
		_g_free0 (line);
		_g_object_unref0 (recording);
		_g_object_unref0 (_tmp2_);
	}
	_tmp29_ = self->priv->dev_script_runner;
	_tmp30_ = owned_dev;
	_vala_assert (!g_hash_table_contains (_tmp29_, _tmp30_), "!this.dev_script_runner.contains (owned_dev)");
	_tmp31_ = owned_dev;
	fd = umockdev_testbed_get_dev_fd (self, _tmp31_);
	if (fd < 0) {
		const gchar* _tmp32_;
		gchar* _tmp33_;
		gchar* _tmp34_;
		GError* _tmp35_;
		GError* _tmp36_;
		gboolean _tmp37_ = FALSE;
		_tmp32_ = owned_dev;
		_tmp33_ = g_strconcat (_tmp32_, " is not a device suitable for scripts", NULL);
		_tmp34_ = _tmp33_;
		_tmp35_ = g_error_new_literal (G_FILE_ERROR, G_FILE_ERROR_INVAL, _tmp34_);
		_tmp36_ = _tmp35_;
		_g_free0 (_tmp34_);
		_inner_error0_ = _tmp36_;
		g_propagate_error (error, _inner_error0_);
		_g_free0 (owned_dev);
		return _tmp37_;
	}
	_tmp39_ = owned_dev;
	_tmp40_ = umockdev_script_runner_new (_tmp39_, recordfile, fd, &_inner_error0_);
	_tmp38_ = _tmp40_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		gboolean _tmp41_ = FALSE;
		g_propagate_error (error, _inner_error0_);
		_g_free0 (owned_dev);
		return _tmp41_;
	}
	_tmp42_ = self->priv->dev_script_runner;
	_tmp43_ = owned_dev;
	_tmp44_ = g_strdup (_tmp43_);
	_tmp45_ = _tmp38_;
	_tmp38_ = NULL;
	g_hash_table_insert (_tmp42_, _tmp44_, _tmp45_);
	result = TRUE;
	_umockdev_script_runner_unref0 (_tmp38_);
	_g_free0 (owned_dev);
	return result;
}

/**
     * umockdev_testbed_load_socket_script:
     * @self: A #UMockdevTestbed.
     * @path: Unix socket path
     * @type: Unix socket type (#SOCK_STREAM, #SOCK_DGRAM)
     * @recordfile: Path of the script record file.
     * @error: return location for a GError, or %NULL
     *
     * Add an Unix socket to the testbed that is backed by a recorded script.
     * Clients can connect to the socket using @path (i. e. without the testbed
     * prefix).
     *
     * Returns: %TRUE on success, %FALSE if the @path or @type are
     *          invalid and an error occurred.
     */
gboolean
umockdev_testbed_load_socket_script (UMockdevTestbed* self,
                                     const gchar* path,
                                     gint type,
                                     const gchar* recordfile,
                                     GError** error)
{
	gint fd = 0;
	gchar* real_path = NULL;
	const gchar* _tmp7_;
	gchar* _tmp8_;
	const gchar* _tmp9_;
	gchar* _tmp10_;
	gchar* _tmp11_;
	gboolean _tmp12_;
	UMockdevSocketServer* _tmp20_;
	UMockdevSocketServer* _tmp22_;
	const gchar* _tmp23_;
	GError* _inner_error0_ = NULL;
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (path != NULL, FALSE);
	g_return_val_if_fail (recordfile != NULL, FALSE);
	fd = socket (AF_UNIX, type, 0);
	if (fd < 0) {
		const gchar* _tmp0_;
		gchar* _tmp1_;
		gchar* _tmp2_;
		GError* _tmp3_;
		GError* _tmp4_;
		_tmp0_ = g_strerror (errno);
		_tmp1_ = g_strdup_printf ("Cannot create socket type %i: %s", type, _tmp0_);
		_tmp2_ = _tmp1_;
		_tmp3_ = g_error_new_literal (G_FILE_ERROR, G_FILE_ERROR_INVAL, _tmp2_);
		_tmp4_ = _tmp3_;
		_g_free0 (_tmp2_);
		_inner_error0_ = _tmp4_;
		if (_inner_error0_->domain == G_FILE_ERROR) {
			gboolean _tmp5_ = FALSE;
			g_propagate_error (error, _inner_error0_);
			return _tmp5_;
		} else {
			gboolean _tmp6_ = FALSE;
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return _tmp6_;
		}
	}
	_tmp7_ = self->priv->root_dir;
	_tmp8_ = g_build_filename (_tmp7_, path, NULL);
	real_path = _tmp8_;
	_tmp9_ = real_path;
	_tmp10_ = g_path_get_dirname (_tmp9_);
	_tmp11_ = _tmp10_;
	_tmp12_ = g_mkdir_with_parents (_tmp11_, 0755) != 0;
	_g_free0 (_tmp11_);
	if (_tmp12_) {
		const gchar* _tmp13_;
		gchar* _tmp14_;
		gchar* _tmp15_;
		GError* _tmp16_;
		GError* _tmp17_;
		_tmp13_ = g_strerror (errno);
		_tmp14_ = g_strdup_printf ("Cannot create socket path: %s", _tmp13_);
		_tmp15_ = _tmp14_;
		_tmp16_ = g_error_new_literal (G_FILE_ERROR, G_FILE_ERROR_INVAL, _tmp15_);
		_tmp17_ = _tmp16_;
		_g_free0 (_tmp15_);
		_inner_error0_ = _tmp17_;
		if (_inner_error0_->domain == G_FILE_ERROR) {
			gboolean _tmp18_ = FALSE;
			g_propagate_error (error, _inner_error0_);
			_g_free0 (real_path);
			return _tmp18_;
		} else {
			gboolean _tmp19_ = FALSE;
			_g_free0 (real_path);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return _tmp19_;
		}
	}
	_tmp20_ = self->priv->socket_server;
	if (_tmp20_ == NULL) {
		UMockdevSocketServer* _tmp21_;
		_tmp21_ = umockdev_socket_server_new ();
		_umockdev_socket_server_unref0 (self->priv->socket_server);
		self->priv->socket_server = _tmp21_;
	}
	_tmp22_ = self->priv->socket_server;
	_tmp23_ = real_path;
	umockdev_socket_server_add (_tmp22_, _tmp23_, fd, recordfile);
	result = TRUE;
	_g_free0 (real_path);
	return result;
}

/**
     * umockdev_testbed_load_evemu_events:
     * @self: A #UMockdevTestbed.
     * @dev: Device path (/dev/...) for which to load the evemu events.
     *       %NULL is valid; in this case the events are associated with
     *       the device node it was recorded from.
     * @eventsfile: Path of the evemu events file.
     * @error: return location for a GError, or %NULL
     *
     * Load an evemu event file for a particular device into the testbed. These
     * have a very simple line-based format with 4 fields that represent the
     * data in a struct input_event:
     *
     *  E: sec.usec evtype(hex) evcode(hex) evvalue
     *
     * The timestamps in those are absolute, and are usually as they were at
     * record time. When loading them into umockdev they are interpreted
     * relatively: the first event happens immediately, and the time to the
     * next event is the difference between the corresponding timestamps in the
     * .event file.
     *
     * Returns: %TRUE on success, %FALSE if @eventsfile is invalid and an error
     *          occurred.
     */
static guint64
uint64_parse (const gchar* str)
{
	guint64 result = 0ULL;
	g_return_val_if_fail (str != NULL, 0ULL);
	result = g_ascii_strtoull (str, NULL, (guint) 0);
	return result;
}

gboolean
umockdev_testbed_load_evemu_events (UMockdevTestbed* self,
                                    const gchar* dev,
                                    const gchar* eventsfile,
                                    GError** error)
{
	GFile* f_ev = NULL;
	GFile* _tmp0_;
	GFileInputStream* _tmp1_ = NULL;
	GFile* _tmp2_;
	GFileInputStream* _tmp3_;
	GDataInputStream* s_ev = NULL;
	GDataInputStream* _tmp5_;
	gchar* line = NULL;
	gchar* recorded_dev = NULL;
	gsize len = 0UL;
	GMatchInfo* match = NULL;
	struct input_event ev = {0};
	struct input_event _tmp6_ = {0};
	GRegex* default_dev_re = NULL;
	GRegex* _tmp7_;
	GRegex* event_re = NULL;
	GRegex* _tmp9_;
	gchar* script_file = NULL;
	gint script_fd = 0;
	gchar* _tmp11_ = NULL;
	gint _tmp12_;
	gint delay = 0;
	gboolean first = FALSE;
	gchar* owned_dev = NULL;
	gchar* _tmp77_;
	const gchar* _tmp78_;
	gboolean ret = FALSE;
	const gchar* _tmp82_;
	const gchar* _tmp83_;
	const gchar* _tmp85_;
	GError* _inner_error0_ = NULL;
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (eventsfile != NULL, FALSE);
	_tmp0_ = g_file_new_for_path (eventsfile);
	f_ev = _tmp0_;
	_tmp2_ = f_ev;
	_tmp3_ = g_file_read (_tmp2_, NULL, &_inner_error0_);
	_tmp1_ = _tmp3_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		gboolean _tmp4_ = FALSE;
		g_propagate_error (error, _inner_error0_);
		_g_object_unref0 (f_ev);
		return _tmp4_;
	}
	_tmp5_ = g_data_input_stream_new ((GInputStream*) _tmp1_);
	s_ev = _tmp5_;
	recorded_dev = NULL;
	ev = _tmp6_;
	_tmp7_ = g_regex_new ("^# device (.*)$", 0, 0, &_inner_error0_);
	default_dev_re = _tmp7_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		gboolean _tmp8_ = FALSE;
		g_propagate_error (error, _inner_error0_);
		_g_match_info_unref0 (match);
		_g_free0 (recorded_dev);
		_g_free0 (line);
		_g_object_unref0 (s_ev);
		_g_object_unref0 (_tmp1_);
		_g_object_unref0 (f_ev);
		return _tmp8_;
	}
	_tmp9_ = g_regex_new ("^E: ([0-9]+)\\.([0-9]+) +([0-9a-fA-F]+) +([0-9a-fA-F]+) +(-?[0-9]+) *#" \
"?", 0, 0, &_inner_error0_);
	event_re = _tmp9_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		gboolean _tmp10_ = FALSE;
		g_propagate_error (error, _inner_error0_);
		_g_regex_unref0 (default_dev_re);
		_g_match_info_unref0 (match);
		_g_free0 (recorded_dev);
		_g_free0 (line);
		_g_object_unref0 (s_ev);
		_g_object_unref0 (_tmp1_);
		_g_object_unref0 (f_ev);
		return _tmp10_;
	}
	_tmp12_ = g_file_open_tmp ("evemu.XXXXXX.script", &_tmp11_, &_inner_error0_);
	_g_free0 (script_file);
	script_file = _tmp11_;
	script_fd = _tmp12_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		gboolean _tmp13_ = FALSE;
		g_propagate_error (error, _inner_error0_);
		_g_free0 (script_file);
		_g_regex_unref0 (event_re);
		_g_regex_unref0 (default_dev_re);
		_g_match_info_unref0 (match);
		_g_free0 (recorded_dev);
		_g_free0 (line);
		_g_object_unref0 (s_ev);
		_g_object_unref0 (_tmp1_);
		_g_object_unref0 (f_ev);
		return _tmp13_;
	}
	delay = 0;
	first = TRUE;
	while (TRUE) {
		gchar* _tmp14_ = NULL;
		GDataInputStream* _tmp15_;
		gsize _tmp16_ = 0UL;
		gchar* _tmp17_;
		gchar* _tmp19_;
		const gchar* _tmp20_;
		GRegex* _tmp21_;
		const gchar* _tmp22_;
		GMatchInfo* _tmp23_ = NULL;
		gboolean _tmp24_;
		GRegex* _tmp27_;
		const gchar* _tmp28_;
		GMatchInfo* _tmp29_ = NULL;
		gboolean _tmp30_;
		time_t ev_sec = 0;
		GMatchInfo* _tmp33_;
		gchar* _tmp34_;
		gchar* _tmp35_;
		time_t _tmp36_;
		time_t ev_usec = 0;
		GMatchInfo* _tmp37_;
		gchar* _tmp38_;
		gchar* _tmp39_;
		time_t _tmp40_;
		GMatchInfo* _tmp45_;
		gchar* _tmp46_;
		gchar* _tmp47_;
		GMatchInfo* _tmp48_;
		gchar* _tmp49_;
		gchar* _tmp50_;
		GMatchInfo* _tmp51_;
		gchar* _tmp52_;
		gchar* _tmp53_;
		guint8* ev_data = NULL;
		guint8* _tmp54_;
		gint ev_data_length1;
		gint _ev_data_size_;
		guint8* _tmp55_;
		gint _tmp55__length1;
		guint8* _tmp56_;
		gint _tmp56__length1;
		gchar* script_line = NULL;
		gchar* _tmp57_;
		gchar* _tmp58_;
		gchar* _tmp59_;
		gchar* _tmp60_;
		gchar* _tmp61_;
		gchar* _tmp62_;
		guint8* _tmp63_;
		gint _tmp63__length1;
		gchar* _tmp64_;
		gchar* _tmp65_;
		gchar* _tmp66_;
		gchar* _tmp67_;
		gchar* _tmp68_;
		gchar* _tmp69_;
		const gchar* _tmp70_;
		const gchar* _tmp71_;
		gint _tmp72_;
		gint _tmp73_;
		const gchar* _tmp74_;
		gint _tmp75_;
		gint _tmp76_;
		_tmp15_ = s_ev;
		_tmp17_ = g_data_input_stream_read_line (_tmp15_, &_tmp16_, NULL, &_inner_error0_);
		len = _tmp16_;
		_tmp14_ = _tmp17_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			gboolean _tmp18_ = FALSE;
			g_propagate_error (error, _inner_error0_);
			_g_free0 (script_file);
			_g_regex_unref0 (event_re);
			_g_regex_unref0 (default_dev_re);
			_g_match_info_unref0 (match);
			_g_free0 (recorded_dev);
			_g_free0 (line);
			_g_object_unref0 (s_ev);
			_g_object_unref0 (_tmp1_);
			_g_object_unref0 (f_ev);
			return _tmp18_;
		}
		_tmp19_ = _tmp14_;
		_tmp14_ = NULL;
		_g_free0 (line);
		line = _tmp19_;
		_tmp20_ = line;
		if (!(_tmp20_ != NULL)) {
			_g_free0 (_tmp14_);
			break;
		}
		_tmp21_ = default_dev_re;
		_tmp22_ = line;
		_tmp24_ = g_regex_match (_tmp21_, _tmp22_, 0, &_tmp23_);
		_g_match_info_unref0 (match);
		match = _tmp23_;
		if (_tmp24_) {
			GMatchInfo* _tmp25_;
			gchar* _tmp26_;
			_tmp25_ = match;
			_tmp26_ = g_match_info_fetch (_tmp25_, 1);
			_g_free0 (recorded_dev);
			recorded_dev = _tmp26_;
			_g_free0 (_tmp14_);
			continue;
		}
		_tmp27_ = event_re;
		_tmp28_ = line;
		_tmp30_ = g_regex_match (_tmp27_, _tmp28_, 0, &_tmp29_);
		_g_match_info_unref0 (match);
		match = _tmp29_;
		if (!_tmp30_) {
			const gchar* _tmp31_;
			_tmp31_ = line;
			if (!g_str_has_prefix (_tmp31_, "#")) {
				const gchar* _tmp32_;
				_tmp32_ = line;
				g_warning ("umockdev.vala:909: Ignoring invalid line in %s: %s", eventsfile, _tmp32_);
			}
			_g_free0 (_tmp14_);
			continue;
		}
		_tmp33_ = match;
		_tmp34_ = g_match_info_fetch (_tmp33_, 1);
		_tmp35_ = _tmp34_;
		_tmp36_ = (time_t) uint64_parse (_tmp35_);
		_g_free0 (_tmp35_);
		ev_sec = _tmp36_;
		_tmp37_ = match;
		_tmp38_ = g_match_info_fetch (_tmp37_, 2);
		_tmp39_ = _tmp38_;
		_tmp40_ = (time_t) uint64_parse (_tmp39_);
		_g_free0 (_tmp39_);
		ev_usec = _tmp40_;
		if (first) {
			delay = 0;
			first = FALSE;
		} else {
			struct input_event _tmp41_;
			struct timeval _tmp42_;
			struct input_event _tmp43_;
			struct timeval _tmp44_;
			_tmp41_ = ev;
			_tmp42_ = _tmp41_.time;
			_tmp43_ = ev;
			_tmp44_ = _tmp43_.time;
			delay = (((gint) (ev_sec - _tmp42_.tv_sec)) * 1000) + (((gint) (ev_usec - _tmp44_.tv_usec)) / 1000);
			if (delay < 0) {
				delay = 0;
			}
		}
		ev.time.tv_sec = ev_sec;
		ev.time.tv_usec = (glong) ev_usec;
		_tmp45_ = match;
		_tmp46_ = g_match_info_fetch (_tmp45_, 3);
		_tmp47_ = _tmp46_;
		ev.type = (guint16) strtoul (_tmp47_, NULL, 16);
		_g_free0 (_tmp47_);
		_tmp48_ = match;
		_tmp49_ = g_match_info_fetch (_tmp48_, 4);
		_tmp50_ = _tmp49_;
		ev.code = (guint16) strtoul (_tmp50_, NULL, 16);
		_g_free0 (_tmp50_);
		_tmp51_ = match;
		_tmp52_ = g_match_info_fetch (_tmp51_, 5);
		_tmp53_ = _tmp52_;
		ev.value = (gint32) atoi (_tmp53_);
		_g_free0 (_tmp53_);
		_tmp54_ = g_new0 (guint8, sizeof (struct input_event));
		ev_data = _tmp54_;
		ev_data_length1 = sizeof (struct input_event);
		_ev_data_size_ = ev_data_length1;
		_tmp55_ = ev_data;
		_tmp55__length1 = ev_data_length1;
		_tmp56_ = ev_data;
		_tmp56__length1 = ev_data_length1;
		memcpy (_tmp55_, &ev, (gsize) _tmp56__length1);
		_tmp57_ = g_strdup_printf ("%i", delay);
		_tmp58_ = _tmp57_;
		_tmp59_ = g_strconcat ("r ", _tmp58_, NULL);
		_tmp60_ = _tmp59_;
		_tmp61_ = g_strconcat (_tmp60_, " ", NULL);
		_tmp62_ = _tmp61_;
		_tmp63_ = ev_data;
		_tmp63__length1 = ev_data_length1;
		_tmp64_ = umockdev_script_runner_encode (_tmp63_, (gint) _tmp63__length1);
		_tmp65_ = _tmp64_;
		_tmp66_ = g_strconcat (_tmp62_, _tmp65_, NULL);
		_tmp67_ = _tmp66_;
		_tmp68_ = g_strconcat (_tmp67_, "\n", NULL);
		_tmp69_ = _tmp68_;
		_g_free0 (_tmp67_);
		_g_free0 (_tmp65_);
		_g_free0 (_tmp62_);
		_g_free0 (_tmp60_);
		_g_free0 (_tmp58_);
		script_line = _tmp69_;
		_tmp70_ = script_line;
		_tmp71_ = script_line;
		_tmp72_ = strlen (_tmp71_);
		_tmp73_ = _tmp72_;
		_tmp74_ = script_line;
		_tmp75_ = strlen (_tmp74_);
		_tmp76_ = _tmp75_;
		_vala_assert (write (script_fd, _tmp70_, (gsize) _tmp73_) == ((gssize) _tmp76_), "Posix.write(script_fd, script_line, script_line.length) == script_line.length");
		_g_free0 (script_line);
		ev_data = (g_free (ev_data), NULL);
		_g_free0 (_tmp14_);
	}
	close (script_fd);
	_tmp77_ = g_strdup (dev);
	owned_dev = _tmp77_;
	_tmp78_ = owned_dev;
	if (_tmp78_ == NULL) {
		const gchar* _tmp79_;
		const gchar* _tmp80_;
		gchar* _tmp81_;
		_tmp79_ = recorded_dev;
		if (_tmp79_ == NULL) {
			g_error ("umockdev.vala:939: null passed for device node, but recording %s has n" \
"o '# device' header", eventsfile);
		}
		_tmp80_ = recorded_dev;
		_tmp81_ = g_strdup (_tmp80_);
		_g_free0 (owned_dev);
		owned_dev = _tmp81_;
	}
	_tmp82_ = owned_dev;
	_tmp83_ = script_file;
	ret = umockdev_testbed_load_script (self, _tmp82_, _tmp83_, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		gboolean _tmp84_ = FALSE;
		g_propagate_error (error, _inner_error0_);
		_g_free0 (owned_dev);
		_g_free0 (script_file);
		_g_regex_unref0 (event_re);
		_g_regex_unref0 (default_dev_re);
		_g_match_info_unref0 (match);
		_g_free0 (recorded_dev);
		_g_free0 (line);
		_g_object_unref0 (s_ev);
		_g_object_unref0 (_tmp1_);
		_g_object_unref0 (f_ev);
		return _tmp84_;
	}
	_tmp85_ = script_file;
	g_unlink (_tmp85_);
	result = ret;
	_g_free0 (owned_dev);
	_g_free0 (script_file);
	_g_regex_unref0 (event_re);
	_g_regex_unref0 (default_dev_re);
	_g_match_info_unref0 (match);
	_g_free0 (recorded_dev);
	_g_free0 (line);
	_g_object_unref0 (s_ev);
	_g_object_unref0 (_tmp1_);
	_g_object_unref0 (f_ev);
	return result;
}

static GHashTable*
umockdev_testbed_create_bus_lookup (void)
{
	GHashTable* lookup = NULL;
	GHashFunc _tmp0_;
	GEqualFunc _tmp1_;
	GHashTable* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	gchar* _tmp10_;
	gchar* _tmp11_;
	gchar* _tmp12_;
	gchar* _tmp13_;
	gchar* _tmp14_;
	gchar* _tmp15_;
	gchar* _tmp16_;
	gchar* _tmp17_;
	gchar* _tmp18_;
	gchar* _tmp19_;
	gchar* _tmp20_;
	gchar* _tmp21_;
	gchar* _tmp22_;
	gchar* _tmp23_;
	gchar* _tmp24_;
	gchar* _tmp25_;
	gchar* _tmp26_;
	gchar* _tmp27_;
	gchar* _tmp28_;
	gchar* _tmp29_;
	gchar* _tmp30_;
	gchar* _tmp31_;
	gchar* _tmp32_;
	gchar* _tmp33_;
	gchar* _tmp34_;
	gchar* _tmp35_;
	gchar* _tmp36_;
	gchar* _tmp37_;
	gchar* _tmp38_;
	gchar* _tmp39_;
	gchar* _tmp40_;
	gchar* _tmp41_;
	gchar* _tmp42_;
	gchar* _tmp43_;
	gchar* _tmp44_;
	gchar* _tmp45_;
	gchar* _tmp46_;
	gchar* _tmp47_;
	gchar* _tmp48_;
	gchar* _tmp49_;
	gchar* _tmp50_;
	gchar* _tmp51_;
	gchar* _tmp52_;
	gchar* _tmp53_;
	gchar* _tmp54_;
	gchar* _tmp55_;
	gchar* _tmp56_;
	gchar* _tmp57_;
	gchar* _tmp58_;
	gchar* _tmp59_;
	gchar* _tmp60_;
	gchar* _tmp61_;
	gchar* _tmp62_;
	gchar* _tmp63_;
	gchar* _tmp64_;
	gchar* _tmp65_;
	gchar* _tmp66_;
	gchar* _tmp67_;
	gchar* _tmp68_;
	gchar* _tmp69_;
	gchar* _tmp70_;
	gchar* _tmp71_;
	gchar* _tmp72_;
	gchar* _tmp73_;
	gchar* _tmp74_;
	gchar* _tmp75_;
	gchar* _tmp76_;
	gchar* _tmp77_;
	gchar* _tmp78_;
	gchar* _tmp79_;
	gchar* _tmp80_;
	gchar* _tmp81_;
	gchar* _tmp82_;
	gchar* _tmp83_;
	gchar* _tmp84_;
	gchar* _tmp85_;
	gchar* _tmp86_;
	gchar* _tmp87_;
	gchar* _tmp88_;
	gchar* _tmp89_;
	gchar* _tmp90_;
	gchar* _tmp91_;
	gchar* _tmp92_;
	gchar* _tmp93_;
	gchar* _tmp94_;
	gchar* _tmp95_;
	gchar* _tmp96_;
	gchar* _tmp97_;
	gchar* _tmp98_;
	gchar* _tmp99_;
	gchar* _tmp100_;
	gchar* _tmp101_;
	gchar* _tmp102_;
	gchar* _tmp103_;
	gchar* _tmp104_;
	gchar* _tmp105_;
	gchar* _tmp106_;
	gchar* _tmp107_;
	gchar* _tmp108_;
	gchar* _tmp109_;
	gchar* _tmp110_;
	gchar* _tmp111_;
	gchar* _tmp112_;
	gchar* _tmp113_;
	gchar* _tmp114_;
	gchar* _tmp115_;
	gchar* _tmp116_;
	gchar* _tmp117_;
	gchar* _tmp118_;
	gchar* _tmp119_;
	gchar* _tmp120_;
	gchar* _tmp121_;
	gchar* _tmp122_;
	gchar* _tmp123_;
	gchar* _tmp124_;
	gchar* _tmp125_;
	gchar* _tmp126_;
	gchar* _tmp127_;
	gchar* _tmp128_;
	gchar* _tmp129_;
	gchar* _tmp130_;
	gchar* _tmp131_;
	gchar* _tmp132_;
	GHashTable* result = NULL;
	_tmp0_ = g_str_hash;
	_tmp1_ = g_str_equal;
	_tmp2_ = g_hash_table_new_full (_tmp0_, _tmp1_, _g_free0_, _g_free0_);
	lookup = _tmp2_;
	_tmp3_ = g_strdup ("ac97");
	g_hash_table_insert (lookup, _tmp3_, NULL);
	_tmp4_ = g_strdup ("ac97bus");
	g_hash_table_insert (lookup, _tmp4_, NULL);
	_tmp5_ = g_strdup ("acpi");
	g_hash_table_insert (lookup, _tmp5_, NULL);
	_tmp6_ = g_strdup ("amba");
	g_hash_table_insert (lookup, _tmp6_, NULL);
	_tmp7_ = g_strdup ("anybuss");
	g_hash_table_insert (lookup, _tmp7_, NULL);
	_tmp8_ = g_strdup ("aoa-soundbus");
	g_hash_table_insert (lookup, _tmp8_, NULL);
	_tmp9_ = g_strdup ("ap");
	g_hash_table_insert (lookup, _tmp9_, NULL);
	_tmp10_ = g_strdup ("aprbus");
	g_hash_table_insert (lookup, _tmp10_, NULL);
	_tmp11_ = g_strdup ("bcma");
	g_hash_table_insert (lookup, _tmp11_, NULL);
	_tmp12_ = g_strdup ("bttv-sub");
	g_hash_table_insert (lookup, _tmp12_, NULL);
	_tmp13_ = g_strdup ("ccw");
	g_hash_table_insert (lookup, _tmp13_, NULL);
	_tmp14_ = g_strdup ("ccwgroup");
	g_hash_table_insert (lookup, _tmp14_, NULL);
	_tmp15_ = g_strdup ("cdmm");
	g_hash_table_insert (lookup, _tmp15_, NULL);
	_tmp16_ = g_strdup ("cec");
	g_hash_table_insert (lookup, _tmp16_, NULL);
	_tmp17_ = g_strdup ("coreboot");
	g_hash_table_insert (lookup, _tmp17_, NULL);
	_tmp18_ = g_strdup ("coresight");
	g_hash_table_insert (lookup, _tmp18_, NULL);
	_tmp19_ = g_strdup ("cosm_bus");
	g_hash_table_insert (lookup, _tmp19_, NULL);
	_tmp20_ = g_strdup ("counter");
	g_hash_table_insert (lookup, _tmp20_, NULL);
	_tmp21_ = g_strdup ("css");
	g_hash_table_insert (lookup, _tmp21_, NULL);
	_tmp22_ = g_strdup ("dax");
	g_hash_table_insert (lookup, _tmp22_, NULL);
	_tmp23_ = g_strdup ("dio");
	g_hash_table_insert (lookup, _tmp23_, NULL);
	_tmp24_ = g_strdup ("ecard");
	g_hash_table_insert (lookup, _tmp24_, NULL);
	_tmp25_ = g_strdup ("eisa");
	g_hash_table_insert (lookup, _tmp25_, NULL);
	_tmp26_ = g_strdup ("event_source");
	g_hash_table_insert (lookup, _tmp26_, NULL);
	_tmp27_ = g_strdup ("fcoe");
	g_hash_table_insert (lookup, _tmp27_, NULL);
	_tmp28_ = g_strdup ("firewire");
	g_hash_table_insert (lookup, _tmp28_, NULL);
	_tmp29_ = g_strdup ("fsi");
	g_hash_table_insert (lookup, _tmp29_, NULL);
	_tmp30_ = g_strdup ("fsl-mc");
	g_hash_table_insert (lookup, _tmp30_, NULL);
	_tmp31_ = g_strdup ("gameport");
	g_hash_table_insert (lookup, _tmp31_, NULL);
	_tmp32_ = g_strdup ("gbphy");
	g_hash_table_insert (lookup, _tmp32_, NULL);
	_tmp33_ = g_strdup ("genpd");
	g_hash_table_insert (lookup, _tmp33_, NULL);
	_tmp34_ = g_strdup ("gio");
	g_hash_table_insert (lookup, _tmp34_, NULL);
	_tmp35_ = g_strdup ("gpio");
	g_hash_table_insert (lookup, _tmp35_, NULL);
	_tmp36_ = g_strdup ("greybus");
	g_hash_table_insert (lookup, _tmp36_, NULL);
	_tmp37_ = g_strdup ("hdaudio");
	g_hash_table_insert (lookup, _tmp37_, NULL);
	_tmp38_ = g_strdup ("hid");
	g_hash_table_insert (lookup, _tmp38_, NULL);
	_tmp39_ = g_strdup ("host1x");
	g_hash_table_insert (lookup, _tmp39_, NULL);
	_tmp40_ = g_strdup ("hsi");
	g_hash_table_insert (lookup, _tmp40_, NULL);
	_tmp41_ = g_strdup ("i2c");
	g_hash_table_insert (lookup, _tmp41_, NULL);
	_tmp42_ = g_strdup ("i3c");
	g_hash_table_insert (lookup, _tmp42_, NULL);
	_tmp43_ = g_strdup ("ibmebus");
	g_hash_table_insert (lookup, _tmp43_, NULL);
	_tmp44_ = g_strdup ("ide");
	g_hash_table_insert (lookup, _tmp44_, NULL);
	_tmp45_ = g_strdup ("iio");
	g_hash_table_insert (lookup, _tmp45_, NULL);
	_tmp46_ = g_strdup ("iio");
	g_hash_table_insert (lookup, _tmp46_, NULL);
	_tmp47_ = g_strdup ("intel_th");
	g_hash_table_insert (lookup, _tmp47_, NULL);
	_tmp48_ = g_strdup ("ipack");
	g_hash_table_insert (lookup, _tmp48_, NULL);
	_tmp49_ = g_strdup ("isa");
	g_hash_table_insert (lookup, _tmp49_, NULL);
	_tmp50_ = g_strdup ("iscsi_flashnode");
	g_hash_table_insert (lookup, _tmp50_, NULL);
	_tmp51_ = g_strdup ("ishtp");
	g_hash_table_insert (lookup, _tmp51_, NULL);
	_tmp52_ = g_strdup ("iucv");
	g_hash_table_insert (lookup, _tmp52_, NULL);
	_tmp53_ = g_strdup ("locomo-bus");
	g_hash_table_insert (lookup, _tmp53_, NULL);
	_tmp54_ = g_strdup ("logicmodule");
	g_hash_table_insert (lookup, _tmp54_, NULL);
	_tmp55_ = g_strdup ("macio");
	g_hash_table_insert (lookup, _tmp55_, NULL);
	_tmp56_ = g_strdup ("maple");
	g_hash_table_insert (lookup, _tmp56_, NULL);
	_tmp57_ = g_strdup ("matrix");
	g_hash_table_insert (lookup, _tmp57_, NULL);
	_tmp58_ = g_strdup ("mcb");
	g_hash_table_insert (lookup, _tmp58_, NULL);
	_tmp59_ = g_strdup ("mcp");
	g_hash_table_insert (lookup, _tmp59_, NULL);
	_tmp60_ = g_strdup ("mdev");
	g_hash_table_insert (lookup, _tmp60_, NULL);
	_tmp61_ = g_strdup ("mdio_bus");
	g_hash_table_insert (lookup, _tmp61_, NULL);
	_tmp62_ = g_strdup ("media");
	g_hash_table_insert (lookup, _tmp62_, NULL);
	_tmp63_ = g_strdup ("mei");
	g_hash_table_insert (lookup, _tmp63_, NULL);
	_tmp64_ = g_strdup ("memstick");
	g_hash_table_insert (lookup, _tmp64_, NULL);
	_tmp65_ = g_strdup ("mic_bus");
	g_hash_table_insert (lookup, _tmp65_, NULL);
	_tmp66_ = g_strdup ("mipi-dsi");
	g_hash_table_insert (lookup, _tmp66_, NULL);
	_tmp67_ = g_strdup ("mmc_rpmb");
	g_hash_table_insert (lookup, _tmp67_, NULL);
	_tmp68_ = g_strdup ("mmc");
	g_hash_table_insert (lookup, _tmp68_, NULL);
	_tmp69_ = g_strdup ("most");
	g_hash_table_insert (lookup, _tmp69_, NULL);
	_tmp70_ = g_strdup ("nd");
	g_hash_table_insert (lookup, _tmp70_, NULL);
	_tmp71_ = g_strdup ("netdevsim");
	g_hash_table_insert (lookup, _tmp71_, NULL);
	_tmp72_ = g_strdup ("ntb_transport");
	g_hash_table_insert (lookup, _tmp72_, NULL);
	_tmp73_ = g_strdup ("ntb");
	g_hash_table_insert (lookup, _tmp73_, NULL);
	_tmp74_ = g_strdup ("nubus");
	g_hash_table_insert (lookup, _tmp74_, NULL);
	_tmp75_ = g_strdup ("nvmem");
	g_hash_table_insert (lookup, _tmp75_, NULL);
	_tmp76_ = g_strdup ("parisc");
	g_hash_table_insert (lookup, _tmp76_, NULL);
	_tmp77_ = g_strdup ("parport");
	g_hash_table_insert (lookup, _tmp77_, NULL);
	_tmp78_ = g_strdup ("pci-epf");
	g_hash_table_insert (lookup, _tmp78_, NULL);
	_tmp79_ = g_strdup ("pci");
	g_hash_table_insert (lookup, _tmp79_, NULL);
	_tmp80_ = g_strdup ("pcmcia");
	g_hash_table_insert (lookup, _tmp80_, NULL);
	_tmp81_ = g_strdup ("platform");
	g_hash_table_insert (lookup, _tmp81_, NULL);
	_tmp82_ = g_strdup ("pnp");
	g_hash_table_insert (lookup, _tmp82_, NULL);
	_tmp83_ = g_strdup ("ps3_system_bus");
	g_hash_table_insert (lookup, _tmp83_, NULL);
	_tmp84_ = g_strdup ("pseudo");
	g_hash_table_insert (lookup, _tmp84_, NULL);
	_tmp85_ = g_strdup ("rapidio");
	g_hash_table_insert (lookup, _tmp85_, NULL);
	_tmp86_ = g_strdup ("rbd");
	g_hash_table_insert (lookup, _tmp86_, NULL);
	_tmp87_ = g_strdup ("rmi4");
	g_hash_table_insert (lookup, _tmp87_, NULL);
	_tmp88_ = g_strdup ("rpmsg");
	g_hash_table_insert (lookup, _tmp88_, NULL);
	_tmp89_ = g_strdup ("sa1111-rab");
	g_hash_table_insert (lookup, _tmp89_, NULL);
	_tmp90_ = g_strdup ("scif_bus");
	g_hash_table_insert (lookup, _tmp90_, NULL);
	_tmp91_ = g_strdup ("scif_peer_bus");
	g_hash_table_insert (lookup, _tmp91_, NULL);
	_tmp92_ = g_strdup ("scm");
	g_hash_table_insert (lookup, _tmp92_, NULL);
	_tmp93_ = g_strdup ("scmi_protocol");
	g_hash_table_insert (lookup, _tmp93_, NULL);
	_tmp94_ = g_strdup ("scsi");
	g_hash_table_insert (lookup, _tmp94_, NULL);
	_tmp95_ = g_strdup ("sdio");
	g_hash_table_insert (lookup, _tmp95_, NULL);
	_tmp96_ = g_strdup ("serial");
	g_hash_table_insert (lookup, _tmp96_, NULL);
	_tmp97_ = g_strdup ("serio");
	g_hash_table_insert (lookup, _tmp97_, NULL);
	_tmp98_ = g_strdup ("siox");
	g_hash_table_insert (lookup, _tmp98_, NULL);
	_tmp99_ = g_strdup ("slimbus");
	g_hash_table_insert (lookup, _tmp99_, NULL);
	_tmp100_ = g_strdup ("snd_seq");
	g_hash_table_insert (lookup, _tmp100_, NULL);
	_tmp101_ = g_strdup ("soc");
	g_hash_table_insert (lookup, _tmp101_, NULL);
	_tmp102_ = g_strdup ("soundwire");
	g_hash_table_insert (lookup, _tmp102_, NULL);
	_tmp103_ = g_strdup ("spi");
	g_hash_table_insert (lookup, _tmp103_, NULL);
	_tmp104_ = g_strdup ("spmi");
	g_hash_table_insert (lookup, _tmp104_, NULL);
	_tmp105_ = g_strdup ("ssb");
	g_hash_table_insert (lookup, _tmp105_, NULL);
	_tmp106_ = g_strdup ("sunxi-rsb");
	g_hash_table_insert (lookup, _tmp106_, NULL);
	_tmp107_ = g_strdup ("superhyway");
	g_hash_table_insert (lookup, _tmp107_, NULL);
	_tmp108_ = g_strdup ("tc");
	g_hash_table_insert (lookup, _tmp108_, NULL);
	_tmp109_ = g_strdup ("tcm_loop_bus");
	g_hash_table_insert (lookup, _tmp109_, NULL);
	_tmp110_ = g_strdup ("tee");
	g_hash_table_insert (lookup, _tmp110_, NULL);
	_tmp111_ = g_strdup ("thunderbolt");
	g_hash_table_insert (lookup, _tmp111_, NULL);
	_tmp112_ = g_strdup ("tifm");
	g_hash_table_insert (lookup, _tmp112_, NULL);
	_tmp113_ = g_strdup ("tiocx");
	g_hash_table_insert (lookup, _tmp113_, NULL);
	_tmp114_ = g_strdup ("typec");
	g_hash_table_insert (lookup, _tmp114_, NULL);
	_tmp115_ = g_strdup ("ulpi");
	g_hash_table_insert (lookup, _tmp115_, NULL);
	_tmp116_ = g_strdup ("umc");
	g_hash_table_insert (lookup, _tmp116_, NULL);
	_tmp117_ = g_strdup ("usb-serial");
	g_hash_table_insert (lookup, _tmp117_, NULL);
	_tmp118_ = g_strdup ("usb");
	g_hash_table_insert (lookup, _tmp118_, NULL);
	_tmp119_ = g_strdup ("usb");
	g_hash_table_insert (lookup, _tmp119_, NULL);
	_tmp120_ = g_strdup ("uwb");
	g_hash_table_insert (lookup, _tmp120_, NULL);
	_tmp121_ = g_strdup ("vio");
	g_hash_table_insert (lookup, _tmp121_, NULL);
	_tmp122_ = g_strdup ("virtio");
	g_hash_table_insert (lookup, _tmp122_, NULL);
	_tmp123_ = g_strdup ("visorbus");
	g_hash_table_insert (lookup, _tmp123_, NULL);
	_tmp124_ = g_strdup ("vlynq");
	g_hash_table_insert (lookup, _tmp124_, NULL);
	_tmp125_ = g_strdup ("vmbus");
	g_hash_table_insert (lookup, _tmp125_, NULL);
	_tmp126_ = g_strdup ("vme");
	g_hash_table_insert (lookup, _tmp126_, NULL);
	_tmp127_ = g_strdup ("vop_bus");
	g_hash_table_insert (lookup, _tmp127_, NULL);
	_tmp128_ = g_strdup ("w1");
	g_hash_table_insert (lookup, _tmp128_, NULL);
	_tmp129_ = g_strdup ("wmi_bus");
	g_hash_table_insert (lookup, _tmp129_, NULL);
	_tmp130_ = g_strdup ("xen-backend");
	g_hash_table_insert (lookup, _tmp130_, NULL);
	_tmp131_ = g_strdup ("xen");
	g_hash_table_insert (lookup, _tmp131_, NULL);
	_tmp132_ = g_strdup ("zorro");
	g_hash_table_insert (lookup, _tmp132_, NULL);
	result = lookup;
	return result;
}

static gboolean
umockdev_testbed_subsystem_is_bus (const gchar* subsystem)
{
	GHashTable* _tmp0_;
	GHashTable* _tmp2_;
	gboolean result = FALSE;
	g_return_val_if_fail (subsystem != NULL, FALSE);
	_tmp0_ = umockdev_testbed_bus_lookup_table;
	if (_tmp0_ == NULL) {
		GHashTable* _tmp1_;
		_tmp1_ = umockdev_testbed_create_bus_lookup ();
		_g_hash_table_unref0 (umockdev_testbed_bus_lookup_table);
		umockdev_testbed_bus_lookup_table = _tmp1_;
	}
	_tmp2_ = umockdev_testbed_bus_lookup_table;
	result = g_hash_table_contains (_tmp2_, subsystem);
	return result;
}

static void
_vala_array_add3 (gchar** * array,
                  int* length,
                  int* size,
                  gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static void
_vala_array_add4 (gchar** * array,
                  int* length,
                  int* size,
                  gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static void
_vala_array_add5 (gchar** * array,
                  int* length,
                  int* size,
                  gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static void
_vala_array_add6 (gchar** * array,
                  int* length,
                  int* size,
                  gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static void
_vala_array_add7 (gchar** * array,
                  int* length,
                  int* size,
                  gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static void
_vala_array_add8 (gchar** * array,
                  int* length,
                  int* size,
                  gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static void
_vala_array_add9 (gchar** * array,
                  int* length,
                  int* size,
                  gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static void
_vala_array_add10 (gchar** * array,
                   int* length,
                   int* size,
                   gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static void
_vala_array_add11 (gchar** * array,
                   int* length,
                   int* size,
                   gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static gchar*
umockdev_testbed_add_dev_from_string (UMockdevTestbed* self,
                                      const gchar* data,
                                      GError** error)
{
	gchar type = '\0';
	gchar* key = NULL;
	gchar* val = NULL;
	gchar* devpath = NULL;
	gchar* subsystem = NULL;
	gchar* majmin = NULL;
	gchar* cur_data = NULL;
	gchar* _tmp0_;
	gchar* devnode_path = NULL;
	guint8* devnode_contents = NULL;
	guint8* _tmp1_;
	gint devnode_contents_length1;
	gint _devnode_contents_size_;
	gchar** devnode_links = NULL;
	gchar** _tmp2_;
	gint devnode_links_length1;
	gint _devnode_links_size_;
	const gchar* _tmp3_;
	gchar _tmp4_ = '\0';
	gchar* _tmp5_ = NULL;
	gchar* _tmp6_ = NULL;
	gchar* _tmp7_;
	gboolean _tmp8_ = FALSE;
	const gchar* _tmp9_;
	const gchar* _tmp11_;
	const gchar* _tmp14_;
	gchar** attrs = NULL;
	gchar** _tmp15_;
	gint attrs_length1;
	gint _attrs_size_;
	gchar** binattrs = NULL;
	gchar** _tmp16_;
	gint binattrs_length1;
	gint _binattrs_size_;
	gchar** linkattrs = NULL;
	gchar** _tmp17_;
	gint linkattrs_length1;
	gint _linkattrs_size_;
	gchar** props = NULL;
	gchar** _tmp18_;
	gint props_length1;
	gint _props_size_;
	const gchar* _tmp86_;
	const gchar* _tmp89_;
	const gchar* _tmp90_;
	gchar* syspath = NULL;
	const gchar* _tmp91_;
	const gchar* _tmp92_;
	gchar* _tmp93_;
	gchar* _tmp94_;
	gchar** _tmp95_;
	gint _tmp95__length1;
	gchar** _tmp96_;
	gint _tmp96__length1;
	gchar* _tmp97_;
	gchar* _tmp98_;
	const gchar* _tmp116_;
	GError* _inner_error0_ = NULL;
	gchar* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (data != NULL, NULL);
	devpath = NULL;
	subsystem = NULL;
	majmin = NULL;
	_tmp0_ = g_strdup (data);
	cur_data = _tmp0_;
	devnode_path = NULL;
	_tmp1_ = g_new0 (guint8, 0);
	devnode_contents = _tmp1_;
	devnode_contents_length1 = 0;
	_devnode_contents_size_ = devnode_contents_length1;
	_tmp2_ = g_new0 (gchar*, 0 + 1);
	devnode_links = _tmp2_;
	devnode_links_length1 = 0;
	_devnode_links_size_ = devnode_links_length1;
	_tmp3_ = cur_data;
	_tmp7_ = umockdev_testbed_record_parse_line (self, _tmp3_, &_tmp4_, &_tmp5_, &_tmp6_);
	type = _tmp4_;
	_g_free0 (key);
	key = _tmp5_;
	_g_free0 (devpath);
	devpath = _tmp6_;
	_g_free0 (cur_data);
	cur_data = _tmp7_;
	_tmp9_ = cur_data;
	if (_tmp9_ == NULL) {
		_tmp8_ = TRUE;
	} else {
		_tmp8_ = type != 'P';
	}
	if (_tmp8_) {
		GError* _tmp10_;
		_tmp10_ = g_error_new_literal (UMOCKDEV_ERROR, UMOCKDEV_ERROR_PARSE, "device descriptions must start with a \"P: /devices/path/...\" line");
		_inner_error0_ = _tmp10_;
		if (_inner_error0_->domain == UMOCKDEV_ERROR) {
			g_propagate_error (error, _inner_error0_);
			devnode_links = (_vala_array_free (devnode_links, devnode_links_length1, (GDestroyNotify) g_free), NULL);
			devnode_contents = (g_free (devnode_contents), NULL);
			_g_free0 (devnode_path);
			_g_free0 (cur_data);
			_g_free0 (majmin);
			_g_free0 (subsystem);
			_g_free0 (devpath);
			_g_free0 (val);
			_g_free0 (key);
			return NULL;
		} else {
			devnode_links = (_vala_array_free (devnode_links, devnode_links_length1, (GDestroyNotify) g_free), NULL);
			devnode_contents = (g_free (devnode_contents), NULL);
			_g_free0 (devnode_path);
			_g_free0 (cur_data);
			_g_free0 (majmin);
			_g_free0 (subsystem);
			_g_free0 (devpath);
			_g_free0 (val);
			_g_free0 (key);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	_tmp11_ = devpath;
	if (!g_str_has_prefix (_tmp11_, "/devices/")) {
		const gchar* _tmp12_;
		GError* _tmp13_;
		_tmp12_ = devpath;
		_tmp13_ = g_error_new (UMOCKDEV_ERROR, UMOCKDEV_ERROR_VALUE, "invalid device path '%s': must start with /devices/", _tmp12_);
		_inner_error0_ = _tmp13_;
		if (_inner_error0_->domain == UMOCKDEV_ERROR) {
			g_propagate_error (error, _inner_error0_);
			devnode_links = (_vala_array_free (devnode_links, devnode_links_length1, (GDestroyNotify) g_free), NULL);
			devnode_contents = (g_free (devnode_contents), NULL);
			_g_free0 (devnode_path);
			_g_free0 (cur_data);
			_g_free0 (majmin);
			_g_free0 (subsystem);
			_g_free0 (devpath);
			_g_free0 (val);
			_g_free0 (key);
			return NULL;
		} else {
			devnode_links = (_vala_array_free (devnode_links, devnode_links_length1, (GDestroyNotify) g_free), NULL);
			devnode_contents = (g_free (devnode_contents), NULL);
			_g_free0 (devnode_path);
			_g_free0 (cur_data);
			_g_free0 (majmin);
			_g_free0 (subsystem);
			_g_free0 (devpath);
			_g_free0 (val);
			_g_free0 (key);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	_tmp14_ = devpath;
	g_debug ("umockdev.vala:1115: parsing device description for %s", _tmp14_);
	_tmp15_ = g_new0 (gchar*, 0 + 1);
	attrs = _tmp15_;
	attrs_length1 = 0;
	_attrs_size_ = attrs_length1;
	_tmp16_ = g_new0 (gchar*, 0 + 1);
	binattrs = _tmp16_;
	binattrs_length1 = 0;
	_binattrs_size_ = binattrs_length1;
	_tmp17_ = g_new0 (gchar*, 0 + 1);
	linkattrs = _tmp17_;
	linkattrs_length1 = 0;
	_linkattrs_size_ = linkattrs_length1;
	_tmp18_ = g_new0 (gchar*, 0 + 1);
	props = _tmp18_;
	props_length1 = 0;
	_props_size_ = props_length1;
	while (TRUE) {
		gboolean _tmp19_ = FALSE;
		const gchar* _tmp20_;
		gint _tmp21_;
		gint _tmp22_;
		const gchar* _tmp24_;
		gchar _tmp25_ = '\0';
		gchar* _tmp26_ = NULL;
		gchar* _tmp27_ = NULL;
		gchar* _tmp28_;
		const gchar* _tmp29_;
		_tmp20_ = cur_data;
		_tmp21_ = strlen (_tmp20_);
		_tmp22_ = _tmp21_;
		if (_tmp22_ > 0) {
			const gchar* _tmp23_;
			_tmp23_ = cur_data;
			_tmp19_ = string_get (_tmp23_, (glong) 0) != '\n';
		} else {
			_tmp19_ = FALSE;
		}
		if (!_tmp19_) {
			break;
		}
		_tmp24_ = cur_data;
		_tmp28_ = umockdev_testbed_record_parse_line (self, _tmp24_, &_tmp25_, &_tmp26_, &_tmp27_);
		type = _tmp25_;
		_g_free0 (key);
		key = _tmp26_;
		_g_free0 (val);
		val = _tmp27_;
		_g_free0 (cur_data);
		cur_data = _tmp28_;
		_tmp29_ = cur_data;
		if (_tmp29_ == NULL) {
			const gchar* _tmp30_;
			GError* _tmp31_;
			_tmp30_ = devpath;
			_tmp31_ = g_error_new (UMOCKDEV_ERROR, UMOCKDEV_ERROR_PARSE, "malformed attribute or property line in description of device %s", _tmp30_);
			_inner_error0_ = _tmp31_;
			if (_inner_error0_->domain == UMOCKDEV_ERROR) {
				g_propagate_error (error, _inner_error0_);
				props = (_vala_array_free (props, props_length1, (GDestroyNotify) g_free), NULL);
				linkattrs = (_vala_array_free (linkattrs, linkattrs_length1, (GDestroyNotify) g_free), NULL);
				binattrs = (_vala_array_free (binattrs, binattrs_length1, (GDestroyNotify) g_free), NULL);
				attrs = (_vala_array_free (attrs, attrs_length1, (GDestroyNotify) g_free), NULL);
				devnode_links = (_vala_array_free (devnode_links, devnode_links_length1, (GDestroyNotify) g_free), NULL);
				devnode_contents = (g_free (devnode_contents), NULL);
				_g_free0 (devnode_path);
				_g_free0 (cur_data);
				_g_free0 (majmin);
				_g_free0 (subsystem);
				_g_free0 (devpath);
				_g_free0 (val);
				_g_free0 (key);
				return NULL;
			} else {
				props = (_vala_array_free (props, props_length1, (GDestroyNotify) g_free), NULL);
				linkattrs = (_vala_array_free (linkattrs, linkattrs_length1, (GDestroyNotify) g_free), NULL);
				binattrs = (_vala_array_free (binattrs, binattrs_length1, (GDestroyNotify) g_free), NULL);
				attrs = (_vala_array_free (attrs, attrs_length1, (GDestroyNotify) g_free), NULL);
				devnode_links = (_vala_array_free (devnode_links, devnode_links_length1, (GDestroyNotify) g_free), NULL);
				devnode_contents = (g_free (devnode_contents), NULL);
				_g_free0 (devnode_path);
				_g_free0 (cur_data);
				_g_free0 (majmin);
				_g_free0 (subsystem);
				_g_free0 (devpath);
				_g_free0 (val);
				_g_free0 (key);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return NULL;
			}
		}
		switch (type) {
			case 'H':
			{
				gchar** _tmp32_;
				gint _tmp32__length1;
				const gchar* _tmp33_;
				gchar* _tmp34_;
				gchar** _tmp35_;
				gint _tmp35__length1;
				const gchar* _tmp36_;
				gchar* _tmp37_;
				_tmp32_ = binattrs;
				_tmp32__length1 = binattrs_length1;
				_tmp33_ = key;
				_tmp34_ = g_strdup (_tmp33_);
				_vala_array_add3 (&binattrs, &binattrs_length1, &_binattrs_size_, _tmp34_);
				_tmp35_ = binattrs;
				_tmp35__length1 = binattrs_length1;
				_tmp36_ = val;
				_tmp37_ = g_strdup (_tmp36_);
				_vala_array_add4 (&binattrs, &binattrs_length1, &_binattrs_size_, _tmp37_);
				break;
			}
			case 'A':
			{
				gchar** _tmp38_;
				gint _tmp38__length1;
				const gchar* _tmp39_;
				gchar* _tmp40_;
				const gchar* _tmp41_;
				gchar* _tmp42_;
				gchar** _tmp43_;
				gint _tmp43__length1;
				const gchar* _tmp44_;
				gchar* _tmp45_;
				const gchar* _tmp46_;
				_tmp38_ = attrs;
				_tmp38__length1 = attrs_length1;
				_tmp39_ = key;
				_tmp40_ = g_strdup (_tmp39_);
				_vala_array_add5 (&attrs, &attrs_length1, &_attrs_size_, _tmp40_);
				_tmp41_ = val;
				_tmp42_ = g_strcompress (_tmp41_);
				_g_free0 (val);
				val = _tmp42_;
				_tmp43_ = attrs;
				_tmp43__length1 = attrs_length1;
				_tmp44_ = val;
				_tmp45_ = g_strdup (_tmp44_);
				_vala_array_add6 (&attrs, &attrs_length1, &_attrs_size_, _tmp45_);
				_tmp46_ = key;
				if (g_strcmp0 (_tmp46_, "dev") == 0) {
					const gchar* _tmp47_;
					gchar* _tmp48_;
					_tmp47_ = val;
					_tmp48_ = g_strdup (_tmp47_);
					_g_free0 (majmin);
					majmin = _tmp48_;
				}
				break;
			}
			case 'L':
			{
				gchar** _tmp49_;
				gint _tmp49__length1;
				const gchar* _tmp50_;
				gchar* _tmp51_;
				gchar** _tmp52_;
				gint _tmp52__length1;
				const gchar* _tmp53_;
				gchar* _tmp54_;
				_tmp49_ = linkattrs;
				_tmp49__length1 = linkattrs_length1;
				_tmp50_ = key;
				_tmp51_ = g_strdup (_tmp50_);
				_vala_array_add7 (&linkattrs, &linkattrs_length1, &_linkattrs_size_, _tmp51_);
				_tmp52_ = linkattrs;
				_tmp52__length1 = linkattrs_length1;
				_tmp53_ = val;
				_tmp54_ = g_strdup (_tmp53_);
				_vala_array_add8 (&linkattrs, &linkattrs_length1, &_linkattrs_size_, _tmp54_);
				break;
			}
			case 'E':
			{
				gchar** _tmp55_;
				gint _tmp55__length1;
				const gchar* _tmp56_;
				gchar* _tmp57_;
				gchar** _tmp58_;
				gint _tmp58__length1;
				const gchar* _tmp59_;
				gchar* _tmp60_;
				const gchar* _tmp61_;
				_tmp55_ = props;
				_tmp55__length1 = props_length1;
				_tmp56_ = key;
				_tmp57_ = g_strdup (_tmp56_);
				_vala_array_add9 (&props, &props_length1, &_props_size_, _tmp57_);
				_tmp58_ = props;
				_tmp58__length1 = props_length1;
				_tmp59_ = val;
				_tmp60_ = g_strdup (_tmp59_);
				_vala_array_add10 (&props, &props_length1, &_props_size_, _tmp60_);
				_tmp61_ = key;
				if (g_strcmp0 (_tmp61_, "SUBSYSTEM") == 0) {
					const gchar* _tmp62_;
					const gchar* _tmp65_;
					gchar* _tmp66_;
					_tmp62_ = subsystem;
					if (_tmp62_ != NULL) {
						const gchar* _tmp63_;
						GError* _tmp64_;
						_tmp63_ = devpath;
						_tmp64_ = g_error_new (UMOCKDEV_ERROR, UMOCKDEV_ERROR_VALUE, "duplicate SUBSYSTEM property in description of device %s", _tmp63_);
						_inner_error0_ = _tmp64_;
						if (_inner_error0_->domain == UMOCKDEV_ERROR) {
							g_propagate_error (error, _inner_error0_);
							props = (_vala_array_free (props, props_length1, (GDestroyNotify) g_free), NULL);
							linkattrs = (_vala_array_free (linkattrs, linkattrs_length1, (GDestroyNotify) g_free), NULL);
							binattrs = (_vala_array_free (binattrs, binattrs_length1, (GDestroyNotify) g_free), NULL);
							attrs = (_vala_array_free (attrs, attrs_length1, (GDestroyNotify) g_free), NULL);
							devnode_links = (_vala_array_free (devnode_links, devnode_links_length1, (GDestroyNotify) g_free), NULL);
							devnode_contents = (g_free (devnode_contents), NULL);
							_g_free0 (devnode_path);
							_g_free0 (cur_data);
							_g_free0 (majmin);
							_g_free0 (subsystem);
							_g_free0 (devpath);
							_g_free0 (val);
							_g_free0 (key);
							return NULL;
						} else {
							props = (_vala_array_free (props, props_length1, (GDestroyNotify) g_free), NULL);
							linkattrs = (_vala_array_free (linkattrs, linkattrs_length1, (GDestroyNotify) g_free), NULL);
							binattrs = (_vala_array_free (binattrs, binattrs_length1, (GDestroyNotify) g_free), NULL);
							attrs = (_vala_array_free (attrs, attrs_length1, (GDestroyNotify) g_free), NULL);
							devnode_links = (_vala_array_free (devnode_links, devnode_links_length1, (GDestroyNotify) g_free), NULL);
							devnode_contents = (g_free (devnode_contents), NULL);
							_g_free0 (devnode_path);
							_g_free0 (cur_data);
							_g_free0 (majmin);
							_g_free0 (subsystem);
							_g_free0 (devpath);
							_g_free0 (val);
							_g_free0 (key);
							g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
							g_clear_error (&_inner_error0_);
							return NULL;
						}
					}
					_tmp65_ = val;
					_tmp66_ = g_strdup (_tmp65_);
					_g_free0 (subsystem);
					subsystem = _tmp66_;
				}
				break;
			}
			case 'P':
			{
				const gchar* _tmp67_;
				GError* _tmp68_;
				_tmp67_ = devpath;
				_tmp68_ = g_error_new (UMOCKDEV_ERROR, UMOCKDEV_ERROR_PARSE, "invalid P: line in description of device %s", _tmp67_);
				_inner_error0_ = _tmp68_;
				if (_inner_error0_->domain == UMOCKDEV_ERROR) {
					g_propagate_error (error, _inner_error0_);
					props = (_vala_array_free (props, props_length1, (GDestroyNotify) g_free), NULL);
					linkattrs = (_vala_array_free (linkattrs, linkattrs_length1, (GDestroyNotify) g_free), NULL);
					binattrs = (_vala_array_free (binattrs, binattrs_length1, (GDestroyNotify) g_free), NULL);
					attrs = (_vala_array_free (attrs, attrs_length1, (GDestroyNotify) g_free), NULL);
					devnode_links = (_vala_array_free (devnode_links, devnode_links_length1, (GDestroyNotify) g_free), NULL);
					devnode_contents = (g_free (devnode_contents), NULL);
					_g_free0 (devnode_path);
					_g_free0 (cur_data);
					_g_free0 (majmin);
					_g_free0 (subsystem);
					_g_free0 (devpath);
					_g_free0 (val);
					_g_free0 (key);
					return NULL;
				} else {
					props = (_vala_array_free (props, props_length1, (GDestroyNotify) g_free), NULL);
					linkattrs = (_vala_array_free (linkattrs, linkattrs_length1, (GDestroyNotify) g_free), NULL);
					binattrs = (_vala_array_free (binattrs, binattrs_length1, (GDestroyNotify) g_free), NULL);
					attrs = (_vala_array_free (attrs, attrs_length1, (GDestroyNotify) g_free), NULL);
					devnode_links = (_vala_array_free (devnode_links, devnode_links_length1, (GDestroyNotify) g_free), NULL);
					devnode_contents = (g_free (devnode_contents), NULL);
					_g_free0 (devnode_path);
					_g_free0 (cur_data);
					_g_free0 (majmin);
					_g_free0 (subsystem);
					_g_free0 (devpath);
					_g_free0 (val);
					_g_free0 (key);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
					g_clear_error (&_inner_error0_);
					return NULL;
				}
			}
			case 'N':
			{
				const gchar* _tmp69_;
				const gchar* _tmp70_;
				gchar* _tmp71_;
				const gchar* _tmp72_;
				_tmp69_ = self->priv->root_dir;
				_tmp70_ = key;
				_tmp71_ = g_build_filename (_tmp69_, "dev", _tmp70_, NULL);
				_g_free0 (devnode_path);
				devnode_path = _tmp71_;
				_tmp72_ = val;
				if (_tmp72_ != NULL) {
					guint8* _tmp73_ = NULL;
					const gchar* _tmp74_;
					gint _tmp75_ = 0;
					guint8* _tmp76_;
					gint _tmp73__length1;
					gint __tmp73__size_;
					guint8* _tmp77_;
					gint _tmp77__length1;
					_tmp74_ = val;
					_tmp76_ = umockdev_decode_hex (_tmp74_, &_tmp75_, &_inner_error0_);
					_tmp73_ = _tmp76_;
					_tmp73__length1 = _tmp75_;
					__tmp73__size_ = _tmp73__length1;
					if (G_UNLIKELY (_inner_error0_ != NULL)) {
						if (_inner_error0_->domain == UMOCKDEV_ERROR) {
							g_propagate_error (error, _inner_error0_);
							props = (_vala_array_free (props, props_length1, (GDestroyNotify) g_free), NULL);
							linkattrs = (_vala_array_free (linkattrs, linkattrs_length1, (GDestroyNotify) g_free), NULL);
							binattrs = (_vala_array_free (binattrs, binattrs_length1, (GDestroyNotify) g_free), NULL);
							attrs = (_vala_array_free (attrs, attrs_length1, (GDestroyNotify) g_free), NULL);
							devnode_links = (_vala_array_free (devnode_links, devnode_links_length1, (GDestroyNotify) g_free), NULL);
							devnode_contents = (g_free (devnode_contents), NULL);
							_g_free0 (devnode_path);
							_g_free0 (cur_data);
							_g_free0 (majmin);
							_g_free0 (subsystem);
							_g_free0 (devpath);
							_g_free0 (val);
							_g_free0 (key);
							return NULL;
						} else {
							props = (_vala_array_free (props, props_length1, (GDestroyNotify) g_free), NULL);
							linkattrs = (_vala_array_free (linkattrs, linkattrs_length1, (GDestroyNotify) g_free), NULL);
							binattrs = (_vala_array_free (binattrs, binattrs_length1, (GDestroyNotify) g_free), NULL);
							attrs = (_vala_array_free (attrs, attrs_length1, (GDestroyNotify) g_free), NULL);
							devnode_links = (_vala_array_free (devnode_links, devnode_links_length1, (GDestroyNotify) g_free), NULL);
							devnode_contents = (g_free (devnode_contents), NULL);
							_g_free0 (devnode_path);
							_g_free0 (cur_data);
							_g_free0 (majmin);
							_g_free0 (subsystem);
							_g_free0 (devpath);
							_g_free0 (val);
							_g_free0 (key);
							g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
							g_clear_error (&_inner_error0_);
							return NULL;
						}
					}
					_tmp77_ = _tmp73_;
					_tmp77__length1 = _tmp73__length1;
					_tmp73_ = NULL;
					_tmp73__length1 = 0;
					devnode_contents = (g_free (devnode_contents), NULL);
					devnode_contents = _tmp77_;
					devnode_contents_length1 = _tmp77__length1;
					_devnode_contents_size_ = devnode_contents_length1;
					_tmp73_ = (g_free (_tmp73_), NULL);
				}
				break;
			}
			case 'S':
			{
				const gchar* _tmp78_;
				gchar** _tmp81_;
				gint _tmp81__length1;
				const gchar* _tmp82_;
				const gchar* _tmp83_;
				gchar* _tmp84_;
				_tmp78_ = val;
				if (_tmp78_ == NULL) {
					const gchar* _tmp79_;
					GError* _tmp80_;
					_tmp79_ = devpath;
					_tmp80_ = g_error_new (UMOCKDEV_ERROR, UMOCKDEV_ERROR_PARSE, "invalid S: line in description of device %s", _tmp79_);
					_inner_error0_ = _tmp80_;
					if (_inner_error0_->domain == UMOCKDEV_ERROR) {
						g_propagate_error (error, _inner_error0_);
						props = (_vala_array_free (props, props_length1, (GDestroyNotify) g_free), NULL);
						linkattrs = (_vala_array_free (linkattrs, linkattrs_length1, (GDestroyNotify) g_free), NULL);
						binattrs = (_vala_array_free (binattrs, binattrs_length1, (GDestroyNotify) g_free), NULL);
						attrs = (_vala_array_free (attrs, attrs_length1, (GDestroyNotify) g_free), NULL);
						devnode_links = (_vala_array_free (devnode_links, devnode_links_length1, (GDestroyNotify) g_free), NULL);
						devnode_contents = (g_free (devnode_contents), NULL);
						_g_free0 (devnode_path);
						_g_free0 (cur_data);
						_g_free0 (majmin);
						_g_free0 (subsystem);
						_g_free0 (devpath);
						_g_free0 (val);
						_g_free0 (key);
						return NULL;
					} else {
						props = (_vala_array_free (props, props_length1, (GDestroyNotify) g_free), NULL);
						linkattrs = (_vala_array_free (linkattrs, linkattrs_length1, (GDestroyNotify) g_free), NULL);
						binattrs = (_vala_array_free (binattrs, binattrs_length1, (GDestroyNotify) g_free), NULL);
						attrs = (_vala_array_free (attrs, attrs_length1, (GDestroyNotify) g_free), NULL);
						devnode_links = (_vala_array_free (devnode_links, devnode_links_length1, (GDestroyNotify) g_free), NULL);
						devnode_contents = (g_free (devnode_contents), NULL);
						_g_free0 (devnode_path);
						_g_free0 (cur_data);
						_g_free0 (majmin);
						_g_free0 (subsystem);
						_g_free0 (devpath);
						_g_free0 (val);
						_g_free0 (key);
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
						g_clear_error (&_inner_error0_);
						return NULL;
					}
				}
				_tmp81_ = devnode_links;
				_tmp81__length1 = devnode_links_length1;
				_tmp82_ = self->priv->root_dir;
				_tmp83_ = val;
				_tmp84_ = g_build_filename (_tmp82_, "dev", _tmp83_, NULL);
				_vala_array_add11 (&devnode_links, &devnode_links_length1, &_devnode_links_size_, _tmp84_);
				break;
			}
			default:
			{
				GError* _tmp85_;
				_tmp85_ = g_error_new (UMOCKDEV_ERROR, UMOCKDEV_ERROR_PARSE, "Unknown line type '%c'\n", (gint) type);
				_inner_error0_ = _tmp85_;
				if (_inner_error0_->domain == UMOCKDEV_ERROR) {
					g_propagate_error (error, _inner_error0_);
					props = (_vala_array_free (props, props_length1, (GDestroyNotify) g_free), NULL);
					linkattrs = (_vala_array_free (linkattrs, linkattrs_length1, (GDestroyNotify) g_free), NULL);
					binattrs = (_vala_array_free (binattrs, binattrs_length1, (GDestroyNotify) g_free), NULL);
					attrs = (_vala_array_free (attrs, attrs_length1, (GDestroyNotify) g_free), NULL);
					devnode_links = (_vala_array_free (devnode_links, devnode_links_length1, (GDestroyNotify) g_free), NULL);
					devnode_contents = (g_free (devnode_contents), NULL);
					_g_free0 (devnode_path);
					_g_free0 (cur_data);
					_g_free0 (majmin);
					_g_free0 (subsystem);
					_g_free0 (devpath);
					_g_free0 (val);
					_g_free0 (key);
					return NULL;
				} else {
					props = (_vala_array_free (props, props_length1, (GDestroyNotify) g_free), NULL);
					linkattrs = (_vala_array_free (linkattrs, linkattrs_length1, (GDestroyNotify) g_free), NULL);
					binattrs = (_vala_array_free (binattrs, binattrs_length1, (GDestroyNotify) g_free), NULL);
					attrs = (_vala_array_free (attrs, attrs_length1, (GDestroyNotify) g_free), NULL);
					devnode_links = (_vala_array_free (devnode_links, devnode_links_length1, (GDestroyNotify) g_free), NULL);
					devnode_contents = (g_free (devnode_contents), NULL);
					_g_free0 (devnode_path);
					_g_free0 (cur_data);
					_g_free0 (majmin);
					_g_free0 (subsystem);
					_g_free0 (devpath);
					_g_free0 (val);
					_g_free0 (key);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
					g_clear_error (&_inner_error0_);
					return NULL;
				}
			}
		}
	}
	_tmp86_ = subsystem;
	if (_tmp86_ == NULL) {
		const gchar* _tmp87_;
		GError* _tmp88_;
		_tmp87_ = devpath;
		_tmp88_ = g_error_new (UMOCKDEV_ERROR, UMOCKDEV_ERROR_VALUE, "missing SUBSYSTEM property in description of device %s", _tmp87_);
		_inner_error0_ = _tmp88_;
		if (_inner_error0_->domain == UMOCKDEV_ERROR) {
			g_propagate_error (error, _inner_error0_);
			props = (_vala_array_free (props, props_length1, (GDestroyNotify) g_free), NULL);
			linkattrs = (_vala_array_free (linkattrs, linkattrs_length1, (GDestroyNotify) g_free), NULL);
			binattrs = (_vala_array_free (binattrs, binattrs_length1, (GDestroyNotify) g_free), NULL);
			attrs = (_vala_array_free (attrs, attrs_length1, (GDestroyNotify) g_free), NULL);
			devnode_links = (_vala_array_free (devnode_links, devnode_links_length1, (GDestroyNotify) g_free), NULL);
			devnode_contents = (g_free (devnode_contents), NULL);
			_g_free0 (devnode_path);
			_g_free0 (cur_data);
			_g_free0 (majmin);
			_g_free0 (subsystem);
			_g_free0 (devpath);
			_g_free0 (val);
			_g_free0 (key);
			return NULL;
		} else {
			props = (_vala_array_free (props, props_length1, (GDestroyNotify) g_free), NULL);
			linkattrs = (_vala_array_free (linkattrs, linkattrs_length1, (GDestroyNotify) g_free), NULL);
			binattrs = (_vala_array_free (binattrs, binattrs_length1, (GDestroyNotify) g_free), NULL);
			attrs = (_vala_array_free (attrs, attrs_length1, (GDestroyNotify) g_free), NULL);
			devnode_links = (_vala_array_free (devnode_links, devnode_links_length1, (GDestroyNotify) g_free), NULL);
			devnode_contents = (g_free (devnode_contents), NULL);
			_g_free0 (devnode_path);
			_g_free0 (cur_data);
			_g_free0 (majmin);
			_g_free0 (subsystem);
			_g_free0 (devpath);
			_g_free0 (val);
			_g_free0 (key);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	_tmp89_ = devpath;
	_tmp90_ = subsystem;
	g_debug ("umockdev.vala:1184: creating device %s (subsystem %s)", _tmp89_, _tmp90_);
	_tmp91_ = subsystem;
	_tmp92_ = devpath;
	_tmp93_ = string_substring (_tmp92_, (glong) 9, (glong) -1);
	_tmp94_ = _tmp93_;
	_tmp95_ = attrs;
	_tmp95__length1 = attrs_length1;
	_tmp96_ = props;
	_tmp96__length1 = props_length1;
	_tmp97_ = umockdev_testbed_add_devicev (self, _tmp91_, _tmp94_, NULL, _tmp95_, _tmp96_);
	_tmp98_ = _tmp97_;
	_g_free0 (_tmp94_);
	syspath = _tmp98_;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp99_ = FALSE;
			_tmp99_ = TRUE;
			while (TRUE) {
				gchar** _tmp100_;
				gint _tmp100__length1;
				guint8* _tmp101_ = NULL;
				gchar** _tmp102_;
				gint _tmp102__length1;
				const gchar* _tmp103_;
				gint _tmp104_ = 0;
				guint8* _tmp105_;
				gint _tmp101__length1;
				gint __tmp101__size_;
				const gchar* _tmp106_;
				gchar** _tmp107_;
				gint _tmp107__length1;
				const gchar* _tmp108_;
				if (!_tmp99_) {
					i = i + 2;
				}
				_tmp99_ = FALSE;
				_tmp100_ = binattrs;
				_tmp100__length1 = binattrs_length1;
				if (!(i < _tmp100__length1)) {
					break;
				}
				_tmp102_ = binattrs;
				_tmp102__length1 = binattrs_length1;
				_tmp103_ = _tmp102_[i + 1];
				_tmp105_ = umockdev_decode_hex (_tmp103_, &_tmp104_, &_inner_error0_);
				_tmp101_ = _tmp105_;
				_tmp101__length1 = _tmp104_;
				__tmp101__size_ = _tmp101__length1;
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					if (_inner_error0_->domain == UMOCKDEV_ERROR) {
						g_propagate_error (error, _inner_error0_);
						_g_free0 (syspath);
						props = (_vala_array_free (props, props_length1, (GDestroyNotify) g_free), NULL);
						linkattrs = (_vala_array_free (linkattrs, linkattrs_length1, (GDestroyNotify) g_free), NULL);
						binattrs = (_vala_array_free (binattrs, binattrs_length1, (GDestroyNotify) g_free), NULL);
						attrs = (_vala_array_free (attrs, attrs_length1, (GDestroyNotify) g_free), NULL);
						devnode_links = (_vala_array_free (devnode_links, devnode_links_length1, (GDestroyNotify) g_free), NULL);
						devnode_contents = (g_free (devnode_contents), NULL);
						_g_free0 (devnode_path);
						_g_free0 (cur_data);
						_g_free0 (majmin);
						_g_free0 (subsystem);
						_g_free0 (devpath);
						_g_free0 (val);
						_g_free0 (key);
						return NULL;
					} else {
						_g_free0 (syspath);
						props = (_vala_array_free (props, props_length1, (GDestroyNotify) g_free), NULL);
						linkattrs = (_vala_array_free (linkattrs, linkattrs_length1, (GDestroyNotify) g_free), NULL);
						binattrs = (_vala_array_free (binattrs, binattrs_length1, (GDestroyNotify) g_free), NULL);
						attrs = (_vala_array_free (attrs, attrs_length1, (GDestroyNotify) g_free), NULL);
						devnode_links = (_vala_array_free (devnode_links, devnode_links_length1, (GDestroyNotify) g_free), NULL);
						devnode_contents = (g_free (devnode_contents), NULL);
						_g_free0 (devnode_path);
						_g_free0 (cur_data);
						_g_free0 (majmin);
						_g_free0 (subsystem);
						_g_free0 (devpath);
						_g_free0 (val);
						_g_free0 (key);
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
						g_clear_error (&_inner_error0_);
						return NULL;
					}
				}
				_tmp106_ = syspath;
				_tmp107_ = binattrs;
				_tmp107__length1 = binattrs_length1;
				_tmp108_ = _tmp107_[i];
				umockdev_testbed_set_attribute_binary (self, _tmp106_, _tmp108_, _tmp101_, (gint) _tmp101__length1);
				_tmp101_ = (g_free (_tmp101_), NULL);
			}
		}
	}
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp109_ = FALSE;
			_tmp109_ = TRUE;
			while (TRUE) {
				gchar** _tmp110_;
				gint _tmp110__length1;
				const gchar* _tmp111_;
				gchar** _tmp112_;
				gint _tmp112__length1;
				const gchar* _tmp113_;
				gchar** _tmp114_;
				gint _tmp114__length1;
				const gchar* _tmp115_;
				if (!_tmp109_) {
					i = i + 2;
				}
				_tmp109_ = FALSE;
				_tmp110_ = linkattrs;
				_tmp110__length1 = linkattrs_length1;
				if (!(i < _tmp110__length1)) {
					break;
				}
				_tmp111_ = syspath;
				_tmp112_ = linkattrs;
				_tmp112__length1 = linkattrs_length1;
				_tmp113_ = _tmp112_[i];
				_tmp114_ = linkattrs;
				_tmp114__length1 = linkattrs_length1;
				_tmp115_ = _tmp114_[i + 1];
				umockdev_testbed_set_attribute_link (self, _tmp111_, _tmp113_, _tmp115_);
			}
		}
	}
	_tmp116_ = devnode_path;
	if (_tmp116_ != NULL) {
		const gchar* _tmp117_;
		const gchar* _tmp118_;
		guint8* _tmp119_;
		gint _tmp119__length1;
		const gchar* _tmp120_;
		_tmp117_ = subsystem;
		_tmp118_ = devnode_path;
		_tmp119_ = devnode_contents;
		_tmp119__length1 = devnode_contents_length1;
		_tmp120_ = majmin;
		umockdev_testbed_create_node_for_device (self, _tmp117_, _tmp118_, _tmp119_, (gint) _tmp119__length1, _tmp120_, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == UMOCKDEV_ERROR) {
				g_propagate_error (error, _inner_error0_);
				_g_free0 (syspath);
				props = (_vala_array_free (props, props_length1, (GDestroyNotify) g_free), NULL);
				linkattrs = (_vala_array_free (linkattrs, linkattrs_length1, (GDestroyNotify) g_free), NULL);
				binattrs = (_vala_array_free (binattrs, binattrs_length1, (GDestroyNotify) g_free), NULL);
				attrs = (_vala_array_free (attrs, attrs_length1, (GDestroyNotify) g_free), NULL);
				devnode_links = (_vala_array_free (devnode_links, devnode_links_length1, (GDestroyNotify) g_free), NULL);
				devnode_contents = (g_free (devnode_contents), NULL);
				_g_free0 (devnode_path);
				_g_free0 (cur_data);
				_g_free0 (majmin);
				_g_free0 (subsystem);
				_g_free0 (devpath);
				_g_free0 (val);
				_g_free0 (key);
				return NULL;
			} else {
				_g_free0 (syspath);
				props = (_vala_array_free (props, props_length1, (GDestroyNotify) g_free), NULL);
				linkattrs = (_vala_array_free (linkattrs, linkattrs_length1, (GDestroyNotify) g_free), NULL);
				binattrs = (_vala_array_free (binattrs, binattrs_length1, (GDestroyNotify) g_free), NULL);
				attrs = (_vala_array_free (attrs, attrs_length1, (GDestroyNotify) g_free), NULL);
				devnode_links = (_vala_array_free (devnode_links, devnode_links_length1, (GDestroyNotify) g_free), NULL);
				devnode_contents = (g_free (devnode_contents), NULL);
				_g_free0 (devnode_path);
				_g_free0 (cur_data);
				_g_free0 (majmin);
				_g_free0 (subsystem);
				_g_free0 (devpath);
				_g_free0 (val);
				_g_free0 (key);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return NULL;
			}
		}
		{
			gint i = 0;
			i = 0;
			{
				gboolean _tmp121_ = FALSE;
				_tmp121_ = TRUE;
				while (TRUE) {
					gchar** _tmp123_;
					gint _tmp123__length1;
					gchar** _tmp124_;
					gint _tmp124__length1;
					const gchar* _tmp125_;
					gchar* _tmp126_;
					gchar* _tmp127_;
					const gchar* _tmp128_;
					gchar** _tmp129_;
					gint _tmp129__length1;
					const gchar* _tmp130_;
					if (!_tmp121_) {
						gint _tmp122_;
						_tmp122_ = i;
						i = _tmp122_ + 1;
					}
					_tmp121_ = FALSE;
					_tmp123_ = devnode_links;
					_tmp123__length1 = devnode_links_length1;
					if (!(i < _tmp123__length1)) {
						break;
					}
					_tmp124_ = devnode_links;
					_tmp124__length1 = devnode_links_length1;
					_tmp125_ = _tmp124_[i];
					_tmp126_ = g_path_get_dirname (_tmp125_);
					_tmp127_ = _tmp126_;
					_vala_assert (g_mkdir_with_parents (_tmp127_, 0755) == 0, "DirUtils.create_with_parents(Path.get_dirname(devnode_links[i]), 0755) == 0");
					_g_free0 (_tmp127_);
					_tmp128_ = devnode_path;
					_tmp129_ = devnode_links;
					_tmp129__length1 = devnode_links_length1;
					_tmp130_ = _tmp129_[i];
					if (symlink (_tmp128_, _tmp130_) < 0) {
						gchar** _tmp131_;
						gint _tmp131__length1;
						const gchar* _tmp132_;
						const gchar* _tmp133_;
						const gchar* _tmp134_;
						_tmp131_ = devnode_links;
						_tmp131__length1 = devnode_links_length1;
						_tmp132_ = _tmp131_[i];
						_tmp133_ = devnode_path;
						_tmp134_ = devpath;
						g_warning ("umockdev.vala:1205: failed to create %s -> %s symlink for device %s: %" \
"m", _tmp132_, _tmp133_, _tmp134_);
					}
				}
			}
		}
	}
	while (TRUE) {
		gboolean _tmp135_ = FALSE;
		const gchar* _tmp136_;
		const gchar* _tmp138_;
		const gchar* _tmp139_;
		gchar* _tmp140_;
		_tmp136_ = cur_data;
		if (string_get (_tmp136_, (glong) 0) != '\0') {
			const gchar* _tmp137_;
			_tmp137_ = cur_data;
			_tmp135_ = string_get (_tmp137_, (glong) 0) == '\n';
		} else {
			_tmp135_ = FALSE;
		}
		if (!_tmp135_) {
			break;
		}
		_tmp138_ = cur_data;
		_tmp139_ = g_utf8_next_char (_tmp138_);
		_tmp140_ = g_strdup (_tmp139_);
		_g_free0 (cur_data);
		cur_data = _tmp140_;
	}
	result = cur_data;
	_g_free0 (syspath);
	props = (_vala_array_free (props, props_length1, (GDestroyNotify) g_free), NULL);
	linkattrs = (_vala_array_free (linkattrs, linkattrs_length1, (GDestroyNotify) g_free), NULL);
	binattrs = (_vala_array_free (binattrs, binattrs_length1, (GDestroyNotify) g_free), NULL);
	attrs = (_vala_array_free (attrs, attrs_length1, (GDestroyNotify) g_free), NULL);
	devnode_links = (_vala_array_free (devnode_links, devnode_links_length1, (GDestroyNotify) g_free), NULL);
	devnode_contents = (g_free (devnode_contents), NULL);
	_g_free0 (devnode_path);
	_g_free0 (majmin);
	_g_free0 (subsystem);
	_g_free0 (devpath);
	_g_free0 (val);
	_g_free0 (key);
	return result;
}

static void
umockdev_testbed_create_node_for_device (UMockdevTestbed* self,
                                         const gchar* subsystem,
                                         const gchar* node_path,
                                         guint8* node_contents,
                                         gint node_contents_length1,
                                         const gchar* majmin,
                                         GError** error)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
	gint ptym = 0;
	gint ptys = 0;
	gchar* ptyname_array = NULL;
	gchar* _tmp5_;
	gint ptyname_array_length1;
	gint _ptyname_array_size_;
	gchar* _tmp6_;
	gint _tmp6__length1;
	gint _tmp7_ = 0;
	gint _tmp8_ = 0;
	gint _tmp9_;
	gchar* ptyname = NULL;
	gchar* _tmp11_;
	gint _tmp11__length1;
	gchar* _tmp12_;
	const gchar* _tmp13_;
	struct termios ios = {0};
	struct termios _tmp14_ = {0};
	gint _tmp15_;
	struct termios _tmp16_;
	const gchar* _tmp17_;
	gchar* devname = NULL;
	const gchar* _tmp29_;
	gint _tmp30_;
	gint _tmp31_;
	gchar* _tmp32_;
	GHashTable* _tmp33_;
	const gchar* _tmp34_;
	GHashTable* _tmp35_;
	const gchar* _tmp36_;
	gchar* _tmp37_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (subsystem != NULL);
	g_return_if_fail (node_path != NULL);
	_tmp0_ = g_path_get_dirname (node_path);
	_tmp1_ = _tmp0_;
	_vala_assert (g_mkdir_with_parents (_tmp1_, 0755) == 0, "DirUtils.create_with_parents(Path.get_dirname(node_path), 0755) == 0");
	_g_free0 (_tmp1_);
	if (node_contents_length1 > 0) {
		_tmp3_ = TRUE;
	} else {
		_tmp3_ = g_strcmp0 (subsystem, "block") == 0;
	}
	if (_tmp3_) {
		_tmp2_ = TRUE;
	} else {
		_tmp2_ = g_strcmp0 (subsystem, "usb") == 0;
	}
	if (_tmp2_) {
		{
			g_debug ("umockdev.vala:1226: create_node_for_device: creating file device %s", node_path);
			g_file_set_contents (node_path, (const char*) node_contents, (size_t) node_contents_length1, &_inner_error0_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				if (_inner_error0_->domain == G_FILE_ERROR) {
					goto __catch9_g_file_error;
				}
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return;
			}
			if (g_strcmp0 (subsystem, "block") == 0) {
				g_chmod (node_path, 01644);
			}
		}
		goto __finally9;
		__catch9_g_file_error:
		{
			GError* e = NULL;
			const gchar* _tmp4_;
			e = _inner_error0_;
			_inner_error0_ = NULL;
			_tmp4_ = e->message;
			g_error ("umockdev.vala:1233: Cannot create dev node file: %s", _tmp4_);
			_g_error_free0 (e);
		}
		__finally9:
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == UMOCKDEV_ERROR) {
				g_propagate_error (error, _inner_error0_);
				return;
			} else {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return;
			}
		}
		return;
	}
	_tmp5_ = g_new0 (gchar, 8192);
	ptyname_array = _tmp5_;
	ptyname_array_length1 = 8192;
	_ptyname_array_size_ = ptyname_array_length1;
	_tmp6_ = ptyname_array;
	_tmp6__length1 = ptyname_array_length1;
	_tmp9_ = openpty (&_tmp7_, &_tmp8_, _tmp6_, NULL, NULL);
	ptym = _tmp7_;
	ptys = _tmp8_;
	if (_tmp9_ < 0) {
		const gchar* _tmp10_;
		_tmp10_ = g_strerror (errno);
		g_error ("umockdev.vala:1243: umockdev Testbed.create_node_for_device: openpty()" \
" failed: %s", _tmp10_);
	}
	_tmp11_ = ptyname_array;
	_tmp11__length1 = ptyname_array_length1;
	_tmp12_ = g_strdup ((const gchar*) _tmp11_);
	ptyname = _tmp12_;
	_tmp13_ = ptyname;
	g_debug ("umockdev.vala:1245: create_node_for_device: creating pty device %s: go" \
"t pty %s", node_path, _tmp13_);
	close (ptys);
	_tmp15_ = tcgetattr (ptym, &_tmp14_);
	ios = _tmp14_;
	_vala_assert (_tmp15_ == 0, "Posix.tcgetattr (ptym, out ios) == 0");
	ios.c_iflag = ios.c_iflag & (~((IGNCR | INLCR) | ICRNL));
	ios.c_oflag = ios.c_oflag & (~(ONLCR | OCRNL));
	ios.c_lflag = ios.c_lflag & (~(ICANON | ECHO));
	cfmakeraw (&ios);
	_tmp16_ = ios;
	_vala_assert (tcsetattr (ptym, TCSANOW, &_tmp16_) == 0, "Posix.tcsetattr (ptym, Posix.TCSANOW, ios) == 0");
	_tmp17_ = ptyname;
	_vala_assert (symlink (_tmp17_, node_path) == 0, "FileUtils.symlink (ptyname, node_path) == 0");
	if (majmin != NULL) {
		gchar* mapdir = NULL;
		const gchar* _tmp18_;
		gchar* _tmp19_;
		const gchar* _tmp20_;
		gchar* dest = NULL;
		const gchar* _tmp21_;
		const gchar* _tmp22_;
		gchar* _tmp23_;
		gchar* _tmp24_;
		gchar* _tmp25_;
		gchar* _tmp26_;
		const gchar* _tmp27_;
		const gchar* _tmp28_;
		_tmp18_ = self->priv->root_dir;
		_tmp19_ = g_build_filename (_tmp18_, "dev", ".ptymap", NULL);
		mapdir = _tmp19_;
		_tmp20_ = mapdir;
		g_mkdir_with_parents (_tmp20_, 0755);
		_tmp21_ = mapdir;
		_tmp22_ = ptyname;
		_tmp23_ = string_replace (_tmp22_, "/", "_");
		_tmp24_ = _tmp23_;
		_tmp25_ = g_build_filename (_tmp21_, _tmp24_, NULL);
		_tmp26_ = _tmp25_;
		_g_free0 (_tmp24_);
		dest = _tmp26_;
		_tmp27_ = dest;
		g_debug ("umockdev.vala:1266: create_node_for_device: creating ptymap symlink %s", _tmp27_);
		_tmp28_ = dest;
		_vala_assert (symlink (majmin, _tmp28_) == 0, "FileUtils.symlink(majmin, dest) == 0");
		_g_free0 (dest);
		_g_free0 (mapdir);
	}
	_tmp29_ = self->priv->root_dir;
	_tmp30_ = strlen (_tmp29_);
	_tmp31_ = _tmp30_;
	_tmp32_ = string_substring (node_path, (glong) _tmp31_, (glong) -1);
	devname = _tmp32_;
	_tmp33_ = self->priv->dev_fd;
	_tmp34_ = devname;
	_vala_assert (!g_hash_table_contains (_tmp33_, _tmp34_), "!this.dev_fd.contains (devname)");
	_tmp35_ = self->priv->dev_fd;
	_tmp36_ = devname;
	_tmp37_ = g_strdup (_tmp36_);
	g_hash_table_insert (_tmp35_, _tmp37_, (gpointer) ((gintptr) ptym));
	_g_free0 (devname);
	_g_free0 (ptyname);
	ptyname_array = (g_free (ptyname_array), NULL);
}

/**
     * umockdev_testbed_record_parse_line:
     * @data: String to parse
     * @type: Pointer to a gchar which will get the line type (one of P, N,
     *        S, E, or H)
     * @key:  Pointer to a string which will get the key name; this will be
     *        set to %NULL for line types which do not have a key (P, N, S). You
     *        need to free this with g_free().
     * @value: Pointer to a string which will get the value. You need to
     *         free this with g_free().
     *
     * Parse one line from a device record file.
     *
     * Returns: Pointer to the next line start in @data, or %NULL if the first line
     * is not valid.
     */
static gchar*
umockdev_testbed_record_parse_line (UMockdevTestbed* self,
                                    const gchar* data,
                                    gchar* type,
                                    gchar* * key,
                                    gchar* * val)
{
	gchar _vala_type = '\0';
	gchar* _vala_key = NULL;
	gchar* _vala_val = NULL;
	GMatchInfo* match = NULL;
	GRegex* _tmp0_;
	GMatchInfo* _tmp1_ = NULL;
	gboolean _tmp2_;
	gchar* type_str = NULL;
	GMatchInfo* _tmp20_;
	gchar* _tmp21_;
	const gchar* _tmp22_;
	const gchar* _tmp23_;
	gint end_pos = 0;
	GMatchInfo* _tmp24_;
	gint _tmp25_ = 0;
	gboolean _tmp26_;
	gchar* _tmp27_;
	gchar* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (data != NULL, NULL);
	_tmp0_ = self->priv->re_record_val;
	_tmp2_ = g_regex_match (_tmp0_, data, 0, &_tmp1_);
	_g_match_info_unref0 (match);
	match = _tmp1_;
	if (_tmp2_) {
		GMatchInfo* _tmp3_;
		gchar* _tmp4_;
		_g_free0 (_vala_key);
		_vala_key = NULL;
		_tmp3_ = match;
		_tmp4_ = g_match_info_fetch (_tmp3_, 2);
		_g_free0 (_vala_val);
		_vala_val = _tmp4_;
	} else {
		GRegex* _tmp5_;
		GMatchInfo* _tmp6_ = NULL;
		gboolean _tmp7_;
		_tmp5_ = self->priv->re_record_keyval;
		_tmp7_ = g_regex_match (_tmp5_, data, 0, &_tmp6_);
		_g_match_info_unref0 (match);
		match = _tmp6_;
		if (_tmp7_) {
			GMatchInfo* _tmp8_;
			gchar* _tmp9_;
			GMatchInfo* _tmp10_;
			gchar* _tmp11_;
			const gchar* _tmp12_;
			_tmp8_ = match;
			_tmp9_ = g_match_info_fetch (_tmp8_, 2);
			_g_free0 (_vala_key);
			_vala_key = _tmp9_;
			_tmp10_ = match;
			_tmp11_ = g_match_info_fetch (_tmp10_, 3);
			_g_free0 (_vala_val);
			_vala_val = _tmp11_;
			_tmp12_ = _vala_val;
			_vala_assert (_tmp12_ != NULL, "val != null");
		} else {
			GRegex* _tmp13_;
			GMatchInfo* _tmp14_ = NULL;
			gboolean _tmp15_;
			_tmp13_ = self->priv->re_record_optval;
			_tmp15_ = g_regex_match (_tmp13_, data, 0, &_tmp14_);
			_g_match_info_unref0 (match);
			match = _tmp14_;
			if (_tmp15_) {
				GMatchInfo* _tmp16_;
				gchar* _tmp17_;
				GMatchInfo* _tmp18_;
				gchar* _tmp19_;
				_tmp16_ = match;
				_tmp17_ = g_match_info_fetch (_tmp16_, 2);
				_g_free0 (_vala_key);
				_vala_key = _tmp17_;
				_tmp18_ = match;
				_tmp19_ = g_match_info_fetch (_tmp18_, 3);
				_g_free0 (_vala_val);
				_vala_val = _tmp19_;
			} else {
				g_debug ("umockdev.vala:1308: record_parse_line: >%s< does not match anything, f" \
"ailing", data);
				_vala_type = '\0';
				_g_free0 (_vala_key);
				_vala_key = NULL;
				_g_free0 (_vala_val);
				_vala_val = NULL;
				result = NULL;
				_g_match_info_unref0 (match);
				if (type) {
					*type = _vala_type;
				}
				if (key) {
					*key = _vala_key;
				} else {
					_g_free0 (_vala_key);
				}
				if (val) {
					*val = _vala_val;
				} else {
					_g_free0 (_vala_val);
				}
				return result;
			}
		}
	}
	_tmp20_ = match;
	_tmp21_ = g_match_info_fetch (_tmp20_, 1);
	type_str = _tmp21_;
	_tmp22_ = type_str;
	_vala_assert (_tmp22_ != NULL, "type_str != null");
	_tmp23_ = type_str;
	_vala_type = string_get (_tmp23_, (glong) 0);
	_tmp24_ = match;
	_tmp26_ = g_match_info_fetch_pos (_tmp24_, 0, NULL, &_tmp25_);
	end_pos = _tmp25_;
	_vala_assert (_tmp26_, "match.fetch_pos(0, null, out end_pos)");
	_tmp27_ = string_substring (data, (glong) end_pos, (glong) -1);
	result = _tmp27_;
	_g_free0 (type_str);
	_g_match_info_unref0 (match);
	if (type) {
		*type = _vala_type;
	}
	if (key) {
		*key = _vala_key;
	} else {
		_g_free0 (_vala_key);
	}
	if (val) {
		*val = _vala_val;
	} else {
		_g_free0 (_vala_val);
	}
	return result;
}

/**
     * umockdev_testbed_disable:
     * @self: A #UMockdevTestbed.
     *
     * Disable the testbed.  This can be used for temporarily switching back to
     * the real /sys and /dev without having to destroy or change $UMOCKDEV_DIR
     * and the #UMockdevTestbed instance. Use @umockdev_testbed_enable() to
     * re-enable the testbed.
     */
void
umockdev_testbed_disable (UMockdevTestbed* self)
{
	const gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	FILE* _tmp3_;
	FILE* _tmp4_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->root_dir;
	_tmp1_ = g_build_filename (_tmp0_, "disabled", NULL);
	_tmp2_ = _tmp1_;
	_tmp3_ = g_fopen (_tmp2_, "w");
	_tmp4_ = _tmp3_;
	_fclose0 (_tmp4_);
	_g_free0 (_tmp2_);
}

/**
     * umockdev_testbed_enable:
     * @self: A #UMockdevTestbed.
     *
     * Re-enable the testbed after @@umockdev_testbed_disable().
     */
void
umockdev_testbed_enable (UMockdevTestbed* self)
{
	const gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->root_dir;
	_tmp1_ = g_build_filename (_tmp0_, "disabled", NULL);
	_tmp2_ = _tmp1_;
	g_remove (_tmp2_);
	_g_free0 (_tmp2_);
}

/**
     * umockdev_testbed_clear:
     * @self: A #UMockdevTestbed.
     *
     * Remove all added devices from testbed directory.  After that, the
     * umockdev root directory will be in the same state as directly after the
     * constructor.
     */
void
umockdev_testbed_clear (UMockdevTestbed* self)
{
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->root_dir;
	umockdev_remove_dir (_tmp0_, FALSE);
	_tmp1_ = self->priv->sys_dir;
	g_mkdir (_tmp1_, 0755);
}

/**
     * umockdev_testbed_get_dev_fd:
     * @self: A #UMockdevTestbed.
     * @devnode: Device node name ("/dev/...")
     *
     * Simulated devices without a pre-defined contents are backed by a
     * stream-like device node (PTY). Return the file descriptor
     * for accessing their "master" side, i. e. the end that gets
     * controlled by test suites. The tested program opens the "slave" side,
     * which is just openening the device specified by @devnode, e. g.
     * /dev/ttyUSB2. Once that happened, your test can directly communicate
     * with the tested program over that descriptor.
     *
     * Returns: File descriptor for communicating with clients that connect to
     *           @devnode, or -1 if @devnode does not exist or is not a
     *           simulated stream device. This must not be closed!
     */
gint
umockdev_testbed_get_dev_fd (UMockdevTestbed* self,
                             const gchar* devnode)
{
	GHashTable* _tmp0_;
	gint result = 0;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (devnode != NULL, 0);
	_tmp0_ = self->priv->dev_fd;
	if (g_hash_table_contains (_tmp0_, devnode)) {
		GHashTable* _tmp1_;
		gconstpointer _tmp2_;
		_tmp1_ = self->priv->dev_fd;
		_tmp2_ = g_hash_table_lookup (_tmp1_, devnode);
		result = (gint) ((gintptr) _tmp2_);
		return result;
	} else {
		result = -1;
		return result;
	}
}

static void
umockdev_testbed_class_init (UMockdevTestbedClass * klass,
                             gpointer klass_data)
{
	umockdev_testbed_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &UMockdevTestbed_private_offset);
	G_OBJECT_CLASS (klass)->finalize = umockdev_testbed_finalize;
}

static void
umockdev_testbed_instance_init (UMockdevTestbed * self,
                                gpointer klass)
{
	self->priv = umockdev_testbed_get_instance_private (self);
	self->priv->ev_sender = NULL;
	self->priv->socket_server = NULL;
}

static void
umockdev_testbed_finalize (GObject * obj)
{
	UMockdevTestbed * self;
	GHashTable* _tmp0_;
	GList* _tmp1_;
	GHashTable* _tmp3_;
	GHashTable* _tmp4_;
	GList* _tmp5_;
	UMockdevSocketServer* _tmp6_;
	const gchar* _tmp8_;
	const gchar* _tmp9_;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, UMOCKDEV_TYPE_TESTBED, UMockdevTestbed);
	_tmp0_ = self->priv->dev_script_runner;
	_tmp1_ = g_hash_table_get_values (_tmp0_);
	{
		GList* r_collection = NULL;
		GList* r_it = NULL;
		r_collection = _tmp1_;
		for (r_it = r_collection; r_it != NULL; r_it = r_it->next) {
			UMockdevScriptRunner* r = NULL;
			r = (UMockdevScriptRunner*) r_it->data;
			{
				UMockdevScriptRunner* _tmp2_;
				_tmp2_ = r;
				umockdev_script_runner_stop (_tmp2_);
			}
		}
		(r_collection == NULL) ? NULL : (r_collection = (g_list_free (r_collection), NULL));
	}
	_tmp3_ = self->priv->dev_script_runner;
	g_hash_table_remove_all (_tmp3_);
	_tmp4_ = self->priv->dev_fd;
	_tmp5_ = g_hash_table_get_values (_tmp4_);
	{
		GList* fd_collection = NULL;
		GList* fd_it = NULL;
		fd_collection = _tmp5_;
		for (fd_it = fd_collection; fd_it != NULL; fd_it = fd_it->next) {
			gint fd = 0;
			fd = (gint) ((gintptr) fd_it->data);
			{
				g_debug ("umockdev.vala:90: closing master pty fd %i for emulated device", fd);
				close (fd);
			}
		}
		(fd_collection == NULL) ? NULL : (fd_collection = (g_list_free (fd_collection), NULL));
	}
	_tmp6_ = self->priv->socket_server;
	if (_tmp6_ != NULL) {
		UMockdevSocketServer* _tmp7_;
		g_debug ("umockdev.vala:95: shutting down socket server thread");
		_tmp7_ = self->priv->socket_server;
		umockdev_socket_server_stop (_tmp7_);
		_umockdev_socket_server_unref0 (self->priv->socket_server);
		self->priv->socket_server = NULL;
	}
	_tmp8_ = self->priv->root_dir;
	g_debug ("umockdev.vala:100: Removing test bed %s", _tmp8_);
	_tmp9_ = self->priv->root_dir;
	umockdev_remove_dir (_tmp9_, TRUE);
	g_unsetenv ("UMOCKDEV_DIR");
	_g_free0 (self->priv->root_dir);
	_g_free0 (self->priv->sys_dir);
	_g_regex_unref0 (self->priv->re_record_val);
	_g_regex_unref0 (self->priv->re_record_keyval);
	_g_regex_unref0 (self->priv->re_record_optval);
	_uevent_sender_close0 (self->priv->ev_sender);
	_g_hash_table_unref0 (self->priv->dev_fd);
	_g_hash_table_unref0 (self->priv->dev_script_runner);
	_umockdev_socket_server_unref0 (self->priv->socket_server);
	G_OBJECT_CLASS (umockdev_testbed_parent_class)->finalize (obj);
}

/**
 * UMockdevTestbed:
 *
 * The #UMockdevTestbed class builds a temporary sandbox for mock devices.
 * You can add a number of devices including arbitrary sysfs attributes and
 * udev properties, and then run your software in that test bed that is
 * independent of the actual hardware it is running on.  With this you can
 * simulate particular hardware in virtual environments up to some degree,
 * without needing any particular privileges or disturbing the whole system.
 *
 * You can either add devices by specifying individual device paths,
 * properties, and attributes, or use the umockdev-record tool to create a human
 * readable/editable record of a real device (and all its parents) and load
 * that into the testbed with umockdev_testbed_add_from_string().
 *
 * Instantiating a #UMockdevTestbed object creates a temporary directory with
 * an empty sysfs tree and sets the $UMOCKDEV_DIR environment variable so that
 * programs subsequently started under umockdev-wrapper will use the test bed
 * instead of the system's real sysfs.
 */
GType
umockdev_testbed_get_type (void)
{
	static volatile gsize umockdev_testbed_type_id__volatile = 0;
	if (g_once_init_enter (&umockdev_testbed_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (UMockdevTestbedClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) umockdev_testbed_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (UMockdevTestbed), 0, (GInstanceInitFunc) umockdev_testbed_instance_init, NULL };
		GType umockdev_testbed_type_id;
		umockdev_testbed_type_id = g_type_register_static (G_TYPE_OBJECT, "UMockdevTestbed", &g_define_type_info, 0);
		UMockdevTestbed_private_offset = g_type_add_instance_private (umockdev_testbed_type_id, sizeof (UMockdevTestbedPrivate));
		g_once_init_leave (&umockdev_testbed_type_id__volatile, umockdev_testbed_type_id);
	}
	return umockdev_testbed_type_id__volatile;
}

void
umockdev_remove_dir (const gchar* path,
                     gboolean remove_toplevel)
{
	gboolean _tmp0_ = FALSE;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (path != NULL);
	if (g_file_test (path, G_FILE_TEST_IS_DIR)) {
		_tmp0_ = !g_file_test (path, G_FILE_TEST_IS_SYMLINK);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		GDir* d = NULL;
		gchar* name = NULL;
		{
			GDir* _tmp1_ = NULL;
			GDir* _tmp2_;
			GDir* _tmp3_;
			_tmp2_ = g_dir_open (path, (guint) 0, &_inner_error0_);
			_tmp1_ = _tmp2_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				if (_inner_error0_->domain == G_FILE_ERROR) {
					goto __catch10_g_file_error;
				}
				_g_dir_close0 (d);
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return;
			}
			_tmp3_ = _tmp1_;
			_tmp1_ = NULL;
			_g_dir_close0 (d);
			d = _tmp3_;
			_g_dir_close0 (_tmp1_);
		}
		goto __finally10;
		__catch10_g_file_error:
		{
			GError* e = NULL;
			GError* _tmp4_;
			const gchar* _tmp5_;
			e = _inner_error0_;
			_inner_error0_ = NULL;
			_tmp4_ = e;
			_tmp5_ = _tmp4_->message;
			g_warning ("umockdev.vala:1413: cannot open: %s: %s", path, _tmp5_);
			_g_error_free0 (e);
			_g_dir_close0 (d);
			return;
		}
		__finally10:
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_dir_close0 (d);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
		while (TRUE) {
			GDir* _tmp6_;
			const gchar* _tmp7_;
			gchar* _tmp8_;
			const gchar* _tmp9_;
			const gchar* _tmp10_;
			gchar* _tmp11_;
			gchar* _tmp12_;
			_tmp6_ = d;
			_tmp7_ = g_dir_read_name (_tmp6_);
			_tmp8_ = g_strdup (_tmp7_);
			_g_free0 (name);
			name = _tmp8_;
			_tmp9_ = name;
			if (!(_tmp9_ != NULL)) {
				break;
			}
			_tmp10_ = name;
			_tmp11_ = g_build_filename (path, _tmp10_, NULL);
			_tmp12_ = _tmp11_;
			umockdev_remove_dir (_tmp12_, TRUE);
			_g_free0 (_tmp12_);
		}
		_g_free0 (name);
		_g_dir_close0 (d);
	}
	if (remove_toplevel) {
		if (g_remove (path) < 0) {
			const gchar* _tmp13_;
			_tmp13_ = g_strerror (errno);
			g_warning ("umockdev.vala:1424: cannot remove %s: %s", path, _tmp13_);
		}
	}
}

static gint
string_index_of_char (const gchar* self,
                      gunichar c,
                      gint start_index)
{
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gint result = 0;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = g_utf8_strchr (((gchar*) self) + start_index, (gssize) -1, c);
	_result_ = _tmp0_;
	_tmp1_ = _result_;
	if (_tmp1_ != NULL) {
		gchar* _tmp2_;
		_tmp2_ = _result_;
		result = (gint) (_tmp2_ - ((gchar*) self));
		return result;
	} else {
		result = -1;
		return result;
	}
}

gchar*
umockdev_make_dotdots (const gchar* path)
{
	gint offset = 0;
	guint count = 0U;
	gchar* dots = NULL;
	gchar* _tmp0_;
	gchar* result = NULL;
	g_return_val_if_fail (path != NULL, NULL);
	offset = 0;
	count = (guint) 0;
	while (TRUE) {
		offset = string_index_of_char (path, (gunichar) '/', offset);
		if (!(offset >= 0)) {
			break;
		}
		count = count + 1;
		offset = offset + 1;
	}
	_tmp0_ = g_strdup ("");
	dots = _tmp0_;
	while (TRUE) {
		const gchar* _tmp1_;
		gchar* _tmp2_;
		if (!(count > ((guint) 1))) {
			break;
		}
		_tmp1_ = dots;
		_tmp2_ = g_strconcat (_tmp1_, "../", NULL);
		_g_free0 (dots);
		dots = _tmp2_;
		count = count - 1;
	}
	result = dots;
	return result;
}

guint8
umockdev_hexdigit (gchar c)
{
	gint _tmp0_ = 0;
	guint8 result = 0U;
	if (c >= 'a') {
		_tmp0_ = (c - 'a') + 10;
	} else {
		gint _tmp1_ = 0;
		if (c >= 'A') {
			_tmp1_ = (c - 'A') + 10;
		} else {
			_tmp1_ = (gint) (c - '0');
		}
		_tmp0_ = _tmp1_;
	}
	result = (guint8) _tmp0_;
	return result;
}

guint8*
umockdev_decode_hex (const gchar* data,
                     gint* result_length1,
                     GError** error)
{
	gint _tmp0_;
	gint _tmp1_;
	gint len = 0;
	gint _tmp3_;
	gint _tmp4_;
	guint8* bin = NULL;
	guint8* _tmp5_;
	gint bin_length1;
	gint _bin_size_;
	guint8* _tmp9_;
	gint _tmp9__length1;
	GError* _inner_error0_ = NULL;
	guint8* result = NULL;
	g_return_val_if_fail (data != NULL, NULL);
	_tmp0_ = strlen (data);
	_tmp1_ = _tmp0_;
	if ((_tmp1_ % 2) != 0) {
		GError* _tmp2_;
		_tmp2_ = g_error_new (UMOCKDEV_ERROR, UMOCKDEV_ERROR_PARSE, "malformed hexadecimal value: %s", data);
		_inner_error0_ = _tmp2_;
		if (_inner_error0_->domain == UMOCKDEV_ERROR) {
			g_propagate_error (error, _inner_error0_);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	_tmp3_ = strlen (data);
	_tmp4_ = _tmp3_;
	len = _tmp4_;
	_tmp5_ = g_new0 (guint8, len / 2);
	bin = _tmp5_;
	bin_length1 = len / 2;
	_bin_size_ = bin_length1;
	{
		guint i = 0U;
		i = (guint) 0;
		{
			gboolean _tmp6_ = FALSE;
			_tmp6_ = TRUE;
			while (TRUE) {
				guint8* _tmp7_;
				gint _tmp7__length1;
				guint8* _tmp8_;
				gint _tmp8__length1;
				if (!_tmp6_) {
					i = i + 1;
				}
				_tmp6_ = FALSE;
				_tmp7_ = bin;
				_tmp7__length1 = bin_length1;
				if (!(i < ((guint) _tmp7__length1))) {
					break;
				}
				_tmp8_ = bin;
				_tmp8__length1 = bin_length1;
				_tmp8_[i] = (guint8) ((umockdev_hexdigit (string_get (data, (glong) (i * 2))) << 4) | umockdev_hexdigit (string_get (data, (glong) ((i * 2) + 1))));
			}
		}
	}
	_tmp9_ = bin;
	_tmp9__length1 = bin_length1;
	if (result_length1) {
		*result_length1 = _tmp9__length1;
	}
	result = _tmp9_;
	return result;
}

gchar*
umockdev_find_devnode (const gchar* devpath)
{
	gchar* devname = NULL;
	GFile* f = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	GFile* _tmp2_;
	GFile* _tmp3_;
	GError* _inner_error0_ = NULL;
	gchar* result = NULL;
	g_return_val_if_fail (devpath != NULL, NULL);
	devname = NULL;
	_tmp0_ = g_build_filename (devpath, "uevent", NULL);
	_tmp1_ = _tmp0_;
	_tmp2_ = g_file_new_for_path (_tmp1_);
	_tmp3_ = _tmp2_;
	_g_free0 (_tmp1_);
	f = _tmp3_;
	{
		GFileInputStream* _tmp4_ = NULL;
		GFile* _tmp5_;
		GFileInputStream* _tmp6_;
		GDataInputStream* inp = NULL;
		GDataInputStream* _tmp7_;
		gchar* line = NULL;
		gsize len = 0UL;
		GDataInputStream* _tmp20_;
		_tmp5_ = f;
		_tmp6_ = g_file_read (_tmp5_, NULL, &_inner_error0_);
		_tmp4_ = _tmp6_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch11_g_error;
		}
		_tmp7_ = g_data_input_stream_new ((GInputStream*) _tmp4_);
		inp = _tmp7_;
		while (TRUE) {
			gchar* _tmp8_ = NULL;
			GDataInputStream* _tmp9_;
			gsize _tmp10_ = 0UL;
			gchar* _tmp11_;
			gchar* _tmp12_;
			const gchar* _tmp13_;
			const gchar* _tmp14_;
			_tmp9_ = inp;
			_tmp11_ = g_data_input_stream_read_line (_tmp9_, &_tmp10_, NULL, &_inner_error0_);
			len = _tmp10_;
			_tmp8_ = _tmp11_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				_g_free0 (line);
				_g_object_unref0 (inp);
				_g_object_unref0 (_tmp4_);
				goto __catch11_g_error;
			}
			_tmp12_ = _tmp8_;
			_tmp8_ = NULL;
			_g_free0 (line);
			line = _tmp12_;
			_tmp13_ = line;
			if (!(_tmp13_ != NULL)) {
				_g_free0 (_tmp8_);
				break;
			}
			_tmp14_ = line;
			if (g_str_has_prefix (_tmp14_, "DEVNAME=")) {
				const gchar* _tmp15_;
				gchar* _tmp16_;
				const gchar* _tmp17_;
				_tmp15_ = line;
				_tmp16_ = string_substring (_tmp15_, (glong) 8, (glong) -1);
				_g_free0 (devname);
				devname = _tmp16_;
				_tmp17_ = devname;
				if (!g_str_has_prefix (_tmp17_, "/dev/")) {
					const gchar* _tmp18_;
					gchar* _tmp19_;
					_tmp18_ = devname;
					_tmp19_ = g_strconcat ("/dev/", _tmp18_, NULL);
					_g_free0 (devname);
					devname = _tmp19_;
				}
				_g_free0 (_tmp8_);
				break;
			}
			_g_free0 (_tmp8_);
		}
		_tmp20_ = inp;
		g_input_stream_close ((GInputStream*) _tmp20_, NULL, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_free0 (line);
			_g_object_unref0 (inp);
			_g_object_unref0 (_tmp4_);
			goto __catch11_g_error;
		}
		_g_free0 (line);
		_g_object_unref0 (inp);
		_g_object_unref0 (_tmp4_);
	}
	goto __finally11;
	__catch11_g_error:
	{
		GError* e = NULL;
		GError* _tmp21_;
		const gchar* _tmp22_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp21_ = e;
		_tmp22_ = _tmp21_->message;
		g_warning ("umockdev.vala:1492: Cannot read uevent file: %s\n", _tmp22_);
		_g_error_free0 (e);
	}
	__finally11:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_object_unref0 (f);
		_g_free0 (devname);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return NULL;
	}
	result = devname;
	_g_object_unref0 (f);
	return result;
}

static inline gpointer
umockdev_script_runner_get_instance_private (UMockdevScriptRunner* self)
{
	return G_STRUCT_MEMBER_P (self, UMockdevScriptRunner_private_offset);
}

static gpointer
_umockdev_script_runner_run_gthread_func (gpointer self)
{
	gpointer result;
	result = umockdev_script_runner_run ((UMockdevScriptRunner*) self);
	umockdev_script_runner_unref (self);
	return result;
}

UMockdevScriptRunner*
umockdev_script_runner_construct (GType object_type,
                                  const gchar* device,
                                  const gchar* script_file,
                                  gint fd,
                                  GError** error)
{
	UMockdevScriptRunner* self = NULL;
	FILE* _tmp0_;
	FILE* _tmp1_;
	gchar* _tmp6_;
	GThread* _tmp7_;
	GError* _inner_error0_ = NULL;
	g_return_val_if_fail (device != NULL, NULL);
	g_return_val_if_fail (script_file != NULL, NULL);
	self = (UMockdevScriptRunner*) g_type_create_instance (object_type);
	_tmp0_ = g_fopen (script_file, "r");
	_fclose0 (self->priv->script);
	self->priv->script = _tmp0_;
	_tmp1_ = self->priv->script;
	if (_tmp1_ == NULL) {
		gchar* _tmp2_;
		gchar* _tmp3_;
		GError* _tmp4_;
		GError* _tmp5_;
		_tmp2_ = g_strconcat ("Cannot open script record file ", script_file, NULL);
		_tmp3_ = _tmp2_;
		_tmp4_ = g_error_new_literal (G_FILE_ERROR, G_FILE_ERROR_FAILED, _tmp3_);
		_tmp5_ = _tmp4_;
		_g_free0 (_tmp3_);
		_inner_error0_ = _tmp5_;
		if (_inner_error0_->domain == G_FILE_ERROR) {
			g_propagate_error (error, _inner_error0_);
			_umockdev_script_runner_unref0 (self);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	umockdev_script_runner_set_device (self, device);
	_tmp6_ = g_strdup (script_file);
	_g_free0 (self->priv->script_file);
	self->priv->script_file = _tmp6_;
	self->priv->fd = fd;
	self->priv->running = TRUE;
	_tmp7_ = g_thread_new (device, _umockdev_script_runner_run_gthread_func, umockdev_script_runner_ref (self));
	_g_thread_unref0 (self->priv->thread);
	self->priv->thread = _tmp7_;
	return self;
}

UMockdevScriptRunner*
umockdev_script_runner_new (const gchar* device,
                            const gchar* script_file,
                            gint fd,
                            GError** error)
{
	return umockdev_script_runner_construct (UMOCKDEV_TYPE_SCRIPT_RUNNER, device, script_file, fd, error);
}

void
umockdev_script_runner_stop (UMockdevScriptRunner* self)
{
	const gchar* _tmp0_;
	GThread* _tmp1_;
	g_return_if_fail (self != NULL);
	if (!self->priv->running) {
		return;
	}
	_tmp0_ = self->priv->_device;
	g_debug ("umockdev.vala:1523: Stopping script runner for %s: joining thread", _tmp0_);
	self->priv->running = FALSE;
	_tmp1_ = self->priv->thread;
	self->priv->thread = NULL;
	g_thread_join (_tmp1_);
}

static void*
umockdev_script_runner_run (UMockdevScriptRunner* self)
{
	gchar op = '\0';
	guint32 delta = 0U;
	guint8* data = NULL;
	gint data_length1 = 0;
	gint _data_size_ = 0;
	const gchar* _tmp0_;
	const gchar* _tmp23_;
	void* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_device;
	g_debug ("umockdev.vala:1534: ScriptRunner[%s]: start", _tmp0_);
	while (TRUE) {
		gchar _tmp1_ = '\0';
		guint32 _tmp2_ = 0U;
		gint _tmp3_ = 0;
		guint8* _tmp4_;
		if (!self->priv->running) {
			break;
		}
		_tmp4_ = umockdev_script_runner_next_line (self, &_tmp1_, &_tmp2_, &_tmp3_);
		op = _tmp1_;
		delta = _tmp2_;
		data = (g_free (data), NULL);
		data = _tmp4_;
		data_length1 = _tmp3_;
		_data_size_ = data_length1;
		switch (op) {
			case 'r':
			{
				const gchar* _tmp5_;
				const gchar* _tmp6_;
				guint8* _tmp7_;
				gint _tmp7__length1;
				gchar* _tmp8_;
				gchar* _tmp9_;
				gssize l = 0L;
				guint8* _tmp10_;
				gint _tmp10__length1;
				guint8* _tmp11_;
				gint _tmp11__length1;
				guint8* _tmp14_;
				gint _tmp14__length1;
				_tmp5_ = self->priv->_device;
				g_debug ("ScriptRunner[%s]: read op; sleeping %" G_GUINT32_FORMAT " ms", _tmp5_, delta);
				g_usleep ((gulong) (delta * 1000));
				_tmp6_ = self->priv->_device;
				_tmp7_ = data;
				_tmp7__length1 = data_length1;
				_tmp8_ = umockdev_script_runner_encode (_tmp7_, (gint) _tmp7__length1);
				_tmp9_ = _tmp8_;
				g_debug ("umockdev.vala:1544: ScriptRunner[%s]: read op after sleep; writing dat" \
"a '%s'", _tmp6_, _tmp9_);
				_g_free0 (_tmp9_);
				_tmp10_ = data;
				_tmp10__length1 = data_length1;
				_tmp11_ = data;
				_tmp11__length1 = data_length1;
				l = write (self->priv->fd, _tmp10_, (gsize) _tmp11__length1);
				if (l < ((gssize) 0)) {
					const gchar* _tmp12_;
					const gchar* _tmp13_;
					_tmp12_ = self->priv->_device;
					_tmp13_ = g_strerror (errno);
					g_error ("umockdev.vala:1547: ScriptRunner[%s]: write failed: %s", _tmp12_, _tmp13_);
				}
				_tmp14_ = data;
				_tmp14__length1 = data_length1;
				_vala_assert (l == ((gssize) _tmp14__length1), "l == data.length");
				break;
			}
			case 'w':
			{
				const gchar* _tmp15_;
				guint8* _tmp16_;
				gint _tmp16__length1;
				gchar* _tmp17_;
				gchar* _tmp18_;
				guint8* _tmp19_;
				gint _tmp19__length1;
				_tmp15_ = self->priv->_device;
				_tmp16_ = data;
				_tmp16__length1 = data_length1;
				_tmp17_ = umockdev_script_runner_encode (_tmp16_, (gint) _tmp16__length1);
				_tmp18_ = _tmp17_;
				g_debug ("umockdev.vala:1552: ScriptRunner[%s]: write op, data '%s'", _tmp15_, _tmp18_);
				_g_free0 (_tmp18_);
				_tmp19_ = data;
				_tmp19__length1 = data_length1;
				umockdev_script_runner_op_write (self, _tmp19_, (gint) _tmp19__length1, delta);
				break;
			}
			case 'Q':
			{
				self->priv->running = FALSE;
				break;
			}
			case 'f':
			{
				const gchar* _tmp21_;
				if (delta > ((guint32) 100)) {
					const gchar* _tmp20_;
					_tmp20_ = self->priv->_device;
					g_error ("umockdev.vala:1562: ScriptRunner[%s]: fuzz value %u is invalid (must b" \
"e between 0 and 100)", _tmp20_, (guint) delta);
				}
				self->priv->fuzz = (guint) delta;
				_tmp21_ = self->priv->_device;
				g_debug ("umockdev.vala:1565: ScriptRunner[%s]: setting fuzz level to %u%%", _tmp21_, self->priv->fuzz);
				break;
			}
			case 'd':
			{
				break;
			}
			default:
			{
				const gchar* _tmp22_;
				_tmp22_ = self->priv->_device;
				g_debug ("umockdev.vala:1573: ScriptRunner[%s]: got unknown line op %c, ignoring", _tmp22_, (gint) op);
				break;
			}
		}
	}
	_tmp23_ = self->priv->_device;
	g_debug ("umockdev.vala:1578: ScriptRunner[%s]: not running any more, ending thr" \
"ead", _tmp23_);
	result = NULL;
	data = (g_free (data), NULL);
	return result;
}

static gchar*
g_file_stream_read_line (FILE* self)
{
	gint c = 0;
	GString* ret = NULL;
	GString* _tmp3_;
	gchar* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	ret = NULL;
	while (TRUE) {
		GString* _tmp0_;
		GString* _tmp2_;
		c = fgetc (self);
		if (!(c != EOF)) {
			break;
		}
		_tmp0_ = ret;
		if (_tmp0_ == NULL) {
			GString* _tmp1_;
			_tmp1_ = g_string_new ("");
			_g_string_free0 (ret);
			ret = _tmp1_;
		}
		if (c == ((gint) '\n')) {
			break;
		}
		_tmp2_ = ret;
		g_string_append_c ((GString*) _tmp2_, (gchar) c);
	}
	_tmp3_ = ret;
	if (_tmp3_ == NULL) {
		result = NULL;
		_g_string_free0 (ret);
		return result;
	} else {
		GString* _tmp4_;
		const gchar* _tmp5_;
		gchar* _tmp6_;
		_tmp4_ = ret;
		_tmp5_ = ((GString*) _tmp4_)->str;
		_tmp6_ = g_strdup (_tmp5_);
		result = _tmp6_;
		_g_string_free0 (ret);
		return result;
	}
	_g_string_free0 (ret);
}

static guint8*
umockdev_script_runner_next_line (UMockdevScriptRunner* self,
                                  gchar* op,
                                  guint32* delta,
                                  gint* result_length1)
{
	gchar _vala_op = '\0';
	guint32 _vala_delta = 0U;
	gint c = 0;
	glong cur_pos = 0L;
	FILE* _tmp9_;
	FILE* _tmp10_;
	FILE* _tmp12_;
	FILE* _tmp13_;
	guint32 _tmp14_ = 0U;
	gint _tmp15_;
	gchar* line = NULL;
	FILE* _tmp17_;
	gchar* _tmp18_;
	const gchar* _tmp19_;
	const gchar* _tmp20_;
	gint _tmp21_ = 0;
	guint8* _tmp22_;
	guint8* _tmp23_;
	gint _tmp23__length1;
	guint8* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	{
		gboolean _tmp0_ = FALSE;
		_tmp0_ = TRUE;
		while (TRUE) {
			FILE* _tmp1_;
			if (!_tmp0_) {
			}
			_tmp0_ = FALSE;
			_tmp1_ = self->priv->script;
			c = fgetc (_tmp1_);
			if (c == EOF) {
				const gchar* _tmp2_;
				const gchar* _tmp3_;
				guint8* _tmp4_;
				guint8* _tmp5_;
				gint _tmp5__length1;
				_tmp2_ = self->priv->_device;
				_tmp3_ = self->priv->script_file;
				g_debug ("umockdev.vala:1589: ScriptRunner[%s]: end of script %s, closing", _tmp2_, _tmp3_);
				_vala_op = 'Q';
				_vala_delta = (guint32) 0;
				_tmp4_ = g_new0 (guint8, 0);
				_tmp5_ = _tmp4_;
				_tmp5__length1 = 0;
				if (result_length1) {
					*result_length1 = _tmp5__length1;
				}
				result = _tmp5_;
				if (op) {
					*op = _vala_op;
				}
				if (delta) {
					*delta = _vala_delta;
				}
				return result;
			} else {
				if (c == ((gint) '#')) {
					FILE* _tmp6_;
					gchar* _tmp7_;
					gchar* _tmp8_;
					_tmp6_ = self->priv->script;
					_tmp7_ = g_file_stream_read_line (_tmp6_);
					_tmp8_ = _tmp7_;
					_vala_assert (_tmp8_ != NULL, "this.script.read_line () != null");
					_g_free0 (_tmp8_);
				} else {
					if (c != ((gint) '\n')) {
						_vala_op = (gchar) c;
						break;
					}
				}
			}
		}
	}
	_tmp9_ = self->priv->script;
	cur_pos = ftell (_tmp9_);
	_tmp10_ = self->priv->script;
	if (fgetc (_tmp10_) != ((gint) ' ')) {
		const gchar* _tmp11_;
		_tmp11_ = self->priv->script_file;
		g_error ("umockdev.vala:1603: Missing space after operation code in %s at positi" \
"on %li", _tmp11_, cur_pos);
	}
	_tmp12_ = self->priv->script;
	cur_pos = ftell (_tmp12_);
	_tmp13_ = self->priv->script;
	_tmp15_ = fscanf (_tmp13_, "%" G_GUINT32_FORMAT " ", &_tmp14_);
	_vala_delta = _tmp14_;
	if (_tmp15_ != 1) {
		const gchar* _tmp16_;
		_tmp16_ = self->priv->script_file;
		g_error ("umockdev.vala:1608: Cannot parse time in %s at position %li", _tmp16_, cur_pos);
	}
	_tmp17_ = self->priv->script;
	_tmp18_ = g_file_stream_read_line (_tmp17_);
	line = _tmp18_;
	_tmp19_ = line;
	_vala_assert (_tmp19_ != NULL, "line != null");
	_tmp20_ = line;
	_tmp22_ = umockdev_script_runner_decode (_tmp20_, &_tmp21_);
	_tmp23_ = _tmp22_;
	_tmp23__length1 = _tmp21_;
	if (result_length1) {
		*result_length1 = _tmp23__length1;
	}
	result = _tmp23_;
	_g_free0 (line);
	if (op) {
		*op = _vala_op;
	}
	if (delta) {
		*delta = _vala_delta;
	}
	return result;
}

static void
umockdev_script_runner_op_write (UMockdevScriptRunner* self,
                                 guint8* data,
                                 gint data_length1,
                                 guint32 delta)
{
	fd_set fds = {0};
	struct timeval timeout = {0};
	struct timeval _tmp0_ = {0};
	gsize offset = 0UL;
	guint8* buf = NULL;
	guint8* _tmp1_;
	gint buf_length1;
	gint _buf_size_;
	g_return_if_fail (self != NULL);
	_tmp0_.tv_sec = (time_t) 0;
	_tmp0_.tv_usec = (glong) 200000;
	timeout = _tmp0_;
	offset = (gsize) 0;
	_tmp1_ = g_new0 (guint8, data_length1);
	buf = _tmp1_;
	buf_length1 = data_length1;
	_buf_size_ = buf_length1;
	while (TRUE) {
		gboolean _tmp2_ = FALSE;
		fd_set _tmp3_ = {0};
		gint res = 0;
		struct timeval _tmp4_;
		gssize len = 0L;
		guint8* _tmp10_;
		gint _tmp10__length1;
		const gchar* _tmp29_;
		if (self->priv->running) {
			_tmp2_ = offset < ((gsize) data_length1);
		} else {
			_tmp2_ = FALSE;
		}
		if (!_tmp2_) {
			break;
		}
		FD_ZERO (&_tmp3_);
		fds = _tmp3_;
		FD_SET (self->priv->fd, &fds);
		_tmp4_ = timeout;
		res = select (self->priv->fd + 1, &fds, NULL, NULL, &_tmp4_);
		if (res < 0) {
			const gchar* _tmp5_;
			const gchar* _tmp6_;
			if (errno == EINTR) {
				continue;
			}
			_tmp5_ = self->priv->_device;
			_tmp6_ = g_strerror (errno);
			g_error ("umockdev.vala:1633: ScriptRunner op_write[%s]: select() failed: %s", _tmp5_, _tmp6_);
		}
		if (res == 0) {
			const gchar* _tmp7_;
			gchar* _tmp8_;
			gchar* _tmp9_;
			_tmp7_ = self->priv->_device;
			_tmp8_ = umockdev_script_runner_encode (data + ((gint) offset), (gint) (data_length1 - ((gint) offset)));
			_tmp9_ = _tmp8_;
			g_debug ("umockdev.vala:1638: ScriptRunner[%s]: timed out on read operation on e" \
"xpected block '%s', trying again", _tmp7_, _tmp9_);
			_g_free0 (_tmp9_);
			continue;
		}
		_tmp10_ = buf;
		_tmp10__length1 = buf_length1;
		len = read (self->priv->fd, _tmp10_, data_length1 - offset);
		if (len <= ((gssize) 0)) {
			const gchar* _tmp11_;
			gchar* _tmp12_;
			gchar* _tmp13_;
			FILE* _tmp14_;
			_tmp11_ = self->priv->_device;
			_tmp12_ = umockdev_script_runner_encode (data + ((gint) offset), (gint) (data_length1 - ((gint) offset)));
			_tmp13_ = _tmp12_;
			g_debug ("umockdev.vala:1646: ScriptRunner[%s]: got failure or EOF on read opera" \
"tion on expected block '%s', resetting", _tmp11_, _tmp13_);
			_g_free0 (_tmp13_);
			_tmp14_ = self->priv->script;
			fseek (_tmp14_, (glong) 0, SEEK_SET);
			buf = (g_free (buf), NULL);
			return;
		}
		if (self->priv->fuzz == ((guint) 0)) {
			guint8* _tmp15_;
			gint _tmp15__length1;
			_tmp15_ = buf;
			_tmp15__length1 = buf_length1;
			if (memcmp (_tmp15_, data + ((gint) offset), (gsize) len) != 0) {
				const gchar* _tmp16_;
				guint8* _tmp17_;
				gint _tmp17__length1;
				gchar* _tmp18_;
				gchar* _tmp19_;
				gchar* _tmp20_;
				gchar* _tmp21_;
				_tmp16_ = self->priv->_device;
				_tmp17_ = buf;
				_tmp17__length1 = buf_length1;
				_tmp18_ = umockdev_script_runner_encode (_tmp17_, (gint) _tmp17__length1);
				_tmp19_ = _tmp18_;
				_tmp20_ = umockdev_script_runner_encode (data + ((gint) offset), (gint) (((gint) (offset + len)) - ((gint) offset)));
				_tmp21_ = _tmp20_;
				g_error ("ScriptRunner op_write[%s]: data mismatch; got block '%s' (%" G_GSSIZE_FORMAT " bytes), expected block '%s'", _tmp16_, _tmp19_, len, _tmp21_);
				_g_free0 (_tmp21_);
				_g_free0 (_tmp19_);
			}
		} else {
			guint d = 0U;
			guint8* _tmp22_;
			gint _tmp22__length1;
			_tmp22_ = buf;
			_tmp22__length1 = buf_length1;
			d = umockdev_script_runner_hamming (_tmp22_, (gint) _tmp22__length1, data + ((gint) offset), (gint) (((gint) (offset + len)) - ((gint) offset)));
			if (((gssize) (d * 100)) > (self->priv->fuzz * len)) {
				const gchar* _tmp23_;
				guint8* _tmp24_;
				gint _tmp24__length1;
				gchar* _tmp25_;
				gchar* _tmp26_;
				gchar* _tmp27_;
				gchar* _tmp28_;
				_tmp23_ = self->priv->_device;
				_tmp24_ = buf;
				_tmp24__length1 = buf_length1;
				_tmp25_ = umockdev_script_runner_encode (_tmp24_, (gint) _tmp24__length1);
				_tmp26_ = _tmp25_;
				_tmp27_ = umockdev_script_runner_encode (data + ((gint) offset), (gint) (((gint) (offset + len)) - ((gint) offset)));
				_tmp28_ = _tmp27_;
				g_error ("ScriptRunner op_write[%s]: data mismatch; got block '%s' (%" G_GSSIZE_FORMAT " bytes), expected block '%s', difference %u%% > fuzz level %u%%", _tmp23_, _tmp26_, len, _tmp28_, ((guint) (((d * 1000) / len) + 5)) / 10, self->priv->fuzz);
				_g_free0 (_tmp28_);
				_g_free0 (_tmp26_);
			}
		}
		offset = offset + len;
		_tmp29_ = self->priv->_device;
		g_debug ("ScriptRunner[%s]: op_write, got %" G_GSSIZE_FORMAT " bytes; offset: %" G_GSIZE_FORMAT ", full block size %i", _tmp29_, len, offset, data_length1);
	}
	buf = (g_free (buf), NULL);
}

static void
_vala_array_add12 (guint8* * array,
                   int* length,
                   int* size,
                   guint8 value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (guint8, *array, *size);
	}
	(*array)[(*length)++] = value;
}

static void
_vala_array_add13 (guint8* * array,
                   int* length,
                   int* size,
                   guint8 value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (guint8, *array, *size);
	}
	(*array)[(*length)++] = value;
}

static guint8*
umockdev_script_runner_decode (const gchar* quoted,
                               gint* result_length1)
{
	guint8* data = NULL;
	guint8* _tmp0_;
	gint data_length1;
	gint _data_size_;
	guint8* _tmp21_;
	gint _tmp21__length1;
	guint8* result = NULL;
	g_return_val_if_fail (quoted != NULL, NULL);
	_tmp0_ = g_new0 (guint8, 0);
	data = _tmp0_;
	data_length1 = 0;
	_data_size_ = data_length1;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp1_ = FALSE;
			_tmp1_ = TRUE;
			while (TRUE) {
				gint _tmp2_;
				gint _tmp3_;
				guint8* _tmp4_;
				gint _tmp4__length1;
				guint8* _tmp5_;
				gint _tmp5__length1;
				guint8 _tmp6_;
				if (!_tmp1_) {
					i = i + 1;
				}
				_tmp1_ = FALSE;
				_tmp2_ = strlen (quoted);
				_tmp3_ = _tmp2_;
				if (!(i < _tmp3_)) {
					break;
				}
				_tmp4_ = string_get_data (quoted, &_tmp4__length1);
				_tmp5_ = _tmp4_;
				_tmp5__length1 = _tmp4__length1;
				_tmp6_ = _tmp5_[i];
				if (_tmp6_ == ((guint8) '^')) {
					gint _tmp7_;
					gint _tmp8_;
					gchar _tmp9_ = '\0';
					guint8* _tmp10_;
					gint _tmp10__length1;
					guint8* _tmp11_;
					gint _tmp11__length1;
					guint8 _tmp12_;
					guint8* _tmp16_;
					gint _tmp16__length1;
					_tmp7_ = strlen (quoted);
					_tmp8_ = _tmp7_;
					_vala_assert ((i + 1) < _tmp8_, "i + 1 < quoted.length");
					_tmp10_ = string_get_data (quoted, &_tmp10__length1);
					_tmp11_ = _tmp10_;
					_tmp11__length1 = _tmp10__length1;
					_tmp12_ = _tmp11_[i + 1];
					if (_tmp12_ == ((guint8) '`')) {
						_tmp9_ = '^';
					} else {
						guint8* _tmp13_;
						gint _tmp13__length1;
						guint8* _tmp14_;
						gint _tmp14__length1;
						guint8 _tmp15_;
						_tmp13_ = string_get_data (quoted, &_tmp13__length1);
						_tmp14_ = _tmp13_;
						_tmp14__length1 = _tmp13__length1;
						_tmp15_ = _tmp14_[i + 1];
						_tmp9_ = (gchar) (_tmp15_ - 64);
					}
					_tmp16_ = data;
					_tmp16__length1 = data_length1;
					_vala_array_add12 (&data, &data_length1, &_data_size_, (guint8) _tmp9_);
					i = i + 1;
				} else {
					guint8* _tmp17_;
					gint _tmp17__length1;
					guint8* _tmp18_;
					gint _tmp18__length1;
					guint8* _tmp19_;
					gint _tmp19__length1;
					guint8 _tmp20_;
					_tmp17_ = data;
					_tmp17__length1 = data_length1;
					_tmp18_ = string_get_data (quoted, &_tmp18__length1);
					_tmp19_ = _tmp18_;
					_tmp19__length1 = _tmp18__length1;
					_tmp20_ = _tmp19_[i];
					_vala_array_add13 (&data, &data_length1, &_data_size_, _tmp20_);
				}
			}
		}
	}
	_tmp21_ = data;
	_tmp21__length1 = data_length1;
	if (result_length1) {
		*result_length1 = _tmp21__length1;
	}
	result = _tmp21_;
	return result;
}

static void
_vala_array_add14 (guint8* * array,
                   int* length,
                   int* size,
                   guint8 value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (guint8, *array, *size);
	}
	(*array)[(*length)++] = value;
}

static void
_vala_array_add15 (guint8* * array,
                   int* length,
                   int* size,
                   guint8 value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (guint8, *array, *size);
	}
	(*array)[(*length)++] = value;
}

static void
_vala_array_add16 (guint8* * array,
                   int* length,
                   int* size,
                   guint8 value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (guint8, *array, *size);
	}
	(*array)[(*length)++] = value;
}

static void
_vala_array_add17 (guint8* * array,
                   int* length,
                   int* size,
                   guint8 value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (guint8, *array, *size);
	}
	(*array)[(*length)++] = value;
}

static void
_vala_array_add18 (guint8* * array,
                   int* length,
                   int* size,
                   guint8 value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (guint8, *array, *size);
	}
	(*array)[(*length)++] = value;
}

static void
_vala_array_add19 (guint8* * array,
                   int* length,
                   int* size,
                   guint8 value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (guint8, *array, *size);
	}
	(*array)[(*length)++] = value;
}

gchar*
umockdev_script_runner_encode (guint8* data,
                               gint data_length1)
{
	guint8* quoted = NULL;
	guint8* _tmp0_;
	gint quoted_length1;
	gint _quoted_size_;
	guint8* _tmp11_;
	gint _tmp11__length1;
	guint8* _tmp12_;
	gint _tmp12__length1;
	gchar* _tmp13_;
	gchar* result = NULL;
	_tmp0_ = g_new0 (guint8, 0);
	quoted = _tmp0_;
	quoted_length1 = 0;
	_quoted_size_ = quoted_length1;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp1_ = FALSE;
			_tmp1_ = TRUE;
			while (TRUE) {
				guint8 _tmp2_;
				if (!_tmp1_) {
					i = i + 1;
				}
				_tmp1_ = FALSE;
				if (!(i < data_length1)) {
					break;
				}
				_tmp2_ = data[i];
				if (((gint) _tmp2_) < 32) {
					guint8* _tmp3_;
					gint _tmp3__length1;
					guint8* _tmp4_;
					gint _tmp4__length1;
					guint8 _tmp5_;
					_tmp3_ = quoted;
					_tmp3__length1 = quoted_length1;
					_vala_array_add14 (&quoted, &quoted_length1, &_quoted_size_, (guint8) '^');
					_tmp4_ = quoted;
					_tmp4__length1 = quoted_length1;
					_tmp5_ = data[i];
					_vala_array_add15 (&quoted, &quoted_length1, &_quoted_size_, (guint8) (_tmp5_ + 64));
				} else {
					guint8 _tmp6_;
					_tmp6_ = data[i];
					if (_tmp6_ == ((guint8) '^')) {
						guint8* _tmp7_;
						gint _tmp7__length1;
						guint8* _tmp8_;
						gint _tmp8__length1;
						_tmp7_ = quoted;
						_tmp7__length1 = quoted_length1;
						_vala_array_add16 (&quoted, &quoted_length1, &_quoted_size_, (guint8) '^');
						_tmp8_ = quoted;
						_tmp8__length1 = quoted_length1;
						_vala_array_add17 (&quoted, &quoted_length1, &_quoted_size_, (guint8) '`');
					} else {
						guint8* _tmp9_;
						gint _tmp9__length1;
						guint8 _tmp10_;
						_tmp9_ = quoted;
						_tmp9__length1 = quoted_length1;
						_tmp10_ = data[i];
						_vala_array_add18 (&quoted, &quoted_length1, &_quoted_size_, _tmp10_);
					}
				}
			}
		}
	}
	_tmp11_ = quoted;
	_tmp11__length1 = quoted_length1;
	_vala_array_add19 (&quoted, &quoted_length1, &_quoted_size_, (guint8) 0);
	_tmp12_ = quoted;
	_tmp12__length1 = quoted_length1;
	_tmp13_ = g_strdup ((const gchar*) _tmp12_);
	result = _tmp13_;
	quoted = (g_free (quoted), NULL);
	return result;
}

static guint
umockdev_script_runner_hamming (guint8* d1,
                                gint d1_length1,
                                guint8* d2,
                                gint d2_length1)
{
	guint d = 0U;
	guint i = 0U;
	guint result = 0U;
	_vala_assert (d1_length1 == d2_length1, "d1.length == d2.length");
	d = (guint) 0;
	{
		gboolean _tmp0_ = FALSE;
		i = (guint) 0;
		_tmp0_ = TRUE;
		while (TRUE) {
			guint8 _tmp1_;
			guint8 _tmp2_;
			if (!_tmp0_) {
				i = i + 1;
			}
			_tmp0_ = FALSE;
			if (!(i < ((guint) d1_length1))) {
				break;
			}
			_tmp1_ = d1[i];
			_tmp2_ = d2[i];
			d = d + ((guint) (((gint) (_tmp1_ ^ _tmp2_)) > 0));
		}
	}
	result = d;
	return result;
}

const gchar*
umockdev_script_runner_get_device (UMockdevScriptRunner* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_device;
	result = _tmp0_;
	return result;
}

static void
umockdev_script_runner_set_device (UMockdevScriptRunner* self,
                                   const gchar* value)
{
	gchar* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_strdup (value);
	_g_free0 (self->priv->_device);
	self->priv->_device = _tmp0_;
}

static void
umockdev_value_script_runner_init (GValue* value)
{
	value->data[0].v_pointer = NULL;
}

static void
umockdev_value_script_runner_free_value (GValue* value)
{
	if (value->data[0].v_pointer) {
		umockdev_script_runner_unref (value->data[0].v_pointer);
	}
}

static void
umockdev_value_script_runner_copy_value (const GValue* src_value,
                                         GValue* dest_value)
{
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = umockdev_script_runner_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}

static gpointer
umockdev_value_script_runner_peek_pointer (const GValue* value)
{
	return value->data[0].v_pointer;
}

static gchar*
umockdev_value_script_runner_collect_value (GValue* value,
                                            guint n_collect_values,
                                            GTypeCValue* collect_values,
                                            guint collect_flags)
{
	if (collect_values[0].v_pointer) {
		UMockdevScriptRunner * object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = umockdev_script_runner_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}

static gchar*
umockdev_value_script_runner_lcopy_value (const GValue* value,
                                          guint n_collect_values,
                                          GTypeCValue* collect_values,
                                          guint collect_flags)
{
	UMockdevScriptRunner ** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = umockdev_script_runner_ref (value->data[0].v_pointer);
	}
	return NULL;
}

GParamSpec*
umockdev_param_spec_script_runner (const gchar* name,
                                   const gchar* nick,
                                   const gchar* blurb,
                                   GType object_type,
                                   GParamFlags flags)
{
	UMockdevParamSpecScriptRunner* spec;
	g_return_val_if_fail (g_type_is_a (object_type, UMOCKDEV_TYPE_SCRIPT_RUNNER), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}

gpointer
umockdev_value_get_script_runner (const GValue* value)
{
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, UMOCKDEV_TYPE_SCRIPT_RUNNER), NULL);
	return value->data[0].v_pointer;
}

void
umockdev_value_set_script_runner (GValue* value,
                                  gpointer v_object)
{
	UMockdevScriptRunner * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, UMOCKDEV_TYPE_SCRIPT_RUNNER));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, UMOCKDEV_TYPE_SCRIPT_RUNNER));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		umockdev_script_runner_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		umockdev_script_runner_unref (old);
	}
}

void
umockdev_value_take_script_runner (GValue* value,
                                   gpointer v_object)
{
	UMockdevScriptRunner * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, UMOCKDEV_TYPE_SCRIPT_RUNNER));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, UMOCKDEV_TYPE_SCRIPT_RUNNER));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		umockdev_script_runner_unref (old);
	}
}

static void
umockdev_script_runner_class_init (UMockdevScriptRunnerClass * klass,
                                   gpointer klass_data)
{
	umockdev_script_runner_parent_class = g_type_class_peek_parent (klass);
	((UMockdevScriptRunnerClass *) klass)->finalize = umockdev_script_runner_finalize;
	g_type_class_adjust_private_offset (klass, &UMockdevScriptRunner_private_offset);
}

static void
umockdev_script_runner_instance_init (UMockdevScriptRunner * self,
                                      gpointer klass)
{
	self->priv = umockdev_script_runner_get_instance_private (self);
	self->priv->fuzz = (guint) 0;
	self->ref_count = 1;
}

static void
umockdev_script_runner_finalize (UMockdevScriptRunner * obj)
{
	UMockdevScriptRunner * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, UMOCKDEV_TYPE_SCRIPT_RUNNER, UMockdevScriptRunner);
	g_signal_handlers_destroy (self);
	umockdev_script_runner_stop (self);
	_g_free0 (self->priv->_device);
	_g_free0 (self->priv->script_file);
	_g_thread_unref0 (self->priv->thread);
	_fclose0 (self->priv->script);
}

GType
umockdev_script_runner_get_type (void)
{
	static volatile gsize umockdev_script_runner_type_id__volatile = 0;
	if (g_once_init_enter (&umockdev_script_runner_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { umockdev_value_script_runner_init, umockdev_value_script_runner_free_value, umockdev_value_script_runner_copy_value, umockdev_value_script_runner_peek_pointer, "p", umockdev_value_script_runner_collect_value, "p", umockdev_value_script_runner_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (UMockdevScriptRunnerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) umockdev_script_runner_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (UMockdevScriptRunner), 0, (GInstanceInitFunc) umockdev_script_runner_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType umockdev_script_runner_type_id;
		umockdev_script_runner_type_id = g_type_register_fundamental (g_type_fundamental_next (), "UMockdevScriptRunner", &g_define_type_info, &g_define_type_fundamental_info, 0);
		UMockdevScriptRunner_private_offset = g_type_add_instance_private (umockdev_script_runner_type_id, sizeof (UMockdevScriptRunnerPrivate));
		g_once_init_leave (&umockdev_script_runner_type_id__volatile, umockdev_script_runner_type_id);
	}
	return umockdev_script_runner_type_id__volatile;
}

gpointer
umockdev_script_runner_ref (gpointer instance)
{
	UMockdevScriptRunner * self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}

void
umockdev_script_runner_unref (gpointer instance)
{
	UMockdevScriptRunner * self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		UMOCKDEV_SCRIPT_RUNNER_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}

static inline gpointer
umockdev_socket_server_get_instance_private (UMockdevSocketServer* self)
{
	return G_STRUCT_MEMBER_P (self, UMockdevSocketServer_private_offset);
}

static gpointer
_umockdev_socket_server_run_gthread_func (gpointer self)
{
	gpointer result;
	result = umockdev_socket_server_run ((UMockdevSocketServer*) self);
	umockdev_socket_server_unref (self);
	return result;
}

UMockdevSocketServer*
umockdev_socket_server_construct (GType object_type)
{
	UMockdevSocketServer* self = NULL;
	GHashFunc _tmp0_;
	GEqualFunc _tmp1_;
	GHashTable* _tmp2_;
	GHashFunc _tmp3_;
	GEqualFunc _tmp4_;
	GHashTable* _tmp5_;
	GThread* _tmp6_;
	gint* fds = NULL;
	gint* _tmp7_;
	gint fds_length1;
	gint _fds_size_;
	gint _tmp8_;
	gint _tmp9_;
	self = (UMockdevSocketServer*) g_type_create_instance (object_type);
	self->priv->running = TRUE;
	_tmp0_ = g_str_hash;
	_tmp1_ = g_str_equal;
	_tmp2_ = g_hash_table_new_full (_tmp0_, _tmp1_, _g_free0_, _g_free0_);
	_g_hash_table_unref0 (self->priv->socket_scriptfile);
	self->priv->socket_scriptfile = _tmp2_;
	_tmp3_ = g_str_hash;
	_tmp4_ = g_str_equal;
	_tmp5_ = g_hash_table_new_full (_tmp3_, _tmp4_, _g_free0_, _umockdev_script_runner_unref0_);
	_g_hash_table_unref0 (self->priv->script_runners);
	self->priv->script_runners = _tmp5_;
	_tmp6_ = g_thread_new ("SocketServer", _umockdev_socket_server_run_gthread_func, umockdev_socket_server_ref (self));
	_g_thread_unref0 (self->priv->thread);
	self->priv->thread = _tmp6_;
	_tmp7_ = g_new0 (gint, 2);
	fds = _tmp7_;
	fds_length1 = 2;
	_fds_size_ = fds_length1;
	_vala_assert (pipe (fds) == 0, "Posix.pipe (fds) == 0");
	_tmp8_ = fds[0];
	self->priv->ctrl_r = _tmp8_;
	_tmp9_ = fds[1];
	self->priv->ctrl_w = _tmp9_;
	fds = (g_free (fds), NULL);
	return self;
}

UMockdevSocketServer*
umockdev_socket_server_new (void)
{
	return umockdev_socket_server_construct (UMOCKDEV_TYPE_SOCKET_SERVER);
}

void
umockdev_socket_server_stop (UMockdevSocketServer* self)
{
	gchar b = '\0';
	GHashTable* _tmp0_;
	GList* _tmp1_;
	GHashTable* _tmp3_;
	GThread* _tmp4_;
	g_return_if_fail (self != NULL);
	if (!self->priv->running) {
		return;
	}
	self->priv->running = FALSE;
	g_debug ("umockdev.vala:1766: Stopping SocketServer: signalling thread");
	b = '1';
	_vala_assert (write (self->priv->ctrl_w, &b, (gsize) 1) == ((gssize) 1), "Posix.write (this.ctrl_w, &b, 1) == 1");
	_tmp0_ = self->priv->script_runners;
	_tmp1_ = g_hash_table_get_values (_tmp0_);
	{
		GList* r_collection = NULL;
		GList* r_it = NULL;
		r_collection = _tmp1_;
		for (r_it = r_collection; r_it != NULL; r_it = r_it->next) {
			UMockdevScriptRunner* r = NULL;
			r = (UMockdevScriptRunner*) r_it->data;
			{
				UMockdevScriptRunner* _tmp2_;
				_tmp2_ = r;
				umockdev_script_runner_stop (_tmp2_);
			}
		}
		(r_collection == NULL) ? NULL : (r_collection = (g_list_free (r_collection), NULL));
	}
	_tmp3_ = self->priv->script_runners;
	g_hash_table_remove_all (_tmp3_);
	g_debug ("umockdev.vala:1775: Stopping SocketServer: joining thread");
	_tmp4_ = self->priv->thread;
	self->priv->thread = NULL;
	g_thread_join (_tmp4_);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
_vala_array_add20 (GSocket** * array,
                   int* length,
                   int* size,
                   GSocket* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (GSocket*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

void
umockdev_socket_server_add (UMockdevSocketServer* self,
                            const gchar* sock_path,
                            gint fd,
                            const gchar* record_file)
{
	GHashTable* _tmp13_;
	gchar* _tmp14_;
	gchar* _tmp15_;
	gchar b = '\0';
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (sock_path != NULL);
	g_return_if_fail (record_file != NULL);
	{
		GSocket* s = NULL;
		GSocket* _tmp0_;
		GSocket* _tmp1_;
		gboolean _tmp2_ = FALSE;
		GSocket* _tmp3_;
		GUnixSocketAddress* _tmp4_;
		GUnixSocketAddress* _tmp5_;
		gboolean _tmp6_;
		gboolean _tmp7_ = FALSE;
		GSocket* _tmp8_;
		GSocket** _tmp9_;
		gint _tmp9__length1;
		GSocket* _tmp10_;
		GSocket* _tmp11_;
		_tmp0_ = g_socket_new_from_fd (fd, &_inner_error0_);
		s = _tmp0_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch12_g_error;
		}
		_tmp1_ = s;
		_vala_assert (_tmp1_ != NULL, "s != null");
		_tmp3_ = s;
		_tmp4_ = (GUnixSocketAddress*) g_unix_socket_address_new (sock_path);
		_tmp5_ = _tmp4_;
		_tmp6_ = g_socket_bind (_tmp3_, (GSocketAddress*) _tmp5_, TRUE, &_inner_error0_);
		_g_object_unref0 (_tmp5_);
		_tmp2_ = _tmp6_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_object_unref0 (s);
			goto __catch12_g_error;
		}
		_vala_assert (_tmp2_, "s.bind (new UnixSocketAddress (sock_path), true)");
		_tmp8_ = s;
		_tmp7_ = g_socket_listen (_tmp8_, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_object_unref0 (s);
			goto __catch12_g_error;
		}
		_vala_assert (_tmp7_, "s.listen ()");
		_tmp9_ = self->priv->listen_sockets;
		_tmp9__length1 = self->priv->listen_sockets_length1;
		_tmp10_ = s;
		_tmp11_ = _g_object_ref0 (_tmp10_);
		_vala_array_add20 (&self->priv->listen_sockets, &self->priv->listen_sockets_length1, &self->priv->_listen_sockets_size_, _tmp11_);
		_g_object_unref0 (s);
	}
	goto __finally12;
	__catch12_g_error:
	{
		GError* e = NULL;
		const gchar* _tmp12_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp12_ = e->message;
		g_error ("umockdev.vala:1788: load_socket_script(): cannot create Socket: %s", _tmp12_);
		_g_error_free0 (e);
	}
	__finally12:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	g_debug ("umockdev.vala:1791: SocketServer.add: Created socket path %s, fd %i", sock_path, fd);
	_tmp13_ = self->priv->socket_scriptfile;
	_tmp14_ = g_strdup (sock_path);
	_tmp15_ = g_strdup (record_file);
	g_hash_table_insert (_tmp13_, _tmp14_, _tmp15_);
	b = '1';
	_vala_assert (write (self->priv->ctrl_w, &b, (gsize) 1) == ((gssize) 1), "Posix.write (this.ctrl_w, &b, 1) == 1");
}

static void*
umockdev_socket_server_run (UMockdevSocketServer* self)
{
	GError* _inner_error0_ = NULL;
	void* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_debug ("umockdev.vala:1802: starting SocketServer thread");
	while (TRUE) {
		fd_set fds = {0};
		fd_set _tmp0_ = {0};
		gint max = 0;
		GSocket** _tmp1_;
		gint _tmp1__length1;
		gint res = 0;
		struct timeval _tmp11_ = {0};
		fd_set _tmp13_;
		GSocket** _tmp14_;
		gint _tmp14__length1;
		if (!self->priv->running) {
			break;
		}
		FD_ZERO (&_tmp0_);
		fds = _tmp0_;
		FD_SET (self->priv->ctrl_r, &fds);
		max = self->priv->ctrl_r;
		_tmp1_ = self->priv->listen_sockets;
		_tmp1__length1 = self->priv->listen_sockets_length1;
		{
			GSocket** s_collection = NULL;
			gint s_collection_length1 = 0;
			gint _s_collection_size_ = 0;
			gint s_it = 0;
			s_collection = _tmp1_;
			s_collection_length1 = _tmp1__length1;
			for (s_it = 0; s_it < s_collection_length1; s_it = s_it + 1) {
				GSocket* s = NULL;
				s = s_collection[s_it];
				{
					GSocket* _tmp2_;
					gint _tmp3_;
					gint _tmp4_;
					GSocket* _tmp5_;
					gint _tmp6_;
					gint _tmp7_;
					_tmp2_ = s;
					_tmp3_ = g_socket_get_fd (_tmp2_);
					_tmp4_ = _tmp3_;
					FD_SET (_tmp4_, &fds);
					_tmp5_ = s;
					_tmp6_ = g_socket_get_fd (_tmp5_);
					_tmp7_ = _tmp6_;
					if (_tmp7_ > max) {
						GSocket* _tmp8_;
						gint _tmp9_;
						gint _tmp10_;
						_tmp8_ = s;
						_tmp9_ = g_socket_get_fd (_tmp8_);
						_tmp10_ = _tmp9_;
						max = _tmp10_;
					}
				}
			}
		}
		_tmp11_.tv_sec = (time_t) 0;
		_tmp11_.tv_usec = (glong) 500000;
		res = select (max + 1, &fds, NULL, NULL, &_tmp11_);
		if (res < 0) {
			const gchar* _tmp12_;
			if (errno == EINTR) {
				continue;
			}
			_tmp12_ = g_strerror (errno);
			g_error ("umockdev.vala:1821: socket server thread: select() failed: %s", _tmp12_);
		}
		if (res == 0) {
			continue;
		}
		_tmp13_ = fds;
		if (FD_ISSET (self->priv->ctrl_r, &_tmp13_) > 0) {
			gchar buf = '\0';
			g_debug ("umockdev.vala:1828: socket server thread: woken up by control fd");
			_vala_assert (read (self->priv->ctrl_r, &buf, (gsize) 1) == ((gssize) 1), "Posix.read (this.ctrl_r, &buf, 1) == 1");
			continue;
		}
		g_debug ("umockdev.vala:1834: socket server thread: select() got requests");
		_tmp14_ = self->priv->listen_sockets;
		_tmp14__length1 = self->priv->listen_sockets_length1;
		{
			GSocket** s_collection = NULL;
			gint s_collection_length1 = 0;
			gint _s_collection_size_ = 0;
			gint s_it = 0;
			s_collection = _tmp14_;
			s_collection_length1 = _tmp14__length1;
			for (s_it = 0; s_it < s_collection_length1; s_it = s_it + 1) {
				GSocket* s = NULL;
				s = s_collection[s_it];
				{
					GSocket* _tmp15_;
					gint _tmp16_;
					gint _tmp17_;
					fd_set _tmp18_;
					_tmp15_ = s;
					_tmp16_ = g_socket_get_fd (_tmp15_);
					_tmp17_ = _tmp16_;
					_tmp18_ = fds;
					if (FD_ISSET (_tmp17_, &_tmp18_) > 0) {
						gint fd = 0;
						GSocket* _tmp19_;
						gint _tmp20_;
						gint _tmp21_;
						gchar* sock_path = NULL;
						_tmp19_ = s;
						_tmp20_ = g_socket_get_fd (_tmp19_);
						_tmp21_ = _tmp20_;
						fd = accept (_tmp21_, NULL, NULL);
						if (fd < 0) {
							const gchar* _tmp22_;
							_tmp22_ = g_strerror (errno);
							g_error ("umockdev.vala:1841: socket server thread: accept() failed: %s", _tmp22_);
						}
						sock_path = NULL;
						{
							GSocketAddress* _tmp23_ = NULL;
							GSocket* _tmp24_;
							GSocketAddress* _tmp25_;
							const gchar* _tmp26_;
							const gchar* _tmp27_;
							gchar* _tmp28_;
							gchar* script = NULL;
							GHashTable* _tmp29_;
							const gchar* _tmp30_;
							gconstpointer _tmp31_;
							gchar* _tmp32_;
							GSocket* _tmp33_;
							gint _tmp34_;
							gint _tmp35_;
							const gchar* _tmp36_;
							const gchar* _tmp37_;
							gchar* key = NULL;
							const gchar* _tmp38_;
							gchar* _tmp39_;
							UMockdevScriptRunner* _tmp40_ = NULL;
							const gchar* _tmp41_;
							const gchar* _tmp42_;
							UMockdevScriptRunner* _tmp43_;
							GHashTable* _tmp44_;
							const gchar* _tmp45_;
							gchar* _tmp46_;
							UMockdevScriptRunner* _tmp47_;
							_tmp24_ = s;
							_tmp25_ = g_socket_get_local_address (_tmp24_, &_inner_error0_);
							_tmp23_ = _tmp25_;
							if (G_UNLIKELY (_inner_error0_ != NULL)) {
								goto __catch13_g_error;
							}
							_tmp26_ = g_unix_socket_address_get_path (G_TYPE_CHECK_INSTANCE_CAST (_tmp23_, G_TYPE_UNIX_SOCKET_ADDRESS, GUnixSocketAddress));
							_tmp27_ = _tmp26_;
							_tmp28_ = g_strdup (_tmp27_);
							_g_free0 (sock_path);
							sock_path = _tmp28_;
							_tmp29_ = self->priv->socket_scriptfile;
							_tmp30_ = sock_path;
							_tmp31_ = g_hash_table_lookup (_tmp29_, _tmp30_);
							_tmp32_ = g_strdup ((const gchar*) _tmp31_);
							script = _tmp32_;
							_tmp33_ = s;
							_tmp34_ = g_socket_get_fd (_tmp33_);
							_tmp35_ = _tmp34_;
							_tmp36_ = sock_path;
							_tmp37_ = script;
							g_debug ("umockdev.vala:1846: socket server thread: accepted request on server s" \
"ocket fd %i, path %s, script %s", _tmp35_, _tmp36_, _tmp37_);
							_tmp38_ = sock_path;
							_tmp39_ = g_strdup_printf ("%s%i", _tmp38_, fd);
							key = _tmp39_;
							_tmp41_ = key;
							_tmp42_ = script;
							_tmp43_ = umockdev_script_runner_new (_tmp41_, _tmp42_, fd, &_inner_error0_);
							_tmp40_ = _tmp43_;
							if (G_UNLIKELY (_inner_error0_ != NULL)) {
								_g_free0 (key);
								_g_free0 (script);
								_g_object_unref0 (_tmp23_);
								goto __catch13_g_error;
							}
							_tmp44_ = self->priv->script_runners;
							_tmp45_ = key;
							_tmp46_ = g_strdup (_tmp45_);
							_tmp47_ = _tmp40_;
							_tmp40_ = NULL;
							g_hash_table_insert (_tmp44_, _tmp46_, _tmp47_);
							_umockdev_script_runner_unref0 (_tmp40_);
							_g_free0 (key);
							_g_free0 (script);
							_g_object_unref0 (_tmp23_);
						}
						goto __finally13;
						__catch13_g_error:
						{
							GError* e = NULL;
							const gchar* _tmp48_;
							e = _inner_error0_;
							_inner_error0_ = NULL;
							_tmp48_ = e->message;
							g_error ("umockdev.vala:1851: socket server thread: cannot launch ScriptRunner: " \
"%s", _tmp48_);
							_g_error_free0 (e);
						}
						__finally13:
						if (G_UNLIKELY (_inner_error0_ != NULL)) {
							_g_free0 (sock_path);
							g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
							g_clear_error (&_inner_error0_);
							return NULL;
						}
						_g_free0 (sock_path);
					}
				}
			}
		}
	}
	g_debug ("umockdev.vala:1857: socket server thread: end");
	result = NULL;
	return result;
}

static void
umockdev_value_socket_server_init (GValue* value)
{
	value->data[0].v_pointer = NULL;
}

static void
umockdev_value_socket_server_free_value (GValue* value)
{
	if (value->data[0].v_pointer) {
		umockdev_socket_server_unref (value->data[0].v_pointer);
	}
}

static void
umockdev_value_socket_server_copy_value (const GValue* src_value,
                                         GValue* dest_value)
{
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = umockdev_socket_server_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}

static gpointer
umockdev_value_socket_server_peek_pointer (const GValue* value)
{
	return value->data[0].v_pointer;
}

static gchar*
umockdev_value_socket_server_collect_value (GValue* value,
                                            guint n_collect_values,
                                            GTypeCValue* collect_values,
                                            guint collect_flags)
{
	if (collect_values[0].v_pointer) {
		UMockdevSocketServer * object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = umockdev_socket_server_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}

static gchar*
umockdev_value_socket_server_lcopy_value (const GValue* value,
                                          guint n_collect_values,
                                          GTypeCValue* collect_values,
                                          guint collect_flags)
{
	UMockdevSocketServer ** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = umockdev_socket_server_ref (value->data[0].v_pointer);
	}
	return NULL;
}

GParamSpec*
umockdev_param_spec_socket_server (const gchar* name,
                                   const gchar* nick,
                                   const gchar* blurb,
                                   GType object_type,
                                   GParamFlags flags)
{
	UMockdevParamSpecSocketServer* spec;
	g_return_val_if_fail (g_type_is_a (object_type, UMOCKDEV_TYPE_SOCKET_SERVER), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}

gpointer
umockdev_value_get_socket_server (const GValue* value)
{
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, UMOCKDEV_TYPE_SOCKET_SERVER), NULL);
	return value->data[0].v_pointer;
}

void
umockdev_value_set_socket_server (GValue* value,
                                  gpointer v_object)
{
	UMockdevSocketServer * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, UMOCKDEV_TYPE_SOCKET_SERVER));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, UMOCKDEV_TYPE_SOCKET_SERVER));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		umockdev_socket_server_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		umockdev_socket_server_unref (old);
	}
}

void
umockdev_value_take_socket_server (GValue* value,
                                   gpointer v_object)
{
	UMockdevSocketServer * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, UMOCKDEV_TYPE_SOCKET_SERVER));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, UMOCKDEV_TYPE_SOCKET_SERVER));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		umockdev_socket_server_unref (old);
	}
}

static void
umockdev_socket_server_class_init (UMockdevSocketServerClass * klass,
                                   gpointer klass_data)
{
	umockdev_socket_server_parent_class = g_type_class_peek_parent (klass);
	((UMockdevSocketServerClass *) klass)->finalize = umockdev_socket_server_finalize;
	g_type_class_adjust_private_offset (klass, &UMockdevSocketServer_private_offset);
}

static void
umockdev_socket_server_instance_init (UMockdevSocketServer * self,
                                      gpointer klass)
{
	GSocket** _tmp0_;
	self->priv = umockdev_socket_server_get_instance_private (self);
	_tmp0_ = g_new0 (GSocket*, 0 + 1);
	self->priv->listen_sockets = _tmp0_;
	self->priv->listen_sockets_length1 = 0;
	self->priv->_listen_sockets_size_ = self->priv->listen_sockets_length1;
	self->ref_count = 1;
}

static void
umockdev_socket_server_finalize (UMockdevSocketServer * obj)
{
	UMockdevSocketServer * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, UMOCKDEV_TYPE_SOCKET_SERVER, UMockdevSocketServer);
	g_signal_handlers_destroy (self);
	umockdev_socket_server_stop (self);
	self->priv->listen_sockets = (_vala_array_free (self->priv->listen_sockets, self->priv->listen_sockets_length1, (GDestroyNotify) g_object_unref), NULL);
	_g_hash_table_unref0 (self->priv->socket_scriptfile);
	_g_hash_table_unref0 (self->priv->script_runners);
	_g_thread_unref0 (self->priv->thread);
}

GType
umockdev_socket_server_get_type (void)
{
	static volatile gsize umockdev_socket_server_type_id__volatile = 0;
	if (g_once_init_enter (&umockdev_socket_server_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { umockdev_value_socket_server_init, umockdev_value_socket_server_free_value, umockdev_value_socket_server_copy_value, umockdev_value_socket_server_peek_pointer, "p", umockdev_value_socket_server_collect_value, "p", umockdev_value_socket_server_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (UMockdevSocketServerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) umockdev_socket_server_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (UMockdevSocketServer), 0, (GInstanceInitFunc) umockdev_socket_server_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType umockdev_socket_server_type_id;
		umockdev_socket_server_type_id = g_type_register_fundamental (g_type_fundamental_next (), "UMockdevSocketServer", &g_define_type_info, &g_define_type_fundamental_info, 0);
		UMockdevSocketServer_private_offset = g_type_add_instance_private (umockdev_socket_server_type_id, sizeof (UMockdevSocketServerPrivate));
		g_once_init_leave (&umockdev_socket_server_type_id__volatile, umockdev_socket_server_type_id);
	}
	return umockdev_socket_server_type_id__volatile;
}

gpointer
umockdev_socket_server_ref (gpointer instance)
{
	UMockdevSocketServer * self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}

void
umockdev_socket_server_unref (gpointer instance)
{
	UMockdevSocketServer * self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		UMOCKDEV_SOCKET_SERVER_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}

/**
 * umockdev_in_mock_environment:
 *
 * Check whether the current process is running under umockdev-wrapper, i. e.
 * the umockdev preload library.
 *
 * Returns: %TRUE if running under preload with mocked devices, %FALSE if
 *          running against the real system.
 */
gboolean
umockdev_in_mock_environment (void)
{
	gboolean result = FALSE;
	if (!umockdev___in_mock_env_initialized) {
		struct stat st = {0};
		struct stat _tmp0_ = {0};
		gint _tmp1_;
		_tmp1_ = stat ("/sys", &_tmp0_);
		st = _tmp0_;
		if (_tmp1_ >= 0) {
			struct stat _tmp2_;
			_tmp2_ = st;
			umockdev___in_mock_env_result = _tmp2_.st_ino > ((ino_t) 1);
		}
		umockdev___in_mock_env_initialized = TRUE;
	}
	result = umockdev___in_mock_env_result;
	return result;
}

GQuark
umockdev_error_quark (void)
{
	return g_quark_from_static_string ("umockdev-error-quark");
}

static void
_vala_array_destroy (gpointer array,
                     gint array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gint array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static gint
_vala_array_length (gpointer array)
{
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}

