/**
 * Handles all the related work to injecting the 'external' extension into the
 * content script (well, more precisely the current environment), and the proxy
 * responsbile for handling the API requests in a webapplication.
 * 
 */
(function (currentWindow) {
   var aWindow = currentWindow;
   var plugin = null;
   var service = null;
   var api = {
       init: function (options) {
	   options.url = window.location.href;
	   options.hostname = window.location.hostname;
	   options.host = window.location.host;
	   options.protocol = window.location.protocol;
	   chrome.runtime.sendMessage (
	       {method: "init_requested", options: options}
	       , function (response) {});
       }
   };

   /**
    * Inserts a given script in the webpage.
    * Needs chrome.extension functionality.
    * 
    * @param path of file to be injected (part of the extension)
    */
   var insertScriptIntoWebpage = function (path) {
     var script = document.createElement ('script');
     script.type = 'text/javascript';
     script.src = chrome.runtime.getURL (path);
     document.getElementsByTagName("head")[0].appendChild (script);
   };

   var injectApiProxy = function () {

     // 1. inject a piece of javascript proxying all the requests
     // to the unity webapps api
     insertScriptIntoWebpage('unity-api-page-proxy-builder-gen.js');
     insertScriptIntoWebpage('unity-api-page-proxy.js');

     function makeWebpageCallback (id) {
       // TODO/FIXME: add support for callback params (needed for DnD)
       return function () {
         var d = document.createElement ("textarea");
         var e = document.createEvent ("Events");
         d.style.cssText = "display:none;";
         d.value = id;
         d.addEventListener ("unity-webapps-chromium-api-com-link-callback-called-ack"
                             , function() { d.parentNode.removeChild (d); }
                             , true);
         document.body.appendChild (d);
         e.initEvent ("unity-webapps-chromium-api-com-link-callback-called", false, true);
         d.dispatchEvent (e);
       };
     };

     // TODO: should be shared / generated w/ web page code
     var isIterableObject = function(obj) {
        if (obj === undefined || obj === null) {
          return false;
        }
       var t = typeof(obj);
       var types = {'string': 0, 'function': 0, 'number': 0, 'undefined': 0, 'boolean': 0};
       return types[t] === undefined;
     };

     /**
      * Wraps callback ids in proper callback that dispatch to the
      * webpage thru a proper event
      *
      */
     function wrapCallbackIds (obj) {
       if ( ! isIterableObject(obj)) {
         return obj;
       }
       if (obj
           && obj.hasOwnProperty('callbackid')
           && obj.callbackid != null) {
         return makeWebpageCallback (obj.callbackid);
       }

       var ret = (obj instanceof Array) ? [] : {};
       for (var key in obj) {
         if (obj.hasOwnProperty(key)) {

           if (isIterableObject (obj[key])) {

             if (obj[key].callbackid != null) {
               ret[key] = makeWebpageCallback (obj[key].callbackid);
             }
             else {
               ret[key] = wrapCallbackIds (obj[key]);
             }
           }
           else {
             ret[key] = obj[key];
           }
         }
       }
       return ret;
     };

     // 2. open the communication mean between the two

     // TODO has the implicit knowledge of who's behind ...
     var dispatchActualFunctionCall = function (funcname, args) {
       var funcnames = funcname.split('.');
       var reducetarget = api;

       // a bit hacky
       try {
         // Assumes that we are calling a 'callable' from a succession of objects
         funcnames.reduce (
           function (prev, cur) {
             return typeof prev[cur] == "function" ? prev[cur].bind(prev) : prev[cur];
           }, reducetarget).apply (null, args);
       } catch (err) {
         console.log ('Error while dispatching call to ' + funcnames.join('.') + ': ' + err);
       }
     };
     
     document.addEventListener("unity-webapps-chromium-api-com-link"
                               , function(event) {
                                 var from = event.target;
                                 if (from) {
                                   var type = from.getAttribute("data-eventType");

                                   var args = JSON.parse(from.value);
                                   args = args.map (function (arg) { return wrapCallbackIds (arg); });

                                   // Actuall call, e.g. 'Notification.showNotification("a","b")
                                   // being reduces to successive calls to associated objects:
                                   // Notification, showNotification
                                   // 
                                   // TODO add proper error handling
                                   dispatchActualFunctionCall(type, args);
                                 }

                                 // send ack event to allow cleanup
                                 var ret = document.createEvent('Events');
                                 ret.initEvent('unity-webapps-chromium-api-com-link-ack', true, false);
                                 from.dispatchEvent(ret);
                               }
                               , true);
   };

   // handle the proxy side of the api which is being injected on the
   //  webpage
   injectApiProxy();
 }
)(window);

