/*
 * wrapped-callback-type.c
 * Copyright (C) Canonical LTD 2012
 * 
 * Author: Alexandre Abreu <alexandre.abreu@canonical.com>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include "wrapped-callback-type.h"



static bool NPClass_HasMethod (NPObject *npobj, NPIdentifier name);
static NPObject * NPClass_Allocate (NPP npp, NPClass *aClass);
static bool NPClass_Invoke (NPObject *npobj
			    , NPIdentifier name
			    , const NPVariant *args
			    , uint32_t argCount
			    , NPVariant *result);
static bool NPClass_InvokeDefault (NPObject *npobj, const NPVariant *args, uint32_t argCount, NPVariant *result);
static bool NPClass_HasProperty (NPObject * npobj, NPIdentifier name);
static bool NPClass_GetProperty (NPObject *npobj, NPIdentifier name, NPVariant *result);
static bool NPClass_SetProperty (NPObject *npobj, NPIdentifier name, const NPVariant *value);
static bool NPClass_RemoveProperty (NPObject *npobj, NPIdentifier name);
static bool NPClass_Enumerate (NPObject *npobj, NPIdentifier **identifier, uint32_t *count);
static bool NPClass_Construct (NPObject *npobj, const NPVariant *args, uint32_t argCount, NPVariant *result);
static void NPClass_Deallocate (NPObject *npobj);
static void NPClass_Invalidate (NPObject *npobj);

 
static NPClass wrapped_callback_class = {
  .structVersion = NP_CLASS_STRUCT_VERSION,
  .allocate = NPClass_Allocate,
  .deallocate = NPClass_Deallocate,
  .invalidate = NPClass_Invalidate,
  .hasMethod = NPClass_HasMethod,
  .invoke = NPClass_Invoke,
  .invokeDefault = NPClass_InvokeDefault,
  .hasProperty = NPClass_HasProperty,
  .getProperty = NPClass_GetProperty,
  .setProperty = NPClass_SetProperty,
  .removeProperty = NPClass_RemoveProperty,
  .enumerate = NPClass_Enumerate,
  .construct = NPClass_Construct
};



///////////////////////////////////////////////////////
//
//	public
//
///////////////////////////////////////////////////////

NPObject * create_wrapped_callback_object_for (NPP instance, void * callback)
{
  NPObject * pObject = NPN_CreateObject (instance, &wrapped_callback_class);
  if (NULL == pObject)
    {
      // TODO Ooops
      return NULL;
    }

  ((wrapped_callback_t *) pObject)->wrapped_callback = callback;
  ((wrapped_callback_t *) pObject)->instance = instance;

  return pObject;
}





///////////////////////////////////////////////////////
//
//	private
//
///////////////////////////////////////////////////////

static bool NPClass_HasMethod (NPObject *npobj, NPIdentifier name)
{
  return false;
}

static NPObject * NPClass_Allocate (NPP npp, NPClass *aClass)
{
  if (NULL == npp || NULL == npp->pdata)
    {
      // TODO error handling
      return NULL;
    }
    
  wrapped_callback_t * pObject = g_malloc0 (sizeof (wrapped_callback_t));
    
  return (NPObject *) pObject;
}

static void NPClass_Deallocate (NPObject *npobj)
{
  g_free (npobj);
}

static void NPClass_Invalidate (NPObject *npobj)
{
  // TODO
}

static bool NPClass_Invoke (NPObject *npobj
			    , NPIdentifier name
			    , const NPVariant *args
			    , uint32_t argCount
			    , NPVariant *result)
{
  // Not invokable
  return false;
}

static bool NPClass_InvokeDefault (NPObject *npobj, const NPVariant *args, uint32_t argCount, NPVariant *result)
{
  //	NPN_Invoke

  return false;
}

static bool NPClass_HasProperty (NPObject * npobj, NPIdentifier name)
{
  // no properties
  return false;
}

static bool NPClass_GetProperty (NPObject *npobj, NPIdentifier name, NPVariant *result)
{
  // no properties
  return false;
}

static bool NPClass_SetProperty (NPObject *npobj, NPIdentifier name, const NPVariant *value)
{
  // no properties
  return false;
}

static bool NPClass_RemoveProperty (NPObject *npobj, NPIdentifier name)
{
  // no properties
  return false;
}

static bool NPClass_Enumerate (NPObject *npobj, NPIdentifier **identifier, uint32_t *count)
{
  // no properties/methods
  return false;
}

static bool NPClass_Construct (NPObject *npobj, const NPVariant *args, uint32_t argCount, NPVariant *result)
{
  // no need for specific construct
  return false;
}


