// Copyright 2016, VIXL authors
// All rights reserved.
//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions are met:
//
//   * Redistributions of source code must retain the above copyright notice,
//     this list of conditions and the following disclaimer.
//   * Redistributions in binary form must reproduce the above copyright notice,
//     this list of conditions and the following disclaimer in the documentation
//     and/or other materials provided with the distribution.
//   * Neither the name of ARM Limited nor the names of its contributors may be
//     used to endorse or promote products derived from this software without
//     specific prior written permission.
//
// THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS CONTRIBUTORS "AS IS" AND
// ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
// WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
// DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE
// FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
// DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
// SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
// CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
// OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
// OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.


// -----------------------------------------------------------------------------
// This file is auto generated from the
// test/aarch32/config/template-simulator-aarch32.cc.in template file using
// tools/generate_tests.py.
//
// PLEASE DO NOT EDIT.
// -----------------------------------------------------------------------------


#include "test-runner.h"

#include "test-utils.h"
#include "test-utils-aarch32.h"

#include "aarch32/assembler-aarch32.h"
#include "aarch32/disasm-aarch32.h"
#include "aarch32/macro-assembler-aarch32.h"

#define __ masm.
#define BUF_SIZE (4096)

#ifdef VIXL_INCLUDE_SIMULATOR_AARCH32
// Run tests with the simulator.

#define SETUP() MacroAssembler masm(BUF_SIZE)

#define START() masm.GetBuffer()->Reset()

#define END() \
  __ Hlt(0);  \
  __ FinalizeCode();

// TODO: Run the tests in the simulator.
#define RUN()

#else  // ifdef VIXL_INCLUDE_SIMULATOR_AARCH32.

#define SETUP()                  \
  MacroAssembler masm(BUF_SIZE); \
  UseScratchRegisterScope harness_scratch;

#define START()                 \
  harness_scratch.Open(&masm);  \
  harness_scratch.ExcludeAll(); \
  masm.GetBuffer()->Reset();    \
  __ Push(r4);                  \
  __ Push(r5);                  \
  __ Push(r6);                  \
  __ Push(r7);                  \
  __ Push(r8);                  \
  __ Push(r9);                  \
  __ Push(r10);                 \
  __ Push(r11);                 \
  __ Push(lr);                  \
  harness_scratch.Include(ip);

#define END()                  \
  harness_scratch.Exclude(ip); \
  __ Pop(lr);                  \
  __ Pop(r11);                 \
  __ Pop(r10);                 \
  __ Pop(r9);                  \
  __ Pop(r8);                  \
  __ Pop(r7);                  \
  __ Pop(r6);                  \
  __ Pop(r5);                  \
  __ Pop(r4);                  \
  __ Bx(lr);                   \
  __ FinalizeCode();           \
  harness_scratch.Close();

#define RUN()                                                 \
  {                                                           \
    int pcs_offset = masm.IsUsingT32() ? 1 : 0;               \
    masm.GetBuffer()->SetExecutable();                        \
    ExecuteMemory(masm.GetBuffer()->GetStartAddress<byte*>(), \
                  masm.GetSizeOfCodeGenerated(),              \
                  pcs_offset);                                \
    masm.GetBuffer()->SetWritable();                          \
  }

#endif  // ifdef VIXL_INCLUDE_SIMULATOR_AARCH32

namespace vixl {
namespace aarch32 {

// List of instruction encodings:
#define FOREACH_INSTRUCTION(M) \
  M(Ldr)                       \
  M(Ldrb)                      \
  M(Str)                       \
  M(Strb)


// The following definitions are defined again in each generated test, therefore
// we need to place them in an anomymous namespace. It expresses that they are
// local to this file only, and the compiler is not allowed to share these types
// across test files during template instantiation. Specifically, `Operands` and
// `Inputs` have various layouts across generated tests so they absolutely
// cannot be shared.

#ifdef VIXL_INCLUDE_TARGET_A32
namespace {

// Values to be passed to the assembler to produce the instruction under test.
struct Operands {
  Condition cond;
  Register rd;
  Register rn;
  Sign sign;
  Register rm;
  ShiftType shift;
  uint32_t amount;
  AddrMode addr_mode;
};

// Input data to feed to the instruction.
struct Inputs {
  uint32_t apsr;
  uint32_t rd;
  uint32_t rm;
  uint32_t memop[2];
};

// This structure contains all input data needed to test one specific encoding.
// It used to generate a loop over an instruction.
struct TestLoopData {
  // The `operands` fields represents the values to pass to the assembler to
  // produce the instruction.
  Operands operands;
  // Description of the operands, used for error reporting.
  const char* operands_description;
  // Unique identifier, used for generating traces.
  const char* identifier;
  // Array of values to be fed to the instruction.
  size_t input_size;
  const Inputs* inputs;
};

static const Inputs kCondition[] = {{NFlag, 0xabababab, 0, {0, 0x77777777}},
                                    {ZFlag, 0xabababab, 0, {0, 0x77777777}},
                                    {CFlag, 0xabababab, 0, {0, 0x77777777}},
                                    {VFlag, 0xabababab, 0, {0, 0x77777777}},
                                    {NZFlag, 0xabababab, 0, {0, 0x77777777}},
                                    {NCFlag, 0xabababab, 0, {0, 0x77777777}},
                                    {NVFlag, 0xabababab, 0, {0, 0x77777777}},
                                    {ZCFlag, 0xabababab, 0, {0, 0x77777777}},
                                    {ZVFlag, 0xabababab, 0, {0, 0x77777777}},
                                    {CVFlag, 0xabababab, 0, {0, 0x77777777}},
                                    {NZCFlag, 0xabababab, 0, {0, 0x77777777}},
                                    {NZVFlag, 0xabababab, 0, {0, 0x77777777}},
                                    {NCVFlag, 0xabababab, 0, {0, 0x77777777}},
                                    {ZCVFlag, 0xabababab, 0, {0, 0x77777777}},
                                    {NZCVFlag, 0xabababab, 0, {0, 0x77777777}}};

static const Inputs kPositiveOffset[] =
    {{NoFlag, 0xabababab, 2590, {0, 0x77777777}},
     {NoFlag, 0xabababab, 180, {0, 0x0cabba9e}},
     {NoFlag, 0xabababab, 3870, {0, 0x77777777}},
     {NoFlag, 0xabababab, 618, {0, 0x55555555}},
     {NoFlag, 0xabababab, 2650, {0, 0x0badbeef}},
     {NoFlag, 0xabababab, 2091, {0, 0x77777777}},
     {NoFlag, 0xabababab, 778, {0, 0x0badbeef}},
     {NoFlag, 0xabababab, 282, {0, 0x0cabba9e}},
     {NoFlag, 0xabababab, 263, {0, 0x77777777}},
     {NoFlag, 0xabababab, 200, {0, 0x0cabba9e}}};

static const Inputs kNegativeOffset[] =
    {{NoFlag, 0xabababab, 3743, {0, 0x77777777}},
     {NoFlag, 0xabababab, 2475, {0, 0x0badbeef}},
     {NoFlag, 0xabababab, 1159, {0, 0x0cabba9e}},
     {NoFlag, 0xabababab, 2345, {0, 0x55555555}},
     {NoFlag, 0xabababab, 3625, {0, 0x55555555}},
     {NoFlag, 0xabababab, 2381, {0, 0x0badbeef}},
     {NoFlag, 0xabababab, 4037, {0, 0x0badbeef}},
     {NoFlag, 0xabababab, 778, {0, 0x77777777}},
     {NoFlag, 0xabababab, 3880, {0, 0x0cabba9e}},
     {NoFlag, 0xabababab, 3384, {0, 0x77777777}}};

static const Inputs kPositivePostIndex[] =
    {{NoFlag, 0xabababab, 1526, {0, 0x0cabba9e}},
     {NoFlag, 0xabababab, 365, {0, 0x55555555}},
     {NoFlag, 0xabababab, 1948, {0, 0x0cabba9e}},
     {NoFlag, 0xabababab, 958, {0, 0x0cabba9e}},
     {NoFlag, 0xabababab, 969, {0, 0x55555555}},
     {NoFlag, 0xabababab, 2695, {0, 0x55555555}},
     {NoFlag, 0xabababab, 2690, {0, 0x0cabba9e}},
     {NoFlag, 0xabababab, 523, {0, 0x0cabba9e}},
     {NoFlag, 0xabababab, 2046, {0, 0x0cabba9e}},
     {NoFlag, 0xabababab, 2490, {0, 0x0cabba9e}}};

static const Inputs kNegativePostIndex[] =
    {{NoFlag, 0xabababab, 4093, {0, 0x0badbeef}},
     {NoFlag, 0xabababab, 1860, {0, 0x0cabba9e}},
     {NoFlag, 0xabababab, 3157, {0, 0x55555555}},
     {NoFlag, 0xabababab, 3069, {0, 0x55555555}},
     {NoFlag, 0xabababab, 932, {0, 0x55555555}},
     {NoFlag, 0xabababab, 3287, {0, 0x55555555}},
     {NoFlag, 0xabababab, 685, {0, 0x0cabba9e}},
     {NoFlag, 0xabababab, 3685, {0, 0x55555555}},
     {NoFlag, 0xabababab, 3039, {0, 0x0badbeef}},
     {NoFlag, 0xabababab, 2245, {0, 0x0badbeef}}};

static const Inputs kPositivePreIndex[] =
    {{NoFlag, 0xabababab, 719, {0, 0x0badbeef}},
     {NoFlag, 0xabababab, 2933, {0, 0x0badbeef}},
     {NoFlag, 0xabababab, 263, {0, 0x0badbeef}},
     {NoFlag, 0xabababab, 2086, {0, 0x55555555}},
     {NoFlag, 0xabababab, 2728, {0, 0x0badbeef}},
     {NoFlag, 0xabababab, 3399, {0, 0x55555555}},
     {NoFlag, 0xabababab, 2532, {0, 0x0badbeef}},
     {NoFlag, 0xabababab, 3626, {0, 0x0badbeef}},
     {NoFlag, 0xabababab, 612, {0, 0x77777777}},
     {NoFlag, 0xabababab, 3811, {0, 0x77777777}}};

static const Inputs kNegativePreIndex[] =
    {{NoFlag, 0xabababab, 3564, {0, 0x77777777}},
     {NoFlag, 0xabababab, 766, {0, 0x55555555}},
     {NoFlag, 0xabababab, 2365, {0, 0x0badbeef}},
     {NoFlag, 0xabababab, 2462, {0, 0x0cabba9e}},
     {NoFlag, 0xabababab, 3439, {0, 0x0badbeef}},
     {NoFlag, 0xabababab, 2810, {0, 0x77777777}},
     {NoFlag, 0xabababab, 2590, {0, 0x55555555}},
     {NoFlag, 0xabababab, 1527, {0, 0x0cabba9e}},
     {NoFlag, 0xabababab, 523, {0, 0x0cabba9e}},
     {NoFlag, 0xabababab, 2290, {0, 0x77777777}}};


// A loop will be generated for each element of this array.
const TestLoopData kTests[] =
    {{{eq, r0, r1, plus, r8, LSL, 1, Offset},
      "eq r0 r1 plus r8 LSL 1 Offset",
      "Condition_eq_r0_r1_plus_r8_LSL_1_Offset",
      ARRAY_SIZE(kCondition),
      kCondition},
     {{ne, r0, r1, plus, r8, LSL, 1, Offset},
      "ne r0 r1 plus r8 LSL 1 Offset",
      "Condition_ne_r0_r1_plus_r8_LSL_1_Offset",
      ARRAY_SIZE(kCondition),
      kCondition},
     {{cs, r0, r1, plus, r8, LSL, 1, Offset},
      "cs r0 r1 plus r8 LSL 1 Offset",
      "Condition_cs_r0_r1_plus_r8_LSL_1_Offset",
      ARRAY_SIZE(kCondition),
      kCondition},
     {{cc, r0, r1, plus, r8, LSL, 1, Offset},
      "cc r0 r1 plus r8 LSL 1 Offset",
      "Condition_cc_r0_r1_plus_r8_LSL_1_Offset",
      ARRAY_SIZE(kCondition),
      kCondition},
     {{mi, r0, r1, plus, r8, LSL, 1, Offset},
      "mi r0 r1 plus r8 LSL 1 Offset",
      "Condition_mi_r0_r1_plus_r8_LSL_1_Offset",
      ARRAY_SIZE(kCondition),
      kCondition},
     {{pl, r0, r1, plus, r8, LSL, 1, Offset},
      "pl r0 r1 plus r8 LSL 1 Offset",
      "Condition_pl_r0_r1_plus_r8_LSL_1_Offset",
      ARRAY_SIZE(kCondition),
      kCondition},
     {{vs, r0, r1, plus, r8, LSL, 1, Offset},
      "vs r0 r1 plus r8 LSL 1 Offset",
      "Condition_vs_r0_r1_plus_r8_LSL_1_Offset",
      ARRAY_SIZE(kCondition),
      kCondition},
     {{vc, r0, r1, plus, r8, LSL, 1, Offset},
      "vc r0 r1 plus r8 LSL 1 Offset",
      "Condition_vc_r0_r1_plus_r8_LSL_1_Offset",
      ARRAY_SIZE(kCondition),
      kCondition},
     {{hi, r0, r1, plus, r8, LSL, 1, Offset},
      "hi r0 r1 plus r8 LSL 1 Offset",
      "Condition_hi_r0_r1_plus_r8_LSL_1_Offset",
      ARRAY_SIZE(kCondition),
      kCondition},
     {{ls, r0, r1, plus, r8, LSL, 1, Offset},
      "ls r0 r1 plus r8 LSL 1 Offset",
      "Condition_ls_r0_r1_plus_r8_LSL_1_Offset",
      ARRAY_SIZE(kCondition),
      kCondition},
     {{ge, r0, r1, plus, r8, LSL, 1, Offset},
      "ge r0 r1 plus r8 LSL 1 Offset",
      "Condition_ge_r0_r1_plus_r8_LSL_1_Offset",
      ARRAY_SIZE(kCondition),
      kCondition},
     {{lt, r0, r1, plus, r8, LSL, 1, Offset},
      "lt r0 r1 plus r8 LSL 1 Offset",
      "Condition_lt_r0_r1_plus_r8_LSL_1_Offset",
      ARRAY_SIZE(kCondition),
      kCondition},
     {{gt, r0, r1, plus, r8, LSL, 1, Offset},
      "gt r0 r1 plus r8 LSL 1 Offset",
      "Condition_gt_r0_r1_plus_r8_LSL_1_Offset",
      ARRAY_SIZE(kCondition),
      kCondition},
     {{le, r0, r1, plus, r8, LSL, 1, Offset},
      "le r0 r1 plus r8 LSL 1 Offset",
      "Condition_le_r0_r1_plus_r8_LSL_1_Offset",
      ARRAY_SIZE(kCondition),
      kCondition},
     {{al, r0, r1, plus, r8, LSL, 1, Offset},
      "al r0 r1 plus r8 LSL 1 Offset",
      "Condition_al_r0_r1_plus_r8_LSL_1_Offset",
      ARRAY_SIZE(kCondition),
      kCondition},
     {{al, r1, r0, plus, r11, LSL, 2, Offset},
      "al r1 r0 plus r11 LSL 2 Offset",
      "PositiveOffset_al_r1_r0_plus_r11_LSL_2_Offset",
      ARRAY_SIZE(kPositiveOffset),
      kPositiveOffset},
     {{al, r3, r11, plus, r12, LSL, 11, Offset},
      "al r3 r11 plus r12 LSL 11 Offset",
      "PositiveOffset_al_r3_r11_plus_r12_LSL_11_Offset",
      ARRAY_SIZE(kPositiveOffset),
      kPositiveOffset},
     {{al, r14, r2, plus, r6, LSL, 2, Offset},
      "al r14 r2 plus r6 LSL 2 Offset",
      "PositiveOffset_al_r14_r2_plus_r6_LSL_2_Offset",
      ARRAY_SIZE(kPositiveOffset),
      kPositiveOffset},
     {{al, r4, r12, plus, r9, ROR, 12, Offset},
      "al r4 r12 plus r9 ROR 12 Offset",
      "PositiveOffset_al_r4_r12_plus_r9_ROR_12_Offset",
      ARRAY_SIZE(kPositiveOffset),
      kPositiveOffset},
     {{al, r1, r12, plus, r0, LSL, 17, Offset},
      "al r1 r12 plus r0 LSL 17 Offset",
      "PositiveOffset_al_r1_r12_plus_r0_LSL_17_Offset",
      ARRAY_SIZE(kPositiveOffset),
      kPositiveOffset},
     {{al, r1, r9, plus, r6, LSL, 24, Offset},
      "al r1 r9 plus r6 LSL 24 Offset",
      "PositiveOffset_al_r1_r9_plus_r6_LSL_24_Offset",
      ARRAY_SIZE(kPositiveOffset),
      kPositiveOffset},
     {{al, r1, r5, plus, r3, LSL, 21, Offset},
      "al r1 r5 plus r3 LSL 21 Offset",
      "PositiveOffset_al_r1_r5_plus_r3_LSL_21_Offset",
      ARRAY_SIZE(kPositiveOffset),
      kPositiveOffset},
     {{al, r8, r7, plus, r6, LSL, 20, Offset},
      "al r8 r7 plus r6 LSL 20 Offset",
      "PositiveOffset_al_r8_r7_plus_r6_LSL_20_Offset",
      ARRAY_SIZE(kPositiveOffset),
      kPositiveOffset},
     {{al, r12, r14, plus, r7, LSL, 21, Offset},
      "al r12 r14 plus r7 LSL 21 Offset",
      "PositiveOffset_al_r12_r14_plus_r7_LSL_21_Offset",
      ARRAY_SIZE(kPositiveOffset),
      kPositiveOffset},
     {{al, r0, r11, plus, r4, ROR, 2, Offset},
      "al r0 r11 plus r4 ROR 2 Offset",
      "PositiveOffset_al_r0_r11_plus_r4_ROR_2_Offset",
      ARRAY_SIZE(kPositiveOffset),
      kPositiveOffset},
     {{al, r6, r14, plus, r8, LSL, 30, Offset},
      "al r6 r14 plus r8 LSL 30 Offset",
      "PositiveOffset_al_r6_r14_plus_r8_LSL_30_Offset",
      ARRAY_SIZE(kPositiveOffset),
      kPositiveOffset},
     {{al, r2, r11, plus, r9, ROR, 29, Offset},
      "al r2 r11 plus r9 ROR 29 Offset",
      "PositiveOffset_al_r2_r11_plus_r9_ROR_29_Offset",
      ARRAY_SIZE(kPositiveOffset),
      kPositiveOffset},
     {{al, r0, r14, plus, r2, LSL, 31, Offset},
      "al r0 r14 plus r2 LSL 31 Offset",
      "PositiveOffset_al_r0_r14_plus_r2_LSL_31_Offset",
      ARRAY_SIZE(kPositiveOffset),
      kPositiveOffset},
     {{al, r3, r4, plus, r7, LSL, 13, Offset},
      "al r3 r4 plus r7 LSL 13 Offset",
      "PositiveOffset_al_r3_r4_plus_r7_LSL_13_Offset",
      ARRAY_SIZE(kPositiveOffset),
      kPositiveOffset},
     {{al, r10, r12, plus, r9, LSL, 7, Offset},
      "al r10 r12 plus r9 LSL 7 Offset",
      "PositiveOffset_al_r10_r12_plus_r9_LSL_7_Offset",
      ARRAY_SIZE(kPositiveOffset),
      kPositiveOffset},
     {{al, r5, r1, plus, r3, ROR, 19, Offset},
      "al r5 r1 plus r3 ROR 19 Offset",
      "PositiveOffset_al_r5_r1_plus_r3_ROR_19_Offset",
      ARRAY_SIZE(kPositiveOffset),
      kPositiveOffset},
     {{al, r5, r6, plus, r3, LSL, 27, Offset},
      "al r5 r6 plus r3 LSL 27 Offset",
      "PositiveOffset_al_r5_r6_plus_r3_LSL_27_Offset",
      ARRAY_SIZE(kPositiveOffset),
      kPositiveOffset},
     {{al, r2, r10, plus, r1, LSL, 21, Offset},
      "al r2 r10 plus r1 LSL 21 Offset",
      "PositiveOffset_al_r2_r10_plus_r1_LSL_21_Offset",
      ARRAY_SIZE(kPositiveOffset),
      kPositiveOffset},
     {{al, r7, r2, plus, r5, LSL, 23, Offset},
      "al r7 r2 plus r5 LSL 23 Offset",
      "PositiveOffset_al_r7_r2_plus_r5_LSL_23_Offset",
      ARRAY_SIZE(kPositiveOffset),
      kPositiveOffset},
     {{al, r7, r14, plus, r0, ROR, 17, Offset},
      "al r7 r14 plus r0 ROR 17 Offset",
      "PositiveOffset_al_r7_r14_plus_r0_ROR_17_Offset",
      ARRAY_SIZE(kPositiveOffset),
      kPositiveOffset},
     {{al, r4, r5, plus, r9, LSL, 19, Offset},
      "al r4 r5 plus r9 LSL 19 Offset",
      "PositiveOffset_al_r4_r5_plus_r9_LSL_19_Offset",
      ARRAY_SIZE(kPositiveOffset),
      kPositiveOffset},
     {{al, r14, r0, plus, r2, ROR, 27, Offset},
      "al r14 r0 plus r2 ROR 27 Offset",
      "PositiveOffset_al_r14_r0_plus_r2_ROR_27_Offset",
      ARRAY_SIZE(kPositiveOffset),
      kPositiveOffset},
     {{al, r11, r7, plus, r5, LSL, 15, Offset},
      "al r11 r7 plus r5 LSL 15 Offset",
      "PositiveOffset_al_r11_r7_plus_r5_LSL_15_Offset",
      ARRAY_SIZE(kPositiveOffset),
      kPositiveOffset},
     {{al, r7, r6, plus, r0, LSL, 3, Offset},
      "al r7 r6 plus r0 LSL 3 Offset",
      "PositiveOffset_al_r7_r6_plus_r0_LSL_3_Offset",
      ARRAY_SIZE(kPositiveOffset),
      kPositiveOffset},
     {{al, r14, r4, plus, r6, ROR, 5, Offset},
      "al r14 r4 plus r6 ROR 5 Offset",
      "PositiveOffset_al_r14_r4_plus_r6_ROR_5_Offset",
      ARRAY_SIZE(kPositiveOffset),
      kPositiveOffset},
     {{al, r0, r12, plus, r8, LSL, 8, Offset},
      "al r0 r12 plus r8 LSL 8 Offset",
      "PositiveOffset_al_r0_r12_plus_r8_LSL_8_Offset",
      ARRAY_SIZE(kPositiveOffset),
      kPositiveOffset},
     {{al, r14, r8, plus, r9, ROR, 13, Offset},
      "al r14 r8 plus r9 ROR 13 Offset",
      "PositiveOffset_al_r14_r8_plus_r9_ROR_13_Offset",
      ARRAY_SIZE(kPositiveOffset),
      kPositiveOffset},
     {{al, r2, r11, plus, r12, LSL, 8, Offset},
      "al r2 r11 plus r12 LSL 8 Offset",
      "PositiveOffset_al_r2_r11_plus_r12_LSL_8_Offset",
      ARRAY_SIZE(kPositiveOffset),
      kPositiveOffset},
     {{al, r5, r2, plus, r0, LSL, 16, Offset},
      "al r5 r2 plus r0 LSL 16 Offset",
      "PositiveOffset_al_r5_r2_plus_r0_LSL_16_Offset",
      ARRAY_SIZE(kPositiveOffset),
      kPositiveOffset},
     {{al, r10, r8, plus, r9, ROR, 25, Offset},
      "al r10 r8 plus r9 ROR 25 Offset",
      "PositiveOffset_al_r10_r8_plus_r9_ROR_25_Offset",
      ARRAY_SIZE(kPositiveOffset),
      kPositiveOffset},
     {{al, r11, r8, plus, r4, LSL, 6, Offset},
      "al r11 r8 plus r4 LSL 6 Offset",
      "PositiveOffset_al_r11_r8_plus_r4_LSL_6_Offset",
      ARRAY_SIZE(kPositiveOffset),
      kPositiveOffset},
     {{al, r7, r5, plus, r10, ROR, 24, Offset},
      "al r7 r5 plus r10 ROR 24 Offset",
      "PositiveOffset_al_r7_r5_plus_r10_ROR_24_Offset",
      ARRAY_SIZE(kPositiveOffset),
      kPositiveOffset},
     {{al, r8, r14, plus, r2, LSL, 31, Offset},
      "al r8 r14 plus r2 LSL 31 Offset",
      "PositiveOffset_al_r8_r14_plus_r2_LSL_31_Offset",
      ARRAY_SIZE(kPositiveOffset),
      kPositiveOffset},
     {{al, r1, r2, plus, r12, LSL, 14, Offset},
      "al r1 r2 plus r12 LSL 14 Offset",
      "PositiveOffset_al_r1_r2_plus_r12_LSL_14_Offset",
      ARRAY_SIZE(kPositiveOffset),
      kPositiveOffset},
     {{al, r12, r1, plus, r0, ROR, 12, Offset},
      "al r12 r1 plus r0 ROR 12 Offset",
      "PositiveOffset_al_r12_r1_plus_r0_ROR_12_Offset",
      ARRAY_SIZE(kPositiveOffset),
      kPositiveOffset},
     {{al, r3, r5, plus, r1, LSL, 9, Offset},
      "al r3 r5 plus r1 LSL 9 Offset",
      "PositiveOffset_al_r3_r5_plus_r1_LSL_9_Offset",
      ARRAY_SIZE(kPositiveOffset),
      kPositiveOffset},
     {{al, r7, r10, plus, r14, ROR, 3, Offset},
      "al r7 r10 plus r14 ROR 3 Offset",
      "PositiveOffset_al_r7_r10_plus_r14_ROR_3_Offset",
      ARRAY_SIZE(kPositiveOffset),
      kPositiveOffset},
     {{al, r4, r1, plus, r14, LSL, 24, Offset},
      "al r4 r1 plus r14 LSL 24 Offset",
      "PositiveOffset_al_r4_r1_plus_r14_LSL_24_Offset",
      ARRAY_SIZE(kPositiveOffset),
      kPositiveOffset},
     {{al, r3, r5, plus, r4, LSL, 4, Offset},
      "al r3 r5 plus r4 LSL 4 Offset",
      "PositiveOffset_al_r3_r5_plus_r4_LSL_4_Offset",
      ARRAY_SIZE(kPositiveOffset),
      kPositiveOffset},
     {{al, r11, r12, plus, r10, ROR, 18, Offset},
      "al r11 r12 plus r10 ROR 18 Offset",
      "PositiveOffset_al_r11_r12_plus_r10_ROR_18_Offset",
      ARRAY_SIZE(kPositiveOffset),
      kPositiveOffset},
     {{al, r1, r2, plus, r8, LSL, 5, Offset},
      "al r1 r2 plus r8 LSL 5 Offset",
      "PositiveOffset_al_r1_r2_plus_r8_LSL_5_Offset",
      ARRAY_SIZE(kPositiveOffset),
      kPositiveOffset},
     {{al, r6, r7, plus, r5, LSL, 19, Offset},
      "al r6 r7 plus r5 LSL 19 Offset",
      "PositiveOffset_al_r6_r7_plus_r5_LSL_19_Offset",
      ARRAY_SIZE(kPositiveOffset),
      kPositiveOffset},
     {{al, r7, r6, plus, r0, ROR, 7, Offset},
      "al r7 r6 plus r0 ROR 7 Offset",
      "PositiveOffset_al_r7_r6_plus_r0_ROR_7_Offset",
      ARRAY_SIZE(kPositiveOffset),
      kPositiveOffset},
     {{al, r7, r3, plus, r4, ROR, 27, Offset},
      "al r7 r3 plus r4 ROR 27 Offset",
      "PositiveOffset_al_r7_r3_plus_r4_ROR_27_Offset",
      ARRAY_SIZE(kPositiveOffset),
      kPositiveOffset},
     {{al, r12, r6, plus, r7, ROR, 10, Offset},
      "al r12 r6 plus r7 ROR 10 Offset",
      "PositiveOffset_al_r12_r6_plus_r7_ROR_10_Offset",
      ARRAY_SIZE(kPositiveOffset),
      kPositiveOffset},
     {{al, r8, r5, plus, r7, ROR, 29, Offset},
      "al r8 r5 plus r7 ROR 29 Offset",
      "PositiveOffset_al_r8_r5_plus_r7_ROR_29_Offset",
      ARRAY_SIZE(kPositiveOffset),
      kPositiveOffset},
     {{al, r9, r0, plus, r4, ROR, 2, Offset},
      "al r9 r0 plus r4 ROR 2 Offset",
      "PositiveOffset_al_r9_r0_plus_r4_ROR_2_Offset",
      ARRAY_SIZE(kPositiveOffset),
      kPositiveOffset},
     {{al, r3, r4, plus, r1, LSL, 1, Offset},
      "al r3 r4 plus r1 LSL 1 Offset",
      "PositiveOffset_al_r3_r4_plus_r1_LSL_1_Offset",
      ARRAY_SIZE(kPositiveOffset),
      kPositiveOffset},
     {{al, r3, r12, plus, r8, LSL, 17, Offset},
      "al r3 r12 plus r8 LSL 17 Offset",
      "PositiveOffset_al_r3_r12_plus_r8_LSL_17_Offset",
      ARRAY_SIZE(kPositiveOffset),
      kPositiveOffset},
     {{al, r12, r5, plus, r10, LSL, 18, Offset},
      "al r12 r5 plus r10 LSL 18 Offset",
      "PositiveOffset_al_r12_r5_plus_r10_LSL_18_Offset",
      ARRAY_SIZE(kPositiveOffset),
      kPositiveOffset},
     {{al, r5, r10, plus, r7, ROR, 19, Offset},
      "al r5 r10 plus r7 ROR 19 Offset",
      "PositiveOffset_al_r5_r10_plus_r7_ROR_19_Offset",
      ARRAY_SIZE(kPositiveOffset),
      kPositiveOffset},
     {{al, r14, r2, plus, r12, LSL, 15, Offset},
      "al r14 r2 plus r12 LSL 15 Offset",
      "PositiveOffset_al_r14_r2_plus_r12_LSL_15_Offset",
      ARRAY_SIZE(kPositiveOffset),
      kPositiveOffset},
     {{al, r2, r8, plus, r0, ROR, 28, Offset},
      "al r2 r8 plus r0 ROR 28 Offset",
      "PositiveOffset_al_r2_r8_plus_r0_ROR_28_Offset",
      ARRAY_SIZE(kPositiveOffset),
      kPositiveOffset},
     {{al, r1, r7, plus, r6, LSL, 23, Offset},
      "al r1 r7 plus r6 LSL 23 Offset",
      "PositiveOffset_al_r1_r7_plus_r6_LSL_23_Offset",
      ARRAY_SIZE(kPositiveOffset),
      kPositiveOffset},
     {{al, r9, r14, plus, r7, ROR, 9, Offset},
      "al r9 r14 plus r7 ROR 9 Offset",
      "PositiveOffset_al_r9_r14_plus_r7_ROR_9_Offset",
      ARRAY_SIZE(kPositiveOffset),
      kPositiveOffset},
     {{al, r4, r11, plus, r0, LSL, 7, Offset},
      "al r4 r11 plus r0 LSL 7 Offset",
      "PositiveOffset_al_r4_r11_plus_r0_LSL_7_Offset",
      ARRAY_SIZE(kPositiveOffset),
      kPositiveOffset},
     {{al, r6, r12, plus, r5, ROR, 17, Offset},
      "al r6 r12 plus r5 ROR 17 Offset",
      "PositiveOffset_al_r6_r12_plus_r5_ROR_17_Offset",
      ARRAY_SIZE(kPositiveOffset),
      kPositiveOffset},
     {{al, r14, r5, plus, r8, LSL, 9, Offset},
      "al r14 r5 plus r8 LSL 9 Offset",
      "PositiveOffset_al_r14_r5_plus_r8_LSL_9_Offset",
      ARRAY_SIZE(kPositiveOffset),
      kPositiveOffset},
     {{al, r8, r5, plus, r6, LSL, 26, Offset},
      "al r8 r5 plus r6 LSL 26 Offset",
      "PositiveOffset_al_r8_r5_plus_r6_LSL_26_Offset",
      ARRAY_SIZE(kPositiveOffset),
      kPositiveOffset},
     {{al, r12, r9, plus, r6, LSL, 9, Offset},
      "al r12 r9 plus r6 LSL 9 Offset",
      "PositiveOffset_al_r12_r9_plus_r6_LSL_9_Offset",
      ARRAY_SIZE(kPositiveOffset),
      kPositiveOffset},
     {{al, r9, r11, plus, r4, ROR, 28, Offset},
      "al r9 r11 plus r4 ROR 28 Offset",
      "PositiveOffset_al_r9_r11_plus_r4_ROR_28_Offset",
      ARRAY_SIZE(kPositiveOffset),
      kPositiveOffset},
     {{al, r5, r9, plus, r2, ROR, 1, Offset},
      "al r5 r9 plus r2 ROR 1 Offset",
      "PositiveOffset_al_r5_r9_plus_r2_ROR_1_Offset",
      ARRAY_SIZE(kPositiveOffset),
      kPositiveOffset},
     {{al, r2, r1, plus, r8, ROR, 4, Offset},
      "al r2 r1 plus r8 ROR 4 Offset",
      "PositiveOffset_al_r2_r1_plus_r8_ROR_4_Offset",
      ARRAY_SIZE(kPositiveOffset),
      kPositiveOffset},
     {{al, r9, r10, plus, r0, ROR, 7, Offset},
      "al r9 r10 plus r0 ROR 7 Offset",
      "PositiveOffset_al_r9_r10_plus_r0_ROR_7_Offset",
      ARRAY_SIZE(kPositiveOffset),
      kPositiveOffset},
     {{al, r5, r8, plus, r3, ROR, 1, Offset},
      "al r5 r8 plus r3 ROR 1 Offset",
      "PositiveOffset_al_r5_r8_plus_r3_ROR_1_Offset",
      ARRAY_SIZE(kPositiveOffset),
      kPositiveOffset},
     {{al, r9, r11, plus, r5, ROR, 6, Offset},
      "al r9 r11 plus r5 ROR 6 Offset",
      "PositiveOffset_al_r9_r11_plus_r5_ROR_6_Offset",
      ARRAY_SIZE(kPositiveOffset),
      kPositiveOffset},
     {{al, r7, r1, plus, r11, LSL, 21, Offset},
      "al r7 r1 plus r11 LSL 21 Offset",
      "PositiveOffset_al_r7_r1_plus_r11_LSL_21_Offset",
      ARRAY_SIZE(kPositiveOffset),
      kPositiveOffset},
     {{al, r8, r4, plus, r10, ROR, 15, Offset},
      "al r8 r4 plus r10 ROR 15 Offset",
      "PositiveOffset_al_r8_r4_plus_r10_ROR_15_Offset",
      ARRAY_SIZE(kPositiveOffset),
      kPositiveOffset},
     {{al, r3, r11, plus, r14, LSL, 4, Offset},
      "al r3 r11 plus r14 LSL 4 Offset",
      "PositiveOffset_al_r3_r11_plus_r14_LSL_4_Offset",
      ARRAY_SIZE(kPositiveOffset),
      kPositiveOffset},
     {{al, r3, r9, plus, r14, ROR, 7, Offset},
      "al r3 r9 plus r14 ROR 7 Offset",
      "PositiveOffset_al_r3_r9_plus_r14_ROR_7_Offset",
      ARRAY_SIZE(kPositiveOffset),
      kPositiveOffset},
     {{al, r1, r6, plus, r3, ROR, 15, Offset},
      "al r1 r6 plus r3 ROR 15 Offset",
      "PositiveOffset_al_r1_r6_plus_r3_ROR_15_Offset",
      ARRAY_SIZE(kPositiveOffset),
      kPositiveOffset},
     {{al, r7, r1, plus, r12, ROR, 28, Offset},
      "al r7 r1 plus r12 ROR 28 Offset",
      "PositiveOffset_al_r7_r1_plus_r12_ROR_28_Offset",
      ARRAY_SIZE(kPositiveOffset),
      kPositiveOffset},
     {{al, r8, r6, plus, r4, ROR, 13, Offset},
      "al r8 r6 plus r4 ROR 13 Offset",
      "PositiveOffset_al_r8_r6_plus_r4_ROR_13_Offset",
      ARRAY_SIZE(kPositiveOffset),
      kPositiveOffset},
     {{al, r5, r14, plus, r8, LSL, 22, Offset},
      "al r5 r14 plus r8 LSL 22 Offset",
      "PositiveOffset_al_r5_r14_plus_r8_LSL_22_Offset",
      ARRAY_SIZE(kPositiveOffset),
      kPositiveOffset},
     {{al, r6, r7, plus, r3, LSL, 29, Offset},
      "al r6 r7 plus r3 LSL 29 Offset",
      "PositiveOffset_al_r6_r7_plus_r3_LSL_29_Offset",
      ARRAY_SIZE(kPositiveOffset),
      kPositiveOffset},
     {{al, r8, r2, plus, r5, LSL, 1, Offset},
      "al r8 r2 plus r5 LSL 1 Offset",
      "PositiveOffset_al_r8_r2_plus_r5_LSL_1_Offset",
      ARRAY_SIZE(kPositiveOffset),
      kPositiveOffset},
     {{al, r2, r1, plus, r12, LSL, 3, Offset},
      "al r2 r1 plus r12 LSL 3 Offset",
      "PositiveOffset_al_r2_r1_plus_r12_LSL_3_Offset",
      ARRAY_SIZE(kPositiveOffset),
      kPositiveOffset},
     {{al, r10, r2, plus, r7, ROR, 22, Offset},
      "al r10 r2 plus r7 ROR 22 Offset",
      "PositiveOffset_al_r10_r2_plus_r7_ROR_22_Offset",
      ARRAY_SIZE(kPositiveOffset),
      kPositiveOffset},
     {{al, r7, r8, plus, r4, LSL, 6, Offset},
      "al r7 r8 plus r4 LSL 6 Offset",
      "PositiveOffset_al_r7_r8_plus_r4_LSL_6_Offset",
      ARRAY_SIZE(kPositiveOffset),
      kPositiveOffset},
     {{al, r11, r5, plus, r6, LSL, 30, Offset},
      "al r11 r5 plus r6 LSL 30 Offset",
      "PositiveOffset_al_r11_r5_plus_r6_LSL_30_Offset",
      ARRAY_SIZE(kPositiveOffset),
      kPositiveOffset},
     {{al, r11, r4, plus, r8, ROR, 12, Offset},
      "al r11 r4 plus r8 ROR 12 Offset",
      "PositiveOffset_al_r11_r4_plus_r8_ROR_12_Offset",
      ARRAY_SIZE(kPositiveOffset),
      kPositiveOffset},
     {{al, r12, r1, plus, r8, ROR, 21, Offset},
      "al r12 r1 plus r8 ROR 21 Offset",
      "PositiveOffset_al_r12_r1_plus_r8_ROR_21_Offset",
      ARRAY_SIZE(kPositiveOffset),
      kPositiveOffset},
     {{al, r6, r2, plus, r4, ROR, 17, Offset},
      "al r6 r2 plus r4 ROR 17 Offset",
      "PositiveOffset_al_r6_r2_plus_r4_ROR_17_Offset",
      ARRAY_SIZE(kPositiveOffset),
      kPositiveOffset},
     {{al, r1, r11, plus, r12, LSL, 8, Offset},
      "al r1 r11 plus r12 LSL 8 Offset",
      "PositiveOffset_al_r1_r11_plus_r12_LSL_8_Offset",
      ARRAY_SIZE(kPositiveOffset),
      kPositiveOffset},
     {{al, r14, r12, plus, r0, LSL, 26, Offset},
      "al r14 r12 plus r0 LSL 26 Offset",
      "PositiveOffset_al_r14_r12_plus_r0_LSL_26_Offset",
      ARRAY_SIZE(kPositiveOffset),
      kPositiveOffset},
     {{al, r4, r10, plus, r0, ROR, 2, Offset},
      "al r4 r10 plus r0 ROR 2 Offset",
      "PositiveOffset_al_r4_r10_plus_r0_ROR_2_Offset",
      ARRAY_SIZE(kPositiveOffset),
      kPositiveOffset},
     {{al, r4, r10, plus, r0, ROR, 27, Offset},
      "al r4 r10 plus r0 ROR 27 Offset",
      "PositiveOffset_al_r4_r10_plus_r0_ROR_27_Offset",
      ARRAY_SIZE(kPositiveOffset),
      kPositiveOffset},
     {{al, r0, r12, plus, r4, LSL, 31, Offset},
      "al r0 r12 plus r4 LSL 31 Offset",
      "PositiveOffset_al_r0_r12_plus_r4_LSL_31_Offset",
      ARRAY_SIZE(kPositiveOffset),
      kPositiveOffset},
     {{al, r5, r1, plus, r10, LSL, 31, Offset},
      "al r5 r1 plus r10 LSL 31 Offset",
      "PositiveOffset_al_r5_r1_plus_r10_LSL_31_Offset",
      ARRAY_SIZE(kPositiveOffset),
      kPositiveOffset},
     {{al, r1, r14, plus, r5, LSL, 1, Offset},
      "al r1 r14 plus r5 LSL 1 Offset",
      "PositiveOffset_al_r1_r14_plus_r5_LSL_1_Offset",
      ARRAY_SIZE(kPositiveOffset),
      kPositiveOffset},
     {{al, r12, r14, plus, r0, LSL, 7, Offset},
      "al r12 r14 plus r0 LSL 7 Offset",
      "PositiveOffset_al_r12_r14_plus_r0_LSL_7_Offset",
      ARRAY_SIZE(kPositiveOffset),
      kPositiveOffset},
     {{al, r1, r6, plus, r5, LSL, 1, Offset},
      "al r1 r6 plus r5 LSL 1 Offset",
      "PositiveOffset_al_r1_r6_plus_r5_LSL_1_Offset",
      ARRAY_SIZE(kPositiveOffset),
      kPositiveOffset},
     {{al, r6, r9, plus, r4, ROR, 9, Offset},
      "al r6 r9 plus r4 ROR 9 Offset",
      "PositiveOffset_al_r6_r9_plus_r4_ROR_9_Offset",
      ARRAY_SIZE(kPositiveOffset),
      kPositiveOffset},
     {{al, r6, r11, plus, r10, LSL, 4, Offset},
      "al r6 r11 plus r10 LSL 4 Offset",
      "PositiveOffset_al_r6_r11_plus_r10_LSL_4_Offset",
      ARRAY_SIZE(kPositiveOffset),
      kPositiveOffset},
     {{al, r5, r14, plus, r7, ROR, 25, Offset},
      "al r5 r14 plus r7 ROR 25 Offset",
      "PositiveOffset_al_r5_r14_plus_r7_ROR_25_Offset",
      ARRAY_SIZE(kPositiveOffset),
      kPositiveOffset},
     {{al, r9, r6, plus, r3, LSL, 23, Offset},
      "al r9 r6 plus r3 LSL 23 Offset",
      "PositiveOffset_al_r9_r6_plus_r3_LSL_23_Offset",
      ARRAY_SIZE(kPositiveOffset),
      kPositiveOffset},
     {{al, r3, r4, plus, r0, ROR, 27, Offset},
      "al r3 r4 plus r0 ROR 27 Offset",
      "PositiveOffset_al_r3_r4_plus_r0_ROR_27_Offset",
      ARRAY_SIZE(kPositiveOffset),
      kPositiveOffset},
     {{al, r1, r0, plus, r2, ROR, 17, Offset},
      "al r1 r0 plus r2 ROR 17 Offset",
      "PositiveOffset_al_r1_r0_plus_r2_ROR_17_Offset",
      ARRAY_SIZE(kPositiveOffset),
      kPositiveOffset},
     {{al, r9, r5, plus, r6, LSL, 10, Offset},
      "al r9 r5 plus r6 LSL 10 Offset",
      "PositiveOffset_al_r9_r5_plus_r6_LSL_10_Offset",
      ARRAY_SIZE(kPositiveOffset),
      kPositiveOffset},
     {{al, r11, r4, plus, r9, LSL, 28, Offset},
      "al r11 r4 plus r9 LSL 28 Offset",
      "PositiveOffset_al_r11_r4_plus_r9_LSL_28_Offset",
      ARRAY_SIZE(kPositiveOffset),
      kPositiveOffset},
     {{al, r7, r1, minus, r10, ROR, 20, Offset},
      "al r7 r1 minus r10 ROR 20 Offset",
      "NegativeOffset_al_r7_r1_minus_r10_ROR_20_Offset",
      ARRAY_SIZE(kNegativeOffset),
      kNegativeOffset},
     {{al, r4, r12, minus, r6, ROR, 2, Offset},
      "al r4 r12 minus r6 ROR 2 Offset",
      "NegativeOffset_al_r4_r12_minus_r6_ROR_2_Offset",
      ARRAY_SIZE(kNegativeOffset),
      kNegativeOffset},
     {{al, r6, r4, minus, r11, LSL, 6, Offset},
      "al r6 r4 minus r11 LSL 6 Offset",
      "NegativeOffset_al_r6_r4_minus_r11_LSL_6_Offset",
      ARRAY_SIZE(kNegativeOffset),
      kNegativeOffset},
     {{al, r10, r0, minus, r12, LSL, 19, Offset},
      "al r10 r0 minus r12 LSL 19 Offset",
      "NegativeOffset_al_r10_r0_minus_r12_LSL_19_Offset",
      ARRAY_SIZE(kNegativeOffset),
      kNegativeOffset},
     {{al, r10, r3, minus, r14, LSL, 20, Offset},
      "al r10 r3 minus r14 LSL 20 Offset",
      "NegativeOffset_al_r10_r3_minus_r14_LSL_20_Offset",
      ARRAY_SIZE(kNegativeOffset),
      kNegativeOffset},
     {{al, r10, r3, minus, r12, LSL, 20, Offset},
      "al r10 r3 minus r12 LSL 20 Offset",
      "NegativeOffset_al_r10_r3_minus_r12_LSL_20_Offset",
      ARRAY_SIZE(kNegativeOffset),
      kNegativeOffset},
     {{al, r14, r10, minus, r12, ROR, 29, Offset},
      "al r14 r10 minus r12 ROR 29 Offset",
      "NegativeOffset_al_r14_r10_minus_r12_ROR_29_Offset",
      ARRAY_SIZE(kNegativeOffset),
      kNegativeOffset},
     {{al, r2, r11, minus, r5, ROR, 21, Offset},
      "al r2 r11 minus r5 ROR 21 Offset",
      "NegativeOffset_al_r2_r11_minus_r5_ROR_21_Offset",
      ARRAY_SIZE(kNegativeOffset),
      kNegativeOffset},
     {{al, r14, r5, minus, r1, ROR, 22, Offset},
      "al r14 r5 minus r1 ROR 22 Offset",
      "NegativeOffset_al_r14_r5_minus_r1_ROR_22_Offset",
      ARRAY_SIZE(kNegativeOffset),
      kNegativeOffset},
     {{al, r7, r4, minus, r10, LSL, 18, Offset},
      "al r7 r4 minus r10 LSL 18 Offset",
      "NegativeOffset_al_r7_r4_minus_r10_LSL_18_Offset",
      ARRAY_SIZE(kNegativeOffset),
      kNegativeOffset},
     {{al, r4, r2, minus, r1, LSL, 9, Offset},
      "al r4 r2 minus r1 LSL 9 Offset",
      "NegativeOffset_al_r4_r2_minus_r1_LSL_9_Offset",
      ARRAY_SIZE(kNegativeOffset),
      kNegativeOffset},
     {{al, r10, r12, minus, r8, LSL, 11, Offset},
      "al r10 r12 minus r8 LSL 11 Offset",
      "NegativeOffset_al_r10_r12_minus_r8_LSL_11_Offset",
      ARRAY_SIZE(kNegativeOffset),
      kNegativeOffset},
     {{al, r5, r4, minus, r1, ROR, 30, Offset},
      "al r5 r4 minus r1 ROR 30 Offset",
      "NegativeOffset_al_r5_r4_minus_r1_ROR_30_Offset",
      ARRAY_SIZE(kNegativeOffset),
      kNegativeOffset},
     {{al, r11, r0, minus, r10, ROR, 10, Offset},
      "al r11 r0 minus r10 ROR 10 Offset",
      "NegativeOffset_al_r11_r0_minus_r10_ROR_10_Offset",
      ARRAY_SIZE(kNegativeOffset),
      kNegativeOffset},
     {{al, r11, r3, minus, r6, ROR, 25, Offset},
      "al r11 r3 minus r6 ROR 25 Offset",
      "NegativeOffset_al_r11_r3_minus_r6_ROR_25_Offset",
      ARRAY_SIZE(kNegativeOffset),
      kNegativeOffset},
     {{al, r3, r12, minus, r1, ROR, 27, Offset},
      "al r3 r12 minus r1 ROR 27 Offset",
      "NegativeOffset_al_r3_r12_minus_r1_ROR_27_Offset",
      ARRAY_SIZE(kNegativeOffset),
      kNegativeOffset},
     {{al, r3, r1, minus, r14, LSL, 5, Offset},
      "al r3 r1 minus r14 LSL 5 Offset",
      "NegativeOffset_al_r3_r1_minus_r14_LSL_5_Offset",
      ARRAY_SIZE(kNegativeOffset),
      kNegativeOffset},
     {{al, r9, r1, minus, r7, LSL, 27, Offset},
      "al r9 r1 minus r7 LSL 27 Offset",
      "NegativeOffset_al_r9_r1_minus_r7_LSL_27_Offset",
      ARRAY_SIZE(kNegativeOffset),
      kNegativeOffset},
     {{al, r2, r9, minus, r6, LSL, 4, Offset},
      "al r2 r9 minus r6 LSL 4 Offset",
      "NegativeOffset_al_r2_r9_minus_r6_LSL_4_Offset",
      ARRAY_SIZE(kNegativeOffset),
      kNegativeOffset},
     {{al, r4, r6, minus, r1, ROR, 19, Offset},
      "al r4 r6 minus r1 ROR 19 Offset",
      "NegativeOffset_al_r4_r6_minus_r1_ROR_19_Offset",
      ARRAY_SIZE(kNegativeOffset),
      kNegativeOffset},
     {{al, r14, r8, minus, r6, LSL, 5, Offset},
      "al r14 r8 minus r6 LSL 5 Offset",
      "NegativeOffset_al_r14_r8_minus_r6_LSL_5_Offset",
      ARRAY_SIZE(kNegativeOffset),
      kNegativeOffset},
     {{al, r5, r0, minus, r12, LSL, 16, Offset},
      "al r5 r0 minus r12 LSL 16 Offset",
      "NegativeOffset_al_r5_r0_minus_r12_LSL_16_Offset",
      ARRAY_SIZE(kNegativeOffset),
      kNegativeOffset},
     {{al, r5, r4, minus, r12, ROR, 29, Offset},
      "al r5 r4 minus r12 ROR 29 Offset",
      "NegativeOffset_al_r5_r4_minus_r12_ROR_29_Offset",
      ARRAY_SIZE(kNegativeOffset),
      kNegativeOffset},
     {{al, r4, r10, minus, r1, LSL, 2, Offset},
      "al r4 r10 minus r1 LSL 2 Offset",
      "NegativeOffset_al_r4_r10_minus_r1_LSL_2_Offset",
      ARRAY_SIZE(kNegativeOffset),
      kNegativeOffset},
     {{al, r6, r5, minus, r12, ROR, 8, Offset},
      "al r6 r5 minus r12 ROR 8 Offset",
      "NegativeOffset_al_r6_r5_minus_r12_ROR_8_Offset",
      ARRAY_SIZE(kNegativeOffset),
      kNegativeOffset},
     {{al, r1, r11, minus, r0, ROR, 8, Offset},
      "al r1 r11 minus r0 ROR 8 Offset",
      "NegativeOffset_al_r1_r11_minus_r0_ROR_8_Offset",
      ARRAY_SIZE(kNegativeOffset),
      kNegativeOffset},
     {{al, r10, r9, minus, r5, ROR, 1, Offset},
      "al r10 r9 minus r5 ROR 1 Offset",
      "NegativeOffset_al_r10_r9_minus_r5_ROR_1_Offset",
      ARRAY_SIZE(kNegativeOffset),
      kNegativeOffset},
     {{al, r14, r2, minus, r7, LSL, 8, Offset},
      "al r14 r2 minus r7 LSL 8 Offset",
      "NegativeOffset_al_r14_r2_minus_r7_LSL_8_Offset",
      ARRAY_SIZE(kNegativeOffset),
      kNegativeOffset},
     {{al, r3, r12, minus, r2, LSL, 17, Offset},
      "al r3 r12 minus r2 LSL 17 Offset",
      "NegativeOffset_al_r3_r12_minus_r2_LSL_17_Offset",
      ARRAY_SIZE(kNegativeOffset),
      kNegativeOffset},
     {{al, r11, r6, minus, r7, LSL, 3, Offset},
      "al r11 r6 minus r7 LSL 3 Offset",
      "NegativeOffset_al_r11_r6_minus_r7_LSL_3_Offset",
      ARRAY_SIZE(kNegativeOffset),
      kNegativeOffset},
     {{al, r2, r14, minus, r10, LSL, 26, Offset},
      "al r2 r14 minus r10 LSL 26 Offset",
      "NegativeOffset_al_r2_r14_minus_r10_LSL_26_Offset",
      ARRAY_SIZE(kNegativeOffset),
      kNegativeOffset},
     {{al, r6, r3, minus, r11, LSL, 8, Offset},
      "al r6 r3 minus r11 LSL 8 Offset",
      "NegativeOffset_al_r6_r3_minus_r11_LSL_8_Offset",
      ARRAY_SIZE(kNegativeOffset),
      kNegativeOffset},
     {{al, r9, r1, minus, r7, LSL, 20, Offset},
      "al r9 r1 minus r7 LSL 20 Offset",
      "NegativeOffset_al_r9_r1_minus_r7_LSL_20_Offset",
      ARRAY_SIZE(kNegativeOffset),
      kNegativeOffset},
     {{al, r1, r11, minus, r12, ROR, 6, Offset},
      "al r1 r11 minus r12 ROR 6 Offset",
      "NegativeOffset_al_r1_r11_minus_r12_ROR_6_Offset",
      ARRAY_SIZE(kNegativeOffset),
      kNegativeOffset},
     {{al, r7, r6, minus, r14, LSL, 16, Offset},
      "al r7 r6 minus r14 LSL 16 Offset",
      "NegativeOffset_al_r7_r6_minus_r14_LSL_16_Offset",
      ARRAY_SIZE(kNegativeOffset),
      kNegativeOffset},
     {{al, r12, r0, minus, r10, ROR, 6, Offset},
      "al r12 r0 minus r10 ROR 6 Offset",
      "NegativeOffset_al_r12_r0_minus_r10_ROR_6_Offset",
      ARRAY_SIZE(kNegativeOffset),
      kNegativeOffset},
     {{al, r11, r12, minus, r10, ROR, 7, Offset},
      "al r11 r12 minus r10 ROR 7 Offset",
      "NegativeOffset_al_r11_r12_minus_r10_ROR_7_Offset",
      ARRAY_SIZE(kNegativeOffset),
      kNegativeOffset},
     {{al, r12, r5, minus, r7, LSL, 8, Offset},
      "al r12 r5 minus r7 LSL 8 Offset",
      "NegativeOffset_al_r12_r5_minus_r7_LSL_8_Offset",
      ARRAY_SIZE(kNegativeOffset),
      kNegativeOffset},
     {{al, r9, r0, minus, r7, ROR, 14, Offset},
      "al r9 r0 minus r7 ROR 14 Offset",
      "NegativeOffset_al_r9_r0_minus_r7_ROR_14_Offset",
      ARRAY_SIZE(kNegativeOffset),
      kNegativeOffset},
     {{al, r12, r1, minus, r6, LSL, 22, Offset},
      "al r12 r1 minus r6 LSL 22 Offset",
      "NegativeOffset_al_r12_r1_minus_r6_LSL_22_Offset",
      ARRAY_SIZE(kNegativeOffset),
      kNegativeOffset},
     {{al, r11, r7, minus, r10, LSL, 16, Offset},
      "al r11 r7 minus r10 LSL 16 Offset",
      "NegativeOffset_al_r11_r7_minus_r10_LSL_16_Offset",
      ARRAY_SIZE(kNegativeOffset),
      kNegativeOffset},
     {{al, r6, r10, minus, r9, LSL, 8, Offset},
      "al r6 r10 minus r9 LSL 8 Offset",
      "NegativeOffset_al_r6_r10_minus_r9_LSL_8_Offset",
      ARRAY_SIZE(kNegativeOffset),
      kNegativeOffset},
     {{al, r2, r6, minus, r7, LSL, 18, Offset},
      "al r2 r6 minus r7 LSL 18 Offset",
      "NegativeOffset_al_r2_r6_minus_r7_LSL_18_Offset",
      ARRAY_SIZE(kNegativeOffset),
      kNegativeOffset},
     {{al, r7, r9, minus, r6, ROR, 31, Offset},
      "al r7 r9 minus r6 ROR 31 Offset",
      "NegativeOffset_al_r7_r9_minus_r6_ROR_31_Offset",
      ARRAY_SIZE(kNegativeOffset),
      kNegativeOffset},
     {{al, r10, r9, minus, r11, LSL, 16, Offset},
      "al r10 r9 minus r11 LSL 16 Offset",
      "NegativeOffset_al_r10_r9_minus_r11_LSL_16_Offset",
      ARRAY_SIZE(kNegativeOffset),
      kNegativeOffset},
     {{al, r11, r1, minus, r3, ROR, 8, Offset},
      "al r11 r1 minus r3 ROR 8 Offset",
      "NegativeOffset_al_r11_r1_minus_r3_ROR_8_Offset",
      ARRAY_SIZE(kNegativeOffset),
      kNegativeOffset},
     {{al, r14, r3, minus, r1, LSL, 1, Offset},
      "al r14 r3 minus r1 LSL 1 Offset",
      "NegativeOffset_al_r14_r3_minus_r1_LSL_1_Offset",
      ARRAY_SIZE(kNegativeOffset),
      kNegativeOffset},
     {{al, r1, r10, minus, r6, ROR, 19, Offset},
      "al r1 r10 minus r6 ROR 19 Offset",
      "NegativeOffset_al_r1_r10_minus_r6_ROR_19_Offset",
      ARRAY_SIZE(kNegativeOffset),
      kNegativeOffset},
     {{al, r2, r11, minus, r5, ROR, 24, Offset},
      "al r2 r11 minus r5 ROR 24 Offset",
      "NegativeOffset_al_r2_r11_minus_r5_ROR_24_Offset",
      ARRAY_SIZE(kNegativeOffset),
      kNegativeOffset},
     {{al, r3, r9, minus, r2, LSL, 19, Offset},
      "al r3 r9 minus r2 LSL 19 Offset",
      "NegativeOffset_al_r3_r9_minus_r2_LSL_19_Offset",
      ARRAY_SIZE(kNegativeOffset),
      kNegativeOffset},
     {{al, r14, r5, minus, r10, LSL, 25, Offset},
      "al r14 r5 minus r10 LSL 25 Offset",
      "NegativeOffset_al_r14_r5_minus_r10_LSL_25_Offset",
      ARRAY_SIZE(kNegativeOffset),
      kNegativeOffset},
     {{al, r4, r6, minus, r7, ROR, 22, Offset},
      "al r4 r6 minus r7 ROR 22 Offset",
      "NegativeOffset_al_r4_r6_minus_r7_ROR_22_Offset",
      ARRAY_SIZE(kNegativeOffset),
      kNegativeOffset},
     {{al, r8, r4, minus, r6, LSL, 9, Offset},
      "al r8 r4 minus r6 LSL 9 Offset",
      "NegativeOffset_al_r8_r4_minus_r6_LSL_9_Offset",
      ARRAY_SIZE(kNegativeOffset),
      kNegativeOffset},
     {{al, r3, r5, minus, r9, LSL, 24, Offset},
      "al r3 r5 minus r9 LSL 24 Offset",
      "NegativeOffset_al_r3_r5_minus_r9_LSL_24_Offset",
      ARRAY_SIZE(kNegativeOffset),
      kNegativeOffset},
     {{al, r11, r7, minus, r14, ROR, 29, Offset},
      "al r11 r7 minus r14 ROR 29 Offset",
      "NegativeOffset_al_r11_r7_minus_r14_ROR_29_Offset",
      ARRAY_SIZE(kNegativeOffset),
      kNegativeOffset},
     {{al, r9, r10, minus, r0, ROR, 10, Offset},
      "al r9 r10 minus r0 ROR 10 Offset",
      "NegativeOffset_al_r9_r10_minus_r0_ROR_10_Offset",
      ARRAY_SIZE(kNegativeOffset),
      kNegativeOffset},
     {{al, r1, r3, minus, r2, LSL, 2, Offset},
      "al r1 r3 minus r2 LSL 2 Offset",
      "NegativeOffset_al_r1_r3_minus_r2_LSL_2_Offset",
      ARRAY_SIZE(kNegativeOffset),
      kNegativeOffset},
     {{al, r1, r9, minus, r10, LSL, 5, Offset},
      "al r1 r9 minus r10 LSL 5 Offset",
      "NegativeOffset_al_r1_r9_minus_r10_LSL_5_Offset",
      ARRAY_SIZE(kNegativeOffset),
      kNegativeOffset},
     {{al, r6, r8, minus, r0, LSL, 9, Offset},
      "al r6 r8 minus r0 LSL 9 Offset",
      "NegativeOffset_al_r6_r8_minus_r0_LSL_9_Offset",
      ARRAY_SIZE(kNegativeOffset),
      kNegativeOffset},
     {{al, r6, r14, minus, r8, ROR, 28, Offset},
      "al r6 r14 minus r8 ROR 28 Offset",
      "NegativeOffset_al_r6_r14_minus_r8_ROR_28_Offset",
      ARRAY_SIZE(kNegativeOffset),
      kNegativeOffset},
     {{al, r4, r12, minus, r7, LSL, 30, Offset},
      "al r4 r12 minus r7 LSL 30 Offset",
      "NegativeOffset_al_r4_r12_minus_r7_LSL_30_Offset",
      ARRAY_SIZE(kNegativeOffset),
      kNegativeOffset},
     {{al, r6, r8, minus, r0, ROR, 26, Offset},
      "al r6 r8 minus r0 ROR 26 Offset",
      "NegativeOffset_al_r6_r8_minus_r0_ROR_26_Offset",
      ARRAY_SIZE(kNegativeOffset),
      kNegativeOffset},
     {{al, r2, r8, minus, r9, LSL, 17, Offset},
      "al r2 r8 minus r9 LSL 17 Offset",
      "NegativeOffset_al_r2_r8_minus_r9_LSL_17_Offset",
      ARRAY_SIZE(kNegativeOffset),
      kNegativeOffset},
     {{al, r9, r14, minus, r0, LSL, 5, Offset},
      "al r9 r14 minus r0 LSL 5 Offset",
      "NegativeOffset_al_r9_r14_minus_r0_LSL_5_Offset",
      ARRAY_SIZE(kNegativeOffset),
      kNegativeOffset},
     {{al, r11, r3, minus, r9, ROR, 27, Offset},
      "al r11 r3 minus r9 ROR 27 Offset",
      "NegativeOffset_al_r11_r3_minus_r9_ROR_27_Offset",
      ARRAY_SIZE(kNegativeOffset),
      kNegativeOffset},
     {{al, r6, r8, minus, r3, ROR, 19, Offset},
      "al r6 r8 minus r3 ROR 19 Offset",
      "NegativeOffset_al_r6_r8_minus_r3_ROR_19_Offset",
      ARRAY_SIZE(kNegativeOffset),
      kNegativeOffset},
     {{al, r0, r7, minus, r1, LSL, 7, Offset},
      "al r0 r7 minus r1 LSL 7 Offset",
      "NegativeOffset_al_r0_r7_minus_r1_LSL_7_Offset",
      ARRAY_SIZE(kNegativeOffset),
      kNegativeOffset},
     {{al, r8, r7, minus, r1, LSL, 14, Offset},
      "al r8 r7 minus r1 LSL 14 Offset",
      "NegativeOffset_al_r8_r7_minus_r1_LSL_14_Offset",
      ARRAY_SIZE(kNegativeOffset),
      kNegativeOffset},
     {{al, r7, r4, minus, r8, LSL, 15, Offset},
      "al r7 r4 minus r8 LSL 15 Offset",
      "NegativeOffset_al_r7_r4_minus_r8_LSL_15_Offset",
      ARRAY_SIZE(kNegativeOffset),
      kNegativeOffset},
     {{al, r14, r11, minus, r1, ROR, 21, Offset},
      "al r14 r11 minus r1 ROR 21 Offset",
      "NegativeOffset_al_r14_r11_minus_r1_ROR_21_Offset",
      ARRAY_SIZE(kNegativeOffset),
      kNegativeOffset},
     {{al, r12, r14, minus, r6, ROR, 6, Offset},
      "al r12 r14 minus r6 ROR 6 Offset",
      "NegativeOffset_al_r12_r14_minus_r6_ROR_6_Offset",
      ARRAY_SIZE(kNegativeOffset),
      kNegativeOffset},
     {{al, r4, r12, minus, r14, LSL, 25, Offset},
      "al r4 r12 minus r14 LSL 25 Offset",
      "NegativeOffset_al_r4_r12_minus_r14_LSL_25_Offset",
      ARRAY_SIZE(kNegativeOffset),
      kNegativeOffset},
     {{al, r6, r12, minus, r2, ROR, 2, Offset},
      "al r6 r12 minus r2 ROR 2 Offset",
      "NegativeOffset_al_r6_r12_minus_r2_ROR_2_Offset",
      ARRAY_SIZE(kNegativeOffset),
      kNegativeOffset},
     {{al, r11, r1, minus, r8, LSL, 26, Offset},
      "al r11 r1 minus r8 LSL 26 Offset",
      "NegativeOffset_al_r11_r1_minus_r8_LSL_26_Offset",
      ARRAY_SIZE(kNegativeOffset),
      kNegativeOffset},
     {{al, r9, r1, minus, r10, ROR, 29, Offset},
      "al r9 r1 minus r10 ROR 29 Offset",
      "NegativeOffset_al_r9_r1_minus_r10_ROR_29_Offset",
      ARRAY_SIZE(kNegativeOffset),
      kNegativeOffset},
     {{al, r0, r6, minus, r4, LSL, 23, Offset},
      "al r0 r6 minus r4 LSL 23 Offset",
      "NegativeOffset_al_r0_r6_minus_r4_LSL_23_Offset",
      ARRAY_SIZE(kNegativeOffset),
      kNegativeOffset},
     {{al, r12, r8, minus, r14, LSL, 26, Offset},
      "al r12 r8 minus r14 LSL 26 Offset",
      "NegativeOffset_al_r12_r8_minus_r14_LSL_26_Offset",
      ARRAY_SIZE(kNegativeOffset),
      kNegativeOffset},
     {{al, r0, r11, minus, r2, ROR, 23, Offset},
      "al r0 r11 minus r2 ROR 23 Offset",
      "NegativeOffset_al_r0_r11_minus_r2_ROR_23_Offset",
      ARRAY_SIZE(kNegativeOffset),
      kNegativeOffset},
     {{al, r11, r4, minus, r2, ROR, 14, Offset},
      "al r11 r4 minus r2 ROR 14 Offset",
      "NegativeOffset_al_r11_r4_minus_r2_ROR_14_Offset",
      ARRAY_SIZE(kNegativeOffset),
      kNegativeOffset},
     {{al, r4, r10, minus, r14, ROR, 29, Offset},
      "al r4 r10 minus r14 ROR 29 Offset",
      "NegativeOffset_al_r4_r10_minus_r14_ROR_29_Offset",
      ARRAY_SIZE(kNegativeOffset),
      kNegativeOffset},
     {{al, r7, r0, minus, r12, ROR, 5, Offset},
      "al r7 r0 minus r12 ROR 5 Offset",
      "NegativeOffset_al_r7_r0_minus_r12_ROR_5_Offset",
      ARRAY_SIZE(kNegativeOffset),
      kNegativeOffset},
     {{al, r6, r12, minus, r0, ROR, 15, Offset},
      "al r6 r12 minus r0 ROR 15 Offset",
      "NegativeOffset_al_r6_r12_minus_r0_ROR_15_Offset",
      ARRAY_SIZE(kNegativeOffset),
      kNegativeOffset},
     {{al, r6, r1, minus, r7, ROR, 22, Offset},
      "al r6 r1 minus r7 ROR 22 Offset",
      "NegativeOffset_al_r6_r1_minus_r7_ROR_22_Offset",
      ARRAY_SIZE(kNegativeOffset),
      kNegativeOffset},
     {{al, r9, r3, minus, r14, LSL, 7, Offset},
      "al r9 r3 minus r14 LSL 7 Offset",
      "NegativeOffset_al_r9_r3_minus_r14_LSL_7_Offset",
      ARRAY_SIZE(kNegativeOffset),
      kNegativeOffset},
     {{al, r12, r0, minus, r7, ROR, 19, Offset},
      "al r12 r0 minus r7 ROR 19 Offset",
      "NegativeOffset_al_r12_r0_minus_r7_ROR_19_Offset",
      ARRAY_SIZE(kNegativeOffset),
      kNegativeOffset},
     {{al, r9, r8, minus, r11, ROR, 21, Offset},
      "al r9 r8 minus r11 ROR 21 Offset",
      "NegativeOffset_al_r9_r8_minus_r11_ROR_21_Offset",
      ARRAY_SIZE(kNegativeOffset),
      kNegativeOffset},
     {{al, r9, r2, minus, r3, LSL, 20, Offset},
      "al r9 r2 minus r3 LSL 20 Offset",
      "NegativeOffset_al_r9_r2_minus_r3_LSL_20_Offset",
      ARRAY_SIZE(kNegativeOffset),
      kNegativeOffset},
     {{al, r12, r2, minus, r5, ROR, 25, Offset},
      "al r12 r2 minus r5 ROR 25 Offset",
      "NegativeOffset_al_r12_r2_minus_r5_ROR_25_Offset",
      ARRAY_SIZE(kNegativeOffset),
      kNegativeOffset},
     {{al, r6, r7, minus, r3, LSL, 15, Offset},
      "al r6 r7 minus r3 LSL 15 Offset",
      "NegativeOffset_al_r6_r7_minus_r3_LSL_15_Offset",
      ARRAY_SIZE(kNegativeOffset),
      kNegativeOffset},
     {{al, r1, r12, minus, r14, LSL, 12, Offset},
      "al r1 r12 minus r14 LSL 12 Offset",
      "NegativeOffset_al_r1_r12_minus_r14_LSL_12_Offset",
      ARRAY_SIZE(kNegativeOffset),
      kNegativeOffset},
     {{al, r14, r4, minus, r11, ROR, 31, Offset},
      "al r14 r4 minus r11 ROR 31 Offset",
      "NegativeOffset_al_r14_r4_minus_r11_ROR_31_Offset",
      ARRAY_SIZE(kNegativeOffset),
      kNegativeOffset},
     {{al, r14, r5, minus, r2, LSL, 27, Offset},
      "al r14 r5 minus r2 LSL 27 Offset",
      "NegativeOffset_al_r14_r5_minus_r2_LSL_27_Offset",
      ARRAY_SIZE(kNegativeOffset),
      kNegativeOffset},
     {{al, r9, r6, minus, r12, LSL, 31, Offset},
      "al r9 r6 minus r12 LSL 31 Offset",
      "NegativeOffset_al_r9_r6_minus_r12_LSL_31_Offset",
      ARRAY_SIZE(kNegativeOffset),
      kNegativeOffset},
     {{al, r4, r8, minus, r11, ROR, 31, Offset},
      "al r4 r8 minus r11 ROR 31 Offset",
      "NegativeOffset_al_r4_r8_minus_r11_ROR_31_Offset",
      ARRAY_SIZE(kNegativeOffset),
      kNegativeOffset},
     {{al, r0, r12, minus, r10, ROR, 25, Offset},
      "al r0 r12 minus r10 ROR 25 Offset",
      "NegativeOffset_al_r0_r12_minus_r10_ROR_25_Offset",
      ARRAY_SIZE(kNegativeOffset),
      kNegativeOffset},
     {{al, r1, r0, minus, r7, ROR, 5, Offset},
      "al r1 r0 minus r7 ROR 5 Offset",
      "NegativeOffset_al_r1_r0_minus_r7_ROR_5_Offset",
      ARRAY_SIZE(kNegativeOffset),
      kNegativeOffset},
     {{al, r12, r4, minus, r11, LSL, 26, Offset},
      "al r12 r4 minus r11 LSL 26 Offset",
      "NegativeOffset_al_r12_r4_minus_r11_LSL_26_Offset",
      ARRAY_SIZE(kNegativeOffset),
      kNegativeOffset},
     {{al, r2, r3, minus, r4, LSL, 10, Offset},
      "al r2 r3 minus r4 LSL 10 Offset",
      "NegativeOffset_al_r2_r3_minus_r4_LSL_10_Offset",
      ARRAY_SIZE(kNegativeOffset),
      kNegativeOffset},
     {{al, r1, r10, minus, r6, LSL, 8, Offset},
      "al r1 r10 minus r6 LSL 8 Offset",
      "NegativeOffset_al_r1_r10_minus_r6_LSL_8_Offset",
      ARRAY_SIZE(kNegativeOffset),
      kNegativeOffset},
     {{al, r7, r10, minus, r2, LSL, 8, Offset},
      "al r7 r10 minus r2 LSL 8 Offset",
      "NegativeOffset_al_r7_r10_minus_r2_LSL_8_Offset",
      ARRAY_SIZE(kNegativeOffset),
      kNegativeOffset},
     {{al, r9, r4, plus, r0, ROR, 19, PostIndex},
      "al r9 r4 plus r0 ROR 19 PostIndex",
      "PositivePostIndex_al_r9_r4_plus_r0_ROR_19_PostIndex",
      ARRAY_SIZE(kPositivePostIndex),
      kPositivePostIndex},
     {{al, r2, r3, plus, r8, LSL, 10, PostIndex},
      "al r2 r3 plus r8 LSL 10 PostIndex",
      "PositivePostIndex_al_r2_r3_plus_r8_LSL_10_PostIndex",
      ARRAY_SIZE(kPositivePostIndex),
      kPositivePostIndex},
     {{al, r11, r14, plus, r5, LSL, 31, PostIndex},
      "al r11 r14 plus r5 LSL 31 PostIndex",
      "PositivePostIndex_al_r11_r14_plus_r5_LSL_31_PostIndex",
      ARRAY_SIZE(kPositivePostIndex),
      kPositivePostIndex},
     {{al, r5, r14, plus, r9, ROR, 11, PostIndex},
      "al r5 r14 plus r9 ROR 11 PostIndex",
      "PositivePostIndex_al_r5_r14_plus_r9_ROR_11_PostIndex",
      ARRAY_SIZE(kPositivePostIndex),
      kPositivePostIndex},
     {{al, r6, r1, plus, r5, LSL, 11, PostIndex},
      "al r6 r1 plus r5 LSL 11 PostIndex",
      "PositivePostIndex_al_r6_r1_plus_r5_LSL_11_PostIndex",
      ARRAY_SIZE(kPositivePostIndex),
      kPositivePostIndex},
     {{al, r3, r2, plus, r14, LSL, 19, PostIndex},
      "al r3 r2 plus r14 LSL 19 PostIndex",
      "PositivePostIndex_al_r3_r2_plus_r14_LSL_19_PostIndex",
      ARRAY_SIZE(kPositivePostIndex),
      kPositivePostIndex},
     {{al, r12, r11, plus, r10, ROR, 6, PostIndex},
      "al r12 r11 plus r10 ROR 6 PostIndex",
      "PositivePostIndex_al_r12_r11_plus_r10_ROR_6_PostIndex",
      ARRAY_SIZE(kPositivePostIndex),
      kPositivePostIndex},
     {{al, r5, r0, plus, r10, LSL, 18, PostIndex},
      "al r5 r0 plus r10 LSL 18 PostIndex",
      "PositivePostIndex_al_r5_r0_plus_r10_LSL_18_PostIndex",
      ARRAY_SIZE(kPositivePostIndex),
      kPositivePostIndex},
     {{al, r4, r11, plus, r8, ROR, 6, PostIndex},
      "al r4 r11 plus r8 ROR 6 PostIndex",
      "PositivePostIndex_al_r4_r11_plus_r8_ROR_6_PostIndex",
      ARRAY_SIZE(kPositivePostIndex),
      kPositivePostIndex},
     {{al, r6, r9, plus, r14, ROR, 15, PostIndex},
      "al r6 r9 plus r14 ROR 15 PostIndex",
      "PositivePostIndex_al_r6_r9_plus_r14_ROR_15_PostIndex",
      ARRAY_SIZE(kPositivePostIndex),
      kPositivePostIndex},
     {{al, r3, r10, plus, r2, LSL, 6, PostIndex},
      "al r3 r10 plus r2 LSL 6 PostIndex",
      "PositivePostIndex_al_r3_r10_plus_r2_LSL_6_PostIndex",
      ARRAY_SIZE(kPositivePostIndex),
      kPositivePostIndex},
     {{al, r3, r5, plus, r8, LSL, 14, PostIndex},
      "al r3 r5 plus r8 LSL 14 PostIndex",
      "PositivePostIndex_al_r3_r5_plus_r8_LSL_14_PostIndex",
      ARRAY_SIZE(kPositivePostIndex),
      kPositivePostIndex},
     {{al, r8, r12, plus, r5, LSL, 14, PostIndex},
      "al r8 r12 plus r5 LSL 14 PostIndex",
      "PositivePostIndex_al_r8_r12_plus_r5_LSL_14_PostIndex",
      ARRAY_SIZE(kPositivePostIndex),
      kPositivePostIndex},
     {{al, r11, r4, plus, r6, LSL, 3, PostIndex},
      "al r11 r4 plus r6 LSL 3 PostIndex",
      "PositivePostIndex_al_r11_r4_plus_r6_LSL_3_PostIndex",
      ARRAY_SIZE(kPositivePostIndex),
      kPositivePostIndex},
     {{al, r8, r12, plus, r11, ROR, 16, PostIndex},
      "al r8 r12 plus r11 ROR 16 PostIndex",
      "PositivePostIndex_al_r8_r12_plus_r11_ROR_16_PostIndex",
      ARRAY_SIZE(kPositivePostIndex),
      kPositivePostIndex},
     {{al, r14, r7, plus, r3, LSL, 26, PostIndex},
      "al r14 r7 plus r3 LSL 26 PostIndex",
      "PositivePostIndex_al_r14_r7_plus_r3_LSL_26_PostIndex",
      ARRAY_SIZE(kPositivePostIndex),
      kPositivePostIndex},
     {{al, r2, r5, plus, r0, LSL, 13, PostIndex},
      "al r2 r5 plus r0 LSL 13 PostIndex",
      "PositivePostIndex_al_r2_r5_plus_r0_LSL_13_PostIndex",
      ARRAY_SIZE(kPositivePostIndex),
      kPositivePostIndex},
     {{al, r1, r14, plus, r10, ROR, 20, PostIndex},
      "al r1 r14 plus r10 ROR 20 PostIndex",
      "PositivePostIndex_al_r1_r14_plus_r10_ROR_20_PostIndex",
      ARRAY_SIZE(kPositivePostIndex),
      kPositivePostIndex},
     {{al, r9, r0, plus, r12, LSL, 4, PostIndex},
      "al r9 r0 plus r12 LSL 4 PostIndex",
      "PositivePostIndex_al_r9_r0_plus_r12_LSL_4_PostIndex",
      ARRAY_SIZE(kPositivePostIndex),
      kPositivePostIndex},
     {{al, r8, r1, plus, r12, LSL, 23, PostIndex},
      "al r8 r1 plus r12 LSL 23 PostIndex",
      "PositivePostIndex_al_r8_r1_plus_r12_LSL_23_PostIndex",
      ARRAY_SIZE(kPositivePostIndex),
      kPositivePostIndex},
     {{al, r10, r12, plus, r1, ROR, 25, PostIndex},
      "al r10 r12 plus r1 ROR 25 PostIndex",
      "PositivePostIndex_al_r10_r12_plus_r1_ROR_25_PostIndex",
      ARRAY_SIZE(kPositivePostIndex),
      kPositivePostIndex},
     {{al, r9, r4, plus, r5, LSL, 30, PostIndex},
      "al r9 r4 plus r5 LSL 30 PostIndex",
      "PositivePostIndex_al_r9_r4_plus_r5_LSL_30_PostIndex",
      ARRAY_SIZE(kPositivePostIndex),
      kPositivePostIndex},
     {{al, r6, r2, plus, r0, LSL, 6, PostIndex},
      "al r6 r2 plus r0 LSL 6 PostIndex",
      "PositivePostIndex_al_r6_r2_plus_r0_LSL_6_PostIndex",
      ARRAY_SIZE(kPositivePostIndex),
      kPositivePostIndex},
     {{al, r9, r12, plus, r5, ROR, 19, PostIndex},
      "al r9 r12 plus r5 ROR 19 PostIndex",
      "PositivePostIndex_al_r9_r12_plus_r5_ROR_19_PostIndex",
      ARRAY_SIZE(kPositivePostIndex),
      kPositivePostIndex},
     {{al, r11, r7, plus, r14, LSL, 16, PostIndex},
      "al r11 r7 plus r14 LSL 16 PostIndex",
      "PositivePostIndex_al_r11_r7_plus_r14_LSL_16_PostIndex",
      ARRAY_SIZE(kPositivePostIndex),
      kPositivePostIndex},
     {{al, r1, r4, plus, r3, ROR, 7, PostIndex},
      "al r1 r4 plus r3 ROR 7 PostIndex",
      "PositivePostIndex_al_r1_r4_plus_r3_ROR_7_PostIndex",
      ARRAY_SIZE(kPositivePostIndex),
      kPositivePostIndex},
     {{al, r3, r1, plus, r14, ROR, 3, PostIndex},
      "al r3 r1 plus r14 ROR 3 PostIndex",
      "PositivePostIndex_al_r3_r1_plus_r14_ROR_3_PostIndex",
      ARRAY_SIZE(kPositivePostIndex),
      kPositivePostIndex},
     {{al, r7, r0, plus, r4, ROR, 8, PostIndex},
      "al r7 r0 plus r4 ROR 8 PostIndex",
      "PositivePostIndex_al_r7_r0_plus_r4_ROR_8_PostIndex",
      ARRAY_SIZE(kPositivePostIndex),
      kPositivePostIndex},
     {{al, r0, r8, plus, r1, ROR, 27, PostIndex},
      "al r0 r8 plus r1 ROR 27 PostIndex",
      "PositivePostIndex_al_r0_r8_plus_r1_ROR_27_PostIndex",
      ARRAY_SIZE(kPositivePostIndex),
      kPositivePostIndex},
     {{al, r5, r4, plus, r11, LSL, 24, PostIndex},
      "al r5 r4 plus r11 LSL 24 PostIndex",
      "PositivePostIndex_al_r5_r4_plus_r11_LSL_24_PostIndex",
      ARRAY_SIZE(kPositivePostIndex),
      kPositivePostIndex},
     {{al, r8, r14, plus, r5, ROR, 12, PostIndex},
      "al r8 r14 plus r5 ROR 12 PostIndex",
      "PositivePostIndex_al_r8_r14_plus_r5_ROR_12_PostIndex",
      ARRAY_SIZE(kPositivePostIndex),
      kPositivePostIndex},
     {{al, r11, r7, plus, r5, LSL, 3, PostIndex},
      "al r11 r7 plus r5 LSL 3 PostIndex",
      "PositivePostIndex_al_r11_r7_plus_r5_LSL_3_PostIndex",
      ARRAY_SIZE(kPositivePostIndex),
      kPositivePostIndex},
     {{al, r14, r5, plus, r8, ROR, 16, PostIndex},
      "al r14 r5 plus r8 ROR 16 PostIndex",
      "PositivePostIndex_al_r14_r5_plus_r8_ROR_16_PostIndex",
      ARRAY_SIZE(kPositivePostIndex),
      kPositivePostIndex},
     {{al, r5, r7, plus, r12, ROR, 3, PostIndex},
      "al r5 r7 plus r12 ROR 3 PostIndex",
      "PositivePostIndex_al_r5_r7_plus_r12_ROR_3_PostIndex",
      ARRAY_SIZE(kPositivePostIndex),
      kPositivePostIndex},
     {{al, r8, r9, plus, r11, LSL, 15, PostIndex},
      "al r8 r9 plus r11 LSL 15 PostIndex",
      "PositivePostIndex_al_r8_r9_plus_r11_LSL_15_PostIndex",
      ARRAY_SIZE(kPositivePostIndex),
      kPositivePostIndex},
     {{al, r4, r12, plus, r3, LSL, 5, PostIndex},
      "al r4 r12 plus r3 LSL 5 PostIndex",
      "PositivePostIndex_al_r4_r12_plus_r3_LSL_5_PostIndex",
      ARRAY_SIZE(kPositivePostIndex),
      kPositivePostIndex},
     {{al, r8, r1, plus, r2, ROR, 5, PostIndex},
      "al r8 r1 plus r2 ROR 5 PostIndex",
      "PositivePostIndex_al_r8_r1_plus_r2_ROR_5_PostIndex",
      ARRAY_SIZE(kPositivePostIndex),
      kPositivePostIndex},
     {{al, r11, r7, plus, r0, LSL, 15, PostIndex},
      "al r11 r7 plus r0 LSL 15 PostIndex",
      "PositivePostIndex_al_r11_r7_plus_r0_LSL_15_PostIndex",
      ARRAY_SIZE(kPositivePostIndex),
      kPositivePostIndex},
     {{al, r6, r1, plus, r5, ROR, 6, PostIndex},
      "al r6 r1 plus r5 ROR 6 PostIndex",
      "PositivePostIndex_al_r6_r1_plus_r5_ROR_6_PostIndex",
      ARRAY_SIZE(kPositivePostIndex),
      kPositivePostIndex},
     {{al, r3, r11, plus, r4, ROR, 28, PostIndex},
      "al r3 r11 plus r4 ROR 28 PostIndex",
      "PositivePostIndex_al_r3_r11_plus_r4_ROR_28_PostIndex",
      ARRAY_SIZE(kPositivePostIndex),
      kPositivePostIndex},
     {{al, r4, r12, plus, r0, ROR, 18, PostIndex},
      "al r4 r12 plus r0 ROR 18 PostIndex",
      "PositivePostIndex_al_r4_r12_plus_r0_ROR_18_PostIndex",
      ARRAY_SIZE(kPositivePostIndex),
      kPositivePostIndex},
     {{al, r0, r4, plus, r7, LSL, 7, PostIndex},
      "al r0 r4 plus r7 LSL 7 PostIndex",
      "PositivePostIndex_al_r0_r4_plus_r7_LSL_7_PostIndex",
      ARRAY_SIZE(kPositivePostIndex),
      kPositivePostIndex},
     {{al, r9, r2, plus, r6, LSL, 21, PostIndex},
      "al r9 r2 plus r6 LSL 21 PostIndex",
      "PositivePostIndex_al_r9_r2_plus_r6_LSL_21_PostIndex",
      ARRAY_SIZE(kPositivePostIndex),
      kPositivePostIndex},
     {{al, r3, r7, plus, r9, ROR, 9, PostIndex},
      "al r3 r7 plus r9 ROR 9 PostIndex",
      "PositivePostIndex_al_r3_r7_plus_r9_ROR_9_PostIndex",
      ARRAY_SIZE(kPositivePostIndex),
      kPositivePostIndex},
     {{al, r14, r3, plus, r8, ROR, 11, PostIndex},
      "al r14 r3 plus r8 ROR 11 PostIndex",
      "PositivePostIndex_al_r14_r3_plus_r8_ROR_11_PostIndex",
      ARRAY_SIZE(kPositivePostIndex),
      kPositivePostIndex},
     {{al, r4, r12, plus, r10, LSL, 22, PostIndex},
      "al r4 r12 plus r10 LSL 22 PostIndex",
      "PositivePostIndex_al_r4_r12_plus_r10_LSL_22_PostIndex",
      ARRAY_SIZE(kPositivePostIndex),
      kPositivePostIndex},
     {{al, r7, r14, plus, r12, ROR, 21, PostIndex},
      "al r7 r14 plus r12 ROR 21 PostIndex",
      "PositivePostIndex_al_r7_r14_plus_r12_ROR_21_PostIndex",
      ARRAY_SIZE(kPositivePostIndex),
      kPositivePostIndex},
     {{al, r5, r9, plus, r0, ROR, 2, PostIndex},
      "al r5 r9 plus r0 ROR 2 PostIndex",
      "PositivePostIndex_al_r5_r9_plus_r0_ROR_2_PostIndex",
      ARRAY_SIZE(kPositivePostIndex),
      kPositivePostIndex},
     {{al, r7, r6, plus, r9, ROR, 1, PostIndex},
      "al r7 r6 plus r9 ROR 1 PostIndex",
      "PositivePostIndex_al_r7_r6_plus_r9_ROR_1_PostIndex",
      ARRAY_SIZE(kPositivePostIndex),
      kPositivePostIndex},
     {{al, r7, r12, plus, r10, ROR, 18, PostIndex},
      "al r7 r12 plus r10 ROR 18 PostIndex",
      "PositivePostIndex_al_r7_r12_plus_r10_ROR_18_PostIndex",
      ARRAY_SIZE(kPositivePostIndex),
      kPositivePostIndex},
     {{al, r1, r0, plus, r6, ROR, 18, PostIndex},
      "al r1 r0 plus r6 ROR 18 PostIndex",
      "PositivePostIndex_al_r1_r0_plus_r6_ROR_18_PostIndex",
      ARRAY_SIZE(kPositivePostIndex),
      kPositivePostIndex},
     {{al, r12, r3, plus, r14, ROR, 17, PostIndex},
      "al r12 r3 plus r14 ROR 17 PostIndex",
      "PositivePostIndex_al_r12_r3_plus_r14_ROR_17_PostIndex",
      ARRAY_SIZE(kPositivePostIndex),
      kPositivePostIndex},
     {{al, r11, r5, plus, r0, ROR, 18, PostIndex},
      "al r11 r5 plus r0 ROR 18 PostIndex",
      "PositivePostIndex_al_r11_r5_plus_r0_ROR_18_PostIndex",
      ARRAY_SIZE(kPositivePostIndex),
      kPositivePostIndex},
     {{al, r11, r4, plus, r5, ROR, 14, PostIndex},
      "al r11 r4 plus r5 ROR 14 PostIndex",
      "PositivePostIndex_al_r11_r4_plus_r5_ROR_14_PostIndex",
      ARRAY_SIZE(kPositivePostIndex),
      kPositivePostIndex},
     {{al, r6, r4, plus, r9, LSL, 4, PostIndex},
      "al r6 r4 plus r9 LSL 4 PostIndex",
      "PositivePostIndex_al_r6_r4_plus_r9_LSL_4_PostIndex",
      ARRAY_SIZE(kPositivePostIndex),
      kPositivePostIndex},
     {{al, r0, r1, plus, r12, ROR, 26, PostIndex},
      "al r0 r1 plus r12 ROR 26 PostIndex",
      "PositivePostIndex_al_r0_r1_plus_r12_ROR_26_PostIndex",
      ARRAY_SIZE(kPositivePostIndex),
      kPositivePostIndex},
     {{al, r2, r8, plus, r12, LSL, 23, PostIndex},
      "al r2 r8 plus r12 LSL 23 PostIndex",
      "PositivePostIndex_al_r2_r8_plus_r12_LSL_23_PostIndex",
      ARRAY_SIZE(kPositivePostIndex),
      kPositivePostIndex},
     {{al, r1, r4, plus, r10, ROR, 22, PostIndex},
      "al r1 r4 plus r10 ROR 22 PostIndex",
      "PositivePostIndex_al_r1_r4_plus_r10_ROR_22_PostIndex",
      ARRAY_SIZE(kPositivePostIndex),
      kPositivePostIndex},
     {{al, r0, r2, plus, r6, ROR, 24, PostIndex},
      "al r0 r2 plus r6 ROR 24 PostIndex",
      "PositivePostIndex_al_r0_r2_plus_r6_ROR_24_PostIndex",
      ARRAY_SIZE(kPositivePostIndex),
      kPositivePostIndex},
     {{al, r2, r12, plus, r3, ROR, 1, PostIndex},
      "al r2 r12 plus r3 ROR 1 PostIndex",
      "PositivePostIndex_al_r2_r12_plus_r3_ROR_1_PostIndex",
      ARRAY_SIZE(kPositivePostIndex),
      kPositivePostIndex},
     {{al, r14, r5, plus, r7, ROR, 6, PostIndex},
      "al r14 r5 plus r7 ROR 6 PostIndex",
      "PositivePostIndex_al_r14_r5_plus_r7_ROR_6_PostIndex",
      ARRAY_SIZE(kPositivePostIndex),
      kPositivePostIndex},
     {{al, r12, r6, plus, r3, LSL, 14, PostIndex},
      "al r12 r6 plus r3 LSL 14 PostIndex",
      "PositivePostIndex_al_r12_r6_plus_r3_LSL_14_PostIndex",
      ARRAY_SIZE(kPositivePostIndex),
      kPositivePostIndex},
     {{al, r1, r11, plus, r7, ROR, 18, PostIndex},
      "al r1 r11 plus r7 ROR 18 PostIndex",
      "PositivePostIndex_al_r1_r11_plus_r7_ROR_18_PostIndex",
      ARRAY_SIZE(kPositivePostIndex),
      kPositivePostIndex},
     {{al, r5, r8, plus, r3, LSL, 18, PostIndex},
      "al r5 r8 plus r3 LSL 18 PostIndex",
      "PositivePostIndex_al_r5_r8_plus_r3_LSL_18_PostIndex",
      ARRAY_SIZE(kPositivePostIndex),
      kPositivePostIndex},
     {{al, r8, r12, plus, r0, ROR, 26, PostIndex},
      "al r8 r12 plus r0 ROR 26 PostIndex",
      "PositivePostIndex_al_r8_r12_plus_r0_ROR_26_PostIndex",
      ARRAY_SIZE(kPositivePostIndex),
      kPositivePostIndex},
     {{al, r14, r6, plus, r11, LSL, 22, PostIndex},
      "al r14 r6 plus r11 LSL 22 PostIndex",
      "PositivePostIndex_al_r14_r6_plus_r11_LSL_22_PostIndex",
      ARRAY_SIZE(kPositivePostIndex),
      kPositivePostIndex},
     {{al, r7, r3, plus, r11, LSL, 15, PostIndex},
      "al r7 r3 plus r11 LSL 15 PostIndex",
      "PositivePostIndex_al_r7_r3_plus_r11_LSL_15_PostIndex",
      ARRAY_SIZE(kPositivePostIndex),
      kPositivePostIndex},
     {{al, r0, r8, plus, r4, LSL, 28, PostIndex},
      "al r0 r8 plus r4 LSL 28 PostIndex",
      "PositivePostIndex_al_r0_r8_plus_r4_LSL_28_PostIndex",
      ARRAY_SIZE(kPositivePostIndex),
      kPositivePostIndex},
     {{al, r7, r8, plus, r4, LSL, 28, PostIndex},
      "al r7 r8 plus r4 LSL 28 PostIndex",
      "PositivePostIndex_al_r7_r8_plus_r4_LSL_28_PostIndex",
      ARRAY_SIZE(kPositivePostIndex),
      kPositivePostIndex},
     {{al, r5, r4, plus, r14, LSL, 17, PostIndex},
      "al r5 r4 plus r14 LSL 17 PostIndex",
      "PositivePostIndex_al_r5_r4_plus_r14_LSL_17_PostIndex",
      ARRAY_SIZE(kPositivePostIndex),
      kPositivePostIndex},
     {{al, r2, r8, plus, r3, LSL, 1, PostIndex},
      "al r2 r8 plus r3 LSL 1 PostIndex",
      "PositivePostIndex_al_r2_r8_plus_r3_LSL_1_PostIndex",
      ARRAY_SIZE(kPositivePostIndex),
      kPositivePostIndex},
     {{al, r9, r3, plus, r4, ROR, 5, PostIndex},
      "al r9 r3 plus r4 ROR 5 PostIndex",
      "PositivePostIndex_al_r9_r3_plus_r4_ROR_5_PostIndex",
      ARRAY_SIZE(kPositivePostIndex),
      kPositivePostIndex},
     {{al, r5, r11, plus, r3, ROR, 26, PostIndex},
      "al r5 r11 plus r3 ROR 26 PostIndex",
      "PositivePostIndex_al_r5_r11_plus_r3_ROR_26_PostIndex",
      ARRAY_SIZE(kPositivePostIndex),
      kPositivePostIndex},
     {{al, r3, r6, plus, r11, ROR, 9, PostIndex},
      "al r3 r6 plus r11 ROR 9 PostIndex",
      "PositivePostIndex_al_r3_r6_plus_r11_ROR_9_PostIndex",
      ARRAY_SIZE(kPositivePostIndex),
      kPositivePostIndex},
     {{al, r3, r6, plus, r9, ROR, 24, PostIndex},
      "al r3 r6 plus r9 ROR 24 PostIndex",
      "PositivePostIndex_al_r3_r6_plus_r9_ROR_24_PostIndex",
      ARRAY_SIZE(kPositivePostIndex),
      kPositivePostIndex},
     {{al, r7, r4, plus, r11, LSL, 1, PostIndex},
      "al r7 r4 plus r11 LSL 1 PostIndex",
      "PositivePostIndex_al_r7_r4_plus_r11_LSL_1_PostIndex",
      ARRAY_SIZE(kPositivePostIndex),
      kPositivePostIndex},
     {{al, r2, r11, plus, r8, LSL, 17, PostIndex},
      "al r2 r11 plus r8 LSL 17 PostIndex",
      "PositivePostIndex_al_r2_r11_plus_r8_LSL_17_PostIndex",
      ARRAY_SIZE(kPositivePostIndex),
      kPositivePostIndex},
     {{al, r6, r10, plus, r7, ROR, 26, PostIndex},
      "al r6 r10 plus r7 ROR 26 PostIndex",
      "PositivePostIndex_al_r6_r10_plus_r7_ROR_26_PostIndex",
      ARRAY_SIZE(kPositivePostIndex),
      kPositivePostIndex},
     {{al, r4, r0, plus, r11, ROR, 5, PostIndex},
      "al r4 r0 plus r11 ROR 5 PostIndex",
      "PositivePostIndex_al_r4_r0_plus_r11_ROR_5_PostIndex",
      ARRAY_SIZE(kPositivePostIndex),
      kPositivePostIndex},
     {{al, r1, r10, plus, r7, ROR, 26, PostIndex},
      "al r1 r10 plus r7 ROR 26 PostIndex",
      "PositivePostIndex_al_r1_r10_plus_r7_ROR_26_PostIndex",
      ARRAY_SIZE(kPositivePostIndex),
      kPositivePostIndex},
     {{al, r9, r5, plus, r12, LSL, 20, PostIndex},
      "al r9 r5 plus r12 LSL 20 PostIndex",
      "PositivePostIndex_al_r9_r5_plus_r12_LSL_20_PostIndex",
      ARRAY_SIZE(kPositivePostIndex),
      kPositivePostIndex},
     {{al, r8, r12, plus, r10, ROR, 28, PostIndex},
      "al r8 r12 plus r10 ROR 28 PostIndex",
      "PositivePostIndex_al_r8_r12_plus_r10_ROR_28_PostIndex",
      ARRAY_SIZE(kPositivePostIndex),
      kPositivePostIndex},
     {{al, r4, r8, plus, r0, LSL, 14, PostIndex},
      "al r4 r8 plus r0 LSL 14 PostIndex",
      "PositivePostIndex_al_r4_r8_plus_r0_LSL_14_PostIndex",
      ARRAY_SIZE(kPositivePostIndex),
      kPositivePostIndex},
     {{al, r14, r12, plus, r8, ROR, 2, PostIndex},
      "al r14 r12 plus r8 ROR 2 PostIndex",
      "PositivePostIndex_al_r14_r12_plus_r8_ROR_2_PostIndex",
      ARRAY_SIZE(kPositivePostIndex),
      kPositivePostIndex},
     {{al, r12, r7, plus, r0, LSL, 17, PostIndex},
      "al r12 r7 plus r0 LSL 17 PostIndex",
      "PositivePostIndex_al_r12_r7_plus_r0_LSL_17_PostIndex",
      ARRAY_SIZE(kPositivePostIndex),
      kPositivePostIndex},
     {{al, r1, r6, plus, r14, ROR, 19, PostIndex},
      "al r1 r6 plus r14 ROR 19 PostIndex",
      "PositivePostIndex_al_r1_r6_plus_r14_ROR_19_PostIndex",
      ARRAY_SIZE(kPositivePostIndex),
      kPositivePostIndex},
     {{al, r9, r11, plus, r6, LSL, 10, PostIndex},
      "al r9 r11 plus r6 LSL 10 PostIndex",
      "PositivePostIndex_al_r9_r11_plus_r6_LSL_10_PostIndex",
      ARRAY_SIZE(kPositivePostIndex),
      kPositivePostIndex},
     {{al, r0, r2, plus, r12, ROR, 12, PostIndex},
      "al r0 r2 plus r12 ROR 12 PostIndex",
      "PositivePostIndex_al_r0_r2_plus_r12_ROR_12_PostIndex",
      ARRAY_SIZE(kPositivePostIndex),
      kPositivePostIndex},
     {{al, r9, r2, plus, r12, LSL, 31, PostIndex},
      "al r9 r2 plus r12 LSL 31 PostIndex",
      "PositivePostIndex_al_r9_r2_plus_r12_LSL_31_PostIndex",
      ARRAY_SIZE(kPositivePostIndex),
      kPositivePostIndex},
     {{al, r10, r4, plus, r7, LSL, 31, PostIndex},
      "al r10 r4 plus r7 LSL 31 PostIndex",
      "PositivePostIndex_al_r10_r4_plus_r7_LSL_31_PostIndex",
      ARRAY_SIZE(kPositivePostIndex),
      kPositivePostIndex},
     {{al, r3, r7, plus, r5, ROR, 29, PostIndex},
      "al r3 r7 plus r5 ROR 29 PostIndex",
      "PositivePostIndex_al_r3_r7_plus_r5_ROR_29_PostIndex",
      ARRAY_SIZE(kPositivePostIndex),
      kPositivePostIndex},
     {{al, r1, r3, plus, r8, ROR, 12, PostIndex},
      "al r1 r3 plus r8 ROR 12 PostIndex",
      "PositivePostIndex_al_r1_r3_plus_r8_ROR_12_PostIndex",
      ARRAY_SIZE(kPositivePostIndex),
      kPositivePostIndex},
     {{al, r9, r11, plus, r3, ROR, 23, PostIndex},
      "al r9 r11 plus r3 ROR 23 PostIndex",
      "PositivePostIndex_al_r9_r11_plus_r3_ROR_23_PostIndex",
      ARRAY_SIZE(kPositivePostIndex),
      kPositivePostIndex},
     {{al, r11, r3, plus, r8, LSL, 20, PostIndex},
      "al r11 r3 plus r8 LSL 20 PostIndex",
      "PositivePostIndex_al_r11_r3_plus_r8_LSL_20_PostIndex",
      ARRAY_SIZE(kPositivePostIndex),
      kPositivePostIndex},
     {{al, r11, r2, plus, r10, LSL, 17, PostIndex},
      "al r11 r2 plus r10 LSL 17 PostIndex",
      "PositivePostIndex_al_r11_r2_plus_r10_LSL_17_PostIndex",
      ARRAY_SIZE(kPositivePostIndex),
      kPositivePostIndex},
     {{al, r2, r3, plus, r7, LSL, 5, PostIndex},
      "al r2 r3 plus r7 LSL 5 PostIndex",
      "PositivePostIndex_al_r2_r3_plus_r7_LSL_5_PostIndex",
      ARRAY_SIZE(kPositivePostIndex),
      kPositivePostIndex},
     {{al, r14, r2, plus, r12, ROR, 26, PostIndex},
      "al r14 r2 plus r12 ROR 26 PostIndex",
      "PositivePostIndex_al_r14_r2_plus_r12_ROR_26_PostIndex",
      ARRAY_SIZE(kPositivePostIndex),
      kPositivePostIndex},
     {{al, r12, r4, plus, r0, ROR, 18, PostIndex},
      "al r12 r4 plus r0 ROR 18 PostIndex",
      "PositivePostIndex_al_r12_r4_plus_r0_ROR_18_PostIndex",
      ARRAY_SIZE(kPositivePostIndex),
      kPositivePostIndex},
     {{al, r4, r8, plus, r14, LSL, 15, PostIndex},
      "al r4 r8 plus r14 LSL 15 PostIndex",
      "PositivePostIndex_al_r4_r8_plus_r14_LSL_15_PostIndex",
      ARRAY_SIZE(kPositivePostIndex),
      kPositivePostIndex},
     {{al, r6, r7, plus, r2, ROR, 25, PostIndex},
      "al r6 r7 plus r2 ROR 25 PostIndex",
      "PositivePostIndex_al_r6_r7_plus_r2_ROR_25_PostIndex",
      ARRAY_SIZE(kPositivePostIndex),
      kPositivePostIndex},
     {{al, r11, r4, minus, r2, ROR, 11, PostIndex},
      "al r11 r4 minus r2 ROR 11 PostIndex",
      "NegativePostIndex_al_r11_r4_minus_r2_ROR_11_PostIndex",
      ARRAY_SIZE(kNegativePostIndex),
      kNegativePostIndex},
     {{al, r5, r11, minus, r12, ROR, 8, PostIndex},
      "al r5 r11 minus r12 ROR 8 PostIndex",
      "NegativePostIndex_al_r5_r11_minus_r12_ROR_8_PostIndex",
      ARRAY_SIZE(kNegativePostIndex),
      kNegativePostIndex},
     {{al, r4, r6, minus, r0, ROR, 26, PostIndex},
      "al r4 r6 minus r0 ROR 26 PostIndex",
      "NegativePostIndex_al_r4_r6_minus_r0_ROR_26_PostIndex",
      ARRAY_SIZE(kNegativePostIndex),
      kNegativePostIndex},
     {{al, r11, r8, minus, r0, LSL, 12, PostIndex},
      "al r11 r8 minus r0 LSL 12 PostIndex",
      "NegativePostIndex_al_r11_r8_minus_r0_LSL_12_PostIndex",
      ARRAY_SIZE(kNegativePostIndex),
      kNegativePostIndex},
     {{al, r2, r7, minus, r3, ROR, 10, PostIndex},
      "al r2 r7 minus r3 ROR 10 PostIndex",
      "NegativePostIndex_al_r2_r7_minus_r3_ROR_10_PostIndex",
      ARRAY_SIZE(kNegativePostIndex),
      kNegativePostIndex},
     {{al, r2, r14, minus, r8, LSL, 19, PostIndex},
      "al r2 r14 minus r8 LSL 19 PostIndex",
      "NegativePostIndex_al_r2_r14_minus_r8_LSL_19_PostIndex",
      ARRAY_SIZE(kNegativePostIndex),
      kNegativePostIndex},
     {{al, r9, r3, minus, r6, ROR, 23, PostIndex},
      "al r9 r3 minus r6 ROR 23 PostIndex",
      "NegativePostIndex_al_r9_r3_minus_r6_ROR_23_PostIndex",
      ARRAY_SIZE(kNegativePostIndex),
      kNegativePostIndex},
     {{al, r6, r5, minus, r14, LSL, 18, PostIndex},
      "al r6 r5 minus r14 LSL 18 PostIndex",
      "NegativePostIndex_al_r6_r5_minus_r14_LSL_18_PostIndex",
      ARRAY_SIZE(kNegativePostIndex),
      kNegativePostIndex},
     {{al, r12, r0, minus, r9, ROR, 13, PostIndex},
      "al r12 r0 minus r9 ROR 13 PostIndex",
      "NegativePostIndex_al_r12_r0_minus_r9_ROR_13_PostIndex",
      ARRAY_SIZE(kNegativePostIndex),
      kNegativePostIndex},
     {{al, r3, r12, minus, r6, LSL, 30, PostIndex},
      "al r3 r12 minus r6 LSL 30 PostIndex",
      "NegativePostIndex_al_r3_r12_minus_r6_LSL_30_PostIndex",
      ARRAY_SIZE(kNegativePostIndex),
      kNegativePostIndex},
     {{al, r5, r9, minus, r3, LSL, 21, PostIndex},
      "al r5 r9 minus r3 LSL 21 PostIndex",
      "NegativePostIndex_al_r5_r9_minus_r3_LSL_21_PostIndex",
      ARRAY_SIZE(kNegativePostIndex),
      kNegativePostIndex},
     {{al, r8, r5, minus, r4, LSL, 28, PostIndex},
      "al r8 r5 minus r4 LSL 28 PostIndex",
      "NegativePostIndex_al_r8_r5_minus_r4_LSL_28_PostIndex",
      ARRAY_SIZE(kNegativePostIndex),
      kNegativePostIndex},
     {{al, r1, r6, minus, r2, ROR, 9, PostIndex},
      "al r1 r6 minus r2 ROR 9 PostIndex",
      "NegativePostIndex_al_r1_r6_minus_r2_ROR_9_PostIndex",
      ARRAY_SIZE(kNegativePostIndex),
      kNegativePostIndex},
     {{al, r14, r6, minus, r2, ROR, 24, PostIndex},
      "al r14 r6 minus r2 ROR 24 PostIndex",
      "NegativePostIndex_al_r14_r6_minus_r2_ROR_24_PostIndex",
      ARRAY_SIZE(kNegativePostIndex),
      kNegativePostIndex},
     {{al, r5, r12, minus, r11, ROR, 14, PostIndex},
      "al r5 r12 minus r11 ROR 14 PostIndex",
      "NegativePostIndex_al_r5_r12_minus_r11_ROR_14_PostIndex",
      ARRAY_SIZE(kNegativePostIndex),
      kNegativePostIndex},
     {{al, r0, r6, minus, r5, ROR, 20, PostIndex},
      "al r0 r6 minus r5 ROR 20 PostIndex",
      "NegativePostIndex_al_r0_r6_minus_r5_ROR_20_PostIndex",
      ARRAY_SIZE(kNegativePostIndex),
      kNegativePostIndex},
     {{al, r8, r3, minus, r7, ROR, 12, PostIndex},
      "al r8 r3 minus r7 ROR 12 PostIndex",
      "NegativePostIndex_al_r8_r3_minus_r7_ROR_12_PostIndex",
      ARRAY_SIZE(kNegativePostIndex),
      kNegativePostIndex},
     {{al, r6, r3, minus, r4, ROR, 16, PostIndex},
      "al r6 r3 minus r4 ROR 16 PostIndex",
      "NegativePostIndex_al_r6_r3_minus_r4_ROR_16_PostIndex",
      ARRAY_SIZE(kNegativePostIndex),
      kNegativePostIndex},
     {{al, r6, r10, minus, r5, ROR, 28, PostIndex},
      "al r6 r10 minus r5 ROR 28 PostIndex",
      "NegativePostIndex_al_r6_r10_minus_r5_ROR_28_PostIndex",
      ARRAY_SIZE(kNegativePostIndex),
      kNegativePostIndex},
     {{al, r0, r4, minus, r6, LSL, 25, PostIndex},
      "al r0 r4 minus r6 LSL 25 PostIndex",
      "NegativePostIndex_al_r0_r4_minus_r6_LSL_25_PostIndex",
      ARRAY_SIZE(kNegativePostIndex),
      kNegativePostIndex},
     {{al, r12, r1, minus, r9, ROR, 27, PostIndex},
      "al r12 r1 minus r9 ROR 27 PostIndex",
      "NegativePostIndex_al_r12_r1_minus_r9_ROR_27_PostIndex",
      ARRAY_SIZE(kNegativePostIndex),
      kNegativePostIndex},
     {{al, r12, r3, minus, r14, LSL, 30, PostIndex},
      "al r12 r3 minus r14 LSL 30 PostIndex",
      "NegativePostIndex_al_r12_r3_minus_r14_LSL_30_PostIndex",
      ARRAY_SIZE(kNegativePostIndex),
      kNegativePostIndex},
     {{al, r4, r0, minus, r2, LSL, 9, PostIndex},
      "al r4 r0 minus r2 LSL 9 PostIndex",
      "NegativePostIndex_al_r4_r0_minus_r2_LSL_9_PostIndex",
      ARRAY_SIZE(kNegativePostIndex),
      kNegativePostIndex},
     {{al, r12, r0, minus, r2, LSL, 20, PostIndex},
      "al r12 r0 minus r2 LSL 20 PostIndex",
      "NegativePostIndex_al_r12_r0_minus_r2_LSL_20_PostIndex",
      ARRAY_SIZE(kNegativePostIndex),
      kNegativePostIndex},
     {{al, r7, r3, minus, r5, ROR, 17, PostIndex},
      "al r7 r3 minus r5 ROR 17 PostIndex",
      "NegativePostIndex_al_r7_r3_minus_r5_ROR_17_PostIndex",
      ARRAY_SIZE(kNegativePostIndex),
      kNegativePostIndex},
     {{al, r11, r14, minus, r12, LSL, 13, PostIndex},
      "al r11 r14 minus r12 LSL 13 PostIndex",
      "NegativePostIndex_al_r11_r14_minus_r12_LSL_13_PostIndex",
      ARRAY_SIZE(kNegativePostIndex),
      kNegativePostIndex},
     {{al, r1, r8, minus, r10, LSL, 6, PostIndex},
      "al r1 r8 minus r10 LSL 6 PostIndex",
      "NegativePostIndex_al_r1_r8_minus_r10_LSL_6_PostIndex",
      ARRAY_SIZE(kNegativePostIndex),
      kNegativePostIndex},
     {{al, r3, r5, minus, r0, ROR, 20, PostIndex},
      "al r3 r5 minus r0 ROR 20 PostIndex",
      "NegativePostIndex_al_r3_r5_minus_r0_ROR_20_PostIndex",
      ARRAY_SIZE(kNegativePostIndex),
      kNegativePostIndex},
     {{al, r0, r10, minus, r7, LSL, 5, PostIndex},
      "al r0 r10 minus r7 LSL 5 PostIndex",
      "NegativePostIndex_al_r0_r10_minus_r7_LSL_5_PostIndex",
      ARRAY_SIZE(kNegativePostIndex),
      kNegativePostIndex},
     {{al, r11, r4, minus, r3, LSL, 21, PostIndex},
      "al r11 r4 minus r3 LSL 21 PostIndex",
      "NegativePostIndex_al_r11_r4_minus_r3_LSL_21_PostIndex",
      ARRAY_SIZE(kNegativePostIndex),
      kNegativePostIndex},
     {{al, r5, r0, minus, r4, ROR, 2, PostIndex},
      "al r5 r0 minus r4 ROR 2 PostIndex",
      "NegativePostIndex_al_r5_r0_minus_r4_ROR_2_PostIndex",
      ARRAY_SIZE(kNegativePostIndex),
      kNegativePostIndex},
     {{al, r2, r5, minus, r7, LSL, 4, PostIndex},
      "al r2 r5 minus r7 LSL 4 PostIndex",
      "NegativePostIndex_al_r2_r5_minus_r7_LSL_4_PostIndex",
      ARRAY_SIZE(kNegativePostIndex),
      kNegativePostIndex},
     {{al, r4, r8, minus, r2, LSL, 12, PostIndex},
      "al r4 r8 minus r2 LSL 12 PostIndex",
      "NegativePostIndex_al_r4_r8_minus_r2_LSL_12_PostIndex",
      ARRAY_SIZE(kNegativePostIndex),
      kNegativePostIndex},
     {{al, r4, r2, minus, r10, LSL, 12, PostIndex},
      "al r4 r2 minus r10 LSL 12 PostIndex",
      "NegativePostIndex_al_r4_r2_minus_r10_LSL_12_PostIndex",
      ARRAY_SIZE(kNegativePostIndex),
      kNegativePostIndex},
     {{al, r2, r1, minus, r4, LSL, 8, PostIndex},
      "al r2 r1 minus r4 LSL 8 PostIndex",
      "NegativePostIndex_al_r2_r1_minus_r4_LSL_8_PostIndex",
      ARRAY_SIZE(kNegativePostIndex),
      kNegativePostIndex},
     {{al, r1, r12, minus, r5, LSL, 18, PostIndex},
      "al r1 r12 minus r5 LSL 18 PostIndex",
      "NegativePostIndex_al_r1_r12_minus_r5_LSL_18_PostIndex",
      ARRAY_SIZE(kNegativePostIndex),
      kNegativePostIndex},
     {{al, r5, r12, minus, r3, LSL, 30, PostIndex},
      "al r5 r12 minus r3 LSL 30 PostIndex",
      "NegativePostIndex_al_r5_r12_minus_r3_LSL_30_PostIndex",
      ARRAY_SIZE(kNegativePostIndex),
      kNegativePostIndex},
     {{al, r1, r8, minus, r12, LSL, 27, PostIndex},
      "al r1 r8 minus r12 LSL 27 PostIndex",
      "NegativePostIndex_al_r1_r8_minus_r12_LSL_27_PostIndex",
      ARRAY_SIZE(kNegativePostIndex),
      kNegativePostIndex},
     {{al, r12, r8, minus, r5, LSL, 17, PostIndex},
      "al r12 r8 minus r5 LSL 17 PostIndex",
      "NegativePostIndex_al_r12_r8_minus_r5_LSL_17_PostIndex",
      ARRAY_SIZE(kNegativePostIndex),
      kNegativePostIndex},
     {{al, r10, r8, minus, r9, LSL, 22, PostIndex},
      "al r10 r8 minus r9 LSL 22 PostIndex",
      "NegativePostIndex_al_r10_r8_minus_r9_LSL_22_PostIndex",
      ARRAY_SIZE(kNegativePostIndex),
      kNegativePostIndex},
     {{al, r4, r1, minus, r2, LSL, 5, PostIndex},
      "al r4 r1 minus r2 LSL 5 PostIndex",
      "NegativePostIndex_al_r4_r1_minus_r2_LSL_5_PostIndex",
      ARRAY_SIZE(kNegativePostIndex),
      kNegativePostIndex},
     {{al, r6, r1, minus, r9, LSL, 21, PostIndex},
      "al r6 r1 minus r9 LSL 21 PostIndex",
      "NegativePostIndex_al_r6_r1_minus_r9_LSL_21_PostIndex",
      ARRAY_SIZE(kNegativePostIndex),
      kNegativePostIndex},
     {{al, r3, r1, minus, r12, LSL, 29, PostIndex},
      "al r3 r1 minus r12 LSL 29 PostIndex",
      "NegativePostIndex_al_r3_r1_minus_r12_LSL_29_PostIndex",
      ARRAY_SIZE(kNegativePostIndex),
      kNegativePostIndex},
     {{al, r0, r4, minus, r9, ROR, 19, PostIndex},
      "al r0 r4 minus r9 ROR 19 PostIndex",
      "NegativePostIndex_al_r0_r4_minus_r9_ROR_19_PostIndex",
      ARRAY_SIZE(kNegativePostIndex),
      kNegativePostIndex},
     {{al, r7, r14, minus, r1, ROR, 11, PostIndex},
      "al r7 r14 minus r1 ROR 11 PostIndex",
      "NegativePostIndex_al_r7_r14_minus_r1_ROR_11_PostIndex",
      ARRAY_SIZE(kNegativePostIndex),
      kNegativePostIndex},
     {{al, r4, r10, minus, r12, ROR, 1, PostIndex},
      "al r4 r10 minus r12 ROR 1 PostIndex",
      "NegativePostIndex_al_r4_r10_minus_r12_ROR_1_PostIndex",
      ARRAY_SIZE(kNegativePostIndex),
      kNegativePostIndex},
     {{al, r0, r11, minus, r5, LSL, 25, PostIndex},
      "al r0 r11 minus r5 LSL 25 PostIndex",
      "NegativePostIndex_al_r0_r11_minus_r5_LSL_25_PostIndex",
      ARRAY_SIZE(kNegativePostIndex),
      kNegativePostIndex},
     {{al, r6, r4, minus, r9, ROR, 5, PostIndex},
      "al r6 r4 minus r9 ROR 5 PostIndex",
      "NegativePostIndex_al_r6_r4_minus_r9_ROR_5_PostIndex",
      ARRAY_SIZE(kNegativePostIndex),
      kNegativePostIndex},
     {{al, r9, r6, minus, r4, ROR, 11, PostIndex},
      "al r9 r6 minus r4 ROR 11 PostIndex",
      "NegativePostIndex_al_r9_r6_minus_r4_ROR_11_PostIndex",
      ARRAY_SIZE(kNegativePostIndex),
      kNegativePostIndex},
     {{al, r6, r12, minus, r4, LSL, 25, PostIndex},
      "al r6 r12 minus r4 LSL 25 PostIndex",
      "NegativePostIndex_al_r6_r12_minus_r4_LSL_25_PostIndex",
      ARRAY_SIZE(kNegativePostIndex),
      kNegativePostIndex},
     {{al, r7, r12, minus, r0, ROR, 27, PostIndex},
      "al r7 r12 minus r0 ROR 27 PostIndex",
      "NegativePostIndex_al_r7_r12_minus_r0_ROR_27_PostIndex",
      ARRAY_SIZE(kNegativePostIndex),
      kNegativePostIndex},
     {{al, r4, r14, minus, r11, LSL, 24, PostIndex},
      "al r4 r14 minus r11 LSL 24 PostIndex",
      "NegativePostIndex_al_r4_r14_minus_r11_LSL_24_PostIndex",
      ARRAY_SIZE(kNegativePostIndex),
      kNegativePostIndex},
     {{al, r7, r8, minus, r12, ROR, 4, PostIndex},
      "al r7 r8 minus r12 ROR 4 PostIndex",
      "NegativePostIndex_al_r7_r8_minus_r12_ROR_4_PostIndex",
      ARRAY_SIZE(kNegativePostIndex),
      kNegativePostIndex},
     {{al, r2, r10, minus, r6, ROR, 1, PostIndex},
      "al r2 r10 minus r6 ROR 1 PostIndex",
      "NegativePostIndex_al_r2_r10_minus_r6_ROR_1_PostIndex",
      ARRAY_SIZE(kNegativePostIndex),
      kNegativePostIndex},
     {{al, r14, r8, minus, r7, LSL, 4, PostIndex},
      "al r14 r8 minus r7 LSL 4 PostIndex",
      "NegativePostIndex_al_r14_r8_minus_r7_LSL_4_PostIndex",
      ARRAY_SIZE(kNegativePostIndex),
      kNegativePostIndex},
     {{al, r12, r6, minus, r14, ROR, 8, PostIndex},
      "al r12 r6 minus r14 ROR 8 PostIndex",
      "NegativePostIndex_al_r12_r6_minus_r14_ROR_8_PostIndex",
      ARRAY_SIZE(kNegativePostIndex),
      kNegativePostIndex},
     {{al, r7, r8, minus, r5, ROR, 27, PostIndex},
      "al r7 r8 minus r5 ROR 27 PostIndex",
      "NegativePostIndex_al_r7_r8_minus_r5_ROR_27_PostIndex",
      ARRAY_SIZE(kNegativePostIndex),
      kNegativePostIndex},
     {{al, r3, r2, minus, r10, LSL, 8, PostIndex},
      "al r3 r2 minus r10 LSL 8 PostIndex",
      "NegativePostIndex_al_r3_r2_minus_r10_LSL_8_PostIndex",
      ARRAY_SIZE(kNegativePostIndex),
      kNegativePostIndex},
     {{al, r4, r9, minus, r3, ROR, 11, PostIndex},
      "al r4 r9 minus r3 ROR 11 PostIndex",
      "NegativePostIndex_al_r4_r9_minus_r3_ROR_11_PostIndex",
      ARRAY_SIZE(kNegativePostIndex),
      kNegativePostIndex},
     {{al, r11, r1, minus, r4, LSL, 9, PostIndex},
      "al r11 r1 minus r4 LSL 9 PostIndex",
      "NegativePostIndex_al_r11_r1_minus_r4_LSL_9_PostIndex",
      ARRAY_SIZE(kNegativePostIndex),
      kNegativePostIndex},
     {{al, r8, r5, minus, r7, ROR, 17, PostIndex},
      "al r8 r5 minus r7 ROR 17 PostIndex",
      "NegativePostIndex_al_r8_r5_minus_r7_ROR_17_PostIndex",
      ARRAY_SIZE(kNegativePostIndex),
      kNegativePostIndex},
     {{al, r6, r5, minus, r8, LSL, 18, PostIndex},
      "al r6 r5 minus r8 LSL 18 PostIndex",
      "NegativePostIndex_al_r6_r5_minus_r8_LSL_18_PostIndex",
      ARRAY_SIZE(kNegativePostIndex),
      kNegativePostIndex},
     {{al, r4, r7, minus, r6, LSL, 16, PostIndex},
      "al r4 r7 minus r6 LSL 16 PostIndex",
      "NegativePostIndex_al_r4_r7_minus_r6_LSL_16_PostIndex",
      ARRAY_SIZE(kNegativePostIndex),
      kNegativePostIndex},
     {{al, r8, r12, minus, r10, LSL, 29, PostIndex},
      "al r8 r12 minus r10 LSL 29 PostIndex",
      "NegativePostIndex_al_r8_r12_minus_r10_LSL_29_PostIndex",
      ARRAY_SIZE(kNegativePostIndex),
      kNegativePostIndex},
     {{al, r14, r7, minus, r2, ROR, 18, PostIndex},
      "al r14 r7 minus r2 ROR 18 PostIndex",
      "NegativePostIndex_al_r14_r7_minus_r2_ROR_18_PostIndex",
      ARRAY_SIZE(kNegativePostIndex),
      kNegativePostIndex},
     {{al, r14, r3, minus, r9, ROR, 8, PostIndex},
      "al r14 r3 minus r9 ROR 8 PostIndex",
      "NegativePostIndex_al_r14_r3_minus_r9_ROR_8_PostIndex",
      ARRAY_SIZE(kNegativePostIndex),
      kNegativePostIndex},
     {{al, r1, r14, minus, r9, LSL, 5, PostIndex},
      "al r1 r14 minus r9 LSL 5 PostIndex",
      "NegativePostIndex_al_r1_r14_minus_r9_LSL_5_PostIndex",
      ARRAY_SIZE(kNegativePostIndex),
      kNegativePostIndex},
     {{al, r3, r2, minus, r10, LSL, 23, PostIndex},
      "al r3 r2 minus r10 LSL 23 PostIndex",
      "NegativePostIndex_al_r3_r2_minus_r10_LSL_23_PostIndex",
      ARRAY_SIZE(kNegativePostIndex),
      kNegativePostIndex},
     {{al, r7, r3, minus, r5, ROR, 27, PostIndex},
      "al r7 r3 minus r5 ROR 27 PostIndex",
      "NegativePostIndex_al_r7_r3_minus_r5_ROR_27_PostIndex",
      ARRAY_SIZE(kNegativePostIndex),
      kNegativePostIndex},
     {{al, r11, r14, minus, r6, ROR, 3, PostIndex},
      "al r11 r14 minus r6 ROR 3 PostIndex",
      "NegativePostIndex_al_r11_r14_minus_r6_ROR_3_PostIndex",
      ARRAY_SIZE(kNegativePostIndex),
      kNegativePostIndex},
     {{al, r11, r2, minus, r14, LSL, 19, PostIndex},
      "al r11 r2 minus r14 LSL 19 PostIndex",
      "NegativePostIndex_al_r11_r2_minus_r14_LSL_19_PostIndex",
      ARRAY_SIZE(kNegativePostIndex),
      kNegativePostIndex},
     {{al, r11, r1, minus, r10, LSL, 25, PostIndex},
      "al r11 r1 minus r10 LSL 25 PostIndex",
      "NegativePostIndex_al_r11_r1_minus_r10_LSL_25_PostIndex",
      ARRAY_SIZE(kNegativePostIndex),
      kNegativePostIndex},
     {{al, r14, r7, minus, r4, ROR, 15, PostIndex},
      "al r14 r7 minus r4 ROR 15 PostIndex",
      "NegativePostIndex_al_r14_r7_minus_r4_ROR_15_PostIndex",
      ARRAY_SIZE(kNegativePostIndex),
      kNegativePostIndex},
     {{al, r12, r14, minus, r7, ROR, 24, PostIndex},
      "al r12 r14 minus r7 ROR 24 PostIndex",
      "NegativePostIndex_al_r12_r14_minus_r7_ROR_24_PostIndex",
      ARRAY_SIZE(kNegativePostIndex),
      kNegativePostIndex},
     {{al, r6, r10, minus, r5, ROR, 8, PostIndex},
      "al r6 r10 minus r5 ROR 8 PostIndex",
      "NegativePostIndex_al_r6_r10_minus_r5_ROR_8_PostIndex",
      ARRAY_SIZE(kNegativePostIndex),
      kNegativePostIndex},
     {{al, r1, r5, minus, r9, ROR, 3, PostIndex},
      "al r1 r5 minus r9 ROR 3 PostIndex",
      "NegativePostIndex_al_r1_r5_minus_r9_ROR_3_PostIndex",
      ARRAY_SIZE(kNegativePostIndex),
      kNegativePostIndex},
     {{al, r2, r9, minus, r1, LSL, 28, PostIndex},
      "al r2 r9 minus r1 LSL 28 PostIndex",
      "NegativePostIndex_al_r2_r9_minus_r1_LSL_28_PostIndex",
      ARRAY_SIZE(kNegativePostIndex),
      kNegativePostIndex},
     {{al, r9, r4, minus, r0, LSL, 16, PostIndex},
      "al r9 r4 minus r0 LSL 16 PostIndex",
      "NegativePostIndex_al_r9_r4_minus_r0_LSL_16_PostIndex",
      ARRAY_SIZE(kNegativePostIndex),
      kNegativePostIndex},
     {{al, r5, r3, minus, r4, ROR, 21, PostIndex},
      "al r5 r3 minus r4 ROR 21 PostIndex",
      "NegativePostIndex_al_r5_r3_minus_r4_ROR_21_PostIndex",
      ARRAY_SIZE(kNegativePostIndex),
      kNegativePostIndex},
     {{al, r4, r0, minus, r11, LSL, 30, PostIndex},
      "al r4 r0 minus r11 LSL 30 PostIndex",
      "NegativePostIndex_al_r4_r0_minus_r11_LSL_30_PostIndex",
      ARRAY_SIZE(kNegativePostIndex),
      kNegativePostIndex},
     {{al, r4, r3, minus, r12, LSL, 1, PostIndex},
      "al r4 r3 minus r12 LSL 1 PostIndex",
      "NegativePostIndex_al_r4_r3_minus_r12_LSL_1_PostIndex",
      ARRAY_SIZE(kNegativePostIndex),
      kNegativePostIndex},
     {{al, r12, r11, minus, r7, LSL, 6, PostIndex},
      "al r12 r11 minus r7 LSL 6 PostIndex",
      "NegativePostIndex_al_r12_r11_minus_r7_LSL_6_PostIndex",
      ARRAY_SIZE(kNegativePostIndex),
      kNegativePostIndex},
     {{al, r10, r2, minus, r6, ROR, 3, PostIndex},
      "al r10 r2 minus r6 ROR 3 PostIndex",
      "NegativePostIndex_al_r10_r2_minus_r6_ROR_3_PostIndex",
      ARRAY_SIZE(kNegativePostIndex),
      kNegativePostIndex},
     {{al, r5, r12, minus, r14, LSL, 25, PostIndex},
      "al r5 r12 minus r14 LSL 25 PostIndex",
      "NegativePostIndex_al_r5_r12_minus_r14_LSL_25_PostIndex",
      ARRAY_SIZE(kNegativePostIndex),
      kNegativePostIndex},
     {{al, r3, r9, minus, r5, ROR, 20, PostIndex},
      "al r3 r9 minus r5 ROR 20 PostIndex",
      "NegativePostIndex_al_r3_r9_minus_r5_ROR_20_PostIndex",
      ARRAY_SIZE(kNegativePostIndex),
      kNegativePostIndex},
     {{al, r8, r2, minus, r11, LSL, 20, PostIndex},
      "al r8 r2 minus r11 LSL 20 PostIndex",
      "NegativePostIndex_al_r8_r2_minus_r11_LSL_20_PostIndex",
      ARRAY_SIZE(kNegativePostIndex),
      kNegativePostIndex},
     {{al, r7, r1, minus, r12, LSL, 22, PostIndex},
      "al r7 r1 minus r12 LSL 22 PostIndex",
      "NegativePostIndex_al_r7_r1_minus_r12_LSL_22_PostIndex",
      ARRAY_SIZE(kNegativePostIndex),
      kNegativePostIndex},
     {{al, r7, r12, minus, r4, ROR, 21, PostIndex},
      "al r7 r12 minus r4 ROR 21 PostIndex",
      "NegativePostIndex_al_r7_r12_minus_r4_ROR_21_PostIndex",
      ARRAY_SIZE(kNegativePostIndex),
      kNegativePostIndex},
     {{al, r8, r4, minus, r0, LSL, 25, PostIndex},
      "al r8 r4 minus r0 LSL 25 PostIndex",
      "NegativePostIndex_al_r8_r4_minus_r0_LSL_25_PostIndex",
      ARRAY_SIZE(kNegativePostIndex),
      kNegativePostIndex},
     {{al, r2, r10, minus, r6, LSL, 1, PostIndex},
      "al r2 r10 minus r6 LSL 1 PostIndex",
      "NegativePostIndex_al_r2_r10_minus_r6_LSL_1_PostIndex",
      ARRAY_SIZE(kNegativePostIndex),
      kNegativePostIndex},
     {{al, r11, r14, minus, r1, LSL, 9, PostIndex},
      "al r11 r14 minus r1 LSL 9 PostIndex",
      "NegativePostIndex_al_r11_r14_minus_r1_LSL_9_PostIndex",
      ARRAY_SIZE(kNegativePostIndex),
      kNegativePostIndex},
     {{al, r7, r8, minus, r3, ROR, 19, PostIndex},
      "al r7 r8 minus r3 ROR 19 PostIndex",
      "NegativePostIndex_al_r7_r8_minus_r3_ROR_19_PostIndex",
      ARRAY_SIZE(kNegativePostIndex),
      kNegativePostIndex},
     {{al, r7, r4, minus, r3, LSL, 3, PostIndex},
      "al r7 r4 minus r3 LSL 3 PostIndex",
      "NegativePostIndex_al_r7_r4_minus_r3_LSL_3_PostIndex",
      ARRAY_SIZE(kNegativePostIndex),
      kNegativePostIndex},
     {{al, r6, r3, minus, r5, LSL, 5, PostIndex},
      "al r6 r3 minus r5 LSL 5 PostIndex",
      "NegativePostIndex_al_r6_r3_minus_r5_LSL_5_PostIndex",
      ARRAY_SIZE(kNegativePostIndex),
      kNegativePostIndex},
     {{al, r7, r12, minus, r1, ROR, 26, PostIndex},
      "al r7 r12 minus r1 ROR 26 PostIndex",
      "NegativePostIndex_al_r7_r12_minus_r1_ROR_26_PostIndex",
      ARRAY_SIZE(kNegativePostIndex),
      kNegativePostIndex},
     {{al, r1, r14, minus, r3, ROR, 5, PostIndex},
      "al r1 r14 minus r3 ROR 5 PostIndex",
      "NegativePostIndex_al_r1_r14_minus_r3_ROR_5_PostIndex",
      ARRAY_SIZE(kNegativePostIndex),
      kNegativePostIndex},
     {{al, r3, r14, minus, r8, LSL, 10, PostIndex},
      "al r3 r14 minus r8 LSL 10 PostIndex",
      "NegativePostIndex_al_r3_r14_minus_r8_LSL_10_PostIndex",
      ARRAY_SIZE(kNegativePostIndex),
      kNegativePostIndex},
     {{al, r2, r6, minus, r3, ROR, 19, PostIndex},
      "al r2 r6 minus r3 ROR 19 PostIndex",
      "NegativePostIndex_al_r2_r6_minus_r3_ROR_19_PostIndex",
      ARRAY_SIZE(kNegativePostIndex),
      kNegativePostIndex},
     {{al, r3, r5, minus, r6, ROR, 30, PostIndex},
      "al r3 r5 minus r6 ROR 30 PostIndex",
      "NegativePostIndex_al_r3_r5_minus_r6_ROR_30_PostIndex",
      ARRAY_SIZE(kNegativePostIndex),
      kNegativePostIndex},
     {{al, r2, r9, minus, r12, LSL, 24, PostIndex},
      "al r2 r9 minus r12 LSL 24 PostIndex",
      "NegativePostIndex_al_r2_r9_minus_r12_LSL_24_PostIndex",
      ARRAY_SIZE(kNegativePostIndex),
      kNegativePostIndex},
     {{al, r4, r9, plus, r3, LSL, 2, PreIndex},
      "al r4 r9 plus r3 LSL 2 PreIndex",
      "PositivePreIndex_al_r4_r9_plus_r3_LSL_2_PreIndex",
      ARRAY_SIZE(kPositivePreIndex),
      kPositivePreIndex},
     {{al, r1, r9, plus, r10, LSL, 25, PreIndex},
      "al r1 r9 plus r10 LSL 25 PreIndex",
      "PositivePreIndex_al_r1_r9_plus_r10_LSL_25_PreIndex",
      ARRAY_SIZE(kPositivePreIndex),
      kPositivePreIndex},
     {{al, r14, r1, plus, r12, ROR, 24, PreIndex},
      "al r14 r1 plus r12 ROR 24 PreIndex",
      "PositivePreIndex_al_r14_r1_plus_r12_ROR_24_PreIndex",
      ARRAY_SIZE(kPositivePreIndex),
      kPositivePreIndex},
     {{al, r3, r10, plus, r14, LSL, 24, PreIndex},
      "al r3 r10 plus r14 LSL 24 PreIndex",
      "PositivePreIndex_al_r3_r10_plus_r14_LSL_24_PreIndex",
      ARRAY_SIZE(kPositivePreIndex),
      kPositivePreIndex},
     {{al, r10, r5, plus, r0, LSL, 17, PreIndex},
      "al r10 r5 plus r0 LSL 17 PreIndex",
      "PositivePreIndex_al_r10_r5_plus_r0_LSL_17_PreIndex",
      ARRAY_SIZE(kPositivePreIndex),
      kPositivePreIndex},
     {{al, r1, r7, plus, r8, LSL, 20, PreIndex},
      "al r1 r7 plus r8 LSL 20 PreIndex",
      "PositivePreIndex_al_r1_r7_plus_r8_LSL_20_PreIndex",
      ARRAY_SIZE(kPositivePreIndex),
      kPositivePreIndex},
     {{al, r5, r6, plus, r2, LSL, 3, PreIndex},
      "al r5 r6 plus r2 LSL 3 PreIndex",
      "PositivePreIndex_al_r5_r6_plus_r2_LSL_3_PreIndex",
      ARRAY_SIZE(kPositivePreIndex),
      kPositivePreIndex},
     {{al, r4, r6, plus, r2, ROR, 9, PreIndex},
      "al r4 r6 plus r2 ROR 9 PreIndex",
      "PositivePreIndex_al_r4_r6_plus_r2_ROR_9_PreIndex",
      ARRAY_SIZE(kPositivePreIndex),
      kPositivePreIndex},
     {{al, r0, r11, plus, r12, LSL, 7, PreIndex},
      "al r0 r11 plus r12 LSL 7 PreIndex",
      "PositivePreIndex_al_r0_r11_plus_r12_LSL_7_PreIndex",
      ARRAY_SIZE(kPositivePreIndex),
      kPositivePreIndex},
     {{al, r2, r14, plus, r11, ROR, 4, PreIndex},
      "al r2 r14 plus r11 ROR 4 PreIndex",
      "PositivePreIndex_al_r2_r14_plus_r11_ROR_4_PreIndex",
      ARRAY_SIZE(kPositivePreIndex),
      kPositivePreIndex},
     {{al, r8, r6, plus, r1, LSL, 13, PreIndex},
      "al r8 r6 plus r1 LSL 13 PreIndex",
      "PositivePreIndex_al_r8_r6_plus_r1_LSL_13_PreIndex",
      ARRAY_SIZE(kPositivePreIndex),
      kPositivePreIndex},
     {{al, r9, r8, plus, r5, ROR, 5, PreIndex},
      "al r9 r8 plus r5 ROR 5 PreIndex",
      "PositivePreIndex_al_r9_r8_plus_r5_ROR_5_PreIndex",
      ARRAY_SIZE(kPositivePreIndex),
      kPositivePreIndex},
     {{al, r4, r5, plus, r14, LSL, 9, PreIndex},
      "al r4 r5 plus r14 LSL 9 PreIndex",
      "PositivePreIndex_al_r4_r5_plus_r14_LSL_9_PreIndex",
      ARRAY_SIZE(kPositivePreIndex),
      kPositivePreIndex},
     {{al, r2, r10, plus, r14, LSL, 2, PreIndex},
      "al r2 r10 plus r14 LSL 2 PreIndex",
      "PositivePreIndex_al_r2_r10_plus_r14_LSL_2_PreIndex",
      ARRAY_SIZE(kPositivePreIndex),
      kPositivePreIndex},
     {{al, r0, r10, plus, r2, LSL, 16, PreIndex},
      "al r0 r10 plus r2 LSL 16 PreIndex",
      "PositivePreIndex_al_r0_r10_plus_r2_LSL_16_PreIndex",
      ARRAY_SIZE(kPositivePreIndex),
      kPositivePreIndex},
     {{al, r11, r12, plus, r2, LSL, 17, PreIndex},
      "al r11 r12 plus r2 LSL 17 PreIndex",
      "PositivePreIndex_al_r11_r12_plus_r2_LSL_17_PreIndex",
      ARRAY_SIZE(kPositivePreIndex),
      kPositivePreIndex},
     {{al, r10, r5, plus, r8, LSL, 24, PreIndex},
      "al r10 r5 plus r8 LSL 24 PreIndex",
      "PositivePreIndex_al_r10_r5_plus_r8_LSL_24_PreIndex",
      ARRAY_SIZE(kPositivePreIndex),
      kPositivePreIndex},
     {{al, r11, r3, plus, r7, ROR, 6, PreIndex},
      "al r11 r3 plus r7 ROR 6 PreIndex",
      "PositivePreIndex_al_r11_r3_plus_r7_ROR_6_PreIndex",
      ARRAY_SIZE(kPositivePreIndex),
      kPositivePreIndex},
     {{al, r12, r0, plus, r11, ROR, 13, PreIndex},
      "al r12 r0 plus r11 ROR 13 PreIndex",
      "PositivePreIndex_al_r12_r0_plus_r11_ROR_13_PreIndex",
      ARRAY_SIZE(kPositivePreIndex),
      kPositivePreIndex},
     {{al, r14, r5, plus, r2, LSL, 2, PreIndex},
      "al r14 r5 plus r2 LSL 2 PreIndex",
      "PositivePreIndex_al_r14_r5_plus_r2_LSL_2_PreIndex",
      ARRAY_SIZE(kPositivePreIndex),
      kPositivePreIndex},
     {{al, r14, r7, plus, r8, ROR, 28, PreIndex},
      "al r14 r7 plus r8 ROR 28 PreIndex",
      "PositivePreIndex_al_r14_r7_plus_r8_ROR_28_PreIndex",
      ARRAY_SIZE(kPositivePreIndex),
      kPositivePreIndex},
     {{al, r12, r2, plus, r7, LSL, 22, PreIndex},
      "al r12 r2 plus r7 LSL 22 PreIndex",
      "PositivePreIndex_al_r12_r2_plus_r7_LSL_22_PreIndex",
      ARRAY_SIZE(kPositivePreIndex),
      kPositivePreIndex},
     {{al, r6, r5, plus, r12, ROR, 16, PreIndex},
      "al r6 r5 plus r12 ROR 16 PreIndex",
      "PositivePreIndex_al_r6_r5_plus_r12_ROR_16_PreIndex",
      ARRAY_SIZE(kPositivePreIndex),
      kPositivePreIndex},
     {{al, r1, r14, plus, r4, LSL, 9, PreIndex},
      "al r1 r14 plus r4 LSL 9 PreIndex",
      "PositivePreIndex_al_r1_r14_plus_r4_LSL_9_PreIndex",
      ARRAY_SIZE(kPositivePreIndex),
      kPositivePreIndex},
     {{al, r9, r2, plus, r11, ROR, 9, PreIndex},
      "al r9 r2 plus r11 ROR 9 PreIndex",
      "PositivePreIndex_al_r9_r2_plus_r11_ROR_9_PreIndex",
      ARRAY_SIZE(kPositivePreIndex),
      kPositivePreIndex},
     {{al, r6, r8, plus, r9, LSL, 2, PreIndex},
      "al r6 r8 plus r9 LSL 2 PreIndex",
      "PositivePreIndex_al_r6_r8_plus_r9_LSL_2_PreIndex",
      ARRAY_SIZE(kPositivePreIndex),
      kPositivePreIndex},
     {{al, r8, r1, plus, r0, LSL, 30, PreIndex},
      "al r8 r1 plus r0 LSL 30 PreIndex",
      "PositivePreIndex_al_r8_r1_plus_r0_LSL_30_PreIndex",
      ARRAY_SIZE(kPositivePreIndex),
      kPositivePreIndex},
     {{al, r14, r0, plus, r6, ROR, 5, PreIndex},
      "al r14 r0 plus r6 ROR 5 PreIndex",
      "PositivePreIndex_al_r14_r0_plus_r6_ROR_5_PreIndex",
      ARRAY_SIZE(kPositivePreIndex),
      kPositivePreIndex},
     {{al, r1, r6, plus, r2, LSL, 9, PreIndex},
      "al r1 r6 plus r2 LSL 9 PreIndex",
      "PositivePreIndex_al_r1_r6_plus_r2_LSL_9_PreIndex",
      ARRAY_SIZE(kPositivePreIndex),
      kPositivePreIndex},
     {{al, r12, r4, plus, r9, ROR, 28, PreIndex},
      "al r12 r4 plus r9 ROR 28 PreIndex",
      "PositivePreIndex_al_r12_r4_plus_r9_ROR_28_PreIndex",
      ARRAY_SIZE(kPositivePreIndex),
      kPositivePreIndex},
     {{al, r5, r1, plus, r10, ROR, 21, PreIndex},
      "al r5 r1 plus r10 ROR 21 PreIndex",
      "PositivePreIndex_al_r5_r1_plus_r10_ROR_21_PreIndex",
      ARRAY_SIZE(kPositivePreIndex),
      kPositivePreIndex},
     {{al, r6, r14, plus, r12, ROR, 31, PreIndex},
      "al r6 r14 plus r12 ROR 31 PreIndex",
      "PositivePreIndex_al_r6_r14_plus_r12_ROR_31_PreIndex",
      ARRAY_SIZE(kPositivePreIndex),
      kPositivePreIndex},
     {{al, r0, r3, plus, r5, ROR, 10, PreIndex},
      "al r0 r3 plus r5 ROR 10 PreIndex",
      "PositivePreIndex_al_r0_r3_plus_r5_ROR_10_PreIndex",
      ARRAY_SIZE(kPositivePreIndex),
      kPositivePreIndex},
     {{al, r2, r11, plus, r3, LSL, 29, PreIndex},
      "al r2 r11 plus r3 LSL 29 PreIndex",
      "PositivePreIndex_al_r2_r11_plus_r3_LSL_29_PreIndex",
      ARRAY_SIZE(kPositivePreIndex),
      kPositivePreIndex},
     {{al, r3, r4, plus, r9, LSL, 16, PreIndex},
      "al r3 r4 plus r9 LSL 16 PreIndex",
      "PositivePreIndex_al_r3_r4_plus_r9_LSL_16_PreIndex",
      ARRAY_SIZE(kPositivePreIndex),
      kPositivePreIndex},
     {{al, r6, r11, plus, r5, ROR, 14, PreIndex},
      "al r6 r11 plus r5 ROR 14 PreIndex",
      "PositivePreIndex_al_r6_r11_plus_r5_ROR_14_PreIndex",
      ARRAY_SIZE(kPositivePreIndex),
      kPositivePreIndex},
     {{al, r4, r12, plus, r0, ROR, 28, PreIndex},
      "al r4 r12 plus r0 ROR 28 PreIndex",
      "PositivePreIndex_al_r4_r12_plus_r0_ROR_28_PreIndex",
      ARRAY_SIZE(kPositivePreIndex),
      kPositivePreIndex},
     {{al, r4, r6, plus, r1, LSL, 7, PreIndex},
      "al r4 r6 plus r1 LSL 7 PreIndex",
      "PositivePreIndex_al_r4_r6_plus_r1_LSL_7_PreIndex",
      ARRAY_SIZE(kPositivePreIndex),
      kPositivePreIndex},
     {{al, r5, r2, plus, r6, ROR, 20, PreIndex},
      "al r5 r2 plus r6 ROR 20 PreIndex",
      "PositivePreIndex_al_r5_r2_plus_r6_ROR_20_PreIndex",
      ARRAY_SIZE(kPositivePreIndex),
      kPositivePreIndex},
     {{al, r9, r6, plus, r5, LSL, 2, PreIndex},
      "al r9 r6 plus r5 LSL 2 PreIndex",
      "PositivePreIndex_al_r9_r6_plus_r5_LSL_2_PreIndex",
      ARRAY_SIZE(kPositivePreIndex),
      kPositivePreIndex},
     {{al, r4, r3, plus, r6, ROR, 6, PreIndex},
      "al r4 r3 plus r6 ROR 6 PreIndex",
      "PositivePreIndex_al_r4_r3_plus_r6_ROR_6_PreIndex",
      ARRAY_SIZE(kPositivePreIndex),
      kPositivePreIndex},
     {{al, r6, r0, plus, r9, ROR, 8, PreIndex},
      "al r6 r0 plus r9 ROR 8 PreIndex",
      "PositivePreIndex_al_r6_r0_plus_r9_ROR_8_PreIndex",
      ARRAY_SIZE(kPositivePreIndex),
      kPositivePreIndex},
     {{al, r10, r14, plus, r2, LSL, 29, PreIndex},
      "al r10 r14 plus r2 LSL 29 PreIndex",
      "PositivePreIndex_al_r10_r14_plus_r2_LSL_29_PreIndex",
      ARRAY_SIZE(kPositivePreIndex),
      kPositivePreIndex},
     {{al, r1, r10, plus, r3, ROR, 21, PreIndex},
      "al r1 r10 plus r3 ROR 21 PreIndex",
      "PositivePreIndex_al_r1_r10_plus_r3_ROR_21_PreIndex",
      ARRAY_SIZE(kPositivePreIndex),
      kPositivePreIndex},
     {{al, r6, r10, plus, r1, LSL, 1, PreIndex},
      "al r6 r10 plus r1 LSL 1 PreIndex",
      "PositivePreIndex_al_r6_r10_plus_r1_LSL_1_PreIndex",
      ARRAY_SIZE(kPositivePreIndex),
      kPositivePreIndex},
     {{al, r5, r1, plus, r14, LSL, 23, PreIndex},
      "al r5 r1 plus r14 LSL 23 PreIndex",
      "PositivePreIndex_al_r5_r1_plus_r14_LSL_23_PreIndex",
      ARRAY_SIZE(kPositivePreIndex),
      kPositivePreIndex},
     {{al, r6, r12, plus, r10, LSL, 27, PreIndex},
      "al r6 r12 plus r10 LSL 27 PreIndex",
      "PositivePreIndex_al_r6_r12_plus_r10_LSL_27_PreIndex",
      ARRAY_SIZE(kPositivePreIndex),
      kPositivePreIndex},
     {{al, r10, r5, plus, r8, LSL, 30, PreIndex},
      "al r10 r5 plus r8 LSL 30 PreIndex",
      "PositivePreIndex_al_r10_r5_plus_r8_LSL_30_PreIndex",
      ARRAY_SIZE(kPositivePreIndex),
      kPositivePreIndex},
     {{al, r12, r8, plus, r5, LSL, 12, PreIndex},
      "al r12 r8 plus r5 LSL 12 PreIndex",
      "PositivePreIndex_al_r12_r8_plus_r5_LSL_12_PreIndex",
      ARRAY_SIZE(kPositivePreIndex),
      kPositivePreIndex},
     {{al, r14, r6, plus, r3, ROR, 23, PreIndex},
      "al r14 r6 plus r3 ROR 23 PreIndex",
      "PositivePreIndex_al_r14_r6_plus_r3_ROR_23_PreIndex",
      ARRAY_SIZE(kPositivePreIndex),
      kPositivePreIndex},
     {{al, r5, r8, plus, r6, ROR, 26, PreIndex},
      "al r5 r8 plus r6 ROR 26 PreIndex",
      "PositivePreIndex_al_r5_r8_plus_r6_ROR_26_PreIndex",
      ARRAY_SIZE(kPositivePreIndex),
      kPositivePreIndex},
     {{al, r1, r4, plus, r10, ROR, 21, PreIndex},
      "al r1 r4 plus r10 ROR 21 PreIndex",
      "PositivePreIndex_al_r1_r4_plus_r10_ROR_21_PreIndex",
      ARRAY_SIZE(kPositivePreIndex),
      kPositivePreIndex},
     {{al, r8, r9, plus, r1, LSL, 24, PreIndex},
      "al r8 r9 plus r1 LSL 24 PreIndex",
      "PositivePreIndex_al_r8_r9_plus_r1_LSL_24_PreIndex",
      ARRAY_SIZE(kPositivePreIndex),
      kPositivePreIndex},
     {{al, r0, r2, plus, r6, ROR, 6, PreIndex},
      "al r0 r2 plus r6 ROR 6 PreIndex",
      "PositivePreIndex_al_r0_r2_plus_r6_ROR_6_PreIndex",
      ARRAY_SIZE(kPositivePreIndex),
      kPositivePreIndex},
     {{al, r5, r1, plus, r0, ROR, 6, PreIndex},
      "al r5 r1 plus r0 ROR 6 PreIndex",
      "PositivePreIndex_al_r5_r1_plus_r0_ROR_6_PreIndex",
      ARRAY_SIZE(kPositivePreIndex),
      kPositivePreIndex},
     {{al, r4, r6, plus, r0, LSL, 25, PreIndex},
      "al r4 r6 plus r0 LSL 25 PreIndex",
      "PositivePreIndex_al_r4_r6_plus_r0_LSL_25_PreIndex",
      ARRAY_SIZE(kPositivePreIndex),
      kPositivePreIndex},
     {{al, r7, r6, plus, r4, LSL, 15, PreIndex},
      "al r7 r6 plus r4 LSL 15 PreIndex",
      "PositivePreIndex_al_r7_r6_plus_r4_LSL_15_PreIndex",
      ARRAY_SIZE(kPositivePreIndex),
      kPositivePreIndex},
     {{al, r3, r10, plus, r4, ROR, 12, PreIndex},
      "al r3 r10 plus r4 ROR 12 PreIndex",
      "PositivePreIndex_al_r3_r10_plus_r4_ROR_12_PreIndex",
      ARRAY_SIZE(kPositivePreIndex),
      kPositivePreIndex},
     {{al, r11, r10, plus, r12, ROR, 30, PreIndex},
      "al r11 r10 plus r12 ROR 30 PreIndex",
      "PositivePreIndex_al_r11_r10_plus_r12_ROR_30_PreIndex",
      ARRAY_SIZE(kPositivePreIndex),
      kPositivePreIndex},
     {{al, r12, r9, plus, r1, ROR, 28, PreIndex},
      "al r12 r9 plus r1 ROR 28 PreIndex",
      "PositivePreIndex_al_r12_r9_plus_r1_ROR_28_PreIndex",
      ARRAY_SIZE(kPositivePreIndex),
      kPositivePreIndex},
     {{al, r1, r4, plus, r11, ROR, 31, PreIndex},
      "al r1 r4 plus r11 ROR 31 PreIndex",
      "PositivePreIndex_al_r1_r4_plus_r11_ROR_31_PreIndex",
      ARRAY_SIZE(kPositivePreIndex),
      kPositivePreIndex},
     {{al, r14, r5, plus, r7, ROR, 2, PreIndex},
      "al r14 r5 plus r7 ROR 2 PreIndex",
      "PositivePreIndex_al_r14_r5_plus_r7_ROR_2_PreIndex",
      ARRAY_SIZE(kPositivePreIndex),
      kPositivePreIndex},
     {{al, r8, r10, plus, r14, ROR, 4, PreIndex},
      "al r8 r10 plus r14 ROR 4 PreIndex",
      "PositivePreIndex_al_r8_r10_plus_r14_ROR_4_PreIndex",
      ARRAY_SIZE(kPositivePreIndex),
      kPositivePreIndex},
     {{al, r4, r9, plus, r10, LSL, 24, PreIndex},
      "al r4 r9 plus r10 LSL 24 PreIndex",
      "PositivePreIndex_al_r4_r9_plus_r10_LSL_24_PreIndex",
      ARRAY_SIZE(kPositivePreIndex),
      kPositivePreIndex},
     {{al, r3, r1, plus, r14, ROR, 21, PreIndex},
      "al r3 r1 plus r14 ROR 21 PreIndex",
      "PositivePreIndex_al_r3_r1_plus_r14_ROR_21_PreIndex",
      ARRAY_SIZE(kPositivePreIndex),
      kPositivePreIndex},
     {{al, r7, r11, plus, r8, ROR, 14, PreIndex},
      "al r7 r11 plus r8 ROR 14 PreIndex",
      "PositivePreIndex_al_r7_r11_plus_r8_ROR_14_PreIndex",
      ARRAY_SIZE(kPositivePreIndex),
      kPositivePreIndex},
     {{al, r2, r0, plus, r9, LSL, 18, PreIndex},
      "al r2 r0 plus r9 LSL 18 PreIndex",
      "PositivePreIndex_al_r2_r0_plus_r9_LSL_18_PreIndex",
      ARRAY_SIZE(kPositivePreIndex),
      kPositivePreIndex},
     {{al, r7, r8, plus, r6, ROR, 21, PreIndex},
      "al r7 r8 plus r6 ROR 21 PreIndex",
      "PositivePreIndex_al_r7_r8_plus_r6_ROR_21_PreIndex",
      ARRAY_SIZE(kPositivePreIndex),
      kPositivePreIndex},
     {{al, r2, r1, plus, r10, LSL, 1, PreIndex},
      "al r2 r1 plus r10 LSL 1 PreIndex",
      "PositivePreIndex_al_r2_r1_plus_r10_LSL_1_PreIndex",
      ARRAY_SIZE(kPositivePreIndex),
      kPositivePreIndex},
     {{al, r4, r7, plus, r2, ROR, 13, PreIndex},
      "al r4 r7 plus r2 ROR 13 PreIndex",
      "PositivePreIndex_al_r4_r7_plus_r2_ROR_13_PreIndex",
      ARRAY_SIZE(kPositivePreIndex),
      kPositivePreIndex},
     {{al, r9, r4, plus, r0, LSL, 18, PreIndex},
      "al r9 r4 plus r0 LSL 18 PreIndex",
      "PositivePreIndex_al_r9_r4_plus_r0_LSL_18_PreIndex",
      ARRAY_SIZE(kPositivePreIndex),
      kPositivePreIndex},
     {{al, r3, r10, plus, r5, ROR, 30, PreIndex},
      "al r3 r10 plus r5 ROR 30 PreIndex",
      "PositivePreIndex_al_r3_r10_plus_r5_ROR_30_PreIndex",
      ARRAY_SIZE(kPositivePreIndex),
      kPositivePreIndex},
     {{al, r3, r2, plus, r6, LSL, 22, PreIndex},
      "al r3 r2 plus r6 LSL 22 PreIndex",
      "PositivePreIndex_al_r3_r2_plus_r6_LSL_22_PreIndex",
      ARRAY_SIZE(kPositivePreIndex),
      kPositivePreIndex},
     {{al, r9, r14, plus, r6, LSL, 29, PreIndex},
      "al r9 r14 plus r6 LSL 29 PreIndex",
      "PositivePreIndex_al_r9_r14_plus_r6_LSL_29_PreIndex",
      ARRAY_SIZE(kPositivePreIndex),
      kPositivePreIndex},
     {{al, r14, r3, plus, r1, ROR, 5, PreIndex},
      "al r14 r3 plus r1 ROR 5 PreIndex",
      "PositivePreIndex_al_r14_r3_plus_r1_ROR_5_PreIndex",
      ARRAY_SIZE(kPositivePreIndex),
      kPositivePreIndex},
     {{al, r14, r3, plus, r4, ROR, 18, PreIndex},
      "al r14 r3 plus r4 ROR 18 PreIndex",
      "PositivePreIndex_al_r14_r3_plus_r4_ROR_18_PreIndex",
      ARRAY_SIZE(kPositivePreIndex),
      kPositivePreIndex},
     {{al, r1, r12, plus, r3, LSL, 16, PreIndex},
      "al r1 r12 plus r3 LSL 16 PreIndex",
      "PositivePreIndex_al_r1_r12_plus_r3_LSL_16_PreIndex",
      ARRAY_SIZE(kPositivePreIndex),
      kPositivePreIndex},
     {{al, r1, r5, plus, r7, ROR, 17, PreIndex},
      "al r1 r5 plus r7 ROR 17 PreIndex",
      "PositivePreIndex_al_r1_r5_plus_r7_ROR_17_PreIndex",
      ARRAY_SIZE(kPositivePreIndex),
      kPositivePreIndex},
     {{al, r6, r10, plus, r8, LSL, 4, PreIndex},
      "al r6 r10 plus r8 LSL 4 PreIndex",
      "PositivePreIndex_al_r6_r10_plus_r8_LSL_4_PreIndex",
      ARRAY_SIZE(kPositivePreIndex),
      kPositivePreIndex},
     {{al, r11, r1, plus, r4, ROR, 16, PreIndex},
      "al r11 r1 plus r4 ROR 16 PreIndex",
      "PositivePreIndex_al_r11_r1_plus_r4_ROR_16_PreIndex",
      ARRAY_SIZE(kPositivePreIndex),
      kPositivePreIndex},
     {{al, r14, r0, plus, r12, LSL, 21, PreIndex},
      "al r14 r0 plus r12 LSL 21 PreIndex",
      "PositivePreIndex_al_r14_r0_plus_r12_LSL_21_PreIndex",
      ARRAY_SIZE(kPositivePreIndex),
      kPositivePreIndex},
     {{al, r10, r14, plus, r1, LSL, 29, PreIndex},
      "al r10 r14 plus r1 LSL 29 PreIndex",
      "PositivePreIndex_al_r10_r14_plus_r1_LSL_29_PreIndex",
      ARRAY_SIZE(kPositivePreIndex),
      kPositivePreIndex},
     {{al, r14, r7, plus, r0, LSL, 27, PreIndex},
      "al r14 r7 plus r0 LSL 27 PreIndex",
      "PositivePreIndex_al_r14_r7_plus_r0_LSL_27_PreIndex",
      ARRAY_SIZE(kPositivePreIndex),
      kPositivePreIndex},
     {{al, r4, r9, plus, r6, LSL, 19, PreIndex},
      "al r4 r9 plus r6 LSL 19 PreIndex",
      "PositivePreIndex_al_r4_r9_plus_r6_LSL_19_PreIndex",
      ARRAY_SIZE(kPositivePreIndex),
      kPositivePreIndex},
     {{al, r3, r11, plus, r12, ROR, 23, PreIndex},
      "al r3 r11 plus r12 ROR 23 PreIndex",
      "PositivePreIndex_al_r3_r11_plus_r12_ROR_23_PreIndex",
      ARRAY_SIZE(kPositivePreIndex),
      kPositivePreIndex},
     {{al, r3, r1, plus, r11, ROR, 22, PreIndex},
      "al r3 r1 plus r11 ROR 22 PreIndex",
      "PositivePreIndex_al_r3_r1_plus_r11_ROR_22_PreIndex",
      ARRAY_SIZE(kPositivePreIndex),
      kPositivePreIndex},
     {{al, r1, r12, plus, r10, ROR, 28, PreIndex},
      "al r1 r12 plus r10 ROR 28 PreIndex",
      "PositivePreIndex_al_r1_r12_plus_r10_ROR_28_PreIndex",
      ARRAY_SIZE(kPositivePreIndex),
      kPositivePreIndex},
     {{al, r14, r8, plus, r12, LSL, 30, PreIndex},
      "al r14 r8 plus r12 LSL 30 PreIndex",
      "PositivePreIndex_al_r14_r8_plus_r12_LSL_30_PreIndex",
      ARRAY_SIZE(kPositivePreIndex),
      kPositivePreIndex},
     {{al, r0, r5, plus, r4, LSL, 15, PreIndex},
      "al r0 r5 plus r4 LSL 15 PreIndex",
      "PositivePreIndex_al_r0_r5_plus_r4_LSL_15_PreIndex",
      ARRAY_SIZE(kPositivePreIndex),
      kPositivePreIndex},
     {{al, r11, r9, plus, r7, LSL, 14, PreIndex},
      "al r11 r9 plus r7 LSL 14 PreIndex",
      "PositivePreIndex_al_r11_r9_plus_r7_LSL_14_PreIndex",
      ARRAY_SIZE(kPositivePreIndex),
      kPositivePreIndex},
     {{al, r11, r5, plus, r0, LSL, 5, PreIndex},
      "al r11 r5 plus r0 LSL 5 PreIndex",
      "PositivePreIndex_al_r11_r5_plus_r0_LSL_5_PreIndex",
      ARRAY_SIZE(kPositivePreIndex),
      kPositivePreIndex},
     {{al, r8, r9, plus, r11, LSL, 6, PreIndex},
      "al r8 r9 plus r11 LSL 6 PreIndex",
      "PositivePreIndex_al_r8_r9_plus_r11_LSL_6_PreIndex",
      ARRAY_SIZE(kPositivePreIndex),
      kPositivePreIndex},
     {{al, r5, r2, plus, r8, ROR, 12, PreIndex},
      "al r5 r2 plus r8 ROR 12 PreIndex",
      "PositivePreIndex_al_r5_r2_plus_r8_ROR_12_PreIndex",
      ARRAY_SIZE(kPositivePreIndex),
      kPositivePreIndex},
     {{al, r8, r0, plus, r6, ROR, 2, PreIndex},
      "al r8 r0 plus r6 ROR 2 PreIndex",
      "PositivePreIndex_al_r8_r0_plus_r6_ROR_2_PreIndex",
      ARRAY_SIZE(kPositivePreIndex),
      kPositivePreIndex},
     {{al, r0, r10, plus, r5, LSL, 28, PreIndex},
      "al r0 r10 plus r5 LSL 28 PreIndex",
      "PositivePreIndex_al_r0_r10_plus_r5_LSL_28_PreIndex",
      ARRAY_SIZE(kPositivePreIndex),
      kPositivePreIndex},
     {{al, r8, r12, plus, r3, ROR, 29, PreIndex},
      "al r8 r12 plus r3 ROR 29 PreIndex",
      "PositivePreIndex_al_r8_r12_plus_r3_ROR_29_PreIndex",
      ARRAY_SIZE(kPositivePreIndex),
      kPositivePreIndex},
     {{al, r9, r2, plus, r8, LSL, 21, PreIndex},
      "al r9 r2 plus r8 LSL 21 PreIndex",
      "PositivePreIndex_al_r9_r2_plus_r8_LSL_21_PreIndex",
      ARRAY_SIZE(kPositivePreIndex),
      kPositivePreIndex},
     {{al, r12, r3, plus, r8, ROR, 27, PreIndex},
      "al r12 r3 plus r8 ROR 27 PreIndex",
      "PositivePreIndex_al_r12_r3_plus_r8_ROR_27_PreIndex",
      ARRAY_SIZE(kPositivePreIndex),
      kPositivePreIndex},
     {{al, r12, r6, plus, r11, LSL, 17, PreIndex},
      "al r12 r6 plus r11 LSL 17 PreIndex",
      "PositivePreIndex_al_r12_r6_plus_r11_LSL_17_PreIndex",
      ARRAY_SIZE(kPositivePreIndex),
      kPositivePreIndex},
     {{al, r4, r2, plus, r0, ROR, 14, PreIndex},
      "al r4 r2 plus r0 ROR 14 PreIndex",
      "PositivePreIndex_al_r4_r2_plus_r0_ROR_14_PreIndex",
      ARRAY_SIZE(kPositivePreIndex),
      kPositivePreIndex},
     {{al, r4, r10, minus, r7, LSL, 3, PreIndex},
      "al r4 r10 minus r7 LSL 3 PreIndex",
      "NegativePreIndex_al_r4_r10_minus_r7_LSL_3_PreIndex",
      ARRAY_SIZE(kNegativePreIndex),
      kNegativePreIndex},
     {{al, r9, r4, minus, r10, LSL, 20, PreIndex},
      "al r9 r4 minus r10 LSL 20 PreIndex",
      "NegativePreIndex_al_r9_r4_minus_r10_LSL_20_PreIndex",
      ARRAY_SIZE(kNegativePreIndex),
      kNegativePreIndex},
     {{al, r3, r2, minus, r14, LSL, 23, PreIndex},
      "al r3 r2 minus r14 LSL 23 PreIndex",
      "NegativePreIndex_al_r3_r2_minus_r14_LSL_23_PreIndex",
      ARRAY_SIZE(kNegativePreIndex),
      kNegativePreIndex},
     {{al, r1, r6, minus, r8, ROR, 22, PreIndex},
      "al r1 r6 minus r8 ROR 22 PreIndex",
      "NegativePreIndex_al_r1_r6_minus_r8_ROR_22_PreIndex",
      ARRAY_SIZE(kNegativePreIndex),
      kNegativePreIndex},
     {{al, r0, r11, minus, r1, ROR, 24, PreIndex},
      "al r0 r11 minus r1 ROR 24 PreIndex",
      "NegativePreIndex_al_r0_r11_minus_r1_ROR_24_PreIndex",
      ARRAY_SIZE(kNegativePreIndex),
      kNegativePreIndex},
     {{al, r6, r11, minus, r12, ROR, 2, PreIndex},
      "al r6 r11 minus r12 ROR 2 PreIndex",
      "NegativePreIndex_al_r6_r11_minus_r12_ROR_2_PreIndex",
      ARRAY_SIZE(kNegativePreIndex),
      kNegativePreIndex},
     {{al, r12, r2, minus, r9, ROR, 28, PreIndex},
      "al r12 r2 minus r9 ROR 28 PreIndex",
      "NegativePreIndex_al_r12_r2_minus_r9_ROR_28_PreIndex",
      ARRAY_SIZE(kNegativePreIndex),
      kNegativePreIndex},
     {{al, r6, r4, minus, r5, ROR, 16, PreIndex},
      "al r6 r4 minus r5 ROR 16 PreIndex",
      "NegativePreIndex_al_r6_r4_minus_r5_ROR_16_PreIndex",
      ARRAY_SIZE(kNegativePreIndex),
      kNegativePreIndex},
     {{al, r0, r2, minus, r12, LSL, 23, PreIndex},
      "al r0 r2 minus r12 LSL 23 PreIndex",
      "NegativePreIndex_al_r0_r2_minus_r12_LSL_23_PreIndex",
      ARRAY_SIZE(kNegativePreIndex),
      kNegativePreIndex},
     {{al, r2, r10, minus, r11, LSL, 3, PreIndex},
      "al r2 r10 minus r11 LSL 3 PreIndex",
      "NegativePreIndex_al_r2_r10_minus_r11_LSL_3_PreIndex",
      ARRAY_SIZE(kNegativePreIndex),
      kNegativePreIndex},
     {{al, r6, r2, minus, r5, LSL, 18, PreIndex},
      "al r6 r2 minus r5 LSL 18 PreIndex",
      "NegativePreIndex_al_r6_r2_minus_r5_LSL_18_PreIndex",
      ARRAY_SIZE(kNegativePreIndex),
      kNegativePreIndex},
     {{al, r10, r7, minus, r3, LSL, 18, PreIndex},
      "al r10 r7 minus r3 LSL 18 PreIndex",
      "NegativePreIndex_al_r10_r7_minus_r3_LSL_18_PreIndex",
      ARRAY_SIZE(kNegativePreIndex),
      kNegativePreIndex},
     {{al, r9, r10, minus, r2, ROR, 5, PreIndex},
      "al r9 r10 minus r2 ROR 5 PreIndex",
      "NegativePreIndex_al_r9_r10_minus_r2_ROR_5_PreIndex",
      ARRAY_SIZE(kNegativePreIndex),
      kNegativePreIndex},
     {{al, r1, r14, minus, r5, LSL, 20, PreIndex},
      "al r1 r14 minus r5 LSL 20 PreIndex",
      "NegativePreIndex_al_r1_r14_minus_r5_LSL_20_PreIndex",
      ARRAY_SIZE(kNegativePreIndex),
      kNegativePreIndex},
     {{al, r11, r1, minus, r14, LSL, 2, PreIndex},
      "al r11 r1 minus r14 LSL 2 PreIndex",
      "NegativePreIndex_al_r11_r1_minus_r14_LSL_2_PreIndex",
      ARRAY_SIZE(kNegativePreIndex),
      kNegativePreIndex},
     {{al, r12, r14, minus, r6, LSL, 16, PreIndex},
      "al r12 r14 minus r6 LSL 16 PreIndex",
      "NegativePreIndex_al_r12_r14_minus_r6_LSL_16_PreIndex",
      ARRAY_SIZE(kNegativePreIndex),
      kNegativePreIndex},
     {{al, r2, r0, minus, r5, LSL, 30, PreIndex},
      "al r2 r0 minus r5 LSL 30 PreIndex",
      "NegativePreIndex_al_r2_r0_minus_r5_LSL_30_PreIndex",
      ARRAY_SIZE(kNegativePreIndex),
      kNegativePreIndex},
     {{al, r12, r14, minus, r10, LSL, 28, PreIndex},
      "al r12 r14 minus r10 LSL 28 PreIndex",
      "NegativePreIndex_al_r12_r14_minus_r10_LSL_28_PreIndex",
      ARRAY_SIZE(kNegativePreIndex),
      kNegativePreIndex},
     {{al, r7, r14, minus, r9, LSL, 26, PreIndex},
      "al r7 r14 minus r9 LSL 26 PreIndex",
      "NegativePreIndex_al_r7_r14_minus_r9_LSL_26_PreIndex",
      ARRAY_SIZE(kNegativePreIndex),
      kNegativePreIndex},
     {{al, r11, r9, minus, r2, ROR, 28, PreIndex},
      "al r11 r9 minus r2 ROR 28 PreIndex",
      "NegativePreIndex_al_r11_r9_minus_r2_ROR_28_PreIndex",
      ARRAY_SIZE(kNegativePreIndex),
      kNegativePreIndex},
     {{al, r5, r4, minus, r6, ROR, 18, PreIndex},
      "al r5 r4 minus r6 ROR 18 PreIndex",
      "NegativePreIndex_al_r5_r4_minus_r6_ROR_18_PreIndex",
      ARRAY_SIZE(kNegativePreIndex),
      kNegativePreIndex},
     {{al, r2, r0, minus, r4, LSL, 1, PreIndex},
      "al r2 r0 minus r4 LSL 1 PreIndex",
      "NegativePreIndex_al_r2_r0_minus_r4_LSL_1_PreIndex",
      ARRAY_SIZE(kNegativePreIndex),
      kNegativePreIndex},
     {{al, r0, r14, minus, r11, ROR, 25, PreIndex},
      "al r0 r14 minus r11 ROR 25 PreIndex",
      "NegativePreIndex_al_r0_r14_minus_r11_ROR_25_PreIndex",
      ARRAY_SIZE(kNegativePreIndex),
      kNegativePreIndex},
     {{al, r12, r4, minus, r2, LSL, 16, PreIndex},
      "al r12 r4 minus r2 LSL 16 PreIndex",
      "NegativePreIndex_al_r12_r4_minus_r2_LSL_16_PreIndex",
      ARRAY_SIZE(kNegativePreIndex),
      kNegativePreIndex},
     {{al, r2, r12, minus, r1, LSL, 26, PreIndex},
      "al r2 r12 minus r1 LSL 26 PreIndex",
      "NegativePreIndex_al_r2_r12_minus_r1_LSL_26_PreIndex",
      ARRAY_SIZE(kNegativePreIndex),
      kNegativePreIndex},
     {{al, r9, r2, minus, r14, LSL, 23, PreIndex},
      "al r9 r2 minus r14 LSL 23 PreIndex",
      "NegativePreIndex_al_r9_r2_minus_r14_LSL_23_PreIndex",
      ARRAY_SIZE(kNegativePreIndex),
      kNegativePreIndex},
     {{al, r0, r8, minus, r2, ROR, 20, PreIndex},
      "al r0 r8 minus r2 ROR 20 PreIndex",
      "NegativePreIndex_al_r0_r8_minus_r2_ROR_20_PreIndex",
      ARRAY_SIZE(kNegativePreIndex),
      kNegativePreIndex},
     {{al, r7, r11, minus, r12, LSL, 27, PreIndex},
      "al r7 r11 minus r12 LSL 27 PreIndex",
      "NegativePreIndex_al_r7_r11_minus_r12_LSL_27_PreIndex",
      ARRAY_SIZE(kNegativePreIndex),
      kNegativePreIndex},
     {{al, r5, r2, minus, r11, ROR, 16, PreIndex},
      "al r5 r2 minus r11 ROR 16 PreIndex",
      "NegativePreIndex_al_r5_r2_minus_r11_ROR_16_PreIndex",
      ARRAY_SIZE(kNegativePreIndex),
      kNegativePreIndex},
     {{al, r9, r4, minus, r0, ROR, 9, PreIndex},
      "al r9 r4 minus r0 ROR 9 PreIndex",
      "NegativePreIndex_al_r9_r4_minus_r0_ROR_9_PreIndex",
      ARRAY_SIZE(kNegativePreIndex),
      kNegativePreIndex},
     {{al, r0, r8, minus, r1, LSL, 6, PreIndex},
      "al r0 r8 minus r1 LSL 6 PreIndex",
      "NegativePreIndex_al_r0_r8_minus_r1_LSL_6_PreIndex",
      ARRAY_SIZE(kNegativePreIndex),
      kNegativePreIndex},
     {{al, r9, r14, minus, r5, LSL, 28, PreIndex},
      "al r9 r14 minus r5 LSL 28 PreIndex",
      "NegativePreIndex_al_r9_r14_minus_r5_LSL_28_PreIndex",
      ARRAY_SIZE(kNegativePreIndex),
      kNegativePreIndex},
     {{al, r12, r3, minus, r7, ROR, 30, PreIndex},
      "al r12 r3 minus r7 ROR 30 PreIndex",
      "NegativePreIndex_al_r12_r3_minus_r7_ROR_30_PreIndex",
      ARRAY_SIZE(kNegativePreIndex),
      kNegativePreIndex},
     {{al, r3, r5, minus, r0, LSL, 21, PreIndex},
      "al r3 r5 minus r0 LSL 21 PreIndex",
      "NegativePreIndex_al_r3_r5_minus_r0_LSL_21_PreIndex",
      ARRAY_SIZE(kNegativePreIndex),
      kNegativePreIndex},
     {{al, r8, r14, minus, r11, LSL, 15, PreIndex},
      "al r8 r14 minus r11 LSL 15 PreIndex",
      "NegativePreIndex_al_r8_r14_minus_r11_LSL_15_PreIndex",
      ARRAY_SIZE(kNegativePreIndex),
      kNegativePreIndex},
     {{al, r7, r9, minus, r14, ROR, 6, PreIndex},
      "al r7 r9 minus r14 ROR 6 PreIndex",
      "NegativePreIndex_al_r7_r9_minus_r14_ROR_6_PreIndex",
      ARRAY_SIZE(kNegativePreIndex),
      kNegativePreIndex},
     {{al, r1, r14, minus, r0, LSL, 15, PreIndex},
      "al r1 r14 minus r0 LSL 15 PreIndex",
      "NegativePreIndex_al_r1_r14_minus_r0_LSL_15_PreIndex",
      ARRAY_SIZE(kNegativePreIndex),
      kNegativePreIndex},
     {{al, r6, r12, minus, r5, LSL, 24, PreIndex},
      "al r6 r12 minus r5 LSL 24 PreIndex",
      "NegativePreIndex_al_r6_r12_minus_r5_LSL_24_PreIndex",
      ARRAY_SIZE(kNegativePreIndex),
      kNegativePreIndex},
     {{al, r5, r14, minus, r9, LSL, 5, PreIndex},
      "al r5 r14 minus r9 LSL 5 PreIndex",
      "NegativePreIndex_al_r5_r14_minus_r9_LSL_5_PreIndex",
      ARRAY_SIZE(kNegativePreIndex),
      kNegativePreIndex},
     {{al, r4, r3, minus, r7, ROR, 19, PreIndex},
      "al r4 r3 minus r7 ROR 19 PreIndex",
      "NegativePreIndex_al_r4_r3_minus_r7_ROR_19_PreIndex",
      ARRAY_SIZE(kNegativePreIndex),
      kNegativePreIndex},
     {{al, r8, r7, minus, r11, LSL, 31, PreIndex},
      "al r8 r7 minus r11 LSL 31 PreIndex",
      "NegativePreIndex_al_r8_r7_minus_r11_LSL_31_PreIndex",
      ARRAY_SIZE(kNegativePreIndex),
      kNegativePreIndex},
     {{al, r2, r11, minus, r5, LSL, 8, PreIndex},
      "al r2 r11 minus r5 LSL 8 PreIndex",
      "NegativePreIndex_al_r2_r11_minus_r5_LSL_8_PreIndex",
      ARRAY_SIZE(kNegativePreIndex),
      kNegativePreIndex},
     {{al, r0, r7, minus, r9, ROR, 16, PreIndex},
      "al r0 r7 minus r9 ROR 16 PreIndex",
      "NegativePreIndex_al_r0_r7_minus_r9_ROR_16_PreIndex",
      ARRAY_SIZE(kNegativePreIndex),
      kNegativePreIndex},
     {{al, r11, r8, minus, r0, ROR, 11, PreIndex},
      "al r11 r8 minus r0 ROR 11 PreIndex",
      "NegativePreIndex_al_r11_r8_minus_r0_ROR_11_PreIndex",
      ARRAY_SIZE(kNegativePreIndex),
      kNegativePreIndex},
     {{al, r10, r1, minus, r0, ROR, 10, PreIndex},
      "al r10 r1 minus r0 ROR 10 PreIndex",
      "NegativePreIndex_al_r10_r1_minus_r0_ROR_10_PreIndex",
      ARRAY_SIZE(kNegativePreIndex),
      kNegativePreIndex},
     {{al, r1, r5, minus, r6, ROR, 21, PreIndex},
      "al r1 r5 minus r6 ROR 21 PreIndex",
      "NegativePreIndex_al_r1_r5_minus_r6_ROR_21_PreIndex",
      ARRAY_SIZE(kNegativePreIndex),
      kNegativePreIndex},
     {{al, r7, r1, minus, r2, LSL, 1, PreIndex},
      "al r7 r1 minus r2 LSL 1 PreIndex",
      "NegativePreIndex_al_r7_r1_minus_r2_LSL_1_PreIndex",
      ARRAY_SIZE(kNegativePreIndex),
      kNegativePreIndex},
     {{al, r14, r1, minus, r4, LSL, 10, PreIndex},
      "al r14 r1 minus r4 LSL 10 PreIndex",
      "NegativePreIndex_al_r14_r1_minus_r4_LSL_10_PreIndex",
      ARRAY_SIZE(kNegativePreIndex),
      kNegativePreIndex},
     {{al, r0, r12, minus, r5, ROR, 27, PreIndex},
      "al r0 r12 minus r5 ROR 27 PreIndex",
      "NegativePreIndex_al_r0_r12_minus_r5_ROR_27_PreIndex",
      ARRAY_SIZE(kNegativePreIndex),
      kNegativePreIndex},
     {{al, r2, r11, minus, r9, ROR, 31, PreIndex},
      "al r2 r11 minus r9 ROR 31 PreIndex",
      "NegativePreIndex_al_r2_r11_minus_r9_ROR_31_PreIndex",
      ARRAY_SIZE(kNegativePreIndex),
      kNegativePreIndex},
     {{al, r7, r12, minus, r0, LSL, 6, PreIndex},
      "al r7 r12 minus r0 LSL 6 PreIndex",
      "NegativePreIndex_al_r7_r12_minus_r0_LSL_6_PreIndex",
      ARRAY_SIZE(kNegativePreIndex),
      kNegativePreIndex},
     {{al, r12, r14, minus, r9, ROR, 13, PreIndex},
      "al r12 r14 minus r9 ROR 13 PreIndex",
      "NegativePreIndex_al_r12_r14_minus_r9_ROR_13_PreIndex",
      ARRAY_SIZE(kNegativePreIndex),
      kNegativePreIndex},
     {{al, r2, r6, minus, r11, LSL, 28, PreIndex},
      "al r2 r6 minus r11 LSL 28 PreIndex",
      "NegativePreIndex_al_r2_r6_minus_r11_LSL_28_PreIndex",
      ARRAY_SIZE(kNegativePreIndex),
      kNegativePreIndex},
     {{al, r14, r1, minus, r0, ROR, 18, PreIndex},
      "al r14 r1 minus r0 ROR 18 PreIndex",
      "NegativePreIndex_al_r14_r1_minus_r0_ROR_18_PreIndex",
      ARRAY_SIZE(kNegativePreIndex),
      kNegativePreIndex},
     {{al, r9, r1, minus, r6, LSL, 12, PreIndex},
      "al r9 r1 minus r6 LSL 12 PreIndex",
      "NegativePreIndex_al_r9_r1_minus_r6_LSL_12_PreIndex",
      ARRAY_SIZE(kNegativePreIndex),
      kNegativePreIndex},
     {{al, r7, r4, minus, r0, LSL, 14, PreIndex},
      "al r7 r4 minus r0 LSL 14 PreIndex",
      "NegativePreIndex_al_r7_r4_minus_r0_LSL_14_PreIndex",
      ARRAY_SIZE(kNegativePreIndex),
      kNegativePreIndex},
     {{al, r10, r11, minus, r9, ROR, 31, PreIndex},
      "al r10 r11 minus r9 ROR 31 PreIndex",
      "NegativePreIndex_al_r10_r11_minus_r9_ROR_31_PreIndex",
      ARRAY_SIZE(kNegativePreIndex),
      kNegativePreIndex},
     {{al, r9, r1, minus, r14, LSL, 7, PreIndex},
      "al r9 r1 minus r14 LSL 7 PreIndex",
      "NegativePreIndex_al_r9_r1_minus_r14_LSL_7_PreIndex",
      ARRAY_SIZE(kNegativePreIndex),
      kNegativePreIndex},
     {{al, r9, r5, minus, r11, ROR, 1, PreIndex},
      "al r9 r5 minus r11 ROR 1 PreIndex",
      "NegativePreIndex_al_r9_r5_minus_r11_ROR_1_PreIndex",
      ARRAY_SIZE(kNegativePreIndex),
      kNegativePreIndex},
     {{al, r1, r14, minus, r11, LSL, 14, PreIndex},
      "al r1 r14 minus r11 LSL 14 PreIndex",
      "NegativePreIndex_al_r1_r14_minus_r11_LSL_14_PreIndex",
      ARRAY_SIZE(kNegativePreIndex),
      kNegativePreIndex},
     {{al, r10, r12, minus, r8, LSL, 2, PreIndex},
      "al r10 r12 minus r8 LSL 2 PreIndex",
      "NegativePreIndex_al_r10_r12_minus_r8_LSL_2_PreIndex",
      ARRAY_SIZE(kNegativePreIndex),
      kNegativePreIndex},
     {{al, r5, r8, minus, r3, ROR, 4, PreIndex},
      "al r5 r8 minus r3 ROR 4 PreIndex",
      "NegativePreIndex_al_r5_r8_minus_r3_ROR_4_PreIndex",
      ARRAY_SIZE(kNegativePreIndex),
      kNegativePreIndex},
     {{al, r3, r0, minus, r1, ROR, 20, PreIndex},
      "al r3 r0 minus r1 ROR 20 PreIndex",
      "NegativePreIndex_al_r3_r0_minus_r1_ROR_20_PreIndex",
      ARRAY_SIZE(kNegativePreIndex),
      kNegativePreIndex},
     {{al, r5, r2, minus, r11, ROR, 5, PreIndex},
      "al r5 r2 minus r11 ROR 5 PreIndex",
      "NegativePreIndex_al_r5_r2_minus_r11_ROR_5_PreIndex",
      ARRAY_SIZE(kNegativePreIndex),
      kNegativePreIndex},
     {{al, r3, r7, minus, r9, LSL, 14, PreIndex},
      "al r3 r7 minus r9 LSL 14 PreIndex",
      "NegativePreIndex_al_r3_r7_minus_r9_LSL_14_PreIndex",
      ARRAY_SIZE(kNegativePreIndex),
      kNegativePreIndex},
     {{al, r3, r0, minus, r5, ROR, 20, PreIndex},
      "al r3 r0 minus r5 ROR 20 PreIndex",
      "NegativePreIndex_al_r3_r0_minus_r5_ROR_20_PreIndex",
      ARRAY_SIZE(kNegativePreIndex),
      kNegativePreIndex},
     {{al, r2, r8, minus, r5, ROR, 17, PreIndex},
      "al r2 r8 minus r5 ROR 17 PreIndex",
      "NegativePreIndex_al_r2_r8_minus_r5_ROR_17_PreIndex",
      ARRAY_SIZE(kNegativePreIndex),
      kNegativePreIndex},
     {{al, r1, r2, minus, r14, ROR, 2, PreIndex},
      "al r1 r2 minus r14 ROR 2 PreIndex",
      "NegativePreIndex_al_r1_r2_minus_r14_ROR_2_PreIndex",
      ARRAY_SIZE(kNegativePreIndex),
      kNegativePreIndex},
     {{al, r8, r4, minus, r2, ROR, 10, PreIndex},
      "al r8 r4 minus r2 ROR 10 PreIndex",
      "NegativePreIndex_al_r8_r4_minus_r2_ROR_10_PreIndex",
      ARRAY_SIZE(kNegativePreIndex),
      kNegativePreIndex},
     {{al, r0, r12, minus, r6, LSL, 28, PreIndex},
      "al r0 r12 minus r6 LSL 28 PreIndex",
      "NegativePreIndex_al_r0_r12_minus_r6_LSL_28_PreIndex",
      ARRAY_SIZE(kNegativePreIndex),
      kNegativePreIndex},
     {{al, r7, r4, minus, r12, LSL, 22, PreIndex},
      "al r7 r4 minus r12 LSL 22 PreIndex",
      "NegativePreIndex_al_r7_r4_minus_r12_LSL_22_PreIndex",
      ARRAY_SIZE(kNegativePreIndex),
      kNegativePreIndex},
     {{al, r3, r6, minus, r5, ROR, 7, PreIndex},
      "al r3 r6 minus r5 ROR 7 PreIndex",
      "NegativePreIndex_al_r3_r6_minus_r5_ROR_7_PreIndex",
      ARRAY_SIZE(kNegativePreIndex),
      kNegativePreIndex},
     {{al, r6, r14, minus, r5, ROR, 28, PreIndex},
      "al r6 r14 minus r5 ROR 28 PreIndex",
      "NegativePreIndex_al_r6_r14_minus_r5_ROR_28_PreIndex",
      ARRAY_SIZE(kNegativePreIndex),
      kNegativePreIndex},
     {{al, r4, r2, minus, r8, ROR, 5, PreIndex},
      "al r4 r2 minus r8 ROR 5 PreIndex",
      "NegativePreIndex_al_r4_r2_minus_r8_ROR_5_PreIndex",
      ARRAY_SIZE(kNegativePreIndex),
      kNegativePreIndex},
     {{al, r8, r9, minus, r3, ROR, 7, PreIndex},
      "al r8 r9 minus r3 ROR 7 PreIndex",
      "NegativePreIndex_al_r8_r9_minus_r3_ROR_7_PreIndex",
      ARRAY_SIZE(kNegativePreIndex),
      kNegativePreIndex},
     {{al, r8, r14, minus, r11, LSL, 11, PreIndex},
      "al r8 r14 minus r11 LSL 11 PreIndex",
      "NegativePreIndex_al_r8_r14_minus_r11_LSL_11_PreIndex",
      ARRAY_SIZE(kNegativePreIndex),
      kNegativePreIndex},
     {{al, r7, r6, minus, r4, LSL, 28, PreIndex},
      "al r7 r6 minus r4 LSL 28 PreIndex",
      "NegativePreIndex_al_r7_r6_minus_r4_LSL_28_PreIndex",
      ARRAY_SIZE(kNegativePreIndex),
      kNegativePreIndex},
     {{al, r12, r9, minus, r8, ROR, 28, PreIndex},
      "al r12 r9 minus r8 ROR 28 PreIndex",
      "NegativePreIndex_al_r12_r9_minus_r8_ROR_28_PreIndex",
      ARRAY_SIZE(kNegativePreIndex),
      kNegativePreIndex},
     {{al, r7, r14, minus, r10, ROR, 1, PreIndex},
      "al r7 r14 minus r10 ROR 1 PreIndex",
      "NegativePreIndex_al_r7_r14_minus_r10_ROR_1_PreIndex",
      ARRAY_SIZE(kNegativePreIndex),
      kNegativePreIndex},
     {{al, r2, r1, minus, r0, ROR, 11, PreIndex},
      "al r2 r1 minus r0 ROR 11 PreIndex",
      "NegativePreIndex_al_r2_r1_minus_r0_ROR_11_PreIndex",
      ARRAY_SIZE(kNegativePreIndex),
      kNegativePreIndex},
     {{al, r3, r9, minus, r6, ROR, 13, PreIndex},
      "al r3 r9 minus r6 ROR 13 PreIndex",
      "NegativePreIndex_al_r3_r9_minus_r6_ROR_13_PreIndex",
      ARRAY_SIZE(kNegativePreIndex),
      kNegativePreIndex},
     {{al, r7, r11, minus, r3, ROR, 28, PreIndex},
      "al r7 r11 minus r3 ROR 28 PreIndex",
      "NegativePreIndex_al_r7_r11_minus_r3_ROR_28_PreIndex",
      ARRAY_SIZE(kNegativePreIndex),
      kNegativePreIndex},
     {{al, r12, r4, minus, r3, LSL, 17, PreIndex},
      "al r12 r4 minus r3 LSL 17 PreIndex",
      "NegativePreIndex_al_r12_r4_minus_r3_LSL_17_PreIndex",
      ARRAY_SIZE(kNegativePreIndex),
      kNegativePreIndex},
     {{al, r12, r3, minus, r5, LSL, 4, PreIndex},
      "al r12 r3 minus r5 LSL 4 PreIndex",
      "NegativePreIndex_al_r12_r3_minus_r5_LSL_4_PreIndex",
      ARRAY_SIZE(kNegativePreIndex),
      kNegativePreIndex},
     {{al, r9, r1, minus, r7, LSL, 19, PreIndex},
      "al r9 r1 minus r7 LSL 19 PreIndex",
      "NegativePreIndex_al_r9_r1_minus_r7_LSL_19_PreIndex",
      ARRAY_SIZE(kNegativePreIndex),
      kNegativePreIndex},
     {{al, r2, r11, minus, r7, ROR, 5, PreIndex},
      "al r2 r11 minus r7 ROR 5 PreIndex",
      "NegativePreIndex_al_r2_r11_minus_r7_ROR_5_PreIndex",
      ARRAY_SIZE(kNegativePreIndex),
      kNegativePreIndex},
     {{al, r5, r9, minus, r6, LSL, 11, PreIndex},
      "al r5 r9 minus r6 LSL 11 PreIndex",
      "NegativePreIndex_al_r5_r9_minus_r6_LSL_11_PreIndex",
      ARRAY_SIZE(kNegativePreIndex),
      kNegativePreIndex},
     {{al, r3, r7, minus, r2, LSL, 12, PreIndex},
      "al r3 r7 minus r2 LSL 12 PreIndex",
      "NegativePreIndex_al_r3_r7_minus_r2_LSL_12_PreIndex",
      ARRAY_SIZE(kNegativePreIndex),
      kNegativePreIndex},
     {{al, r4, r8, minus, r0, LSL, 3, PreIndex},
      "al r4 r8 minus r0 LSL 3 PreIndex",
      "NegativePreIndex_al_r4_r8_minus_r0_LSL_3_PreIndex",
      ARRAY_SIZE(kNegativePreIndex),
      kNegativePreIndex},
     {{al, r8, r10, minus, r5, ROR, 8, PreIndex},
      "al r8 r10 minus r5 ROR 8 PreIndex",
      "NegativePreIndex_al_r8_r10_minus_r5_ROR_8_PreIndex",
      ARRAY_SIZE(kNegativePreIndex),
      kNegativePreIndex},
     {{al, r11, r14, minus, r0, LSL, 17, PreIndex},
      "al r11 r14 minus r0 LSL 17 PreIndex",
      "NegativePreIndex_al_r11_r14_minus_r0_LSL_17_PreIndex",
      ARRAY_SIZE(kNegativePreIndex),
      kNegativePreIndex},
     {{al, r7, r0, minus, r3, ROR, 10, PreIndex},
      "al r7 r0 minus r3 ROR 10 PreIndex",
      "NegativePreIndex_al_r7_r0_minus_r3_ROR_10_PreIndex",
      ARRAY_SIZE(kNegativePreIndex),
      kNegativePreIndex},
     {{al, r4, r12, minus, r1, LSL, 20, PreIndex},
      "al r4 r12 minus r1 LSL 20 PreIndex",
      "NegativePreIndex_al_r4_r12_minus_r1_LSL_20_PreIndex",
      ARRAY_SIZE(kNegativePreIndex),
      kNegativePreIndex},
     {{al, r3, r2, minus, r4, LSL, 14, PreIndex},
      "al r3 r2 minus r4 LSL 14 PreIndex",
      "NegativePreIndex_al_r3_r2_minus_r4_LSL_14_PreIndex",
      ARRAY_SIZE(kNegativePreIndex),
      kNegativePreIndex},
     {{al, r4, r6, minus, r11, LSL, 24, PreIndex},
      "al r4 r6 minus r11 LSL 24 PreIndex",
      "NegativePreIndex_al_r4_r6_minus_r11_LSL_24_PreIndex",
      ARRAY_SIZE(kNegativePreIndex),
      kNegativePreIndex},
     {{al, r3, r6, minus, r10, LSL, 8, PreIndex},
      "al r3 r6 minus r10 LSL 8 PreIndex",
      "NegativePreIndex_al_r3_r6_minus_r10_LSL_8_PreIndex",
      ARRAY_SIZE(kNegativePreIndex),
      kNegativePreIndex},
     {{al, r12, r3, minus, r9, LSL, 7, PreIndex},
      "al r12 r3 minus r9 LSL 7 PreIndex",
      "NegativePreIndex_al_r12_r3_minus_r9_LSL_7_PreIndex",
      ARRAY_SIZE(kNegativePreIndex),
      kNegativePreIndex},
     {{al, r2, r1, minus, r14, ROR, 17, PreIndex},
      "al r2 r1 minus r14 ROR 17 PreIndex",
      "NegativePreIndex_al_r2_r1_minus_r14_ROR_17_PreIndex",
      ARRAY_SIZE(kNegativePreIndex),
      kNegativePreIndex},
     {{al, r12, r10, minus, r6, ROR, 5, PreIndex},
      "al r12 r10 minus r6 ROR 5 PreIndex",
      "NegativePreIndex_al_r12_r10_minus_r6_ROR_5_PreIndex",
      ARRAY_SIZE(kNegativePreIndex),
      kNegativePreIndex},
     {{al, r7, r1, minus, r5, ROR, 20, PreIndex},
      "al r7 r1 minus r5 ROR 20 PreIndex",
      "NegativePreIndex_al_r7_r1_minus_r5_ROR_20_PreIndex",
      ARRAY_SIZE(kNegativePreIndex),
      kNegativePreIndex}};

// We record all inputs to the instructions as outputs. This way, we also check
// that what shouldn't change didn't change.
struct TestResult {
  size_t output_size;
  const Inputs* outputs;
};

// These headers each contain an array of `TestResult` with the reference output
// values. The reference arrays are names `kReference{mnemonic}`.
#include "aarch32/traces/simulator-cond-rd-memop-rs-shift-amount-1to31-ldr-a32.h"
#include "aarch32/traces/simulator-cond-rd-memop-rs-shift-amount-1to31-ldrb-a32.h"
#include "aarch32/traces/simulator-cond-rd-memop-rs-shift-amount-1to31-str-a32.h"
#include "aarch32/traces/simulator-cond-rd-memop-rs-shift-amount-1to31-strb-a32.h"


// The maximum number of errors to report in detail for each test.
const unsigned kErrorReportLimit = 8;

typedef void (MacroAssembler::*Fn)(Condition cond,
                                   Register rd,
                                   const MemOperand& memop);

void TestHelper(Fn instruction,
                const char* mnemonic,
                const TestResult reference[]) {
  SETUP();
  masm.UseA32();
  START();

  // Data to compare to `reference`.
  TestResult* results[ARRAY_SIZE(kTests)];

  // Test cases for memory bound instructions may allocate a buffer and save its
  // address in this array.
  byte* scratch_memory_buffers[ARRAY_SIZE(kTests)];

  // Generate a loop for each element in `kTests`. Each loop tests one specific
  // instruction.
  for (unsigned i = 0; i < ARRAY_SIZE(kTests); i++) {
    // Allocate results on the heap for this test.
    results[i] = new TestResult;
    results[i]->outputs = new Inputs[kTests[i].input_size];
    results[i]->output_size = kTests[i].input_size;

    size_t input_stride = sizeof(kTests[i].inputs[0]) * kTests[i].input_size;
    VIXL_ASSERT(IsUint32(input_stride));

    scratch_memory_buffers[i] = NULL;

    Label loop;
    UseScratchRegisterScope scratch_registers(&masm);
    // Include all registers from r0 ro r12.
    scratch_registers.Include(RegisterList(0x1fff));

    // Values to pass to the macro-assembler.
    Condition cond = kTests[i].operands.cond;
    Register rd = kTests[i].operands.rd;
    Register rn = kTests[i].operands.rn;
    Sign sign = kTests[i].operands.sign;
    Register rm = kTests[i].operands.rm;
    ShiftType shift = kTests[i].operands.shift;
    uint32_t amount = kTests[i].operands.amount;
    AddrMode addr_mode = kTests[i].operands.addr_mode;
    MemOperand memop(rn, sign, rm, shift, amount, addr_mode);
    scratch_registers.Exclude(rd);
    scratch_registers.Exclude(rn);
    scratch_registers.Exclude(rm);

    // Allocate reserved registers for our own use.
    Register input_ptr = scratch_registers.Acquire();
    Register input_end = scratch_registers.Acquire();
    Register result_ptr = scratch_registers.Acquire();

    // Initialize `input_ptr` to the first element and `input_end` the address
    // after the array.
    __ Mov(input_ptr, Operand::From(kTests[i].inputs));
    __ Add(input_end, input_ptr, static_cast<uint32_t>(input_stride));
    __ Mov(result_ptr, Operand::From(results[i]->outputs));
    __ Bind(&loop);

    {
      UseScratchRegisterScope temp_registers(&masm);
      Register nzcv_bits = temp_registers.Acquire();
      Register saved_q_bit = temp_registers.Acquire();
      // Save the `Q` bit flag.
      __ Mrs(saved_q_bit, APSR);
      __ And(saved_q_bit, saved_q_bit, QFlag);
      // Set the `NZCV` and `Q` flags together.
      __ Ldr(nzcv_bits, MemOperand(input_ptr, offsetof(Inputs, apsr)));
      __ Orr(nzcv_bits, nzcv_bits, saved_q_bit);
      __ Msr(APSR_nzcvq, nzcv_bits);
    }
    __ Ldr(rd, MemOperand(input_ptr, offsetof(Inputs, rd)));
    __ Ldr(rm, MemOperand(input_ptr, offsetof(Inputs, rm)));
    // Allocate 4 bytes for the instruction to work with.
    scratch_memory_buffers[i] = new byte[4];
    {
      UseScratchRegisterScope temp_registers(&masm);

      Register memop_tmp = temp_registers.Acquire();
      Register base_register = memop.GetBaseRegister();

      // Write the expected data into the scratch buffer.
      __ Mov(base_register, Operand::From(scratch_memory_buffers[i]));
      __ Ldr(memop_tmp, MemOperand(input_ptr, offsetof(Inputs, memop) + 4));
      __ Str(memop_tmp, MemOperand(base_register));

      // Compute the address to put into the base register so that the
      // `MemOperand` points to the right location.
      // TODO: Support more kinds of `MemOperand`.
      if (!memop.IsPostIndex()) {
        if (memop.IsImmediate()) {
          if (memop.GetSign().IsPlus()) {
            __ Mov(memop_tmp, memop.GetOffsetImmediate());
            __ Sub(base_register, base_register, memop_tmp);
          } else {
            __ Mov(memop_tmp, -memop.GetOffsetImmediate());
            __ Add(base_register, base_register, memop_tmp);
          }
        } else if (memop.IsShiftedRegister()) {
          __ Mov(memop_tmp,
                 Operand(memop.GetOffsetRegister(),
                         memop.GetShift(),
                         memop.GetShiftAmount()));
          if (memop.GetSign().IsPlus()) {
            __ Sub(base_register, base_register, memop_tmp);
          } else {
            __ Add(base_register, base_register, memop_tmp);
          }
        }
      }
    }


    (masm.*instruction)(cond, rd, memop);

    {
      UseScratchRegisterScope temp_registers(&masm);
      Register nzcv_bits = temp_registers.Acquire();
      __ Mrs(nzcv_bits, APSR);
      // Only record the NZCV bits.
      __ And(nzcv_bits, nzcv_bits, NZCVFlag);
      __ Str(nzcv_bits, MemOperand(result_ptr, offsetof(Inputs, apsr)));
    }
    __ Str(rd, MemOperand(result_ptr, offsetof(Inputs, rd)));
    __ Str(rm, MemOperand(result_ptr, offsetof(Inputs, rm)));
    {
      UseScratchRegisterScope temp_registers(&masm);
      Register memop_tmp = temp_registers.Acquire();
      Register base_register = memop.GetBaseRegister();

      // Compute the address of the scratch buffer by from the base register. If
      // the instruction has updated the base register, we will be able to
      // record it.
      if (!memop.IsPostIndex()) {
        if (memop.IsImmediate()) {
          if (memop.GetSign().IsPlus()) {
            __ Mov(memop_tmp, memop.GetOffsetImmediate());
            __ Add(base_register, base_register, memop_tmp);
          } else {
            __ Mov(memop_tmp, -memop.GetOffsetImmediate());
            __ Sub(base_register, base_register, memop_tmp);
          }
        } else if (memop.IsShiftedRegister()) {
          __ Mov(memop_tmp,
                 Operand(memop.GetOffsetRegister(),
                         memop.GetShift(),
                         memop.GetShiftAmount()));
          if (memop.GetSign().IsPlus()) {
            __ Add(base_register, base_register, memop_tmp);
          } else {
            __ Sub(base_register, base_register, memop_tmp);
          }
        }
      }

      // Record the value of the base register, as an offset from the scratch
      // buffer's address.
      __ Mov(memop_tmp, Operand::From(scratch_memory_buffers[i]));
      __ Sub(base_register, base_register, memop_tmp);
      __ Str(base_register, MemOperand(result_ptr, offsetof(Inputs, memop)));

      // Record the 32 bit word from memory.
      __ Ldr(memop_tmp, MemOperand(memop_tmp));
      __ Str(memop_tmp, MemOperand(result_ptr, offsetof(Inputs, memop) + 4));
    }


    // Advance the result pointer.
    __ Add(result_ptr, result_ptr, Operand::From(sizeof(kTests[i].inputs[0])));
    // Loop back until `input_ptr` is lower than `input_base`.
    __ Add(input_ptr, input_ptr, Operand::From(sizeof(kTests[i].inputs[0])));
    __ Cmp(input_ptr, input_end);
    __ B(ne, &loop);
  }

  END();

  RUN();

  if (Test::generate_test_trace()) {
    // Print the results.
    for (size_t i = 0; i < ARRAY_SIZE(kTests); i++) {
      printf("const Inputs kOutputs_%s_%s[] = {\n",
             mnemonic,
             kTests[i].identifier);
      for (size_t j = 0; j < results[i]->output_size; j++) {
        printf("  { ");
        printf("0x%08" PRIx32, results[i]->outputs[j].apsr);
        printf(", ");
        printf("0x%08" PRIx32, results[i]->outputs[j].rd);
        printf(", ");
        printf("0x%08" PRIx32, results[i]->outputs[j].rm);
        printf(", ");
        printf("{0x%08" PRIx32 ", 0x%08" PRIx32 "}",
               results[i]->outputs[j].memop[0],
               results[i]->outputs[j].memop[1]);
        printf(" },\n");
      }
      printf("};\n");
    }
    printf("const TestResult kReference%s[] = {\n", mnemonic);
    for (size_t i = 0; i < ARRAY_SIZE(kTests); i++) {
      printf("  {\n");
      printf("    ARRAY_SIZE(kOutputs_%s_%s),\n",
             mnemonic,
             kTests[i].identifier);
      printf("    kOutputs_%s_%s,\n", mnemonic, kTests[i].identifier);
      printf("  },\n");
    }
    printf("};\n");
  } else if (kCheckSimulatorTestResults) {
    // Check the results.
    unsigned total_error_count = 0;
    for (size_t i = 0; i < ARRAY_SIZE(kTests); i++) {
      bool instruction_has_errors = false;
      for (size_t j = 0; j < kTests[i].input_size; j++) {
        uint32_t apsr = results[i]->outputs[j].apsr;
        uint32_t rd = results[i]->outputs[j].rd;
        uint32_t rm = results[i]->outputs[j].rm;
        uint32_t memop[2] = {results[i]->outputs[j].memop[0],
                             results[i]->outputs[j].memop[1]};

        uint32_t apsr_input = kTests[i].inputs[j].apsr;
        uint32_t rd_input = kTests[i].inputs[j].rd;
        uint32_t rm_input = kTests[i].inputs[j].rm;
        uint32_t memop_input[2] = {kTests[i].inputs[j].memop[0],
                                   kTests[i].inputs[j].memop[1]};

        uint32_t apsr_ref = reference[i].outputs[j].apsr;
        uint32_t rd_ref = reference[i].outputs[j].rd;
        uint32_t rm_ref = reference[i].outputs[j].rm;
        uint32_t memop_ref[2] = {results[i]->outputs[j].memop[0],
                                 results[i]->outputs[j].memop[1]};


        if (((apsr != apsr_ref) || (rd != rd_ref) || (rm != rm_ref) ||
             ((memop[0] != memop_ref[0]) && (memop[1] != memop_ref[1]))) &&
            (++total_error_count <= kErrorReportLimit)) {
          // Print the instruction once even if it triggered multiple failures.
          if (!instruction_has_errors) {
            printf("Error(s) when testing \"%s %s\":\n",
                   mnemonic,
                   kTests[i].operands_description);
            instruction_has_errors = true;
          }
          // Print subsequent errors.
          printf("  Input:    ");
          printf("0x%08" PRIx32, apsr_input);
          printf(", ");
          printf("0x%08" PRIx32, rd_input);
          printf(", ");
          printf("0x%08" PRIx32, rm_input);
          printf(", ");
          printf("{0x%08" PRIx32 ", 0x%08" PRIx32 "}",
                 memop_input[0],
                 memop_input[1]);
          printf("\n");
          printf("  Expected: ");
          printf("0x%08" PRIx32, apsr_ref);
          printf(", ");
          printf("0x%08" PRIx32, rd_ref);
          printf(", ");
          printf("0x%08" PRIx32, rm_ref);
          printf(", ");
          printf("{0x%08" PRIx32 ", 0x%08" PRIx32 "}",
                 memop_ref[0],
                 memop_ref[1]);
          printf("\n");
          printf("  Found:    ");
          printf("0x%08" PRIx32, apsr);
          printf(", ");
          printf("0x%08" PRIx32, rd);
          printf(", ");
          printf("0x%08" PRIx32, rm);
          printf(", ");
          printf("{0x%08" PRIx32 ", 0x%08" PRIx32 "}", memop[0], memop[1]);
          printf("\n\n");
        }
      }
    }

    if (total_error_count > kErrorReportLimit) {
      printf("%u other errors follow.\n",
             total_error_count - kErrorReportLimit);
    }
    VIXL_CHECK(total_error_count == 0);
  } else {
    VIXL_WARNING("Assembled the code, but did not run anything.\n");
  }

  for (size_t i = 0; i < ARRAY_SIZE(kTests); i++) {
    delete[] results[i]->outputs;
    delete results[i];
    delete[] scratch_memory_buffers[i];
  }
}

// Instantiate tests for each instruction in the list.
// TODO: Remove this limitation by having a sandboxing mechanism.
#if defined(VIXL_HOST_POINTER_32)
#define TEST(mnemonic)                                                      \
  void Test_##mnemonic() {                                                  \
    TestHelper(&MacroAssembler::mnemonic, #mnemonic, kReference##mnemonic); \
  }                                                                         \
  Test test_##mnemonic(                                                     \
      "AARCH32_SIMULATOR_COND_RD_MEMOP_RS_SHIFT_AMOUNT_1TO31_" #mnemonic    \
      "_A32",                                                               \
      &Test_##mnemonic);
#else
#define TEST(mnemonic)                                                   \
  void Test_##mnemonic() {                                               \
    VIXL_WARNING("This test can only run on a 32-bit host.\n");          \
    USE(TestHelper);                                                     \
  }                                                                      \
  Test test_##mnemonic(                                                  \
      "AARCH32_SIMULATOR_COND_RD_MEMOP_RS_SHIFT_AMOUNT_1TO31_" #mnemonic \
      "_A32",                                                            \
      &Test_##mnemonic);
#endif

FOREACH_INSTRUCTION(TEST)
#undef TEST

}  // namespace
#endif

}  // namespace aarch32
}  // namespace vixl
